/** *********************************************************************
 * Copyright (C) 2003 Catalyst IT                                       *
 *                                                                      *
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to:                           *
 *   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    *
 *   Boston, MA  02111-1307  USA                                        *
 ************************************************************************/
/*
 * SocketTest.java
 *
 * Created on 29 October 2002, 16:03
 */

package nz.net.catalyst.lucene.testclient;


/**
 *
 * @author  hamish
 */
public class StressControl {
    
    public static long startTime       = 0L;
    
    public static int  timeToRun        = 5; //in seconds
    public static int  requestsPerSecond = 50;
    public static int  thread_count     = (requestsPerSecond * timeToRun);
    public static int  errorCount      = 0;
    
    public static int threadCountDown  = thread_count;
    public static long threadTime      = 0L;
    
    public static String [] queries = {
            // ~0 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: (Name:pepper  ^1) OR (Teaser:pepper) OR (Details:pepper) AND (Cancelled:N)\nLimit: 5\nEND",
            // ~ 100 results
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",  
            // ~ 100 results (WITH SORT)
            //  "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-15\nRange-To: 2002-02-02\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nSort: Name\nLimit: 5\nEND",  
            // ~ 1000 results  
            "QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nLimit: 5\nEND",
            // ~ 1000 results  (WITH SORT)
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) AND (Teaser:free) OR (Details:(pharoah AND egypt AND river))) AND Cancelled:N\nSort: Name\nLimit: 5\nEND",
            // ~ 10000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-06-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // ~ 20000 results
            //"QUERY\nApplication: sos\nRange-Field: DisplayStartDate\nRange-From: 2002-01-10\nRange-To: 2002-10-10\nQuery: ((Name:cat  ^1) OR (Teaser:mother) OR (Details:(pharoah AND egypt AND river AND she AND vine))) AND (Cancelled:N) \nLimit: 5\nEND",
            // all results
            //"QUERY\nApplication: sos\nQuery: \nQuery: Domain:sos\nLimit: 5\nEND"
    };
    
    
    /** Creates a new instance of SocketTest */
    public StressControl() {
    }
    
    
    /**
     * @param args the command line arguments
     */
    public static void main(String[] args) throws java.lang.Exception {
        StressControl sc = new StressControl();
        sc.go();
    }
        
    public void go() {
        startTime = System.currentTimeMillis();
        
        java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat("HH:mm:ss S");
        java.util.Calendar c = new java.util.GregorianCalendar();
        System.out.println("It has begun: " + sdf.format(c.getTime()));

         java.util.Random r = new java.util.Random();
         
         
        Thread[] threads = new Thread[thread_count];
        
        long tBefore = System.currentTimeMillis();
        
        for (int i = 0; i < thread_count; i++) {

            int query_number = r.nextInt(queries.length);
            
            //java.util.Date d = new java.util.Date();
            
            //Thread t = new Thread(new StressClient(("T"+i), query_number, r.nextInt(5000)));
            Thread t = new Thread(new StressClient(("T"+i), query_number, 0));
            //t.setDaemon(true);
            
            threads[i] = t;
        }
        
        long tCreated = System.currentTimeMillis();

        
        synchronized (this) {
                        try {
            for (int i = 0; i < thread_count; i++) {
                //threads[i].start();
                //long delay = (long) (r.nextInt(100)*2);
                long delay = 1000L / requestsPerSecond;
                this.wait(delay);
                threads[i].start();
                //threads[i].sleep(delay);
            }
                        } catch (Exception e) {
                            //do nothing
                        }
        }
        
        long tAfter = System.currentTimeMillis();
        
        System.out.println(" TIme taken to create threads: " + (tCreated - tBefore));
        System.out.println(" TIme taken to start threads:  " + (tAfter - tCreated));
    }

    public static void printStats() {
            System.out.println("============= STATISTICS ==============");
            System.out.println(" Time to run test over: " + timeToRun + "seconds.");
            System.out.println(" Requests per second:   " + requestsPerSecond);
            System.out.println(" Total Threads Spawned: " + thread_count);
            System.out.println(" ");
            System.out.println("Total Time:             " + (System.currentTimeMillis() - StressControl.startTime));
            System.out.println("Average time:           " + (StressControl.threadTime / StressControl.thread_count));
            System.out.println("Throughput:             " + (double) ((StressControl.thread_count * 1000d) / (System.currentTimeMillis() - StressControl.startTime)) + " (requests per second)");
            System.out.println("Error Count:             " + errorCount);
            System.out.println("============= STATISTICS ==============");
    }

    
}
