/*
 * Decompiled with CFR 0.152.
 */
package com.holub.asynch;

import java.util.LinkedList;
import java.util.NoSuchElementException;

public class Blocking_queue {
    private LinkedList elements = new LinkedList();
    private boolean closed = false;
    private boolean reject_enqueue_requests = false;
    private int waiting_threads = 0;

    public final synchronized void enqueue(Object new_element) throws Closed {
        if (this.closed || this.reject_enqueue_requests) {
            throw new Closed();
        }
        this.elements.addLast(new_element);
        this.notify();
    }

    public final synchronized void enqueue_final_item(Object new_element) throws Closed {
        this.enqueue(new_element);
        this.reject_enqueue_requests = true;
    }

    public final synchronized Object dequeue() throws InterruptedException, Closed {
        if (this.closed) {
            throw new Closed();
        }
        try {
            if (this.elements.size() <= 0) {
                ++this.waiting_threads;
                while (this.elements.size() <= 0) {
                    this.wait();
                    if (!this.closed) continue;
                    --this.waiting_threads;
                    throw new Closed();
                }
                --this.waiting_threads;
            }
            Object head = this.elements.removeFirst();
            if (this.elements.size() == 0 && this.reject_enqueue_requests) {
                this.close();
            }
            return head;
        }
        catch (NoSuchElementException e) {
            throw new Error("Internal error (com.holub.asynch.Blocking_queue)");
        }
    }

    public final boolean is_empty() {
        return this.elements.size() <= 0;
    }

    public final int waiting_threads() {
        return this.waiting_threads;
    }

    public synchronized void close() {
        this.closed = true;
        this.elements = null;
        this.notifyAll();
    }

    public class Closed
    extends RuntimeException {
        private Closed() {
            super("Tried to access closed Blocking_queue");
        }
    }
}

