/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.testclient;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;

public class SocketTestXML {
    public static void main(String[] args) throws Exception {
        String serverOutput;
        long tStart = System.currentTimeMillis();
        long tOpenedConnection = 9999L;
        long tAfterExecuting = 9999L;
        long tClosedConnection = 9999L;
        Socket echoSocket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            echoSocket = new Socket("localhost", 22222);
            out = new PrintWriter(echoSocket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(echoSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            System.err.println("Unknown Host Exception. Cannot resolve host.");
            System.exit(1);
        }
        catch (IOException e) {
            System.err.println("Couldn't get I/O for the connection.");
            System.exit(1);
        }
        tOpenedConnection = System.currentTimeMillis();
        String index = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneRequest type=\"INDEX\"><Application>sos</Application><Domain>sos2</Domain><Id>zz12</Id><Name>cat</Name><Details>none</Details><Teaser>Buy Me!</Teaser><Location>10</Location><Category>10</Category><DisplayStartDate>2002-12-10</DisplayStartDate><SaleStartDate>2002-12-10</SaleStartDate><EndDate>2002-12-25</EndDate><Cancelled>N</Cancelled></LuceneRequest>\n\n";
        String query = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneRequest type=\"QUERY\"><Application>sos</Application><Query>Name:cat\n</Query><Limit>3</Limit></LuceneRequest>";
        String optimize = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneUtilityRequest><Serial>123abc</Serial><Utility>OPTIMIZE</Utility><Application>newsquest</Application></LuceneUtilityRequest>";
        String backup = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneUtilityRequest><Serial>123abc</Serial><Utility>BACKUP</Utility><Application>nqst</Application><BackUpTarget>c:\\indexnew</BackUpTarget></LuceneUtilityRequest>";
        String experimental = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?><LuceneUtilityRequest><Serial>123abc</Serial><Utility>EXPERIMENTAL</Utility><Application>nqst</Application></LuceneUtilityRequest>";
        String old = "QUERY\nApplication:sos\nQuery: Name:cat\nLimit:0\nEND\n";
        String command = backup;
        System.out.println("About to send XML command to server...");
        System.out.println("===================================================");
        out.println(command);
        BufferedReader br = new BufferedReader(in);
        while ((serverOutput = br.readLine()) != null) {
            System.out.println("from server: " + serverOutput);
        }
        if (serverOutput != null) {
            System.out.println("from server: " + serverOutput);
        }
        tAfterExecuting = System.currentTimeMillis();
        out.close();
        br.close();
        in.close();
        echoSocket.close();
        tClosedConnection = System.currentTimeMillis();
        System.out.println("================= Time Statistics =================");
        System.out.println(" Opening Connection: " + (tOpenedConnection - tStart));
        System.out.println(" Executing:          " + (tAfterExecuting - tOpenedConnection));
        System.out.println(" Closing Connection: " + (tClosedConnection - tAfterExecuting));
        System.out.println("===================================================");
    }
}

