#!/bin/bash

# If HTMLArea doesn't exist then we export it from the public CVS
# for the package. If it does exist then we delete it first.
# NB: HTMLArea is a javascript wysiwyg editor which is used in Axyl
# to provide a user editing interface for user-managed content.

# CVS repository for HTMLArea..
HTMLAREA_CVSROOT=":pserver:anonymous@cvs.sourceforge.net:/cvsroot/itools-htmlarea"

# Axyl installation configuration..
CONF=/etc/axyl/axyl.conf
if [ ! -f $CONF ]
then
  echo "Axyl configuration file $CONF not found. Is Axyl installed?"
  exit 1
else
  . $CONF
fi

# Locate Axyl javascript libraries..
AXYL_JS=${AXYL_HOME}/lib/js
if [ ! -d $AXYL_JS ]
then
  echo "Axyl javascript directory not found at $AXYL_JS."
  echo "Check your Axyl installation."
  exit 1
else
  cd $AXYL_JS
fi

# CVS export it..
echo "exporting latest HTMLArea into Axyl from SourceForge.."
if [ -d htmlarea ]
then
  echo -n "a copy of htmlarea already exists - replace it? [Y] :"
  read ANS
  if [ "$ANS" != "y" -a $ANS != "Y" -a "$ANS" != "" ]
  then
    echo "cancelled."
    exit 0
  fi
  echo "removing existing copy first.."
  rm -rf htmlarea
fi
echo ""
echo "just hit the [ENTER] key for the CVS password.."
cvs -d $HTMLAREA_CVSROOT login
cvs -q -z3 -d $HTMLAREA_CVSROOT export -r HEAD -d htmlarea htmlarea
echo "the HEAD version of htmlarea was exported to $AXYL_JS"

# END