<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-calendar.php                                       */
/* Author:      Paul Waite                                              */
/* Description: An example of how the calendar class might be used.     */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("calendar-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Calendar", "main", $theme);

// -----------------------------------------------------------------------
// Common site-specific content..
include_once("site-webpage.php");

// Create the calendar object. This will automatically
// process any POSTs of calendar navigation etc.
$calendar = new Calendar();
$calendar->set_year_limits(1990, 2010);

// Create your own content, which uses the calendar settings
$s = "";
if ($calendar->is_valid()) {
  $Tcal = new table("calendar info");
  $Tcal->setpadding(4);
  //$Tcal->setstyle("border:solid 1px black");
  $Tcal->setclass("tablestyle_4");

  $Tcal->tr("axbglite");
  $Tcal->td("The calendar date:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->get_displaydate(NICE_DATE));
  $Tcal->td_alignment("", "top");

  $Tcal->tr("axbglite");
  $Tcal->td("Day of week:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->dayname);
  $Tcal->td_alignment("", "top");

  $Tcal->tr("axbgdark");
  $Tcal->td("Day:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->get_DDstr());
  $Tcal->td_alignment("", "top");

  $Tcal->tr("axbglite");
  $Tcal->td("Month:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->get_MMstr());
  $Tcal->td_alignment("", "top");

  $Tcal->tr("axbgdark");
  $Tcal->td("Year:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->get_YYstr());
  $Tcal->td_alignment("", "top");

  $Tcal->tr("axbglite");
  $Tcal->td("The DB-formatted date is:");
  $Tcal->td_alignment("", "top");
  $Tcal->td($calendar->get_DB_datetime());
  $Tcal->td_alignment("", "top");
  $s = $Tcal->render();
}
else {
  $s = "The calendar date is invalid.";
}
$MY_CONTENT = $s;

// -----------------------------------------------------------------------------------------------
// MAIN CONTENT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<table border="0" cellspacing="0" cellpadding="6" width="95%" align="center" style="padding-top:20px">
  <tr class="axhdg">
    <th class="axhdg" colspan="2">Example Usage of Axyl Calendar</td>
  </tr>
  <tr>
    <td valign="top"><!--MY_CONTENT--></td>
    <td valign="top"><!--CALENDAR--></td>
  </tr>
  <tr>
    <td>&nbsp;</td>
  </tr>
</table>
<?php
$RESPONSE->plugin_inline();

// -----------------------------------------------------------------------
// Plugins..
$RESPONSE->plugin("CALENDAR",   $calendar->render());
$RESPONSE->plugin("MY_CONTENT", $MY_CONTENT);

// -----------------------------------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>