--
-- AXYL Metadata Sub-system
-- MYSQL VARIANT
-- The data inserts below are the standard Axyl metadata definitions. These
-- include the basic elements and schema definitions for the Dublin Core,
-- AGLS, and NZGLS metadata sets.
--
-- Name: axyl_meta_data.sql
-- Created: 2004-09-06
--
insert into ax_sitepage (page_id,page_title,page_path,managed,enabled) values (30,'Metadata Core Elements','/axyl-meta-elements.php',0,1);
insert into ax_sitepage (page_id,page_title,page_path,managed,enabled) values (31,'Metadata Encoding Schemes','/axyl-encoding-schemes.php',0,1);
insert into ax_sitepage (page_id,page_title,page_path,managed,enabled) values (32,'Metadata Schema Definition','/axyl-metaschema.php',0,1);
insert into ax_sitepage (page_id,page_title,page_path,managed,enabled) values (33,'Site Metadata','/axyl-site-metadata.php',0,1);

-- METADATA PAGES SITEPAGE SECURITY
-- Metadata Core Elements
insert into ax_sitepage_group (page_id,group_id) values(30,1);
insert into ax_sitepage_group (page_id,group_id) values(30,3);
-- Metadata Encoding Schemes
insert into ax_sitepage_group (page_id,group_id) values(31,1);
insert into ax_sitepage_group (page_id,group_id) values(31,3);
-- Metadata Schema Definition
insert into ax_sitepage_group (page_id,group_id) values(32,1);
insert into ax_sitepage_group (page_id,group_id) values(32,3);
-- Site Metadata
insert into ax_sitepage_group (page_id,group_id) values(33,1);
insert into ax_sitepage_group (page_id,group_id) values(33,3);

-- METADATA MENU OPTIONS
insert into ax_menuoption (menu_id,menuoption_id,is_parent,parent_id,user_groups,user_type,menu_level,label,description,display_order,action,auth_code,active,width,height,sitepage,sitepage_parms)
values (1,30,1,10, 'Admin,Editor','',1,'METADATA','Metadata maintenance',30,'',0,1,100,20,'','');
insert into ax_menuoption (menu_id,menuoption_id,is_parent,parent_id,user_groups,user_type,menu_level,label,description,display_order,action,auth_code,active,width,height,sitepage,sitepage_parms)
values (1,31,0,30,'Admin,Editor','',2,'Core Elements','Maintain core metadata elements',1,'/axyl-meta-elements.php',0,1,120,20,'/axyl-meta-elements.php','');
insert into ax_menuoption (menu_id,menuoption_id,is_parent,parent_id,user_groups,user_type,menu_level,label,description,display_order,action,auth_code,active,width,height,sitepage,sitepage_parms)
values (1,32,0,30,'Admin,Editor','',2,'Encoding Schemes','Manage encoding schemes for metadata',2,'/axyl-encoding-schemes.php',0,1,140,20,'/axyl-encoding-schemes.php','');
insert into ax_menuoption (menu_id,menuoption_id,is_parent,parent_id,user_groups,user_type,menu_level,label,description,display_order,action,auth_code,active,width,height,sitepage,sitepage_parms)
values (1,33,0,30,'Admin,Editor','',2,'Metadata Schemas','Build and maintain metadata schemas',3,'/axyl-metaschema.php',0,1,140,20,'/axyl-metaschema.php','');
insert into ax_menuoption (menu_id,menuoption_id,is_parent,parent_id,user_groups,user_type,menu_level,label,description,display_order,action,auth_code,active,width,height,sitepage,sitepage_parms)
values (1,34,0,30,'Admin,Editor','',2,'Site Metadata','Maintain the metadata elements used on the website',4,'/axyl-site-metadata.php',0,1,120,20,'/axyl-site-metadata.php','');

-- ENSURE SEQUENCES
select setval('seq_menuoption_id', (select max(menuoption_id) from ax_menuoption));
select setval('seq_page_id', (select max(page_id) from ax_sitepage));

-- META DATA
INSERT INTO ax_meta_schema (schema_name, description, namespace, namespace_uri) VALUES ('AGLS', 'AGLS - Australian Government Locater Set', 'AGLS', '');
INSERT INTO ax_meta_schema (schema_name, description, namespace, namespace_uri) VALUES ('NZGLS', 'NZGLS - New Zealand Government Locater Set', 'NZGLS', 'http://www.e-government.govt.nz/docs/element-set-21/');
INSERT INTO ax_meta_schema (schema_name, description, namespace, namespace_uri) VALUES ('Dublin Core', 'DC - Dublin Core Metadata Element Set', 'DC', 'http://dublincore.org/2003/03/24/dces');

-- Name: ax_meta_element;
--
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Audience', 'A class of entity for whom the resource is intended or useful.', 1, 18, NULL, 'audience');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Contributor', 'An entity responsible for making contributions to the content of the resource.', 1, 1, NULL, 'contributor');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Coverage', 'The extent or scope of the content of the resource.', 1, 2, NULL, 'coverage');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Creator', 'An entity primarily responsible for making the content of the resource.', 1, 3, NULL, 'creator');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Date', 'A date of an event in the lifecycle of the resource.', 1, 4, NULL, 'date');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Description', 'An account of the content of the resource.', 1, 5, NULL, 'description');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Format', 'The physical or digital manifestation of the resource.', 1, 6, NULL, 'format');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Resource Identifier', 'An unambiguous reference to the resource within a given context.', 1, 7, NULL, 'identifier');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Language', 'A language of the intellectual content of the resource.', 1, 8, NULL, 'language');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Publisher', 'An entity responsible for making the resource available', 1, 9, NULL, 'publisher');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Relation', 'A reference to a related resource.', 1, 10, NULL, 'relation');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Rights Management', 'Information about rights held in and over the resource.', 1, 11, NULL, 'rights');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Source', 'A Reference to a resource from which the present resource is derived.', 1, 12, NULL, 'source');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Subject and Keywords', 'A topic of the content of the resource.', 1, 13, NULL, 'subject');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Title', 'A name given to the resource.', 1, 14, NULL, 'title');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Resource Type', 'The nature or genre of the content of the resource.', 1, 15, NULL, 'type');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Abstract', 'A summary of the content of the resource.', 1, 16, 5, 'abstract');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Alternative', 'Any form of the title used as a substitute or alternative to the formal title of the resource.', 1, 17, 14, 'alternative');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Available', 'Date (often a range) that the resource will become or did become available.', 1, 19, 4, 'available');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Category', 'The generic type of the resource being described.', 1, 48, 15, 'category');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Created', 'Date of creation of the resource.', 1, 20, 4, 'created');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Extent', 'The size or duration of the resource.', 1, 21, 6, 'extent');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Issued', 'Date of formal issuance (e.g., publication) of the resource.', 1, 22, 4, 'issued');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Mediator', 'A class of entity that mediates access to the resource and for whom the resource is intended or useful.', 1, 23, 18, 'mediator');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Medium', 'The material or physical carrier of the resource.', 1, 24, 6, 'medium');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Modified', 'Date on which the resource was changed.', 1, 25, 4, 'modified');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Spatial', 'Spatial characteristics of the intellectual content of the resource.', 1, 26, 2, 'spatial');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Table Of Contents', 'A list of subunits of the content of the resource.', 1, 27, 5, 'tableOfContents');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Temporal', 'Temporal characteristics of the intellectual content of the resource.', 1, 28, 2, 'temporal');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Valid', 'Date (often a range) of validity of a resource.', 1, 29, 4, 'valid');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Has Format', 'The described resource pre-existed the referenced resource, which is essentially the same intellectual content presented in another format.', 1, 30, 10, 'hasFormat');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Format Of', 'The described resource is the same intellectual content of the referenced resource, but presented in another format.', 1, 31, 10, 'isFormatOf');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Has Part', 'The described resource includes the referenced resource either physically or logically', 1, 32, 10, 'hasPart');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Part Of', 'The described resource is a physical or logical part of the referenced resource.', 1, 33, 10, 'isPartOf');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Has Version', 'The described resource has a version, edition, or adaptation, namely, the referenced resource.', 1, 34, 10, 'hasVersion');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Version Of', 'The described resource is a version, edition, or adaptation of the referenced resource. Changes in version imply substantive changes in content rather than differences in format.', 1, 35, 10, 'isVersionOf');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'References', 'The described resource references, cites, or otherwise points to the referenced resource.', 1, 36, 10, 'references');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Referenced By', 'The described resource is referenced, cited, or otherwise pointed to by the referenced resource.', 1, 37, 10, 'isReferencedBy');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Mandate', 'A specific warrant which requires the resource to be created or provided.', 1, 44, NULL, 'mandate');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Act', 'A reference to a specific Act which requires the creation or provision of the resource.', 1, 45, 44, 'act');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Replaces', 'The described resource supplants, displaces, or supersedes the referenced resource.', 1, 38, 10, 'replaces');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Replaced By', 'The described resource is supplanted, displaced, or superseded by the referenced resource.', 1, 39, 10, 'isReplacedBy');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Requires', 'The described resource requires the referenced resource to support its function, delivery, or coherence of content.', 1, 40, 10, 'requires');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Is Required By', 'The described resource is required by the referenced resource, either physically or logically.', 1, 41, 10, 'isRequiredBy');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('Dublin Core', 'Conforms To', 'A reference to an established standard to which the resource conforms.', 1, 42, 10, 'conformsTo');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Is Based On', 'The described resource is a performance, production, derivation, translation, or interpretation of the referenced resource.', 1, 57, 10, 'isBasedOn');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Is Basis For', 'The described resource pre-existed the referenced resource, which is a performance, production, derivation, translation or interpretation of the described resource.', 1, 58, 10, 'isBasisFor');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('NZGLS', 'Rules', 'The specific rule or bylaw which requires the creation or provision of the resource.', 1, 59, 44, 'rules');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Function', 'The business function of the organisation to which the resource relates.', 1, 43, NULL, 'function');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Regulation', 'A reference to a specific regulation which requires the creation or provision of the resource.', 1, 46, 44, 'regulation');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Case', 'A reference to a specific case which requires the creation or provision of the resource.', 1, 47, 44, 'case');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Aggregation Level', 'The level of aggregation of the resource being described.', 1, 49, 15, 'aggregationLevel');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Document Type', 'The form of the resource where Category = ''document''.', 1, 50, 15, 'documentType');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Service', 'The type of service being offered where Category = ''service''.', 1, 51, 15, 'service');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Jurisdiction', 'The name of the political/administrative entity covered by the content of the resource.', 1, 54, 2, 'jurisdiction');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Availability', 'How the resource can be obtained of contact information for obtaining the resource.', 1, 56, NULL, 'availability');
INSERT INTO ax_meta_element (parent_schema, label, definition, enabled, element_id, parent_element, tag_name) VALUES ('AGLS', 'Postcode', 'Postcode(s) applicable to the spatial coverage of the resource content.', 1, 55, 26, 'postcode');



-- Name: ax_enc_scheme;
--
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (32, 'JEL', 'The Journal of Economic Literature (JEL) began publication in 1969 under the auspices of the American Economic Association with quarterly issues appearing in March, June, September, and December. JEL contains survey and review articles, book reviews, an annotated bibliography of newly published books, and a list of current dissertations in North American universities.', 1, 'Journal of Economic Literature', '', 'http://www.aeaweb.org/journal.html', 'JEL');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (14, 'URI', 'Uniform Resource Identifiers (URIs, aka URLs) are short strings that identify resources in the web: documents, images, downloadable files, services, electronic mailboxes, and other resources. They make resources available under a variety of naming schemes and access methods such as HTTP, FTP, and Internet mail addressable in the same simple way.', 1, 'Uniform Resource Identifier (URI)', '', 'http://www.w3.org/Addressing/', 'URI');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (27, 'AGIFT', 'Australian Governments'' Interactive Functions Thesaurus. AGIFT aims to help end-users searching government websites to retrieve relevant results by linking natural language terms with their bureaucratic equivalents. For example, AGIFT enables a user interested in government information on ''kindergartens'' to focus their search on the government term ''early childhood education''.', 1, 'AGLS Functions Thesaurus', '', 'http://www.naa.gov.au/recordkeeping/gov_online/agift/summary.html', 'AGIFT');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (1, 'IMT', 'RFC2045, RFC2046 specifies that Content Types, Content Subtypes, Character Sets, Access Types, and conversion values for MIME mail will be assigned and listed by the IANA.', 1, 'Internet Media Types (MIME)', 'http://www.isi.edu/in-notes/iana/assignments/media-types/media-types', 'http://www.isi.edu/in-notes/iana/assignments/media-types/media-types', 'IMT');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (31, 'AAT', 'The AAT is a structured vocabulary containing around 125,000 terms and other information about concepts. Terms in AAT may be used to describe art, architecture, decorative arts, material culture, and archival materials. The coverage of the AAT ranges from Antiquity to the present, and the scope is global.', 1, 'Getty Art and Architecture Thesaurus', '', 'http://www.getty.edu/research/conducting_research/vocabularies/aat/', 'AAT');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (15, 'AGLSAudience', 'A controlled vocabulary for use with the Audience element for AGLS.', 1, 'AGLS Audience', '', 'http://www.oit.nsw.gov.au/Guidelines/2.3.34.z20-AGLS.asp', 'AglsAudience');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (16, 'AGLSDocument', 'A controlled vocabulary of document types for the AGLS.', 1, 'AGLS Document', '', 'http://www.oit.nsw.gov.au/Guidelines/2.3.34.z20-AGLS.asp', 'AglsDocument');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (26, 'AGLSService', 'The AGLS Service Type Scheme is a controlled vocabulary for types of services for use with AGLS metadata.

The AGLS metadata standard includes an element which can be used to provide information about the type of service for a resource which is a service, either offline or online.', 1, 'AGLS Service', '', 'http://www.naa.gov.au/recordkeeping/gov_online/agls/schemes/agls-service1.0.html', 'AglsService');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (36, 'ANZSIC', 'ANZSIC - Australian/New Zealand Standard Industrial Classifications. This is a scheme applicable for the ''Audience'' metadata element.', 1, 'Standard Industrial Classifications', '', 'http://www.arc.gov.au/apply_grants/anzsic_codes.htm', 'ANZSIC');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (30, 'APAIS', 'The APAIS thesaurus lists the subject terms used to index articles for APAIS: Australian Public Affairs Information Service, a subject guide to literature in the social sciences and humanities. The APAIS thesaurus was introduced in 1978 when APAIS became available as an online database and was first published by the National Library of Australia in 1980 to facilitate online searching.', 1, 'Australian Public Affairs Information Service Thesaurus', '', 'http://www.nla.gov.au/apais/thesaurus/', 'APAIS');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (35, 'ASCO', 'ASCO -- Australian Standard Classification of Occupations, Second Edition. This scheme is available as a PDF file.', 1, 'Australian Standard Classification of Occupations', '', 'http://www.abs.gov.au/ausstats/abs@.nsf/0/B70D48AB5ACC56FECA25692600235A67?Open&Highlight=0,ASCO', 'ASCO');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (37, 'Australia Postcodes', 'Postcodes for all of Australia. Postcodes can be found via a web search form.', 1, 'Postcodes for all of Australia', '', 'http://www1.auspost.com.au/postcodes/', 'Australia Postcodes');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (13, 'DCMIPeriod', 'A specification of the limits of a time interval.', 1, 'Dublin Core Period', '', 'http://dublincore.org/documents/dcmi-period/', 'DCMIPeriod');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (17, 'DCMIPoint', 'The DCMI Point Encoding Scheme is used for identifying a point in space using its geographic coordinates. Components of the value correspond to the location coordinates in north and east directions, plus optionally elevation, and also allow the coordinate system and units to be specified, and a name if desired.', 1, 'Dublin Core Point Encoding', '', 'http://dublincore.org/documents/dcmi-point/', 'DCMIPoint');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (28, 'KeywordAAA', 'Keyword AAA is a product of State Records Authority of New South Wales.

Keyword AAA is designed to enable the consistent classification, titling and indexing of the records that document the common administrative functions of an agency. The common administrative functions are the functions and activities that are performed by most agencies, such as occupational health and safety or finance.', 1, 'AGLS Function Thesaurus', '', 'http://www.naa.gov.au/recordkeeping/control/KeyAAA/summary.html', 'Keyword AAA');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (29, 'LCSH', 'The big red books. Library of Congress Subject Headings (LCSH), 27th edition, (2004), is the only subject headings list accepted as the world wide standard. LCSH is the most comprehensive list of subject headings in print in the world. It''s the one tool no librarian should be without. Provides an alphabetical list of all subject headings, cross-references and subdivisions in verified status in the LC subject authority file.', 1, 'Library of Congress Subject Headings', '', 'http://www.loc.gov/cds/lcsh.html', 'LCSH');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (34, 'MeSH', 'The Medical Subject Headings comprise the National Library of Medicine controlled vocabulary used for indexing articles, for cataloging books and other holdings, and for searching MeSH-indexed databases, including MEDLINE.', 1, 'Medical Subject Headings', '', 'http://www.nlm.nih.gov/mesh/meshhome.html', 'MeSH');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (21, 'RFC2396', 'This document defines a grammar that is a superset of all valid URI, such that an implementation can parse the common components of a URI reference without knowing the scheme-specific requirements of every possible identifier type. This document does not define a generative    grammar for URI; that task will be performed by the individual specifications of each URI scheme.', 1, 'Uniform Resource Identifiers (URI)', '', 'http://www.ietf.org/rfc/rfc2396.txt', 'RFC2396');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (3, 'RFC3066', 'This scheme describes a language tag for use in cases where it is desired to indicate the language used in an information object, how    to register values for use in this language tag, and a construct for matching such language tags.', 1, 'Tags for the Identification of Languages', 'http://www.loc.gov/standards/iso639-2/langcodes.html', 'http://www.ietf.org/rfc/rfc3066.txt', 'RFC3066');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (33, 'TAGS', 'The Thesaurus of Australian Government Subjects (TAGS) describes Commonwealth information and services.  It was developed in response to agency requests for a simpler approach to ''Subject'' metadata.', 1, 'Thesaurus of Australian Government Subjects', '', 'http://www.agimo.gov.au/services/tags', 'TAGS');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (19, 'TGN', 'The TGN is a structured vocabulary containing more than one million names and other information about places. The TGN includes all continents and nations of the modern political world, as well as historical places. It includes physical features and administrative entities, such as cities and nations. The emphasis in TGN is on places that are important for art and architecture.', 1, 'The Getty Thesaurus of Geographic Names', '', 'http://www.getty.edu/research/conducting_research/vocabularies/tgn/index.html', 'TGN');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (20, 'UDC', 'The Universal Decimal Classification (UDC) is the world''s foremost multilingual classification scheme for all fields of knowledge, a sophisticated indexing and retrieval tool. It was adapted by Paul Otlet (1), (2), (3) and Nobel Prizewinner Henri La Fontaine from the Decimal Classification of Melvil Dewey, and first published (in French) from 1904 to 1907.', 1, 'Universal Decimal Classification', '', 'http://www.udcc.org/', 'UDC');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (22, 'W3CDTF', 'This scheme defines a profile of ISO 8601, the International Standard for the representation of dates and times. ISO 8601 describes a large number of date/time formats. To reduce the scope for error and the complexity of software, it is useful to restrict the supported formats to a small number. This profile defines a few date/time formats, likely to satisfy most requirements.', 1, 'Date and Time Format Scheme', '', 'http://www.w3.org/TR/NOTE-datetime', 'W3CDTF');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (10, 'X.500', 'The X.500 directory services protocol.', 1, 'Directory Services Protocol', '', 'http://www.faqs.org/rfc/rfc1309.txt', 'X.500');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (39, 'ISSN', 'The ISSN (International Standard Serial Number) is an eight-digit number which identifies periodical publications as such, including electronic serials. More than one million  ISSN numbers have so far been assigned.', 1, 'International Standard Serial Number', '', 'http://www.issn.org:8080/pub/', 'ISSN');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (40, 'ISBN', 'The ISBN (International Standard Book Number) is a unique machine-readable identification number, which marks any book unmistakably. This number is defined in ISO Standard 2108. The number has been in use now for 30 years and has revolutionised the international book-trade. 166 countries and territories are officially ISBN members. The ISBN accompanies a publication from its production onwards.', 1, 'International Standard Book Number', '', 'http://www.isbn-international.org/', 'ISBN');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (5, 'FONZ', 'New Zealand Government thesaurus of functions of government. Mandatory for metadata prepared for New Zealand Government web portals.', 1, 'NZGLS Functions of New Zealand', '', 'http://www.e-government.govt.nz/docs/element-set-21/chapter8.html', 'FONZ');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (9, 'SONZ', 'New Zealand Government thesaurus of topics of government activity or information provision. Mandatory for metadata prepared for New Zealand Government web portals', 1, 'NZGLS Subjects of New Zealand', '', 'http://www.e-government.govt.nz/docs/element-set-21/chapter8.html', 'SONZ');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (41, 'Value List', 'A comma-delimited list of values which are stored against the metadata element.', 1, 'A list of provided values', '', '', '');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (12, 'ISO8601', 'A standard for the numeric representation of dates and time.', 1, 'Numeric Representation of Dates and Time', '', 'http://www.iso.ch/iso/en/prods-services/popstds/datesandtime.html', 'ISO 8601');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (44, 'DOI', 'The DOI System provides a framework for managing intellectual content, for linking customers with content suppliers, for facilitating electronic commerce, and enabling automated copyright management for all types of media. The system is managed and directed by the International DOI Foundation. Several million DOIs have been assigned by DOI Registration Agencies in the US, Australasia, and Europe.

DOIs are names (characters and/or digits) assigned to objects of intellectual property (physical, digital or abstract) such as electronic journal articles, images, learning objects, ebooks, any kind of content. They are used to provide current information, including where they (or information about them) can be found on the Internet. Information about a digital object may change over time, including where to find it, but its DOI will not change.', 1, 'Digital Object Identifier System', '', 'http://www.doi.org/', 'DOI');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (45, 'DDC', 'The Dewey Decimal Classification (DDC) system, devised by library pioneer Melvil Dewey in the 1870s and owned by OCLC since 1988, provides a dynamic structure for the organization of library collections.', 1, 'The Dewey Decimal Classification', '', 'http://www.oclc.org/dewey/index.htm', 'DDC');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (46, 'LCC', 'The Library of Congress Classification system.', 1, 'Library of Congress Classification', '', 'http://lcweb.loc.gov/catdir/cpso/lcco/lcco.html', 'LCC');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (18, 'RFC1766', 'This scheme describes a language tag for use in cases where it is desired to indicate the language used in an information object.

It also defines a Content-language: header, for use in the case where one desires to indicate the language of something that has RFC-822-like headers, like MIME body parts or Web documents, and a new parameter to the Multipart/Alternative type, to aid in the usage of the Content-Language: header.', 1, 'Tags for the Identification of Languages', '', 'http://www.ietf.org/rfc/rfc1766.txt', 'RFC1766');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (23, 'DCMIType', 'Vocabulary of DCMI types.', 1, 'Dublin Core Types Vocabulary', '', 'http://dublincore.org/documents/dcmi-type-vocabulary/', 'DCMIType');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (47, 'DCMIBox', '', 1, 'DCMI Box', '', 'http://dublincore.org/documents/dcmi-box/', 'Box');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (48, 'CCLIC', 'Select a pre-defined licence on the Creative Commons website, and then use a URI to refer to it.', 1, 'Creative Commons Licences', '', 'http://creativecommons.org/licenses/', '');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (11, 'AGLSAgent', 'The AGLS Agent Scheme was developed as a method for describing characteristics of agents for use by government agencies in AGLS metadata descriptions. Agents are people, organisations or instruments associated with resources.', 1, 'AGLS Agent', '', 'http://www.oit.nsw.gov.au/Guidelines/2.3.34.z23-AGLS.asp#A76', 'AglsAgent');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (25, 'AGLSJurisdiction', 'The AGLS Jurisdiction Scheme is a controlled vocabulary for names of administrative jurisdictions in Australia, developed by the National Archives of Australia for use by government agencies in AGLS metadata descriptions. However, it can be used by non-government organisations as a source for jurisdiction names when appropriate.', 1, 'AGLS Jurisdiction', '', 'http://www.oit.nsw.gov.au/Guidelines/2.3.34.z24-AGLS.asp#A78', 'AglsJuri');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (24, 'AGLSAvailability', 'The AGLS Availability Scheme is a method for describing accessibility characteristics of the person or organisation making non-electronic resources available.', 1, 'AGLS Availability', '', 'http://www.naa.gov.au/recordkeeping/gov_online/agls/schemes/AglsAvail1.0.html', 'AglsAvailability');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (38, 'ISO639-2', 'Codes for the Representation of Names of Languages Part 2: Alpha-3 Code.

ISO 639 provides two sets of language codes, one as a two-letter code set (639-1) and another as a three-letter code set (this part of ISO 639) for the representation of names of languages. ISO 639-1 was devised primarily for use in terminology, lexicography and linguistics. This part of ISO 639 represents all languages contained in ISO 639-1 and in addition any other language as well as language groups as they may be coded for special purposes when more specificity in coding is needed. The languages listed in ISO 639-1 are a subset of the languages listed in ISO 639-2; every language code in the two-letter code set has a corresponding language code in the alpha-3 list, but not necessarily vice versa.

Both code lists are to be considered as open lists. The codes were devised for use in terminology, lexicography, information and documentation (i.e. for libraries, information services, and publishers) and linguistics. This part of ISO 639 also includes guidelines for the creation of language codes and their use in some applications.', 1, 'Alpha-3 Language Codes', 'http://www.loc.gov/standards/iso639-2/ISO-639-2_values_8bits.txt', 'http://www.loc.gov/standards/iso639-2/langhome.html', 'ISO 639-2');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (49, 'ISO639-1', 'Codes for the Representation of Names of Languages Part 2: Alpha-3 Code.

ISO 639 provides two sets of language codes, one as a two-letter code set (639-1) and another as a three-letter code set (this part of ISO 639) for the representation of names of languages. ISO 639-1 was devised primarily for use in terminology, lexicography and linguistics. This part of ISO 639 represents all languages contained in ISO 639-1 and in addition any other language as well as language groups as they may be coded for special purposes when more specificity in coding is needed. The languages listed in ISO 639-1 are a subset of the languages listed in ISO 639-2; every language code in the two-letter code set has a corresponding language code in the alpha-3 list, but not necessarily vice versa.

Both code lists are to be considered as open lists. The codes were devised for use in terminology, lexicography, information and documentation (i.e. for libraries, information services, and publishers) and linguistics. This part of ISO 639 also includes guidelines for the creation of language codes and their use in some applications.', 1, 'Alpha-2 Language Codes', 'http://www.loc.gov/standards/iso639-2/ISO-639-2_values_8bits.txt', 'http://www.loc.gov/standards/iso639-2/langhome.html', 'ISO 639-1');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (4, 'ISO3166', 'This list states the country names (official short names in English) in alphabetical order as given in ISO 3166-1 and the corresponding ISO 3166-1-alpha-2 code elements. It lists 240 official short names and code elements.', 1, 'English country names and code elements', 'http://www.iso.org/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1-semic.txt', 'http://www.iso.org/iso/en/prods-services/iso3166ma/02iso-3166-code-lists/list-en1.html', 'ISO 3166');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (6, 'NZGLSAgent', 'A set of components of contact information for a person or organisation making resources available.

The component labels, e.g. corporateName are formatted according to Dublin Core rules with the words strung together, the first word not capitalized but subsequent words having initial capitals.

All of these components are optional and should only be used when they give useful information. All of the components may be repeated, but if components vary for different channels then repeat the Availability element instead, for clarity. For example, a call centre may be available 24x7 and a branch only Monday - Friday, 9.00 am to 5.00 pm. (excluding public holidays). The order of components is not significant.', 1, 'NZGLS Agent', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter27.html', 'NZGLSAgent');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (7, 'NZGLSAudience', 'A controlled vocabulary for New Zealand Government use for resource discovery metadata.', 1, 'NZGLS Audience Vocabulary', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter28.html', 'NZGLSAudience');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (8, 'NZGLSJuriisdiction', 'A controlled vocabulary for New Zealand Government use for resource discovery metadata.', 1, 'NZGLS Jurisdiction Vocabulary', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter30.html', 'NZGLSJuriisdiction');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (50, 'NZGLSType', 'Encoding schemes for the Type element are currently being worked on.', 1, 'NZGLS Type', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter32.html', 'NZGLSType');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (42, 'NZGLSDocument', 'A controlled vocabulary of document types for the NZGLS.', 1, 'NZGLS Document', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter33.html', 'NZGLSDocument');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (43, 'NZGLSService', 'A controlled vocabulary of service types for the NZGLS.', 1, 'NZGLS Service', '', 'http://www.e-government.govt.nz/docs/usage-guide-2-1/chapter32.html', 'NZGLSService');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (51, 'NZSC099', 'NZ Standard Classification of Occupations 1999', 1, 'NZSC099', '', 'http://www.stats.govt.nz/domino/external/web/carsweb.nsf/94772cd5918085044c2567e6007eec2c/ef7c87fcece9546ccc2568c40000836e?OpenDocument', 'NZSC099');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (52, 'NZGPN', 'NZ Geographic Place Names Database [Land Information New Zealand (LINZ)]', 1, 'NZGPN', '', 'http://www.linz.govt.nz/rcs/linz/pub/web/root/core/Placenames/searchplacenames/index.jsp', 'NZGPN');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (53, 'NZMS260', 'NZ Map Series 1:50 000', 1, 'NZMS260', '', '', 'NZMS260');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (54, 'NZMS262', 'NZ Map Series 1:250 000', 1, 'NZMS262', '', '', 'NZMS262');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (55, 'NZ202', 'NZ Chart Catalogue - maritime areas', 1, 'NZ202', '', 'http://www.hydro.linz.govt.nz/charts/catalogue/index.asp', 'NZ202');
INSERT INTO ax_enc_scheme (enc_scheme_id, enc_scheme_name, description, enabled, label, datasrc_uri, reference_url, tag_name) VALUES (56, 'ISMN', 'International Standard Music Number - for printed music', 1, 'ISMN', '', 'http://www.ismn-international.org/whatis.html', 'ISMN');

-- Name: ax_enc_value;
--
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'collection', 'Collection');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'dataset', 'Dataset');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'event', 'Event');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'image', 'Image');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'Interactive Resource', 'InteractiveResource');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'MovingImage', 'Moving Image');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'PhysicalObject', 'Physical Object');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'service', 'Service');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'software', 'Software');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'sound', 'Sound');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'StillImage', 'Still Image');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (23, 'text', 'Text');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Commonwealth of Australia', 'Commonwealth of Australia');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Australian Antarctic Territory', 'Australian Antarctic Territory');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Australian Capital Territory (ACT)', 'Australian Capital Territory (ACT)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Indian Ocean Territories', 'Indian Ocean Territories');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'New South Wales', 'New South Wales');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Northern Territory', 'Northern Territory');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Queensland', 'Queensland');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'South Australia', 'South Australia');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Tasmania', 'Tasmania');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Victoria', 'Victoria');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Western Australia', 'Western Australia');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (25, 'Other', 'Other');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'aa', 'Afar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'aar', 'Afar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ab', 'Abkhazian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'abk', 'Abkhazian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ace', 'Achinese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ach', 'Acoli');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ada', 'Adangme');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ady', 'Adyghe; Adygei');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'afa', 'Afro-Asiatic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'afh', 'Afrihili');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'af', 'Afrikaans');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'afr', 'Afrikaans');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ak', 'Akan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'aka', 'Akan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'akk', 'Akkadian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sq', 'Albanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'alb', 'Albanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ale', 'Aleut');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'alg', 'Algonquian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'am', 'Amharic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'amh', 'Amharic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ang', 'English, Old (ca.450-1100)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'apa', 'Apache languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ar', 'Arabic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ara', 'Arabic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arc', 'Aramaic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'an', 'Aragonese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arg', 'Aragonese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'hy', 'Armenian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arm', 'Armenian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arn', 'Araucanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arp', 'Arapaho');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'art', 'Artificial (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'arw', 'Arawak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'as', 'Assamese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'asm', 'Assamese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ast', 'Asturian; Bable');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ath', 'Athapascan languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'aus', 'Australian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'av', 'Avaric');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ava', 'Avaric');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ae', 'Avestan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ave', 'Avestan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'awa', 'Awadhi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ay', 'Aymara');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'aym', 'Aymara');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'az', 'Azerbaijani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'aze', 'Azerbaijani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bad', 'Banda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bai', 'Bamileke languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ba', 'Bashkir');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bak', 'Bashkir');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bal', 'Baluchi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bm', 'Bambara');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bam', 'Bambara');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ban', 'Balinese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'eu', 'Basque');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'baq', 'Basque');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bas', 'Basa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bat', 'Baltic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bej', 'Beja');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'be', 'Belarusian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bel', 'Belarusian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bem', 'Bemba');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bn', 'Bengali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ben', 'Bengali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ber', 'Berber (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bho', 'Bhojpuri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bh', 'Bihari');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bih', 'Bihari');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bik', 'Bikol');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bin', 'Bini');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bi', 'Bislama');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bis', 'Bislama');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bla', 'Siksika');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bnt', 'Bantu (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bs', 'Bosnian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bos', 'Bosnian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bra', 'Braj');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'br', 'Breton');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bre', 'Breton');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'btk', 'Batak (Indonesia)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bua', 'Buriat');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bug', 'Buginese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bg', 'Bulgarian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bul', 'Bulgarian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'my', 'Burmese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'bur', 'Burmese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'byn', 'Blin; Bilin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cad', 'Caddo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cai', 'Central American Indian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'car', 'Carib');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ca', 'Catalan; Valencian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cat', 'Catalan; Valencian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cau', 'Caucasian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ceb', 'Cebuano');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cel', 'Celtic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ch', 'Chamorro');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cha', 'Chamorro');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chb', 'Chibcha');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ce', 'Chechen');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'che', 'Chechen');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chg', 'Chagatai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'zh', 'Chinese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chi', 'Chinese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chk', 'Chuukese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chm', 'Mari');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chn', 'Chinook jargon');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cho', 'Choctaw');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chp', 'Chipewyan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chr', 'Cherokee');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'cu', 'Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chu', 'Church Slavic; Old Slavonic; Church Slavonic; Old Bulgarian; Old Church Slavonic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'cv', 'Chuvash');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chv', 'Chuvash');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'chy', 'Cheyenne');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cmc', 'Chamic languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cop', 'Coptic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kw', 'Cornish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cor', 'Cornish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'co', 'Corsican');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cos', 'Corsican');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cpe', 'Creoles and pidgins, English based (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cpf', 'Creoles and pidgins, French-based (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cpp', 'Creoles and pidgins, Portuguese-based (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'cr', 'Cree');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cre', 'Cree');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'crh', 'Crimean Tatar; Crimean Turkish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'crp', 'Creoles and pidgins (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'csb', 'Kashubian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cus', 'Cushitic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'cs', 'Czech');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'cze', 'Czech');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dak', 'Dakota');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'da', 'Danish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dan', 'Danish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dar', 'Dargwa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'day', 'Dayak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'del', 'Delaware');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'den', 'Slave (Athapascan)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dgr', 'Dogrib');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'din', 'Dinka');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'dv', 'Divehi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'div', 'Divehi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'doi', 'Dogri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dra', 'Dravidian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dsb', 'Lower Sorbian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dua', 'Duala');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dum', 'Dutch, Middle (ca.1050-1350)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nl', 'Dutch; Flemish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dut', 'Dutch; Flemish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dyu', 'Dyula');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'dz', 'Dzongkha');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'dzo', 'Dzongkha');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'efi', 'Efik');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'egy', 'Egyptian (Ancient)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'eka', 'Ekajuk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'elx', 'Elamite');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'en', 'English');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'eng', 'English');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'enm', 'English, Middle (1100-1500)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'eo', 'Esperanto');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'epo', 'Esperanto');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'et', 'Estonian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'est', 'Estonian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ee', 'Ewe');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ewe', 'Ewe');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ewo', 'Ewondo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fan', 'Fang');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fo', 'Faroese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fao', 'Faroese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fat', 'Fanti');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fj', 'Fijian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fij', 'Fijian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fi', 'Finnish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fin', 'Finnish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fiu', 'Finno-Ugrian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fon', 'Fon');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fr', 'French');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fre', 'French');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'frm', 'French, Middle (ca.1400-1800)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fro', 'French, Old (842-ca.1400)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fy', 'Frisian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fry', 'Frisian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ff', 'Fulah');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ful', 'Fulah');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'fur', 'Friulian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gaa', 'Ga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gay', 'Gayo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gba', 'Gbaya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gem', 'Germanic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ka', 'Georgian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'geo', 'Georgian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'de', 'German');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ger', 'German');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gez', 'Geez');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gil', 'Gilbertese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'gd', 'Gaelic; Scottish Gaelic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gla', 'Gaelic; Scottish Gaelic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ga', 'Irish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gle', 'Irish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'gl', 'Gallegan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'glg', 'Gallegan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'gv', 'Manx');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'glv', 'Manx');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gmh', 'German, Middle High (ca.1050-1500)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'goh', 'German, Old High (ca.750-1050)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gon', 'Gondi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gor', 'Gorontalo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'got', 'Gothic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'grb', 'Grebo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'grc', 'Greek, Ancient (to 1453)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'el', 'Greek, Modern (1453-)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gre', 'Greek, Modern (1453-)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'gn', 'Guarani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'grn', 'Guarani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'gu', 'Gujarati');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'guj', 'Gujarati');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'gwi', 'Gwichin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hai', 'Haida');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ht', 'Haitian; Haitian Creole');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hat', 'Haitian; Haitian Creole');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ha', 'Hausa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hau', 'Hausa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'haw', 'Hawaiian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'he', 'Hebrew');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'heb', 'Hebrew');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'hz', 'Herero');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'her', 'Herero');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hil', 'Hiligaynon');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'him', 'Himachali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'hi', 'Hindi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hin', 'Hindi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hit', 'Hittite');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hmn', 'Hmong');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ho', 'Hiri Motu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hmo', 'Hiri Motu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hsb', 'Upper Sorbian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'hu', 'Hungarian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hun', 'Hungarian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'hup', 'Hupa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'iba', 'Iban');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ig', 'Igbo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ibo', 'Igbo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'is', 'Icelandic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ice', 'Icelandic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'io', 'Ido');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ido', 'Ido');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ii', 'Sichuan Yi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'iii', 'Sichuan Yi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ijo', 'Ijo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'iu', 'Inuktitut');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'iku', 'Inuktitut');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ie', 'Interlingue');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ile', 'Interlingue');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ilo', 'Iloko');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ia', 'Interlingua (International Auxiliary Language Association)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ina', 'Interlingua (International Auxiliary Language Association)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'inc', 'Indic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'id', 'Indonesian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ind', 'Indonesian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ine', 'Indo-European (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'inh', 'Ingush');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ik', 'Inupiaq');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ipk', 'Inupiaq');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ira', 'Iranian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'iro', 'Iroquoian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'it', 'Italian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ita', 'Italian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'jv', 'Javanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'jav', 'Javanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'jbo', 'Lojban');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ja', 'Japanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'jpn', 'Japanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'jpr', 'Judeo-Persian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'jrb', 'Judeo-Arabic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kaa', 'Kara-Kalpak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kab', 'Kabyle');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kac', 'Kachin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kl', 'Kalaallisut; Greenlandic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kal', 'Kalaallisut; Greenlandic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kam', 'Kamba');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kn', 'Kannada');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kan', 'Kannada');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kar', 'Karen');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ks', 'Kashmiri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kas', 'Kashmiri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kr', 'Kanuri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kau', 'Kanuri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kaw', 'Kawi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kk', 'Kazakh');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kaz', 'Kazakh');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kbd', 'Kabardian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kha', 'Khasi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'khi', 'Khoisan (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'km', 'Khmer');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'khm', 'Khmer');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kho', 'Khotanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ki', 'Kikuyu; Gikuyu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kik', 'Kikuyu; Gikuyu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'rw', 'Kinyarwanda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kin', 'Kinyarwanda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ky', 'Kirghiz');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kir', 'Kirghiz');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kmb', 'Kimbundu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kok', 'Konkani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kv', 'Komi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kom', 'Komi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kg', 'Kongo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kon', 'Kongo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ko', 'Korean');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kor', 'Korean');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kos', 'Kosraean');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kpe', 'Kpelle');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'krc', 'Karachay-Balkar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kro', 'Kru');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kru', 'Kurukh');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'kj', 'Kuanyama; Kwanyama');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kua', 'Kuanyama; Kwanyama');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kum', 'Kumyk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ku', 'Kurdish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kur', 'Kurdish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'kut', 'Kutenai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lad', 'Ladino');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lah', 'Lahnda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lam', 'Lamba');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lo', 'Lao');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lao', 'Lao');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'la', 'Latin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lat', 'Latin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lv', 'Latvian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lav', 'Latvian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lez', 'Lezghian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'li', 'Limburgan; Limburger; Limburgish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lim', 'Limburgan; Limburger; Limburgish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ln', 'Lingala');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lin', 'Lingala');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lt', 'Lithuanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lit', 'Lithuanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lol', 'Mongo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'loz', 'Lozi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lb', 'Luxembourgish; Letzeburgesch');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ltz', 'Luxembourgish; Letzeburgesch');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lua', 'Luba-Lulua');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lu', 'Luba-Katanga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lub', 'Luba-Katanga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'lg', 'Ganda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lug', 'Ganda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lui', 'Luiseno');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lun', 'Lunda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'luo', 'Luo (Kenya and Tanzania)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'lus', 'lushai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mk', 'Macedonian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mac', 'Macedonian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mad', 'Madurese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mag', 'Magahi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mh', 'Marshallese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mah', 'Marshallese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mai', 'Maithili');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mak', 'Makasar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ml', 'Malayalam');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mal', 'Malayalam');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'man', 'Mandingo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mi', 'Maori');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mao', 'Maori');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'map', 'Austronesian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mr', 'Marathi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mar', 'Marathi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mas', 'Masai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ms', 'Malay');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'may', 'Malay');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mdf', 'Moksha');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mdr', 'Mandar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'men', 'Mende');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mga', 'Irish, Middle (900-1200)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mic', 'Micmac');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'min', 'Minangkabau');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mis', 'Miscellaneous languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mkh', 'Mon-Khmer (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mg', 'Malagasy');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mlg', 'Malagasy');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mt', 'Maltese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mlt', 'Maltese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mnc', 'Manchu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mni', 'Manipuri');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mno', 'Manobo languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'moh', 'Mohawk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mo', 'Moldavian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mol', 'Moldavian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'mn', 'Mongolian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mon', 'Mongolian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mos', 'Mossi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mul', 'Multiple languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mun', 'Munda languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mus', 'Creek');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'mwr', 'Marwari');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'myn', 'Mayan languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'myv', 'Erzya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nah', 'Nahuatl');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nai', 'North American Indian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nap', 'Neapolitan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'na', 'Nauru');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nau', 'Nauru');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nv', 'Navajo; Navaho');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nav', 'Navajo; Navaho');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nr', 'Ndebele, South; South Ndebele');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nbl', 'Ndebele, South; South Ndebele');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nd', 'Ndebele, North; North Ndebele');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nde', 'Ndebele, North; North Ndebele');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ng', 'Ndonga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ndo', 'Ndonga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nds', 'Low German; Low Saxon; German, Low; Saxon, Low');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ne', 'Nepali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nep', 'Nepali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'new', 'Nepal Bhasa; Newari');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nia', 'Nias');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nic', 'Niger-Kordofanian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'niu', 'Niuean');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nn', 'Norwegian Nynorsk; Nynorsk, Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nno', 'Norwegian Nynorsk; Nynorsk, Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'nb', 'Norwegian Bokmal; Bokmal, Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nob', 'Norwegian Bokmal; Bokmal, Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nog', 'Nogai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'non', 'Norse, Old');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'no', 'Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nor', 'Norwegian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nso', 'Sotho, Northern');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nub', 'Nubian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nwc', 'Classical Newari; Old Newari; Classical Nepal Bhasa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ny', 'Chichewa; Chewa; Nyanja');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nya', 'Chichewa; Chewa; Nyanja');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nym', 'Nyamwezi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nyn', 'Nyankole');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nyo', 'Nyoro');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'nzi', 'Nzima');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'oc', 'Occitan (post 1500); Provencal');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'oci', 'Occitan (post 1500); Provencal');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'oj', 'Ojibwa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'oji', 'Ojibwa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'or', 'Oriya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ori', 'Oriya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'om', 'Oromo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'orm', 'Oromo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'osa', 'Osage');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'os', 'Ossetian; Ossetic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'oss', 'Ossetian; Ossetic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ota', 'Turkish, Ottoman (1500-1928)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'oto', 'Otomian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'paa', 'Papuan (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pag', 'Pangasinan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pal', 'Pahlavi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pam', 'Pampanga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'pa', 'Panjabi; Punjabi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pan', 'Panjabi; Punjabi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pap', 'Papiamento');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pau', 'Palauan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'peo', 'Persian, Old (ca.600-400 B.C.)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'fa', 'Persian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'per', 'Persian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'phi', 'Philippine (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'phn', 'Phoenician');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'pi', 'Pali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pli', 'Pali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'pl', 'Polish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pol', 'Polish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pon', 'Pohnpeian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'pt', 'Portuguese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'por', 'Portuguese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pra', 'Prakrit languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pro', 'Provencal, Old (to 1500)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ps', 'Pushto');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'pus', 'Pushto');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'qaa-qtz', 'Reserved for local use');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'qu', 'Quechua');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'que', 'Quechua');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'raj', 'Rajasthani');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'rap', 'Rapanui');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'rar', 'Rarotongan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'roa', 'Romance (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'rm', 'Raeto-Romance');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'roh', 'Raeto-Romance');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'rom', 'Romany');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ro', 'Romanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'rum', 'Romanian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'rn', 'Rundi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'run', 'Rundi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ru', 'Russian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'rus', 'Russian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sad', 'Sandawe');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sg', 'Sango');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sag', 'Sango');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sah', 'Yakut');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sai', 'South American Indian (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sal', 'Salishan languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sam', 'Samaritan Aramaic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sa', 'Sanskrit');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'san', 'Sanskrit');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sas', 'Sasak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sat', 'Santali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sr', 'Serbian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'scc', 'Serbian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sco', 'Scots');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'hr', 'Croatian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'scr', 'Croatian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sel', 'Selkup');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sem', 'Semitic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sga', 'Irish, Old (to 900)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sgn', 'Sign Languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'shn', 'Shan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sid', 'Sidamo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'si', 'Sinhalese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sin', 'Sinhalese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sio', 'Siouan languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sit', 'Sino-Tibetan (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sla', 'Slavic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sk', 'Slovak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'slo', 'Slovak');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sl', 'Slovenian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'slv', 'Slovenian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sma', 'Southern Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'se', 'Northern Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sme', 'Northern Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'smi', 'Sami languages (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'smj', 'Lule Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'smn', 'Inari Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sm', 'Samoan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'smo', 'Samoan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sms', 'Skolt Sami');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sn', 'Shona');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sna', 'Shona');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sd', 'Sindhi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'snd', 'Sindhi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'snk', 'Soninke');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sog', 'Sogdian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'so', 'Somali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'som', 'Somali');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'son', 'Songhai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'st', 'Sotho, Southern');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sot', 'Sotho, Southern');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'es', 'Spanish; Castilian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'spa', 'Spanish; Castilian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sc', 'Sardinian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'srd', 'Sardinian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'srr', 'Serer');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ssa', 'Nilo-Saharan (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ss', 'Swati');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ssw', 'Swati');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'suk', 'Sukuma');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'su', 'Sundanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sun', 'Sundanese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sus', 'Susu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'sux', 'Sumerian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sw', 'Swahili');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'swa', 'Swahili');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'sv', 'Swedish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'swe', 'Swedish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'syr', 'Syriac');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ty', 'Tahitian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tah', 'Tahitian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tai', 'Tai (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ta', 'Tamil');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tam', 'Tamil');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tt', 'Tatar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tat', 'Tatar');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'te', 'Telugu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tel', 'Telugu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tem', 'Timne');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ter', 'Tereno');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tet', 'Tetum');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tg', 'Tajik');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tgk', 'Tajik');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tl', 'Tagalog');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tgl', 'Tagalog');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'th', 'Thai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tha', 'Thai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'bo', 'Tibetan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tib', 'Tibetan');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tig', 'Tigre');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ti', 'Tigrinya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tir', 'Tigrinya');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tiv', 'Tiv');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tkl', 'Tokelau');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tlh', 'Klingon; tlhlngan-Hol');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tli', 'Tlingit');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tmh', 'Tamashek');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tog', 'Tonga (Nyasa)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'to', 'Tonga (Tonga Islands)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ton', 'Tonga (Tonga Islands)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tpi', 'Tok Pisin');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tsi', 'Tsimshian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tn', 'Tswana');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tsn', 'Tswana');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ts', 'Tsonga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tso', 'Tsonga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tk', 'Turkmen');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tuk', 'Turkmen');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tum', 'Tumbuka');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tup', 'Tupi languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tr', 'Turkish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tur', 'Turkish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tut', 'Altaic (Other)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tvl', 'Tuvalu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'tw', 'Twi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'twi', 'Twi');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'tyv', 'Tuvinian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'udm', 'Udmurt');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'uga', 'Ugaritic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ug', 'Uighur');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'uig', 'Uighur');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'uk', 'Ukrainian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ukr', 'Ukrainian');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'umb', 'Umbundu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'und', 'Undetermined');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'ur', 'Urdu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'urd', 'Urdu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'uz', 'Uzbek');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'uzb', 'Uzbek');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'vai', 'Vai');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 've', 'Venda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ven', 'Venda');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'vi', 'Vietnamese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'vie', 'Vietnamese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'vo', 'Volapuk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'vol', 'Volapuk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'vot', 'Votic');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wak', 'Wakashan languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wal', 'Walamo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'war', 'Waray');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'was', 'Washo');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'cy', 'Welsh');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wel', 'Welsh');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wen', 'Sorbian languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'wa', 'Walloon');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wln', 'Walloon');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'wo', 'Wolof');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'wol', 'Wolof');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'xal', 'Kalmyk');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'xh', 'Xhosa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'xho', 'Xhosa');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'yao', 'Yao');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'yap', 'Yapese');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'yi', 'Yiddish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'yid', 'Yiddish');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'yo', 'Yoruba');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'yor', 'Yoruba');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'ypk', 'Yupik languages');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'zap', 'Zapotec');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'zen', 'Zenaga');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'za', 'Zhuang; Chuang');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'zha', 'Zhuang; Chuang');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'znd', 'Zande');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (49, 'zu', 'Zulu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'zul', 'Zulu');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, 'zun', 'Zuni');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (38, '', '');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, ').', 'This list states the country names (official short names in English) in alphabetical order as given in ISO 3166-1 and the corresponding ISO 3166-1-alpha-2 code elements. The list is updated whenever a change to the official code list in ISO 3166-1 is effected by the ISO 3166/MA. It lists 240 official short names and code elements. One line of text contains one entry. A country name and its code element are separated by a semicolon (');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AF', 'AFGHANISTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AX', 'ALAND ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AL', 'ALBANIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DZ', 'ALGERIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AS', 'AMERICAN SAMOA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AD', 'ANDORRA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AO', 'ANGOLA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AI', 'ANGUILLA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AQ', 'ANTARCTICA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AG', 'ANTIGUA AND BARBUDA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AR', 'ARGENTINA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AM', 'ARMENIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AW', 'ARUBA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AU', 'AUSTRALIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AT', 'AUSTRIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AZ', 'AZERBAIJAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BS', 'BAHAMAS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BH', 'BAHRAIN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BD', 'BANGLADESH');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BB', 'BARBADOS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BY', 'BELARUS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BE', 'BELGIUM');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BZ', 'BELIZE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BJ', 'BENIN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BM', 'BERMUDA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BT', 'BHUTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BO', 'BOLIVIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BA', 'BOSNIA AND HERZEGOVINA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BW', 'BOTSWANA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BV', 'BOUVET ISLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BR', 'BRAZIL');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IO', 'BRITISH INDIAN OCEAN TERRITORY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BN', 'BRUNEI DARUSSALAM');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BG', 'BULGARIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BF', 'BURKINA FASO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'BI', 'BURUNDI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KH', 'CAMBODIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CM', 'CAMEROON');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CA', 'CANADA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CV', 'CAPE VERDE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KY', 'CAYMAN ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CF', 'CENTRAL AFRICAN REPUBLIC');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TD', 'CHAD');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CL', 'CHILE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CN', 'CHINA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CX', 'CHRISTMAS ISLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CC', 'COCOS (KEELING) ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CO', 'COLOMBIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KM', 'COMOROS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CG', 'CONGO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CD', 'CONGO, THE DEMOCRATIC REPUBLIC OF THE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CK', 'COOK ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CR', 'COSTA RICA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CI', 'COTE D''IVOIRE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HR', 'CROATIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CU', 'CUBA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CY', 'CYPRUS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CZ', 'CZECH REPUBLIC');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DK', 'DENMARK');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DJ', 'DJIBOUTI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DM', 'DOMINICA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DO', 'DOMINICAN REPUBLIC');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'EC', 'ECUADOR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'EG', 'EGYPT');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SV', 'EL SALVADOR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GQ', 'EQUATORIAL GUINEA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ER', 'ERITREA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'EE', 'ESTONIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ET', 'ETHIOPIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FK', 'FALKLAND ISLANDS (MALVINAS)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FO', 'FAROE ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FJ', 'FIJI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FI', 'FINLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FR', 'FRANCE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GF', 'FRENCH GUIANA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PF', 'FRENCH POLYNESIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TF', 'FRENCH SOUTHERN TERRITORIES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GA', 'GABON');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GM', 'GAMBIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GE', 'GEORGIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'DE', 'GERMANY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GH', 'GHANA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GI', 'GIBRALTAR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GR', 'GREECE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GL', 'GREENLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GD', 'GRENADA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GP', 'GUADELOUPE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GU', 'GUAM');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GT', 'GUATEMALA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GN', 'GUINEA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GW', 'GUINEA-BISSAU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GY', 'GUYANA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HT', 'HAITI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HM', 'HEARD ISLAND AND MCDONALD ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VA', 'HOLY SEE (VATICAN CITY STATE)');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HN', 'HONDURAS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HK', 'HONG KONG');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'HU', 'HUNGARY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IS', 'ICELAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IN', 'INDIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ID', 'INDONESIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IR', 'IRAN, ISLAMIC REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IQ', 'IRAQ');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IE', 'IRELAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IL', 'ISRAEL');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'IT', 'ITALY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'JM', 'JAMAICA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'JP', 'JAPAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'JO', 'JORDAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KZ', 'KAZAKHSTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KE', 'KENYA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KI', 'KIRIBATI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KP', 'KOREA, DEMOCRATIC PEOPLE''S REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KR', 'KOREA, REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KW', 'KUWAIT');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KG', 'KYRGYZSTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LA', 'LAO PEOPLE''S DEMOCRATIC REPUBLIC');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LV', 'LATVIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LB', 'LEBANON');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LS', 'LESOTHO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LR', 'LIBERIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LY', 'LIBYAN ARAB JAMAHIRIYA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LI', 'LIECHTENSTEIN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LT', 'LITHUANIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LU', 'LUXEMBOURG');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MO', 'MACAO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MK', 'MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MG', 'MADAGASCAR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MW', 'MALAWI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MY', 'MALAYSIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MV', 'MALDIVES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ML', 'MALI');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MT', 'MALTA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MH', 'MARSHALL ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MQ', 'MARTINIQUE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MR', 'MAURITANIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MU', 'MAURITIUS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'YT', 'MAYOTTE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MX', 'MEXICO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'FM', 'MICRONESIA, FEDERATED STATES OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MD', 'MOLDOVA, REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MC', 'MONACO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MN', 'MONGOLIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MS', 'MONTSERRAT');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MA', 'MOROCCO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MZ', 'MOZAMBIQUE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MM', 'MYANMAR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NA', 'NAMIBIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NR', 'NAURU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NP', 'NEPAL');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NL', 'NETHERLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AN', 'NETHERLANDS ANTILLES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NC', 'NEW CALEDONIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NZ', 'NEW ZEALAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NI', 'NICARAGUA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NE', 'NIGER');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NG', 'NIGERIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NU', 'NIUE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NF', 'NORFOLK ISLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'MP', 'NORTHERN MARIANA ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'NO', 'NORWAY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'OM', 'OMAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PK', 'PAKISTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PW', 'PALAU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PS', 'PALESTINIAN TERRITORY, OCCUPIED');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PA', 'PANAMA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PG', 'PAPUA NEW GUINEA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PY', 'PARAGUAY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PE', 'PERU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PH', 'PHILIPPINES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PN', 'PITCAIRN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PL', 'POLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PT', 'PORTUGAL');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PR', 'PUERTO RICO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'QA', 'QATAR');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'RE', 'REUNION');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'RO', 'ROMANIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'RU', 'RUSSIAN FEDERATION');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'RW', 'RWANDA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SH', 'SAINT HELENA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'KN', 'SAINT KITTS AND NEVIS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LC', 'SAINT LUCIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'PM', 'SAINT PIERRE AND MIQUELON');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VC', 'SAINT VINCENT AND THE GRENADINES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'WS', 'SAMOA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SM', 'SAN MARINO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ST', 'SAO TOME AND PRINCIPE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SA', 'SAUDI ARABIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SN', 'SENEGAL');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CS', 'SERBIA AND MONTENEGRO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SC', 'SEYCHELLES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SL', 'SIERRA LEONE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SG', 'SINGAPORE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SK', 'SLOVAKIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SI', 'SLOVENIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SB', 'SOLOMON ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SO', 'SOMALIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ZA', 'SOUTH AFRICA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GS', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ES', 'SPAIN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'LK', 'SRI LANKA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SD', 'SUDAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SR', 'SURINAME');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SJ', 'SVALBARD AND JAN MAYEN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SZ', 'SWAZILAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SE', 'SWEDEN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'CH', 'SWITZERLAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'SY', 'SYRIAN ARAB REPUBLIC');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TW', 'TAIWAN, PROVINCE OF CHINA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TJ', 'TAJIKISTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TZ', 'TANZANIA, UNITED REPUBLIC OF');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TH', 'THAILAND');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TL', 'TIMOR-LESTE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TG', 'TOGO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TK', 'TOKELAU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TO', 'TONGA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TT', 'TRINIDAD AND TOBAGO');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TN', 'TUNISIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TR', 'TURKEY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TM', 'TURKMENISTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TC', 'TURKS AND CAICOS ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'TV', 'TUVALU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'UG', 'UGANDA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'UA', 'UKRAINE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'AE', 'UNITED ARAB EMIRATES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'GB', 'UNITED KINGDOM');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'US', 'UNITED STATES');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'UM', 'UNITED STATES MINOR OUTLYING ISLANDS');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'UY', 'URUGUAY');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'UZ', 'UZBEKISTAN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VU', 'VANUATU');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VE', 'VENEZUELA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VN', 'VIET NAM');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VG', 'VIRGIN ISLANDS, BRITISH');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'VI', 'VIRGIN ISLANDS, U.S.');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'WF', 'WALLIS AND FUTUNA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'EH', 'WESTERN SAHARA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'YE', 'YEMEN');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ZM', 'ZAMBIA');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (4, 'ZW', 'ZIMBABWE');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'All', 'All');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Business', 'Business');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Caregivers', 'Caregivers');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Children', 'Children');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Community groups', 'Community groups');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Employees', 'Employees');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Employers', 'Employers');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Jobseekers', 'Jobseekers');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'M&#257;ori', 'M&#257;ori');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Men', 'Men');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Migrants', 'Migrants');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Older people', 'Older people');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Pacific Islanders', 'Pacific Islanders');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Parents', 'Parents');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'People with disabilities', 'People with disabilities');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Rural community', 'Rural community');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Students', 'Students');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Visitors to New Zealand', 'Visitors to New Zealand');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Women', 'Women');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (7, 'Youth', 'Youth');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (50, 'Agency', 'Agency');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (50, 'Document', 'Document');
INSERT INTO ax_enc_value (enc_scheme_id, enc_value, enc_label) VALUES (50, 'Service', 'Service');



-- Name: ax_enc_qualifier;
--
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'personalName', 'Personal name', 'The name of a person', NULL, NULL, 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'corporateName', 'Corporate Name', 'The name of an organisation', NULL, NULL, 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'Contact', 'Contact', 'Contact details for the agent. Can include an official title. Typically includes a phone number.', NULL, NULL, 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'Address', 'Address', 'Street or postal address for the agent.', NULL, NULL, 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'Email', 'Email', 'Email address for the agent.', NULL, NULL, 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'Sector', 'Sector', 'Indicates whether the creator is from the government or non-government sector: ''government'' and ''non-government'' are the only allowable values. The default value is ''government''.', 'government', 'government,non-government', 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'corporateName', 'corporateName', 'The name of an organisation. Use the full proper name of the organisation making the resource available. If it has a relevant common use name append this in brackets, e.g. Ministry of Social Development (WINZ). If you are using both the English and Maori name of an agency enter them with ''space hyphen space'' in between them.', '', '', 1);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'personalName', 'personalName', 'The name of a person. The name of a person making the resource available. Format is last name, comma, space, first name e.g. Crump, Barry. If you are not sure, then enter the name as it is shown on the resource itself. This component is not recommended because of the maintenance requirement of changing this information as people change jobs.', '', '', 2);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'jurisdiction', 'jurisdiction', 'The legal jurisdiction. Use the full proper name of the legal jurisdiction for which the resource applies. Make sure that the jurisdiction chosen is correct for the service or document as it is not necessarily the same as the agency''s.', '', '', 3);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'contact', 'contact', 'Contact details. For organisations or persons making the resource available.
Can include an official title or defined organisational role. The following standard phrase should be used, as appropriate:
"Contact your nearest [organisation name] approved agent"', '', '', 4);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'phone', 'phone', 'Telephone system numbers through which requests for this resource should be directed.

These components all have the same format. Use the international area code only if the service is likely to be accessed from overseas, otherwise use the local area code. The format is (phone) +64 4 474 3000 or (phone) 04 474 3000.

Do not use dashes, hyphens or brackets within phone numbers. You can have text after a number to provide information e.g. "(phone) 04 474 3000 - Past hotline" or "(phone) 0800 STOP SMOKING".

If you have a 0800 word number then you should include the actual number in brackets e.g. (phone) 0800 STOP SMOKING (0800 123123).', '', '', 5);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'mobilePhone', 'mobilePhone', 'As for ''phone''.', '', '', 6);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'fax', 'fax', 'As for ''phone''.', '', '', 7);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'website', 'website', 'World-Wide-Web page containing the resource or providing an access channel.
Enter the URI in full, i.e. you must include the part before the colon e.g. http://', '', '', 8);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'email', 'email', 'Email address. This should be a generic e-mail address, e.g. info@... not a personal e-mail address.', '', '', 9);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'addressPhysical', 'addressPhysical', 'Street or postal. Can include a post code. Use a comma followed by a space to separate the parts (lines) of the address. Post Office Box should be written as ''PO Box''. Omit address if the channel being described is a website or call centre.', '', '', 10);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'addressPostal', 'addressPostal', 'Street or postal. Can include a post code. Use a comma followed by a space to separate the parts (lines) of the address. Post Office Box should be written as ''PO Box''. Omit address if the channel being described is a website or call centre.', '', '', 11);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'hours', 'hours', 'Hours during which service can be accessed at the locations identified in address components.

Information should be written in full e.g. Monday - Friday, 9.00 am to 5.00 pm. Do not use abbreviations such as Mon - Fri.
This component would not normally be used for any online resource. For seasonal Availability use Date.

The following standard phrase should be used, as appropriate: (excluding public holidays)', '', '', 12);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (6, 'cost', 'cost', 'Cost of obtaining the resource. Start with "$" and any leading zeros required, e.g. $0.25. Specify currency only when the service is accessed from overseas, e.g. NZ$55.00.
You can also specify whether the price includes or excludes postage, or GST if this is appropriate (e.g. your audience is overseas).

If the pricing schedule is complex - state this and refer to where the information can be obtained.', '', '', 13);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (11, 'Jurisdiction', 'Jurisdiction', 'The legal jurisdiction of the agent eg: NSW
For other values, see the AGLS Jurisdiction controlled vocabulary', '', 'Commonwealth of Australia,Australian Antarctic Territory,Indian Ocean Territories,New South Wales,Northern Territory,Queensland,South Australia,Tasmania,Victoria,Western Australia,Other', 999);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'personalName', 'personalName', 'The name of a person making the resource available', '', '', 1);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'corporateName', 'corporateName', 'The name of an organisation making the resource available', '', '', 2);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'jurisdiction', 'jurisdiction', 'The legal jurisdiction of the agent eg NSW
For other values, see the AGLS Jurisdiction scheme (Part 2 Section 7.8 AGLS Jurisdiction scheme).', '', '', 3);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'contact', 'contact', 'Contact details for the agent making the resource available. Can include an official title. Typically includes a phone number.', '', '', 4);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'address', 'address', 'Street or postal address for the agent making the resource available.', '', '', 5);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'email', 'email', 'Email address for the agent making the resource available.', '', '', 6);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'hours', 'hours', 'Hours during which the resource can be accessed at the locations identified in address components', '', '', 7);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'cost', 'cost', 'Cost of obtaining the resource', '', '', 8);
INSERT INTO ax_enc_qualifier (enc_scheme_id, qual_name, qual_label, comments, default_value, list_of_values, display_order) VALUES (24, 'postcode', 'postcode', 'Australian postcode(s) where the resource is available. Typically used in describing availability of services.', '', '', 9);



-- Name: ax_meta_element_set;
--
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 22, 17, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 16, 16, 'o', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 42, 20, 'o', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 21, 22, 'o', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 24, 37, 'o', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 27, 40, 'o', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 14, 4, 'm', 'If the resource is a text document, use the full title as it appears on the title page. If the document has another common usage name, use the "alternative" refinement.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 17, 5, 'o', 'This qualifier could include abbreviations, translations and acronyms by which a resource may be known.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 41, 47, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 40, 48, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 39, 49, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 20, 14, 'o', 'Date created vs. date modified. It is up to individual agencies to decide when a change is a modification to a resource, and when changes to a resource are so significant that they actually create a new resource - which will require its own set of metadata.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 25, 15, 'o', 'Date created vs. date modified. It is up to individual agencies to decide when a change is a modification to a resource, and when changes to a resource are so significant that they actually create a new resource - which will require its own set of metadata.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 29, 16, 'o', 'Typically, a date the resource becomes valid or ceases to be valid, or the date range for which the resource is valid.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 5, 19, 'r', 'Description element contains text describing a resource. It can contain abstracts if these are available. It can also contain:

- a prose description of the content of the resource

- a description of the nature of the service or objects, or

- thumbnail images or other electronic samples of content.

When writing a description, make it concise and clear, and use non-technical language.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 44, 21, 'r', 'The element is useful to indicate the specific legal mandate that requires the resource being described to be created or provided to the public. The content of this element will usually be a reference to a specific Act, Regulation or Case, but may be a URI pointing to the legal instrument in question.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 45, 22, 'o', 'A reference to a specific Act of Parliament which requires the creation or provision of the resource.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 19, 18, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 46, 23, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 59, 24, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 2, 27, 'o', 'Coverage will typically include spatial location (a place name or geographic coordinates), temporal period (date, or date range, or a period label) or jurisdiction (such as a named administrative entity). Recommended best practice is to select names from a controlled vocabulary (for example, the New Zealand Geographic Place Names Database maintained by LINZ).', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 54, 28, 'o', 'Jurisdiction is a description of the territory over which a particular government exercises its authority or a particular business transacts its operations, to which the resource content is applicable.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 6, 31, 'o', 'Typically, Format may include the media-type or dimensions of the resource. Format may be used to determine the software, hardware or other equipment needed to display or operate the resource. Examples of dimensions include size and duration. Recommended best practice is to select a value from a controlled vocabulary (for example, the list of Internet Media Types (IMT) defining computer media formats). This element can also be used to describe the size of electronic resources in bytes by using the "extent" refinement.

The encoding scheme [ISO] can also be used to indicate that the format of the resource is defined by an ISO standard. The element value is the ISO standard''s number, e.g. the specification for 120mm CD-ROM discs: [ISO] 10149:1995.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 21, 32, 'o', 'The extent qualifier allows the description of the physical dimensions, file size or duration of the resource.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 12, 50, 'o', 'It is recommended that Source should not be used. The element is included in the NZGLS standard to support interoperability with the DCMES. The present resource may be derived from the Source resource in whole or in part.

Consider whether creation of metadata for the source record, or the description of a relationship (such as isBasedOn) may be better than using Source.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 35, 35, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 34, 36, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 9, 9, 'o', 'Examples of a Publisher include a person, an organisation, or a service. Typically, the name of a Publisher should be used to indicate the entity.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 11, 11, 'o', 'Typically, a Rights element will contain a rights management statement for the resource, or reference a service providing such information. Rights information often encompasses Intellectual Property Rights (IPR), Copyright, and various Property Rights. If the Rights element is absent, no assumptions can be made about the status of these and other rights with respect to the resource.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 12, 12, 'o', 'The present resource may be derived from the Source resource in whole or in part. Recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 13, 13, 'o', 'Typically, a Subject will be expressed as keywords, key phrases or classification codes that describe a topic of the resource. Recommended best practice is to select a value from a controlled vocabulary or formal classification scheme.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 17, 17, 'o', 'This qualifier can include Title abbreviations as well as translations.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 18, 18, 'o', 'A class of entity may be determined by the creator or the publisher or by a third party.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 23, 36, 'o', 'The audiences for a resource are of two basic classes: (1) an ultimate beneficiary of the resource, and (2) frequently, an entity that mediates access to the resource. The mediator element refinement represents the second of these two classes.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 47, 25, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 10, 34, 'o', '.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 39, 37, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 38, 38, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 41, 39, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 40, 40, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 33, 41, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 32, 42, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 37, 43, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 36, 44, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 31, 45, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 30, 46, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 58, 47, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 57, 48, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 10, 10, 'o', 'Recommended best practice is to reference the resource by means of a string or number conforming to a formal identification system.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 14, 14, 'o', 'Typically, a Title will be a name by which the resource is formally known.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 14, 2, 'm', NULL, NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 4, 3, 'm', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 20, 4, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 25, 5, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 22, 6, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 29, 7, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 7, 10, 'c', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 13, 11, 'c', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 43, 12, 'c', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 15, 13, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 1, 26, 'o', 'Typically, a contributor will be an entity that has played an important but secondary role in creating the content of the resource and is not specified in the creator element.

If a structured value is to be given (including for example name and address information) it is recommended that the NZGLSAgent Encoding Scheme be used. Alternatively, a link to a directory, authority file or similar set of identity information may be provided.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 18, 14, 'o', 'Use of the Audience element supports direct targeting of specific community sectors such as families, youth, rural and seniors, at which the resource is targeted. Providing this level of granularity enables the extent of resources being returned from a search process to be restricted to the area of relevance, or a particular portal. It also enables increased specificity of resources for the user.

Within the AGLS metadata standard, the default value is ''all'' which means that if the element is not included in the metadata record, the search engine will assume that the resource is relevant to all audience groups. The element should be used when the target audience is not ''all''.

For example, use of the value ''rural'' in Audience in a resource indicates that this resource or service is particularly applicable to rural or regional Australia. A resource relevant to rural families would have both ''families'' and ''rural'' in the AGLS.Audience element.

The preferred audience controlled vocabulary for NSW agencies is the AGLS Audience scheme see AGLS Audience scheme in Part 2 Section 7.1 AGLS Audience Scheme. Other audience schemes such as Australian New Zealand Standard Industrial Classification (ANZSIC), Education Network Australia (EdNA), Business Entry Point (BEP) (currently under review), age group, equal employment opportunity (EEO) and the Australian Standard Classification of Occupations (ASCO) are also available for use with certain resources.', 'all', 15, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 2, 16, 'o', 'Where programs and services are being delivered on a state level, the full name of each state where these are being delivered should be included (eg NSW). If the programs or services are being delivered to specific areas of a state, then the local government area names should be used (see Local Government Directory).

When describing:
* General material on the legislative and political affairs of a specific legally defined geographic area, use the jurisdiction qualifier.
* General geographic, economic, social or cultural affairs having a strong focus on place, to allow for a consistent retrieval within a specified geographic context, use the spatial qualifier.
* Time-related characteristics of the resource, use the temporal qualifier.', 'NSW', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 26, 17, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 28, 18, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 55, 19, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 5, 20, 'o', '', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 6, 21, 'o', 'The Format element describes the nature of a resource, or the communications channel (or channels) through which a service is delivered. For services that are not accessible online use ''Physical''. This could be further refined with the terms ''Call Center'' or ''Shopfront''. Values can be selected for electronic resources from the Internet Media Types (IMT) list of terms,', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 21, 22, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 24, 23, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 8, 24, 'o', 'Used to describe the language of the content of the resource. The default value is English (''en'') or Australian English (''en-AU'') so resources in any other language must be described using this element. Values should be constructed according to the World Wide Web language description standard, ''IETF FC 3066 Tags for the Identification of Language'' which uses a combination of two ISO standards (ISO639 for language codes and ISO 3166 for country codes). RFC 3066 enables the use of ISO639-2/T three-letter codes for languages that are not described with a two-letter code in ISO639-1.', 'en', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 44, 25, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 45, 26, 'o', 'Specific State or Federal Act which requires creation or provision of the resource.', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 46, 27, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 47, 28, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 54, 31, 'o', 'The legal jurisdiction of the agent eg NSW', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 48, 32, 'o', 'Specifies the actual type of resource being described. There are only three values for this qualifier: ''service'', ''document'', or ''agency''.', 'document', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 49, 33, 'o', 'Specifies the level of aggregation of the resource being described. There are only two values possible: ''item'' or ''collection''.', 'item', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 50, 34, 'o', 'Describes the form of the resource where category = document (document is used in its widest sense).', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 51, 35, 'o', 'Describes the type of service being offered where category = service.', NULL, NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 10, 36, 'o', 'Relation element identifies a relationship that exists between the resource being described and another resource, and also specifies the type of relationship between the two resources. This relationship is expressed as an element refinement (eg. DC.Relation.hasVersion). Typically, the value for this element is a formal identifier (eg. a URI, an ISBN or ISSN).', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 33, 37, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 32, 38, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 35, 39, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 34, 40, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 31, 41, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 30, 42, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 36, 43, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 37, 44, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 57, 45, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 58, 46, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 38, 50, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 11, 29, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 12, 30, 'o', '', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 43, 2, 'm', 'Functions are the major units of activity that organisations pursue in order to meet their mission and goals. They are defined in the Australian Records Management Standard [AS 4390 : 1996] as ''the largest unit of business activity in an organisation...''.

Recommended best practice is to select a value from a controlled vocabulary or formal classification scheme. Resources being described within the NZ Government should use the Functions of New Zealand (FONZ) thesaurus. Use of this encoding scheme is mandatory for metadata prepared for use by the NZ Government Portal.', '', NULL, NULL, true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 48, 7, 'm', 'The value for this qualifier must be one of service, document, or agency.

Service: used when describing a service directly, not a document about a service.

Document: used for all resources which are not services or agencies, even if they are not traditional "documents" - for example, a sculpture.

Agency: used to describe an organisation.', '', NULL, 'service,document,agency', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 49, 8, 'm', 'There are only two values possible for this qualifier, either item or collection.', '', NULL, 'item,collection', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 1, 1, 'o', 'Examples of a Contributor include a person, an organisation, or a service. Typically, the name of a Contributor should be used to indicate the entity.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 2, 2, 'o', 'Coverage will typically include spatial location (a place name or geographic coordinates), temporal period (a period label, date, or date range) or jurisdiction (such as a named administrative entity). Recommended best practice is to select a value from a controlled vocabulary (for example, the Thesaurus of Geographic Names [TGN]) and that, where appropriate, named places or time periods be used in preference to numeric identifiers such as sets of coordinates or date ranges.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 3, 3, 'o', 'Examples of a Creator include a person, an organisation, or a service. Typically, the name of a Creator should be used to indicate the entity.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 4, 4, 'o', 'Typically, Date will be associated with the creation or availability of the resource. Recommended best practice for encoding the date value is defined in a profile of ISO 8601 [W3CDTF] and follows the YYYY-MM-DD format.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 5, 5, 'o', 'Description may include but is not limited to: an abstract, table of contents, reference to a graphical representation of content or a free-text account of the content.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 6, 6, 'o', 'Typically, Format may include the media-type or dimensions of the resource. Format may be used to determine the software, hardware or other equipment needed to display or operate the resource. Examples of dimensions include size and duration. Recommended best practice is to select a value from a controlled vocabulary (for example, the list of Internet Media Types [MIME] defining computer media formats).', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 7, 7, 'o', 'Recommended best practice is to identify the resource by means of a string or number conforming to a formal identification system. Example formal identification systems include the Uniform Resource Identifier (URI) (including the Uniform Resource Locator (URL)), the Digital Object Identifier (DOI) and the International Standard Book Number (ISBN).', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 8, 8, 'o', 'Recommended best practice is to use RFC 3066 [RFC3066], which, in conjunction with ISO 639 [ISO639], defines two- and three-letter primary language tags with optional subtags. Examples include "en" or "eng" for English, "akk" for Akkadian, and "en-GB" for English used in the United Kingdom.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 15, 15, 'o', 'Type includes terms describing general categories, functions, genres, or aggregation levels for content. Recommended best practice is to select a value from a controlled vocabulary (for example, the DCMI Type Vocabulary [DCMITYPE]). To describe the physical or digital manifestation of the resource, use the Format element.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 19, 19, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 20, 21, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 22, 35, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 25, 38, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 26, 39, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 28, 41, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 29, 42, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 3, 1, 'm', '', '', 11, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 9, 8, 'c', '', '', 11, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 1, 15, 'o', '', '', 11, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('AGLS', 56, 9, 'c', '', '', 24, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 34, 23, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 30, 24, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 32, 25, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 36, 26, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 38, 27, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 40, 28, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 35, 29, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 31, 30, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 33, 31, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 37, 32, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 39, 33, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('Dublin Core', 41, 34, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 15, 6, 'o', 'Type includes terms describing general categories, genres, or aggregation levels for content. NZGLS metadata must include a value for the Category refinement of Type (i.e. either document, service or agency).', '', 50, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 18, 12, 'r', 'A class of entity may be determined by the creator, the publisher, or a third party, and typically represents the target audience of the resource. Types of audiences commonly used in this element include particular industry sectors, education levels, skill levels, occupations, and EEO (Equal Employment Opportunities) categories.', '', 7, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 56, 9, 'c', 'Conditional - mandatory when adding an agency, service, or off-line document; optional when adding an on-line document.

The Availability element is primarily used for non-electronic resources to provide information on how to obtain physical access to the resource.

The Availability element should be repeated to show multiple access points - for example, a service where someone could pay a bill at two separate organisations.

Generally, full details of how any service can be obtained, or contact information, should be provided.

If a structured value is to be given (including for example name and address information) it is recommended that the NZGLSAgent Encoding scheme be used.', '', 6, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 28, 30, 'o', 'The refinement "temporal" refers to time periods that are covered by or discussed in the content of resource. Time periods will generally be best expressed as date ranges, although named periods may be appropriate. The recommended encoding schemes for dates and date ranges are noted in the section on Date.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 26, 29, 'o', 'Spatial (geographic) coverage or locations or areas covered in the content of a resource. Use of the New Zealand Geographic Place Names Database (LINZ) may be appropriate. In some cases the DCMI Box Encoding Scheme may be suitable. Refer: http://dublincore.org/documents/dcmi-box/index.shtml', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 3, 1, 'm', 'If a structured value is to be given (including for example name and address information) it is recommended that the NZGLSAgent Encoding scheme be used.', '', 6, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 4, 13, 'r', 'Typically, Date will be associated with the creation or availability of the resource. Recommended best practice for encoding the date value is defined in a W3C profile [W3CDTF] of ISO 8601 and follows the YYYY-MM-DD format. Where a date range with an unknown start or end date or a named period is being described, best practice is to use the DCMIPeriod encoding scheme.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 24, 33, 'o', '', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 7, 10, 'c', 'Conditional - mandatory for online resources, otherwise recommended where available. Not used for services.Recommended best practice is to identify the resource by means of a string or number conforming to a formal identification system. Examples of formal identification systems include the Uniform Resource Identifier (URI) (including the Uniform Resource Locator (URL)), the Digital Object Identifier (DOI) and the International Standard Book Number (ISBN).', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 8, 20, 'r', 'It is recommended that Language be used. When Language is used, it is strongly recommended (mandatory within the New Zealand government) that the values of the Language element be defined by RFC 3066 which includes a two (or three) letter language code (taken from the ISO 639 standard), followed when necessary, by a two-letter country code (taken from the ISO 3166 standard). For example, ''en'' for English, ''mi'' for Maori, or ''en-uk'' for colloquial English used in the United Kingdom.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 9, 11, 'c', 'Conditional - Mandatory for document resources.

This field is often the name of the organisation that owns or controls or publishes the resource. It is not recommended that this element be used for the name of the entity which merely acts as the host for a website.

The Publisher element is not generally used when describing services, since there is no concept of "publisher" for physical services as there is for information resources. The closest concept is the service provider, which fits better under the Availability element.

If a structured value is to be given (including for example name and address information) it is recommended that the NZGLSAgent Encoding Scheme be used. Alternatively, a link to a directory, authority file or similar set of identity information may be provided.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 11, 49, 'o', 'Typically, the Rights element will contain a rights management statement for the resource, or refer to a service providing such information. Rights information often encompasses Intellectual Property Rights (IPR), Copyright, and various Property Rights. For documents, the typical value within the NZ Government would be ''Crown Copyright New Zealand, yyyy''. If the Rights element is absent, no assumptions can be made about the status of these and other rights with respect to the resource.

Although the NZGLS metadata describing the resource might be freely available, the actual resource or service may have some restrictions on it regarding access. If this is the case, then the Rights element should be used to describe access terms and conditions. Note that there is no way of enforcing the access policy through the metadata, and agencies will need some kind of external mechanism to do this.

If a resource or service is freely available without any restrictions or conditions on usage, then this element should be left blank.

This element should only be used for intellectual property rights or restrictions on access to a resource or service. Details on where and how to get at the resource or service should be recorded in the Availability element, not here. The Rights element deals with who can legitimately have access to a resource or service. Availability deals with how to obtain access.', '', NULL, '', true);
INSERT INTO ax_meta_element_set (schema_name, element_id, display_order, obligation, comments, default_value, preferred_enc_scheme, list_of_values, enabled) VALUES ('NZGLS', 13, 3, 'm', 'The Subject element should tell the searcher what the resource is about. Typically, a subject will be expressed as keywords, key phrases or classification codes that describe a topic of the resource. Searchers can use the Subject element to find resources relating to a particular topic. For example, to find all resources related to "pests".

Recommended best practice is to select a value from a controlled vocabulary or formal classification scheme. Resources being described within the NZ Government should use the Subjects of New Zealand (SONZ) thesaurus. Use of this encoding scheme is mandatory for metadata prepared for use by the NZ Government Portal.', '', 9, '', true);



-- Name: ax_element_set_enc;
--
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 54, 25);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 4, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 20, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 25, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 22, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 29, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 15, 16);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 15, 26);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 50, 16);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 51, 26);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 43, 27);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 43, 28);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 31);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 32);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 29);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 34);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 33);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 13, 30);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 7, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 26, 19);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 28, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 28, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 55, 37);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 18, 15);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 18, 35);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 18, 36);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 12);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 19);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 25);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 29);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 2, 37);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 8, 3);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 6, 31);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 6, 1);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 44, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 45, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 46, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 47, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 33, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 33, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 33, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 32, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 32, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 32, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 35, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 35, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 35, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 34, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 34, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 34, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 31, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 31, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 31, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 30, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 30, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 30, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 36, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 36, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 36, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 37, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 37, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 37, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 57, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 57, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 57, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 58, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 58, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 58, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 41, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 41, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 41, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 40, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 40, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 40, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 39, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 39, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 39, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 38, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 38, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 38, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 10, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 10, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 10, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 11, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 12, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 12, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 12, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 43, 5);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 48, 41);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 49, 41);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 2, 19);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 4, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 6, 1);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 7, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 7, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 7, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 7, 44);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 8, 38);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 8, 3);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 15, 23);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 19, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 19, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 20, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 10, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 10, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 10, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 22, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 25, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 26, 19);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 28, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 28, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 29, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('Dublin Core', 29, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 3, 10);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 3, 11);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 9, 10);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 9, 11);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 1, 10);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 1, 11);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 56, 10);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('AGLS', 56, 24);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 15, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 15, 42);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 15, 43);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 15, 50);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 18, 36);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 18, 7);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 18, 51);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 56, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 56, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 56, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 1, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 1, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 54, 8);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 28, 29);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 28, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 55);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 8);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 52);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 53);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 54);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 26, 19);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 3, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 3, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 4, 13);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 4, 22);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 24, 1);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 44);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 40);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 56);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 39);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 7, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 8, 49);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 8, 38);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 8, 3);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 9, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 9, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 11, 14);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 13, 31);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 13, 29);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 13, 34);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 13, 6);
INSERT INTO ax_element_set_enc (schema_name, element_id, enc_scheme_id) VALUES ('NZGLS', 13, 9);
