----------------------------------------------------------------------------
-- Axyl Database Patch
-- Upgrades v2.1.0 to v2.1.7
--
-- NOTE: This patch is a generic 'catch-all' which is applied to all 
-- Axyl databases pre 2.1.7. As such it is highly likely that it will
-- fail in numerous places, due to the target database being of a
-- vintage where some or all entities are already created. You should
-- therefore bear this in mind, and not get too worried by any errors
-- which are reported - just adopt an iterative approach.
--
-- Once you have applied this patch, you should then compare the result
-- with the latest 'axyl_core.sql' by using the Axyl 'dbdiff.php'
-- script. That should then lead you towards full compatibility.
--
----------------------------------------------------------------------------

-- COLUMNS to DROP/RECREATE on TABLE ax_story
alter table "ax_story" drop column written;
alter table "ax_story" drop column title;
alter table "ax_story" drop column category;
alter table "ax_story" drop column subcategory;
alter table "ax_story" drop column source;
alter table "ax_story" drop column slug;
alter table "ax_story" drop column precis;
alter table "ax_story" drop column story_body;
alter table "ax_story" drop column story_path;
alter table "ax_story" drop column word_count;
alter table "ax_story" drop column old_story_id;
alter table "ax_story" drop column purged;
alter table "ax_story" drop column remote_story_url;

-- ADDING NEW COLUMN cache
alter table ax_block
  add column cache text;

-- ADDING NEW COLUMN cache_updated
alter table ax_block
  add column cache_updated timestamptz;

-- CREATING NEW TABLE ax_content_location
create table ax_content_location (
  "location_id" int4 not null,
  "location_name" text not null,
  "location_desc" text,
  "enabled" bool not null default true
);

-- CREATING NEW TABLE ax_control
create table ax_control (
  "app_prefix" text,
  "site_axyl_version" text,
  "site_docroot" text
);

-- CREATING NEW TABLE ax_element_set_enc
create table ax_element_set_enc (
  "schema_name" text not null,
  "element_id" int4 not null,
  "enc_scheme_id" int4 not null
);

-- CREATING NEW TABLE ax_enc_qualifier
create table ax_enc_qualifier (
  "enc_scheme_id" int4 not null,
  "qual_name" text not null,
  "qual_label" text,
  "comments" text,
  "default_value" text,
  "list_of_values" text,
  "display_order" int4 not null default 999
);

-- CREATING NEW TABLE ax_enc_scheme
create table ax_enc_scheme (
  "enc_scheme_id" int4 not null,
  "enc_scheme_name" text not null,
  "label" text,
  "tag_name" text not null,
  "description" text,
  "datasrc_uri" text,
  "reference_url" text,
  "enabled" bool not null default true
);

-- CREATING NEW TABLE ax_enc_value
create table ax_enc_value (
  "enc_scheme_id" int4 not null,
  "enc_value" text not null,
  "enc_label" text
);

-- ADDING NEW COLUMN cache
alter table ax_layout
  add column cache text;

-- ADDING NEW COLUMN cache_updated
alter table ax_layout
  add column cache_updated timestamptz;

-- ADDING NEW COLUMN last_modified
alter table ax_layout
  add column last_modified timestamptz;
alter table "ax_layout" alter column "last_modified" set default CURRENT_TIMESTAMP;
update ax_layout set last_modified = now();
alter table ax_layout
  alter column last_modified set not null;

-- CREATING NEW TABLE ax_layout_metadata
create table ax_layout_metadata (
  "layout_id" int4 not null,
  "element_id" int4 not null,
  "schema_name" text not null,
  "meta_tag_value" text,
  "enc_scheme_id" int4,
  "linked_uri" bool not null default false,
  "language" text
);

-- CREATING NEW TABLE ax_layout_set_group
create table ax_layout_set_group (
  "layout_name" text not null,
  "cm_privilege" text not null,
  "group_id" int4 not null
);

-- ADDING NEW COLUMN target
alter table ax_menuoption
  add column target text;

-- CREATING NEW TABLE ax_meta_element
create table ax_meta_element (
  "element_id" int4 not null,
  "label" text,
  "tag_name" text not null,
  "definition" text,
  "parent_element" int4,
  "parent_schema" text,
  "enabled" bool not null default true
);

-- CREATING NEW TABLE ax_meta_element_set
create table ax_meta_element_set (
  "schema_name" text not null,
  "element_id" int4 not null,
  "preferred_enc_scheme" int4,
  "comments" text,
  "obligation" text not null default 'o'::text,
  "default_value" text,
  "list_of_values" text,
  "display_order" int4 not null default 999,
  "enabled" bool not null default true
);

-- CREATING NEW TABLE ax_meta_schema
create table ax_meta_schema (
  "schema_name" text not null,
  "description" text,
  "namespace" text,
  "namespace_uri" text
);

-- CREATING NEW TABLE ax_microsite
create table ax_microsite (
  "microsite_name" text not null,
  "menu_id" int4,
  "microsite_desc" text,
  "microsite_domain" text,
  "css" text,
  "css_ie" text,
  "css_ns" text,
  "req_microsite_publish" bool not null default false,
  "req_microsite_remove" bool not null default false,
  "currently_installed" bool not null default false,
  "last_installed" timestamp,
  "last_modified" timestamptz not null default ('now'::text)::timestamp(6) with time zone
);

-- CREATING NEW TABLE ax_microsite_media
create table ax_microsite_media (
  "microsite_name" text not null,
  "cat_id" int4 not null
);

-- CREATING NEW TABLE ax_microsite_page
create table ax_microsite_page (
  "microsite_page_id" int4 not null,
  "microsite_name" text not null,
  "page_id" int4,
  "menuoption_id" int4,
  "microsite_template_id" int4,
  "page_title" text not null,
  "corepage" bool not null default false,
  "microsite_homepage" bool not null default false,
  "menuoption_label" text not null,
  "display_order" int4 not null default 999,
  "cache_seconds" int4 not null default 0,
  "enabled" bool not null default true
);

-- CREATING NEW TABLE ax_microsite_page_plugin
create table ax_microsite_page_plugin (
  "plugin_id" int4 not null,
  "microsite_page_id" int4 not null,
  "plugin_pattern" text not null,
  "plugin_content" text not null
);

-- CREATING NEW TABLE ax_microsite_story
create table ax_microsite_story (
  "microsite_name" text not null,
  "story_id" int4 not null
);

-- CREATING NEW TABLE ax_microsite_template
create table ax_microsite_template (
  "microsite_template_id" int4 not null,
  "microsite_name" text not null,
  "template_name" text not null,
  "template_type" text not null,
  "template_content" text
);

-- CREATING NEW TABLE ax_plugin_area
create table ax_plugin_area (
  "plugin_pattern" text not null,
  "plugin_desc" text
);

-- CREATING NEW TABLE ax_plugin_content
create table ax_plugin_content (
  "plugin_content" text not null,
  "plugin_content_desc" text not null,
  "generator" text not null,
  "generator_type" text not null default 'defer'::text,
  "replace_content" bool not null default false
);

-- CREATING NEW TABLE ax_site_meta_element
create table ax_site_meta_element (
  "element_id" int4 not null,
  "schema_name" text not null,
  "label" text,
  "description" text,
  "indexed" bool not null default false,
  "searchable" bool not null default false,
  "obligation" text not null default 'o'::text,
  "default_value" text,
  "list_of_values" text,
  "display_order" int4 not null default 999,
  "enabled" bool default true
);

-- CREATING NEW TABLE ax_sitepage_group
create table ax_sitepage_group (
  "group_id" int4 not null,
  "page_id" int4 not null
);

-- ADDING NEW COLUMN lang_id
alter table ax_story
  add column lang_id int4;
alter table "ax_story" alter column "lang_id" set default 0;
update ax_story set lang_id = 0;
alter table ax_story
  alter column lang_id set not null;

-- ADDING NEW COLUMN category_id
alter table ax_story
  add column category_id int4;

-- ADDING NEW COLUMN story_author
alter table ax_story
  add column story_author text;

-- ADDING NEW COLUMN story_icon
alter table ax_story
  add column story_icon int4;

-- ADDING NEW COLUMN story_icon_url
alter table ax_story
  add column story_icon_url text;

-- ADDING NEW COLUMN story_headline
alter table ax_story
  add column story_headline text;

-- ADDING NEW COLUMN story_precis
alter table ax_story
  add column story_precis text;

-- ADDING NEW COLUMN story_content
alter table ax_story
  add column story_content text;

-- ADDING NEW COLUMN story_url
alter table ax_story
  add column story_url text;

-- ADDING NEW COLUMN story_date
alter table ax_story
  add column story_date timestamptz;
alter table "ax_story" alter column "story_date" set default CURRENT_TIMESTAMP;
alter table ax_story
  alter column story_date set not null;

-- ADDING NEW COLUMN expiry_date
alter table ax_story
  add column expiry_date timestamptz;

-- ADDING NEW COLUMN visible
alter table ax_story
  add column visible bool;
alter table "ax_story" alter column "visible" set default true;
update ax_story set visible = true;
alter table ax_story
  alter column visible set not null;

-- CREATING NEW TABLE ax_story_category
create table ax_story_category (
  "category_id" int4 not null,
  "category_desc" text not null,
  "has_media" bool not null default false,
  "has_precis" bool not null default true,
  "has_expiry" bool not null default false,
  "has_multilang" bool not null default true,
  "has_multimedia" bool not null default false
);

-- CREATING NEW TABLE ax_story_category_locs
create table ax_story_category_locs (
  "category_id" int4 not null,
  "location_id" int4 not null
);

-- CREATING NEW TABLE ax_story_location
create table ax_story_location (
  "story_id" int4 not null,
  "location_id" int4 not null,
  "display_order" int4 not null default 999
);

-- CREATING NEW TABLE ax_story_media
create table ax_story_media (
  "story_id" int4 not null,
  "cat_id" int4 not null,
  "caption" text,
  "width" int4 not null default 0,
  "height" int4 not null default 0,
  "justify" text not null default ''::text,
  "display_order" int4 not null default 999
);

-- CREATING NEW TABLE ax_story_translation
create table ax_story_translation (
  "story_id" int4 not null,
  "translated_story_id" int4 not null
);

-- DROPPING NON-EXISTENT CONSTRAINT ckc_width_ax_menuo
alter table ax_menuoption
 drop constraint ckc_width_ax_menuo restrict;

-- DROPPING NON-EXISTENT CONSTRAINT ckc_height_ax_menuo
alter table ax_menuoption
 drop constraint ckc_height_ax_menuo restrict;

-- DROPPING NON-EXISTENT CONSTRAINT ax_menuoption_menu
alter table ax_menuoption
 drop constraint ax_menuoption_menu restrict;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_content_location
alter table ax_content_location
  add constraint pk_ax_content_location primary key (location_id);

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_element_set_enc
alter table ax_element_set_enc
  add constraint pk_ax_element_set_enc primary key (schema_name,element_id,enc_scheme_id);

-- CREATING NEW CONSTRAINT fk_ax_elemset_enc_enc
alter table ax_element_set_enc
  add constraint fk_ax_elemset_enc_enc foreign key (enc_scheme_id) references ax_enc_scheme (enc_scheme_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_elemset_enc_set
alter table ax_element_set_enc
  add constraint fk_ax_elemset_enc_set foreign key (schema_name,element_id) references ax_meta_element_set (schema_name,element_id) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_enc_qualifier
alter table ax_enc_qualifier
  add constraint pk_ax_enc_qualifier primary key (enc_scheme_id,qual_name);

-- CREATING NEW CONSTRAINT fk_ax_enc_qual_scheme
alter table ax_enc_qualifier
  add constraint fk_ax_enc_qual_scheme foreign key (enc_scheme_id) references ax_enc_scheme (enc_scheme_id) on update restrict on delete restrict;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_enc_scheme
alter table ax_enc_scheme
  add constraint pk_ax_enc_scheme primary key (enc_scheme_id);

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_enc_value
alter table ax_enc_value
  add constraint pk_ax_enc_value primary key (enc_scheme_id,enc_value);

-- CREATING NEW CONSTRAINT fk_ax_enc_schema_value
alter table ax_enc_value
  add constraint fk_ax_enc_schema_value foreign key (enc_scheme_id) references ax_enc_scheme (enc_scheme_id) on update restrict on delete restrict;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_layout_metadata
alter table ax_layout_metadata
  add constraint pk_ax_layout_metadata primary key (layout_id,element_id,schema_name);

-- CREATING NEW CONSTRAINT fk_ax_lay_metadata_elem
alter table ax_layout_metadata
  add constraint fk_ax_lay_metadata_elem foreign key (element_id,schema_name) references ax_site_meta_element (element_id,schema_name) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_lay_metadata_scheme
alter table ax_layout_metadata
  add constraint fk_ax_lay_metadata_scheme foreign key (enc_scheme_id) references ax_enc_scheme (enc_scheme_id) on update restrict on delete set null;

-- CREATING NEW CONSTRAINT fk_ax_layout_meta_data
alter table ax_layout_metadata
  add constraint fk_ax_layout_meta_data foreign key (layout_id) references ax_layout (layout_id) on update no action on delete cascade;

-- CREATING NEW CONSTRAINT ckc_cm_privilege_ax_layou
alter table ax_layout_set_group
  add constraint ckc_cm_privilege_ax_layou check (((cm_privilege = 'editor'::text) OR (cm_privilege = 'author'::text)) OR (cm_privilege = 'entry'::text));

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_layout_set_group
alter table ax_layout_set_group
  add constraint pk_ax_layout_set_group primary key (layout_name,cm_privilege,group_id);

-- CREATING NEW CONSTRAINT fk_group_layout_set
alter table ax_layout_set_group
  add constraint fk_group_layout_set foreign key (layout_name) references ax_layout_set (layout_name) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_layout_set_group
alter table ax_layout_set_group
  add constraint fk_layout_set_group foreign key (group_id) references ax_group (group_id) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_meta_element
alter table ax_meta_element
  add constraint pk_ax_meta_element primary key (element_id);

-- CREATING NEW CONSTRAINT fk_ax_meta_elem_parent_schema
alter table ax_meta_element
  add constraint fk_ax_meta_elem_parent_schema foreign key (parent_schema) references ax_meta_schema (schema_name) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_parent_element
alter table ax_meta_element
  add constraint fk_ax_parent_element foreign key (parent_element) references ax_meta_element (element_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT ckc_obligation_ax_meta_
alter table ax_meta_element_set
  add constraint ckc_obligation_ax_meta_ check ((((obligation = 'm'::text) OR (obligation = 'c'::text)) OR (obligation = 'r'::text)) OR (obligation = 'o'::text));

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_meta_element_set
alter table ax_meta_element_set
  add constraint pk_ax_meta_element_set primary key (schema_name,element_id);

-- CREATING NEW CONSTRAINT fk_ax_meta_elem_set_elem
alter table ax_meta_element_set
  add constraint fk_ax_meta_elem_set_elem foreign key (element_id) references ax_meta_element (element_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_meta_elem_set_schema
alter table ax_meta_element_set
  add constraint fk_ax_meta_elem_set_schema foreign key (schema_name) references ax_meta_schema (schema_name) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_pref_enc_scheme
alter table ax_meta_element_set
  add constraint fk_ax_pref_enc_scheme foreign key (preferred_enc_scheme) references ax_enc_scheme (enc_scheme_id) on update restrict on delete restrict;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_meta_schema
alter table ax_meta_schema
  add constraint pk_ax_meta_schema primary key (schema_name);

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_microsite
alter table ax_microsite
  add constraint pk_ax_microsite primary key (microsite_name);

-- CREATING NEW CONSTRAINT fk_ax_microsite_menu
alter table ax_microsite
  add constraint fk_ax_microsite_menu foreign key (menu_id) references ax_menu (menu_id) on update restrict on delete set null;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_microsite_media
alter table ax_microsite_media
  add constraint pk_ax_microsite_media primary key (microsite_name,cat_id);

-- CREATING NEW CONSTRAINT fk_ax_microsite_media
alter table ax_microsite_media
  add constraint fk_ax_microsite_media foreign key (cat_id) references ax_catalog (cat_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_microsite_media_page
alter table ax_microsite_media
  add constraint fk_ax_microsite_media_page foreign key (microsite_name) references ax_microsite (microsite_name) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_microsite_page
alter table ax_microsite_page
  add constraint pk_ax_microsite_page primary key (microsite_page_id);

-- CREATING NEW CONSTRAINT fk_ax_microsite_page
alter table ax_microsite_page
  add constraint fk_ax_microsite_page foreign key (microsite_name) references ax_microsite (microsite_name) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_microsite_page_template
alter table ax_microsite_page
  add constraint fk_ax_microsite_page_template foreign key (microsite_template_id) references ax_microsite_template (microsite_template_id) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_microsite_sitepage
alter table ax_microsite_page
  add constraint fk_ax_microsite_sitepage foreign key (page_id) references ax_sitepage (page_id) on update restrict on delete set null;

-- CREATING NEW CONSTRAINT fk_microsite_page_menuoption
alter table ax_microsite_page
  add constraint fk_microsite_page_menuoption foreign key (menuoption_id) references ax_menuoption (menuoption_id) on update restrict on delete set null;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_microsite_page_plugin
alter table ax_microsite_page_plugin
  add constraint pk_ax_microsite_page_plugin primary key (plugin_id);

-- CREATING NEW CONSTRAINT fk_microsite_page_plugin
alter table ax_microsite_page_plugin
  add constraint fk_microsite_page_plugin foreign key (microsite_page_id) references ax_microsite_page (microsite_page_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_plugin_area
alter table ax_microsite_page_plugin
  add constraint fk_plugin_area foreign key (plugin_pattern) references ax_plugin_area (plugin_pattern) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_plugin_content
alter table ax_microsite_page_plugin
  add constraint fk_plugin_content foreign key (plugin_content) references ax_plugin_content (plugin_content) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_microsite_story
alter table ax_microsite_story
  add constraint fk_microsite_story foreign key (story_id) references ax_story (story_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_story_microsite
alter table ax_microsite_story
  add constraint fk_story_microsite foreign key (microsite_name) references ax_microsite (microsite_name) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_microsite_template
alter table ax_microsite_template
  add constraint pk_ax_microsite_template primary key (microsite_template_id);

-- CREATING NEW CONSTRAINT fk_ax_microsite_template
alter table ax_microsite_template
  add constraint fk_ax_microsite_template foreign key (microsite_name) references ax_microsite (microsite_name) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_plugin_area
alter table ax_plugin_area
  add constraint pk_ax_plugin_area primary key (plugin_pattern);

-- CREATING NEW CONSTRAINT ckc_generator_type_ax_plugi
alter table ax_plugin_content
  add constraint ckc_generator_type_ax_plugi check (((((generator_type = 'cm'::text) OR (generator_type = 'func'::text)) OR (generator_type = 'defer'::text)) OR (generator_type = 'lit'::text)) OR (generator_type = 'file'::text));

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_plugin_content
alter table ax_plugin_content
  add constraint pk_ax_plugin_content primary key (plugin_content);

-- CREATING NEW CONSTRAINT ckc_obligation_ax_site_
alter table ax_site_meta_element
  add constraint ckc_obligation_ax_site_ check ((((obligation = 'm'::text) OR (obligation = 'c'::text)) OR (obligation = 'r'::text)) OR (obligation = 'o'::text));

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_site_meta_element
alter table ax_site_meta_element
  add constraint pk_ax_site_meta_element primary key (element_id,schema_name);

-- CREATING NEW CONSTRAINT fk_ax_site_meta_element
alter table ax_site_meta_element
  add constraint fk_ax_site_meta_element foreign key (schema_name,element_id) references ax_meta_element_set (schema_name,element_id) on update restrict on delete restrict;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_sitepage_group
alter table ax_sitepage_group
  add constraint pk_ax_sitepage_group primary key (group_id,page_id);

-- CREATING NEW CONSTRAINT fk_ax_sitepage_gp_group
alter table ax_sitepage_group
  add constraint fk_ax_sitepage_gp_group foreign key (group_id) references ax_group (group_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_sitepage_gp_page
alter table ax_sitepage_group
  add constraint fk_ax_sitepage_gp_page foreign key (page_id) references ax_sitepage (page_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_story_author
alter table ax_story
  add constraint fk_ax_story_author foreign key (story_author) references ax_user (user_id) on update restrict on delete set null;

-- CREATING NEW CONSTRAINT fk_ax_story_category
alter table ax_story
  add constraint fk_ax_story_category foreign key (category_id) references ax_story_category (category_id) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_story_language
alter table ax_story
  add constraint fk_ax_story_language foreign key (lang_id) references ax_language (lang_id) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_story_icon
alter table ax_story
  add constraint fk_story_icon foreign key (story_icon) references ax_catalog (cat_id) on update restrict on delete set null;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_story_category
alter table ax_story_category
  add constraint pk_ax_story_category primary key (category_id);

-- CREATING NEW CONSTRAINT fk_ax_story_categ_loc
alter table ax_story_category_locs
  add constraint fk_ax_story_categ_loc foreign key (category_id) references ax_story_category (category_id) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_story_categ_loc_loc
alter table ax_story_category_locs
  add constraint fk_ax_story_categ_loc_loc foreign key (location_id) references ax_content_location (location_id) on update restrict on delete restrict;

-- CREATING NEW CONSTRAINT fk_ax_content_location
alter table ax_story_location
  add constraint fk_ax_content_location foreign key (location_id) references ax_content_location (location_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_story_location
alter table ax_story_location
  add constraint fk_ax_story_location foreign key (story_id) references ax_story (story_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT ckc_justify_ax_story
alter table ax_story_media
  add constraint ckc_justify_ax_story check ((((justify = ''::text) OR (justify = 'left'::text)) OR (justify = 'center'::text)) OR (justify = 'right'::text));

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_story_media
alter table ax_story_media
  add constraint pk_ax_story_media primary key (story_id,cat_id);

-- CREATING NEW CONSTRAINT fk_ax_story_media_cat_id
alter table ax_story_media
  add constraint fk_ax_story_media_cat_id foreign key (cat_id) references ax_catalog (cat_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_story_media_story
alter table ax_story_media
  add constraint fk_ax_story_media_story foreign key (story_id) references ax_story (story_id) on update restrict on delete cascade;

-- CREATING NEW PRIMARY KEY CONSTRAINT pk_ax_story_translation
alter table ax_story_translation
  add constraint pk_ax_story_translation primary key (story_id,translated_story_id);

-- CREATING NEW CONSTRAINT fk_ax_original_story
alter table ax_story_translation
  add constraint fk_ax_original_story foreign key (story_id) references ax_story (story_id) on update restrict on delete cascade;

-- CREATING NEW CONSTRAINT fk_ax_translated_story
alter table ax_story_translation
  add constraint fk_ax_translated_story foreign key (translated_story_id) references ax_story (story_id) on update restrict on delete cascade;

-- CREATING NEW TRIGGER ax_layout_modstamp
create trigger ax_layout_modstamp before update on ax_layout for each row execute procedure modstamp ();

-- CREATING NEW TRIGGER ax_microsite_modstamp
create trigger ax_microsite_modstamp before update on ax_microsite for each row execute procedure modstamp ();

-- DROPPING NON-EXISTENT SEQUENCE seq_www_session_id
drop sequence seq_www_session_id;

-- CREATING NEW SEQUENCE seq_category_id
create sequence "seq_category_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_element_id
create sequence "seq_element_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_enc_scheme_id
create sequence "seq_enc_scheme_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_lang_id
create sequence "seq_lang_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_location_id
create sequence "seq_location_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_menu_id
create sequence "seq_menu_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_microsite_page_id
create sequence "seq_microsite_page_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_microsite_template_id
create sequence "seq_microsite_template_id" start 1 increment 1 minvalue 1 cache 1;

-- CREATING NEW SEQUENCE seq_plugin_id
create sequence "seq_plugin_id" start 1 increment 1 minvalue 1 cache 1;
