#!/bin/bash

# Sanity check..
if [ ! -d debian ] ; then
  echo "you are not in a debian packaging directory!"
fi

# Allow user override
if [ "$1" != "" ]
then
  USER=$1
fi

# Build debian package..
PACKAGE=`head -n 1 debian/control | cut -f2 -d' '`
PACKAGE_DOC=${PACKAGE}-doc
USER=${1:-"`grep -e \"Maintainer:\" debian/control|cut -d\":\" -f2`"}
VERSION=`head -n 1 debian/changelog | cut -f2 -d\( | cut -f1 -d')' | cut -f1 -d-`

# CVS repositories..
HTMLAREA_CVSROOT=":pserver:anonymous@cvs.sourceforge.net:/cvsroot/itools-htmlarea"
PACKAGE_CVSROOT=catalyst/codeforge/php/${PACKAGE}

echo -n "refresh ChangeLog? (y/n) [n]: "
read ANS
if [ "$ANS" = "y" -o "$ANS" = "Y" ]
then
  cvs2cl >/dev/null 2>&1
fi

echo "constructing package to build.."
HOMEDIR=`pwd`
cd ..
[ ! -d debian-builds ] && mkdir debian-builds
[ ! -d debian-builds/${PACKAGE} ] && mkdir debian-builds/${PACKAGE}
cd debian-builds/${PACKAGE}
WRKDIR="${PACKAGE}-${VERSION}"
sudo rm -rf $WRKDIR
cp -a $HOMEDIR/ $WRKDIR
cd $WRKDIR
# Cleanse of unwanted stuff..
find . -depth -type d -name "CVS" -exec rm -rf {} \;
find . -name ".cvsignore" -exec rm -f {} \;
find . -name ".#*" -exec rm -f {} \;
find . -name "*.log" -exec rm -f {} \;
find . -name "diffs.sql" -exec rm -f {} \;

echo "building version ${VERSION} of ${PACKAGE} and ${PACKAGE_DOC} in `pwd`"

cp $HOMEDIR/ChangeLog .

# Fix perms..
find . -iname "*.php" -exec chmod 664 {} \;
find ./scripts -iname "*.php" -exec chmod 775 {} \;
find . -iname "*.jpg" -exec chmod 664 {} \;
find . -iname "*.gif" -exec chmod 664 {} \;
find . -iname "*.png" -exec chmod 664 {} \;
find . -iname "*.wbmp" -exec chmod 664 {} \;
find . -iname "*.pdm" -exec chmod 664 {} \;
find . -iname "*.pdf" -exec chmod 664 {} \;
find . -iname "*.sql" -exec chmod 664 {} \;
find . -iname "*.xml" -exec chmod 664 {} \;
find . -iname "*.html" -exec chmod 664 {} \;
find . -iname "*.db" -exec chmod 664 {} \;
find . -iname "*.js" -exec chmod 664 {} \;
find . -iname ".htaccess" -exec chmod 664 {} \;
find . -iname "ChangeLog" -exec chmod 664 {} \;
find . -iname "*.cgi" -exec chmod 775 {} \;
find . -iname "*.pl" -exec chmod 775 {} \;
find . -iname "*.sh" -exec chmod 775 {} \;
find . -iname "make-patch" -exec chmod 775 {} \;

# Ensure we have HTMLarea locally.
if [ -f lib/js/htmlarea/htmlarea.js ]
then
 :
else
  echo "HTMLarea not present in build directory."
  echo "acquiring latest HTMLarea export.."
  cd lib/js
  echo "just hit the [ENTER] key for the CVS password.."
  cvs -d $HTMLAREA_CVSROOT login
  cvs -q -z3 -d $HTMLAREA_CVSROOT export -r HEAD -d htmlarea htmlarea
  cd ../..
fi

# Build it!
dpkg-buildpackage -tc -rsudo -sgpg -m"${USER}" -k"${USER}"

# ENDS
