create table ax_blocklet (
blocklet_id          INTEGER                        not null,
blocklet_desc        LONG VARBINARY,
blocklet_type        VARCHAR(10)                    not null default 'text' 
      check (blocklet_type in ('text','list','ordered','bullets','table','raw')),
blocklet_width       INTEGER                        not null default 100 
      check (blocklet_width between 0 and 100),
blocklet_style       LONG VARCHAR,
justify              VARCHAR(16)                    not null default '' 
      check (justify in ('','left','center','right')),
heading              LONG VARCHAR,
heading_level        INTEGER                        not null default 3,
heading_colour       LONG VARCHAR,
ruler                VARCHAR(10)                    not null default 'none' 
      check (ruler in ('none','top','bottom')),
ruler_width          INTEGER                        not null default 100 
      check (ruler_width between 0 and 100),
ruler_size           INTEGER                        not null default 1,
ruler_colour         LONG VARCHAR,
content              LONG VARCHAR,
content_size         FLOAT                          not null default 1.0,
content_colour       LONG VARCHAR,
table_style          LONG VARCHAR,
table_autojustify    SMALLINT                       not null default false,
table_rowstripes     SMALLINT                       not null default false,
primary key (blocklet_id)
);

create table ax_catalog (
cat_id               INTEGER                        not null,
cat_name             LONG VARCHAR                   not null,
cat_desc             LONG VARCHAR,
mime_type            LONG VARCHAR                   not null,
mime_category        LONG VARCHAR                   not null,
upload_timestamp     DATE                           not null default 'now()',
category             LONG VARCHAR,
keywords             LONG VARCHAR,
filesize             INTEGER                        not null default 0,
filepath             LONG VARCHAR                   not null,
width                INTEGER                        not null default 0,
height               INTEGER                        not null default 0,
primary key (cat_id)
);

create table ax_config (
config_name          VARCHAR(64)                    not null,
config_fields        LONG VARCHAR,
primary key (config_name)
);

create table ax_configuration (
config_name          VARCHAR(64)                    not null,
config_id            VARCHAR(64)                    not null,
config_set           LONG VARCHAR,
primary key (config_name, config_id),
foreign key (config_name)
      references ax_config (config_name)
);

create  index ax_configuration_config_FK on ax_configuration (
config_name ASC
);

create table ax_contactinfo (
contactinfo_id       INTEGER                        not null,
addr_postal          LONG VARCHAR,
addr_street          LONG VARCHAR,
addr_suburb          LONG VARCHAR,
addr_city            LONG VARCHAR,
addr_country         LONG VARCHAR,
addr_code            LONG VARCHAR,
addr_other           LONG VARCHAR,
emails               LONG VARBINARY,
phone                LONG VARBINARY,
phone_fax            LONG VARBINARY,
phone_work           LONG VARBINARY,
phone_mobile         LONG VARBINARY,
urls                 LONG VARCHAR,
primary key (contactinfo_id)
);

create table ax_content_location (
location_id          INTEGER                        not null,
location_name        LONG VARCHAR                   not null,
location_desc        LONG VARCHAR,
enabled              SMALLINT                       not null default true,
primary key (location_id)
);

create table ax_enc_scheme (
enc_scheme_id        INTEGER                        not null,
enc_scheme_name      LONG VARCHAR                   not null,
label                LONG VARCHAR,
tag_name             LONG VARCHAR                   not null,
description          LONG VARCHAR,
datasrc_uri          LONG VARCHAR,
reference_url        LONG VARCHAR,
enabled              SMALLINT                       not null default true,
primary key (enc_scheme_id)
);

create table ax_enc_value (
enc_scheme_id        INTEGER                        not null,
enc_value            LONG VARCHAR                   not null,
enc_label            LONG VARCHAR,
primary key (enc_scheme_id, enc_value),
foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
);

create table ax_group (
group_id             INTEGER                        not null,
group_desc           LONG VARBINARY                 not null,
primary key (group_id)
);

create table ax_language (
lang_id              INTEGER                        not null,
lang_desc            LONG VARCHAR                   not null,
char_encoding        LONG VARCHAR                   not null,
direction            VARCHAR(4)                     not null default 'LTR' 
      check (direction in ('LTR','RTL')),
is_default           SMALLINT                       not null default 0,
display_order        INTEGER                        not null default 999,
enabled              SMALLINT                       not null default 1,
primary key (lang_id)
);

create table ax_menu (
menu_id              INTEGER                        not null,
menu_name            LONG VARCHAR                   not null,
lang_id              INTEGER                        not null default 0,
menu_desc            LONG VARCHAR,
menu_user_groups     LONG VARCHAR,
active               SMALLINT                       not null default true,
last_modified        DATE                           not null default 'now()',
primary key (menu_id),
foreign key (lang_id)
      references ax_language (lang_id)
);

create unique index menu_language on ax_menu (
menu_name ASC,
lang_id ASC
);

create table ax_menuoption (
menuoption_id        INTEGER                        not null,
menu_id              INTEGER                        not null,
parent_id            INTEGER                         default 0,
user_groups          LONG VARCHAR,
user_type            LONG VARCHAR,
menu_level           INTEGER                        not null default 0,
label                LONG VARCHAR,
description          LONG VARCHAR,
display_order        INTEGER                        not null default 0,
action               LONG VARCHAR,
sitepage             LONG VARCHAR,
sitepage_parms       LONG VARCHAR,
auth_code            SMALLINT                       not null default false,
active               SMALLINT                       not null default true,
last_modified        DATE                           not null default 'now()',
width                INTEGER                        not null default 80,
height               INTEGER                        not null default 20,
is_parent            SMALLINT                       not null default 0,
primary key (menuoption_id),
foreign key (menu_id)
      references ax_menu (menu_id)
);

create  index ax_menuoption_menu_FK on ax_menuoption (
menu_id ASC
);

create table ax_meta_schema (
schema_name          VARCHAR(64)                    not null,
description          LONG VARCHAR,
namespace            LONG VARCHAR,
namespace_uri        LONG VARCHAR,
primary key (schema_name)
);

create table ax_organisation (
org_id               INTEGER                        not null,
contactinfo_id       INTEGER,
org_name             LONG VARCHAR                   not null,
org_desc             LONG VARCHAR,
org_contact          LONG VARCHAR,
enabled              SMALLINT                       not null default true,
primary key (org_id),
foreign key (contactinfo_id)
      references ax_contactinfo (contactinfo_id)
);

create  index ax_org_contactinfo_FK on ax_organisation (
contactinfo_id ASC
);

create table ax_query_resource (
quid                 INTEGER                        not null,
q_desc               LONG VARCHAR,
q_query              LONG VARCHAR,
q_script             LONG VARCHAR,
enabled              SMALLINT                       not null default true,
primary key (quid)
);

create table ax_sitepage (
page_id              INTEGER                        not null,
page_title           LONG VARCHAR                   not null,
page_path            LONG VARCHAR                   not null,
managed              SMALLINT                       not null default true,
enabled              SMALLINT                       not null default true,
primary key (page_id)
);

create table ax_sitepage_group (
group_id             INTEGER                        not null,
page_id              INTEGER                        not null,
primary key (group_id, page_id),
foreign key (group_id)
      references ax_group (group_id),
foreign key (page_id)
      references ax_sitepage (page_id)
);

create table ax_story_category (
category_id          INTEGER                        not null,
category_desc        LONG VARCHAR                   not null,
has_media            SMALLINT                       not null default false,
has_precis           SMALLINT                       not null default true,
has_expiry           SMALLINT                       not null default false,
has_multilang        SMALLINT                       not null default true,
has_multimedia       SMALLINT                       not null default false,
primary key (category_id)
);

create table ax_story_category_locs (
category_id          INTEGER                        not null,
location_id          INTEGER                        not null,
foreign key (location_id)
      references ax_content_location (location_id),
foreign key (category_id)
      references ax_story_category (category_id)
);

create table ax_user (
user_id              VARCHAR(64)                    not null,
org_id               INTEGER                        not null default 0,
password             LONG VARCHAR,
full_name            LONG VARCHAR,
user_type            VARCHAR(10)                    not null default 'user' 
      check (user_type in ('user','sys')),
email                LONG VARBINARY,
address              LONG VARBINARY,
phone                LONG VARBINARY,
fax                  LONG VARBINARY,
mobile               LONG VARBINARY,
last_login           DATE,
total_logins         INTEGER                        not null default 0,
limit_logins         INTEGER                        not null default 0,
enabled              SMALLINT                       not null default true,
auth_code            LONG VARCHAR,
primary key (user_id),
foreign key (org_id)
      references ax_organisation (org_id)
);

create  index ax_user_org_FK on ax_user (
org_id ASC
);

create table ax_user_group (
group_id             INTEGER                        not null,
user_id              VARCHAR(64)                    not null,
primary key (group_id, user_id),
foreign key (user_id)
      references ax_user (user_id),
foreign key (group_id)
      references ax_group (group_id)
);

create  index ax_user_group_FK on ax_user_group (
group_id ASC
);

create  index ax_user_group_FK2 on ax_user_group (
user_id ASC
);

create table ax_user_ip (
user_id              VARCHAR(64)                    not null,
ip                   VARCHAR(32)                    not null,
primary key (user_id, ip),
foreign key (user_id)
      references ax_user (user_id)
);

create  index ax_user_ip_user_FK on ax_user_ip (
user_id ASC
);

create table ax_wwwsession (
session_id           VARCHAR(64)                    not null,
user_id              VARCHAR(64)                    not null,
menuoption_id        INTEGER,
lang_id              INTEGER                        not null default 0,
menu_status          LONG VARCHAR,
user_groups          LONG VARCHAR,
login_type           INTEGER                        not null default 0 
      check (login_type between 0 and 4),
login_datetime       DATE                           not null default 'now()',
primary key (session_id),
foreign key (user_id)
      references ax_user (user_id),
foreign key (menuoption_id)
      references ax_menuoption (menuoption_id),
foreign key (lang_id)
      references ax_language (lang_id)
);

create  index ax_wwwsession_user_FK on ax_wwwsession (
user_id ASC
);

create table ax_forum (
forum_id             INTEGER                        not null,
moderator            VARCHAR(64),
forum_name           LONG VARCHAR                   not null,
forum_desc           LONG VARCHAR,
enabled              SMALLINT                       not null default true,
private              SMALLINT                       not null default false,
last_author          LONG VARCHAR,
threadlast_author    INTEGER                        not null default 0,
datelast_author      DATE,
posts                INTEGER                        not null default 0,
primary key (forum_id),
foreign key (moderator)
      references ax_user (user_id)
);

create table ax_forum_member (
user_id              VARCHAR(64)                    not null,
forum_id             INTEGER                        not null,
primary key (user_id, forum_id),
foreign key (forum_id)
      references ax_forum (forum_id),
foreign key (user_id)
      references ax_user (user_id)
);

create  index ax_forum_member_FK on ax_forum_member (
user_id ASC
);

create  index ax_forum_member_FK2 on ax_forum_member (
forum_id ASC
);

create table ax_forum_msg (
msg_id               INTEGER                        not null,
forum_id             INTEGER                        not null,
msg_subject          LONG VARCHAR                   not null,
msg_text             LONG VARCHAR                   not null,
msg_author           LONG VARCHAR                   not null,
msg_votes            INTEGER                        not null default 0,
last_modified        DATE                           not null default 'now()',
parent_thread_id     INTEGER,
sticky               SMALLINT                       not null default false,
locked               SMALLINT                       not null default false,
views                INTEGER                        not null default 0,
enabled              SMALLINT                       not null default true,
replies              INTEGER                        not null default 0,
primary key (msg_id),
foreign key (forum_id)
      references ax_forum (forum_id),
foreign key (parent_thread_id)
      references ax_forum_msg (msg_id)
);

create  index ax_fk_forum_msg_forum_FK on ax_forum_msg (
forum_id ASC
);

create table ax_enc_qualifier (
enc_scheme_id        INTEGER                        not null,
qual_name            VARCHAR(64)                    not null,
qual_label           LONG VARCHAR,
comments             LONG VARCHAR,
default_value        LONG VARCHAR,
list_of_values       LONG VARCHAR,
display_order        INTEGER                        not null default 999,
primary key (enc_scheme_id, qual_name),
foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
);

create table ax_story (
story_id             INTEGER                        not null,
lang_id              INTEGER                        not null default 0,
category_id          INTEGER,
story_author         VARCHAR(64),
story_icon           INTEGER,
story_icon_url       LONG VARCHAR,
story_headline       LONG VARCHAR,
story_precis         LONG VARCHAR,
story_content        LONG VARCHAR,
story_type           LONG VARCHAR,
story_url            LONG VARCHAR,
story_date           DATE                           not null default 'CURRENT_TIMESTAMP',
expiry_date          DATE,
last_modified        DATE                           not null default 'CURRENT_TIMESTAMP',
deleted              SMALLINT                       not null default false,
visible              SMALLINT                       not null default true,
primary key (story_id),
foreign key (story_icon)
      references ax_catalog (cat_id),
foreign key (lang_id)
      references ax_language (lang_id),
foreign key (story_author)
      references ax_user (user_id),
foreign key (category_id)
      references ax_story_category (category_id)
);

create table ax_story_location (
story_id             INTEGER                        not null,
location_id          INTEGER                        not null,
display_order        INTEGER                        not null default 999,
foreign key (story_id)
      references ax_story (story_id),
foreign key (location_id)
      references ax_content_location (location_id)
);

create table ax_story_media (
story_id             INTEGER                        not null,
cat_id               INTEGER                        not null,
caption              LONG VARCHAR,
width                INTEGER                        not null default 0,
height               INTEGER                        not null default 0,
justify              VARCHAR(16)                    not null default '' 
      check (justify in ('','left','center','right')),
display_order        INTEGER                        not null default 999,
primary key (story_id, cat_id),
foreign key (story_id)
      references ax_story (story_id),
foreign key (cat_id)
      references ax_catalog (cat_id)
);

create table ax_story_translation (
story_id             INTEGER                        not null,
translated_story_id  INTEGER                        not null,
primary key (story_id, translated_story_id),
foreign key (story_id)
      references ax_story (story_id),
foreign key (translated_story_id)
      references ax_story (story_id)
);

create table ax_layout_set (
layout_name          VARCHAR(64)                    not null,
page_id              INTEGER,
primary key (layout_name),
foreign key (page_id)
      references ax_sitepage (page_id)
);

create  index ax_layout_set_sitepage_FK on ax_layout_set (
page_id ASC
);

create table ax_meta_element (
element_id           INTEGER                        not null,
label                LONG VARCHAR,
tag_name             LONG VARCHAR                   not null,
definition           LONG VARCHAR,
parent_element       INTEGER,
parent_schema        VARCHAR(64),
enabled              SMALLINT                       not null default true,
primary key (element_id),
foreign key (parent_element)
      references ax_meta_element (element_id),
foreign key (parent_schema)
      references ax_meta_schema (schema_name)
);

create table ax_meta_element_set (
schema_name          VARCHAR(64)                    not null,
element_id           INTEGER                        not null,
preferred_enc_scheme INTEGER,
comments             LONG VARCHAR,
obligation           VARCHAR(10)                    not null default 'o' 
      check (obligation in ('m','c','r','o')),
default_value        LONG VARCHAR,
list_of_values       LONG VARCHAR,
display_order        INTEGER                        not null default 999,
enabled              SMALLINT                       not null default true,
primary key (schema_name, element_id),
foreign key (element_id)
      references ax_meta_element (element_id),
foreign key (schema_name)
      references ax_meta_schema (schema_name),
foreign key (preferred_enc_scheme)
      references ax_enc_scheme (enc_scheme_id)
);

create table ax_site_meta_element (
element_id           INTEGER                        not null,
schema_name          VARCHAR(64)                    not null,
label                LONG VARCHAR,
description          LONG VARCHAR,
indexed              SMALLINT                       not null default false,
searchable           SMALLINT                       not null default false,
obligation           VARCHAR(10)                    not null default 'o' 
      check (obligation in ('m','c','r','o')),
default_value        LONG VARCHAR,
list_of_values       LONG VARCHAR,
display_order        INTEGER                        not null default 999,
enabled              SMALLINT                        default true,
primary key (element_id, schema_name),
foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id)
);

create table ax_layout (
layout_id            INTEGER                        not null,
layout_name          VARCHAR(64)                    not null,
lang_id              INTEGER                        not null default 0,
index_category       LONG VARCHAR,
layout_table         LONG VARCHAR,
show_last_modified   SMALLINT                       not null default false,
format_last_modified LONG VARCHAR,
prefix_last_modified LONG VARCHAR,
layout_style         LONG VARCHAR,
cache                LONG VARCHAR,
cache_updated        DATE,
last_modified        DATE                           not null default 'now()',
primary key (layout_id),
foreign key (layout_name)
      references ax_layout_set (layout_name),
foreign key (lang_id)
      references ax_language (lang_id)
);

create  index ax_layout_set_FK on ax_layout (
layout_name ASC
);

create table ax_block (
block_id             INTEGER                        not null,
layout_id            INTEGER                        not null,
background_img       INTEGER,
lang_id              INTEGER                        not null default 0,
block_desc           LONG VARBINARY,
block_style          LONG VARCHAR,
block_type           LONG VARCHAR,
cols                 INTEGER                        not null default 1,
gutter_width         INTEGER                        not null default 0,
gutter_colour        LONG VARCHAR,
blocklet_sep         INTEGER                        not null default 0,
border_width         INTEGER                        not null default 0,
border_colour        LONG VARCHAR,
background_colour    LONG VARCHAR,
justify              VARCHAR(16)                    not null default '' 
      check (justify in ('','left','center','right')),
valign               VARCHAR(10)                    not null default '' 
      check (valign in ('','top','middle','bottom')),
exportable           SMALLINT                       not null default false,
cache                LONG VARCHAR,
cache_updated        DATE,
last_modified        DATE                           not null default 'now()',
primary key (block_id),
foreign key (layout_id)
      references ax_layout (layout_id),
foreign key (background_img)
      references ax_catalog (cat_id),
foreign key (lang_id)
      references ax_language (lang_id)
);

create  index ax_block_layout_FK on ax_block (
layout_id ASC
);

create table ax_block_blocklet (
blocklet_id          INTEGER                        not null,
block_id             INTEGER                        not null,
display_order        INTEGER                        not null default 0,
visible              SMALLINT                       not null default true,
primary key (blocklet_id, block_id),
foreign key (blocklet_id)
      references ax_blocklet (blocklet_id),
foreign key (block_id)
      references ax_block (block_id)
);

create  index ax_block_blocklet_FK on ax_block_blocklet (
blocklet_id ASC
);

create  index ax_block_blocklet_FK2 on ax_block_blocklet (
block_id ASC
);

create table ax_layout_metadata (
layout_id            INTEGER                        not null,
element_id           INTEGER                        not null,
schema_name          VARCHAR(64)                    not null,
meta_tag_value       LONG VARCHAR,
enc_scheme_id        INTEGER,
linked_uri           SMALLINT                       not null default false,
language             LONG VARCHAR,
primary key (layout_id, element_id, schema_name),
foreign key (layout_id)
      references ax_layout (layout_id),
foreign key (element_id, schema_name)
      references ax_site_meta_element (element_id, schema_name),
foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
);

create table ax_element_set_enc (
schema_name          VARCHAR(64)                    not null,
element_id           INTEGER                        not null,
enc_scheme_id        INTEGER                        not null,
primary key (schema_name, element_id, enc_scheme_id),
foreign key (schema_name, element_id)
      references ax_meta_element_set (schema_name, element_id),
foreign key (enc_scheme_id)
      references ax_enc_scheme (enc_scheme_id)
);

