#!/usr/bin/php4 -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    monitor.php                                             */
/* Author:      Paul Waite                                              */
/* Description: Checks 'things' to make sure the site is working        */
/*              as it should. If not, e-mails the appropriate people.   */
/*              NOTE: Must be run from 'scripts' directory.             */
/*              NB: This utility is designed to be run from 'cron' on a */
/*              system which has php-cgi installed.                     */
/*                                                                      */
/* ******************************************************************** */
chdir("..");
// ----------------------------------------------------------------------
/**
* AXYL LIBRARY LOCATOR
* If not defined above, sniff the Axyl library. We only allow for the
* basic possibilities, as listed in the below possibles array. These
* are relative to the website root directory.
*
*/
$LIBDIR_POSSIBLES = array(".", "lib", "library", "axyl");
if (!isset($LIBDIR)) {
  foreach ($LIBDIR_POSSIBLES as $testdir) {
    if (file_exists("$testdir/application-defs.php")) {
      $LIBDIR = $testdir;
      break;
    }
  }
  // Failure is not an option..
  if (!isset($LIBDIR)) {
    exit;
  }
}

// ----------------------------------------------------------------------
// INITIALISATION
include_once("$LIBDIR/monitor-defs.php");
include_once("$LIBDIR/optlist-defs.php");

// ----------------------------------------------------------------------
// Program parameters..
$opts = new optlist();
$progname = $opts->progname;
$verbose = ($opts->opt_exists("verbose") || $opts->opt_exists("v"));

// ----------------------------------------------------------------------
// MONITOR
// Create a new monitor to do all our monitoring tasks. This just sets it
// up for the check() calls further on.
// NOTES: Make sure you customise this to have your own e-mail To: and
// From: settings.
$monitor = new monitor(
        "AXYL",                      // Monitor name (prefixed on messages)
        "root@localhost",            // Address to email messages
        "root@localhost",            // The From: email address
        //"pager@localhost"            // Pager system email address
        );

// Add timeslots which alter the condition logging level. When adding slots
// which overlap, remember that the FIRST matched slot is used. This means
// you should put short slots at the top, and longer/catchall slots at
// the bottom. Time format is "hh:mm" start/end. Possibilities for slot
// names are determined by the third (name) parameter supplied, and these
// can be:
// "verbose"   Report everything, even when Ok (useful for testing)
// "warnings"  Report warnings, errors and fatal errors
// "errors"    Report error conditions and fatal
// "fatal"     Report only fatal errors
// "skip"      Skip all monitoring checks

// NOTES: Customise, and uncomment to set up your timeslots, if any..
//$monitor->add_timeslot("23:00", "01:00", "errors");  // Report errors & fatal
//$monitor->add_timeslot("01:00", "04:00", "skip");    // Skip all monitoring
//$monitor->add_timeslot("04:00", "06:00", "errors");  // Report errors & fatal

// If this program was run with the --verbose parameter, then we adjust
// the logging level regardless. This is usually just used for testing.
if ($verbose) {
  $monitor->set_condition_thresholds(
      COND_ALL,   // Threshold for emailed messages
      COND_ALL    // Threshold for pager messaging
      );
}

// ----------------------------------------------------------------------
// CHECK POSTGRES
// This check is done first, since the database is required for
// further checks. Failure here is fatal, and nothing else will
// be checked should that be the case.

// NOTES: to check that your database is up, change 'dbname' and
// 'dbuser' below.

$monitor->add_monitor( new postgres_monitor("dbname", "dbuser") );

// The reason we throw in the check here, is because database
// monitors are always COND_FATAL if they fail, and in that case
// this call will not return. We need to know right now whether
// we have a database, since later tests may rely on it.
$monitor->check();

// If we get here, then all is ok, so clear the above out, since
// we don't need to check the database again..
$monitor->clear();

// ----------------------------------------------------------------------
// CONNECT AS PER APPLICATION
// CLI Program working dir is always its own directory
// so we need to get into the website root directory..
include_once("application.php");
include_once("$LIBDIR/lucene-defs.php");

// ----------------------------------------------------------------------
// CHECK LUCENE SEARCHING
// To set up Luceneserver monitoring, you need to know your content and
// what to search for. Then, replace the 'my search words' with your own
// search term(s), and set the expected results to the number you know
// is returned (and always will be).
$SEARCH_FOR = "my search words";
$EXPECT_RESULTS = 2;

$checksearch = new lucene_search();
$checksearch->must_match($SEARCH_FOR);
$checksearch->set_maxresults($EXPECT_RESULTS);
$monitor->add_monitor( new lucene_monitor($checksearch, $EXPECT_RESULTS) );

// ......................................................................
// FILE TIMESTAMP CHECKS
// Max time allowed for a given file to remain unchanged. Typically this
// is some logfile which your application is using, and you expect it
// to be updated regularly. This kind of monitor allows you to make
// sure that it is, and will warn you if things are unchanged for longer
// than a given 'lull' period.
$tinow = time();
$tinfo = getdate($tinow);
$wday = $tinfo["wday"];
$hour = $tinfo["hours"];
switch ($wday) {
  // Sundays..
  case 0:
    $MAXLULL_MINS = 90;
    break;
  // Saturdays..
  case 6:
    $MAXLULL_MINS = 30;
    break;
  default:
  $MAXLULL_MINS = 15;
} // switch

// Example of profiling for quiet times of day (24hr clock)..
switch ($hour) {
  case 11: $MAXLULL_MINS *= 1.20; break;
  case  0: $MAXLULL_MINS *= 1.50; break;
  case  1: $MAXLULL_MINS *= 1.50; break;
  case  2: $MAXLULL_MINS *= 2.00; break;
  case  3: $MAXLULL_MINS *= 2.00; break;
  case  4: $MAXLULL_MINS *= 1.50; break;
  case  5: $MAXLULL_MINS *= 1.20; break;
} // switch

// CHECK FILE TIMESTAMP(s)
// Add as many of these sections as needed. Replace the path below with
// the location of your file to check, make sure the $MAXLULL settings
// above match your requirements, and also make sure that the messages
// below are customised appropriately.
$FILE_TO_CHECK = "path/to/myfile";
if (file_exists($FILE_TO_CHECK)) {
  // Create a file monitor..
  $filemon = new file_monitor(
        $FILE_To_CHECK,                 // Path to file/dir to monitor
        $MAXLULL_MINS,                  // Max mins before warning issued
        $MAXLULL_MINS * 2               // Max mins before error condition
        );
  // Set the messages for expected conditions. Note that these
  // are optional, and you could remove all of these 'set_messages'
  // calls and rely on the generic messages if you want.
  // NOTE:
  $filemon->set_messages(
          COND_OK,                           // Level for this message
          "Activity ok on $FILE_TO_CHECK",   // E-mailed message
          "$FILE_TO_CHECK OK"                // Pager message
          );
  $filemon->set_messages(
          COND_WARNING,
          "Lack of activity on $FILE_TO_CHECK, please investigate",
          "$FILE_TO_CHECK inactive!"
          );
  $filemon->set_messages(
          COND_ERROR,
          "CRITICAL! No activity on $FILE_TO_CHECK, please fix now.",
          "$FILE_TO_CHECK inactive!"
          );
  $monitor->add_monitor( $filemon );
}

// ......................................................................
// DISK SPACE CHECKS
// If you want to keep tabs on disk partition space as part of your
// monitoring regime then you can alter/use the following templates
// which represent a standard Linux system where we want to make
// sure the Postgres database area, the root partition and the location
// of all our websites all have enough space.

// NOTE: These monitors all use the default messages, but you could do
// the same as above and customise these if you need to.

// Postgres database partition
$spacemon = new diskspace_monitor(
        "/var/lib/postgres/data",
        100 * MEGABYTE,
        50 * MEGABYTE
        );
$monitor->add_monitor( $spacemon );

// Root partition
$spacemon = new diskspace_monitor(
        "/",
        200 * MEGABYTE,
        50 * MEGABYTE
        );
$monitor->add_monitor( $spacemon );

// Websites partition
$spacemon = new diskspace_monitor(
        "/var/www",
        250 * MEGABYTE,
        100 * MEGABYTE
        );
$monitor->add_monitor( $spacemon );

// ----------------------------------------------------------------------
// RUN THE MONITOR NOW..
$monitor->check();

// ----------------------------------------------------------------------
?>
