<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    reg-defs.php                                            */
/* Author:      Mark Kessell                                            */
/* Description: Definitions for managing self registering USERS         */
/*                                                                      */
/* ******************************************************************** */
/** @package user */

// ----------------------------------------------------------------------
/** Self-registration class.
* Used to provide means for users to register themselves on an
* Axyl-based website.
* @package user
*/
class user_self_registration extends HTMLObject {
  // this new class caters for user self registration to any site created using axyl.
  var $user_id;
  var $password;
  var $full_name;
  var $email;
  var $address;
  var $phone;
  var $mobile;
  var $enabled = 'f';
  var $auth_code;
  var $user_confirmation = 'f';
  var $error_msg;
  var $regmode;
  var $displaypw;
  var $savepw = 'f';
  var $forumfor = 'Axyl Default Site';
  var $forumemail = 'axyl@catalyst.net.nz';
  var $confirmsubject = 'Forums Confirmation of Registration';

  function user_self_registration ($confirmation='f', $rmode='', $user='', $ff='', $fe='') {
    // main class contructor.
    if ( trim($confirmation) != '' )
      $this->user_confirmation = trim($confirmation);

    if ( trim($ff) != "" )
      $this->forumfor = trim($ff);

    if ( trim($fe) != "" )
      $this->forumemail = trim($fe);

    // if no confirmation is required, account is enabled from start.
    if ( $this->user_confirmation == 'f' )
      $this->enabled = 't';

    // set the mode for internal use.
    if ( trim($rmode) != '')
      $this->regmode = trim($rmode);

    // post process
    $this->POSTprocess();

    if ( trim($user) != "" ) {
      $this->user_id = trim($user);
      $this->get_user();
    }
  } // user_self_registration

  function get_user() {
    // gets the user so they can edit details
    if ( trim($this->auth_code) != "" ) {
      $q = "select * from ax_user where auth_code='$this->auth_code'";
    } else {
      $q = "select * from ax_user where user_id='$this->user_id'";
    }
    $Q = new dbrecords($q);

    if ( $Q->hasdata ) {
      $this->user_id = $Q->field("user_id");
      $this->full_name = $Q->field("full_name");
      $this->email = $Q->field("email");
      $this->address = $Q->field("address");
      $this->phone = $Q->field("phone");
      $this->mobile = $Q->field("mobile");
      $this->auth_code = $Q->field("auth_code");
      $this->displaypw = $Q->field("password");
      $this->enabled = $Q->field("enabled");

      return TRUE;
    }

    return FALSE;
  } // get_user

  function save() {
    // save the record to the database
    if ( trim($this->auth_code) == "" ) {
      // it's an insert
      $query = new dbinsert("ax_user");
      $query->set("user_id", $this->user_id);
      $query->set("password", $this->password);

      $seed = $this->user_id . $this->full_name . microtime();
      $this->auth_code = md5($seed);
      $query->set("full_name", $this->full_name);
      $query->set("address", $this->address);
      $query->set("email", $this->email);
      $query->set("phone", $this->phone);
      $query->set("mobile", $this->mobile);
      $query->set("auth_code", $this->auth_code);

      $q = new dbrecords("select group_id from ax_group where group_desc='User'");
      $ug = new dbinsert("ax_user_group");
      $ug->set("group_id", $q->field("group_id"));
      $ug->set("user_id", $this->user_id);

      $regins = 'true';
    } else {
      // it's an update
      $query = new dbupdate("ax_user");
      $query->where("user_id='$this->user_id'");
      $query->set("full_name", $this->full_name);
      $query->set("address", $this->address);
      $query->set("email", $this->email);
      $query->set("phone", $this->phone);
      $query->set("mobile", $this->mobile);

      if ( $this->savepw == 't' )
        $query->set("password", $this->password);
    }

    $query->set("enabled", $this->enabled);

    begin_transaction();
    if ( $query->execute() ) {
      if ( $regins == "true" ) {
        // only execute the 2nd query if it's an insert.
        if ( $ug->execute() ) {
          $this->regmode = "confirm";
          commit();
          return TRUE;
        } else {
          $this->regmode = "newreg";
          $this->error_msg = "ERROR assigning User Group to User.";
        }
      } else {
        $this->regmode = "confirm";
        commit();
        return TRUE;
      }
    } else {
      $this->regmode = "newreg";
      $this->error_msg = "ERROR in Saving User Record.";
    }

    rollback();
    return FALSE;
  } // save

  function send_confirmation_email() {
    // send the confirmation email
    global $SERVER_NAME, $SCRIPT_NAME;
    $subject = $this->forumfor . " " . $this->confirmsubject;

    $body = "Please click on the link below to enable your registration to the ".$this->forumfor." Forums\n\n";
    $body .= "http://".$SERVER_NAME.$SCRIPT_NAME."?regmode=confirm&auth_code=$this->auth_code";
    $email = new email($this->forumemail,
                       $this->email,
                       $subject,
                       $body);

    $email->send();
  } // send confirmation_email

  function check_authcode($auth_code) {
    // if auth_code exists in database, enable user
    //$q = "select * from ax_user where auth_code='$auth_code'";
    //$Q = new dbrecords($q);

    //if ( $Q->hasdata ) {
      // auth_code confirmed
    $this->auth_code = $auth_code;
    if ( $this->get_user() ) {

      $this->enabled = 't';

      return TRUE;
    }

    return FALSE;
  } // check_authcode

  function html() {
    // this displays either the reg form or the appropriate messages.
    global $RESPONSE, $auth_code, $regmode, $SaveReg_x, $LIBDIR;

    $s = "";

    $T = new table("SelfRegistrationForm");
    $T->setborder(0);
    $T->setalign("center");
    $T->setwidth("80%");

    switch ($this->regmode) {
      case "noauth":
        $T->tr();
        $T->td("It Seems that that Authorisation code doesn't exist in our database. Please click <a href=\"?regmode=newreg\" class=\"forumlinkgold\">HERE</a> to register to the $this->forumfor Forums.");
        break;
      case "confirm":
        if ( trim($auth_code) == "" ) {
          // means the save button was pressed
          if ( trim($this->user_confirmation) == 't' ) {
            // means the user has to confirm their use of the site
            $T->tr();
            $T->td("A Confirmation Email has been send to $this->email.<br>
                    Please click the link in that email to Enable your account.");
          } else {
            // means the account is activated immediately
            $T->tr();
            $T->td("Your Account has been created and enabled. You may login immediately! :D.");
          }
        } else {
          // means someone is returning to activate their user account
          if ( isset($SaveReg_x) ) {
            $T->tr();
            $T->td("Registration Updated. Click <a href=\"\" class=\"forumlink\">HERE</a> to view the FORUMS.");
          } else {
            $T->tr();
            $T->td("$this->full_name, your account has now been Enabled. You can now login<br>
                    and start using the forums. Thankyou for registering for the $this->forumfor forums.");
          }
        }
        break;
      case "editreg": // displays the form for editing the registration
      case "newreg": // displays the main registration form.
        debugbr("new registration form");
        $T->tr();
        $T->td("<b>Registration</b>", "forumheadings" );
        $T->td_alignment("center");
        $T->tr();
        $T->td("<hr>");

        if ( trim($this->error_msg) != "" ) {
          $T->tr();
          $T->td("$this->error_msg", "formerror" );
          $T->td_alignment("center");
          $T->tr();
          $T->td("<hr>");
        }
        $F = new form("RegistrationForm");

        if ( trim($this->regmode) == "editreg" ) {
          $userid = new form_labelfield("User id", $this->user_id);
          $uidh = new form_hiddenfield("user_id", $this->user_id);
          $F->add($uidh);
        } else {
          // user_id
          $userid = new form_textfield("user_id", "<font color=\"red\">User id</font>", $this->user_id);
          $userid->setstyle("width: 250");
          $userid->setclass("axtxtbox");
        }

        // password
        if ( trim($this->regmode) == "editreg" ) {
          $password = new form_passwordfield("password", "Change Password", $this->password);
        } else {
          $password = new form_passwordfield("password", "<font color=\"red\">Password</font>", $this->password);
        }
        $password->setstyle("width: 250");
        $password->setclass("axtxtbox");

        // cpassword
        if ( trim($this->regmode) == "editreg" ) {
          $cpassword = new form_passwordfield("cpassword", "Confirm Password");
        } else {
          $cpassword = new form_passwordfield("cpassword", "<font color=\"red\">Confirm Password</font>");
        }
        $cpassword->setstyle("width: 250");
        $cpassword->setclass("axtxtbox");

        // full_name
        $fname = new form_textfield("full_name", "Full Name", $this->full_name);
        $fname->setstyle("width: 250");
        $fname->setclass("axtxtbox");

        // email
        $email_addy = new form_textfield("email", "<font color=\"red\">Email Address</dont>", $this->email);
        $email_addy->setstyle("width: 250");
        $email_addy->setclass("axtxtbox");

        // address
        $addy = new form_textfield("address", "Address", $this->address);
        $addy->setstyle("width: 250");
        $addy->setclass("axtxtbox");

        // phone
        $ph = new form_textfield("phone", "Phone", $this->phone);
        $ph->setstyle("width: 250");
        $ph->setclass("axtxtbox");

        // mobile
        $mob = new form_textfield("mobile", "Mobile", $this->mobile);
        $mob->setstyle("width: 250");
        $mob->setclass("axtxtbox");

        // POST buttons
        $pb = new form_imagebutton("SaveReg", "SaveReg", "", "$LIBDIR/img/_save.gif", "", 57, 15);
        $cb = new form_imagebutton("CancelReg", "CancelReg", "", "$LIBDIR/img/_cancel.gif", "", 57, 15);

        // hidden field(s)
        $rm = new form_hiddenfield("regmode", $this->regmode);
        $ac = new form_hiddenfield("auth_code", $this->auth_code);

        // add the form objects
        $F->add($userid);
        // display password only
        if ( $this->regmode == "editreg" ) {
          $disppw = new form_labelfield("Password",  $this->displaypw);
          $F->add($disppw);
        }
        $F->add($password);
        $F->add($cpassword);
        $F->add($fname);
        $F->add($email_addy);
        $F->add($addy);
        $F->add($ph);
        $F->add($mob);
        $F->add($pb);
        $F->add($cb);
        $F->add($rm);
        $F->add($ac);


        $T->tr();
        $T->td($F->render());

        break;
      default: // this is the default display if the regmode isn't what is expected.
        $T->tr();
        $T->td("<font color=\"red\"><b>INVALID REGISTRATION MODE</b></font>");
        break;
    }

    $s = $T->render();
    return $s;
  } // html

  function POSTprocess() {
    // perform all form stuffs
    global $RESPONSE, $phone, $mobile, $email, $address, $cpassword, $password;
    global $user_id, $full_name, $SaveReg_x, $auth_code, $CancelReg_x;


    if ( isset($SaveReg_x) ) {
      // save button was pressed
      debugbr("AUTH_CODE: $auth_code");
      $this->user_id = trim($user_id);
      $this->phone = trim($phone);
      $this->email = trim($email);
      $this->mobile = trim($mobile);
      $this->password = trim($password);
      $this->full_name = trim($full_name);
      $this->address = trim($address);

      if ( trim($auth_code) == "" ) {
        if ( trim($user_id) != "" && $password == $cpassword && trim($password) != "" && trim($email) != "" &&
             eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $this->email)) {
          // the form requirements have been meet
          if ( $this->save() ) {
            debugbr("SENDING CONFIRMATION EMAIL!");
            $this->send_confirmation_email();
            $this->regmode = "confirm";
          }
        } else {
          // make the error
          $this->regmode = "newreg";
          $this->error_msg = "<ul>";
          if ( trim($user_id) == "" )    $this->error_msg .= "<li>User Id MUST Exist.</li>";
          if ( trim($email) == "" )      $this->error_msg .= "<li>Email MUST Exist.</li>";
          if ( !eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $this->email) ) {
            $this->error_msg .= "<li>Invalid Email Address.</li>";
          }
          if ( trim($password) == "" )   $this->error_msg .= "<li>You MUST Have a Password.</li>";
          if ( $password != $cpassword ) $this->error_msg .= "<li>Your Confirmation Password MUST Match your Password.</li>";
          $this->error_msg .= "</ul>";
        }
      } else {
        debugbr("AUTH CODE HAS A VALUE!");
        $this->auth_code = $auth_code;
        $this->enabled = 't';
        if ( trim($password) == "" && trim($email) != "" &&
             eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $this->email)) {
          if ( $this->save() )
            $this->regmode = "confirm";
        } else {
          if ( $password != $cpassword || trim($email) == "" ||
               !eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $this->email)) {
            // make the error
            $this->regmode = "editreg";
            $this->error_msg = "<ul>";
            if ( trim($email) == "" )      $this->error_msg .= "<li>Email MUST Exist.</li>";
            if ( $password != $cpassword ) $this->error_msg .= "<li>Your Confirmation Password MUST Match your Password.</li>";
            if ( !eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,3})$", $this->email) ) {
              $this->error_msg .= "<li>Invalid Email Address.</li>";
            }
            $this->error_msg .= "</ul>";
          } else {
            $this->savepw = 't';
            if ( $this->save() )
              $this->regmode = "confirm";
          }
        }
      }
    } else {
      debugbr("was the cancel button pressed: $CancelReg_x");
      if ( trim($auth_code) != "" && trim($CancelReg_x) == "" ) {
        debugbr("it's telling me that an authcode exists, and the cancel button WASN'T pressed.");
        // means that a confirmation email has been replied to
        // and th eauth_code has been passed back.
        if ( $this->check_authcode(trim($auth_code)) ) {
          debugbr("AUTHCODE CHECKS OUT!");
          // auth_code is authentic
          $this->enabled = 't';
          if ( !$this->save() ) {
            debugbr("DID NOT ENABLE THE USER!");
            $this->error_msg = "ERROR in Enabling your Account!";
          }
        } else {
          $this->regmode = "noauth";
        }
      }
    }
  } // POSTprocess
} // class user_self_registration

?>