#!/usr/bin/perl
#
# Axyl configuration Script
# This script takes two (mandatory) parameters on the command
# line, and one optional one. It changes the relevant sections
# of the Axyl config 'application.xml' to set the database
# name, username and optional password.
#
#  Parameter 1 - Application prefix
#  Parameter 2 - full path to Axyl website to configure
#  Parameter 3 - the database type code
#  Parameter 4 - the database name
#  Parameter 5 - the user name
#  Parameter 6 - the password
#  Parameter 7 - the database remote hostname
#  Parameter 8 - the database remote port

$APP_PREFIX=$ARGV[0];
$APP_NAME = ucfirst lc $APP_PREFIX;
$WWWPATH=$ARGV[1];
$DBCODE=$ARGV[2];
$DBNAME=$ARGV[3];
$DBUSER=$ARGV[4];
$DBPASSWD=$ARGV[5];
$DBHOST=$ARGV[6];
$DBPORT=$ARGV[7];
$META=$ARGV[8];
$MICRO=$ARGV[9];
if ("$DBCODE" eq "" || "$DBNAME" eq "" || "$DBUSER" eq "") {
  print "ERROR: application config failed - dbtype, dbname and dbuser are required.\n";
  exit 1;
}

# Some translations..
if ("$DBPASSWD" eq "none") {
  $DBPASSWD = "";
}
if ("$DBHOST" eq "direct") {
  $DBHOST = "";
  $DBPORT = "";
}

# Set DBTYPE from DBCODE..
$DBTYPE = "postgres";
if    ($DBCODE == 1) { $DBTYPE = "postgres"; }
elsif ($DBCODE == 2) { $DBTYPE = "mysql"; }
elsif ($DBCODE == 3) { $DBTYPE = "odbc"; }
elsif ($DBCODE == 4) { $DBTYPE = "oracle"; }
elsif ($DBCODE == 5) { $DBTYPE = "mssql_server"; }

if ("$META" eq "y") { $META = "true" } else { $META = "false" }
if ("$MICRO" eq "y") { $MICRO = "true" } else { $MICRO = "false" }

# Files..
$appxml = "$WWWPATH/application.xml";
$appxml_tmp = "$WWWPATH/application.xml.tmp";

# Set up application.xml with database, username
print "setting up Axyl application.xml config file..\n";
if (open APPXML, "<$appxml" ) {
  $customised = 0;
  if (open APPXMLTMP, ">$appxml_tmp" ) {
    $indbtag = 0;
    while (<APPXML>) {
      $line = $_;
      if ($customised eq 0) {
        if ($indbtag eq 1) {
          if (/.*?\<\/setting\>.*?/) {
            $customised = 1;
          }
          else {
            if (/.*?parameter name=\"type\".*?/) {
              $line = "      \<parameter name=\"type\" type=\"string\"\>$DBTYPE\<\/parameter\>\n";
            }
            if (/.*?parameter name=\"name\".*?/) {
              $line = "      \<parameter name=\"name\" type=\"string\"\>$DBNAME\<\/parameter\>\n";
            }
            elsif (/.*?parameter name=\"user\".*?/) {
              $line = "      \<parameter name=\"user\" type=\"string\"\>$DBUSER\<\/parameter\>\n";
            }
            elsif (/.*?parameter name=\"password\".*?/) {
              $line = "      \<parameter name=\"password\" type=\"string\"\>$DBPASSWD\<\/parameter\>\n";
            }
            elsif (/.*?parameter name=\"host\".*?/) {
              $line = "      \<parameter name=\"host\" type=\"string\"\>$DBHOST\<\/parameter\>\n";
            }
            elsif (/.*?parameter name=\"port\".*?/) {
              $line = "      \<parameter name=\"port\" type=\"string\"\>$DBPORT\<\/parameter\>\n";
            }
          }
        }
        elsif (/.*?setting name=\"database\".*?/) {
          $indbtag = 1;
        }
        elsif (/.*?definition name=\"APP_NAME\".*?/) {
          $line = "    \<definition name=\"APP_NAME\"\>$APP_NAME\<\/definition\>\n";
        }
        elsif (/.*?definition name=\"APP_PREFIX\".*?/) {
          $line = "    \<definition name=\"APP_PREFIX\"\>$APP_PREFIX\<\/definition\>\n";
        }
        elsif (/.*?parameter name=\"metadata_enabled\".*?/) {
          $line = "      \<parameter name=\"metadata_enabled\" type=\"boolean\"\>$META\<\/parameter\>\n";
        }
        elsif (/.*?parameter name=\"microsites_enabled\".*?/) {
          $line = "      \<parameter name=\"microsites_enabled\" type=\"boolean\"\>$MICRO\<\/parameter\>\n";
        }
        elsif (/.*?parameter name=\"cookiename\".*?/) {
          $line = "      \<parameter name=\"cookiename\" type=\"string\"\>" . $APP_PREFIX . "_session_id\<\/parameter\>\n";
        }
      }
      print APPXMLTMP $line;
    }
  }
  # Finish up..
  close APPXMLTMP;
  close APPXML;
  if ($customised eq 1) {
    rename $appxml, $appxml . ".bak";
    if (rename $appxml_tmp, $appxml) {
      print "application.xml customisation completed.";
    }
    else {
      print "ERROR: failed to rename '$appxml_tmp' to '$appxml'";
      print "customisation of your application.xml failed.";
    }
  }
}
else {
  print "ERROR: configuration file '$appxml' not found.";
}