#!/bin/bash

# Detection of PHP settings.
# This script is designed to be called either in-line, or run as a
# separate call.
#
# NOTICE: If you want this script to define the PHP_APACHE_MOD and
#         PHP_INI vars, then make sure you have run 'detect-apache.sh'
#         first, and that $APACHE_NAME is defined in the environment
#         before this script is run/sourced.
#
if [ $(id -u) != 0 ]
then
  echo "You must be root to run this script."
  exit 11
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Find apache configuration details. These are then set as exported
# variables for the current session.
PHP_VERSIONS="php5 php4"	# Versions of Php to look for
PHP=						# The 'preferred' version we found
PHP_BIN=					# The path to the php binary itself
PHP_INI_APACHE=				# Path to Apache ini file
PHP_INI_CLI=				# Path to CLI ini file
PHPDET=0					# Flag: =1 if we found at least one Php
PHP_APACHE_MOD=0			# Flag: =1 if apache module is installed

# Versions of php..
PHP_INSTVERS=
for phpver in $PHP_VERSIONS ; do
	if [ -x /usr/bin/${phpver} ] ; then
		if [ "$PHP_INSTVERS" = "" ] ; then
			PHP_INSTVERS=$phpver
			PHP=$phpver
			PHP_BIN=/usr/bin/${phpver}
		else
			PHP_INSTVERS="${PHP_INSTVERS} ${phpver}"
		fi
	fi
done

# If at least one Php is installed, then if we have an /etc/alternatives
# symlink, then that is obviously the preferred version on this machine.
if [ "$PHP_INSTVERS" != "" ] ; then
	if [ -L /etc/alternatives/php ] ; then
		physphp=`readlink /etc/alternatives/php`
		for phpver in $PHP_INSTVERS ; do
			if [ "/usr/bin/${phpver}" = "$physphp" ] ; then
				PHP=$phpver
				PHP_BIN=$physphp
				break
			fi
		done
	fi
fi

# General PHP detection flag
if [ ! -z $PHP ] ; then
	PHPDET=1
fi

# Define CLI ini path
if [ -f /etc/${PHP}/cli/php.ini ] ; then
	PHP_INI_CLI=/etc/${PHP}/cli/php.ini
fi
 
# Define apache module flag, and ini file path
if [ ! -z $APACHE_NAME ] ; then
	if [ -e /usr/lib/${APACHE_NAME}/modules/lib${php}.so ] ; then
		PHP_APACHE_MOD=1
	fi
	if [ -f /etc/${PHP}/${APACHE_NAME}/php.ini ] ; then
		PHP_INI_APACHE=/etc/${PHP}/${APACHE_NAME}/php.ini
	fi
fi

export PHPDET PHP PHP_BIN \
       PHP_INI_APACHE PHP_INI_CLI PHP_APACHE_MOD

# END