#!/bin/bash
###########################################################################
# Pre-Build script executed before dpkg-buildpackage is invoked to
# create the package files.
# P Waite, Nov 2007
#
# This script can be put anywhere you like, but normally it lives in the
# top directory of your source package.
#
###########################################################################

# Insert your custom pre-build processing here.

# Some parameters available to you:
#  $package        your package name, from debian/control
#  $package_ver    debian version being built, from debian/changelog
#  $packagesdir    directory in which the package will be built
#  $VCS            path to VCS executable, eg: /usr/bin/svn
#  $VCSTYPE        type of VCS being used, eg: Vcs-Svn
#
# There are many others (see scripts), but those are the main ones.
#
#
# The below is just an example based on the author's packaging..
#
# Provide versioning info in package /etc area if present
if [ -d etc/${package} ] ; then
  # Update the debian version
  echo "re-writing the version file with ${package_ver}"
  echo $package_ver > etc/${package}/${package}.version

  if [ "$VCSTYPE" = "Vcs-Svn" ] ; then
    # Update the Subversion revision
    mypwd=`pwd`
    cd $package_home
    svnrev=`svn info | grep Revision | awk '{print $2}'`
    cd $mypwd
    echo "re-writing the SVN revision file with ${svnrev}"
    echo $svnrev > etc/${package}/${package}.svn
  fi

fi

# Fix some stuff up before building

echo "cleaning out cruft.."
find . -depth -type d -name "${REPO_CTLDIR}" -exec rm -rf {} \;
find . -type f -name "${REPO_CTLDIR}ignore" -exec rm -f {} \;
find . -type f -name ".#*" -exec rm -f {} \;
find . -type f -name "*.log" -exec rm -f {} \;
find . -type f -name "*.bak" -exec rm -f {} \;
find . -type f -name "diffs.sql" -exec rm -f {} \;

# remove all dojo licences, which we look after
# in our very own debian/copyright file
echo "removing superfluous LICENSE files.."
find . -type f -name "LICENSE" -exec rm -f {} \;

# Remove dojo directories we don't need
dojo_deldirs="tests demos"
for dir in $dojo_deldirs ; do
  echo "removing dojo '$dir' sub-trees"
  find ./lib/js/dojo -depth -type d -name "$dir" -exec rm -rf {} \;
done

echo "fixing package permissions.."
RDWR_EXTNS="php jpg gif png wbmp pdm cdm pdf sql xml db js css html"
EXEC_EXTNS="cgi pl sh"
RDWR_FILES=".htaccess ChangeLog README"
for extn in $RDWR_EXTNS ; do
  find . -iname "*.${extn}" -exec chmod 0664 {} \;
done
for extn in $EXEC_EXTNS ; do
  find . -iname "*.${extn}" -exec chmod 0775 {} \;
done
for file in $RDWR_FILES ; do
  find . -iname "${file}" -exec chmod 0664 {} \;
done
# Special treatment for scripts directory..
find ./scripts -iname "*.php" -exec chmod 775 {} \;

# ENDS
