Summary: 	A Universal Instant Messaging Client 
Name: 		ayttm
Version: 	0.5.0
Release:	10
Group: 		Applications/Internet
License: 	GPL
URL: 		http://ayttm.sourceforge.net
Source: 	%{name}-%{version}.tar.bz2
Buildroot: 	%{_tmppath}/%{name}-%{version}-%{release}-root
Requires:	gdb

# If you want stripped RPM with no crash dialog use
# --define "nodebug 1" in rpmbuild commandline
%if "%{nodebug}" != "1"
%define nodebug 0
%endif

%description
Ayttm is designed to become a Universal Instant Messaging client, seamlessly
integrating all existing Instant Messaging clients and providing a single
consistant user interface. Currently, Ayttm supports sending and receiving
messages through AOL, ICQ, Yahoo, MSN, IRC and Jabber.

%if "%{nodebug}" == "0"
%define optflags -g
%define __spec_install_post %{_libdir}/rpm/brp-compress 
%endif

%define debug_package %{nil}

%prep
%setup 

%build
%if "%{nodebug}" == "0"
%configure --enable-smtp --enable-jasper-filter
%else
%configure --disable-crash-dialog --enable-smtp --enable-jasper-filter
%endif
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
# Install documentation.
%doc COPYING AUTHORS README ChangeLog
# Install man page.
%{_mandir}/man*/*
# Icons and sounds
%{_datadir}/pixmaps/ayttm.png
%{_datadir}/ayttm/sounds/*
%{_datadir}/ayttm/smileys/*
# Red Hat menu (doesn't do any damage on other distros)
%{_datadir}/gnome/apps/Internet/ayttm.desktop
%{_datadir}/applnk/Internet/ayttm.desktop
# Install the modules
%{_libdir}/ayttm/*.a   
%{_libdir}/ayttm/*.la  
%{_libdir}/ayttm/*.so 
# Install translations
%{_datadir}/locale/*/LC_MESSAGES/ayttm.mo
# the config file
%config(noreplace) /etc/ayttmrc
# Lastly, the binary itself
%{_bindir}/ayttm_streamer_wrapper.sh
%{_bindir}/ayttm

%changelog
Wed Aug 22 2007 19:32 UTC [siddheshp]   0.5.0-10

- ChangeLog,configure.ac
Updated version number

Tue Aug 21 2007 20:20 UTC [siddheshp]   0.5.0-9

- ChangeLog
Updated ChangeLog

Tue Aug 21 2007 19:45 UTC [siddheshp]   0.5.0-8

- modules/aim-oscar/libfaim/src/Makefile.am:
Removed CVS from list of sources to be built

Tue Aug 21 2007 18:53 UTC [siddheshp]   0.5.0-7

- Makefile.am, doc/ayttm.1:
Manpage and ayttm.desktop file updates by Kartik Mistry

Sun Aug 19 2007 06:40 UTC [siddheshp]	0.5.0-6

- ChangeLog configure.ac:
Updated release number

Sun Aug 19 2007 06:29 UTC [siddheshp]	0.5.0-5

- configure.ac:
Added Strict checks for flex, bison and g++

Sun Aug 12 2007 20:02 UTC [siddheshp]	0.5.0-4

- modules/jabber/libEBjabber.c:
"Agent List" seems to be deprecated
(http://mailman.linuxpl.org/cicq/2006-March/004571.html) and
hence gives a 501 error with gtalk.

Sun Aug 12 2007 19:51 UTC [siddheshp]	0.5.0-3

- src/status.c:
Fixed crash when trying to drag nothing in status window

Fri Aug 10 2007 20:10 UTC [siddheshp]	0.5.0-2

- modules/smileys/: console_smileys/Makefile.am,
- giles_smiles/Makefile.am:
Fixed output directory names for smileys. I thought I had fixed
this...

Sun Aug 05 2007 11:38 UTC [siddheshp]	0.5.0-1

- po/es.po:
Updated Spanish Translation by Ricardo Mones

Fri Aug 03 2007 20:38 UTC [siddheshp]	0.5.0-0

- ChangeLog, ChangeLog-0.4.6-35, ChangeLog.cvs2cl, Makefile.am,
- README, README.LINUX, configure.ac, gen, doc/Makefile.am,
- doc/gtk2-porting.txt, libproxy/Makefile.am, libproxy/proxy.c,
- m4/Makefile.am, mingw32/Makefile.am, modules/Makefile.am,
- modules/aim-oscar/Makefile.am, modules/aim-oscar/aim-oscar.c,
- modules/aim-oscar/libfaim/Makefile.am,
- modules/aim-oscar/libfaim/include/Makefile.am,
- modules/aim-oscar/libfaim/src/Makefile.am,
- modules/aim-oscar/libfaim/src/rxhandlers.c,
- modules/aim-toc/Makefile.am, modules/aim-toc/aim-toc.c,
- modules/aim-toc/libtoc/Makefile.am,
- modules/aim-toc/libtoc/libtoc.c, modules/aim-toc/libtoc/libtoc.h,
- modules/aycryption/Makefile.am, modules/aycryption/aycryption.c,
- modules/aycryption/select-keys.c,
- modules/aycryption/select-keys.h, modules/icq/Makefile.am,
- modules/icq/libicq/Makefile.am, modules/icq-toc/Makefile.am,
- modules/icq-toc/icq-toc.c, modules/icq-toc/libtoc/Makefile.am,
- modules/icq-toc/libtoc/libtoc.c, modules/icq-toc/libtoc/libtoc.h,
- modules/image_filter/Makefile.am, modules/image_filter/img2jpc.c,
- modules/importers/Makefile.am,
- modules/importers/import_everybuddy.c,
- modules/importers/importicq.c, modules/irc/Makefile.am,
- modules/irc/irc.c, modules/jabber/Makefile.am,
- modules/jabber/jabber.c, modules/jabber/libjabber/Makefile.am,
- modules/jabber/libjabber/jid.c,
- modules/jabber/libjabber/include/Makefile.am,
- modules/jabber/libjabber/include/jabber/Makefile.am,
- modules/jabber/libxode/Makefile.am,
- modules/jabber/libxode/include/Makefile.am,
- modules/livejournal/Makefile.am, modules/msn2/Makefile.am,
- modules/msn2/msn.C, modules/msn2/libmsn2/Makefile.am,
- modules/msn2/libmsn2/msn_bittybits.C,
- modules/msn2/libmsn2/msn_core.h, modules/smileys/Makefile.am,
- modules/smileys/smiley-themer.c,
- modules/smileys/console_smileys/Makefile.am,
- modules/smileys/giles_smiles/Makefile.am,
- modules/smtp/Makefile.am, modules/smtp/smtp.c,
- modules/utility/Makefile.am, modules/workwizu/Makefile.am,
- modules/yahoo2/Makefile.am, modules/yahoo2/yahoo.c,
- modules/yahoo2/libyahoo2/Makefile.am,
- modules/yahoo2/libyahoo2/libyahoo2.c, pixmaps/Makefile.am,
- po/LINGUAS, po/Makefile.in.in, po/de.po, po/en_GB.po, po/es.po,
- po/fr.po, po/hi.po, po/nl.po, po/pt_BR.po, po/sv.po,
- sounds/BuddyArrive.au, sounds/BuddyLeave.au, sounds/Makefile.am,
- sounds/Receive.au, sounds/Send.au, src/Makefile.am, src/about.c,
- src/account.h, src/account_parser.y, src/activity_bar.C,
- src/add_contact_window.c, src/away_window.c, src/browser.c,
- src/charconv.c, src/charconv.h, src/chat_room.c,
- src/chat_window.c, src/chat_window.h, src/console_session.c,
- src/contact.h, src/contact_actions.c, src/contact_parser.y,
- src/crash.c, src/dialog.c, src/edit_account_window.c,
- src/edit_contact_window.c, src/edit_group_window.c,
- src/edit_list_window.c, src/edit_local_accounts.c,
- src/file_select.c, src/file_select.h, src/image_window.c,
- src/info_window.c, src/main.c, src/messages.c, src/nomodule.c,
- src/plugin.c, src/plugin_api.c, src/service.c, src/service.h,
- src/smileys.c, src/sound.c, src/status.c, src/status.h,
- src/tcp_util.c, src/trigger.c, src/usercount.c, src/util.c,
- src/util.h, src/gtk/Makefile.am, src/gtk/about_window.c,
- src/gtk/extgtktext.c, src/gtk/extgtktext.h,
- src/gtk/file_selection_dlg.C, src/gtk/gtk_eb_html.c,
- src/gtk/gtk_eb_html.h, src/gtk/gtk_tree_view_tooltip.c,
- src/gtk/gtk_tree_view_tooltip.h, src/gtk/gtkspell.c,
- src/gtk/gtkspell.h, src/gtk/gtkutils.c, src/gtk/gtkutils.h,
- src/gtk/html_text_buffer.c, src/gtk/html_text_buffer.h,
- src/gtk/log_window.C, src/gtk/message_windows.c,
- src/gtk/prefs_window.C:
Merged gtk2-port into HEAD

* Fri Aug 03 2007 16:47 UTC [siddheshp]

- ChangeLog.cvs2cl:
Sample Changelog using cvs2cl. Command `cvs2cl -b --gmt -f
ChangeLog.cvs2cl`


* Wed Jul 25 2007 19:24 UTC [siddheshp]  0.5.0-0

- configure.ac, gen, modules/aim-oscar/aim-oscar.c,
- modules/msn2/libmsn2/msn_core.h:
Cleaned up some warnings

* Sun Jul 22 2007 17:01 UTC [siddheshp]

- sounds/: BuddyArrive.au, BuddyLeave.au, Receive.au, Send.au:
Converted audio files to Sun/NEXT format. The old ones were wma
audio files renamed to .au

* Tue Jul 17 2007 18:25 UTC [siddheshp]

- configure.ac, gen, po/LINGUAS, po/hi.po,
- src/gtk/html_text_buffer.c:
Multiple changes and fixes:  
* Hindi translation by Ashish Jain
* Configure checks and warnings for Pspell, libxpm-dev, libssl, libtool and more
* Fixes in HTML parsing. Added html, title, pre and p tags to the parser.
Also fixed case when upper case </A> tag is ignored

* Mon Jul 09 2007 16:10 UTC [siddheshp]

- src/gtk/html_text_buffer.c:
Moved variable to start of block

* Sun Jul 08 2007 18:51 UTC [siddheshp]

- src/chat_window.c:
Chat Autocompletion updates: 
* Fixed broken tab completion 
* Use Right and left arrows to stop the autocompletion without changing
cursor position

* Thu Jul 05 2007 18:17 UTC [siddheshp]

- src/gtk/html_text_buffer.c:
Fixes for multiple bugs in the html parser:  
* Strip only known tags; simply write the others out as plain text
* Apply unclosed tags in the end  
* A stray < or > should not break the rest of the html following it

* Mon Jun 25 2007 18:52 UTC [siddheshp]

- configure.ac, src/browser.c:
Look for installed browsers on ./configure instead of blindly
defaulting to mozilla.

* Sun Jun 17 2007 19:18 UTC [siddheshp]

- modules/: aim-toc/aim-toc.c, aim-toc/libtoc/libtoc.c,
- aycryption/aycryption.c, icq-toc/icq-toc.c,
- icq-toc/libtoc/libtoc.c, image_filter/img2jpc.c,
- importers/importicq.c, irc/irc.c, jabber/libjabber/jid.c,
- yahoo2/libyahoo2/libyahoo2.c:
Got rid of some build warnings

* Sun Jun 17 2007 19:10 UTC [siddheshp]

- modules/yahoo2/yahoo.c:
Logging out immediately after login would cause ayttm to lock up
with infinite "Account exists" messages.

* Fri Jun 1 2007 12:28  kartik_m

- debian/: README.Debian, changelog, compat, control, copyright,
- dirs, docs, menu, postinst, rules:
Removing dead debian/ directory

* Fri Jun 1 2007 12:13  kartik_m

- mkinstalldirs:
Added missing mkinstalldirs needed to build po/

* Sun Apr 29 2007 18:27 UTC [siddheshp]

- modules/aycryption/aycryption.c, src/contact.h (gtk2-port):
Removed dependency of core on gpgme.

* Sat Apr 28 2007 20:54 UTC [siddheshp]

- src/gtk/html_text_buffer.c:
Fixed bug where anything between a & and ; gets deleted in chat
text

* Sat Apr 28 2007 20:19 UTC [siddheshp]

- modules/aycryption/Makefile.am, modules/aycryption/aycryption.c,
- modules/aycryption/select-keys.c,
- modules/aycryption/select-keys.h, src/contact.h, configure.ac:
GPGME port from 0.x to 1.x

* Wed Apr 25 2007 17:50 UTC [siddheshp]

- src/charconv.c:
Moved variable declarations to start of block

* Tue Apr 24 2007 22:08 UTC [siddheshp]

- configure.ac, src/Makefile.am:
Removed check for GDK_PIXBUF since its part of gtk now.

* Tue Apr 24 2007 21:57 UTC [siddheshp]

- src/: Makefile.am, account_parser.y, charconv.c, charconv.h,
- contact_parser.y:
Convert non-utf8 buddy name strings to utf8. This will also
automatically import the old contact and account files if they're
in some other non-utf8 charset.

* Tue Apr 24 2007 21:50 UTC [siddheshp]

- modules/msn2/msn.C:
We don't need UTF-8 to native charset conversion -- gtk2 does
UTF-8

* Thu Apr 19 2007 18:45 UTC [siddheshp]

- src/status.c:
Sort contact list alphabetically -- patch by Philip Tellis

* Sun Apr 15 2007 21:42 UTC [siddheshp]

- modules/msn2/libmsn2/msn_bittybits.C:
Allow special characters in msn friendly names

* Sat Apr 14 2007 21:05 UTC [siddheshp]

- src/gtk/prefs_window.C:
The X should destroy the window; Joe user expects that.

* Sat Apr 14 2007 20:27 UTC [siddheshp]

- src/: chat_window.c, status.c:
Fixed keyboard shortcuts for the chat window and the main window
menu.

* Thu Apr 12 2007 18:05 UTC [siddheshp]

- modules/smtp/smtp.c, src/about.c:
Corrected my email address

* Thu Apr 12 2007 12:12  bluesmoon

- src/about.c: 
added siddhesh's name to developers list

* Thu Apr 05 2007 12:55 UTC [siddheshp]

- src/: add_contact_window.c, away_window.c, chat_room.c,
- chat_window.c, dialog.c, edit_account_window.c,
- edit_contact_window.c, edit_list_window.c, edit_local_accounts.c,
- status.c, gtk/gtk_tree_view_tooltip.c, gtk/gtkspell.c,
- gtk/html_text_buffer.c:
Moved variable declarations to start of code blocks

* Tue Apr 03 2007 21:37 UTC [siddheshp]

- modules/importers/importicq.c:
Fixed icqimport crash

* Tue Apr 03 2007 20:57 UTC [siddheshp]

- modules/: aim-oscar/libfaim/src/rxhandlers.c,
- importers/import_everybuddy.c, importers/importicq.c:
More issues caught by -Wall and also by --enable-smtp

* Mon Apr 02 2004 20:41 UTC [siddheshp]

- libproxy/proxy.c, modules/aycryption/select-keys.c,
- modules/yahoo2/yahoo.c, src/add_contact_window.c,
- src/chat_room.c, src/chat_window.c, src/console_session.c,
- src/dialog.c, src/edit_contact_window.c, src/edit_list_window.c,
- src/edit_local_accounts.c, src/info_window.c, src/plugin.c,
- src/plugin_api.c, src/service.c, src/smileys.c, src/sound.c,
- src/status.c, src/status.h, src/tcp_util.c, src/trigger.c,
- src/usercount.c, src/gtk/about_window.c,
- src/gtk/gtk_tree_view_tooltip.c, src/gtk/gtkspell.c,
- src/gtk/gtkutils.c, src/gtk/html_text_buffer.c,
- src/gtk/log_window.C, src/gtk/prefs_window.C:
Mother of all Oops'es -- I was not building with -Wall. NOW most
of the port is done... I hope :)

* Mon Mar 26 2007 20:27 UTC [siddheshp]

- ChangeLog, ChangeLog-0.4.6-35, README, README.LINUX, configure.ac:
Updated ChangeLog and corrected some references to gtk1.2

* Sat Mar 24 2007 17:28 GMT [siddhesh]

- src/status.c:
Fixed the 'Check latest version' check.

* Fri Mar 23 2007 20:30 GMT [siddhesh]

- configure.ac:
Thou shall now be called version 0.5.0 :)

* Wed Mar 21 2007 19:10 GMT [siddhesh]

- modules/yahoo2/yahoo.c:
Allow @ in yahoo usernames as well. See Feature Request #959812.

* Tue Mar 20 2007 20:33 GMT [siddhesh]

- src/gtk/html_text_buffer.c:
Parses &quot; as ". Closes feature request #997779

* Tue Mar 20 2007 20:31 GMT [siddhesh]

- modules/yahoo2/libyahoo2/libyahoo2.c:
Changed printf to DEBUG_MSG

* Sun Mar 18 2007 20:24 GMT [siddhesh]

- modules/yahoo2/libyahoo2/libyahoo2.c:
Fixed status update for yahoo. Yahoo 6 introduces a new service
number 0xc6 for status updates instead of 3 and 4. Now sending
0xc6 results in reception of 3 or 4 depending on whether the user
is going "Away" or coming "(I'm) Back"

* Sun Mar 18 2007 20:21 GMT [siddhesh]

- modules/yahoo2/yahoo.c:
Applied patch #974493. Fixes incorrect comparison of EB_STATUSes
with YAHOO_STATUSes

* Sat Mar 17 2007 18:11 GMT [siddhesh]

- configure.ac, src/chat_window.c, src/crash.c, src/smileys.c,
- src/status.c, src/trigger.c, src/gtk/file_selection_dlg.C,
- src/gtk/gtkutils.c, src/gtk/html_text_buffer.c,
- src/gtk/prefs_window.C:
* Removed XFT dependency 
* Cleaned up obsolete code

* Thu Mar 15 2007 19:34 GMT [siddhesh]

- src/: account.h, status.c, gtk/Makefile.am, gtk/prefs_window.C:
Tooltips implemented in the status window

* Thu Mar 15 2007 19:29 GMT [siddhesh]

- src/gtk/: gtk_tree_view_tooltip.c, gtk_tree_view_tooltip.h:
Custom tooltip widget

* Thu Mar 08 2007 19:11 GMT [siddhesh]

- src/gtk/prefs_window.C:
The "Edit Accounts" menu now works

* Thu Mar 08 2007 18:55 GMT [siddhesh]

- configure.ac, doc/gtk2-porting.txt,
- modules/aycryption/select-keys.c, src/activity_bar.C,
- src/away_window.c, src/dialog.c, src/edit_list_window.c,
- src/status.c, src/gtk/Makefile.am, src/gtk/about_window.c,
- src/gtk/gtkutils.c, src/gtk/log_window.C, src/gtk/prefs_window.C:
Code now builds successfully with -DGTK_DISABLE_DEPRECATED

* Sat Mar 03 2007 20:18 GMT [siddhesh]

- po/LINGUAS:
po/LINGUAS now contains the full set of translations. ALL_LINGUAS
can force only a subset of those to be built for distribution

* Sat Mar 03 2007 20:14 GMT [siddhesh]

- modules/importers/importicq.c, src/file_select.c:
Replaced GtkFileSelection with GtkFileChooser

* Thu Mar 01 2007 21:36 GMT [siddhesh]

- modules/msn2/msn.C, modules/yahoo2/yahoo.c,
- src/contact_actions.c, src/file_select.c, src/file_select.h,
- src/gtk/Makefile.am, src/gtk/file_selection_dlg.C:
Replaced file_selection with file_chooser

* Thu Mar 01 2007 19:45 GMT [siddhesh]

- src/: edit_account_window.c, edit_contact_window.c,
- gtk/prefs_window.C:
Replaced deprecated GtkOptionMenu and GtkCombo

* Thu Mar 01 2007 19:43 GMT [siddhesh]

- src/: status.c, util.c:
Added functions to refresh group and contact lines after editing
them

* Wed Feb 28 2007 02:43 GMT [siddhesh]

- src/add_contact_window.c:
Fixed crash when trying to add accounts with no services defined.

* Wed Feb 28 2007 02:33 GMT [siddhesh]

- src/add_contact_window.c:
Replaced deprecated GtkCombo with GtkComboBoxEntry

* Sat Feb 24 2007 11:57 GMT [siddhesh]

- src/: chat_room.c, chat_window.h, edit_list_window.c, trigger.c:
Ported deprecated GtkCombo to GtkComboBox and GtkCList to
GtkTreeView

* Fri Feb 23 2007 22:25 GMT [siddhesh]

- src/: image_window.c, info_window.c, smileys.c:
Replace deprecated GtkPixmap with GtkImage

* Fri Feb 23 2007 21:51 GMT [siddhesh]

- src/: add_contact_window.c, edit_contact_window.c:
Ported deprecated GtkOptionMenu to GtkComboBox

* Fri Feb 23 2007 21:35 GMT [siddhesh]

- src/edit_local_accounts.c:
Ported deprecated GtkOptionMenu to GtkComboBox and GtkCList to
GtkTreeView

* Thu Feb 22 2007 19:37 GMT [siddhesh]

- src/gtk/prefs_window.C:
Corrected selection mode from Single to Browse to force atleast
one selection to persist.

* Thu Feb 22 2007 19:35 GMT [siddhesh]

- src/messages.c:
Replaced custom dialog boxes with GtkMessageDialog

* Thu Feb 22 2007 19:34 GMT [siddhesh]

- src/: chat_room.c, chat_window.c, dialog.c, trigger.c,
- gtk/about_window.c, gtk/html_text_buffer.c:
Replaced deprecated GtkPixmap with GtkImage

* Wed Feb 21 2007 20:16 GMT [siddhesh]

- src/gtk/: gtk_eb_html.c, gtk_eb_html.h:
Old html parser -- not needed anymore

* Wed Feb 21 2007 20:00 GMT [siddhesh]

- modules/aycryption/select-keys.c, src/chat_room.c,
- src/chat_window.c, src/edit_list_window.c,
- src/edit_local_accounts.c, src/status.c, src/gtk/prefs_window.C:
Replaced deprecated functions for toolbars and signals

* Tue Feb 20 2007 20:40 GMT [siddhesh]

- src/: add_contact_window.c, away_window.c, chat_room.c,
- chat_window.c, dialog.c, edit_account_window.c,
- edit_contact_window.c, edit_group_window.c, edit_list_window.c,
- edit_local_accounts.c, info_window.c, main.c, status.c,
- trigger.c, gtk/about_window.c, gtk/gtkutils.c, gtk/gtkutils.h,
- gtk/prefs_window.C:
Multiple fixes: default window icon, replaced some deprecated
functions.

* Sun Feb 18 2007 19:47 GMT [siddhesh]

- configure.ac, doc/gtk2-porting.txt, src/chat_window.c,
- src/edit_list_window.c, src/status.c, src/gtk/html_text_buffer.c,
- src/gtk/prefs_window.C:
* Build without GTK_ENABLE_BROKEN 
* Auto-scroll during drag in status window 
* Fixed resize of preferences window

* Sun Feb 18 2007 12:12 GMT [siddhesh]

- src/dialog.c:
Yet another gtktext becomes gtktextview

* Sun Feb 18 2007 09:50 GMT [siddhesh]

- src/smileys.c:
Fixed smiley selection. Yahoo showed MSN smileys when using the
Default Protocol Smileys

* Sat Feb 17 2007 07:35 GMT [siddhesh]

- src/: away_window.c, edit_list_window.c:
Widget port: gtktext to gtktextview

* Sat Feb 17 2007 06:21 GMT [siddhesh]

- src/status.c:
Fixed the autoresize bug in status window

* Sat Feb 17 2007 06:20 GMT [siddhesh]

- src/gtk/gtkspell.c:
Menu popup now comes up with the menu key (or Shift+F10) as well

* Sat Feb 17 2007 03:03 GMT [siddhesh]

- configure.ac:
We need GTK 2.6 or later for now.

* Fri Feb 16 2007 18:35 GMT [siddhesh]

- src/gtk/Makefile.am:
We don't need gtk_eb_html.[c|h] anymore

* Fri Feb 16 2007 18:34 GMT [siddhesh]

- src/gtk/: gtkspell.c, gtkspell.h:
Spell check is working now

* Fri Feb 16 2007 09:58 GMT [siddhesh]

- src/gtk/html_text_buffer.c:
don't delete text marks after they're done as bad html needs it
- :)

* Fri Feb 16 2007 08:55 GMT [siddhesh]

- src/gtk/html_text_buffer.c:
Links now open on double click instead of single click

* Wed Feb 14 2007 19:15 GMT [philip]

- src/Makefile.am:
comment at start of rule is unportable

* Sat Feb 10 2007 18:32 GMT [siddhesh]

- doc/gtk2-porting.txt, modules/aycryption/aycryption.c,
- modules/aycryption/select-keys.c, src/add_contact_window.c,
- src/away_window.c, src/edit_account_window.c,
- src/edit_contact_window.c, src/edit_list_window.c,
- src/edit_local_accounts.c, src/image_window.c, src/info_window.c,
- src/smileys.c, src/trigger.c, src/usercount.c,
- src/gtk/message_windows.c:
replaced deprecated set_usize with set_size_request

* Sat Feb 10 2007 18:30 GMT [siddhesh]

- src/gtk/html_text_buffer.c:
Finally got a non-deprecated function to show pixmaps

* Sat Feb 10 2007 18:29 GMT [siddhesh]

- src/: status.c, gtk/gtkutils.c:
Ported menu and contact tree view in status window

* Sat Feb 03 2007 21:50 GMT [siddhesh]

- modules/aycryption/aycryption.c,
- modules/aycryption/select-keys.c,
- modules/importers/import_everybuddy.c,
- modules/importers/importicq.c, src/add_contact_window.c,
- src/away_window.c, src/chat_room.c, src/crash.c, src/dialog.c,
- src/edit_account_window.c, src/edit_contact_window.c,
- src/edit_group_window.c, src/edit_list_window.c,
- src/edit_local_accounts.c, src/image_window.c, src/info_window.c,
- src/smileys.c, src/status.c, src/trigger.c, src/usercount.c,
- src/gtk/about_window.c, src/gtk/gtkspell.c, src/gtk/gtkutils.c,
- src/gtk/message_windows.c:
Ported signal functions to their gtk2 equivalents

* Sat Feb 03 2007 20:32 GMT [siddhesh]

- src/: edit_account_window.c, edit_contact_window.c:
Fixed edit acount/contact windows. GtkDialog cannot have multiple
widgets

* Sat Feb 03 2007 19:45 GMT [siddhesh]

- src/: chat_room.c, chat_window.c:
Fixed autocomplete, ported chat window and room toolbars to gtk2

* Fri Feb 02 2007 19:54 GMT [siddhesh]

- src/smileys.c:
Fixed smiley window which was broken due to the text entry port

* Fri Jan 31 2007 18:06 GMT [siddhesh]

- src/: chat_room.c, chat_window.c:
Ported message entry widgets to gtktextview.
multi-line/single-line works now

* Wed Jan 31 2007 23:05 GMT [siddhesh]

- src/: chat_window.c, gtk/html_text_buffer.c:
ported chat window entry (gtk_text) to to gtk_text_view

* Wed Jan 31 2007 23:03 GMT [siddhesh]

- src/crash.c:
ported gtk_text to gtk_text_view

* Tue Jan 30 2007 19:25 GMT [siddhesh]

- doc/gtk2-porting.txt, src/gtk/html_text_buffer.c:
Fixed transparency issue with smileys and icons

* Tue Jan 30 2007 17:11 GMT [siddhesh]

- doc/gtk2-porting.txt, modules/aim-oscar/aim-oscar.c,
- modules/aycryption/aycryption.c, modules/irc/irc.c,
- src/chat_room.c, src/chat_window.c, src/info_window.c,
- src/status.c:
Fixed broken html in chat adn log windows.

* Tue Jan 30 2007 17:09 GMT [siddhesh]

- src/gtk/: Makefile.am, gtk_eb_html.c, html_text_buffer.c,
- html_text_buffer.h, log_window.C:
Fixed broken html in chat and log windows

* Fri Jan 12 2007 18:16 GMT [siddhesh]

- src/chat_window.c:
Reversed smiley window fix. Needs more testing.

* Thu Jan 11 2007 21:29 GMT [siddhesh]

- doc/gtk2-porting.txt, src/gtk/prefs_window.C:
Porting widgets to gtk2 - Tree to TreeView

* Sun Jan 07 2007 19:21 GMT [siddhesh]

- src/chat_window.c:
Smiley popup now shows up on first click as well

* Sun Jan 07 2007 19:18 GMT [siddhesh]

- src/smileys.c:
Fixed smiley popup

* Sat Jan 06 2007 16:34 GMT [siddhesh]

- Makefile.am, doc/Makefile.am, doc/gtk2-porting.txt,
- libproxy/Makefile.am, m4/Makefile.am, mingw32/Makefile.am,
- modules/Makefile.am, modules/aim-oscar/Makefile.am,
- modules/aim-oscar/libfaim/Makefile.am,
- modules/aim-oscar/libfaim/include/Makefile.am,
- modules/aim-oscar/libfaim/src/Makefile.am,
- modules/aim-toc/Makefile.am, modules/aim-toc/aim-toc.c,
- modules/aim-toc/libtoc/Makefile.am,
- modules/aim-toc/libtoc/libtoc.h, modules/aycryption/Makefile.am,
- modules/aycryption/select-keys.c, modules/icq/Makefile.am,
- modules/icq/libicq/Makefile.am, modules/icq-toc/Makefile.am,
- modules/icq-toc/icq-toc.c, modules/icq-toc/libtoc/Makefile.am,
- modules/icq-toc/libtoc/libtoc.h,
- modules/image_filter/Makefile.am, modules/image_filter/img2jpc.c,
- modules/importers/Makefile.am, modules/importers/importicq.c,
- modules/irc/Makefile.am, modules/jabber/Makefile.am,
- modules/jabber/libjabber/Makefile.am,
- modules/jabber/libjabber/include/Makefile.am,
- modules/jabber/libjabber/include/jabber/Makefile.am,
- modules/jabber/libxode/Makefile.am,
- modules/jabber/libxode/include/Makefile.am,
- modules/livejournal/Makefile.am, modules/msn2/Makefile.am,
- modules/msn2/libmsn2/Makefile.am, modules/smileys/Makefile.am,
- modules/smileys/console_smileys/Makefile.am,
- modules/smileys/giles_smiles/Makefile.am,
- modules/smtp/Makefile.am, modules/utility/Makefile.am,
- modules/workwizu/Makefile.am, modules/yahoo2/Makefile.am,
- modules/yahoo2/libyahoo2/Makefile.am, pixmaps/Makefile.am,
- po/Makefile.in.in, po/de.po, po/en_GB.po, po/es.po, po/fr.po,
- po/nl.po, po/pt_BR.po, po/sv.po, sounds/Makefile.am,
- src/Makefile.am, src/gtk/Makefile.am:
fixed build and configure warnings

* Sat Jan 05 2007 16:28 GMT [siddhesh]

- src/: chat_room.c, status.c:
Fixed toolbars

* Fri Jan 05 2007 21:00 GMT [siddhesh]

- src/: main.c, status.c:
Fixed error messages on program close

* Fri Jan 05 2007 20:58 GMT [siddhesh]

- src/: chat_room.c, chat_window.c:
UI fixes to chat window, many yet to come.

* Fri Jan 05 2007 19:15 GMT [siddhesh]

- modules/irc/irc.c:
Fixed compile time warnings

* Fri Jan 05 2007 19:09 GMT [siddhesh]

- src/: add_contact_window.c, edit_account_window.c, util.c,
- util.h:
Cleaned up compiler warnings

* Mon Jan 01 2007 11:23 GMT [philip]

- doc/gtk2-porting.txt:
updated status

* Mon Jan 01 2007 11:19 GMT [philip]

- src/: add_contact_window.c, edit_group_window.c,
- edit_local_accounts.c, status.c:
UI fixes for gtk2 - patch by Siddhesh Poyarekar

* Mon Jan 01 2007 11:17 GMT [philip]

- modules/smileys/: console_smileys/Makefile.am,
- giles_smiles/Makefile.am:
makefile fixes for space in directory
name - patch by Siddhesh Poyarekar

* Mon Jan 01 2007 10:59 GMT [philip]

- modules/aycryption/: aycryption.c, select-keys.c:
make aycryption work with gtk2 also - patch by Siddhesh Poyarekar

* Mon Jan 01 2007 10:38 GMT [philip]

- src/activity_bar.C:
gtk2 progress bar is easier to work with :)

* Mon Jan 01 2007 10:36 GMT [philip]

- libproxy/proxy.c:
don't throw an error on connect failure - let
the calling lib fallback if possible and throw the error if
necessary.  also fix indentation

* Sun Dec 31 2006 08:12 GMT [philip]

- doc/gtk2-porting.txt:
document to decribe porting to gtk2

* Sun Dec 31 2006 07:44 GMT [philip]

- configure.ac, modules/importers/import_everybuddy.c,
- modules/irc/irc.c, modules/jabber/jabber.c, modules/msn2/msn.C,
- modules/smileys/smiley-themer.c,
- modules/smileys/console_smileys/Makefile.am,
- modules/smileys/giles_smiles/Makefile.am, modules/yahoo2/yahoo.c,
- src/activity_bar.C, src/add_contact_window.c, src/chat_room.c,
- src/chat_window.c, src/chat_window.h, src/dialog.c,
- src/edit_account_window.c, src/edit_contact_window.c,
- src/edit_group_window.c, src/edit_list_window.c,
- src/edit_local_accounts.c, src/image_window.c, src/info_window.c,
- src/nomodule.c, src/plugin_api.c, src/service.c, src/service.h,
- src/smileys.c, src/status.c, src/trigger.c, src/gtk/Makefile.am,
- src/gtk/extgtktext.c, src/gtk/extgtktext.h,
- src/gtk/gtk_eb_html.c, src/gtk/gtk_eb_html.h, src/gtk/gtkutils.c,
- src/gtk/log_window.C, src/gtk/prefs_window.C: 
initial gtk2 port (note binary compatibility breakage)


