/*
 * Created on 2004-2-10
 */
package org.cneclipse.bdcc;

import java.io.*;
import java.util.*;
import org.cneclipse.bdcc.ui.*;
import org.gudy.azureus2.plugins.*;
import org.gudy.azureus2.plugins.download.*;
import org.gudy.azureus2.plugins.utils.*;
import org.gudy.azureus2.plugins.ui.config.*;
import org.jibble.lz.pircbot.*;

/**
 * @author Leon
 */
public class BDCCPlugin implements Plugin {

	private static BDCCIrcClient	client1			= null;
	private static BDCCIrcClient	client2			= null;
	private static BDCCIrcClient	client3			= null;
	private static Properties		historyData		= null;
	private static PluginInterface	pluginInterface;
	public static boolean			bdccIsInited	= false;

	/**
	 * @return Returns the client1.
	 */
	public static BDCCIrcClient getClient1() {
		return client1;
	}

	/**
	 * @return Returns the client2.
	 */
	public static BDCCIrcClient getClient2() {
		return client2;
	}

	/**
	 * @return Returns the client3.
	 */
	public static BDCCIrcClient getClient3() {
		return client3;
	}

	public static long getDownloaded() {
		String downloadedStr = getProperties("Downloaded");
		long downloaded = 0;
		try {
			downloaded = Long.parseLong(downloadedStr);
		} catch (NumberFormatException e) {
		}
		return downloaded;
	}

	public static long getUploaded() {
		String uploadedStr = getProperties("Uploaded");
		long uploaded = 0;
		try {
			uploaded = Long.parseLong(uploadedStr);
		} catch (NumberFormatException e) {
		}
		return uploaded;
	}

	public static void updateHistoryData(long downloaded, long uploaded) {
		downloaded += getDownloaded();
		uploaded += getUploaded();
		historyData.setProperty("Downloaded", "" + downloaded);
		historyData.setProperty("Uploaded", "" + uploaded);
		String propertiesFile = pluginInterface.getPluginDirectoryName() + File.separator + "status.properties";
		try {
			historyData.save(new FileOutputStream(new File(propertiesFile)), "Status log");
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}
	}

	/**
	 * @param string
	 * @return
	 */
	private static String getProperties(String key) {
		if (historyData == null) {
			historyData = new Properties();
			String propertiesFile = pluginInterface.getPluginDirectoryName() + File.separator + "status.properties";
			try {
				historyData.load(new FileInputStream(propertiesFile));
			} catch (FileNotFoundException e) {
			} catch (IOException e) {
			}
		}
		return historyData.getProperty(key);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.plugins.Plugin#initialize(org.gudy.azureus2.plugins.PluginInterface)
	 */
	public void initialize(final PluginInterface pluginInterface) throws PluginException {
		BDCCPlugin.pluginInterface = pluginInterface;
		final PluginConfig config = pluginInterface.getPluginconfig();
		client1 = new BDCCIrcClient(pluginInterface, 1);
		client2 = new BDCCIrcClient(pluginInterface, 2);
		client3 = new BDCCIrcClient(pluginInterface, 3);
		if (config.getPluginBooleanParameter("BDCC Enable Server 1", false)) client1.connectToServer();
		if (config.getPluginBooleanParameter("BDCC Enable Server 2", false)) client2.connectToServer();
		if (config.getPluginBooleanParameter("BDCC Enable Server 3", false)) client3.connectToServer();
		pluginInterface.addConfigUIParameters(getIrcParameter(pluginInterface), "BDCC.Config.Irc");
		pluginInterface.addConfigUIParameters(getAdminParameter(pluginInterface), "BDCC.Config.BDCC");
		pluginInterface.getUIManager().getSWTManager().addView(new BDCCPluginView(pluginInterface));
		pluginInterface.addListener(new PluginListener() {

			public void initializationComplete() {
				bdccIsInited = true;
			}

			public void closedownInitiated() {
				bdccIsInited = false;
				// Logoff
				if (client1 != null && client1.isConnected()) {
					client1.quitServer(BDCCIrcClient.VERSION_INFO + " on " + pluginInterface.getAzureusName() + " "
							+ pluginInterface.getAzureusVersion() + " running " + client1.getRunningTime());
					client1.setQuit(true);
				}
				if (client2 != null && client2.isConnected()) {
					client2.quitServer(BDCCIrcClient.VERSION_INFO + " on " + pluginInterface.getAzureusName() + " "
							+ pluginInterface.getAzureusVersion() + " running " + client2.getRunningTime());
					client2.setQuit(true);
				}
				if (client3 != null && client3.isConnected()) {
					client3.quitServer(BDCCIrcClient.VERSION_INFO + " on " + pluginInterface.getAzureusName() + " "
							+ pluginInterface.getAzureusVersion() + " running " + client3.getRunningTime());
					client3.setQuit(true);
				}
			}

			public void closedownComplete() {
				// Do nothing
			}
		});
		pluginInterface.getDownloadManager().addListener(new DownloadManagerListener() {

			public void downloadAdded(Download download) {
				if (config.getPluginBooleanParameter("BDCC Send Update Notice", true)) {
					if (client1 != null && bdccIsInited && client1.isConnected())
							client1.sendAction(client1.getChannel(), "--> " + download.getName() + " added to #"
									+ (download.getIndex() + 1) + ". Use \"/msg " + client1.getNick() + " bt info #"
									+ (download.getIndex() + 1) + "\" to get torrent information.");
					if (client2 != null && bdccIsInited && client2.isConnected())
							client2.sendAction(client2.getChannel(), "--> " + download.getName() + " added to #"
									+ (download.getIndex() + 1) + ". Use \"/msg " + client2.getNick() + " bt info #"
									+ (download.getIndex() + 1) + "\" to get torrent information.");
					if (client3 != null && bdccIsInited && client3.isConnected())
							client3.sendAction(client3.getChannel(), "--> " + download.getName() + " added to #"
									+ (download.getIndex() + 1) + ". Use \"/msg " + client3.getNick() + " bt info #"
									+ (download.getIndex() + 1) + "\" to get torrent information.");
				}
			}

			public void downloadRemoved(Download download) {
				updateHistoryData(download.getStats().getDiscarded(), download.getStats().getUploaded());
				if (config.getPluginBooleanParameter("BDCC Send Update Notice", true)) {
					if (client1 != null && client1.isConnected())
							client1.sendAction(client1.getChannel(), "--> " + download.getName() + " removed");
					if (client2 != null && client2.isConnected())
							client2.sendAction(client2.getChannel(), "--> " + download.getName() + " removed");
					if (client3 != null && client3.isConnected())
							client3.sendAction(client3.getChannel(), "--> " + download.getName() + " removed");
				}
			}
		});
	}

	/**
	 * @param pluginInterface
	 * @return
	 */
	private Parameter[] getAdminParameter(PluginInterface pluginInterface) {
		PluginConfigUIFactory configFactory = pluginInterface.getPluginConfigUIFactory();
		Parameter[] para = new Parameter[20];
		para[0] = configFactory.createBooleanParameter("BDCC Enable Admin", "BDCC.Admin.Enable", false);
		para[1] = configFactory.createStringParameter("BDCC Admin Password", "BDCC.Admin.Password", "");
		((EnablerParameter) para[0]).addEnabledOnSelection(para[1]);
		para[2] = configFactory.createStringParameter("BDCC Admin Host Mask", "BDCC.Admin.Host", "*!*@*");
		((EnablerParameter) para[0]).addEnabledOnSelection(para[2]);
		para[7] = configFactory.createBooleanParameter("BDCC Response To list", "BDCC.IRCList", true);
		para[8] = configFactory.createStringParameter("BDCC Color 1", "BDCC.Color1", Colors.DARK_GREEN, IRC_COLOR,
				IRC_COLOR_CODE);
		para[9] = configFactory.createStringParameter("BDCC Color 2", "BDCC.Color2", Colors.BLUE, IRC_COLOR,
				IRC_COLOR_CODE);
		para[10] = configFactory.createBooleanParameter("BDCC Send Torrent", "BDCC.SendTorrent", true);
		para[11] = configFactory.createIntParameter("BDCC DCC Send Port Low", "BDCC.DCC.Lowport", 0);
		para[12] = configFactory.createIntParameter("BDCC DCC Send Port High", "BDCC.DCC.Highport", 0);
		((EnablerParameter) para[10]).addEnabledOnSelection(para[11]);
		((EnablerParameter) para[10]).addEnabledOnSelection(para[12]);
		para[13] = configFactory.createBooleanParameter("BDCC Enable AD", "BDCC.AD.Enable", false);
		para[14] = configFactory.createIntParameter("BDCC AD Delay", "BDCC.AD.Delay", 60);
		((EnablerParameter) para[13]).addEnabledOnSelection(para[14]);
		para[15] = configFactory.createStringParameter("BDCC AD Headline", "BDCC.AD.Headline", "Good Stuff Here!!");
		((EnablerParameter) para[13]).addEnabledOnSelection(para[15]);
		para[16] = configFactory.createStringParameter("BDCC AD Creditline", "BDCC.AD.Creditline",
				"Brought to you by me.");
		((EnablerParameter) para[13]).addEnabledOnSelection(para[16]);
		para[17] = configFactory.createBooleanParameter("BDCC Send Update Notice", "BDCC.AD.Send.Info", true);
		return para;
	}

	/**
	 * Init parameters
	 */
	private Parameter[] getIrcParameter(PluginInterface pluginInterface) {
		PluginConfigUIFactory configFactory = pluginInterface.getPluginConfigUIFactory();
		Parameter[] para = new Parameter[50];
		para[0] = configFactory.createBooleanParameter("BDCC Enable Server 1", "IRC.Enable.Server.1", false);
		para[1] = configFactory.createStringParameter("BDCC IRC Server 1", "IRC.Address", "");
		para[2] = configFactory.createIntParameter("BDCC IRC Server Port 1", "IRC.Port", 6667);
		para[3] = configFactory.createStringParameter("BDCC IRC Nickname 1", "IRC.Nick", "");
		para[5] = configFactory.createStringParameter("BDCC IRC Channel 1", "IRC.Channel", "");
		para[6] = configFactory.createStringParameter("BDCC IRC Channel Password 1", "IRC.Channel.Password", "");
		//		((EnablerParameter) para[0]).addEnabledOnSelection(para[1]);
		//		((EnablerParameter) para[0]).addEnabledOnSelection(para[2]);
		//		((EnablerParameter) para[0]).addEnabledOnSelection(para[3]);
		//		((EnablerParameter) para[0]).addEnabledOnSelection(para[5]);
		//		((EnablerParameter) para[0]).addEnabledOnSelection(para[6]);
		para[10] = configFactory.createBooleanParameter("BDCC Enable Server 2", "IRC.Enable.Server.2", false);
		para[11] = configFactory.createStringParameter("BDCC IRC Server 2", "IRC.Address", "");
		para[12] = configFactory.createIntParameter("BDCC IRC Server Port 2", "IRC.Port", 6667);
		para[13] = configFactory.createStringParameter("BDCC IRC Nickname 2", "IRC.Nick", "");
		para[15] = configFactory.createStringParameter("BDCC IRC Channel 2", "IRC.Channel", "");
		para[16] = configFactory.createStringParameter("BDCC IRC Channel Password 2", "IRC.Channel.Password", "");
		//		((EnablerParameter) para[10]).addEnabledOnSelection(para[11]);
		//		((EnablerParameter) para[10]).addEnabledOnSelection(para[12]);
		//		((EnablerParameter) para[10]).addEnabledOnSelection(para[13]);
		//		((EnablerParameter) para[10]).addEnabledOnSelection(para[15]);
		//		((EnablerParameter) para[10]).addEnabledOnSelection(para[16]);
		para[20] = configFactory.createBooleanParameter("BDCC Enable Server 3", "IRC.Enable.Server.3", false);
		para[21] = configFactory.createStringParameter("BDCC IRC Server 3", "IRC.Address", "");
		para[22] = configFactory.createIntParameter("BDCC IRC Server Port 3", "IRC.Port", 6667);
		para[23] = configFactory.createStringParameter("BDCC IRC Nickname 3", "IRC.Nick", "");
		para[25] = configFactory.createStringParameter("BDCC IRC Channel 3", "IRC.Channel", "");
		para[26] = configFactory.createStringParameter("BDCC IRC Channel Password 3", "IRC.Channel.Password", "");
		//		((EnablerParameter) para[20]).addEnabledOnSelection(para[21]);
		//		((EnablerParameter) para[20]).addEnabledOnSelection(para[22]);
		//		((EnablerParameter) para[20]).addEnabledOnSelection(para[23]);
		//		((EnablerParameter) para[20]).addEnabledOnSelection(para[25]);
		//		((EnablerParameter) para[20]).addEnabledOnSelection(para[26]);
		// Encoding Setting
		LocaleUtilities luts = pluginInterface.getUtilities().getLocaleUtilities();
		LocaleDecoder[]	decoders = luts.getDecoders();
		String decoderLabels[] = new String[decoders.length + 1];
		String decoderValues[] = new String[decoders.length + 1];
		decoderLabels[0] = luts.getLocalisedMessageText("ConfigView.section.file.decoder.nodecoder");
		decoderValues[0] = "";
		for (int i = 1; i <= decoders.length; i++) {
			decoderLabels[i] = decoderValues[i] = decoders[i - 1].getName();
		}
		para[30] = configFactory.createStringParameter("BDCC IRC Encoding", "IRC.Encoding", "", decoderLabels,
				decoderValues);
		return para;
	}

	private static final String[]	IRC_COLOR		= { Colors.WHITE, Colors.BLACK, Colors.DARK_BLUE,
			Colors.DARK_GREEN, Colors.RED, Colors.BROWN, Colors.PURPLE, Colors.OLIVE, Colors.YELLOW, Colors.GREEN,
			Colors.TEAL, Colors.CYAN, Colors.BLUE, Colors.MAGENTA, Colors.DARK_GRAY, Colors.LIGHT_GRAY};
	private static final String[]	IRC_COLOR_CODE	= { "White", "Black", "Dark Blue", "Dark Green", "Red", "Brown",
			"Purple", "Olive", "Yellow", "Green", "Teal", "Cyan", "Blue", "Magenta", "Dark Gray", "Light Gray"};
}