/*
 * Created on 2004-3-11
 */
package org.cneclipse.bdcc;

import java.io.*;
import org.gudy.azureus2.plugins.download.*;
import org.jibble.lz.pircbot.*;

/**
 * @author Leon
 */
public class BDCCTorrentListener implements DownloadListener, DownloadTrackerListener {

	private DccChat chat;
	private Download download;

	/**
	 * @param download
	 * @param chat
	 */
	public BDCCTorrentListener(Download download, DccChat chat) {
		this.download = download;
		this.chat = chat;
		download.addListener(this);
		download.addTrackerListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.plugins.download.DownloadListener#stateChanged(org.gudy.azureus2.plugins.download.Download,
	 *      int, int)
	 */
	public void stateChanged(Download download, int old_state, int new_state) {
		try {
			if (BDCCPlugin.bdccIsInited)
				chat.sendLine("--> Download #" + (download.getIndex() + 1) + " " + download.getName()
						+ " state updated from [" + BDCCHelper.getDescriptionOfStatus(old_state) + "] to ["
						+ BDCCHelper.getDescriptionOfStatus(new_state) + "]");
		} catch (IOException e) {
		}
	}

	/**
	 * @return Returns the download.
	 */
	public Download getDownload() {
		return download;
	}

	/**
	 *  
	 */
	public void remove() {
		download.removeListener(this);
		download.removeTrackerListener(this);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.plugins.download.DownloadTrackerListener#scrapeResult(org.gudy.azureus2.plugins.download.DownloadScrapeResult)
	 */
	public void scrapeResult(DownloadScrapeResult result) {
		try {
			if (result.getResponseType() == DownloadScrapeResult.RT_SUCCESS)
				chat.sendLine("--> Download #" + (download.getIndex() + 1) + " " + download.getName()
						+ " scrape OK! Seed(s):" + result.getSeedCount() + " Peer(s):" + result.getNonSeedCount());
		} catch (IOException e) {
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.gudy.azureus2.plugins.download.DownloadTrackerListener#announceResult(org.gudy.azureus2.plugins.download.DownloadAnnounceResult)
	 */
	public void announceResult(DownloadAnnounceResult result) {
		try {
			if (result.getResponseType() == DownloadAnnounceResult.RT_SUCCESS)
				chat.sendLine("--> Download #" + (download.getIndex() + 1) + " " + download.getName()
						+ " announce OK! Seed(s):" + result.getSeedCount() + " Peer(s):" + result.getNonSeedCount());
			else
				chat.sendLine("--> Download #" + (download.getIndex() + 1) + " " + download.getName()
						+ " announce failed! Error: " + result.getError());
		} catch (IOException e) {
		}
	}

	/* (non-Javadoc)
	 * @see org.gudy.azureus2.plugins.download.DownloadListener#positionChanged(org.gudy.azureus2.plugins.download.Download, int, int)
	 */
	public void positionChanged(Download download, int oldPosition, int newPosition) {
		//Do nothing now...
	}
}
