/*
 * Created on 2004-2-20
 */
package org.cneclipse.bdcc;

import java.io.*;
import java.util.*;

import org.gudy.azureus2.plugins.*;
import org.gudy.azureus2.plugins.download.*;
import org.jibble.lz.pircbot.*;

/**
 * @author Leon
 */
public class BDCCAdminChat {

	private DccChat chat;
	private BDCCAdminCommands commands;
	private PluginConfig config;

	private List torrentListeners = null;

	/**
	 * @param chat
	 */
	public BDCCAdminChat(BDCCAdminCommands commands, DccChat chat, PluginConfig config) {
		super();
		this.chat = chat;
		this.commands = commands;
		this.config = config;
		torrentListeners = new ArrayList();
		try {
			while (true) {
				String input = chat.readLine();
				if (input == null)
					break;
				String[] incomingWords = BDCCHelper.splitWords(input);
				try {
					if (incomingWords.length == 0) {
						sendWrongInput();
					} else if (incomingWords[0].equalsIgnoreCase("help")) {
						sendHelpMessages();
					} else if (incomingWords[0].equalsIgnoreCase("XDL")) {
						String[] list = commands.getAllTorrents();
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
						chat.sendLine("--> " + commands.getStatusLines());
						for (int i = 0; i < list.length; i++) {
							chat.sendLine("--> " + list[i]);
						}
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
						chat.sendLine("--> ** Returned All Torrents.");
					} else if (incomingWords[0].equalsIgnoreCase("DCL")) {
						String[] list = commands.getDownloadingTorrents();
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
						chat.sendLine("--> " + commands.getStatusLines());
						for (int i = 0; i < list.length; i++) {
							chat.sendLine("--> " + list[i]);
						}
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
						chat.sendLine("--> ** Returned All Downloading Torrents.");
					} else if (incomingWords[0].equalsIgnoreCase("SCL")) {
						String[] list = commands.getSeedingTorrents();
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
						chat.sendLine("--> " + commands.getStatusLines());
						for (int i = 0; i < list.length; i++) {
							chat.sendLine("--> " + list[i]);
						}
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
						chat.sendLine("--> ** Returned All Seeding Torrents.");
					} else if (incomingWords[0].equalsIgnoreCase("QUL")) {
						String[] list = commands.getQueuedTorrents();
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
						chat.sendLine("--> " + commands.getStatusLines());
						for (int i = 0; i < list.length; i++) {
							chat.sendLine("--> " + list[i]);
						}
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
						chat.sendLine("--> ** Returned All Quereing Torrents.");
					} else if (incomingWords[0].equalsIgnoreCase("INFO")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String[] list = commands.getTorrentInfo(n);
						if (list == null) {
							sendNoPackageError();
						} else {
							for (int i = 0; i < list.length; i++) {
								chat.sendLine("--> " + list[i]);
							}
						}
					} else if (incomingWords[0].equalsIgnoreCase("TRON")) {
						int n = 0;
						Download download = null;
						try {
							n = Integer.parseInt(incomingWords[1]);
							download = commands.getDownloadById(n);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						torrentListeners.add(new BDCCTorrentListener(download, chat));
						chat.sendLine("--> Tracing to #" + n + " is started.");
					} else if (incomingWords[0].equalsIgnoreCase("TROFF")) {
						int n = 0;
						Download download = null;
						try {
							n = Integer.parseInt(incomingWords[1]);
							download = commands.getDownloadById(n);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						boolean b = removeListeners(download);
						if (b)
							chat.sendLine("--> Tracing to #" + n + " is stopped.");
						else
							chat.sendLine("--> Error on stopping tracing.");
					} else if (incomingWords[0].equalsIgnoreCase("ADD")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String filename = incomingWords[1];
						int position = commands.add(filename);
						if (position < 0)
							chat.sendLine("Error: Torrent file dose not exist");
						else
							chat.sendLine("--> Download added to #" + position);
					} else if (incomingWords[0].equalsIgnoreCase("ADDURL")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String url = incomingWords[1];
						int position = commands.addUrl(url);
						chat.sendLine("--> Download added to #" + position);
					} else if (incomingWords[0].equalsIgnoreCase("QUEUE")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String name = commands.queueTorrent(n);
						chat.sendLine("--> Download #" + n + " " + name + " is in the queue.");
					} else if (incomingWords[0].equalsIgnoreCase("START")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String name = commands.startTorrent(n);
						chat.sendLine("--> Download #" + n + " " + name + " is started.");
					} else if (incomingWords[0].equalsIgnoreCase("STOP")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String name = commands.stopTorrent(n);
						chat.sendLine("--> Download #" + n + " " + name + " is stopped.");
					} else if (incomingWords[0].equalsIgnoreCase("REMOVE")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String name = commands.removeTorrent(n);
						chat.sendLine("--> Download #" + n + " " + name + " is removed.");
					} else if (incomingWords[0].equalsIgnoreCase("HOST")) {
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[1]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String name = commands.hostTorrent(n);
						chat.sendLine("--> Download #" + n + " " + name + " is hosted.");
					} else if (incomingWords[0].equalsIgnoreCase("SEND")) {
						if (incomingWords.length < 3) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						int n = 0;
						try {
							n = Integer.parseInt(incomingWords[2]);
						} catch (RuntimeException e) {
							sendNoPackageError();
							sendWrongInput();
							continue;
						}
						String nick = incomingWords[1];
						String name = commands.sendTorrent(nick, n);
						if (name == null)
							chat.sendLine("--> Torrent #" + n + " dose not exist.");
						else
							chat.sendLine("--> Torrent #" + n + " " + name + " is sending.");
					} else if (incomingWords[0].equalsIgnoreCase("SADD")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String filename = incomingWords[1];
						String name = commands.addShare(filename);
						chat.sendLine("--> Share " + name + " is added.");
					} else if (incomingWords[0].equalsIgnoreCase("SADDDIR")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String dir = incomingWords[1];
						String name = commands.addShareDir(dir);
						chat.sendLine("--> Share " + name + " is added.");
					} else if (incomingWords[0].equalsIgnoreCase("SADDCON")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String dir = incomingWords[1];
						String name = commands.addShareDirContent(dir, false);
						chat.sendLine("--> Share " + name + " is added.");
					} else if (incomingWords[0].equalsIgnoreCase("SADDCONR")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String dir = incomingWords[1];
						String name = commands.addShareDirContent(dir, true);
						chat.sendLine("--> Share " + name + " is added.");
					} else if (incomingWords[0].equalsIgnoreCase("SLIST")) {
						String[] list = commands.getShares();
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Headline", ""));
						chat.sendLine("--> " + commands.getStatusLines());
						for (int i = 0; i < list.length; i++) {
							chat.sendLine("--> " + list[i]);
						}
						chat.sendLine("--> ** " + config.getPluginStringParameter("BDCC AD Creditline", ""));
						chat.sendLine("--> ** Returned All Shares.");
					} else if (incomingWords[0].equalsIgnoreCase("SREMOVE")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String name = incomingWords[1];
						boolean b = commands.removeShare(name);
						if (b)
							chat.sendLine("--> Share " + name + " is removed.");
						else
							chat.sendLine("--> Share with name " + name + " is not found.");
					} else if (incomingWords[0].equalsIgnoreCase("SAY")) {
						if (incomingWords.length < 2) {
							chat.sendLine("Error: Please input more parameter!");
							continue;
						}
						String msg = input.substring(4);
						commands.say(msg);
						chat.sendLine("--> Admin send message to channel.");
					} else if (incomingWords[0].equalsIgnoreCase("QUIT")) {
						chat.sendLine("Bye.");
						chat.close();
						break;
					} else if (incomingWords[0].equalsIgnoreCase("SHUTDOWN")) {
						String msg = "";
						commands.quit(msg);
					} else {
						sendWrongInput();
					}
				} catch (Exception e) {
					sendWrongInput();
					chat.sendLine("Error: " + e);
					e.printStackTrace();
				}
			}
		} catch (IOException e) {
			try {
				chat.close();
			} catch (IOException e1) {
			}
		} finally {
			for (Iterator iter = torrentListeners.iterator(); iter.hasNext();) {
				BDCCTorrentListener listener = (BDCCTorrentListener) iter.next();
				listener.remove();
				torrentListeners.remove(listener);
			}
		}
	}

	/**
	 * @param download
	 */
	private boolean removeListeners(Download download) {
		for (Iterator iter = torrentListeners.iterator(); iter.hasNext();) {
			BDCCTorrentListener listener = (BDCCTorrentListener) iter.next();
			if (listener.getDownload().getTorrent().getHash().equals(download.getTorrent().getHash())) {
				listener.remove();
				torrentListeners.remove(listener);
				return true;
			}
		}
		return false;
	}

	/**
	 *  
	 */
	private void sendNoPackageError() throws IOException {
		chat.sendLine("--> *** Try Specifying a Valid Torrent Number");
	}

	/**
	 * @param chat2
	 */
	private void sendHelpMessages() throws IOException {
		chat.sendLine("--> -- Info Commands --");
		chat.sendLine("-->   HELP             - Shows Help");
		chat.sendLine("-->   XDL              - Lists All torrents");
		chat.sendLine("-->   DCL              - Lists Current Downloading torrents");
		chat.sendLine("-->   SCL              - Lists Current Seeding torrents");
		chat.sendLine("-->   QUL              - Lists Current Queue");
		chat.sendLine("-->   INFO n           - Show Detail Information About Torrent n");
		chat.sendLine("-->   TRON n           - Start Tracing Information About Torrent n");
		chat.sendLine("-->   TROFF n          - Stop Tracing Information About Torrent n");
		chat.sendLine("--> -- Torrents Commands --");
		chat.sendLine("-->   ADD <filename>   - Add New Torrent With <filename> and put it into quere.");
		chat.sendLine("-->   ADDURL <url>     - Add New Torrent from <url> and put it into quere.");
		chat.sendLine("-->   QUEUE n          - Queue torrent n");
		chat.sendLine("-->   START n          - Force Start torrent n");
		chat.sendLine("-->   STOP n           - Stop torrent n");
		chat.sendLine("-->   REMOVE n         - Remove torrent n");
		chat.sendLine("-->   SEND nick n      - Sends torrent n to nick");
		chat.sendLine("-->   HOST n           - Host torrent n to embedded tracker");
		chat.sendLine("--> -- Share Commands --");
		chat.sendLine("-->   SADD <filename>  - Share a file");
		chat.sendLine("-->   SADDDIR <dir>    - Share a directory");
		chat.sendLine("-->   SADDCON <dir>    - Share directory contents");
		chat.sendLine("-->   SADDCONR <dir>   - Share directory contents with recursive");
		chat.sendLine("-->   SLIST            - List all shares");
		chat.sendLine("-->   SREMOVE <name>   - Remove a share");
		chat.sendLine("--> -- Bot Commands --");
		chat.sendLine("-->   SAY <message>    - Say a message to channel");
		chat.sendLine("-->   QUIT             - Close DCC Chat");
		chat.sendLine("-->   SHUTDOWN [message] - Quit IRC with a quit message.");
		chat.sendLine("--> No additional help right now.");
	}

	/**
	 * @param chat2
	 */
	private void sendWrongInput() throws IOException {
		chat.sendLine("--> *** User Command Not Recognized, try \"HELP\"");
	}
}
