//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_10.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot10(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[10] = {6.019206314958798e-02,5.438675002946463e-01,1.522944105404443e+00,3.022513376451572e+00,5.084907750098527e+00,
    7.777439231525445e+00,1.120813020434867e+01,1.556116333218935e+01,2.119389209630153e+01,2.902495034023622e+01};
  static constexpr double aw[10] = {4.622436696006100e-01,2.866755053628348e-01,1.090172060200231e-01,2.481052088746362e-02,3.243773342237849e-03,
    2.283386360163547e-04,7.802556478532124e-06,1.086069370769281e-07,4.399340992273179e-10,2.229393645534142e-13};
  static constexpr double xr[41800] = {   1.230754285271613e-02,  -3.055587428667479e-04,   5.651975419069337e-06,  -9.212789141246145e-08,   1.392102294066887e-09,
  -1.991620691157146e-11,   2.722883114318828e-13,  -3.569888371110768e-15,   4.484489392429303e-17,  -5.371596483765382e-19,   6.068221519539716e-21,  -6.323717485739558e-23,
   5.775257865362563e-25,  -3.936223843428673e-27,   1.230807430072185e-02,  -3.055847197744071e-04,   5.652760645101822e-06,  -9.214662218383029e-08,   1.392486597987393e-09,
  -1.992326410708434e-11,   2.724065604885139e-13,  -3.571709814384254e-15,   4.487060908343701e-17,  -5.374868183729591e-19,   6.071795040341774e-21,  -6.326560314327655e-23,
   5.775295702236104e-25,  -3.929831074033477e-27,   1.230901210921124e-02,  -3.056305607305906e-04,   5.654146364887871e-06,  -9.217967831295018e-08,   1.393164843712960e-09,
  -1.993571955938771e-11,   2.726152677616648e-13,  -3.574924678271491e-15,   4.491599614366621e-17,  -5.380642337938363e-19,   6.078100578739706e-21,  -6.331572686940899e-23,
   5.775349462084828e-25,  -3.918519338597820e-27,   1.231014621978026e-02,  -3.056859994270054e-04,   5.655822292364720e-06,  -9.221965932662646e-08,   1.393985216623098e-09,
  -1.995078580488191e-11,   2.728677325427753e-13,  -3.578813658404770e-15,   4.497089956167945e-17,  -5.387626531691470e-19,   6.085725306701403e-21,  -6.337627135652960e-23,
   5.775392265216563e-25,  -3.904787133087980e-27,   1.231124730206287e-02,  -3.057398260228825e-04,   5.657449568280670e-06,  -9.225848182737886e-08,   1.394781862328473e-09,
  -1.996541707094256e-11,   2.731129191439899e-13,  -3.582590617969198e-15,   4.502422073561096e-17,  -5.394408785012642e-19,   6.093127258603280e-21,  -6.343497797518148e-23,
   5.775410526373340e-25,  -3.891399583360922e-27,   1.231213439657219e-02,  -3.057831935241512e-04,   5.658760705996245e-06,  -9.228976362660038e-08,   1.395423803097415e-09,
  -1.997720756655380e-11,   2.733105086302382e-13,  -3.585634437633239e-15,   4.506719126123037e-17,  -5.399873997288741e-19,   6.099090169295369e-21,  -6.348222176537287e-23,
   5.775408521098129e-25,  -3.880574162151328e-27,   1.231272061049702e-02,  -3.058118526875404e-04,   5.659627192818908e-06,  -9.231043746001143e-08,   1.395848071013645e-09,
  -1.998500034657100e-11,   2.734411066940241e-13,  -3.587646302672055e-15,   4.509559309705489e-17,  -5.403486054659034e-19,   6.103030350123298e-21,  -6.351341533758400e-23,
   5.775399000015729e-25,  -3.873401021408166e-27,   1.231302167104913e-02,  -3.058265713715496e-04,   5.660072209400720e-06,  -9.232105550739384e-08,   1.396065979146047e-09,
  -1.998900287817398e-11,   2.735081857044087e-13,  -3.588679665834588e-15,   4.511018117321585e-17,  -5.405341248474765e-19,   6.105053819819850e-21,  -6.352942720978258e-23,
   5.775391573370655e-25,  -3.869711112582971e-27,   1.231312645978646e-02,  -3.058316944768207e-04,   5.660227106932548e-06,  -9.232475138235369e-08,   1.396141828247510e-09,
  -1.999039608609802e-11,   2.735315348647963e-13,  -3.589039365081113e-15,   4.511525906473860e-17,  -5.405987002204751e-19,   6.105758106678027e-21,  -6.353499909049555e-23,
   5.775388584331860e-25,  -3.868425825241467e-27,   1.231314308840397e-02,  -3.058325074493615e-04,   5.660251687295596e-06,  -9.232533787470586e-08,   1.396153864653765e-09,
  -1.999061717328762e-11,   2.735352401355222e-13,  -3.589096445714355e-15,   4.511606487413527e-17,  -5.406089476162419e-19,   6.105869867287941e-21,  -6.353588321433462e-23,
   5.775388090822991e-25,  -3.868221821271561e-27,   1.087769844274436e-01,  -2.563573744820450e-03,   4.262088254004441e-05,  -5.739438394891804e-07,   6.210434279964525e-09,
  -4.628706515510529e-11,   7.788756639087668e-16,   7.910254387458116e-15,  -1.770354275782320e-16,   2.530102695663472e-18,  -2.370728317069882e-20,   4.392505168364719e-23,
   3.849176524590587e-24,  -1.007762594826712e-25,   1.087809871400139e-01,  -2.563735318561936e-03,   4.262437587446796e-05,  -5.739871013136472e-07,   6.210429852156590e-09,
  -4.627135595621089e-11,   3.121117002578528e-16,   7.918798498062216e-15,  -1.771346532439220e-16,   2.530300112425062e-18,  -2.368283515347833e-20,   4.317927487504894e-23,
   3.862795320042392e-24,  -1.009370580142835e-25,   1.087880502556746e-01,  -2.564020427844012e-03,   4.263053991477998e-05,  -5.740634254693545e-07,   6.210421504770337e-09,
  -4.624362314907345e-11,  -5.117119495553775e-16,   7.933875236143225e-15,  -1.773096540861265e-16,   2.530645322025427e-18,  -2.363962769622315e-20,   4.186238752675549e-23,
   3.886829255362898e-24,  -1.012205274705666e-25,   1.087965915047657e-01,  -2.564365201867261e-03,   4.263799353250334e-05,  -5.741556969616730e-07,   6.210410499575675e-09,
  -4.621006501873726e-11,  -1.508248457362331e-15,   7.952107070525198e-15,  -1.775211228942046e-16,   2.531057404347864e-18,  -2.358726388887381e-20,   4.026837036504365e-23,
   3.915897024590767e-24,  -1.015628538146098e-25,   1.088048836771351e-01,  -2.564699920146074e-03,   4.264522936940380e-05,  -5.742452510608040e-07,   6.210398861255067e-09,
  -4.617746294170961e-11,  -2.476045834696708e-15,   7.969807135425463e-15,  -1.777262620677065e-16,   2.531451842025532e-18,  -2.353630759239828e-20,   3.871922797580286e-23,
   3.944121399770970e-24,  -1.018947078365897e-25,   1.088115640841283e-01,  -2.564969577465335e-03,   4.265105846094733e-05,  -5.743173792900238e-07,   6.210388801410331e-09,
  -4.615118163150706e-11,  -3.255960813627358e-15,   7.984066728296147e-15,  -1.778914111214697e-16,   2.531765577682336e-18,  -2.349517013997193e-20,   3.747004328535187e-23,
   3.966862767306000e-24,  -1.021617070623326e-25,   1.088159785449123e-01,  -2.565147768399847e-03,   4.265491021850253e-05,  -5.743650328018035e-07,   6.210381818998796e-09,
  -4.613380684079029e-11,  -3.771446890964597e-15,   7.993489529728356e-15,  -1.780004855417830e-16,   2.531970920204702e-18,  -2.346794428887004e-20,   3.664400943523050e-23,
   3.981891887003895e-24,  -1.023379694799025e-25,   1.088182456333490e-01,  -2.565239279882452e-03,   4.265688827958420e-05,  -5.743895028287472e-07,   6.210378129567729e-09,
  -4.612488140428214e-11,  -4.036214516686630e-15,   7.998328686547877e-15,  -1.780564840314791e-16,   2.532075764455150e-18,  -2.345394922641794e-20,   3.621961764672535e-23,
   3.989610683106570e-24,  -1.024284372710999e-25,   1.088190347224555e-01,  -2.565271131596327e-03,   4.265757676174199e-05,  -5.743980194744888e-07,   6.210376828928501e-09,
  -4.612177440246207e-11,  -4.128375817583358e-15,   8.000013014863159e-15,  -1.780759721995946e-16,   2.532112159490620e-18,  -2.344907600167058e-20,   3.607187493144387e-23,
   3.992297379808787e-24,  -1.024599172248657e-25,   1.088191599404192e-01,  -2.565276186039096e-03,   4.265768601437295e-05,  -5.743993709312505e-07,   6.210376621751686e-09,
  -4.612128134403421e-11,  -4.143000855522195e-15,   8.000280295303353e-15,  -1.780790645791220e-16,   2.532117930277834e-18,  -2.344830258760620e-20,   3.604842880803448e-23,
   3.992723726268668e-24,  -1.024649122710493e-25,   2.914306505230865e-01,  -6.177607078277521e-03,   8.099604037023677e-05,  -6.220937409270631e-07,  -1.090967791746005e-09,
   1.186281294969087e-10,  -1.836647400064598e-12,   9.096590163894255e-15,   2.181820084111644e-16,  -5.987869387381225e-18,   6.242566986834958e-20,   2.107135092974356e-22,
  -1.884778520060553e-23,   3.116527028157232e-25,   2.914382426255492e-01,  -6.177781649516301e-03,   8.099541216553313e-05,  -6.219823797164718e-07,  -1.093543727487844e-09,
   1.186457174856943e-10,  -1.836069323642812e-12,   9.076412091189913e-15,   2.184415978809973e-16,  -5.986695498154873e-18,   6.230854800100791e-20,   2.129641837006442e-22,
  -1.885875908824435e-23,   3.111420912229263e-25,   2.914516389603700e-01,  -6.178089657728997e-03,   8.099430251203721e-05,  -6.217858677989707e-07,  -1.098088343689579e-09,
   1.186767194874346e-10,  -1.835048746975315e-12,   9.040810849118118e-15,   2.188992454435533e-16,  -5.984614746248838e-18,   6.210183057111243e-20,   2.169324807368819e-22,
  -1.887801827236728e-23,   3.102397876861437e-25,   2.914678378672588e-01,  -6.178462061095612e-03,   8.099295870149894e-05,  -6.215482208116789e-07,  -1.103582611362508e-09,
   1.187141524007713e-10,  -1.833813714611931e-12,   8.997767065059491e-15,   2.194519519572294e-16,  -5.982082649764878e-18,   6.185177384163121e-20,   2.217257763430677e-22,
  -1.890112870725639e-23,   3.091464642760869e-25,   2.914835633972983e-01,  -6.178823538329275e-03,   8.099165205343240e-05,  -6.213174935044073e-07,  -1.108915166607160e-09,
   1.187504339940627e-10,  -1.832613782803838e-12,   8.955986810445645e-15,   2.199877915417033e-16,  -5.979607760096937e-18,   6.160892741878247e-20,   2.263735604301692e-22,
  -1.892337761528390e-23,   3.080827363717761e-25,   2.914962316164313e-01,  -6.179114707079551e-03,   8.099059793024558e-05,  -6.211316056018862e-07,  -1.113210154541288e-09,
   1.187796206846799e-10,  -1.831646429006231e-12,   8.922333428037055e-15,   2.204189421484979e-16,  -5.977602010408369e-18,   6.141322526852604e-20,   2.301138348929269e-22,
  -1.894116761306072e-23,   3.072241325475541e-25,   2.915046025189131e-01,  -6.179307090236138e-03,   8.098990064785617e-05,  -6.210087658775080e-07,  -1.116047790097660e-09,
   1.187988865149879e-10,  -1.831006874200714e-12,   8.900097958477248e-15,   2.207035866868433e-16,  -5.976270769159991e-18,   6.128387549706316e-20,   2.325834203813186e-22,
  -1.895285761515405e-23,   3.066559623172736e-25,   2.915089013682649e-01,  -6.179405883254264e-03,   8.098954233221175e-05,  -6.209456792327733e-07,  -1.117504923059635e-09,
   1.188087741893247e-10,  -1.830678325666204e-12,   8.888679627414868e-15,   2.208496873025748e-16,  -5.975585296066419e-18,   6.121743793686511e-20,   2.338510761206017e-22,
  -1.895884079685464e-23,   3.063639264509194e-25,   2.915103976206199e-01,  -6.179440268282794e-03,   8.098941758090989e-05,  -6.209237209395345e-07,  -1.118012071043337e-09,
   1.188122146897262e-10,  -1.830563954382705e-12,   8.884705475765266e-15,   2.209005265453383e-16,  -5.975346421668366e-18,   6.119431210414885e-20,   2.342922006158823e-22,
  -1.896092008356887e-23,   3.062622404050113e-25,   2.915106350551892e-01,  -6.179445724675942e-03,   8.098939778287502e-05,  -6.209202364414071e-07,  -1.118092547471111e-09,
   1.188127606025116e-10,  -1.830545804430225e-12,   8.884074837525634e-15,   2.209085934436212e-16,  -5.975308501862690e-18,   6.119064227558978e-20,   2.343621965018590e-22,
  -1.896124988514069e-23,   3.062461023180066e-25,   5.411975731786582e-01,  -9.735957332138169e-03,   8.147446113282238e-05,   1.836099860396223e-07,  -1.357737648920849e-08,
   1.115422714514004e-10,   1.433539473437864e-12,  -3.987227816429158e-14,   1.383242809317740e-16,   7.752653322203282e-18,  -1.263804375632757e-19,  -4.171525519562548e-22,
   3.759757532242620e-23,  -3.548693875942730e-25,   5.412051960862279e-01,  -9.735905326053692e-03,   8.146683527830306e-05,   1.837139006205656e-07,  -1.357535642926664e-08,
   1.114641881767386e-10,   1.433891737819986e-12,  -3.984617199244732e-14,   1.377985110704832e-16,   7.750405384044636e-18,  -1.261500460751774e-19,  -4.196592532297333e-22,
   3.754922220714645e-23,  -3.532638586168977e-25,   5.412186462468854e-01,  -9.735813536851242e-03,   8.145338026260685e-05,   1.838972001496837e-07,  -1.357179160318206e-08,
   1.113264507644506e-10,   1.434512196290510e-12,  -3.980011347993788e-14,   1.368715701011717e-16,   7.746428443707507e-18,  -1.257437603102319e-19,  -4.240728755718487e-22,
   3.746386523896323e-23,  -3.504348422139695e-25,   5.412349093365256e-01,  -9.735702504053929e-03,   8.143711189045781e-05,   1.841187466663979e-07,  -1.356748029872273e-08,
   1.111599684013841e-10,   1.435260556896679e-12,  -3.974442969095788e-14,   1.357520465886297e-16,   7.741601748409389e-18,  -1.252528907748004e-19,  -4.293937072076369e-22,
   3.736058774820175e-23,  -3.470207228012260e-25,   5.412506962275219e-01,  -9.735594673132715e-03,   8.142132048752765e-05,   1.843337142081145e-07,  -1.356329424939824e-08,
   1.109984247431928e-10,   1.435985059611074e-12,  -3.969038401665536e-14,   1.346666386177311e-16,   7.736897537261455e-18,  -1.247767984488804e-19,  -4.345421684104259e-22,
   3.726026233770332e-23,  -3.437134275818073e-25,   5.412634132001444e-01,  -9.735507775714466e-03,   8.140860032183393e-05,   1.845068133482606e-07,  -1.355992151486804e-08,
   1.108683406729573e-10,   1.436567282769936e-12,  -3.964685355514150e-14,   1.337932550044620e-16,   7.733094627275649e-18,  -1.243935766811206e-19,  -4.386776003080846e-22,
   3.717939497207879e-23,  -3.410541787116254e-25,   5.412718159860876e-01,  -9.735450340650246e-03,   8.140019564228835e-05,   1.846211570138978e-07,  -1.355769262373924e-08,
   1.107824095802423e-10,   1.436951307276459e-12,  -3.961809334080568e-14,   1.332166314844246e-16,   7.730575250152134e-18,  -1.241405033813978e-19,  -4.414043006723074e-22,
   3.712593661992701e-23,  -3.392994734530428e-25,   5.412761311064644e-01,  -9.735420840420816e-03,   8.139587961636918e-05,   1.846798664661789e-07,  -1.355654790479466e-08,
   1.107382879370731e-10,   1.437148306404215e-12,  -3.960332481434169e-14,   1.329206600790089e-16,   7.729279426944572e-18,  -1.240105854026711e-19,  -4.428027624056100e-22,
   3.709847622707836e-23,  -3.383991147880918e-25,   5.412776330057562e-01,  -9.735410571867402e-03,   8.139437741254905e-05,   1.847002989994308e-07,  -1.355614946267800e-08,
   1.107229322821444e-10,   1.437216839401979e-12,  -3.959818468777488e-14,   1.328176687733038e-16,   7.728828085195117e-18,  -1.239653737866859e-19,  -4.432892186910973e-22,
   3.708891727870442e-23,  -3.380858587093736e-25,   5.412778713356408e-01,  -9.735408942354817e-03,   8.139413903484574e-05,   1.847035412742184e-07,  -1.355608623482224e-08,
   1.107204956122875e-10,   1.437227713014196e-12,  -3.959736902970721e-14,   1.328013266227683e-16,   7.728756448353520e-18,  -1.239581996832074e-19,  -4.433663987854809e-22,
   3.708740035273809e-23,  -3.380361550752603e-25,   8.328213066417492e-01,  -1.190247659001605e-02,   3.479861049786338e-05,   1.071969032014541e-06,  -8.802045551597941e-09,
  -1.607254416037207e-10,   2.366622472717710e-12,   2.610138019078310e-14,  -6.494091800847860e-16,  -3.763966009698283e-18,   1.781315145710430e-19,   2.512910440932127e-22,
  -4.822828269905400e-23,   1.312958322660091e-25,   8.328245591038674e-01,  -1.190217562845083e-02,   3.479367801918247e-05,   1.071818782364481e-06,  -8.798737450181857e-09,
  -1.606742560429784e-10,   2.364933074391305e-12,   2.608871166491315e-14,  -6.486671016730088e-16,  -3.762635036218035e-18,   1.778380141459800e-19,   2.522044173611685e-22,
  -4.812193181471055e-23,   1.304435061878061e-25,   8.328302977508014e-01,  -1.190164461130726e-02,   3.478497609097140e-05,   1.071553703440381e-06,  -8.792902178561166e-09,
  -1.605839585744706e-10,   2.361953682420776e-12,   2.606636152917961e-14,  -6.473586949787759e-16,  -3.760282731248693e-18,   1.773206603175883e-19,   2.538110632364850e-22,
  -4.793451816872447e-23,   1.289433897502200e-25,   8.328372363469797e-01,  -1.190100255813559e-02,   3.477445619709649e-05,   1.071233233570584e-06,  -8.785849387454105e-09,
  -1.604748044493984e-10,   2.358353658897760e-12,   2.603934178367279e-14,  -6.457782634466825e-16,  -3.757431865790568e-18,   1.766959772989990e-19,   2.557453000216133e-22,
  -4.770831144259355e-23,   1.271359444169341e-25,   8.328439715490727e-01,  -1.190037932521205e-02,   3.476424635746064e-05,   1.070922196485593e-06,  -8.779006094906868e-09,
  -1.603688756775726e-10,   2.354861632494442e-12,   2.601311806508016e-14,  -6.442457946977909e-16,  -3.754657576461693e-18,   1.760904943172357e-19,   2.576141039261001e-22,
  -4.748914876292654e-23,   1.253881103245887e-25,   8.328493968624812e-01,  -1.189987730070447e-02,   3.475602337114466e-05,   1.070671678854117e-06,  -8.773495687464094e-09,
  -1.602835667437705e-10,   2.352050516427502e-12,   2.599199730115537e-14,  -6.430125369367548e-16,  -3.752417844125208e-18,   1.756034039302820e-19,   2.591132110130514e-22,
  -4.731290534521630e-23,   1.239849404992602e-25,   8.328529815790137e-01,  -1.189954559331153e-02,   3.475059071191860e-05,   1.070506165645244e-06,  -8.769855712443697e-09,
  -1.602272088034198e-10,   2.350193967072253e-12,   2.597804339153282e-14,  -6.421982480241879e-16,  -3.750935523410574e-18,   1.752818753488333e-19,   2.601006775021174e-22,
  -4.719659903311151e-23,   1.230601271284209e-25,   8.328548224301399e-01,  -1.189937525232939e-02,   3.474780107324706e-05,   1.070421174231645e-06,  -8.767986783373748e-09,
  -1.601982702265591e-10,   2.349240844982151e-12,   2.597087810772575e-14,  -6.417802651578002e-16,  -3.750173556536328e-18,   1.751168576684151e-19,   2.606068260950753e-22,
  -4.713691721012435e-23,   1.225859251108779e-25,   8.328554631437168e-01,  -1.189931596464699e-02,   3.474683016040901e-05,   1.070391593391908e-06,  -8.767336344753149e-09,
  -1.601881985142530e-10,   2.348909150630602e-12,   2.596838427918770e-14,  -6.416348131827240e-16,  -3.749908231782615e-18,   1.750594380867563e-19,   2.607828425912313e-22,
  -4.711615188969521e-23,   1.224209915067091e-25,   8.328555648155909e-01,  -1.189930655655847e-02,   3.474667609211821e-05,   1.070386899377006e-06,  -8.767233131915020e-09,
  -1.601866003018608e-10,   2.348856517608399e-12,   2.596798854836239e-14,  -6.416117334189756e-16,  -3.749866122931125e-18,   1.750503271652169e-19,   2.608107667163186e-22,
  -4.711285707458307e-23,   1.223948243560073e-25,   1.137954051618063e+00,  -1.192259156147909e-02,  -3.177579501603560e-05,   1.071569277461845e-06,   8.309568273587985e-09,
  -1.592832058178033e-10,  -2.260697815338952e-12,   2.539994717886603e-14,   6.190740182115004e-16,  -3.521529486072381e-18,  -1.681778701772382e-19,   1.832090337373122e-22,
   4.473651046042830e-23,   1.454003475055242e-25,   1.137951081989940e+00,  -1.192229070762509e-02,  -3.177113872023089e-05,   1.071420368415313e-06,   8.306408198123942e-09,
  -1.592333883495957e-10,  -2.259087195451690e-12,   2.538808784339858e-14,   6.183732542602495e-16,  -3.520545570161361e-18,  -1.679055096775600e-19,   1.842250255968105e-22,
   4.464024794748604e-23,   1.445387527817224e-25,   1.137945842387095e+00,  -1.192175988023512e-02,  -3.176292405358139e-05,   1.071157653968467e-06,   8.300834030896057e-09,
  -1.591455036111764e-10,  -2.256246721517509e-12,   2.536716458752685e-14,   6.171376754835145e-16,  -3.518805224100842e-18,  -1.674254071734406e-19,   1.860126869720506e-22,
   4.447060442245797e-23,   1.430221685662912e-25,   1.137939507204655e+00,  -1.192111805599642e-02,  -3.175299324658183e-05,   1.070840041479331e-06,   8.294096817084857e-09,
  -1.590392647853742e-10,  -2.252814529637174e-12,   2.534186862250894e-14,   6.156451854321398e-16,  -3.516693613500632e-18,  -1.668456830128846e-19,   1.881657126386178e-22,
   4.426583279156044e-23,   1.411946181499712e-25,   1.137933357748787e+00,  -1.192049504477365e-02,  -3.174335516188474e-05,   1.070531776436830e-06,   8.287559721458810e-09,
  -1.589361638334025e-10,  -2.249485274833707e-12,   2.531731662697173e-14,   6.141979602898692e-16,  -3.514636213247608e-18,  -1.662837555554990e-19,   1.902468108511640e-22,
   4.406742382025265e-23,   1.394270662585378e-25,   1.137928404278135e+00,  -1.191999319847612e-02,  -3.173559268766918e-05,   1.070283490599532e-06,   8.282295867656526e-09,
  -1.588531313059063e-10,  -2.246805173446626e-12,   2.529754136895098e-14,   6.130332817340922e-16,  -3.512973448208195e-18,  -1.658316887174921e-19,   1.919168658748412e-22,
   4.390785990500312e-23,   1.380078693406451e-25,   1.137925131333778e+00,  -1.191966160865072e-02,  -3.173046428441877e-05,   1.070119451470905e-06,   8.278818754794746e-09,
  -1.587982767674711e-10,  -2.245035141455690e-12,   2.528447595230594e-14,   6.122642637672160e-16,  -3.511872108353223e-18,  -1.655332716702990e-19,   1.930172555165660e-22,
   4.380255584124843e-23,   1.370723959713257e-25,   1.137923450588526e+00,  -1.191949132798622e-02,  -3.172783088269513e-05,   1.070035216867204e-06,   8.277033445893361e-09,
  -1.587701100099934e-10,  -2.244126433231885e-12,   2.527776676871767e-14,   6.118695157988332e-16,  -3.511305710247669e-18,  -1.653801131650951e-19,   1.935813843220645e-22,
   4.374851824604401e-23,   1.365926980762040e-25,   1.137922865600619e+00,  -1.191943206128856e-02,  -3.172691434747959e-05,   1.070005899410113e-06,   8.276412109277712e-09,
  -1.587603068967882e-10,  -2.243810194837082e-12,   2.527543166083959e-14,   6.117321487308966e-16,  -3.511108441761288e-18,  -1.653268197338949e-19,   1.937775795713164e-22,
   4.372971650357623e-23,   1.364258481706886e-25,   1.137922772771611e+00,  -1.191942265652958e-02,  -3.172676890806995e-05,   1.070001247188893e-06,   8.276313514395930e-09,
  -1.587587513054894e-10,  -2.243760014334371e-12,   2.527506111541106e-14,   6.117103518255749e-16,  -3.511077131873920e-18,  -1.653183635023192e-19,   1.938087057015338e-22,
   4.372673323628778e-23,   1.363993767675402e-25,   1.428175257320616e+00,  -9.855433903302709e-03,  -7.763687736455407e-05,   2.268607486454354e-07,   1.298988289182162e-08,
   9.556360828259647e-11,  -1.428101527826672e-12,  -3.532675386228708e-14,  -9.047346584209140e-17,   6.958711700235807e-18,   1.026972261023486e-19,  -4.637198014198591e-22,
  -3.098940318850654e-23,  -2.583701127544093e-25,   1.428167993522538e+00,  -9.855369785449404e-03,  -7.762958192234748e-05,   2.269497580983126e-07,   1.298787193721047e-08,
   9.549443127079766e-11,  -1.428330216701130e-12,  -3.530333270199746e-14,  -9.004630701138433e-17,   6.956250148909975e-18,   1.025073902818593e-19,  -4.655421497565209e-22,
  -3.094819470388761e-23,  -2.571518690984329e-25,   1.428155176991058e+00,  -9.855256628235160e-03,  -7.761670991987737e-05,   2.271067640691798e-07,   1.298432331810936e-08,
   9.537240479940433e-11,  -1.428732833901140e-12,  -3.526201250140860e-14,  -8.929322795233296e-17,   6.951899131855450e-18,   1.021726294859870e-19,  -4.687505105633792e-22,
  -3.087546313583627e-23,  -2.550053013131094e-25,   1.428139680049679e+00,  -9.855119762797107e-03,  -7.760114652583813e-05,   2.272965276835085e-07,   1.298003185068131e-08,
   9.522491294140636e-11,  -1.429218135795191e-12,  -3.521205929093525e-14,  -8.838370353125314e-17,   6.946624946941767e-18,   1.017681870147772e-19,  -4.726178279395840e-22,
  -3.078748398802790e-23,  -2.524148335726815e-25,   1.428124636877214e+00,  -9.854986860054610e-03,  -7.758603949532171e-05,   2.274806530250774e-07,   1.297586530926448e-08,
   9.508179725749327e-11,  -1.429687639546796e-12,  -3.516357776272452e-14,  -8.750191139936393e-17,   6.941491388986075e-18,   1.013759319022751e-19,  -4.763593228198339e-22,
  -3.070204285781458e-23,  -2.499054788612831e-25,   1.428112519002373e+00,  -9.854879769443613e-03,  -7.757387064527893e-05,   2.276289147512380e-07,   1.297250846935845e-08,
   9.496655302095015e-11,  -1.430064706559915e-12,  -3.512453041642813e-14,  -8.679238069887844e-17,   6.937346228373467e-18,   1.010602019005514e-19,  -4.793642409900924e-22,
  -3.063318955152005e-23,  -2.478878612309116e-25,   1.428104512073807e+00,  -9.854808993202157e-03,  -7.756583026240641e-05,   2.277268505361922e-07,   1.297029016884852e-08,
   9.489042513147438e-11,  -1.430313298540815e-12,  -3.509873291119942e-14,  -8.632394145592247e-17,   6.934602470937090e-18,   1.008517032146500e-19,  -4.813453463918951e-22,
  -3.058768132787480e-23,  -2.465565571904171e-25,   1.428100400240259e+00,  -9.854772642296899e-03,  -7.756170131936338e-05,   2.277771350677444e-07,   1.296915091581349e-08,
   9.485133706888866e-11,  -1.430440787083989e-12,  -3.508548598435023e-14,  -8.608350101342071e-17,   6.933191965452874e-18,   1.007446693946514e-19,  -4.823613508826500e-22,
  -3.056430723899974e-23,  -2.458734568081803e-25,   1.428098969096033e+00,  -9.854759989407618e-03,  -7.756026423130854e-05,   2.277946354388954e-07,   1.296875438047313e-08,
   9.483773326510439e-11,  -1.430485132732098e-12,  -3.508087548141845e-14,  -8.599983349555196e-17,   6.932700794644362e-18,   1.007074216987427e-19,  -4.827147596754041e-22,
  -3.055617112772904e-23,  -2.456357910489349e-25,   1.428098741993966e+00,  -9.854757981538734e-03,  -7.756003618657359e-05,   2.277974124298479e-07,   1.296869145540139e-08,
   9.483557458359860e-11,  -1.430492168451017e-12,  -3.508014386813172e-14,  -8.598655756120425e-17,   6.932622841616375e-18,   1.007015113064762e-19,  -4.827708302996681e-22,
  -3.055488001305924e-23,  -2.455980812085484e-25,   1.677561159407081e+00,  -6.487843522885175e-03,  -7.964370940254423e-05,  -5.402396582038569e-07,   2.077025391701756e-09,
   1.154979893287556e-10,   1.528755707994383e-12,   4.198671175771169e-15,  -2.294394155441896e-16,  -4.888544694991506e-18,  -3.800869082961137e-20,   3.886540394588936e-22,
   1.561484532387749e-23,   1.976096935035002e-25,   1.677553695193869e+00,  -6.487995083345865e-03,  -7.964252898748875e-05,  -5.401313120091506e-07,   2.079168034396889e-09,
   1.155059939903149e-10,   1.528150192646245e-12,   4.182226263240088e-15,  -2.295966589296536e-16,  -4.886485627773579e-18,  -3.791210216077393e-20,   3.900734774424595e-22,
   1.561433939715231e-23,   1.971468259399450e-25,   1.677540524563444e+00,  -6.488262489381392e-03,  -7.964044514835077e-05,  -5.399401274206794e-07,   2.082948067649310e-09,
   1.155200920466938e-10,   1.527081417577653e-12,   4.153214646189374e-15,  -2.298737861033649e-16,  -4.882846447111119e-18,  -3.774167322056358e-20,   3.925753398138941e-22,
   1.561337945348480e-23,   1.963296027923633e-25,   1.677524598651984e+00,  -6.488585797360979e-03,  -7.963792368010068e-05,  -5.397089347167961e-07,   2.087517741527397e-09,
   1.155370947384287e-10,   1.525788474824236e-12,   4.118143201584047e-15,  -2.302083264365550e-16,  -4.878435817706974e-18,  -3.753559455822019e-20,   3.955959134709198e-22,
   1.561210412583464e-23,   1.953405822061632e-25,   1.677509138215795e+00,  -6.488899614900219e-03,  -7.963547413624884e-05,  -5.394844861184788e-07,   2.091952662964502e-09,
   1.155535537211102e-10,   1.524532713647950e-12,   4.084106635456634e-15,  -2.305325009530389e-16,  -4.874143495582786e-18,  -3.733554336325944e-20,   3.985233045158580e-22,
   1.561074619740328e-23,   1.943795975501073e-25,   1.677496683606270e+00,  -6.489152390522434e-03,  -7.963349956468216e-05,  -5.393036655755600e-07,   2.095524490126828e-09,
   1.155667792395877e-10,   1.523520663086552e-12,   4.056694528047148e-15,  -2.307932279656525e-16,  -4.870678098028362e-18,  -3.717438951775858e-20,   4.008780389001299e-22,
   1.560956645530524e-23,   1.936048270132127e-25,   1.677488453879379e+00,  -6.489319404625986e-03,  -7.963219419057403e-05,  -5.391841788310479e-07,   2.097884255065656e-09,
   1.155755019657069e-10,   1.522851709851933e-12,   4.038584677832666e-15,  -2.309653042491662e-16,  -4.868384527013712e-18,  -3.706790435935517e-20,   4.024322745005278e-22,
   1.560874491425381e-23,   1.930925730502071e-25,   1.677484227538540e+00,  -6.489405169558305e-03,  -7.963152362913841e-05,  -5.391228155115522e-07,   2.099095972780122e-09,
   1.155799764127416e-10,   1.522508105991112e-12,   4.029285511856848e-15,  -2.310536094894022e-16,  -4.867205525514304e-18,  -3.701321990531753e-20,   4.032299133921386e-22,
   1.560831003418485e-23,   1.928294137814260e-25,   1.677482756524725e+00,  -6.489435020064049e-03,  -7.963129020394326e-05,  -5.391014572618403e-07,   2.099517700814084e-09,
   1.155815329746853e-10,   1.522388501276808e-12,   4.026049028552084e-15,  -2.310843347218701e-16,  -4.866794981326642e-18,  -3.699418660446781e-20,   4.035074536541897e-22,
   1.560815660437690e-23,   1.927378041075562e-25,   1.677482523095226e+00,  -6.489439756891915e-03,  -7.963125316114845e-05,  -5.390980679930089e-07,   2.099584622228350e-09,
   1.155817799411606e-10,   1.522369521169627e-12,   4.025535451609226e-15,  -2.310892099081663e-16,  -4.866729824982993e-18,  -3.699116628768056e-20,   4.035514914236482e-22,
   1.560813215911895e-23,   1.927232662174903e-25,   1.864654532385088e+00,  -3.013146818970411e-03,  -4.678348276958648e-05,  -5.756386965580300e-07,  -5.406200994632553e-09,
  -2.774445800566033e-11,   2.518354416272558e-13,   9.690314247819383e-15,   1.615164010336815e-16,   1.738452139409116e-18,   8.006657550792366e-21,  -1.543687645831112e-22,
  -5.005719093274927e-24,  -8.200876927699856e-26,   1.864650140341707e+00,  -3.013308808049852e-03,  -4.678652172157560e-05,  -5.756645456616156e-07,  -5.405841828774835e-09,
  -2.772528730004412e-11,   2.522600950631031e-13,   9.696160060729238e-15,   1.615491708844897e-16,   1.737632788876907e-18,   7.975353690303769e-21,  -1.549696716434684e-22,
  -5.012877130637632e-24,  -8.203134948946809e-26,   1.864642390280565e+00,  -3.013594646215709e-03,  -4.679188383481352e-05,  -5.757101421718711e-07,  -5.405207589194686e-09,
  -2.769145094168554e-11,   2.530094720653493e-13,   9.706472824320072e-15,   1.616068861441437e-16,   1.736184511692588e-18,   7.920081632977088e-21,  -1.560301113434200e-22,
  -5.025498033482156e-24,  -8.207085788240957e-26,   1.864633018429108e+00,  -3.013940294815168e-03,  -4.679836747733734e-05,  -5.757652529925236e-07,  -5.404439831578870e-09,
  -2.765051972120475e-11,   2.539157448062096e-13,   9.718939261059800e-15,   1.616764924033907e-16,   1.734428941793527e-18,   7.853184886177274e-21,  -1.573126262083579e-22,
  -5.040743020964211e-24,  -8.211806067801999e-26,   1.864623919984606e+00,  -3.014275854998269e-03,  -4.680466138966664e-05,  -5.758187274721173e-07,  -5.403693638278022e-09,
  -2.761076771768880e-11,   2.547956621287194e-13,   9.731037406332489e-15,   1.617438725317360e-16,   1.732720163998929e-18,   7.788178652876321e-21,  -1.585578979190944e-22,
  -5.055525436930160e-24,  -8.216328569143781e-26,   1.864616590099887e+00,  -3.014546185443456e-03,  -4.680973147165743e-05,  -5.758617870759039e-07,  -5.403091893051254e-09,
  -2.757873206940080e-11,   2.555046003786538e-13,   9.740780604663911e-15,   1.617980151406137e-16,   1.731340369605485e-18,   7.735764629679621e-21,  -1.595612350904002e-22,
  -5.067421640253758e-24,  -8.219928908599144e-26,   1.864611746497643e+00,  -3.014724818669749e-03,  -4.681308158769434e-05,  -5.758902309168741e-07,  -5.402693966149928e-09,
  -2.755755763298036e-11,   2.559730973206771e-13,   9.747217309936193e-15,   1.618337240393453e-16,   1.730427046763943e-18,   7.701107941032447e-21,  -1.602243014748405e-22,
  -5.075276396615158e-24,  -8.222286915084083e-26,   1.864609259031290e+00,  -3.014816556517835e-03,  -4.681480200045670e-05,  -5.759048353514009e-07,  -5.402489517510987e-09,
  -2.754668173752125e-11,   2.562137062574488e-13,   9.750522424517497e-15,   1.618520413634627e-16,   1.729957523347154e-18,   7.683303137238077e-21,  -1.605648421324945e-22,
  -5.079308318622814e-24,  -8.223491356268335e-26,   1.864608393238708e+00,  -3.014848486897301e-03,  -4.681540080075914e-05,  -5.759099181066070e-07,  -5.402418342303129e-09,
  -2.754289599449882e-11,   2.562974545240261e-13,   9.751672729585071e-15,   1.618584135473441e-16,   1.729794023659912e-18,   7.677104908249093e-21,  -1.606833742929226e-22,
  -5.080711367885820e-24,  -8.223909536697869e-26,   1.864608255849010e+00,  -3.014853553817377e-03,  -4.681549582187750e-05,  -5.759107246483999e-07,  -5.402407047066404e-09,
  -2.754229523554689e-11,   2.563107443212811e-13,   9.751855263817582e-15,   1.618594245671393e-16,   1.729768074819624e-18,   7.676121282267240e-21,  -1.607021838976688e-22,
  -5.080933998323915e-24,  -8.223975846968022e-26,   1.973870383633212e+00,  -6.141340918713964e-04,  -1.068874248661938e-05,  -1.624950366637244e-07,  -2.263309562924855e-09,
  -2.937074157780743e-11,  -3.561319335732438e-13,  -4.003682623348488e-15,  -4.078692988879503e-17,  -3.550103367465632e-19,  -2.146953768332041e-21,   3.997519470054456e-24,
   4.292535154221722e-25,   9.566825419078835e-27,   1.973869379004115e+00,  -6.141798907469037e-04,  -1.069001843050292e-05,  -1.625226381309345e-07,  -2.263811641098009e-09,
  -2.937864285946646e-11,  -3.562391840347521e-13,  -4.004880160093022e-15,  -4.079589954639199e-17,  -3.549869461253638e-19,  -2.144233538301397e-21,   4.068731527243053e-24,
   4.306363297996356e-25,   9.589518462992968e-27,   1.973867606222653e+00,  -6.142607099072956e-04,  -1.069227008349898e-05,  -1.625713473829361e-07,  -2.264697688637158e-09,
  -2.939258671193269e-11,  -3.564284482532132e-13,  -4.006993166320968e-15,  -4.081171726197834e-17,  -3.549453731930897e-19,  -2.139426668372005e-21,   4.194521668599066e-24,
   4.330785852122106e-25,   9.629592723273559e-27,   1.973865462389911e+00,  -6.143584480835713e-04,  -1.069499319846664e-05,  -1.626302574116613e-07,  -2.265769316024209e-09,
  -2.940945103534215e-11,  -3.566573411079022e-13,  -4.009548122592098e-15,  -4.083082819172706e-17,  -3.548945911634707e-19,  -2.133602238498675e-21,   4.346859358501803e-24,
   4.360356378106454e-25,   9.678105566068548e-27,   1.973863381019867e+00,  -6.144533419073847e-04,  -1.069763716200010e-05,  -1.626874570150197e-07,  -2.266809852470432e-09,
  -2.942582605073601e-11,  -3.568795803866030e-13,  -4.012028310403346e-15,  -4.084936395355730e-17,  -3.548447566130563e-19,  -2.127935499356765e-21,   4.494988120989097e-24,
   4.389103284704182e-25,   9.725258203251341e-27,   1.973861704170310e+00,  -6.145297952308860e-04,  -1.069976739891103e-05,  -1.627335439872139e-07,  -2.267648252118539e-09,
  -2.943902000208386e-11,  -3.570586378491431e-13,  -4.014026231313333e-15,  -4.086428407176015e-17,  -3.548042259861066e-19,  -2.123361496639140e-21,   4.614492213935506e-24,
   4.412290346164363e-25,   9.763284753578201e-27,   1.973860596076828e+00,  -6.145803181880332e-04,  -1.070117516561056e-05,  -1.627640012155541e-07,  -2.268202328556526e-09,
  -2.944773953058079e-11,  -3.571769677674684e-13,  -4.015346379478662e-15,  -4.087413711386446e-17,  -3.547772556368560e-19,  -2.120334691470486e-21,   4.693543381551344e-24,
   4.427626113123809e-25,   9.788432098380882e-27,   1.973860026998887e+00,  -6.146062653696144e-04,  -1.070189816573646e-05,  -1.627796436281295e-07,  -2.268486897097909e-09,
  -2.945221779693444e-11,  -3.572377395329278e-13,  -4.016024325578011e-15,  -4.087919529461047e-17,  -3.547633467671990e-19,  -2.118778925280621e-21,   4.734166233217054e-24,
   4.435506146714832e-25,   9.801352673183961e-27,   1.973859828923087e+00,  -6.146152967189127e-04,  -1.070214981964662e-05,  -1.627850882991086e-07,  -2.268585947570471e-09,
  -2.945377655765354e-11,  -3.572588922898675e-13,  -4.016260288828881e-15,  -4.088095554963477e-17,  -3.547584963728453e-19,  -2.118237210535546e-21,   4.748309575793454e-24,
   4.438249562541122e-25,   9.805850786273289e-27,   1.973859797491042e+00,  -6.146167298789281e-04,  -1.070218975399318e-05,  -1.627859523022394e-07,  -2.268601665696044e-09,
  -2.945402391431789e-11,  -3.572622489689590e-13,  -4.016297732847402e-15,  -4.088123486404245e-17,  -3.547577262412234e-19,  -2.118151237607230e-21,   4.750554128265679e-24,
   4.438684937987180e-25,   9.806564621809977e-27,   1.116923513676876e-02,  -2.644145499117149e-04,   4.668001686618955e-06,  -7.271706515983422e-08,   1.051798772562451e-09,
  -1.443493016564266e-11,   1.898195874894018e-13,  -2.402392593242729e-15,   2.927470772098607e-17,  -3.426351186754865e-19,   3.825379690940205e-21,  -4.022571689949258e-23,
   3.877353611660685e-25,  -3.218009294804820e-27,   1.116967395181636e-02,  -2.644350493623550e-04,   4.668594834668647e-06,  -7.273063782036893e-08,   1.052066619094510e-09,
  -1.443967835932402e-11,   1.898967685823172e-13,  -2.403554418793045e-15,   2.929092341090228e-17,  -3.428434462102160e-19,   3.827785859300189e-21,  -4.024921502779294e-23,
   3.878882245607380e-25,  -3.217415757731970e-27,   1.117044829327279e-02,  -2.644712240764897e-04,   4.669641576454920e-06,  -7.275459061849981e-08,   1.052539326893238e-09,
  -1.444805848419740e-11,   1.900329904904521e-13,  -2.405605050584457e-15,   2.931954451030478e-17,  -3.432111418984746e-19,   3.832032346548945e-21,  -4.029067418792993e-23,
   3.881576193539431e-25,  -3.216358909181574e-27,   1.117138471265549e-02,  -2.645149722324017e-04,   4.670907517084854e-06,  -7.278356077999233e-08,   1.053111080935299e-09,
  -1.445819499695167e-11,   1.901977705798403e-13,  -2.408085672512949e-15,   2.935416753434340e-17,  -3.436559313523034e-19,   3.837168548084008e-21,  -4.034080077298296e-23,
   3.884828020768628e-25,  -3.215064662886395e-27,   1.117229385346472e-02,  -2.645574477410299e-04,   4.672136689524414e-06,  -7.281169098634345e-08,   1.053666287730763e-09,
  -1.446803867497953e-11,   1.903577981453833e-13,  -2.410494839694615e-15,   2.938779371855121e-17,  -3.440879010632323e-19,   3.842156047452249e-21,  -4.038945617377292e-23,
   3.887978831910756e-25,  -3.213791140178441e-27,   1.117302630357866e-02,  -2.645916694398936e-04,   4.673127051930737e-06,  -7.283435695499416e-08,   1.054113668241843e-09,
  -1.447597099827357e-11,   1.904867586382527e-13,  -2.412436366125755e-15,   2.941489310648858e-17,  -3.444360162013651e-19,   3.846174888214185e-21,  -4.042864755332612e-23,
   3.890512771650752e-25,  -3.212752941459179e-27,   1.117351032201605e-02,  -2.646142844785186e-04,   4.673781542683900e-06,  -7.284933649563801e-08,   1.054409344718519e-09,
  -1.448121370383678e-11,   1.905719951623371e-13,  -2.413719651011342e-15,   2.943280507588964e-17,  -3.446661061509917e-19,   3.848830944113653e-21,  -4.045454216483253e-23,
   3.892185038562383e-25,  -3.212060904745653e-27,   1.117375889744208e-02,  -2.646258989859353e-04,   4.674117678791563e-06,  -7.285702990932093e-08,   1.054561205873435e-09,
  -1.448390644514989e-11,   1.906157749163156e-13,  -2.414378790181729e-15,   2.944200533028672e-17,  -3.447842874200226e-19,   3.850195103491957e-21,  -4.046783955584490e-23,
   3.893043172663588e-25,  -3.211703649337676e-27,   1.117384541779635e-02,  -2.646299416176053e-04,   4.674234677829617e-06,  -7.285970778430366e-08,   1.054614065267453e-09,
  -1.448484373592354e-11,   1.906310139305976e-13,  -2.414608227275433e-15,   2.944520781798521e-17,  -3.448254245289540e-19,   3.850669935144069e-21,  -4.047246771791308e-23,
   3.893341749753296e-25,  -3.211579006824416e-27,   1.117385914745150e-02,  -2.646305831321329e-04,   4.674253244145429e-06,  -7.286013273149532e-08,   1.054622453454820e-09,
  -1.448499247379054e-11,   1.906334322030864e-13,  -2.414644636621185e-15,   2.944571602077884e-17,  -3.448319525657177e-19,   3.850745285502652e-21,  -4.047320213795007e-23,
   3.893389124870447e-25,  -3.211559213695404e-27,   9.916329629714572e-02,  -2.248536769766701e-03,   3.629939224499949e-05,  -4.819170027108891e-07,   5.299845684247958e-09,
  -4.417292510359876e-11,   1.553771621276616e-13,   3.525803752550134e-15,  -1.021784988503677e-16,   1.659182333095122e-18,  -1.919735909272335e-20,   1.345786744583453e-22,
   4.788153468935813e-25,  -3.658788118999449e-26,   9.916670534546361e-02,  -2.248672454303104e-03,   3.630237461592580e-05,  -4.819583555448924e-07,   5.300060988675108e-09,
  -4.416589429776246e-11,   1.551072739782716e-13,   3.531421250343906e-15,  -1.022593809790248e-16,   1.659865580928920e-18,  -1.919409203926363e-20,   1.343053028871866e-22,
   4.853729469721159e-25,  -3.669337878981398e-26,   9.917272089239926e-02,  -2.248911881251051e-03,   3.630763715413074e-05,  -4.820313178857633e-07,   5.300440587513116e-09,
  -4.415347932996166e-11,   1.546308795377717e-13,   3.541335280609582e-15,  -1.024020872960517e-16,   1.661070030542351e-18,  -1.918829419814515e-20,   1.338223069455040e-22,
   4.969517229555629e-25,  -3.687955372083366e-26,   9.917999534402228e-02,  -2.249201414985044e-03,   3.631400083819575e-05,  -4.821195355408726e-07,   5.300899075118690e-09,
  -4.413845166995256e-11,   1.540545240864184e-13,   3.553326613214584e-15,  -1.025746296618630e-16,   1.662524497931910e-18,  -1.918122696620275e-20,   1.332371930560401e-22,
   5.109661714039704e-25,  -3.710471687176558e-26,   9.918705766204898e-02,  -2.249482506191742e-03,   3.632017876691099e-05,  -4.822051660868316e-07,   5.301343614525719e-09,
  -4.412384700255336e-11,   1.534947001252834e-13,   3.564970919971617e-15,  -1.027421101403718e-16,   1.663934408671183e-18,  -1.917430710259917e-20,   1.326680539749307e-22,
   5.245850382063580e-25,  -3.732334114174560e-26,   9.919274726473670e-02,  -2.249708961698700e-03,   3.632515575080017e-05,  -4.822741420394558e-07,   5.301701333759633e-09,
  -4.411207015276500e-11,   1.530434925096802e-13,   3.574353805067864e-15,  -1.028770153605010e-16,   1.665068736088378e-18,  -1.916869016915410e-20,   1.322087599139742e-22,
   5.355661586321509e-25,  -3.749949018276086e-26,   9.919650699538247e-02,  -2.249858605381034e-03,   3.632844451419117e-05,  -4.823197167392731e-07,   5.301937514349315e-09,
  -4.410428257914881e-11,   1.527452344946002e-13,   3.580555014381125e-15,  -1.029661510150681e-16,   1.665817554949640e-18,  -1.916495783886599e-20,   1.319048733692436e-22,
   5.428271500448945e-25,  -3.761589999141486e-26,   9.919843784104981e-02,  -2.249935456402076e-03,   3.633013347044190e-05,  -4.823431204823560e-07,   5.302058744404785e-09,
  -4.410028154276332e-11,   1.525920313153023e-13,   3.583739992505721e-15,  -1.030119241714483e-16,   1.666201885070196e-18,  -1.916303468616127e-20,   1.317486914770875e-22,
   5.465575196426544e-25,  -3.767568619425998e-26,   9.919910989658477e-02,  -2.249962205395059e-03,   3.633072133013827e-05,  -4.823512662029131e-07,   5.302100930086247e-09,
  -4.409888866763443e-11,   1.525387022257735e-13,   3.584848610674314e-15,  -1.030278555762221e-16,   1.666335618983776e-18,  -1.916236429259331e-20,   1.316943115780157e-22,
   5.478561481695405e-25,  -3.769649599515285e-26,   9.919921654287565e-02,  -2.249966450105682e-03,   3.633081461551865e-05,  -4.823525588086735e-07,   5.302107623919538e-09,
  -4.409866762434733e-11,   1.525302393811714e-13,   3.585024535832533e-15,  -1.030303836535771e-16,   1.666356839018787e-18,  -1.916225786181428e-20,   1.316856813178122e-22,
   5.480622339872841e-25,  -3.769979825549868e-26,   2.679686795130900e-01,  -5.559630764190463e-03,   7.349698470553235e-05,  -6.228652993752060e-07,   8.647260787707424e-10,
   7.821222960871622e-11,  -1.513131331906511e-12,   1.311577756625458e-14,   4.777695462176718e-17,  -3.517740707695215e-18,   5.703347092692071e-20,  -3.501848526424291e-22,
  -5.615192603015888e-24,   1.880517978251156e-25,   2.679755707939505e-01,  -5.559805685636320e-03,   7.349745911169405e-05,  -6.227917602347225e-07,   8.625997912842983e-10,
   7.823786157558476e-11,  -1.513000975706767e-12,   1.310385975584332e-14,   4.801641159691938e-17,  -3.519492726774436e-18,   5.699777442477776e-20,  -3.488072087031263e-22,
  -5.635803202867911e-24,   1.880989789860630e-25,   2.679877306023513e-01,  -5.560114320431376e-03,   7.349829523682798e-05,  -6.226619797845211e-07,   8.588480744853620e-10,
   7.828307048708245e-11,  -1.512770449806321e-12,   1.308282582366271e-14,   4.843881393306934e-17,  -3.522578414390022e-18,   5.693468410703808e-20,  -3.463760681641598e-22,
  -5.672134476416534e-24,   1.881811632391840e-25,   2.680024344320685e-01,  -5.560487496192989e-03,   7.349930463097799e-05,  -6.225050146725657e-07,   8.543117161782194e-10,
   7.833770501826758e-11,  -1.512490825441267e-12,   1.305738324877270e-14,   4.894937693450231e-17,  -3.526299808773477e-18,   5.685821864884873e-20,  -3.434358576091791e-22,
  -5.716004421511766e-24,   1.882787213243992e-25,   2.680167087176554e-01,  -5.560849738672883e-03,   7.350028279790385e-05,  -6.223526008997886e-07,   8.499081684607332e-10,
   7.839070916429061e-11,  -1.512218460141177e-12,   1.303267554882378e-14,   4.944480200355895e-17,  -3.529902156112965e-18,   5.678380319045540e-20,  -3.405810869907946e-22,
  -5.758527370949442e-24,   1.883715237072809e-25,   2.680282079410332e-01,  -5.561141534942021e-03,   7.350106955306369e-05,  -6.222297934506273e-07,   8.463609217859559e-10,
   7.843338416987577e-11,  -1.511998393770457e-12,   1.301276527472793e-14,   4.984375168057292e-17,  -3.532796766878839e-18,   5.672372326046758e-20,  -3.382809915640005e-22,
  -5.792736510812382e-24,   1.884449193440682e-25,   2.680358064447808e-01,  -5.561334338160174e-03,   7.350158881807603e-05,  -6.221486322898804e-07,   8.440170595563155e-10,
   7.846157108246341e-11,  -1.511852658453292e-12,   1.299960595106244e-14,   5.010729291675417e-17,  -3.534705853837045e-18,   5.668395902389332e-20,  -3.367609698026961e-22,
  -5.815318366521596e-24,   1.884927498139235e-25,   2.680397086467654e-01,  -5.561433348572497e-03,   7.350185529723813e-05,  -6.221069483825323e-07,   8.428134036181927e-10,
   7.847604270826722e-11,  -1.511777717637661e-12,   1.299284709128793e-14,   5.024260993326944e-17,  -3.535685141678708e-18,   5.666351825168229e-20,  -3.359803168519804e-22,
  -5.826908132472930e-24,   1.885171064797990e-25,   2.680410668449733e-01,  -5.561467809533325e-03,   7.350194801777871e-05,  -6.220924393170665e-07,   8.423944648400348e-10,
   7.848107910067604e-11,  -1.511751618079483e-12,   1.299049446226770e-14,   5.028970443466179e-17,  -3.536025813524052e-18,   5.665640048106111e-20,  -3.357085956652085e-22,
  -5.830940926300656e-24,   1.885255511574290e-25,   2.680412823723744e-01,  -5.561473277988523e-03,   7.350196272982866e-05,  -6.220901368997269e-07,   8.423279852485515e-10,
   7.848187827880372e-11,  -1.511747475692747e-12,   1.299012112551451e-14,   5.029717750179836e-17,  -3.536079864991601e-18,   5.665527083829206e-20,  -3.356654768864196e-22,
  -5.831580821470703e-24,   1.885268896504666e-25,   5.035663124619472e-01,  -9.078861558509023e-03,   8.245301700695747e-05,  -1.427956736869964e-08,  -1.108936088057935e-08,
   1.332729717988154e-10,   4.140220101414795e-13,  -3.196310373257511e-14,   3.263001796248139e-16,   2.787340488392591e-18,  -1.125055999653192e-19,   8.679748620588462e-22,
   1.536093061375516e-23,  -4.280544186502908e-25,   5.035740299020114e-01,  -9.078865136513284e-03,   8.244678260198394e-05,  -1.415515185327827e-08,  -1.108876866414047e-08,
   1.332101962471720e-10,   4.148688170517098e-13,  -3.195358340851600e-14,   3.258286322392149e-16,   2.791696134683406e-18,  -1.124097816738959e-19,   8.648880975172885e-22,
   1.537779182256707e-23,  -4.272686279865799e-25,   5.035876469718404e-01,  -9.078871421601398e-03,   8.243578216934388e-05,  -1.393566651584074e-08,  -1.108772272458363e-08,
   1.330994430907906e-10,   4.163620167167141e-13,  -3.193677278325635e-14,   3.249969087634576e-16,   2.799368845794588e-18,  -1.122406253698102e-19,   8.594461272933624e-22,
   1.540741688421002e-23,  -4.258818726704126e-25,   5.036041120690006e-01,  -9.078878973254044e-03,   8.242248079447081e-05,  -1.367034399018017e-08,  -1.108645631981159e-08,
   1.329655452778992e-10,   4.181658975173817e-13,  -3.191642499118097e-14,   3.239917415352127e-16,   2.808624795930110e-18,  -1.120359379543467e-19,   8.528736097772416e-22,
   1.544302385689677e-23,  -4.242046318390373e-25,   5.036200952529788e-01,  -9.078886253652871e-03,   8.240956853816429e-05,  -1.341285879972937e-08,  -1.108522519594100e-08,
   1.328355869336021e-10,   4.199152814018045e-13,  -3.189665057984488e-14,   3.230165310276516e-16,   2.817587318150147e-18,  -1.118370830126712e-19,   8.465014717731700e-22,
   1.547736464525466e-23,  -4.225760241484615e-25,   5.036329704910437e-01,  -9.078892082388844e-03,   8.239916694244272e-05,  -1.320549320637120e-08,  -1.108423218686435e-08,
   1.327309137782702e-10,   4.213232785152325e-13,  -3.188070545552445e-14,   3.222313359122666e-16,   2.824790946490608e-18,  -1.116767824487709e-19,   8.413741424726931e-22,
   1.550486754350931e-23,  -4.212637780006821e-25,   5.036414779217504e-01,  -9.078895916163256e-03,   8.239229392478477e-05,  -1.306849964312456e-08,  -1.108357542136966e-08,
   1.326617572216906e-10,   4.222530295208658e-13,  -3.187016180914035e-14,   3.217126995559240e-16,   2.829542919920869e-18,  -1.115708071405509e-19,   8.379890239509044e-22,
   1.552296193766283e-23,  -4.203965433924326e-25,   5.036458468025602e-01,  -9.078897879500931e-03,   8.238876435441579e-05,  -1.299815614800075e-08,  -1.108323795450642e-08,
   1.326262449906843e-10,   4.227303068467000e-13,  -3.186474485796251e-14,   3.214464188752763e-16,   2.831980795344428e-18,  -1.115163678399360e-19,   8.362515096050015e-22,
   1.553222985288991e-23,  -4.199511384780891e-25,   5.036473674169009e-01,  -9.078898561984797e-03,   8.238753586357536e-05,  -1.297367392361115e-08,  -1.108312046641141e-08,
   1.326138851063590e-10,   4.228963966608301e-13,  -3.186285907500634e-14,   3.213537476208062e-16,   2.832828923843328e-18,  -1.114974172130532e-19,   8.356468960650441e-22,
   1.553545174935196e-23,  -4.197961051366637e-25,   5.036476087167596e-01,  -9.078898670244107e-03,   8.238734091939922e-05,  -1.296978900171546e-08,  -1.108310182126073e-08,
   1.326119237853911e-10,   4.229227513586286e-13,  -3.186255980996985e-14,   3.213390424520770e-16,   2.832963491340480e-18,  -1.114944098895235e-19,   8.355509590707770e-22,
   1.553596283548654e-23,  -4.197715031925814e-25,   7.858459721686162e-01,  -1.157525054355824e-02,   4.672173505146136e-05,   9.087114240357052e-07,  -1.140185587407819e-08,
  -9.758093494895028e-11,   2.795891591339046e-12,   4.510007312064441e-15,  -6.598644074298644e-16,   2.949699778151656e-18,   1.435845069441987e-19,  -1.646777987307282e-21,
  -2.671623647916092e-23,   6.062053483219864e-25,   7.858503394927233e-01,  -1.157499529091571e-02,   4.671534358752913e-05,   9.086200181923501e-07,  -1.139794447765628e-08,
  -9.757190146294406e-11,   2.794171836238779e-12,   4.519746226702520e-15,  -6.592639283123110e-16,   2.941376643448863e-18,   1.434204996962606e-19,  -1.642443697167934e-21,
  -2.668823041970953e-23,   6.044117043012463e-25,   7.858580452204089e-01,  -1.157454491449290e-02,   4.670406753265911e-05,   9.084587380739867e-07,  -1.139104471833790e-08,
  -9.755594625269398e-11,   2.791138579575649e-12,   4.536907980528623e-15,  -6.582049348252039e-16,   2.926708409994359e-18,   1.431312474372342e-19,  -1.634806370612959e-21,
  -2.663879223727353e-23,   6.012517406356544e-25,   7.858673622427979e-01,  -1.157400035011222e-02,   4.669043544752244e-05,   9.082637282562394e-07,  -1.138270479866082e-08,
  -9.753662666854301e-11,   2.787472911939867e-12,   4.557621460745167e-15,  -6.569253454234116e-16,   2.909002203638837e-18,   1.427817211905530e-19,  -1.625589281718433e-21,
  -2.657897541123989e-23,   5.974391078435679e-25,   7.858764061821408e-01,  -1.157347173371831e-02,   4.667720483885284e-05,   9.080744284935915e-07,  -1.137461204849654e-08,
  -9.751784396427886e-11,   2.783916625751270e-12,   4.577689269989029e-15,  -6.556841437493488e-16,   2.891845517040388e-18,   1.424426592837807e-19,  -1.616660365435262e-21,
  -2.652086925327588e-23,   5.937466837896007e-25,   7.858836912425837e-01,  -1.157304591393594e-02,   4.666654871305777e-05,   9.079219399531129e-07,  -1.136809514068222e-08,
  -9.750269311869862e-11,   2.781053361078104e-12,   4.593826663615518e-15,  -6.546849651427339e-16,   2.878047351685013e-18,   1.421696961296055e-19,  -1.609480851769538e-21,
  -2.647403338314676e-23,   5.907784209795538e-25,   7.858885047774665e-01,  -1.157276455288702e-02,   4.665950845133016e-05,   9.078211825960329e-07,  -1.136379011096706e-08,
  -9.749267205198827e-11,   2.779162166165781e-12,   4.604475792385921e-15,  -6.540250768178574e-16,   2.868941038982686e-18,   1.419894154450845e-19,  -1.604743362259694e-21,
  -2.644307228308628e-23,   5.888201296969824e-25,   7.858909766641633e-01,  -1.157262006457004e-02,   4.665589328526787e-05,   9.077694402192373e-07,  -1.136157965156509e-08,
  -9.748752276987571e-11,   2.778191194239150e-12,   4.609940248889040e-15,  -6.536863011433326e-16,   2.864267994441556e-18,   1.418968600638773e-19,  -1.602312475893298e-21,
  -2.642716833966300e-23,   5.878154063657829e-25,   7.858918370120349e-01,  -1.157256977473197e-02,   4.665463504856514e-05,   9.077514310256710e-07,  -1.136081034131281e-08,
  -9.748573004005628e-11,   2.777853277909364e-12,   4.611841505841816e-15,  -6.535684044471839e-16,   2.862642052745411e-18,   1.418646496746915e-19,  -1.601466708452549e-21,
  -2.642163220138575e-23,   5.874658548495886e-25,   7.858919735366845e-01,  -1.157256179445784e-02,   4.665443538633781e-05,   9.077485732248639e-07,  -1.136068826523744e-08,
  -9.748544553597631e-11,   2.777799657109230e-12,   4.612143176043179e-15,  -6.535496966854875e-16,   2.862384064498977e-18,   1.418595385364748e-19,  -1.601332512225315e-21,
  -2.642075366284311e-23,   5.874103930355229e-25,   1.089839561112177e+00,  -1.212336229933830e-02,  -1.823316775970199e-05,   1.176369240811903e-06,   4.649850192171576e-09,
  -2.029294622601020e-10,  -1.300190107497059e-12,   4.193751665065320e-14,   3.789483959934695e-16,  -9.454066178190170e-18,  -1.133676801514817e-19,   2.225473499711340e-21,
   3.438564651724762e-23,  -5.347619035940574e-25,   1.089837856985769e+00,  -1.212303211366684e-02,  -1.823056247272500e-05,   1.176179684275370e-06,   4.648033437064342e-09,
  -2.028474001183194e-10,  -1.299205089019974e-12,   4.190590389489027e-14,   3.784768176921622e-16,  -9.442740198215393e-18,  -1.131589651044294e-19,   2.221631053811876e-21,
   3.429798101551827e-23,  -5.335253639157918e-25,   1.089834850225221e+00,  -1.212244953907010e-02,  -1.822596623089163e-05,   1.175845271172065e-06,   4.644828866390620e-09,
  -2.027026506304618e-10,  -1.297468010758550e-12,   4.185015365699876e-14,   3.776454226648672e-16,  -9.422771366329213e-18,  -1.127911224260907e-19,   2.214858308436619e-21,
   3.414353715244214e-23,  -5.313464670197106e-25,   1.089831214754622e+00,  -1.212174515731843e-02,  -1.822040981765582e-05,   1.175441001624000e-06,   4.640955778114229e-09,
  -2.025277039946550e-10,  -1.295369225196011e-12,   4.178279264488466e-14,   3.766413044267666e-16,  -9.398652166577880e-18,  -1.123470696421083e-19,   2.206681085836365e-21,
   3.395719622603904e-23,  -5.287168255069680e-25,   1.089827685854895e+00,  -1.212106143284630e-02,  -1.821501722552784e-05,   1.175048655079271e-06,   4.637197853148953e-09,
  -2.023579588351952e-10,  -1.293333547812067e-12,   4.171745496350465e-14,   3.756677932924848e-16,  -9.375266252879436e-18,  -1.119167715629601e-19,   2.198755805335536e-21,
   3.377673271535462e-23,  -5.261693522315823e-25,   1.089824843271478e+00,  -1.212051068856435e-02,  -1.821067408185981e-05,   1.174732665552285e-06,   4.634171951453947e-09,
  -2.022212788008923e-10,  -1.291694912253608e-12,   4.166485931725594e-14,   3.748844540322718e-16,  -9.356447329269353e-18,  -1.115706876293068e-19,   2.192380624344225e-21,
   3.363166339387228e-23,  -5.241209596388488e-25,   1.089822965066518e+00,  -1.212014679360779e-02,  -1.820780472799843e-05,   1.174523904338772e-06,   4.632173191254666e-09,
  -2.021309946174936e-10,  -1.290612757251603e-12,   4.163012440019845e-14,   3.743672819311683e-16,  -9.344022132097394e-18,  -1.113422747360006e-19,   2.188172578168934e-21,
   3.353595561090103e-23,  -5.227692859175222e-25,   1.089822000556599e+00,  -1.211995992450173e-02,  -1.820633133769849e-05,   1.174416707537225e-06,   4.631146949213158e-09,
  -2.020846391233968e-10,  -1.290057212451869e-12,   4.161229233982858e-14,   3.741018267065335e-16,  -9.337644293607729e-18,  -1.112250582129027e-19,   2.186012954349457e-21,
   3.348685187353920e-23,  -5.220757139055858e-25,   1.089821664856169e+00,  -1.211989488432987e-02,  -1.820581853621356e-05,   1.174379398630219e-06,   4.630789790807201e-09,
  -2.020685062217858e-10,  -1.289863880806756e-12,   4.160608667997917e-14,   3.740094544510736e-16,  -9.335424921064725e-18,  -1.111842733637354e-19,   2.185261501771203e-21,
   3.346976831282409e-23,  -5.218344016527511e-25,   1.089821611585423e+00,  -1.211988456341357e-02,  -1.820573716289094e-05,   1.174373478311718e-06,   4.630733116326407e-09,
  -2.020659462261895e-10,  -1.289833203199790e-12,   4.160510197242025e-14,   3.739947972842335e-16,  -9.335072760587913e-18,  -1.111778020075651e-19,   2.185142267241327e-21,
   3.346705774036202e-23,  -5.217961130806372e-25,   1.387533735418994e+00,  -1.046197488279115e-02,  -7.361140602066389e-05,   4.477878428238531e-07,   1.447767968166775e-08,
   4.935055396696394e-11,  -2.414836707714301e-12,  -3.348856778807544e-14,   2.248039786346783e-16,   1.018572754019444e-17,   4.647095802469916e-20,  -2.117042130028010e-21,
  -3.381133251471473e-23,   2.121013163852010e-25,   1.387526850672322e+00,  -1.046184878179807e-02,  -7.360328146672328e-05,   4.478335596406903e-07,   1.447429085486229e-08,
   4.928516515492209e-11,  -2.414242704940176e-12,  -3.345447372744336e-14,   2.249934640352389e-16,   1.017487328669124e-17,   4.626614156282098e-20,  -2.115460518889221e-21,
  -3.371629336132856e-23,   2.126624750811811e-25,   1.387514703045293e+00,  -1.046162626425048e-02,  -7.358894711136599e-05,   4.479141780123537e-07,   1.446831189720066e-08,
   4.916983999744409e-11,  -2.413194177267227e-12,  -3.339434395753942e-14,   2.253271153710988e-16,   1.015572744661830e-17,   4.590521563920686e-20,  -2.112666462457564e-21,
  -3.354878885026589e-23,   2.136483784671138e-25,   1.387500015056479e+00,  -1.046135717599489e-02,  -7.357161649476734e-05,   4.480115779441523e-07,   1.446108323841594e-08,
   4.903048036001571e-11,  -2.411925604646924e-12,  -3.332168508785520e-14,   2.257293800165108e-16,   1.013258745909905e-17,   4.546959101676563e-20,  -2.109282286404212e-21,
  -3.334657049849875e-23,   2.148332759729236e-25,   1.387485757312291e+00,  -1.046109593129120e-02,  -7.355479499548498e-05,   4.481060434881779e-07,   1.445406699746738e-08,
   4.889528954804011e-11,  -2.410693383675834e-12,  -3.325120218149709e-14,   2.261186467163598e-16,   1.011013547490291e-17,   4.504754244987845e-20,  -2.105991172740314e-21,
  -3.315060567820914e-23,   2.159759604821026e-25,   1.387474272247849e+00,  -1.046088546271908e-02,  -7.354124579413017e-05,   4.481820802288367e-07,   1.444841567644705e-08,
   4.878645113891187e-11,  -2.409700212802222e-12,  -3.319446007944801e-14,   2.264313439751819e-16,   1.009205699390561e-17,   4.470815280100311e-20,  -2.103335744073610e-21,
  -3.299298619665439e-23,   2.168910634425951e-25,   1.387466683508080e+00,  -1.046074638235798e-02,  -7.353229369248523e-05,   4.482322928846764e-07,   1.444468181098590e-08,
   4.871456669919155e-11,  -2.409043693995384e-12,  -3.315698451572180e-14,   2.266375329332756e-16,   1.008011524317928e-17,   4.448418722086951e-20,  -2.101579058269919e-21,
  -3.288895504256291e-23,   2.174930938731954e-25,   1.387462786446536e+00,  -1.046067495593501e-02,  -7.352769665967799e-05,   4.482580698802115e-07,   1.444276442442672e-08,
   4.867766112518043e-11,  -2.408706463190155e-12,  -3.313774477386135e-14,   2.267432861337504e-16,   1.007398387851526e-17,   4.436926199428486e-20,  -2.100676290874893e-21,
  -3.283556747245130e-23,   2.178014457669440e-25,   1.387461430057591e+00,  -1.046065009499560e-02,  -7.352609666802699e-05,   4.482670402705005e-07,   1.444209708149485e-08,
   4.866481747759750e-11,  -2.408589074671055e-12,  -3.313104912135356e-14,   2.267800730676218e-16,   1.007185000723949e-17,   4.432927582923866e-20,  -2.100361975004559e-21,
  -3.281699139361463e-23,   2.179086400864870e-25,   1.387461214818248e+00,  -1.046064614989177e-02,  -7.352584277365263e-05,   4.482684636753112e-07,   1.444199118436025e-08,
   4.866277944714505e-11,  -2.408570446148414e-12,  -3.312998665699078e-14,   2.267859096299061e-16,   1.007151140105335e-17,   4.432293126915617e-20,  -2.100312092687785e-21,
  -3.281404390836353e-23,   2.179256441609204e-25,   1.650295473262724e+00,  -7.150171111939536e-03,  -8.584443617973122e-05,  -4.865112084724369e-07,   4.758396552799875e-09,
   1.525972171267094e-10,   1.515245816784376e-12,  -6.204494052396965e-15,  -4.264000376062433e-16,  -5.810822188971179e-18,  -9.670435892200549e-22,   1.364399950808140e-21,
   2.411394102736731e-23,   8.687241242377144e-26,   1.650287430759982e+00,  -7.150307439441345e-03,  -8.584174764116411e-05,  -4.863682544634787e-07,   4.760514126724309e-09,
   1.525846934477697e-10,   1.514126546677644e-12,  -6.223921480512200e-15,  -4.263993877829245e-16,  -5.803764801520187e-18,  -8.196648640608157e-22,   1.364979541317204e-21,
   2.407460715112314e-23,   8.586140460146756e-26,   1.650273239843498e+00,  -7.150547958797602e-03,  -8.583700270721725e-05,  -4.861160195023295e-07,   4.764249339654226e-09,
   1.525625642141083e-10,   1.512151581187336e-12,  -6.258182102756229e-15,  -4.263977372791469e-16,  -5.791309557408982e-18,  -5.598111978267454e-22,   1.365996248413144e-21,
   2.400515206790239e-23,   8.407902303087412e-26,   1.650256080387172e+00,  -7.150838741677453e-03,  -8.583126343678931e-05,  -4.858110307395447e-07,   4.768763817265684e-09,
   1.525357524632096e-10,   1.509763439746636e-12,  -6.299577363835616e-15,  -4.263948827812917e-16,  -5.776244514269517e-18,  -2.459318486267813e-22,   1.367215455310977e-21,
   2.392108153445304e-23,   8.192640766026754e-26,   1.650239422652158e+00,  -7.151120970341888e-03,  -8.582569012965703e-05,  -4.855149701719460e-07,   4.773144109261774e-09,
   1.525096687677846e-10,   1.507445082617965e-12,  -6.339728552150323e-15,  -4.263912130672371e-16,  -5.761615434050323e-18,   5.842212042478821e-23,   1.368388360579857e-21,
   2.383937896630821e-23,   7.983947543285850e-26,   1.650226003661282e+00,  -7.151348288297743e-03,  -8.582119911192557e-05,  -4.852764799984788e-07,   4.776671178539867e-09,
   1.524886164703846e-10,   1.505577451546896e-12,  -6.372049022160447e-15,  -4.263876133576371e-16,  -5.749827445472457e-18,   3.033514479875974e-22,   1.369325591596421e-21,
   2.377349738608027e-23,   7.816027184033783e-26,   1.650217136760354e+00,  -7.151498475494515e-03,  -8.581823092336674e-05,  -4.851188960027409e-07,   4.779001001574920e-09,
   1.524746861001348e-10,   1.504343358037855e-12,  -6.393393666138636e-15,  -4.263849198601564e-16,  -5.742036693974277e-18,   4.650718248127390e-22,   1.369941155685717e-21,
   2.372993323885513e-23,   7.705166547558668e-26,   1.650212583222419e+00,  -7.151575597479258e-03,  -8.581670642974319e-05,  -4.850379709568922e-07,   4.780197229307034e-09,
   1.524675261944545e-10,   1.503709593213633e-12,  -6.404351405268262e-15,  -4.263834392789626e-16,  -5.738035320533790e-18,   5.480844421110823e-22,   1.370256120709784e-21,
   2.370755146940753e-23,   7.648264686021383e-26,   1.650210998328202e+00,  -7.151602439485055e-03,  -8.581617578604439e-05,  -4.850098045523809e-07,   4.780613547862030e-09,
   1.524650331696055e-10,   1.503489005765482e-12,  -6.408164748593712e-15,  -4.263829084554644e-16,  -5.736642534377984e-18,   5.769716079062200e-22,   1.370365563084231e-21,
   2.369975977980753e-23,   7.628464310957048e-26,   1.650210746827620e+00,  -7.151606698893883e-03,  -8.581609157878611e-05,  -4.850053349460858e-07,   4.780679610009688e-09,
   1.524646375156048e-10,   1.503454001585170e-12,  -6.408769845265581e-15,  -4.263828234856164e-16,  -5.736421515005526e-18,   5.815553119642577e-22,   1.370382921343489e-21,
   2.369852327434128e-23,   7.625322493898964e-26,   1.851807532562747e+00,  -3.416555359947341e-03,  -5.422711099986638e-05,  -6.661451138382030e-07,  -5.875401469489008e-09,
  -1.780079751306436e-11,   6.052721431077093e-13,   1.590380404970936e-14,   2.274614911188715e-16,   1.835137086196818e-18,  -5.799837748963278e-21,  -5.170107751298365e-22,
  -1.050300964984319e-23,  -1.273091372378178e-25,   1.851802442156499e+00,  -3.416742770685965e-03,  -5.423041105853456e-05,  -6.661615378878400e-07,  -5.874543253565138e-09,
  -1.776938972456893e-11,   6.058686733035912e-13,   1.590992705636368e-14,   2.274349254981243e-16,   1.832435416748701e-18,  -5.865042278251838e-21,  -5.179331790825113e-22,
  -1.050775507163185e-23,  -1.271554924775484e-25,   1.851793459803511e+00,  -3.417073463597050e-03,  -5.423623366992162e-05,  -6.661904944136041e-07,  -5.873028236259624e-09,
  -1.771396042118389e-11,   6.069212022669854e-13,   1.592072375869392e-14,   2.273878262100149e-16,   1.827664420478913e-18,  -5.980120144321947e-21,  -5.195598511830374e-22,
  -1.051609003930003e-23,  -1.268835847005605e-25,   1.851782597818207e+00,  -3.417473347328236e-03,  -5.424327376172459e-05,  -6.662254680810943e-07,  -5.871195098655444e-09,
  -1.764691807078977e-11,   6.081938323956829e-13,   1.593376655475377e-14,   2.273304915402751e-16,   1.821888705226334e-18,  -6.119313378399113e-21,  -5.215252614031967e-22,
  -1.052610324758499e-23,  -1.265534285005324e-25,   1.851772052742620e+00,  -3.417861554156232e-03,  -5.425010745689657e-05,  -6.662593771039692e-07,  -5.869414303110447e-09,
  -1.758181709799903e-11,   6.094291754596674e-13,   1.594641497547949e-14,   2.272744322457907e-16,   1.816274858357967e-18,  -6.254481320720489e-21,  -5.234315898936644e-22,
  -1.053575522743569e-23,  -1.262314922053542e-25,   1.851763557445690e+00,  -3.418174293271036e-03,  -5.425561208819250e-05,  -6.662866630953867e-07,  -5.867978845234557e-09,
  -1.752936012723536e-11,   6.104242767881782e-13,   1.595659484287687e-14,   2.272289851105302e-16,   1.811747487461975e-18,  -6.363400515595323e-21,  -5.249661126522462e-22,
  -1.054348149770401e-23,  -1.259711227586945e-25,   1.851757943747570e+00,  -3.418380948027638e-03,  -5.425924920331685e-05,  -6.663046781705915e-07,  -5.867029893234085e-09,
  -1.749469139095734e-11,   6.110817851885595e-13,   1.596331684627234e-14,   2.271988141571341e-16,   1.808753469096742e-18,  -6.435386852552706e-21,  -5.259795137843651e-22,
  -1.054856275542170e-23,  -1.257985750848824e-25,   1.851755060796350e+00,  -3.418487075850657e-03,  -5.426111695950529e-05,  -6.663139251276628e-07,  -5.866542428923619e-09,
  -1.747688544880547e-11,   6.114194357972918e-13,   1.596676747134656e-14,   2.271832765369154e-16,   1.807215151580370e-18,  -6.472359746725640e-21,  -5.264997628435364e-22,
  -1.055116476056614e-23,  -1.257098089330540e-25,   1.851754057351035e+00,  -3.418524014725539e-03,  -5.426176703697747e-05,  -6.663171428760623e-07,  -5.866372741483678e-09,
  -1.747068762718370e-11,   6.115369563641545e-13,   1.596796826285911e-14,   2.271778616174688e-16,   1.806679607363112e-18,  -6.485229211164357e-21,  -5.266808114691065e-22,
  -1.055206922374611e-23,  -1.256788884399438e-25,   1.851753898117716e+00,  -3.418529876421673e-03,  -5.426187019474134e-05,  -6.663176534533014e-07,  -5.866345813425927e-09,
  -1.746970410399063e-11,   6.115556051731662e-13,   1.596815880100786e-14,   2.271770020163544e-16,   1.806594618235905e-18,  -6.487271451618673e-21,  -5.267095400237293e-22,
  -1.055221269316663e-23,  -1.256739806147259e-25,   1.971229545748495e+00,  -7.081072749523759e-04,  -1.287696050828079e-05,  -2.039126297909610e-07,  -2.946090856722012e-09,
  -3.942301611907446e-11,  -4.885429441966762e-13,  -5.529133856691161e-15,  -5.500006406665168e-17,  -4.291403440381731e-19,  -1.292506698475352e-21,   4.122376388949144e-23,
   1.241416071388273e-24,   2.357354366234008e-26,   1.971228335201235e+00,  -7.081647557921243e-04,  -1.287862156966318e-05,  -2.039496805339914e-07,  -2.946779577682180e-09,
  -3.943392451346421e-11,  -4.886874257115448e-13,  -5.530576456352182e-15,  -5.500526436898635e-17,  -4.289209551513738e-19,  -1.284678171618981e-21,   4.139885731814059e-23,
   1.244587960240708e-24,   2.362261960273221e-26,   1.971226199044448e+00,  -7.082661901275540e-04,  -1.288155285401294e-05,  -2.040150654752707e-07,  -2.947995001894920e-09,
  -3.945317485344573e-11,  -4.889423765659440e-13,  -5.533121339176682e-15,  -5.501441340394055e-17,  -4.285331032200008e-19,  -1.270848607122826e-21,   4.170810489820509e-23,
   1.250189276904814e-24,   2.370926718346365e-26,   1.971223615764102e+00,  -7.083888600862262e-04,  -1.288509793221923e-05,  -2.040941438363524e-07,  -2.949464987602234e-09,
  -3.947645650229430e-11,  -4.892506844916439e-13,  -5.536197602353705e-15,  -5.502543047339300e-17,  -4.280628513926877e-19,  -1.254098443511557e-21,   4.208254927573011e-23,
   1.256970069895889e-24,   2.381413150853224e-26,   1.971221107733275e+00,  -7.085079611200090e-04,  -1.288853999607555e-05,  -2.041709266031662e-07,  -2.950892319351900e-09,
  -3.949906204075545e-11,  -4.895500039462236e-13,  -5.539182898394143e-15,  -5.503607739154499e-17,  -4.276050215331999e-19,  -1.237809059900058e-21,   4.244657610983281e-23,
   1.263560728568756e-24,   2.391602526567330e-26,   1.971219087133607e+00,  -7.086039182282158e-04,  -1.289131328160517e-05,  -2.042327924517818e-07,  -2.952042370672651e-09,
  -3.951727571761594e-11,  -4.897911457117263e-13,  -5.541587033979612e-15,  -5.504461979675050e-17,  -4.272352549924521e-19,  -1.224666028078192e-21,   4.274020610746145e-23,
   1.268875797797601e-24,   2.399817634355710e-26,   1.971217751877698e+00,  -7.086673302958147e-04,  -1.289314601693551e-05,  -2.042736775175102e-07,  -2.952802407620502e-09,
  -3.952931243451258e-11,  -4.899504946886738e-13,  -5.543175261492677e-15,  -5.505024750449399e-17,  -4.269904569641717e-19,  -1.215971295898562e-21,   4.293441512621239e-23,
   1.272390702110462e-24,   2.405249299672941e-26,   1.971217066135268e+00,  -7.086998970720165e-04,  -1.289408727535200e-05,  -2.042946755679408e-07,  -2.953192754975620e-09,
  -3.953549431099811e-11,  -4.900323301109721e-13,  -5.543990773929554e-15,  -5.505313235329326e-17,  -4.268645982467483e-19,  -1.211503025373767e-21,   4.303420752999169e-23,
   1.274196640062145e-24,   2.408039730100150e-26,   1.971216827452413e+00,  -7.087112324986594e-04,  -1.289441489869616e-05,  -2.043019843884716e-07,  -2.953328624044305e-09,
  -3.953764604078738e-11,  -4.900608140128709e-13,  -5.544274601644811e-15,  -5.505413561552356e-17,  -4.268207691614672e-19,  -1.209947307751960e-21,   4.306895023092807e-23,
   1.274825351245550e-24,   2.409011125783999e-26,   1.971216789576545e+00,  -7.087130312871892e-04,  -1.289446688847082e-05,  -2.043031442098217e-07,  -2.953350184836259e-09,
  -3.953798749404449e-11,  -4.900653340316537e-13,  -5.544319640298901e-15,  -5.505429477973831e-17,  -4.268138130064598e-19,  -1.209700413282712e-21,   4.307446384831422e-23,
   1.274925125600278e-24,   2.409165280534647e-26,   1.018111532623922e-02,  -2.302953055114891e-04,   3.887586125667556e-06,  -5.797145140295688e-08,   8.037105504042142e-10,
  -1.059102822125471e-11,   1.340053310731647e-13,  -1.636585177757537e-15,   1.931329518125851e-17,  -2.200980442104489e-19,   2.410609079933523e-21,  -2.520012955160833e-23,
   2.470747529506546e-25,  -2.210800365320236e-27,   1.018148069643003e-02,  -2.303116450254741e-04,   3.888039279399871e-06,  -5.798140767408186e-08,   8.038995974011343e-10,
  -1.059426211949519e-11,   1.340562395782191e-13,  -1.637331413359994e-15,   1.932351431385672e-17,  -2.202286129554863e-19,   2.412144331204408e-21,  -2.521633617313704e-23,
   2.472146624389810e-25,  -2.211532257249221e-27,   1.018212543255585e-02,  -2.303404786366952e-04,   3.888838962897535e-06,  -5.799897813988808e-08,   8.042332320924562e-10,
  -1.059996958000663e-11,   1.341460902766091e-13,  -1.638648516569983e-15,   1.934155140575418e-17,  -2.204590715436161e-19,   2.414854009454292e-21,  -2.524493732797763e-23,
   2.474614790662645e-25,  -2.212821073564285e-27,   1.018290511349844e-02,  -2.303753484384164e-04,   3.889806096419609e-06,  -5.802022874497158e-08,   8.046367661344959e-10,
  -1.060687314223907e-11,   1.342547759484444e-13,  -1.640241783670579e-15,   1.936337104027348e-17,  -2.207378604605254e-19,   2.418131780218250e-21,  -2.527952949874681e-23,
   2.477598368447624e-25,  -2.214375049886097e-27,   1.018366207618803e-02,  -2.304092035134039e-04,   3.890745127587309e-06,  -5.804086287411330e-08,   8.050286141189141e-10,
  -1.061357713772555e-11,   1.343603251322093e-13,  -1.641789140654402e-15,   1.938456258040913e-17,  -2.210086253315444e-19,   2.421315038537578e-21,  -2.531311866116149e-23,
   2.480493770365419e-25,  -2.215878925977576e-27,   1.018427191986147e-02,  -2.304364796416792e-04,   3.891501709732759e-06,  -5.805748862022687e-08,   8.053443563776484e-10,
  -1.061897932065329e-11,   1.344453821430454e-13,  -1.643036130608864e-15,   1.940164095804018e-17,  -2.212268369960049e-19,   2.423880329214908e-21,  -2.534018314791424e-23,
   2.482825546894170e-25,  -2.217087055031627e-27,   1.018467491542565e-02,  -2.304545046512570e-04,   3.892001700017529e-06,  -5.806847616453827e-08,   8.055530297788386e-10,
  -1.062254973682716e-11,   1.345015999938398e-13,  -1.643860344284127e-15,   1.941292935057760e-17,  -2.213710699813029e-19,   2.425575867783474e-21,  -2.535806956487780e-23,
   2.484365988991599e-25,  -2.217883709803335e-27,   1.018488187965067e-02,  -2.304637617983866e-04,   3.892258485740767e-06,  -5.807411927289076e-08,   8.056602048570907e-10,
  -1.062438354832443e-11,   1.345304747855169e-13,  -1.644283687014432e-15,   1.941872750245540e-17,  -2.214451536974071e-19,   2.426446744084073e-21,  -2.536725592573558e-23,
   2.485156969938882e-25,  -2.218292317479132e-27,   1.018495391651440e-02,  -2.304669839036283e-04,   3.892347865036167e-06,  -5.807608348463116e-08,   8.056975099239813e-10,
  -1.062502186013968e-11,   1.345405255955170e-13,  -1.644431046405229e-15,   1.942074576505816e-17,  -2.214709413110937e-19,   2.426749882224418e-21,  -2.537045345480716e-23,
   2.485432260605911e-25,  -2.218434455440651e-27,   1.018496534782335e-02,  -2.304674952106972e-04,   3.892362048426286e-06,  -5.807639518160034e-08,   8.057034298097498e-10,
  -1.062512315318703e-11,   1.345421205526557e-13,  -1.644454430836944e-15,   1.942106604326345e-17,  -2.214750335498268e-19,   2.426797987101057e-21,  -2.537096086490099e-23,
   2.485475944612469e-25,  -2.218457006898573e-27,   9.071526225193344e-02,  -1.979897774452647e-03,   3.099675273386990e-05,  -4.039569525401950e-07,   4.459980554817138e-09,
  -3.957849742677965e-11,   2.163146212623431e-13,   1.075330244248925e-15,  -5.482247116578883e-17,   1.011091891978220e-18,  -1.327552386971112e-20,   1.263148040929344e-22,
  -5.842405196921734e-25,  -8.591673842634903e-27,   9.071817323141104e-02,  -1.980011517749374e-03,   3.099926317443850e-05,  -4.039940389959478e-07,   4.460283029285905e-09,
  -3.957632578871228e-11,   2.161695532269872e-13,   1.078759573613514e-15,  -5.487858898548388e-17,   1.011740627541513e-18,  -1.327901994564066e-20,   1.262491031951142e-22,
  -5.816819891946750e-25,  -8.643679821285048e-27,   9.072330989211831e-02,  -1.980212228065740e-03,   3.100369302430288e-05,  -4.040594769595062e-07,   4.460816583941872e-09,
  -3.957248840180930e-11,   2.159134585620696e-13,   1.084812457472122e-15,  -5.497762164891259e-17,   1.012885053294931e-18,  -1.328517589908552e-20,   1.261328629566564e-22,
  -5.771622650934558e-25,  -8.735503721224621e-27,   9.072952152387177e-02,  -1.980454943583513e-03,   3.100904988131846e-05,  -4.041386023920701e-07,   4.461461480279049e-09,
  -3.956783881714437e-11,   2.156035818121213e-13,   1.092134700837255e-15,  -5.509739324281500e-17,   1.014268429636347e-18,  -1.329259768347459e-20,   1.259917752548989e-22,
  -5.716881726207760e-25,  -8.846637871316752e-27,   9.073555201062693e-02,  -1.980690582747484e-03,   3.101425047164502e-05,  -4.042154130019426e-07,   4.462087237320965e-09,
  -3.956331526049970e-11,   2.153025448172130e-13,   1.099246181865768e-15,  -5.521368658831849e-17,   1.015610888358165e-18,  -1.329977949928354e-20,   1.258542557372393e-22,
  -5.663648082981256e-25,  -8.954629275491645e-27,   9.074041033750666e-02,  -1.980880421441708e-03,   3.101844017598191e-05,  -4.042772884851940e-07,   4.462591126058489e-09,
  -3.955966410410216e-11,   2.150598799759059e-13,   1.104977372129057e-15,  -5.530738612548478e-17,   1.016691997252279e-18,  -1.330554849243989e-20,   1.257430746358985e-22,
  -5.620697752863202e-25,  -9.041700389023646e-27,   9.074362075340746e-02,  -1.981005868780445e-03,   3.102120874432305e-05,  -4.043181736508830e-07,   4.462923982436370e-09,
  -3.955724803830194e-11,   2.148994562796651e-13,   1.108765553595147e-15,  -5.536930850761168e-17,   1.017406198947060e-18,  -1.330935241379362e-20,   1.256694135954245e-22,
  -5.592284621045648e-25,  -9.099271942720306e-27,   9.074526949271142e-02,  -1.981070293633917e-03,   3.102263056333857e-05,  -4.043391698143792e-07,   4.463094887842756e-09,
  -3.955600620683569e-11,   2.148170478114157e-13,   1.110711310212070e-15,  -5.540111089899107e-17,   1.017772921252794e-18,  -1.331130339483163e-20,   1.256315249420614e-22,
  -5.577683122655510e-25,  -9.128848974954152e-27,   9.074584335743545e-02,  -1.981092717555655e-03,   3.102312544471805e-05,  -4.043464776695422e-07,   4.463154367896438e-09,
  -3.955557380628777e-11,   2.147883610919189e-13,   1.111388603410968e-15,  -5.541218037615748e-17,   1.017900553636920e-18,  -1.331198205120010e-20,   1.256183278661935e-22,
  -5.572599346027640e-25,  -9.139145327775785e-27,   9.074593442214435e-02,  -1.981096275935622e-03,   3.102320397577914e-05,  -4.043476373230507e-07,   4.463163806317848e-09,
  -3.955550518221785e-11,   2.147838087290825e-13,   1.111496083114765e-15,  -5.541393696698985e-17,   1.017920806726650e-18,  -1.331208972560609e-20,   1.256162332170327e-22,
  -5.571792545141517e-25,  -9.140779302408713e-27,   2.468592438581501e-01,  -5.001210524306207e-03,   6.615118910065518e-05,  -5.983622286490900e-07,   2.096016761698598e-09,
   4.637465290404911e-11,  -1.140576725879740e-12,   1.302510758298353e-14,  -4.200795545752777e-17,  -1.594021590229903e-18,   3.854249564051624e-20,  -4.387318454699447e-22,
   9.114998339525885e-25,   7.104768169417222e-26,   2.468654478683488e-01,  -5.001378659412101e-03,   6.615235904633772e-05,  -5.983185377105646e-07,   2.094411569768328e-09,
   4.640020940263012e-11,  -1.140683634652684e-12,   1.301966941941633e-14,  -4.184519697753218e-17,  -1.596263167384674e-18,   3.854749783967280e-20,  -4.382030874874818e-22,
   8.977379734890606e-25,   7.121536283164232e-26,   2.468763950302001e-01,  -5.001675326428412e-03,   6.615442269955860e-05,  -5.982414249088553e-07,   2.091579062407969e-09,
   4.644529551405975e-11,  -1.140871929424804e-12,   1.301006755867401e-14,  -4.155799047870311e-17,  -1.600216239592757e-18,   3.855625506924720e-20,  -4.372690938428498e-22,
   8.734548177027018e-25,   7.151086652470031e-26,   2.468896326057233e-01,  -5.002034042261080e-03,   6.615691683893254e-05,  -5.981481461200976e-07,   2.088153758290797e-09,
   4.649979922561045e-11,  -1.141099025037975e-12,   1.299844642859713e-14,  -4.121066916914796e-17,  -1.604992538482249e-18,   3.856672636251200e-20,  -4.361380090539651e-22,
   8.440911809139137e-25,   7.186755732800952e-26,   2.469024835723979e-01,  -5.002382259478384e-03,   6.615933679497655e-05,  -5.980575579623724e-07,   2.084828317020795e-09,
   4.655269487769878e-11,  -1.141318865103715e-12,   1.298715389106739e-14,  -4.087346639090809e-17,  -1.609625305642915e-18,   3.857676809984842e-20,  -4.350382040297531e-22,
   8.155853369737693e-25,   7.221316041940604e-26,   2.469128362568470e-01,  -5.002662765909682e-03,   6.616128534052984e-05,  -5.979845564448444e-07,   2.082149230743675e-09,
   4.659529573830542e-11,  -1.141495520848618e-12,   1.297804893096749e-14,  -4.060179939725500e-17,  -1.613354547608995e-18,   3.858476902459346e-20,  -4.341509503734211e-22,
   7.926213466794631e-25,   7.249109593401182e-26,   2.469196771815300e-01,  -5.002848113279191e-03,   6.616257244466987e-05,  -5.979363061643743e-07,   2.080378862936406e-09,
   4.662344014730640e-11,  -1.141612034144313e-12,   1.297202869901108e-14,  -4.042227655209567e-17,  -1.615817365347694e-18,   3.859001252776477e-20,  -4.335640501234152e-22,
   7.774471421775591e-25,   7.267451659096715e-26,   2.469231903407571e-01,  -5.002943296078593e-03,   6.616323329195400e-05,  -5.979115235708058e-07,   2.079469671085536e-09,
   4.663789195248799e-11,  -1.141671801977252e-12,   1.296893583568943e-14,  -4.033007985939570e-17,  -1.617081707250324e-18,   3.859269190640053e-20,  -4.332624574989637e-22,
   7.696544630513771e-25,   7.276863940638637e-26,   2.469244131307169e-01,  -5.002976425014172e-03,   6.616346328325209e-05,  -5.979028971626643e-07,   2.079153214832519e-09,
   4.664292176565482e-11,  -1.141692594001350e-12,   1.296785914747830e-14,  -4.029798946030617e-17,  -1.617521704098577e-18,   3.859362235360161e-20,  -4.331574549851517e-22,
   7.669421501951185e-25,   7.280138817310272e-26,   2.469246071707720e-01,  -5.002981682105300e-03,   6.616349977862827e-05,  -5.979015282420376e-07,   2.079102997407710e-09,
   4.664371991491524e-11,  -1.141695892900424e-12,   1.296768828292483e-14,  -4.029289713240854e-17,  -1.617591522265954e-18,   3.859376990139934e-20,  -4.331407910875036e-22,
   7.665117435286681e-25,   7.280658440337852e-26,   4.685650407002030e-01,  -8.422734486587358e-03,   8.130601422760241e-05,  -1.701279437021729e-07,  -8.390643688093408e-09,
   1.337135086380465e-10,  -3.253864419042500e-13,  -2.069991897239653e-14,   3.562721492818079e-16,  -8.055183546485242e-19,  -6.520711091304252e-20,   1.141270613212678e-21,
  -2.237141425608837e-24,  -2.314588433156166e-25,   4.685726536444044e-01,  -8.422781894716007e-03,   8.130129198491360e-05,  -1.700029305540819e-07,  -8.391090278297058e-09,
   1.336727152568313e-10,  -3.244569199221199e-13,  -2.070248617213245e-14,   3.559966702865328e-16,  -7.996996676708239e-19,  -6.521939070968478e-20,   1.139575335608880e-21,
  -2.203320503080587e-24,  -2.315106488150454e-25,   4.685860864441933e-01,  -8.422865518580597e-03,   8.129295931162708e-05,  -1.697823739889638e-07,  -8.391877233278954e-09,
   1.336007306582701e-10,  -3.228173518768006e-13,  -2.070700011922818e-14,   3.555105425111293e-16,  -7.894396121960823e-19,  -6.524088923356285e-20,   1.136583703845787e-21,
  -2.143712029224425e-24,  -2.316005556245905e-25,   4.686023289153502e-01,  -8.422966588819856e-03,   8.128288301034830e-05,  -1.695157276663205e-07,  -8.392827019942718e-09,
   1.335136792488329e-10,  -3.208357715215718e-13,  -2.071243130545503e-14,   3.549226425179447e-16,  -7.770451661230986e-19,  -6.526659692556339e-20,   1.132965706199660e-21,
  -2.071750609818975e-24,  -2.317067091618114e-25,   4.686180961823412e-01,  -8.423064655138623e-03,   8.127310075197942e-05,  -1.692569275696126e-07,  -8.393747163968123e-09,
   1.334291640819728e-10,  -3.189131378552859e-13,  -2.071767541713024e-14,   3.543518475334262e-16,  -7.650255481276942e-19,  -6.529125164202766e-20,   1.129452917074515e-21,
  -2.002015056407527e-24,  -2.318070814450641e-25,   4.686307976269782e-01,  -8.423143619610133e-03,   8.126522003455983e-05,  -1.690484813716091e-07,  -8.394487064526085e-09,
   1.333610746442429e-10,  -3.173650417224462e-13,  -2.072187967605533e-14,   3.538919713945226e-16,  -7.553517973063061e-19,  -6.531089708920573e-20,   1.126622707328884e-21,
  -1.945925382134035e-24,  -2.318860228098279e-25,   4.686391902897997e-01,  -8.423195780066610e-03,   8.126001247102139e-05,  -1.689107633223874e-07,  -8.394975314111023e-09,
   1.333160798569679e-10,  -3.163424558633088e-13,  -2.072464782657205e-14,   3.535880685472515e-16,  -7.489640095690700e-19,  -6.532377274267451e-20,   1.124752384759984e-21,
  -1.908905599279258e-24,  -2.319372482466625e-25,   4.686435002539859e-01,  -8.423222561433930e-03,   8.125733809907457e-05,  -1.688400445406449e-07,  -8.395225848469835e-09,
   1.332929721090414e-10,  -3.158174230581688e-13,  -2.072606632856330e-14,   3.534319922280330e-16,  -7.456849525679713e-19,  -6.533035233403734e-20,   1.123791832406138e-21,
  -1.889907552795562e-24,  -2.319632652338237e-25,   4.686450003653865e-01,  -8.423231882054866e-03,   8.125640725323714e-05,  -1.688154311804138e-07,  -8.395313016588380e-09,
   1.332849291230190e-10,  -3.156346987256077e-13,  -2.072655956160007e-14,   3.533776672181255e-16,  -7.445438660784646e-19,  -6.533263722115558e-20,   1.123457495090814e-21,
  -1.883297239405539e-24,  -2.319722745810182e-25,   4.686452384118788e-01,  -8.423233361067305e-03,   8.125625954052874e-05,  -1.688115254246712e-07,  -8.395326847417910e-09,
   1.332836528060826e-10,  -3.156057037518855e-13,  -2.072663780765038e-14,   3.533690465294767e-16,  -7.443628017802325e-19,  -6.533299955444966e-20,   1.123404439971586e-21,
  -1.882248374859496e-24,  -2.319737020520879e-25,   7.403570358551778e-01,  -1.116108441153097e-02,   5.647911784987582e-05,   7.143162456921868e-07,  -1.268401508010227e-08,
  -3.121635293692614e-11,   2.649507517893860e-12,  -1.395776462682252e-14,  -4.703455557777006e-16,   6.981771537721600e-18,   5.432055873467928e-20,  -2.158729137360220e-21,
   4.527365528747972e-24,   5.124248958314321e-25,   7.403623164820484e-01,  -1.116088361441393e-02,   5.647200404661049e-05,   7.142867528528414e-07,  -1.268030375477724e-08,
  -3.124346261183093e-11,   2.648277615568491e-12,  -1.393448704019473e-14,  -4.701155695211242e-16,   6.970784286457434e-18,   5.434644816360862e-20,  -2.155029238712942e-21,
   4.481290271367426e-24,   5.115688318789302e-25,   7.403716336916634e-01,  -1.116052931151988e-02,   5.645945332246681e-05,   7.142346917239712e-07,  -1.267375646701614e-08,
  -3.129126094286919e-11,   2.646107924848676e-12,  -1.389344341406929e-14,  -4.697096682097919e-16,   6.951412570284511e-18,   5.439190055191467e-20,  -2.148505792409237e-21,
   4.400158424355160e-24,   5.100587516091799e-25,   7.403828992411549e-01,  -1.116010089623474e-02,   5.644427974007344e-05,   7.141717038307403e-07,  -1.266584181052517e-08,
  -3.134899594105584e-11,   2.643485149449332e-12,  -1.384386421738344e-14,  -4.692187002986443e-16,   6.928014432722453e-18,   5.444647061780713e-20,  -2.140626236592402e-21,
   4.302340136731821e-24,   5.082335314517790e-25,   7.403938346783709e-01,  -1.115968501020125e-02,   5.642955251197329e-05,   7.141105196263712e-07,  -1.265816090530412e-08,
  -3.140497788040025e-11,   2.640939881988264e-12,  -1.379578716490747e-14,  -4.687419231551391e-16,   6.905327499200155e-18,   5.449903711085408e-20,  -2.132985971837224e-21,
   4.207680105214903e-24,   5.064624665450316e-25,   7.404026434343176e-01,  -1.115934998650018e-02,   5.641769061413019e-05,   7.140612041862083e-07,  -1.265197506334987e-08,
  -3.145002880196625e-11,   2.638890076456107e-12,  -1.375709527577199e-14,  -4.683577278346272e-16,   6.887070943714714e-18,   5.454109133593862e-20,  -2.126837571985117e-21,
   4.131638009109689e-24,   5.050363160076057e-25,   7.404084637654841e-01,  -1.115912861305740e-02,   5.640985354351902e-05,   7.140286045806732e-07,  -1.264788844812088e-08,
  -3.147977445163099e-11,   2.637535909415353e-12,  -1.373154713582728e-14,  -4.681038048180472e-16,   6.875016998543844e-18,   5.456873693504844e-20,  -2.122777999826933e-21,
   4.081495775561815e-24,   5.040942345672627e-25,   7.404114526795571e-01,  -1.115901492851699e-02,   5.640582916060389e-05,   7.140118591536288e-07,  -1.264579004745316e-08,
  -3.149504309473863e-11,   2.636840575087946e-12,  -1.371843274643511e-14,  -4.679733866665534e-16,   6.868829707707805e-18,   5.458289006766519e-20,  -2.120694198864803e-21,
   4.055777790750370e-24,   5.036105217257526e-25,   7.404124929818401e-01,  -1.115897535978095e-02,   5.640442848946466e-05,   7.140060301225363e-07,  -1.264505972315082e-08,
  -3.150035634434779e-11,   2.636598572771207e-12,  -1.371386908673988e-14,  -4.679279908062474e-16,   6.866676639868166e-18,   5.458780916150590e-20,  -2.119969069431780e-21,
   4.046831574261080e-24,   5.034421755651521e-25,   7.404126580626956e-01,  -1.115896908077743e-02,   5.640420622472273e-05,   7.140051051055868e-07,  -1.264494383279619e-08,
  -3.150119942970162e-11,   2.636560171056335e-12,  -1.371314494064177e-14,  -4.679207869837174e-16,   6.866335000221205e-18,   5.458858942012481e-20,  -2.119854008810256e-21,
   4.045412177994988e-24,   5.034154620380056e-25,   1.041145152807782e+00,  -1.221181455916403e-02,  -3.808635807100075e-06,   1.217022286188164e-06,   3.799796084189585e-10,
  -2.190132989143445e-10,  -1.234339881398142e-14,   4.795908951210880e-14,  -1.584961711419988e-17,  -1.166249714807801e-17,   8.824526627722343e-21,   3.020671754544959e-21,
  -3.754506390054716e-24,  -8.192277093119865e-25,   1.041144796177737e+00,  -1.221147299258880e-02,  -3.808422169950516e-06,   1.216817749661631e-06,   3.799617685848009e-10,
  -2.189194984845320e-10,  -1.238425232646955e-14,   4.792012784217733e-14,  -1.581311573416663e-17,  -1.164714951308470e-17,   8.801832310190792e-21,   3.014801639289619e-21,
  -3.742868076923894e-24,  -8.170350657819149e-25,   1.041144166914673e+00,  -1.221087033961621e-02,  -3.808045212105100e-06,   1.216456913040863e-06,   3.799302435038974e-10,
  -2.187540483137862e-10,  -1.245626153377681e-14,   4.785142130680205e-14,  -1.574878584208677e-17,  -1.162009285409206e-17,   8.761845943966412e-21,   3.004456677155373e-21,
  -3.722371165245613e-24,  -8.131725516381561e-25,   1.041143406030780e+00,  -1.221014168468727e-02,  -3.807589404759143e-06,   1.216020707080308e-06,   3.798920439617556e-10,
  -2.185540901473030e-10,  -1.254320387661068e-14,   4.776841210253148e-14,  -1.567112923089979e-17,  -1.158741736384575e-17,   8.713592958071068e-21,   2.991969490723864e-21,
  -3.697652596188162e-24,  -8.085129219149000e-25,   1.041142667406902e+00,  -1.220943440231650e-02,  -3.807146929670173e-06,   1.215597373115222e-06,   3.798548777752703e-10,
  -2.183600851095155e-10,  -1.262746795439638e-14,   4.768790299062661e-14,  -1.559587936421075e-17,  -1.155574019554447e-17,   8.666853248983745e-21,   2.979870205992437e-21,
  -3.673725750860679e-24,  -8.040008935941344e-25,   1.041142072401914e+00,  -1.220886468445404e-02,  -3.806790488104256e-06,   1.215256431909375e-06,   3.798248779556301e-10,
  -2.182038765843321e-10,  -1.269525119298703e-14,   4.762309944026183e-14,  -1.553535768091348e-17,  -1.153025270963219e-17,   8.629274351651250e-21,   2.970139678334467e-21,
  -3.654500302583662e-24,  -8.003742578759620e-25,   1.041141679243403e+00,  -1.220848825422592e-02,  -3.806554963068168e-06,   1.215031188642669e-06,   3.798050256338847e-10,
  -2.181006956384082e-10,  -1.273999281196497e-14,   4.758030460816334e-14,  -1.549541427376838e-17,  -1.151342631008042e-17,   8.604479071834266e-21,   2.963717987797149e-21,
  -3.641820766839648e-24,  -7.979818483014135e-25,   1.041141477340845e+00,  -1.220829494831750e-02,  -3.806434011302211e-06,   1.214915529240799e-06,   3.797948215605324e-10,
  -2.180477193013941e-10,  -1.276295483396778e-14,   4.755833551313511e-14,  -1.547491633210140e-17,  -1.150478987052303e-17,   8.591756689803505e-21,   2.960422635778574e-21,
  -3.635316724411083e-24,  -7.967544693249778e-25,   1.041141407067312e+00,  -1.220822766786258e-02,  -3.806391913188766e-06,   1.214875275122456e-06,   3.797912685139255e-10,
  -2.180292823147616e-10,  -1.277094459828659e-14,   4.755069025746641e-14,  -1.546778420841049e-17,  -1.150178463009600e-17,   8.587330327273047e-21,   2.959276055094669e-21,
  -3.633054127069440e-24,  -7.963274657783453e-25,   1.041141395915894e+00,  -1.220821699144920e-02,  -3.806385232810119e-06,   1.214868887452494e-06,   3.797907046267009e-10,
  -2.180263567096929e-10,  -1.277221235098460e-14,   4.754947712187273e-14,  -1.546665255122325e-17,  -1.150130777549780e-17,   8.586628008938824e-21,   2.959094127363184e-21,
  -3.632695140709052e-24,  -7.962597155436328e-25,   1.344547715982642e+00,  -1.102538133932721e-02,  -6.682654981036138e-05,   6.838780989488140e-07,   1.481484751750236e-08,
  -1.869815744264363e-11,  -3.195307566062316e-12,  -2.027755019204660e-14,   5.985928593549042e-16,   9.767864554249417e-18,  -7.545918302336146e-20,  -3.202333599503595e-21,
  -5.911454153929436e-24,   8.368337804303492e-25,   1.344541467683278e+00,  -1.102518906197108e-02,  -6.681824172415328e-05,   6.838602386669479e-07,   1.481037261881708e-08,
  -1.873756209912518e-11,  -3.193742862509713e-12,  -2.024500711979235e-14,   5.982734619494945e-16,   9.751586611030033e-18,  -7.549248879560013e-20,  -3.196304138237162e-21,
  -5.840427103271354e-24,   8.352026622193190e-25,   1.344530443090813e+00,  -1.102484978968743e-02,  -6.680358401719903e-05,   6.838286940431429e-07,   1.480247837587559e-08,
  -1.880704035617810e-11,  -3.190982600702115e-12,  -2.018762884902176e-14,   5.977097688235478e-16,   9.722889107526670e-18,  -7.555090330864125e-20,  -3.185674733744358e-21,
  -5.715393270156535e-24,   8.323261720566922e-25,   1.344517113110009e+00,  -1.102443954507405e-02,  -6.678586324232059e-05,   6.837904990337817e-07,   1.479293561802540e-08,
  -1.889096579721023e-11,  -3.187646026044619e-12,  -2.011832224659866e-14,   5.970279559885441e-16,   9.688230691698981e-18,  -7.562093609402425e-20,  -3.172838033808112e-21,
  -5.564702421187714e-24,   8.288506973845572e-25,   1.344504173720138e+00,  -1.102404129410057e-02,  -6.676866386535105e-05,   6.837533666984214e-07,   1.478367486196471e-08,
  -1.897234664282875e-11,  -3.184408155640444e-12,  -2.005111992985235e-14,   5.963658669372475e-16,   9.654629803216350e-18,  -7.568829288932467e-20,  -3.160393646800634e-21,
  -5.418938424720275e-24,   8.254797142337836e-25,   1.344493750721712e+00,  -1.102372047359856e-02,  -6.675481088172481e-05,   6.837234152202113e-07,   1.477621680107546e-08,
  -1.903783974735227e-11,  -3.181800642555260e-12,  -1.999703941692810e-14,   5.958323562332117e-16,   9.627593511360228e-18,  -7.574210428994404e-20,  -3.150380970459322e-21,
  -5.301887644451456e-24,   8.227662108525104e-25,   1.344486863784523e+00,  -1.102350848372425e-02,  -6.674565835503474e-05,   6.837036051466501e-07,   1.477128976529570e-08,
  -1.908108400575092e-11,  -3.180078071961524e-12,  -1.996133177082421e-14,   5.954797534321584e-16,   9.609744141266366e-18,  -7.577744176322669e-20,  -3.143770821629269e-21,
  -5.224725805463405e-24,   8.209742145867556e-25,   1.344483327134741e+00,  -1.102339961758432e-02,  -6.674095848987054e-05,   6.836934259541116e-07,   1.476875984238172e-08,
  -1.910328197968228e-11,  -3.179193581791670e-12,  -1.994300277772835e-14,   5.952986539228667e-16,   9.600582498143915e-18,  -7.579552124358694e-20,  -3.140378064207182e-21,
  -5.185156115372581e-24,   8.200542603260859e-25,   1.344482096190818e+00,  -1.102336172585536e-02,  -6.673932272167633e-05,   6.836898820742234e-07,   1.476787933457682e-08,
  -1.911100659262331e-11,  -3.178885747943922e-12,  -1.993662457131949e-14,   5.952356172267916e-16,   9.597394478278205e-18,  -7.580180315304547e-20,  -3.139197481621909e-21,
  -5.171392528853090e-24,   8.197341130521431e-25,   1.344481900857892e+00,  -1.102335571296591e-02,  -6.673906315077885e-05,   6.836893196656820e-07,   1.476773961272730e-08,
  -1.911223230659076e-11,  -3.178836899951452e-12,  -1.993561250271721e-14,   5.952256140121979e-16,   9.596888620168462e-18,  -7.580279949207541e-20,  -3.139010153556992e-21,
  -5.169208864687715e-24,   8.196833125217794e-25,   1.620286451682478e+00,  -7.858740485044707e-03,  -9.111888357909303e-05,  -3.840746874614106e-07,   8.151148810005589e-09,
   1.851462756803524e-10,   1.119773233936455e-12,  -2.306566332176030e-14,  -6.186698019695226e-16,  -4.304039096993225e-18,   8.459828691061911e-20,   2.484895702848111e-21,
   1.875906255895260e-23,  -3.548237159340534e-25,   1.620277918525851e+00,  -7.858847895890246e-03,  -9.111428979661388e-05,  -3.839014970824869e-07,   8.152704382482254e-09,
   1.851006401930072e-10,   1.118156684419056e-12,  -2.307985851928709e-14,  -6.183093323572880e-16,  -4.291329396934790e-18,   8.471003064358624e-20,   2.482255160016274e-21,
   1.866548032308308e-23,  -3.556631007867006e-25,   1.620262861987690e+00,  -7.859037384485448e-03,  -9.110618328815090e-05,  -3.835959347816997e-07,   8.155447369390035e-09,
   1.850200930984692e-10,   1.115305028766990e-12,  -2.310487137095403e-14,  -6.176728985806575e-16,  -4.268914046859030e-18,   8.490673486451724e-20,   2.477590960693263e-21,
   1.850047986405409e-23,  -3.571389901237141e-25,   1.620244656059304e+00,  -7.859266448720351e-03,  -9.109637960656693e-05,  -3.832265050121675e-07,   8.158761072854155e-09,
   1.849226562639110e-10,   1.111858092139707e-12,  -2.313505786643923e-14,  -6.169026701217801e-16,  -4.241828133122837e-18,   8.514379186141628e-20,   2.471942593297282e-21,
   1.830117611842001e-23,  -3.589147603005738e-25,   1.620226982685884e+00,  -7.859488749741914e-03,  -9.108686110112429e-05,  -3.828679312354666e-07,   8.161974665535367e-09,
   1.848280260795011e-10,   1.108513244381539e-12,  -2.316430030952136e-14,  -6.161542706522150e-16,  -4.215553476908021e-18,   8.537308565689769e-20,   2.466450520420119e-21,
   1.810792260441667e-23,  -3.606293455147126e-25,   1.620212745695157e+00,  -7.859667781993937e-03,  -9.107919221389217e-05,  -3.825791134754457e-07,   8.164561134928864e-09,
   1.847517644703059e-10,   1.105819666819330e-12,  -2.318781317713182e-14,  -6.155508871156294e-16,  -4.194401212042470e-18,   8.555720242023988e-20,   2.462019937961465e-21,
   1.795240303669406e-23,  -3.620039346241390e-25,   1.620203338365194e+00,  -7.859786058563209e-03,  -9.107412430788571e-05,  -3.823882896918580e-07,   8.166269072980180e-09,
   1.847013580880539e-10,   1.104040282844342e-12,  -2.320332829792232e-14,  -6.151519461011537e-16,  -4.180431157648122e-18,   8.567857020618119e-20,   2.459089240428317e-21,
   1.784971835198133e-23,  -3.629089809835115e-25,   1.620198507319138e+00,  -7.859846791586024e-03,  -9.107152155903157e-05,  -3.822902993057300e-07,   8.167145823790985e-09,
   1.846754676507476e-10,   1.103126633785668e-12,  -2.321128932595468e-14,  -6.149469979254519e-16,  -4.173259027654859e-18,   8.574080770249392e-20,   2.457583246163260e-21,
   1.779700957448520e-23,  -3.633727586758030e-25,   1.620196825840143e+00,  -7.859867929052170e-03,  -9.107061562671000e-05,  -3.822561939303253e-07,   8.167450928093037e-09,
   1.846664555549742e-10,   1.102808653708488e-12,  -2.321405916356644e-14,  -6.148756522416278e-16,  -4.170763046320834e-18,   8.576245560144372e-20,   2.457058921428401e-21,
   1.777866773917506e-23,  -3.635340204937690e-25,   1.620196559013098e+00,  -7.859871283219086e-03,  -9.107047186669494e-05,  -3.822507819280318e-07,   8.167499341245191e-09,
   1.846650254266468e-10,   1.102758195781594e-12,  -2.321449864780289e-14,  -6.148643301139225e-16,  -4.170366984800145e-18,   8.576589013981339e-20,   2.456975711213172e-21,
   1.777575732947473e-23,  -3.635596029164817e-25,   1.837220765941907e+00,  -3.883966437536935e-03,  -6.279363179599794e-05,  -7.620434319779348e-07,  -6.045582332364677e-09,
   2.950075953835616e-12,   1.161788315696312e-12,   2.414046512394929e-14,   2.823379158140904e-16,   9.753720337639528e-19,  -4.206438404304300e-20,  -1.186059362737910e-21,
  -1.727471512749866e-23,  -1.130438746233520e-25,   1.837214872242739e+00,  -3.884180750593121e-03,  -6.279702315343638e-05,  -7.620402662320360e-07,  -6.043939856295262e-09,
   2.997651852523647e-12,   1.162525705411505e-12,   2.414359666093763e-14,   2.821570456674127e-16,   9.692259018684879e-19,  -4.217058888552455e-20,  -1.186849583107440e-21,
  -1.726012096592496e-23,  -1.123854097290462e-25,   1.837204472460305e+00,  -3.884558908564513e-03,  -6.280300650389912e-05,  -7.620346439464912e-07,  -6.041040839818829e-09,
   3.081605208751659e-12,   1.163826453115262e-12,   2.414910542069259e-14,   2.818375337797148e-16,   9.583776800209880e-19,  -4.235791461064265e-20,  -1.188240011829587e-21,
  -1.723428090649131e-23,  -1.112225764028126e-25,   1.837191896493191e+00,  -3.885016179875138e-03,  -6.281024035086608e-05,  -7.620277835607207e-07,  -6.037533883405444e-09,
   3.183130899394733e-12,   1.165398668949772e-12,   2.415573787280585e-14,   2.814505566823036e-16,   9.452543206703685e-19,  -4.258430373305529e-20,  -1.189914632406755e-21,
  -1.720288409250502e-23,  -1.098148299402896e-25,   1.837179687502255e+00,  -3.885460089528438e-03,  -6.281726149899843e-05,  -7.620210588366207e-07,  -6.034127888794034e-09,
   3.281699050286407e-12,   1.166924254754033e-12,   2.416214637664781e-14,   2.810742370771889e-16,   9.325085683958120e-19,  -4.280394483999623e-20,  -1.191533303225130e-21,
  -1.717224681583922e-23,  -1.084465056272791e-25,   1.837169851768553e+00,  -3.885817696350111e-03,  -6.282291668050016e-05,  -7.620155950691617e-07,  -6.031382987902459e-09,
   3.361110536280929e-12,   1.168152749031876e-12,   2.416728736478678e-14,   2.807706140945722e-16,   9.222365947108711e-19,  -4.298078890886714e-20,  -1.192832248769538e-21,
  -1.714745280721459e-23,  -1.073429806444358e-25,   1.837163352329680e+00,  -3.886053996064827e-03,  -6.282665305153608e-05,  -7.620119619809558e-07,  -6.029568679600627e-09,
   3.413587292579151e-12,   1.168964272233951e-12,   2.417067385061334e-14,   2.805697579210613e-16,   9.154470240606079e-19,  -4.309759722881564e-20,  -1.193688102358644e-21,
  -1.713101404862521e-23,  -1.066131946604541e-25,   1.837160014506965e+00,  -3.886175347119018e-03,  -6.282857171080260e-05,  -7.620100891872847e-07,  -6.028636782615652e-09,
   3.440537563072516e-12,   1.169380952748928e-12,   2.417240969835391e-14,   2.804665383178150e-16,   9.119596266820848e-19,  -4.315756930349961e-20,  -1.194126861044942e-21,
  -1.712255485507324e-23,  -1.062382305066561e-25,   1.837158852739263e+00,  -3.886217584439878e-03,  -6.282923949447941e-05,  -7.620094362252469e-07,  -6.028312401410469e-09,
   3.449918001872374e-12,   1.169525970197956e-12,   2.417301335466696e-14,   2.804306005914487e-16,   9.107457061904886e-19,  -4.317844080898612e-20,  -1.194279453513335e-21,
  -1.711960783255810e-23,  -1.061076915108356e-25,   1.837158668382352e+00,  -3.886224286919816e-03,  -6.282934546144820e-05,  -7.620093325560390e-07,  -6.028260925349934e-09,
   3.451406555455424e-12,   1.169548981899197e-12,   2.417310912185724e-14,   2.804248972376266e-16,   9.105530689859883e-19,  -4.318175271907440e-20,  -1.194303662067496e-21,
  -1.711914005142147e-23,  -1.060869753801237e-25,   1.968174372067671e+00,  -8.217764403871018e-04,  -1.563497242579567e-05,  -2.580512269902925e-07,  -3.865430930295422e-09,
  -5.321923753002292e-11,  -6.703657925740676e-13,  -7.541496510781129e-15,  -7.074529410232969e-17,  -4.217618060739397e-19,   2.377813320565533e-21,   1.408379874995381e-22,
   3.176215570955253e-24,   5.479575088072412e-26,   1.968172901916257e+00,  -8.218491933596407e-04,  -1.563715206122311e-05,  -2.581012449695504e-07,  -3.866375823506877e-09,
  -5.323410711150246e-11,  -6.705512761701686e-13,  -7.542900548151540e-15,  -7.073461899771621e-17,  -4.210197819266395e-19,   2.397784338174856e-21,   1.412439931122319e-22,
   3.183072816521424e-24,   5.489198380574713e-26,   1.968170307644153e+00,  -8.219775785848896e-04,  -1.564099849491249e-05,  -2.581895138224664e-07,  -3.868043314440994e-09,
  -5.326034696005488e-11,  -6.708785417249713e-13,  -7.545375946526050e-15,  -7.071571382946722e-17,  -4.197087611838329e-19,   2.433058086165866e-21,   1.419609689125154e-22,
   3.195179556504377e-24,   5.506181711213450e-26,   1.968167170338165e+00,  -8.221328429142000e-04,  -1.564565038146355e-05,  -2.582962688021532e-07,  -3.870060023750505e-09,
  -5.329208027919482e-11,  -6.712742351255499e-13,  -7.548365730054399e-15,  -7.069273614410783e-17,  -4.181205478853340e-19,   2.475770453526756e-21,   1.428289200018710e-22,
   3.209831121542160e-24,   5.526723010143728e-26,   1.968164124397925e+00,  -8.222835913052071e-04,  -1.565016712514357e-05,  -2.583999249422717e-07,  -3.872018188728428e-09,
  -5.332289042712565e-11,  -6.716583258267541e-13,  -7.551264496498177e-15,  -7.067030680919360e-17,  -4.165756853338386e-19,   2.517296668642476e-21,   1.436725344032630e-22,
   3.224067127490080e-24,   5.546669205731410e-26,   1.968161670414618e+00,  -8.224050469152996e-04,  -1.565380630884098e-05,  -2.584834434935835e-07,  -3.873595932140016e-09,
  -5.334771353915258e-11,  -6.719677144018912e-13,  -7.553597077158874e-15,  -7.065214982943133e-17,  -4.153289755139127e-19,   2.550793940286662e-21,   1.443528719199298e-22,
   3.235544432291078e-24,   5.562741193258016e-26,   1.968160048761639e+00,  -8.224853098006683e-04,  -1.565621128774253e-05,  -2.585386381707630e-07,  -3.874638609645636e-09,
  -5.336411760767541e-11,  -6.721721381848834e-13,  -7.555137117052370e-15,  -7.064010880639452e-17,  -4.145040996609095e-19,   2.572950036340623e-21,   1.448027856341699e-22,
   3.243132816734513e-24,   5.573363021829136e-26,   1.968159215932915e+00,  -8.225265308539431e-04,  -1.565744644334147e-05,  -2.585669854762435e-07,  -3.875174115492674e-09,
  -5.337254231403125e-11,  -6.722771150322941e-13,  -7.555927602695906e-15,  -7.063391179420809e-17,  -4.140801547222765e-19,   2.584334963251849e-21,   1.450339488258481e-22,
   3.247031170995888e-24,   5.578818376063476e-26,   1.968158926054103e+00,  -8.225408785726567e-04,  -1.565787636390982e-05,  -2.585768523654104e-07,  -3.875360509743049e-09,
  -5.337547467903088e-11,  -6.723136524608831e-13,  -7.556202674994477e-15,  -7.063175273816891e-17,  -4.139325439825239e-19,   2.588298659962446e-21,   1.451144249592772e-22,
   3.248388244680094e-24,   5.580717247310116e-26,   1.968158880054084e+00,  -8.225431553748046e-04,  -1.565794458701687e-05,  -2.585784181214430e-07,  -3.875390088253816e-09,
  -5.337594000823702e-11,  -6.723194504131896e-13,  -7.556246322166384e-15,  -7.063141002461921e-17,  -4.139091176832162e-19,   2.588927694776621e-21,   1.451271962520725e-22,
   3.248603603826676e-24,   5.581018576067174e-26,   9.318018393832748e-03,  -2.017736725289873e-04,   3.262621143122189e-06,  -4.664631563610501e-08,   6.206716097031407e-10,
  -7.861662089279775e-12,   9.576320864615894e-14,  -1.128701954103080e-15,   1.288715674801755e-17,  -1.427358977965753e-19,   1.526136341851888e-21,  -1.574433276910447e-23,
   1.536563753945940e-25,  -1.429492297483952e-27,   9.318324966367334e-03,  -2.017868178103243e-04,   3.262971032853226e-06,  -4.665370468537592e-08,   6.208066782968108e-10,
  -7.863891918112115e-12,   9.579717106550921e-14,  -1.129185815322298e-15,   1.289362586104963e-17,  -1.428174879770984e-19,   1.527091623547476e-21,  -1.575482814074946e-23,
   1.537541841063814e-25,  -1.430259756727783e-27,   9.318865945195088e-03,  -2.018100145592173e-04,   3.263588480660950e-06,  -4.666674448118456e-08,   6.210450478402311e-10,
  -7.867827261743686e-12,   9.585711211426180e-14,  -1.130039820243397e-15,   1.290504399340873e-17,  -1.429614991766576e-19,   1.528777725590193e-21,  -1.577335193199641e-23,
   1.539268065883507e-25,  -1.431612465892951e-27,   9.319520148217974e-03,  -2.018380672031020e-04,   3.264335210658011e-06,  -4.668251524427743e-08,   6.213333531520903e-10,
  -7.872587243981772e-12,   9.592961704933020e-14,  -1.131072874460492e-15,   1.291885651598473e-17,  -1.431357141669742e-19,   1.530817418014554e-21,  -1.579575883822110e-23,
   1.541356074187732e-25,  -1.433245645026299e-27,   9.320155284990771e-03,  -2.018653032480663e-04,   3.265060233718817e-06,  -4.669782826827036e-08,   6.216133044145657e-10,
  -7.877209537746493e-12,   9.600002828251776e-14,  -1.132076146102789e-15,   1.293227133424196e-17,  -1.433049177340659e-19,   1.532798395728338e-21,  -1.581751917239285e-23,
   1.543383745315059e-25,  -1.434828456838751e-27,   9.320666977168671e-03,  -2.018872464185403e-04,   3.265644382056067e-06,  -4.671016641990434e-08,   6.218388792860137e-10,
  -7.880934190352152e-12,   9.605676835616921e-14,  -1.132884655715678e-15,   1.294308233740425e-17,  -1.434412823059446e-19,   1.534394875970916e-21,  -1.583505481100160e-23,
   1.545017689899523e-25,  -1.436101650911259e-27,   9.321005111016977e-03,  -2.019017471357299e-04,   3.266030415648183e-06,  -4.671832031757889e-08,   6.219879595177452e-10,
  -7.883395860662059e-12,   9.609426985412484e-14,  -1.133419045030048e-15,   1.295022811257022e-17,  -1.435314171950153e-19,   1.535450110362088e-21,  -1.584664488448013e-23,
   1.546097605905511e-25,  -1.436942025432368e-27,   9.321178764114537e-03,  -2.019091942759992e-04,   3.266228674361888e-06,  -4.672250806415575e-08,   6.220645268890494e-10,
  -7.884660196540052e-12,   9.611353134876063e-14,  -1.133693522990097e-15,   1.295389844622580e-17,  -1.435777143127630e-19,   1.535992119187428e-21,  -1.585259781832835e-23,
   1.546652266968144e-25,  -1.437373310549935e-27,   9.321239206491265e-03,  -2.019117863736139e-04,   3.266297682032198e-06,  -4.672396570023673e-08,   6.220911780641218e-10,
  -7.885100284164377e-12,   9.612023591522071e-14,  -1.133789064479939e-15,   1.295517604075762e-17,  -1.435938298081469e-19,   1.536180785523191e-21,  -1.585466993097626e-23,
   1.546845333375054e-25,  -1.437523377531273e-27,   9.321248797903232e-03,  -2.019121977062866e-04,   3.266308632689733e-06,  -4.672419700950192e-08,   6.220954072955435e-10,
  -7.885170121146082e-12,   9.612129985784622e-14,  -1.133804225927190e-15,   1.295537878222328e-17,  -1.435963871798633e-19,   1.536210724993958e-21,  -1.585499875333786e-23,
   1.546875970902918e-25,  -1.437547188922441e-27,   8.326255414156733e-02,  -1.750158860559952e-03,   2.655223959849435e-05,  -3.386406815527810e-07,   3.721870657771617e-09,
  -3.419364549177881e-11,   2.266650655447986e-13,  -1.887587288166334e-16,  -2.672567354678082e-17,   5.819009496152417e-19,  -8.430611545110122e-21,   9.284449859797733e-23,
  -7.278909071845654e-25,   1.136124662367059e-27,   8.326504761547154e-02,  -1.750254215988891e-03,   2.655433494065421e-05,  -3.386727408612328e-07,   3.722188565372373e-09,
  -3.419398564459647e-11,   2.265941728379025e-13,  -1.867823293968968e-16,  -2.676138364717421e-17,   5.823799488441305e-19,  -8.435080828186132e-21,   9.285163900398801e-23,
  -7.271497018843535e-25,   1.115011149186783e-27,   8.326944754938762e-02,  -1.750422479476977e-03,   2.655803235010001e-05,  -3.387293102657525e-07,   3.722749437002362e-09,
  -3.419458268002251e-11,   2.264690052422945e-13,  -1.832936269611229e-16,  -2.682440998056974e-17,   5.832251792662212e-19,  -8.442963189400616e-21,   9.286411243181572e-23,
  -7.258390685354558e-25,   1.077725690882519e-27,   8.327476826928695e-02,  -1.750625957989078e-03,   2.656250354473062e-05,  -3.387977150194336e-07,   3.723427510231126e-09,
  -3.419529921581353e-11,   2.263175211297844e-13,  -1.790728092004549e-16,  -2.690064817432559e-17,   5.842472895778825e-19,  -8.452488205711445e-21,   9.287898058762297e-23,
  -7.242495195758137e-25,   1.032587969135165e-27,   8.327993381774385e-02,  -1.750823504501063e-03,   2.656684436235851e-05,  -3.388641216135009e-07,   3.724085626621898e-09,
  -3.419598915358911e-11,   2.261703266881619e-13,  -1.749729650363160e-16,  -2.697468619044741e-17,   5.852395870637711e-19,  -8.461728192478704e-21,   9.289318919289968e-23,
  -7.227014698539443e-25,   9.887148248825679e-28,   8.328409532110244e-02,  -1.750982654784480e-03,   2.657034145433847e-05,  -3.389176182182303e-07,   3.724615692422601e-09,
  -3.419654089983855e-11,   2.260516510906048e-13,  -1.716685019818889e-16,  -2.703434980385294e-17,   5.860390048626781e-19,  -8.469166972042912e-21,   9.290447403491985e-23,
  -7.214508370211354e-25,   9.533323126828835e-28,   8.328684526861579e-02,  -1.751087823050489e-03,   2.657265236135929e-05,  -3.389529679758205e-07,   3.724965899417617e-09,
  -3.419690349618446e-11,   2.259731845401196e-13,  -1.694841481341194e-16,  -2.707378402591602e-17,   5.865672633239085e-19,  -8.474080014926675e-21,   9.291185177422390e-23,
  -7.206227048717040e-25,   9.299331330810268e-28,   8.328825752924129e-02,  -1.751141833407909e-03,   2.657383915080909e-05,  -3.389711218153246e-07,   3.725145731676105e-09,
  -3.419708909191701e-11,   2.259328734184373e-13,  -1.683621232280237e-16,  -2.709403834447619e-17,   5.868385546794647e-19,  -8.476602363801911e-21,   9.291561612954173e-23,
  -7.201968822311338e-25,   9.179106424486915e-28,   8.328874908441994e-02,  -1.751160632433600e-03,   2.657425222822222e-05,  -3.389774404329716e-07,   3.725208321426285e-09,
  -3.419715359231795e-11,   2.259188404080752e-13,  -1.679715516372707e-16,  -2.710108851649774e-17,   5.869329809709124e-19,  -8.477480173550855e-21,   9.291692245187693e-23,
  -7.200485852271420e-25,   9.137251662289737e-28,   8.328882708769125e-02,  -1.751163615590809e-03,   2.657431777813121e-05,  -3.389784431109294e-07,   3.725218253438271e-09,
  -3.419716382299574e-11,   2.259166134507796e-13,  -1.679095713799552e-16,  -2.710220730405788e-17,   5.869479651632410e-19,  -8.477619464318792e-21,   9.291712956226711e-23,
  -7.200250484740242e-25,   9.130609442502106e-28,   2.278682316251601e-01,  -4.500090852951171e-03,   5.919818038616163e-05,  -5.587726437793586e-07,   2.778338089557427e-09,
   2.318204734404008e-11,  -8.014117001048761e-13,   1.102370145014486e-14,  -7.609940900530184e-17,  -4.153922361228016e-19,   2.114098302676323e-20,  -3.380325135982862e-22,
   2.742409431719258e-24,   7.919262153898425e-27,   2.278737845679920e-01,  -4.500247930215895e-03,   5.919973682237723e-05,  -5.587507283976360e-07,   2.777208769038059e-09,
   2.320372709074014e-11,  -8.016096059901275e-13,   1.102225414509680e-14,  -7.600968543618466e-17,  -4.171326609600543e-19,   2.115767257606249e-20,  -3.379679647663878e-22,
   2.736398584786429e-24,   8.039571079102061e-27,   2.278835829409930e-01,  -4.500525090481980e-03,   5.920248266160208e-05,  -5.587120418442942e-07,   2.775215839652798e-09,
   2.324197900652512e-11,  -8.019586222372269e-13,   1.101969557890329e-14,  -7.585130978755509e-17,  -4.202033906155886e-19,   2.118709122188388e-20,  -3.378533519806940e-22,
   2.725784238470571e-24,   8.251866346011633e-27,   2.278954314395199e-01,  -4.500860227043258e-03,   5.920580207819589e-05,  -5.586652334881155e-07,   2.772805583693540e-09,
   2.328822963952890e-11,  -8.023803292929085e-13,   1.101659359435318e-14,  -7.565970314364814e-17,  -4.239160747666733e-19,   2.122261282573842e-20,  -3.377135412035410e-22,
   2.712935443415196e-24,   8.508589656336060e-27,   2.279069339674567e-01,  -4.501185562813123e-03,   5.920902358714184e-05,  -5.586197632562302e-07,   2.770465346526005e-09,
   2.333312476611555e-11,  -8.027893725406545e-13,   1.101357371907222e-14,  -7.547359312113066e-17,  -4.275197842819492e-19,   2.125704236990634e-20,  -3.375765379505910e-22,
   2.700447612769400e-24,   8.757825804193951e-27,   2.279162004052969e-01,  -4.501447642625915e-03,   5.921161813130509e-05,  -5.585831119003830e-07,   2.768579793711235e-09,
   2.336928869134889e-11,  -8.031186468708040e-13,   1.101113484104340e-14,  -7.532359256873210e-17,  -4.304225257132966e-19,   2.128473949382945e-20,  -3.374652546546547e-22,
   2.690377246891833e-24,   8.958616494606496e-27,   2.279223235762315e-01,  -4.501620817137168e-03,   5.921333223593060e-05,  -5.585588829927958e-07,   2.767333712951870e-09,
   2.339318369572953e-11,  -8.033361052044736e-13,   1.100952028453297e-14,  -7.522443928707903e-17,  -4.323404284855512e-19,   2.130302221847834e-20,  -3.373912724910542e-22,
   2.683717876330577e-24,   9.091299771257664e-27,   2.279254681403371e-01,  -4.501709749557258e-03,   5.921421241048663e-05,  -5.585464370903824e-07,   2.766693747249995e-09,
   2.340545446781499e-11,  -8.034477432603494e-13,   1.100869020806657e-14,  -7.517350833200763e-17,  -4.333253084124715e-19,   2.131240538149555e-20,  -3.373531405153718e-22,
   2.680296409877860e-24,   9.159440293354904e-27,   2.279265626383083e-01,  -4.501740703144845e-03,   5.921451874735101e-05,  -5.585421046707856e-07,   2.766470994385228e-09,
   2.340972534978012e-11,  -8.034865939846343e-13,   1.100840114518169e-14,  -7.515577959586043e-17,  -4.336680961336119e-19,   2.131567033928399e-20,  -3.373398462673808e-22,
   2.679105288753087e-24,   9.183157431289936e-27,   2.279267363202354e-01,  -4.501745615045506e-03,   5.921456735803523e-05,  -5.585414171512854e-07,   2.766435646243874e-09,
   2.341040307647962e-11,  -8.034927587783018e-13,   1.100835526789638e-14,  -7.515296620649079e-17,  -4.337224914080102e-19,   2.131618839858413e-20,  -3.373377356058312e-22,
   2.678916262445480e-24,   9.186921024113661e-27,   4.361591106570945e-01,  -7.782535167195937e-03,   7.854536987161785e-05,  -2.835827717762629e-07,  -5.834927240729546e-09,
   1.201949235581354e-10,  -7.527696953379882e-13,  -1.017176202384431e-14,   2.918743153901300e-16,  -2.475767387995461e-18,  -2.060289055239181e-20,   8.337191834337908e-22,
  -8.907990935889492e-24,  -3.930101074526866e-26,   4.361664676703522e-01,  -7.782614528424233e-03,   7.854208181209006e-05,  -2.834702588567662e-07,  -5.835976784975811e-09,
   1.201747670599543e-10,  -7.520053629637866e-13,  -1.018000602014932e-14,   2.917856624717980e-16,  -2.471480505989406e-18,  -2.065699741907550e-20,   8.334141799069791e-22,
  -8.886162998438586e-24,  -3.962154903048380e-26,   4.361794489848631e-01,  -7.782754536864820e-03,   7.853627950139525e-05,  -2.832717434406309e-07,  -5.837827849211466e-09,
   1.201391874609534e-10,  -7.506568766916885e-13,  -1.019454092768944e-14,   2.916290483105153e-16,  -2.463917531714471e-18,  -2.075236007078253e-20,   8.328741028588561e-22,
  -8.847650593030618e-24,  -4.018624608706768e-26,   4.361951457008646e-01,  -7.782923792757040e-03,   7.852926247066781e-05,  -2.830317227440534e-07,  -5.840064687308086e-09,
   1.200961418362936e-10,  -7.490265973042711e-13,  -1.021209665472400e-14,   2.914393541354738e-16,  -2.454774518410632e-18,  -2.086748646030879e-20,   8.322178109559469e-22,
  -8.801086736467757e-24,  -4.086755301352301e-26,   4.362103833526074e-01,  -7.783088057573022e-03,   7.852244960596683e-05,  -2.827987423204062e-07,  -5.842234612403654e-09,
   1.200543304552725e-10,  -7.474442905777886e-13,  -1.022911846970068e-14,   2.912548731362186e-16,  -2.445900966837197e-18,  -2.097905320238025e-20,   8.315773216486984e-22,
  -8.755889468809967e-24,  -4.152735098570413e-26,   4.362226582853684e-01,  -7.783220354305990e-03,   7.851696064002343e-05,  -2.826110760405586e-07,  -5.843981559239109e-09,
   1.200206309718476e-10,  -7.461698489087883e-13,  -1.024281599193752e-14,   2.911060220194153e-16,  -2.438754221577551e-18,  -2.106878952229034e-20,   8.310589387038314e-22,
  -8.719483585654383e-24,  -4.205772713059823e-26,   4.362307691849305e-01,  -7.783307757538888e-03,   7.851333333017509e-05,  -2.824870791637047e-07,  -5.845135363923497e-09,
   1.199983547429505e-10,  -7.453278401493368e-13,  -1.025185971216196e-14,   2.910075485794616e-16,  -2.434032600482352e-18,  -2.112801694642034e-20,   8.307152203036612e-22,
  -8.695429430311119e-24,  -4.240762790202185e-26,   4.362349344712885e-01,  -7.783352638304826e-03,   7.851147044058014e-05,  -2.824234038216713e-07,  -5.845727728787255e-09,
   1.199869122953301e-10,  -7.448954653684366e-13,  -1.025650181974403e-14,   2.909569421267668e-16,  -2.431608076404416e-18,  -2.115841180589446e-20,   8.305383397586777e-22,
  -8.683077157622629e-24,  -4.258714478462277e-26,   4.362363842296031e-01,  -7.783368258674208e-03,   7.851082203008409e-05,  -2.824012415113789e-07,  -5.845933879890971e-09,
   1.199829292426523e-10,  -7.447449792595852e-13,  -1.025811718555677e-14,   2.909393224169777e-16,  -2.430764239114196e-18,  -2.116898763106473e-20,   8.304767168295920e-22,
  -8.678777945861451e-24,  -4.264959959376399e-26,   4.362366142859134e-01,  -7.783370737374093e-03,   7.851071913557000e-05,  -2.823977246805403e-07,  -5.845966591954397e-09,
   1.199822971678706e-10,  -7.447210994664475e-13,  -1.025837350466757e-14,   2.909365261425361e-16,  -2.430630335682045e-18,  -2.117066570821787e-20,   8.304669353648013e-22,
  -8.678095725390349e-24,  -4.265950899750050e-26,   6.966657462457603e-01,  -1.067844011655581e-02,   6.382340606842109e-05,   5.096719547709134e-07,  -1.271188071578090e-08,
   2.622400579141430e-11,   2.087708398524184e-12,  -2.474643310616152e-14,  -2.015821369573520e-16,   7.400620719945027e-18,  -2.812231316947759e-20,  -1.453042470643974e-21,
   2.152514654484320e-23,   1.307936594415549e-25,   6.966717153578819e-01,  -1.067829668652207e-02,   6.381627218237191e-05,   5.096961338076062e-07,  -1.270895117075467e-08,
   2.617568011534453e-11,   2.087176895314356e-12,  -2.472165022351569e-14,  -2.016965930532093e-16,   7.393166551894361e-18,  -2.799175627608097e-20,  -1.452067046912184e-21,
   2.146824280970434e-23,   1.311411870741237e-25,   6.966822474085168e-01,  -1.067804359650905e-02,   6.380368566625976e-05,   5.097387613866657e-07,  -1.270378255097125e-08,
   2.609044827028226e-11,   2.086238807791750e-12,  -2.467794086188403e-14,  -2.018981071539069e-16,   7.380017663240176e-18,  -2.776167167742251e-20,  -1.450343860525379e-21,
   2.136793972694833e-23,   1.317521591123395e-25,   6.966949819532595e-01,  -1.067773754805353e-02,   6.378846819778948e-05,   5.097902445350588e-07,  -1.269753363843841e-08,
   2.598745246137547e-11,   2.085104050785532e-12,  -2.462512185280556e-14,  -2.021410212433328e-16,   7.364124897102525e-18,  -2.748393667117611e-20,  -1.448256702909553e-21,
   2.124683021620118e-23,   1.324871298185998e-25,   6.967073434619593e-01,  -1.067744043177101e-02,   6.377369773151630e-05,   5.098401579820117e-07,  -1.269146838926324e-08,
   2.588753651613433e-11,   2.084002018181751e-12,  -2.457388252429055e-14,  -2.023760441609465e-16,   7.348703823563211e-18,  -2.721482454737260e-20,  -1.446226912411562e-21,
   2.112944558301216e-23,   1.331966310589345e-25,   6.967173010398967e-01,  -1.067720107178433e-02,   6.376180054729153e-05,   5.098803206921151e-07,  -1.268658308236111e-08,
   2.580709609681263e-11,   2.083113927432824e-12,  -2.453263089775591e-14,  -2.025648073582115e-16,   7.336286077789088e-18,  -2.699839512938226e-20,  -1.444589158317645e-21,
   2.103501554448445e-23,   1.337653388525305e-25,   6.967238804908645e-01,  -1.067704290355689e-02,   6.375393993773440e-05,   5.099068365327825e-07,  -1.268335534005445e-08,
   2.575396725144533e-11,   2.082526942505346e-12,  -2.450538533922689e-14,  -2.026892607483175e-16,   7.328083235276248e-18,  -2.685556042571922e-20,  -1.443505699022852e-21,
   2.097268320085383e-23,   1.341397341605169e-25,   6.967272592488732e-01,  -1.067696167554919e-02,   6.374990339770468e-05,   5.099204465858688e-07,  -1.268169785792438e-08,
   2.572669069988781e-11,   2.082225451202143e-12,  -2.449139739343960e-14,  -2.027530876064478e-16,   7.323871482317372e-18,  -2.678226299139855e-20,  -1.442948901692742e-21,
   2.094069276390256e-23,   1.343315726174696e-25,   6.967284352398436e-01,  -1.067693340322935e-02,   6.374849848422867e-05,   5.099251825593213e-07,  -1.268112097487510e-08,
   2.571719806448712e-11,   2.082120507001569e-12,  -2.448652938994787e-14,  -2.027752894561226e-16,   7.322405670397413e-18,  -2.675675990499350e-20,  -1.442755041393626e-21,
   2.092956141549832e-23,   1.343982751053222e-25,   6.967286218526220e-01,  -1.067692891679359e-02,   6.374827554576691e-05,   5.099259340394337e-07,  -1.268102943237195e-08,
   2.571569177181074e-11,   2.082103853451444e-12,  -2.448575693470313e-14,  -2.027788119348969e-16,   7.322173072275822e-18,  -2.675271333208167e-20,  -1.442724275497214e-21,
   2.092779517648317e-23,   1.344088566136247e-25,   9.923291597086424e-01,  -1.218409398072236e-02,   1.068874308407039e-05,   1.188494381529235e-06,  -3.896390797509597e-09,
  -2.036318137063436e-10,   1.262242922487628e-12,   4.105321653018413e-14,  -3.988704564512768e-16,  -8.848468212381597e-18,   1.237806165213608e-19,   1.926125675701392e-21,
  -3.826389383097885e-23,  -4.116790784464136e-25,   9.923301573967983e-01,  -1.218376038723468e-02,   1.068656131220274e-05,   1.188304152200693e-06,  -3.894628012068144e-09,
  -2.035514607277827e-10,   1.261206498060302e-12,   4.102360844404213e-14,  -3.983557047768144e-16,  -8.838651874860980e-18,   1.235483208030390e-19,   1.923157615292559e-21,
  -3.816722328115668e-23,  -4.109102489275515e-25,   9.923319176681622e-01,  -1.218317179964883e-02,   1.068271234463018e-05,   1.187968550652343e-06,  -3.891518730142882e-09,
  -2.034097238959512e-10,   1.259378804869832e-12,   4.097139135981041e-14,  -3.974482101657665e-16,  -8.821343191565639e-18,   1.231389147406313e-19,   1.917924981982742e-21,
  -3.799690957282891e-23,  -4.095547276838042e-25,   9.923340459256652e-01,  -1.218246014719309e-02,   1.067805950108986e-05,   1.187562841820880e-06,  -3.887760965585829e-09,
  -2.032384147623569e-10,   1.257170602969681e-12,   4.090829566110986e-14,  -3.963522086726071e-16,  -8.800434474525468e-18,   1.226446798684233e-19,   1.911605389754001e-21,
  -3.779141220474988e-23,  -4.079174759530749e-25,   9.923361117065430e-01,  -1.218176936472671e-02,   1.067354403443609e-05,   1.187169095739943e-06,  -3.884115099044106e-09,
  -2.030721951427512e-10,   1.255028869523582e-12,   4.084709133611576e-14,  -3.952896423781712e-16,  -8.780158762055399e-18,   1.221657462246213e-19,   1.905478563605906e-21,
  -3.759238701380488e-23,  -4.063300065495366e-25,   9.923377756616645e-01,  -1.218121293481676e-02,   1.066990745985410e-05,   1.186851977114893e-06,  -3.881179544718979e-09,
  -2.029383511687411e-10,   1.253304913568257e-12,   4.079782021788184e-14,  -3.944346641710126e-16,  -8.763840740404910e-18,   1.217805396137715e-19,   1.900548689390586e-21,
  -3.743238971920762e-23,  -4.050525559362626e-25,   9.923388750702267e-01,  -1.218084528299668e-02,   1.066750497868629e-05,   1.186642469006261e-06,  -3.879240520933448e-09,
  -2.028499390129135e-10,   1.252166437605638e-12,   4.076527952157037e-14,  -3.938702045919948e-16,  -8.753065827779135e-18,   1.215263032819834e-19,   1.897293963002503e-21,
  -3.732683005623867e-23,  -4.042091217606491e-25,   9.923394396371726e-01,  -1.218065648459183e-02,   1.066627134503652e-05,   1.186534888388817e-06,  -3.878244967675319e-09,
  -2.028045442792993e-10,   1.251581986990001e-12,   4.074857350484653e-14,  -3.935804805206729e-16,  -8.747534788908330e-18,   1.213958338817705e-19,   1.895623385285342e-21,
  -3.727267069423071e-23,  -4.037761889706233e-25,   9.923396361347812e-01,  -1.218059077291469e-02,   1.066584199228232e-05,   1.186497445851461e-06,  -3.877898492576220e-09,
  -2.027887456812551e-10,   1.251378597226772e-12,   4.074275964848924e-14,  -3.934796637434783e-16,  -8.745610041267348e-18,   1.213504376310148e-19,   1.895042065481403e-21,
  -3.725382807962054e-23,  -4.036255363395021e-25,   9.923396673160040e-01,  -1.218058034543998e-02,   1.066577386108757e-05,   1.186491504325779e-06,  -3.877843513474286e-09,
  -2.027862387303828e-10,   1.251346323668644e-12,   4.074183710875307e-14,  -3.934636666647068e-16,  -8.745304628414558e-18,   1.213432345745991e-19,   1.894949824683516e-21,
  -3.725083839812979e-23,  -4.036016314363882e-25,   1.299434556929518e+00,  -1.152319422893166e-02,  -5.722405017359178e-05,   9.136070752458375e-07,   1.364048851932348e-08,
  -9.973701217487618e-11,  -3.447790788300740e-12,   3.647354296827655e-15,   8.624183347191107e-16,   4.016842804055092e-18,  -2.056612092377491e-19,  -2.315520920116971e-21,
   4.365232682519164e-23,   9.198501590852174e-25,   1.299429207532693e+00,  -1.152293760656110e-02,  -5.721640461742690e-05,   9.135136343280799e-07,   1.363566660801058e-08,
  -9.972962132914005e-11,  -3.445544660403044e-12,   3.660607511368562e-15,   8.615592817713627e-16,   4.005157645337087e-18,  -2.053939616957890e-19,  -2.308961277000146e-21,
   4.359077174228729e-23,   9.168141780123847e-25,   1.299419769017197e+00,  -1.152248481369932e-02,  -5.720291611197973e-05,   9.133487620539499e-07,   1.362716083052035e-08,
  -9.971655900140015e-11,  -3.441583160470623e-12,   3.683961140862481e-15,   8.600443834234931e-16,   3.984566326792855e-18,  -2.049227085866157e-19,  -2.297404601496976e-21,
   4.348218015974585e-23,   9.114668700730540e-25,   1.299408356851146e+00,  -1.152193732813241e-02,  -5.718660941521175e-05,   9.131494064602358e-07,   1.361687991858063e-08,
  -9.970072801375527e-11,  -3.436795988117611e-12,   3.712146298983528e-15,   8.582141100330639e-16,   3.959713629408181e-18,  -2.043533917330286e-19,  -2.283460658192065e-21,
   4.335091017172511e-23,   9.050174131287991e-25,   1.299397279152087e+00,  -1.152140587673695e-02,  -5.717078308024993e-05,   9.129558856951240e-07,   1.360690395648085e-08,
  -9.968532203471397e-11,  -3.432151945084203e-12,   3.739451165195914e-15,   8.564389427751927e-16,   3.935635737144179e-18,  -2.038012610118939e-19,  -2.269956021190289e-21,
   4.322351797273335e-23,   8.987737095217069e-25,   1.299388355842680e+00,  -1.152097777371300e-02,  -5.715803640142240e-05,   9.127999951974157e-07,   1.359887072371081e-08,
  -9.967288431927878e-11,  -3.428413099720533e-12,   3.761406961122709e-15,   8.550100586881585e-16,   3.916273730552837e-18,  -2.033568672756214e-19,  -2.259099683357566e-21,
   4.312092317666665e-23,   8.937562505675821e-25,   1.299382459841506e+00,  -1.152069490423196e-02,  -5.714961499907975e-05,   9.126969891186930e-07,   1.359356410841912e-08,
  -9.966465256017848e-11,  -3.425943680255325e-12,   3.775895075538747e-15,   8.540664489479349e-16,   3.903496696805465e-18,  -2.030634134733554e-19,  -2.251937168752526e-21,
   4.305314551658964e-23,   8.904468600467635e-25,   1.299379432074955e+00,  -1.152054964135361e-02,  -5.714529063149167e-05,   9.126440916781673e-07,   1.359083940282055e-08,
  -9.966042109754611e-11,  -3.424675868566077e-12,   3.783329270032675e-15,   8.535820368538362e-16,   3.896940342986584e-18,  -2.029127707899019e-19,  -2.248262323092918e-21,
   4.301834315711415e-23,   8.887492010808332e-25,   1.299378378250936e+00,  -1.152049908193681e-02,  -5.714378556348026e-05,   9.126256804162905e-07,   1.358989112292206e-08,
  -9.965894765203466e-11,  -3.424234651344146e-12,   3.785915831487390e-15,   8.534134609074983e-16,   3.894659181741877e-18,  -2.028603477576140e-19,  -2.246983808112041e-21,
   4.300623062962808e-23,   8.881586131062975e-25,   1.299378211024426e+00,  -1.152049105888494e-02,  -5.714354673313020e-05,   9.126227588109857e-07,   1.358974064770456e-08,
  -9.965871380585261e-11,  -3.424164638917605e-12,   3.786326236744849e-15,   8.533867115612874e-16,   3.894297232632335e-18,  -2.028520293969341e-19,  -2.246780951435899e-21,
   4.300430857409943e-23,   8.880649090616554e-25,   1.587367909423075e+00,  -8.603620376332732e-03,  -9.481904340778744e-05,  -2.228341120285343e-07,   1.205844055818213e-08,
   2.019193811102182e-10,   1.794356375598905e-13,  -4.446283432503950e-14,  -6.845793484599693e-16,   1.440906891473051e-18,   2.041424122529228e-19,   2.661471955231176e-21,
  -1.738998325440912e-23,  -1.036855448537243e-24,   1.587359033774007e+00,  -8.603682384281964e-03,  -9.481225925399861e-05,  -2.226455481737009e-07,   1.205867187456211e-08,
   2.018319287606923e-10,   1.776563213133515e-13,  -4.445762229417359e-14,  -6.837217377751202e-16,   1.454338504620533e-18,   2.040306709247646e-19,   2.653966292778074e-21,
  -1.747995557276317e-23,  -1.035478276870043e-24,   1.587343373068592e+00,  -8.603791755296882e-03,  -9.480028840688847e-05,  -2.223128909096805e-07,   1.205907800865276e-08,
   2.016776262256550e-10,   1.745185178110346e-13,  -4.444838894288347e-14,  -6.822088570866896e-16,   1.478007412071970e-18,   2.038330535667697e-19,   2.640730676903877e-21,
  -1.763829878916220e-23,  -1.033044039999516e-24,   1.587324436857798e+00,  -8.603923934610735e-03,  -9.478581295903698e-05,  -2.219107517870762e-07,   1.205956565504763e-08,
   2.014910565043753e-10,   1.707273686236590e-13,  -4.443716145905780e-14,  -6.803801262622637e-16,   1.506574617147732e-18,   2.035933300474060e-19,   2.624740101701967e-21,
  -1.782906317313108e-23,  -1.030093404598885e-24,   1.587306054835269e+00,  -8.604052175269567e-03,  -9.477176026591586e-05,  -2.215204810379807e-07,   1.206003543720808e-08,
   2.013099531389404e-10,   1.670502492842435e-13,  -4.442619672496689e-14,  -6.786055192114969e-16,   1.534251180734283e-18,   2.033598139394495e-19,   2.609231486645965e-21,
  -1.801351544304523e-23,  -1.027221542804050e-24,   1.587291247178382e+00,  -8.604155429308497e-03,  -9.476043947145712e-05,  -2.212061692209387e-07,   1.206041129766996e-08,
   2.011640696143447e-10,   1.640903469392118e-13,  -4.441731695269294e-14,  -6.771764164468846e-16,   1.556506969079647e-18,   2.031711268713306e-19,   2.596748537616412e-21,
  -1.816157919232075e-23,  -1.024902701964102e-24,   1.587281462866346e+00,  -8.604223630827966e-03,  -9.475295882988879e-05,  -2.209985192973241e-07,   1.206065839198426e-08,
   2.010676777762837e-10,   1.621356403339981e-13,  -4.441142650087867e-14,  -6.762323348135855e-16,   1.571193576402589e-18,   2.030461674779830e-19,   2.588505218301949e-21,
  -1.825915847580508e-23,  -1.023367863821734e-24,   1.587276438254105e+00,  -8.604258647250160e-03,  -9.474911714330134e-05,  -2.208918940296047e-07,   1.206078489483645e-08,
   2.010181776271602e-10,   1.611321587532068e-13,  -4.440839440799704e-14,  -6.757475792666419e-16,   1.578729785816454e-18,   2.029819088811286e-19,   2.584273486074807e-21,
  -1.830919017639990e-23,  -1.022578852044543e-24,   1.587274689407745e+00,  -8.604270833711871e-03,  -9.474778000605011e-05,  -2.208547841829920e-07,   1.206082886293127e-08,
   2.010009489133927e-10,   1.607829441193568e-13,  -4.440733793610488e-14,  -6.755788676932043e-16,   1.581351866938491e-18,   2.029595294113887e-19,   2.582800848819209e-21,
  -1.832659144696402e-23,  -1.022304102240447e-24,   1.587274411890670e+00,  -8.604272767472625e-03,  -9.474756782063885e-05,  -2.208488954589418e-07,   1.206083583710113e-08,
   2.009982149664502e-10,   1.607275312400428e-13,  -4.440717023520441e-14,  -6.755520960614697e-16,   1.581767909264774e-18,   2.029559774486790e-19,   2.582567173718943e-21,
  -1.832935218512206e-23,  -1.022260497203278e-24,   1.820619985070274e+00,  -4.424522431638713e-03,  -7.251100164599286e-05,  -8.565373005371618e-07,  -5.647638272917165e-09,
   3.998315235296185e-11,   1.966506044004714e-12,   3.329495474038477e-14,   2.722417344815836e-16,  -2.010845999328585e-18,  -1.138981783245983e-19,  -2.089541698042111e-21,
  -1.827800882324622e-23,   1.343439238855303e-25,   1.820613180831794e+00,  -4.424763198192377e-03,  -7.251416277513533e-05,  -8.564992663460420e-07,  -5.644864561980759e-09,
   4.004858864291328e-11,   1.967210670061521e-12,   3.328788854866162e-14,   2.717577118831334e-16,  -2.021578262384132e-18,  -1.140080242519877e-19,  -2.088477244003915e-21,
  -1.820803325342319e-23,   1.358330880863967e-25,   1.820601174406704e+00,  -4.425188025777981e-03,  -7.251973936690894e-05,  -8.564321045765820e-07,  -5.639969503677397e-09,
   4.016404055984710e-11,   1.968452958749177e-12,   3.327539072501484e-14,   2.709032724862013e-16,  -2.040510963420147e-18,  -1.142014960438622e-19,  -2.086590162810448e-21,
  -1.808446337682512e-23,   1.384594175345399e-25,   1.820586655701327e+00,  -4.425701716844970e-03,  -7.252648047500069e-05,  -8.563508068705343e-07,  -5.634048980685866e-09,
   4.030362670257933e-11,   1.969953382071857e-12,   3.326022807301478e-14,   2.698694385255269e-16,  -2.063396811221486e-18,  -1.144348418479710e-19,  -2.084293224614695e-21,
  -1.793487656646518e-23,   1.416329354897300e-25,   1.820572560766428e+00,  -4.426200383534991e-03,  -7.253302235723906e-05,  -8.562717954855777e-07,  -5.628300009825096e-09,
   4.043911400131965e-11,   1.971408117625276e-12,   3.324545592726304e-14,   2.688651447136001e-16,  -2.085605820230741e-18,  -1.146607387141724e-19,  -2.082047633655534e-21,
  -1.778948821641742e-23,   1.447113446212616e-25,   1.820561205764255e+00,  -4.426602091675507e-03,  -7.253829078668007e-05,  -8.562080811935042e-07,  -5.623667690070082e-09,
   4.054824608123612e-11,   1.972578708066672e-12,   3.323351806643692e-14,   2.680556224562076e-16,  -2.103491228301889e-18,  -1.148422657413813e-19,  -2.080227325508887e-21,
  -1.767224232749464e-23,   1.471895517973709e-25,   1.820553702431340e+00,  -4.426867527742595e-03,  -7.254177127486829e-05,  -8.561659487138775e-07,  -5.620606234814209e-09,
   4.062035139360160e-11,   1.973351564130155e-12,   3.322561132783930e-14,   2.675204717002878e-16,  -2.115306698764966e-18,  -1.149619938667221e-19,  -2.079018972788681e-21,
  -1.759470829021577e-23,   1.488262616455302e-25,   1.820549849064556e+00,  -4.427003840157224e-03,  -7.254355842585754e-05,  -8.561443020179716e-07,  -5.619033876215035e-09,
   4.065737868567458e-11,   1.973748261871039e-12,   3.322154514558320e-14,   2.672455742285081e-16,  -2.121373612920110e-18,  -1.150234113994752e-19,  -2.078396717457908e-21,
  -1.755487231435527e-23,   1.496665282919424e-25,   1.820548507857587e+00,  -4.427051284669720e-03,  -7.254418042092361e-05,  -8.561367661507129e-07,  -5.618486577760225e-09,
   4.067026601757980e-11,   1.973886304176857e-12,   3.322012896723335e-14,   2.671498821968051e-16,  -2.123485115247219e-18,  -1.150447774125645e-19,  -2.078179863851538e-21,
  -1.754100408964678e-23,   1.499589489874185e-25,   1.820548295026163e+00,  -4.427058813447535e-03,  -7.254427912111326e-05,  -8.561355702394220e-07,  -5.618399727863096e-09,
   4.067231104275201e-11,   1.973908208071571e-12,   3.321990419620562e-14,   2.671346966458510e-16,  -2.123820174808294e-18,  -1.150481673860527e-19,  -2.078145439261653e-21,
  -1.753880325346239e-23,   1.500053501384906e-25,   1.964615896265547e+00,  -9.603810242131463e-04,  -1.914083246350111e-05,  -3.293639248077045e-07,  -5.109185688192029e-09,
  -7.211079116261990e-11,  -9.152878841294991e-13,  -1.001464582157137e-14,  -8.222826813923020e-17,  -1.457720493494298e-19,   1.317488900634712e-20,   3.841528711774385e-22,
   7.513868169405713e-24,   1.191020773935457e-25,   1.964614096032016e+00,  -9.604738963784976e-04,  -1.914371365587099e-05,  -3.294316943760965e-07,  -5.110475346011015e-09,
  -7.213051432732063e-11,  -9.155025490162837e-13,  -1.001508513737321e-14,  -8.217116889126375e-17,  -1.437570114477791e-19,   1.322199815336089e-20,   3.850319451685639e-22,
   7.527182521240043e-24,   1.192499737207897e-25,   1.964610919271112e+00,  -9.606377863026299e-04,  -1.914879815558702e-05,  -3.295512898823518e-07,  -5.112751212511147e-09,
  -7.216531683939391e-11,  -9.158812058119699e-13,  -1.001585476277231e-14,  -8.207025424780961e-17,  -1.401977518677214e-19,   1.330519000004164e-20,   3.865839611027707e-22,
   7.550679287113813e-24,   1.195107001775229e-25,   1.964607077521848e+00,  -9.608359902277516e-04,  -1.915494739381849e-05,  -3.296959316855157e-07,  -5.115503632231628e-09,
  -7.220740155823750e-11,  -9.163388720775859e-13,  -1.001677592462796e-14,  -8.194795059346885e-17,  -1.358875569144538e-19,   1.340590074861058e-20,   3.884621681058111e-22,
   7.579097550554852e-24,   1.198255648311021e-25,   1.964603347624344e+00,  -9.610284308976446e-04,  -1.916091802231146e-05,  -3.298363742938230e-07,  -5.118176070868712e-09,
  -7.224825787064330e-11,  -9.167829467953132e-13,  -1.001766023909696e-14,  -8.182893048032723e-17,  -1.316966935107395e-19,   1.350378868602266e-20,   3.902870608939497e-22,
   7.606691445067632e-24,   1.201308006713782e-25,   1.964600342585220e+00,  -9.611834784695475e-04,  -1.916572863856863e-05,  -3.299495322706380e-07,  -5.120329265858887e-09,
  -7.228117203592307e-11,  -9.171405299341792e-13,  -1.001836550774510e-14,  -8.173284161200174e-17,  -1.283158567786736e-19,   1.358273170018342e-20,   3.917582890315279e-22,
   7.628924940829452e-24,   1.203763860542808e-25,   1.964598356770715e+00,  -9.612859408731554e-04,  -1.916890777807799e-05,  -3.300243144654318e-07,  -5.121752212055923e-09,
  -7.230292154460700e-11,  -9.173767372121771e-13,  -1.001882804627852e-14,  -8.166924599158185e-17,  -1.260795424291142e-19,   1.363493783440768e-20,   3.927309975370170e-22,
   7.643618485422945e-24,   1.205385129625699e-25,   1.964597336917213e+00,  -9.613385632293825e-04,  -1.917054053275944e-05,  -3.300627216137655e-07,  -5.122483010417175e-09,
  -7.231409108574089e-11,  -9.174980170304542e-13,  -1.001906450196199e-14,  -8.163655510029747e-17,  -1.249303710537274e-19,   1.366176117106096e-20,   3.932306990350539e-22,
   7.651164953123492e-24,   1.206217259336224e-25,   1.964596981941057e+00,  -9.613568794014737e-04,  -1.917110884619612e-05,  -3.300760900372385e-07,  -5.122737379025305e-09,
  -7.231797876711568e-11,  -9.175402257719448e-13,  -1.001914663054496e-14,  -8.162517172071974e-17,  -1.245302772755527e-19,   1.367109934692808e-20,   3.934046516377600e-22,
   7.653791670222892e-24,   1.206506814871655e-25,   1.964596925610907e+00,  -9.613597859484750e-04,  -1.917119903057643e-05,  -3.300782114439476e-07,  -5.122777744178413e-09,
  -7.231859568957046e-11,  -9.175469235370088e-13,  -1.001915965505441e-14,  -8.162336509703152e-17,  -1.244667824833770e-19,   1.367258128500239e-20,   3.934322567979451e-22,
   7.654208498787525e-24,   1.206552759793233e-25,   8.559804065904252e-03,  -1.777540924183914e-04,   2.757638170439764e-06,  -3.785852436757224e-08,   4.840837616851554e-10,
  -5.900347022013144e-12,   6.923725850638466e-14,  -7.879822792760531e-16,   8.698487458254325e-18,  -9.361703056487555e-20,   9.721356641608301e-22,  -9.911138569102071e-24,
   9.395825208989844e-26,  -8.969178590892261e-28,   8.560063141715670e-03,  -1.777647596404711e-04,   2.757911018290741e-06,  -3.786406902280331e-08,   4.841813975558463e-10,
  -5.901903409106500e-12,   6.926017713831844e-14,  -7.882995759943171e-16,   8.702607462521770e-18,  -9.366839043168759e-20,   9.727203197285031e-22,  -9.917707587094618e-24,
   9.402911535705496e-26,  -8.971050714459281e-28,   8.560520305929601e-03,  -1.777835833920338e-04,   2.758392507337690e-06,  -3.787385384215503e-08,   4.843537038243567e-10,
  -5.904650187185055e-12,   6.930062622959212e-14,  -7.888595921675150e-16,   8.709879283160087e-18,  -9.375904327424391e-20,   9.737523112111971e-22,  -9.929299833911278e-24,
   9.415424942038668e-26,  -8.974352615301529e-28,   8.561073149367441e-03,  -1.778063474398555e-04,   2.758974805299996e-06,  -3.788568777611574e-08,   4.845621031513429e-10,
  -5.907972487891231e-12,   6.934955271859222e-14,  -7.895370103846315e-16,   8.718675871522394e-18,  -9.386870863758939e-20,   9.750008162916559e-22,  -9.943319196808989e-24,
   9.430572407288259e-26,  -8.978342848219169e-28,   8.561609877475293e-03,  -1.778284486522134e-04,   2.759540169953881e-06,  -3.789717807615502e-08,   4.847644604770938e-10,
  -5.911198628339740e-12,   6.939706543519746e-14,  -7.901948883644587e-16,   8.727219035095070e-18,  -9.397521907252500e-20,   9.762134825630866e-22,  -9.956930934533621e-24,
   9.445294148882537e-26,  -8.982214023168360e-28,   8.562042285363830e-03,  -1.778462547272191e-04,   2.759995677602092e-06,  -3.790643603294271e-08,   4.849275104931205e-10,
  -5.913798216159396e-12,   6.943535233353284e-14,  -7.907250469857500e-16,   8.734103868018788e-18,  -9.406105774725424e-20,   9.771908489822652e-22,  -9.967897793709941e-24,
   9.457165835566065e-26,  -8.985330891035797e-28,   8.562328025869771e-03,  -1.778580214604578e-04,   2.760296696968454e-06,  -3.791255427043955e-08,   4.850352674861917e-10,
  -5.915516296298287e-12,   6.946065715390305e-14,  -7.910754548409957e-16,   8.738654502322916e-18,  -9.411779567655788e-20,   9.778368997854627e-22,  -9.975145194112034e-24,
   9.465016320792548e-26,  -8.987389658409965e-28,   8.562474771335895e-03,  -1.778640644872027e-04,   2.760451293484580e-06,  -3.791569650842884e-08,   4.850906109450748e-10,
  -5.916398711266061e-12,   6.947365409729563e-14,  -7.912554334091849e-16,   8.740991860311079e-18,  -9.414693865680946e-20,   9.781687472342364e-22,  -9.978867295961094e-24,
   9.469049738703497e-26,  -8.988446691709189e-28,   8.562525848083083e-03,  -1.778661678571998e-04,   2.760505103597824e-06,  -3.791679022980071e-08,   4.851098745526574e-10,
  -5.916705859576315e-12,   6.947817807429714e-14,  -7.913180809554358e-16,   8.741805461183748e-18,  -9.415708298792661e-20,   9.782842608363373e-22,  -9.980162841815380e-24,
   9.470453895992092e-26,  -8.988814563812664e-28,   8.562533953289986e-03,  -1.778665016349111e-04,   2.760513642587227e-06,  -3.791696379006003e-08,   4.851129314603273e-10,
  -5.916754600528377e-12,   6.947889598004714e-14,  -7.913280224650965e-16,   8.741934571381551e-18,  -9.415869279391550e-20,   9.783025917791428e-22,  -9.980368428724352e-24,
   9.470676730142934e-26,  -8.988872938255439e-28,   7.666238091599235e-02,  -1.553033416889773e-03,   2.282423203249558e-05,  -2.842694721722254e-07,   3.091544078629450e-09,
  -2.889653078340184e-11,   2.121352562456476e-13,  -7.665016224627005e-16,  -1.095396188328950e-17,   3.164441058592820e-19,  -5.077117739435230e-21,   6.068053533718585e-23,
  -5.937017549964764e-25,   3.384758241220961e-27,   7.666452417788967e-02,  -1.553113462990357e-03,   2.282597270437088e-05,  -2.842965751433112e-07,   3.091842047246033e-09,
  -2.889802269408292e-11,   2.121060569946053e-13,  -7.654254408216725e-16,  -1.097549880889601e-17,   3.167579435055291e-19,  -5.080784870903720e-21,   6.070509099081106e-23,
  -5.935663439898420e-25,   3.381243997410912e-27,   7.666830613015486e-02,  -1.553254711795700e-03,   2.282904428350862e-05,  -2.843443998947237e-07,   3.092367784007061e-09,
  -2.890065346741726e-11,   2.120544884218215e-13,  -7.635256395210025e-16,  -1.101351362556211e-17,   3.173118177150313e-19,  -5.087254882006114e-21,   6.074839869669410e-23,
  -5.933256920724454e-25,   3.375025370723477e-27,   7.667287953390708e-02,  -1.553425521934739e-03,   2.283275870209380e-05,  -2.844022320253222e-07,   3.093003453273353e-09,
  -2.890383168181468e-11,   2.119920526407969e-13,  -7.612269097451907e-16,  -1.105950298374496e-17,   3.179817434557133e-19,  -5.095077288985076e-21,   6.080073073412058e-23,
  -5.930317666189473e-25,   3.367475485013003e-27,   7.667731955247477e-02,  -1.553591352534689e-03,   2.283636483858105e-05,  -2.844583764767778e-07,   3.093620490003945e-09,
  -2.890691395233609e-11,   2.119313588250647e-13,  -7.589938033212931e-16,  -1.110417110171395e-17,   3.186322790834341e-19,  -5.102669882553195e-21,   6.085149587017475e-23,
  -5.927433656616266e-25,   3.360114380670355e-27,   7.668089654377547e-02,  -1.553724951443928e-03,   2.283927006949787e-05,  -2.845036071633681e-07,   3.094117523755114e-09,
  -2.890939477814208e-11,   2.118824057349782e-13,  -7.571937387145657e-16,  -1.114017123701315e-17,   3.191564734149418e-19,  -5.108785466430891e-21,   6.089236438262048e-23,
  -5.925088398569120e-25,   3.354161495796395e-27,   7.668326023918533e-02,  -1.553813235108185e-03,   2.284118987965115e-05,  -2.845334955032973e-07,   3.094445933729343e-09,
  -2.891103298061393e-11,   2.118500295391461e-13,  -7.560037479061195e-16,  -1.116396735785876e-17,   3.195029159517557e-19,  -5.112826087235176e-21,   6.091935621287403e-23,
  -5.923527956867867e-25,   3.350216700659645e-27,   7.668447413563273e-02,  -1.553858574195488e-03,   2.284217582040908e-05,  -2.845488448148373e-07,   3.094614581444765e-09,
  -2.891187394095918e-11,   2.118333938849509e-13,  -7.553924636153829e-16,  -1.117619023910844e-17,   3.196808506395571e-19,  -5.114901000326040e-21,   6.093321367346672e-23,
  -5.922723275777680e-25,   3.348187377740792e-27,   7.668489664750817e-02,  -1.553874355071307e-03,   2.284251899031926e-05,  -2.845541873181236e-07,   3.094673279788275e-09,
  -2.891216659156820e-11,   2.118276022716090e-13,  -7.551796739206617e-16,  -1.118044491243995e-17,   3.197427855997887e-19,  -5.115623170654569e-21,   6.093803623060473e-23,
  -5.922442670747879e-25,   3.347480498341039e-27,   7.668496369451853e-02,  -1.553876859288043e-03,   2.284257344685719e-05,  -2.845550351014708e-07,   3.094682594357688e-09,
  -2.891221302865702e-11,   2.118266831548467e-13,  -7.551459058639131e-16,  -1.118112008890071e-17,   3.197526139751283e-19,  -5.115737768086305e-21,   6.093880147271362e-23,
  -5.922398117510588e-25,   3.347368299955917e-27,   2.107736777754080e-01,  -4.052541841188266e-03,   5.277181865551183e-05,  -5.115552778044165e-07,   3.073180258488577e-09,
   7.368295110380090e-12,  -5.280820926292005e-13,   8.485711150177168e-15,  -7.906070882607107e-17,   1.717679093753359e-19,   9.163842434497089e-21,  -2.089129596997625e-22,
   2.450289661091076e-24,  -1.409961079524590e-26,   2.107786285853465e-01,  -4.052685690970703e-03,   5.277354310909499e-05,  -5.115482294977509e-07,   3.072435201064950e-09,
   7.385010030795464e-12,  -5.282888166483316e-13,   8.486262669753758e-15,  -7.902156370549092e-17,   1.706868566814737e-19,   9.178943287816927e-21,  -2.090124108819224e-22,
   2.448995578665405e-24,  -1.403353685496427e-26,   2.107873644984335e-01,  -4.052939514542556e-03,   5.277658559331615e-05,  -5.115357799069492e-07,   3.071120299474644e-09,
   7.414504640129788e-12,  -5.286535006025824e-13,   8.487232865634867e-15,  -7.895243978279007e-17,   1.687789090107358e-19,   9.205582419460603e-21,  -2.091875002306020e-22,
   2.446707436063943e-24,  -1.391687293139653e-26,   2.107979282813388e-01,  -4.053246437932531e-03,   5.278026401580243e-05,  -5.115207040007355e-07,   3.069529904011301e-09,
   7.450171315861449e-12,  -5.290943373245267e-13,   8.488400973546100e-15,  -7.886876618861338e-17,   1.664710949178246e-19,   9.237783537723727e-21,  -2.093985483301827e-22,
   2.443932546331036e-24,  -1.377567346786715e-26,   2.108081836529089e-01,  -4.053544390927631e-03,   5.278383435518135e-05,  -5.115060458180273e-07,   3.067985554307974e-09,
   7.484797451900422e-12,  -5.295221441261209e-13,   8.489529649248804e-15,  -7.878744496068700e-17,   1.642299738131054e-19,   9.269032072070430e-21,  -2.096027262701579e-22,
   2.441230301175639e-24,  -1.363846572055695e-26,   2.108164454145156e-01,  -4.053784415892551e-03,   5.278671013738629e-05,  -5.114942210731484e-07,   3.066741144456949e-09,
   7.512692920596951e-12,  -5.298666722820341e-13,   8.490435095272615e-15,  -7.872186748171021e-17,   1.624240300953460e-19,   9.294197048714650e-21,  -2.097667047477695e-22,
   2.439047362161227e-24,  -1.352783746141970e-26,   2.108219047214810e-01,  -4.053943019087900e-03,   5.278861018915736e-05,  -5.114863995095858e-07,   3.065918712843567e-09,
   7.531126288642012e-12,  -5.300942777170236e-13,   8.491031536797181e-15,  -7.867850266605891e-17,   1.612304376728194e-19,   9.310821480451417e-21,  -2.098748116217079e-22,
   2.437601952825730e-24,  -1.345468966940115e-26,   2.108247083622067e-01,  -4.054024469100275e-03,   5.278958589050598e-05,  -5.114823802936600e-07,   3.065496309169545e-09,
   7.540592871659796e-12,  -5.302111477153581e-13,   8.491337262443630e-15,  -7.865622274389727e-17,   1.606173914651317e-19,   9.319357641075033e-21,  -2.099302532072651e-22,
   2.436858749459839e-24,  -1.341711039403101e-26,   2.108256841990768e-01,  -4.054052818472447e-03,   5.278992548176389e-05,  -5.114809809757125e-07,   3.065349280429306e-09,
   7.543887829059613e-12,  -5.302518227957370e-13,   8.491443581410629e-15,  -7.864846641875756e-17,   1.604040024876664e-19,   9.322328525978456e-21,  -2.099495379831224e-22,
   2.436599924772521e-24,  -1.340402829579877e-26,   2.108258390511405e-01,  -4.054057317124977e-03,   5.278997936971961e-05,  -5.114807589045672e-07,   3.065325948647869e-09,
   7.544410694677069e-12,  -5.302582772477069e-13,   8.491460448415695e-15,  -7.864723552110016e-17,   1.603701399963191e-19,   9.322799954811352e-21,  -2.099525976333936e-22,
   2.436558845929719e-24,  -1.340195223844762e-26,   4.062621353417533e-01,  -7.169195370097086e-03,   7.465815127810257e-05,  -3.587709759071460e-07,  -3.629673373362062e-09,
   9.967975088977693e-11,  -9.209743224901833e-13,  -2.352812156734486e-15,   1.955834907772507e-16,  -2.694660573001010e-18,   6.511874861998727e-21,   4.053802374397578e-22,
  -8.162353481154796e-24,   5.146222851497768e-26,   4.062691304163695e-01,  -7.169295945227137e-03,   7.465610231796924e-05,  -3.586775666196274e-07,  -3.630962412395923e-09,
   9.967497513753293e-11,  -9.204603876508538e-13,  -2.361851706653253e-15,   1.956093509819533e-16,  -2.692556225148747e-18,   6.461697514684799e-21,   4.057447237910344e-22,
  -8.155326853158044e-24,   5.124764941091186e-26,   4.062814731787248e-01,  -7.169473390277365e-03,   7.465248630746213e-05,  -3.585127481440831e-07,  -3.633236354303452e-09,
   9.966653380581333e-11,  -9.195534873157137e-13,  -2.377796350506768e-15,   1.956548099081100e-16,  -2.688841554371608e-18,   6.373194389925619e-21,   4.063865917120803e-22,
  -8.142905786817699e-24,   5.086914720747273e-26,   4.062963979113711e-01,  -7.169687922326869e-03,   7.464811278631460e-05,  -3.583134541676702e-07,  -3.635985026955840e-09,
   9.965630183926021e-11,  -9.184567615313738e-13,  -2.397066918865599e-15,   1.957094864577532e-16,  -2.684347153719312e-18,   6.266236233567808e-21,   4.071605735341833e-22,
  -8.127847843197713e-24,   5.041167346895107e-26,   4.063108863033473e-01,  -7.169896148208819e-03,   7.464386599800453e-05,  -3.581199896165534e-07,  -3.638652341242025e-09,
   9.964634305156947e-11,  -9.173919828835148e-13,  -2.415764118544868e-15,   1.957622589227732e-16,  -2.679981369167118e-18,   6.162466840430826e-21,   4.079096681375503e-22,
  -8.113189861967806e-24,   4.996779162431966e-26,   4.063225577627735e-01,  -7.170063864960495e-03,   7.464044408863764e-05,  -3.579641418195213e-07,  -3.640800342911472e-09,
   9.963830192210728e-11,  -9.165341423208350e-13,  -2.430818932277703e-15,   1.958045521443820e-16,  -2.676462419943522e-18,   6.078917300863417e-21,   4.085115004811471e-22,
  -8.101352981273104e-24,   4.961036822086140e-26,   4.063302699569479e-01,  -7.170174675830307e-03,   7.463818258378770e-05,  -3.578611626899376e-07,  -3.642219335919496e-09,
   9.963297945099668e-11,  -9.159672629973327e-13,  -2.440763257223678e-15,   1.958323912653032e-16,  -2.674136217349124e-18,   6.023731674003741e-21,   4.089083833901503e-22,
  -8.093517397930913e-24,   4.937426866041812e-26,   4.063342305072706e-01,  -7.170231578378716e-03,   7.463702107901429e-05,  -3.578082786970827e-07,  -3.642947942843748e-09,
   9.963024331343260e-11,  -9.156761329807013e-13,  -2.445869021759983e-15,   1.958466547512795e-16,  -2.672941309466931e-18,   5.995398153764641e-21,   4.091119552581149e-22,
  -8.089489130863240e-24,   4.925304483749888e-26,   4.063356090082400e-01,  -7.170251383173439e-03,   7.463661678852151e-05,  -3.577898720533604e-07,  -3.643201523025708e-09,
   9.962929053093534e-11,  -9.155748008647519e-13,  -2.447645951198061e-15,   1.958516139977708e-16,  -2.672525364446657e-18,   5.985537517911222e-21,   4.091827710720916e-22,
  -8.088086368246695e-24,   4.921085569414659e-26,   4.063358277571290e-01,  -7.170254525890351e-03,   7.463655263232812e-05,  -3.577869511779289e-07,  -3.643241761847504e-09,
   9.962913931636157e-11,  -9.155587207753395e-13,  -2.447927916945347e-15,   1.958524007107470e-16,  -2.672459357498691e-18,   5.983972823288869e-21,   4.091940067037498e-22,
  -8.087863736514665e-24,   4.920416104419791e-26,   6.550070873389237e-01,  -1.014678991039667e-02,   6.874458671167407e-05,   3.129544300361151e-07,  -1.174523525869648e-08,
   6.752094621112116e-11,   1.342371622134484e-12,  -2.725767585915935e-14,   3.204819226622292e-17,   5.312140881875515e-18,  -6.852416031290184e-20,  -3.968111847946761e-22,
   2.002911376085492e-23,  -1.518657039753313e-25,   6.550135188904191e-01,  -1.014670167084807e-02,   6.873799069090446e-05,   3.130172822810072e-07,  -1.174334663606833e-08,
   6.746756695097414e-11,   1.342449871426115e-12,  -2.723980199776453e-14,   3.176304807798945e-17,   5.310053426697021e-18,  -6.840139258226788e-20,  -3.978814959127711e-22,
   2.000403664016207e-23,  -1.511348620106164e-25,   6.550248669629136e-01,  -1.014654595648032e-02,   6.872635277222097e-05,   3.131281454599146e-07,  -1.174001404452566e-08,
   6.737340698722154e-11,   1.342587337386062e-12,  -2.720826904571221e-14,   3.126032671839425e-17,   5.306365633434225e-18,  -6.818489316271394e-20,  -3.997657526047910e-22,
   1.995978521405235e-23,  -1.498468202859294e-25,   6.550385883187135e-01,  -1.014635764063342e-02,   6.871228154936141e-05,   3.132621331957677e-07,  -1.173598409100741e-08,
   6.725959647881961e-11,   1.342752529776857e-12,  -2.717014888860366e-14,   3.065314659655607e-17,   5.301898746406352e-18,  -6.792331489374977e-20,  -4.020368492272072e-22,
   1.990627184947749e-23,  -1.482919330035237e-25,   6.550519078784233e-01,  -1.014617480135736e-02,   6.869862299207257e-05,   3.133921337190472e-07,  -1.173207172728123e-08,
   6.714916222443045e-11,   1.342911814811888e-12,  -2.713315279961717e-14,   3.006445596812635e-17,   5.297554460443092e-18,  -6.766960454282741e-20,  -4.042338841807808e-22,
   1.985431788717734e-23,  -1.467852258060958e-25,   6.550626373013019e-01,  -1.014602749014096e-02,   6.868762094100943e-05,   3.134968085522924e-07,  -1.172891986758897e-08,
   6.706023437308713e-11,   1.343039358869973e-12,  -2.710335661857045e-14,   2.959075107447263e-17,   5.294049104261037e-18,  -6.746538022014421e-20,  -4.059982710482062e-22,
   1.981246160490520e-23,  -1.455734127598579e-25,   6.550697267988671e-01,  -1.014593014056857e-02,   6.868035152273903e-05,   3.135659504123076e-07,  -1.172683712099208e-08,
   6.700149032559445e-11,   1.343123259014362e-12,  -2.708367145286806e-14,   2.927799795569660e-17,   5.291730062546949e-18,  -6.733051147212097e-20,  -4.071614479955090e-22,
   1.978480236690421e-23,  -1.447736331739745e-25,   6.550733674980032e-01,  -1.014588014413935e-02,   6.867661849596349e-05,   3.136014502101402e-07,  -1.172576751433845e-08,
   6.697132797933096e-11,   1.343166228684784e-12,  -2.707356329851671e-14,   2.911746546424594e-17,   5.290538269582332e-18,  -6.726127436312112e-20,  -4.077579609746457e-22,
   1.977059761527667e-23,  -1.443632064867584e-25,   6.550746346612224e-01,  -1.014586274198404e-02,   6.867531920844840e-05,   3.136138049893533e-07,  -1.172539522530476e-08,
   6.696083057930072e-11,   1.343181166038880e-12,  -2.707004524121137e-14,   2.906160358554935e-17,   5.290123319240879e-18,  -6.723717964521887e-20,  -4.079654500427570e-22,
   1.976565345697971e-23,  -1.442204012248863e-25,   6.550748357418399e-01,  -1.014585998048075e-02,   6.867511303067854e-05,   3.136157654632973e-07,  -1.172533614803697e-08,
   6.695916482830238e-11,   1.343183535506761e-12,  -2.706948698243815e-14,   2.905273968829687e-17,   5.290057465887249e-18,  -6.723335633008993e-20,  -4.079983693996930e-22,
   1.976486888410806e-23,  -1.441977422517969e-25,   9.438522406529336e-01,  -1.204289312771221e-02,   2.444855477748287e-05,   1.095578475371269e-06,  -7.581547371404741e-09,
  -1.612431184257770e-10,   2.192754615698064e-12,   2.427928662329018e-14,  -6.131943849935264e-16,  -2.793641417204755e-18,   1.637038885293728e-19,  -1.411302000621169e-22,
  -4.208284850669676e-23,   2.485875441306952e-25,   9.438545241746078e-01,  -1.204258552782455e-02,   2.444430745441242e-05,   1.095427710720135e-06,  -7.578482663410187e-09,
  -1.611954689533053e-10,   2.191159051999534e-12,   2.426984117355171e-14,  -6.125119890830091e-16,  -2.794301109656054e-18,   1.634473709289979e-19,  -1.393729263965106e-22,
  -4.199912586385104e-23,   2.474841374895997e-25,   9.438585531629178e-01,  -1.204204279737934e-02,   2.443681438302595e-05,   1.095161720389070e-06,  -7.573076756519548e-09,
  -1.611114058348620e-10,   2.188345106053508e-12,   2.425317276831487e-14,  -6.113087671687154e-16,  -2.795457842501735e-18,   1.629951611173127e-19,  -1.362786873743143e-22,
  -4.185154315959464e-23,   2.455417498595004e-25,   9.438634245103347e-01,  -1.204138658056783e-02,   2.442775606245960e-05,   1.094840143870179e-06,  -7.566542975842434e-09,
  -1.610097816057068e-10,   2.184944925861026e-12,   2.423301416632213e-14,  -6.098553117344245e-16,  -2.796844139376717e-18,   1.624490590081581e-19,  -1.325481615476883e-22,
  -4.167333541444333e-23,   2.432008067329297e-25,   9.438681529560069e-01,  -1.204074959804802e-02,   2.441896489472244e-05,   1.094528027691279e-06,  -7.560203339185107e-09,
  -1.609111535745168e-10,   2.181646678184957e-12,   2.421344143255011e-14,  -6.084458849364873e-16,  -2.798176932300428e-18,   1.619196604476899e-19,  -1.289381910056538e-22,
  -4.150059686786575e-23,   2.409364221717471e-25,   9.438719617190912e-01,  -1.204023649720253e-02,   2.441188463008146e-05,   1.094276637334668e-06,  -7.555098534008444e-09,
  -1.608317194704078e-10,   2.178991506178463e-12,   2.419767167533801e-14,  -6.073115877352385e-16,  -2.799241315082209e-18,   1.614937192748871e-19,  -1.260383112541817e-22,
  -4.136162882389576e-23,   2.391180984988812e-25,   9.438744782805503e-01,  -1.203989747084038e-02,   2.440720699148745e-05,   1.094110545770471e-06,  -7.551726507005880e-09,
  -1.607792403069731e-10,   2.177237922841485e-12,   2.418725021993164e-14,  -6.065626117392828e-16,  -2.799940094494217e-18,   1.612125269095350e-19,  -1.241261626991539e-22,
  -4.126989314389164e-23,   2.379194342491774e-25,   9.438757705930131e-01,  -1.203972337124135e-02,   2.440480507054781e-05,   1.094025256826213e-06,  -7.549995161433425e-09,
  -1.607522926766596e-10,   2.176337654299145e-12,   2.418189797074643e-14,  -6.061781459369848e-16,  -2.800297546765994e-18,   1.610682021540805e-19,  -1.231454310008775e-22,
  -4.122281089859287e-23,   2.373047435560495e-25,   9.438762203842891e-01,  -1.203966277534176e-02,   2.440396910299610e-05,   1.093995572345833e-06,  -7.549392606725354e-09,
  -1.607429137738053e-10,   2.176024352220980e-12,   2.418003501845309e-14,  -6.060443560251792e-16,  -2.800421737848722e-18,   1.610179814897012e-19,  -1.228042769204751e-22,
  -4.120642801455646e-23,   2.370909349465412e-25,   9.438762917594995e-01,  -1.203965315965736e-02,   2.440383644850136e-05,   1.093990861880679e-06,  -7.549296992248799e-09,
  -1.607414254932447e-10,   2.175974637614714e-12,   2.417973939106933e-14,  -6.060231266871521e-16,  -2.800441434657643e-18,   1.610100127737011e-19,  -1.227501498904926e-22,
  -4.120382849116694e-23,   2.370570131145163e-25,   1.252500631114702e+00,  -1.193360368337175e-02,  -4.503143578775213e-05,   1.111492998560758e-06,   1.084301417224912e-08,
  -1.780672820253428e-10,  -2.949827058485977e-12,   3.181472397467040e-14,   8.411334799863342e-16,  -5.482022681504143e-18,  -2.473996587703698e-19,   6.528704638163855e-22,
   7.243545789683535e-23,   5.198449727805128e-26,   1.252496421622393e+00,  -1.193329166262789e-02,  -4.502535985948302e-05,   1.111326584680977e-06,   1.083889181342571e-08,
  -1.780049396053909e-10,  -2.947640308957687e-12,   3.179631032241576e-14,   8.401038700350733e-16,  -5.478643504198890e-18,  -2.469596908735920e-19,   6.532067484576550e-22,
   7.225722681201958e-23,   5.118208410742579e-26,   1.252488994367212e+00,  -1.193274113506915e-02,  -4.501464066744597e-05,   1.111032992194388e-06,   1.083162033806801e-08,
  -1.778949648524235e-10,  -2.943783943747029e-12,   3.176382842419501e-14,   8.382886088680775e-16,  -5.472679527439211e-18,  -2.461842517637095e-19,   6.537954293155407e-22,
   7.194322485235405e-23,   4.977154509398428e-26,   1.252480014035508e+00,  -1.193207549596753e-02,  -4.500168210894155e-05,   1.110678057866230e-06,   1.082283183911440e-08,
  -1.777620323727428e-10,  -2.939124515515238e-12,   3.172456679296003e-14,   8.360961342601260e-16,  -5.465465508539754e-18,  -2.452481003377144e-19,   6.544992783948555e-22,
   7.156436404266379e-23,   4.807497457324633e-26,   1.252471296906457e+00,  -1.193142937279835e-02,  -4.498910551785421e-05,   1.110333578403315e-06,   1.081430456142590e-08,
  -1.776330363435388e-10,  -2.934605126246035e-12,   3.168646885819915e-14,   8.339703945339718e-16,  -5.458459857202546e-18,  -2.443408880535649e-19,   6.551742231760874e-22,
   7.119744420469623e-23,   4.643744077553101e-26,   1.252464275089182e+00,  -1.193090891291049e-02,  -4.497897638147848e-05,   1.110056130857416e-06,   1.080743828067942e-08,
  -1.775291564418731e-10,  -2.930967159545285e-12,   3.165578953715456e-14,   8.322598422073021e-16,  -5.452814483205284e-18,  -2.436111854326021e-19,   6.557119938354928e-22,
   7.090248193721477e-23,   4.512502803282727e-26,   1.252459635485537e+00,  -1.193056502604937e-02,  -4.497228440433276e-05,   1.109872828141915e-06,   1.080290272267213e-08,
  -1.774605328703924e-10,  -2.928564623436421e-12,   3.163552300588012e-14,   8.311304770479065e-16,  -5.449083287034016e-18,  -2.431295664479678e-19,   6.560644346297007e-22,
   7.070788105599720e-23,   4.426111235443769e-26,   1.252457252916165e+00,  -1.193038843103958e-02,  -4.496884811741348e-05,   1.109778702604504e-06,   1.080057397830818e-08,
  -1.774252970777539e-10,  -2.927331228923952e-12,   3.162511697167157e-14,   8.305507837223211e-16,  -5.447166882496807e-18,  -2.428824037211865e-19,   6.562445320228200e-22,
   7.060803841131351e-23,   4.381847015157591e-26,   1.252456423655260e+00,  -1.193032696669894e-02,  -4.496765214415407e-05,   1.109745942810231e-06,   1.079976351418048e-08,
  -1.774130338440016e-10,  -2.926902001954007e-12,   3.162149534264069e-14,   8.303490622614851e-16,  -5.446499819560608e-18,  -2.427964037886881e-19,   6.563070737830536e-22,
   7.057330225688861e-23,   4.366456668401624e-26,   1.252456292063648e+00,  -1.193031721321011e-02,  -4.496746236241626e-05,   1.109740744351412e-06,   1.079963490832505e-08,
  -1.774110878807330e-10,  -2.926833892739236e-12,   3.162092065359146e-14,   8.303170540324995e-16,  -5.446393963925125e-18,  -2.427827580804538e-19,   6.563169915234835e-22,
   7.056779081916349e-23,   4.364015202058027e-26,   1.551424422060318e+00,  -9.369282705926787e-03,  -9.620267897203034e-05,   2.175409237547227e-09,   1.602668336061162e-08,
   1.889204391756234e-10,  -1.351962825364363e-12,  -6.375754612388876e-14,  -4.612751630985386e-16,   1.149181203658137e-17,   2.816342843543888e-19,   3.507817281060580e-22,
  -8.058608932256415e-23,  -1.212860498321706e-24,   1.551415421151941e+00,  -9.369281474173031e-03,  -9.619367479848806e-05,   2.351472245502493e-09,   1.602476817054839e-08,
   1.887955343458745e-10,  -1.353149508577695e-12,  -6.371872418001381e-14,  -4.601029222722216e-16,   1.149328775596696e-17,   2.811391784147174e-19,   3.421816134054526e-22,
  -8.051060929771794e-23,  -1.207972969012066e-24,   1.551399539592265e+00,  -9.369279260648358e-03,  -9.617778767150999e-05,   2.662043186543661e-09,   1.602138744027050e-08,
   1.885751999616161e-10,  -1.355240937724580e-12,  -6.365021844297080e-14,  -4.580361798954675e-16,   1.149585590884888e-17,   2.802659394669461e-19,   3.270355001219881e-22,
  -8.037709836349475e-23,  -1.199358641139642e-24,   1.551380336608134e+00,  -9.369276515712928e-03,  -9.615857828681517e-05,   3.037426925654466e-09,   1.601729712981291e-08,
   1.883088752496371e-10,  -1.357765669513892e-12,  -6.356737415054668e-14,  -4.555399421462860e-16,   1.149890042649626e-17,   2.792106642219002e-19,   3.087699366964348e-22,
  -8.021510258365108e-23,  -1.188958810340567e-24,   1.551361695906094e+00,  -9.369273779454358e-03,  -9.613993171893084e-05,   3.401673399044686e-09,   1.601332392610506e-08,
   1.880504428151764e-10,  -1.360212191505601e-12,  -6.348694370442072e-14,  -4.531196621500360e-16,   1.150179230206939e-17,   2.781869082076889e-19,   2.910895969918249e-22,
  -8.005726294372048e-23,  -1.178880337224713e-24,   1.551346680074849e+00,  -9.369271523927546e-03,  -9.612491141179164e-05,   3.694984159387039e-09,   1.601012144622091e-08,
   1.878423325311920e-10,  -1.362179895973588e-12,  -6.342214528470903e-14,  -4.511720822152479e-16,   1.150407640056859e-17,   2.773626768513167e-19,   2.768834469231343e-22,
  -7.992969747315237e-23,  -1.170773796290117e-24,   1.551336758309909e+00,  -9.369270008436195e-03,  -9.611498681161527e-05,   3.888739225585840e-09,   1.600800446377325e-08,
   1.877048559015418e-10,  -1.363478563020767e-12,  -6.337932536711679e-14,  -4.498862163663446e-16,   1.150556341536411e-17,   2.768182813264244e-19,   2.675143295596700e-22,
  -7.984520339244194e-23,  -1.165423283436356e-24,   1.551331663141494e+00,  -9.369269222403978e-03,  -9.610989022504715e-05,   3.988223337158168e-09,   1.600691703212052e-08,
   1.876342671166369e-10,  -1.364145009359445e-12,  -6.335733459180000e-14,  -4.492261905565866e-16,   1.150632018570154e-17,   2.765387830624883e-19,   2.627084196248875e-22,
  -7.980174957603560e-23,  -1.162677439922811e-24,   1.551329889742580e+00,  -9.369268947583779e-03,  -9.610811633856523e-05,   4.022846766424352e-09,   1.600653850021680e-08,
   1.876096999608167e-10,  -1.364376895499551e-12,  -6.334968039027843e-14,  -4.489965147138888e-16,   1.150658249134812e-17,   2.764415130617632e-19,   2.610365667493421e-22,
  -7.978661520797676e-23,  -1.161722026600544e-24,   1.551329608329599e+00,  -9.369268903914995e-03,  -9.610783484849969e-05,   4.028340888866027e-09,   1.600647843045375e-08,
   1.876058015825489e-10,  -1.364413688999756e-12,  -6.334846576866224e-14,  -4.489600707980546e-16,   1.150662406366049e-17,   2.764260782187638e-19,   2.607713088780391e-22,
  -7.978421312389733e-23,  -1.161570430033472e-24,   1.801694556901861e+00,  -5.047181316653193e-03,  -8.329602098333555e-05,  -9.376044080427971e-07,  -4.295826618059048e-09,
   9.924778621253599e-11,   3.002466509564506e-12,   3.977547305598989e-14,   9.364418027886990e-17,  -8.618261482818099e-18,  -2.200542508329430e-19,  -2.551128523796226e-21,
   5.445062007219192e-24,   8.776202332122875e-25,   1.801686743112878e+00,  -5.047444687195296e-03,  -8.329841353178022e-05,  -9.375107094400324e-07,  -4.291601756995426e-09,
   9.932562527936502e-11,   3.002693184171200e-12,   3.974605119444814e-14,   9.271718279362177e-17,  -8.631162148972836e-18,  -2.200132572493399e-19,  -2.544625028828054e-21,
   5.602871421178678e-24,   8.791904057827463e-25,   1.801672955379575e+00,  -5.047909387128689e-03,  -8.330263328850951e-05,  -9.373453175954345e-07,  -4.284146671448284e-09,
   9.946292628199362e-11,   3.003091177590290e-12,   3.969410064491819e-14,   9.108162813971522e-17,  -8.653898227318241e-18,  -2.199401312244320e-19,  -2.533140297959792e-21,
   5.881179693717247e-24,   8.819518618834086e-25,   1.801656282798810e+00,  -5.048471270531230e-03,  -8.330773256804496e-05,  -9.371452231175161e-07,  -4.275131474666202e-09,
   9.962887150866988e-11,   3.003569063920610e-12,   3.963122149748767e-14,   8.910415046899908e-17,  -8.681344275844011e-18,  -2.198503562021592e-19,  -2.519237169233752e-21,
   6.217458218172632e-24,   8.852754579722871e-25,   1.801640097025339e+00,  -5.049016698745554e-03,  -8.331267940935533e-05,  -9.369508692401348e-07,  -4.266379231790567e-09,
   9.978988379636416e-11,   3.004029457312295e-12,   3.957011675662914e-14,   8.718471615442522e-17,  -8.707939528972320e-18,  -2.197617908573130e-19,  -2.505723891171219e-21,
   6.543643617466524e-24,   8.884856196554099e-25,   1.801627057747048e+00,  -5.049456061052599e-03,  -8.331666204769148e-05,  -9.367942246285252e-07,  -4.259328220658077e-09,
   9.991953264744776e-11,   3.004397814933535e-12,   3.952084665609808e-14,   8.563863764802318e-17,  -8.729329261914385e-18,  -2.196894316062452e-19,  -2.494826080759579e-21,
   6.806221533930710e-24,   8.910599809467905e-25,   1.801618441511822e+00,  -5.049746370336144e-03,  -8.331929249343311e-05,  -9.366906796257418e-07,  -4.254668882926422e-09,
   1.000051726358669e-10,   3.004639980752843e-12,   3.948826787806717e-14,   8.461711159544771e-17,  -8.743446042020343e-18,  -2.196411225109471e-19,  -2.487619291900183e-21,
   6.979633621620400e-24,   8.927553410784454e-25,   1.801614016628004e+00,  -5.049895453867707e-03,  -8.332064297875065e-05,  -9.366374928611893e-07,  -4.252276042187552e-09,
   1.000491436911907e-10,   3.004763961539264e-12,   3.947153032525238e-14,   8.409253863791815e-17,  -8.750690370714694e-18,  -2.196161603152093e-19,  -2.483916498041827e-21,
   7.068659663878552e-24,   8.936242165980475e-25,   1.801612476501136e+00,  -5.049947343091193e-03,  -8.332111296792203e-05,  -9.366189788978452e-07,  -4.251443184444705e-09,
   1.000644467585031e-10,   3.004807053222919e-12,   3.946570358586336e-14,   8.390996093313736e-17,  -8.753210979585813e-18,  -2.196074476141133e-19,  -2.482627426323591e-21,
   7.099641312549270e-24,   8.939263543783127e-25,   1.801612232103950e+00,  -5.049955577164761e-03,  -8.332118754590080e-05,  -9.366160409003068e-07,  -4.251311021030135e-09,
   1.000668750751564e-10,   3.004813888385495e-12,   3.946477891126505e-14,   8.388098859008032e-17,  -8.753610925329789e-18,  -2.196060638711043e-19,  -2.482422855088672e-21,
   7.104557451179415e-24,   8.939742860805025e-25,   1.960440970382634e+00,  -1.130824708685644e-03,  -2.363541411367568e-05,  -4.239428657262170e-07,  -6.795324818206257e-09,
  -9.774022109945382e-11,  -1.232372997734020e-12,  -1.258777981154984e-14,  -7.276536950526554e-17,   8.511287046963933e-19,   4.065076899858774e-20,   9.352900738281808e-22,
   1.642381876047990e-23,   2.316916571163145e-25,   1.960438746873828e+00,  -1.130944265916272e-03,  -2.363924627237360e-05,  -4.240347049143328e-07,  -6.797060049716025e-09,
  -9.776495523231404e-11,  -1.232560386321238e-12,  -1.258477955768233e-14,  -7.259057216035225e-17,   8.560173883958718e-19,   4.075332750913703e-20,   9.369883715587061e-22,
   1.644407046364739e-23,   2.317669863956344e-25,   1.960434823164250e+00,  -1.131155247569590e-03,  -2.364600897085016e-05,  -4.241967754462252e-07,  -6.800122105869424e-09,
  -9.780859413425511e-11,  -1.232890661389624e-12,  -1.257947209983037e-14,  -7.228178690749751e-17,   8.646506712395905e-19,   4.093439515356266e-20,   9.399854755443962e-22,
   1.647977435376832e-23,   2.318986504057945e-25,   1.960430078072540e+00,  -1.131410404715308e-03,  -2.365418785229339e-05,  -4.243927849857031e-07,  -6.803825139529838e-09,
  -9.786135445140190e-11,  -1.233289393537696e-12,  -1.257303129666515e-14,  -7.190779905072532e-17,   8.751022765521039e-19,   4.115351711041932e-20,   9.436103353332511e-22,
   1.652289563132037e-23,   2.320557160677128e-25,   1.960425471095825e+00,  -1.131658144428684e-03,  -2.366212918700090e-05,  -4.245831012868850e-07,  -6.807420359887821e-09,
  -9.791256453365544e-11,  -1.233675804951123e-12,  -1.256675460703999e-14,  -7.154410799796725e-17,   8.852612363071911e-19,   4.136641796921259e-20,   9.471300439703430e-22,
   1.656470212543647e-23,   2.322059440667203e-25,   1.960421759399940e+00,  -1.131857747243752e-03,  -2.366852763915001e-05,  -4.247364417199384e-07,  -6.810316894213791e-09,
  -9.795381244854084e-11,  -1.233986611831529e-12,  -1.256168092980460e-14,  -7.125067152605946e-17,   8.934542786916424e-19,   4.153805776261802e-20,   9.499660135953651e-22,
   1.659834143227771e-23,   2.323253521229281e-25,   1.960419306593622e+00,  -1.131989654411815e-03,  -2.367275611992043e-05,  -4.248377781434640e-07,  -6.812231005352399e-09,
  -9.798106526475958e-11,  -1.234191751720014e-12,  -1.255831987957703e-14,  -7.105655268725633e-17,   8.988725592690180e-19,   4.165153771209685e-20,   9.518402334102132e-22,
   1.662055031382003e-23,   2.324034637226551e-25,   1.960418046903370e+00,  -1.132057399131541e-03,  -2.367492780100615e-05,  -4.248898228938549e-07,  -6.813214034072988e-09,
  -9.799505993896397e-11,  -1.234297027916977e-12,  -1.255659120373509e-14,  -7.095679493465285e-17,   9.016564862640907e-19,   4.170983470451644e-20,   9.528028154689421e-22,
   1.663194963474634e-23,   2.324433328884289e-25,   1.960417608447592e+00,  -1.132080978950777e-03,  -2.367568369899480e-05,  -4.249079381266110e-07,  -6.813556192756909e-09,
  -9.799993076198972e-11,  -1.234333658643904e-12,  -1.255598910575753e-14,  -7.092206243782673e-17,   9.026256773607891e-19,   4.173012862756515e-20,   9.531378637506307e-22,
   1.663591631621009e-23,   2.324571707123360e-25,   1.960417538870269e+00,  -1.132084720774161e-03,  -2.367580365075826e-05,  -4.249108127921330e-07,  -6.813610488937975e-09,
  -9.800070368732798e-11,  -1.234339470884187e-12,  -1.255589354132528e-14,  -7.091655035155236e-17,   9.027794850752523e-19,   4.173334914180806e-20,   9.531910319046135e-22,
   1.663654572849657e-23,   2.324593647323555e-25,   7.890207419046544e-03,  -1.573869424665692e-04,   2.346186931534107e-06,  -3.097392742626384e-08,   3.810568753753704e-10,
  -4.474826639083604e-12,   5.061295082201985e-14,  -5.568290265784516e-16,   5.934084383419280e-18,  -6.227504247757990e-20,   6.209084450708708e-22,  -6.330021072260778e-24,
   5.927605572777644e-26,  -4.274400922914647e-28,   7.890427804742150e-03,  -1.573956686778567e-04,   2.346401678505672e-06,  -3.097813181663516e-08,   3.811282346375770e-10,
  -4.475926252740136e-12,   5.062858214480664e-14,  -5.570400588987419e-16,   5.936715762574001e-18,  -6.230780246196378e-20,   6.212788214947763e-22,  -6.333130228775857e-24,
   5.935391842226288e-26,  -4.271340535545048e-28,   7.890816695190914e-03,  -1.574110671781590e-04,   2.346780635598308e-06,  -3.098555136885119e-08,   3.812541670727426e-10,
  -4.477866876565055e-12,   5.065616948315020e-14,  -5.574125187319645e-16,   5.941360146068343e-18,  -6.236562098783366e-20,   6.219327479881775e-22,  -6.338614631335798e-24,
   5.949128801071410e-26,  -4.265989641609046e-28,   7.891286973679025e-03,  -1.574296888517331e-04,   2.347238930296565e-06,  -3.099452460185747e-08,   3.814064764347411e-10,
  -4.480214076436708e-12,   5.068953797763112e-14,  -5.578630545968621e-16,   5.946978356692201e-18,  -6.243555795902632e-20,   6.227241503016811e-22,  -6.345243460447219e-24,
   5.965736162749595e-26,  -4.259603122961243e-28,   7.891743541220790e-03,  -1.574477681702597e-04,   2.347683893226675e-06,  -3.100323716009046e-08,   3.815543676884570e-10,
  -4.482493301595971e-12,   5.072194157961111e-14,  -5.583005877435627e-16,   5.952434694487657e-18,  -6.250347479299374e-20,   6.234931287809466e-22,  -6.351675529324645e-24,
   5.981854564282499e-26,  -4.253490915572784e-28,   7.892111367108661e-03,  -1.574623338667658e-04,   2.348042391403817e-06,  -3.101025695785962e-08,   3.816735298635568e-10,
  -4.484329848707756e-12,   5.074805269897464e-14,  -5.586531739396978e-16,   5.956831880957393e-18,  -6.255820435317090e-20,   6.241131084739461e-22,  -6.356854928883804e-24,
   5.994836621454949e-26,  -4.248629790283959e-28,   7.892354430192311e-03,  -1.574719592231089e-04,   2.348279301094644e-06,  -3.101489604117452e-08,   3.817522813222687e-10,
  -4.485543618349007e-12,   5.076530998700183e-14,  -5.588862130226257e-16,   5.959738262701114e-18,  -6.259437681815698e-20,   6.245230251053810e-22,  -6.360276318083613e-24,
   6.003413587128105e-26,  -4.245448365440229e-28,   7.892479257898172e-03,  -1.574769024908177e-04,   2.348400971891217e-06,  -3.101727859511353e-08,   3.817927274334938e-10,
  -4.486167012715417e-12,   5.077417352057450e-14,  -5.590059071880750e-16,   5.961231076040770e-18,  -6.261295562875240e-20,   6.247336127014383e-22,  -6.362033037092480e-24,
   6.007817849615155e-26,  -4.243824047085578e-28,   7.892522705830969e-03,  -1.574786230701318e-04,   2.348443321534711e-06,  -3.101810789073163e-08,   3.818068056252090e-10,
  -4.486384001274447e-12,   5.077725872821661e-14,  -5.590475706160578e-16,   5.961750702763116e-18,  -6.261942255492053e-20,   6.248069217084211e-22,  -6.362644427141992e-24,
   6.009350726376899e-26,  -4.243260199466212e-28,   7.892529600443581e-03,  -1.574788961037836e-04,   2.348450041887763e-06,  -3.101823948975460e-08,   3.818090396665666e-10,
  -4.486418434866028e-12,   5.077774831642143e-14,  -5.590541821601441e-16,   5.961833162236622e-18,  -6.262044878607555e-20,   6.248185554109869e-22,  -6.362741443852581e-24,
   6.009593969614906e-26,  -4.243170796349937e-28,   7.079496194213995e-02,  -1.383285759514823e-03,   1.969158956153000e-05,  -2.391594751691786e-07,   2.562622746227142e-09,
  -2.409319340970059e-11,   1.872268805922035e-13,  -9.692051247432860e-16,  -2.645636518209394e-18,   1.590241284556370e-19,  -2.968738413659573e-21,   3.670579515390904e-23,
  -3.980411609797566e-25,   4.269901078667156e-27,   7.079681092173344e-02,  -1.383353102605025e-03,   1.969303251963408e-05,  -2.391820784556034e-07,   2.562885947895761e-09,
  -2.409509290133055e-11,   1.872196752796172e-13,  -9.686634487958423e-16,  -2.658239655857782e-18,   1.592146190441844e-19,  -2.971190738155579e-21,   3.673728189343405e-23,
  -3.978135037433919e-25,   4.274746106850178e-27,   7.080007358552130e-02,  -1.383471935720083e-03,   1.969557876229307e-05,  -2.392219637558035e-07,   2.563350363047310e-09,
  -2.409844371478580e-11,   1.872069344474511e-13,  -9.677071294628719e-16,  -2.680486492692853e-18,   1.595508749495209e-19,  -2.975516757931902e-21,   3.679286883896118e-23,
  -3.974117768035241e-25,   4.283242816763065e-27,   7.080401902135344e-02,  -1.383615638813086e-03,   1.969865791138442e-05,  -2.392701959515770e-07,   2.563911924580523e-09,
  -2.410249407123037e-11,   1.871914821417409e-13,  -9.665498448732164e-16,  -2.707401929229795e-18,   1.599577047856091e-19,  -2.980745874249898e-21,   3.686013286427890e-23,
  -3.969259699443268e-25,   4.293427797787524e-27,   7.080784937896002e-02,  -1.383755152525420e-03,   1.970164731096826e-05,  -2.393170215126801e-07,   2.564457063867796e-09,
  -2.410642453345178e-11,   1.871764331712044e-13,  -9.654254375313655e-16,  -2.733545965363356e-18,   1.603528844983598e-19,  -2.985820164610648e-21,   3.692548129159533e-23,
  -3.964543254631867e-25,   4.303221713648863e-27,   7.081093520624647e-02,  -1.383867549576394e-03,   1.970405568640383e-05,  -2.393547454241729e-07,   2.564896210273231e-09,
  -2.410958974896411e-11,   1.871642754133176e-13,  -9.645189590958920e-16,  -2.754618003231038e-18,   1.606714055510572e-19,  -2.989906481486466e-21,   3.697816053588575e-23,
  -3.960743552467102e-25,   4.311044623537332e-27,   7.081297433499054e-02,  -1.383941822786149e-03,   1.970564717339306e-05,  -2.393796736177315e-07,   2.565186385140804e-09,
  -2.411168072146340e-11,   1.871562248854792e-13,  -9.639196459072103e-16,  -2.768547289235219e-18,   1.608819615672724e-19,  -2.992605929345609e-21,   3.701298729808700e-23,
  -3.958232693611628e-25,   4.316181103759763e-27,   7.081402154652275e-02,  -1.383979966635453e-03,   1.970646450143143e-05,  -2.393924757176992e-07,   2.565335402193172e-09,
  -2.411275436713800e-11,   1.871520853274150e-13,  -9.636117683327653e-16,  -2.775702270204305e-18,   1.609901178243901e-19,  -2.993992003077340e-21,   3.703087782699263e-23,
  -3.956943224307977e-25,   4.318808804645621e-27,   7.081438604148614e-02,  -1.383993243111075e-03,   1.970674898365253e-05,  -2.393969316503733e-07,   2.565387268683821e-09,
  -2.411312803247750e-11,   1.871506436841212e-13,  -9.635045925507722e-16,  -2.778192885714965e-18,   1.610277666870743e-19,  -2.994474403404700e-21,   3.703710563491887e-23,
  -3.956494409258518e-25,   4.319721788017318e-27,   7.081444388197830e-02,  -1.383995349912484e-03,   1.970679412723930e-05,  -2.393976387476349e-07,   2.565395499169267e-09,
  -2.411318732674500e-11,   1.871504148756761e-13,  -9.634875844624115e-16,  -2.778588124383777e-18,   1.610337412371042e-19,  -2.994550952015770e-21,   3.703809394237518e-23,
  -3.956423188332320e-25,   4.319866589384898e-27,   1.953701710041551e-01,  -3.654078933851107e-03,   4.693102163503499e-05,  -4.618183501809425e-07,   3.111606695188894e-09,
  -2.732525277349108e-12,  -3.245618309416108e-13,   6.109430760875282e-15,  -6.819962215103289e-17,   3.863074257089304e-19,   2.281639396111474e-21,  -1.102054261373946e-22,
   1.674021802133941e-24,  -1.291629127597748e-26,   1.953745742871233e-01,  -3.654208828651534e-03,   4.693276932098143e-05,  -4.618208105982008e-07,   3.111148166658356e-09,
  -2.720476891574759e-12,  -3.247406478541693e-13,   6.110719625227720e-15,  -6.818966117879361e-17,   3.857355937811554e-19,   2.292058874909909e-21,  -1.102979042528612e-22,
   1.675354934470148e-24,  -1.288044608526263e-26,   1.953823440822070e-01,  -3.654438030618780e-03,   4.693585293018473e-05,  -4.618251428537598e-07,   3.110338881483394e-09,
  -2.699215269414509e-12,  -3.250561516526178e-13,   6.112992275015438e-15,  -6.817204909508355e-17,   3.847262016763357e-19,   2.310450869302226e-21,  -1.104608712304814e-22,
   1.677703080387112e-24,  -1.281727005008980e-26,   1.953917396282304e-01,  -3.654715185020196e-03,   4.693958130500495e-05,  -4.618303657937094e-07,   3.109359936752982e-09,
  -2.673501984935310e-12,  -3.254376255786653e-13,   6.115737706924961e-15,  -6.815069133223158e-17,   3.835049769620453e-19,   2.332702007009636e-21,  -1.106575712701581e-22,
   1.680535329628427e-24,  -1.274100186734598e-26,   1.954008608991541e-01,  -3.654984242691503e-03,   4.694320037137380e-05,  -4.618354197228180e-07,   3.108409229282287e-09,
  -2.648536306521558e-12,  -3.258079154289433e-13,   6.118400116788913e-15,  -6.812989364219956e-17,   3.823187459232519e-19,   2.354314884573753e-21,  -1.108481462192446e-22,
   1.683277318085381e-24,  -1.266709270220595e-26,   1.954082090465392e-01,  -3.655200992750588e-03,   4.694611557516951e-05,  -4.618394793432945e-07,   3.107643090292872e-09,
  -2.628421654854869e-12,  -3.261061885321522e-13,   6.120542907045353e-15,  -6.811309346423529e-17,   3.813626417753953e-19,   2.371734420974677e-21,  -1.110014003195877e-22,
   1.685480834300308e-24,  -1.260764593200900e-26,   1.954130646547343e-01,  -3.655344217669657e-03,   4.694804175816950e-05,  -4.618421561102349e-07,   3.107136711307494e-09,
  -2.615128966324038e-12,  -3.263032685599981e-13,   6.121957839036032e-15,  -6.810196976101250e-17,   3.807306245843606e-19,   2.383249088667227e-21,  -1.111025355136785e-22,
   1.686934232231516e-24,  -1.256841028894922e-26,   1.954155582676369e-01,  -3.655417770624097e-03,   4.694903090455905e-05,  -4.618435289773550e-07,   3.106876621888542e-09,
  -2.608302137454846e-12,  -3.264044743973795e-13,   6.122684169441718e-15,  -6.809625026466040e-17,   3.804059791541905e-19,   2.389163703271858e-21,  -1.111544323565702e-22,
   1.687679802088362e-24,  -1.254827503814710e-26,   1.954164261965448e-01,  -3.655443371420243e-03,   4.694937517953109e-05,  -4.618440065328182e-07,   3.106786089083279e-09,
  -2.605925933913604e-12,  -3.264396993489816e-13,   6.122936926849706e-15,  -6.809425843621556e-17,   3.802929715049027e-19,   2.391222543011119e-21,  -1.111724890157710e-22,
   1.687939173935804e-24,  -1.254126902811278e-26,   1.954165639251038e-01,  -3.655447433914807e-03,   4.694942981091975e-05,  -4.618440823008339e-07,   3.106771722474788e-09,
  -2.605548860135499e-12,  -3.264452890320068e-13,   6.122977033664808e-15,  -6.809394230799598e-17,   3.802750381855996e-19,   2.391549262203614e-21,  -1.111753540497903e-22,
   1.687980326475313e-24,  -1.254015737752748e-26,   3.787514137439747e-01,  -6.589994790590610e-03,   7.006631633390012e-05,  -4.021087393923354e-07,  -1.859164700092980e-09,
   7.740595690299409e-11,  -9.132867621654066e-13,   2.432423982062967e-15,   1.065912678655874e-16,  -2.181960290360395e-18,   1.682182581809761e-20,   9.011359151265396e-23,
  -4.821150073406047e-24,   7.012556568144959e-26,   3.787579803342280e-01,  -6.590107627697327e-03,   7.006526332694194e-05,  -4.020361322855981e-07,  -1.860445678865989e-09,
   7.741062882361989e-11,  -9.130055176763971e-13,   2.425072588406167e-15,   1.066612765520502e-16,  -2.181475813707060e-18,   1.679201914364191e-20,   9.062365275911280e-23,
  -4.820648860465367e-24,   7.007670070216797e-26,   3.787695671050876e-01,  -6.590306713941349e-03,   7.006340469454545e-05,  -4.019080123767110e-07,  -1.862705663987514e-09,
   7.741886074083728e-11,  -9.125091085168291e-13,   2.412102282374128e-15,   1.067847057716752e-16,  -2.180618811643705e-18,   1.673942746640469e-20,   9.152336754804111e-23,
  -4.819751039723778e-24,   6.999004635509430e-26,   3.787835778141623e-01,  -6.590547422839807e-03,   7.006115621892941e-05,  -4.017530824065855e-07,  -1.865437912862098e-09,
   7.742879481241546e-11,  -9.119085916316673e-13,   2.396420744909525e-15,   1.069337834344789e-16,  -2.179578875439215e-18,   1.667583764484701e-20,   9.261080530954875e-23,
  -4.818642532370915e-24,   6.988452831819830e-26,   3.787971790234067e-01,  -6.590781069219944e-03,   7.005897239331706e-05,  -4.016026727903507e-07,  -1.868089757424419e-09,
   7.743841764217030e-11,  -9.113253548308695e-13,   2.381199788381448e-15,   1.070783229652085e-16,  -2.178565512540442e-18,   1.661411061889104e-20,   9.366593793421694e-23,
  -4.817542524313374e-24,   6.978132486892931e-26,   3.788081358770677e-01,  -6.590969270459473e-03,   7.005721238358076e-05,  -4.014815002631928e-07,  -1.870225636577910e-09,
   7.744615462719395e-11,  -9.108553168222628e-13,   2.368939713095732e-15,   1.071946313884349e-16,  -2.177746430896104e-18,   1.656438766164576e-20,   9.451555549682884e-23,
  -4.816639286544269e-24,   6.969763567142191e-26,   3.788153759200285e-01,  -6.591093620083165e-03,   7.005604903418721e-05,  -4.014014294165490e-07,  -1.871636785538761e-09,
   7.745125972489809e-11,  -9.105446310916924e-13,   2.360839321942833e-15,   1.072714219096786e-16,  -2.177203860131774e-18,   1.653153336336532e-20,   9.507677921236184e-23,
  -4.816034089781196e-24,   6.964206640279290e-26,   3.788190940128153e-01,  -6.591157476347668e-03,   7.005545148533145e-05,  -4.013603085258650e-07,  -1.872361415592099e-09,
   7.745387915951689e-11,  -9.103850503574615e-13,   2.356679646117143e-15,   1.073108377205743e-16,  -2.176924810916620e-18,   1.651466165271896e-20,   9.536493603367839e-23,
  -4.815720711541623e-24,   6.961344581245638e-26,   3.788203881265599e-01,  -6.591179701593125e-03,   7.005524348494672e-05,  -4.013459959151246e-07,  -1.872613619773758e-09,
   7.745479051518150e-11,  -9.103295022461721e-13,   2.355231874690048e-15,   1.073245536030028e-16,  -2.176827619511134e-18,   1.650878938617021e-20,   9.546522234319913e-23,
  -4.815611226749023e-24,   6.960347092764434e-26,   3.788205934844697e-01,  -6.591183228409172e-03,   7.005521047729421e-05,  -4.013437246957826e-07,  -1.872653640631865e-09,
   7.745493511756320e-11,  -9.103206873087463e-13,   2.355002135290319e-15,   1.073267299750342e-16,  -2.176812193451397e-18,   1.650785754247249e-20,   9.548113595708717e-23,
  -4.815593833531182e-24,   6.960188742301501e-26,   6.155392635366133e-01,  -9.584893376198377e-03,   7.142203183665661e-05,   1.373291342948160e-07,  -1.013318954008192e-08,
   9.085241072003376e-11,   6.183719333528233e-13,  -2.371986082631609e-14,   1.720798380382780e-16,   2.472225248673705e-18,  -6.814799480357639e-20,   3.322998449494926e-22,
   9.958762658955674e-24,  -1.988201591953710e-25,   6.155459479067736e-01,  -9.584854453909041e-03,   7.141633686978292e-05,   1.374139168892313e-07,  -1.013231469321069e-08,
   9.080584583350351e-11,   6.188177516544703e-13,  -2.371147408056025e-14,   1.717943339294640e-16,   2.473883264759086e-18,  -6.808601360263381e-20,   3.308719331640783e-22,
   9.966640482990771e-24,  -1.983489598106635e-25,   6.155577421497821e-01,  -9.584785755598020e-03,   7.140628841230786e-05,   1.375634816629589e-07,  -1.013077050473767e-08,
   9.072369480235435e-11,   6.196037969798216e-13,  -2.369667102675012e-14,   1.712907703326392e-16,   2.476802900954096e-18,  -6.797660774853643e-20,   3.283551543702383e-22,
   9.980488487608360e-24,  -1.975180591208140e-25,   6.155720031356612e-01,  -9.584702651931060e-03,   7.139413839434240e-05,   1.377442765508202e-07,  -1.012890239084288e-08,
   9.062437982523161e-11,   6.205532548679438e-13,  -2.367876333888628e-14,   1.706822189449383e-16,   2.480323203192847e-18,  -6.784424661809909e-20,   3.253166003891658e-22,
   9.997144101903007e-24,  -1.965142439127633e-25,   6.155858466802772e-01,  -9.584621941847270e-03,   7.138234408388164e-05,   1.379197258208990e-07,  -1.012708795331765e-08,
   9.052799058027493e-11,   6.214738871168585e-13,  -2.366137084041565e-14,   1.700918281359286e-16,   2.483730029720252e-18,  -6.771568341813543e-20,   3.223718085086326e-22,
   1.001321937381315e-23,  -1.955407213895878e-25,   6.155969983055196e-01,  -9.584556898151778e-03,   7.137284325437943e-05,   1.380610201394993e-07,  -1.012562561811716e-08,
   9.045035786957632e-11,   6.222147593417460e-13,  -2.364735392991873e-14,   1.696164895745113e-16,   2.486466921477498e-18,  -6.761206508129794e-20,   3.200030913032594e-22,
   1.002610230050222e-23,  -1.947571561783837e-25,   6.156043668294437e-01,  -9.584513906343956e-03,   7.136656552703634e-05,   1.381543627151072e-07,  -1.012465901599768e-08,
   9.039906798631967e-11,   6.227039341134238e-13,  -2.363808899879772e-14,   1.693025278242600e-16,   2.488271690879134e-18,  -6.754357176176817e-20,   3.184396317668272e-22,
   1.003458226944200e-23,  -1.942397295036779e-25,   6.156081508351257e-01,  -9.584491824254250e-03,   7.136334169147088e-05,   1.382022917310979e-07,  -1.012416252153916e-08,
   9.037273078425934e-11,   6.229550311478680e-13,  -2.363333014632366e-14,   1.691413347370904e-16,   2.489197376522773e-18,  -6.750838970456034e-20,   3.176372604658454e-22,
   1.003892698674635e-23,  -1.939741111730161e-25,   6.156094678795955e-01,  -9.584484137785442e-03,   7.136221961836683e-05,   1.382189727715054e-07,  -1.012398969649447e-08,
   9.036356429498460e-11,   6.230424090475500e-13,  -2.363167364618375e-14,   1.690852365816374e-16,   2.489519386893728e-18,  -6.749614308090798e-20,   3.173580737369201e-22,
   1.004043758940565e-23,  -1.938816770100784e-25,   6.156096768757798e-01,  -9.584482918020444e-03,   7.136204156140677e-05,   1.382216197710180e-07,  -1.012396227079947e-08,
   9.036210971908613e-11,   6.230562738280594e-13,  -2.363141077587758e-14,   1.690763348890988e-16,   2.489570476818563e-18,  -6.749419965409799e-20,   3.173137747280972e-22,
   1.004067722453333e-23,  -1.938670097758399e-25,   8.961518991414454e-01,  -1.179700463335908e-02,   3.677104347927349e-05,   9.515246642928743e-07,  -1.023677516318357e-08,
  -1.027251459173413e-10,   2.591519689746090e-12,   4.266442308298880e-15,  -6.023544240078768e-16,   3.100036589551789e-18,   1.197819720409854e-19,  -1.665386938664292e-21,
  -1.862729682759378e-23,   5.722548059149531e-25,   8.961553349023639e-01,  -1.179673735651822e-02,   3.676530576057560e-05,   9.514284318049062e-07,  -1.023314940614923e-08,
  -1.027165839284910e-10,   2.589948861663426e-12,   4.276685851909347e-15,  -6.018527789113611e-16,   3.091608976982246e-18,   1.196673002647080e-19,  -1.661275677390803e-21,
  -1.861478857383807e-23,   5.709218784227711e-25,   8.961613969217592e-01,  -1.179626576431232e-02,   3.675518311925959e-05,   9.512586346391617e-07,  -1.022675349256454e-08,
  -1.027014598760669e-10,   2.587178179102799e-12,   4.294737738655389e-15,  -6.009680110243547e-16,   3.076755481432593e-18,   1.194650238139061e-19,  -1.654029181504557e-21,
  -1.859264647951752e-23,   5.685725011108387e-25,   8.961687264391055e-01,  -1.179569554746251e-02,   3.674294553217318e-05,   9.510533253083731e-07,  -1.021902253975363e-08,
  -1.026831439623181e-10,   2.583829661118754e-12,   4.316527076114509e-15,  -5.998988098095786e-16,   3.058823711537928e-18,   1.192205378286727e-19,  -1.645280082650626e-21,
  -1.856575123920337e-23,   5.657360278286344e-25,   8.961758410315238e-01,  -1.179514203006700e-02,   3.673106844572290e-05,   9.508540263202288e-07,  -1.021152066188483e-08,
  -1.026653341649386e-10,   2.580580883994499e-12,   4.337638782176812e-15,  -5.988615487499702e-16,   3.041446446168465e-18,   1.189833093722312e-19,  -1.636800671203428e-21,
  -1.853951585812062e-23,   5.629870503326381e-25,   8.961815718986258e-01,  -1.179469615177412e-02,   3.672150253339627e-05,   9.506934820780357e-07,  -1.020547953673195e-08,
  -1.026509660497717e-10,   2.577965076640990e-12,   4.354616746579346e-15,  -5.980264468370109e-16,   3.027469441947555e-18,   1.187922833294244e-19,  -1.629979833723917e-21,
  -1.851829111243120e-23,   5.607758171867567e-25,   8.961853584813007e-01,  -1.179440153711040e-02,   3.671518258383809e-05,   9.505874014338036e-07,  -1.020148878983978e-08,
  -1.026414616928257e-10,   2.576237265994467e-12,   4.365821123410381e-15,  -5.974748721598364e-16,   3.018244398623416e-18,   1.186660970171387e-19,  -1.625477670646968e-21,
  -1.850422233075928e-23,   5.593162914684003e-25,   8.961873029885074e-01,  -1.179425024264196e-02,   3.671193730734949e-05,   9.505329252254234e-07,  -1.019943969697237e-08,
  -1.026365776098898e-10,   2.575350159174045e-12,   4.371570668668706e-15,  -5.971916881723433e-16,   3.013510208537270e-18,   1.186013067877862e-19,  -1.623167116720115e-21,
  -1.849698381019518e-23,   5.585672551349251e-25,   8.961879797786473e-01,  -1.179419758389460e-02,   3.671080781009016e-05,   9.505139644857687e-07,  -1.019872654661019e-08,
  -1.026348771602376e-10,   2.575041426411439e-12,   4.373571144177554e-15,  -5.970931354906108e-16,   3.011862957293841e-18,   1.185787579435810e-19,  -1.622363149535849e-21,
  -1.849446222602279e-23,   5.583066257428747e-25,   8.961880871752853e-01,  -1.179418922770880e-02,   3.671062857684910e-05,   9.505109556871816e-07,  -1.019861338208863e-08,
  -1.026346072985703e-10,   2.574992436335275e-12,   4.373888558560513e-15,  -5.970774971116415e-16,   3.011601586221711e-18,   1.185751798469852e-19,  -1.622235582515989e-21,
  -1.849406198329498e-23,   5.582652712243118e-25,   1.204133964352617e+00,  -1.223784814327731e-02,  -3.078162204262745e-05,   1.252998495400535e-06,   6.660570178545351e-09,
  -2.353799722555337e-10,  -1.724849691034046e-12,   5.377988386543401e-14,   4.816810420094465e-16,  -1.381613654855184e-17,  -1.468107177926782e-19,   3.695493463972033e-21,
   4.468424952571127e-23,  -1.043631599859775e-24,   1.204131086074592e+00,  -1.223749651210224e-02,  -3.077788907923177e-05,   1.252778710426613e-06,   6.658159397847214e-09,
  -2.352748261622344e-10,  -1.723597866131400e-12,   5.373374254268467e-14,   4.810703860761835e-16,  -1.379737062975074e-17,  -1.465393299694383e-19,   3.688040000290837e-21,
   4.457375388505542e-23,  -1.040389443460759e-24,   1.204126007590563e+00,  -1.223687610345474e-02,  -3.077130330550297e-05,   1.252390976292643e-06,   6.653906963568266e-09,
  -2.350893678375581e-10,  -1.721390299321573e-12,   5.365237673131817e-14,   4.799938004169132e-16,  -1.376428893383045e-17,  -1.460610137002654e-19,   3.674907382074349e-21,
   4.437914701191893e-23,  -1.034678927114036e-24,   1.204119867115600e+00,  -1.223612598408908e-02,  -3.076334159082954e-05,   1.251922260250124e-06,   6.648767305359947e-09,
  -2.348652351067833e-10,  -1.718723097667534e-12,   5.355407569881891e-14,   4.786935597339557e-16,  -1.372433910398166e-17,  -1.454835681976657e-19,   3.659059865933995e-21,
   4.414444652104906e-23,  -1.027791282538603e-24,   1.204113906553665e+00,  -1.223539787060720e-02,  -3.075561445716005e-05,   1.251467381423686e-06,   6.643780358311772e-09,
  -2.346477822373036e-10,  -1.716136138840746e-12,   5.345873818315495e-14,   4.774329596155449e-16,  -1.368561183810375e-17,  -1.449239764905875e-19,   3.643709442105710e-21,
   4.391725136661163e-23,  -1.021123249142007e-24,   1.204109105164169e+00,  -1.223481137590821e-02,  -3.074939098349626e-05,   1.251101039090276e-06,   6.639764760602442e-09,
  -2.344726990632814e-10,  -1.714053775477001e-12,   5.338200097386979e-14,   4.764186183518088e-16,  -1.365445325626882e-17,  -1.444738794483807e-19,   3.631367714133534e-21,
   4.373468917505188e-23,  -1.015764711491202e-24,   1.204105932668591e+00,  -1.223442386201673e-02,  -3.074527931059880e-05,   1.250859016595944e-06,   6.637112216893469e-09,
  -2.343570532400157e-10,  -1.712678597696356e-12,   5.333132641970412e-14,   4.757489378870896e-16,  -1.363388358982438e-17,  -1.441768069794216e-19,   3.623224439077683e-21,
   4.361428174403199e-23,  -1.012230312267160e-24,   1.204104303495070e+00,  -1.223422486478825e-02,  -3.074316798245187e-05,   1.250734741922720e-06,   6.635750284474378e-09,
  -2.342976778038323e-10,  -1.711972628759906e-12,   5.330531251151867e-14,   4.754052036311201e-16,  -1.362332606781741e-17,  -1.440243522294222e-19,   3.619046160507183e-21,
   4.355251669854473e-23,  -1.010417214984701e-24,   1.204103736455023e+00,  -1.223415560352415e-02,  -3.074243314920206e-05,   1.250691489445298e-06,   6.635276295307773e-09,
  -2.342770139041791e-10,  -1.711726949701653e-12,   5.329625970825143e-14,   4.752855922168456e-16,  -1.361965237819357e-17,  -1.439713058525524e-19,   3.617592458408841e-21,
   4.353102993415955e-23,  -1.009786465861309e-24,   1.204103646473991e+00,  -1.223414461278870e-02,  -3.074231654289236e-05,   1.250684625989625e-06,   6.635201081838101e-09,
  -2.342737349353949e-10,  -1.711687965712424e-12,   5.329482322784603e-14,   4.752666128827410e-16,  -1.361906945946032e-17,  -1.439628889249987e-19,   3.617361803721123e-21,
   4.352762080856854e-23,  -1.009686389660121e-24,   1.512414728322301e+00,  -1.013416787091325e-02,  -9.452075414123160e-05,   2.864353287295385e-07,   1.932930228710605e-08,
   1.338421869866165e-10,  -3.266327103533828e-12,  -6.977118975918110e-14,   1.470802296229122e-16,   2.173221825020681e-17,   1.936218179634748e-19,  -4.639661853020934e-21,
  -1.152178275813117e-22,   1.915321077363697e-25,   1.512405888792700e+00,  -1.013408687344509e-02,  -9.450990732774978e-05,   2.865596614878520e-07,   1.932471380800697e-08,
   1.337059806079520e-10,  -3.265924677528934e-12,  -6.969846534282632e-14,   1.478747414247917e-16,   2.170835986515416e-17,   1.929248891958309e-19,  -4.638031424307367e-21,
  -1.148720324212553e-22,   1.957329037890350e-25,   1.512390292127069e+00,  -1.013394392390509e-02,  -9.449077005167423e-05,   2.867789451394430e-07,   1.931661783081979e-08,
   1.334657584029509e-10,  -3.265212908408938e-12,  -6.957020738037079e-14,   1.492742936751618e-16,   2.166626843745356e-17,   1.916968798824216e-19,  -4.635129860914898e-21,
  -1.142625068713222e-22,   2.031209264316119e-25,   1.512371433876214e+00,  -1.013377101967010e-02,  -9.446763262829714e-05,   2.870439289325450e-07,   1.930682888520593e-08,
   1.331754770223854e-10,  -3.264349364916313e-12,  -6.941522800500822e-14,   1.509625994406789e-16,   2.161538315521321e-17,   1.902149096998030e-19,  -4.631579334147965e-21,
  -1.135265457324945e-22,   2.120131524255759e-25,   1.512353128082698e+00,  -1.013360311685742e-02,  -9.444517496204639e-05,   2.873009860262004e-07,   1.929732678200717e-08,
   1.328938840056603e-10,  -3.263508056400055e-12,  -6.926489347873042e-14,   1.525973438464051e-16,   2.156599738741377e-17,   1.887793270000099e-19,  -4.628088766184862e-21,
  -1.128132224240582e-22,   2.206022491619243e-25,   1.512338382226630e+00,  -1.013346782045641e-02,  -9.442708604048529e-05,   2.875079356772364e-07,   1.928967261122918e-08,
   1.326671846715904e-10,  -3.262828166083141e-12,  -6.914386959136756e-14,   1.539112429638400e-16,   2.152622207730517e-17,   1.876250510317055e-19,  -4.625245531738671e-21,
  -1.122393918365513e-22,   2.274905323918270e-25,   1.512328638943228e+00,  -1.013337840134562e-02,  -9.441513451663860e-05,   2.876446196129348e-07,   1.928461516577629e-08,
   1.325174583944356e-10,  -3.262377858599516e-12,  -6.906394011579006e-14,   1.547779621362496e-16,   2.149994380175264e-17,   1.868634076981518e-19,  -4.623351494077463e-21,
  -1.118606131259432e-22,   2.320270416776753e-25,   1.512323635460447e+00,  -1.013333247489365e-02,  -9.440899724341569e-05,   2.877147933474282e-07,   1.928201801664456e-08,
   1.324405892349810e-10,  -3.262146280300607e-12,  -6.902290516969300e-14,   1.552226059065500e-16,   2.148645005956961e-17,   1.864726017479419e-19,  -4.622374097543612e-21,
  -1.116662153307289e-22,   2.343520774151063e-25,   1.512321893977828e+00,  -1.013331648890232e-02,  -9.440686117392270e-05,   2.877392147736924e-07,   1.928111406961722e-08,
   1.324138377933455e-10,  -3.262065625817798e-12,  -6.900862459696353e-14,   1.553772953570847e-16,   2.148175366393442e-17,   1.863366313711384e-19,  -4.622033155362059e-21,
  -1.115985730120467e-22,   2.351605829673169e-25,   1.512321617629725e+00,  -1.013331395210440e-02,  -9.440652221218200e-05,   2.877430899665251e-07,   1.928097062636246e-08,
   1.324095928776094e-10,  -3.262052824616106e-12,  -6.900635856245313e-14,   1.554018389829092e-16,   2.148100842131358e-17,   1.863150572708483e-19,  -4.621979016924655e-21,
  -1.115878400388296e-22,   2.352888463321797e-25,   1.780100421006457e+00,  -5.759544777430528e-03,  -9.488044726802305e-05,  -9.861623267626175e-07,  -1.499772826008665e-09,
   1.846575039802261e-10,   4.098162896478701e-12,   3.590210627145885e-14,  -3.999456255109706e-16,  -1.938337718912995e-17,  -3.051760474706639e-19,  -7.128435514829304e-22,
   8.165004185576415e-23,   2.074927287712646e-24,   1.780091524354372e+00,  -5.759821523083220e-03,  -9.488125843734222e-05,  -9.859886262088586e-07,  -1.494022561780272e-09,
   1.847271441290226e-10,   4.097086843378054e-12,   3.583660924438636e-14,  -4.012165576087997e-16,  -1.938646809032252e-17,  -3.046632206639957e-19,  -6.977966609400599e-22,
   8.181573798498736e-23,   2.072669681491879e-24,   1.780075826013612e+00,  -5.760309805329297e-03,  -9.488268713173267e-05,  -9.856820760866116e-07,  -1.483877370459469e-09,
   1.848499203969098e-10,   4.095185428430137e-12,   3.572103065641297e-14,  -4.034573717407108e-16,  -1.939185908718447e-17,  -3.037575059027489e-19,  -6.712598442500022e-22,
   8.210723005994990e-23,   2.068668492117894e-24,   1.780056843313144e+00,  -5.760900173547822e-03,  -9.488441024601710e-05,  -9.853113024936466e-07,  -1.471611813762269e-09,
   1.849982039509322e-10,   4.092881612059374e-12,   3.558125817945465e-14,  -4.061639758028538e-16,  -1.939827064803968e-17,  -3.026609043370010e-19,  -6.391946020050826e-22,
   8.245820251886787e-23,   2.063800234569028e-24,   1.780038415132523e+00,  -5.761473221690456e-03,  -9.488607832647198e-05,  -9.849512678248663e-07,  -1.459706843275241e-09,
   1.851419677881375e-10,   4.090640287892697e-12,   3.544555537308410e-14,  -4.087883432466821e-16,  -1.940438257776261e-17,  -3.015948786537556e-19,  -6.080907732275487e-22,
   8.279734659639758e-23,   2.059042881897279e-24,   1.780023569555757e+00,  -5.761934810868523e-03,  -9.488741875104846e-05,  -9.846611612169221e-07,  -1.450117946124986e-09,
   1.852576478798300e-10,   4.088831255742497e-12,   3.533622495687446e-14,  -4.109002358804391e-16,  -1.940922584023737e-17,  -3.007350561041689e-19,  -5.830515896714074e-22,
   8.306942887433688e-23,   2.055188012231036e-24,   1.780013759826856e+00,  -5.762239795823423e-03,  -9.488830283504785e-05,  -9.844694309766378e-07,  -1.443782554082627e-09,
   1.853340215196268e-10,   4.087634190984521e-12,   3.526397651200677e-14,  -4.122946278734135e-16,  -1.941238681628222e-17,  -3.001663895742532e-19,  -5.665148141025550e-22,
   8.324866377444276e-23,   2.052629828099529e-24,   1.780008722050490e+00,  -5.762396412473786e-03,  -9.488875634588077e-05,  -9.843709581347858e-07,  -1.440529268632436e-09,
   1.853732227177903e-10,   4.087018918957879e-12,   3.522687198675337e-14,  -4.130103717531763e-16,  -1.941399795766847e-17,  -2.998741942721981e-19,  -5.580250756364694e-22,
   8.334053868551053e-23,   2.051312693799379e-24,   1.780006968604510e+00,  -5.762450923104589e-03,  -9.488891411351178e-05,  -9.843366821385853e-07,  -1.439396971300595e-09,
   1.853868638187419e-10,   4.086804684809909e-12,   3.521395718025391e-14,  -4.132594383255520e-16,  -1.941455679280852e-17,  -2.997724679157715e-19,  -5.550705726868471e-22,
   8.337248939971764e-23,   2.050853714669892e-24,   1.780006690356697e+00,  -5.762459573132637e-03,  -9.488893914521827e-05,  -9.843312429330605e-07,  -1.439217293134494e-09,
   1.853890283200144e-10,   4.086770684857171e-12,   3.521190776710805e-14,  -4.132989591662009e-16,  -1.941464538028093e-17,  -2.997563241525788e-19,  -5.546017541001156e-22,
   8.337755824722227e-23,   2.050780855446494e-24,   1.955504466089890e+00,  -1.342265225829015e-03,  -2.944513155654336e-05,  -5.500375916816013e-07,  -9.075639438585743e-09,
  -1.317679779250970e-10,  -1.610043369373764e-12,  -1.401590272281349e-14,  -4.775685207278979e-19,   3.580357451711423e-18,   1.040336962229450e-19,   2.069668307844962e-21,
   3.196544294806808e-23,   3.586243540509214e-25,   1.955501695340186e+00,  -1.342420359580499e-03,  -2.945024937319943e-05,  -5.501613540645176e-07,  -9.077903449073811e-09,
  -1.317953743680491e-10,  -1.610035407467662e-12,  -1.400353783088440e-14,  -3.229863458578036e-20,   3.591129733264872e-18,   1.042319990719379e-19,   2.072258285125769e-21,
   3.197683283484039e-23,   3.580420356918495e-25,   1.955496805917072e+00,  -1.342694123868777e-03,  -2.945928087667162e-05,  -5.503797555597356e-07,  -9.081898318519678e-09,
  -1.318436958933417e-10,  -1.610020404422368e-12,  -1.398169015245501e-14,   7.540676945456049e-19,   3.610148417591724e-18,   1.045819631222159e-19,   2.076824824185260e-21,
   3.199677263852265e-23,   3.570104715681646e-25,   1.955490892906508e+00,  -1.343025210902119e-03,  -2.947020363272703e-05,  -5.506438844767450e-07,  -9.086728934972348e-09,
  -1.319020927843839e-10,  -1.610000634701908e-12,  -1.395522116076565e-14,   1.706110886824758e-18,   3.633164459628551e-18,   1.050052375687055e-19,   2.082340719370201e-21,
   3.202061459218448e-23,   3.557561750672207e-25,   1.955485151958728e+00,  -1.343346675078807e-03,  -2.948080910410351e-05,  -5.509003334144686e-07,  -9.091418389429890e-09,
  -1.319587478150675e-10,  -1.609979736631386e-12,  -1.392947256515440e-14,   2.631553496142104e-18,   3.655527338013878e-18,   1.054162429991512e-19,   2.087689137430929e-21,
   3.204347730793113e-23,   3.545312742880310e-25,   1.955480526624629e+00,  -1.343605678708143e-03,  -2.948935405863291e-05,  -5.511069519573159e-07,  -9.095196134817036e-09,
  -1.320043627912522e-10,  -1.609961678201506e-12,  -1.390869186985523e-14,   3.377949084924503e-18,   3.673556403493727e-18,   1.057474132996508e-19,   2.091993212091693e-21,
   3.206169238370235e-23,   3.535393096937100e-25,   1.955477470040821e+00,  -1.343776841451946e-03,  -2.949500106097426e-05,  -5.512434948366010e-07,  -9.097692392516883e-09,
  -1.320344918185552e-10,  -1.609949146232012e-12,  -1.389494176225712e-14,   3.871580532414246e-18,   3.685476452427448e-18,   1.059662786484219e-19,   2.094835038354703e-21,
   3.207362914076194e-23,   3.528812889356249e-25,   1.955475900262876e+00,  -1.343864747203276e-03,  -2.949790126746434e-05,  -5.513136201663442e-07,  -9.098974337398277e-09,
  -1.320499606361894e-10,  -1.609942525055856e-12,  -1.388787467204617e-14,   4.125215820974933e-18,   3.691600058832509e-18,   1.060786869230745e-19,   2.096293761309355e-21,
   3.207972845622047e-23,   3.525425753148464e-25,   1.955475353875202e+00,  -1.343895344479487e-03,  -2.949891074282646e-05,  -5.513380285707233e-07,  -9.099420529588831e-09,
  -1.320553440819788e-10,  -1.609940190970446e-12,  -1.388541399070745e-14,   4.213516908728029e-18,   3.693731768927259e-18,   1.061178133116690e-19,   2.096801373100455e-21,
   3.208184647608128e-23,   3.524245573739370e-25,   1.955475267170430e+00,  -1.343900199887342e-03,  -2.949907093417970e-05,  -5.513419018787772e-07,  -9.099491334122223e-09,
  -1.320561983313477e-10,  -1.609939819181477e-12,  -1.388502347098579e-14,   4.227530072342771e-18,   3.694070057758904e-18,   1.061240222093724e-19,   2.096881918872024e-21,
   3.208218234386462e-23,   3.524058235904369e-25,   7.295982489703918e-03,  -1.400069458415891e-04,   2.008328056372667e-06,  -2.553193030679359e-08,   3.025472514977497e-10,
  -3.427665468340299e-12,   3.737442949569390e-14,  -3.985126439354854e-16,   4.079279136676877e-18,  -4.223095087572911e-20,   3.995936788109789e-22,  -3.795736241678950e-24,
   5.096092291467429e-26,   1.029489089293544e-28,   7.296171112326011e-03,  -1.400141380264313e-04,   2.008498536324848e-06,  -2.553515035474680e-08,   3.025999362885116e-10,
  -3.428452314925733e-12,   3.738517264169431e-14,  -3.986556825163123e-16,   4.080975174011899e-18,  -4.225049614079984e-20,   3.999121313594692e-22,  -3.795046280651831e-24,
   5.102902643785752e-26,   1.018180058522737e-28,   7.296503952944440e-03,  -1.400268294873619e-04,   2.008799375010456e-06,  -2.554083278053233e-08,   3.026929117283412e-10,
  -3.429840947323832e-12,   3.740413271790759e-14,  -3.989081299570164e-16,   4.083968953602634e-18,  -4.228498124146068e-20,   4.004743846930168e-22,  -3.793835632178809e-24,
   5.114885237847466e-26,   9.981690871167658e-29,   7.296906449602522e-03,  -1.400421773953406e-04,   2.009163193507640e-06,  -2.554770505455540e-08,   3.028053595950568e-10,
  -3.431520487354078e-12,   3.742706562903152e-14,  -3.992134835117512e-16,   4.087590931781676e-18,  -4.232667619294543e-20,   4.011548439356580e-22,  -3.792383317908466e-24,
   5.129316150930575e-26,   9.738763870042580e-29,   7.297297209667512e-03,  -1.400570781960318e-04,   2.009516425297803e-06,  -2.555437761174586e-08,   3.029145440023577e-10,
  -3.433151365161915e-12,   3.744933498046158e-14,  -3.995100111763131e-16,   4.091109042567077e-18,  -4.236714792797123e-20,   4.018160241928917e-22,  -3.790985628032152e-24,
   5.143264167256901e-26,   9.501940977917010e-29,   7.297612017573031e-03,  -1.400690830312191e-04,   2.009801015112328e-06,  -2.555975370561740e-08,   3.030025172812596e-10,
  -3.434465472516006e-12,   3.746727952348673e-14,  -3.997489585846445e-16,   4.093944589805220e-18,  -4.239974786511185e-20,   4.023490928252547e-22,  -3.789868422774934e-24,
   5.154456659578979e-26,   9.310450161278550e-29,   7.297820045195789e-03,  -1.400770160746608e-04,   2.009989082112104e-06,  -2.556330650903381e-08,   3.030606561646720e-10,
  -3.435333954924017e-12,   3.747913923182558e-14,  -3.999068843511229e-16,   4.095818956109989e-18,  -4.242128758385017e-20,   4.027015453960687e-22,  -3.789134488534287e-24,
   5.161831009003076e-26,   9.183570124711991e-29,   7.297926879859620e-03,  -1.400810902149999e-04,   2.010085668191504e-06,  -2.556513115998499e-08,   3.030905156471090e-10,
  -3.435780006634330e-12,   3.748523046289713e-14,  -3.999879971718937e-16,   4.096781745477447e-18,  -4.243234872379423e-20,   4.028826116060292e-22,  -3.788758908215000e-24,
   5.165611460718883e-26,   9.118304269039340e-29,   7.297964065044847e-03,  -1.400825082796133e-04,   2.010119286605454e-06,  -2.556576626499029e-08,   3.031009088929655e-10,
  -3.435935266091987e-12,   3.748735068364244e-14,  -4.000162308849578e-16,   4.097116886982951e-18,  -4.243619856960853e-20,   4.029456436906710e-22,  -3.788628395942285e-24,
   5.166926226487000e-26,   9.095570893080974e-29,   7.297969965840709e-03,  -1.400827333080179e-04,   2.010124621420091e-06,  -2.556586704828762e-08,   3.031025581759636e-10,
  -3.435959903965533e-12,   3.748768713879126e-14,  -4.000207112648518e-16,   4.097170070931270e-18,  -4.243680948307452e-20,   4.029556465047463e-22,  -3.788607695504603e-24,
   5.167134811626773e-26,   9.091962612880299e-29,   6.555964592297576e-02,  -1.236570746206749e-03,   1.705255148925288e-05,  -2.017776169891381e-07,   2.123465428745062e-09,
  -1.993042493768376e-11,   1.596179204382197e-13,  -9.823294737632602e-16,   1.285996806458736e-18,   6.781067200917772e-20,  -1.687184152731579e-21,   2.371641939591458e-23,
  -1.247020300365824e-25,   6.343659279033606e-27,   6.556124699690186e-02,  -1.236627561924748e-03,   1.705374720346141e-05,  -2.017963179513462e-07,   2.123689928951360e-09,
  -1.993235519587254e-11,   1.596211485935017e-13,  -9.820973717997540e-16,   1.278854652857452e-18,   6.793474489771523e-20,  -1.687943618011499e-21,   2.376237254623893e-23,
  -1.244356571431524e-25,   6.335858791436735e-27,   6.556407220836229e-02,  -1.236727818433413e-03,   1.705585716270095e-05,  -2.018293175639419e-07,   2.124086066735733e-09,
  -1.993576079376116e-11,   1.596268294673049e-13,  -9.816874824742465e-16,   1.266249615938288e-18,   6.815386565337601e-20,  -1.689282401730846e-21,   2.384341050059434e-23,
  -1.239688278260742e-25,   6.322040508107456e-27,   6.556748863997770e-02,  -1.236849056973651e-03,   1.705840872308441e-05,  -2.018692235553511e-07,   2.124565086969342e-09,
  -1.993987824265576e-11,   1.596336728224094e-13,  -9.811912568332148e-16,   1.251003049736910e-18,   6.841915637927972e-20,  -1.690899059620695e-21,   2.394132192871050e-23,
  -1.234097667025940e-25,   6.305239130732949e-27,   6.557080541573909e-02,  -1.236966760893376e-03,   1.706088591713023e-05,  -2.019079662263848e-07,   2.125030117989488e-09,
  -1.994387472379598e-11,   1.596402889822601e-13,  -9.807089185051182e-16,   1.236197321514778e-18,   6.867703887438288e-20,  -1.692466178940008e-21,   2.403628803717172e-23,
  -1.228727236616464e-25,   6.288832458023451e-27,   6.557347748401685e-02,  -1.237061587117206e-03,   1.706288164384101e-05,  -2.019391786992261e-07,   2.125404745556340e-09,
  -1.994709375880857e-11,   1.596455993460729e-13,  -9.803199148698616e-16,   1.224266707808228e-18,   6.888503118694200e-20,  -1.693726988795776e-21,   2.411273067962975e-23,
  -1.224441566383711e-25,   6.275546766919580e-27,   6.557524319635244e-02,  -1.237124249278321e-03,   1.706420044883760e-05,  -2.019598042661147e-07,   2.125652295038765e-09,
  -1.994922060551356e-11,   1.596490987768237e-13,  -9.800626535363663e-16,   1.216381550443597e-18,   6.902258896913867e-20,  -1.694559309939178e-21,   2.416321275819190e-23,
  -1.221629570732885e-25,   6.266734279024676e-27,   6.557614999181891e-02,  -1.237156430125679e-03,   1.706487773820330e-05,  -2.019703967663805e-07,   2.125779424240802e-09,
  -1.995031277057813e-11,   1.596508929442001e-13,  -9.799304711182721e-16,   1.212331643963254e-18,   6.909326862441059e-20,  -1.694986500249597e-21,   2.418912847041361e-23,
  -1.220191626396552e-25,   6.262198291905580e-27,   6.557646561310243e-02,  -1.237167631096341e-03,   1.706511347813717e-05,  -2.019740836284358e-07,   2.125823672834825e-09,
  -1.995069289708841e-11,   1.596515169496812e-13,  -9.798844532415092e-16,   1.210921957204067e-18,   6.911787523942799e-20,  -1.695135148593814e-21,   2.419814719717976e-23,
  -1.219692115436529e-25,   6.260617853593342e-27,   6.557651569798706e-02,  -1.237169408542390e-03,   1.706515088696839e-05,  -2.019746686848198e-07,   2.125830694482565e-09,
  -1.995075321738240e-11,   1.596516159484011e-13,  -9.798771503361247e-16,   1.210698255545724e-18,   6.912178025106846e-20,  -1.695158735181508e-21,   2.419957827489419e-23,
  -1.219612896383200e-25,   6.260366981671920e-27,   1.814708396688825e-01,  -3.299958316362306e-03,   4.168488986605454e-05,  -4.128391816888165e-07,   2.991699163813214e-09,
  -8.702580433215248e-12,  -1.818832765160984e-13,   4.159014995111519e-15,  -5.361817577233376e-17,   4.022568429550782e-19,  -9.854192307189299e-22,  -4.118938986466027e-23,
   1.314497590387489e-24,  -1.442893653085335e-28,   1.814747509948706e-01,  -3.300074455633556e-03,   4.168657123947552e-05,  -4.128472712968529e-07,   2.991441725425320e-09,
  -8.694370894425915e-12,  -1.820241035332086e-13,   4.160367069999712e-15,  -5.362206819618592e-17,   4.020443640681558e-19,  -9.771971594664395e-22,  -4.119167654981592e-23,
   1.316426027143773e-24,  -1.664276509896014e-28,   1.814816527191918e-01,  -3.300279387045573e-03,   4.168953793124968e-05,  -4.128615392738568e-07,   2.990987310296475e-09,
  -8.679882872460488e-12,  -1.822726031701981e-13,   4.162752244352817e-15,  -5.362890816141295e-17,   4.016694308673087e-19,  -9.626796025872606e-22,  -4.119584473365676e-23,
   1.319818076889179e-24,  -2.056158789977162e-28,   1.814899985763699e-01,  -3.300527195436394e-03,   4.169312508525788e-05,  -4.128787815829446e-07,   2.990437552068609e-09,
  -8.662360116394362e-12,  -1.825731054411481e-13,   4.165635428481753e-15,  -5.363713088194276e-17,   4.012160387285161e-19,  -9.451085150270923e-22,  -4.120111272249618e-23,
   1.323901534752614e-24,  -2.532148391149555e-28,   1.814981008187375e-01,  -3.300767766817297e-03,   4.169660722132520e-05,  -4.128955089315071e-07,   2.989903568732006e-09,
  -8.645345469929045e-12,  -1.828648422998693e-13,   4.168433332598886e-15,  -5.364506281334098e-17,   4.007758731972592e-19,  -9.280337823449530e-22,  -4.120646595973135e-23,
   1.327846594142147e-24,  -2.996442311847593e-28,   1.815046280436724e-01,  -3.300961570345865e-03,   4.169941223366797e-05,  -4.129089762497819e-07,   2.989473192654891e-09,
  -8.631635928190332e-12,  -1.830998720396701e-13,   4.170686541786389e-15,  -5.365141643995293e-17,   4.004212666828958e-19,  -9.142664344514293e-22,  -4.121095026836991e-23,
   1.331011014826511e-24,  -3.372048906963118e-28,   1.815089411978547e-01,  -3.301089633416637e-03,   4.170126566181020e-05,  -4.129178712884357e-07,   2.989188706922393e-09,
  -8.622575554229585e-12,  -1.832551805429030e-13,   4.172175057016399e-15,  -5.365559705394655e-17,   4.001869415857447e-19,  -9.051632731176400e-22,  -4.121399772349608e-23,
   1.333095319799304e-24,  -3.621012573312406e-28,   1.815111562337136e-01,  -3.301155400287133e-03,   4.170221746294173e-05,  -4.129224381023583e-07,   2.989042578685697e-09,
  -8.617922200297306e-12,  -1.833349404454165e-13,   4.172939367847530e-15,  -5.365773850841834e-17,   4.000666021086350e-19,  -9.004865290875224e-22,  -4.121558884775063e-23,
   1.334163642773320e-24,  -3.749104704250397e-28,   1.815119272011786e-01,  -3.301178291105363e-03,   4.170254874239539e-05,  -4.129240274304814e-07,   2.988991712447443e-09,
  -8.616302491244718e-12,  -1.833627018571562e-13,   4.173205375247735e-15,  -5.365848298695468e-17,   4.000247164783477e-19,  -8.988584535998463e-22,  -4.121614681332309e-23,
   1.334535153323038e-24,  -3.793726080168039e-28,   1.815120495432849e-01,  -3.301181923565649e-03,   4.170260131170911e-05,  -4.129242796257899e-07,   2.988983640440160e-09,
  -8.616045462563339e-12,  -1.833671072225947e-13,   4.173247586104874e-15,  -5.365860108393613e-17,   4.000180697879066e-19,  -8.986000865898694e-22,  -4.121623555234263e-23,
   1.334594091311567e-24,  -3.800808668387522e-28,   3.534813670045352e-01,  -6.049161112477248e-03,   6.510983988900003e-05,  -4.206321392145276e-07,  -5.230163371269139e-10,
   5.662198981517366e-11,  -8.082817260560728e-13,   4.720611270218206e-15,   4.058359419506430e-17,  -1.484882329601528e-18,   1.698442149679153e-20,  -5.380335369096797e-23,
  -1.191187524891596e-24,   6.830472009381272e-26,   3.534874704364574e-01,  -6.049279227769176e-03,   6.510953928484806e-05,  -4.205789788145695e-07,  -5.241517015102496e-10,
   5.663120366598984e-11,  -8.081737201555396e-13,   4.715593150317417e-15,   4.065500826237934e-17,  -1.485140439806206e-18,   1.697700169805218e-20,  -5.330657329801708e-23,
  -1.192232181844921e-24,   6.825654327093018e-26,   3.534982400145882e-01,  -6.049487631894146e-03,   6.510900834516861e-05,  -4.204851694530172e-07,  -5.261549457946628e-10,
   5.664745361570086e-11,  -8.079829897798165e-13,   4.706737904642003e-15,   4.078099401664261e-17,  -1.485593799598269e-18,   1.696390393877624e-20,  -5.243028935397126e-23,
  -1.194089294619201e-24,   6.817105358882523e-26,   3.535112626634144e-01,  -6.049739615644012e-03,   6.510836544246523e-05,  -4.203717222401323e-07,  -5.285770785847462e-10,
   5.666708952741726e-11,  -8.077520969841973e-13,   4.696028867248170e-15,   4.093329385965212e-17,  -1.486138461850163e-18,   1.694805672044515e-20,  -5.137117876656431e-23,
  -1.196358429293419e-24,   6.806686028952593e-26,   3.535239047834289e-01,  -6.049984215381482e-03,   6.510774039717652e-05,  -4.202615771613837e-07,  -5.309282214305252e-10,
   5.668613738200570e-11,  -8.075276784651104e-13,   4.685631488721157e-15,   4.108109836555251e-17,  -1.486663499071228e-18,   1.693266274963665e-20,  -5.034353999765624e-23,
  -1.198585824506214e-24,   6.796485658868635e-26,   3.535340890807627e-01,  -6.050181246182238e-03,   6.510723620504062e-05,  -4.201728367742825e-07,  -5.328221125493283e-10,
   5.670147180455895e-11,  -8.073466951215816e-13,   4.677254617725223e-15,   4.120013510858691e-17,  -1.487083803746894e-18,   1.692025452745609e-20,  -4.951606723374238e-23,
  -1.200397750065100e-24,   6.788207294837650e-26,   3.535408186682458e-01,  -6.050311433003089e-03,   6.510690271886899e-05,  -4.201141943296082e-07,  -5.340734841772291e-10,
   5.671159948349643e-11,  -8.072270092340307e-13,   4.671718902090667e-15,   4.127877647932845e-17,  -1.487360232237518e-18,   1.691205193142909e-20,  -4.896947456882315e-23,
  -1.201603625869977e-24,   6.782707256908851e-26,   3.535442746288481e-01,  -6.050378287807454e-03,   6.510673135725993e-05,  -4.200840772748000e-07,  -5.347160992882489e-10,
   5.671679897425729e-11,  -8.071655153288499e-13,   4.668875915019636e-15,   4.131915764045232e-17,  -1.487501789105649e-18,   1.690783843101189e-20,  -4.868883093822807e-23,
  -1.202225553928484e-24,   6.779873508676712e-26,   3.535454775068568e-01,  -6.050401556859050e-03,   6.510667169728264e-05,  -4.200735945426156e-07,  -5.349397635256192e-10,
   5.671860845675602e-11,  -8.071441071197786e-13,   4.667886366311806e-15,   4.133321188594364e-17,  -1.487550995215093e-18,   1.690637171215911e-20,  -4.859115957665773e-23,
  -1.202442443828243e-24,   6.778885730717507e-26,   3.535456683869960e-01,  -6.050405249319254e-03,   6.510666222930634e-05,  -4.200719310671608e-07,  -5.349752557775666e-10,
   5.671889558494036e-11,  -8.071407097090875e-13,   4.667729337562706e-15,   4.133544206376072e-17,  -1.487558800506211e-18,   1.690613895593148e-20,  -4.857566091489706e-23,
  -1.202476881303983e-24,   6.778728914390700e-26,   5.783491757689354e-01,  -9.009539288618877e-03,   7.215918173253840e-05,  -9.672898855100571e-09,  -8.218029732847467e-09,
   9.840997399561501e-11,   4.113728488783461e-14,  -1.727980961751469e-14,   2.165648855379493e-16,   1.455520235606912e-19,  -4.627799110655455e-20,   5.988236415102013e-22,
   2.110948018178912e-24,  -8.983158161053363e-26,   5.783559314000402e-01,  -9.009541685219443e-03,   7.215455946768922e-05,  -9.580925626219601e-09,  -8.217965214654722e-09,
   9.837596369748158e-11,   4.170174521150216e-14,  -1.727923866166082e-14,   2.163701043904992e-16,   1.486140446250776e-19,  -4.626402001283454e-20,   5.981645709911495e-22,
   2.130681501966700e-24,  -8.987088660360305e-26,   5.783678514653230e-01,  -9.009545893078294e-03,   7.214640343959778e-05,  -9.418663333927263e-09,  -8.217850727529024e-09,
   9.831595294358619e-11,   4.269732893604416e-14,  -1.727822281809418e-14,   2.160264587019475e-16,   1.540142639485596e-19,  -4.623926930735819e-20,   5.970013954022845e-22,
   2.165431157062263e-24,  -8.994036077520063e-26,   5.783822647353030e-01,  -9.009550945496648e-03,   7.213654113626015e-05,  -9.222498226431004e-09,  -8.217711191134657e-09,
   9.824338893153570e-11,   4.390049119963465e-14,  -1.727698016071828e-14,   2.156110019490690e-16,   1.605395515945186e-19,  -4.620917279693869e-20,   5.955944693901507e-22,
   2.207330853505138e-24,  -9.002457212617967e-26,   5.783962562596600e-01,  -9.009555812844603e-03,   7.212696703862566e-05,  -9.032110810391724e-09,  -8.217574582910668e-09,
   9.817294676621351e-11,   4.506775875628477e-14,  -1.727575885432384e-14,   2.152077712340769e-16,   1.668692492496488e-19,  -4.617978032811460e-20,   5.942282287550886e-22,
   2.247880809994134e-24,  -9.010653251049263e-26,   5.784075271993118e-01,  -9.009559707086006e-03,   7.211925431018575e-05,  -8.878770339073187e-09,  -8.217463710349079e-09,
   9.811620071557012e-11,   4.600756307310912e-14,  -1.727476427443990e-14,   2.148829967204712e-16,   1.719648322383231e-19,  -4.615597675509051e-20,   5.931273008471346e-22,
   2.280457429129841e-24,  -9.017270702881644e-26,   5.784149746149152e-01,  -9.009562267195743e-03,   7.211415789633974e-05,  -8.777461920719536e-09,  -8.217390045011788e-09,
   9.807870454747706e-11,   4.662830893738397e-14,  -1.727410183110389e-14,   2.146684223915546e-16,   1.753301696052773e-19,  -4.614018647537038e-20,   5.923996791550376e-22,
   2.301939483478679e-24,  -9.021650586522398e-26,   5.784187991509714e-01,  -9.009563577872597e-03,   7.211154065008627e-05,  -8.725440220762042e-09,  -8.217352089815443e-09,
   9.805944866078758e-11,   4.694701121182501e-14,  -1.727376001381346e-14,   2.145582377755659e-16,   1.770578953396318e-19,  -4.613205847148255e-20,   5.920259647505956e-22,
   2.312957944904332e-24,  -9.023902074449330e-26,   5.784201303049119e-01,  -9.009564033419031e-03,   7.211062969453398e-05,  -8.707334390926018e-09,  -8.217338859340116e-09,
   9.805274650335716e-11,   4.705792565321092e-14,  -1.727364078315514e-14,   2.145198885358939e-16,   1.776591607622613e-19,  -4.612922643173271e-20,   5.918958827271999e-22,
   2.316790856359947e-24,  -9.024686075617006e-26,   5.784203415401938e-01,  -9.009564105677279e-03,   7.211048513848001e-05,  -8.704461283030945e-09,  -8.217336758904941e-09,
   9.805168296471500e-11,   4.707552563969022e-14,  -1.727362185064340e-14,   2.145138031121395e-16,   1.777545692525421e-19,  -4.612877688299790e-20,   5.918752401548670e-22,
   2.317398983851296e-24,  -9.024810502401452e-26,   8.496204241149221e-01,  -1.146008164335352e-02,   4.714977714423994e-05,   7.746826252802002e-07,  -1.167034798196244e-08,
  -4.114085841285754e-11,   2.463606672857388e-12,  -1.245328228950422e-14,  -4.237825923520236e-16,   6.268832813423667e-18,   3.730305847891026e-20,  -1.856086330734340e-21,
   9.705394145112601e-24,   4.638212110406537e-25,   8.496248312594534e-01,  -1.145986390090613e-02,   4.714323206078338e-05,   7.746438527857673e-07,  -1.166689665324174e-08,
  -4.116504368607235e-11,   2.462497540144113e-12,  -1.243237058066021e-14,  -4.236233527595233e-16,   6.259392954657201e-18,   3.736140804289405e-20,  -1.852725761736934e-21,
   9.668540537744153e-24,   4.632600066124092e-25,   8.496326072388887e-01,  -1.145947969982723e-02,   4.713168473313933e-05,   7.745754197766806e-07,  -1.166080799608422e-08,
  -4.120768563124335e-11,   2.460540798960535e-12,  -1.239549734687628e-14,  -4.233421733519322e-16,   6.242750230764935e-18,   3.746418223482339e-20,  -1.846799346338451e-21,
   9.603589411917571e-24,   4.622678813713954e-25,   8.496420091899463e-01,  -1.145901513494709e-02,   4.711772426641972e-05,   7.744926386094673e-07,  -1.165344768629639e-08,
  -4.125919189082258e-11,   2.458175268229924e-12,  -1.235095381267136e-14,  -4.230018299398637e-16,   6.222649627160622e-18,   3.758814351032620e-20,  -1.839638800628742e-21,
   9.525182015143659e-24,   4.610650137320347e-25,   8.496511355550921e-01,  -1.145856415929199e-02,   4.710417449844007e-05,   7.744122433916514e-07,  -1.164630468602792e-08,
  -4.130913379378875e-11,   2.455879461374044e-12,  -1.230775773627210e-14,  -4.226710767668797e-16,   6.203161383177268e-18,   3.770815409943220e-20,  -1.832693486333081e-21,
   9.449203665002266e-24,   4.598939758899897e-25,   8.496584870012911e-01,  -1.145820087055575e-02,   4.709326099560265e-05,   7.743474546403754e-07,  -1.164055199770657e-08,
  -4.134932374787490e-11,   2.454030426140105e-12,  -1.227299248513785e-14,  -4.224043732898192e-16,   6.187479863993988e-18,   3.780459767321956e-20,  -1.827102751168499e-21,
   9.388095337823615e-24,   4.589482381997166e-25,   8.496633443951555e-01,  -1.145796082140685e-02,   4.708605053332645e-05,   7.743046319321656e-07,  -1.163675151674518e-08,
  -4.137585970891285e-11,   2.452808830625614e-12,  -1.225003634830599e-14,  -4.222280166535560e-16,   6.177126584037376e-18,   3.786821070891068e-20,  -1.823410610725590e-21,
   9.347764371185797e-24,   4.583221577994657e-25,   8.496658388032041e-01,  -1.145783754640768e-02,   4.708234792083289e-05,   7.742826368811176e-07,  -1.163480003314724e-08,
  -4.138948075037944e-11,   2.452181549090344e-12,  -1.223825225740772e-14,  -4.221374108512737e-16,   6.171812396585006e-18,   3.790084345281081e-20,  -1.821515175459210e-21,
   9.327067421020265e-24,   4.580002796127806e-25,   8.496667069894670e-01,  -1.145779463968991e-02,   4.708105924118370e-05,   7.742749807385008e-07,  -1.163412084044767e-08,
  -4.139422065286408e-11,   2.451963228550644e-12,  -1.223415148989755e-14,  -4.221058685885561e-16,   6.169963177489906e-18,   3.791219591342787e-20,  -1.820855556266810e-21,
   9.319866033700216e-24,   4.578881903731055e-25,   8.496668447579436e-01,  -1.145778783099775e-02,   4.708085474777551e-05,   7.742737657873527e-07,  -1.163401306377347e-08,
  -4.139497276141825e-11,   2.451928584588312e-12,  -1.223350079222456e-14,  -4.221008629771271e-16,   6.169669752418868e-18,   3.791399712369227e-20,  -1.820750888743122e-21,
   9.318723385468566e-24,   4.578704006695870e-25,   1.154787364487943e+00,  -1.242251525960488e-02,  -1.526740107249146e-05,   1.320194722273940e-06,   1.667910510293208e-09,
  -2.574562162730623e-10,  -8.408200847728714e-14,   6.044946892682527e-14,  -7.802245912651935e-17,  -1.601862017467887e-17,   4.156628887049020e-20,   4.362169606174311e-21,
  -1.760351749332796e-23,  -1.123254520907251e-24,   1.154785935053890e+00,  -1.242214480201872e-02,  -1.526646355678583e-05,   1.319954350165797e-06,   1.667789895540683e-09,
  -2.573380560832189e-10,  -8.428327476191499e-14,   6.039598317744513e-14,  -7.785045301466909e-17,  -1.599643898040236e-17,   4.146142963840411e-20,   4.354142556380331e-21,
  -1.751533165732874e-23,  -1.119851056611874e-24,   1.154783412866353e+00,  -1.242149117856062e-02,  -1.526480935126594e-05,   1.319530299592434e-06,   1.667576840193830e-09,
  -2.571296458918192e-10,  -8.463804723078879e-14,   6.030166736433973e-14,  -7.754730161610299e-17,  -1.595733337293089e-17,   4.127684357336250e-20,   4.339998754073504e-21,
  -1.736008066522128e-23,  -1.113858985984060e-24,   1.154780363131866e+00,  -1.242070090348285e-02,  -1.526280916330621e-05,   1.319017686168302e-06,   1.667318821692282e-09,
  -2.568777794771765e-10,  -8.506641995569271e-14,   6.018772299723719e-14,  -7.718133384473035e-17,  -1.591010344726022e-17,   4.105438863977618e-20,   4.322930055565910e-21,
  -1.717295283043689e-23,  -1.106636110497229e-24,   1.154777402629784e+00,  -1.241993381589769e-02,  -1.526086751506243e-05,   1.318520210155727e-06,   1.667067934070268e-09,
  -2.566334241148561e-10,  -8.548162615634037e-14,   6.007721589575009e-14,  -7.682669210048472e-17,  -1.586431306215473e-17,   4.083921552153050e-20,   4.306395738744585e-21,
  -1.699192315227799e-23,  -1.099648092829958e-24,   1.154775017779061e+00,  -1.241931593016143e-02,  -1.525930341991689e-05,   1.318119564710953e-06,   1.666865530385140e-09,
  -2.564366835989823e-10,  -8.581564516485976e-14,   5.998827022156663e-14,  -7.654145025418317e-17,  -1.582746758175299e-17,   4.066643426536272e-20,   4.293101424231953e-21,
  -1.684653924149856e-23,  -1.094035670852119e-24,   1.154773441956867e+00,  -1.241890767656574e-02,  -1.525826992870740e-05,   1.317854881512427e-06,   1.666731642826801e-09,
  -2.563067343094272e-10,  -8.603613113972756e-14,   5.992953438370981e-14,  -7.635318891889742e-17,  -1.580314161061680e-17,   4.055253695088115e-20,   4.284329251773494e-21,
  -1.675069279724714e-23,  -1.090335408173907e-24,   1.154772632710587e+00,  -1.241869802941403e-02,  -1.525773919234992e-05,   1.317718971394297e-06,   1.666662841016299e-09,
  -2.562400156217067e-10,  -8.614929081722194e-14,   5.989938243020102e-14,  -7.625657610467654e-17,  -1.579065550905277e-17,   4.049412970688164e-20,   4.279828174926230e-21,
  -1.670153924025646e-23,  -1.088437717953706e-24,   1.154772351047208e+00,  -1.241862506149105e-02,  -1.525755446642490e-05,   1.317671669397907e-06,   1.666638886890413e-09,
  -2.562167961962786e-10,  -8.618866587176556e-14,   5.988888963041910e-14,  -7.622296001058336e-17,  -1.578631063328756e-17,   4.047381397120643e-20,   4.278262147011810e-21,
  -1.668444174324052e-23,  -1.087777618638193e-24,   1.154772306351214e+00,  -1.241861348256674e-02,  -1.525752515304657e-05,   1.317664163353785e-06,   1.666635085367045e-09,
  -2.562131117178463e-10,  -8.619491361865437e-14,   5.988722465607309e-14,  -7.621762611581727e-17,  -1.578562121005275e-17,   4.047059078164266e-20,   4.278013669047938e-21,
  -1.668172912084491e-23,  -1.087672889385686e-24,   1.470395145735543e+00,  -1.087115489550426e-02,  -8.915514905941575e-05,   6.122146640140006e-07,   2.106996040589616e-08,
   3.330376859161755e-11,  -5.028531395095571e-12,  -5.154458509130288e-14,   1.005671021826685e-15,   2.389649384505787e-17,  -1.169460969128449e-19,  -8.859799024317842e-21,
  -3.750459725151351e-23,   2.816555533179640e-24,   1.470386811167875e+00,  -1.087098260364027e-02,  -8.914333695292792e-05,   6.122450448872569e-07,   2.106292012791787e-08,
   3.320355206293480e-11,  -5.025901865723056e-12,  -5.146510179271104e-14,   1.005170789394340e-15,   2.385159851511090e-17,  -1.171621477562828e-19,  -8.839502152705106e-21,
  -3.715686543228353e-23,   2.811137620462575e-24,   1.470372105587461e+00,  -1.087067858513027e-02,  -8.912249751719373e-05,   6.122985764205568e-07,   2.105050044870451e-08,
   3.302684506615658e-11,  -5.021263091394887e-12,  -5.132497486921434e-14,   1.004287394367260e-15,   2.377246477673380e-17,  -1.175416406882063e-19,  -8.803720244453532e-21,
  -3.654483263063765e-23,   2.801575247809472e-24,   1.470354324968985e+00,  -1.087031095110742e-02,  -8.909730372461011e-05,   6.123631778097271e-07,   2.103548755777717e-08,
   3.281338488337348e-11,  -5.015655664157444e-12,  -5.115574079279231e-14,   1.003217948058219e-15,   2.367691987501952e-17,  -1.179975793859934e-19,  -8.760507361519373e-21,
  -3.580738727785463e-23,   2.790008328255224e-24,   1.470337065450656e+00,  -1.086995404623748e-02,  -8.907285175984335e-05,   6.124257561794165e-07,   2.102091866145195e-08,
   3.260638725179533e-11,  -5.010213986712731e-12,  -5.099166983265068e-14,   1.002178459335730e-15,   2.358431769746773e-17,  -1.184371162022551e-19,  -8.718614631906433e-21,
  -3.509423854925242e-23,   2.778775257531559e-24,   1.470323162552168e+00,  -1.086966651963910e-02,  -8.905315768181543e-05,   6.124760714449622e-07,   2.100918598648578e-08,
   3.243979432977230e-11,  -5.005831615768666e-12,  -5.085965284956654e-14,   1.001340140976406e-15,   2.350982680913498e-17,  -1.187889988792137e-19,  -8.684907664219588e-21,
  -3.452170240244530e-23,   2.769723156207595e-24,   1.470313976325090e+00,  -1.086947652294097e-02,  -8.904014619634827e-05,   6.125092713791222e-07,   2.100143512297882e-08,
   3.232979180796560e-11,  -5.002936496065445e-12,  -5.077249492275991e-14,   1.000785746260991e-15,   2.346065751168063e-17,  -1.190204402161249e-19,  -8.662654910794674e-21,
  -3.414434249678309e-23,   2.763740298541864e-24,   1.470309258931291e+00,  -1.086937894923388e-02,  -8.903346479766360e-05,   6.125263064500758e-07,   2.099745526476669e-08,
   3.227332470577328e-11,  -5.001449921767031e-12,  -5.072775881659467e-14,   1.000500899539645e-15,   2.343542309428521e-17,  -1.191389639177387e-19,  -8.651233308075680e-21,
  -3.395084726850350e-23,   2.760667389666457e-24,   1.470307617026774e+00,  -1.086934498760285e-02,  -8.903113937463077e-05,   6.125322333252958e-07,   2.099607013116988e-08,
   3.225367470628247e-11,  -5.000932539120997e-12,  -5.071219177071139e-14,   1.000401734006744e-15,   2.342664262963110e-17,  -1.191801642795526e-19,  -8.647258909868617e-21,
  -3.388354676058596e-23,   2.759597768325698e-24,   1.470307356480451e+00,  -1.086933959834982e-02,  -8.903077036671982e-05,   6.125331737278202e-07,   2.099585033393562e-08,
   3.225055670676053e-11,  -5.000850439194572e-12,  -5.070972167366351e-14,   1.000385996757459e-15,   2.342524941449154e-17,  -1.191866996990476e-19,  -8.646628274856828e-21,
  -3.387286934077157e-23,   2.759428030965267e-24,   1.755469046186889e+00,  -6.566015126469611e-03,  -1.067183372317742e-04,  -9.749628042168463e-07,   3.247844763333718e-09,
   2.929013157014960e-10,   4.802602536124259e-12,   9.607620849633379e-15,  -1.311470871892713e-15,  -3.064394558811385e-17,  -2.080817690696971e-19,   6.135125721717850e-21,
   2.065347179606396e-22,   2.347157079716309e-24,   1.755459045106728e+00,  -6.566288366472731e-03,  -1.067164724541398e-04,  -9.746880660560660e-07,   3.254557468461809e-09,
   2.929186009098939e-10,   4.799142767414032e-12,   9.505041482907713e-15,  -1.312307967144164e-15,  -3.061167463505607e-17,  -2.068130157578370e-19,   6.151599014508918e-21,
   2.063387942011150e-22,   2.334641639671123e-24,   1.755441398189825e+00,  -6.566770439918807e-03,  -1.067131789644581e-04,  -9.742032735688413e-07,   3.266398180232923e-09,
   2.929489371608263e-10,   4.793036189223786e-12,   9.324127587458183e-15,  -1.313780691398954e-15,  -3.055466368001093e-17,  -2.045752823149508e-19,   6.180592052234545e-21,
   2.059916175394653e-22,   2.312562201005787e-24,   1.755420059599090e+00,  -6.567353261134799e-03,  -1.067091912248766e-04,  -9.736170357775137e-07,   3.280709338467352e-09,
   2.929853409339914e-10,   4.785649051829059e-12,   9.105516470630768e-15,  -1.315554121675306e-15,  -3.048560909374218e-17,  -2.018711041928334e-19,   6.215523994397882e-21,
   2.055693125226632e-22,   2.285870882624917e-24,   1.755399344726295e+00,  -6.567918941678390e-03,  -1.067053145350602e-04,  -9.730479038339114e-07,   3.294595285605730e-09,
   2.930203888933678e-10,   4.778474615537707e-12,   8.893451811820693e-15,  -1.317267987121281e-15,  -3.041845054901221e-17,  -1.992477351900451e-19,   6.249302612591864e-21,
   2.051567388816857e-22,   2.259967294132671e-24,   1.755382657281815e+00,  -6.568374566172434e-03,  -1.067021876123033e-04,  -9.725894025372123e-07,   3.305776551781644e-09,
   2.930484138062827e-10,   4.772692745180839e-12,   8.722729482100108e-15,  -1.318643104158435e-15,  -3.036426160210089e-17,  -1.971356776585907e-19,   6.276419161150389e-21,
   2.048225109329067e-22,   2.239105458702702e-24,   1.755371630607716e+00,  -6.568675595357077e-03,  -1.067001194825525e-04,  -9.722864252430455e-07,   3.313162449279626e-09,
   2.930668297422585e-10,   4.768871094872386e-12,   8.609975170198374e-15,  -1.319549040108904e-15,  -3.032841204186438e-17,  -1.957407032665707e-19,   6.294290752925460e-21,
   2.046007480512813e-22,   2.225323194049128e-24,   1.755365967911403e+00,  -6.568830176073177e-03,  -1.066990568068656e-04,  -9.721308294983136e-07,   3.316954692741077e-09,
   2.930762555375829e-10,   4.766908156933045e-12,   8.552087752612704e-15,  -1.320013441528753e-15,  -3.030998845977839e-17,  -1.950245141211262e-19,   6.303454278840512e-21,
   2.044865808152709e-22,   2.218246237164036e-24,   1.755363996962624e+00,  -6.568883977368905e-03,  -1.066986868386060e-04,  -9.720766725918069e-07,   3.318274495481467e-09,
   2.930795312308982e-10,   4.766224884697038e-12,   8.531942264516486e-15,  -1.320174946977100e-15,  -3.030357387645019e-17,  -1.947752693198135e-19,   6.306641436924661e-21,
   2.044467990976774e-22,   2.215783180923814e-24,   1.755363684200412e+00,  -6.568892514801563e-03,  -1.066986281252641e-04,  -9.720680786184520e-07,   3.318483924192395e-09,
   2.930800507990115e-10,   4.766116456254451e-12,   8.528745583939211e-15,  -1.320200569319733e-15,  -3.030255587137851e-17,  -1.947357190933564e-19,   6.307147086258435e-21,
   2.044404841624429e-22,   2.215392334645753e-24,   1.949618713133190e+00,  -1.606911240524914e-03,  -3.701097241779048e-05,  -7.185618125457074e-07,  -1.212858066393814e-08,
  -1.749673281252025e-10,  -1.976423236291468e-12,  -1.095782737301710e-14,   2.298783103455269e-16,   1.008256946208271e-17,   2.355689043998407e-19,   4.055758093833532e-21,
   4.996553450119948e-23,   2.502872877021522e-25,   1.949615229634149e+00,  -1.607113914070232e-03,  -3.701781037351765e-05,  -7.187260202929245e-07,  -1.213135258966412e-08,
  -1.749883501072542e-10,  -1.975799049441191e-12,  -1.092325171671513e-14,   2.308819315053252e-16,   1.010354552986134e-17,   2.358747405743104e-19,   4.057419322204304e-21,
   4.989452092124269e-23,   2.472390636670394e-25,   1.949609082422149e+00,  -1.607471572312488e-03,  -3.702987732003617e-05,  -7.190157833029535e-07,  -1.213624297448316e-08,
  -1.750253881143342e-10,  -1.974695514099000e-12,  -1.086218482418837e-14,   2.326538828851535e-16,   1.014056492209934e-17,   2.364140304845683e-19,   4.060332330824123e-21,
   4.976870964559067e-23,   2.418505605449303e-25,   1.949601648255653e+00,  -1.607904120565307e-03,  -3.704447095921504e-05,  -7.193661948386919e-07,  -1.214215524776035e-08,
  -1.750700799837310e-10,  -1.973357443625324e-12,  -1.078824385472181e-14,   2.347983281764245e-16,   1.018534069274415e-17,   2.370655252001125e-19,   4.063823605555889e-21,
   4.961571275437739e-23,   2.353179058225147e-25,   1.949594430361258e+00,  -1.608324098033940e-03,  -3.705864047160268e-05,  -7.197063965372947e-07,  -1.214789348771490e-08,
  -1.751133666341583e-10,  -1.972054629384118e-12,  -1.071636035943112e-14,   2.368819843236346e-16,   1.022882023853418e-17,   2.376973330760125e-19,   4.067180186203151e-21,
   4.946627991460076e-23,   2.289585042651164e-25,   1.949588615049953e+00,  -1.608662474509038e-03,  -3.707005686565753e-05,  -7.199804788130335e-07,  -1.215251521153844e-08,
  -1.751481664895644e-10,  -1.971002347466693e-12,  -1.065837822456273e-14,   2.385618866662029e-16,   1.026385534767017e-17,   2.382058406131325e-19,   4.069860746634895e-21,
   4.934524900843478e-23,   2.238228327474452e-25,   1.949584772068036e+00,  -1.608886091201905e-03,  -3.707760140816685e-05,  -7.201615973837585e-07,  -1.215556870948831e-08,
  -1.751711266771970e-10,  -1.970305670458510e-12,  -1.062002856008824e-14,   2.396725900578606e-16,   1.028701009201604e-17,   2.385416232247016e-19,   4.071620513314869e-21,
   4.926495559060764e-23,   2.204230931191079e-25,   1.949582798411560e+00,  -1.609000936355393e-03,  -3.708147613686863e-05,  -7.202546134909589e-07,  -1.215713668600226e-08,
  -1.751829070227036e-10,  -1.969947476522983e-12,  -1.060032300637298e-14,   2.402431915367454e-16,   1.029890244616598e-17,   2.387139923629570e-19,   4.072520678146443e-21,
   4.922362257997419e-23,   2.186752530927465e-25,   1.949582111446209e+00,  -1.609040910422111e-03,  -3.708282481070043e-05,  -7.202869890850329e-07,  -1.215768241216180e-08,
  -1.751870055585241e-10,  -1.969822737452855e-12,  -1.059346253020991e-14,   2.404418267821899e-16,   1.030304189314669e-17,   2.387739756569955e-19,   4.072833421795916e-21,
   4.920922056192285e-23,   2.180665971205242e-25,   1.949582002433502e+00,  -1.609047253811004e-03,  -3.708303882851583e-05,  -7.202921266690032e-07,  -1.215776901032261e-08,
  -1.751876558579875e-10,  -1.969802939928368e-12,  -1.059237378273031e-14,   2.404733489873374e-16,   1.030369877606035e-17,   2.387834936399705e-19,   4.072883022984694e-21,
   4.920693441529692e-23,   2.179699973567442e-25,   6.766257214746650e-03,  -1.250884724250982e-04,   1.728875274764337e-06,  -2.119440992677724e-08,   2.421306289236818e-10,
  -2.651130491020553e-12,   2.783535708867633e-14,  -2.894982236008330e-16,   2.813209944283281e-18,  -2.883418653677296e-20,   2.899286507849358e-22,  -1.088074001290260e-24,
   6.285454732545888e-26,   1.990870527548991e-28,   6.766419570345995e-03,  -1.250944421136911e-04,   1.729011694469792e-06,  -2.119690016330497e-08,   2.421698599903971e-10,
  -2.651701990083712e-12,   2.784276730469226e-14,  -2.895956836697718e-16,   2.814445452910082e-18,  -2.883975109320871e-20,   2.903140614151792e-22,  -1.086859033393982e-24,
   6.277946820946634e-26,   1.947096970401405e-28,   6.766706059783741e-03,  -1.251049762935335e-04,   1.729252427151435e-06,  -2.120129466096967e-08,   2.422390923079060e-10,
  -2.652710565252554e-12,   2.785584539186431e-14,  -2.897676687329271e-16,   2.816626846162181e-18,  -2.884956499373597e-20,   2.909937432472557e-22,  -1.084741110915399e-24,
   6.264666190155772e-26,   1.869943979569833e-28,   6.767052503655437e-03,  -1.251177153090125e-04,   1.729543554317145e-06,  -2.120660927822906e-08,   2.423228232324619e-10,
  -2.653930411271215e-12,   2.787166406551697e-14,  -2.899756608826610e-16,   2.819266858027258e-18,  -2.886142387703450e-20,   2.918149705326983e-22,  -1.082224235727646e-24,
   6.248551347992319e-26,   1.776796701591732e-28,   6.767388843992105e-03,  -1.251300831433768e-04,   1.729826207614254e-06,  -2.121176939559998e-08,   2.424041229164850e-10,
  -2.655114895399971e-12,   2.788702528631694e-14,  -2.901776032496344e-16,   2.821832088610123e-18,  -2.887292779372809e-20,   2.926115203593586e-22,  -1.079827074273761e-24,
   6.232849161646511e-26,   1.686524899997792e-28,   6.767659808737615e-03,  -1.251400472398271e-04,   1.730053932425222e-06,  -2.121592687722575e-08,   2.424696277428093e-10,
  -2.656069300134438e-12,   2.789940347409726e-14,  -2.903403048669178e-16,   2.823900289942874e-18,  -2.888218918880826e-20,   2.932527198798301e-22,  -1.077929006517647e-24,
   6.220158153601500e-26,   1.613913485334699e-28,   6.767838863948457e-03,  -1.251466316946739e-04,   1.730204420181340e-06,  -2.121867434034951e-08,   2.425129174823157e-10,
  -2.656700051577237e-12,   2.790758441966198e-14,  -2.904478247283969e-16,   2.825267745200667e-18,  -2.888830603763685e-20,   2.936761724558522e-22,  -1.076690968671564e-24,
   6.211751888352146e-26,   1.565987222722043e-28,   6.767930819387499e-03,  -1.251500132378322e-04,   1.730281706326470e-06,  -2.122008537866052e-08,   2.425351504794446e-10,
  -2.657024002869197e-12,   2.791178624004553e-14,  -2.905030442688543e-16,   2.825970253869813e-18,  -2.889144643610405e-20,   2.938935611076265e-22,  -1.076060175467885e-24,
   6.207428612323759e-26,   1.541391519447048e-28,   6.767962825641881e-03,  -1.251511902324942e-04,   1.730308607031371e-06,  -2.122057651692532e-08,   2.425428891395284e-10,
  -2.657136761898297e-12,   2.791324880385511e-14,  -2.905222644046956e-16,   2.826214809029854e-18,  -2.889253933840107e-20,   2.939692133493313e-22,  -1.075841417637305e-24,
   6.205922861615524e-26,   1.532833422902547e-28,   6.767967904608927e-03,  -1.251513770061727e-04,   1.730312875829072e-06,  -2.122065445444281e-08,   2.425441171707353e-10,
  -2.657154655431871e-12,   2.791348089646994e-14,  -2.905253143978179e-16,   2.826253618492228e-18,  -2.889271276020597e-20,   2.939812177545593e-22,  -1.075806741543444e-24,
   6.205683872508262e-26,   1.531475497286068e-28,   6.087164578057804e-02,  -1.109287065276041e-03,   1.482256761578171e-05,  -1.707921397586865e-07,   1.760969375356901e-09,
  -1.642316809679314e-11,   1.329744675431262e-13,  -9.131582763635182e-16,   2.756827508454839e-18,   2.065505896937637e-20,  -6.538884122209132e-22,   2.597800293810235e-23,
   2.113892497496931e-25,   5.287070165652975e-27,   6.087303738417198e-02,  -1.109335154759882e-03,   1.482355921516049e-05,  -1.708075515528249e-07,   1.761156455165966e-09,
  -1.642496470063074e-11,   1.329816481863947e-13,  -9.130850316195205e-16,   2.754109369472897e-18,   2.079041737795165e-20,  -6.526236920990992e-22,   2.601455852420300e-23,
   2.104604647040901e-25,   5.248789118973989e-27,   6.087549296634778e-02,  -1.109420012938580e-03,   1.482530899346463e-05,  -1.708347472754378e-07,   1.761486568624677e-09,
  -1.642813471743405e-11,   1.329943127681431e-13,  -9.129554176773339e-16,   2.749317470044178e-18,   2.102941051309443e-20,  -6.503967801494398e-22,   2.607883491183734e-23,
   2.088184867160229e-25,   5.181320461146630e-27,   6.087846241170271e-02,  -1.109522630370570e-03,   1.482742499004477e-05,  -1.708676349686799e-07,   1.761885759310550e-09,
  -1.643196773242548e-11,   1.330096170729467e-13,  -9.127980517924925e-16,   2.743530374068398e-18,   2.131866054453950e-20,  -6.477120102361932e-22,   2.615617269407103e-23,
   2.068276816342653e-25,   5.099871149367627e-27,   6.088134523310409e-02,  -1.109622255897041e-03,   1.482947931574740e-05,  -1.708995642169853e-07,   1.762273301336178e-09,
  -1.643568854372153e-11,   1.330244639278497e-13,  -9.126446180550435e-16,   2.737920012729445e-18,   2.159972774671566e-20,  -6.451141106768527e-22,   2.623084716101277e-23,
   2.048895044262702e-25,   5.020942503947124e-27,   6.088366769344768e-02,  -1.109702517439593e-03,   1.483113436333769e-05,  -1.709252877559760e-07,   1.762585510621867e-09,
  -1.643868582771237e-11,   1.330364169872909e-13,  -9.125205366358709e-16,   2.733405850683271e-18,   2.182634346760254e-20,  -6.430273251863981e-22,   2.629071497071452e-23,
   2.033241802215865e-25,   4.957459649401021e-27,   6.088520238132241e-02,  -1.109755555047371e-03,   1.483222804292669e-05,  -1.709422862699916e-07,   1.762791818080667e-09,
  -1.644066630441876e-11,   1.330443117478899e-13,  -9.124383120952404e-16,   2.730425648054120e-18,   2.197618069491404e-20,  -6.416513799148878e-22,   2.633013318246439e-23,
   2.022879116774188e-25,   4.915560801974148e-27,   6.088599053165380e-02,  -1.109782793080284e-03,   1.483278971631052e-05,  -1.709510160855344e-07,   1.762897768416702e-09,
  -1.644168335069419e-11,   1.330483649698374e-13,  -9.123960135485809e-16,   2.728895997884525e-18,   2.205315817591965e-20,  -6.409456840787907e-22,   2.635033262510685e-23,
   2.017551424828871e-25,   4.894059049576608e-27,   6.088626485693070e-02,  -1.109792273635904e-03,   1.483298521451566e-05,  -1.709540546200065e-07,   1.762934645653646e-09,
  -1.644203733925585e-11,   1.330497755533288e-13,  -9.123812796381665e-16,   2.728363720634452e-18,   2.207995548884171e-20,  -6.407002063837227e-22,   2.635735627198528e-23,
   2.015696125556593e-25,   4.886577605623628e-27,   6.088630838868499e-02,  -1.109793778074678e-03,   1.483301623751371e-05,  -1.709545367955844e-07,   1.762940497575240e-09,
  -1.644209351218927e-11,   1.330499993850752e-13,  -9.123789410228617e-16,   2.728279261806672e-18,   2.208420807142739e-20,  -6.406612593965081e-22,   2.635847049792387e-23,
   2.015401670164088e-25,   4.885390519246851e-27,   1.689077185184350e-01,  -2.985496321829466e-03,   3.701161098224978e-05,  -3.665653099584122e-07,   2.782481766106949e-09,
  -1.185119177309767e-11,  -8.734404425454251e-14,   2.664904824547482e-15,  -4.011159128374911e-17,   3.455617681403885e-19,  -1.362725930349917e-21,   2.582344004209168e-23,
   1.518349878866750e-24,   4.005824401886920e-27,   1.689111914906718e-01,  -2.985599457089733e-03,   3.701317542413962e-05,  -3.665763761424462e-07,   2.782357692109538e-09,
  -1.184592663753464e-11,  -8.744944862172286e-14,   2.666074589589215e-15,  -4.011704119748951e-17,   3.456957694514383e-19,  -1.353411714354035e-21,   2.584627703649830e-23,
   1.516625219472408e-24,   3.888484037872578e-27,   1.689173197240684e-01,  -2.985781443404372e-03,   3.701593584947262e-05,  -3.665958985797809e-07,   2.782138641034968e-09,
  -1.183663434881208e-11,  -8.763544773826037e-14,   2.668139026724732e-15,  -4.012662578098607e-17,   3.459323060117466e-19,  -1.336985413636988e-21,   2.588587892951308e-23,
   1.513572566549731e-24,   3.681676329062958e-27,   1.689247302526963e-01,  -2.986001507505894e-03,   3.701927368806403e-05,  -3.666194984667694e-07,   2.781873556571236e-09,
  -1.182539481794590e-11,  -8.786037933819750e-14,   2.670635994337471e-15,  -4.013816123294143e-17,   3.462184785487664e-19,  -1.317137558160217e-21,   2.593258303289730e-23,
   1.509865173826272e-24,   3.432013732830592e-27,   1.689319244785314e-01,  -2.986215146434154e-03,   3.702251390213999e-05,  -3.666424016510841e-07,   2.781616001886633e-09,
  -1.181448032853800e-11,  -8.807875938274384e-14,   2.673060665289610e-15,  -4.014930278396490e-17,   3.464964444378345e-19,  -1.297885355656946e-21,   2.597668507229895e-23,
   1.506249307183681e-24,   3.190076789555925e-27,   1.689377202058619e-01,  -2.986387254405812e-03,   3.702512410345344e-05,  -3.666608470150225e-07,   2.781408364929684e-09,
  -1.180568535904142e-11,  -8.825469803912041e-14,   2.675014420284412e-15,  -4.015823754699549e-17,   3.467204790869222e-19,  -1.282387346919803e-21,   2.601132732592135e-23,
   1.503324419794016e-24,   2.995484665036029e-27,   1.689415499939296e-01,  -2.986500981868447e-03,   3.702684884222192e-05,  -3.666730328641724e-07,   2.781271086598138e-09,
  -1.179987262522633e-11,  -8.837096226762425e-14,   2.676305657747982e-15,  -4.016412154649152e-17,   3.468685698130472e-19,  -1.272152090738340e-21,   2.603378496824481e-23,
   1.501385850947543e-24,   2.867053090275860e-27,   1.689435167964509e-01,  -2.986559386851048e-03,   3.702773456704314e-05,  -3.666792901017604e-07,   2.781200564247540e-09,
  -1.179688714498084e-11,  -8.843067170371438e-14,   2.676968841409801e-15,  -4.016713709900299e-17,   3.469446376068037e-19,  -1.266897516410617e-21,   2.604518410344667e-23,
   1.500388495745468e-24,   2.801144180086676e-27,   1.689442013637574e-01,  -2.986579715317925e-03,   3.702804284991702e-05,  -3.666814678665768e-07,   2.781176014578773e-09,
  -1.179584796340018e-11,  -8.845145446835184e-14,   2.677199679931075e-15,  -4.016818570869315e-17,   3.469711162516946e-19,  -1.265068887657094e-21,   2.604913036041085e-23,
   1.500041069712388e-24,   2.778211440124209e-27,   1.689443099953355e-01,  -2.986582941169345e-03,   3.702809177007973e-05,  -3.666818134419724e-07,   2.781172118707899e-09,
  -1.179568305684922e-11,  -8.845475242341764e-14,   2.677236311365247e-15,  -4.016835206204200e-17,   3.469753181688760e-19,  -1.264778722468504e-21,   2.604975556521867e-23,
   1.499985924347192e-24,   2.774572684297438e-27,   3.302944162388720e-01,  -5.548535547051392e-03,   6.004612884010488e-05,  -4.209478887084322e-07,   4.267076864623381e-10,
   3.891127291074340e-11,  -6.650541023758720e-13,   5.289983860257294e-15,  -1.276154031175126e-18,  -8.573924209076229e-19,   1.456319176998115e-20,  -3.088885085233794e-23,
   1.961093999028233e-24,   4.585622578001785e-26,   3.303000460235205e-01,  -5.548653809595099e-03,   6.004636358351783e-05,  -4.209113223311899e-07,   4.257724334539506e-10,
   3.892164144970446e-11,  -6.650561744715385e-13,   5.287086390251210e-15,  -1.214338796291439e-18,  -8.575391769335246e-19,   1.457496920760223e-20,  -3.056537811515148e-23,
   1.953421834214209e-24,   4.564086492492962e-26,   3.303099798845111e-01,  -5.548862477340789e-03,   6.004677736425978e-05,  -4.208467924937217e-07,   4.241221629169013e-10,
   3.893993226056171e-11,  -6.650596985672862e-13,   5.281973365243809e-15,  -1.105224759920709e-18,  -8.577967863544139e-19,   1.459571187515900e-20,  -2.999588008581012e-23,
   1.939864924638226e-24,   4.526127419136295e-26,   3.303219920450279e-01,  -5.549114786330274e-03,   6.004727698308422e-05,  -4.207687488748186e-07,   4.221266350308432e-10,
   3.896204179374287e-11,  -6.650637345570906e-13,   5.275789972164546e-15,  -9.732146496699519e-19,  -8.581060026154818e-19,   1.462072789653956e-20,  -2.930940876036229e-23,
   1.923439040705890e-24,   4.480298024068006e-26,   3.303336532735682e-01,  -5.549359708576341e-03,   6.004776124070590e-05,  -4.206929713989328e-07,   4.201894079661866e-10,
   3.898349706125550e-11,  -6.650674165314572e-13,   5.269786544235459e-15,  -8.449901640705710e-19,  -8.584037933002370e-19,   1.464494357397008e-20,  -2.864526637279645e-23,
   1.907458943459821e-24,   4.435882169601779e-26,   3.303430474298555e-01,  -5.549557004037534e-03,   6.004815080517067e-05,  -4.206319159625561e-07,   4.186288008818007e-10,
   3.900077520949860e-11,  -6.650702134687742e-13,   5.264949763647856e-15,  -7.416431422547789e-19,  -8.586419796622446e-19,   1.466440159424224e-20,  -2.811186831748528e-23,
   1.894561223353605e-24,   4.400154770083922e-26,   3.303492549318539e-01,  -5.549687368116759e-03,   6.004840795451628e-05,  -4.205915666797454e-07,   4.175975785045367e-10,
   3.901218939536230e-11,  -6.650719787626684e-13,   5.261753462704466e-15,  -6.733283122161252e-19,  -8.587985330579296e-19,   1.467723469319419e-20,  -2.776020410251888e-23,
   1.886026749871596e-24,   4.376572918494456e-26,   3.303524427845095e-01,  -5.549754314686407e-03,   6.004853993015483e-05,  -4.205708438654086e-07,   4.170679961650922e-10,
   3.901805022699703e-11,  -6.650728596919808e-13,   5.260111934432139e-15,  -6.382376665179055e-19,  -8.588786724867050e-19,   1.468381754818829e-20,  -2.757985365289632e-23,
   1.881640220499595e-24,   4.364470608024347e-26,   3.303535523463548e-01,  -5.549777615794702e-03,   6.004858585229387e-05,  -4.205636308570256e-07,   4.168836701339934e-10,
   3.902009000000161e-11,  -6.650731622261966e-13,   5.259540573593159e-15,  -6.260228188467205e-19,  -8.589065246631915e-19,   1.468610756788167e-20,  -2.751712017134757e-23,
   1.880112865415589e-24,   4.360259577623196e-26,   3.303537284185639e-01,  -5.549781313347415e-03,   6.004859313887868e-05,  -4.205624862403951e-07,   4.168544201291706e-10,
   3.902041367709089e-11,  -6.650732100404493e-13,   5.259449905932764e-15,  -6.240844325060409e-19,  -8.589109424700527e-19,   1.468647090533605e-20,  -2.750716708986446e-23,
   1.879870467519233e-24,   4.359591406320180e-26,   5.434618713831768e-01,  -8.434816265947557e-03,   7.131888477372851e-05,  -1.255126037795691e-07,  -6.275122536182951e-09,
   9.436772089532388e-11,  -3.471308197612105e-13,  -1.057037422525770e-14,   1.950134920715905e-16,  -1.160662221068853e-18,  -1.877490657844278e-20,   6.382482083308872e-22,
   3.740063477871746e-25,   4.798209085783999e-27,   5.434685504242264e-01,  -8.434851255336382e-03,   7.131535230610912e-05,  -1.254243097540937e-07,  -6.275604656009135e-09,
   9.434684976030051e-11,  -3.466205442890304e-13,  -1.057420566553450e-14,   1.949343655543284e-16,  -1.157371286786125e-18,  -1.877244249293082e-20,   6.382523433802148e-22,
   3.773096467476489e-25,   4.235448070607245e-27,   5.434803354278450e-01,  -8.434912974505828e-03,   7.130911899226883e-05,  -1.252685294812089e-07,  -6.276454781291739e-09,
   9.431001622332312e-11,  -3.457203239949952e-13,  -1.058095727245892e-14,   1.947947541488984e-16,  -1.151564395679753e-18,  -1.876807847062825e-20,   6.382563111676153e-22,
   3.830919222891745e-25,   3.243714016840528e-27,   5.434945855208027e-01,  -8.434987571617114e-03,   7.130158122907836e-05,  -1.250801854658179e-07,  -6.277481768386761e-09,
   9.426546634127853e-11,  -3.446320558093163e-13,  -1.058910599133261e-14,   1.946259492108822e-16,  -1.144542674663204e-18,  -1.876277414748795e-20,   6.382554387288485e-22,
   3.900048813545726e-25,   2.046659107075675e-27,   5.435084187833527e-01,  -8.435059953214996e-03,   7.129426330816345e-05,  -1.248973727963935e-07,  -6.278477709487646e-09,
   9.422220723436603e-11,  -3.435758852705358e-13,  -1.059700050373855e-14,   1.944620917033490e-16,  -1.137726156944463e-18,  -1.875759641595767e-20,   6.382486604571787e-22,
   3.966333147663437e-25,   8.868424300116442e-28,   5.435195623351095e-01,  -8.435118237107039e-03,   7.128836780633224e-05,  -1.247501216675924e-07,  -6.279279281510537e-09,
   9.418735049345586e-11,  -3.427252639440498e-13,  -1.060334866839582e-14,   1.943301012963027e-16,  -1.132234901507221e-18,  -1.875340510657950e-20,   6.382389548445748e-22,
   4.019140988449323e-25,  -4.586827206962382e-29,   5.435269256268386e-01,  -8.435156737442009e-03,   7.128447202676159e-05,  -1.246528307247251e-07,  -6.279808581213717e-09,
   9.416431398069951e-11,  -3.421632942424586e-13,  -1.060753776644160e-14,   1.942428898201525e-16,  -1.128606402044124e-18,  -1.875062573288626e-20,   6.382304648991726e-22,
   4.053747212675106e-25,  -6.613921601011541e-28,   5.435307069772717e-01,  -8.435176505302728e-03,   7.128247131519598e-05,  -1.246028702569685e-07,  -6.280080289126705e-09,
   9.415248245493542e-11,  -3.418747286046043e-13,  -1.060968731954411e-14,   1.941981042374149e-16,  -1.126743002205177e-18,  -1.874919536337545e-20,   6.382254630829985e-22,
   4.071430147013248e-25,  -9.772472888483642e-28,   5.435320231026097e-01,  -8.435183385066259e-03,   7.128177494247270e-05,  -1.245854815500553e-07,  -6.280174841595346e-09,
   9.414836419717624e-11,  -3.417742958964552e-13,  -1.061043521271450e-14,   1.941825164734245e-16,  -1.126094430206027e-18,  -1.874869702917373e-20,   6.382236200115998e-22,
   4.077570693923287e-25,  -1.087144415403487e-27,   5.435322319531805e-01,  -8.435184476760482e-03,   7.128166443739213e-05,  -1.245827222250790e-07,  -6.280189844917381e-09,
   9.414771067751764e-11,  -3.417583588559374e-13,  -1.061055387984052e-14,   1.941800429226957e-16,  -1.125991510828849e-18,  -1.874861792758669e-20,   6.382233226931869e-22,
   4.078544442142592e-25,  -1.104581717476216e-27,   8.045888314472568e-01,  -1.104891534832354e-02,   5.530848422191740e-05,   5.844436800192344e-07,  -1.193715303549926e-08,
   1.248406705037472e-11,   1.960169322952588e-12,  -2.226382103611669e-14,  -1.891106583599393e-16,   6.340355746417149e-18,  -2.688932426041727e-20,  -9.302017657042424e-22,
   2.613951954890170e-23,   1.478477351321141e-25,   8.045940031597786e-01,  -1.104875093400320e-02,   5.530178510936439e-05,   5.844550184598685e-07,  -1.193440245305984e-08,
   1.244057336555583e-11,   1.959670686470979e-12,  -2.224254617194157e-14,  -1.892189957586963e-16,   6.335600578514985e-18,  -2.673024142248235e-20,  -9.291404255532830e-22,
   2.608224036778112e-23,   1.474897545607656e-25,   8.046031282192718e-01,  -1.104846081981487e-02,   5.528996567618709e-05,   5.844749922706486e-07,  -1.192954957795291e-08,
   1.236386206494410e-11,   1.958790606422555e-12,  -2.220501935628470e-14,  -1.894096155097571e-16,   6.327214438689885e-18,  -2.644982554524058e-20,  -9.272698092206403e-22,
   2.598115595635072e-23,   1.468575794111745e-25,   8.046141614715500e-01,  -1.104811000632373e-02,   5.527567563323790e-05,   5.844990884874287e-07,  -1.192368240309459e-08,
   1.227115988296666e-11,   1.957726016031869e-12,  -2.215966371638048e-14,  -1.896391892663906e-16,   6.317081374049281e-18,  -2.611123528115770e-20,  -9.250114824599316e-22,
   2.585889943787097e-23,   1.460922785723992e-25,   8.046248714538807e-01,  -1.104776943814716e-02,   5.526180534968591e-05,   5.845224217133806e-07,  -1.191798767104216e-08,
   1.218122686786140e-11,   1.956692124606505e-12,  -2.211565646921518e-14,  -1.898610869936854e-16,   6.307252263759050e-18,  -2.578305258352284e-20,  -9.228229549063488e-22,
   2.574019009765742e-23,   1.453484371613422e-25,   8.046334986258544e-01,  -1.104749507762477e-02,   5.525063323641389e-05,   5.845411764250570e-07,  -1.191340079975448e-08,
   1.210882144919713e-11,   1.955858945289738e-12,  -2.208022143488849e-14,  -1.900391515984952e-16,   6.299339710437380e-18,  -2.551904181404737e-20,  -9.210626422317268e-22,
   2.564454194550860e-23,   1.447485687147790e-25,   8.046391989889231e-01,  -1.104731378350031e-02,   5.524325168964399e-05,   5.845535485330885e-07,  -1.191037023480036e-08,
   1.206099850689659e-11,   1.955308253618326e-12,  -2.205681473576704e-14,  -1.901564742960779e-16,   6.294114000367510e-18,  -2.534476886203336e-20,  -9.199007996451956e-22,
   2.558133094201047e-23,   1.443518755627263e-25,   8.046421262996223e-01,  -1.104722067980493e-02,   5.523946115545035e-05,   5.845598958111125e-07,  -1.190881400538065e-08,
   1.203644571415918e-11,   1.955025403358826e-12,  -2.204479679262371e-14,  -1.902166202601347e-16,   6.291431202586369e-18,  -2.525532723718397e-20,  -9.193045526539040e-22,
   2.554886649578049e-23,   1.441480590373596e-25,   8.046431451612395e-01,  -1.104718827413350e-02,   5.523814186403875e-05,   5.845621040219524e-07,  -1.190827236310304e-08,
   1.202790093666954e-11,   1.954926947778257e-12,  -2.204061423808063e-14,  -1.902375379253607e-16,   6.290497566226526e-18,  -2.522420515620518e-20,  -9.190970894738159e-22,
   2.553756654117870e-23,   1.440771036520861e-25,   8.046433068398018e-01,  -1.104718313179606e-02,   5.523793251249980e-05,   5.845624543863036e-07,  -1.190818641276987e-08,
   1.202654504785897e-11,   1.954911323903389e-12,  -2.203995054329559e-14,  -1.902408564785921e-16,   6.290349417448854e-18,  -2.521926693288538e-20,  -9.190641710600396e-22,
   2.553577337474941e-23,   1.440658432900433e-25,   1.104953486901303e+00,  -1.248122068235371e-02,   5.663244011455839e-07,   1.306142415896082e-06,  -3.367942686201204e-09,
  -2.399577556886794e-10,   1.491211958389329e-12,   4.939978222188259e-14,  -5.821279842240287e-16,  -1.094491374427979e-17,   1.979998323530023e-19,   2.464493209690956e-21,
  -5.290328681629572e-23,  -1.581661574024662e-25,   1.104953536214904e+00,  -1.248085411986283e-02,   5.644416635914578e-07,   1.305918268177274e-06,  -3.365863516902662e-09,
  -2.398610816353765e-10,   1.489700883857065e-12,   4.936317302093355e-14,  -5.813029362735342e-16,  -1.093225439082290e-17,   1.976795699875743e-19,   2.463266269711568e-21,
  -5.274965068061955e-23,  -1.594479278641775e-25,   1.104953623087424e+00,  -1.248020736568318e-02,   5.611204901476407e-07,   1.305522829500372e-06,  -3.362196510821948e-09,
  -2.396905571791855e-10,   1.487036323589764e-12,   4.929861020912335e-14,  -5.798482184248720e-16,  -1.090992197731856e-17,   1.971152278381623e-19,   2.461093757870416e-21,
  -5.247919313778859e-23,  -1.617049329270033e-25,   1.104953727892352e+00,  -1.247942539074078e-02,   5.571061052107251e-07,   1.305044786118903e-06,  -3.357765260720682e-09,
  -2.394844567776862e-10,   1.483817298851515e-12,   4.922059932237138e-14,  -5.780910186293564e-16,  -1.088292629759850e-17,   1.964341229101479e-19,   2.458453867198737e-21,
  -5.215323529698388e-23,  -1.644261221474630e-25,   1.104953829381541e+00,  -1.247866635422119e-02,   5.532106987354644e-07,   1.304580841044529e-06,  -3.353466549312819e-09,
  -2.392844823197135e-10,   1.480695454434745e-12,   4.914492963789501e-14,  -5.763871055757236e-16,  -1.085672872047100e-17,   1.957742804052940e-19,   2.455877658068059e-21,
  -5.183793210277131e-23,  -1.670594311547093e-25,   1.104953910958237e+00,  -1.247805494961917e-02,   5.500738195681838e-07,   1.304207186878113e-06,  -3.350005761349085e-09,
  -2.391234601533264e-10,   1.478182777715165e-12,   4.908401549069319e-14,  -5.750158481401327e-16,  -1.083563101984820e-17,   1.952436940415018e-19,   2.453792678500919e-21,
  -5.158473667911210e-23,  -1.691747966350704e-25,   1.104953964773730e+00,  -1.247765097634144e-02,   5.480016177686752e-07,   1.303960328851726e-06,  -3.347720010037908e-09,
  -2.390170961142194e-10,   1.476523542154326e-12,   4.904378622680174e-14,  -5.741104269407443e-16,  -1.082169333656420e-17,   1.948935682189527e-19,   2.452410258345592e-21,
  -5.141782496229093e-23,  -1.705696601371709e-25,   1.104953992383060e+00,  -1.247744352662669e-02,   5.469376260559097e-07,   1.303833569664047e-06,  -3.346546499942024e-09,
  -2.389624843881769e-10,   1.475671784268043e-12,   4.902313329105861e-14,  -5.736456603882389e-16,  -1.081453669197109e-17,   1.947139089558738e-19,   2.451698866538297e-21,
  -5.133222992015338e-23,  -1.712850829724545e-25,   1.104954001988362e+00,  -1.247737132342857e-02,   5.465673231366506e-07,   1.303789452231679e-06,  -3.346138101942903e-09,
  -2.389434780751040e-10,   1.475375376088443e-12,   4.901594591679326e-14,  -5.734839276420124e-16,  -1.081204591923991e-17,   1.946514003076304e-19,   2.451451028930696e-21,
  -5.130245720947228e-23,  -1.715339482028236e-25,   1.104954003512383e+00,  -1.247735986585019e-02,   5.465085625465639e-07,   1.303782451510219e-06,  -3.346073297317869e-09,
  -2.389404621203444e-10,   1.475328342753642e-12,   4.901480543023839e-14,  -5.734582644731214e-16,  -1.081165067565012e-17,   1.946414821567787e-19,   2.451411689543694e-21,
  -5.129773361236004e-23,  -1.715734328409103e-25,   1.425538673409546e+00,  -1.154927287135841e-02,  -7.978627891318680e-05,   9.476898604459571e-07,   2.043427305145362e-08,
  -1.003199719260233e-10,  -5.902819437709352e-12,  -7.272095878050699e-15,   1.687281320684437e-15,   1.148750582198609e-17,  -4.861315213680059e-19,  -6.440436835112093e-21,
   1.453506983348548e-22,   3.575084433129798e-24,   1.425531216440091e+00,  -1.154900666581068e-02,  -7.977483119171784e-05,   9.475956959348433e-07,   2.042602404845772e-08,
  -1.003336873131710e-10,  -5.898432013049571e-12,  -7.234161868609389e-15,   1.685258989592577e-15,   1.145527783191645e-17,  -4.852425199261543e-19,  -6.415111500998404e-21,
   1.451277076014671e-22,   3.560200766937558e-24,   1.425518059366971e+00,  -1.154853696347785e-02,  -7.975463526698974e-05,   9.474295309020139e-07,   2.041147355239800e-08,
  -1.003578280229790e-10,  -5.890694631745240e-12,  -7.167314423103668e-15,   1.681693594542475e-15,   1.139851636634948e-17,  -4.836749881207339e-19,  -6.370512383861091e-21,
   1.447339182917852e-22,   3.533986611557608e-24,   1.425502151171342e+00,  -1.154796903113430e-02,  -7.973022054839829e-05,   9.472285848862228e-07,   2.039388745830081e-08,
  -1.003869164950176e-10,  -5.881345832517653e-12,  -7.086631135259426e-15,   1.677387461517365e-15,   1.133005914084370e-17,  -4.817814315931534e-19,  -6.316732222105929e-21,
   1.442572038821180e-22,   3.502370438713242e-24,   1.425486709317645e+00,  -1.154741773071742e-02,  -7.970652587205110e-05,   9.470334917046036e-07,   2.037682410160830e-08,
  -1.004150476218097e-10,  -5.872277844979101e-12,  -7.008461350718880e-15,   1.673212563980438e-15,   1.126378953960566e-17,  -4.799452113346364e-19,  -6.264679747558970e-21,
   1.437938561501973e-22,   3.471764017717683e-24,   1.425474270669542e+00,  -1.154697363783682e-02,  -7.968744255509507e-05,   9.468763141137511e-07,   2.036308447080182e-08,
  -1.004376327839705e-10,  -5.864978280046786e-12,  -6.945600496354703e-15,   1.669853203179409e-15,   1.121053771988446e-17,  -4.784674184688413e-19,  -6.222858817622936e-21,
   1.434201896641695e-22,   3.447169416386534e-24,   1.425466051975103e+00,  -1.154668020267001e-02,  -7.967483499186878e-05,   9.467724475781092e-07,   2.035400869377226e-08,
  -1.004525190352989e-10,  -5.860157542991196e-12,  -6.904117787293104e-15,   1.667635297351467e-15,   1.117541543857552e-17,  -4.774916258415581e-19,  -6.195278994078483e-21,
   1.431730830026928e-22,   3.430947832388479e-24,   1.425461831450059e+00,  -1.154652951384584e-02,  -7.966836113236386e-05,   9.467191051704424e-07,   2.034934881456844e-08,
  -1.004601522102110e-10,  -5.857682693995937e-12,  -6.882831309011960e-15,   1.666496883956023e-15,   1.115739872612586e-17,  -4.769907282336542e-19,  -6.181132337016746e-21,
   1.430461219988482e-22,   3.422626570487532e-24,   1.425460362484380e+00,  -1.154647706588518e-02,  -7.966610796207951e-05,   9.467005385432632e-07,   2.034772705479240e-08,
  -1.004628071561951e-10,  -5.856821432269127e-12,  -6.875425040912382e-15,   1.666100742240307e-15,   1.115113106798954e-17,  -4.768164210422392e-19,  -6.176211152948509e-21,
   1.430019225426782e-22,   3.419731758559271e-24,   1.425460129381026e+00,  -1.154646874314770e-02,  -7.966575042048387e-05,   9.466975922603460e-07,   2.034746971115472e-08,
  -1.004632283717247e-10,  -5.856684768166605e-12,  -6.874249895632848e-15,   1.666037884443773e-15,   1.115013662996412e-17,  -4.767887625441624e-19,  -6.175430356463511e-21,
   1.429949082463843e-22,   3.419272461995509e-24,   1.727425280599005e+00,  -7.465190666686649e-03,  -1.178924815877124e-04,  -8.698778300817622e-07,   1.025129440847667e-08,
   4.055894193095819e-10,   4.310764418179697e-12,  -5.089837582929396e-14,  -2.470094557427210e-15,  -3.029215998703926e-17,   3.128262582589178e-19,   1.794309690883892e-20,
   2.517295241250182e-22,  -1.606774261153793e-24,   1.727414239844664e+00,  -7.465433983229287e-03,  -1.178866815002558e-04,  -8.694984481229164e-07,   1.025728011035055e-08,
   4.054876306283724e-10,   4.304308830954296e-12,  -5.099821502146501e-14,  -2.468726601011212e-15,  -3.020014404610398e-17,   3.143338327347474e-19,   1.793032825853383e-20,
   2.506493817889405e-22,  -1.625374209390535e-24,   1.727394758705731e+00,  -7.465863232504343e-03,  -1.178764444351537e-04,  -8.688291007461755e-07,   1.026783460628400e-08,
   4.053078642737172e-10,   4.292920794088635e-12,  -5.117413074153285e-14,  -2.466307693522356e-15,  -3.003783503323466e-17,   3.169885465186801e-19,   1.790768840935367e-20,
   2.487442147514281e-22,  -1.658104086730495e-24,   1.727371202664631e+00,  -7.466382137679560e-03,  -1.178640610319142e-04,  -8.680198519239647e-07,   1.028058465278645e-08,
   4.050902186835206e-10,   4.279155292865666e-12,  -5.138642015333617e-14,  -2.463373995727796e-15,  -2.984166258628532e-17,   3.201894072237377e-19,   1.788012595177696e-20,
   2.464417726265878e-22,  -1.697527961155413e-24,   1.727348335663984e+00,  -7.466885727255817e-03,  -1.178520345878895e-04,  -8.672343867422596e-07,   1.029294902461305e-08,
   4.048786495202522e-10,   4.265797264270122e-12,  -5.159205713556294e-14,  -2.460516887995554e-15,  -2.965131991879468e-17,   3.232870668539291e-19,   1.785317436953891e-20,
   2.442079802978599e-22,  -1.735639363245369e-24,   1.727329914876299e+00,  -7.467291301720718e-03,  -1.178423427676707e-04,  -8.666017262792151e-07,   1.030290018006231e-08,
   4.047080099258328e-10,   4.255040001158866e-12,  -5.175739335343288e-14,  -2.458208712796035e-15,  -2.949805294391489e-17,   3.257755675267149e-19,   1.783132354934390e-20,
   2.424094616120432e-22,  -1.766226385285626e-24,   1.727317743027410e+00,  -7.467559243881067e-03,  -1.178359368857333e-04,  -8.661837245436410e-07,   1.030947111404343e-08,
   4.045951554057061e-10,   4.247933652203003e-12,  -5.186648683137608e-14,  -2.456680320880569e-15,  -2.939681153903999e-17,   3.274165305299144e-19,   1.781681700310069e-20,
   2.412215229148136e-22,  -1.786381444465667e-24,   1.727311492287041e+00,  -7.467696828233581e-03,  -1.178326466333503e-04,  -8.659690758204633e-07,   1.031284417684535e-08,
   4.045371686404012e-10,   4.244284777435985e-12,  -5.192246277486003e-14,  -2.455894432682011e-15,  -2.934482998308840e-17,   3.282581941617806e-19,   1.780934622291815e-20,
   2.406116118669998e-22,  -1.796714624831644e-24,   1.727309316673374e+00,  -7.467744713058127e-03,  -1.178315013472331e-04,  -8.658943677821079e-07,   1.031401797520547e-08,
   4.045169809509315e-10,   4.243014844821140e-12,  -5.194193794990079e-14,  -2.455620740241445e-15,  -2.932673904000571e-17,   3.285509758514600e-19,   1.780674261279903e-20,
   2.403993510477917e-22,  -1.800308412077992e-24,   1.727308971434101e+00,  -7.467752311593584e-03,  -1.178313196021289e-04,  -8.658825127599976e-07,   1.031420423006150e-08,
   4.045137772117337e-10,   4.242813328357556e-12,  -5.194502802336196e-14,  -2.455577301575781e-15,  -2.932386833787973e-17,   3.285974283435566e-19,   1.780632929737934e-20,
   2.403656693341598e-22,  -1.800878565088163e-24,   1.942539252273460e+00,  -1.941072095487099e-03,  -4.692212299339177e-05,  -9.432754878121720e-07,  -1.612113500897033e-08,
  -2.248422275153494e-10,  -2.110489356425888e-12,   4.416959944816101e-15,   8.120921672098213e-16,   2.380223386655329e-17,   4.681573075936133e-19,   6.443602162161409e-21,
   3.916763757162467e-23,  -9.866593889339537e-25,   1.942534835095618e+00,  -1.941338133346181e-03,  -4.693120770713096e-05,  -9.434861917136282e-07,  -1.612407712078163e-08,
  -2.248322383023568e-10,  -2.108316659695150e-12,   4.498149263907992e-15,   8.140743409077688e-16,   2.383515392658174e-17,   4.683820824544319e-19,   6.435854511474397e-21,
   3.879006494970513e-23,  -9.962942689173957e-25,   1.942527040221306e+00,  -1.941807609504509e-03,  -4.694723916706086e-05,  -9.438579740550773e-07,  -1.612926602329351e-08,
  -2.248144818052045e-10,  -2.104478667566245e-12,   4.641499199784282e-15,   8.175726730721864e-16,   2.389320886591444e-17,   4.687767890343268e-19,   6.422126201092457e-21,
   3.812267077098696e-23,  -1.013308435161408e-24,   1.942517613391719e+00,  -1.942375387225129e-03,  -4.696662686307160e-05,  -9.443075235131664e-07,  -1.613553623351748e-08,
  -2.247927880625632e-10,  -2.099830505097962e-12,   4.814993047857089e-15,   8.218041773696940e-16,   2.396335304413060e-17,   4.692508079934365e-19,   6.405427755808161e-21,
   3.731367097849736e-23,  -1.033904706836428e-24,   1.942508460748474e+00,  -1.942926662016140e-03,  -4.698545049287958e-05,  -9.447439238892195e-07,  -1.614161877337589e-08,
  -2.247714951354190e-10,  -2.095310585889586e-12,   4.983578613369626e-15,   8.259133869764652e-16,   2.403138844740572e-17,   4.697075537877880e-19,   6.389114474435578e-21,
   3.652623568249953e-23,  -1.053922752916540e-24,   1.942501086609395e+00,  -1.943370823442115e-03,  -4.700061627606883e-05,  -9.450954719378454e-07,  -1.614651558144981e-08,
  -2.247541747854509e-10,  -2.091663977525863e-12,   5.119504066299096e-15,   8.292246677507300e-16,   2.408615421012637e-17,   4.700730456628792e-19,   6.375899060800468e-21,
   3.589040377701650e-23,  -1.070065839924972e-24,   1.942496213474497e+00,  -1.943664347571967e-03,  -4.701063839329330e-05,  -9.453277634995068e-07,  -1.614974973358545e-08,
  -2.247426479814022e-10,  -2.089251709400133e-12,   5.209377523999976e-15,   8.314131690263202e-16,   2.412232149640149e-17,   4.703133519166891e-19,   6.367130472383614e-21,
   3.546953085616316e-23,  -1.080741110948122e-24,   1.942493710751973e+00,  -1.943815095588134e-03,  -4.701578548908417e-05,  -9.454470547405282e-07,  -1.615141013922673e-08,
  -2.247367031031183e-10,  -2.088012073350373e-12,   5.255549263535297e-15,   8.325372128895653e-16,   2.414088863537931e-17,   4.704363879365645e-19,   6.362616220946421e-21,
   3.525316783475593e-23,  -1.086225906365721e-24,   1.942492839635053e+00,  -1.943867566301147e-03,  -4.701757702414637e-05,  -9.454885748956994e-07,  -1.615198798118454e-08,
  -2.247346299032687e-10,  -2.087580475968133e-12,   5.271622532955959e-15,   8.329284695026160e-16,   2.414735006328775e-17,   4.704791523818289e-19,   6.361043217066482e-21,
   3.517782494511428e-23,  -1.088135342439146e-24,   1.942492701399778e+00,  -1.943875892751184e-03,  -4.701786131804483e-05,  -9.454951635604463e-07,  -1.615207967306870e-08,
  -2.247343007236494e-10,  -2.087511981202587e-12,   5.274173271066042e-15,   8.329905576228948e-16,   2.414837535375797e-17,   4.704859356913720e-19,   6.360793518631598e-21,
   3.516586736867108e-23,  -1.088438362759945e-24,   6.292042500797064e-03,  -1.122127492494443e-04,   1.496147611342817e-06,  -1.771078795331112e-08,   1.951807128439486e-10,
  -2.071061198930733e-12,   2.084935434973619e-14,  -2.138855129245326e-16,   1.980579426787518e-18,  -1.729805565812438e-20,   3.083421546704554e-22,   1.805172954791658e-24,
   4.629956687585474e-26,  -1.121547482163344e-27,   6.292182985092641e-03,  -1.122177372510809e-04,   1.496257566159028e-06,  -1.771273311845873e-08,   1.952100940365022e-10,
  -2.071483209610056e-12,   2.085458043099166e-14,  -2.139436609867906e-16,   1.981888899357065e-18,  -1.728907644396463e-20,   3.086137047506875e-22,   1.796758373243927e-24,
   4.597653529118030e-26,  -1.125448066497831e-27,   6.292430880246461e-03,  -1.122265391039655e-04,   1.496451596615980e-06,  -1.771616571495175e-08,   1.952619435993351e-10,
  -2.072227947061690e-12,   2.086380473352402e-14,  -2.140462397634944e-16,   1.984200402619988e-18,  -1.727326797029952e-20,   3.090912407554692e-22,   1.781887850953712e-24,
   4.540713808225126e-26,  -1.132306298315577e-27,   6.292730652045731e-03,  -1.122371831582296e-04,   1.496686243259701e-06,  -1.772031699637436e-08,   1.953246508541392e-10,
  -2.073128650038874e-12,   2.087496363416793e-14,  -2.141702375895983e-16,   1.986997059072553e-18,  -1.725421277522252e-20,   3.096659249750319e-22,   1.763867375941267e-24,
   4.471963538270125e-26,  -1.140557782274012e-27,   6.293021680327240e-03,  -1.122475170174896e-04,   1.496914058186806e-06,  -1.772434756356124e-08,   1.953855366656749e-10,
  -2.074003202837082e-12,   2.088580150426655e-14,  -2.142905691319584e-16,   1.989713635631611e-18,  -1.723577784360818e-20,   3.102209335533266e-22,   1.746332821517296e-24,
   4.405328669324026e-26,  -1.148524730525062e-27,   6.293256139679911e-03,  -1.122558424102363e-04,   1.497097600146560e-06,  -1.772759494813071e-08,   1.954345931478905e-10,
  -2.074707850069436e-12,   2.089453593695528e-14,  -2.143874756214646e-16,   1.991903239496546e-18,  -1.722097247402240e-20,   3.106659760689926e-22,   1.732178219286173e-24,
   4.351724971350255e-26,  -1.154911721850470e-27,   6.293411071509034e-03,  -1.122613439606143e-04,   1.497218889834542e-06,  -1.772974096377741e-08,   1.954670125508464e-10,
  -2.075173526600769e-12,   2.090030925050462e-14,  -2.144514945316620e-16,   1.993350659821790e-18,  -1.721121168611604e-20,   3.109590418179515e-22,   1.722810950252632e-24,
   4.316342065626260e-26,  -1.159116936360959e-27,   6.293490638045005e-03,  -1.122641693563104e-04,   1.497281180500227e-06,  -1.773084310789910e-08,   1.954836626264255e-10,
  -2.075412691776110e-12,   2.090327466642496e-14,  -2.144843666184395e-16,   1.994094155121181e-18,  -1.720620596728282e-20,   3.111092327814128e-22,   1.717996037902473e-24,
   4.298182839156225e-26,  -1.161271820392557e-27,   6.293518332165762e-03,  -1.122651527749021e-04,   1.497302861751975e-06,  -1.773122672918893e-08,   1.954894580225476e-10,
  -2.075495938270194e-12,   2.090430689307494e-14,  -2.144958073035937e-16,   1.994352963415408e-18,  -1.720446478197287e-20,   3.111614584138807e-22,   1.716319468296125e-24,
   4.291864199265107e-26,  -1.162021100494009e-27,   6.293522726853623e-03,  -1.122653088305412e-04,   1.497306302287735e-06,  -1.773128760507596e-08,   1.954903776808719e-10,
  -2.075509148478303e-12,   2.090447069733402e-14,  -2.144976227473733e-16,   1.994394034053521e-18,  -1.720418853211988e-20,   3.111697435429862e-22,   1.716053386796710e-24,
   4.290861605737967e-26,  -1.162139965471550e-27,   5.665932306629359e-02,  -9.984494424485949e-04,   1.293181408708872e-05,  -1.450794443708167e-07,   1.462402809821861e-09,
  -1.352806763681713e-11,   1.087308566329353e-13,  -8.156447477113205e-16,   3.337600562596990e-18,   2.101060194668173e-20,   7.684090614673081e-22,   3.871476161459011e-23,
   2.035761264767323e-25,  -8.127915945166827e-27,   5.666053707456437e-02,  -9.984902906848643e-04,   1.293263755078529e-05,  -1.450921403990213e-07,   1.462555816805762e-09,
  -1.352967221322759e-11,   1.087396855982127e-13,  -8.155687053783205e-16,   3.340877412307092e-18,   2.120782676873259e-20,   7.695241075649622e-22,   3.865343036285927e-23,
   2.004480636156037e-25,  -8.162603336116431e-27,   5.666267927415573e-02,  -9.985623709468496e-04,   1.293409063545133e-05,  -1.451145439634700e-07,   1.462825810160751e-09,
  -1.353250338935165e-11,   1.087552714607414e-13,  -8.154339880908498e-16,   3.346663162819980e-18,   2.155557404423716e-20,   7.714759483173549e-22,   3.854500722509768e-23,
   1.949339645898080e-25,  -8.223583918853205e-27,   5.666526975204226e-02,  -9.986495361257700e-04,   1.293584784034660e-05,  -1.451416366781444e-07,   1.463152306279592e-09,
  -1.353592666541860e-11,   1.087741300176563e-13,  -8.152701672837601e-16,   3.353665622223398e-18,   2.197563152645508e-20,   7.738094254412502e-22,   3.841355528648220e-23,
   1.882754972882937e-25,  -8.296937719289249e-27,   5.666778465545180e-02,  -9.987341597627489e-04,   1.293755382947163e-05,  -1.451679400000649e-07,   1.463469281151353e-09,
  -1.353924969944241e-11,   1.087924501150410e-13,  -8.151101709025873e-16,   3.360470005600186e-18,   2.238295221396931e-20,   7.760467784902762e-22,   3.828558335980741e-23,
   1.818212531915613e-25,  -8.367746294909633e-27,   5.666981070941319e-02,  -9.988023351831022e-04,   1.293892824171204e-05,  -1.451891311785524e-07,   1.463724644953294e-09,
  -1.354192653203988e-11,   1.088072175345128e-13,  -8.149805910859052e-16,   3.365956164757155e-18,   2.271075160121521e-20,   7.778291545082269e-22,   3.818223324998236e-23,
   1.766287374229404e-25,  -8.424501203684893e-27,   5.667114952918468e-02,  -9.988473861073186e-04,   1.293983647270170e-05,  -1.452031346977453e-07,   1.463893391155674e-09,
  -1.354369525658570e-11,   1.088169799845221e-13,  -8.148946299685299e-16,   3.369583577779560e-18,   2.292719241010054e-20,   7.789971279041837e-22,   3.811381554704253e-23,
   1.732010144556310e-25,  -8.461863237462590e-27,   5.667183708938469e-02,  -9.988705224756719e-04,   1.294030290633820e-05,  -1.452103264117687e-07,   1.463980052369402e-09,
  -1.354460355687108e-11,   1.088219948315697e-13,  -8.148503806136628e-16,   3.371447123025432e-18,   2.303829461035382e-20,   7.795939122606709e-22,   3.807864095131110e-23,
   1.714417661270693e-25,  -8.481006990094208e-27,   5.667207640294903e-02,  -9.988785753902111e-04,   1.294046525499661e-05,  -1.452128295914044e-07,   1.464010215911264e-09,
  -1.354491969521491e-11,   1.088237405118535e-13,  -8.148349626338058e-16,   3.372095857421404e-18,   2.307695670315706e-20,   7.798011469277467e-22,   3.806639193538168e-23,
   1.708296110478375e-25,  -8.487663236640197e-27,   5.667211437880792e-02,  -9.988798532810982e-04,   1.294049101759533e-05,  -1.452132268133284e-07,   1.464015002464789e-09,
  -1.354496986183146e-11,   1.088240175375676e-13,  -8.148325152253871e-16,   3.372198807871817e-18,   2.308309146279848e-20,   7.798340093551181e-22,   3.806444789219303e-23,
   1.707324784155936e-25,  -8.488719163242210e-27,   1.575311039758999e-01,  -2.706260371741790e-03,   3.287181813711729e-05,  -3.240327845122611e-07,   2.529837414054671e-09,
  -1.318588672009943e-11,  -2.888228304045157e-14,   1.573375221152859e-15,  -2.818196539927571e-17,   3.352802085831395e-19,   1.358791194934870e-21,   9.449293761015227e-23,
   1.051879137037546e-24,  -2.972857204048499e-26,   1.575341885589839e-01,  -2.706351549227754e-03,   3.287324093320661e-05,  -3.240451200417920e-07,   2.529795925218933e-09,
  -1.318277091897698e-11,  -2.895613755599646e-14,   1.574519228537971e-15,  -2.817603828938979e-17,   3.357587133951873e-19,   1.364908048222704e-21,   9.426965143374861e-23,
   1.043404039656800e-24,  -2.983639532607462e-26,   1.575396314628597e-01,  -2.706512436154591e-03,   3.287575146014805e-05,  -3.240668838975744e-07,   2.529722633126263e-09,
  -1.317727120158374e-11,  -2.908644224616975e-14,   1.576539154123705e-15,  -2.816555917431276e-17,   3.366021006534267e-19,   1.375658874360173e-21,   9.387502740732780e-23,
   1.028465482153982e-24,  -3.002598524938607e-26,   1.575462132653797e-01,  -2.706706987150906e-03,   3.287878718348607e-05,  -3.240931969252378e-07,   2.529633863663957e-09,
  -1.317061775037993e-11,  -2.924398627567647e-14,   1.578983895736190e-15,  -2.815285262902547e-17,   3.376203255309109e-19,   1.388586549036558e-21,   9.339676881050073e-23,
   1.010428714495843e-24,  -3.025410548983593e-26,   1.575526029590629e-01,  -2.706895858922144e-03,   3.288173417691609e-05,  -3.241187369049446e-07,   2.529547537148869e-09,
  -1.316415541122952e-11,  -2.939690443191926e-14,   1.581359537363547e-15,  -2.814048071853711e-17,   3.386071144344732e-19,   1.401060828909625e-21,   9.293136134723745e-23,
   9.929473199223219e-25,  -3.047437527663571e-26,   1.575577505520054e-01,  -2.707048015169771e-03,   3.288410821194459e-05,  -3.241393085330076e-07,   2.529477885694284e-09,
  -1.315894708066735e-11,  -2.952007690381976e-14,   1.583274990332223e-15,  -2.813048792229217e-17,   3.394008489855340e-19,   1.411055769315696e-21,   9.255563344911968e-23,
   9.788848842033979e-25,  -3.065097385607885e-26,   1.575611520576843e-01,  -2.707148559072580e-03,   3.288567691996772e-05,  -3.241529004058997e-07,   2.529431808408881e-09,
  -1.315550435542662e-11,  -2.960145903539089e-14,   1.584541503076216e-15,  -2.812387209481205e-17,   3.399247416578307e-19,   1.417633741180062e-21,   9.230696759181309e-23,
   9.696026439465343e-25,  -3.076725247727221e-26,   1.575628989146248e-01,  -2.707200193723319e-03,   3.288648252287456e-05,  -3.241598800213451e-07,   2.529408129176083e-09,
  -1.315373599454273e-11,  -2.964325016409276e-14,   1.585192170047449e-15,  -2.812047061060635e-17,   3.401936020897561e-19,   1.421003651279119e-21,   9.217914489177765e-23,
   9.648388525164585e-25,  -3.082683902530678e-26,   1.575635069275263e-01,  -2.707218165723254e-03,   3.288676291975089e-05,  -3.241623092669192e-07,   2.529399884800657e-09,
  -1.315312044353893e-11,  -2.965779555255774e-14,   1.585418680764091e-15,  -2.811928606627099e-17,   3.402871521958806e-19,   1.422175275359511e-21,   9.213463580406798e-23,
   9.631812621827282e-25,  -3.084755828825609e-26,   1.575636034109589e-01,  -2.707221017636254e-03,   3.288680741484532e-05,  -3.241626947512462e-07,   2.529398576408315e-09,
  -1.315302276137527e-11,  -2.966010368655306e-14,   1.585454626799580e-15,  -2.811909806566549e-17,   3.403019959214669e-19,   1.422361134068141e-21,   9.212757191247207e-23,
   9.629182487314469e-25,  -3.085084518261522e-26,   3.090292551121578e-01,  -5.088202191161985e-03,   5.505872705024701e-05,  -4.087120410631000e-07,   1.057187496253301e-09,
   2.469826276604185e-11,  -5.213509308655422e-13,   4.866996318137990e-15,  -2.168386759974453e-17,  -2.682252373367925e-19,   1.581142385072108e-20,   9.116250427451678e-23,
   2.329360161955626e-24,  -4.635282912905657e-26,   3.090344180430424e-01,  -5.088317059339193e-03,   5.505931757462965e-05,  -4.086888060583145e-07,   1.056453693389531e-09,
   2.470783046174282e-11,  -5.214064631328388e-13,   4.866102901936265e-15,  -2.161673477488869e-17,  -2.677688639067687e-19,   1.582489701572613e-20,   9.081255835647884e-23,
   2.309032968608236e-24,  -4.655406587333768e-26,   3.090435281604624e-01,  -5.088519740721178e-03,   5.506035922847636e-05,  -4.086478002381745e-07,   1.055158823730240e-09,
   2.472471138738578e-11,  -5.215043071656432e-13,   4.864527697105500e-15,  -2.149823246135118e-17,  -2.669650639546021e-19,   1.584856872906938e-20,   9.019389587759614e-23,
   2.273197534129387e-24,  -4.690774208879329e-26,   3.090545442879041e-01,  -5.088764816135241e-03,   5.506161823499357e-05,  -4.085982031352782e-07,   1.053592946259718e-09,
   2.474512155646138e-11,  -5.216223764254786e-13,   4.862625057707084e-15,  -2.135486104624230e-17,  -2.659956241741608e-19,   1.587701918389259e-20,   8.944380074204162e-23,
   2.229919904643987e-24,  -4.733301189248165e-26,   3.090652386334262e-01,  -5.089002721596520e-03,   5.506283985724471e-05,  -4.085500421137599e-07,   1.052072707355907e-09,
   2.476493285593941e-11,  -5.217367395939919e-13,   4.860780219674059e-15,  -2.121559807062751e-17,  -2.650571558873607e-19,   1.590445670715272e-20,   8.871353232510701e-23,
   2.187964319069388e-24,  -4.774334847324705e-26,   3.090738539161894e-01,  -5.089194368328555e-03,   5.506382355069931e-05,  -4.085112348983373e-07,   1.050847942403048e-09,
   2.478089076293935e-11,  -5.218286852889330e-13,   4.859295624061091e-15,  -2.110335217406725e-17,  -2.643030376577797e-19,   1.592642994189554e-20,   8.812374591891976e-23,
   2.154206730104019e-24,  -4.807211648955938e-26,   3.090795467695088e-01,  -5.089321001738451e-03,   5.506447334748699e-05,  -4.084855872172843e-07,   1.050038600282959e-09,
   2.479143457384660e-11,  -5.218893513558872e-13,   4.858315403257923e-15,  -2.102915404057757e-17,  -2.638056610779046e-19,   1.594088581513653e-20,   8.773329727588550e-23,
   2.131920540462970e-24,  -4.828848352352412e-26,   3.090824703307225e-01,  -5.089386033021667e-03,   5.506480698418319e-05,  -4.084724144943325e-07,   1.049622952246612e-09,
   2.479684905018876e-11,  -5.219204784424873e-13,   4.857812251978294e-15,  -2.099104109417114e-17,  -2.635505226796082e-19,   1.594828992235728e-20,   8.753255842440603e-23,
   2.120481772127669e-24,  -4.839932739525163e-26,   3.090834879043516e-01,  -5.089408667591034e-03,   5.506492309913511e-05,  -4.084678293827638e-07,   1.049478280210505e-09,
   2.479873356448302e-11,  -5.219313080771730e-13,   4.857637163598247e-15,  -2.097777415796317e-17,  -2.634617653400829e-19,   1.595086385810051e-20,   8.746265368096391e-23,
   2.116501400261429e-24,  -4.843786450798236e-26,   3.090836493793376e-01,  -5.089412259377664e-03,   5.506494152448721e-05,  -4.084671017780373e-07,   1.049455322659192e-09,
   2.479903260886932e-11,  -5.219330263805981e-13,   4.857609381288736e-15,  -2.097566881260355e-17,  -2.634476829529551e-19,   1.595127215760328e-20,   8.745155906464678e-23,
   2.115869817361625e-24,  -4.844397777085628e-26,   5.108519447291627e-01,  -7.871856577941093e-03,   6.927089260294409e-05,  -2.113568652672009e-07,  -4.491587018235456e-09,
   8.314768046668244e-11,  -5.627302707401661e-13,  -5.088147427111784e-15,   1.465327006929300e-16,  -1.344277954690591e-18,   9.702911296493874e-21,   6.496852441806618e-22,
  -6.395190036237266e-25,  -8.129664242037094e-26,   5.108584337817670e-01,  -7.871915747692419e-03,   6.926836165159947e-05,  -2.112789993556467e-07,  -4.492373796057177e-09,
   8.313759260167787e-11,  -5.623447819818242e-13,  -5.092597765932561e-15,   1.465734571074123e-16,  -1.340952486248655e-18,   9.697596481379293e-21,   6.490610881768861e-22,
  -6.689187423264844e-25,  -8.183851063622931e-26,   5.108698836239088e-01,  -7.872020135861236e-03,   6.926389538933832e-05,  -2.111416114382283e-07,  -4.493761636867108e-09,
   8.311978532431627e-11,  -5.616644941247290e-13,  -5.100441352298982e-15,   1.466453530229944e-16,  -1.335087291487290e-18,   9.688071247357932e-21,   6.479565714792834e-22,
  -7.207285858349390e-25,  -8.279183472178153e-26,   5.108837285658180e-01,  -7.872146332821114e-03,   6.925849412565040e-05,  -2.109754936478184e-07,  -4.495439076735707e-09,
   8.309824051077364e-11,  -5.608417346736064e-13,  -5.109910378418232e-15,   1.467322568767777e-16,  -1.327999557101435e-18,   9.676302543138420e-21,   6.466155611640638e-22,
  -7.832642571655130e-25,  -8.393981797748676e-26,   5.108971686506488e-01,  -7.872268810886414e-03,   6.925325003202857e-05,  -2.108142431447375e-07,  -4.497066718679619e-09,
   8.307731255866716e-11,  -5.600428589834671e-13,  -5.119086496646848e-15,   1.468165861599441e-16,  -1.321123653988592e-18,   9.664615461679672e-21,   6.453080735434516e-22,
  -8.438540743234134e-25,  -8.504925614238397e-26,   5.109079955609174e-01,  -7.872367454869047e-03,   6.924902499973278e-05,  -2.106843517075402e-07,  -4.498377361457941e-09,
   8.306044423933444e-11,  -5.593991840455229e-13,  -5.126467020747165e-15,   1.468844950073740e-16,  -1.315587925022645e-18,   9.655012822213895e-21,   6.442507347993317e-22,
  -8.925793480597204e-25,  -8.593942543406396e-26,   5.109151496692638e-01,  -7.872432625914976e-03,   6.924623294913010e-05,  -2.105985265942399e-07,  -4.499243134485381e-09,
   8.304929353510099e-11,  -5.589738007407933e-13,  -5.131338243434605e-15,   1.469293552427752e-16,  -1.311931686435734e-18,   9.648575759926395e-21,   6.435500884059837e-22,
  -9.247344660128020e-25,  -8.652588306753680e-26,   5.109188236087632e-01,  -7.872466090920171e-03,   6.924479902812424e-05,  -2.105544527873655e-07,  -4.499687664884778e-09,
   8.304356574899152e-11,  -5.587553292471561e-13,  -5.133838088164319e-15,   1.469523891593750e-16,  -1.310054550910880e-18,   9.645241645345109e-21,   6.431896628066062e-22,
  -9.412347671463512e-25,  -8.682651629791258e-26,   5.109201023510890e-01,  -7.872477738173218e-03,   6.924429992773483e-05,  -2.105391127333598e-07,  -4.499842374152824e-09,
   8.304157192319109e-11,  -5.586792855666819e-13,  -5.134707901664731e-15,   1.469604056920598e-16,  -1.309401279219111e-18,   9.644076660458478e-21,   6.430641163172605e-22,
  -9.469757956855951e-25,  -8.693106839074614e-26,   5.109203052696020e-01,  -7.872479586405830e-03,   6.924422072685211e-05,  -2.105366784893595e-07,  -4.499866923736928e-09,
   8.304125552017710e-11,  -5.586672183548281e-13,  -5.134845915779511e-15,   1.469616777752964e-16,  -1.309297617917289e-18,   9.643891579054787e-21,   6.430441892123375e-22,
  -9.478867204111731e-25,  -8.694765528348723e-26,   7.613179842596162e-01,  -1.058160659431384e-02,   6.119175791027678e-05,   3.977811038123830e-07,  -1.127019672000575e-08,
   5.156558357067225e-11,   1.284542844099902e-12,  -2.492817904029219e-14,   1.338998976745365e-17,   4.827939957047136e-18,  -3.935810108168127e-20,   3.387532867114150e-22,
   2.291770422407808e-23,  -2.944789882656031e-25,   7.613237082702662e-01,  -1.058149454985398e-02,   6.118542863576034e-05,   3.978290362663455e-07,  -1.126838996397392e-08,
   5.151676627526379e-11,   1.284574668401768e-12,  -2.491184177694394e-14,   1.322837593117097e-17,   4.829602264591193e-18,  -3.921983990099324e-20,   3.365865501415250e-22,
   2.284114374283340e-23,  -2.947269917460307e-25,   7.613338078960648e-01,  -1.058129683475005e-02,   6.117426135747832e-05,   3.979135767087537e-07,  -1.126520187940244e-08,
   5.143065355870455e-11,   1.284630480654787e-12,  -2.488300991923553e-14,   1.294367687599087e-17,   4.832526335963688e-18,  -3.897626006171090e-20,   3.327618890461316e-22,
   2.270613657210044e-23,  -2.951605768591106e-25,   7.613460196513188e-01,  -1.058105773696815e-02,   6.116075917396437e-05,   3.980157406246112e-07,  -1.126134675384158e-08,
   5.132656976724613e-11,   1.284697386585141e-12,  -2.484813847389313e-14,   1.260021810259421e-17,   4.836046640129890e-18,  -3.868237549782046e-20,   3.281346624771127e-22,
   2.254302961042752e-23,  -2.956780294043245e-25,   7.613578737531144e-01,  -1.058082560554577e-02,   6.114765296312272e-05,   3.981148533260553e-07,  -1.125760420257032e-08,
   5.122557376176640e-11,   1.284761728231299e-12,  -2.481427788403013e-14,   1.226763335094852e-17,   4.839447839110427e-18,  -3.839776275413872e-20,   3.236401327386405e-22,
   2.238484047009984e-23,  -2.961732135738408e-25,   7.613674226480648e-01,  -1.058063858957105e-02,   6.113709582708377e-05,   3.981946497669637e-07,  -1.125458920767337e-08,
   5.114424618482211e-11,   1.284813124954987e-12,  -2.478699452064356e-14,   1.200030778812262e-17,   4.842176153175575e-18,  -3.816897318164589e-20,   3.200176226184134e-22,
   2.225751465213317e-23,  -2.965670161923607e-25,   7.613737320864906e-01,  -1.058051500593319e-02,   6.113012037718335e-05,   3.982473545996847e-07,  -1.125259693117934e-08,
   5.109052277093994e-11,   1.284846873731316e-12,  -2.476896336935877e-14,   1.182395745744431e-17,   4.843973270103653e-18,  -3.801803328619549e-20,   3.176230690594159e-22,
   2.217343361151810e-23,  -2.968247359522472e-25,   7.613769721918570e-01,  -1.058045153771524e-02,   6.112653830994672e-05,   3.982744138688783e-07,  -1.125157379522056e-08,
   5.106293829961772e-11,   1.284864139442076e-12,  -2.475970264866124e-14,   1.173348386550740e-17,   4.844894411192771e-18,  -3.794059268217471e-20,   3.163930854688955e-22,
   2.213027056419081e-23,  -2.969563158399073e-25,   7.613780999253706e-01,  -1.058042944668542e-02,   6.112529156412172e-05,   3.982838309516755e-07,  -1.125121768232330e-08,
   5.105333807930990e-11,   1.284870138444044e-12,  -2.475647923294094e-14,   1.170200814318052e-17,   4.845214741855885e-18,  -3.791365059014721e-20,   3.159649362180126e-22,
   2.211524991293024e-23,  -2.970019906823423e-25,   7.613782788804438e-01,  -1.058042594112731e-02,   6.112509372393941e-05,   3.982853252587303e-07,  -1.125116117206082e-08,
   5.105181469490108e-11,   1.284871089905290e-12,  -2.475596771475478e-14,   1.169701406492124e-17,   4.845265560583313e-18,  -3.790937581225878e-20,   3.158969928274266e-22,
   2.211286646792724e-23,  -2.970092328255822e-25,   1.055135176581695e+00,  -1.241526126727120e-02,   1.576582245203862e-05,   1.216234957516331e-06,  -7.709378442160722e-09,
  -1.899803171004368e-10,   2.566284250581856e-12,   2.616323037334365e-14,  -8.142516426469086e-16,  -1.598016734845461e-18,   2.518147324935075e-19,   8.174945102530535e-23,
  -4.132083871458119e-23,   4.109225272529224e-25,   1.055136645960410e+00,  -1.241491982759071e-02,   1.576150615114377e-05,   1.216057283587473e-06,  -7.705794597816670e-09,
  -1.899288938703527e-10,   2.564168589247821e-12,   2.615785126632585e-14,  -8.131975427890517e-16,  -1.597488475984791e-18,   2.515584997258053e-19,   8.452786997723792e-23,
  -4.133302985389891e-23,   4.067914703623315e-25,   1.055139238375729e+00,  -1.241431739244521e-02,   1.575389160326563e-05,   1.215743814308123e-06,  -7.699473258256260e-09,
  -1.898381653731373e-10,   2.560437716074763e-12,   2.614836127438526e-14,  -8.113384463113091e-16,  -1.596544938374733e-18,   2.511063123477850e-19,   8.940612811176105e-23,
  -4.135447762877529e-23,   3.995209883772837e-25,   1.055142372595339e+00,  -1.241358899055211e-02,   1.574468679418288e-05,   1.215364830678303e-06,  -7.691833534695772e-09,
  -1.897284701689972e-10,   2.555930130202158e-12,   2.613688849959469e-14,  -8.090919064149307e-16,  -1.595384605844414e-18,   2.505594193826295e-19,   9.526360283855048e-23,
  -4.138030376240199e-23,   3.907615056279676e-25,   1.055145414658629e+00,  -1.241288194297846e-02,   1.573575383882801e-05,   1.214996989847958e-06,  -7.684421322692019e-09,
  -1.896219953174867e-10,   2.551558248595130e-12,   2.612575370409771e-14,  -8.069125747376733e-16,  -1.594237951419405e-18,   2.500283974160299e-19,   1.009067159214422e-22,
  -4.140526124395376e-23,   3.822914625511444e-25,   1.055147864887718e+00,  -1.241231240649908e-02,   1.572855965333283e-05,   1.214700712149985e-06,  -7.678453220009833e-09,
  -1.895362315611300e-10,   2.548039185845577e-12,   2.611678566534909e-14,  -8.051580587682069e-16,  -1.593299793559545e-18,   2.496005360266784e-19,   1.054218345112958e-22,
  -4.142528478300897e-23,   3.754920718361497e-25,   1.055149483751044e+00,  -1.241193609232482e-02,   1.572380688537781e-05,   1.214504961649556e-06,  -7.674511110957219e-09,
  -1.894795657836839e-10,   2.545715255759377e-12,   2.611086073575184e-14,  -8.039992568932909e-16,  -1.592672836330620e-18,   2.493177752222820e-19,   1.083902426290909e-22,
  -4.143847583053493e-23,   3.710108718318794e-25,   1.055150315051614e+00,  -1.241174284484055e-02,   1.572136642752109e-05,   1.214404441985315e-06,  -7.672487115217187e-09,
  -1.894504668608078e-10,   2.544522240530202e-12,   2.610781830889494e-14,  -8.034043271034499e-16,  -1.592348692189998e-18,   2.491725524022895e-19,   1.099099977352674e-22,
  -4.144523763539714e-23,   3.687131807262254e-25,   1.055150604383328e+00,  -1.241167558453366e-02,   1.572051705410153e-05,   1.214369456403004e-06,  -7.671782719121571e-09,
  -1.894403389793108e-10,   2.544107069749432e-12,   2.610675941354207e-14,  -8.031972834738876e-16,  -1.592235525606103e-18,   2.491220044219122e-19,   1.104382203464881e-22,
  -4.144758916365879e-23,   3.679140241847440e-25,   1.055150650295808e+00,  -1.241166491130861e-02,   1.572038227262478e-05,   1.214363904730238e-06,  -7.671670944682532e-09,
  -1.894387318365852e-10,   2.544041191144341e-12,   2.610659138377041e-14,  -8.031644297893932e-16,  -1.592217551247375e-18,   2.491139830658866e-19,   1.105220067821149e-22,
  -4.144796222479634e-23,   3.677872363802253e-25,   1.378144608741898e+00,  -1.213671824731658e-02,  -6.654337213951460e-05,   1.250933779417842e-06,   1.702733199714040e-08,
  -2.380929989137342e-10,  -5.317621321759175e-12,   4.917806429322010e-14,   1.705573982191864e-15,  -1.099758864579163e-17,  -5.619868972834888e-19,   3.851629494530760e-21,
   2.494513714682260e-22,  -3.220691242415083e-25,   1.378138389454898e+00,  -1.213636720608022e-02,  -6.653383617046269e-05,   1.250711376240654e-06,   1.701990641311767e-08,
  -2.379967608431883e-10,  -5.313192023959075e-12,   4.914146200027845e-14,   1.703251243880328e-15,  -1.097783538892408e-17,  -5.604834937921938e-19,   3.848939794120796e-21,
   2.485829977293822e-22,  -3.281920057105722e-25,   1.378127416146819e+00,  -1.213574783900051e-02,  -6.651701318632816e-05,   1.250319015502954e-06,   1.700680889829170e-08,
  -2.378270055834876e-10,  -5.305381386132869e-12,   4.907693079865452e-14,   1.699157856860713e-15,  -1.094299207127171e-17,  -5.578350561508863e-19,   3.844157927636734e-21,
   2.470531656860923e-22,  -3.389548094802706e-25,   1.378114148335779e+00,  -1.213499898015366e-02,  -6.649667642135710e-05,   1.249844693432581e-06,   1.699097984172661e-08,
  -2.376218351075307e-10,  -5.295945074317637e-12,   4.899899123717661e-14,   1.694216811575403e-15,  -1.090087906559718e-17,  -5.546399312925747e-19,   3.838314686405347e-21,
   2.452074099893539e-22,  -3.518993490933908e-25,   1.378101269462658e+00,  -1.213427209145614e-02,  -6.647693987929021e-05,   1.249384360350166e-06,   1.697562226677699e-08,
  -2.374227631737866e-10,  -5.286793247705585e-12,   4.892342544218283e-14,   1.689429251017182e-15,  -1.086001746432447e-17,  -5.515458919333395e-19,   3.832578547069194e-21,
   2.434199047858863e-22,  -3.643926162229191e-25,   1.378090895332764e+00,  -1.213368658421266e-02,  -6.646104470197838e-05,   1.249013615533120e-06,   1.696325684853247e-08,
  -2.372624678842822e-10,  -5.279426940464837e-12,   4.886261980103630e-14,   1.685578980299127e-15,  -1.082711501011726e-17,  -5.490589069208118e-19,   3.827912152045648e-21,
   2.419830065537686e-22,  -3.744048114037751e-25,   1.378084040744306e+00,  -1.213329972319900e-02,  -6.645054356869932e-05,   1.248768679745225e-06,   1.695508915440382e-08,
  -2.371565840542277e-10,  -5.274562490599190e-12,   4.882247438106723e-14,   1.683037981527484e-15,  -1.080538109468041e-17,  -5.474182575451339e-19,   3.824806494870809e-21,
   2.410350423300457e-22,  -3.809951783354642e-25,   1.378080520724853e+00,  -1.213310106137360e-02,  -6.644515138879521e-05,   1.248642907654750e-06,   1.695089562775545e-08,
  -2.371022189064853e-10,  -5.272065313152723e-12,   4.880186825818447e-14,   1.681734043301878e-15,  -1.079422199795034e-17,  -5.465765418063582e-19,   3.823204742730900e-21,
   2.405486847353250e-22,  -3.843717684125706e-25,   1.378079295572086e+00,  -1.213303191686859e-02,  -6.644327469538525e-05,   1.248599133780377e-06,   1.694943618761266e-08,
  -2.370832984120030e-10,  -5.271196298914324e-12,   4.879469777527700e-14,   1.681280352600130e-15,  -1.079033834039860e-17,  -5.462837080051024e-19,   3.822646149064489e-21,
   2.403794778970389e-22,  -3.855457682404256e-25,   1.378079101158271e+00,  -1.213302094466209e-02,  -6.644297689493318e-05,   1.248592187576355e-06,   1.694920460192956e-08,
  -2.370802960752199e-10,  -5.271058405501795e-12,   4.879355999752163e-14,   1.681208365583085e-15,  -1.078972207492823e-17,  -5.462372456299227e-19,   3.822557456259436e-21,
   2.403526306323862e-22,  -3.857320063683950e-25,   1.695616919056467e+00,  -8.446646386105183e-03,  -1.270627302388750e-04,  -6.359985518593913e-07,   1.923224004519294e-08,
   4.821346381759431e-10,   1.642187944052257e-12,  -1.432387562367514e-13,  -3.116802501828766e-15,   9.612126560610169e-19,   1.300037907279796e-18,   2.443882975398626e-20,
  -6.442774130273989e-23,  -1.110841034391924e-23,   1.695605028690863e+00,  -8.446823677123247e-03,  -1.270518996790829e-04,  -6.355489214752487e-07,   1.923445412369755e-08,
   4.818527469092320e-10,   1.634119259474774e-12,  -1.432323212953828e-13,  -3.111333335061951e-15,   1.084093880747504e-18,   1.299570855182571e-18,   2.435825129218975e-20,
  -6.591425199637057e-23,  -1.109676675667091e-23,   1.695584048780340e+00,  -8.447136407519380e-03,  -1.270327879955065e-04,  -6.347557563954381e-07,   1.923835171970281e-08,
   4.813553571933018e-10,   1.619893600830693e-12,  -1.432206318679486e-13,  -3.101684565873102e-15,   1.300582624794845e-18,   1.298739334024599e-18,   2.421614008524808e-20,
  -6.853021327366192e-23,  -1.107610712947330e-23,   1.695558681057909e+00,  -8.447514389898563e-03,  -1.270096762575981e-04,  -6.337970189621012e-07,   1.924304909030479e-08,
   4.807539288197606e-10,   1.602711664980985e-12,  -1.432059265351315e-13,  -3.090020021532465e-15,   1.561788532054755e-18,   1.297721255574194e-18,   2.404441880168231e-20,
  -7.168151869700843e-23,  -1.105093101367394e-23,   1.695534055988196e+00,  -8.447881145897741e-03,  -1.269872380206555e-04,  -6.328666767878957e-07,   1.924759284563487e-08,
   4.801700945877782e-10,   1.586052556727377e-12,  -1.431910543923860e-13,  -3.078699290778823e-15,   1.814761257986990e-18,   1.296719764857601e-18,   2.387784215951481e-20,
  -7.472825789561143e-23,  -1.102628789587628e-23,   1.695514219409935e+00,  -8.448176468850594e-03,  -1.269691608089789e-04,  -6.321174800224771e-07,   1.925124151446900e-08,
   4.796997814296907e-10,   1.572647109273416e-12,  -1.431786467947378e-13,  -3.069581627284349e-15,   2.018122047292307e-18,   1.295903571100368e-18,   2.374374188179224e-20,
  -7.717372891914827e-23,  -1.100629117891721e-23,   1.695501112270271e+00,  -8.448371548911784e-03,  -1.269572150937419e-04,  -6.316225586888259e-07,   1.925364675405411e-08,
   4.793890148916391e-10,   1.563796329539478e-12,  -1.431702393356679e-13,  -3.063557906396195e-15,   2.152288403313251e-18,   1.295359648177964e-18,   2.365517587129386e-20,
  -7.878527783923727e-23,  -1.099300717760635e-23,   1.695494381287060e+00,  -8.448471712041149e-03,  -1.269510802071665e-04,  -6.313684345108119e-07,   1.925488018652998e-08,
   4.792294239126773e-10,   1.559253288399105e-12,  -1.431658571974261e-13,  -3.060464769337801e-15,   2.221124061460710e-18,   1.295078898042078e-18,   2.360970695894869e-20,
  -7.961153317077993e-23,  -1.098616344826446e-23,   1.695492038532212e+00,  -8.448506571581041e-03,  -1.269489448734488e-04,  -6.312799908874439e-07,   1.925530921177557e-08,
   4.791738772127371e-10,   1.557672400745241e-12,  -1.431643216890348e-13,  -3.059388227606503e-15,   2.245072566503088e-18,   1.294980954535270e-18,   2.359388331507669e-20,
  -7.989890371189317e-23,  -1.098377796615480e-23,   1.695491666770493e+00,  -8.448512103160175e-03,  -1.269486060239598e-04,  -6.312659564169429e-07,   1.925537727877663e-08,
   4.791650627355830e-10,   1.557421552709366e-12,  -1.431640775377731e-13,  -3.059217397776133e-15,   2.248872371867939e-18,   1.294965401531101e-18,   2.359137242652934e-20,
  -7.994449524450790e-23,  -1.098339925886010e-23,   1.933945857919535e+00,  -2.366470429040706e-03,  -5.994610140998579e-05,  -1.239834081121404e-06,  -2.109542690567308e-08,
  -2.701381789892237e-10,  -1.465081916715508e-12,   4.830509070266109e-14,   2.077373967213852e-15,   4.845431242646665e-17,   7.601658568774195e-19,   5.670681070822792e-21,
  -1.108518598929474e-22,  -5.627294443726418e-24,   1.933940214140135e+00,  -2.366820020649492e-03,  -5.995797878909842e-05,  -1.240086511010292e-06,  -2.109742180649313e-08,
  -2.700404644090054e-10,  -1.459563158988748e-12,   4.846933627068019e-14,   2.080556863993785e-15,   4.848190032473515e-17,   7.594263330317539e-19,   5.628410990380655e-21,
  -1.120076455889458e-22,  -5.647650874477242e-24,   1.933930254695842e+00,  -2.367436938127759e-03,  -5.997893750856585e-05,  -1.240531852243702e-06,  -2.110093550509754e-08,
  -2.698677822527114e-10,  -1.449818446011868e-12,   4.875922464323392e-14,   2.086170551847198e-15,   4.853040126172365e-17,   7.581156054546390e-19,   5.553704201254734e-21,
  -1.140481356477222e-22,  -5.683536619214857e-24,   1.933918210083249e+00,  -2.368183019509067e-03,  -6.000428254384104e-05,  -1.241070235130859e-06,  -2.110517349952283e-08,
  -2.696585242136301e-10,  -1.438023481477476e-12,   4.910988742545269e-14,   2.092954264246482e-15,   4.858874467699519e-17,   7.565207219580132e-19,   5.463162515407651e-21,
  -1.165173633816472e-22,  -5.726872589430267e-24,   1.933906515762674e+00,  -2.368907405192120e-03,  -6.002888866267626e-05,  -1.241592753188671e-06,  -2.110927634691554e-08,
  -2.694549099129940e-10,  -1.426561040271238e-12,   4.945043699679719e-14,   2.099535129862640e-15,   4.864506421164756e-17,   7.549620253070857e-19,   5.375051259196969e-21,
  -1.189163668262873e-22,  -5.768881798414737e-24,   1.933897093809932e+00,  -2.369491034518128e-03,  -6.004871217469906e-05,  -1.242013590283929e-06,  -2.111257342888026e-08,
  -2.692905438980032e-10,  -1.417318384981102e-12,   4.972487372925347e-14,   2.104833249193604e-15,   4.869020544941310e-17,   7.536988965586860e-19,   5.303916088717482e-21,
  -1.208503395563291e-22,  -5.802680144730221e-24,   1.933890867383341e+00,  -2.369876722431597e-03,  -6.006181175706458e-05,  -1.242291624563743e-06,  -2.111474810493200e-08,
  -2.691817687387364e-10,  -1.411206763407150e-12,   4.990626274434581e-14,   2.108332511521925e-15,   4.871992170243527e-17,   7.528605881782121e-19,   5.256835938607242e-21,
  -1.221289399037027e-22,  -5.824991956850918e-24,   1.933887669639679e+00,  -2.370074802778085e-03,  -6.006853919204979e-05,  -1.242434393807824e-06,  -2.111586367481295e-08,
  -2.691258564481607e-10,  -1.408066842458435e-12,   4.999942891692208e-14,   2.110129041746132e-15,   4.873514767216514e-17,   7.524289459641317e-19,   5.232634753563493e-21,
  -1.227857674461771e-22,  -5.836443454322370e-24,   1.933886556607745e+00,  -2.370143748231408e-03,  -6.007088076487649e-05,  -1.242484083615499e-06,  -2.111625176322004e-08,
  -2.691063875369551e-10,  -1.406973755556794e-12,   5.003185852025070e-14,   2.110754259507915e-15,   4.874044167605062e-17,   7.522785288968919e-19,   5.224207605004022e-21,
  -1.230144148692016e-22,  -5.840428186179451e-24,   1.933886379983578e+00,  -2.370154689009570e-03,  -6.007125234153931e-05,  -1.242491968592761e-06,  -2.111631333820437e-08,
  -2.691032977030772e-10,  -1.406800287814472e-12,   5.003700475909259e-14,   2.110853469107163e-15,   4.874128149877697e-17,   7.522546512322231e-19,   5.222870156744366e-21,
  -1.230506996116397e-22,  -5.841060457558992e-24,   5.865854855457715e-03,  -1.010435780125804e-04,   1.301071403871327e-06,  -1.489399262207463e-08,   1.583131369477586e-10,
  -1.635866333700670e-12,   1.567225933849498e-14,  -1.579068599192218e-16,   1.602880280308723e-18,  -3.017883514496355e-21,   4.051243160893421e-22,   1.628371612770395e-24,
  -7.516153661101604e-26,  -3.559395639782890e-27,   5.865977009680773e-03,  -1.010477723514982e-04,   1.301160579550197e-06,  -1.489552885903727e-08,   1.583352262448675e-10,
  -1.636177370814630e-12,   1.567650182173680e-14,  -1.579168563681116e-16,   1.604573905503667e-18,  -3.010485858929558e-21,   4.046448031215914e-22,   1.602657257231002e-24,
  -7.547579174925766e-26,  -3.553722806030606e-27,   5.866192559544099e-03,  -1.010551736803413e-04,   1.301317941554443e-06,  -1.489823981048486e-08,   1.583742080218075e-10,
  -1.636726216612759e-12,   1.568399135526179e-14,  -1.579344756945956e-16,   1.607560676552680e-18,  -2.997540052985194e-21,   4.037971320149303e-22,   1.557317705560812e-24,
  -7.602867684860466e-26,  -3.543704940501606e-27,   5.866453216362660e-03,  -1.010641240462107e-04,   1.301508242621479e-06,  -1.490151832632568e-08,   1.584213535005072e-10,
  -1.637389913935766e-12,   1.569305392378991e-14,  -1.579557480143169e-16,   1.611169482621128e-18,  -2.982069000390144e-21,   4.027694597009349e-22,   1.502550356204652e-24,
  -7.669446702240701e-26,  -3.531577525981405e-27,   5.866706269660021e-03,  -1.010728135347786e-04,   1.301693001669421e-06,  -1.490470147623192e-08,   1.584671302078232e-10,
  -1.638034248181485e-12,   1.570185813986597e-14,  -1.579763643483630e-16,   1.614669881522706e-18,  -2.967241643484003e-21,   4.017690354641031e-22,   1.449443647706079e-24,
  -7.733791359231108e-26,  -3.519790142012734e-27,   5.866910134825757e-03,  -1.010798141239860e-04,   1.301841854101522e-06,  -1.490726608383070e-08,   1.585040135587558e-10,
  -1.638553335781462e-12,   1.570895530774182e-14,  -1.579929480856024e-16,   1.617487627841015e-18,  -2.955434163126423e-21,   4.009611214708658e-22,   1.406704941260729e-24,
  -7.785419708934225e-26,  -3.510284168954360e-27,   5.867044849565419e-03,  -1.010844402090773e-04,   1.301940219476120e-06,  -1.490896087941573e-08,   1.585283884718027e-10,
  -1.638896349557680e-12,   1.571364724412782e-14,  -1.580038943944654e-16,   1.619348500426989e-18,  -2.947699154136343e-21,   4.004262962901766e-22,   1.378485210911883e-24,
  -7.819433623003479e-26,  -3.503997806758133e-27,   5.867114033350640e-03,  -1.010868159933022e-04,   1.301990736763155e-06,  -1.490983128398913e-08,   1.585409070999659e-10,
  -1.639072506616019e-12,   1.571605747493239e-14,  -1.580095121741683e-16,   1.620303824396947e-18,  -2.943747620361519e-21,   4.001513384160449e-22,   1.363999601978964e-24,
  -7.836870127825729e-26,  -3.500767920533563e-27,   5.867138113610888e-03,  -1.010876429176131e-04,   1.302008320079667e-06,  -1.491013424358678e-08,   1.585452644734484e-10,
  -1.639133820182240e-12,   1.571689648877778e-14,  -1.580114669103747e-16,   1.620636282183626e-18,  -2.942375557741705e-21,   4.000555891589201e-22,   1.358958799765762e-24,
  -7.842934087232958e-26,  -3.499643484404718e-27,   5.867141934826531e-03,  -1.010877741396279e-04,   1.302011110324654e-06,  -1.491018231944977e-08,   1.585459559357453e-10,
  -1.639143549823981e-12,   1.571702963398637e-14,  -1.580117770724186e-16,   1.620689036211748e-18,  -2.942157987181038e-21,   4.000403928091176e-22,   1.358158943569116e-24,
  -7.843896117901986e-26,  -3.499465040268234e-27,   5.286194385101859e-02,  -9.015806486418131e-04,   1.132276151002397e-05,  -1.237112413045256e-07,   1.216153363570228e-09,
  -1.117951947555672e-11,   8.756383455971940e-14,  -6.873900267424544e-16,   5.067641384082342e-18,   8.633709903946274e-20,   2.432526340427297e-21,   2.876075091746753e-23,
  -8.233556998904902e-25,  -3.140110825490885e-26,   5.286300673250439e-02,  -9.016154793193640e-04,   1.132344629100373e-05,  -1.237217334174799e-07,   1.216276660067953e-09,
  -1.118086807185478e-11,   8.757734503044781e-14,  -6.870950381046670e-16,   5.077734663902109e-18,   8.647659400301770e-20,   2.427294018753700e-21,   2.853406433139432e-23,
  -8.263517337677986e-25,  -3.134805332244017e-26,   5.286488225591186e-02,  -9.016769409998456e-04,   1.132465465425669e-05,  -1.237402479425628e-07,   1.216494234209092e-09,
  -1.118324721735696e-11,   8.760120590653904e-14,  -6.865741497086873e-16,   5.095526348560359e-18,   8.672178779417966e-20,   2.418046598084313e-21,   2.813438869883619e-23,
  -8.316233635597423e-25,  -3.125436235438967e-26,   5.286715024804263e-02,  -9.017512652163476e-04,   1.132611591625535e-05,  -1.237626376545030e-07,   1.216757353684036e-09,
  -1.118612329710411e-11,   8.763009525981440e-14,  -6.859436460415955e-16,   5.117009404305618e-18,   8.701666448792874e-20,   2.406839152164952e-21,   2.765163646837169e-23,
  -8.379724642677764e-25,  -3.114094323529961e-26,   5.286935206894437e-02,  -9.018234221684431e-04,   1.132753458489967e-05,  -1.237843750319666e-07,   1.217012813286350e-09,
  -1.118891449845611e-11,   8.765817876070184e-14,  -6.853308962135375e-16,   5.137832443872644e-18,   8.730123640407170e-20,   2.395932659922049e-21,   2.718355463197262e-23,
  -8.441094874939612e-25,  -3.103070540640006e-26,   5.287112589415332e-02,  -9.018815539440946e-04,   1.132867751813127e-05,  -1.238018876934571e-07,   1.217218628132504e-09,
  -1.119116244667206e-11,   8.768082982211356e-14,  -6.848367960536113e-16,   5.154584011727063e-18,   8.752927429946954e-20,   2.387127592070090e-21,   2.680687956393185e-23,
  -8.490343786168965e-25,  -3.094180463856605e-26,   5.287229803902099e-02,  -9.019199678907545e-04,   1.132943278341328e-05,  -1.238134603909312e-07,   1.217354636672242e-09,
  -1.119264755331302e-11,   8.769581062568075e-14,  -6.845100706274925e-16,   5.165641776446673e-18,   8.767936578657697e-20,   2.381300105347268e-21,   2.655817807678370e-23,
  -8.522793588074655e-25,  -3.088301440863480e-26,   5.287290000163003e-02,  -9.019396957558182e-04,   1.132982065921050e-05,  -1.238194037235710e-07,   1.217424486583550e-09,
  -1.119341013459877e-11,   8.770350812270955e-14,  -6.843422096165160e-16,   5.171316947873857e-18,   8.775626196934714e-20,   2.378304553918135e-21,   2.643051943230492e-23,
  -8.539429374028191e-25,  -3.085280855782179e-26,   5.287310952184215e-02,  -9.019465622940116e-04,   1.132995566467496e-05,  -1.238214723865638e-07,   1.217448798965492e-09,
  -1.119367554334405e-11,   8.770618796556879e-14,  -6.842837726246085e-16,   5.173291682657645e-18,   8.778299726597256e-20,   2.377261470139226e-21,   2.638609646005229e-23,
  -8.545215038143507e-25,  -3.084229286801315e-26,   5.287314276989084e-02,  -9.019476519225729e-04,   1.132997708826550e-05,  -1.238218006563927e-07,   1.217452657028491e-09,
  -1.119371765936089e-11,   8.770661325098184e-14,  -6.842744989364370e-16,   5.173605019252850e-18,   8.778723840685849e-20,   2.377095925531465e-21,   2.637904761087024e-23,
  -8.546132926275243e-25,  -3.084062406530346e-26,   1.472083298947307e-01,  -2.458171504333312e-03,   2.921750126615459e-05,  -2.856894969401016e-07,   2.262279060634283e-09,
  -1.344057191905191e-11,   4.486268504338794e-15,   8.838911277051064e-16,  -1.405111334293155e-17,   4.798074377983117e-19,   5.792546744578673e-21,   8.147439703641672e-23,
  -2.164938881126020e-24,  -9.442273558603541e-26,   1.472110715847008e-01,  -2.458251898674238e-03,   2.921877382858424e-05,  -2.857020825768566e-07,   2.262284939859519e-09,
  -1.343880581995227e-11,   4.449878549936124e-15,   8.855206303283943e-16,  -1.402712112229593e-17,   4.802010471051630e-19,   5.778765197406832e-21,   8.079222831791734e-23,
  -2.173333455017518e-24,  -9.427270472340075e-26,   1.472159094368552e-01,  -2.458393758630887e-03,   2.922101928763260e-05,  -2.857242887771318e-07,   2.262295272434837e-09,
  -1.343568689712135e-11,   4.385718833597891e-15,   8.883969739534561e-16,  -1.398483407711593e-17,   4.808927257607012e-19,   5.754405696010446e-21,   7.958942573935707e-23,
  -2.188101967771540e-24,  -9.400775510357111e-26,   1.472217595848846e-01,  -2.458565302112093e-03,   2.922373452516314e-05,  -2.857511384421089e-07,   2.262307696127334e-09,
  -1.343191100546370e-11,   4.308222990209046e-15,   8.918768824810910e-16,  -1.393378139908561e-17,   4.817242520922132e-19,   5.724878899180272e-21,   7.813651069369665e-23,
  -2.205885534855223e-24,  -9.368700496142237e-26,   1.472274389806511e-01,  -2.458731838691406e-03,   2.922637043540881e-05,  -2.857772012117071e-07,   2.262319682985482e-09,
  -1.342824076657678e-11,   4.233082143459834e-15,   8.952569987930505e-16,  -1.388430557094841e-17,   4.825263985655888e-19,   5.696140608627464e-21,   7.672764576396324e-23,
  -2.223071419293504e-24,  -9.337524002194080e-26,   1.472320143522117e-01,  -2.458866002074594e-03,   2.922849389374608e-05,  -2.857981953045344e-07,   2.262329286566722e-09,
  -1.342528072377653e-11,   4.172614632542230e-15,   8.979813197123699e-16,  -1.384450964005781e-17,   4.831689563402597e-19,   5.672936395748590e-21,   7.559382956897504e-23,
  -2.236860264123473e-24,  -9.312381050759935e-26,   1.472350377370384e-01,  -2.458954656650241e-03,   2.922989703880952e-05,  -2.858120669768733e-07,   2.262335606567113e-09,
  -1.342332314148033e-11,   4.132690568030057e-15,   8.997821581588381e-16,  -1.381824317510775e-17,   4.835917652800117e-19,   5.657577559906931e-21,   7.484518597852821e-23,
  -2.245944356700051e-24,  -9.295753576536152e-26,   1.472365904086157e-01,  -2.459000185574093e-03,   2.923061762143833e-05,  -2.858191904813149e-07,   2.262338844190693e-09,
  -1.342231732241928e-11,   4.112197476375919e-15,   9.007071772407242e-16,  -1.380476336678167e-17,   4.838083470654272e-19,   5.649682062959355e-21,   7.446089553009882e-23,
  -2.250601027082948e-24,  -9.287210419022074e-26,   1.472371308331710e-01,  -2.459016032421702e-03,   2.923086842690080e-05,  -2.858216698403852e-07,   2.262339969802047e-09,
  -1.342196715717945e-11,   4.105066231947827e-15,   9.010291707844683e-16,  -1.380007307382239e-17,   4.838836426631916e-19,   5.646932690388582e-21,   7.432716740448714e-23,
  -2.252220479836774e-24,  -9.284236234276005e-26,   1.472372165912471e-01,  -2.459018547102382e-03,   2.923090822627733e-05,  -2.858220632785347e-07,   2.262340148360630e-09,
  -1.342191158694697e-11,   4.103934675898802e-15,   9.010802682522952e-16,  -1.379932885909374e-17,   4.838955868756585e-19,   5.646496342435211e-21,   7.430594790706760e-23,
  -2.252477400891884e-24,  -9.283764240775637e-26,   2.895267740300046e-01,  -4.667029649214277e-03,   5.026989426904758e-05,  -3.884803072310190e-07,   1.436640393148388e-09,
   1.373840778537932e-11,  -3.953177898700055e-13,   4.149980734730813e-15,  -1.878632172216897e-17,   4.633111358678309e-19,   2.075572926061882e-20,   8.361338154681966e-23,
  -3.951372243263988e-24,  -1.948934614530432e-25,   2.895314884392021e-01,  -4.667138863461867e-03,   5.027069923628041e-05,  -3.884673585699448e-07,   1.436083919352523e-09,
   1.374660308980755e-11,  -3.953653148557724e-13,   4.151554005475221e-15,  -1.869957725595157e-17,   4.636876493148229e-19,   2.073040528639975e-20,   8.220677526414691e-23,
  -3.970387943092484e-24,  -1.945579823683115e-25,   2.895398071495013e-01,  -4.667331570749977e-03,   5.027211935903339e-05,  -3.884445041993155e-07,   1.435101958938879e-09,
   1.376106635642305e-11,  -3.954489888165697e-13,   4.154331059509514e-15,  -1.854660290118070e-17,   4.643461357017632e-19,   2.068562609380748e-20,   7.972679706801985e-23,
  -4.003849402743663e-24,  -1.939655553880507e-25,   2.895498663270532e-01,  -4.667564589396881e-03,   5.027383615252134e-05,  -3.884168577844653e-07,   1.433914470587137e-09,
   1.377855979597390e-11,  -3.955498535931308e-13,   4.157690785140560e-15,  -1.836177429802764e-17,   4.651323685803602e-19,   2.063131755973495e-20,   7.673139421601102e-23,
  -4.044154597662938e-24,  -1.932483895033720e-25,   2.895596317115727e-01,  -4.667790794560636e-03,   5.027550233129635e-05,  -3.883900079527867e-07,   1.432761581997003e-09,
   1.379554663170706e-11,  -3.956474420165916e-13,   4.160954096172603e-15,  -1.818250285265457e-17,   4.658851486459234e-19,   2.057842752168108e-20,   7.382708573722117e-23,
  -4.083118254659141e-24,  -1.925513461148128e-25,   2.895674986564912e-01,  -4.667973018696953e-03,   5.027684425749770e-05,  -3.883683700725902e-07,   1.431832761678660e-09,
   1.380923423616930e-11,  -3.957258221154295e-13,   4.163584219306896e-15,  -1.803819676923432e-17,   4.664840739116281e-19,   2.053569972574676e-20,   7.148997702280308e-23,
  -4.114389576668918e-24,  -1.919892238105852e-25,   2.895726970318063e-01,  -4.668093427298177e-03,   5.027773081892337e-05,  -3.883540682268945e-07,   1.431218980387505e-09,
   1.381828034348054e-11,  -3.957774988491303e-13,   4.165322762039368e-15,  -1.794289712199115e-17,   4.668761607149773e-19,   2.050740718687829e-20,   6.994691351101519e-23,
  -4.134995744066386e-24,  -1.916174938800698e-25,   2.895753666580942e-01,  -4.668155262300376e-03,   5.027818606130693e-05,  -3.883467223324354e-07,   1.430903764016950e-09,
   1.382292644179021e-11,  -3.958040016338639e-13,   4.166215772927396e-15,  -1.789397329429591e-17,   4.670763807892537e-19,   2.049285946286760e-20,   6.915486522984961e-23,
  -4.145560270106850e-24,  -1.914265034327779e-25,   2.895762958478548e-01,  -4.668176784447474e-03,   5.027834450473417e-05,  -3.883441653335762e-07,   1.430794048432269e-09,
   1.382454363676925e-11,  -3.958132204896854e-13,   4.166526623081962e-15,  -1.787694763206351e-17,   4.671458885244583e-19,   2.048779310671886e-20,   6.887924746111284e-23,
  -4.149234529225351e-24,  -1.913600132528064e-25,   2.895764432975622e-01,  -4.668180199711458e-03,   5.027836964715113e-05,  -3.883437595639093e-07,   1.430776638002161e-09,
   1.382480026703905e-11,  -3.958146831254572e-13,   4.166575952121079e-15,  -1.787424602329768e-17,   4.671569098673682e-19,   2.048698900873391e-20,   6.883551365541448e-23,
  -4.149817449651351e-24,  -1.913494615029230e-25,   4.804552251810134e-01,  -7.328934864944179e-03,   6.635580778156249e-05,  -2.706918708195695e-07,  -2.972665788492100e-09,
   6.842172335754934e-11,  -6.459753344195848e-13,  -1.043989661348198e-15,   1.117691313607081e-16,  -4.169896921504505e-19,   3.506695095964546e-20,   4.203724346791885e-22,
  -1.109285907320486e-23,  -3.276620356135453e-25,   4.804614426587373e-01,  -7.329010771008499e-03,   6.635413055445650e-05,  -2.706277430616364e-07,  -2.973570679716503e-09,
   6.841964659589517e-11,  -6.456789393696043e-13,  -1.045343254963277e-15,   1.119148051810675e-16,  -4.149140512968232e-19,   3.499675973655904e-20,   4.180059109052324e-22,
  -1.112666738930471e-23,  -3.271286249648319e-25,   4.804724133677133e-01,  -7.329144693794918e-03,   6.635117064780649e-05,  -2.705145902116542e-07,  -2.975167034498852e-09,
   6.841597997697956e-11,  -6.451556361234532e-13,  -1.047726064377049e-15,   1.121716068281721e-16,  -4.112614406010457e-19,   3.487273815227762e-20,   4.138333247433810e-22,
  -1.118614106039017e-23,  -3.261865833090855e-25,   4.804856790474775e-01,  -7.329306609665969e-03,   6.634759079290613e-05,  -2.703777672847689e-07,  -2.977096783756780e-09,
   6.841154261892292e-11,  -6.445223248487097e-13,  -1.050597805635903e-15,   1.124817209300679e-16,  -4.068615192566559e-19,   3.472248398298683e-20,   4.087932183467691e-22,
  -1.125774791213412e-23,  -3.250460459310758e-25,   4.804985569106683e-01,  -7.329463768618530e-03,   6.634411479448911e-05,  -2.702449447932501e-07,  -2.978969543253029e-09,
   6.840723110110540e-11,  -6.439069653930653e-13,  -1.053375636701124e-15,   1.127823411404767e-16,  -4.026077899968339e-19,   3.457632119326467e-20,   4.039060601422963e-22,
  -1.132693911203107e-23,  -3.239373612013679e-25,   4.805089309856226e-01,  -7.329590355074848e-03,   6.634131404722837e-05,  -2.701379467553855e-07,  -2.980477778332163e-09,
   6.840375507589351e-11,  -6.434108447516471e-13,  -1.055606268950710e-15,   1.130242061408998e-16,  -3.991936705027427e-19,   3.445836093392045e-20,   3.999731087898795e-22,
  -1.138244718040054e-23,  -3.230431698223832e-25,   4.805157859091607e-01,  -7.329673991968710e-03,   6.633946310477923e-05,  -2.700672453543561e-07,  -2.981474179827333e-09,
   6.840145684954409e-11,  -6.430828237640610e-13,  -1.057076735759895e-15,   1.131838739404323e-16,  -3.969438615615665e-19,   3.438031062729702e-20,   3.973762833532954e-22,
  -1.141901272139242e-23,  -3.224517920670954e-25,   4.805193062155323e-01,  -7.329716940676171e-03,   6.633851247731568e-05,  -2.700309371101854e-07,  -2.981985813663749e-09,
   6.840027618925188e-11,  -6.429143095376636e-13,  -1.057830811322621e-15,   1.132658238699122e-16,  -3.957903876570226e-19,   3.434019586234729e-20,   3.960433076274073e-22,
  -1.143775589494465e-23,  -3.221479333245631e-25,   4.805205314864449e-01,  -7.329731888915077e-03,   6.633818158999375e-05,  -2.700182997423738e-07,  -2.982163881995785e-09,
   6.839986518421985e-11,  -6.428556471074894e-13,  -1.058093102497057e-15,   1.132943397882332e-16,  -3.953892146140341e-19,   3.432622842937317e-20,   3.955794516901818e-22,
  -1.144427406149876e-23,  -3.220421473913442e-25,   4.805207259198761e-01,  -7.329734260973261e-03,   6.633812908212860e-05,  -2.700162943684766e-07,  -2.982192138488697e-09,
   6.839979996027758e-11,  -6.428463377362899e-13,  -1.058134716344061e-15,   1.132988645153966e-16,  -3.953255684131077e-19,   3.432401174706682e-20,   3.955058488164859e-22,
  -1.144530814054344e-23,  -3.220253594290277e-25,   7.199966452389855e-01,  -1.007595643704760e-02,   6.492200941823568e-05,   2.271490062932781e-07,  -9.986236450025730e-09,
   7.421793570457087e-11,   6.167673532145015e-13,  -2.197693334518174e-14,   1.648759659543672e-16,   3.801468082447819e-18,  -8.045248502693050e-21,   8.564753665599071e-22,
  -5.664088695492440e-24,  -7.863740141161393e-25,   7.200027203991480e-01,  -1.007589230778816e-02,   6.491639709862948e-05,   2.272182236303493e-07,  -9.985364014171981e-09,
   7.417487474543389e-11,   6.171994217800205e-13,  -2.196399491561872e-14,   1.648408021847681e-16,   3.805663769267250e-18,  -8.082883268671199e-21,   8.507969498429058e-22,
  -5.720351232642276e-24,  -7.850728830865598e-25,   7.200134396878128e-01,  -1.007577913493512e-02,   6.490649447242427e-05,   2.273403259552858e-07,  -9.983824093670600e-09,
   7.409891376678473e-11,   6.179617377797098e-13,  -2.194115350216761e-14,   1.647786238138605e-16,   3.813043394397559e-18,  -8.149570369701350e-21,   8.407850521101480e-22,
  -5.819350024414249e-24,  -7.827753260569601e-25,   7.200264008381243e-01,  -1.007564225823494e-02,   6.489452079325174e-05,   2.274879175516885e-07,  -9.981961163585616e-09,
   7.400709635161508e-11,   6.188834090238665e-13,  -2.191351411116808e-14,   1.647032124538442e-16,   3.821926476178726e-18,  -8.230685535554851e-21,   8.286917930520217e-22,
  -5.938588140730856e-24,  -7.799942243865561e-25,   7.200389825360867e-01,  -1.007550935256484e-02,   6.488289766740630e-05,   2.276311384579482e-07,  -9.980151781898333e-09,
   7.391799869291365e-11,   6.197780157507394e-13,  -2.188666210455215e-14,   1.646297683695209e-16,   3.830507698546871e-18,  -8.309928413608411e-21,   8.169657343381064e-22,
  -6.053848646712973e-24,  -7.772913874982452e-25,   7.200491176421099e-01,  -1.007540226532851e-02,   6.487353474054481e-05,   2.277464734804232e-07,  -9.978693536068714e-09,
   7.384624936975632e-11,   6.204986018470274e-13,  -2.186501606958444e-14,   1.645704330615464e-16,   3.837390317887328e-18,  -8.374121176455838e-21,   8.075293162659983e-22,
  -6.146347755044811e-24,  -7.751118844521218e-25,   7.200558144721768e-01,  -1.007533149412294e-02,   6.486734813609444e-05,   2.278226643084817e-07,  -9.977729644038070e-09,
   7.379885171977956e-11,   6.209747045181378e-13,  -2.185070571706509e-14,   1.645311420169858e-16,   3.841923401679721e-18,  -8.416712441212742e-21,   8.012987697834438e-22,
  -6.207296773894713e-24,  -7.736706676634389e-25,   7.200592535321403e-01,  -1.007529514667137e-02,   6.486417109627289e-05,   2.278617856052613e-07,  -9.977234543752555e-09,
   7.377451478754521e-11,   6.212191912274597e-13,  -2.184335449312472e-14,   1.645109383647280e-16,   3.844246772998535e-18,  -8.438638778906879e-21,   7.981005928033521e-22,
  -6.238543635405898e-24,  -7.729302131605970e-25,   7.200604505152874e-01,  -1.007528249512227e-02,   6.486306531082075e-05,   2.278754011217609e-07,  -9.977062204343802e-09,
   7.376604473690435e-11,   6.213042847091685e-13,  -2.184079548664204e-14,   1.645039021833518e-16,   3.845054714020455e-18,  -8.446278981782916e-21,   7.969876779417477e-22,
  -6.249410898335205e-24,  -7.726724402112911e-25,   7.200606404594028e-01,  -1.007528048747261e-02,   6.486288983848506e-05,   2.278775616688092e-07,  -9.977034855730578e-09,
   7.376470068697469e-11,   6.213177877608946e-13,  -2.184038939115258e-14,   1.645027854428196e-16,   3.845182888498081e-18,  -8.447491782058169e-21,   7.968110850714602e-22,
  -6.251134980171549e-24,  -7.726315327758483e-25,   1.005815506045521e+00,  -1.223311836799650e-02,   2.950654751359257e-05,   1.066030587318770e-06,  -1.084892874249985e-08,
  -1.225270661734083e-10,   2.939162673161656e-12,   1.105629651079710e-15,  -6.944307441606226e-16,   8.026716271378812e-18,   2.176402238543090e-19,  -1.564771169037865e-21,
  -3.332055032195172e-23,  -2.650994739736793e-25,   1.005818260075614e+00,  -1.223281895200361e-02,   2.950046820171806e-05,   1.065915740734116e-06,  -1.084481685871885e-08,
  -1.225244624252827e-10,   2.937358595594949e-12,   1.132507172595791e-15,  -6.935194584840222e-16,   8.018572422771604e-18,   2.174272325056832e-19,  -1.566711675603233e-21,
  -3.346896032355835e-23,  -2.651439391946340e-25,   1.005823119144518e+00,  -1.223229065402230e-02,   2.948974303552976e-05,   1.065713094241674e-06,  -1.083756343017879e-08,
  -1.225198251553993e-10,   2.934177212912767e-12,   1.179910581517227e-15,  -6.919122170377694e-16,   8.004194337267498e-18,   2.170506684952858e-19,  -1.570135913084212e-21,
  -3.373000334529121e-23,  -2.652163590403286e-25,   1.005828993997420e+00,  -1.223165187521407e-02,   2.947677724680052e-05,   1.065468055562838e-06,  -1.082879600945101e-08,
  -1.225141445694565e-10,   2.930333558724782e-12,   1.237193079855959e-15,  -6.899699809633762e-16,   7.986794328808482e-18,   2.165940687421632e-19,  -1.574276825438953e-21,
  -3.404424833571512e-23,  -2.652936536997836e-25,   1.005834696380864e+00,  -1.223103180667118e-02,   2.946419363039935e-05,   1.065230180079601e-06,  -1.082028841508611e-08,
  -1.225085533847508e-10,   2.926605668225912e-12,   1.292761904808020e-15,  -6.880858107871925e-16,   7.969888172765241e-18,   2.161494994995743e-19,  -1.578297021738314e-21,
  -3.434783698400933e-23,  -2.653579569595206e-25,   1.005839289557896e+00,  -1.223053232109617e-02,   2.945405883010457e-05,   1.065038553444074e-06,  -1.081343743295166e-08,
  -1.225039943589149e-10,   2.923605007978574e-12,   1.337498730378808e-15,  -6.865688943847328e-16,   7.956258383011254e-18,   2.157904241641830e-19,  -1.581535811338293e-21,
  -3.459134912654316e-23,  -2.654020883537537e-25,   1.005842324359143e+00,  -1.223020228636741e-02,   2.944736310822854e-05,   1.064911931336628e-06,  -1.080891171084349e-08,
  -1.225009549936037e-10,   2.921623438952296e-12,   1.367045971313473e-15,  -6.855670071447809e-16,   7.947246963475135e-18,   2.155526962514832e-19,  -1.583676021071606e-21,
  -3.475174184760222e-23,  -2.654275018618526e-25,   1.005843882785637e+00,  -1.223003280282717e-02,   2.944392489756800e-05,   1.064846905248006e-06,  -1.080658793322455e-08,
  -1.224993858347785e-10,   2.920606183740647e-12,   1.382215545047779e-15,  -6.850526337666552e-16,   7.942617591962318e-18,   2.154304703797028e-19,  -1.584775142571558e-21,
  -3.483395183998714e-23,  -2.654393955816677e-25,   1.005844425196057e+00,  -1.222997381333837e-02,   2.944272825463140e-05,   1.064824272389738e-06,  -1.080577918437312e-08,
  -1.224988383535878e-10,   2.920252178488943e-12,   1.387494761749000e-15,  -6.848736242842358e-16,   7.941006045845882e-18,   2.153879060837893e-19,  -1.585157705114325e-21,
  -3.486254042713658e-23,  -2.654433512008552e-25,   1.005844511268447e+00,  -1.222996445255734e-02,   2.944253836662024e-05,   1.064820680870038e-06,  -1.080565085007017e-08,
  -1.224987514131498e-10,   2.920196005566863e-12,   1.388332467862358e-15,  -6.848452190312725e-16,   7.940750303757537e-18,   2.153811506502858e-19,  -1.585218412671523e-21,
  -3.486707583886089e-23,  -2.654439701663943e-25,   1.328634120719207e+00,  -1.260479316666992e-02,  -5.007561272948347e-05,   1.478915048786960e-06,   1.113057272457900e-08,
  -3.435336759636927e-10,  -3.264069124600430e-12,   9.361644254987298e-14,   9.761128889633595e-16,  -2.685043144163319e-17,  -1.629082905139762e-19,   1.291623517971446e-20,
   7.850736699890565e-23,  -5.951767523351184e-24,   1.328629438655931e+00,  -1.260437835128793e-02,  -5.006937751766720e-05,   1.478594522950078e-06,   1.112601275257187e-08,
  -3.433507797895417e-10,  -3.261520681462985e-12,   9.352750905133093e-14,   9.754402327533564e-16,  -2.678548351057642e-17,  -1.624496484251080e-19,   1.287365023933993e-20,
   7.791837582098200e-23,  -5.934721012019096e-24,   1.328621177553678e+00,  -1.260364647603347e-02,  -5.005837746641303e-05,   1.478029089028402e-06,   1.111796951827697e-08,
  -3.430281981271287e-10,  -3.257025340134420e-12,   9.337076149059311e-14,   9.742548696145443e-16,  -2.667105942340113e-17,  -1.616433022227523e-19,   1.279860921870732e-20,
   7.688161929208049e-23,  -5.904684138796751e-24,   1.328611188945354e+00,  -1.260276160912718e-02,  -5.004507962930587e-05,   1.477345597153642e-06,   1.110824851078077e-08,
  -3.426383700346572e-10,  -3.251591955734473e-12,   9.318152212665350e-14,   9.728241507171354e-16,  -2.653299905891390e-17,  -1.606732554962676e-19,   1.270804047705183e-20,
   7.563226502797832e-23,  -5.868434694775581e-24,   1.328601493019920e+00,  -1.260190272596890e-02,  -5.003217402763397e-05,   1.476682323021601e-06,   1.109881671484656e-08,
  -3.422601839022198e-10,  -3.246319862411725e-12,   9.299812709115719e-14,   9.714379840568782e-16,  -2.639928881673911e-17,  -1.597367713458680e-19,   1.262029745645073e-20,
   7.442391037040742e-23,  -5.833319085632501e-24,   1.328593682712122e+00,  -1.260121091421818e-02,  -5.002178009899814e-05,   1.476148175594668e-06,   1.109122230022337e-08,
  -3.419557026218574e-10,  -3.242074552061591e-12,   9.285061202186233e-14,   9.703232707810330e-16,  -2.629180000328250e-17,  -1.589860845294941e-19,   1.254974131140273e-20,
   7.345369118889053e-23,  -5.805083867344291e-24,   1.328588522095382e+00,  -1.260075382303727e-02,  -5.001491327635135e-05,   1.475795307415706e-06,   1.108620586612579e-08,
  -3.417545951479686e-10,  -3.239270216661247e-12,   9.275324702452963e-14,   9.695876475273988e-16,  -2.622088406634685e-17,  -1.584918685171944e-19,   1.250318191878311e-20,
   7.281415952908343e-23,  -5.786452681369207e-24,   1.328585871963142e+00,  -1.260051909897627e-02,  -5.001138723639604e-05,   1.475614119598454e-06,   1.108363024989199e-08,
  -3.416513441400932e-10,  -3.237830331335199e-12,   9.270327953535722e-14,   9.692101659703626e-16,  -2.618449956963047e-17,  -1.582386285119734e-19,   1.247929086704989e-20,
   7.248621499831996e-23,  -5.776892754124722e-24,   1.328584949574895e+00,  -1.260043740336688e-02,  -5.001016002989803e-05,   1.475551059797705e-06,   1.108273387265047e-08,
  -3.416154110265451e-10,  -3.237329209839930e-12,   9.268589331896088e-14,   9.690788271631865e-16,  -2.617184105984748e-17,  -1.581505756699005e-19,   1.247097845889171e-20,
   7.237214815721265e-23,  -5.773566619356789e-24,   1.328584803205274e+00,  -1.260042443950560e-02,  -5.000996529216628e-05,   1.475541053278896e-06,   1.108259163417964e-08,
  -3.416097091425625e-10,  -3.237249690838194e-12,   9.268313462340008e-14,   9.690579877386255e-16,  -2.616983258725141e-17,  -1.581366071518417e-19,   1.246965954092251e-20,
   7.235405098710220e-23,  -5.773038868589980e-24,   1.659757353622668e+00,  -9.487705812173883e-03,  -1.325274776369450e-04,  -2.505618249108031e-07,   2.888754935443020e-08,
   4.625890879518831e-10,  -3.676557252213217e-12,  -2.304324701583099e-13,  -1.912612813008752e-15,   7.116076777492422e-17,   2.063262920111384e-18,   4.092090148222641e-21,
  -8.259865237339639e-22,  -1.565763262125324e-23,   1.659744961755339e+00,  -9.487774769135298e-03,  -1.325112579586105e-04,  -2.501319267967988e-07,   2.888232218615148e-08,
   4.621392526997654e-10,  -3.681401940453855e-12,  -2.301918810166314e-13,  -1.904071319296206e-15,   7.117760236631350e-17,   2.058191054924597e-18,   3.981814517914295e-21,
  -8.251554500396233e-22,  -1.558082807992926e-23,   1.659723097342871e+00,  -9.487896347136773e-03,  -1.324826404843886e-04,  -2.493737064804678e-07,   2.887309329550141e-08,
   4.613458965959960e-10,  -3.689932339200489e-12,  -2.297673146138857e-13,  -1.889017080327619e-15,   7.120684929697373e-17,   2.049245915957027e-18,   3.787685092735214e-21,
  -8.236829776640248e-22,  -1.544552371977867e-23,   1.659696660762882e+00,  -9.488043194121026e-03,  -1.324480400284094e-04,  -2.484574407452731e-07,   2.886192430965939e-08,
   4.603872188895961e-10,  -3.700216500911424e-12,  -2.292538517881851e-13,  -1.870842925699255e-15,   7.124143541762380e-17,   2.038436620261386e-18,   3.553714354370424e-21,
  -8.218922085732010e-22,  -1.528228483110378e-23,   1.659670998788815e+00,  -9.488185576411045e-03,  -1.324144547999001e-04,  -2.475685554281106e-07,   2.885107191742857e-08,
   4.594572391968389e-10,  -3.710167874219505e-12,  -2.287553160342504e-13,  -1.853230746535149e-15,   7.127419631059683e-17,   2.027950773835301e-18,   3.327387573054251e-21,
  -8.201430908162482e-22,  -1.512420563335937e-23,   1.659650327412520e+00,  -9.488300152951804e-03,  -1.323874020555879e-04,  -2.468529175697699e-07,   2.884232240961186e-08,
   4.587085526605220e-10,  -3.718161441874198e-12,  -2.283536491938563e-13,  -1.839064788814392e-15,   7.130000548536779e-17,   2.019508998054113e-18,   3.145639761719678e-21,
  -8.187264163780170e-22,  -1.499713880945552e-23,   1.659636668907055e+00,  -9.488375802012295e-03,  -1.323695275922478e-04,  -2.463802505163013e-07,   2.883653748716767e-08,
   4.582140753412748e-10,  -3.723432133470044e-12,  -2.280882092993936e-13,  -1.829715034884159e-15,   7.131677495431035e-17,   2.013933516348356e-18,   3.025826775578438e-21,
  -8.177865930894220e-22,  -1.491331230698641e-23,   1.659629654849623e+00,  -9.488414632540160e-03,  -1.323603486666075e-04,  -2.461375794395364e-07,   2.883356560120709e-08,
   4.579602122385153e-10,  -3.726135388331056e-12,  -2.279518853610572e-13,  -1.824916846200361e-15,   7.132529891013088e-17,   2.011071074227518e-18,   2.964384442229330e-21,
  -8.173028046812233e-22,  -1.487030575944107e-23,   1.659627213580695e+00,  -9.488428144854930e-03,  -1.323571539317666e-04,  -2.460531260662368e-07,   2.883253104178169e-08,
   4.578718647471474e-10,  -3.727075724314000e-12,  -2.279044353217625e-13,  -1.823247327109759e-15,   7.132825175515743e-17,   2.010074908028893e-18,   2.943012778382076e-21,
  -8.171342358238009e-22,  -1.485534368305655e-23,   1.659626826186742e+00,  -9.488430288930490e-03,  -1.323566469748729e-04,  -2.460397249782675e-07,   2.883236686350871e-08,
   4.578578457812996e-10,  -3.727224916262581e-12,  -2.278969055950745e-13,  -1.822982422792397e-15,   7.132871966674673e-17,   2.009916836489129e-18,   2.939622049559368e-21,
  -8.171074776393890e-22,  -1.485296972787764e-23,   1.923417957082505e+00,  -2.911709344264872e-03,  -7.703211986629678e-05,  -1.621875695363148e-06,  -2.669379654235634e-08,
  -2.797266312550584e-10,   1.124344431158941e-12,   1.489012257841496e-13,   4.405228435319810e-15,   8.091064887682100e-17,   7.475013130149668e-19,  -1.059971207939707e-20,
  -6.645481267441581e-22,  -1.689759430527311e-23,   1.923410705213110e+00,  -2.912166410236889e-03,  -7.704712532086158e-05,  -1.622135433286367e-06,  -2.669207785695362e-08,
  -2.794291675060994e-10,   1.135970038882246e-12,   1.491727288390742e-13,   4.408246006099805e-15,   8.085116287869234e-17,   7.432888768460526e-19,  -1.072380241940058e-20,
  -6.667270338439126e-22,  -1.690757651064340e-23,   1.923397908032786e+00,  -2.912972969300661e-03,  -7.707360186346563e-05,  -1.622593516892310e-06,  -2.668903189389153e-08,
  -2.789038542480629e-10,   1.156489964083631e-12,   1.496516334803416e-13,   4.413556021085999e-15,   8.074567818537111e-17,   7.358450731125350e-19,  -1.094281710731299e-20,
  -6.705657004249184e-22,  -1.692489283941960e-23,   1.923382431597263e+00,  -2.913948369643770e-03,  -7.710561618267464e-05,  -1.623147047420175e-06,  -2.668532597363013e-08,
  -2.782679003755828e-10,   1.181313695588949e-12,   1.502304447530468e-13,   4.419952137144510e-15,   8.061723695424642e-17,   7.268253922580645e-19,  -1.120774513577900e-20,
  -6.751971043204923e-22,  -1.694532412160842e-23,   1.923367405301331e+00,  -2.914895376615073e-03,  -7.713669365924602e-05,  -1.623683997563822e-06,  -2.668170454328216e-08,
  -2.776497532383214e-10,   1.205423446432793e-12,   1.507920446661798e-13,   4.426135361765061e-15,   8.049161831923901e-17,   7.180498397675085e-19,  -1.146502864910862e-20,
  -6.796823009721759e-22,  -1.696462583877022e-23,   1.923355298850963e+00,  -2.915658348460705e-03,  -7.716172821297054e-05,  -1.624116265289942e-06,  -2.667877011829074e-08,
  -2.771512274522982e-10,   1.224854026799828e-12,   1.512442463861736e-13,   4.431097825178519e-15,   8.038975502468016e-17,   7.109664860772894e-19,  -1.167236056701707e-20,
  -6.832876799788068e-22,  -1.697979283701655e-23,   1.923347298408521e+00,  -2.916162543542304e-03,  -7.717827008092208e-05,  -1.624401756889808e-06,  -2.667682275369558e-08,
  -2.768215390682144e-10,   1.237697355907316e-12,   1.515429471772873e-13,   4.434367785987369e-15,   8.032211915714294e-17,   7.062791425085121e-19,  -1.180939449273582e-20,
  -6.856661990756106e-22,  -1.698962753748896e-23,   1.923343189577185e+00,  -2.916421483243583e-03,  -7.718676496073124e-05,  -1.624548326179189e-06,  -2.667582010646436e-08,
  -2.766521443816165e-10,   1.244294239154897e-12,   1.516963114531283e-13,   4.436044236683487e-15,   8.028728394404824e-17,   7.038698691954340e-19,  -1.187977798496110e-20,
  -6.868864884871105e-22,  -1.699462012624954e-23,   1.923341759425574e+00,  -2.916511611392880e-03,  -7.718972165580092e-05,  -1.624599333907241e-06,  -2.667547071476886e-08,
  -2.765931716497802e-10,   1.246590538735652e-12,   1.517496860536729e-13,   4.436627289883849e-15,   8.027514315532843e-17,   7.030309656804248e-19,  -1.190427718989628e-20,
  -6.873110310497890e-22,  -1.699634860420019e-23,   1.923341532478537e+00,  -2.916525913575066e-03,  -7.719019084137031e-05,  -1.624607427796220e-06,  -2.667541525159961e-08,
  -2.765838128552121e-10,   1.246954939058595e-12,   1.517581556187894e-13,   4.436719790991511e-15,   8.027321581626863e-17,   7.028978273990030e-19,  -1.190816495142911e-20,
  -6.873783910661057e-22,  -1.699662245118268e-23,   5.481423415055617e-03,  -9.130921803650450e-05,   1.136524224391084e-06,  -1.260368358492870e-08,   1.290289622721535e-10,
  -1.306979488778391e-12,   1.197529813102243e-14,  -1.051779022289829e-16,   1.788253873625870e-18,   1.283400009171253e-20,   3.246272715282835e-22,  -7.021623639070805e-24,
  -2.895968291924174e-25,  -3.991829271322372e-27,   5.481530109884067e-03,  -9.131276713793008e-05,   1.136596898443269e-06,  -1.260491061047373e-08,   1.290458583749855e-10,
  -1.307185886126817e-12,   1.198001922059721e-14,  -1.051355641109144e-16,   1.789566329473282e-18,   1.279670363325552e-20,   3.228502312647590e-22,  -7.049824659718567e-24,
  -2.892782985753009e-25,  -3.973872536563743e-27,   5.481718380140757e-03,  -9.131902986419345e-05,   1.136725140693592e-06,  -1.260707587349205e-08,   1.290756772227705e-10,
  -1.307550010217421e-12,   1.198835242393121e-14,  -1.050609609706021e-16,   1.791876096598963e-18,   1.273077623667173e-20,   3.197162305904005e-22,  -7.099479334827816e-24,
  -2.887151144256896e-25,  -3.942208768271310e-27,   5.481946048016162e-03,  -9.132660329879875e-05,   1.136880225795286e-06,  -1.260969440057245e-08,   1.291117437162600e-10,
  -1.307990198358006e-12,   1.199843373069206e-14,  -1.049709261291351e-16,   1.794658725412443e-18,   1.265085657859563e-20,   3.159293208024852e-22,  -7.159340844138018e-24,
  -2.880321761784653e-25,  -3.903956532779419e-27,   5.482167073965520e-03,  -9.133395595975145e-05,   1.137030793555093e-06,  -1.261223670183748e-08,   1.291467661060007e-10,
  -1.308417405522251e-12,   1.200822540790192e-14,  -1.048837065245699e-16,   1.797349202704964e-18,   1.257306338497938e-20,   3.122559467397018e-22,  -7.217263451934926e-24,
  -2.873671704685786e-25,  -3.866859335590632e-27,   5.482345136701798e-03,  -9.133987952731196e-05,   1.137152098893334e-06,  -1.261428494762338e-08,   1.291749866125721e-10,
  -1.308761472279358e-12,   1.201611697227650e-14,  -1.048135760509470e-16,   1.799508845247682e-18,   1.251024503242424e-20,   3.092988002735527e-22,  -7.263789158049132e-24,
  -2.868300023774568e-25,  -3.837000968678067e-27,   5.482462800865225e-03,  -9.134379389126917e-05,   1.137232260152212e-06,  -1.261563849032776e-08,   1.291936376119520e-10,
  -1.308988783505016e-12,   1.202133329600913e-14,  -1.047673000408152e-16,   1.800932095079490e-18,   1.246866285849649e-20,   3.073457884044844e-22,  -7.294465960308992e-24,
  -2.864743422055300e-25,  -3.817284080354119e-27,   5.482523228119228e-03,  -9.134580415889991e-05,   1.137273428294988e-06,  -1.261633362969251e-08,   1.292032168415282e-10,
  -1.309105505728739e-12,   1.202401265863740e-14,  -1.047435552009764e-16,   1.801661826000540e-18,   1.244728589321912e-20,   3.063431384386577e-22,  -7.310199389674810e-24,
  -2.862914743996864e-25,  -3.807162518600123e-27,   5.482544260549673e-03,  -9.134650385962587e-05,   1.137287757483023e-06,  -1.261657558415720e-08,   1.292065511471193e-10,
  -1.309146129904023e-12,   1.202494531977997e-14,  -1.047352937943606e-16,   1.801915628341025e-18,   1.243984186008953e-20,   3.059942071236414e-22,  -7.315672278628992e-24,
  -2.862277906735532e-25,  -3.803640252595790e-27,   5.482547598114854e-03,  -9.134661489290613e-05,   1.137290031339162e-06,  -1.261661397922839e-08,   1.292070802634248e-10,
  -1.309152576303205e-12,   1.202509332426602e-14,  -1.047339829749645e-16,   1.801955894391081e-18,   1.243866042442254e-20,   3.059388389126236e-22,  -7.316540595258381e-24,
  -2.862176832859036e-25,  -3.803081347672046e-27,   4.942782888204229e-02,  -8.166221844588136e-04,   9.947951731600432e-06,  -1.059334978852157e-07,   1.012128780193114e-09,
  -9.287037849100924e-12,   7.119817388281148e-14,  -4.551950628278076e-16,   1.007945315372059e-17,   1.908781534935471e-19,   2.180795916942128e-21,  -5.572628697287687e-23,
  -2.741579639931033e-24,  -3.592488758568157e-26,   4.942876264472078e-02,  -8.166520088919455e-04,   9.948521620030466e-06,  -1.059422119058907e-07,   1.012229217693496e-09,
  -9.287923906982259e-12,   7.122480959978076e-14,  -4.545586350803865e-16,   1.008811290474728e-17,   1.905810047266254e-19,   2.163965966830847e-21,  -5.597985266665324e-23,
  -2.738712824984243e-24,  -3.575906156886878e-26,   4.943041032718570e-02,  -8.167046365680063e-04,   9.949527243151713e-06,  -1.059575886049283e-07,   1.012406471766944e-09,
  -9.289486355264223e-12,   7.127182689569223e-14,  -4.534364708151593e-16,   1.010333556544220e-17,   1.900556274315539e-19,   2.134283790242602e-21,  -5.642629014372822e-23,
  -2.733643959323690e-24,  -3.546665751103417e-26,   4.943240279665032e-02,  -8.167682779172899e-04,   9.950743331854141e-06,  -1.059761834197897e-07,   1.012620861346369e-09,
  -9.291373955029130e-12,   7.132871158278157e-14,  -4.520809422075142e-16,   1.012164478029920e-17,   1.894185418994643e-19,   2.098416604376312e-21,  -5.696445150640447e-23,
  -2.727497026900220e-24,  -3.511341638846097e-26,   4.943433712924614e-02,  -8.168300633992696e-04,   9.951923971911404e-06,  -1.059942361436865e-07,   1.012829041573493e-09,
  -9.293204594364033e-12,   7.138396647237488e-14,  -4.507664916949331e-16,   1.013931627030251e-17,   1.887981955500471e-19,   2.063623397024805e-21,  -5.748513557810304e-23,
  -2.721511254592850e-24,  -3.477084691418204e-26,   4.943589545812569e-02,  -8.168798395321382e-04,   9.952875139089590e-06,  -1.060087800422631e-07,   1.012996787943560e-09,
  -9.294678037678441e-12,   7.142850210283295e-14,  -4.497086447618245e-16,   1.015347858308015e-17,   1.882971118850736e-19,   2.035613128230625e-21,  -5.790333611257282e-23,
  -2.716675984376216e-24,  -3.449512740876514e-26,   4.943692520135973e-02,  -8.169127319636173e-04,   9.953503682259967e-06,  -1.060183908117387e-07,   1.013107650899411e-09,
  -9.295651028582578e-12,   7.145794168985363e-14,  -4.490101567506820e-16,   1.016280075827461e-17,   1.879653492992944e-19,   2.017113603960002e-21,  -5.817906099748171e-23,
  -2.713474456001864e-24,  -3.431305871579771e-26,   4.943745403221584e-02,  -8.169296241874886e-04,   9.953826478173503e-06,  -1.060233265316905e-07,   1.013164590253004e-09,
  -9.296150509909314e-12,   7.147306379469155e-14,  -4.486516102064086e-16,   1.016757700171433e-17,   1.877947708584106e-19,   2.007616049376756e-21,  -5.832046891563342e-23,
  -2.711828317708048e-24,  -3.421959529133881e-26,   4.943763809798092e-02,  -8.169355037422273e-04,   9.953938831667563e-06,  -1.060250444749072e-07,   1.013184409459210e-09,
  -9.296324327752707e-12,   7.147832773333918e-14,  -4.485268403588787e-16,   1.016923764378544e-17,   1.877353672544349e-19,   2.004310790315937e-21,  -5.836965699315671e-23,
  -2.711255045750485e-24,  -3.418707045960188e-26,   4.943766730674658e-02,  -8.169364367495106e-04,   9.953956660687140e-06,  -1.060253170898177e-07,   1.013187554539038e-09,
  -9.296351908769246e-12,   7.147916307407973e-14,  -4.485070423161566e-16,   1.016950108063668e-17,   1.877259391916200e-19,   2.003786312676586e-21,  -5.837746102798762e-23,
  -2.711164060268185e-24,  -3.418190949989909e-26,   1.378222533714269e-01,  -2.237549602989097e-03,   2.599757553633452e-05,  -2.516299516654382e-07,   1.996360386344818e-09,
  -1.306903501391313e-11,   2.588418297031136e-14,   7.597530789167673e-16,   7.838132666467308e-18,   7.333947807135006e-19,   5.158919882228758e-21,  -1.563498887133931e-22,
  -7.861115138099530e-24,  -1.060427376661789e-25,   1.378246928940343e-01,  -2.237620416882035e-03,   2.599869869385437e-05,  -2.516421909194701e-07,   1.996397034739763e-09,
  -1.306750027918208e-11,   2.590517081169801e-14,   7.622063962128470e-16,   7.858347612698720e-18,   7.325596209844436e-19,   5.110675786078225e-21,  -1.570988764841234e-22,
  -7.852602906468458e-24,  -1.055625609277200e-25,   1.378289975557489e-01,  -2.237745371908365e-03,   2.600068053981601e-05,  -2.516637860943276e-07,   1.996461725565728e-09,
  -1.306478829962052e-11,   2.594224639127952e-14,   7.665330004408939e-16,   7.893852083420933e-18,   7.310828557484260e-19,   5.025591468813446e-21,  -1.584176306228748e-22,
  -7.837553082172251e-24,  -1.047158854895692e-25,   1.378342029448077e-01,  -2.237896473632314e-03,   2.600307703786427e-05,  -2.516898971940342e-07,   1.996539991625006e-09,
  -1.306150227043100e-11,   2.598715029738216e-14,   7.717608272782592e-16,   7.936503027386635e-18,   7.292918360982992e-19,   4.922780279370839e-21,  -1.600074310114104e-22,
  -7.819303766536455e-24,  -1.036931017155166e-25,   1.378392563994179e-01,  -2.238043165566298e-03,   2.600540354678853e-05,  -2.517152432834251e-07,   1.996616014168407e-09,
  -1.305830526393571e-11,   2.603081702827648e-14,   7.768317680762705e-16,   7.977613232905792e-18,   7.275476062077231e-19,   4.823050240445574e-21,  -1.615457046569744e-22,
  -7.801534340168058e-24,  -1.027012686543896e-25,   1.378433275063728e-01,  -2.238161342260106e-03,   2.600727777369856e-05,  -2.517356602467666e-07,   1.996677287928028e-09,
  -1.305572479376289e-11,   2.606604775332741e-14,   7.809138783719189e-16,   8.010520097075561e-18,   7.261385159388563e-19,   4.742764484348492e-21,  -1.627812823768097e-22,
  -7.787181329256761e-24,  -1.019030217287761e-25,   1.378460176750072e-01,  -2.238239433066673e-03,   2.600851624001967e-05,  -2.517491506690944e-07,   1.996717791720721e-09,
  -1.305401721621540e-11,   2.608935363496735e-14,   7.836098060446469e-16,   8.032161101022882e-18,   7.252054775676765e-19,   4.689740282087741e-21,  -1.635959509448595e-22,
  -7.777678416170413e-24,  -1.013759252690684e-25,   1.378473992219229e-01,  -2.238279536974329e-03,   2.600915225500259e-05,  -2.517560784164127e-07,   1.996738597054547e-09,
  -1.305313953631627e-11,   2.610133035671084e-14,   7.849938425238241e-16,   8.043242864079853e-18,   7.247257194317586e-19,   4.662518235417860e-21,  -1.640137721928908e-22,
  -7.772792432853275e-24,  -1.011053503630572e-25,   1.378478800846218e-01,  -2.238293495592931e-03,   2.600937362636226e-05,  -2.517584896456726e-07,   1.996745839289701e-09,
  -1.305283393127234e-11,   2.610550024213679e-14,   7.854754971954517e-16,   8.047094890926628e-18,   7.245586400269132e-19,   4.653044693696804e-21,  -1.641591111535603e-22,
  -7.771090901005568e-24,  -1.010111924618420e-25,   1.378479563910350e-01,  -2.238295710637558e-03,   2.600940875497297e-05,  -2.517588722728085e-07,   1.996746988568202e-09,
  -1.305278543023973e-11,   2.610616200615041e-14,   7.855519257442648e-16,   8.047705913278503e-18,   7.245321223084723e-19,   4.651541436769412e-21,  -1.641821702889763e-22,
  -7.770820847631106e-24,  -1.009962517617639e-25,   2.716340244552027e-01,  -4.283109058332485e-03,   4.575355113998568e-05,  -3.637728699531084e-07,   1.625679952752822e-09,
   5.598476873763111e-12,  -2.838663505731759e-13,   3.978171449695208e-15,   1.292426534448821e-17,   1.271252413971545e-18,   1.623097420630072e-20,  -3.860829727909581e-22,
  -1.591283022907564e-23,  -2.249202750526260e-25,   2.716383156733324e-01,  -4.283211350515567e-03,   4.575446333249466e-05,  -3.637675549095462e-07,   1.625281185601434e-09,
   5.606376152927203e-12,  -2.838310845491199e-13,   3.982408179297983e-15,   1.298960415109003e-17,   1.269200221377110e-18,   1.613332944875500e-20,  -3.876712437133642e-22,
  -1.589531605138306e-23,  -2.238952109043743e-25,   2.716458876646027e-01,  -4.283391845457663e-03,   4.575607272828896e-05,  -3.637581703899807e-07,   1.624577595521298e-09,
   5.620321310210190e-12,  -2.837687195519483e-13,   3.989878279471909e-15,   1.310456131727636e-17,   1.265572494852277e-18,   1.596112251278207e-20,  -3.904676968981973e-22,
  -1.586435114325613e-23,  -2.220878253795818e-25,   2.716550439156276e-01,  -4.283610099781888e-03,   4.575801851616109e-05,  -3.637468122237335e-07,   1.623726876606751e-09,
   5.637195454853207e-12,  -2.836930730965653e-13,   3.998901514268793e-15,   1.324299914551602e-17,   1.261174572347697e-18,   1.575303962392783e-20,  -3.938388435972823e-22,
  -1.582680427726210e-23,  -2.199046182005424e-25,   2.716639327694758e-01,  -4.283821975113862e-03,   4.575990712798170e-05,  -3.637357751168576e-07,   1.622901086564312e-09,
   5.653588629075417e-12,  -2.836193923707254e-13,   4.007650951267826e-15,   1.337679597522042e-17,   1.256893400424348e-18,   1.555119535590703e-20,  -3.971006583925747e-22,
  -1.579024578124562e-23,  -2.177875972509362e-25,   2.716710936032710e-01,  -4.283992657557470e-03,   4.576142833599386e-05,  -3.637268760288529e-07,   1.622235893354809e-09,
   5.666803382821150e-12,  -2.835598614224976e-13,   4.014692091002810e-15,   1.348415396228931e-17,   1.253436144481725e-18,   1.538870634892108e-20,  -3.997205748380982e-22,
  -1.576071689735934e-23,  -2.160838625737555e-25,   2.716758253981196e-01,  -4.284105440707308e-03,   4.576243340901702e-05,  -3.637209918799085e-07,   1.621796371280464e-09,
   5.675539677816299e-12,  -2.835204390649122e-13,   4.019341175431808e-15,   1.355488521389995e-17,   1.251147545033658e-18,   1.528139245534492e-20,  -4.014479718330266e-22,
  -1.574116663129740e-23,  -2.149588986796445e-25,   2.716782554146167e-01,  -4.284163360013550e-03,   4.576294952681006e-05,  -3.637179689154773e-07,   1.621570663636072e-09,
   5.680027488250774e-12,  -2.835001674350220e-13,   4.021727596099549e-15,   1.359114447900328e-17,   1.249970971143195e-18,   1.522629895474669e-20,  -4.023338989646999e-22,
  -1.573111485062889e-23,  -2.143814329408745e-25,   2.716791012062506e-01,  -4.284183519320651e-03,   4.576312916071541e-05,  -3.637169165583514e-07,   1.621492105293217e-09,
   5.681589719475231e-12,  -2.834931075149307e-13,   4.022558035404466e-15,   1.360375456261598e-17,   1.249561251987845e-18,   1.520712591591049e-20,  -4.026420671699598e-22,
  -1.572761436043105e-23,  -2.141804815571650e-25,   2.716792354218360e-01,  -4.284186718323253e-03,   4.576315766587548e-05,  -3.637167495549064e-07,   1.621479639226424e-09,
   5.681837633914683e-12,  -2.834919870038238e-13,   4.022689806315680e-15,   1.360575512095172e-17,   1.249496225621147e-18,   1.520408354969065e-20,  -4.026909603505264e-22,
  -1.572705879179344e-23,  -2.141485952782731e-25,   4.521795947577881e-01,  -6.811791669389605e-03,   6.286454931641359e-05,  -3.081521439480303e-07,  -1.759565761721207e-09,
   5.296818383921825e-11,  -6.253092567193584e-13,   2.587240884774957e-15,   1.245437693593480e-16,   1.131063225513807e-18,   3.501090617830778e-20,  -5.881012021070771e-22,
  -3.148770296616801e-23,  -3.848944563403462e-25,   4.521854863008243e-01,  -6.811878161937538e-03,   6.286355462322390e-05,  -3.081024429906756e-07,  -1.760441196109476e-09,
   5.297333668641535e-11,  -6.249794266544653e-13,   2.590976020038159e-15,   1.246852610409134e-16,   1.127925960057412e-18,   3.481753123616263e-20,  -5.908126275487710e-22,
  -3.145647323819194e-23,  -3.830217408634115e-25,   4.521958819449497e-01,  -6.812030768029295e-03,   6.286179907198899e-05,  -3.080147409225821e-07,  -1.761985535658237e-09,
   5.298243490425741e-11,  -6.243971381083790e-13,   2.597558040018004e-15,   1.249342633784495e-16,   1.122378944754054e-18,   3.447647646526364e-20,  -5.955858853201794e-22,
  -3.140125376400668e-23,  -3.797201570206214e-25,   4.522084523388741e-01,  -6.812215281559005e-03,   6.285967555969563e-05,  -3.079086839118010e-07,  -1.763852322445519e-09,
   5.299344668151273e-11,  -6.236925210739457e-13,   2.605502259304469e-15,   1.252342313415144e-16,   1.115652265344401e-18,   3.406433979638805e-20,  -6.013388530622219e-22,
  -3.133428723557840e-23,  -3.757326907675544e-25,   4.522206553235166e-01,  -6.812394383797098e-03,   6.285761337775214e-05,  -3.078057185469275e-07,  -1.765663890912512e-09,
   5.300414730437667e-11,  -6.230079608342684e-13,   2.613198813652167e-15,   1.255242539552510e-16,   1.109102088128105e-18,   3.366452831820632e-20,  -6.069039503990466e-22,
  -3.126907361710774e-23,  -3.718667763747452e-25,   4.522304857916588e-01,  -6.812538651683694e-03,   6.285595160006409e-05,  -3.077227659305712e-07,  -1.767122782472909e-09,
   5.301277515897921e-11,  -6.224561089756623e-13,   2.619387892892339e-15,   1.257570464896939e-16,   1.103811025339197e-18,   3.334264898966283e-20,  -6.113729554146214e-22,
  -3.121639248488401e-23,  -3.687560466021301e-25,   4.522369815420939e-01,  -6.812633974210177e-03,   6.285485327694630e-05,  -3.076679498420519e-07,  -1.768086554749732e-09,
   5.301847999555263e-11,  -6.220912698648285e-13,   2.623472051982053e-15,   1.259104576048008e-16,   1.100307782832974e-18,   3.313005669347696e-20,  -6.143190628705423e-22,
  -3.118151031615381e-23,  -3.667022879267653e-25,   4.522403174059716e-01,  -6.812682924685660e-03,   6.285428915815912e-05,  -3.076397983913529e-07,  -1.768581424530795e-09,
   5.302141084683600e-11,  -6.219038503140263e-13,   2.625567768521688e-15,   1.259891135347888e-16,   1.098506537059342e-18,   3.302091128097602e-20,  -6.158298872792582e-22,
  -3.116357457110860e-23,  -3.656481262340534e-25,   4.522414784815899e-01,  -6.812699961996221e-03,   6.285409279914163e-05,  -3.076299998991024e-07,  -1.768753656803348e-09,
   5.302243113864236e-11,  -6.218386081216970e-13,   2.626296931932884e-15,   1.260164700734666e-16,   1.097879252819063e-18,   3.298292714325729e-20,  -6.163554025019577e-22,
  -3.115732835555527e-23,  -3.652813017068016e-25,   4.522416627281882e-01,  -6.812702665566116e-03,   6.285406163908558e-05,  -3.076284450075357e-07,  -1.768780987138145e-09,
   5.302259305354754e-11,  -6.218282546523691e-13,   2.626412627307019e-15,   1.260208102120331e-16,   1.097779695115562e-18,   3.297689981747555e-20,  -6.164387783411705e-22,
  -3.115633700029740e-23,  -3.652230957913389e-25,   6.807451543579334e-01,  -9.548276418753393e-03,   6.674016552999135e-05,   7.985147418270133e-08,  -8.400082160974665e-09,
   8.235817143604918e-11,   9.578475802035501e-14,  -1.451076162044170e-14,   3.031461451476998e-16,   3.996674408962490e-18,   7.982012050968752e-21,  -4.943612867797818e-22,
  -5.101382808335775e-23,  -8.198657539117960e-25,   6.807514017526108e-01,  -9.548253689500392e-03,   6.673544131164862e-05,   7.992844662824400e-08,  -8.399938047297977e-09,
   8.232981665523040e-11,   9.658097290828598e-14,  -1.449734607187214e-14,   3.031697892044258e-16,   3.993900387920400e-18,   7.669567339711098e-21,  -5.001720781994512e-22,
  -5.094494724718295e-23,  -8.165151510288803e-25,   6.807624250189928e-01,  -9.548213565816335e-03,   6.672710542206142e-05,   8.006424417525704e-08,  -8.399682845975518e-09,
   8.227980563410050e-11,   9.798595100899207e-14,  -1.447368190138870e-14,   3.032104406975276e-16,   3.988981413612151e-18,   7.118602016025322e-21,  -5.104054627546249e-22,
  -5.082324392336611e-23,  -8.106082561215639e-25,   6.807757538569816e-01,  -9.548165017891694e-03,   6.671702569153473e-05,   8.022841529681982e-08,  -8.399372701347075e-09,
   8.221936831398030e-11,   9.968493969529325e-14,  -1.444508023754382e-14,   3.032577753160734e-16,   3.982992181409707e-18,   6.452963271240754e-21,  -5.227459589769342e-22,
  -5.067580288508214e-23,  -8.034745729932852e-25,   6.807886926197356e-01,  -9.548117857061172e-03,   6.670724058569462e-05,   8.038775133789938e-08,  -8.399069992548079e-09,
   8.216073506404461e-11,   1.013343641681448e-13,  -1.441732822675055e-14,   3.033018204292712e-16,   3.977134912933948e-18,   5.807395872698978e-21,  -5.346905084409699e-22,
  -5.053238076315911e-23,  -7.965586956901816e-25,   6.807991154584464e-01,  -9.548079842453363e-03,   6.669935791940072e-05,   8.051608284707806e-08,  -8.398824969396293e-09,
   8.211352828159749e-11,   1.026631718862644e-13,  -1.439498163165799e-14,   3.033359373274432e-16,   3.972385597090469e-18,   5.287782173624083e-21,  -5.442875439347256e-22,
  -5.041663489508370e-23,  -7.909940444125563e-25,   6.808060024592173e-01,  -9.548054712083861e-03,   6.669414923699107e-05,   8.060086854517242e-08,  -8.398662492095721e-09,
   8.208234829389757e-11,   1.035412496475408e-13,  -1.438022034362193e-14,   3.033578129910363e-16,   3.969232285402202e-18,   4.944649763960717e-21,  -5.506166954291403e-22,
  -5.034005085102169e-23,  -7.873202851296389e-25,   6.808095391939458e-01,  -9.548041803036983e-03,   6.669147434268385e-05,   8.064440589096021e-08,  -8.398578875834192e-09,
   8.206634002577952e-11,   1.039921922939973e-13,  -1.437264124834782e-14,   3.033688406154101e-16,   3.967608259511698e-18,   4.768502644601879e-21,  -5.538631848116025e-22,
  -5.030068998301230e-23,  -7.854346405117931e-25,   6.808107701757605e-01,  -9.548037309383786e-03,   6.669054332334943e-05,   8.065955879954457e-08,  -8.398549744346364e-09,
   8.206076886168485e-11,   1.041491482270761e-13,  -1.437000351910596e-14,   3.033726459996174e-16,   3.967042262619096e-18,   4.707203822900371e-21,  -5.549925451378127e-22,
  -5.028698509092656e-23,  -7.847784846480907e-25,   6.808109655150943e-01,  -9.548036596277218e-03,   6.669039558350421e-05,   8.066196332595911e-08,  -8.398545120247289e-09,
   8.205988482601213e-11,   1.041740550295029e-13,  -1.436958495940552e-14,   3.033732483008074e-16,   3.966952411594028e-18,   4.697477056731063e-21,  -5.551717301103956e-22,
  -5.028481007683066e-23,  -7.846743693409515e-25,   9.574317753535224e-01,  -1.194900888648587e-02,   4.118889316386391e-05,   8.766453927132505e-07,  -1.260320155663345e-08,
  -5.380355819119105e-11,   2.713503385300287e-12,  -1.497856107339973e-14,  -2.702381770810945e-16,   1.479897460509251e-17,   1.043605135732249e-19,  -3.873748537540493e-21,
  -6.871288454033763e-23,  -9.038724762123313e-25,   9.574356226170049e-01,  -1.194876250902093e-02,   4.118182536489428e-05,   8.765947114160910e-07,  -1.259939397168605e-08,
  -5.383226229712955e-11,   2.712802781328183e-12,  -1.492914256970381e-14,  -2.698115360361034e-16,   1.477875873280301e-17,   1.039364584230623e-19,  -3.880018311966313e-21,
  -6.868977070790080e-23,  -8.976916394740831e-25,   9.574424106379071e-01,  -1.194832778373172e-02,   4.116935586155510e-05,   8.765052618320161e-07,  -1.259267622560237e-08,
  -5.388283230568806e-11,   2.711567456824062e-12,  -1.484199848790790e-14,  -2.690601746438819e-16,   1.474306157144922e-17,   1.031883282416345e-19,  -3.891044897768196e-21,
  -6.864848459197286e-23,  -8.868014932227472e-25,   9.574506178714136e-01,  -1.194780212908967e-02,   4.115428057000001e-05,   8.763970615857455e-07,  -1.258455441428875e-08,
  -5.394384773626088e-11,   2.710075225482444e-12,  -1.473671786147544e-14,  -2.681540983684664e-16,   1.469985206288280e-17,   1.022838906386234e-19,  -3.904316141475765e-21,
  -6.859770677978097e-23,  -8.736602772904190e-25,   9.574585843547283e-01,  -1.194729185342435e-02,   4.113964884263143e-05,   8.762919841193166e-07,  -1.257667132271946e-08,
  -5.400293983337424e-11,   2.708628199160521e-12,  -1.463461272135596e-14,  -2.672770897100270e-16,   1.465785895155439e-17,   1.014060997547463e-19,  -3.917134559615898e-21,
  -6.854751896394847e-23,  -8.609314624887996e-25,   9.574650013645498e-01,  -1.194688079686307e-02,   4.112786393763598e-05,   8.762073075016947e-07,  -1.257032182508419e-08,
  -5.405044295484998e-11,   2.707463642381070e-12,  -1.455242946123013e-14,  -2.665724416262373e-16,   1.462399693322296e-17,   1.006991230754520e-19,  -3.927414342121171e-21,
  -6.850644869602475e-23,  -8.506976075969879e-25,   9.574692412747018e-01,  -1.194660918529630e-02,   4.112007777133745e-05,   8.761513412135905e-07,  -1.256612668854862e-08,
  -5.408178288640901e-11,   2.706694685722758e-12,  -1.449815916112980e-14,  -2.661077326787906e-16,   1.460160543706484e-17,   1.002320445631301e-19,  -3.934184261457044e-21,
  -6.847899727915335e-23,  -8.439451753816007e-25,   9.574714185676495e-01,  -1.194646970201421e-02,   4.111607953914723e-05,   8.761225956787529e-07,  -1.256397243928521e-08,
  -5.409786220376163e-11,   2.706299963236964e-12,  -1.447029957271257e-14,  -2.658693637870074e-16,   1.459010136829122e-17,   9.999220198837969e-20,  -3.937653899679589e-21,
  -6.846480294578033e-23,  -8.404805390537434e-25,   9.574721763778765e-01,  -1.194642115393932e-02,   4.111468797142941e-05,   8.761125898688386e-07,  -1.256322265762560e-08,
  -5.410345633207684e-11,   2.706162604076032e-12,  -1.446060450872029e-14,  -2.657864421066167e-16,   1.458609648222938e-17,   9.990872651046125e-20,  -3.938860418814594e-21,
  -6.845984708539140e-23,  -8.392751273731486e-25,   9.574722966311384e-01,  -1.194641345004548e-02,   4.111446715134263e-05,   8.761110020531257e-07,  -1.256310367876655e-08,
  -5.410434392806656e-11,   2.706140808379613e-12,  -1.445906611729020e-14,  -2.657732857044933e-16,   1.458546092449842e-17,   9.989548028840884e-20,  -3.939051823613153e-21,
  -6.845905992795850e-23,  -8.390838682358533e-25,   1.277529692311381e+00,  -1.293192781265778e-02,  -3.149805423160945e-05,   1.598725551173901e-06,   3.703222833301991e-09,
  -3.877966507431507e-10,  -3.532343300689805e-13,   1.092579126072164e-13,   3.044838711775921e-17,  -2.210114251166016e-17,   3.670703453301119e-19,   8.333939625224409e-21,
  -2.713691227388411e-22,  -6.132001540170167e-24,   1.277526743550527e+00,  -1.293147944582445e-02,  -3.149597396829152e-05,   1.598363790077813e-06,   3.702727454655350e-09,
  -3.875827167230607e-10,  -3.531236746915094e-13,   1.091843910189019e-13,   3.194403146789156e-17,  -2.205985528041702e-17,   3.654197181780196e-19,   8.290437098629388e-21,
  -2.707532941682009e-22,  -6.107652319744300e-24,   1.277521540573756e+00,  -1.293068837788859e-02,  -3.149230353709192e-05,   1.597725619622818e-06,   3.701853489762252e-09,
  -3.872053439281219e-10,  -3.529252616604160e-13,   1.090547730713016e-13,   3.457748305875571e-17,  -2.198718430944743e-17,   3.625102470563884e-19,   8.213819961270498e-21,
  -2.696676879120286e-22,  -6.064762184124366e-24,   1.277515249348289e+00,  -1.292973195055341e-02,  -3.148786559802604e-05,   1.596954214429411e-06,   3.700796920719532e-09,
  -3.867492203394793e-10,  -3.526799588627509e-13,   1.088982283829821e-13,   3.775227757243235e-17,  -2.189961800054798e-17,   3.589973426133457e-19,   8.121418513592252e-21,
  -2.683567192733431e-22,  -6.013025644141238e-24,   1.277509142217852e+00,  -1.292880361451335e-02,  -3.148355772729129e-05,   1.596205637970011e-06,   3.699771474813769e-09,
  -3.863066323473675e-10,  -3.524362001204786e-13,   1.087464567967229e-13,   4.082426588841400e-17,  -2.181493236940169e-17,   3.555925785804807e-19,   8.031972770228481e-21,
  -2.670858905199698e-22,  -5.962933013105890e-24,   1.277504222595278e+00,  -1.292805586441780e-02,  -3.148008765184626e-05,   1.595602802488606e-06,   3.698945572424716e-09,
  -3.859502387777682e-10,  -3.522358097437681e-13,   1.086243340653652e-13,   4.329182741268700e-17,  -2.174694123072034e-17,   3.528536845088375e-19,   7.960099583196651e-21,
  -2.660634406493550e-22,  -5.922673597641423e-24,   1.277500971895362e+00,  -1.292756181604613e-02,  -3.147779482938959e-05,   1.595204561351724e-06,   3.698399921571453e-09,
  -3.857148134409509e-10,  -3.521014292946352e-13,   1.085437071818246e-13,   4.491882918501306e-17,  -2.170212660973128e-17,   3.510457997291420e-19,   7.912696623280077e-21,
  -2.653884658217725e-22,  -5.896117093610588e-24,   1.277499302536042e+00,  -1.292730811451470e-02,  -3.147661739913169e-05,   1.595000076953805e-06,   3.698119731998717e-09,
  -3.855939338895794e-10,  -3.520318111168004e-13,   1.085023229305452e-13,   4.575328474301662e-17,  -2.167914698314322e-17,   3.501179602559340e-19,   7.888380609834779e-21,
  -2.650420321951590e-22,  -5.882493325399971e-24,   1.277498721505119e+00,  -1.292721981391193e-02,  -3.147620759071753e-05,   1.594928909297898e-06,   3.698022213966095e-09,
  -3.855518642556444e-10,  -3.520074832320133e-13,   1.084879221852042e-13,   4.604355152789858e-17,  -2.167115425512847e-17,   3.497951120687127e-19,   7.879921602452941e-21,
  -2.649214843373772e-22,  -5.877753717647281e-24,   1.277498629303746e+00,  -1.292720580194288e-02,  -3.147614256009704e-05,   1.594917616208943e-06,   3.698006739411996e-09,
  -3.855451885550615e-10,  -3.520036181450492e-13,   1.084856371476700e-13,   4.608960465176406e-17,  -2.166988618228449e-17,   3.497438850095371e-19,   7.878579483500955e-21,
  -2.649023565493484e-22,  -5.877001714877087e-24,   1.619679014906386e+00,  -1.055143447386760e-02,  -1.324774519147096e-04,   2.785767237916545e-07,   3.671069857914587e-08,
   2.929411798747050e-10,  -1.048869868259377e-11,  -2.351739673118428e-13,   2.052706522258098e-15,   1.430997480467770e-16,   1.134554173300162e-18,  -4.990000523955873e-20,
  -1.252718814505915e-21,   4.048946808986526e-24,   1.619666636454441e+00,  -1.055135517127042e-02,  -1.324568850418899e-04,   2.788475338860897e-07,   3.669601384288885e-08,
   2.924857431247017e-10,  -1.048321718994510e-11,  -2.346976754597340e-13,   2.057252078854095e-15,   1.428437259684095e-16,   1.127028912043987e-18,  -4.986767404701968e-20,
  -1.247820953295341e-21,   4.098985665410796e-24,   1.619644796038638e+00,  -1.055121517932719e-02,  -1.324206011708788e-04,   2.793250377599015e-07,   3.667010869761934e-08,
   2.916828768717008e-10,  -1.047353545445202e-11,  -2.338579525299666e-13,   2.065247172481631e-15,   1.423921092686431e-16,   1.113774939964129e-18,  -4.981033403070670e-20,
  -1.239193850518339e-21,   4.186806332172392e-24,   1.619618389029619e+00,  -1.055104579516855e-02,  -1.323767377478112e-04,   2.799018530310324e-07,   3.663879467347631e-08,
   2.907133359077108e-10,  -1.046181194078949e-11,  -2.328437465055256e-13,   2.074871310919939e-15,   1.418462461434369e-16,   1.097789765942284e-18,  -4.974050339878098e-20,
  -1.228787845655250e-21,   4.292194902595419e-24,   1.619592756342344e+00,  -1.055088125069535e-02,  -1.323341678538461e-04,   2.804612005748090e-07,   3.660840683208755e-08,
   2.897734758697865e-10,  -1.045041398136006e-11,  -2.318604248659247e-13,   2.084168658531679e-15,   1.413165805004457e-16,   1.082315205953572e-18,  -4.967219765552776e-20,
  -1.218713052600164e-21,   4.393664439378843e-24,   1.619572108974341e+00,  -1.055074861756814e-02,  -1.322998826668423e-04,   2.809113635799133e-07,   3.658393486463402e-08,
   2.890173059665037e-10,  -1.044121980414960e-11,  -2.310691705654826e-13,   2.091625860445898e-15,   1.408900677706659e-16,   1.069880272519742e-18,  -4.961680388236677e-20,
  -1.210616381117807e-21,   4.474807505537464e-24,   1.619558466536358e+00,  -1.055066093767166e-02,  -1.322772318194397e-04,   2.812086079317238e-07,   3.656776818451042e-08,
   2.885181165935229e-10,  -1.043513853027940e-11,  -2.305467628322945e-13,   2.096537495529013e-15,   1.406083237090165e-16,   1.061678733114422e-18,  -4.958002138769592e-20,
  -1.205275759974690e-21,   4.528132801310039e-24,   1.619551460793181e+00,  -1.055061589801244e-02,  -1.322656008221886e-04,   2.813611905627907e-07,   3.655946704595920e-08,
   2.882619055652644e-10,  -1.043201367556798e-11,  -2.302786172132201e-13,   2.099054926547270e-15,   1.404636619156096e-16,   1.057471560220798e-18,  -4.956107652033649e-20,
  -1.202536036309757e-21,   4.555427599997501e-24,   1.619549022428107e+00,  -1.055060021966248e-02,  -1.322615527535036e-04,   2.814142877501245e-07,   3.655657795377721e-08,
   2.881727523042163e-10,  -1.043092575024960e-11,  -2.301853082843640e-13,   2.099930357218395e-15,   1.404133153995984e-16,   1.056007964648723e-18,  -4.955447379552204e-20,
  -1.201582918421390e-21,   4.564913447431315e-24,   1.619548635495430e+00,  -1.055059773163483e-02,  -1.322609103905535e-04,   2.814227130395763e-07,   3.655611950390072e-08,
   2.881586060171452e-10,  -1.043075309767425e-11,  -2.301705024682619e-13,   2.100069238786349e-15,   1.404053263073216e-16,   1.055775747761487e-18,  -4.955342561698988e-20,
  -1.201431693954377e-21,   4.566418039546415e-24,   1.910404554355634e+00,  -3.613484381316892e-03,  -9.923246108369999e-05,  -2.090526195719914e-06,  -3.158638966724766e-08,
  -1.839195399351286e-10,   7.737490925581985e-12,   3.406245692854080e-13,   7.631797305588443e-15,   8.840267606364809e-17,  -7.991220675062360e-19,  -6.965080214216299e-20,
  -1.905695191422627e-21,  -2.887642519166992e-23,   1.910395215791602e+00,  -3.614072926726127e-03,  -9.925016551470807e-05,  -2.090692938743605e-06,  -3.157527298271328e-08,
  -1.832443651360308e-10,   7.757445749444152e-12,   3.409133295409727e-13,   7.628047165794377e-15,   8.803566785510487e-17,  -8.109062271167899e-19,  -6.985432028784566e-20,
  -1.905589533643551e-21,  -2.873916758616642e-23,   1.910378736406354e+00,  -3.615111461512284e-03,  -9.928140012285766e-05,  -2.090986643423913e-06,  -3.155563463501264e-08,
  -1.820525511178157e-10,   7.792648117514923e-12,   3.414218387722421e-13,   7.621389575077381e-15,   8.738723081605374e-17,  -8.316986377704803e-19,  -7.021260409242476e-20,
  -1.905367566190230e-21,  -2.849614544086966e-23,   1.910358807069519e+00,  -3.616367332139424e-03,  -9.931916057541438e-05,  -2.091340914188368e-06,  -3.153184889490917e-08,
  -1.806106179743761e-10,   7.835201100863702e-12,   3.420350051108887e-13,   7.613270245475559e-15,   8.660169493719820e-17,  -8.568393442016756e-19,  -7.064443095365675e-20,
  -1.905038547623404e-21,  -2.820086935304277e-23,   1.910339457618552e+00,  -3.617586575754675e-03,  -9.935580857686474e-05,  -2.091683912208927e-06,  -3.150871744547634e-08,
  -1.792100000072968e-10,   7.876495963699406e-12,   3.426284443428425e-13,   7.605315993321525e-15,   8.583760657782129e-17,  -8.812435714876926e-19,  -7.106215625721245e-20,
  -1.904655634448789e-21,  -2.791274568260060e-23,   1.910323868236187e+00,  -3.618568829878614e-03,  -9.938532513762471e-05,  -2.091959566199835e-06,  -3.149005392049779e-08,
  -1.780810979976408e-10,   7.909751884541588e-12,   3.431052115366954e-13,   7.598856460470763e-15,   8.522099167790403e-17,  -9.009018026129123e-19,  -7.139760350624026e-20,
  -1.904301637776850e-21,  -2.767958243137705e-23,   1.910313566209789e+00,  -3.619217909046795e-03,  -9.940482592465268e-05,  -2.092141389838222e-06,  -3.147770713520170e-08,
  -1.773348549124623e-10,   7.931721552166353e-12,   3.434196138496078e-13,   7.594562808200860e-15,   8.481301793714869e-17,  -9.138908340039388e-19,  -7.161873751278409e-20,
  -1.904045422453647e-21,  -2.752499680996472e-23,   1.910308275366468e+00,  -3.619551249407338e-03,  -9.941483951225597e-05,  -2.092234664879430e-06,  -3.147136206051499e-08,
  -1.769515354074194e-10,   7.943002398767100e-12,   3.435808773748923e-13,   7.592349985822539e-15,   8.460334154040309e-17,  -9.205610731642729e-19,  -7.173213823161952e-20,
  -1.903906944943267e-21,  -2.744545045500499e-23,   1.910306433798634e+00,  -3.619667272710254e-03,  -9.941832467393399e-05,  -2.092267114174504e-06,  -3.146915289718526e-08,
  -1.768181035454195e-10,   7.946928540997935e-12,   3.436369752313143e-13,   7.591578546763576e-15,   8.453033591903067e-17,  -9.228826703482825e-19,  -7.177158254890900e-20,
  -1.903857648120432e-21,  -2.741773828234681e-23,   1.910306141565217e+00,  -3.619685684064530e-03,  -9.941887771353563e-05,  -2.092272262674109e-06,  -3.146880230006564e-08,
  -1.767969290822027e-10,   7.947551553359509e-12,   3.436458756981139e-13,   7.591456070859744e-15,   8.451874970640758e-17,  -9.232510739013973e-19,  -7.177784059158595e-20,
  -1.903849773242635e-21,  -2.741333953977915e-23,   5.133466936560362e-03,  -8.278901558910563e-05,   9.968566799105562e-07,  -1.073367169514276e-08,   1.055614186041049e-10,
  -1.047954705064143e-12,   9.914409950614326e-15,  -3.892800157130067e-17,   2.367445499969694e-18,   1.494298199845485e-20,   5.133608978088835e-03,  -8.279360330243018e-05,
   9.969469334977261e-07,  -1.073516398332060e-08,   1.055826934097142e-10,  -1.048069907967840e-12,   9.923794380642665e-15,  -3.885654269455425e-17,   2.365104066067916e-18,
   1.475311538624251e-20,   5.133842171555826e-03,  -8.280113523727137e-05,   9.970951125374259e-07,  -1.073761393398290e-08,   1.056176338999908e-10,  -1.048258881149437e-12,
   9.939193605743868e-15,  -3.873993359710529e-17,   2.361244071162919e-18,   1.444152888033745e-20,   5.134089620502089e-03,  -8.280912782877677e-05,   9.972523598552638e-07,
  -1.074021368143017e-08,   1.056547280988561e-10,  -1.048459191871795e-12,   9.955524058236923e-15,  -3.861715647370302e-17,   2.357126403540367e-18,   1.411106230701260e-20,
   5.134284373286326e-03,  -8.281541849392681e-05,   9.973761272879104e-07,  -1.074225981243487e-08,   1.056839356423467e-10,  -1.048616690104571e-12,   9.968369445525536e-15,
  -3.852122087844655e-17,   2.353869940139020e-18,   1.385109328582210e-20,   5.134396772599699e-03,  -8.281904914164147e-05,   9.974475610926838e-07,  -1.074344072116723e-08,
   1.057007975830267e-10,  -1.048707526561076e-12,   9.975780051551807e-15,  -3.846613135651003e-17,   2.351984232753725e-18,   1.370110437785129e-20,   5.134438980353880e-03,
  -8.282041252033275e-05,   9.974743861795628e-07,  -1.074388417292908e-08,   1.057071304858865e-10,  -1.048741625455457e-12,   9.978562293263517e-15,  -3.844549700161880e-17,
   2.351274933959615e-18,   1.364479045285367e-20,   5.134445976929918e-03,  -8.282063852167920e-05,   9.974788328735350e-07,  -1.074395768186973e-08,   1.057081803119670e-10,
  -1.048747277250424e-12,   9.979023462488220e-15,  -3.844207932126946e-17,   2.351157294417117e-18,   1.363545605763313e-20,   4.631288732800156e-02,  -7.418634854472288e-04,
   8.768110004378704e-06,  -9.113663932342310e-08,   8.426668078369062e-10,  -7.687995025246401e-12,   6.408447765130373e-14,  -1.318448041717054e-17,   1.753384510956976e-17,
   1.848959218182030e-19,   4.631413654295878e-02,  -7.419024323399896e-04,   8.768830290575793e-06,  -9.114758010400227e-08,   8.428044262769430e-10,  -7.688020110229491e-12,
   6.415382851070870e-14,  -1.228285291714604e-17,   1.750919004818595e-17,   1.831963357390393e-19,   4.631618740576089e-02,  -7.419663733456957e-04,   8.770012842168671e-06,
  -9.116554118643308e-08,   8.430304559485467e-10,  -7.688059373452432e-12,   6.426760730262442e-14,  -1.080897088120509e-17,   1.746856417964699e-17,   1.804072312480262e-19,
   4.631836363066235e-02,  -7.420342242859631e-04,   8.771267736680299e-06,  -9.118459930986679e-08,   8.432704358944729e-10,  -7.688098435710520e-12,   6.438823748351738e-14,
  -9.253608413746111e-18,   1.742525266527328e-17,   1.774491993090454e-19,   4.632007640420040e-02,  -7.420876266568317e-04,   8.772255429181322e-06,  -9.119959817174154e-08,
   8.434594063054145e-10,  -7.688127301972195e-12,   6.448310299340459e-14,  -8.035711693916422e-18,   1.739101860679923e-17,   1.751222499744935e-19,   4.632106490860720e-02,
  -7.421184475418825e-04,   8.772825479488731e-06,  -9.120825431540149e-08,   8.435685068710514e-10,  -7.688143211210792e-12,   6.453782318208652e-14,  -7.335317061519972e-18,
   1.737120235806260e-17,   1.737797400370957e-19,   4.632143610738082e-02,  -7.421300213425701e-04,   8.773039545409272e-06,  -9.121150478474599e-08,   8.436094831636295e-10,
  -7.688149043750747e-12,   6.455836575314190e-14,  -7.072780096492970e-18,   1.736374999889421e-17,   1.732756934798152e-19,   4.632149763918303e-02,  -7.421319398789861e-04,
   8.773075030235323e-06,  -9.121204359663540e-08,   8.436162759897536e-10,  -7.688150003116592e-12,   6.456177069307729e-14,  -7.029285533819695e-18,   1.736251407517134e-17,
   1.731921447366073e-19,   1.292697917932099e-01,  -2.041128391589934e-03,   2.316124384072812e-05,  -2.217382420543901e-07,   1.743174445809813e-09,  -1.213863061528044e-11,
   5.481476466423160e-14,   1.452176167254491e-15,   3.515606247194473e-17,   6.750182083828850e-19,   1.292730908028558e-01,  -2.041223117421915e-03,   2.316273291298139e-05,
  -2.217554790821097e-07,   1.743293096561934e-09,  -1.213423794209681e-11,   5.495324018821827e-14,   1.455503684920455e-15,   3.507901124658054e-17,   6.701495747069894e-19,
   1.292785068145423e-01,  -2.041378630520562e-03,   2.316517753989936e-05,  -2.217837719135439e-07,   1.743488093767359e-09,  -1.212701955549722e-11,   5.518034576986991e-14,
   1.460948338344447e-15,   3.495208347192825e-17,   6.621598854012643e-19,   1.292842538300986e-01,  -2.041543649160906e-03,   2.316777157841219e-05,  -2.218137866213442e-07,
   1.743695289886998e-09,  -1.211935065760332e-11,   5.542101667729679e-14,   1.466701071724407e-15,   3.481681211180500e-17,   6.536862559420535e-19,   1.292887769125565e-01,
  -2.041673524927494e-03,   2.316981317311350e-05,  -2.218374038815564e-07,   1.743858563425536e-09,  -1.211330823770028e-11,   5.561020409615989e-14,   1.471210794800391e-15,
   3.470992559249801e-17,   6.470204153709339e-19,   1.292913873324259e-01,  -2.041748480868104e-03,   2.317099144652282e-05,  -2.218510320704066e-07,   1.743952875546825e-09,
  -1.210981825583389e-11,   5.571929874952665e-14,   1.473806347385932e-15,   3.464806828789587e-17,   6.431746173923473e-19,   1.292923675824868e-01,  -2.041776627965316e-03,
   2.317143390542317e-05,  -2.218561492516611e-07,   1.743988306513595e-09,  -1.210850720754411e-11,   5.576024801375712e-14,   1.474779662014317e-15,   3.462480796405274e-17,
   6.417307074879122e-19,   1.292925300735692e-01,  -2.041781293770468e-03,   2.317150724961034e-05,  -2.218569974798042e-07,   1.743994180538309e-09,  -1.210828985482310e-11,
   5.576703505033301e-14,   1.474940932097308e-15,   3.462095052969509e-17,   6.414913706668288e-19,   2.552069156665946e-01,  -3.934100191783839e-03,   4.154701358104714e-05,
  -3.371970849678096e-07,   1.678961700566721e-09,   2.155100558164484e-13,  -1.591672115624591e-13,   5.201398593434748e-15,   6.396029358728816e-17,   1.321700224268725e-18,
   2.552128309908557e-01,  -3.934244147074138e-03,   4.154844524596080e-05,  -3.371966460772917e-07,   1.678624929145444e-09,   2.311573415301747e-13,  -1.589152706232928e-13,
   5.207888543445916e-15,   6.382064326189740e-17,   1.311221050674000e-18,   2.552225421002233e-01,  -3.934480472821805e-03,   4.155079534880202e-05,  -3.371959094303684e-07,
   1.678072451483529e-09,   2.568587294958257e-13,  -1.585020761170283e-13,   5.218504089590502e-15,   6.359048934733790e-17,   1.294023813515304e-18,   2.552328465379739e-01,
  -3.934731232487140e-03,   4.155328870861037e-05,  -3.371951058515689e-07,   1.677486755776166e-09,   2.841486471676520e-13,  -1.580641998022720e-13,   5.229715342652685e-15,
   6.334506354762438e-17,   1.275784451008258e-18,   2.552409563295540e-01,  -3.934928581501644e-03,   4.155525079257712e-05,  -3.371944575399521e-07,   1.677026190590349e-09,
   3.056395015181925e-13,  -1.577199917768387e-13,   5.238500538855182e-15,   6.315103431099130e-17,   1.261435979138680e-18,   2.552456367069478e-01,  -3.935042475412223e-03,
   4.155638306814112e-05,  -3.371940770147891e-07,   1.676760541813826e-09,   3.180477117461864e-13,  -1.575215044747000e-13,   5.243555370668563e-15,   6.303870490151050e-17,
   1.253157614532714e-18,   2.552473942461799e-01,  -3.935085243695878e-03,   4.155680823348176e-05,  -3.371939329192220e-07,   1.676660816850762e-09,   3.227081407081416e-13,
  -1.574470011593128e-13,   5.245450623207734e-15,   6.299645774806912e-17,   1.250049465094247e-18,   2.552476855840439e-01,  -3.935092333150418e-03,   4.155687870991074e-05,
  -3.371939089697662e-07,   1.676644287529448e-09,   3.234807274310502e-13,  -1.574346527858318e-13,   5.245764636147817e-15,   6.298945117933913e-17,   1.249534269076725e-18,
   4.259146695064665e-01,  -6.324076550769455e-03,   5.903017612082806e-05,  -3.286096916957357e-07,  -8.419415791305803e-10,   3.932700016389867e-11,  -4.894236547599675e-13,
   7.414936065952878e-15,   1.797188420300103e-16,   1.511206587765753e-18,   4.259230684766345e-01,  -6.324216643066954e-03,   5.902945136685581e-05,  -3.285535383239239e-07,
  -8.429778575439612e-10,   3.934927395863337e-11,  -4.887117624427071e-13,   7.422171246013511e-15,   1.795172608662675e-16,   1.492318198845449e-18,   4.259368566704003e-01,
  -6.324446609881428e-03,   5.902826092902848e-05,  -3.284613305158813e-07,  -8.446779802372388e-10,   3.938585529678399e-11,  -4.875436661995777e-13,   7.433979116742163e-15,
   1.791846444438922e-16,   1.461322095672968e-18,   4.259514869076579e-01,  -6.324690598842433e-03,   5.902699691726653e-05,  -3.283634596910370e-07,  -8.464804527206969e-10,
   3.942469163427630e-11,  -4.863050306055859e-13,   7.446413275558314e-15,   1.788294219123755e-16,   1.428449565384445e-18,   4.259630009074017e-01,  -6.324882602344888e-03,
   5.902600150721230e-05,  -3.282864122310495e-07,  -8.478979302906431e-10,   3.945527096591778e-11,  -4.853308026672458e-13,   7.456130330117449e-15,   1.785482042715444e-16,
   1.402590895614765e-18,   4.259696458321906e-01,  -6.324993404468373e-03,   5.902542678570632e-05,  -3.282419375712450e-07,  -8.487155524312915e-10,   3.947292485945157e-11,
  -4.847687917694507e-13,   7.461710702994074e-15,   1.783852453834833e-16,   1.387672259011785e-18,   4.259721410619273e-01,  -6.325035010472273e-03,   5.902521092465463e-05,
  -3.282252351807791e-07,  -8.490224960607075e-10,   3.947955519659912e-11,  -4.845577956059263e-13,   7.463800985951710e-15,   1.783239275615897e-16,   1.382071092937429e-18,
   4.259725546816770e-01,  -6.325041907194623e-03,   5.902517514009465e-05,  -3.282224664300861e-07,  -8.490733720556447e-10,   3.948065432915084e-11,  -4.845228223221406e-13,
   7.464147205833204e-15,   1.783137566561134e-16,   1.381142668633001e-18,   6.436233576851355e-01,  -9.012682480563026e-03,   6.694613235165216e-05,  -4.135879528071035e-08,
  -6.756624118021285e-09,   8.101042843546081e-11,  -1.530364938421845e-13,  -2.536883050655327e-15,   4.399711378610427e-16,   3.035045253236316e-18,   6.436328730066093e-01,
  -9.012699730487673e-03,   6.694036152477241e-05,  -4.124357330534475e-08,  -6.756930113826790e-09,   8.100308179891323e-11,  -1.512944455351278e-13,  -2.522098321847853e-15,
   4.394408588912118e-16,   3.006573293850146e-18,   6.436484933534139e-01,  -9.012728013491546e-03,   6.693088759592750e-05,  -4.105442523903208e-08,  -6.757429773664015e-09,
   8.099105254351364e-11,  -1.484361356249917e-13,  -2.497932090529558e-15,   4.385673232513449e-16,   2.959849602957742e-18,   6.436650669422660e-01,  -9.012757975645054e-03,
   6.692083477794350e-05,  -4.085373463395779e-08,  -6.757956307888659e-09,   8.097833117522180e-11,  -1.454053514721401e-13,  -2.472432918270571e-15,   4.376363682041913e-16,
   2.910296272810561e-18,   6.436781098599553e-01,  -9.012781521048022e-03,   6.691292297904401e-05,  -4.069579738077561e-08,  -6.758368056143258e-09,   8.096835013814852e-11,
  -1.430216351661458e-13,  -2.452468491518244e-15,   4.369007629856715e-16,   2.871315117062380e-18,   6.436856369487727e-01,  -9.012795095543362e-03,   6.690835685394156e-05,
  -4.060465162831956e-08,  -6.758604627434167e-09,   8.096260217900802e-11,  -1.416465590878619e-13,  -2.440988131292693e-15,   4.364750546130631e-16,   2.848825412507377e-18,
   6.436884634012384e-01,  -9.012800190251996e-03,   6.690664221512181e-05,  -4.057042604419465e-08,  -6.758693262623701e-09,   8.096044608277189e-11,  -1.411303203955773e-13,
  -2.436684984833540e-15,   4.363149747784511e-16,   2.840381647985955e-18,   6.436889319238582e-01,  -9.012801034633113e-03,   6.690635798848620e-05,  -4.056475269285003e-08,
  -6.758707944641909e-09,   8.096008880123335e-11,  -1.410447525686282e-13,  -2.435972090437533e-15,   4.362884275424726e-16,   2.838982044122011e-18,   9.103568123464354e-01,
  -1.158089262012929e-02,   5.047372869573958e-05,   6.697707262561933e-07,  -1.306465715392839e-08,   5.820141543822447e-12,   2.256682765512133e-12,  -1.469068642036677e-14,
   2.865765293660258e-16,   1.445081497309858e-17,   9.103639727516617e-01,  -1.158060665232571e-02,   5.046260089049684e-05,   6.697786488584636e-07,  -1.305982672999714e-08,
   5.777392015129084e-12,   2.257803760614935e-12,  -1.461832891986107e-14,   2.855730423863625e-16,   1.438840190789102e-17,   9.103757265758704e-01,  -1.158013718751947e-02,
   5.044433578198371e-05,   6.697916115998774e-07,  -1.305189508874674e-08,   5.707366945590662e-12,   2.259641143537411e-12,  -1.449977324050458e-14,   2.839218285932622e-16,
   1.428597192400205e-17,   9.103881967428954e-01,  -1.157963904585284e-02,   5.042495914718309e-05,   6.698053070474839e-07,  -1.304347667106941e-08,   5.633275591732905e-12,
   2.261586785198536e-12,  -1.437429020682624e-14,   2.821645715039714e-16,   1.417732842163367e-17,   9.103980097085757e-01,  -1.157924700341504e-02,   5.040971257160040e-05,
   6.698160427707448e-07,  -1.303684964469447e-08,   5.575117613723497e-12,   2.263115140907017e-12,  -1.427576148047998e-14,   2.807778501283062e-16,   1.409185649234799e-17,
   9.104036725135299e-01,  -1.157902074712643e-02,   5.040091465246867e-05,   6.698222214863735e-07,  -1.303302438242310e-08,   5.541614488836451e-12,   2.263996031075313e-12,
  -1.421898963426057e-14,   2.799760452528593e-16,   1.404254149891030e-17,   9.104057988681596e-01,  -1.157893578546432e-02,   5.039761116897860e-05,   6.698245384298668e-07,
  -1.303158783075236e-08,   5.529045250014404e-12,   2.264326595828422e-12,  -1.419768844102074e-14,   2.796746761886432e-16,   1.402402560489241e-17,   9.104061513373948e-01,
  -1.157892170184343e-02,   5.039706358104994e-05,   6.698249223263118e-07,  -1.303134969501822e-08,   5.526962326172629e-12,   2.264381380148939e-12,  -1.419415837064504e-14,
   2.796247050117145e-16,   1.402095645599786e-17,   1.225420078775333e+00,  -1.310672072796490e-02,  -1.221260605278476e-05,   1.596478299005163e-06,  -3.891559464229936e-09,
  -3.600599819478361e-10,   2.622984071736194e-12,   1.007816607867651e-13,  -4.544542475244512e-16,  -4.842791912469943e-18,   1.225418334213858e+00,  -1.310604095695144e-02,
  -1.221589724347867e-05,   1.595968446020116e-06,  -3.885981327202628e-09,  -3.597592338977440e-10,   2.621218278613327e-12,   1.007548026822001e-13,  -4.522676217997607e-16,
  -4.919159406010919e-18,   1.225415469900311e+00,  -1.310492515951562e-02,  -1.222129682990741e-05,   1.595131748963965e-06,  -3.876826612840023e-09,  -3.592655666312631e-10,
   2.618325639510007e-12,   1.007104286424628e-13,  -4.486955826205197e-16,  -5.044440840337764e-18,   1.225412430189125e+00,  -1.310374142510702e-02,  -1.222702153987925e-05,
   1.594244368823096e-06,  -3.867116418131183e-09,  -3.587418284752878e-10,   2.615264719055331e-12,   1.006629611184953e-13,  -4.449293377654074e-16,  -5.177254084124599e-18,
   1.225410037592513e+00,  -1.310280997401692e-02,  -1.223152353725595e-05,   1.593546300127811e-06,  -3.859477093210955e-09,  -3.583297026797602e-10,   2.612861813674220e-12,
   1.006253265937394e-13,  -4.419826047933163e-16,  -5.281691721680609e-18,   1.225408656646819e+00,  -1.310227247714009e-02,  -1.223412037355537e-05,   1.593143552938453e-06,
  -3.855069350072130e-09,  -3.580918805147813e-10,   2.611477470005989e-12,   1.006034958509145e-13,  -4.402889211436453e-16,  -5.341929761042894e-18,   1.225408138063149e+00,
  -1.310207065338994e-02,  -1.223509525543639e-05,   1.592992340404246e-06,  -3.853414399009984e-09,  -3.580025804149806e-10,   2.610958091747911e-12,   1.005952771920992e-13,
  -4.396542354480219e-16,  -5.364543128654000e-18,   1.225408052099173e+00,  -1.310203719883020e-02,  -1.223525684255941e-05,   1.592967275977731e-06,  -3.853140077746574e-09,
  -3.579877778822313e-10,   2.610872021431890e-12,   1.005939137241680e-13,  -4.395490962553263e-16,  -5.368291268874614e-18,   1.575388512930372e+00,  -1.158753261497978e-02,
  -1.254653080206931e-04,   8.970971419053638e-07,   3.957660314031977e-08,  -2.544676507591125e-11,  -1.534545792497977e-11,  -8.355605438044537e-14,   7.343893811277828e-15,
   1.289953755101300e-16,   1.575370725878260e+00,  -1.158714975987758e-02,  -1.254316992456342e-04,   8.970589166764080e-07,   3.954419036176877e-08,  -2.568624123218140e-11,
  -1.531648163681527e-11,  -8.291373050356966e-14,   7.330105155379803e-15,   1.283031904019146e-16,   1.575341528980214e+00,  -1.158652125350812e-02,  -1.253765448946844e-04,
   8.969959216942932e-07,   3.949102409241607e-08,  -2.607800470599922e-11,  -1.526895210849465e-11,  -8.186179808532921e-14,   7.307463912939690e-15,   1.271690914698244e-16,
   1.575310553470730e+00,  -1.158585437634958e-02,  -1.253180488860566e-04,   8.969287509083018e-07,   3.943467108817133e-08,  -2.649182975828523e-11,  -1.521857362060983e-11,
  -8.074907244230997e-14,   7.283433180179726e-15,   1.259687575875346e-16,   1.575286178952116e+00,  -1.158532955262552e-02,  -1.252720317716532e-04,   8.968756500947617e-07,
   3.939036476701588e-08,  -2.681616337370376e-11,  -1.517896460027002e-11,  -7.987585017611846e-14,   7.264516132486409e-15,   1.250262805809183e-16,   1.575272113291420e+00,
  -1.158502667145380e-02,  -1.252454822285342e-04,   8.968449097532452e-07,   3.936481226692903e-08,  -2.700280272444632e-11,  -1.515612114100912e-11,  -7.937289695312803e-14,
   7.253596856695747e-15,   1.244832361375096e-16,   1.575266831751209e+00,  -1.158491293748219e-02,  -1.252355140912279e-04,   8.968333485502780e-07,   3.935522036406464e-08,
  -2.707278569811182e-11,  -1.514754615898859e-11,  -7.918422196820070e-14,   7.249496207567847e-15,   1.242794832540904e-16,   1.575265956273785e+00,  -1.158489408449700e-02,
  -1.252338618078605e-04,   8.968314311717228e-07,   3.935363054372485e-08,  -2.708438100120258e-11,  -1.514612488935262e-11,  -7.915295635345889e-14,   7.248816447742492e-15,
   1.242457170353295e-16,   1.894190749100982e+00,  -4.516530212411622e-03,  -1.274309644092186e-04,  -2.611461764786170e-06,  -3.247933497195852e-08,   1.464547013423036e-10,
   2.108664627350815e-11,   6.217641610715774e-13,   9.215557268132838e-15,  -3.666998757930513e-17,   1.894172559492693e+00,  -4.517644308261851e-03,  -1.274584390512198e-04,
  -2.611237695811075e-06,  -3.243389850734896e-08,   1.483090964646449e-10,   2.112250342149158e-11,   6.215364895286580e-13,   9.174067936587583e-15,  -3.815378262878192e-17,
   1.894142695521506e+00,  -4.519473204152351e-03,  -1.275035149486041e-04,  -2.610867944522141e-06,  -3.235925233344652e-08,   1.513528685861410e-10,   2.118124859123549e-11,
   6.211572444381142e-13,   9.105842487116126e-15,  -4.058850053297882e-17,   1.894111003755886e+00,  -4.521413704850311e-03,  -1.275513056504095e-04,  -2.610473019977925e-06,
  -3.227997251095510e-08,   1.545818361151877e-10,   2.124341829472623e-11,   6.207473834170712e-13,   9.033295547556483e-15,  -4.317031002937659e-17,   1.894086059431275e+00,
  -4.522940817026077e-03,  -1.275888894325201e-04,  -2.610160337401658e-06,  -3.221752504118794e-08,   1.571225314088892e-10,   2.129222768680787e-11,   6.204194266582063e-13,
   8.976089255672664e-15,  -4.520102171171424e-17,   1.894071662476442e+00,  -4.523822114351912e-03,  -1.276105686392296e-04,  -2.609979130704785e-06,  -3.218146383281810e-08,
   1.585886065758762e-10,   2.132034899815615e-11,   6.202279948746931e-13,   8.943029824715132e-15,  -4.637250411385117e-17,   1.894066256069383e+00,  -4.524153044775268e-03,
  -1.276187072928842e-04,  -2.609910943762374e-06,  -3.216791841999838e-08,   1.591390925310799e-10,   2.133089983854972e-11,   6.201557018634928e-13,   8.930607271537143e-15,
  -4.681231581744574e-17,   1.894065359869089e+00,  -4.524207900940149e-03,  -1.276200562802110e-04,  -2.609899633308391e-06,  -3.216567285927795e-08,   1.592303413506209e-10,
   2.133264831688383e-11,   6.201436967152370e-13,   8.928547612321061e-15,  -4.688521605468951e-17,   4.817483361845735e-03,  -7.530217577799854e-05,   8.775361134022334e-07,
  -9.199644974869187e-09,   8.693930916874250e-11,  -8.141853816404026e-13,   9.932984506415179e-15,   4.033905712116647e-17,   2.350781997951752e-18,  -2.514293501839228e-20,
   4.817608391206234e-03,  -7.530610739886469e-05,   8.776104668159516e-07,  -9.200802623191791e-09,   8.696062040028430e-11,  -8.140670213595280e-13,   9.942119654294849e-15,
   4.020287044025854e-17,   2.339610261075442e-18,  -2.541867425702884e-20,   4.817813654809947e-03,  -7.531256214799886e-05,   8.777325431681327e-07,  -9.202702969505887e-09,
   8.699562020782112e-11,  -8.138730127465802e-13,   9.957084315159111e-15,   3.997828450540497e-17,   2.321272020755247e-18,  -2.587034201192702e-20,   4.818031465788651e-03,
  -7.531941162115987e-05,   8.778620935446302e-07,  -9.204719219872564e-09,   8.703277667067434e-11,  -8.136675621004496e-13,   9.972919268264543e-15,   3.973860613779666e-17,
   2.301816491656844e-18,  -2.634823213148330e-20,   4.818202891726422e-03,  -7.532480254400492e-05,   8.779640633586485e-07,  -9.206305900941131e-09,   8.706203270986219e-11,
  -8.135061673332944e-13,   9.985349815946820e-15,   3.954898382967357e-17,   2.286506949008978e-18,  -2.672334533853368e-20,   4.818301828015082e-03,  -7.532791389187965e-05,
   8.780229173393293e-07,  -9.207221558130436e-09,   8.707892242984736e-11,  -8.134131422058841e-13,   9.992511044644279e-15,   3.943915110272223e-17,   2.277672359067725e-18,
  -2.693943378774075e-20,   4.818338980147607e-03,  -7.532908226057369e-05,   8.780450185786469e-07,  -9.207565387540962e-09,   8.708526572404444e-11,  -8.133782328648031e-13,
   9.995197760034781e-15,   3.939783266127196e-17,   2.274355045112176e-18,  -2.702050212420704e-20,   4.818345138675554e-03,  -7.532927593581324e-05,   8.780486822273475e-07,
  -9.207622381714216e-09,   8.708631727050804e-11,  -8.133724473307241e-13,   9.995642995107636e-15,   3.939097957467409e-17,   2.273805161468120e-18,  -2.703393640246366e-20,
   4.347910562793947e-02,  -6.758750973153563e-04,   7.750565509079984e-06,  -7.879940363022009e-08,   7.046056631950554e-10,  -6.086387030833371e-12,   7.224439677559100e-14,
   6.042414850079408e-16,   1.879770089154897e-17,  -1.985482577231454e-19,   4.348020980198177e-02,  -6.759087690610555e-04,   7.751168011504924e-06,  -7.880804992373761e-08,
   7.047607376966736e-10,  -6.084598743153777e-12,   7.231713061567671e-14,   6.031573014158975e-16,   1.869323091008703e-17,  -2.010527220933384e-19,   4.348202254454209e-02,
  -6.759640493472757e-04,   7.752157212751257e-06,  -7.882224238227128e-08,   7.050154286603798e-10,  -6.081665364723596e-12,   7.243623420976195e-14,   6.013682343762257e-16,
   1.852174295290928e-17,  -2.051549988804699e-19,   4.348394608900906e-02,  -6.760227096269828e-04,   7.753206962249583e-06,  -7.883729918981237e-08,   7.052858261602014e-10,
  -6.078556076066138e-12,   7.256220357652008e-14,   5.994574054215984e-16,   1.833980401832517e-17,  -2.094953064895344e-19,   4.348545998980434e-02,  -6.760688781987158e-04,
   7.754033215153385e-06,  -7.884914717627234e-08,   7.054987393267834e-10,  -6.076111413033929e-12,   7.266104620471085e-14,   5.979445442302892e-16,   1.819663436887703e-17,
  -2.129020732116508e-19,   4.348633371608723e-02,  -6.760955240357636e-04,   7.754510099764129e-06,  -7.885598415968850e-08,   7.056216592707088e-10,  -6.074701500398469e-12,
   7.271797160414897e-14,   5.970678281344141e-16,   1.811401546452699e-17,  -2.148645427545304e-19,   4.348666181363142e-02,  -6.761055300112750e-04,   7.754689181842797e-06,
  -7.885855137866624e-08,   7.056678251634891e-10,  -6.074172244116044e-12,   7.273932523929381e-14,   5.967379299567745e-16,   1.808299260850415e-17,  -2.156007808014168e-19,
   4.348671620074030e-02,  -6.761071886554233e-04,   7.754718867638704e-06,  -7.885897692477000e-08,   7.056754782550846e-10,  -6.074084521811943e-12,   7.274286372732133e-14,
   5.966832086174723e-16,   1.807785019856783e-17,  -2.157227864505709e-19,   1.214596517558171e-01,  -1.866025640566044e-03,   2.065999354592143e-05,  -1.957017971383233e-07,
   1.517586749106278e-09,  -1.019026202482896e-11,   1.138874715167372e-13,   2.814507031991057e-15,   4.327785433783678e-17,  -4.647276358612261e-19,   1.214625944332779e-01,
  -1.866109240945340e-03,   2.066129071787143e-05,  -1.957162280044198e-07,   1.517831818273142e-09,  -1.018189251412256e-11,   1.140535610678227e-13,   2.811933418812937e-15,
   4.297153801584745e-17,  -4.719330652912312e-19,   1.214674254483722e-01,  -1.866246488938579e-03,   2.066342038749156e-05,  -1.957399100161915e-07,   1.518234391853873e-09,
  -1.016815829140025e-11,   1.143253420228324e-13,   2.807681935754922e-15,   4.246871548105005e-17,  -4.837354180421148e-19,   1.214725517106386e-01,  -1.866392125701445e-03,
   2.066568033813480e-05,  -1.957650267892489e-07,   1.518661896479289e-09,  -1.015359297536530e-11,   1.146125240898031e-13,   2.803134848398616e-15,   4.193524552091209e-17,
  -4.962225404723512e-19,   1.214765862376724e-01,  -1.866506746967214e-03,   2.066745908080379e-05,  -1.957847853735361e-07,   1.518998592579614e-09,  -1.014213563502158e-11,
   1.148376701769376e-13,   2.799530291119270e-15,   4.151544954144918e-17,  -5.060238165486814e-19,   1.214789146949083e-01,  -1.866572898891641e-03,   2.066848568798448e-05,
  -1.957961850533319e-07,   1.519193005585981e-09,  -1.013552564869134e-11,   1.149672585864302e-13,   2.797439632297804e-15,   4.127319672163059e-17,  -5.116698313778725e-19,
   1.214797890637329e-01,  -1.866597739927911e-03,   2.066887120053334e-05,  -1.958004651066470e-07,   1.519266028311623e-09,  -1.013304396288642e-11,   1.150158545874660e-13,
   2.796652605394446e-15,   4.118223215641439e-17,  -5.137879816760517e-19,   1.214799340034075e-01,  -1.866601857702695e-03,   2.066893510535497e-05,  -1.958011745529975e-07,
   1.519278133860027e-09,  -1.013263261063877e-11,   1.150239066024582e-13,   2.796522040865213e-15,   4.116715367852205e-17,  -5.141389906937059e-19,   2.401102839146997e-01,
  -3.617453622068577e-03,   3.766144518133444e-05,  -3.104526106666184e-07,   1.658219117904493e-09,  -1.590561648198411e-12,   2.037209648390251e-14,   7.715429692125988e-15,
   7.975070128712451e-17,  -9.569830229883992e-19,   2.401156462628298e-01,  -3.617586168403539e-03,   3.766286131048192e-05,  -3.104546802832719e-07,   1.658266205751019e-09,
  -1.567590131925333e-12,   2.067684805111603e-14,   7.710118699730222e-15,   7.912301025365979e-17,  -9.722426962411982e-19,   2.401244495711079e-01,  -3.617803765263708e-03,
   3.766518614593194e-05,  -3.104580543022762e-07,   1.658343971328439e-09,  -1.529890405688131e-12,   2.117533991819809e-14,   7.701343757046987e-15,   7.809265555694347e-17,
  -9.972388886089851e-19,   2.401337907600153e-01,  -3.618034653162285e-03,   3.766765301732598e-05,  -3.104616023408224e-07,   1.658427114691931e-09,  -1.489904098004382e-12,
   2.170182241529408e-14,   7.691956746833851e-15,   7.699951212267910e-17,  -1.023686916447220e-18,   2.401411424684546e-01,  -3.618216363736969e-03,   3.766959448810145e-05,
  -3.104643714613790e-07,   1.658493002498413e-09,  -1.458446311413659e-12,   2.211438890369358e-14,   7.684514097168251e-15,   7.613930906171288e-17,  -1.044447392753972e-18,
   2.401453853407505e-01,  -3.618321232696456e-03,   3.767071496092604e-05,  -3.104659602752639e-07,   1.658531209046750e-09,  -1.440296093687173e-12,   2.235177642577561e-14,
   7.680196771469120e-15,   7.564291288030178e-17,  -1.056406900576648e-18,   2.401469785923750e-01,  -3.618360612077582e-03,   3.767113571190074e-05,  -3.104665551331374e-07,
   1.658545590226273e-09,  -1.433481394193076e-12,   2.244078310512355e-14,   7.678571412854410e-15,   7.545651959364026e-17,  -1.060893697895422e-18,   2.401472426972115e-01,
  -3.618367139775991e-03,   3.767120545751811e-05,  -3.104666536466317e-07,   1.658547975917829e-09,  -1.432351807090011e-12,   2.245553013058074e-14,   7.678301767030937e-15,
   7.542562268556527e-17,  -1.061637231540626e-18,   4.015376225533556e-01,  -5.867781384661317e-03,   5.503014410218620e-05,  -3.363438458779672e-07,  -1.525227879351169e-10,
   3.075836400750999e-11,  -1.961218903278308e-13,   1.356615262947894e-14,   1.823125666673826e-16,  -2.300757469858208e-18,   4.015454534805470e-01,  -5.867924821351311e-03,
   5.503001155086271e-05,  -3.362997340614765e-07,  -1.529331036797883e-10,   3.079870402405034e-11,  -1.954180686128852e-13,   1.355361806199636e-14,   1.812222841804992e-16,
  -2.328698319432861e-18,   4.015583092012878e-01,  -5.868160282207666e-03,   5.502979369581253e-05,  -3.362272759655415e-07,  -1.536056295478624e-10,   3.086490113218515e-11,
  -1.942657704578418e-13,   1.353293783457021e-14,   1.794325626794759e-16,  -2.374467713832909e-18,   4.015719500961355e-01,  -5.868410105770577e-03,   5.502956219453640e-05,
  -3.361503360611863e-07,  -1.543177747018429e-10,   3.093510380583517e-11,  -1.930473590929456e-13,   1.351085513201743e-14,   1.775337463093368e-16,  -2.422896498192820e-18,
   4.015826855387045e-01,  -5.868606704752289e-03,   5.502937975576009e-05,  -3.360897432274521e-07,  -1.548771840256455e-10,   3.099032637890739e-11,  -1.920915514641400e-13,
   1.349337517212193e-14,   1.760395305788425e-16,  -2.460911579224622e-18,   4.015888811671807e-01,  -5.868720160465752e-03,   5.502927436823586e-05,  -3.360547575978412e-07,
  -1.551996088161588e-10,   3.102218543118659e-11,  -1.915411741515489e-13,   1.348324680983213e-14,   1.751772566691584e-16,  -2.482811258273181e-18,   4.015912076862698e-01,
  -5.868762763192864e-03,   5.502923477555864e-05,  -3.360416170617873e-07,  -1.553206029886573e-10,   3.103414674410454e-11,  -1.913347359766497e-13,   1.347943589150588e-14,
   1.748534771798355e-16,  -2.491027322902699e-18,   4.015915933400567e-01,  -5.868769825150796e-03,   5.502922821152398e-05,  -3.360394386671500e-07,  -1.553406553104056e-10,
   3.103612939321679e-11,  -1.913005282374710e-13,   1.347880377553712e-14,   1.747998067832598e-16,  -2.492388858380257e-18,   6.086381887764818e-01,  -8.480814606371945e-03,
   6.585401651691277e-05,  -1.366971935190604e-07,  -5.170356013415755e-09,   7.814613396215582e-11,  -1.703499128735281e-14,   1.230355251532721e-14,   4.447010531540485e-16,
  -4.248746849655618e-18,   6.086475514088935e-01,  -8.480872571384572e-03,   6.584960175944941e-05,  -1.365856788536343e-07,  -5.170371861985416e-09,   7.818253296995731e-11,
  -1.530315346385582e-14,   1.228057650200904e-14,   4.427675841975943e-16,  -4.293952572734121e-18,   6.086629212316295e-01,  -8.480967695854612e-03,   6.584235421707521e-05,
  -1.364025721933319e-07,  -5.170395229356187e-09,   7.824223742125870e-11,  -1.246562915383019e-14,   1.224269154769382e-14,   4.395935773973400e-16,  -4.367995363866646e-18,
   6.086792291850084e-01,  -8.481068583403027e-03,   6.583466401055545e-05,  -1.362082312233676e-07,  -5.170416426233122e-09,   7.830551974986367e-11,  -9.462363424439916e-15,
   1.220226727101903e-14,   4.362258534290144e-16,  -4.446329620579887e-18,   6.086920631837042e-01,  -8.481147948496385e-03,   6.582861177547126e-05,  -1.360552472082288e-07,
  -5.170430507145433e-09,   7.835527337414463e-11,  -7.104255985286939e-15,   1.217029021992656e-14,   4.335755503208878e-16,  -4.507811777732546e-18,   6.086994697564125e-01,
  -8.481193738038278e-03,   6.582511891162584e-05,  -1.359669424576757e-07,  -5.170437592066894e-09,   7.838396711026944e-11,  -5.745542061270151e-15,   1.215177041634304e-14,
   4.320460573458568e-16,  -4.543227212259643e-18,   6.087022509643009e-01,  -8.481210929894826e-03,   6.582380730642723e-05,  -1.359337803712271e-07,  -5.170440055825719e-09,
   7.839473809719785e-11,  -5.235746530611797e-15,   1.214480372893713e-14,   4.314717271406885e-16,  -4.556513367329856e-18,   6.087027119875341e-01,  -8.481213779555451e-03,
   6.582358988908736e-05,  -1.359282831343769e-07,  -5.170440453855763e-09,   7.839652334203534e-11,  -5.151262520348355e-15,   1.214364825126329e-14,   4.313765242053352e-16,
  -4.558715067955075e-18,   8.648867422853284e-01,  -1.114848001611952e-02,   5.726981891281307e-05,   4.644945321468175e-07,  -1.243278689170826e-08,   5.650065205641247e-11,
   2.039156993076667e-12,   8.618014343079424e-16,   6.013392899416155e-16,   2.084298142622316e-19,   8.648948709039178e-01,  -1.114828142902403e-02,   5.725922808261149e-05,
   4.645749582592361e-07,  -1.242840664625907e-08,   5.650320575051919e-11,   2.041476292750156e-12,   8.607113692268730e-16,   5.976372468540087e-16,   1.278015217378968e-19,
   8.649082142619360e-01,  -1.114795539133485e-02,   5.724184423219169e-05,   4.647069933580769e-07,  -1.242121222675965e-08,   5.650739429838232e-11,   2.045273143361660e-12,
   8.586253512869302e-16,   5.915608973133082e-16,  -4.290635627525092e-21,   8.649223711217600e-01,  -1.114760940639649e-02,   5.722340230945159e-05,   4.648470963598879e-07,
  -1.241357359258824e-08,   5.651183321874193e-11,   2.049287415918617e-12,   8.560095111402996e-16,   5.851150090423730e-16,  -1.440802979214886e-19,   8.649335115775215e-01,
  -1.114733708999426e-02,   5.720889108911334e-05,   4.649573607318165e-07,  -1.240755847979111e-08,   5.651532244975148e-11,   2.052436187516114e-12,   8.536599081986577e-16,
   5.800432273267118e-16,  -2.538271059998790e-19,   8.649399405245964e-01,  -1.114717992107754e-02,   5.720051745057680e-05,   4.650209974877277e-07,  -1.240408565293159e-08,
   5.651733437019834e-11,   2.054249203964522e-12,   8.521874335810439e-16,   5.771166757740770e-16,  -3.170564636532735e-19,   8.649423545773000e-01,  -1.114712090073487e-02,
   5.719737326840767e-05,   4.650448939170899e-07,  -1.240278130991084e-08,   5.651808951857703e-11,   2.054929215655086e-12,   8.516125072372801e-16,   5.760178165780149e-16,
  -3.407793548373555e-19,   8.649427547368246e-01,  -1.114711111717059e-02,   5.719685208588471e-05,   4.650488551025748e-07,  -1.240256508257009e-08,   5.651821467662195e-11,
   2.055041895439973e-12,   8.515160449182162e-16,   5.758356697016517e-16,  -3.447106892098649e-19,   1.172916944250200e+00,  -1.312936955294643e-02,   6.347531156176422e-06,
   1.480952700420692e-06,  -1.024357117964772e-08,  -2.649781070090523e-10,   5.228309189364200e-12,   8.504912860074888e-14,  -5.235453771127113e-16,  -4.362880488688642e-18,
   1.172917830089732e+00,  -1.312873862580664e-02,   6.338847818545619e-06,   1.480577758842422e-06,  -1.023243635386234e-08,  -2.647243876968580e-10,   5.226163333671115e-12,
   8.502183374134374e-14,  -5.264205546037522e-16,  -4.547661932167652e-18,   1.172919283455710e+00,  -1.312770297195994e-02,   6.324599577698489e-06,   1.479962492319993e-06,
  -1.021416007733781e-08,  -2.643079285336672e-10,   5.222632263389667e-12,   8.497634583081526e-14,  -5.311441565221628e-16,  -4.850316353290503e-18,   1.172920824389686e+00,
  -1.312660421965306e-02,   6.309490419419450e-06,   1.479310001342153e-06,  -1.019477208455242e-08,  -2.638661184412574e-10,   5.218874237813884e-12,   8.492715825849196e-14,
  -5.361610267363522e-16,  -5.170512577044524e-18,   1.172922036244542e+00,  -1.312573960906557e-02,   6.297606184186043e-06,   1.478796744047612e-06,  -1.017951693158508e-08,
  -2.635184739411176e-10,   5.215908475481293e-12,   8.488778138097114e-14,  -5.401127491560054e-16,  -5.421825560605813e-18,   1.172922735281726e+00,  -1.312524067077401e-02,
   6.290750265776641e-06,   1.478500636048355e-06,  -1.017071420882273e-08,  -2.633178667075094e-10,   5.214193597114555e-12,   8.486478961390191e-14,  -5.423947262394329e-16,
  -5.566589366063812e-18,   1.172922997711386e+00,  -1.312505332306110e-02,   6.288176311691800e-06,   1.478389463983432e-06,  -1.016740894941977e-08,  -2.632425414851529e-10,
   5.213549023316837e-12,   8.485610562975891e-14,  -5.432518873666788e-16,  -5.620897857419308e-18,   1.172923041209390e+00,  -1.312502226794847e-02,   6.287749668939784e-06,
   1.478371036647543e-06,  -1.016686106858475e-08,  -2.632300555045832e-10,   5.213442143276067e-12,   8.485466348011756e-14,  -5.433939875715884e-16,  -5.629897536800238e-18,
   1.527114097269457e+00,  -1.253760010605577e-02,  -1.109833206194494e-04,   1.505970720542868e-06,   3.534791684816833e-08,  -3.917524875931271e-10,  -1.385990937335671e-11,
   2.015154834357826e-13,   9.514947810285079e-15,  -3.120262602781725e-17,   1.527098363887353e+00,  -1.253695912465507e-02,  -1.109533039195253e-04,   1.505418286962455e-06,
   3.531877206470122e-08,  -3.911529967652437e-10,  -1.382272057800771e-11,   2.013459303207135e-13,   9.479959016176636e-15,  -3.156569016657487e-17,   1.527072538054639e+00,
  -1.253590701919782e-02,  -1.109040444941224e-04,   1.504511993279917e-06,   3.527098317671921e-08,  -3.901692080342157e-10,  -1.376176946607059e-11,   2.010662512487336e-13,
   9.422598020069019e-15,  -3.215983744050560e-17,   1.527045139008244e+00,  -1.253479088390830e-02,  -1.108518006707823e-04,   1.503551181864779e-06,   3.522035284381782e-08,
  -3.891258399586580e-10,  -1.369723183702000e-11,   2.007676860980116e-13,   9.361840511717335e-15,  -3.278772020914907e-17,   1.527023578824574e+00,  -1.253391264595340e-02,
  -1.108107020384528e-04,   1.502795623516203e-06,   3.518056245794190e-08,  -3.883050726927845e-10,  -1.364653890740115e-11,   2.005314105681791e-13,   9.314101371432441e-15,
  -3.328002116287268e-17,   1.527011137227211e+00,  -1.253340586432387e-02,  -1.107869902364990e-04,   1.502359818591326e-06,   3.515762105474356e-08,  -3.878315401283791e-10,
  -1.361732248757737e-11,   2.003945299400998e-13,   9.286581151192249e-15,  -3.356339853810169e-17,   1.527006465511643e+00,  -1.253321557538028e-02,  -1.107780875458015e-04,
   1.502196215350606e-06,   3.514901056219317e-08,  -3.876537520151441e-10,  -1.360635888616686e-11,   2.003430314700475e-13,   9.276252885160880e-15,  -3.366966996005571e-17,
   1.527005691119943e+00,  -1.253318403292863e-02,  -1.107766118673635e-04,   1.502169098189895e-06,   3.514758347302300e-08,  -3.876242825727286e-10,  -1.360454190548148e-11,
   2.003344896715650e-13,   9.274541135774317e-15,  -3.368727860736595e-17,   1.873875346786686e+00,  -5.669729509295809e-03,  -1.616832506880979e-04,  -3.073719073616057e-06,
  -2.292008116940750e-08,   8.913442166342205e-10,   4.196985626555189e-11,   8.278795876924150e-13,   9.862535150590024e-16,  -4.897545361811784e-16,   1.873852299747499e+00,
  -5.671037189900126e-03,  -1.617023131636468e-04,  -3.072430119766810e-06,  -2.283047445251289e-08,   8.937773647491270e-10,   4.197158939539407e-11,   8.253239943153689e-13,
   8.802572275983355e-16,  -4.915031523204355e-16,   1.873814462422401e+00,  -5.673183556791395e-03,  -1.617335519990968e-04,  -3.070311607783113e-06,  -2.268336901455845e-08,
   8.977662211864887e-10,   4.197413017704940e-11,   8.211222173837803e-13,   7.063928427775711e-16,  -4.943581392217593e-16,   1.873774311543540e+00,  -5.675460470570129e-03,
  -1.617666236560042e-04,  -3.068060327779304e-06,  -2.252727697981761e-08,   9.019911558172315e-10,   4.197641262864737e-11,   8.166551997418671e-13,   5.221086180492461e-16,
  -4.973662180384193e-16,   1.873742710745178e+00,  -5.677252017034206e-03,  -1.617925968044154e-04,  -3.066286117424267e-06,  -2.240443063014615e-08,   9.053107290751323e-10,
   4.197790971925527e-11,   8.131334263135277e-13,   3.772213325589071e-16,  -4.997181716030236e-16,   1.873724472567455e+00,  -5.678285794429072e-03,  -1.618075646022611e-04,
  -3.065261208210137e-06,  -2.233353322586690e-08,   9.072243241475838e-10,   4.197865384213866e-11,   8.110984621494298e-13,   2.936626628912303e-16,  -5.010693452625085e-16,
   1.873717623810768e+00,  -5.678673958035856e-03,  -1.618131810361168e-04,  -3.064876159905441e-06,  -2.230691048284365e-08,   9.079424829127431e-10,   4.197891061690452e-11,
   8.103338451347564e-13,   2.622966716389988e-16,  -5.015755550121437e-16,   1.873716488523954e+00,  -5.678738300122350e-03,  -1.618141118229102e-04,  -3.064812322895890e-06,
  -2.230249737899987e-08,   9.080615060977248e-10,   4.197895198624622e-11,   8.102070742688538e-13,   2.570978972601539e-16,  -5.016594048229815e-16,   4.529647925603685e-03,
  -6.870097327276128e-05,   7.749925253174208e-07,  -7.925412172712861e-09,   7.316938668653594e-11,  -5.551336675916555e-13,   1.186591033582103e-14,   8.462843908915198e-17,
  -1.673456013090991e-19,  -1.228340099260286e-19,   4.529758338660443e-03,  -6.870435958926552e-05,   7.750551439944707e-07,  -7.926200127631947e-09,   7.319470282235243e-11,
  -5.548908298137675e-13,   1.186486513487347e-14,   8.399835207935196e-17,  -1.856411443477982e-19,  -1.228661980625044e-19,   4.529939606031892e-03,  -6.870991901869148e-05,
   7.751579583096073e-07,  -7.927493437614461e-09,   7.323626154439384e-11,  -5.544935337510464e-13,   1.186309694542536e-14,   8.296386191217346e-17,  -2.156120925440780e-19,
  -1.229165427223218e-19,   4.530131953517015e-03,  -6.871581833301470e-05,   7.752670734763938e-07,  -7.928865406527414e-09,   7.328035605377604e-11,  -5.540738223565553e-13,
   1.186114975007051e-14,   8.186605654872652e-17,  -2.473263153436297e-19,  -1.229665707122328e-19,   4.530283338366715e-03,  -6.872046136330896e-05,   7.753529630582611e-07,
  -7.929944912821843e-09,   7.331505681490214e-11,  -5.537448471310681e-13,   1.185956596400655e-14,   8.100198684094853e-17,  -2.722223201761084e-19,  -1.230034894282134e-19,
   4.530370708076653e-03,  -6.872314104264596e-05,   7.754025377772698e-07,  -7.930567820828378e-09,   7.333508254997461e-11,  -5.535555261989764e-13,   1.185863137957085e-14,
   8.050328010031570e-17,  -2.865649127879712e-19,  -1.230238130985063e-19,   4.530403516754091e-03,  -6.872414730698245e-05,   7.754211547418476e-07,  -7.930801710822665e-09,
   7.334260226900237e-11,  -5.534845358276091e-13,   1.185827655269193e-14,   8.031600425969979e-17,  -2.919458994069397e-19,  -1.230312591516660e-19,   4.530408955287451e-03,
  -6.872431411065444e-05,   7.754242408316441e-07,  -7.930840480479820e-09,   7.334384876245691e-11,  -5.534727735131864e-13,   1.185821753038741e-14,   8.028496026936694e-17,
  -2.928376216987827e-19,  -1.230324836477002e-19,   4.089388471480836e-02,  -6.174698980500025e-04,   6.868921330987650e-06,  -6.839848736357401e-08,   6.018916039176002e-10,
  -4.093325156498945e-12,   9.545195002159523e-14,   9.383342816809695e-16,  -3.339595226647236e-18,  -1.104774537806034e-18,   4.089486324859738e-02,  -6.174991193661672e-04,
   6.869436405727442e-06,  -6.840428963787149e-08,   6.020951519764051e-10,  -4.090611559208268e-12,   9.543514381534634e-14,   9.326673716792911e-16,  -3.508778336859130e-18,
  -1.105059961551025e-18,   4.089646972339293e-02,  -6.175470926724549e-04,   6.870282109849989e-06,  -6.841381225707253e-08,   6.024292812812462e-10,  -4.086168994658157e-12,
   9.540706982657841e-14,   9.233633374358722e-16,  -3.785933341272550e-18,  -1.105505636887834e-18,   4.089817438964909e-02,  -6.175979984860913e-04,   6.871179637950635e-06,
  -6.842391275728213e-08,   6.027837801414026e-10,  -4.081471732663468e-12,   9.537662444798175e-14,   9.134898825531097e-16,  -4.079218367228444e-18,  -1.105947441229217e-18,
   4.089951602333165e-02,  -6.176380633864914e-04,   6.871886120840640e-06,  -6.843185920540315e-08,   6.030627446612101e-10,  -4.077787013027986e-12,   9.535218903159849e-14,
   9.057186215565836e-16,  -4.309456915940571e-18,  -1.106272650699786e-18,   4.090029032736383e-02,  -6.176611863283693e-04,   6.872293895457218e-06,  -6.843644417605008e-08,
   6.032237292332886e-10,  -4.075665319834983e-12,   9.533789681488598e-14,   9.012333661427865e-16,  -4.442100060552448e-18,  -1.106451325268043e-18,   4.090058109019682e-02,
  -6.176698693561048e-04,   6.872447028241229e-06,  -6.843816567421126e-08,   6.032841783912098e-10,  -4.074869515996318e-12,   9.533249405070388e-14,   8.995490512086390e-16,
  -4.491865000496801e-18,  -1.106516717055214e-18,   4.090062928850770e-02,  -6.176713086992618e-04,   6.872472412685894e-06,  -6.843845102642069e-08,   6.032941985906790e-10,
  -4.074737648287381e-12,   9.533159657230117e-14,   8.992698489311670e-16,  -4.500111936152651e-18,  -1.106527466894350e-18,   1.143117994756266e-01,  -1.709740975880303e-03,
   1.845109506015837e-05,  -1.728730759452441e-07,   1.348186396430220e-09,  -6.385453652833501e-12,   2.064735278430031e-13,   3.484373076046628e-15,  -1.722842864384203e-17,
  -3.108378287807077e-18,   1.143144275219705e-01,  -1.709814810990905e-03,   1.845224869240246e-05,  -1.728820773833864e-07,   1.348626185809437e-09,  -6.375295607861898e-12,
   2.063946876780292e-13,   3.468428003742119e-15,  -1.772116160236753e-17,  -3.109210154925951e-18,   1.143187420045621e-01,  -1.709936026035915e-03,   1.845414283759782e-05,
  -1.728968443592309e-07,   1.349348044225902e-09,  -6.358653986115060e-12,   2.062638493991746e-13,   3.442249004078209e-15,  -1.852837530807658e-17,  -3.110509809444067e-18,
   1.143233201660774e-01,  -1.710064648318965e-03,   1.845615304054072e-05,  -1.729124992262135e-07,   1.350113817973320e-09,  -6.341042766593840e-12,   2.061231070669665e-13,
   3.414467685558141e-15,  -1.938259603118980e-17,  -3.111799222374722e-18,   1.143269233205768e-01,  -1.710165877446819e-03,   1.845773534758809e-05,  -1.729248095418460e-07,
   1.350716359152133e-09,  -6.327216550672520e-12,   2.060109592886976e-13,   3.392601302293347e-15,  -2.005320843483219e-17,  -3.112749160569008e-18,   1.143290028185321e-01,
  -1.710224299843947e-03,   1.845864863484873e-05,  -1.729319100033493e-07,   1.351064046320882e-09,  -6.319250763128983e-12,   2.059456830009946e-13,   3.379980881683441e-15,
  -2.043956442650616e-17,  -3.113271415848342e-18,   1.143297836995836e-01,  -1.710246238240602e-03,   1.845899160350485e-05,  -1.729345755300186e-07,   1.351194596609952e-09,
  -6.316262099808737e-12,   2.059210665498808e-13,   3.375241621642003e-15,  -2.058451869897533e-17,  -3.113462620844959e-18,   1.143299131422642e-01,  -1.710249874854713e-03,
   1.845904845653481e-05,  -1.729350173387575e-07,   1.351216236676417e-09,  -6.315766821618435e-12,   2.059169805069717e-13,   3.374456012764626e-15,  -2.060854028276911e-17,
  -3.113494056991027e-18,   2.262200924039790e-01,  -3.330614611984713e-03,   3.409445086223906e-05,  -2.840710977178166e-07,   1.650038782574772e-09,   1.716016234164255e-12,
   2.605826638778310e-13,   8.794208249147397e-15,  -4.504879509627252e-17,  -6.425685044977774e-18,   2.262249471343847e-01,  -3.330735878760407e-03,   3.409586287472562e-05,
  -2.840684387397348e-07,   1.650592610666561e-09,   1.741770382181850e-12,   2.603819719953725e-13,   8.761239546332811e-15,  -4.607326964478390e-17,  -6.427659183040974e-18,
   2.262329171060245e-01,  -3.330934956933680e-03,   3.409818126282259e-05,  -2.840640473262379e-07,   1.651501488254748e-09,   1.783978743446195e-12,   2.600495734318851e-13,
   8.707109808134107e-15,  -4.775160268407623e-17,  -6.430762983481083e-18,   2.262413740603783e-01,  -3.331146193082825e-03,   3.410064171523012e-05,  -2.840593520332396e-07,
   1.652465439083013e-09,   1.828668247992068e-12,   2.596928958160740e-13,   8.649665719586719e-15,  -4.952767145689663e-17,  -6.433870199682858e-18,   2.262480298716093e-01,
  -3.331312436185305e-03,   3.410257843967057e-05,  -2.840556310229102e-07,   1.653223753999164e-09,   1.863769010882447e-12,   2.594093135330836e-13,   8.604451163186459e-15,
  -5.092198773463858e-17,  -6.436180915540712e-18,   2.262518711280355e-01,  -3.331408377985942e-03,   3.410369629565928e-05,  -2.840534732275420e-07,   1.653661263676639e-09,
   1.883998241481260e-12,   2.592445015988622e-13,   8.578354722757497e-15,  -5.172528703260429e-17,  -6.437460522564232e-18,   2.262533135689110e-01,  -3.331444405020854e-03,
   3.410411608710647e-05,  -2.840526610031475e-07,   1.653825528511695e-09,   1.891589206198147e-12,   2.591823956889896e-13,   8.568554835840092e-15,  -5.202667142898953e-17,
  -6.437930834249441e-18,   2.262535526747075e-01,  -3.331450377014128e-03,   3.410418567488792e-05,  -2.840525262624462e-07,   1.653852756470329e-09,   1.892847236990914e-12,
   2.591720892813644e-13,   8.566930342676516e-15,  -5.207661635605177e-17,  -6.438008257491394e-18,   3.789214189993572e-01,  -5.443680447111057e-03,   5.099922611058063e-05,
  -3.339791088830035e-07,   4.492292158793103e-10,   3.113764022049850e-11,   2.417962647724423e-13,   1.645745175909765e-14,  -5.938983145454523e-17,  -1.195704447440877e-17,
   3.789286773411448e-01,  -5.443822872091401e-03,   5.099961258614490e-05,  -3.339343916637742e-07,   4.497420432009040e-10,   3.118584176546745e-11,   2.415218757835282e-13,
   1.639608884240994e-14,  -6.121467338627884e-17,  -1.196123518120142e-17,   3.789405931244699e-01,  -5.444056671860789e-03,   5.100024736375516e-05,  -3.338609319388604e-07,
   4.505834888994250e-10,   3.126483979646219e-11,   2.410662024665116e-13,   1.629533802857728e-14,  -6.420414601524458e-17,  -1.196786778721809e-17,   3.789532367467528e-01,
  -5.444304732606503e-03,   5.100092134039324e-05,  -3.337829187380747e-07,   4.514757208773430e-10,   3.134848257523064e-11,   2.405756142540966e-13,   1.618841557119031e-14,
  -6.736763519025234e-17,  -1.197456985799765e-17,   3.789631873839423e-01,  -5.444499944041360e-03,   5.100145207369466e-05,  -3.337214736652646e-07,   4.521774692388103e-10,
   3.141417937303011e-11,   2.401843978751739e-13,   1.610425435528164e-14,  -6.985110406438210e-17,  -1.197960158437559e-17,   3.789689301072888e-01,  -5.444612598893737e-03,
   5.100175849454168e-05,  -3.336859931810085e-07,   4.525822832718449e-10,   3.145204196165509e-11,   2.399565691366633e-13,   1.605567831860887e-14,  -7.128186940730698e-17,
  -1.198240820737125e-17,   3.789710865600440e-01,  -5.444654900874264e-03,   5.100187358210217e-05,  -3.336726662548564e-07,   4.527342610614094e-10,   3.146624985109030e-11,
   2.398706299944097e-13,   1.603743661300741e-14,  -7.181866452025459e-17,  -1.198344374122376e-17,   3.789714440231152e-01,  -5.444661912978338e-03,   5.100189266075149e-05,
  -3.336704569335113e-07,   4.527594517634577e-10,   3.146860449042819e-11,   2.398563639332224e-13,   1.603441274099639e-14,  -7.190762111326300e-17,  -1.198361442627011e-17,
   5.757563774731810e-01,  -7.961830948626672e-03,   6.376918440004031e-05,  -2.067983908591717e-07,  -3.576250722783795e-09,   8.324212343836918e-11,   4.841812691366591e-13,
   2.126413474967624e-14,   1.541695225049517e-17,  -2.095399545107787e-17,   5.757654461678692e-01,  -7.961918814969242e-03,   6.376613669444660e-05,  -2.066794107541569e-07,
  -3.575217315804352e-09,   8.330395197098265e-11,   4.841780127346896e-13,   2.115662367118095e-14,   1.228976923005866e-17,  -2.096044175270498e-17,   5.757803335858043e-01,
  -7.962063024960185e-03,   6.376113402998583e-05,  -2.064840227706879e-07,  -3.573520850298518e-09,   8.340522119477621e-11,   4.841637207481770e-13,   2.098010611529211e-14,
   7.166479756940643e-18,  -2.097060660311783e-17,   5.757961298628079e-01,  -7.962215992840214e-03,   6.375582668273567e-05,  -2.062766156829528e-07,  -3.571720830223526e-09,
   8.351235990459666e-11,   4.841364139877882e-13,   2.079278003211785e-14,   1.744542794343940e-18,  -2.098082480197984e-17,   5.758085613088397e-01,  -7.962336343108268e-03,
   6.375165039982320e-05,  -2.061133235321043e-07,  -3.570304255004384e-09,   8.359644999336115e-11,   4.841061454478346e-13,   2.064533431028863e-14,  -2.512206582621051e-18,
  -2.098845595827234e-17,   5.758157356163942e-01,  -7.962405785064901e-03,   6.374924043671931e-05,  -2.060190597470769e-07,  -3.569486743748206e-09,   8.364488837255068e-11,
   4.840851625376729e-13,   2.056023305987811e-14,  -4.964709677500744e-18,  -2.099269553764300e-17,   5.758184296169669e-01,  -7.962431858462279e-03,   6.374833551913121e-05,
  -2.059836580954960e-07,  -3.569179764532501e-09,   8.366306014112563e-11,   4.840766195112035e-13,   2.052827531373913e-14,  -5.884864066821525e-18,  -2.099425645810617e-17,
   5.758188761848964e-01,  -7.962436180356133e-03,   6.374818551859516e-05,  -2.059777895191219e-07,  -3.569128878570715e-09,   8.366607145791415e-11,   4.840751683798071e-13,
   2.052297778769608e-14,  -6.037351408579986e-18,  -2.099451356346353e-17,   8.212398019398853e-01,  -1.067130409396464e-02,   6.169622286588995e-05,   2.773147735693658e-07,
  -1.080080820787136e-08,   1.077295010677208e-10,   2.296862764211435e-12,   1.489424014653329e-14,   8.920452111952772e-17,  -3.097135289262294e-17,   8.212485632764807e-01,
  -1.067118515924434e-02,   6.168702845477647e-05,   2.774684326014240e-07,  -1.079590266310156e-08,   1.077714719556173e-10,   2.297099196503129e-12,   1.473533056582979e-14,
   8.345236140280139e-17,  -3.098098799655430e-17,   8.212629454876373e-01,  -1.067098986115022e-02,   6.167193736861894e-05,   2.777207308903284e-07,  -1.078784911558516e-08,
   1.078400305736844e-10,   2.297470875033033e-12,   1.447442421545467e-14,   7.402717864030465e-17,  -3.099612615735301e-17,   8.212782048468412e-01,  -1.067078257021068e-02,
   6.165592867478999e-05,   2.779884959255348e-07,  -1.077930328282143e-08,   1.079123098410346e-10,   2.297842907991018e-12,   1.419754226425544e-14,   6.405071057158203e-17,
  -3.101126596485747e-17,   8.212902131172659e-01,  -1.067061938439770e-02,   6.164333272800591e-05,   2.781992695697226e-07,  -1.077257739140348e-08,   1.079688560570376e-10,
   2.298119542582950e-12,   1.397960672833373e-14,   5.621685000495229e-17,  -3.102251318150552e-17,   8.212971429540206e-01,  -1.067052518793077e-02,   6.163606455511256e-05,
   2.783209276079519e-07,  -1.076869564084080e-08,   1.080013545099246e-10,   2.298272724521041e-12,   1.385382100751651e-14,   5.170286666256247e-17,  -3.102873656303852e-17,
   8.212997451065289e-01,  -1.067048981267787e-02,   6.163333550965487e-05,   2.783666145136762e-07,  -1.076723798508694e-08,   1.080135323951772e-10,   2.298329023973585e-12,
   1.380658520805704e-14,   5.000916207824807e-17,  -3.103102293817869e-17,   8.213001764468556e-01,  -1.067048394853645e-02,   6.163288314321605e-05,   2.783741879357832e-07,
  -1.076699635674609e-08,   1.080155497030645e-10,   2.298338291975005e-12,   1.379875509314682e-14,   4.972847706622312e-17,  -3.103139927031970e-17,   1.120609174914695e+00,
  -1.301064442783328e-02,   2.298490257066360e-05,   1.282248901580541e-06,  -1.410646528599592e-08,  -1.131358168116732e-10,   7.314837705254881e-12,   6.026376679438121e-14,
  -1.253534391621998e-15,  -4.241543789141066e-17,   1.120612421792354e+00,  -1.301009757076741e-02,   2.297294593608811e-05,   1.282089388710369e-06,  -1.409091263226959e-08,
  -1.129592303094025e-10,   7.309667008421192e-12,   6.004443517405271e-14,  -1.262039633052342e-15,  -4.249246433087118e-17,   1.120617750851971e+00,  -1.300919986523676e-02,
   2.295332676325462e-05,   1.281827702678529e-06,  -1.406538850429907e-08,  -1.126698100340877e-10,   7.301154163660334e-12,   5.968409150043328e-14,  -1.275969917171238e-15,
  -4.261760350609388e-17,   1.120623403744633e+00,  -1.300824739663994e-02,   2.293252231889615e-05,   1.281550278156931e-06,  -1.403831642026005e-08,  -1.123633587017578e-10,
   7.292088390679411e-12,   5.930136749090096e-14,  -1.290706890057531e-15,  -4.274860308096923e-17,   1.120627851405583e+00,  -1.300749784686621e-02,   2.291615853242731e-05,
   1.281332120474421e-06,  -1.401701851985494e-08,  -1.121226478272555e-10,   7.284929736770620e-12,   5.899989478519724e-14,  -1.302272980217909e-15,  -4.285041015918543e-17,
   1.120630417758700e+00,  -1.300706528627452e-02,   2.290671844678575e-05,   1.281206288240145e-06,  -1.400473028591545e-08,  -1.119839165277592e-10,   7.280788793490159e-12,
   5.882580269400579e-14,  -1.308935166079170e-15,  -4.290864797333352e-17,   1.120631381359298e+00,  -1.300690285910658e-02,   2.290317431428251e-05,   1.281159050364288e-06,
  -1.400011653750130e-08,  -1.119318570233837e-10,   7.279232025756048e-12,   5.876040937323824e-14,  -1.311434456773832e-15,  -4.293041914527439e-17,   1.120631541085115e+00,
  -1.300687593467032e-02,   2.290258686122980e-05,   1.281151220715832e-06,  -1.399935177462615e-08,  -1.119232292872310e-10,   7.278973874177278e-12,   5.874956844071237e-14,
  -1.311848621951914e-15,  -4.293402287469081e-17,   1.475315072600324e+00,  -1.334426638361007e-02,  -8.982870148119119e-05,   1.993292149277641e-06,   2.481111413743542e-08,
  -6.249167869485638e-10,  -4.444737438261538e-12,   4.427798269731421e-13,   4.157429925392043e-15,  -2.649609433780992e-16,   1.475302331811513e+00,  -1.334341850415322e-02,
  -8.980756925838063e-05,   1.992413818192506e-06,   2.480181400651810e-08,  -6.236150052634695e-10,  -4.428857673006016e-12,   4.414360992190753e-13,   4.124268347699162e-15,
  -2.644514434198966e-16,   1.475281417909281e+00,  -1.334202684122863e-02,  -8.977288297391056e-05,   1.990973225585637e-06,   2.478657047235771e-08,  -6.214808134302386e-10,
  -4.402883332658966e-12,   4.392320404972397e-13,   4.069939839449246e-15,  -2.636148463665271e-16,   1.475259229584078e+00,  -1.334055054389182e-02,  -8.973608585578843e-05,
   1.989446451466745e-06,   2.477042862724832e-08,  -6.192202011983733e-10,  -4.375451302470098e-12,   4.368959299791702e-13,   4.012444718499079e-15,  -2.627269139069629e-16,
   1.475241769384986e+00,  -1.333938895392410e-02,  -8.970713190678924e-05,   1.988246178511963e-06,   2.475774853983234e-08,  -6.174439313470821e-10,  -4.353955232514523e-12,
   4.350592569818047e-13,   3.967305511305864e-15,  -2.620279285940635e-16,   1.475231693616168e+00,  -1.333871868332372e-02,  -8.969042424984290e-05,   1.987554000728509e-06,
   2.475044006469783e-08,  -6.164199506619734e-10,  -4.341586696524873e-12,   4.340000220635128e-13,   3.941298778990843e-15,  -2.616244575128388e-16,   1.475227910226096e+00,
  -1.333846701001675e-02,  -8.968415078037230e-05,   1.987294179929905e-06,   2.474769744354566e-08,  -6.160356510183069e-10,  -4.336949226573852e-12,   4.336024096408051e-13,
   3.931541305361637e-15,  -2.614729361104622e-16,   1.475227283083546e+00,  -1.333842529261698e-02,  -8.968311088525908e-05,   1.987251116126658e-06,   2.474724290888319e-08,
  -6.159719592072081e-10,  -4.336180870719528e-12,   4.335365071197018e-13,   3.929924302962722e-15,  -2.614478185256921e-16,   1.848369373935084e+00,  -7.115219365436375e-03,
  -1.999815039041075e-04,  -3.235408567052267e-06,   6.788258384340285e-09,   2.159015630137838e-09,   6.192426365011510e-11,   4.325240542608080e-13,  -3.040699517894981e-14,
  -1.267477782388265e-15,   1.848340928254717e+00,  -7.116589740940002e-03,  -1.999749679190401e-04,  -3.232326173029650e-06,   6.918973924808217e-09,   2.160205897960858e-09,
   6.180089381870112e-11,   4.261114297995749e-13,  -3.051448807335492e-14,  -1.264498888241891e-15,   1.848294230855910e+00,  -7.118838480757260e-03,  -1.999641578398695e-04,
  -3.227264742478929e-06,   7.133373139165212e-09,   2.162146117192761e-09,   6.159805871220126e-11,   4.155953251512994e-13,  -3.068990561654635e-14,  -1.259578553259405e-15,
   1.848244682383442e+00,  -7.121223271632949e-03,  -1.999525785742862e-04,  -3.221892574908168e-06,   7.360606757968223e-09,   2.164186100554969e-09,   6.138242407769867e-11,
   4.044522838110467e-13,  -3.087461150326247e-14,  -1.254317086575108e-15,   1.848205688258325e+00,  -7.123099176190723e-03,  -1.999433868098969e-04,  -3.217663499481044e-06,
   7.539251989377901e-09,   2.165778021116240e-09,   6.121242227840860e-11,   3.956938189034499e-13,  -3.101894424505820e-14,  -1.250147006142134e-15,   1.848183184301253e+00,
  -7.124181421190347e-03,  -1.999380504842284e-04,  -3.215222357853267e-06,   7.642275891917675e-09,   2.166691318767347e-09,   6.111419260880259e-11,   3.906436294042976e-13,
  -3.110182806950662e-14,  -1.247728676061035e-15,   1.848174733901276e+00,  -7.124587743837400e-03,  -1.999360406741814e-04,  -3.214305598285473e-06,   7.680948065779175e-09,
   2.167033245051301e-09,   6.107728408080122e-11,   3.887480838807748e-13,  -3.113287364748235e-14,  -1.246818363469675e-15,   1.848173333129675e+00,  -7.124655093880543e-03,
  -1.999357072046774e-04,  -3.214153627701464e-06,   7.687357776192319e-09,   2.167089870107794e-09,   6.107116478826134e-11,   3.884339150089859e-13,  -3.113801577557798e-14,
  -1.246667349892113e-15,   4.266668697366448e-03,  -6.286229030691992e-05,   6.865976188029132e-07,  -6.827315639605063e-09,   6.508309540655725e-11,  -2.474018362948350e-13,
   1.333891966812655e-14,  -1.306622046143480e-17,  -6.517880044732155e-18,  -2.169551687525569e-19,   4.266766517326375e-03,  -6.286520628412136e-05,   6.866533490338467e-07,
  -6.827668202116570e-09,   6.511125912834809e-11,  -2.474581883958790e-13,   1.331286051600695e-14,  -1.415228957778178e-17,  -6.522268983401602e-18,  -2.160104849310514e-19,
   4.266927110384600e-03,  -6.286999344168518e-05,   6.867448565127141e-07,  -6.828247055698368e-09,   6.515745418649424e-11,  -2.475530288282261e-13,   1.327006846347056e-14,
  -1.593173738121272e-17,  -6.529316492590464e-18,  -2.144579787013855e-19,   4.267097519865029e-03,  -6.287507313411137e-05,   6.868419764992980e-07,  -6.828861353955069e-09,
   6.520641600216732e-11,  -2.476568234583289e-13,   1.322464708508227e-14,  -1.781509480510219e-17,  -6.536580519018722e-18,  -2.128084235320459e-19,   4.267231638694371e-03,
  -6.287907098610457e-05,   6.869184274279907e-07,  -6.829344876004214e-09,   6.524490958859740e-11,  -2.477407961888829e-13,   1.318888904669323e-14,  -1.929384777587012e-17,
  -6.542142714683999e-18,  -2.115086212693167e-19,   4.267309043567605e-03,  -6.288137826770539e-05,   6.869625555603804e-07,  -6.829623952864503e-09,   6.526710910609988e-11,
  -2.477901736813775e-13,   1.316824796808820e-14,  -2.014587757268834e-17,  -6.545290867362160e-18,  -2.107578470821973e-19,   4.267338110297092e-03,  -6.288224468302536e-05,
   6.869791273989782e-07,  -6.829728754112080e-09,   6.527544224315992e-11,  -2.478088882723742e-13,   1.316049621087632e-14,  -2.046556089108459e-17,  -6.546461340499947e-18,
  -2.104758049943395e-19,   4.267342928546238e-03,  -6.288238830419552e-05,   6.869818744862676e-07,  -6.829746126689598e-09,   6.527682342150356e-11,  -2.478119995992652e-13,
   1.315921120272241e-14,  -2.051853913483041e-17,  -6.546654746749862e-18,  -2.104290462251348e-19,   3.852893357173793e-02,  -5.656433118569679e-04,   6.103645381931054e-06,
  -5.929051201225611e-08,   5.448164793728029e-10,  -1.543363448523269e-12,   1.128003400563499e-13,  -4.453253140870493e-18,  -6.094546387567344e-17,  -1.976095993167371e-18,
   3.852980310352763e-02,  -5.656686320487328e-04,   6.104111916640218e-06,  -5.929270991803219e-08,   5.450543683837297e-10,  -1.543534342795825e-12,   1.125566623394867e-13,
  -1.434400981831170e-17,  -6.098703010566903e-17,  -1.967435767721859e-18,   3.853123062893217e-02,  -5.657101999213084e-04,   6.104877954783644e-06,  -5.929631837734655e-08,
   5.454445253193445e-10,  -1.543836105501985e-12,   1.121565145011785e-13,  -3.054910539942577e-17,  -6.105382235570865e-17,  -1.953203296600111e-18,   3.853274540930191e-02,
  -5.657543075711682e-04,   6.105690978644946e-06,  -5.930014757139737e-08,   5.458580003673975e-10,  -1.544185089892559e-12,   1.117317775514218e-13,  -4.770019567036614e-17,
  -6.112273258916830e-17,  -1.938080948799030e-18,   3.853393759690602e-02,  -5.657890211927407e-04,   6.106330976088693e-06,  -5.930316142262362e-08,   5.461830369102853e-10,
  -1.544480557772778e-12,   1.113974011247842e-13,  -6.116648058917183e-17,  -6.117554746246725e-17,  -1.926164835141498e-18,   3.853462565072487e-02,  -5.658090553708889e-04,
   6.106700388574303e-06,  -5.930490088054333e-08,   5.463704733206817e-10,  -1.544659411990100e-12,   1.112043839612685e-13,  -6.892541699351636e-17,  -6.120546038978764e-17,
  -1.919281956275196e-18,   3.853488402537482e-02,  -5.658165784547219e-04,   6.106839117490045e-06,  -5.930555408458441e-08,   5.464408294794107e-10,  -1.544728147548477e-12,
   1.111318962304877e-13,  -7.183656965178170e-17,  -6.121658580716208e-17,  -1.916696266327591e-18,   3.853492685486123e-02,  -5.658178255162268e-04,   6.106862114366065e-06,
  -5.930566236358361e-08,   5.464524905385184e-10,  -1.544739624459052e-12,   1.111198799382463e-13,  -7.231900797167934e-17,  -6.121842435213959e-17,  -1.916267593310051e-18,
   1.077554220391689e-01,  -1.570071218110757e-03,   1.650278640727945e-05,  -1.520240101087123e-07,   1.277094525110804e-09,  -4.464138656833165e-13,   2.752718428365133e-13,
   5.611345824162071e-16,  -1.811250351373784e-16,  -5.653428719994077e-18,   1.077577727064004e-01,  -1.570136122718870e-03,   1.650388012302406e-05,  -1.520246354458125e-07,
   1.277673516691551e-09,  -4.451876930809032e-13,   2.745476090769378e-13,   5.328428323800352e-16,  -1.812505296038678e-16,  -5.628475161425442e-18,   1.077616318202342e-01,
  -1.570242674331459e-03,   1.650567598906431e-05,  -1.520256609636982e-07,   1.278622906419086e-09,  -4.432354045834671e-13,   2.733583246464906e-13,   4.864900822443762e-16,
  -1.814523739398074e-16,  -5.587464887117154e-18,   1.077657267920780e-01,  -1.570355734091796e-03,   1.650758202334386e-05,  -1.520267476915882e-07,   1.279628761678093e-09,
  -4.412462242507479e-13,   2.720959498235409e-13,   4.374323571522365e-16,  -1.816608805069740e-16,  -5.543889307906515e-18,   1.077689496678146e-01,  -1.570444712908608e-03,
   1.650908243074248e-05,  -1.520276019465002e-07,   1.280419273872235e-09,  -4.397402650308228e-13,   2.711021320112050e-13,   3.989150572196258e-16,  -1.818208807132802e-16,
  -5.509551765970434e-18,   1.077708096970749e-01,  -1.570496064400394e-03,   1.650994848475203e-05,  -1.520280945593823e-07,   1.280875052441142e-09,  -4.388949830556377e-13,
   2.705284528633581e-13,   3.767226255369158e-16,  -1.819115804663652e-16,  -5.489717686558766e-18,   1.077715081649983e-01,  -1.570515347410684e-03,   1.651027372301127e-05,
  -1.520282794669300e-07,   1.281046118374218e-09,  -4.385820732291086e-13,   2.703130067502274e-13,   3.683960776769954e-16,  -1.819453295072379e-16,  -5.482266557867123e-18,
   1.077716239464996e-01,  -1.570518543846417e-03,   1.651032763729881e-05,  -1.520283101141514e-07,   1.281074470598574e-09,  -4.385304413621323e-13,   2.702772922178248e-13,
   3.670161988869435e-16,  -1.819509075665208e-16,  -5.481031256446907e-18,   2.134221960811030e-01,  -3.071040398350518e-03,   3.084644951990297e-05,  -2.569785025809638e-07,
   1.764932355153101e-09,   1.050369508435246e-11,   4.430661770354311e-13,   2.439690764584133e-15,  -3.848137785405666e-16,  -1.174480385527501e-17,   2.134265887986108e-01,
  -3.071150055132420e-03,   3.084796174275225e-05,  -2.569635022524489e-07,   1.765859842786446e-09,   1.051004950333122e-11,   4.415274294572931e-13,   2.380912135792337e-15,
  -3.850830688133751e-16,  -1.169309633013295e-17,   2.134338003119235e-01,  -3.071330069851827e-03,   3.085044486794862e-05,  -2.569388706372967e-07,   1.767380087032933e-09,
   1.052035525636441e-11,   4.390006006526161e-13,   2.284609690109056e-15,  -3.855164368380568e-16,  -1.160811386862512e-17,   2.134414524978109e-01,  -3.071521073082545e-03,
   3.085308042502886e-05,  -2.569127263045189e-07,   1.768989952808549e-09,   1.053111936684325e-11,   4.363184675320279e-13,   2.182686739747320e-15,  -3.859644460536693e-16,
  -1.151781144516443e-17,   2.134474749624922e-01,  -3.071671389067214e-03,   3.085515517868744e-05,  -2.568921446338454e-07,   1.770254585942641e-09,   1.053946708384319e-11,
   4.342069213480116e-13,   2.102662242382715e-15,  -3.863084817485184e-16,  -1.144665022303472e-17,   2.134509507064365e-01,  -3.071758137532583e-03,   3.085635278241403e-05,
  -2.568802641850686e-07,   1.770983492441288e-09,   1.054423519074465e-11,   4.329880323776511e-13,   2.056554509597155e-15,  -3.865036087704255e-16,  -1.140554484258441e-17,
   2.134522558945341e-01,  -3.071790712098274e-03,   3.085680253661269e-05,  -2.568758025137323e-07,   1.771257026768076e-09,   1.054601630881679e-11,   4.325302760098363e-13,
   2.039254962216887e-15,  -3.865762345199777e-16,  -1.139010243783396e-17,   2.134524722487599e-01,  -3.071796111780566e-03,   3.085687709202866e-05,  -2.568750629044388e-07,
   1.771302359643643e-09,   1.054631106136546e-11,   4.324543936362906e-13,   2.036388072562443e-15,  -3.865882391908653e-16,  -1.138754227379887e-17,   3.579375408069995e-01,
  -5.051545325365105e-03,   4.705658108296875e-05,  -3.213471854503729e-07,   1.164250054908390e-09,   4.177847868660884e-11,   5.955763490554043e-13,   5.504519214626989e-15,
  -6.837646339413688e-16,  -2.148520120420146e-17,   3.579442393174752e-01,  -5.051682305058778e-03,   4.705758217367158e-05,  -3.212876087495466e-07,   1.165488883940651e-09,
   4.179321458810697e-11,   5.928420007543545e-13,   5.396940211365399e-15,  -6.842526470210241e-16,  -2.139259279387110e-17,   3.579552361109359e-01,  -5.051907160990115e-03,
   4.705922638032064e-05,  -3.211897895044025e-07,   1.167518398591504e-09,   4.181717521081887e-11,   5.883518104640000e-13,   5.220676136108970e-15,  -6.850380122280490e-16,
  -2.124038048289019e-17,   3.579669047007263e-01,  -5.052145725497017e-03,   4.706097203430868e-05,  -3.210859762169097e-07,   1.169666129071685e-09,   4.184228609100392e-11,
   5.835856091494671e-13,   5.034114577648874e-15,  -6.858499198804997e-16,  -2.107862827026308e-17,   3.579760880450693e-01,  -5.052333458904518e-03,   4.706234661320256e-05,
  -3.210042605911491e-07,   1.171352246473974e-09,   4.186182204709114e-11,   5.798333271661623e-13,   4.887628954590799e-15,  -6.864734069519061e-16,  -2.095115415145644e-17,
   3.579813879739088e-01,  -5.052441796263847e-03,   4.706314020583284e-05,  -3.209570953178957e-07,   1.172323670888451e-09,   4.187300596740201e-11,   5.776673146066075e-13,
   4.803225338089839e-15,  -6.868270329410262e-16,  -2.087751707667758e-17,   3.579833781576870e-01,  -5.052482476647070e-03,   4.706343826371128e-05,  -3.209393832366157e-07,
   1.172688135320779e-09,   4.187718851723724e-11,   5.768538621290698e-13,   4.771556676115178e-15,  -6.869586519908688e-16,  -2.084985260078019e-17,   3.579837080595467e-01,
  -5.052489219930473e-03,   4.706348767402173e-05,  -3.209364471502071e-07,   1.172748533893855e-09,   4.187788093170948e-11,   5.767190158380380e-13,   4.766308500011025e-15,
  -6.869804079787547e-16,  -2.084526613265982e-17,   5.449124438447709e-01,  -7.462444932436084e-03,   6.100180195933882e-05,  -2.498751249133884e-07,  -1.750145162857815e-09,
   1.012299345457478e-10,   9.461939671705359e-13,   5.981959756562005e-15,  -1.070990799511176e-15,  -3.729790416415032e-17,   5.449211218668212e-01,  -7.462551100234565e-03,
   6.100031873775710e-05,  -2.497309441959924e-07,  -1.748176331249504e-09,   1.012448335649484e-10,   9.419090563902455e-13,   5.795085470731673e-15,  -1.071856389004561e-15,
  -3.714158507892727e-17,   5.449353680941236e-01,  -7.462725347345853e-03,   6.099788498825093e-05,  -2.494942341176980e-07,  -1.744950795418111e-09,   1.012688918128276e-10,
   9.348723423434381e-13,   5.488882335777399e-15,  -1.073250629326177e-15,  -3.688463892958730e-17,   5.449504842381399e-01,  -7.462910176500857e-03,   6.099530421889530e-05,
  -2.492430474955483e-07,  -1.741537251482746e-09,   1.012938753019082e-10,   9.274027074114091e-13,   5.164767750740018e-15,  -1.074693700360223e-15,  -3.661156399769401e-17,
   5.449623805751219e-01,  -7.463055594213891e-03,   6.099327431605655e-05,  -2.490453487713305e-07,  -1.738857291372302e-09,   1.013131439866584e-10,   9.215218269288904e-13,
   4.910260790329138e-15,  -1.075803143498153e-15,  -3.639634052973718e-17,   5.449692461245967e-01,  -7.463139500060633e-03,   6.099210329033541e-05,  -2.489312476051568e-07,
  -1.737313246764702e-09,   1.013241067849041e-10,   9.181269693666875e-13,   4.763609665481235e-15,  -1.076432911006033e-15,  -3.627200676873939e-17,   5.449718241955033e-01,
  -7.463171004221537e-03,   6.099166364746854e-05,  -2.488884004752177e-07,  -1.736733936559576e-09,   1.013281936698968e-10,   9.168520003421297e-13,   4.708584167343634e-15,
  -1.076667409299836e-15,  -3.622529487008866e-17,   5.449722515470675e-01,  -7.463176226312062e-03,   6.099159077506050e-05,  -2.488812978971481e-07,  -1.736637933657708e-09,
   1.013288695604059e-10,   9.166406472377317e-13,   4.699465196455094e-15,  -1.076706176033721e-15,  -3.621755047614194e-17,   7.795588947684664e-01,  -1.016717713979688e-02,
   6.406829359373827e-05,   1.248656049002990e-07,  -8.064809200082171e-09,   1.669013493111132e-10,   2.536878915529507e-12,  -6.902343030618130e-15,  -1.637682900822788e-15,
  -6.137013475471230e-17,   7.795679983708750e-01,  -1.016712299363157e-02,   6.406143770472774e-05,   1.251028978312422e-07,  -8.059471978194569e-09,   1.668758256999636e-10,
   2.530314944407062e-12,  -7.209638041875771e-15,  -1.639578607172012e-15,  -6.110593097836473e-17,   7.795829427076673e-01,  -1.016703403076737e-02,   6.405018592199851e-05,
   1.254924243084374e-07,  -8.050720211653596e-09,   1.668332654422241e-10,   2.519533922123813e-12,  -7.713129967740762e-15,  -1.642645651828380e-15,  -6.067162981329191e-17,
   7.795987988530464e-01,  -1.016693953485213e-02,   6.403825134977392e-05,   1.259057032132864e-07,  -8.041447705760302e-09,   1.667872110872957e-10,   2.508087426110791e-12,
  -8.246037294947235e-15,  -1.645838856205240e-15,  -6.021003735338212e-17,   7.796112770344036e-01,  -1.016686509407657e-02,   6.402886198987723e-05,   1.262309275059255e-07,
  -8.034160186030105e-09,   1.667503192470139e-10,   2.499073962473666e-12,  -8.664469604222968e-15,  -1.648307700394215e-15,  -5.984621260779924e-17,   7.796184781609808e-01,
  -1.016682210399205e-02,   6.402344449297749e-05,   1.264186093344078e-07,  -8.029958421913768e-09,   1.667287692688739e-10,   2.493870125971505e-12,  -8.905566538202563e-15,
  -1.649714811849115e-15,  -5.963602381832617e-17,   7.796211822034780e-01,  -1.016680595533366e-02,   6.402141041203868e-05,   1.264890835479217e-07,  -8.028381375014583e-09,
   1.667206281246638e-10,   2.491915659595211e-12,  -8.996027363241617e-15,  -1.650239851873268e-15,  -5.955705475439513e-17,   7.796216304344764e-01,  -1.016680327817465e-02,
   6.402107324682540e-05,   1.265007655423154e-07,  -8.028119996872069e-09,   1.667192760339728e-10,   2.491591659139322e-12,  -9.011018663067202e-15,  -1.650326708404696e-15,
  -5.954396233923148e-17,   1.069026244010234e+00,  -1.276916177103639e-02,   3.697522113431957e-05,   1.048452572078752e-06,  -1.450776317245197e-08,   7.633903733340601e-11,
   8.134286124293929e-12,  -1.496744913622552e-14,  -3.753837855957062e-15,  -9.208996610215275e-17,   1.069031481142576e+00,  -1.276871378139574e-02,   3.696293104348282e-05,
   1.048560761905627e-06,  -1.449057828153805e-08,   7.628697499424526e-11,   8.119256148769437e-12,  -1.542776768491195e-14,  -3.757406212807904e-15,  -9.166400566309896e-17,
   1.069040077494596e+00,  -1.276797830059902e-02,   3.694276541841274e-05,   1.048738316429674e-06,  -1.446238972777406e-08,   7.620051943439677e-11,   8.094572210413014e-12,
  -1.618186968961317e-14,  -3.763181206039130e-15,  -9.096364097089693e-17,   1.069049197192556e+00,  -1.276719785338144e-02,   3.692138245944447e-05,   1.048926638044059e-06,
  -1.443251106747591e-08,   7.610744413677720e-11,   8.068367454364706e-12,  -1.697987336706076e-14,  -3.769196192528413e-15,  -9.021904098001585e-17,   1.069056373215340e+00,
  -1.276658360456644e-02,   3.690456432589677e-05,   1.049074791627979e-06,  -1.440901927141467e-08,   7.603322520376378e-11,   8.047734726658365e-12,  -1.760634316713328e-14,
  -3.773848505855727e-15,  -8.963198936492065e-17,   1.069060514146547e+00,  -1.276622909643735e-02,   3.689486240593928e-05,   1.049160271161039e-06,  -1.439547086464852e-08,
   7.599000439779434e-11,   8.035823422994492e-12,  -1.796726394550666e-14,  -3.776500807335631e-15,  -8.929277339843495e-17,   1.069062069014442e+00,  -1.276609597262892e-02,
   3.689122002338616e-05,   1.049192365249791e-06,  -1.439038503629436e-08,   7.597370135145133e-11,   8.031349904678819e-12,  -1.810267467534218e-14,  -3.777490607860181e-15,
  -8.916531595707591e-17,   1.069062326751149e+00,  -1.276607390532130e-02,   3.689061628774101e-05,   1.049197685075764e-06,  -1.438954207888246e-08,   7.597099502774674e-11,
   8.030608317872996e-12,  -1.812511468318057e-14,  -3.777654356332222e-15,  -8.914418393038926e-17,   1.420660492065091e+00,  -1.396143528510226e-02,  -6.394665240829475e-05,
   2.288847238763604e-06,   1.228580433026266e-08,  -5.778787717369075e-10,   8.133422306128437e-12,   3.901003777553848e-13,  -8.172588555316100e-15,  -3.831991077510951e-16,
   1.420651413276750e+00,  -1.396046099546487e-02,  -6.393606625898130e-05,   2.288034431090967e-06,   1.230278003300124e-08,  -5.767436151506754e-10,   8.100920838826644e-12,
   3.881778490372330e-13,  -8.169666714635656e-15,  -3.816864773495706e-16,   1.420636510080064e+00,  -1.395886178988221e-02,  -6.391867702733675e-05,   2.286701230587666e-06,
   1.233059828703418e-08,  -5.748841980521418e-10,   8.047573544472825e-12,   3.850273114775357e-13,  -8.164746205941671e-15,  -3.792027803874577e-16,   1.420620698137057e+00,
  -1.395716524674447e-02,  -6.390021165310507e-05,   2.285288169016188e-06,   1.236004750986980e-08,  -5.729168139442738e-10,   7.990980538201056e-12,   3.816919654579892e-13,
  -8.159356954338475e-15,  -3.765667671582417e-16,   1.420608255141664e+00,  -1.395583030264921e-02,  -6.388566914328511e-05,   2.284177215015845e-06,   1.238317490699213e-08,
  -5.713725224783713e-10,   7.946450818392820e-12,   3.790725468077954e-13,  -8.154993867082624e-15,  -3.744917778926937e-16,   1.420601074481511e+00,  -1.395505997817343e-02,
  -6.387727230693338e-05,   2.283536515256146e-06,   1.239650242197760e-08,  -5.704829034651002e-10,   7.920755614155482e-12,   3.775630404645939e-13,  -8.152427077626121e-15,
  -3.732940923932815e-16,   1.420598378154608e+00,  -1.395477073216448e-02,  -6.387411844271688e-05,   2.283296011773908e-06,   1.240150330214458e-08,  -5.701491490100093e-10,
   7.911107527625373e-12,   3.769966238219039e-13,  -8.151454008191535e-15,  -3.728443182976193e-16,   1.420597931204176e+00,  -1.395472278647367e-02,  -6.387359560404127e-05,
   2.283256149395826e-06,   1.240233207262232e-08,  -5.700938405871139e-10,   7.909508257215964e-12,   3.769027542077762e-13,  -8.151292221971429e-15,  -3.727697601674859e-16,
   1.816470508606090e+00,  -8.864707868384895e-03,  -2.364629863606120e-04,  -2.699044780884125e-06,   6.504991272851034e-08,   3.634664845540174e-09,   5.286158325825022e-11,
  -1.354112204062820e-12,  -8.141645199069221e-14,  -1.249092319524691e-15,   1.816436971129131e+00,  -8.865842007398260e-03,  -2.364068279572581e-04,  -2.693907441071541e-06,
   6.515895510659341e-08,   3.630523012232900e-09,   5.254145794573513e-11,  -1.360115089058045e-12,  -8.121099735274139e-14,  -1.234287865069649e-15,   1.816381919805230e+00,
  -8.867702303221434e-03,  -2.363145687558668e-04,  -2.685477965437613e-06,   6.533747421189471e-08,   3.623710813183835e-09,   5.201651902209368e-11,  -1.369915330737909e-12,
  -8.087250691948716e-14,  -1.210030623945012e-15,   1.816323514079951e+00,  -8.869674078446892e-03,  -2.362165849509469e-04,  -2.676539490150004e-06,   6.552622915728660e-08,
   3.616465334671160e-09,   5.146033365171565e-11,  -1.380240217262186e-12,  -8.051171679145943e-14,  -1.184355492084917e-15,   1.816277554250721e+00,  -8.871224325318547e-03,
  -2.361394063938245e-04,  -2.669509104099678e-06,   6.567429731589550e-08,   3.610750695797568e-09,   5.102320467685973e-11,  -1.388312507348067e-12,  -8.022660383664510e-14,
  -1.164195327797586e-15,   1.816251032253759e+00,  -8.872118381739076e-03,  -2.360948392119021e-04,  -2.665453432637499e-06,   6.575955687770138e-08,   3.607447708323695e-09,
   5.077116671371305e-11,  -1.392949783391427e-12,  -8.006159344276141e-14,  -1.152579126121775e-15,   1.816241073418628e+00,  -8.872453991393966e-03,  -2.360780988964485e-04,
  -2.663930809547990e-06,   6.579153613930699e-08,   3.606206468612315e-09,   5.067656894004442e-11,  -1.394687084731274e-12,  -7.999954259866133e-14,  -1.148220654507161e-15,
   1.816239422622290e+00,  -8.872509617304155e-03,  -2.360753236914110e-04,  -2.663678429961942e-06,   6.579683523178405e-08,   3.606000666082341e-09,   5.066089037969773e-11,
  -1.394974854138658e-12,  -7.998925215861195e-14,  -1.147498361734188e-15,   4.025710857341849e-03,  -5.767978361003002e-05,   6.108093042911877e-07,  -5.808817154039073e-09,
   6.315448427711803e-11,   3.763849364404077e-14,   8.907921791339147e-15,  -3.396076484377023e-16,  -1.317786661846263e-17,  -9.208422545894018e-20,   4.025797888643753e-03,
  -5.768226336508010e-05,   6.108633323560750e-07,  -5.808772221339419e-09,   6.317289033112037e-11,   3.661707434817624e-14,   8.856528474061463e-15,  -3.400226137543310e-16,
  -1.312415375918982e-17,  -8.995870193911639e-20,   4.025940770189152e-03,  -5.768633427260791e-05,   6.109520393376856e-07,  -5.808699510295155e-09,   6.320302815010396e-11,
   3.493938964148501e-14,   8.772312910381588e-15,  -3.406960590045861e-16,  -1.303594137560918e-17,  -8.648030529920784e-20,   4.026092386134206e-03,  -5.769065380440611e-05,
   6.110461794549868e-07,  -5.808623790187912e-09,   6.323489988001261e-11,   3.315807736337638e-14,   8.683164239045797e-15,  -3.414000750033540e-16,  -1.294229616981712e-17,
  -8.280440729215071e-20,   4.026211714170142e-03,  -5.769405328739223e-05,   6.111202791731653e-07,  -5.808565235188332e-09,   6.325990585751735e-11,   3.175534318129278e-14,
   8.613156249181961e-15,  -3.419465100865577e-16,  -1.286856522712353e-17,  -7.992228604398384e-20,   4.026280582914101e-03,  -5.769601519104090e-05,   6.111630479524782e-07,
  -5.808531857802844e-09,   6.327430636785660e-11,   3.094546668836854e-14,   8.572814404418765e-15,  -3.422588160832428e-16,  -1.282600127169394e-17,  -7.826330050803014e-20,
   4.026306444228320e-03,  -5.769675190453302e-05,   6.111791088820178e-07,  -5.808519402876831e-09,   6.327970806096234e-11,   3.064128769905821e-14,   8.557677197197182e-15,
  -3.423755138491503e-16,  -1.281001577878751e-17,  -7.764115603309108e-20,   4.026310731133274e-03,  -5.769687402529548e-05,   6.111817712546225e-07,  -5.808517342442160e-09,
   6.328060316083479e-11,   3.059086239720173e-14,   8.555168598129436e-15,  -3.423948277917517e-16,  -1.280736583385596e-17,  -7.753807000262412e-20,   3.635971986910313e-02,
  -5.195133128081904e-04,   5.443907969438506e-06,  -5.067814319191276e-08,   5.395944687577946e-10,   8.769307033643433e-13,   7.493213284723686e-14,  -3.030391973684408e-15,
  -1.216859693149761e-16,  -8.392382141162782e-19,   3.636049550548166e-02,  -5.195349443030909e-04,   5.444369570571972e-06,  -5.067697227016201e-08,   5.397487958700191e-10,
   8.678151877509550e-13,   7.445746693267893e-14,  -3.034169982679167e-15,  -1.211945121374503e-16,  -8.197206619683607e-19,   3.636176888578324e-02,  -5.195704555606996e-04,
   5.445127457023313e-06,  -5.067505941265532e-08,   5.400014219032889e-10,   8.528427701302363e-13,   7.367964320394445e-14,  -3.040300685416160e-15,  -1.203873863896261e-16,
  -7.877801006900538e-19,   3.636312010548027e-02,  -5.196081352863887e-04,   5.445931759937102e-06,  -5.067304250272264e-08,   5.402684909347043e-10,   8.369453292311348e-13,
   7.285623866161334e-14,  -3.046708850965944e-15,  -1.195305407646392e-16,  -7.540255734386676e-19,   3.636418356939011e-02,  -5.196377890944100e-04,   5.446564842182582e-06,
  -5.067146444020300e-08,   5.404779622001243e-10,   8.244263882448148e-13,   7.220961019744568e-14,  -3.051682052905065e-15,  -1.188559012900952e-16,  -7.275597413157501e-19,
   3.636479733401238e-02,  -5.196549027533789e-04,   5.446930242991380e-06,  -5.067055742089443e-08,   5.405985664815411e-10,   8.171984492893700e-13,   7.183698766358008e-14,
  -3.054524155274717e-15,  -1.184664372664900e-16,  -7.123255574707543e-19,   3.636502781228569e-02,  -5.196613290773146e-04,   5.447067461551256e-06,  -5.067021752775271e-08,
   5.406438006285805e-10,   8.144837193716647e-13,   7.169716994244594e-14,  -3.055586101379076e-15,  -1.183201679922913e-16,  -7.066124881178584e-19,   3.636506601754602e-02,
  -5.196623943311646e-04,   5.447090207856690e-06,  -5.067016122261648e-08,   5.406512959901995e-10,   8.140336841827261e-13,   7.167399873273629e-14,  -3.055761855145001e-15,
  -1.182959206319886e-16,  -7.056658617645176e-19,   1.017281203374581e-01,  -1.444997085801323e-03,   1.480194844068424e-05,  -1.313118193775097e-07,   1.331323714566944e-09,
   5.507400933694448e-12,   1.799282946302172e-13,  -8.317766170777887e-15,  -3.552944623292430e-16,  -2.408397304685985e-18,   1.017302290536266e-01,  -1.445053118811487e-03,
   1.480308725842447e-05,  -1.313041933978901e-07,   1.331691365417693e-09,   5.482373647277637e-12,   1.785419462198676e-13,  -8.328595144242030e-15,  -3.538805355985131e-16,
  -2.351904249152776e-18,   1.017336909700642e-01,  -1.445145103765439e-03,   1.480495703380218e-05,  -1.312916999293016e-07,   1.332292800511549e-09,   5.441264891235028e-12,
   1.762701084779816e-13,  -8.346165659291402e-15,  -3.515583798702775e-16,  -2.259451483318103e-18,   1.017373644907846e-01,  -1.445242703788910e-03,   1.480694131066190e-05,
  -1.312784784852358e-07,   1.332928087369280e-09,   5.397615103660596e-12,   1.738650561946803e-13,  -8.364528596484649e-15,  -3.490931121986919e-16,  -2.161745942935339e-18,
   1.017402556866191e-01,  -1.445319513263378e-03,   1.480850316411578e-05,  -1.312680985561482e-07,   1.333425977341825e-09,   5.363240802349332e-12,   1.719762819001572e-13,
  -8.378777526462250e-15,  -3.471520313130082e-16,  -2.085136601730022e-18,   1.017419242986623e-01,  -1.445363840609540e-03,   1.480940462714134e-05,  -1.312621182875509e-07,
   1.333712484854519e-09,   5.343394089651933e-12,   1.708878428831455e-13,  -8.386919723664732e-15,  -3.460314421720747e-16,  -2.041038324150464e-18,   1.017425508878459e-01,
  -1.445380485798173e-03,   1.480974315186637e-05,  -1.312598745638857e-07,   1.333819913646682e-09,   5.335939827758184e-12,   1.704794274747762e-13,  -8.389961881749238e-15,
  -3.456105839924171e-16,  -2.024500625216098e-18,   1.017426547544345e-01,  -1.445383244967446e-03,   1.480979926804948e-05,  -1.312595027362209e-07,   1.333837713193716e-09,
   5.334704091663737e-12,   1.704117428272662e-13,  -8.390465355350766e-15,  -3.455408172770393e-16,  -2.021760406813501e-18,   2.016127508249061e-01,  -2.836103993255693e-03,
   2.794093719491776e-05,  -2.264880518648920e-07,   2.078029728425649e-09,   2.017809102452322e-11,   2.767606388290327e-13,  -1.629018649273316e-14,  -7.476599561788748e-16,
  -5.053039233930003e-18,   2.016167305999810e-01,  -2.836200586096390e-03,   2.794271464241745e-05,  -2.264597513157064e-07,   2.078585928226721e-09,   2.012905163779803e-11,
   2.738424974796065e-13,  -1.631291705518163e-14,  -7.447229862573142e-16,  -4.934904711081278e-18,   2.016232642283736e-01,  -2.836359150246507e-03,   2.794563294254737e-05,
  -2.264133419683415e-07,   2.079494550460046e-09,   2.004849849042341e-11,   2.690603668480454e-13,  -1.634980005617839e-14,  -7.398993087372753e-16,  -4.741568755578607e-18,
   2.016301971625307e-01,  -2.836527387344517e-03,   2.794872993480106e-05,  -2.263641668376904e-07,   2.080452601274260e-09,   1.996296192968929e-11,   2.639976722050394e-13,
  -1.638834865224416e-14,  -7.347781378034264e-16,  -4.537241674750054e-18,   2.016356535987809e-01,  -2.836659782345748e-03,   2.795116760880971e-05,  -2.263255155655169e-07,
   2.081202204825773e-09,   1.989559867032961e-11,   2.600216449780422e-13,  -1.641826247140205e-14,  -7.307457198459522e-16,  -4.377027347484319e-18,   2.016388026872521e-01,
  -2.836736186693325e-03,   2.795257456796890e-05,  -2.263032291350140e-07,   2.081633058832396e-09,   1.985670389419804e-11,   2.577303458284068e-13,  -1.643535662630756e-14,
  -7.284177364585539e-16,  -4.284802023358947e-18,   2.016399852149749e-01,  -2.836764876643883e-03,   2.795310291961542e-05,  -2.262948641349044e-07,   2.081794516952122e-09,
   1.984209510939438e-11,   2.568705723419265e-13,  -1.644174361502324e-14,  -7.275434071381734e-16,  -4.250215401788444e-18,   2.016401812365935e-01,  -2.836769632380003e-03,
   2.795319050275446e-05,  -2.262934777156295e-07,   2.081821263445674e-09,   1.983967331471577e-11,   2.567280859298335e-13,  -1.644280066068007e-14,  -7.273984667595364e-16,
  -4.244484543492499e-18,   3.384603796338460e-01,  -4.690132069001029e-03,   4.334228844435583e-05,  -2.952592398896106e-07,   2.139436807769272e-09,   5.474021368718902e-11,
   3.294608553609690e-13,  -2.813058338040485e-14,  -1.349973404397651e-15,  -9.465884742993928e-18,   3.384665512407285e-01,  -4.690257849139686e-03,   4.334411878961268e-05,
  -2.951820565914737e-07,   2.140077646518206e-09,   5.465547486507303e-11,   3.241917971187011e-13,  -2.817334595660947e-14,  -1.344674065860508e-15,  -9.251379461675698e-18,
   3.384766831213784e-01,  -4.690464313951582e-03,   4.334712397338678e-05,  -2.950554351457866e-07,   2.141121616301704e-09,   5.451627371299466e-11,   3.155570717041698e-13,
  -2.824276151443642e-14,  -1.335970027313537e-15,  -8.900313376732442e-18,   3.384874340869325e-01,  -4.690683356958392e-03,   4.335031321369716e-05,  -2.949211988776339e-07,
   2.142218393062627e-09,   5.436845095914742e-11,   3.064157426629836e-13,  -2.831535056451303e-14,  -1.326728626875821e-15,  -8.529272742539200e-18,   3.384958953394988e-01,
  -4.690855721714873e-03,   4.335282352830743e-05,  -2.948156403334154e-07,   2.143073639961110e-09,   5.425202782703727e-11,   2.992365203746492e-13,  -2.837170828151405e-14,
  -1.319451535330371e-15,  -8.238325252624285e-18,   3.385007785684463e-01,  -4.690955187474091e-03,   4.335427242585936e-05,  -2.947547549605593e-07,   2.143564047419068e-09,
   5.418480358742646e-11,   2.950992858872689e-13,  -2.840392523772391e-14,  -1.315250187614919e-15,  -8.070840319388918e-18,   3.385026122835823e-01,  -4.690992536096105e-03,
   4.335481652879176e-05,  -2.947318984250667e-07,   2.143747601106323e-09,   5.415955378622144e-11,   2.935468540801251e-13,  -2.841596484282750e-14,  -1.313672241922786e-15,
  -8.008028716531922e-18,   3.385029162488577e-01,  -4.690998727071985e-03,   4.335490672308937e-05,  -2.947281099715333e-07,   2.143777996157126e-09,   5.415536793169261e-11,
   2.932895764782111e-13,  -2.841795751198182e-14,  -1.313410659217619e-15,  -7.997621049978568e-18,   5.160192432869967e-01,  -6.986738732301578e-03,   5.790604807756437e-05,
  -2.604754722054108e-07,   4.898304503798230e-10,   1.208427331752712e-10,   4.356620768461203e-13,  -4.877367952642662e-14,  -2.236862342152873e-15,  -1.719138564104233e-17,
   5.160274845934892e-01,  -6.986849332110804e-03,   5.790647094815295e-05,  -2.603047462440721e-07,   4.906570227589505e-10,   1.206957441214884e-10,   4.269352486546171e-13,
  -4.885195132405155e-14,  -2.227897891015765e-15,  -1.682463212467387e-17,   5.160410140764974e-01,  -6.987030847213267e-03,   5.790716563605464e-05,  -2.600246236303306e-07,
   4.920006100958013e-10,   1.204542750708765e-10,   4.126346118480960e-13,  -4.897910280573575e-14,  -2.213173081103875e-15,  -1.622435963449085e-17,   5.160553699643592e-01,
  -6.987223377598153e-03,   5.790790339794248e-05,  -2.597275981237629e-07,   4.934081178534103e-10,   1.201978381643111e-10,   3.974956946155460e-13,  -4.911219697492243e-14,
  -2.197537972691757e-15,  -1.558989004726242e-17,   5.160666681675400e-01,  -6.987374848515720e-03,   5.790848448341967e-05,  -2.594939868794771e-07,   4.945027155819038e-10,
   1.199958632301931e-10,   3.856067562083338e-13,  -4.921562551108413e-14,  -2.185225302381933e-15,  -1.509234625955887e-17,   5.160731885991684e-01,  -6.987462244704272e-03,
   5.790882002364464e-05,  -2.593592251679390e-07,   4.951291765502013e-10,   1.198792367239563e-10,   3.787556297056673e-13,  -4.927478906914049e-14,  -2.178116365084245e-15,
  -1.480592093063809e-17,   5.160756370894191e-01,  -6.987495058941770e-03,   5.790894605705774e-05,  -2.593086321306883e-07,   4.953634267169729e-10,   1.198354304856287e-10,
   3.761848941792628e-13,  -4.929690606515599e-14,  -2.175446317671932e-15,  -1.469850094246412e-17,   5.160760429619011e-01,  -6.987500498165588e-03,   5.790896695072836e-05,
  -2.593002462081222e-07,   4.954022047109138e-10,   1.198281683519285e-10,   3.757588598255646e-13,  -4.930056702709284e-14,  -2.175003689144445e-15,  -1.468070169540640e-17,
   7.399220323300794e-01,  -9.650556538409011e-03,   6.491283617584657e-05,   2.564232435430065e-08,  -4.172916845006275e-09,   2.174981249767266e-10,   1.280211917087840e-12,
  -9.349038385569089e-14,  -3.596764306933892e-15,  -3.006400672543008e-17,   7.399312627677304e-01,  -9.650544506525489e-03,   6.490928761470763e-05,   2.594946109245120e-08,
  -4.170350248420744e-09,   2.172165728355080e-10,   1.266187062005939e-12,  -9.362767615124915e-14,  -3.581993071671602e-15,  -2.943812822735083e-17,   7.399464156627313e-01,
  -9.650524660025668e-03,   6.490346360846822e-05,   2.645338529261065e-08,  -4.166158239434500e-09,   2.167540736938195e-10,   1.243205622720331e-12,  -9.385076886717368e-14,
  -3.557727986375770e-15,  -2.841365612238900e-17,   7.399624935632573e-01,  -9.650503473357299e-03,   6.489728596148461e-05,   2.698769289848215e-08,  -4.161739343692482e-09,
   2.162629407223117e-10,   1.218878501033029e-12,  -9.408437477988050e-14,  -3.531959871883668e-15,  -2.733070580165654e-17,   7.399751465991610e-01,  -9.650486706702391e-03,
   6.489242561664706e-05,   2.740790973904994e-08,  -4.158282726382432e-09,   2.158761394014881e-10,   1.199774912567869e-12,  -9.426597500176859e-14,  -3.511665327992498e-15,
  -2.648138579263895e-17,   7.399824487708040e-01,  -9.650476993217786e-03,   6.488962121433083e-05,   2.765031039075161e-08,  -4.156296284243000e-09,   2.156527984205697e-10,
   1.188766693394103e-12,  -9.436988017543528e-14,  -3.499947071626073e-15,  -2.599241732836049e-17,   7.399851907818799e-01,  -9.650473338693136e-03,   6.488856824613040e-05,
   2.774131256086821e-08,  -4.155551949469995e-09,   2.155689108822239e-10,   1.184636180379126e-12,  -9.440872770662739e-14,  -3.495545650124609e-15,  -2.580903000399737e-17,
   7.399856453080406e-01,  -9.650472732533352e-03,   6.488839370752222e-05,   2.775639632905351e-08,  -4.155428649390765e-09,   2.155550042278253e-10,   1.183951656644987e-12,
  -9.441515828288963e-14,  -3.494815993771542e-15,  -2.577864281346353e-17,   1.018615549466749e+00,  -1.242679727896539e-02,   4.824758549137140e-05,   8.387231692923589e-07,
  -1.114603374855853e-08,   2.498647894902721e-10,   5.534970834760338e-12,  -1.867468266375059e-13,  -6.698547208444333e-15,  -4.157630433710062e-17,   1.018622396446159e+00,
  -1.242643797103006e-02,   4.823813354674470e-05,   8.390740065664282e-07,  -1.113452884758591e-08,   2.493038352132484e-10,   5.508801866928674e-12,  -1.869301455111074e-13,
  -6.673420190901997e-15,  -4.046586680145926e-17,   1.018633635909462e+00,  -1.242584800173904e-02,   4.822262365142312e-05,   8.396493846042047e-07,  -1.111568178673525e-08,
   2.483825612027538e-10,   5.465913833434338e-12,  -1.872270213220832e-13,  -6.632135476355575e-15,  -3.864819805138435e-17,   1.018645560542338e+00,  -1.242522185317347e-02,
   4.820617595586542e-05,   8.402591192462112e-07,  -1.109573803088116e-08,   2.474045109933721e-10,   5.420504986155556e-12,  -1.875365064030573e-13,  -6.588282797377752e-15,
  -3.672671668444473e-17,   1.018654944345534e+00,  -1.242472896565605e-02,   4.819323840224736e-05,   8.407384144230905e-07,  -1.108008155239922e-08,   2.466344168159918e-10,
   5.384839466122475e-12,  -1.877760824077045e-13,  -6.553737445911625e-15,  -3.521972594594474e-17,   1.018660359542933e+00,  -1.242444446844502e-02,   4.818577463711529e-05,
   8.410147968304245e-07,  -1.107106165490399e-08,   2.461898359262580e-10,   5.364284863693211e-12,  -1.879127496618661e-13,  -6.533787571200375e-15,  -3.435210927592602e-17,
   1.018662392931797e+00,  -1.242433762894256e-02,   4.818297243846353e-05,   8.411185380321774e-07,  -1.106767757106223e-08,   2.460228642199443e-10,   5.356571825948585e-12,
  -1.879637681072158e-13,  -6.526293744161797e-15,  -3.402670728416577e-17,   1.018662729991329e+00,  -1.242431991834533e-02,   4.818250796131620e-05,   8.411357323452915e-07,
  -1.106711676774926e-08,   2.459951848403322e-10,   5.355293565499794e-12,  -1.879722092491777e-13,  -6.525051406290570e-15,  -3.397278818131322e-17,   1.363969222619729e+00,
  -1.436059584380877e-02,  -3.563957295603078e-05,   2.406588837182335e-06,   3.359985135367762e-09,  -2.933498980247311e-10,   1.344808767632936e-11,  -7.047653561851597e-14,
  -1.930810742529693e-14,  -1.597539992919512e-16,   1.363964156934611e+00,  -1.435956989989835e-02,  -3.563654691130507e-05,   2.406169489072150e-06,   3.387798551555280e-09,
  -2.935724436480010e-10,   1.337272117000198e-11,  -7.123108766840387e-14,  -1.923252244977153e-14,  -1.573648593237302e-16,   1.363955841128586e+00,  -1.435788577672693e-02,
  -3.563156228688742e-05,   2.405480827460758e-06,   3.433343332344820e-09,  -2.939393767729098e-10,   1.324921258872779e-11,  -7.246103982518752e-14,  -1.910842752386134e-14,
  -1.534532122178831e-16,   1.363947017873106e+00,  -1.435609896831912e-02,  -3.562625030939923e-05,   2.404749785605314e-06,   3.481513152065381e-09,  -2.943308697073658e-10,
   1.311845637129328e-11,  -7.375422034608714e-14,  -1.897674112185320e-14,  -1.493169744677315e-16,   1.363940074256565e+00,  -1.435469286849089e-02,  -3.562205320120679e-05,
   2.404174220419188e-06,   3.519309733687907e-09,  -2.946405241933249e-10,   1.301576481266174e-11,  -7.476336571906032e-14,  -1.887309560070151e-14,  -1.460721299953511e-16,
   1.363936067092948e+00,  -1.435388143201484e-02,  -3.561962434233022e-05,   2.403841957512376e-06,   3.541077503555208e-09,  -2.948198494979964e-10,   1.295658539909266e-11,
  -7.534232373052842e-14,  -1.881327705487696e-14,  -1.442036429055037e-16,   1.363934562388379e+00,  -1.435357673923356e-02,  -3.561871103053872e-05,   2.403717171885424e-06,
   3.549242946640230e-09,  -2.948873043576353e-10,   1.293437917574743e-11,  -7.555907878168669e-14,  -1.879081413185580e-14,  -1.435027977829714e-16,   1.363934312963390e+00,
  -1.435352623255468e-02,  -3.561855957006260e-05,   2.403696485952397e-06,   3.550596033692029e-09,  -2.948984921003392e-10,   1.293069903284361e-11,  -7.559497478942310e-14,
  -1.878709055741776e-14,  -1.433866643922655e-16,   1.777055863740485e+00,  -1.086238680507177e-02,  -2.600334643780958e-04,  -1.026368780239469e-06,   1.457066124420139e-07,
   4.125454023749013e-09,  -2.552675940589830e-11,  -4.256097709593319e-12,  -8.126889863966583e-14,   1.887392342601168e-15,   1.777019108581574e+00,  -1.086280463856209e-02,
  -2.599093847802432e-04,  -1.020603856588997e-06,   1.456484854189451e-07,   4.112893763872443e-09,  -2.583485551079288e-11,  -4.246184576531401e-12,  -8.050763868158853e-14,
   1.896659575040415e-15,   1.776958781745968e+00,  -1.086348882572609e-02,  -2.597057250502783e-04,  -1.011152653828770e-06,   1.455525934835766e-07,   4.092295631082079e-09,
  -2.633847276626337e-11,  -4.229877703559726e-12,  -7.926140046021806e-14,   1.911680136996355e-15,   1.776894787577175e+00,  -1.086421241932592e-02,  -2.594896767915193e-04,
  -1.001141652486202e-06,   1.454502118343841e-07,   4.070468768798551e-09,  -2.686990269595122e-11,  -4.212530578445724e-12,  -7.794379350996314e-14,   1.927356696570152e-15,
   1.776844436329506e+00,  -1.086478016844904e-02,  -2.593196823287044e-04,  -9.932755702807558e-07,   1.453691801370465e-07,   4.053312192224314e-09,  -2.728601154296374e-11,
  -4.198846549106555e-12,  -7.691026808709731e-14,   1.939505759292388e-15,   1.776815382649687e+00,  -1.086510713752559e-02,  -2.592215899319001e-04,  -9.887409593645829e-07,
   1.453222325220059e-07,   4.043419335638191e-09,  -2.752530399431022e-11,  -4.190936600677298e-12,  -7.631517866241152e-14,   1.946441935585795e-15,   1.776804473650842e+00,
  -1.086522978730576e-02,  -2.591847580506857e-04,  -9.870391236890090e-07,   1.453045687612103e-07,   4.039706084768471e-09,  -2.761499980330524e-11,  -4.187963961505899e-12,
  -7.609197719310613e-14,   1.949032340389801e-15,   1.776802665378082e+00,  -1.086525011138698e-02,  -2.591786527864297e-04,  -9.867570704803921e-07,   1.453016389232319e-07,
   4.039090645520545e-09,  -2.762985968422589e-11,  -4.187471079016847e-12,  -7.605499209897939e-14,   1.949460988802023e-15,   3.804347599704022e-03,  -5.305484128739677e-05,
   5.472178690635367e-07,  -4.784809424429209e-09,   6.502601378344123e-11,   8.951435457138148e-14,  -6.404004539285245e-15,  -7.261876964949479e-16,  -7.646180823013083e-18,
   4.625899345047615e-19,   3.804425584318778e-03,  -5.305688364499087e-05,   5.472733116415898e-07,  -4.784700008198806e-09,   6.501201117255163e-11,   8.738196600704702e-14,
  -6.432265316545172e-15,  -7.238222514742866e-16,  -7.539269316802140e-18,   4.624438094301054e-19,   3.804553614378751e-03,  -5.306023647605223e-05,   5.473643208634704e-07,
  -4.784522561329200e-09,   6.498898118460870e-11,   8.388641103193846e-14,  -6.478355644512430e-15,  -7.199396824062055e-16,  -7.364382948550493e-18,   4.621838969639413e-19,
   3.804689471905942e-03,  -5.306379404927381e-05,   5.474608767859875e-07,  -4.784337233126729e-09,   6.496448716849175e-11,   8.018429553372588e-14,  -6.526848445698772e-15,
  -7.158209567705783e-16,  -7.179664979227261e-18,   4.618810370716585e-19,   3.804796398096285e-03,  -5.306659384966211e-05,   5.475368581806929e-07,  -4.784193517287958e-09,
   6.494516887626159e-11,   7.727573409373446e-14,  -6.564714575911525e-15,  -7.125802391126310e-16,  -7.034905561423030e-18,   4.616231949205557e-19,   3.804858109537277e-03,
  -5.306820965791246e-05,   5.475807050689833e-07,  -4.784111432512412e-09,   6.493400339353228e-11,   7.559915959030787e-14,  -6.586448677855237e-15,  -7.107102649190373e-16,
  -6.951608160747795e-18,   4.614666133254081e-19,   3.804881283221463e-03,  -5.306881640785292e-05,   5.475971693570770e-07,  -4.784080770651546e-09,   6.492980752938428e-11,
   7.496996967380350e-14,  -6.594587552849926e-15,  -7.100081303254618e-16,  -6.920375639847483e-18,   4.614063500183238e-19,   3.804885124613711e-03,  -5.306891698522860e-05,
   5.475998985139582e-07,  -4.784075696542132e-09,   6.492911184073762e-11,   7.486569251038929e-14,  -6.595935501831042e-15,  -7.098917446250443e-16,  -6.915200853764265e-18,
   4.613962833144159e-19,   3.436512715435161e-02,  -4.782460383340964e-04,   4.888368446602660e-06,  -4.184348290439362e-08,   5.659461403730803e-10,   1.215786007827495e-12,
  -6.348944803301543e-14,  -6.600321020968390e-15,  -7.084344339722568e-17,   4.245480721447620e-18,   3.436582377525729e-02,  -4.782638967358672e-04,   4.888850889522718e-06,
  -4.184191604265909e-08,   5.658075313980347e-10,   1.196408108898879e-12,  -6.375148072070734e-14,  -6.578609920052658e-15,  -6.986213121541438e-17,   4.244211650719848e-18,
   3.436696744074644e-02,  -4.782932137481088e-04,   4.889642811172691e-06,  -4.183936357265179e-08,   5.655795887591851e-10,   1.164643017682572e-12,  -6.417885658190597e-14,
  -6.542973721897604e-15,  -6.825689450877941e-17,   4.241943734740281e-18,   3.436818102553871e-02,  -4.783243207632964e-04,   4.890482983586912e-06,  -4.183668207065845e-08,
   5.653371914436643e-10,   1.131001487413913e-12,  -6.462854825286805e-14,  -6.505169604358689e-15,  -6.656141423360528e-17,   4.239287816386197e-18,   3.436913617188385e-02,
  -4.783488017154481e-04,   4.891144118400745e-06,  -4.183459114545824e-08,   5.651460397320541e-10,   1.104571530497824e-12,  -6.497972306294446e-14,  -6.475424111875318e-15,
  -6.523270227326373e-17,   4.237017987147576e-18,   3.436968742505184e-02,  -4.783629299792319e-04,   4.891525638007967e-06,  -4.183339221370396e-08,   5.650355691187532e-10,
   1.089336764139337e-12,  -6.518129896605477e-14,  -6.458260125506925e-15,  -6.446813492099583e-17,   4.235636365710744e-18,   3.436989442979019e-02,  -4.783682352502869e-04,
   4.891668895942038e-06,  -4.183294347298739e-08,   5.649940574160343e-10,   1.083619450255638e-12,  -6.525678623266063e-14,  -6.451815403120534e-15,  -6.418145882652662e-17,
   4.235104048959160e-18,   3.436992874398336e-02,  -4.783691146731914e-04,   4.891692642653638e-06,  -4.183286916532387e-08,   5.649871747348500e-10,   1.082671907874852e-12,
  -6.526928844114553e-14,  -6.450747126115983e-15,  -6.413396065564419e-17,   4.235015098409809e-18,   9.617550706368284e-02,  -1.332512938339344e-03,   1.335813579124729e-05,
  -1.089974297909119e-07,   1.459083189561508e-09,   5.742761676364038e-12,  -2.093663649294433e-13,  -1.874715980604916e-14,  -2.082391451243993e-16,   1.227024229123239e-17,
   9.617741052461407e-02,  -1.332559444601783e-03,   1.335937903278045e-05,  -1.089897210577438e-07,   1.458627197267118e-09,   5.687739330786284e-12,  -2.101375118602203e-13,
  -1.868439964179181e-14,  -2.053992881708848e-16,   1.226698795165023e-17,   9.618053549134481e-02,  -1.332635789890014e-03,   1.336141973077312e-05,  -1.089771221013490e-07,
   1.457877453325991e-09,   5.597546728093488e-12,  -2.113953909185844e-13,  -1.858138477596119e-14,  -2.007538190110331e-16,   1.226110713300075e-17,   9.618385149592346e-02,
  -1.332716795068481e-03,   1.336358468245304e-05,  -1.089638299073897e-07,   1.457080348938099e-09,   5.502029515681086e-12,  -2.127191379242248e-13,  -1.847210100111689e-14,
  -1.958471723709426e-16,   1.225413934704842e-17,   9.618646133445613e-02,  -1.332780544352172e-03,   1.336528823058821e-05,  -1.089534240443489e-07,   1.456451893548562e-09,
   5.426990250344067e-12,  -2.137530190464716e-13,  -1.838611156235951e-14,  -1.920019250592817e-16,   1.224813170912392e-17,   9.618796757361181e-02,  -1.332817334423949e-03,
   1.336627126910809e-05,  -1.089474407098179e-07,   1.456088748421774e-09,   5.383737043270501e-12,  -2.143465261992073e-13,  -1.833649265361493e-14,  -1.897892882469692e-16,
   1.224445553644996e-17,   9.618853319090030e-02,  -1.332831149294485e-03,   1.336664038858725e-05,  -1.089451980815700e-07,   1.455952298735644e-09,   5.367505130172121e-12,
  -2.145687964599481e-13,  -1.831786166839092e-14,  -1.889596546375882e-16,   1.224303570133330e-17,   9.618862695056356e-02,  -1.332833439298203e-03,   1.336670157430255e-05,
  -1.089448265539438e-07,   1.455929675763775e-09,   5.364814990841033e-12,  -2.146056094319460e-13,  -1.831477339101026e-14,  -1.888221960446755e-16,   1.224279826787720e-17,
   1.906990169316364e-01,  -2.622850653105684e-03,   2.543651548566932e-05,  -1.898545538060706e-07,   2.496950324435580e-09,   1.863478790734339e-11,  -5.087684178627140e-13,
  -3.828116809423935e-14,  -4.425972282781797e-16,   2.556758632249148e-17,   1.907026410093291e-01,  -2.622931616041338e-03,   2.543864121981704e-05,  -1.898289814732733e-07,
   2.495844985349287e-09,   1.852247630065832e-11,  -5.104093086176351e-13,  -3.815036014203057e-14,  -4.366521790904551e-16,   2.556209607269660e-17,   1.907085907372027e-01,
  -2.623064522137267e-03,   2.544213026835660e-05,  -1.897871149996424e-07,   2.494027925533744e-09,   1.833838102313515e-11,  -5.130861738700134e-13,  -3.793564663086201e-14,
  -4.269271379455072e-16,   2.555194237644212e-17,   1.907149041543382e-01,  -2.623205535378000e-03,   2.544583148254394e-05,  -1.897428470942140e-07,   2.492096546204407e-09,
   1.814342547185629e-11,  -5.159035903987839e-13,  -3.770786057753552e-14,  -4.166552493009251e-16,   2.553962641008060e-17,   1.907198730611011e-01,  -2.623316506025387e-03,
   2.544874367925594e-05,  -1.897081205963273e-07,   2.490574134535020e-09,   1.799027225311291e-11,  -5.181043425591134e-13,  -3.752862364556329e-14,  -4.086053003753051e-16,
   2.552882342885803e-17,   1.907227408002513e-01,  -2.623380546348911e-03,   2.545042409281970e-05,  -1.896881243403578e-07,   2.489694560208119e-09,   1.790199589042089e-11,
  -5.193678119243060e-13,  -3.742519587581080e-14,  -4.039731646799360e-16,   2.552214583628910e-17,   1.907238176810523e-01,  -2.623404593559432e-03,   2.545105505336737e-05,
  -1.896806240640422e-07,   2.489364090138829e-09,   1.786886828425321e-11,  -5.198410062020813e-13,  -3.738636031615955e-14,  -4.022363294309107e-16,   2.551955485108266e-17,
   1.907239961903157e-01,  -2.623408579698844e-03,   2.545115964139446e-05,  -1.896793812350570e-07,   2.489309300448007e-09,   1.786337801957795e-11,  -5.199193789702269e-13,
  -3.737992290492865e-14,  -4.019485600747054e-16,   2.551912096008577e-17,   3.203718209774193e-01,  -4.356899973889211e-03,   4.004113716897145e-05,  -2.521971375523499e-07,
   3.223972947762579e-09,   4.828733805389281e-11,  -1.054756030491654e-12,  -6.802078514197839e-14,  -8.093120449377253e-16,   4.605163389238855e-17,   3.203775246348056e-01,
  -4.357007405907810e-03,   4.004387696514981e-05,  -2.521301021584685e-07,   3.221686121366595e-09,   4.808782685183001e-11,  -1.057757355766265e-12,  -6.778509338745609e-14,
  -7.984836293814194e-16,   4.604493089421442e-17,   3.203868883914911e-01,  -4.357183752665503e-03,   4.004837336175953e-05,  -2.520202563508714e-07,   3.217927413217757e-09,
   4.776080581355806e-11,  -1.062653692835715e-12,  -6.739820794313015e-14,  -7.807700606778878e-16,   4.603181465062353e-17,   3.203968244415458e-01,  -4.357370842666901e-03,
   4.005314245168644e-05,  -2.519039779368155e-07,   3.213933026310042e-09,   4.741450277972891e-11,  -1.067807291630953e-12,  -6.698775214775923e-14,  -7.620601597699680e-16,
   4.601504137945776e-17,   3.204046444405929e-01,  -4.357518063569698e-03,   4.005689434880827e-05,  -2.518126661659775e-07,   3.210785021410850e-09,   4.714246113358009e-11,
  -1.071833019417681e-12,  -6.666476771331391e-14,  -7.473972449732249e-16,   4.599978449641606e-17,   3.204091576253496e-01,  -4.357603019658832e-03,   4.005905907974759e-05,
  -2.517600484340071e-07,   3.208966488582423e-09,   4.698566125301149e-11,  -1.074144273016614e-12,  -6.647838677840504e-14,  -7.389597679154486e-16,   4.599015900186466e-17,
   3.204108523919671e-01,  -4.357634920009222e-03,   4.005987185142373e-05,  -2.517403050788998e-07,   3.208283280001057e-09,   4.692681926590380e-11,  -1.075009892922892e-12,
  -6.640840273597572e-14,  -7.357960916564668e-16,   4.598638991008416e-17,   3.204111333248930e-01,  -4.357640207869497e-03,   4.006000657435306e-05,  -2.517370331329625e-07,
   3.208170010934776e-09,   4.691706736507058e-11,  -1.075153261669999e-12,  -6.639680208555582e-14,  -7.352719138649628e-16,   4.598575698310999e-17,   4.889794203765935e-01,
  -6.535675472384561e-03,   5.490733679081697e-05,  -2.333478023060865e-07,   2.858135042458240e-09,   1.067391812050051e-10,  -1.924290082632551e-12,  -1.153808489669785e-13,
  -1.357340964363451e-15,   7.741646239513601e-17,   4.889872389535950e-01,  -6.535774567702907e-03,   5.490975355548894e-05,  -2.331987565823306e-07,   2.853968286491643e-09,
   1.064007049347255e-10,  -1.929315287240312e-12,  -1.149844370143810e-13,  -1.338769506312098e-15,   7.741261749245994e-17,   4.890000746582689e-01,  -6.535937203384491e-03,
   5.491371847594667e-05,  -2.329544194076369e-07,   2.847120331592902e-09,   1.058458973863490e-10,  -1.937512106132080e-12,  -1.143337047682349e-13,  -1.308389137959774e-15,
   7.740259919343088e-17,   4.890136946660755e-01,  -6.536109710875459e-03,   5.491792204065733e-05,  -2.326956278648133e-07,   2.839843904549141e-09,   1.052583670412087e-10,
  -1.946137882433870e-12,  -1.136432922376429e-13,  -1.276299418167492e-15,   7.738695745599442e-17,   4.890244139248610e-01,  -6.536245430668261e-03,   5.492122771596681e-05,
  -2.324922968111903e-07,   2.834109955142975e-09,   1.047968198061145e-10,  -1.952874647096980e-12,  -1.130999865818011e-13,  -1.251150369934959e-15,   7.737103888350181e-17,
   4.890306003153116e-01,  -6.536323739388062e-03,   5.492313446214081e-05,  -2.323750863477516e-07,   2.830797840751520e-09,   1.045307894600364e-10,  -1.956741858897989e-12,
  -1.127864572665674e-13,  -1.236678703727063e-15,   7.736041211071736e-17,   4.890329233846960e-01,  -6.536353141723411e-03,   5.492385027072632e-05,  -2.323310983179935e-07,
   2.829553554517715e-09,   1.044309562249389e-10,  -1.958190126791293e-12,  -1.126687284649187e-13,  -1.231252447272768e-15,   7.735615028795478e-17,   4.890333084676612e-01,
  -6.536358015403739e-03,   5.492396891603212e-05,  -2.323238080259963e-07,   2.829347267053006e-09,   1.044144108031789e-10,  -1.958429991856180e-12,  -1.126492134777069e-13,
  -1.230353389413065e-15,   7.735542953327092e-17,   7.023592009566371e-01,  -9.130821998235936e-03,   6.496589258834168e-05,  -5.784428778191689e-09,   2.036848997984654e-10,
   2.036161525352099e-10,  -2.943903210913549e-12,  -2.011317187106501e-13,  -2.176513265838405e-15,   1.287257630068145e-16,   7.023684463567179e-01,  -9.130823462602135e-03,
   6.496603031825267e-05,  -5.499644273895571e-09,   1.973064480825779e-10,   2.030256203807922e-10,  -2.951925366739955e-12,  -2.004720973368829e-13,  -2.144997513511866e-15,
   1.287375684907122e-16,   7.023836241860225e-01,  -9.130825779880664e-03,   6.496625245826611e-05,  -5.032727421811486e-09,   1.868231540055151e-10,   2.020575909946103e-10,
  -2.965005319375422e-12,  -1.993892274578954e-13,  -2.093442407609092e-15,   1.287504287163635e-16,   7.023997290477600e-01,  -9.130828120939011e-03,   6.496648277201293e-05,
  -4.538111279983221e-09,   1.756832896966289e-10,   2.010323732657990e-10,  -2.978762519098382e-12,  -1.982402391609928e-13,  -2.038987063059071e-15,   1.287552572630671e-16,
   7.024124036669409e-01,  -9.130829878186569e-03,   6.496666012166678e-05,  -4.149437925740757e-09,   1.669044304478314e-10,   2.002269233966860e-10,  -2.989501662677846e-12,
  -1.973360042750973e-13,  -1.996310226616166e-15,   1.287527084703660e-16,   7.024197184408112e-01,  -9.130830858211043e-03,   6.496676090589671e-05,  -3.925364087473114e-09,
   1.618332975344168e-10,   1.997626444513675e-10,  -2.995664294356317e-12,  -1.968141659897803e-13,  -1.971752601034656e-15,   1.287487040563463e-16,   7.024224652117530e-01,
  -9.130831219774514e-03,   6.496679845494084e-05,  -3.841266933035456e-09,   1.599281541373290e-10,   1.995884092982546e-10,  -2.997971791233870e-12,  -1.966182134456253e-13,
  -1.962544571671317e-15,   1.287467228757419e-16,   7.024229205283855e-01,  -9.130831279368883e-03,   6.496680466359109e-05,  -3.827328988736426e-09,   1.596123028466308e-10,
   1.995595329305383e-10,  -2.998353942187393e-12,  -1.965857316704073e-13,  -1.961018926447530e-15,   1.287463693106339e-16,   9.697403315067096e-01,  -1.200317353570736e-02,
   5.742461555148217e-05,   7.053643822134902e-07,  -5.369989740442296e-09,   2.957461741457187e-10,  -2.631439490857104e-12,  -3.823220282582312e-13,  -3.861788828555255e-15,
   2.352433801813824e-16,   9.697484941641008e-01,  -1.200287094853166e-02,   5.741999756122891e-05,   7.057757845366897e-07,  -5.375774339760910e-09,   2.946228991979907e-10,
  -2.645678316440100e-12,  -3.811158114174543e-13,  -3.806111496527230e-15,   2.352941698496150e-16,   9.697618940073406e-01,  -1.200237407795813e-02,   5.741241276031335e-05,
   7.064500207107469e-07,  -5.385292056797715e-09,   2.927814673827620e-10,  -2.668895197953527e-12,  -3.791355159818171e-13,  -3.715038409047711e-15,   2.353652205765471e-16,
   9.697761116242566e-01,  -1.200184669051605e-02,   5.740435976996596e-05,   7.071638795663958e-07,  -5.395419988850687e-09,   2.908311074535360e-10,  -2.693315270430886e-12,
  -3.770341646645690e-13,  -3.618851277829589e-15,   2.354239392761887e-16,   9.697873004909626e-01,  -1.200143151135535e-02,   5.739801844904587e-05,   7.077245634756197e-07,
  -5.403411543862512e-09,   2.892987281409428e-10,  -2.712378859320039e-12,  -3.753803335704996e-13,  -3.543475873546028e-15,   2.354581464934859e-16,   9.697937576152681e-01,
  -1.200119185429950e-02,   5.739435731382801e-05,   7.080476938416227e-07,  -5.408031937689436e-09,   2.884153899373302e-10,  -2.723318777300079e-12,  -3.744258589691853e-13,
  -3.500105172833504e-15,   2.354730977542796e-16,   9.697961822938370e-01,  -1.200110185142803e-02,   5.739298224972058e-05,   7.081689472554737e-07,  -5.409768508341451e-09,
   2.880838819349350e-10,  -2.727415112818972e-12,  -3.740674419297866e-13,  -3.483843586810142e-15,   2.354778092459322e-16,   9.697965842171264e-01,  -1.200108693167523e-02,
   5.739275429883822e-05,   7.081890422481060e-07,  -5.410056452341682e-09,   2.880289399873793e-10,  -2.728093521570497e-12,  -3.740080290703358e-13,  -3.481149290623800e-15,
   2.354785426763368e-16,   1.306140342430384e+00,  -1.452962276303835e-02,  -6.579685370871853e-06,   2.428991161558735e-06,   1.913341837970006e-10,  -6.548507267784660e-11,
   2.763539893378307e-12,  -6.631489998037424e-13,  -1.344467516563339e-14,   5.540458173289751e-16,   1.306139406481536e+00,  -1.452858616324558e-02,  -6.579492272938698e-06,
   2.428881661851391e-06,   1.966333176526043e-10,  -6.742169002883804e-11,   2.712705560535826e-12,  -6.603207904792447e-13,  -1.331203728872509e-14,   5.536912814772396e-16,
   1.306137869994410e+00,  -1.452688445445801e-02,  -6.579172189730458e-06,   2.428699927203605e-06,   2.052557217312069e-10,  -7.059485919457098e-11,   2.629630391950791e-12,
  -6.556793422119748e-13,  -1.309505391197308e-14,   5.530823712792453e-16,   1.306136239696087e+00,  -1.452507886124939e-02,  -6.578828393883490e-06,   2.428504414444873e-06,
   2.143004508197036e-10,  -7.395354623411202e-11,   2.541993225836141e-12,  -6.507565196940989e-13,  -1.286585408656501e-14,   5.523999388284567e-16,   1.306134956666936e+00,
  -1.452365788733156e-02,  -6.578554830704124e-06,   2.428348608447386e-06,   2.213434265416082e-10,  -7.659084944735899e-11,   2.473392079347319e-12,  -6.468838042812497e-13,
  -1.268622222299243e-14,   5.518367153454538e-16,   1.306134216215459e+00,  -1.452283783058382e-02,  -6.578395758439850e-06,   2.428257914431251e-06,   2.253779737655134e-10,
  -7.811048366949063e-11,   2.433948925190350e-12,  -6.446494283177508e-13,  -1.258285340359268e-14,   5.515012400585849e-16,   1.306133938170410e+00,  -1.452252989398208e-02,
  -6.578335800398488e-06,   2.428223711486942e-06,   2.268873084084737e-10,  -7.868066691714440e-11,   2.419165547947540e-12,  -6.438105212519702e-13,  -1.254409410447371e-14,
   5.513733009856389e-16,   1.306133892080560e+00,  -1.452247884923381e-02,  -6.578325849653418e-06,   2.428218034136597e-06,   2.271372029287334e-10,  -7.877515897581859e-11,
   2.416716463532745e-12,  -6.436714669437963e-13,  -1.253767218741543e-14,   5.513519897547908e-16,   1.729431457051297e+00,  -1.294645237501645e-02,  -2.558680656622655e-04,
   1.887067190076087e-06,   2.113122894984056e-07,   1.886855184046839e-09,  -1.638959650176632e-10,  -4.797279423853526e-12,   7.481177284646019e-14,   6.296323273556159e-15,
   1.729395404004205e+00,  -1.294563769221569e-02,  -2.556895978728099e-04,   1.889635908241719e-06,   2.109660423545289e-07,   1.873013681529567e-09,  -1.635929070865263e-10,
  -4.766163722270687e-12,   7.505675274214121e-14,   6.253672514923775e-15,   1.729336235133898e+00,  -1.294429949290420e-02,  -2.553968266376546e-04,   1.893838842775429e-06,
   2.103980917564524e-07,   1.850357085182241e-09,  -1.630947182075123e-10,  -4.715238896861116e-12,   7.545275959494313e-14,   6.183825612786983e-15,   1.729273476897209e+00,
  -1.294287852173905e-02,  -2.550864624074658e-04,   1.898279447504120e-06,   2.097960917587270e-07,   1.826406839268457e-09,  -1.625651999936562e-10,  -4.661416250870058e-12,
   7.586461548881143e-14,   6.109945774329745e-15,   1.729224103570170e+00,  -1.294175946004314e-02,  -2.548424130123709e-04,   1.901760474971121e-06,   2.093227780237734e-07,
   1.807622998944519e-09,  -1.621478213172735e-10,  -4.619211147864010e-12,   7.618274567272020e-14,   6.051971064813541e-15,   1.729195616363704e+00,  -1.294111332764633e-02,
  -2.547016510242509e-04,   1.903763941157517e-06,   2.090498053148002e-07,   1.796808536721551e-09,  -1.619066878139436e-10,  -4.594915238346327e-12,   7.636394997156890e-14,
   6.018580619545215e-15,   1.729184920477155e+00,  -1.294087064187225e-02,  -2.546488093113485e-04,   1.904515223677033e-06,   2.089473365021453e-07,   1.792752518440958e-09,
  -1.618160916712195e-10,  -4.585803492423621e-12,   7.643154267514849e-14,   6.006055020194005e-15,   1.729183147551688e+00,  -1.294083041024548e-02,  -2.546400508751755e-04,
   1.904639704726513e-06,   2.089303526846603e-07,   1.792080434758456e-09,  -1.618010715326680e-10,  -4.584293702313136e-12,   7.644272335715995e-14,   6.003979400736635e-15,
   3.600545112683908e-03,  -4.888903582225751e-05,   4.960551171818006e-07,  -3.745590061326948e-09,   6.357144843033437e-11,  -3.159122239637376e-13,  -2.677449486135057e-14,
  -5.850561319327330e-16,   1.922792994218728e-17,   9.013797331393750e-19,   3.600615813481463e-03,  -4.889063653806237e-05,   4.961090790462582e-07,  -3.746053730188353e-09,
   6.351520009111811e-11,  -3.175901109926873e-13,  -2.669827799932465e-14,  -5.806200031909058e-16,   1.920922587891548e-17,   8.945782632733569e-19,   3.600731885786087e-03,
  -4.889326451854329e-05,   4.961976317567999e-07,  -3.746816614355476e-09,   6.342297670917088e-11,  -3.203351696820796e-13,  -2.657321267428406e-14,  -5.733622933225434e-16,
   1.917797415991003e-17,   8.834485008957339e-19,   3.600855054950191e-03,  -4.889605320824119e-05,   4.962915462826573e-07,  -3.747628394092781e-09,   6.332528003865421e-11,
  -3.232350554859521e-13,  -2.644058699755751e-14,  -5.656950887821115e-16,   1.914407658680400e-17,   8.716877777930147e-19,   3.600951995142433e-03,  -4.889824806620519e-05,
   4.963654236951764e-07,  -3.748268930627122e-09,   6.324850766320883e-11,  -3.255080119431857e-13,  -2.633626724558091e-14,  -5.596853637420263e-16,   1.911686921393565e-17,
   8.624673340545575e-19,   3.601007943392260e-03,  -4.889951481965757e-05,   4.964080462509563e-07,  -3.748639261484565e-09,   6.320424707602870e-11,  -3.268160716793293e-13,
  -2.627608548338138e-14,  -5.562267979183267e-16,   1.910095620254696e-17,   8.571601764796491e-19,   3.601028952926374e-03,  -4.889999050914703e-05,   4.964240488858205e-07,
  -3.748778449877288e-09,   6.318763552594137e-11,  -3.273065611876834e-13,  -2.625349104524821e-14,  -5.549299153223502e-16,   1.909494095808217e-17,   8.551699573524297e-19,
   3.601032435579005e-03,  -4.890006936206783e-05,   4.964267014166560e-07,  -3.748801528961023e-09,   6.318488238480337e-11,  -3.273878299419391e-13,  -2.624974592709590e-14,
  -5.547150356545132e-16,   1.909394175186403e-17,   8.548401909330068e-19,   3.252739547983678e-02,  -4.409926535823129e-04,   4.440933729285667e-06,  -3.274182807123698e-08,
   5.594835392678060e-10,  -2.599020682745391e-12,  -2.489345278683951e-13,  -5.325584389038766e-15,   1.758993100196489e-16,   8.279642625495238e-18,   3.252802841199198e-02,
  -4.410066453355481e-04,   4.441408481336808e-06,  -3.274565498522184e-08,   5.589604381832232e-10,  -2.614288127977350e-12,  -2.482372756993103e-13,  -5.284836354786543e-15,
   1.757288000517487e-16,   8.217163269605271e-18,   3.252906752095037e-02,  -4.410296162742548e-04,   4.442187543487516e-06,  -3.275195291988506e-08,   5.581027568324547e-10,
  -2.639265174932676e-12,  -2.470931432814715e-13,  -5.218170721804586e-15,   1.754438439553244e-16,   8.114923344993128e-18,   3.253017016162097e-02,  -4.410539918645476e-04,
   4.443013753861292e-06,  -3.275865644572772e-08,   5.571941494717626e-10,  -2.665649869113164e-12,  -2.458798447016674e-13,  -5.147743703801586e-15,   1.751346841727895e-16,
   8.006887036056185e-18,   3.253103799321882e-02,  -4.410731767780951e-04,   4.443663671259283e-06,  -3.276394727199147e-08,   5.564801265822848e-10,  -2.686329622682946e-12,
  -2.449254956524179e-13,  -5.092541462767040e-15,   1.748864865231312e-16,   7.922186040961000e-18,   3.253153885487833e-02,  -4.410842492468859e-04,   4.444038625321841e-06,
  -3.276700675812040e-08,   5.560684731383928e-10,  -2.698230254173347e-12,  -2.443749339227259e-13,  -5.060772864678432e-15,   1.747412994315468e-16,   7.873433266059661e-18,
   3.253172693701675e-02,  -4.410884071598298e-04,   4.444179400501100e-06,  -3.276815676701455e-08,   5.559139731379823e-10,  -2.702692630445921e-12,  -2.441682327822681e-13,
  -5.048860372871556e-15,   1.746864135485952e-16,   7.855150639643473e-18,   3.253175811451351e-02,  -4.410890963982082e-04,   4.444202734746816e-06,  -3.276834745762902e-08,
   5.558883667693950e-10,  -2.703431994219310e-12,  -2.441339712394368e-13,  -5.046886599615038e-15,   1.746772961173402e-16,   7.852121326123608e-18,   9.105147012006946e-02,
  -1.230476821960934e-03,   1.219263806773195e-05,  -8.519185787138803e-08,   1.479456466887675e-09,  -5.805418081218674e-12,  -7.376304171745055e-13,  -1.516587502401870e-14,
   5.057822799680516e-16,   2.398448866224153e-17,   9.105320774454846e-02,  -1.230513222791155e-03,   1.219389251849915e-05,  -8.520048452332479e-08,   1.477905714597120e-09,
  -5.848864041468780e-12,  -7.356254502134323e-13,  -1.504783842407459e-14,   5.052961958644847e-16,   2.380340943155311e-17,   9.105606046406586e-02,  -1.230572983393513e-03,
   1.219595095304109e-05,  -8.521469048045428e-08,   1.475362991339794e-09,  -5.919935788928488e-12,  -7.323354565394356e-13,  -1.485472553839299e-14,   5.044834900530685e-16,
   2.350709396132632e-17,   9.105908759349322e-02,  -1.230636397754196e-03,   1.219813382189834e-05,  -8.522982363850894e-08,   1.472669160437896e-09,  -5.995006931575497e-12,
  -7.288465587812996e-13,  -1.465071738045444e-14,   5.036012735495582e-16,   2.319397765244520e-17,   9.106147008586848e-02,  -1.230686307904897e-03,   1.219985081850210e-05,
  -8.524177651166045e-08,   1.470552137617431e-09,  -6.053841690538759e-12,  -7.261022726308436e-13,  -1.449081165939137e-14,   5.028926801407584e-16,   2.294849184212229e-17,
   9.106284511914382e-02,  -1.230715113119251e-03,   1.220084135723111e-05,  -8.524869194813550e-08,   1.469331579088177e-09,  -6.087697722163268e-12,  -7.245190964342905e-13,
  -1.439878690146957e-14,   5.024780452803377e-16,   2.280719302129883e-17,   9.106336146732465e-02,  -1.230725929970001e-03,   1.220121324379410e-05,  -8.525129200990939e-08,
   1.468873477158313e-09,  -6.100392375183350e-12,  -7.239247130752660e-13,  -1.436427976555659e-14,   5.023212740212061e-16,   2.275420491028059e-17,   9.106344705992830e-02,
  -1.230727723028732e-03,   1.220127488559241e-05,  -8.525172317853345e-08,   1.468797552335361e-09,  -6.102495713739582e-12,  -7.238261916117061e-13,  -1.435856230136656e-14,
   5.022952305003933e-16,   2.274542511715727e-17,   1.806011580723212e-01,  -2.427770243327147e-03,   2.340708180150432e-05,  -1.479650278609239e-07,   2.656988601691476e-09,
  -6.935458907459821e-12,  -1.591184894291525e-12,  -3.105124797029604e-14,   1.049603833495217e-15,   5.022152304823460e-17,   1.806044935957964e-01,  -2.427833450511236e-03,
   2.340933151577920e-05,  -1.479756442688814e-07,   2.653641438990925e-09,  -7.024325085358923e-12,  -1.587023828474391e-12,  -3.080410646224324e-14,   1.048612214490053e-15,
   4.984171357096542e-17,   1.806099696259487e-01,  -2.427937218785564e-03,   2.341302273597992e-05,  -1.479931626019722e-07,   2.648152937822075e-09,  -7.169686041032006e-12,
  -1.580195800160960e-12,  -3.039977495350731e-14,   1.046953038714329e-15,   4.922019528738603e-17,   1.806157804276941e-01,  -2.428047329651617e-03,   2.341693662211903e-05,
  -1.480118726338561e-07,   2.642337920353644e-09,  -7.323210299490958e-12,  -1.572954907229613e-12,  -2.997263477657398e-14,   1.045150305231435e-15,   4.856343284302976e-17,
   1.806203537839468e-01,  -2.428133990901438e-03,   2.342001485724372e-05,  -1.480266854301645e-07,   2.637767772644454e-09,  -7.443518337904798e-12,  -1.567259345595679e-12,
  -2.963783612787206e-14,   1.043701197293403e-15,   4.804852234994833e-17,   1.806229932473302e-01,  -2.428184006177885e-03,   2.342179056024206e-05,  -1.480352693446598e-07,
   2.635132776321870e-09,  -7.512743898847974e-12,  -1.563973564284136e-12,  -2.944516255776513e-14,   1.042852796603074e-15,   4.775214450217629e-17,   1.806239844090963e-01,
  -2.428202787671799e-03,   2.342245720196995e-05,  -1.480384993265274e-07,   2.634143786221901e-09,  -7.538699793429796e-12,  -1.562739956325529e-12,  -2.937291465468870e-14,
   1.042531936771452e-15,   4.764100036451694e-17,   1.806241487092441e-01,  -2.428205900986990e-03,   2.342256769934007e-05,  -1.480390350921467e-07,   2.633979872130140e-09,
  -7.543000298709101e-12,  -1.562535480613504e-12,  -2.936094395803585e-14,   1.042478629752841e-15,   4.762258447516219e-17,   3.035670317328403e-01,  -4.047738303987838e-03,
   3.734984333099912e-05,  -1.949389780951969e-07,   3.775381666469130e-09,  -8.153438330780083e-13,  -2.982541216056129e-12,  -5.521415328038721e-14,   1.894412315057447e-15,
   9.129467153934640e-17,   3.035723533004150e-01,  -4.047821536778009e-03,   3.735303139631082e-05,  -1.949414647710513e-07,   3.769104273371914e-09,  -9.732078356035309e-13,
  -2.975029896242859e-12,  -5.476496887293804e-14,   1.892676260089812e-15,   9.060128039374913e-17,   3.035810898373464e-01,  -4.047958177952282e-03,   3.735826127590914e-05,
  -1.949457064740479e-07,   3.758810484770453e-09,  -1.231408897301230e-12,  -2.962704181093051e-12,  -5.403009997265638e-14,   1.889768154644475e-15,   8.946661187299557e-17,
   3.035903604164072e-01,  -4.048103166291743e-03,   3.736380535983571e-05,  -1.949504233828477e-07,   3.747903696756303e-09,  -1.504080829865908e-12,  -2.949632981329234e-12,
  -5.325379195705026e-14,   1.886604005472931e-15,   8.826759129105452e-17,   3.035976567279174e-01,  -4.048217273978268e-03,   3.736816480482852e-05,  -1.949542916830507e-07,
   3.739331373270286e-09,  -1.717736652605699e-12,  -2.939351260768123e-12,  -5.264532171420742e-14,   1.884057432768316e-15,   8.732753699676750e-17,   3.036018676990110e-01,
  -4.048283128203751e-03,   3.737067921230329e-05,  -1.949565865769434e-07,   3.734388676579505e-09,  -1.840666210601450e-12,  -2.933419659359358e-12,  -5.229515714203205e-14,
   1.882565294458770e-15,   8.678644779362203e-17,   3.036034489845367e-01,  -4.048307857205800e-03,   3.737162311137020e-05,  -1.949574601144992e-07,   3.732533506338306e-09,
  -1.886756620028613e-12,  -2.931192698937004e-12,  -5.216385479657202e-14,   1.882000752246557e-15,   8.658353443344614e-17,   3.036037111065131e-01,  -4.048311956396387e-03,
   3.737177956106946e-05,  -1.949576055370108e-07,   3.732226030761506e-09,  -1.894393029066056e-12,  -2.930823570324743e-12,  -5.214209946216515e-14,   1.881906948562161e-15,
   8.654991293386648e-17,   4.636987854219584e-01,  -6.106699791777402e-03,   5.244073795937572e-05,  -1.741944717300235e-07,   4.257887124335622e-09,   2.024819433368257e-11,
  -5.188972112384490e-12,  -9.325115888002233e-14,   3.233471136934309e-15,   1.557677714013054e-16,   4.637062553098469e-01,  -6.106774065784048e-03,   5.244431171271178e-05,
  -1.741678960802938e-07,   4.246962926687556e-09,   1.998169641493691e-11,  -5.176148730941037e-12,  -9.248503891342247e-14,   3.230641499805209e-15,   1.545741332282222e-16,
   4.637185186978366e-01,  -6.106895990908271e-03,   5.245017191392809e-05,  -1.741245369260785e-07,   4.229048838826718e-09,   1.954583112828016e-11,  -5.155105808725953e-12,
  -9.123170151120357e-14,   3.225893976620082e-15,   1.526208541559449e-16,   4.637315315866641e-01,  -6.107025352497613e-03,   5.245638095031033e-05,  -1.740788942982084e-07,
   4.210067441922281e-09,   1.908556021089491e-11,  -5.132789670271045e-12,  -8.990774355333191e-14,   3.220718494345437e-15,   1.505567913753892e-16,   4.637417731504123e-01,
  -6.107127153259631e-03,   5.246126091837250e-05,  -1.740432367110194e-07,   4.195148405827546e-09,   1.872492487358149e-11,  -5.115235584802100e-12,  -8.887006510580948e-14,
   3.216546176895501e-15,   1.489385252565923e-16,   4.637476838980691e-01,  -6.107185901479626e-03,   5.246407460902238e-05,  -1.740227633695380e-07,   4.186546122025691e-09,
   1.851743531898553e-11,  -5.105108360019538e-12,  -8.827291430577198e-14,   3.214098730230119e-15,   1.480070607815657e-16,   4.637499034692200e-01,  -6.107207961456551e-03,
   5.246513068012696e-05,  -1.740150953104412e-07,   4.183317349866397e-09,   1.843964176540599e-11,  -5.101306168110365e-12,  -8.804900176303536e-14,   3.213172248093031e-15,
   1.476577530039057e-16,   4.637502713963133e-01,  -6.107211618183775e-03,   5.246530571277729e-05,  -1.740138252681876e-07,   4.182782212258186e-09,   1.842675274124874e-11,
  -5.100675936457744e-12,  -8.801190211166784e-14,   3.213018278529013e-15,   1.475998748397002e-16,   6.668753704682882e-01,  -8.611042401155481e-03,   6.503255911468032e-05,
   2.422622232718313e-08,   3.095772271671173e-09,   6.314452561258240e-11,  -8.589665012353422e-12,  -1.608559105912835e-13,   5.539603487120558e-15,   2.630772906558815e-16,
   6.668846301873445e-01,  -8.611031755397215e-03,   6.503510014385502e-05,   2.431221512628604e-08,   3.077697542871409e-09,   6.268436917338302e-11,  -8.567692330438684e-12,
  -1.595628363312308e-13,   5.534932824803543e-15,   2.610301820369653e-16,   6.668998317602682e-01,  -8.611014253022169e-03,   6.503926058277278e-05,   2.445292142003818e-08,
   3.048058794511627e-09,   6.193170554720840e-11,  -8.531635096659866e-12,  -1.574475441779615e-13,   5.527085348075833e-15,   2.576803311829745e-16,   6.669159621371424e-01,
  -8.610995646878712e-03,   6.504366009404383e-05,   2.460159150296958e-08,   3.016655775900411e-09,   6.113681031009527e-11,  -8.493395542612872e-12,  -1.552132249025431e-13,
   5.518515813269908e-15,   2.541405628194532e-16,   6.669286570692179e-01,  -8.610980978630677e-03,   6.504711165504090e-05,   2.471814058432207e-08,   2.991974718747836e-09,
   6.051392383128687e-11,  -8.463315480512790e-12,  -1.534621494467373e-13,   5.511597071292723e-15,   2.513653701621417e-16,   6.669359836590956e-01,  -8.610972503250037e-03,
   6.504909926109878e-05,   2.478522132558332e-08,   2.977744136318924e-09,   6.015552398375924e-11,  -8.445961639481341e-12,  -1.524545083578796e-13,   5.507534615205093e-15,
   2.497680084280487e-16,   6.669387348846394e-01,  -8.610969318763508e-03,   6.504984480371655e-05,   2.481037645577073e-08,   2.972402931775591e-09,   6.002114516053804e-11,
  -8.439446232881616e-12,  -1.520766838985050e-13,   5.505996033706844e-15,   2.491689874078171e-16,   6.669391909406128e-01,  -8.610968790789274e-03,   6.504996834465694e-05,
   2.481454446742209e-08,   2.971517683636149e-09,   5.999888069628657e-11,  -8.438366270969089e-12,  -1.520140833374404e-13,   5.505740302528349e-15,   2.490697335175800e-16,
   9.226985186672713e-01,  -1.151097118588431e-02,   6.554726378276413e-05,   6.595657188572664e-07,  -9.838690675164376e-10,   1.003863943019236e-10,  -1.332479840134170e-11,
  -3.069756449635076e-13,   1.006695963830499e-14,   4.722471278632349e-16,   9.227078445141208e-01,  -1.151068912563385e-02,   6.554626547876113e-05,   6.597011752182687e-07,
  -1.011838574002661e-09,   9.950587698489317e-11,  -1.328489097404008e-11,  -3.046561909072749e-13,   1.005737561643013e-14,   4.685072081917961e-16,   9.227231542735596e-01,
  -1.151022603798712e-02,   6.554460949039829e-05,   6.599226583253928e-07,  -1.057693588787143e-09,   9.806531066918097e-11,  -1.321940598447346e-11,  -3.008621274022491e-13,
   1.004130796886452e-14,   4.623877407129929e-16,   9.227393989374739e-01,  -1.150973461185210e-02,   6.554282912447752e-05,   6.601564616033735e-07,  -1.106265804971012e-09,
   9.654346352117777e-11,  -1.314996197445099e-11,  -2.968549053888714e-13,   1.002380828414631e-14,   4.559219739455402e-16,   9.227521834465557e-01,  -1.150934781766419e-02,
   6.554141116115946e-05,   6.603395939690724e-07,  -1.144431959884731e-09,   9.535060382464872e-11,  -1.309533899160385e-11,  -2.937146154758103e-13,   1.000971211831724e-14,
   4.508532528862113e-16,   9.227595615856802e-01,  -1.150912457548417e-02,   6.554058609548825e-05,   6.604449343903780e-07,  -1.166434175969273e-09,   9.466411793100550e-11,
  -1.306382708503034e-11,  -2.919076595075397e-13,   1.000144795303979e-14,   4.479359564543619e-16,   9.227623321406093e-01,  -1.150904074286445e-02,   6.554027500347357e-05,
   6.604844249145727e-07,  -1.174691650223029e-09,   9.440670122615360e-11,  -1.305199635065291e-11,  -2.912301426833156e-13,   9.998320392255722e-15,   4.468419869981412e-16,
   9.227627913992346e-01,  -1.150902684625166e-02,   6.554022336844952e-05,   6.604909675623141e-07,  -1.176060203356440e-09,   9.436404999636783e-11,  -1.305003535879951e-11,
  -2.911178879871880e-13,   9.997800675517670e-15,   4.466607252523748e-16,   1.248101110187070e+00,  -1.446572665437472e-02,   2.253630271603633e-05,   2.418282615352563e-06,
  -2.111624027356377e-09,  -2.465914077279828e-10,  -1.774257674144965e-11,  -6.280480538750882e-13,   1.894314646271878e-14,   1.076989045859057e-15,   1.248104313218614e+00,
  -1.446469553213751e-02,   2.253429060670435e-05,   2.417916635744017e-06,  -2.148609864212510e-09,  -2.483843548264666e-10,  -1.766776774454788e-11,  -6.227655246905312e-13,
   1.891140587982295e-14,   1.068189476997040e-15,   1.248109571273188e+00,  -1.446300289447385e-02,   2.253096485967443e-05,   2.417314011480303e-06,  -2.209213049421047e-09,
  -2.513165093748046e-10,  -1.754505195917103e-11,  -6.141255947594595e-13,   1.885862004058085e-14,   1.053794800094848e-15,   1.248115150147983e+00,  -1.446120703353319e-02,
   2.252740538468587e-05,   2.416672127555753e-06,  -2.273361431039473e-09,  -2.544124888720987e-10,  -1.741497158111458e-11,  -6.050016154259319e-13,   1.880169550908471e-14,
   1.038590516132055e-15,   1.248119540513696e+00,  -1.445979379648241e-02,   2.252458193410585e-05,   2.416165190405809e-06,  -2.323733457878307e-09,  -2.568380197857170e-10,
  -1.731269298310133e-11,  -5.978525209733359e-13,   1.875623922655154e-14,   1.026674996750497e-15,   1.248122074183856e+00,  -1.445897823589773e-02,   2.252294360676192e-05,
   2.415871918723018e-06,  -2.352758830603473e-09,  -2.582334330101068e-10,  -1.725370449012408e-11,  -5.937392488202762e-13,   1.872974433405770e-14,   1.019818477545120e-15,
   1.248123025584062e+00,  -1.445867199352067e-02,   2.252232672533870e-05,   2.415761658598137e-06,  -2.363649585418899e-09,  -2.587565925355330e-10,  -1.723156103041797e-11,
  -5.921970544647058e-13,   1.871974610068857e-14,   1.017247594988605e-15,   1.248123183291307e+00,  -1.445862122992408e-02,   2.252222438017245e-05,   2.415743374356047e-06,
  -2.365454432335771e-09,  -2.588432698509736e-10,  -1.722789082121091e-11,  -5.919415391660732e-13,   1.871808616372435e-14,   1.016821635279759e-15,   1.673778109712061e+00,
  -1.484405881997341e-02,  -2.124914317319917e-04,   5.318130674461247e-06,   2.011210436335976e-07,  -3.180266379911076e-09,  -2.314869487309561e-10,   9.863308766598062e-13,
   2.604410718192121e-13,   1.875266912909429e-15,   1.673748210426173e+00,  -1.484180428414704e-02,  -2.123224322105593e-04,   5.313631071545803e-06,   2.006387868343407e-07,
  -3.177183435975090e-09,  -2.304829927570186e-10,   9.949256137329072e-13,   2.588032442273026e-13,   1.837088206090595e-15,   1.673699142856946e+00,  -1.483810448085165e-02,
  -2.120452860081014e-04,   5.306247471151183e-06,   1.998486153112527e-07,  -3.172104368379789e-09,  -2.288394985658695e-10,   1.008897653174360e-12,   2.561240564795927e-13,
   1.774910883452630e-15,   1.673647101390687e+00,  -1.483418058147537e-02,  -2.117516113403963e-04,   5.298417294630054e-06,   1.990122591870501e-07,  -3.166690895699842e-09,
  -2.271019452645016e-10,   1.023537036982875e-12,   2.532942076105443e-13,   1.709610517793409e-15,   1.673606161135756e+00,  -1.483109381123346e-02,  -2.115207762282114e-04,
   5.292258093684168e-06,   1.983555432144819e-07,  -3.162413075801959e-09,  -2.257390465295241e-10,   1.034924398052267e-12,   2.510764719769030e-13,   1.658704166781769e-15,
   1.673582540385117e+00,  -1.482931292045063e-02,  -2.113876722422473e-04,   5.288704779237677e-06,   1.979771401297806e-07,  -3.159937333246183e-09,  -2.249543169646624e-10,
   1.041442844369502e-12,   2.498003212393816e-13,   1.629518686072000e-15,   1.673573671818779e+00,  -1.482864428118627e-02,  -2.113377121815328e-04,   5.287370716721688e-06,
   1.978351593981733e-07,  -3.159006362517637e-09,  -2.246599878724917e-10,   1.043880518736326e-12,   2.493218213551130e-13,   1.618595716573436e-15,   1.673572201793446e+00,
  -1.482853345008724e-02,  -2.113294317365235e-04,   5.287149589558703e-06,   1.978116300385122e-07,  -3.158851972079595e-09,  -2.246112167837822e-10,   1.044284067812765e-12,
   2.492425404452147e-13,   1.616786999044261e-15,   3.412664652848074e-03,  -4.508382009636572e-05,   4.568778845548720e-07,  -2.817864535702028e-09,   4.997791020717331e-11,
  -1.058297794429968e-12,  -3.027992057695257e-14,   4.472584207516478e-16,   3.966763933454046e-17,  -3.381311130860045e-20,   3.412729755022226e-03,  -4.508502838356050e-05,
   4.569202028234405e-07,  -2.819359326038899e-09,   4.991508249196180e-11,  -1.056965415314571e-12,  -3.012708078307271e-14,   4.470036570693100e-16,   3.941464995500701e-17,
  -3.689663187040862e-20,   3.412836635076925e-03,  -4.508701244121985e-05,   4.569896369093889e-07,  -2.821811897775546e-09,   4.981217367593989e-11,  -1.054778701639739e-12,
  -2.987688944582384e-14,   4.465743743854623e-16,   3.900084152239664e-17,  -4.190943662898573e-20,   3.412950048917513e-03,  -4.508911830290288e-05,   4.570632600009629e-07,
  -2.824412406383680e-09,   4.970329559499927e-11,  -1.052459260772605e-12,  -2.961239315767018e-14,   4.461039570213636e-16,   3.856381150264203e-17,  -4.716181730763695e-20,
   3.413039310434313e-03,  -4.509077607812179e-05,   4.571211642883083e-07,  -2.826457674243886e-09,   4.961783638438555e-11,  -1.050634460554286e-12,  -2.940493802031841e-14,
   4.457230139570061e-16,   3.822134830746215e-17,  -5.124756723219900e-20,   3.413090826695513e-03,  -4.509173299334483e-05,   4.571545669839934e-07,  -2.827637498841375e-09,
   4.956860760592005e-11,  -1.049581581239575e-12,  -2.928549352373862e-14,   4.454988915251692e-16,   3.802429857455973e-17,  -5.358643498123043e-20,   3.413110171884065e-03,
  -4.509209235867887e-05,   4.571671071954475e-07,  -2.828080432754274e-09,   4.955013896773479e-11,  -1.049186261959654e-12,  -2.924069414063413e-14,   4.454139267240991e-16,
   3.795041624865781e-17,  -5.446110547190517e-20,   3.413113378642860e-03,  -4.509215193042838e-05,   4.571691857656023e-07,  -2.828153850012069e-09,   4.954707843656734e-11,
  -1.049120734639088e-12,  -2.923327080709302e-14,   4.453998002188554e-16,   3.793817508971054e-17,  -5.460590513276061e-20,   3.083219816487554e-02,  -4.068908650298687e-04,
   4.098871670070847e-06,  -2.456648428533077e-08,   4.400531878019845e-10,  -9.476407955746797e-12,  -2.800889768922860e-13,   4.135016332893091e-15,   3.637426464182745e-16,
  -3.084615650386728e-19,   3.083278221335935e-02,  -4.069014002589252e-04,   4.099244121544579e-06,  -2.457986594186242e-08,   4.394718855643902e-10,  -9.464089378790596e-12,
  -2.786875783248109e-13,   4.132685462323688e-15,   3.614176754457656e-16,  -3.368482170040145e-19,   3.083374106128544e-02,  -4.069186996478478e-04,   4.099855207422471e-06,
  -2.460182144385116e-08,   4.385197206254183e-10,  -9.443871954302048e-12,  -2.763935717452203e-13,   4.128757270548759e-15,   3.576147939221182e-16,  -3.829948961119389e-19,
   3.083475852442433e-02,  -4.069370612140637e-04,   4.100503137055024e-06,  -2.462510073541824e-08,   4.375122985286654e-10,  -9.422427315166160e-12,  -2.739684232816342e-13,
   4.124451856658477e-15,   3.535985282611033e-16,  -4.313459494245801e-19,   3.083555931044934e-02,  -4.069515158997990e-04,   4.101012714314208e-06,  -2.464340921472333e-08,
   4.367215462872294e-10,  -9.405555874084339e-12,  -2.720662959679986e-13,   4.120964774641317e-15,   3.504513383907543e-16,  -4.689567254213250e-19,   3.083602147462539e-02,
  -4.069598595991267e-04,   4.101306662497622e-06,  -2.465397040826010e-08,   4.362660257536207e-10,  -9.395821311531285e-12,  -2.709711318858450e-13,   4.118912980681465e-15,
   3.486404844928105e-16,  -4.904865110306362e-19,   3.083619502468530e-02,  -4.069629930468594e-04,   4.101417016747415e-06,  -2.465793529879694e-08,   4.360951314934990e-10,
  -9.392166320266076e-12,  -2.705603758995465e-13,   4.118135105329951e-15,   3.479615195120601e-16,  -4.985379821193554e-19,   3.083622379324043e-02,  -4.069635124767963e-04,
   4.101435308161423e-06,  -2.465859248642928e-08,   4.360668116669341e-10,  -9.391560476117882e-12,  -2.704923129968617e-13,   4.118005771312148e-15,   3.478490255752262e-16,
  -4.998708811817492e-19,   8.631871838985143e-02,  -1.136638137253834e-03,   1.130512211449312e-05,  -6.351315342925375e-08,   1.164518487627404e-09,  -2.604975115614628e-11,
  -8.221918768903225e-13,   1.212618515014193e-14,   1.050413250302840e-15,  -8.871021317435160e-19,   8.632032917175533e-02,  -1.136665382248370e-03,   1.130610678279616e-05,
  -6.354991922964849e-08,   1.162811295836249e-09,  -2.601362444990758e-11,  -8.181455328481212e-13,   1.211945620375396e-14,   1.043669844277547e-15,  -9.697126703941957e-19,
   8.632297363076956e-02,  -1.136710120591137e-03,   1.130772223675408e-05,  -6.361023913313842e-08,   1.160014833492399e-09,  -2.595433254183654e-11,  -8.115219928044531e-13,
   1.210811364892341e-14,   1.032639968292125e-15,  -1.104003146638538e-18,   8.632577974180045e-02,  -1.136757606748039e-03,   1.130943494901975e-05,  -6.367419278964494e-08,
   1.157055939292044e-09,  -2.589144123387030e-11,  -8.045199202520085e-13,   1.209567881813583e-14,   1.020991328942673e-15,  -1.244701596108015e-18,   8.632798826408777e-02,
  -1.136794989688484e-03,   1.131078184385981e-05,  -6.372448815339534e-08,   1.154733320409258e-09,  -2.584196163286096e-11,  -7.990280384043471e-13,   1.208560536191711e-14,
   1.011863425618486e-15,  -1.354141513628907e-18,   8.632926288481979e-02,  -1.136816568556402e-03,   1.131155875538970e-05,  -6.375349996286976e-08,   1.153395311188632e-09,
  -2.581341256474175e-11,  -7.958660800207430e-13,   1.207967733714239e-14,   1.006611383046493e-15,  -1.416786916784641e-18,   8.632974152501217e-02,  -1.136824672475273e-03,
   1.131185041637555e-05,  -6.376439142119611e-08,   1.152893332249630e-09,  -2.580269335935460e-11,  -7.946801514895014e-13,   1.207742975588663e-14,   1.004642179743126e-15,
  -1.440213970539442e-18,   8.632982086686727e-02,  -1.136826015860100e-03,   1.131189875929716e-05,  -6.376619669047296e-08,   1.152810146143003e-09,  -2.580091656401528e-11,
  -7.944836416337421e-13,   1.207705605227978e-14,   1.004315913777919e-15,  -1.444092235211982e-18,   1.712543330928099e-01,  -2.246918351271157e-03,   2.187467474613635e-05,
  -1.088449751834836e-07,   2.092176446123748e-09,  -5.024143897483735e-11,  -1.752587050819678e-12,   2.581271141555335e-14,   2.191166982289830e-15,  -1.872987771855346e-18,
   1.712574495703705e-01,  -2.246965069760951e-03,   2.187644055734702e-05,  -1.089158233701771e-07,   2.088535182735537e-09,  -5.016453491420961e-11,  -1.744148220509626e-12,
   2.579850939934257e-14,   2.177009590365427e-15,  -2.047229786551158e-18,   1.712625659511728e-01,  -2.247041787435057e-03,   2.187933720664994e-05,  -1.090320531403760e-07,
   2.082570324856700e-09,  -5.003831806508541e-11,  -1.730334797973017e-12,   2.577457051774541e-14,   2.153853372782303e-15,  -2.330456524091171e-18,   1.712679950691572e-01,
  -2.247123220312351e-03,   2.188240776857596e-05,  -1.091552745705070e-07,   2.076258600865904e-09,  -4.990443863849715e-11,  -1.715732303323970e-12,   2.574832710725973e-14,
   2.129398621365917e-15,  -2.627172942803323e-18,   1.712722679890422e-01,  -2.247187329760052e-03,   2.188482214326349e-05,  -1.092521727832735e-07,   2.071303849621936e-09,
  -4.979910899041107e-11,  -1.704279500562530e-12,   2.572706787901098e-14,   2.110236180466332e-15,  -2.857950618447000e-18,   1.712747340449824e-01,  -2.247224337128796e-03,
   2.188621465589356e-05,  -1.093080634959380e-07,   2.068449411287557e-09,  -4.973833507079456e-11,  -1.697685638055700e-12,   2.571455747991613e-14,   2.099210579224119e-15,
  -2.990044664350936e-18,   1.712756600867979e-01,  -2.247238235379927e-03,   2.188673739388522e-05,  -1.093290451290422e-07,   2.067378493926032e-09,  -4.971551650508784e-11,
  -1.695212554451254e-12,   2.570981426685715e-14,   2.095076662742951e-15,  -3.039441548475770e-18,   1.712758135921849e-01,  -2.247240539299239e-03,   2.188682403652281e-05,
  -1.093325228245970e-07,   2.067201024274091e-09,  -4.971173414129617e-11,  -1.694802762412446e-12,   2.570902561873252e-14,   2.094391739363628e-15,  -3.047618952361534e-18,
   2.879602744948814e-01,  -3.757298212253917e-03,   3.535881682373322e-05,  -1.389183255286362e-07,   2.965430452588333e-09,  -8.133246118838393e-11,  -3.247205737817696e-12,
   4.775434153327457e-14,   3.970640976528608e-15,  -3.594234463474047e-18,   2.879653113286975e-01,  -3.757357923973942e-03,   3.536131068046410e-05,  -1.390328668797209e-07,
   2.958679773216539e-09,  -8.119019560307559e-11,  -3.231918012348119e-12,   4.772747159116438e-14,   3.944772632273589e-15,  -3.914150090493244e-18,   2.879735803572715e-01,
  -3.757455985492267e-03,   3.536540064096640e-05,  -1.392207589154987e-07,   2.947620744746341e-09,  -8.095670704839344e-11,  -3.206894335608771e-12,   4.768221501304210e-14,
   3.902462793164143e-15,  -4.434109985027422e-18,   2.879823547762231e-01,  -3.757560083975858e-03,   3.536973482856371e-05,  -1.394199283240252e-07,   2.935917871565259e-09,
  -8.070904517661646e-11,  -3.180442061023887e-12,   4.763264827532956e-14,   3.857781877728682e-15,  -4.978758508890598e-18,   2.879892605364404e-01,  -3.757642044498341e-03,
   3.537314182546140e-05,  -1.395765319605348e-07,   2.926730487579173e-09,  -8.051419839402761e-11,  -3.159696032532121e-12,   4.759252780168525e-14,   3.822771577114833e-15,
  -5.402315531749727e-18,   2.879932460844113e-01,  -3.757689359329048e-03,   3.537510645596453e-05,  -1.396668533756676e-07,   2.921437407621948e-09,  -8.040177466508199e-11,
  -3.147751911796332e-12,   4.756893074751437e-14,   3.802627949701464e-15,  -5.644731704450542e-18,   2.879947427159572e-01,  -3.757707129128044e-03,   3.537584388942457e-05,
  -1.397007590783179e-07,   2.919451528940493e-09,  -8.035956342166303e-11,  -3.143272215043416e-12,   4.755998645331546e-14,   3.795075423349902e-15,  -5.735379610844868e-18,
   2.879949908050421e-01,  -3.757710074864228e-03,   3.537596611350070e-05,  -1.397063788595491e-07,   2.919122432104141e-09,  -8.035256656781296e-11,  -3.142529927951538e-12,
   4.755849941834675e-14,   3.793824095823955e-15,  -5.750385690597610e-18,   4.400994154111089e-01,  -5.694393594479702e-03,   5.074882524945532e-05,  -1.102098476669148e-07,
   3.286897230891355e-09,  -1.192060076992396e-10,  -5.612901924486292e-12,   8.248396168910685e-14,   6.770860332475311e-15,  -7.101639280768623e-18,   4.401066428517276e-01,
  -5.694441237074161e-03,   5.075156576224437e-05,  -1.103774133098967e-07,   3.275224125269776e-09,  -1.189603513971024e-10,  -5.586841879877949e-12,   8.243299449149927e-14,
   6.726306606885305e-15,  -7.653566825878787e-18,   4.401185081369526e-01,  -5.694519501326473e-03,   5.075605765096444e-05,  -1.106522471323808e-07,   3.256100553608188e-09,
  -1.185571861998068e-10,  -5.544186841531330e-12,   8.234734908494107e-14,   6.653438527909049e-15,  -8.550448221190184e-18,   4.401310984906280e-01,  -5.694602615321336e-03,
   5.076081424691334e-05,  -1.109435242359996e-07,   3.235862843203372e-09,  -1.181295612992424e-10,  -5.499098373166224e-12,   8.225380751329996e-14,   6.576491292848155e-15,
  -9.489686846326960e-18,   4.401410074320146e-01,  -5.694668076812455e-03,   5.076455073994914e-05,  -1.111725126908158e-07,   3.219974584052399e-09,  -1.177931391698307e-10,
  -5.463737580247805e-12,   8.217827448532121e-14,   6.516201509080935e-15,  -1.021993950365183e-17,   4.401467261827359e-01,  -5.694705876087001e-03,   5.076670435144615e-05,
  -1.113045669514413e-07,   3.210820734835085e-09,  -1.175990324345892e-10,  -5.443379797423048e-12,   8.213391984349458e-14,   6.481514288808240e-15,  -1.063782165786153e-17,
   4.401488736506890e-01,  -5.694720073901114e-03,   5.076751252672426e-05,  -1.113541358437941e-07,   3.207386314169761e-09,  -1.175261527665671e-10,  -5.435744613505692e-12,
   8.211712056703011e-14,   6.468509120816267e-15,  -1.079406986782107e-17,   4.401492296253054e-01,  -5.694722427593025e-03,   5.076764646553953e-05,  -1.113623516057209e-07,
   3.206817164842856e-09,  -1.175140724128933e-10,  -5.434479466259184e-12,   8.211432828098425e-14,   6.466354394403022e-15,  -1.081993492045741e-17,   6.334747795570376e-01,
  -8.088759579375590e-03,   6.562277604816969e-05,   7.159540669564098e-08,   2.070399975000194e-09,  -1.690545408065528e-10,  -9.365954927183551e-12,   1.381749149711057e-13,
   1.147211166250772e-14,  -1.597957051017045e-17,   6.334841214919505e-01,  -8.088729850706052e-03,   6.562443378847996e-05,   7.135829956753847e-08,   2.050929338648664e-09,
  -1.686433628772205e-10,  -9.321819729066570e-12,   1.380683579919068e-13,   1.139567941947033e-14,  -1.691452544254756e-17,   6.334994579435000e-01,  -8.088681118634405e-03,
   6.562714338614672e-05,   7.096947200048558e-08,   2.019032397849056e-09,  -1.679685936414412e-10,  -9.249582030948920e-12,   1.378900868925394e-13,   1.127068333203881e-14,
  -1.843326625518316e-17,   6.335157313119439e-01,  -8.088629508399479e-03,   6.563000239412568e-05,   7.055746949987969e-08,   1.985278508164929e-09,  -1.672529493679618e-10,
  -9.173226925621166e-12,   1.376964195250716e-13,   1.113870303077336e-14,  -2.002297322117284e-17,   6.335285386885552e-01,  -8.088588961960103e-03,   6.563224082033725e-05,
   7.023363655266244e-08,   1.958779929710270e-09,  -1.666899813335904e-10,  -9.113347820297066e-12,   1.375407635573720e-13,   1.103530312465702e-14,  -2.125841052457732e-17,
   6.335359301360564e-01,  -8.088565590293769e-03,   6.563352800453793e-05,   7.004691261498064e-08,   1.943513455045140e-09,  -1.663651817804017e-10,  -9.078875510376347e-12,
   1.374496414529632e-13,   1.097581664173168e-14,  -2.196515988330444e-17,   6.335387057094176e-01,  -8.088556819380860e-03,   6.563401047578472e-05,   6.997682736418058e-08,
   1.937785721219234e-09,  -1.662432353950595e-10,  -9.065946875598707e-12,   1.374151813509550e-13,   1.095351428093489e-14,  -2.222937504843071e-17,   6.335391658010281e-01,
  -8.088555365760277e-03,   6.563409040593383e-05,   6.996521138940441e-08,   1.936836529892166e-09,  -1.662230220454132e-10,  -9.063804616022779e-12,   1.374094563084182e-13,
   1.094981921176368e-14,  -2.227311054516342e-17,   8.777531845558755e-01,  -1.095517301864524e-02,   7.337157895326300e-05,   6.404315001410330e-07,  -2.620403375073367e-09,
  -2.719157165811165e-10,  -1.518844563424881e-11,   2.314918060492345e-13,   2.048220283531267e-14,  -4.391181603257863e-17,   8.777636210103185e-01,  -1.095490094975936e-02,
   7.336916358035822e-05,   6.400503441802960e-07,  -2.651893654083226e-09,  -2.712282622592063e-10,  -1.510971401332749e-11,   2.312248655689895e-13,   2.034246481891047e-14,
  -4.550350195761145e-17,   8.777807538631519e-01,  -1.095445442089440e-02,   7.336517921450208e-05,   6.394253202034473e-07,  -2.703470096392518e-09,  -2.701002979927165e-10,
  -1.498086054455898e-11,   2.307809702106375e-13,   2.011397171291865e-14,  -4.808667851524655e-17,   8.777989327678691e-01,  -1.095398077712108e-02,   7.336092552098417e-05,
   6.387630795540337e-07,  -2.758034002398977e-09,  -2.689042671557670e-10,  -1.484467549816933e-11,   2.303023171917380e-13,   1.987275513909969e-14,  -5.078735447804805e-17,
   8.778132393881672e-01,  -1.095360813118667e-02,   7.335755906770321e-05,   6.382425860917145e-07,  -2.800858555105623e-09,  -2.679635880727016e-10,  -1.473788588190173e-11,
   2.299201254582393e-13,   1.968380567468710e-14,  -5.288385386431196e-17,   8.778214959087081e-01,  -1.095339311567900e-02,   7.335560870638391e-05,   6.379424769967357e-07,
  -2.825526416493296e-09,  -2.674209473548455e-10,  -1.467641096197882e-11,   2.296973699682542e-13,   1.957511472837581e-14,  -5.408225102238851e-17,   8.778245962934902e-01,
  -1.095331238386097e-02,   7.335487490706868e-05,   6.378298355547235e-07,  -2.834780565635255e-09,  -2.672172266061981e-10,  -1.465335585742863e-11,   2.296133118522926e-13,
   1.953436727220106e-14,  -5.453008935927213e-17,   8.778251102255490e-01,  -1.095329900186243e-02,   7.335475319448706e-05,   6.378111663931158e-07,  -2.836314105206056e-09,
  -2.671834594201324e-10,  -1.464953569055393e-11,   2.295993563669392e-13,   1.952761633378405e-14,  -5.460421060754470e-17,   1.190781051025473e+00,  -1.417048134183424e-02,
   5.110285062100828e-05,   2.317584959855680e-06,  -1.223298862964485e-08,  -7.829723306339078e-10,  -2.187366237560935e-11,   4.577398913384197e-13,   4.146781053743749e-14,
  -1.568510681831962e-16,   1.190788301818905e+00,  -1.416949580759440e-02,   5.109215256710797e-05,   2.316482150877107e-06,  -1.227780422011929e-08,  -7.816184088285579e-10,
  -2.171494089952250e-11,   4.568709799405809e-13,   4.115190835742471e-14,  -1.593427639220322e-16,   1.190800204029794e+00,  -1.416787823121763e-02,   5.107456291355628e-05,
   2.314673098101341e-06,  -1.235113482140794e-08,  -7.793976451140696e-10,  -2.145527086610542e-11,   4.554357528129354e-13,   4.063554323846862e-14,  -1.633723750225339e-16,
   1.190812831644710e+00,  -1.416616231622022e-02,   5.105586222595079e-05,   2.312755436742744e-06,  -1.242861686534073e-08,  -7.770438600011827e-10,  -2.118095642736727e-11,
   4.539010697455418e-13,   4.009067303472567e-14,  -1.675659605315536e-16,   1.190822768520128e+00,  -1.416481221392487e-02,   5.104111817352946e-05,   2.311247589979676e-06,
  -1.248935918866219e-08,  -7.751933212313919e-10,  -2.096594685882207e-11,   4.526848197925356e-13,   3.966404515249342e-14,  -1.708073597149366e-16,   1.190828502834372e+00,
  -1.416403317644120e-02,   5.103259848553040e-05,   2.310377928119862e-06,  -1.252432018260495e-08,  -7.741261042893550e-10,  -2.084221141069647e-11,   4.519795433787922e-13,
   3.941870415323667e-14,  -1.726545580750558e-16,   1.190830656041130e+00,  -1.416374066524146e-02,   5.102939725558788e-05,   2.310051464607709e-06,  -1.253743052820908e-08,
  -7.737254986431614e-10,  -2.079581371312638e-11,   4.517140746496393e-13,   3.932674109855733e-14,  -1.733437815066167e-16,   1.190831012961471e+00,  -1.416369217864829e-02,
   5.102886650032872e-05,   2.309997354049172e-06,  -1.253960281426622e-08,  -7.736591001760881e-10,  -2.078812612002506e-11,   4.516700362395675e-13,   3.931150559889734e-14,
  -1.734577975624797e-16,   1.611474715454524e+00,  -1.624069442847764e-02,  -1.323764123863060e-04,   7.751713190228561e-06,   8.903559759924161e-08,  -7.480958529154023e-09,
  -9.317479404036904e-11,   8.133785456405874e-12,   1.185303242569578e-13,  -9.076332849276122e-15,   1.611456027978848e+00,  -1.623742192171991e-02,  -1.323014838374182e-04,
   7.741265852724232e-06,   8.884204930114510e-08,  -7.457358427951466e-09,  -9.272255637365496e-11,   8.089273813444375e-12,   1.175553500255001e-13,  -9.001728035216153e-15,
   1.611425356995259e+00,  -1.623205274965887e-02,  -1.321785942579177e-04,   7.724138839039741e-06,   8.852499560449665e-08,  -7.418709906121064e-09,  -9.198289246266744e-11,
   8.016472234333260e-12,   1.159635896841316e-13,  -8.879884480051659e-15,   1.611392822941535e+00,  -1.622635995750701e-02,  -1.320483587334398e-04,   7.705998294013610e-06,
   8.818950873479417e-08,  -7.377829447120700e-09,  -9.120178570346125e-11,   7.939591837761847e-12,   1.142865328315108e-13,  -8.751454572288884e-15,   1.611367225872376e+00,
  -1.622188282078017e-02,  -1.319459782244731e-04,   7.691745108341807e-06,   8.792615151333763e-08,  -7.345749178859763e-09,  -9.058974321801740e-11,   7.879351798237036e-12,
   1.129752665687202e-13,  -8.650995964095204e-15,   1.611352456268715e+00,  -1.621930022749886e-02,  -1.318869386833859e-04,   7.683528729985405e-06,   8.777443197433658e-08,
  -7.327272172915837e-09,  -9.023759734871809e-11,   7.844692087772286e-12,   1.122219355982206e-13,  -8.593265432907235e-15,   1.611346910695987e+00,  -1.621833067415765e-02,
  -1.318647774838649e-04,   7.680445175899717e-06,   8.771751056426046e-08,  -7.320340884363408e-09,  -9.010556599509636e-11,   7.831697017189441e-12,   1.119396981338951e-13,
  -8.571633441652026e-15,   1.611345991467484e+00,  -1.621816996926664e-02,  -1.318611044084864e-04,   7.679934126414350e-06,   8.770807770322939e-08,  -7.319192293692858e-09,
  -9.008369060320776e-11,   7.829543952133230e-12,   1.118929472590125e-13,  -8.568050074268463e-15,   3.239442046233220e-03,  -4.155229445253665e-05,   4.270525936235895e-07,
  -2.220321375387057e-09,   2.325312788513364e-11,  -1.504082967134685e-12,  -2.480633403986249e-15,   1.377181774733204e-15,   9.643803010488833e-18,  -1.460071074410665e-18,
   3.239502858826165e-03,  -4.155324979296126e-05,   4.270724208251210e-07,  -2.222428115110385e-09,   2.324826419360427e-11,  -1.500081525178290e-12,  -2.444084383054485e-15,
   1.369998244776696e-15,   9.552514580622004e-18,  -1.448945132181962e-18,   3.239602694577658e-03,  -4.155481878117631e-05,   4.271049675204417e-07,  -2.225882600868866e-09,
   2.324033505727799e-11,  -1.493527835643626e-12,  -2.384341309020242e-15,   1.358245859555462e-15,   9.403496705991253e-18,  -1.430767139536412e-18,   3.239708630796514e-03,
  -4.155648447120376e-05,   4.271394982045737e-07,  -2.229542556427095e-09,   2.323199670963135e-11,  -1.486594644990958e-12,  -2.321298694227854e-15,   1.345830595570930e-15,
   9.246522589731321e-18,  -1.411596686925861e-18,   3.239792005163290e-03,  -4.155779600902732e-05,   4.271666712431963e-07,  -2.232418970155446e-09,   2.322548857687235e-11,
  -1.481153195891140e-12,  -2.271935770481648e-15,   1.336099348066610e-15,   9.123808045066725e-18,  -1.396594344884465e-18,   3.239840122944722e-03,  -4.155855317592189e-05,
   4.271823522210006e-07,  -2.234077407364344e-09,   2.322175427317712e-11,  -1.478018833076770e-12,  -2.243548115251777e-15,   1.330499095819698e-15,   9.053316314980850e-18,
  -1.387970106973604e-18,   3.239858191802097e-03,  -4.155883754737557e-05,   4.271882403740748e-07,  -2.234699865364004e-09,   2.322035609371910e-11,  -1.476842982011203e-12,
  -2.232907252716658e-15,   1.328399134190111e-15,   9.026908028008694e-18,  -1.384738013580486e-18,   3.239861186981857e-03,  -4.155888468853326e-05,   4.271892164086627e-07,
  -2.234803030779450e-09,   2.322012454099838e-11,  -1.476648127619462e-12,  -2.231144377966007e-15,   1.328051193033034e-15,   9.022533746173408e-18,  -1.384202584765923e-18,
   2.926849694764724e-02,  -3.751758776526966e-04,   3.839043546701470e-06,  -1.934525260929632e-08,   1.990447685407788e-10,  -1.361130684379930e-11,  -2.427136712529297e-14,
   1.265634268895014e-14,   8.789172780159524e-17,  -1.341413867848635e-17,   2.926904361297282e-02,  -3.751842038450197e-04,   3.839213230565006e-06,  -1.936431296725948e-08,
   1.989968898837212e-10,  -1.357453307435617e-11,  -2.393836429546670e-14,   1.259035007722528e-14,   8.705496984462735e-17,  -1.331174072173640e-17,   2.926994107001658e-02,
  -3.751978784471516e-04,   3.839491765786044e-06,  -1.939556623979328e-08,   1.989187940260952e-10,  -1.351430376294173e-11,  -2.339405152997208e-14,   1.248238564124450e-14,
   8.568907934642184e-17,  -1.314444048639199e-17,   2.927089336500646e-02,  -3.752123961469396e-04,   3.839787274885546e-06,  -1.942867764009485e-08,   1.988366122529065e-10,
  -1.345058670640125e-11,  -2.281969609430666e-14,   1.236833251663226e-14,   8.425029040023607e-17,  -1.296800820938930e-17,   2.927164284332973e-02,  -3.752238273607297e-04,
   3.840019814502593e-06,  -1.945469981241560e-08,   1.987724284327941e-10,  -1.340057892056282e-11,  -2.236998453784327e-14,   1.227893683327971e-14,   8.312553712823417e-17,
  -1.282993794184121e-17,   2.927207538880492e-02,  -3.752304268241009e-04,   3.840154006643561e-06,  -1.946970303649010e-08,   1.987355840744299e-10,  -1.337177360300112e-11,
  -2.211136972818834e-14,   1.222749062232810e-14,   8.247944574608941e-17,  -1.275056752635902e-17,   2.927223781523227e-02,  -3.752329054201778e-04,   3.840204395049263e-06,
  -1.947533412397217e-08,   1.987217858979949e-10,  -1.336096733102702e-11,  -2.201443129225872e-14,   1.220819956444738e-14,   8.223740233550283e-17,  -1.272082209814953e-17,
   2.927226473980613e-02,  -3.752333163057386e-04,   3.840212747539278e-06,  -1.947626741112931e-08,   1.987195006161981e-10,  -1.335917658568020e-11,  -2.199837152904252e-14,
   1.220500324533705e-14,   8.219731022486640e-17,  -1.271589447424323e-17,   8.194860800865525e-02,  -1.048974763944983e-03,   1.063456519592944e-05,  -4.994061941079183e-08,
   4.920695882993581e-10,  -3.825005625936586e-11,  -7.852205144094392e-14,   3.669748874186409e-14,   2.505517447279287e-16,  -3.888601839366537e-17,   8.195012222853597e-02,
  -1.048996273654280e-03,   1.063498446593738e-05,  -4.999415454227654e-08,   4.919131736415410e-10,  -3.814342828728375e-11,  -7.757332535191872e-14,   3.650621261083252e-14,
   2.481390376523794e-16,  -3.858809194335589e-17,   8.195260810859692e-02,  -1.049031601635002e-03,   1.063567267252385e-05,  -5.008193270993258e-08,   4.916578312672542e-10,
  -3.796878924631758e-11,  -7.602265723060856e-14,   3.619328739723880e-14,   2.442007581335774e-16,  -3.810134176973465e-17,   8.195524587800464e-02,  -1.049069109504268e-03,
   1.063640278700451e-05,  -5.017492501270870e-08,   4.913888414108886e-10,  -3.778403700318385e-11,  -7.438651133795604e-14,   3.586272015860165e-14,   2.400524631137291e-16,
  -3.758803490992605e-17,   8.195732185876907e-02,  -1.049098644418582e-03,   1.063697730015774e-05,  -5.024800410500428e-08,   4.911785510342028e-10,  -3.763903560729294e-11,
  -7.310551322442290e-14,   3.560362307544611e-14,   2.368097159414362e-16,  -3.718634633051375e-17,   8.195851996484989e-02,  -1.049115696013801e-03,   1.063730882666640e-05,
  -5.029013691098920e-08,   4.910577505001951e-10,  -3.755551231431839e-11,  -7.236888371088248e-14,   3.545451720316360e-14,   2.349470364677337e-16,  -3.695543714167095e-17,
   8.195896986880773e-02,  -1.049122100270003e-03,   1.063743331132693e-05,  -5.030595015992385e-08,   4.910124947778539e-10,  -3.752417866126843e-11,  -7.209277361344062e-14,
   3.539860648510432e-14,   2.342492354885242e-16,  -3.686890063017782e-17,   8.195904444699793e-02,  -1.049123161931097e-03,   1.063745394608076e-05,  -5.030857100837585e-08,
   4.910049985860255e-10,  -3.751898625063716e-11,  -7.204703084864639e-14,   3.538934270118832e-14,   2.341336521161551e-16,  -3.685456503830277e-17,   1.626090684242819e-01,
  -2.076665878571503e-03,   2.072982157412947e-05,  -8.531309963894334e-08,   7.635707025854259e-10,  -7.642237980654922e-11,  -1.877846008882293e-13,   7.693774419441069e-14,
   5.115927653737806e-16,  -8.158432010186607e-17,   1.626120197369596e-01,  -2.076702677816538e-03,   2.073047141401774e-05,  -8.541997266328164e-08,   7.631927002375501e-10,
  -7.619883284051603e-11,  -1.858491545764479e-13,   7.653653648138794e-14,   5.065820978624406e-16,  -8.095559758930596e-17,   1.626168648610190e-01,  -2.076763122275080e-03,
   2.073153800529976e-05,  -8.559519473678729e-08,   7.625750800280163e-10,  -7.583270011235694e-11,  -1.826859658676442e-13,   7.588017963163334e-14,   4.984035946606309e-16,
  -7.992842743578675e-17,   1.626220060027173e-01,  -2.076827302707488e-03,   2.073266943481764e-05,  -8.578081046716288e-08,   7.619237100435393e-10,  -7.544536540250470e-11,
  -1.793487486051999e-13,   7.518683733629850e-14,   4.897895628462790e-16,  -7.884525949477995e-17,   1.626260521738437e-01,  -2.076877845010565e-03,   2.073355965480927e-05,
  -8.592666808294688e-08,   7.614139456123108e-10,  -7.514136901662714e-11,  -1.767361633114149e-13,   7.464341217850229e-14,   4.830563583241268e-16,  -7.799765736938879e-17,
   1.626283873246125e-01,  -2.076907026765660e-03,   2.073407332984260e-05,  -8.601075612291370e-08,   7.611208968602885e-10,  -7.496626200514784e-11,  -1.752339109578272e-13,
   7.433068577708514e-14,   4.791888856005472e-16,  -7.751042905948129e-17,   1.626292642019157e-01,  -2.076917987223751e-03,   2.073426620325967e-05,  -8.604231516497719e-08,
   7.610110704362250e-10,  -7.490057086418166e-11,  -1.746708416734925e-13,   7.421342274097948e-14,   4.777400776178744e-16,  -7.732783568572712e-17,   1.626294095571423e-01,
  -2.076919804204143e-03,   2.073429817391082e-05,  -8.604754563920790e-08,   7.609928765362186e-10,  -7.488968495374145e-11,  -1.745775597643755e-13,   7.419399361376004e-14,
   4.775000995940319e-16,  -7.729758749150353e-17,   2.734872099556901e-01,  -3.480437031091567e-03,   3.391091956393252e-05,  -1.080193400584297e-07,   7.370982008506983e-10,
  -1.301749446134784e-10,  -3.872843731028227e-13,   1.400127080862495e-13,   8.968089676324323e-16,  -1.489719893006449e-16,   2.734920369853150e-01,  -3.480483788624800e-03,
   3.391154449322080e-05,  -1.082011646545773e-07,   7.363114925102618e-10,  -1.297681644242993e-10,  -3.838955842094087e-13,   1.392803694258949e-13,   8.878297600375122e-16,
  -1.478140365016814e-16,   2.734999613994788e-01,  -3.480560603994789e-03,   3.391256994287846e-05,  -1.084992455740183e-07,   7.350251145877306e-10,  -1.291019308503403e-10,
  -3.783577059367957e-13,   1.380823349155045e-13,   8.731749944110257e-16,  -1.459223334520030e-16,   2.735083699021215e-01,  -3.480642186144727e-03,   3.391365738319889e-05,
  -1.088149712460799e-07,   7.336671207077495e-10,  -1.283971233993695e-10,  -3.725159311173522e-13,   1.368168416363999e-13,   8.577415283266308e-16,  -1.439276266508144e-16,
   2.735149875006871e-01,  -3.480706446050226e-03,   3.391451274165894e-05,  -1.090630433516985e-07,   7.326033896498063e-10,  -1.278439657482524e-10,  -3.679431833190795e-13,
   1.358250142691080e-13,   8.456791087064893e-16,  -1.423668162909485e-16,   2.735188066713912e-01,  -3.480743553456671e-03,   3.391500620068148e-05,  -1.092060482314452e-07,
   7.319914953885960e-10,  -1.275253394845546e-10,  -3.653140516430875e-13,   1.352542590252799e-13,   8.387510913048693e-16,  -1.414696496708346e-16,   2.735202408127246e-01,
  -3.480757491767252e-03,   3.391519146452297e-05,  -1.092597173203403e-07,   7.317621014677210e-10,  -1.274058076458140e-10,  -3.643286518756212e-13,   1.350402456255748e-13,
   8.361558547369735e-16,  -1.411334349038962e-16,   2.735204785424295e-01,  -3.480759802458534e-03,   3.391522217281516e-05,  -1.092686121229413e-07,   7.317240960915003e-10,
  -1.273859996216052e-10,  -3.641654060638120e-13,   1.350047862271857e-13,   8.357259891983896e-16,  -1.410777383383292e-16,   4.181264164657323e-01,  -5.293022159916345e-03,
   4.964262280207780e-05,  -8.280922194285066e-08,  -1.392186603315389e-10,  -2.040090818918554e-10,  -7.158484875981399e-13,   2.387211365582702e-13,   1.451688978038932e-15,
  -2.564259440771108e-16,   4.181334807198683e-01,  -5.293058516905858e-03,   4.964249567138440e-05,  -8.309370575615528e-08,  -1.406820832459513e-10,  -2.033157011846668e-10,
  -7.103707127011506e-13,   2.374612205849017e-13,   1.436774080759590e-15,  -2.544077182639184e-16,   4.181450778222937e-01,  -5.293118289216301e-03,   4.964228608293928e-05,
  -8.356002707597156e-08,  -1.430762388926534e-10,  -2.021800912612300e-10,  -7.014201758485375e-13,   2.354002142593939e-13,   1.412435112023257e-15,  -2.511108700008243e-16,
   4.181573832252293e-01,  -5.293181829604100e-03,   4.964206249628757e-05,  -8.405387351543119e-08,  -1.456053914658739e-10,  -2.009787642327564e-10,  -6.919799775330696e-13,
   2.332232831701516e-13,   1.386807333848424e-15,  -2.476348454462394e-16,   4.181670676281822e-01,  -5.293231921093978e-03,   4.964188566782115e-05,  -8.444184188384828e-08,
  -1.475877433086178e-10,  -2.000359443362500e-10,  -6.845915926694865e-13,   2.315172095752452e-13,   1.366780519041892e-15,  -2.449151831706278e-16,   4.181726566809493e-01,
  -5.293260863862613e-03,   4.964178327078723e-05,  -8.466546926427598e-08,  -1.487285576443539e-10,  -1.994928768708868e-10,  -6.803440280790079e-13,   2.305354718403810e-13,
   1.355279465780075e-15,  -2.433519964278559e-16,   4.181747554247902e-01,  -5.293271738580983e-03,   4.964174475439386e-05,  -8.474939130629237e-08,  -1.491563335102884e-10,
  -1.992891482759299e-10,  -6.787521213417039e-13,   2.301673611469649e-13,   1.350971413310850e-15,  -2.427662078528166e-16,   4.181751033215673e-01,  -5.293273541559858e-03,
   4.964173836630811e-05,  -8.476329983000605e-08,  -1.492272112625040e-10,  -1.992553878178357e-10,  -6.784884031727242e-13,   2.301063700772247e-13,   1.350257856060321e-15,
  -2.426691684342519e-16,   6.021755146210338e-01,  -7.560104522337525e-03,   6.653484739891205e-05,   6.748010087240918e-08,  -3.045867423941344e-09,  -3.099808485836527e-10,
  -1.141768680615995e-12,   3.996836136850387e-13,   2.250796752546259e-15,  -4.393191660415609e-16,   6.021849777619532e-01,  -7.560077235635671e-03,   6.653223351020629e-05,
   6.704873955766143e-08,  -3.048204610382659e-09,  -3.088206912705582e-10,  -1.133288317795544e-12,   3.975268192326211e-13,   2.227043287254461e-15,  -4.357953423951157e-16,
   6.022005127688301e-01,  -7.560032570932330e-03,   6.652794097777815e-05,   6.634176926599155e-08,  -3.052028653221669e-09,  -3.069207034095206e-10,  -1.119433456138097e-12,
   3.939989193469321e-13,   2.188289696557895e-15,  -4.300397395120545e-16,   6.022169962442045e-01,  -7.559985355849059e-03,   6.652338435554342e-05,   6.559321910514879e-08,
  -3.056068881100284e-09,  -3.049109036546318e-10,  -1.104823095642347e-12,   3.902729194531360e-13,   2.147495718681589e-15,  -4.239722747173850e-16,   6.022299685597532e-01,
  -7.559948325778344e-03,   6.651979688773877e-05,   6.500526260132238e-08,  -3.059236023838975e-09,  -3.033336826506051e-10,  -1.093390053707182e-12,   3.873530715888414e-13,
   2.115625740068285e-15,  -4.192257336159958e-16,   6.022374550300038e-01,  -7.559927006438371e-03,   6.651772593696825e-05,   6.466640429088431e-08,  -3.061058832399862e-09,
  -3.024252383103060e-10,  -1.086817936128676e-12,   3.856729792890666e-13,   2.097326746657193e-15,  -4.164978245424473e-16,   6.022402662538546e-01,  -7.559919010530532e-03,
   6.651694816997683e-05,   6.453924703739721e-08,  -3.061742369628329e-09,  -3.020844483265934e-10,  -1.084354965081098e-12,   3.850430328830945e-13,   2.090472968138875e-15,
  -4.154756192132745e-16,   6.022407322533828e-01,  -7.559917685606789e-03,   6.651681923846167e-05,   6.451817351197358e-08,  -3.061855625869482e-09,  -3.020279754288169e-10,
  -1.083946951883500e-12,   3.849386600565043e-13,   2.089337787423712e-15,  -4.153062874249804e-16,   8.351534167735305e-01,  -1.033869831934850e-02,   8.057063854768110e-05,
   5.386471508894402e-07,  -1.082576008098668e-08,  -4.924578584628915e-10,  -1.035068796889577e-12,   6.870724021915774e-13,   3.323527787457387e-15,  -7.965167130598945e-16,
   8.351648639553674e-01,  -1.033847077239483e-02,   8.056138342602211e-05,   5.379631030816917e-07,  -1.082782210122161e-08,  -4.904666225399655e-10,  -1.022567653689530e-12,
   6.831676378955530e-13,   3.287410845547097e-15,  -7.899132970627909e-16,   8.351836554037777e-01,  -1.033809742441533e-02,   8.054618841923731e-05,   5.368421503592716e-07,
  -1.083118834387677e-08,  -4.872060074318413e-10,  -1.002146782455468e-12,   6.767813560835140e-13,   3.228509892055483e-15,  -7.791299006349173e-16,   8.352035932874382e-01,
  -1.033770155458126e-02,   8.053006368159342e-05,   5.356554769448930e-07,  -1.083473458911717e-08,  -4.837575234928628e-10,  -9.806163776293740e-13,   6.700375491435793e-13,
   3.166539661937573e-15,  -7.677652297422066e-16,   8.352192835686724e-01,  -1.033739020629538e-02,   8.051737223055741e-05,   5.347235418751253e-07,  -1.083750703506488e-08,
  -4.810516940056892e-10,  -9.637710719779448e-13,   6.647536017878680e-13,   3.118148902559984e-15,  -7.588768887150877e-16,   8.352283383607859e-01,  -1.033721060253933e-02,
   8.051004726746461e-05,   5.341864976714592e-07,  -1.083909968680995e-08,  -4.794933647775010e-10,  -9.540889395291278e-13,   6.617135086162949e-13,   3.090373267423383e-15,
  -7.537694927390149e-16,   8.352317384541948e-01,  -1.033714317492343e-02,   8.050729658072868e-05,   5.339849821175353e-07,  -1.083969635086908e-08,  -4.789088115696315e-10,
  -9.504606731404733e-13,   6.605736921003748e-13,   3.079971807580523e-15,  -7.518558071195273e-16,   8.352323020645962e-01,  -1.033713199864209e-02,   8.050684061027272e-05,
   5.339515859336604e-07,  -1.083979518307930e-08,  -4.788119459267155e-10,  -9.498596297103234e-13,   6.603848444194928e-13,   3.078249121588721e-15,  -7.515388072305301e-16,
   1.135086446391092e+00,  -1.365508533694581e-02,   7.714831795358676e-05,   1.974906365567861e-06,  -3.140307392489670e-08,  -1.023565236117259e-09,   5.885776336192735e-12,
   1.313714602128178e-12,   2.394609024732735e-15,  -1.705777440176462e-15,   1.135097371388480e+00,  -1.365424723296299e-02,   7.712157644296744e-05,   1.973481667311664e-06,
  -3.139040709710806e-08,  -1.019771582665060e-09,   5.894539001971263e-12,   1.305383410697891e-12,   2.356624098881320e-15,  -1.690460508264363e-15,   1.135115303801359e+00,
  -1.365287178180499e-02,   7.707768377349019e-05,   1.971146641893224e-06,  -3.136959933791836e-08,  -1.013561419385911e-09,   5.908817662336547e-12,   1.291762052534737e-12,
   2.294741441314767e-15,  -1.665458085103704e-15,   1.135134327756121e+00,  -1.365141290853514e-02,   7.703112092910451e-05,   1.968674218452254e-06,  -3.134750296611231e-08,
  -1.006995991470370e-09,   5.923824183747231e-12,   1.277384073715998e-12,   2.229721532901852e-15,  -1.639121663756350e-15,   1.135149297014554e+00,  -1.365026519190440e-02,
   7.699448345480690e-05,   1.966732179178738e-06,  -3.133010023675355e-08,  -1.001846316415680e-09,   5.935530537351826e-12,   1.266122849846379e-12,   2.179012336218543e-15,
  -1.618533781092566e-15,   1.135157934986567e+00,  -1.364960299211006e-02,   7.697334235119250e-05,   1.965612899388850e-06,  -3.132005168573627e-08,  -9.988812767252669e-10,
   5.942245060647452e-12,   1.259645478563867e-12,   2.149931109714892e-15,  -1.606707582545654e-15,   1.135161178426884e+00,  -1.364935436159889e-02,   7.696540424247690e-05,
   1.965192883622048e-06,  -3.131627739448036e-08,  -9.977691842935625e-10,   5.944758620315030e-12,   1.257217254286195e-12,   2.139045478470514e-15,  -1.602277181793560e-15,
   1.135161716062777e+00,  -1.364931314922558e-02,   7.696408841824587e-05,   1.965123275020357e-06,  -3.131565170107918e-08,  -9.975849080859325e-10,   5.945174867310623e-12,
   1.256814957069593e-12,   2.137242854564587e-15,  -1.601543330233562e-15,   1.545001738172540e+00,  -1.691516474944927e-02,  -3.591826466409616e-05,   7.938858858875863e-06,
  -6.364978618505843e-08,  -6.878260041031579e-09,   1.352413925952884e-10,   6.415868735537350e-12,  -2.060741366447281e-13,  -5.887495177375192e-15,   1.544996520650297e+00,
  -1.691180946905051e-02,  -3.597103321210117e-05,   7.929228136717218e-06,  -6.337038547357910e-08,  -6.859550186850089e-09,   1.344553846965515e-10,   6.386725608094570e-12,
  -2.043681807072275e-13,  -5.849327104803766e-15,   1.544987950065585e+00,  -1.690630416817232e-02,  -3.605749182153429e-05,   7.913436799708794e-06,  -6.291289815525545e-08,
  -6.828897223013853e-09,   1.331698556163178e-10,   6.339022032808605e-12,  -2.015820727274756e-13,  -5.786899453849868e-15,   1.544978848985051e+00,  -1.690046660406464e-02,
  -3.614900111717285e-05,   7.896706829200947e-06,  -6.242908769542226e-08,  -6.796456552285426e-09,   1.318123518048309e-10,   6.288594093564168e-12,  -1.986454062521895e-13,
  -5.720972600169004e-15,   1.544971681305617e+00,  -1.689587529364722e-02,  -3.622085321909901e-05,   7.883558949511212e-06,  -6.204949532223848e-08,  -6.770986620586703e-09,
   1.307487079904233e-10,   6.249043690301071e-12,  -1.963483615136552e-13,  -5.669314320500105e-15,   1.544967542663170e+00,  -1.689322671354173e-02,  -3.626225395526185e-05,
   7.875978535963991e-06,  -6.183089269732183e-08,  -6.756311853201889e-09,   1.301367440757946e-10,   6.226273035047235e-12,  -1.950283318325096e-13,  -5.639591901483497e-15,
   1.544965988177514e+00,  -1.689223236356909e-02,  -3.627778778313486e-05,   7.873133428960005e-06,  -6.174889348767716e-08,  -6.750805944292973e-09,   1.299073012734451e-10,
   6.217732743806506e-12,  -1.945337107880792e-13,  -5.628447934176562e-15,   1.544965730479001e+00,  -1.689206754733657e-02,  -3.628036207513985e-05,   7.872661886300844e-06,
  -6.173530559752551e-08,  -6.749893504270929e-09,   1.298692865944567e-10,   6.216317612168638e-12,  -1.944517762931750e-13,  -5.626601563399862e-15,   3.079902933855202e-03,
  -3.823836607410157e-05,   4.016738090173598e-07,  -2.079057208091631e-09,  -4.330586381490929e-12,  -1.115375836267637e-12,   3.245363957102150e-14,   8.630307260009145e-16,
  -3.739151651812897e-17,  -7.484177888354671e-19,   3.079960088328161e-03,  -3.823925919793521e-05,   4.016704934215322e-07,  -2.080623247426651e-09,  -4.263007467369675e-12,
  -1.112855871344531e-12,   3.231012758831643e-14,   8.593137798739323e-16,  -3.712564720381051e-17,  -7.440290948792378e-19,   3.080053916368101e-03,  -3.824072588359021e-05,
   4.016650915048427e-07,  -2.083191587056244e-09,  -4.152284265735228e-12,  -1.108726893730251e-12,   3.207528385599080e-14,   8.532278881325438e-16,  -3.669114918288569e-17,
  -7.368473707545926e-19,   3.080153474795950e-03,  -3.824228280011003e-05,   4.016594155351581e-07,  -2.085913309059831e-09,  -4.035094751336525e-12,  -1.104356518746737e-12,
   3.182711874011933e-14,   8.467920899308585e-16,  -3.623277913055397e-17,  -7.292582432866357e-19,   3.080231827532661e-03,  -3.824350857164770e-05,   4.016549889198533e-07,
  -2.088052798942276e-09,  -3.943080066209030e-12,  -1.100924807647031e-12,   3.163254920664646e-14,   8.417428326269273e-16,  -3.587396126999714e-17,  -7.233081299591571e-19,
   3.080277046321853e-03,  -3.824421617668297e-05,   4.016524504102437e-07,  -2.089286531541005e-09,  -3.890062243015381e-12,  -1.098947420605694e-12,   3.152055424674279e-14,
   8.388351087657046e-16,  -3.566764804650207e-17,  -7.198832350006105e-19,   3.080294026406632e-03,  -3.824448192498988e-05,   4.016515002299677e-07,  -2.089749619853290e-09,
  -3.870169692811857e-12,  -1.098205481343479e-12,   3.147855467511369e-14,   8.377444191197345e-16,  -3.559032013202084e-17,  -7.185988581634131e-19,   3.080296841097669e-03,
  -3.824452597845228e-05,   4.016513428851140e-07,  -2.089826373320731e-09,  -3.866873070426681e-12,  -1.098082525361441e-12,   3.147159557841246e-14,   8.375636844197903e-16,
  -3.557750955168637e-17,  -7.183860442347166e-19,   2.782779752495903e-02,  -3.453582549517463e-04,   3.617253051228599e-06,  -1.824963105276813e-08,  -5.059169933793140e-11,
  -1.007684936265266e-11,   2.964959814751375e-13,   7.914205168827748e-15,  -3.438064242402449e-16,  -6.849393511677165e-18,   2.782831220685180e-02,  -3.453660960577463e-04,
   3.617213343594671e-06,  -1.826377652475624e-08,  -4.997439864599787e-11,  -1.005373958073263e-11,   2.951764568382975e-13,   7.880187795508693e-15,  -3.413600859051410e-16,
  -6.809248602090529e-18,   2.782915713697241e-02,  -3.453789728222191e-04,   3.617148533126937e-06,  -1.828697506118805e-08,  -4.896300885166948e-11,  -1.001587391623867e-11,
   2.930171850131777e-13,   7.824489837686144e-15,  -3.373621737441630e-16,  -6.743554198261570e-18,   2.783005366839654e-02,  -3.453926419318893e-04,   3.617080274612714e-06,
  -1.831155854220275e-08,  -4.789257097283186e-11,  -9.975794264280572e-12,   2.907354363450371e-13,   7.765589450258183e-15,  -3.331446453935633e-16,  -6.674132185030509e-18,
   2.783075923992569e-02,  -3.454034038380945e-04,   3.617026923823440e-06,  -1.833088276358514e-08,  -4.705209906319587e-11,  -9.944322725705929e-12,   2.889464758834586e-13,
   7.719378610803059e-15,  -3.298431366978213e-16,  -6.619702501260855e-18,   2.783116643768957e-02,  -3.454096164452339e-04,   3.616996281788881e-06,  -1.834202589753537e-08,
  -4.656783379766696e-11,  -9.926188444658055e-12,   2.879167453901921e-13,   7.692767074717141e-15,  -3.279448443146895e-16,  -6.588372425989531e-18,   2.783131934424213e-02,
  -3.454119496623084e-04,   3.616984803305844e-06,  -1.834620850764717e-08,  -4.638613604469966e-11,  -9.919384234495662e-12,   2.875305833779284e-13,   7.682785060410806e-15,
  -3.272333504607174e-16,  -6.576623221618556e-18,   2.783134469067835e-02,  -3.454123364433836e-04,   3.616982902054627e-06,  -1.834690174298453e-08,  -4.635602488002682e-11,
  -9.918256623626802e-12,   2.874665984875961e-13,   7.681130972422174e-15,  -3.271154804610192e-16,  -6.574676442773531e-18,   7.791918009737765e-02,  -9.662186127253603e-04,
   1.005789657309829e-05,  -4.794117521401543e-08,  -2.094631206701870e-10,  -2.821166101179233e-11,   8.498575728012013e-13,   2.284187921959628e-14,  -9.981767175744294e-16,
  -1.969045854845513e-17,   7.792061107057177e-02,  -9.662392196108021e-04,   1.005772772363153e-05,  -4.798076069902054e-08,  -2.076943023059265e-10,  -2.814495574228106e-11,
   8.460268144740067e-13,   2.274408295354166e-14,  -9.910628727693038e-16,  -1.957520511598226e-17,   7.792296022895552e-02,  -9.662730612334542e-04,   1.005745160722400e-05,
  -4.804567871461285e-08,  -2.047963335377671e-10,  -2.803565749150064e-11,   8.397581891425568e-13,   2.258395680526863e-14,  -9.794372779647508e-16,  -1.938659630623281e-17,
   7.792545284628738e-02,  -9.663089862242709e-04,   1.005716008860119e-05,  -4.811446949404204e-08,  -2.017292751426549e-10,  -2.791996748420848e-11,   8.331340428415279e-13,
   2.241462324979837e-14,  -9.671732725248226e-16,  -1.918727954235186e-17,   7.792741453387014e-02,  -9.663372712559246e-04,   1.005693171908276e-05,  -4.816854149734275e-08,
  -1.993211982237520e-10,  -2.782912399088367e-11,   8.279405420557133e-13,   2.228177052751098e-14,  -9.575730841429043e-16,  -1.903100279683156e-17,   7.792854665599384e-02,
  -9.663535998580101e-04,   1.005680034583360e-05,  -4.819972080065015e-08,  -1.979337361173174e-10,  -2.777677854084782e-11,   8.249511615745325e-13,   2.220526413348194e-14,
  -9.520532562575776e-16,  -1.894104719078478e-17,   7.792897177795030e-02,  -9.663597323092818e-04,   1.005675109381428e-05,  -4.821142389474380e-08,  -1.974131618935527e-10,
  -2.775713780757001e-11,   8.238301083165157e-13,   2.217656646775314e-14,  -9.499843961458137e-16,  -1.890731229332821e-17,   7.792904224793860e-02,  -9.663607488982668e-04,
   1.005674293380295e-05,  -4.821336358408118e-08,  -1.973268920205024e-10,  -2.775388289241571e-11,   8.236443561738498e-13,   2.217181106634820e-14,  -9.496416579757954e-16,
  -1.890172258855793e-17,   1.546277407667383e-01,  -1.914828748364390e-03,   1.973013911355388e-05,  -8.483817508347628e-08,  -6.376242166413452e-10,  -5.598060155191117e-11,
   1.752815784102172e-12,   4.751672337103682e-14,  -2.098423558790078e-15,  -4.072491293184505e-17,   1.546305474574525e-01,  -1.914865244738784e-03,   1.972961529440284e-05,
  -8.491667077791166e-08,  -6.339778507967810e-10,  -5.584181987600189e-11,   1.744763435512420e-12,   4.731443640911253e-14,  -2.083424815189487e-15,  -4.048727535062111e-17,
   1.546351550440387e-01,  -1.914925183395117e-03,   1.972875758076419e-05,  -8.504539275447575e-08,  -6.280040114371508e-10,  -5.561442011978845e-11,   1.731586755667791e-12,
   4.698322037637067e-14,  -2.058914087262609e-15,  -4.009837130110614e-17,   1.546400439810806e-01,  -1.914988815470475e-03,   1.972785049375958e-05,  -8.518178477485057e-08,
  -6.216819333735851e-10,  -5.537371862420339e-11,   1.717662938679928e-12,   4.663295553401036e-14,  -2.033058094702834e-15,  -3.968736464976935e-17,   1.546438915507711e-01,
  -1.915038917781283e-03,   1.972713879014612e-05,  -8.528898722762434e-08,  -6.167184353877651e-10,  -5.518470964289725e-11,   1.706746430890538e-12,   4.635814838586909e-14,
  -2.012818703777681e-15,  -3.936509319237728e-17,   1.546461120386853e-01,  -1.915067842231761e-03,   1.972672892432316e-05,  -8.535080029029338e-08,  -6.138587089558386e-10,
  -5.507579870442656e-11,   1.700462934844970e-12,   4.619989314670062e-14,  -2.001181853875937e-15,  -3.917958151257294e-17,   1.546469458502404e-01,  -1.915078705431655e-03,
   1.972657518037012e-05,  -8.537400121426652e-08,  -6.127857604097524e-10,  -5.503493363426762e-11,   1.698106558260678e-12,   4.614053117202999e-14,  -1.996820341590255e-15,
  -3.911001019632568e-17,   1.546470840662436e-01,  -1.915080506256475e-03,   1.972654970379693e-05,  -8.537784654599264e-08,  -6.126079516608106e-10,  -5.502816135503757e-11,
   1.697716120561336e-12,   4.613069447276100e-14,  -1.996097792766005e-15,  -3.909848250933083e-17,   2.600998532042506e-01,  -3.214328629824418e-03,   3.260153868461660e-05,
  -1.162322139803626e-07,  -1.646431732522106e-09,  -9.419840700451674e-11,   3.128274516397308e-12,   8.539754706923892e-14,  -3.839423222391510e-15,  -7.265539347155607e-17,
   2.601044898902578e-01,  -3.214378717672201e-03,   3.260016964992791e-05,  -1.163641642457914e-07,  -1.639928256038305e-09,  -9.394894614713631e-11,   3.113544194833766e-12,
   8.503657988550242e-14,  -3.811842173841726e-15,  -7.223435514548318e-17,   2.601121016260082e-01,  -3.214460985209860e-03,   3.259792611649585e-05,  -1.165805277590111e-07,
  -1.629274173361908e-09,  -9.354018817365685e-11,   3.089440231169747e-12,   8.444553703248091e-14,  -3.766771061491308e-15,  -7.154525113081048e-17,   2.601201780830643e-01,
  -3.214548332058737e-03,   3.259555092669522e-05,  -1.168097611185425e-07,  -1.617999782289970e-09,  -9.310751230709808e-11,   3.063970077511376e-12,   8.382048797434876e-14,
  -3.719228175254442e-15,  -7.081690664663840e-17,   2.601265341649792e-01,  -3.214617114010629e-03,   3.259368552387485e-05,  -1.169899194898616e-07,  -1.609148746643363e-09,
  -9.276775143600139e-11,   3.044001436384570e-12,   8.333008320365553e-14,  -3.682014255272376e-15,  -7.024575471428133e-17,   2.601302023311939e-01,  -3.214656825251876e-03,
   3.259261051841961e-05,  -1.170937925133422e-07,  -1.604049430470338e-09,  -9.257197189240387e-11,   3.032507726210217e-12,   8.304766605892737e-14,  -3.660618282243876e-15,
  -6.991695608266902e-17,   2.601315797540825e-01,  -3.214671740208933e-03,   3.259220713686184e-05,  -1.171327789985111e-07,  -1.602136245860495e-09,  -9.249851196015122e-11,
   3.028197494368942e-12,   8.294172984091983e-14,  -3.652599138816337e-15,  -6.979364460795603e-17,   2.601318080811149e-01,  -3.214674212734316e-03,   3.259214028608210e-05,
  -1.171392405714207e-07,  -1.601819195614281e-09,  -9.248633794283935e-11,   3.027483315930279e-12,   8.292417541930479e-14,  -3.651270655036350e-15,  -6.977321217581617e-17,
   3.977418601182664e-01,  -4.900198766316755e-03,   4.850407167073588e-05,  -1.163556528835128e-07,  -3.859367998554573e-09,  -1.443333466900485e-10,   5.236500432683764e-12,
   1.426543727925131e-13,  -6.615789830080617e-15,  -1.203419869791969e-16,   3.977487561019520e-01,  -4.900249153664008e-03,   4.850083785583435e-05,  -1.165575394831680e-07,
  -3.848490115867006e-09,  -1.439165527570077e-10,   5.211126721988487e-12,   1.420562026173932e-13,  -6.567852713837034e-15,  -1.196554834003224e-16,   3.977600766527237e-01,
  -4.900331934130552e-03,   4.849553564374488e-05,  -1.168885442611151e-07,  -3.830670937157796e-09,  -1.432335982117710e-10,   5.169607639376316e-12,   1.410767270390273e-13,
  -6.489520598874792e-15,  -1.185317137051232e-16,   3.977720881941346e-01,  -4.900419854091579e-03,   4.848991856906304e-05,  -1.172391893600022e-07,  -3.811815793935790e-09,
  -1.425106675215682e-10,   5.125736909403046e-12,   1.400408427796029e-13,  -6.406897396027907e-15,  -1.173437029076904e-16,   3.977815410235816e-01,  -4.900489107955273e-03,
   4.848550439500726e-05,  -1.175147320164176e-07,  -3.797014534516862e-09,  -1.419429724836286e-10,   5.091343353183034e-12,   1.392280638506158e-13,  -6.342228004730441e-15,
  -1.164119118288080e-16,   3.977869963094196e-01,  -4.900529099904270e-03,   4.848295948834004e-05,  -1.176735861503115e-07,  -3.788487576116851e-09,  -1.416158469640269e-10,
   5.071547301537130e-12,   1.387599806100128e-13,  -6.305048011431282e-15,  -1.158754305579856e-16,   3.977890447995279e-01,  -4.900544121848797e-03,   4.848200434151826e-05,
  -1.177332059293183e-07,  -3.785288476179116e-09,  -1.414931029441483e-10,   5.064123714347800e-12,   1.385843971207661e-13,  -6.291113326865695e-15,  -1.156742171078480e-16,
   3.977893843648208e-01,  -4.900546612192158e-03,   4.848184603815036e-05,  -1.177430870983706e-07,  -3.784758330246632e-09,  -1.414727613682924e-10,   5.062893677060012e-12,
   1.385553014738455e-13,  -6.288804864294317e-15,  -1.156408757882745e-16,   5.730030025483713e-01,  -7.025877192559805e-03,   6.685313024864232e-05,  -2.857755172848506e-08,
  -8.633518060959391e-09,  -2.095953010313233e-10,   8.708951618027743e-12,   2.302770442502189e-13,  -1.131344464437276e-14,  -1.924826126439226e-16,   5.730125016229318e-01,
  -7.025890425564237e-03,   6.684586074062232e-05,  -2.887015358973483e-08,  -8.615440534811684e-09,  -2.089223787242583e-10,   8.665586239558818e-12,   2.293191893604112e-13,
  -1.123022932410933e-14,  -1.914264876760230e-16,   5.730280951601533e-01,  -7.025912238651569e-03,   6.683393766109023e-05,  -2.934982108262115e-08,  -8.585829350965157e-09,
  -2.078197184880006e-10,   8.594630937146727e-12,   2.277505935560158e-13,  -1.109425914508465e-14,  -1.896970072467753e-16,   5.730446401154932e-01,  -7.025935504825513e-03,
   6.682130127249696e-05,  -2.985785442923687e-08,  -8.554499099992415e-09,  -2.066524931717972e-10,   8.519661599122119e-12,   2.260914539290522e-13,  -1.095085210801826e-14,
  -1.878677694901317e-16,   5.730576603639168e-01,  -7.025953902801464e-03,   6.681136715375356e-05,  -3.025700621904853e-08,  -8.529906676421466e-09,  -2.057358916757630e-10,
   8.460891039628347e-12,   2.247895050690417e-13,  -1.083861548448728e-14,  -1.864324061149777e-16,   5.730651743160815e-01,  -7.025964555627860e-03,   6.680563829726542e-05,
  -3.048709499658936e-08,  -8.515739771479849e-09,  -2.052077079431008e-10,   8.427065620606733e-12,   2.240396469760746e-13,  -1.077409131313436e-14,  -1.856057369310339e-16,
   5.730679958254576e-01,  -7.025968562480967e-03,   6.680348787010321e-05,  -3.057344471257046e-08,  -8.510424840255366e-09,  -2.050095216962977e-10,   8.414381239400704e-12,
   2.237583552185880e-13,  -1.074990894439250e-14,  -1.852956371969409e-16,   5.730684635281549e-01,  -7.025969227022889e-03,   6.680313144902078e-05,  -3.058775572922015e-08,
  -8.509544071752419e-09,  -2.049766775041991e-10,   8.412279538836882e-12,   2.237117422391405e-13,  -1.074590285260874e-14,  -1.852442507571732e-16,   7.951235751277261e-01,
  -9.671947893147220e-03,   8.568338610246582e-05,   2.917092299671392e-07,  -1.941507104113742e-08,  -3.006211684117294e-10,   1.550476332660177e-11,   3.657241733885297e-13,
  -2.034655181729714e-14,  -3.019934738065599e-16,   7.951357355351022e-01,  -9.671824833863833e-03,   8.566699050489370e-05,   2.912904271694290e-07,  -1.938289537237207e-08,
  -2.995522342634731e-10,   1.542685504591596e-11,   3.642163791130979e-13,  -2.019290397783929e-14,  -3.005254729918019e-16,   7.951556971549578e-01,  -9.671622939260922e-03,
   8.564009404382707e-05,   2.906039840982088e-07,  -1.933019233462118e-08,  -2.978006371006618e-10,   1.529939158459700e-11,   3.617465037553970e-13,  -1.994187277170052e-14,
  -2.981185090221796e-16,   7.951768757256783e-01,  -9.671408886077220e-03,   8.561158137195964e-05,   2.898770938591666e-07,  -1.927443106632029e-08,  -2.959464422603916e-10,
   1.516473312104125e-11,   3.591331254791197e-13,  -1.967714209946506e-14,  -2.955686553824663e-16,   7.951935417433679e-01,  -9.671240549917231e-03,   8.558916094289287e-05,
   2.893060967762688e-07,  -1.923066274150551e-08,  -2.944903511098380e-10,   1.505918199128774e-11,   3.570816999210207e-13,  -1.946997440062965e-14,  -2.935649283340778e-16,
   7.952031593754570e-01,  -9.671143449814970e-03,   8.557622935841335e-05,   2.889769913780483e-07,  -1.920544962488395e-08,  -2.936512814482854e-10,   1.499843656351859e-11,
   3.558999117299918e-13,  -1.935088376275905e-14,  -2.924097614640593e-16,   7.952067707686249e-01,  -9.671106997203586e-03,   8.557137487091453e-05,   2.888534899041397e-07,
  -1.919599061529189e-08,  -2.933364421072261e-10,   1.497565816214313e-11,   3.554565408336632e-13,  -1.930625264484452e-14,  -2.919762174495250e-16,   7.952073694022304e-01,
  -9.671100955159478e-03,   8.557057024664618e-05,   2.888330220322685e-07,  -1.919442311125407e-08,  -2.932842656182729e-10,   1.497188400865716e-11,   3.553830669806649e-13,
  -1.929885906709430e-14,  -2.919043636307187e-16,   1.081836597385613e+00,  -1.295309063391389e-02,   9.721480193107067e-05,   1.328315706798416e-06,  -4.767040756884238e-08,
  -4.863423878795925e-10,   3.517389113382525e-11,   5.298693860684010e-13,  -4.327998956676200e-14,  -4.015316814235425e-16,   1.081850350751767e+00,  -1.295252594305600e-02,
   9.717451219177160e-05,   1.327636670862679e-06,  -4.759728078898556e-08,  -4.847914386440501e-10,   3.500841292819234e-11,   5.278306355010836e-13,  -4.294126696009344e-14,
  -4.008707275984223e-16,   1.081872925050483e+00,  -1.295159911808032e-02,   9.710841457549183e-05,   1.326523505178920e-06,  -4.747748297061635e-08,  -4.822496956883994e-10,
   3.473771359015563e-11,   5.244863144092125e-13,  -4.238792147161535e-14,  -3.997629319719706e-16,   1.081896872586706e+00,  -1.295061596547474e-02,   9.703834030684248e-05,
   1.325344497545978e-06,  -4.735070940490571e-08,  -4.795586747708804e-10,   3.445178103022703e-11,   5.209413338123790e-13,  -4.180446331148842e-14,  -3.985569345036231e-16,
   1.081915715414742e+00,  -1.294984242196408e-02,   9.698323516264367e-05,   1.324418165029952e-06,  -4.725118433688573e-08,  -4.774451432916015e-10,   3.422768877203006e-11,
   5.181540585385009e-13,  -4.134793365729684e-14,  -3.975859728937292e-16,   1.081926588372952e+00,  -1.294939607608450e-02,   9.695145039130983e-05,   1.323884182176708e-06,
  -4.719384503470815e-08,  -4.762271122133895e-10,   3.409873572049179e-11,   5.165465382957558e-13,  -4.108552163067574e-14,  -3.970169498596523e-16,   1.081930670973344e+00,
  -1.294922848410910e-02,   9.693951819588165e-05,   1.323683783747822e-06,  -4.717233216104805e-08,  -4.757700561795136e-10,   3.405038331137831e-11,   5.159431021983277e-13,
  -4.098718320236378e-14,  -3.968016495485171e-16,   1.081931347706785e+00,  -1.294920070414940e-02,   9.693754043784179e-05,   1.323650571033533e-06,  -4.716876707518025e-08,
  -4.756943098346282e-10,   3.404237193636507e-11,   5.158430848084966e-13,  -4.097089273392645e-14,  -3.967658748957270e-16,   1.477333255600413e+00,  -1.684782500646421e-02,
   4.940005472637346e-05,   6.042274297438154e-06,  -1.585856316315967e-07,  -2.334639444618946e-09,   2.072581895566561e-10,  -1.261457649241567e-12,  -2.074195987488275e-13,
   4.899799139313836e-15,   1.477340018255839e+00,  -1.684525726950547e-02,   4.926709513060865e-05,   6.038923588502892e-06,  -1.581527634713298e-07,  -2.338036465978393e-09,
   2.064520162440590e-10,  -1.237933125799093e-12,  -2.064383210464536e-13,   4.840491365476339e-15,   1.477351106963556e+00,  -1.684104295398054e-02,   4.904908455115780e-05,
   6.033419516689751e-06,  -1.574433733384627e-07,  -2.343563428192366e-09,   2.051313634902934e-10,  -1.199529008543903e-12,  -2.048299741700358e-13,   4.743713834021820e-15,
   1.477362854897504e+00,  -1.683657265379623e-02,   4.881811701845469e-05,   6.027574758179434e-06,  -1.566923289718010e-07,  -2.349360534055132e-09,   2.037338653926982e-10,
  -1.159070565973102e-12,  -2.031269141297364e-13,   4.641817952205243e-15,   1.477372087531612e+00,  -1.683305552846016e-02,   4.863660362668902e-05,   6.022971656620742e-06,
  -1.561024628311504e-07,  -2.353874264024831e-09,   2.026367870801108e-10,  -1.127439544522098e-12,  -2.017891572506832e-13,   4.562196403579903e-15,   1.477377410637245e+00,
  -1.683102613741686e-02,   4.853195252074951e-05,   6.020313822669580e-06,  -1.557625238521642e-07,  -2.356459800117381e-09,   2.020047470189601e-10,  -1.109268534370223e-12,
  -2.010181416543649e-13,   4.516473239417473e-15,   1.477379408528626e+00,  -1.683026415855447e-02,   4.849267460057325e-05,   6.019315535848412e-06,  -1.556349648512417e-07,
  -2.357427030649591e-09,   2.017676184736746e-10,  -1.102460955996316e-12,  -2.007288127660224e-13,   4.499346720150401e-15,   1.477379739655624e+00,  -1.683013785374823e-02,
   4.848616475733408e-05,   6.019150042680527e-06,  -1.556138249444537e-07,  -2.357587169850992e-09,   2.017283220341790e-10,  -1.101333335963205e-12,  -2.006808626663983e-13,
   4.496510019362832e-15,   2.933214727463392e-03,  -3.512733851088917e-05,   3.757264686197526e-07,  -2.278899224444997e-09,  -1.765057032084569e-11,  -1.940719423257867e-13,
   3.830902933835282e-14,  -4.183138379262019e-16,  -3.289001356207126e-17,   8.515026629277134e-19,   2.933268166714036e-03,  -3.512831243596309e-05,   3.757118517562683e-07,
  -2.279185345049966e-09,  -1.757031254227279e-11,  -1.952564892875195e-13,   3.818095781958020e-14,  -4.141821938714100e-16,  -3.274593244891029e-17,   8.428397032368805e-19,
   2.933355894464273e-03,  -3.512991138222758e-05,   3.756879048590735e-07,  -2.279656249697156e-09,  -1.743875241919045e-11,  -1.971923391088907e-13,   3.797112040587099e-14,
  -4.074309362696942e-16,  -3.250978918404124e-17,   8.286940800589280e-19,   2.933448978449392e-03,  -3.513160811117508e-05,   3.756625619475104e-07,  -2.280157530224640e-09,
  -1.729942300595204e-11,  -1.992345353351555e-13,   3.774902698220137e-14,  -4.003099952098789e-16,  -3.225975318589190e-17,   8.137873865809196e-19,   2.933522234633712e-03,
  -3.513294353525812e-05,   3.756426651096131e-07,  -2.280553205615904e-09,  -1.718996237686363e-11,  -2.008331746764498e-13,   3.757464346901393e-14,  -3.947365483365704e-16,
  -3.206335847156081e-17,   8.021299173823164e-19,   2.933564511649236e-03,  -3.513371427053024e-05,   3.756312015460427e-07,  -2.280782023350066e-09,  -1.712686752155428e-11,
  -2.017523509751897e-13,   3.747416558850293e-14,  -3.915322985374756e-16,  -3.195016986908212e-17,   7.954317894723878e-19,   2.933580386983025e-03,  -3.513400369608432e-05,
   3.756269005080490e-07,  -2.280868034563126e-09,  -1.710318932178274e-11,  -2.020968636895261e-13,   3.743646579395995e-14,  -3.903313901693209e-16,  -3.190769568830847e-17,
   7.929221625099841e-19,   2.933583018541251e-03,  -3.513405167287131e-05,   3.756261877416318e-07,  -2.280882296785189e-09,  -1.709926508834195e-11,  -2.021539374919086e-13,
   3.743021812977807e-14,  -3.901324446573114e-16,  -3.190065652967965e-17,   7.925064503273375e-19,   2.650281746515651e-02,  -3.173225021198027e-04,   3.388150295147152e-06,
  -2.023357094360323e-08,  -1.699916354057227e-10,  -1.657486525085554e-12,   3.499164337558053e-13,  -3.849515134118981e-15,  -3.014048152477089e-16,   7.843233389182615e-18,
   2.650329934036038e-02,  -3.173311489513161e-04,   3.388009295107578e-06,  -2.023602115392905e-08,  -1.692586033174130e-10,  -1.668386695257432e-12,   3.487427329229929e-13,
  -3.811457854536776e-15,  -3.000869310427391e-16,   7.763457114844477e-18,   2.650409040267736e-02,  -3.173453449022931e-04,   3.387778268702852e-06,  -2.024005453340234e-08,
  -1.680570088492900e-10,  -1.686200253645948e-12,   3.468196882586141e-13,  -3.749270794092973e-15,  -2.979269346324981e-16,   7.633191705722848e-18,   2.650492976218437e-02,
  -3.173604089621799e-04,   3.387533740072257e-06,  -2.024434911511725e-08,  -1.667844624432885e-10,  -1.704992294013956e-12,   3.447843144519842e-13,  -3.683678412926262e-15,
  -2.956398129872704e-16,   7.495917865846214e-18,   2.650559032897087e-02,  -3.173722652244286e-04,   3.387341734665739e-06,  -2.024773969330361e-08,  -1.657847245576379e-10,
  -1.719702697874030e-12,   3.431861709510483e-13,  -3.632340231245511e-15,  -2.938433222296922e-16,   7.388565847596815e-18,   2.650597154955279e-02,  -3.173791080135123e-04,
   3.387231100773850e-06,  -2.024970074775697e-08,  -1.652084620802909e-10,  -1.728160767596499e-12,   3.422653353318186e-13,  -3.602825188912418e-15,  -2.928079327639230e-16,
   7.326883768157292e-18,   2.650611470064702e-02,  -3.173816776071836e-04,   3.387189589929228e-06,  -2.025043795183260e-08,  -1.649922030967317e-10,  -1.731330896052608e-12,
   3.419198327646650e-13,  -3.591763355030273e-15,  -2.924193987973376e-16,   7.303772990728549e-18,   2.650613842993586e-02,  -3.173821035571935e-04,   3.387182710667875e-06,
  -2.025056019658558e-08,  -1.649563621048802e-10,  -1.731856076013435e-12,   3.418625755549616e-13,  -3.589930823411900e-15,  -2.923550077237474e-16,   7.299944760255446e-18,
   7.421146154212464e-02,  -8.881484754433025e-04,   9.447890293590033e-06,  -5.455081394345042e-08,  -5.381370871488767e-10,  -4.069651390728781e-12,   1.002223064275421e-12,
  -1.120207806372183e-14,  -8.688770590404691e-16,   2.285676399646250e-17,   7.421280514639809e-02,  -8.881717858407360e-04,   9.447442682582820e-06,  -5.455687155387124e-08,
  -5.360378149690355e-10,  -4.101368260972431e-12,   9.988392584777933e-13,  -1.109116843908907e-14,  -8.650931411098201e-16,   2.262439326889115e-17,   7.421501084618450e-02,
  -8.882100555625761e-04,   9.446709139519259e-06,  -5.456684799931535e-08,  -5.325966989911397e-10,  -4.153201058417557e-12,   9.932950343122212e-13,  -1.090993740084573e-14,
  -8.588911184547390e-16,   2.224495943400062e-17,   7.421735120430510e-02,  -8.882506653261885e-04,   9.445932535395489e-06,  -5.457747699978016e-08,  -5.289524386103486e-10,
  -4.207880481693303e-12,   9.874269016167885e-13,  -1.071878167490139e-14,  -8.523237740693190e-16,   2.184511247843126e-17,   7.421919303518504e-02,  -8.882826273325385e-04,
   9.445322603590699e-06,  -5.458587326957781e-08,  -5.260894690162834e-10,  -4.250683154725111e-12,   9.828192939315133e-13,  -1.056916649308389e-14,  -8.471650298578925e-16,
   2.153242150044297e-17,   7.422025597447977e-02,  -8.883010739979617e-04,   9.444971104530477e-06,  -5.459073139013179e-08,  -5.244392282300360e-10,  -4.275293345067033e-12,
   9.801644158236972e-13,  -1.048315044603392e-14,  -8.441917518233645e-16,   2.135275648113323e-17,   7.422065511548284e-02,  -8.883080010493074e-04,   9.444839208442724e-06,
  -5.459255801549189e-08,  -5.238199307512841e-10,  -4.284517344466694e-12,   9.791682878425493e-13,  -1.045091277560402e-14,  -8.430760010890529e-16,   2.128544040929496e-17,
   7.422072127864476e-02,  -8.883091493148760e-04,   9.444817349804695e-06,  -5.459286092881353e-08,  -5.237172935988378e-10,  -4.286045438695094e-12,   9.790032078345828e-13,
  -1.044557219912488e-14,  -8.428910887500083e-16,   2.127428970788606e-17,   1.472773240037027e-01,  -1.761301889953687e-03,   1.862220928831767e-05,  -1.014059594977539e-07,
  -1.271186096298231e-09,  -6.185304186390777e-12,   2.062719751930643e-12,  -2.367315520455552e-14,  -1.805152298460531e-15,   4.834892614294691e-17,   1.472799719477600e-01,
  -1.761345215586466e-03,   1.862114832743859e-05,  -1.014153241555644e-07,  -1.266866284106254e-09,  -6.252327152373240e-12,   2.055688576779148e-12,  -2.343853755845019e-14,
  -1.797344093460524e-15,   4.785778368098728e-17,   1.472843188713779e-01,  -1.761416344646325e-03,   1.861940922798370e-05,  -1.014307651599425e-07,  -1.259785375353344e-09,
  -6.361857850158370e-12,   2.044168139523870e-12,  -2.305516084581740e-14,  -1.784545254919352e-15,   4.705580744118506e-17,   1.472889311506279e-01,  -1.761491822194418e-03,
   1.861756749279266e-05,  -1.014472405888392e-07,  -1.252286591604133e-09,  -6.477403180879043e-12,   2.031974443017473e-12,  -2.265078735772070e-14,  -1.770991416446589e-15,
   4.621068734980418e-17,   1.472925609354520e-01,  -1.761551226411721e-03,   1.861612062941822e-05,  -1.014602727465181e-07,  -1.246395570971004e-09,  -6.567850734998132e-12,
   2.022399909559324e-12,  -2.233428781957489e-14,  -1.760343888375957e-15,   4.554978208099371e-17,   1.472946557139296e-01,  -1.761585510948650e-03,   1.861528665430346e-05,
  -1.014678202077612e-07,  -1.242999976506077e-09,  -6.619855019971818e-12,   2.016883057531744e-12,  -2.215232681214897e-14,  -1.754206796357940e-15,   4.517004164447176e-17,
   1.472954423162722e-01,  -1.761598385360623e-03,   1.861497368444298e-05,  -1.014706593261322e-07,  -1.241725695715546e-09,  -6.639346397022676e-12,   2.014813086768666e-12,
  -2.208413013258736e-14,  -1.751903735098595e-15,   4.502776231712994e-17,   1.472955727064580e-01,  -1.761600519490696e-03,   1.861492181555064e-05,  -1.014711302127096e-07,
  -1.241514507555428e-09,  -6.642575434644447e-12,   2.014470047141582e-12,  -2.207283248693962e-14,  -1.751522047755622e-15,   4.500419418657197e-17,   2.477545456707836e-01,
  -2.959657021676788e-03,   3.100131574294944e-05,  -1.530226287451164e-07,  -2.663227125114806e-09,  -5.435116702756353e-12,   3.662386197780322e-12,  -4.379291795089458e-14,
  -3.242543673921384e-15,   8.930541311677824e-17,   2.477589529008364e-01,  -2.959722381613852e-03,   3.099908513393268e-05,  -1.530314040038834e-07,  -2.655559011585551e-09,
  -5.559112209905122e-12,   3.649753197280129e-12,  -4.335952516944497e-14,  -3.228670104826413e-15,   8.839935012073465e-17,   2.477661878599413e-01,  -2.959829683479932e-03,
   3.099542791308422e-05,  -1.530459347137546e-07,  -2.642989900240056e-09,  -5.761750318765393e-12,   3.629053851539905e-12,  -4.265133584167696e-14,  -3.205926774601532e-15,
   8.691985751996388e-17,   2.477738644088942e-01,  -2.959943543085067e-03,   3.099155367973222e-05,  -1.530615218902057e-07,  -2.629679350120461e-09,  -5.975517721954205e-12,
   3.607144243663270e-12,  -4.190435452771902e-14,  -3.181838536511849e-15,   8.536077111173579e-17,   2.477799056749310e-01,  -2.960033154127967e-03,   3.098850923791045e-05,
  -1.530739110186347e-07,  -2.619222855525327e-09,  -6.142853741078908e-12,   3.589940322209863e-12,  -4.131969462672266e-14,  -3.162913109466066e-15,   8.414152502776445e-17,
   2.477833921202446e-01,  -2.960084871594988e-03,   3.098675407331280e-05,  -1.530811097744237e-07,  -2.613195806809315e-09,  -6.239066837730312e-12,   3.580027244472924e-12,
  -4.098356192090300e-14,  -3.152003807486593e-15,   8.344097483202446e-17,   2.477847012986078e-01,  -2.960104292242137e-03,   3.098609533957014e-05,  -1.530838221769589e-07,
  -2.610934025304127e-09,  -6.275127925749743e-12,   3.576307740055565e-12,  -4.085758331867949e-14,  -3.147909706027230e-15,   8.317849596588741e-17,   2.477849183127894e-01,
  -2.960107511504217e-03,   3.098598616337792e-05,  -1.530842722813662e-07,  -2.610559178334157e-09,  -6.281101988818212e-12,   3.575691334800408e-12,  -4.083671334696241e-14,
  -3.147231179488881e-15,   8.313501714957177e-17,   3.789065778234651e-01,  -4.518971151708648e-03,   4.666677064479225e-05,  -1.934720788683055e-07,  -5.298208775865525e-09,
   3.580294229446668e-12,   6.058028852424550e-12,  -7.715141908582369e-14,  -5.428127042966667e-15,   1.561006410932567e-16,   3.789132098959377e-01,  -4.519053738039579e-03,
   4.666231852354267e-05,  -1.934688181331446e-07,  -5.285527883043097e-09,   3.361753977963308e-12,   6.036872310398957e-12,  -7.639378757894212e-14,  -5.405318119192985e-15,
   1.545201558047824e-16,   3.789240970700778e-01,  -4.519189316289359e-03,   4.665501739236089e-05,  -1.934636849343806e-07,  -5.264742535192359e-09,   3.004594154194557e-12,
   6.002205845128853e-12,  -7.515576072656715e-14,  -5.367919846167754e-15,   1.519393909642961e-16,   3.789356485973826e-01,  -4.519333174541369e-03,   4.664728084500376e-05,
  -1.934585360822006e-07,  -5.242731640193569e-09,   2.627800511763193e-12,   5.965510886350382e-12,  -7.384990258746789e-14,  -5.328300659746523e-15,   1.492197576230339e-16,
   3.789447392717218e-01,  -4.519446391227097e-03,   4.664119974774167e-05,  -1.934546988733196e-07,  -5.225440739107231e-09,   2.332835428777412e-12,   5.936696025010064e-12,
  -7.282779943957709e-14,  -5.297166266861489e-15,   1.470929134445918e-16,   3.789499855020436e-01,  -4.519511730593286e-03,   4.663769327372479e-05,  -1.934525702836199e-07,
  -5.215474550312380e-09,   2.163234314027958e-12,   5.920092145891490e-12,  -7.224016697190478e-14,  -5.279216584484279e-15,   1.458708706660665e-16,   3.789519554805198e-01,
  -4.519536266138872e-03,   4.663637713327971e-05,  -1.934517871929737e-07,  -5.211734551410241e-09,   2.099666091202151e-12,   5.913862087143264e-12,  -7.201992828411701e-14,
  -5.272479824695691e-15,   1.454129998988633e-16,   3.789522820309001e-01,  -4.519540333254870e-03,   4.663615899450965e-05,  -1.934516582392876e-07,  -5.211114719844001e-09,
   2.089135004370857e-12,   5.912829622216774e-12,  -7.198344287136561e-14,  -5.271363296547637e-15,   1.453371549365036e-16,   5.459633391251938e-01,  -6.495009266629517e-03,
   6.558395136659829e-05,  -1.874805061107333e-07,  -1.043758032580714e-08,   3.331601106647275e-11,   9.805565961282355e-12,  -1.378881167485808e-13,  -8.845837766945040e-15,
   2.728510250762223e-16,   5.459726545168354e-01,  -6.495089150925777e-03,   6.557515537256972e-05,  -1.874363776587260e-07,  -1.041705804000997e-08,   3.292495959262589e-11,
   9.771063834936593e-12,  -1.365635477610337e-13,  -8.809884906193290e-15,   2.700995471340806e-16,   5.459879463540669e-01,  -6.495220281072364e-03,   6.556072786018223e-05,
  -1.873643272158190e-07,  -1.038342022141489e-08,   3.228579916686653e-11,   9.714526255098515e-12,  -1.343990609073161e-13,  -8.750914150118952e-15,   2.656065444707319e-16,
   5.460041709721707e-01,  -6.495359402887257e-03,   6.554543617332539e-05,  -1.872884094366387e-07,  -1.034779961592684e-08,   3.161141310284120e-11,   9.654675746449600e-12,
  -1.321159259360139e-13,  -8.688412726096748e-15,   2.608716013345507e-16,   5.460169389613670e-01,  -6.495468879934961e-03,   6.553341384363178e-05,  -1.872290466519293e-07,
  -1.031981787093959e-08,   3.108341893328288e-11,   9.607674547417002e-12,  -1.303288616351711e-13,  -8.639275932547206e-15,   2.571685911695830e-16,   5.460243072688379e-01,
  -6.495532056265125e-03,   6.552648045124789e-05,  -1.871949411155015e-07,  -1.030368982376990e-08,   3.077980297806875e-11,   9.580589886680224e-12,  -1.293014177678108e-13,
  -8.610939254500026e-15,   2.550408641816575e-16,   5.460270740756638e-01,  -6.495555778659430e-03,   6.552387782458391e-05,  -1.871821631859621e-07,  -1.029763750381039e-08,
   3.066599968400205e-11,   9.570427007920532e-12,  -1.289163391603876e-13,  -8.600302569235277e-15,   2.542436453215897e-16,   5.460275327100227e-01,  -6.495559710935990e-03,
   6.552344645106849e-05,  -1.871800465919875e-07,  -1.029663445198998e-08,   3.064714609773037e-11,   9.568742770421734e-12,  -1.288525457019318e-13,  -8.598539599060678e-15,
   2.541115878352986e-16,   7.578210096704314e-01,  -8.978073574074878e-03,   8.719331745272851e-05,  -4.471484465305470e-08,  -2.127429913657301e-08,   1.177045913035238e-10,
   1.636541990440619e-11,  -2.712728173953283e-13,  -1.450619158815713e-14,   5.079705179396816e-16,   7.578333817840283e-01,  -8.978092096206725e-03,   8.717534630778193e-05,
  -4.455382103115505e-08,  -2.124003687782330e-08,   1.169330647715248e-10,   1.630875082277275e-11,  -2.688054517671002e-13,  -1.445162254000758e-14,   5.029012742847044e-16,
   7.578536907938656e-01,  -8.978122455095456e-03,   8.714586469607690e-05,  -4.429025210605335e-08,  -2.118387666289911e-08,   1.156717215997331e-10,   1.621587650680849e-11,
  -2.647733151962276e-13,  -1.436203848423779e-14,   4.946227106840195e-16,   7.578752377547873e-01,  -8.978154602857584e-03,   8.711461084551536e-05,  -4.401163876084927e-08,
  -2.112440420763682e-08,   1.143404423936935e-10,   1.611754325631062e-11,  -2.605198855997135e-13,  -1.426698489718360e-14,   4.858973024568127e-16,   7.578921935401560e-01,
  -8.978179856088470e-03,   8.709003445345377e-05,  -4.379312918801758e-08,  -2.107768431189145e-08,   1.132978447825342e-10,   1.604030909995901e-11,  -2.571904312717471e-13,
  -1.419218040226092e-14,   4.790727484989412e-16,   7.579019783397912e-01,  -8.978194411323614e-03,   8.707585916798424e-05,  -4.366732717505058e-08,  -2.105075548014450e-08,
   1.126981905577968e-10,   1.599579773809865e-11,  -2.552761377941848e-13,  -1.414901110000132e-14,   4.751510985521979e-16,   7.579056524941210e-01,  -8.978199873391067e-03,
   8.707053776217683e-05,  -4.362014466370904e-08,  -2.104064988357421e-08,   1.124734011014403e-10,   1.597909499361520e-11,  -2.545586597148334e-13,  -1.413280101090494e-14,
   4.736816737711657e-16,   7.579062615306589e-01,  -8.978200778618793e-03,   8.706965574499800e-05,  -4.361232651279121e-08,  -2.103897507632953e-08,   1.124361594138220e-10,
   1.597632689262112e-11,  -2.544397990372470e-13,  -1.413011398002251e-14,   4.734382638992488e-16,   1.031661735738091e+00,  -1.212500719793990e-02,   1.084127474253387e-04,
   5.358448457784589e-07,  -4.856549454919680e-08,   3.806073064101324e-10,   3.130293453033256e-11,  -6.995908235769553e-13,  -2.415641121325387e-14,   1.138962634725024e-15,
   1.031677081032805e+00,  -1.212477658316962e-02,   1.083716517160756e-04,   5.363696489824267e-07,  -4.849980026165443e-08,   3.786046484165769e-10,   3.120803894220228e-11,
  -6.940455162198793e-13,  -2.409139241471759e-14,   1.128091868949104e-15,   1.031702268650654e+00,  -1.212439783364870e-02,   1.083042266423679e-04,   5.372291748518048e-07,
  -4.839209813517434e-08,   3.753287522029231e-10,   3.105244233780311e-11,  -6.849815982004840e-13,  -2.398419602373735e-14,   1.110332144760935e-15,   1.031728988998993e+00,
  -1.212399573665708e-02,   1.082327379922741e-04,   5.381384546425786e-07,  -4.827801568166800e-08,   3.718687516537773e-10,   3.088760105007636e-11,  -6.754177284480227e-13,
  -2.386983815854871e-14,   1.091604757225992e-15,   1.031750013956643e+00,  -1.212367912918386e-02,   1.081765155165309e-04,   5.388520813179696e-07,  -4.818837529548730e-08,
   3.691572455453341e-10,   3.075805796507421e-11,  -6.679296188853809e-13,  -2.377939913742945e-14,   1.076950664787782e-15,   1.031762146229162e+00,  -1.212349634676251e-02,
   1.081440842342762e-04,   5.392631367113324e-07,  -4.813669939687828e-08,   3.675969931980179e-10,   3.068337160433103e-11,  -6.636235550229179e-13,  -2.372703106434928e-14,
   1.068527262103262e-15,   1.031766701707909e+00,  -1.212342769842636e-02,   1.081319089516481e-04,   5.394173425058404e-07,  -4.811730541235908e-08,   3.670119730050851e-10,
   3.065534042195552e-11,  -6.620095040059578e-13,  -2.370733368459014e-14,   1.065370560424962e-15,   1.031767456827353e+00,  -1.212341631836403e-02,   1.081298908817849e-04,
   5.394428964367268e-07,  -4.811409115299352e-08,   3.669150434001625e-10,   3.065069460655031e-11,  -6.617421057958327e-13,  -2.370406684524296e-14,   1.064847627696352e-15,
   1.411128077270750e+00,  -1.620762971992723e-02,   1.059575683477609e-04,   3.378494033698046e-06,  -1.614815868710460e-07,   1.654402885274155e-09,   1.101170225644498e-10,
  -4.550565173322323e-12,   1.643404454853615e-16,   4.793912822473096e-15,   1.411142881238582e+00,  -1.620617946356073e-02,   1.058210189031535e-04,   3.380737136250025e-06,
  -1.612467102681642e-07,   1.641186895990704e-09,   1.101035303441984e-10,  -4.526522136613176e-12,  -5.243305570137879e-16,   4.774748051229706e-15,   1.411167170516950e+00,
  -1.620379796666779e-02,   1.055969957680559e-04,   3.384406117594546e-06,  -1.608611505600451e-07,   1.619542305168647e-09,   1.100794392315196e-10,  -4.487123134883365e-12,
  -1.647580664899646e-15,   4.743209717174618e-15,   1.411192924529679e+00,  -1.620127011098416e-02,   1.053594867950417e-04,   3.388280960646954e-06,  -1.604520819162732e-07,
   1.596645757454781e-09,   1.100512495534134e-10,  -4.445415117126259e-12,  -2.829528381354312e-15,   4.709643198059995e-15,   1.411213179475761e+00,  -1.619928002292172e-02,
   1.051727085271763e-04,   3.391317306365786e-06,  -1.601301729737903e-07,   1.578676695105784e-09,   1.100271709728463e-10,  -4.412661299406255e-12,  -3.752580808114487e-15,
   4.683153741509929e-15,   1.411224863552863e+00,  -1.619813124326331e-02,   1.050649722709689e-04,   3.393064366674995e-06,  -1.599444055609754e-07,   1.568326675209279e-09,
   1.100125188282712e-10,  -4.393786772420160e-12,  -4.282436443406978e-15,   4.667837568581189e-15,   1.411229250010456e+00,  -1.619769981582942e-02,   1.050245270340599e-04,
   3.393719409206846e-06,  -1.598746504683158e-07,   1.564443969822160e-09,   1.100068742746726e-10,  -4.386704561111185e-12,  -4.480863736523920e-15,   4.662080842247574e-15,
   1.411229977074281e+00,  -1.619762829796047e-02,   1.050178232267834e-04,   3.393827939361538e-06,  -1.598630876920160e-07,   1.563800557813688e-09,   1.100059310986842e-10,
  -4.385530866150369e-12,  -4.513727503643505e-15,   4.661126301444293e-15,   2.798537009851293e-03,  -3.223571238226629e-05,   3.467037991843336e-07,  -2.548122480526272e-09,
  -1.376623271047542e-11,   4.979751280983228e-13,   1.714444329676921e-14,  -9.031888899618854e-16,   2.272285108923686e-18,   8.217816907340836e-19,   2.798586325133360e-03,
  -3.223679781101019e-05,   3.466922527905115e-07,  -2.547436000280293e-09,  -1.372955876559801e-11,   4.953416330666573e-13,   1.715121802252179e-14,  -8.990696195191783e-16,
   2.161431113343287e-18,   8.184046283835688e-19,   2.798667282998371e-03,  -3.223857951135014e-05,   3.466733201717095e-07,  -2.546311713331580e-09,  -1.366934329613673e-11,
   4.910271630898148e-13,   1.716202667616274e-14,  -8.923197041795158e-16,   1.980511375743680e-18,   8.128567063892866e-19,   2.798753183986559e-03,  -3.224046975276791e-05,
   3.466532619930463e-07,  -2.545122397382024e-09,  -1.360543771345253e-11,   4.864611741373511e-13,   1.717307155584291e-14,  -8.851745639408422e-16,   1.789984143313057e-18,
   8.069647708464700e-19,   2.798820787384614e-03,  -3.224195718006908e-05,   3.466374983981888e-07,  -2.544189030616804e-09,  -1.355513497156535e-11,   4.828763914207677e-13,
   1.718145829816127e-14,  -8.795636451406200e-16,   1.641078858856920e-18,   8.023241873194204e-19,   2.798859802174541e-03,  -3.224281552234249e-05,   3.466284098578220e-07,
  -2.543651419816808e-09,  -1.352610085027883e-11,   4.808110165722831e-13,   1.718617636605364e-14,  -8.763304240833790e-16,   1.555558593289693e-18,   7.996446181573961e-19,
   2.798874452530530e-03,  -3.224313782308488e-05,   3.466249987100824e-07,  -2.543449740569188e-09,  -1.351519760957821e-11,   4.800361038212521e-13,   1.718792502308644e-14,
  -8.751172532150127e-16,   1.523523340403574e-18,   7.986381544674489e-19,   2.798876881032223e-03,  -3.224319124823860e-05,   3.466244333526511e-07,  -2.543416319839092e-09,
  -1.351339020782626e-11,   4.799076855388340e-13,   1.718821367462351e-14,  -8.749162021505810e-16,   1.518217174016349e-18,   7.984713051806176e-19,   2.528613494429625e-02,
  -2.912345525268665e-04,   3.129273097688959e-06,  -2.281487803128165e-08,  -1.322827776050489e-10,   4.652606092841771e-12,   1.556858983511947e-13,  -8.276504848769331e-15,
   2.158885403863259e-17,   7.529239286093438e-18,   2.528658003954093e-02,  -2.912442700676790e-04,   3.129162036275955e-06,  -2.280846023469190e-08,  -1.319497066175767e-10,
   4.628473638669270e-12,   1.557508975358823e-13,  -8.238759881061399e-15,   2.056643653268161e-17,   7.498443559369024e-18,   2.528731072432212e-02,  -2.912602210510763e-04,
   3.128979916759291e-06,  -2.279794895506313e-08,  -1.314028274603865e-10,   4.588937297793129e-12,   1.558547158297365e-13,  -8.176909724960940e-15,   1.889777356328991e-17,
   7.447848828849071e-18,   2.528808602228047e-02,  -2.912771436549452e-04,   3.128786953556842e-06,  -2.278682902518233e-08,  -1.308224275460764e-10,   4.547096118598354e-12,
   1.559609648420166e-13,  -8.111437366613593e-15,   1.714046851431229e-17,   7.394113139335119e-18,   2.528869617494824e-02,  -2.912904599376924e-04,   3.128635293018882e-06,
  -2.277810169277889e-08,  -1.303655655898210e-10,   4.514246379478658e-12,   1.560417642853329e-13,  -8.060022872106913e-15,   1.576703676434473e-17,   7.351787389514650e-18,
   2.528904830161804e-02,  -2.912981442661346e-04,   3.128547847941895e-06,  -2.277307463169865e-08,  -1.301018684990956e-10,   4.495319980622576e-12,   1.560872691416648e-13,
  -8.030395713341864e-15,   1.497822965549693e-17,   7.327346568358917e-18,   2.528918052785922e-02,  -2.913010296645958e-04,   3.128515026791541e-06,  -2.277118874341900e-08,
  -1.300028414324690e-10,   4.488218941286081e-12,   1.561041442955482e-13,  -8.019278956750039e-15,   1.468274675210249e-17,   7.318166237671899e-18,   2.528920244620785e-02,
  -2.913015079531360e-04,   3.128509587025643e-06,  -2.277087622658749e-08,  -1.299864259541312e-10,   4.487042159412069e-12,   1.561069304017077e-13,  -8.017436645590833e-15,
   1.463380428715471e-17,   7.316644332649323e-18,   7.080568304351056e-02,  -8.153285822021557e-04,   8.742762825688981e-06,  -6.265760092678659e-08,  -4.170298325003674e-10,
   1.393645869654832e-11,   4.404294918247390e-13,  -2.386284749803402e-14,   6.695863671046009e-17,   2.169586311038063e-17,   7.080692649766569e-02,  -8.153552642314721e-04,
   8.742412088323062e-06,  -6.263835420504665e-08,  -4.160873348629066e-10,   1.386687934986270e-11,   4.406348601880306e-13,  -2.375405990295317e-14,   6.397108703963929e-17,
   2.160802019852670e-17,   7.080896779374872e-02,  -8.153990612996199e-04,   8.741836878513145e-06,  -6.260682844362771e-08,  -4.145397879179870e-10,   1.375288702924533e-11,
   4.409635648197046e-13,  -2.357579366949650e-14,   5.909504337427046e-17,   2.146368485315834e-17,   7.081113371892470e-02,  -8.154455255015272e-04,   8.741227327979627e-06,
  -6.257347333066912e-08,  -4.128973413208301e-10,   1.363224924102793e-11,   4.413009187309268e-13,  -2.338708300135012e-14,   5.395979190699844e-17,   2.131036615746316e-17,
   7.081283827888568e-02,  -8.154820873820470e-04,   8.740748181662201e-06,  -6.254729219875478e-08,  -4.116044578273496e-10,   1.353753578917863e-11,   4.415581794503118e-13,
  -2.323888806225585e-14,   4.994617335052105e-17,   2.118958587886767e-17,   7.081382199993669e-02,  -8.155031856802344e-04,   8.740471886723222e-06,  -6.253221038776504e-08,
  -4.108582033053978e-10,   1.348296654709076e-11,   4.417033586916080e-13,  -2.315349073598429e-14,   4.764096636784527e-17,   2.111983529486470e-17,   7.081419139435961e-02,
  -8.155111078707981e-04,   8.740368178657651e-06,  -6.252655227432465e-08,  -4.105779574582330e-10,   1.346249258252093e-11,   4.417572542808899e-13,  -2.312144755560840e-14,
   4.677743808095182e-17,   2.109363472404368e-17,   7.081425262663478e-02,  -8.155124210645941e-04,   8.740350989852592e-06,  -6.252561463824188e-08,  -4.105315016555672e-10,
   1.345909964369660e-11,   4.417661555369653e-13,  -2.311613722532134e-14,   4.663440658703679e-17,   2.108929115783083e-17,   1.405218845821594e-01,  -1.617530907789293e-03,
   1.728708559327677e-05,  -1.203647961319402e-07,  -9.796576819713463e-10,   3.064612952340957e-11,   8.880681736440222e-13,  -4.962272590649813e-14,   1.556671337319208e-16,
   4.504645678394865e-17,   1.405243430011806e-01,  -1.617582144641919e-03,   1.728625989343825e-05,  -1.203224028180424e-07,  -9.777563700540018e-10,   3.050143535886888e-11,
   8.885579330202906e-13,  -4.939677042783659e-14,   1.493208633927780e-16,   4.486721977271046e-17,   1.405283788108040e-01,  -1.617666245432640e-03,   1.728490554855356e-05,
  -1.202529546646190e-07,  -9.746343718646994e-10,   3.026438138248703e-11,   8.893440193741848e-13,  -4.902649400044350e-14,   1.389625072468427e-16,   4.457265399317501e-17,
   1.405326610039160e-01,  -1.617755465506821e-03,   1.728347008112681e-05,  -1.201794647714405e-07,  -9.713207717845018e-10,   3.001350703728512e-11,   8.901538394343484e-13,
  -4.863450792577407e-14,   1.280528648227140e-16,   4.425967361320242e-17,   1.405360310307702e-01,  -1.617825669620768e-03,   1.728234151727367e-05,  -1.201217724062710e-07,
  -9.687122976454945e-10,   2.981654357542116e-11,   8.907736675971386e-13,  -4.832666913716586e-14,   1.195256233171086e-16,   4.401305813248565e-17,   1.405379759064642e-01,
  -1.617866180762085e-03,   1.728169066466209e-05,  -1.200885348936294e-07,  -9.672066381158386e-10,   2.970306269621663e-11,   8.911243900886909e-13,  -4.814927258508741e-14,
   1.146278472663531e-16,   4.387061464327384e-17,   1.405387062204480e-01,  -1.617881392149342e-03,   1.728144635067648e-05,  -1.200760648085941e-07,  -9.666411996640485e-10,
   2.966048549603400e-11,   8.912547710998968e-13,  -4.808270818707880e-14,   1.127931098679208e-16,   4.381710392559727e-17,   1.405388272801185e-01,  -1.617883913604459e-03,
   1.728140585675997e-05,  -1.200739982899859e-07,  -9.665474676088097e-10,   2.965342961414494e-11,   8.912763141177541e-13,  -4.807167681140671e-14,   1.124892091819885e-16,
   4.380823261745232e-17,   2.363993110555982e-01,  -2.719695995295549e-03,   2.891970122995569e-05,  -1.923140892082496e-07,  -2.038909765515921e-09,   5.933874178590185e-11,
   1.527433697306456e-12,  -8.939607132705658e-14,   3.269051264855431e-16,   8.084871195544183e-17,   2.364034230782658e-01,  -2.719777808275659e-03,   2.891797886727629e-05,
  -1.922318409343503e-07,  -2.035637042120469e-09,   5.907805316820144e-11,   1.528493745396141e-12,  -8.899029114158889e-14,   3.151127373146627e-16,   8.053605848598665e-17,
   2.364101734550015e-01,  -2.719912092658985e-03,   2.891515335355174e-05,  -1.920970825311539e-07,  -2.030262829130993e-09,   5.865096159275331e-11,   1.530200655991899e-12,
  -8.832530045384127e-14,   2.958639106983993e-16,   8.002205582803426e-17,   2.364173358901502e-01,  -2.720054545020376e-03,   2.891215801548464e-05,  -1.919544537299222e-07,
  -2.024558352226673e-09,   5.819896677528474e-11,   1.531966694582285e-12,  -8.762127616469049e-14,   2.755888184487485e-16,   7.947568541894734e-17,   2.364229725932652e-01,
  -2.720166631377691e-03,   2.890980266038871e-05,  -1.918424645831119e-07,  -2.020067457024364e-09,   5.784409944869767e-11,   1.533324039454341e-12,  -8.706835200548686e-14,
   2.597399992840385e-16,   7.904499967800063e-17,   2.364262255763469e-01,  -2.720231308837088e-03,   2.890844413739513e-05,  -1.917779377395491e-07,  -2.017475102745932e-09,
   5.763964093184335e-11,   1.534094391808589e-12,  -8.674970864805489e-14,   2.506364148350579e-16,   7.879617134255058e-17,   2.364274470908963e-01,  -2.720255594021114e-03,
   2.890793414943875e-05,  -1.917537269637136e-07,  -2.016501540890573e-09,   5.756292939200561e-11,   1.534381215318305e-12,  -8.663014188239044e-14,   2.472260556829941e-16,
   7.870268318534171e-17,   2.364276495737345e-01,  -2.720259619540674e-03,   2.890784961959805e-05,  -1.917497147197348e-07,  -2.016340153451257e-09,   5.755021676664500e-11,
   1.534428631223876e-12,  -8.661032656930402e-14,   2.466611682246486e-16,   7.868718352836304e-17,   3.615606891231357e-01,  -4.156312823267341e-03,   4.386173071943534e-05,
  -2.707858917381415e-07,  -4.024907868651519e-09,   1.091577495863272e-10,   2.404910451057081e-12,  -1.507843196487597e-13,   6.743483788270656e-16,   1.352048049674827e-16,
   3.615669241180176e-01,  -4.156427892745329e-03,   4.385832332243070e-05,  -2.706342554996544e-07,  -4.019748087710771e-09,   1.087179648254199e-10,   2.407170052542281e-12,
  -1.501050774427807e-13,   6.535708937518522e-16,   1.347065035443293e-16,   3.615771595257389e-01,  -4.156616751993903e-03,   4.385273272095938e-05,  -2.703857679229114e-07,
  -4.011274210972289e-09,   1.079974453359665e-10,   2.410820808380096e-12,  -1.489918488850745e-13,   6.196520427442659e-16,   1.338868123591754e-16,   3.615880196151294e-01,
  -4.156817083915850e-03,   4.384680500013577e-05,  -2.701227112460080e-07,  -4.002278389457295e-09,   1.072348983077556e-10,   2.414615000846521e-12,  -1.478131549651779e-13,
   5.839199399749770e-16,   1.330148528924445e-16,   3.615965662229311e-01,  -4.156974701115744e-03,   4.384214299534933e-05,  -2.699161237151312e-07,  -3.995195495346534e-09,
   1.066362015091022e-10,   2.417543694009118e-12,  -1.468873491939367e-13,   5.559850392011989e-16,   1.323270495544255e-16,   3.616014985013307e-01,  -4.157065647034697e-03,
   4.383945372121264e-05,  -2.697970739560540e-07,  -3.991106574466318e-09,   1.062912552112763e-10,   2.419210985763123e-12,  -1.463537839557013e-13,   5.399377868644186e-16,
   1.319294862813903e-16,   3.616033505951997e-01,  -4.157099794722417e-03,   4.383844411021400e-05,  -2.697524028179687e-07,  -3.989570910348813e-09,   1.061618327438683e-10,
   2.419832748485283e-12,  -1.461535639916530e-13,   5.339259446227955e-16,   1.317800815368352e-16,   3.616036576049125e-01,  -4.157105455010644e-03,   4.383827676530551e-05,
  -2.697449996898507e-07,  -3.989316339749690e-09,   1.061403848288862e-10,   2.419935586778923e-12,  -1.461203820065582e-13,   5.329301368570849e-16,   1.317553094812167e-16,
   5.210145499201574e-01,  -5.982050449688523e-03,   6.239088545389391e-05,  -3.381276446160530e-07,  -7.854291090347822e-09,   2.001945610022874e-10,   3.591045684262439e-12,
  -2.503327893543553e-13,   1.453612323273116e-15,   2.200670520645632e-16,   5.210234152041473e-01,  -5.982193820280152e-03,   6.238422290620107e-05,  -3.378489041943174e-07,
  -7.846566842936150e-09,   1.994641091457195e-10,   3.596082947954230e-12,  -2.492253703397746e-13,   1.416928746956808e-15,   2.193258539004673e-16,   5.210379683247910e-01,
  -5.982429101737876e-03,   6.237329004062926e-05,  -3.373920506597894e-07,  -7.833878866438507e-09,   1.982673330961505e-10,   3.604248656512238e-12,  -2.474101363277216e-13,
   1.357033551261194e-15,   2.181051869367532e-16,   5.210534093897355e-01,  -5.982678638733500e-03,   6.236169593044381e-05,  -3.369083035452940e-07,  -7.820406007024535e-09,
   1.970006910132514e-10,   3.612772577403792e-12,  -2.454878097556129e-13,   1.293922946687011e-15,   2.168047741458543e-16,   5.210655609225018e-01,  -5.982874942628003e-03,
   6.235257601654096e-05,  -3.365283220958403e-07,  -7.809795669951107e-09,   1.960061729018694e-10,   3.619379603792073e-12,  -2.439776691800279e-13,   1.244574117952156e-15,
   2.157776382151448e-16,   5.210725735425894e-01,  -5.982988200192594e-03,   6.234731462518774e-05,  -3.363093196753559e-07,  -7.803669402796602e-09,   1.954331525250354e-10,
   3.623152155971589e-12,  -2.431072379846205e-13,   1.216221682940860e-15,   2.151833908529686e-16,   5.210752068006913e-01,  -5.983030723253232e-03,   6.234533927758307e-05,
  -3.362271372962953e-07,  -7.801368395523558e-09,   1.952181543873687e-10,   3.624561149095781e-12,  -2.427805906405130e-13,   1.205599163815356e-15,   2.149599698568993e-16,
   5.210756432982511e-01,  -5.983037771727935e-03,   6.234501185428679e-05,  -3.362135173020717e-07,  -7.800986942576343e-09,   1.951825246884624e-10,   3.624794307331537e-12,
  -2.427264551579909e-13,   1.203839599697475e-15,   2.149229201617979e-16,   7.232926320559790e-01,  -8.288158260814766e-03,   8.475238819224760e-05,  -3.482285094496201e-07,
  -1.580315235550542e-08,   3.847210621787641e-10,   5.167630436791410e-12,  -4.311386043430343e-13,   3.535837026671186e-15,   3.604209360960060e-16,   7.233046659372937e-01,
  -8.288305032585493e-03,   8.473895817606513e-05,  -3.476916298900158e-07,  -1.579197301752461e-08,   3.834616523418752e-10,   5.180298435409167e-12,  -4.293187059127532e-13,
   3.466811993532701e-15,   3.594412674688420e-16,   7.233244201305111e-01,  -8.288545819013201e-03,   8.471691757566595e-05,  -3.468115385140182e-07,  -1.577360152890578e-08,
   3.813980406868203e-10,   5.200899550716411e-12,  -4.263347519247504e-13,   3.354078297823404e-15,   3.578228205250859e-16,   7.233453789940871e-01,  -8.288801090451405e-03,
   8.469354023957250e-05,  -3.458794354703447e-07,  -1.575408257729607e-08,   3.792137034416425e-10,   5.222494199538863e-12,  -4.231735999469854e-13,   3.235247990500360e-15,
   3.560918516476785e-16,   7.233618723819119e-01,  -8.289001830158448e-03,   8.467514899595754e-05,  -3.451471249543927e-07,  -1.573870281018527e-08,   3.774984626864622e-10,
   5.239298347517776e-12,  -4.206894314548354e-13,   3.142297324530638e-15,   3.547197808277051e-16,   7.233713904983267e-01,  -8.289117616785191e-03,   8.466453779409622e-05,
  -3.447249985291320e-07,  -1.572981957247765e-08,   3.765101034704113e-10,   5.248920041049545e-12,  -4.192572473576259e-13,   3.088881351883686e-15,   3.539240437752981e-16,
   7.233749645435934e-01,  -8.289161083690100e-03,   8.466055370119621e-05,  -3.445665811080488e-07,  -1.572648245863254e-08,   3.761392556503618e-10,   5.252518687414285e-12,
  -4.187197279714743e-13,   3.068866087555330e-15,   3.536245059525651e-16,   7.233755569873689e-01,  -8.289168288312287e-03,   8.465989330815023e-05,  -3.445403261761253e-07,
  -1.572592921210712e-08,   3.760777976585329e-10,   5.253114455827725e-12,  -4.186306412243898e-13,   3.065550535906593e-15,   3.535748148296634e-16,   9.849194368417632e-01,
  -1.124438850584939e-02,   1.105431089367836e-04,  -1.472303684950441e-07,  -3.531758646038925e-08,   8.471819969495223e-10,   6.941965268759431e-12,  -8.493635769627465e-13,
   1.134336599804503e-14,   6.004923350145215e-16,   9.849351074727154e-01,  -1.124444718069475e-02,   1.105130402267840e-04,  -1.460457394163590e-07,  -3.530227355107723e-08,
   8.446926262987414e-10,   6.983977474471912e-12,  -8.463008356022299e-13,   1.118872498323190e-14,   6.000173526736890e-16,   9.849608302717119e-01,  -1.124454314429930e-02,
   1.104636871765070e-04,  -1.441035191489256e-07,  -3.527707179530100e-08,   8.406125273162766e-10,   7.052508468699866e-12,  -8.412748651216057e-13,   1.093599426508698e-14,
   5.992034939411443e-16,   9.849881199671116e-01,  -1.124464447936989e-02,   1.104113328482865e-04,  -1.420461218016316e-07,  -3.525024534320685e-08,   8.362922022351290e-10,
   7.124630515883986e-12,  -8.359447285379913e-13,   1.066937022104580e-14,   5.982939187891031e-16,   9.850095940730893e-01,  -1.124472387635666e-02,   1.103701391978991e-04,
  -1.404294331408891e-07,  -3.522907121014771e-08,   8.328985799849243e-10,   7.180961816021508e-12,  -8.317519680321158e-13,   1.046065017665974e-14,   5.975450289225496e-16,
   9.850219859860584e-01,  -1.124476955602008e-02,   1.103463693425259e-04,  -1.394974092036989e-07,  -3.521682661638013e-08,   8.309426575713467e-10,   7.213300155007052e-12,
  -8.293330970785748e-13,   1.034063966004778e-14,   5.970996679387357e-16,   9.850266390432549e-01,  -1.124478668238220e-02,   1.103374442454325e-04,  -1.391476135980705e-07,
  -3.521222401359411e-08,   8.302086812326053e-10,   7.225411151807566e-12,  -8.284249502895790e-13,   1.029565869825149e-14,   5.969299529013834e-16,   9.850274103419895e-01,
  -1.124478951990806e-02,   1.103359648208341e-04,  -1.390896399189190e-07,  -3.521146082200228e-08,   8.300870401004406e-10,   7.227417016499516e-12,  -8.282744206255827e-13,
   1.028820689845414e-14,   5.969016897507729e-16,   1.348191871605230e+00,  -1.523848581582813e-02,   1.324397386585613e-04,   1.161480049128545e-06,  -1.117317192954586e-07,
   2.893776680453909e-09,   1.826748203743404e-12,  -2.749559134600558e-12,   8.374932229854766e-14,   1.003186672083038e-16,   1.348210526997006e+00,  -1.523797566400678e-02,
   1.323443828028879e-04,   1.165528887138145e-06,  -1.117240029223562e-07,   2.885576357928143e-09,   2.149409478378764e-12,  -2.748578073564294e-12,   8.321630020727149e-14,
   1.178718201852164e-16,   1.348241143043317e+00,  -1.523713693406158e-02,   1.321878466960328e-04,   1.172167283014908e-06,  -1.117108432991725e-07,   2.872116620810153e-09,
   2.677579232039450e-12,  -2.746903738912408e-12,   8.234197558039039e-14,   1.465247635710788e-16,   1.348273615718386e+00,  -1.523624530220517e-02,   1.320217580557320e-04,
   1.179199682658091e-06,  -1.116962126158194e-07,   2.857838162319982e-09,   3.235928649923519e-12,  -2.745040810166254e-12,   8.141523741304028e-14,   1.767060101970561e-16,
   1.348299162243374e+00,  -1.523554237193655e-02,   1.318910515375817e-04,   1.184725928175641e-06,  -1.116842160582690e-07,   2.846603433740380e-09,   3.673847883598940e-12,
  -2.743512429376231e-12,   8.068661485194780e-14,   2.002985249740645e-16,   1.348313901778076e+00,  -1.523513621194668e-02,   1.318156207434029e-04,   1.187911909904456e-06,
  -1.116770996816114e-07,   2.840120670818239e-09,   3.925976790682974e-12,  -2.742605504927853e-12,   8.026640652298108e-14,   2.138500630745563e-16,   1.348319435889527e+00,
  -1.523498360317010e-02,   1.317872962064137e-04,   1.189107649762877e-06,  -1.116743909856255e-07,   2.837686523689955e-09,   4.020539795303229e-12,  -2.742260255991777e-12,
   8.010867007537866e-14,   2.189266831704501e-16,   1.348320353209183e+00,  -1.523495830124649e-02,   1.317826010342265e-04,   1.189305827633359e-06,  -1.116739400598411e-07,
   2.837283039294459e-09,   4.036208958669635e-12,  -2.742202778879080e-12,   8.008252596292774e-14,   2.197675666331066e-16,   2.674943608367892e-03,  -2.958727515215075e-05,
   3.151833684275497e-07,  -2.674505181885392e-09,  -1.602478137877034e-12,   6.358803094212459e-13,  -3.810936333457621e-15,  -5.166143879568231e-16,   1.700100737585390e-17,
   2.104344115740753e-20,   2.674988458441569e-03,  -2.958841380895433e-05,   3.151819588617818e-07,  -2.673613283869246e-09,  -1.609835428686843e-12,   6.343394644369493e-13,
  -3.745231637262370e-15,  -5.164336576247957e-16,   1.690261242667451e-17,   2.378450107676191e-20,   2.675062086947002e-03,  -2.959028282626851e-05,   3.151796405365835e-07,
  -2.672150672412447e-09,  -1.621813321829151e-12,   6.318103552603657e-13,  -3.637648889023750e-15,  -5.161270085843831e-16,   1.674129513579803e-17,   2.825803002382606e-20,
   2.675140212279379e-03,  -2.959226562854600e-05,   3.151771748107976e-07,  -2.670600880427089e-09,  -1.634386726955828e-12,   6.291273808351114e-13,  -3.523878393714817e-15,
  -5.157881592909768e-16,   1.657041709944786e-17,   3.296903926697025e-20,   2.675201697179812e-03,  -2.959382583700824e-05,   3.151752300959944e-07,  -2.669382743747321e-09,
  -1.644183734640898e-12,   6.270163136587528e-13,  -3.434617532476319e-15,  -5.155117715047554e-16,   1.643614768238595e-17,   3.665080740215360e-20,   2.675237181259316e-03,
  -2.959472615672322e-05,   3.151741060978900e-07,  -2.668680357604022e-09,  -1.649798425969893e-12,   6.257981580032631e-13,  -3.383214336959446e-15,  -5.153483835302460e-16,
   1.635874368986474e-17,   3.876529845608508e-20,   2.675250505872894e-03,  -2.959506421549459e-05,   3.151736837117199e-07,  -2.668416722623715e-09,  -1.651899367507046e-12,
   6.253407632902131e-13,  -3.363932894098409e-15,  -5.152862981469794e-16,   1.632969392363918e-17,   3.955736101920638e-20,   2.675252714617733e-03,  -2.959512025250758e-05,
   3.151736136786419e-07,  -2.668373027576985e-09,  -1.652247236805005e-12,   6.252649454165811e-13,  -3.360737824860824e-15,  -5.152759680519974e-16,   1.632487936480438e-17,
   3.968855392392114e-20,   2.416949090280376e-02,  -2.673234477474242e-04,   2.846317826938773e-06,  -2.405865701519618e-08,  -1.935916042655054e-11,   5.884735904749777e-12,
  -3.605110484815606e-14,  -4.716231487584893e-15,   1.560315943378219e-16,   1.732022530643184e-19,   2.416989592070660e-02,  -2.673336897755032e-04,   2.846300905198501e-06,
  -2.405040135374348e-08,  -1.942897852848838e-11,   5.870667926853332e-12,  -3.544803923757857e-14,  -4.714671821821571e-15,   1.551305985856367e-16,   1.984733013134736e-19,
   2.417056082136201e-02,  -2.673505012030465e-04,   2.846273084589855e-06,  -2.403686280720637e-08,  -1.954267571145503e-11,   5.847576865302146e-12,  -3.446059315042126e-14,
  -4.712019628126396e-15,   1.536534032404777e-16,   2.397177738689785e-19,   2.417126632992735e-02,  -2.673683360057959e-04,   2.846243509585471e-06,  -2.402251700999789e-08,
  -1.966206830979546e-11,   5.823080737453807e-12,  -3.341634492020816e-14,  -4.709081238367359e-15,   1.520886268373607e-16,   2.831531265183985e-19,   2.417182156712348e-02,
  -2.673823696141711e-04,   2.846220194185012e-06,  -2.401124101532376e-08,  -1.975512838428939e-11,   5.803806058095910e-12,  -3.259705380332169e-14,  -4.706679163887856e-15,
   1.508590620098574e-16,   3.170999158140356e-19,   2.417214200466399e-02,  -2.673904676924710e-04,   2.846206722570457e-06,  -2.400473911900496e-08,  -1.980847395784260e-11,
   5.792683855451153e-12,  -3.212524132022282e-14,  -4.705257111079675e-15,   1.501502298236961e-16,   3.365964366008460e-19,   2.417226233201398e-02,  -2.673935084140682e-04,
   2.846201660860549e-06,  -2.400229866970045e-08,  -1.982843754469041e-11,   5.788507661891941e-12,  -3.194826306303612e-14,  -4.704716370436227e-15,   1.498842028996235e-16,
   3.438996719410448e-19,   2.417228227798757e-02,  -2.673940124473164e-04,   2.846200821652455e-06,  -2.400189418713292e-08,  -1.983174319840132e-11,   5.787815414156681e-12,
  -3.191893651134310e-14,  -4.704626379435325e-15,   1.498401128724510e-16,   3.451093438757435e-19,   6.767936210992177e-02,  -7.484836443579504e-04,   7.961302160369768e-06,
  -6.674097296158708e-08,  -8.295285483484338e-11,   1.730146421348099e-11,  -1.106161678839765e-13,  -1.348964813986639e-14,   4.512873052572290e-16,   3.794094648688684e-19,
   6.768049491682107e-02,  -7.485120518335511e-04,   7.961230120956730e-06,  -6.671669144501183e-08,  -8.316833167494767e-11,   1.726121736165074e-11,  -1.088716705404042e-13,
  -1.348574138875953e-14,   4.486941531769778e-16,   4.531867021557359e-19,   6.768235459514088e-02,  -7.485586798906784e-04,   7.961111730141727e-06,  -6.667687077159999e-08,
  -8.351940880624906e-11,   1.719515534101765e-11,  -1.060152328388166e-13,  -1.347905991932405e-14,   4.444424958912580e-16,   5.736036088016484e-19,   6.768432784732398e-02,
  -7.486081457973195e-04,   7.960985937357196e-06,  -6.663467417284955e-08,  -8.388831584146546e-11,   1.712507192817109e-11,  -1.029944305172440e-13,  -1.347160767210330e-14,
   4.399385635149351e-16,   7.004254863903238e-19,   6.768588079974076e-02,  -7.486470684434211e-04,   7.960886814678928e-06,  -6.660150592307372e-08,  -8.417603667587374e-11,
   1.706992593166946e-11,  -1.006243482161359e-13,  -1.346548122449542e-14,   4.363993345370111e-16,   7.995489588753674e-19,   6.768677703597188e-02,  -7.486695285462770e-04,
   7.960829559929662e-06,  -6.658238018856251e-08,  -8.434104102100523e-11,   1.703810419495854e-11,  -9.925945332020516e-14,  -1.346184107815570e-14,   4.343589459241078e-16,
   8.564806082213996e-19,   6.768711358102615e-02,  -7.486779619870522e-04,   7.960808050946345e-06,  -6.657520136782747e-08,  -8.440280447502504e-11,   1.702615560020053e-11,
  -9.874747447898741e-14,  -1.346045446752464e-14,   4.335931708937852e-16,   8.778072003659962e-19,   6.768716936815646e-02,  -7.486793599215027e-04,   7.960804485036876e-06,
  -6.657401153815910e-08,  -8.441303224687399e-11,   1.702417499117283e-11,  -9.866263581191613e-14,  -1.346022357878607e-14,   4.334662544398784e-16,   8.813396567368198e-19,
   1.343188985559491e-01,  -1.485226341368960e-03,   1.577140775625420e-05,  -1.304240998219428e-07,  -2.580331643856997e-10,   3.702866834891848e-11,  -2.517541150176309e-13,
  -2.768331752092160e-14,   9.430324078685126e-16,   3.754497462967760e-19,   1.343211424944527e-01,  -1.485281838729908e-03,   1.577118465728946e-05,  -1.303721027991724e-07,
  -2.585274069155468e-10,   3.694604359716942e-11,  -2.481077948799484e-13,  -2.767723040322444e-14,   9.376591015173447e-16,   5.319149816881394e-19,   1.343248262594017e-01,
  -1.485372930751055e-03,   1.577081811284033e-05,  -1.302868262054152e-07,  -2.593332194086779e-10,   3.681041751990207e-11,  -2.421371835342344e-13,  -2.766666908405803e-14,
   9.288486708440638e-16,   7.873142707240351e-19,   1.343287349871060e-01,  -1.485469564860189e-03,   1.577042878668319e-05,  -1.301964565710732e-07,  -2.601806962545639e-10,
   3.666652994188224e-11,  -2.358228341876723e-13,  -2.765469325515917e-14,   9.195147733786796e-16,   1.056327580181868e-18,   1.343318111534500e-01,  -1.485545600809115e-03,
   1.577012210102318e-05,  -1.301254187547958e-07,  -2.608422069819067e-10,   3.655330623630341e-11,  -2.308685489499181e-13,  -2.764471342788971e-14,   9.121796162088469e-16,
   1.266608554436655e-18,   1.343335864600177e-01,  -1.485589476391439e-03,   1.576994499339900e-05,  -1.300844549344877e-07,  -2.612217932776230e-10,   3.648796943674193e-11,
  -2.280153987963803e-13,  -2.763873225026024e-14,   9.079506505613962e-16,   1.387392132484258e-18,   1.343342531035514e-01,  -1.485605950927903e-03,   1.576987846636099e-05,
  -1.300690789427361e-07,  -2.613639192161776e-10,   3.646343612723221e-11,  -2.269451583060196e-13,  -2.763644445991631e-14,   9.063634464854314e-16,   1.432639265873219e-18,
   1.343343636091678e-01,  -1.485608681755842e-03,   1.576986743742654e-05,  -1.300665304859485e-07,  -2.613874568739062e-10,   3.645936944953764e-11,  -2.267678110566505e-13,
  -2.763606302306308e-14,   9.061003877219782e-16,   1.440133915716452e-18,   2.259679737682015e-01,  -2.498024946564331e-03,   2.645960171239185e-05,  -2.142517494170267e-07,
  -6.729125696261220e-10,   6.924397489489988e-11,  -5.091674729005198e-13,  -4.886423088971417e-14,   1.710458577757930e-15,  -4.747653559635048e-19,   2.259717379969863e-01,
  -2.498116071825901e-03,   2.645902147449313e-05,  -2.141544421166225e-07,  -6.739211348643927e-10,   6.909804620501354e-11,  -5.025511165041730e-13,  -4.885894697902073e-14,
   1.700844936656292e-15,  -1.848593314819309e-19,   2.259779175273664e-01,  -2.498265638957561e-03,   2.645806832236683e-05,  -2.139948464779382e-07,  -6.755667556916109e-10,
   6.885849701853774e-11,  -4.917168816106271e-13,  -4.884921910200480e-14,   1.685080324194776e-15,   2.884166316302630e-19,   2.259844744046447e-01,  -2.498424300860298e-03,
   2.645705614532927e-05,  -2.138257070797395e-07,  -6.772991800561415e-10,   6.860434030573720e-11,  -4.802583827429372e-13,  -4.883747065770810e-14,   1.668377108733927e-15,
   7.870024289782553e-19,   2.259896346420888e-01,  -2.498549139392619e-03,   2.645625897361793e-05,  -2.136927411109511e-07,  -6.786527015080944e-10,   6.840433560971645e-11,
  -4.712675847322591e-13,  -4.882719600790918e-14,   1.655249272494246e-15,   1.176793794147289e-18,   2.259926126921946e-01,  -2.498621174444965e-03,   2.645579867738513e-05,
  -2.136160630230517e-07,  -6.794298805508512e-10,   6.828891651022204e-11,  -4.660896753013139e-13,  -4.882085538883553e-14,   1.647680068486921e-15,   1.400710389347852e-18,
   2.259937309751181e-01,  -2.498648222111694e-03,   2.645562578766511e-05,  -2.135872808224470e-07,  -6.797209703638546e-10,   6.824557695000159e-11,  -4.641473698139373e-13,
  -4.881839691981713e-14,   1.644839108831199e-15,   1.484597023565539e-18,   2.259939163462818e-01,  -2.498652705532949e-03,   2.645559712640552e-05,  -2.135825103507048e-07,
  -6.797691831899983e-10,   6.823839287544880e-11,  -4.638255130549925e-13,  -4.881798530873643e-14,   1.644368250525439e-15,   1.498492085113584e-18,   3.456153363676578e-01,
  -3.819331959948026e-03,   4.030440030644810e-05,  -3.159271575737339e-07,  -1.578576629590109e-09,   1.221270570141474e-10,  -9.870598846360432e-13,  -7.987013943493942e-14,
   2.910955639738849e-15,  -3.779131103493317e-18,   3.456210692468927e-01,  -3.819466229733553e-03,   4.030304133217616e-05,  -3.157553776251799e-07,  -1.580550248115090e-09,
   1.218883025723884e-10,  -9.757923352311587e-13,  -7.987597042820538e-14,   2.894958258739760e-15,  -3.270952160468721e-18,   3.456304805547402e-01,  -3.819686602789646e-03,
   4.030080918005350e-05,  -3.154736186187760e-07,  -1.583773054362864e-09,   1.214963446256110e-10,  -9.573407533784834e-13,  -7.988369510406659e-14,   2.868721651507540e-15,
  -2.441184871092134e-18,   3.456404664877856e-01,  -3.819920364287851e-03,   4.029843910170548e-05,  -3.151749842976201e-07,  -1.587169352552962e-09,   1.210804438268206e-10,
  -9.378245720743011e-13,  -7.988938928341963e-14,   2.840917772198089e-15,  -1.566829538814937e-18,   3.456483253305444e-01,  -3.820104284191269e-03,   4.029657268914187e-05,
  -3.149401991676168e-07,  -1.589825382679164e-09,   1.207531271468996e-10,  -9.225103619152175e-13,  -7.989206601871229e-14,   2.819061672419888e-15,  -8.831090697348306e-19,
   3.456528607666350e-01,  -3.820210407281257e-03,   4.029549508708328e-05,  -3.148047969424216e-07,  -1.591351475521101e-09,   1.205642266204927e-10,  -9.136903100948707e-13,
  -7.989288977687997e-14,   2.806458464040190e-15,  -4.902821195792507e-19,   3.456545638574497e-01,  -3.820250253648855e-03,   4.029509035023972e-05,  -3.147539703687041e-07,
  -1.591923263158335e-09,   1.204932927229804e-10,  -9.103817086262275e-13,  -7.989306310090690e-14,   2.801727803410765e-15,  -3.431042844837393e-19,   3.456548461685741e-01,
  -3.820256858548505e-03,   4.029502325475273e-05,  -3.147455461024302e-07,  -1.592017977889657e-09,   1.204815344225311e-10,  -9.098334407357207e-13,  -7.989308466374405e-14,
   2.800943732804386e-15,  -3.187249887179851e-19,   4.980563144035678e-01,  -5.500966315991781e-03,   5.772052443229026e-05,  -4.292946143482472e-07,  -3.504500941241578e-09,
   2.130795890102497e-10,  -1.927501977314083e-12,  -1.260736658661193e-13,   4.887504012142082e-15,  -1.411369118801366e-17,   4.980645223963744e-01,  -5.501148531945868e-03,
   5.771751020476645e-05,  -4.289945742318991e-07,  -3.508391195869140e-09,   2.127020935927140e-10,  -1.908562451105305e-12,  -1.261223061593526e-13,   4.861681040319663e-15,
  -1.322523242481953e-17,   4.980779968318881e-01,  -5.501447577097233e-03,   5.771255953235016e-05,  -4.285023983661727e-07,  -3.514748742227022e-09,   2.120822839436368e-10,
  -1.877544344164296e-12,  -1.261989232708867e-13,   4.819319439343066e-15,  -1.177411144118480e-17,   4.980922938238358e-01,  -5.501764762381315e-03,   5.770730332912895e-05,
  -4.279806898390504e-07,  -3.521455326183954e-09,   2.114244997088842e-10,  -1.844732515813881e-12,  -1.262758399637822e-13,   4.774413154806627e-15,  -1.024443913920944e-17,
   4.981035453234413e-01,  -5.502014298607568e-03,   5.770316439129168e-05,  -4.275704848824939e-07,  -3.526705063918569e-09,   2.109067373820638e-10,  -1.818982362132499e-12,
  -1.263332143646622e-13,   4.739102969471390e-15,  -9.047864103107421e-18,   4.981100386603156e-01,  -5.502158274679991e-03,   5.770077481857937e-05,  -4.273339008744674e-07,
  -3.529723430669166e-09,   2.106078944528767e-10,  -1.804150664601226e-12,  -1.263650636691737e-13,   4.718737453263503e-15,  -8.360213341643490e-18,   4.981124769495225e-01,
  -5.502212332293656e-03,   5.769987733841957e-05,  -4.272450902022351e-07,  -3.530854712251353e-09,   2.104956699975507e-10,  -1.798586735923478e-12,  -1.263767852192255e-13,
   4.711092412741803e-15,  -8.102544319870763e-18,   4.981128811296273e-01,  -5.502221292756457e-03,   5.769972855917842e-05,  -4.272303700907055e-07,  -3.531042125247435e-09,
   2.104770668759360e-10,  -1.797664726334790e-12,  -1.263787156800867e-13,   4.709825265555551e-15,  -8.059861029885406e-18,   6.914643063536352e-01,  -7.630543031598703e-03,
   7.932189759235767e-05,  -5.365374905042808e-07,  -7.741085957442673e-09,   3.854479701303395e-10,  -4.005718308495582e-12,  -1.985229803243424e-13,   8.526813090489809e-15,
  -4.740018073509101e-17,   6.914755810572264e-01,  -7.630770172209737e-03,   7.931524188188863e-05,  -5.359940076032106e-07,  -7.749244510874132e-09,   3.848515973173175e-10,
  -3.972606005329986e-12,  -1.987221754343807e-13,   8.485176115510744e-15,  -4.576308509778536e-17,   6.914940896165990e-01,  -7.631142893773548e-03,   7.930431054467296e-05,
  -5.351024070893473e-07,  -7.762587469161443e-09,   3.838721526937374e-10,  -3.918366614084044e-12,  -1.990432179242497e-13,   8.416839316624726e-15,  -4.308790591724575e-17,
   6.915137276888994e-01,  -7.631538153964235e-03,   7.929270489303400e-05,  -5.341571855726792e-07,  -7.776676673369263e-09,   3.828323467169258e-10,  -3.860977233825369e-12,
  -1.993757821759839e-13,   8.344352931464565e-15,  -4.026613993558204e-17,   6.915291822744561e-01,  -7.631849062121699e-03,   7.928356637692635e-05,  -5.334138963900101e-07,
  -7.787715285811399e-09,   3.820136288020975e-10,  -3.815929341337490e-12,  -1.996316767228877e-13,   8.287324167993902e-15,  -3.805754956023960e-17,   6.915381011451298e-01,
  -7.632028427711053e-03,   7.927829043795699e-05,  -5.329851722832620e-07,  -7.794066002780448e-09,   3.815409781009001e-10,  -3.789978554034988e-12,  -1.997770258808839e-13,
   8.254419409449759e-15,  -3.678779637166570e-17,   6.915414502181759e-01,  -7.632095768879851e-03,   7.927630890753440e-05,  -5.328242279811668e-07,  -7.796447005341473e-09,
   3.813634644371536e-10,  -3.780242701746430e-12,  -1.998311658218549e-13,   8.242064825644190e-15,  -3.631191088901587e-17,   6.915420053722499e-01,  -7.632106930988747e-03,
   7.927598042137302e-05,  -5.327975515790164e-07,  -7.796841492590072e-09,   3.813340375016010e-10,  -3.778629315755124e-12,  -1.998401170928751e-13,   8.240016955434155e-15,
  -3.623307455117602e-17,   9.416875483567468e-01,  -1.037540701109032e-02,   1.059544247570502e-04,  -5.748694257806281e-07,  -1.836218239884005e-08,   7.826716098740423e-10,
  -9.830376949671355e-12,  -3.212727361139216e-13,   1.693296600046834e-14,  -1.832000283440585e-16,   9.417025946896422e-01,  -1.037564853129665e-02,   1.059386322505334e-04,
  -5.737638572604233e-07,  -1.838238344327691e-08,   7.816981679937818e-10,  -9.764294584093316e-12,  -3.221186848795545e-13,   1.686614968953186e-14,  -1.797317593077891e-16,
   9.417272940385273e-01,  -1.037604468660362e-02,   1.059126940753903e-04,  -5.719498942575090e-07,  -1.841544551319161e-08,   7.800983381734560e-10,  -9.656002782179484e-12,
  -3.234947591179800e-13,   1.675634272744067e-14,  -1.740585471857704e-16,   9.417534997249425e-01,  -1.037646457717415e-02,   1.058851550929164e-04,  -5.700265083961670e-07,
  -1.845038953034842e-08,   7.783984079152568e-10,  -9.541359421051326e-12,  -3.249376785118829e-13,   1.663967242123631e-14,  -1.680667223883572e-16,   9.417741221215512e-01,
  -1.037679469974219e-02,   1.058634697956286e-04,  -5.685137856245562e-07,  -1.847779130695467e-08,   7.770588371908303e-10,  -9.451324767661976e-12,  -3.260608419354507e-13,
   1.654774092003388e-14,  -1.633713290845456e-16,   9.417860230618342e-01,  -1.037698508628564e-02,   1.058509499957615e-04,  -5.676411616264120e-07,  -1.849356562665058e-08,
   7.762850604463341e-10,  -9.399440324568201e-12,  -3.267040730691460e-13,   1.649464148816203e-14,  -1.606696278220264e-16,   9.417904918607428e-01,  -1.037705655307070e-02,
   1.058462477819546e-04,  -5.673135578733033e-07,  -1.849948152650187e-08,   7.759943707046074e-10,  -9.379971630029589e-12,  -3.269446749549648e-13,   1.647469389356575e-14,
  -1.596566438646660e-16,   9.417912326216639e-01,  -1.037706839838109e-02,   1.058454682750207e-04,  -5.672592568317026e-07,  -1.850046177530446e-08,   7.759461779312104e-10,
  -9.376745176602267e-12,  -3.269845087196491e-13,   1.647138686201864e-14,  -1.594888080885562e-16,   1.289408017664854e+00,  -1.414930213687126e-02,   1.375101693203180e-04,
  -1.817123380125958e-07,  -5.814235732106275e-08,   2.301856397556054e-09,  -4.054226692895578e-11,  -4.598017511787046e-13,   5.098910318853637e-14,  -1.349361976834757e-15,
   1.289427485574346e+00,  -1.414936818817532e-02,   1.374600493572552e-04,  -1.784492216801981e-07,  -5.822648701693945e-08,   2.300376109755745e-09,  -4.033918052918581e-11,
  -4.664769814317750e-13,   5.098649460212606e-14,  -1.340523341329877e-15,   1.289459440068695e+00,  -1.414947561818387e-02,   1.373777181709608e-04,  -1.730938545020790e-07,
  -5.836428626279720e-08,   2.297931714198535e-09,  -4.000579784869905e-11,  -4.774026275269090e-13,   5.098064125550671e-14,  -1.326000347628475e-15,   1.289493339146552e+00,
  -1.414958824562062e-02,   1.372902890001035e-04,  -1.674135328285301e-07,  -5.851007617834578e-08,   2.295318675169437e-09,  -3.965207796540772e-11,  -4.889509461903953e-13,
   5.097230085956352e-14,  -1.310573098091206e-15,   1.289520012748742e+00,  -1.414967589657247e-02,   1.372214316051287e-04,  -1.629446431806811e-07,  -5.862450538074125e-08,
   2.293248223007695e-09,  -3.937371852533936e-11,  -4.980071966440762e-13,   5.096419938988334e-14,  -1.298419578196329e-15,   1.289535404540983e+00,  -1.414972608591052e-02,
   1.371816725695547e-04,  -1.603661842966682e-07,  -5.869042116392127e-08,   2.292047732104787e-09,  -3.921308048829295e-11,  -5.032207673880428e-13,   5.095890897518317e-14,
  -1.291400749140447e-15,   1.289541183921601e+00,  -1.414974485771554e-02,   1.371667388630459e-04,  -1.593980656685387e-07,  -5.871514984496174e-08,   2.291595879998272e-09,
  -3.915276101640600e-11,  -5.051760631366257e-13,   5.095680631912422e-14,  -1.288764213732537e-15,   1.289542141916065e+00,  -1.414974796546560e-02,   1.371642631874009e-04,
  -1.592375923965088e-07,  -5.871924774595246e-08,   2.291520923373210e-09,  -3.914276229250843e-11,  -5.055000520277631e-13,   5.095645165562241e-14,  -1.288327123287213e-15,
   2.561434773024044e-03,  -2.719370608083381e-05,   2.833282232166760e-07,  -2.607212222302416e-09,   9.336530370173882e-12,   4.295405000746282e-13,  -1.121020846593635e-14,
  -4.761757522982777e-17,   1.057577545074232e-17,  -2.758700958231625e-19,   2.561475108474274e-03,  -2.719481700289958e-05,   2.833360626566672e-07,  -2.606602359064091e-09,
   9.313100201372289e-12,   4.293764879285039e-13,  -1.116816654270709e-14,  -4.898221764238794e-17,   1.057128017435513e-17,  -2.740570059337706e-19,   2.561541326431023e-03,
  -2.719664057347279e-05,   2.833489180654692e-07,  -2.605601347513238e-09,   9.274700595505582e-12,   4.291043194740727e-13,  -1.109916234786418e-14,  -5.121579206169671e-17,
   1.056364199003701e-17,  -2.710813829425368e-19,   2.561611589870478e-03,  -2.719857526760828e-05,   2.833625392338854e-07,  -2.604539439966924e-09,   9.234043712446397e-12,
   4.288115725965127e-13,  -1.102596357524981e-14,  -5.357667378254726e-17,   1.055518714115306e-17,  -2.679252307252753e-19,   2.561666888340350e-03,  -2.720009769732732e-05,
   2.833732451260263e-07,  -2.603703890418652e-09,   9.202110284018764e-12,   4.285783218933516e-13,  -1.096837056264134e-14,  -5.542810334710854e-17,   1.054828049937228e-17,
  -2.654422389875638e-19,   2.561698802478631e-03,  -2.720097624724734e-05,   2.833794180838735e-07,  -2.603221749914691e-09,   9.183706429584098e-12,   4.284425650282920e-13,
  -1.093513854811546e-14,  -5.649395577622357e-17,   1.054419356492114e-17,  -2.640096357564833e-19,   2.561710786613474e-03,  -2.720130613748502e-05,   2.833817350290132e-07,
  -2.603040714921349e-09,   9.176800428329484e-12,   4.283913711198885e-13,  -1.092266075007603e-14,  -5.689369432498946e-17,   1.054263982940067e-17,  -2.634717522689343e-19,
   2.561712773158452e-03,  -2.720136082077569e-05,   2.833821190398300e-07,  -2.603010706496491e-09,   9.175655914516477e-12,   4.283828736154074e-13,  -1.092059243762047e-14,
  -5.695993035470955e-17,   1.054238127131761e-17,  -2.633825942830624e-19,   2.314391348986083e-02,  -2.457045294271501e-04,   2.559388363175349e-06,  -2.350885594490644e-08,
   8.180857349768864e-11,   3.973093561839040e-12,  -1.033399221058634e-13,  -4.199383550882810e-16,   9.666997728973888e-17,  -2.533679077882661e-18,   2.314427784761943e-02,
  -2.457145459474629e-04,   2.559456993260377e-06,  -2.350321440117848e-08,   8.159254721366775e-11,   3.971639176766576e-12,  -1.029555833787784e-13,  -4.324735739738308e-16,
   9.663112803119502e-17,  -2.517098801354187e-18,   2.314487600673104e-02,  -2.457309879493443e-04,   2.559569528787164e-06,  -2.349395447233788e-08,   8.123849759414561e-11,
   3.969224781723212e-12,  -1.023247546639652e-13,  -4.529908257408515e-16,   9.656497166893056e-17,  -2.489886741719520e-18,   2.314551070912888e-02,  -2.457484318233383e-04,
   2.559688758663775e-06,  -2.348413113203200e-08,   8.086362870939431e-11,   3.966626589400196e-12,  -1.016555709437575e-13,  -4.746778675345595e-16,   9.649155165759486e-17,
  -2.461022803642067e-18,   2.314601023001583e-02,  -2.457621585348157e-04,   2.559782463748802e-06,  -2.347640168713716e-08,   8.056918776875378e-11,   3.964555549654098e-12,
  -1.011290489599841e-13,  -4.916853503808923e-16,   9.643144426242193e-17,  -2.438314438308583e-18,   2.314629851599737e-02,  -2.457700798034448e-04,   2.559836490945763e-06,
  -2.347194150875972e-08,   8.039949374557636e-11,   3.963349809103926e-12,  -1.008252355447258e-13,  -5.014765213362439e-16,   9.639582560838695e-17,  -2.425212200002270e-18,
   2.314640677076210e-02,  -2.457730541891237e-04,   2.559856768903334e-06,  -2.347026678798676e-08,   8.033581610187587e-11,   3.962895058593472e-12,  -1.007111606644011e-13,
  -5.051486336709094e-16,   9.638227508072991e-17,  -2.420292798312467e-18,   2.314642471556589e-02,  -2.457735472292953e-04,   2.559860129748627e-06,  -2.346998918541831e-08,
   8.032526294995447e-11,   3.962819572632549e-12,  -1.006922516545953e-13,  -5.057570977923899e-16,   9.638001964304224e-17,  -2.419477370058120e-18,   6.480773705263657e-02,
  -6.879945165582478e-04,   7.163116962629381e-06,  -6.554406320031380e-08,   2.140806291302078e-10,   1.166757628989090e-11,  -3.015159909544486e-13,  -1.112499429407350e-15,
   2.772205605037338e-16,  -7.338602338156931e-18,   6.480875677715990e-02,  -6.880224402290086e-04,   7.163296188211258e-06,  -6.552749285483603e-08,   2.134501024340300e-10,
   1.166367382666200e-11,  -3.004135408840839e-13,  -1.148818364885711e-15,   2.771228188207387e-16,  -7.291017312072833e-18,   6.481043083791604e-02,  -6.880682763501588e-04,
   7.163590031055411e-06,  -6.550029420334911e-08,   2.124166904770453e-10,   1.165718968383714e-11,  -2.986040118011135e-13,  -1.208265702635008e-15,   2.769554383392850e-16,
  -7.212915069635213e-18,   6.481220717010168e-02,  -6.881169050820398e-04,   7.163901298413340e-06,  -6.547144015461827e-08,   2.113224702032422e-10,   1.165020422644004e-11,
  -2.966844088742339e-13,  -1.271104663601291e-15,   2.767684570761734e-16,  -7.130065982904232e-18,   6.481360517047322e-02,  -6.881551711289205e-04,   7.164145889526903e-06,
  -6.544873611639687e-08,   2.104629851351813e-10,   1.164463057241703e-11,  -2.951740036308554e-13,  -1.320386057503801e-15,   2.766145353617491e-16,  -7.064881300500520e-18,
   6.481441199087738e-02,  -6.881772532005325e-04,   7.164286896495745e-06,  -6.543563488667062e-08,   2.099676296520514e-10,   1.164138347204781e-11,  -2.943024552432697e-13,
  -1.348757897725479e-15,   2.765229994231043e-16,  -7.027269489648242e-18,   6.481471496129450e-02,  -6.881855448576816e-04,   7.164339817426481e-06,  -6.543071557005677e-08,
   2.097817453994228e-10,   1.164015840733374e-11,  -2.939752061970113e-13,  -1.359398686835156e-15,   2.764881164585177e-16,  -7.013147346358913e-18,   6.481476518304806e-02,
  -6.881869192984758e-04,   7.164348588320524e-06,  -6.542990014011413e-08,   2.097509391053361e-10,   1.163995503233902e-11,  -2.939209613652351e-13,  -1.361161857885273e-15,
   2.764823072088984e-16,  -7.010806477259162e-18,   1.286203946118196e-01,  -1.365332535135332e-03,   1.420434688774271e-05,  -1.291602943143982e-07,   3.763072863257693e-10,
   2.491975361539084e-11,  -6.382614074495804e-13,  -1.986270735505474e-15,   5.712256760844608e-16,  -1.536818540896931e-17,   1.286224166255550e-01,  -1.365387551455611e-03,
   1.420466064259312e-05,  -1.291248931118508e-07,   3.749718374222638e-10,   2.491260698958185e-11,  -6.359887896727780e-13,  -2.062368495218652e-15,   5.710712809436751e-16,
  -1.527004673740488e-17,   1.286257361195164e-01,  -1.365477858743211e-03,   1.420517490639119e-05,  -1.290667841589022e-07,   3.727829861487123e-10,   2.490071199006164e-11,
  -6.322584480313457e-13,  -2.186932043864227e-15,   5.708032197246101e-16,  -1.510895521964325e-17,   1.286292584015000e-01,  -1.365573666934649e-03,   1.420571947278877e-05,
  -1.290051368287743e-07,   3.704652078193217e-10,   2.488786984236187e-11,  -6.283010080359357e-13,  -2.318609973531264e-15,   5.704990089083645e-16,  -1.493805325490221e-17,
   1.286320304865493e-01,  -1.365649057755644e-03,   1.420614724866478e-05,  -1.289566279178922e-07,   3.686445515452655e-10,   2.487760359762549e-11,  -6.251870362517658e-13,
  -2.421883841690217e-15,   5.702453220161591e-16,  -1.480357537728258e-17,   1.286336303233005e-01,  -1.365692562972293e-03,   1.420639380581758e-05,  -1.289286356517288e-07,
   3.675951969825784e-10,   2.487161496006248e-11,  -6.233901303192741e-13,  -2.481341979657046e-15,   5.700932094124778e-16,  -1.472597544256668e-17,   1.286342310802257e-01,
  -1.365708898800987e-03,   1.420648632990666e-05,  -1.289181248803042e-07,   3.672014150633468e-10,   2.486935412394665e-11,  -6.227154180822855e-13,  -2.503642031385614e-15,
   5.700350131981757e-16,  -1.469683784707393e-17,   1.286343306644074e-01,  -1.365711606655545e-03,   1.420650166390415e-05,  -1.289163826013639e-07,   3.671361538503567e-10,
   2.486897872299199e-11,  -6.226035771995097e-13,  -2.507337156121771e-15,   5.700253096024561e-16,  -1.469200797857067e-17,   2.163828171176585e-01,  -2.296716180868312e-03,
   2.386652078945000e-05,  -2.149608098665213e-07,   5.095927009768177e-10,   4.644160723037684e-11,  -1.177268598266458e-12,  -2.712416716377586e-15,   1.014113278626270e-15,
  -2.795436092777134e-17,   2.163862143456212e-01,  -2.296807719220509e-03,   2.386694195960862e-05,  -2.148948090976710e-07,   5.071276440760139e-10,   4.643129696421086e-11,
  -1.173231262721020e-12,  -2.850948768841520e-15,   1.013969764516552e-15,  -2.778006170278153e-17,   2.163917914864014e-01,  -2.296957973900905e-03,   2.386763187256052e-05,
  -2.147864696684247e-07,   5.030870809609864e-10,   4.641407481115455e-11,  -1.166603889873197e-12,  -3.077726115532149e-15,   1.013707352528696e-15,  -2.749391446772892e-17,
   2.163977093198462e-01,  -2.297117378089562e-03,   2.386836187881502e-05,  -2.146715289749814e-07,   4.988081932839454e-10,   4.639539900336170e-11,  -1.159572547492924e-12,
  -3.317477211800327e-15,   1.013392583582638e-15,  -2.719028597001917e-17,   2.164023667263737e-01,  -2.297242810013328e-03,   2.386893491880144e-05,  -2.145810816250839e-07,
   4.954468125056697e-10,   4.638041075103567e-11,  -1.154039465257431e-12,  -3.505527481299021e-15,   1.013118640004232e-15,  -2.695132975756667e-17,   2.164050546229714e-01,
  -2.297315191208735e-03,   2.386926503916240e-05,  -2.145288873752805e-07,   4.935093494985173e-10,   4.637164457130272e-11,  -1.150846475120619e-12,  -3.613800393136792e-15,
   1.012950059954402e-15,  -2.681342518150583e-17,   2.164060639579349e-01,  -2.297342369551464e-03,   2.386938889076954e-05,  -2.145092888059570e-07,   4.927822769825552e-10,
   4.636833085055675e-11,  -1.149647525968343e-12,  -3.654409831380119e-15,   1.012884778614340e-15,  -2.676164112527840e-17,   2.164062312698140e-01,  -2.297346874670828e-03,
   2.386940941504608e-05,  -2.145060401096634e-07,   4.926617787892394e-10,   4.636778039741746e-11,  -1.149448785674787e-12,  -3.661138888685566e-15,   1.012873853038249e-15,
  -2.675305720606083e-17,   3.309584927895759e-01,  -3.512316392231363e-03,   3.643652883081531e-05,  -3.235094222672601e-07,   4.977376615905547e-10,   8.145398498546634e-11,
  -2.044122614258534e-12,  -2.483916254872026e-15,   1.670730846661302e-15,  -4.773802324574890e-17,   3.309636787807964e-01,  -3.512454096385079e-03,   3.643692958666024e-05,
  -3.233936051841189e-07,   4.934533502321273e-10,   8.144279232040916e-11,  -2.037464226122597e-12,  -2.720780058413361e-15,   1.670831926637381e-15,  -4.745130170018852e-17,
   3.309721924623072e-01,  -3.512680124333453e-03,   3.643758487337651e-05,  -3.232034857663224e-07,   4.864302325861220e-10,   8.142391113951251e-11,  -2.026533378871951e-12,
  -3.108567790740064e-15,   1.670951495005981e-15,  -4.698048531254171e-17,   3.309812261874152e-01,  -3.512919908931850e-03,   3.643827662744905e-05,  -3.230017724134376e-07,
   4.789921234403748e-10,   8.140318948134441e-11,  -2.014934943137831e-12,  -3.518596272966185e-15,   1.671015521412269e-15,  -4.648076332299711e-17,   3.309883358133819e-01,
  -3.513108585540319e-03,   3.643881846978638e-05,  -3.228430362307723e-07,   4.731484008128501e-10,   8.138638481759176e-11,  -2.005806997811126e-12,  -3.840245001544577e-15,
   1.671020548122465e-15,  -4.608737836960253e-17,   3.309924389322821e-01,  -3.513217460419202e-03,   3.643913014760718e-05,  -3.227514318745188e-07,   4.697799260904679e-10,
   8.137648777748168e-11,  -2.000539134692859e-12,  -4.025455500978605e-15,   1.671005311407617e-15,  -4.586031000303602e-17,   3.309939796970100e-01,  -3.513258341357430e-03,
   3.643924699115674e-05,  -3.227170345569532e-07,   4.685157961764381e-10,   8.137273381534753e-11,  -1.998561011881855e-12,  -4.094924633224166e-15,   1.670996167100385e-15,
  -4.577503662523583e-17,   3.309942351009643e-01,  -3.513265117817702e-03,   3.643926634938564e-05,  -3.227113327637135e-07,   4.683062889500164e-10,   8.137210956371722e-11,
  -1.998233110408001e-12,  -4.106435955235293e-15,   1.670994470867221e-15,  -4.576090098244224e-17,   4.769424060670621e-01,  -5.060458651385128e-03,   5.236250229758817e-05,
  -4.546845826468323e-07,   9.464734796872135e-11,   1.407967763098724e-10,  -3.508812440365092e-12,   8.949873016430407e-16,   2.665744129411374e-15,  -8.043580918849855e-17,
   4.769498577138375e-01,  -5.060652058529171e-03,   5.236254145475867e-05,  -4.544842554322729e-07,   8.728384363520206e-11,   1.407930855210173e-10,  -3.498170256672357e-12,
   4.951139586045648e-16,   2.666795003822317e-15,  -7.998168993069237e-17,   4.769620907957564e-01,  -5.060969505863533e-03,   5.236260123347824e-05,  -4.541553923122298e-07,
   7.521188842242670e-11,   1.407861707230587e-10,  -3.480696817859044e-12,  -1.596578642551807e-16,   2.668440829336082e-15,  -7.923571545570207e-17,   4.769750710379002e-01,
  -5.061306258040250e-03,   5.236265854740604e-05,  -4.538064523328458e-07,   6.242494100921132e-11,   1.407776725222592e-10,  -3.462152777827882e-12,  -8.521304612000820e-16,
   2.670079604352134e-15,  -7.844356362771503e-17,   4.769852865541475e-01,  -5.061571222970820e-03,   5.236269923004490e-05,  -4.535318417778681e-07,   5.237771523956156e-11,
   1.407701453208144e-10,  -3.447556177859948e-12,  -1.395450674673686e-15,   2.671291660748733e-15,  -7.781970278208062e-17,   4.769911821272569e-01,  -5.061724115041513e-03,
   5.236272093698148e-05,  -4.533733616031857e-07,   4.658574659331660e-11,   1.407654654009664e-10,  -3.439131287481612e-12,  -1.708346022762044e-15,   2.671960100663553e-15,
  -7.745949087146714e-17,   4.769933959733738e-01,  -5.061781522927905e-03,   5.236272875343261e-05,  -4.533138512932813e-07,   4.441202995614170e-11,   1.407636446317374e-10,
  -3.435967489730640e-12,  -1.825715549614289e-15,   2.672205244086041e-15,  -7.732419613643144e-17,   4.769937629500448e-01,  -5.061791038863787e-03,   5.236273003146750e-05,
  -4.533039866381102e-07,   4.405176994467748e-11,   1.407633394693706e-10,  -3.435443036216920e-12,  -1.845164592205469e-15,   2.672245571057292e-15,  -7.730176744316863e-17,
   6.621682559587502e-01,  -7.023282525348532e-03,   7.237387767857976e-05,  -6.053160233044487e-07,  -1.296152464331334e-09,   2.505216765811690e-10,  -6.254152220217862e-12,
   1.456900466499851e-14,   4.261796031299565e-15,  -1.405843021748214e-16,   6.621785529167769e-01,  -7.023539687606482e-03,   7.237269657800153e-05,  -6.049592493864204e-07,
  -1.309299769953866e-09,   2.505540484083307e-10,  -6.237083829492945e-12,   1.386779823527758e-14,   4.266113233001875e-15,  -1.398775286780106e-16,   6.621954569070015e-01,
  -7.023961750938663e-03,   7.237074956099587e-05,  -6.043735185745548e-07,  -1.330856821873630e-09,   2.506056898108799e-10,  -6.209051677264059e-12,   1.271928317326031e-14,
   4.273059770299015e-15,  -1.387156828565272e-16,   6.622133931661898e-01,  -7.024409443071616e-03,   7.236867269477377e-05,  -6.037519747672979e-07,  -1.353694660801570e-09,
   2.506584468493973e-10,  -6.179291817085092e-12,   1.150419570880915e-14,   4.280239574329222e-15,  -1.374807788832410e-16,   6.622275089651045e-01,  -7.024761670755735e-03,
   7.236703028303428e-05,  -6.032627895659320e-07,  -1.371642189703080e-09,   2.506984934547998e-10,  -6.155859543876973e-12,   1.055050683035579e-14,   4.285752148886213e-15,
  -1.365074076376554e-16,   6.622356554159340e-01,  -7.024964904796079e-03,   7.236607924785312e-05,  -6.029804606310411e-07,  -1.381989647020794e-09,   2.507210153063136e-10,
  -6.142331925672895e-12,   1.000115384236274e-14,   4.288878366392886e-15,  -1.359450639035188e-16,   6.622387144792441e-01,  -7.025041212987738e-03,   7.236572152631744e-05,
  -6.028744413328426e-07,  -1.385873251774617e-09,   2.507293610982563e-10,  -6.137251346578996e-12,   9.795062902988909e-15,   4.290041872169908e-15,  -1.357337871777335e-16,
   6.622392215622476e-01,  -7.025053861729571e-03,   7.236566219729268e-05,  -6.028568670130327e-07,  -1.386516911004875e-09,   2.507307386589059e-10,  -6.136409124570791e-12,
   9.760910752036772e-15,   4.290234190519400e-15,  -1.356987591982736e-16,   9.018318999357636e-01,  -9.559264527742728e-03,   9.776234432482755e-05,  -7.583111422164768e-07,
  -5.513469625754394e-09,   4.920007938488266e-10,  -1.258917957736350e-11,   7.065761028906818e-14,   7.064624371734350e-15,  -2.769123570953925e-16,   9.018458024640140e-01,
  -9.559585788041955e-03,   9.775748651611355e-05,  -7.576094134545368e-07,  -5.540003454996549e-09,   4.921897857337376e-10,  -1.256067034664002e-11,   6.926701162965713e-14,
   7.082209602213687e-15,  -2.758733728892336e-16,   9.018686251911675e-01,  -9.560112971940161e-03,   9.774949536961500e-05,  -7.564572268970764e-07,  -5.583518857375162e-09,
   4.924970611903039e-10,  -1.251381876499340e-11,   6.698800896578971e-14,   7.110802988175357e-15,  -2.741620059586145e-16,   9.018928411570442e-01,  -9.560672060021137e-03,
   9.774099405187759e-05,  -7.552344178419908e-07,  -5.629631987804525e-09,   4.928190515518534e-10,  -1.246403936566999e-11,   6.457510932665222e-14,   7.140768707168469e-15,
  -2.723384120544877e-16,   9.019118987335705e-01,  -9.561111851827576e-03,   9.773428748549154e-05,  -7.542718809482304e-07,  -5.665879736336300e-09,   4.930695290817562e-10,
  -1.242481509050742e-11,   6.267998964827977e-14,   7.164081449752321e-15,  -2.708977003961257e-16,   9.019228970266289e-01,  -9.561365578709728e-03,   9.773041059132830e-05,
  -7.537163104679591e-07,  -5.686781562479917e-09,   4.932129110455556e-10,  -1.240215901533387e-11,   6.158782320685236e-14,   7.177427418768359e-15,  -2.700640332671858e-16,
   9.019270269558830e-01,  -9.561460839502656e-03,   9.772895356914137e-05,  -7.535076747431615e-07,  -5.694627105001656e-09,   4.932665307352773e-10,  -1.239364785991995e-11,
   6.117799605957968e-14,   7.182418514505119e-15,  -2.697505679977799e-16,   9.019277115487054e-01,  -9.561476629489335e-03,   9.772871198304325e-05,  -7.534730896752764e-07,
  -5.695927441799299e-09,   4.932754072761133e-10,  -1.239223682586937e-11,   6.111007676763203e-14,   7.183244781713132e-15,  -2.696985847912247e-16,   1.234979002539777e+00,
  -1.307061255005826e-02,   1.310907373791787e-04,  -7.981759288617079e-07,  -2.210825142846809e-08,   1.316072107833213e-09,  -3.738550017025498e-11,   4.726362401464881e-13,
   1.095178296741281e-14,  -7.655518080114685e-16,   1.234997618843224e+00,  -1.307094665002259e-02,   1.310714116291530e-04,  -7.962917248548459e-07,  -2.218750402850286e-08,
   1.317421657190183e-09,  -3.733941995774140e-11,   4.687014868947377e-13,   1.106993245960572e-14,  -7.660546406630210e-16,   1.235028178459447e+00,  -1.307149454516251e-02,
   1.310396365486184e-04,  -7.931971370503403e-07,  -2.231753761196862e-08,   1.319628654108991e-09,  -3.726343449807764e-11,   4.622403030072317e-13,   1.126338230235614e-14,
  -7.668519685225296e-16,   1.235060601773526e+00,  -1.307207511029280e-02,   1.310058545232438e-04,  -7.899116939539885e-07,  -2.245541463206693e-08,   1.321958885194854e-09,
  -3.718235040148911e-11,   4.553823026156361e-13,   1.146795067091402e-14,  -7.676597727342440e-16,   1.235086117062245e+00,  -1.307253144307739e-02,   1.309792199741424e-04,
  -7.873247000013405e-07,  -2.256385291473076e-08,   1.323784415821945e-09,  -3.711820607928290e-11,   4.499834831218380e-13,   1.162844135815344e-14,  -7.682678769679827e-16,
   1.235100841619942e+00,  -1.307279457109495e-02,   1.309638294537519e-04,  -7.858311621256890e-07,  -2.262640597133924e-08,   1.324834608287930e-09,  -3.708105478179628e-11,
   4.468671173891537e-13,   1.172086059023127e-14,  -7.686077561921192e-16,   1.235106370683771e+00,  -1.307289333469775e-02,   1.309580465318324e-04,  -7.852702231923510e-07,
  -2.264988981451767e-08,   1.325228331449368e-09,  -3.706707910885643e-11,   4.456967791438920e-13,   1.175552650183546e-14,  -7.687332932197656e-16,   1.235107287197116e+00,
  -1.307290970387916e-02,   1.309570877383495e-04,  -7.851772342310088e-07,  -2.265378230985831e-08,   1.325293563222282e-09,  -3.706476112323288e-11,   4.455027729660648e-13,
   1.176127084449720e-14,  -7.687539925005470e-16,   2.456999378645455e-03,  -2.504912887541972e-05,   2.531742936178304e-07,  -2.403599945877193e-09,   1.528851871513872e-11,
   1.738525339562252e-13,  -9.229987367153375e-15,   1.436725187275225e-16,   2.046056824137833e-18,  -1.702345996983655e-19,   2.457035433233421e-03,  -2.505015413811978e-05,
   2.531872366382925e-07,  -2.403349046179225e-09,   1.526891986360639e-11,   1.742679660545079e-13,  -9.221328995124181e-15,   1.428009392553163e-16,   2.070538225786582e-18,
  -1.702193041857457e-19,   2.457094623989990e-03,  -2.505183719459024e-05,   2.532084726397504e-07,  -2.402936732204669e-09,   1.523675880246571e-11,   1.749480829431569e-13,
  -9.207045062992906e-15,   1.413701963216420e-16,   2.110607593001271e-18,  -1.701889933345659e-19,   2.457157431744665e-03,  -2.505362294126816e-05,   2.532309892909840e-07,
  -2.402498663396774e-09,   1.520265200779566e-11,   1.756671816878723e-13,  -9.191794016321570e-15,   1.398522082338927e-16,   2.152959962811465e-18,  -1.701497776445070e-19,
   2.457206863071169e-03,  -2.505502825625771e-05,   2.532486981524693e-07,  -2.402153487767490e-09,   1.517582327734523e-11,   1.762312643481692e-13,  -9.179722954153278e-15,
   1.386576537768456e-16,   2.186172425349849e-18,  -1.701138193730201e-19,   2.457235391374643e-03,  -2.505583926012318e-05,   2.532589135293229e-07,  -2.401954114815380e-09,
   1.516034531745040e-11,   1.765560652159238e-13,  -9.172729136230223e-15,   1.379682999015656e-16,   2.205292223565837e-18,  -1.700910285338445e-19,   2.457246104134233e-03,
  -2.505614379429759e-05,   2.532627486066164e-07,  -2.401879217069733e-09,   1.515453421679291e-11,   1.766778908804100e-13,  -9.170097720377771e-15,   1.377094498459036e-16,
   2.212462866341931e-18,  -1.700820854847190e-19,   2.457247879932642e-03,  -2.505619427488781e-05,   2.532633842781866e-07,  -2.401866800050147e-09,   1.515357099791312e-11,
   1.766980778272196e-13,  -9.169661253060684e-15,   1.376665422361663e-16,   2.213651026472446e-18,  -1.700805827542842e-19,   2.220029718851661e-02,  -2.263304300668327e-04,
   2.287323349438979e-06,  -2.169774576746042e-08,   1.369741872664043e-10,   1.619872766553766e-12,  -8.485628562626593e-14,   1.324288838835973e-15,   1.850390961742849e-17,
  -1.556434021696043e-18,   2.220062292455480e-02,  -2.263396850484971e-04,   2.287439283550025e-06,  -2.169540834725862e-08,   1.367939898253045e-10,   1.623702992670837e-12,
  -8.477790958943793e-14,   1.316318936575971e-15,   1.872880949805729e-17,  -1.556337518241049e-18,   2.220115768475646e-02,  -2.263548778704487e-04,   2.287629497255961e-06,
  -2.169156720696426e-08,   1.364982899376216e-10,   1.629973717353828e-12,  -8.464860125721522e-14,   1.303235769410395e-15,   1.909691623073623e-17,  -1.556131330103563e-18,
   2.220172512266390e-02,  -2.263709976383831e-04,   2.287831178019697e-06,  -2.168748618751786e-08,   1.361846977184140e-10,   1.636604050282138e-12,  -8.451052517483535e-14,
   1.289354589177687e-15,   1.948600590530863e-17,  -1.555847770148854e-18,   2.220217171086110e-02,  -2.263836832629020e-04,   2.287989792778118e-06,  -2.168427059379685e-08,
   1.359380212096114e-10,   1.641805222598517e-12,  -8.440123007899561e-14,   1.278430878742103e-15,   1.979113453969635e-17,  -1.555577811369067e-18,   2.220242945028371e-02,
  -2.263910040970776e-04,   2.288081288750275e-06,  -2.168241328706600e-08,   1.357957085018439e-10,   1.644800132959706e-12,  -8.433790226284610e-14,   1.272126957989262e-15,
   1.996679422124327e-17,  -1.555403289762889e-18,   2.220252623487689e-02,  -2.263937530886925e-04,   2.288115638137973e-06,  -2.168171556203137e-08,   1.357422779673782e-10,
   1.645923468638184e-12,  -8.431407455982590e-14,   1.269759845225863e-15,   2.003267373026594e-17,  -1.555334220459160e-18,   2.220254227835483e-02,  -2.263942087705300e-04,
   2.288121331604951e-06,  -2.168159988893969e-08,   1.357334215826466e-10,   1.646109609926040e-12,  -8.431012227360624e-14,   1.269367466282194e-15,   2.004358985149301e-17,
  -1.555322584863518e-18,   6.216548989057482e-02,  -6.337622756990959e-04,   6.403574722966014e-06,  -6.064075263260278e-08,   3.767174489003937e-10,   4.824214289524433e-12,
  -2.462183007257305e-13,   3.863503864108309e-15,   5.186867143631060e-17,  -4.465482707397351e-18,   6.216640180713757e-02,  -6.337881399679568e-04,   6.403893419357155e-06,
  -6.063379335905314e-08,   3.761945030188392e-10,   4.835394693007689e-12,  -2.459981627507152e-13,   3.840630806263560e-15,   5.252038208586948e-17,  -4.465468944110680e-18,
   6.216789889811233e-02,  -6.338305981831894e-04,   6.404416289192355e-06,  -6.062235723725484e-08,   3.753363494684286e-10,   4.853699734790344e-12,  -2.456349118034044e-13,
   3.803082073163194e-15,   5.358711772641130e-17,  -4.465308050547281e-18,   6.216948747130105e-02,  -6.338756466828704e-04,   6.404970657173578e-06,  -6.061020723311768e-08,
   3.744262550469421e-10,   4.873055662156768e-12,  -2.452469531538708e-13,   3.763241730413005e-15,   5.471471804851745e-17,  -4.464949750447337e-18,   6.217073771856203e-02,
  -6.339110979528356e-04,   6.405406631146882e-06,  -6.060063399146732e-08,   3.737103495153752e-10,   4.888240271581709e-12,  -2.449398060786778e-13,   3.731888668549801e-15,
   5.559903751041973e-17,  -4.464532253015339e-18,   6.217145927345235e-02,  -6.339315567172654e-04,   6.405658113397930e-06,  -6.059510463444645e-08,   3.732973245530187e-10,
   4.896984123070976e-12,  -2.447618166092309e-13,   3.713794875688115e-15,   5.610814883577313e-17,  -4.464237085391313e-18,   6.217173022689774e-02,  -6.339392390247670e-04,
   6.405752523510863e-06,  -6.059302746527264e-08,   3.731422557264428e-10,   4.900263843737209e-12,  -2.446948421804230e-13,   3.707000612175250e-15,   5.629908944731890e-17,
  -4.464116010326547e-18,   6.217177514143675e-02,  -6.339405124686517e-04,   6.405768172073853e-06,  -6.059268310042394e-08,   3.731165522297196e-10,   4.900807310115558e-12,
  -2.446837329542428e-13,   3.705874373110509e-15,   5.633072814705547e-17,  -4.464095400658268e-18,   1.233767055078302e-01,  -1.257762593158815e-03,   1.270432368436618e-05,
  -1.199726451688559e-07,   7.255845725832720e-10,   1.050798880574555e-11,  -5.166833684602556e-13,   8.179576118934464e-15,   1.028573510304919e-16,  -9.207602401750623e-18,
   1.233785146596785e-01,  -1.257813758552005e-03,   1.270493700391647e-05,  -1.199574922013799e-07,   7.244868989260601e-10,   1.053167901827122e-11,  -5.162453103312099e-13,
   8.132389024031047e-15,   1.042230167663682e-16,  -9.208471595643081e-18,   1.233814847374115e-01,  -1.257897750106030e-03,   1.270594319151554e-05,  -1.199325920991394e-07,
   7.226855807257084e-10,   1.057046840855342e-11,  -5.155222709765736e-13,   8.054922733192712e-15,   1.064585172482618e-16,  -9.209609144797070e-18,   1.233846363039200e-01,
  -1.257986865218493e-03,   1.270700991622937e-05,  -1.199061385324899e-07,   7.207751849621774e-10,   1.061148842164103e-11,  -5.147497855252581e-13,   7.972724185859681e-15,
   1.088217670299164e-16,  -9.210423655880927e-18,   1.233871166644641e-01,  -1.258056994630505e-03,   1.270784876964727e-05,  -1.198852958539862e-07,   7.192723781092043e-10,
   1.064367108992922e-11,  -5.141380171112958e-13,   7.908033358289878e-15,   1.106752871778806e-16,  -9.210781091065445e-18,   1.233885481535353e-01,  -1.258097465820636e-03,
   1.270833262204070e-05,  -1.198732576984723e-07,   7.184053541749074e-10,   1.066220413313118e-11,  -5.137834256816945e-13,   7.870699111872705e-15,   1.117424344710441e-16,
  -9.210873896362394e-18,   1.233890856965456e-01,  -1.258112662802369e-03,   1.270851426309645e-05,  -1.198687354692255e-07,   7.180798301985921e-10,   1.066915587620943e-11,
  -5.136499845976313e-13,   7.856679767022413e-15,   1.121426756426381e-16,  -9.210887320981139e-18,   1.233891748022380e-01,  -1.258115181901013e-03,   1.270854437004649e-05,
  -1.198679857510248e-07,   7.180258726927193e-10,   1.067030782625360e-11,  -5.136278496171977e-13,   7.854355862276556e-15,   1.122089958462923e-16,  -9.210888416635638e-18,
   2.075617560093140e-01,  -2.115902807459100e-03,   2.136165357463299e-05,  -2.008832457202582e-07,   1.164868729517022e-09,   2.005325172542699e-11,  -9.411706966804322e-13,
   1.509917292433234e-14,   1.717909284829271e-16,  -1.636037462606254e-17,   2.075647979067101e-01,  -2.115988466750592e-03,   2.136263686254005e-05,  -2.008543400428209e-07,
   1.162868511756690e-09,   2.009703386025436e-11,  -9.404348161324474e-13,   1.501526347705551e-14,   1.742768017516846e-16,  -1.636438198742311e-17,   2.075697917730649e-01,
  -2.116129081339893e-03,   2.136424985724464e-05,  -2.008068422193080e-07,   1.159585993066701e-09,   2.016872802711933e-11,  -9.392196550048754e-13,   1.487750165917685e-14,
   1.783464040828128e-16,  -1.637043548747907e-17,   2.075750907863826e-01,  -2.116278272047246e-03,   2.136595969594456e-05,  -2.007563830131647e-07,   1.156104572903883e-09,
   2.024455467637605e-11,  -9.379206516348383e-13,   1.473131199787403e-14,   1.826491097848678e-16,  -1.637614619411774e-17,   2.075792612355120e-01,  -2.116395677050356e-03,
   2.136730413675521e-05,  -2.007166277421010e-07,   1.153365829831669e-09,   2.030405223783864e-11,  -9.368913756352909e-13,   1.461625086196241e-14,   1.860241577730193e-16,
  -1.638012569472990e-17,   2.075816681224427e-01,  -2.116463430217000e-03,   2.136807955442013e-05,  -2.006936667429108e-07,   1.151785711324310e-09,   2.033831792615041e-11,
  -9.362945776764344e-13,   1.454984345494307e-14,   1.879674686649073e-16,  -1.638221630339551e-17,   2.075825719398237e-01,  -2.116488871532376e-03,   2.136837063972765e-05,
  -2.006850413633898e-07,   1.151192448934539e-09,   2.035117151496546e-11,  -9.360699487134313e-13,   1.452490620782855e-14,   1.886963510758004e-16,  -1.638296244485959e-17,
   2.075827217608823e-01,  -2.116493088759082e-03,   2.136841888644470e-05,  -2.006836114094704e-07,   1.151094111839091e-09,   2.035330146816020e-11,  -9.360326855441520e-13,
   1.452077247102858e-14,   1.888171289070620e-16,  -1.638308407717945e-17,   3.174679578179166e-01,  -3.236110481562705e-03,   3.264747785523895e-05,  -3.051131096397699e-07,
   1.655352334062250e-09,   3.609454381240061e-11,  -1.605891269174509e-12,   2.627323931498755e-14,   2.562777493984832e-16,  -2.697775651034115e-17,   3.174726065969509e-01,
  -3.236240557210199e-03,   3.264887192804470e-05,  -3.050611022584487e-07,   1.651937680590746e-09,   3.617084582259609e-11,  -1.604782328620473e-12,   2.613470795454300e-14,
   2.605250511090219e-16,  -2.699061890810139e-17,   3.174802384606219e-01,  -3.236454081246208e-03,   3.265115842120538e-05,  -3.049756461629947e-07,   1.646333731585921e-09,
   3.629580850474717e-11,  -1.602949696617813e-12,   2.590724540508310e-14,   2.674792833787658e-16,  -2.701084222228961e-17,   3.174883366487284e-01,  -3.236680624734457e-03,
   3.265358170967353e-05,  -3.048848653961737e-07,   1.640389907078338e-09,   3.642799659273742e-11,  -1.600988680506457e-12,   2.566583627684269e-14,   2.748332211794079e-16,
  -2.703108990513745e-17,   3.174947101034552e-01,  -3.236858899699469e-03,   3.265548678200974e-05,  -3.048133443881977e-07,   1.635713830542168e-09,   3.653173461728181e-11,
  -1.599433461824271e-12,   2.547580850032129e-14,   2.806026543487006e-16,  -2.704614986675898e-17,   3.174983884041485e-01,  -3.236961779270717e-03,   3.265658540754033e-05,
  -3.047720377680412e-07,   1.633015877282721e-09,   3.659148572052165e-11,  -1.598531156691546e-12,   2.536612517884097e-14,   2.839250217093484e-16,  -2.705449101940511e-17,
   3.174997696530920e-01,  -3.237000410363229e-03,   3.265699779568716e-05,  -3.047565209716550e-07,   1.632002901994067e-09,   3.661390052313300e-11,  -1.598191433726837e-12,
   2.532493530137376e-14,   2.851712257247395e-16,  -2.705755706786588e-17,   3.174999986154268e-01,  -3.237006813955953e-03,   3.265706614666104e-05,  -3.047539485373511e-07,
   1.631834993863840e-09,   3.661761491942568e-11,  -1.598135072409297e-12,   2.531810734853763e-14,   2.853777291609490e-16,  -2.705806182178127e-17,   4.575040972808783e-01,
  -4.663172832505581e-03,   4.699384700375971e-05,  -4.350690663973523e-07,   2.109534621168988e-09,   6.401554551379345e-11,  -2.689387456165769e-12,   4.530990171734246e-14,
   3.424643345300777e-16,  -4.307398683205551e-17,   4.575107884069662e-01,  -4.663358247094657e-03,   4.699561580348119e-05,  -4.349768574915534e-07,   2.103812005283737e-09,
   6.414740878660529e-11,  -2.687874979363150e-12,   4.508828585918867e-14,   3.496181397189438e-16,  -4.311059714642776e-17,   4.575217731504091e-01,  -4.663662606448058e-03,
   4.699851604879000e-05,  -4.348253474908085e-07,   2.094419816837659e-09,   6.436340442005132e-11,  -2.685371564051065e-12,   4.472434319831278e-14,   3.613338585038823e-16,
  -4.316921328117266e-17,   4.575334290526978e-01,  -4.663985516215526e-03,   4.700158864234489e-05,  -4.346644016070660e-07,   2.084457273851997e-09,   6.459194097344191e-11,
  -2.682687512508524e-12,   4.433800589398988e-14,   3.737264671212369e-16,  -4.322939328718989e-17,   4.575426024830387e-01,  -4.664239619623446e-03,   4.700400332156035e-05,
  -4.345376047446559e-07,   2.076619099235274e-09,   6.477132862417457e-11,  -2.680555104826333e-12,   4.403383856782203e-14,   3.834514649066712e-16,  -4.327529769473108e-17,
   4.575478967187639e-01,  -4.664386256328890e-03,   4.700539549020311e-05,  -4.344643751116427e-07,   2.072096501495521e-09,   6.487466758214200e-11,  -2.679316427308071e-12,
   4.385825119714625e-14,   3.890526913235300e-16,  -4.330120649955513e-17,   4.575498847700912e-01,  -4.664441317725844e-03,   4.700591800068312e-05,  -4.344368667067132e-07,
   2.070398404203499e-09,   6.491343663050058e-11,  -2.678849776478885e-12,   4.379230770455621e-14,   3.911538773895865e-16,  -4.331082530933875e-17,   4.575502143187497e-01,
  -4.664450444827399e-03,   4.700600460041691e-05,  -4.344323062701675e-07,   2.070116929945047e-09,   6.491986126870515e-11,  -2.678772342529915e-12,   4.378137617063430e-14,
   3.915020666346980e-16,  -4.331241395314933e-17,   6.351870434092654e-01,  -6.473369801883385e-03,   6.512550409648986e-05,  -5.937668877432304e-07,   2.307440556965721e-09,
   1.164241066006971e-10,  -4.620120520907157e-12,   8.152093792845329e-14,   3.656974385047979e-16,  -6.884172730711943e-17,   6.351963150958276e-01,  -6.473622701247834e-03,
   6.512741854213825e-05,  -5.935992039900604e-07,   2.297599141420789e-09,   1.166620431342844e-10,  -4.618405557905411e-12,   8.116551904887739e-14,   3.781608897243655e-16,
  -6.894610753407628e-17,   6.352115362582929e-01,  -6.474037824287307e-03,   6.513055534781765e-05,  -5.933236815986415e-07,   2.281445647320906e-09,   1.170518850356443e-10,
  -4.615554515969394e-12,   8.058167391484391e-14,   3.985795010543096e-16,  -6.911494708040396e-17,   6.352276873439076e-01,  -6.474478230937709e-03,   6.513387549693035e-05,
  -5.930310020756686e-07,   2.264309352926340e-09,   1.174644912854652e-10,  -4.612480952230870e-12,   7.996167471275997e-14,   4.201877928624136e-16,  -6.929068073686256e-17,
   6.352403985181306e-01,  -6.474824781864064e-03,   6.513648250351571e-05,  -5.928004239104158e-07,   2.250825782252570e-09,   1.177884568103265e-10,  -4.610027060002069e-12,
   7.947337813623259e-14,   4.371519452931480e-16,  -6.942651184688487e-17,   6.352477344593951e-01,  -6.475024762557484e-03,   6.513798466589675e-05,  -5.926672575157794e-07,
   2.243045273294496e-09,   1.179751197934930e-10,  -4.608596865921372e-12,   7.919143207205591e-14,   4.469255452513164e-16,  -6.950391252936121e-17,   6.352504891922757e-01,
  -6.475099853397291e-03,   6.513854829070746e-05,  -5.926172342249641e-07,   2.240123828057639e-09,   1.180451561550827e-10,  -4.608057168824748e-12,   7.908553211053449e-14,
   4.505924603699340e-16,  -6.953279021921256e-17,   6.352509458294190e-01,  -6.475112300573094e-03,   6.513864169573785e-05,  -5.926089412000040e-07,   2.239639567964866e-09,
   1.180567626537237e-10,  -4.607967566821058e-12,   7.906797628662272e-14,   4.512001367687355e-16,  -6.953756724522353e-17,   8.651001479812671e-01,  -8.814418359870143e-03,
   8.840756801535538e-05,  -7.831986638924921e-07,   1.562025104607340e-09,   2.309640027928608e-10,  -8.735807451080994e-12,   1.671569626448391e-13,  -3.599877369535662e-17,
  -1.136607342897406e-16,   8.651127314954428e-01,  -8.814751548046109e-03,   8.840879611924859e-05,  -7.828658561407545e-07,   1.543382535545232e-09,   2.314540755040302e-10,
  -8.735449228595721e-12,   1.665655970959502e-13,  -1.177183538246648e-17,  -1.140029743849816e-16,   8.651333894804786e-01,  -8.815298426718580e-03,   8.841080074740682e-05,
  -7.823189982159297e-07,   1.512778559595742e-09,   2.322573260269557e-10,  -8.734791689519769e-12,   1.655935414345898e-13,   2.794585893276354e-17,  -1.145603284968756e-16,
   8.651553093481428e-01,  -8.815878566317610e-03,   8.841291217943064e-05,  -7.817380606857290e-07,   1.480306546450896e-09,   2.331078915712508e-10,  -8.733999676732998e-12,
   1.645604480677821e-13,   7.001467084492794e-17,  -1.151456247025268e-16,   8.651725605065183e-01,  -8.816335037121122e-03,   8.841456256881546e-05,  -7.812803687479606e-07,
   1.454751795061913e-09,   2.337760263225120e-10,  -8.733308142261511e-12,   1.637461982389046e-13,   1.030686828759232e-16,  -1.156018400771093e-16,   8.651825165302152e-01,
  -8.816598434395752e-03,   8.841551050379909e-05,  -7.810160291321455e-07,   1.440004021659894e-09,   2.341611125880609e-10,  -8.732881722517455e-12,   1.632758001113740e-13,
   1.221229236070243e-16,  -1.158633609753064e-16,   8.651862551241968e-01,  -8.816697334948631e-03,   8.841586560528257e-05,  -7.809167298315922e-07,   1.434466158462322e-09,
   2.343056203690226e-10,  -8.732716436297724e-12,   1.630990707517714e-13,   1.292738356859946e-16,  -1.159612301610084e-16,   8.651868748500885e-01,  -8.816713728722374e-03,
   8.841592442319811e-05,  -7.809002675920936e-07,   1.433548182231128e-09,   2.343295695397839e-10,  -8.732688765522222e-12,   1.630697705799358e-13,   1.304589828196709e-16,
  -1.159774357329225e-16,   1.184727121159977e+00,  -1.206450459000430e-02,   1.201143223297291e-04,  -9.851521935699128e-07,  -3.572692297819122e-09,   5.966854194258313e-10,
  -2.242064932368611e-11,   5.146701341360314e-13,  -4.787758289525026e-15,  -1.731917878417766e-16,   1.184744207623058e+00,  -1.206492212536991e-02,   1.201109993565854e-04,
  -9.842902213133152e-07,  -3.620760996405345e-09,   5.982084492757969e-10,  -2.243843047889127e-11,   5.137350975632604e-13,  -4.725361338463589e-15,  -1.749762691680057e-16,
   1.184772257432721e+00,  -1.206560730828244e-02,   1.201055144272369e-04,  -9.828735940778443e-07,  -3.699700289614153e-09,   6.007066986583090e-10,  -2.246744102913797e-11,
   5.121935197856541e-13,  -4.622858310473592e-15,  -1.778999920407556e-16,   1.184802019924176e+00,  -1.206633397450301e-02,   1.200996540772283e-04,  -9.813683237125362e-07,
  -3.783497176979413e-09,   6.033547396405941e-10,  -2.249797859707613e-11,   5.105488776080267e-13,  -4.514002754298258e-15,  -1.809943829008581e-16,   1.184825442780288e+00,
  -1.206690559957731e-02,   1.200950126816944e-04,  -9.801821344558098e-07,  -3.849471854721493e-09,   6.054367322842767e-10,  -2.252183445018212e-11,   5.092480945891383e-13,
  -4.428267053458094e-15,  -1.834239352338364e-16,   1.184838960415389e+00,  -1.206723538926848e-02,   1.200923223067171e-04,  -9.794969470138504e-07,  -3.887557548796390e-09,
   6.066374754153769e-10,  -2.253553100265229e-11,   5.084948085067376e-13,  -4.378761171735656e-15,  -1.848237641405580e-16,   1.184844036392782e+00,  -1.206735920847379e-02,
   1.200913098258795e-04,  -9.792395362191295e-07,  -3.901861069942172e-09,   6.070882120182193e-10,  -2.254066074740802e-11,   5.082114550481555e-13,  -4.360166310904197e-15,
  -1.853489755686998e-16,   1.184844877807160e+00,  -1.206737973221867e-02,   1.200911418756575e-04,  -9.791968605716421e-07,  -3.904232186820224e-09,   6.071629199116826e-10,
  -2.254151036656627e-11,   5.081644594718209e-13,  -4.357083688251435e-15,  -1.854360137364361e-16,   2.360677107600564e-03,  -2.313475567612268e-05,   2.258784677625396e-07,
  -2.141764354403328e-09,   1.689428546082314e-11,   3.394780798125491e-15,  -5.004224943583155e-15,   1.396844536022852e-16,  -1.508446595060166e-18,  -3.891299864822005e-20,
   2.360709280650697e-03,  -2.313567001242811e-05,   2.258928319107223e-07,  -2.141756030484702e-09,   1.688353604089829e-11,   3.808851711183858e-15,  -5.009931548619725e-15,
   1.394748744245549e-16,  -1.493803798208869e-18,  -3.929542488010460e-20,   2.360762099388682e-03,  -2.313717104011089e-05,   2.259164063302507e-07,  -2.141741940937107e-09,
   1.686588048531633e-11,   4.488156830435135e-15,  -5.019257664232621e-15,   1.391294127715774e-16,  -1.469760167156509e-18,  -3.992157647994785e-20,   2.360818146148670e-03,
  -2.313876374189012e-05,   2.259414115646868e-07,  -2.141726414184600e-09,   1.684713486528871e-11,   5.208326184682988e-15,  -5.029096032663148e-15,   1.387609471613845e-16,
  -1.444241274879981e-18,  -4.058370696322392e-20,   2.360862256688745e-03,  -2.314001720317195e-05,   2.259610842632893e-07,  -2.141713777241817e-09,   1.683237351281391e-11,
   5.774648798007029e-15,  -5.036797343592539e-15,   1.384695868458993e-16,  -1.424153051550044e-18,  -4.110316373595938e-20,   2.360887714323296e-03,  -2.314074059881216e-05,
   2.259724351351181e-07,  -2.141706317005716e-09,   1.682385106931327e-11,   6.101302057965206e-15,  -5.041225268896024e-15,   1.383008864454940e-16,  -1.412557905267641e-18,
  -4.140229244567899e-20,   2.360897274027705e-03,  -2.314101224080614e-05,   2.259766970037013e-07,  -2.141703484016672e-09,   1.682065016959208e-11,   6.223929042250713e-15,
  -5.042884851291855e-15,   1.382374337912361e-16,  -1.408203471062225e-18,  -4.151449337090583e-20,   2.360898858691322e-03,  -2.314105726934097e-05,   2.259774034432193e-07,
  -2.141703012741545e-09,   1.682011954104537e-11,   6.244254395557539e-15,  -5.043159784774363e-15,   1.382269101228932e-16,  -1.407481643402721e-18,  -4.153308568885451e-20,
   2.132997863167128e-02,  -2.090342693139989e-04,   2.040846697365185e-06,  -1.934438794443792e-08,   1.521711122980413e-10,   5.307351802630880e-14,  -4.600524095666253e-14,
   1.282171348408699e-15,  -1.392707373929120e-17,  -3.531422350633601e-19,   2.133026931929866e-02,  -2.090425274730757e-04,   2.040976067534934e-06,  -1.934428035234458e-08,
   1.520722868507531e-10,   5.687462819367356e-14,  -4.605795579282435e-14,   1.280268282899249e-15,  -1.379319963410785e-17,  -3.566537619078069e-19,   2.133074654331533e-02,
  -2.090560845374231e-04,   2.041188388427040e-06,  -1.934409982563261e-08,   1.519099690292027e-10,   6.311059441417409e-14,  -4.614410988914912e-14,   1.277131204508753e-15,
  -1.357337387495377e-17,  -3.624033603277035e-19,   2.133125293286171e-02,  -2.090704695751465e-04,   2.041413594130348e-06,  -1.934390297902739e-08,   1.517376290707563e-10,
   6.972175220496287e-14,  -4.623500158328812e-14,   1.273785036446387e-15,  -1.334005600825254e-17,  -3.684835072849404e-19,   2.133165147711221e-02,  -2.090817906348508e-04,
   2.041590771962015e-06,  -1.934374422872139e-08,   1.516019185314425e-10,   7.492064058369954e-14,  -4.630615404378644e-14,   1.271138949014783e-15,  -1.315638748476402e-17,
  -3.732536507048254e-19,   2.133188149000931e-02,  -2.090883242233508e-04,   2.041693000599183e-06,  -1.934365107578120e-08,   1.515235661090968e-10,   7.791936228235740e-14,
  -4.634706526712023e-14,   1.269606783275570e-15,  -1.305037077681702e-17,  -3.760005842917362e-19,   2.133196786312534e-02,  -2.090907776476762e-04,   2.041731383902802e-06,
  -1.934361580586194e-08,   1.514941381052227e-10,   7.904509816900273e-14,  -4.636239905876825e-14,   1.269030484947109e-15,  -1.301055710178741e-17,  -3.770309480041366e-19,
   2.133198218075766e-02,  -2.090911843377105e-04,   2.041737746243881e-06,  -1.934360994406761e-08,   1.514892596818684e-10,   7.923168843314598e-14,  -4.636493933591802e-14,
   1.268934904900513e-15,  -1.300395724009929e-17,  -3.772016855153248e-19,   5.972844121794583e-02,  -5.853365294998010e-04,   5.714299551265556e-06,  -5.412393819703000e-08,
   4.233130749268370e-10,   2.800330160623281e-13,  -1.334665963840876e-13,   3.708688774251478e-15,  -4.077099391544226e-17,  -9.973155293749932e-19,   5.972925512830535e-02,
  -5.853596344478448e-04,   5.714659369210553e-06,  -5.412344692401946e-08,   4.230263521652119e-10,   2.910297241786755e-13,  -1.336210796153751e-13,   3.703307630545677e-15,
  -4.038692763011713e-17,  -1.007480872568521e-18,   5.973059133067393e-02,  -5.853975647872521e-04,   5.715249891095096e-06,  -5.412262914526033e-08,   4.225554162366025e-10,
   3.090708013311616e-13,  -1.338735818185394e-13,   3.694436296536102e-15,  -3.975625962227322e-17,  -1.024125873434175e-18,   5.973200919465529e-02,  -5.854378115732485e-04,
   5.715876239134299e-06,  -5.412174610237082e-08,   4.220553995768567e-10,   3.281976988031927e-13,  -1.341400013946101e-13,   3.684972498282402e-15,  -3.908685863173781e-17,
  -1.041728863330640e-18,   5.973312509725116e-02,  -5.854694858332291e-04,   5.716369003549156e-06,  -5.412104005876125e-08,   4.216616548828481e-10,   3.432389909035277e-13,
  -1.343485853166088e-13,   3.677487853084082e-15,  -3.855988618495728e-17,  -1.055539950838880e-18,   5.973376912096518e-02,  -5.854877655985690e-04,   5.716653317446861e-06,
  -5.412062814583271e-08,   4.214343255864160e-10,   3.519149227335586e-13,  -1.344685263176910e-13,   3.673153675238611e-15,  -3.825570120329501e-17,  -1.063493507584986e-18,
   5.973401096101524e-02,  -5.854946298190385e-04,   5.716760066894061e-06,  -5.412047262917778e-08,   4.213489439030506e-10,   3.551719332268802e-13,  -1.345134827783575e-13,
   3.671523383448990e-15,  -3.814146575471651e-17,  -1.066476912815779e-18,   5.973405104960979e-02,  -5.854957676611371e-04,   5.716777761443942e-06,  -5.412044680579687e-08,
   4.213347897564272e-10,   3.557117824477747e-13,  -1.345209305986859e-13,   3.671252993454323e-15,  -3.812252901965176e-17,  -1.066971284212491e-18,   1.185401010513971e-01,
  -1.161677334919990e-03,   1.133928234904503e-05,  -1.072745518981392e-07,   8.311277000102160e-10,   9.798087239891878e-13,  -2.799263372987318e-13,   7.746437540671579e-15,
  -8.679126541200617e-17,  -2.003026973002316e-18,   1.185417161347523e-01,  -1.161723127141158e-03,   1.133998859304144e-05,  -1.072729637354551e-07,   8.305262772922402e-10,
   1.002784382708723e-12,  -2.802557273021920e-13,   7.735607187208372e-15,  -8.599945545686157e-17,  -2.024292036672502e-18,   1.185443676276417e-01,  -1.161798301950152e-03,
   1.134114763450659e-05,  -1.072703329503323e-07,   8.295384450932445e-10,   1.040478883756374e-12,  -2.807941916531676e-13,   7.717749327972565e-15,  -8.469917714068616e-17,
  -2.059114638517586e-18,   1.185471811646088e-01,  -1.161878067504430e-03,   1.134237696085840e-05,  -1.072675094787827e-07,   8.284896018873365e-10,   1.080443277236818e-12,
  -2.813624410425285e-13,   7.698694818921647e-15,  -8.331895686553305e-17,  -2.095944997913466e-18,   1.185493955039875e-01,  -1.161940842884538e-03,   1.134334408050844e-05,
  -1.072652642298542e-07,   8.276636682008678e-10,   1.111871944657859e-12,  -2.818074092529585e-13,   7.683622257266985e-15,  -8.223234528210862e-17,  -2.124844230834407e-18,
   1.185506734709988e-01,  -1.161977071570365e-03,   1.134390207715624e-05,  -1.072639591718440e-07,   8.271868103761259e-10,   1.130000591342724e-12,  -2.820633082332069e-13,
   7.674892943394661e-15,  -8.160509466925064e-17,  -2.141487818669755e-18,   1.185511533656974e-01,  -1.161990675761659e-03,   1.134411158265394e-05,  -1.072634673558071e-07,
   8.270077086586824e-10,   1.136806289115580e-12,  -2.821592305526815e-13,   7.671609212762884e-15,  -8.136952860862855e-17,  -2.147731079809969e-18,   1.185512329153964e-01,
  -1.161992930848954e-03,   1.134414630972271e-05,  -1.072633857377499e-07,   8.269780180421900e-10,   1.137934336472715e-12,  -2.821751220660457e-13,   7.671064582281010e-15,
  -8.133047873473610e-17,  -2.148765642825833e-18,   1.994251424617110e-01,  -1.954311884973396e-03,   1.907254823834291e-05,  -1.801151144489871e-07,   1.375585395978094e-09,
   2.720815307231031e-12,  -5.092183364790291e-13,   1.402459365214297e-14,  -1.614904807786370e-16,  -3.415487359352198e-18,   1.994278589748087e-01,  -1.954388765096249e-03,
   1.907371657045860e-05,  -1.801108914598093e-07,   1.374491158534930e-09,   2.762428967412266e-12,  -5.098326087051060e-13,   1.400606331933136e-14,  -1.600839985737262e-16,
  -3.454089725472580e-18,   1.994323186900116e-01,  -1.954514974878882e-03,   1.907563389918041e-05,  -1.801039160620327e-07,   1.372693858453013e-09,   2.830703832346743e-12,
  -5.108369803705402e-13,   1.397550098499195e-14,  -1.577741614673579e-16,  -3.517310133697571e-18,   1.994370509546586e-01,  -1.954648891328704e-03,   1.907766741201647e-05,
  -1.800964566465995e-07,   1.370785520611629e-09,   2.903093268361233e-12,  -5.118971831020527e-13,   1.394287958621710e-14,  -1.553220848365970e-16,  -3.584185294025834e-18,
   1.994407753891670e-01,  -1.954754282908792e-03,   1.907926713014261e-05,  -1.800905440871433e-07,   1.369282736560303e-09,   2.960023839968229e-12,  -5.127275754702936e-13,
   1.391706731527585e-14,  -1.533914628168651e-16,  -3.636666428401841e-18,   1.994429248801871e-01,  -1.954815105899676e-03,   1.908019009124345e-05,  -1.800871150197271e-07,
   1.368415085755365e-09,   2.992863390702366e-12,  -5.132052103188866e-13,   1.390211488787895e-14,  -1.522769376400585e-16,  -3.666894071591041e-18,   1.994437320443287e-01,
  -1.954837945433233e-03,   1.908053662174271e-05,  -1.800858241935614e-07,   1.368089205415916e-09,   3.005191902322332e-12,  -5.133842643422778e-13,   1.389648959177570e-14,
  -1.518583614544909e-16,  -3.678233449564310e-18,   1.994438658438077e-01,  -1.954841731407331e-03,   1.908059406146500e-05,  -1.800856100530512e-07,   1.368035182456337e-09,
   3.007235367708063e-12,  -5.134139291445184e-13,   1.389555656416319e-14,  -1.517889732626601e-16,  -3.680112511854184e-18,   3.050233793460218e-01,  -2.989083298526154e-03,
   2.916277554646476e-05,  -2.746893508440843e-07,   2.053053402369506e-09,   6.588679488151892e-12,  -8.663204121499592e-13,   2.375155252145936e-14,  -2.841451983065403e-16,
  -5.277597843358570e-18,   3.050275329270087e-01,  -2.989200534118801e-03,   2.916451797751107e-05,  -2.746793797242006e-07,   2.051191337789676e-09,   6.659196238275222e-12,
  -8.674044846197669e-13,   2.372275805532481e-14,  -2.818274058892976e-16,  -5.343265603709343e-18,   3.050343518801502e-01,  -2.989392992107490e-03,   2.916737730695600e-05,
  -2.746629381800569e-07,   2.048132810416638e-09,   6.774897563840230e-12,  -8.691774792198115e-13,   2.367524593505521e-14,  -2.780205195874787e-16,  -5.450829628912500e-18,
   3.050415875579745e-01,  -2.989597200533945e-03,   2.917040970876972e-05,  -2.746453941547976e-07,   2.044885243719939e-09,   6.897579253988971e-12,  -8.710496741074538e-13,
   2.362450438829870e-14,  -2.739786313973998e-16,  -5.564635971046227e-18,   3.050472822492657e-01,  -2.989757910462186e-03,   2.917279508943087e-05,  -2.746315157885411e-07,
   2.042327779530491e-09,   6.994067639220452e-12,  -8.725165181287418e-13,   2.358433378172410e-14,  -2.707958693073957e-16,  -5.653964401658721e-18,   3.050505688370275e-01,
  -2.989850658027955e-03,   2.917417128394866e-05,  -2.746234778104965e-07,   2.040851172179884e-09,   7.049727746437784e-12,  -8.733604229072865e-13,   2.356105576871103e-14,
  -2.689583322586135e-16,  -5.705422047086476e-18,   3.050518029966540e-01,  -2.989885485419547e-03,   2.917468797260032e-05,  -2.746204540838528e-07,   2.040296569745218e-09,
   7.070623893323198e-12,  -8.736768185482882e-13,   2.355229674597403e-14,  -2.682681870141383e-16,  -5.724726819131504e-18,   3.050520075769759e-01,  -2.989891258545459e-03,
   2.917477361659888e-05,  -2.746199525737747e-07,   2.040204630037718e-09,   7.074087476558490e-12,  -8.737292393283150e-13,   2.355084386878601e-14,  -2.681537786327771e-16,
  -5.727925906656024e-18,   4.395711545560069e-01,  -4.307454881742324e-03,   4.200762199470173e-05,  -3.941427500801862e-07,   2.848565248621040e-09,   1.479643377032686e-11,
  -1.442134072886814e-12,   3.943300555388609e-14,  -4.976745347689164e-16,  -7.549765658380678e-18,   4.395771374046909e-01,  -4.307623071889286e-03,   4.201003664483690e-05,
  -3.941207049984520e-07,   2.845464320983521e-09,   1.491360653825155e-11,  -1.444040333880665e-12,   3.939138862360493e-14,  -4.939785766609043e-16,  -7.659568675457445e-18,
   4.395869594649108e-01,  -4.307899176210075e-03,   4.201399876311193e-05,  -3.940843941897296e-07,   2.840370746098851e-09,   1.510587280606845e-11,  -1.447159102500152e-12,
   3.932266381271170e-14,  -4.879070399870574e-16,  -7.839470632599448e-18,   4.395973817639775e-01,  -4.308192134666636e-03,   4.201820026546112e-05,  -3.940457022522759e-07,
   2.834962136732062e-09,   1.530975694350865e-11,  -1.450453853061214e-12,   3.924919329645561e-14,  -4.814592564463428e-16,  -8.029873078786993e-18,   4.396055844098934e-01,
  -4.308422687568703e-03,   4.202150497842998e-05,  -3.940151332562195e-07,   2.830702692429841e-09,   1.547012378482232e-11,  -1.453036332939187e-12,   3.919097529375763e-14,
  -4.763809396272788e-16,  -8.179366628747790e-18,   4.396103184141413e-01,  -4.308555741368633e-03,   4.202341143446624e-05,  -3.939974439088684e-07,   2.828243347635594e-09,
   1.556263800584496e-11,  -1.454522519617692e-12,   3.915721787164171e-14,  -4.734486034664997e-16,  -8.265499894975575e-18,   4.396120960981212e-01,  -4.308605703865963e-03,
   4.202412718428271e-05,  -3.939907924289796e-07,   2.827319624735551e-09,   1.559737107976955e-11,  -1.455079801013505e-12,   3.914451165556368e-14,  -4.723471926267915e-16,
  -8.297816831604938e-18,   4.396123907756522e-01,  -4.308613985837199e-03,   4.202424582249507e-05,  -3.939896893786535e-07,   2.827166493135228e-09,   1.560312821767047e-11,
  -1.455172136359200e-12,   3.914240383796300e-14,  -4.721646027854862e-16,  -8.303172402899747e-18,   6.102915207608188e-01,  -5.980097269577848e-03,   5.828126430191939e-05,
  -5.434690183339342e-07,   3.710962536069407e-09,   3.247050194897150e-11,  -2.447111643016738e-12,   6.709233928994666e-14,  -9.151488666791513e-16,  -9.691711573122843e-18,
   6.102998209242337e-01,  -5.980329118944825e-03,   5.828440303233958e-05,  -5.434211258699236e-07,   3.705697221174155e-09,   3.267011991798940e-11,  -2.450635721900722e-12,
   6.703763221996684e-14,  -9.092580029180656e-16,  -9.880484764736483e-18,   6.103134473042368e-01,  -5.980709722042276e-03,   5.828955250382483e-05,  -5.433422976889450e-07,
   3.697047982521990e-09,   3.299770367961184e-11,  -2.456404048559730e-12,   6.694712643966739e-14,  -8.995778371956373e-16,  -1.018989309075291e-17,   6.103279063792533e-01,
  -5.981113550706425e-03,   5.829501205530032e-05,  -5.432583764209195e-07,   3.687863185087065e-09,   3.334512949937743e-11,  -2.462501543928027e-12,   6.685014889419975e-14,
  -8.892938004222431e-16,  -1.051752566723780e-17,   6.103392860604098e-01,  -5.981431351017626e-03,   5.829930553797664e-05,  -5.431921283729836e-07,   3.680629436782123e-09,
   3.361843470592271e-11,  -2.467283535806088e-12,   6.677314443391281e-14,  -8.811911317450363e-16,  -1.077488421270946e-17,   6.103458536224037e-01,  -5.981614753782187e-03,
   5.830178210238258e-05,  -5.431538145484119e-07,   3.676452592664773e-09,   3.377611587443531e-11,  -2.470036591250010e-12,   6.672843028936425e-14,  -8.765113070655780e-16,
  -1.092321367457330e-17,   6.103483198309503e-01,  -5.981683622207112e-03,   5.830271183336685e-05,  -5.431394120600757e-07,   3.674883748455611e-09,   3.383531750802867e-11,
  -2.471069119298864e-12,   6.671158804617675e-14,  -8.747533055706805e-16,  -1.097887550103821e-17,   6.103487286415683e-01,  -5.981695038074308e-03,   5.830286593673434e-05,
  -5.431370238361715e-07,   3.674623669101795e-09,   3.384513053954486e-11,  -2.471240208506542e-12,   6.670879347996527e-14,  -8.744618558102496e-16,  -1.098810027230444e-17,
   8.311984514315944e-01,  -8.144041673106124e-03,   7.927893073141138e-05,  -7.310934327288422e-07,   4.450601965114953e-09,   7.450482838898743e-11,  -4.501944884779256e-12,
   1.255588882942670e-13,  -1.936343345866939e-15,  -7.818767002210030e-18,   8.312097409361724e-01,  -8.144353406631092e-03,   7.928267585531932e-05,  -7.309842464640901e-07,
   4.440903094535324e-09,   7.487924325805917e-11,  -4.509459381933001e-12,   1.255092743399579e-13,  -1.926678437882917e-15,  -8.175238041924008e-18,   8.312282748619597e-01,
  -8.144865133246701e-03,   7.928881806875048e-05,  -7.308046147694149e-07,   4.424969341892433e-09,   7.549379249780451e-11,  -4.521767663220582e-12,   1.254265089118329e-13,
  -1.910786237544591e-15,  -8.759931859181386e-18,   8.312479413016736e-01,  -8.145408067897764e-03,   7.929532725511303e-05,  -7.306134887878792e-07,   4.408046810876427e-09,
   7.614572111128738e-11,  -4.534789630904565e-12,   1.253369007772578e-13,  -1.893888612429572e-15,  -9.379636523032143e-18,   8.312634192635255e-01,  -8.145835326358163e-03,
   7.930044409572290e-05,  -7.304626931159961e-07,   4.394717422600000e-09,   7.665867845420384e-11,  -4.545010392636609e-12,   1.252650852598420e-13,  -1.880565028405360e-15,
  -9.866835295926370e-18,   8.312723520463827e-01,  -8.146081891939614e-03,   7.930339474916246e-05,  -7.303755142728186e-07,   4.387020261585303e-09,   7.695467010736807e-11,
  -4.550897922204882e-12,   1.252231209220865e-13,  -1.872865717373469e-15,  -1.014780041535314e-17,   8.312757064232131e-01,  -8.146174477188902e-03,   7.930450229978865e-05,
  -7.303427490771939e-07,   4.384129049306715e-09,   7.706580916269995e-11,  -4.553106654171647e-12,   1.252072649843460e-13,  -1.869972661884794e-15,  -1.025326633466887e-17,
   8.312762624606655e-01,  -8.146189824383148e-03,   7.930468586846422e-05,  -7.303373162644414e-07,   4.383649744570193e-09,   7.708423158897263e-11,  -4.553472672616267e-12,
   1.252046314712455e-13,  -1.869492997052959e-15,  -1.027074674384362e-17,   1.138315672896374e+00,  -1.115110920121790e-02,   1.082611475131856e-04,  -9.715453202263785e-07,
   4.041602276830386e-09,   2.106460524533322e-10,  -1.066755412215229e-11,   3.181900291304275e-13,  -6.224319240799448e-15,   4.403212811985155e-17,   1.138331085927161e+00,
  -1.115152288620752e-02,   1.082644676034718e-04,  -9.712374970910894e-07,   4.018540659390171e-09,   2.116001502536451e-10,  -1.069205069805881e-11,   3.183932063157048e-13,
  -6.209728156771090e-15,   4.319921556448801e-17,   1.138356389232815e+00,  -1.115220192021272e-02,   1.082699037445823e-04,  -9.707311729101867e-07,   3.980643649718443e-09,
   2.131668804903982e-10,  -1.073222316117743e-11,   3.187236588432018e-13,  -6.185668364316591e-15,   4.183032187299508e-17,   1.138383238431525e+00,  -1.115292229597295e-02,
   1.082756524296241e-04,  -9.701925880304223e-07,   3.940380884214733e-09,   2.148298753258069e-10,  -1.077479114296502e-11,   3.190700841158923e-13,  -6.159994895288236e-15,
   4.037574835973526e-17,   1.138404369206884e+00,  -1.115348913992381e-02,   1.082801625603141e-04,  -9.697677515664129e-07,   3.908656900330361e-09,   2.161390729506898e-10,
  -1.080825016605909e-11,   3.193396717775446e-13,  -6.139685452022737e-15,   3.922950087675616e-17,   1.138416564316555e+00,  -1.115381623830466e-02,   1.082827597837917e-04,
  -9.695221823203282e-07,   3.890333556589569e-09,   2.168948006782929e-10,  -1.082754306250611e-11,   3.194940323697852e-13,  -6.127922702596229e-15,   3.856738465994044e-17,
   1.138421143725296e+00,  -1.115393905974608e-02,   1.082837339966289e-04,  -9.694298953182346e-07,   3.883450160258291e-09,   2.171786148727323e-10,  -1.083478452618872e-11,
   3.195517649179335e-13,  -6.123497781506946e-15,   3.831864145947955e-17,   1.138421902829098e+00,  -1.115395941877527e-02,   1.082838954298731e-04,  -9.694145935591494e-07,
   3.882308991180454e-09,   2.172256627661988e-10,  -1.083598473293811e-11,   3.195613227050683e-13,  -6.122763871267506e-15,   3.827740281522157e-17,   2.271595814620418e-03,
  -2.142596845063274e-05,   2.017836215586611e-07,  -1.876217703723882e-09,   1.604624356256599e-11,  -7.599578892828966e-14,  -1.877832525281333e-15,   8.255239505868131e-17,
  -1.753608506699676e-18,   1.378616508314180e-20,   2.271624557417327e-03,  -2.142676982358658e-05,   2.017972993321363e-07,  -1.876323758776043e-09,   1.604215312788733e-11,
  -7.574805599608503e-14,  -1.884744320166564e-15,   8.261748061318501e-17,  -1.749985969638166e-18,   1.357994815933590e-20,   2.271671744774773e-03,  -2.142808543926025e-05,
   2.018197510611868e-07,  -1.876497610079035e-09,   1.603542739378282e-11,  -7.534122531115376e-14,  -1.896080580592007e-15,   8.272356399647165e-17,  -1.744015138872464e-18,
   1.324121051578907e-20,   2.271721816117020e-03,  -2.142948145299835e-05,   2.018435706121613e-07,  -1.876681732794457e-09,   1.602827644072236e-11,  -7.490936124623310e-14,
  -1.908094826649934e-15,   8.283508645207937e-17,  -1.737647256873558e-18,   1.288151600251121e-20,   2.271761223908575e-03,  -2.143058015484538e-05,   2.018623142096434e-07,
  -1.876826387075564e-09,   1.602263816292811e-11,  -7.456934853423582e-14,  -1.917539644185524e-15,   8.292210176125850e-17,  -1.732612299595528e-18,   1.259824308732175e-20,
   2.271783967469657e-03,  -2.143121424986144e-05,   2.018731304974893e-07,  -1.876909769151467e-09,   1.601938001996800e-11,  -7.437306730161568e-14,  -1.922986231588756e-15,
   8.297201787781523e-17,  -1.729697158834173e-18,   1.243468479051394e-20,   2.271792508007707e-03,  -2.143145236124365e-05,   2.018771919303512e-07,  -1.876941060907192e-09,
   1.601815576461333e-11,  -7.429935171056310e-14,  -1.925030684040093e-15,   8.299070476028079e-17,  -1.728600725148146e-18,   1.237325275983898e-20,   2.271793923729660e-03,
  -2.143149183174002e-05,   2.018778651609154e-07,  -1.876946246958951e-09,   1.601795278508089e-11,  -7.428713176741549e-14,  -1.925369539315062e-15,   8.299379936513490e-17,
  -1.728418882263939e-18,   1.236306877122179e-20,   2.052508304626311e-02,  -1.935948883488624e-04,   1.823194112995772e-06,  -1.694995061949629e-08,   1.448070304765152e-10,
  -6.775467259612036e-13,  -1.732687366848017e-14,   7.568603829746526e-16,  -1.608878969181595e-17,   1.276693413471394e-19,   2.052534274838636e-02,  -1.936021279911655e-04,
   1.823317541426481e-06,  -1.695089563235867e-08,   1.447692919976764e-10,  -6.752753431197939e-13,  -1.739029369525377e-14,   7.574637928177861e-16,  -1.605586969635872e-17,
   1.257847168929186e-19,   2.052576910412610e-02,  -1.936140133231438e-04,   1.823520145648515e-06,  -1.695244468375446e-08,   1.447072406955278e-10,  -6.715452301323370e-13,
  -1.749431187032893e-14,   7.584473952184673e-16,  -1.600160735791814e-17,   1.226889347180486e-19,   2.052622151774379e-02,  -1.936266249693148e-04,   1.823735092385475e-06,
  -1.695408516583182e-08,   1.446412670641933e-10,  -6.675855735989538e-13,  -1.760455229110149e-14,   7.594815662773038e-16,  -1.594373381148085e-17,   1.194015619599288e-19,
   2.052657758210950e-02,  -1.936365506834470e-04,   1.823904233401331e-06,  -1.695537393003603e-08,   1.445892496700313e-10,  -6.644680654804857e-13,  -1.769121703392319e-14,
   7.602885780518452e-16,  -1.589797230328377e-17,   1.168125877275172e-19,   2.052678307881638e-02,  -1.936422791202326e-04,   1.824001838682593e-06,  -1.695611677739664e-08,
   1.445591910347347e-10,  -6.626683966328406e-13,  -1.774119476285538e-14,   7.607515590257192e-16,  -1.587147647654859e-17,   1.153177278538196e-19,   2.052686024581805e-02,
  -1.936444302265677e-04,   1.824038488676259e-06,  -1.695639554936395e-08,   1.445478964666048e-10,  -6.619925099786071e-13,  -1.775995466836192e-14,   7.609248909592399e-16,
  -1.586151079441478e-17,   1.147562593406601e-19,   2.052687303740296e-02,  -1.936447868043597e-04,   1.824044563844435e-06,  -1.695644175059617e-08,   1.445460238477730e-10,
  -6.618804671856507e-13,  -1.776306400962109e-14,   7.609535956663491e-16,  -1.585985798375684e-17,   1.146631808618876e-19,   5.747457236219974e-02,  -5.421054825724109e-04,
   5.105160849782183e-06,  -4.744779488532877e-08,   4.044415039064012e-10,  -1.843892913715306e-12,  -5.062883893609935e-14,   2.183802532616832e-15,  -4.649314297558663e-17,
   3.760499899371113e-19,   5.747529955727195e-02,  -5.421257481454624e-04,   5.105505554037795e-06,  -4.745036351642581e-08,   4.043312563964891e-10,  -1.837338547127135e-12,
  -5.081214839657107e-14,   2.185583872679799e-15,  -4.639990134895639e-17,   3.706478060548267e-19,   5.747649340106385e-02,  -5.421590181440625e-04,   5.106071373148871e-06,
  -4.745457358697345e-08,   4.041499854843607e-10,  -1.826574740269431e-12,  -5.111280838454231e-14,   2.188488184908441e-15,  -4.624619758473062e-17,   3.617736218721794e-19,
   5.747776020969759e-02,  -5.421943212439033e-04,   5.106671657478784e-06,  -4.745903161709156e-08,   4.039572603022907e-10,  -1.815148431939503e-12,  -5.143146098616247e-14,
   2.191542629599172e-15,  -4.608224748277751e-17,   3.523498608556868e-19,   5.747875722957364e-02,  -5.422221057355603e-04,   5.107144016645948e-06,  -4.746253346192927e-08,
   4.038053076438246e-10,  -1.806152209801609e-12,  -5.168197294598489e-14,   2.193926751532734e-15,  -4.595259720042966e-17,   3.449278958414089e-19,   5.747933264319878e-02,
  -5.422381410159933e-04,   5.107416597173994e-06,  -4.746455177956179e-08,   4.037175018473391e-10,  -1.800958854164768e-12,  -5.182644008559480e-14,   2.195294758478568e-15,
  -4.587752498338443e-17,   3.406423843571481e-19,   5.747954871937509e-02,  -5.422441624812383e-04,   5.107518948731801e-06,  -4.746530917403182e-08,   4.036845089348733e-10,
  -1.799008422273093e-12,  -5.188066844944777e-14,   2.195806962064035e-15,  -4.584928768529300e-17,   3.390327281827290e-19,   5.747958453723335e-02,  -5.422451606283509e-04,
   5.107535914696264e-06,  -4.746543469642340e-08,   4.036790387816755e-10,  -1.798685095768455e-12,  -5.188965649561868e-14,   2.195891788178018e-15,  -4.584460447384282e-17,
   3.387658833784364e-19,   1.140669859092530e-01,  -1.075886728986646e-03,   1.013142688176953e-05,  -9.411722921429500e-08,   7.993109584383956e-10,  -3.487808362744565e-12,
  -1.072881410350681e-13,   4.542907146781891e-15,  -9.697788920163818e-17,   8.081277218500058e-19,   1.140684290554991e-01,  -1.075926926811402e-03,   1.013210804314677e-05,
  -9.412207742926096e-08,   7.990774022879233e-10,  -3.474171314543803e-12,  -1.076706283078557e-13,   4.546748303816705e-15,  -9.678969374462527e-17,   7.970058558286969e-19,
   1.140707982835432e-01,  -1.075992919517406e-03,   1.013322613424278e-05,  -9.413002250728738e-08,   7.986933940406832e-10,  -3.451775790274565e-12,  -1.082979935061652e-13,
   4.553012908031078e-15,  -9.647942051095317e-17,   7.787350010267501e-19,   1.140733123126420e-01,  -1.076062944876066e-03,   1.013441231730927e-05,  -9.413843374749263e-08,
   7.982851328995844e-10,  -3.428001444915699e-12,  -1.089629274877921e-13,   4.559604013898775e-15,  -9.614840504037967e-17,   7.593313704660831e-19,   1.140752909355545e-01,
  -1.076118056645485e-03,   1.013534570610228e-05,  -9.414503960409463e-08,   7.979632513160323e-10,  -3.409283011027393e-12,  -1.094856901088498e-13,   4.564750594619482e-15,
  -9.588659878779889e-17,   7.440485456693510e-19,   1.140764328651053e-01,  -1.076149863303588e-03,   1.013588432544807e-05,  -9.414884642674833e-08,   7.977772556227258e-10,
  -3.398477083108309e-12,  -1.097871680738776e-13,   4.567704484435274e-15,  -9.573498664597094e-17,   7.352237343389038e-19,   1.140768616762189e-01,  -1.076161807129219e-03,
   1.013608657147936e-05,  -9.415027487805100e-08,   7.977073686419318e-10,  -3.394418755150646e-12,  -1.099003346724549e-13,   4.568810617331269e-15,  -9.567795682362173e-17,
   7.319090287840107e-19,   1.140769327580739e-01,  -1.076163786995039e-03,   1.013612009607935e-05,  -9.415051160898673e-08,   7.976957815669476e-10,  -3.393745997872245e-12,
  -1.099190914717269e-13,   4.568993812078778e-15,  -9.566849814841950e-17,   7.313595214754091e-19,   1.918998959412232e-01,  -1.810002427075427e-03,   1.704320524072228e-05,
  -1.582123763440814e-07,   1.336283111816571e-09,  -5.435712979455183e-12,  -1.977097913167373e-13,   8.174391844543802e-15,  -1.752652338967306e-16,   1.523524949491623e-18,
   1.919023236040522e-01,  -1.810069997980472e-03,   1.704434377639265e-05,  -1.582199044338667e-07,   1.335852872864583e-09,  -5.411168995671804e-12,  -1.984013947037145e-13,
   8.181667053514315e-15,  -1.749417694351130e-16,   1.503812039952240e-18,   1.919063091223159e-01,  -1.810180928834542e-03,   1.704621259888905e-05,  -1.582322377192370e-07,
   1.335145502552799e-09,  -5.370860704048770e-12,  -1.995358283454253e-13,   8.193537306750920e-15,  -1.744083632268585e-16,   1.471425419068453e-18,   1.919105382240173e-01,
  -1.810298638136124e-03,   1.704819519931615e-05,  -1.582452899052277e-07,   1.334393483477162e-09,  -5.328069688896803e-12,  -2.007382616831934e-13,   8.206033056309287e-15,
  -1.738391378876093e-16,   1.437027444873987e-18,   1.919138666642406e-01,  -1.810391278210292e-03,   1.704975525195213e-05,  -1.582555371432494e-07,   1.333800595287448e-09,
  -5.294377941877286e-12,  -2.016836472224020e-13,   8.215795193063262e-15,  -1.733888117148633e-16,   1.409932199668074e-18,   1.919157876182578e-01,  -1.810444743503535e-03,
   1.705065548278973e-05,  -1.582614410409613e-07,   1.333458009151055e-09,  -5.274927788305062e-12,  -2.022288716103244e-13,   8.221400205779497e-15,  -1.731279815725893e-16,
   1.394285514804792e-18,   1.919165089643021e-01,  -1.810464820421820e-03,   1.705099350836650e-05,  -1.582636561259695e-07,   1.333329285523562e-09,  -5.267622933197774e-12,
  -2.024335375884712e-13,   8.223499478523055e-15,  -1.730298600715816e-16,   1.388408244427348e-18,   1.919166285381935e-01,  -1.810468148467315e-03,   1.705104953988603e-05,
  -1.582640232084464e-07,   1.333307943566111e-09,  -5.266411989407631e-12,  -2.024674601448914e-13,   8.223847174675399e-15,  -1.730135856837789e-16,   1.387433908806831e-18,
   2.935135677741418e-01,  -2.768404034845602e-03,   2.606485577184447e-05,  -2.417097745600355e-07,   2.025028351155146e-09,  -7.343639367785273e-12,  -3.413479863837059e-13,
   1.371777976116878e-14,  -2.962100433042059e-16,   2.727453548198952e-18,   2.935172804631353e-01,  -2.768507261697147e-03,   2.606658061637450e-05,  -2.417198770368782e-07,
   2.024285827101061e-09,  -7.302436791913702e-12,  -3.425176776162538e-13,   1.373088217750541e-14,  -2.957036054120287e-16,   2.695076148619735e-18,   2.935233756199023e-01,
  -2.768676728321127e-03,   2.606941176525476e-05,  -2.417364194226189e-07,   2.023065054673469e-09,  -7.234768360025655e-12,  -3.444364334159400e-13,   1.375227167366610e-14,
  -2.948681685317715e-16,   2.641876626461396e-18,   2.935298432927639e-01,  -2.768856549633205e-03,   2.607241520376706e-05,  -2.417539144434514e-07,   2.021767277013754e-09,
  -7.162929371760035e-12,  -3.464703615462145e-13,   1.377480407150821e-14,  -2.939762246922103e-16,   2.585364715909842e-18,   2.935349335593698e-01,  -2.768998072932801e-03,
   2.607477846957944e-05,  -2.417676413073032e-07,   2.020744150820174e-09,  -7.106364633958891e-12,  -3.480696060878136e-13,   1.379241872783206e-14,  -2.932702967639097e-16,
   2.540844226894438e-18,   2.935378713215383e-01,  -2.769079749989921e-03,   2.607614217351599e-05,  -2.417755465855668e-07,   2.020152976171497e-09,  -7.073709201026484e-12,
  -3.489919714601167e-13,   1.380253698226677e-14,  -2.928613047843880e-16,   2.515132538727306e-18,   2.935389744936324e-01,  -2.769110420762426e-03,   2.607665422330163e-05,
  -2.417785119272552e-07,   2.019930850334678e-09,  -7.061444721178583e-12,  -3.493382171316868e-13,   1.380632750504991e-14,  -2.927074244257007e-16,   2.505474148348031e-18,
   2.935391573608933e-01,  -2.769115504893867e-03,   2.607673910105705e-05,  -2.417790033078996e-07,   2.019894022736079e-09,  -7.059411600577953e-12,  -3.493956064105100e-13,
   1.380695536452873e-14,  -2.926819007422632e-16,   2.503872953107217e-18,   4.229846123502731e-01,  -3.989525950029787e-03,   3.755598878754611e-05,  -3.477376924305570e-07,
   2.877931039586624e-09,  -8.486808765107299e-12,  -5.769432064525184e-13,   2.245967002711284e-14,  -4.906723902976491e-16,   4.884613309940448e-18,   4.229899617704970e-01,
  -3.989674447454474e-03,   3.755843897228012e-05,  -3.477491995846902e-07,   2.876676473162394e-09,  -8.419314041951381e-12,  -5.788828081945575e-13,   2.248331308837816e-14,
  -4.899301659009274e-16,   4.833258536173526e-18,   4.229987439606886e-01,  -3.989918233434448e-03,   3.756246056562296e-05,  -3.477680208629588e-07,   2.874613915088354e-09,
  -8.308460359490881e-12,  -5.820648024394809e-13,   2.252193616578925e-14,  -4.887049946265648e-16,   4.748861714182508e-18,   4.230080628845533e-01,  -3.990176913844227e-03,
   3.756672672394631e-05,  -3.477878971040156e-07,   2.872421327565862e-09,  -8.190768074474837e-12,  -5.854381764498242e-13,   2.256265869684263e-14,  -4.873959097236906e-16,
   4.659189066513628e-18,   4.230153971736985e-01,  -3.990380500038872e-03,   3.757008344250908e-05,  -3.478034713025484e-07,   2.870692815924314e-09,  -8.098094600756174e-12,
  -5.880908824564119e-13,   2.259451948891185e-14,  -4.863590830553708e-16,   4.588529129722076e-18,   4.230196300344193e-01,  -3.990497994953770e-03,   3.757202036133311e-05,
  -3.478124320086032e-07,   2.869694082551504e-09,  -8.044591333151411e-12,  -5.896209435796245e-13,   2.261283154774261e-14,  -4.857580787640988e-16,   4.547715180618222e-18,
   4.230212195344290e-01,  -3.990542115715766e-03,   3.757274763515843e-05,  -3.478157916501472e-07,   2.869318826113784e-09,  -8.024496627701884e-12,  -5.901953324768201e-13,
   2.261969364592213e-14,  -4.855318985898943e-16,   4.532382597814984e-18,   4.230214830177947e-01,  -3.990549429376944e-03,   3.757286818812057e-05,  -3.478163482848640e-07,
   2.869256610271222e-09,  -8.021165447809766e-12,  -5.902905369843471e-13,   2.262083038440049e-14,  -4.854943797714822e-16,   4.529840658344107e-18,   5.872637958002535e-01,
  -5.538892741649280e-03,   5.212857951131446e-05,  -4.815122478991749e-07,   3.907515899226606e-09,  -7.146394637123739e-12,  -9.920901686728153e-13,   3.736294329477112e-14,
  -8.329607258706690e-16,   9.239959036874220e-18,   5.872712207646552e-01,  -5.539098342225326e-03,   5.213190368063198e-05,  -4.815214683131200e-07,   3.905359029466986e-09,
  -7.034020025648319e-12,  -9.953880410500988e-13,   3.740809800585512e-14,  -8.319524053776293e-16,   9.158857649360999e-18,   5.872834103856954e-01,  -5.539435871478030e-03,
   5.213735949917960e-05,  -4.815364892331291e-07,   3.901813101812467e-09,  -6.849442799325109e-12,  -1.000799063444252e-12,   3.748192508494037e-14,  -8.302857566518219e-16,
   9.025533309069504e-18,   5.872963449782199e-01,  -5.539794019661726e-03,   5.214314671687148e-05,  -4.815522700432149e-07,   3.898043701139276e-09,  -6.653461826471721e-12,
  -1.006536523623525e-12,   3.755985093512001e-14,  -8.285019290224648e-16,   8.883817925099730e-18,   5.873065249053130e-01,  -5.540075886726413e-03,   5.214769996313140e-05,
  -4.815645755131028e-07,   3.895072171116099e-09,  -6.499129733654421e-12,  -1.011048986559674e-12,   3.762088156904539e-14,  -8.270869167467946e-16,   8.772108550423371e-18,
   5.873124000744900e-01,  -5.540238558743161e-03,   5.215032719922542e-05,  -4.815716314853661e-07,   3.893355242700368e-09,  -6.410024063050324e-12,  -1.013652030683090e-12,
   3.765598422616220e-14,  -8.262658265480783e-16,   8.707567582630922e-18,   5.873146062842990e-01,  -5.540299643895605e-03,   5.215131365201853e-05,  -4.815742724232863e-07,
   3.892710141002517e-09,  -6.376556901577110e-12,  -1.014629274829534e-12,   3.766914305992063e-14,  -8.259566565533240e-16,   8.683318365837451e-18,   5.873149719964920e-01,
  -5.540309769644126e-03,   5.215147716538652e-05,  -4.815747097401911e-07,   3.892603186222746e-09,  -6.371008866440275e-12,  -1.014791255161905e-12,   3.767132313439332e-14,
  -8.259053627657528e-16,   8.679298002817436e-18,   7.998370014493624e-01,  -7.543611619947755e-03,   7.096618653078769e-05,  -6.527642597870996e-07,   5.108906023157030e-09,
   1.703669375595979e-12,  -1.834983999254735e-12,   6.710407904466489e-14,  -1.555349817877371e-15,   2.025487586593809e-17,   7.998471091853654e-01,  -7.543890284455441e-03,
   7.097052609499598e-05,  -6.527601272843114e-07,   5.104915730486864e-09,   1.905801728258445e-12,  -1.841158887521599e-12,   6.720432858370688e-14,  -1.554282051196409e-15,
   2.012428114320935e-17,   7.998637031130642e-01,  -7.544347755681639e-03,   7.097764770627834e-05,  -6.527531345428730e-07,   5.098355504335417e-09,   2.237848947860671e-12,
  -1.851292771875384e-12,   6.736841757261660e-14,  -1.552508379256177e-15,   1.990945345022734e-17,   7.998813111551477e-01,  -7.544833165716670e-03,   7.098520090480844e-05,
  -6.527454311197599e-07,   5.091381668478895e-09,   2.590467316022369e-12,  -1.862041232567772e-12,   6.754186611719388e-14,  -1.550598167450859e-15,   1.968091471535135e-17,
   7.998951692127688e-01,  -7.545215184277318e-03,   7.099114286094699e-05,  -6.527391630681944e-07,   5.085883864320474e-09,   2.868189775242256e-12,  -1.870497135059385e-12,
   6.767789063625765e-14,  -1.549074401571072e-15,   1.950062771943625e-17,   7.999031671435336e-01,  -7.545435653973189e-03,   7.099457109679262e-05,  -6.527354632806856e-07,
   5.082707223327814e-09,   3.028552845617894e-12,  -1.875375913518531e-12,   6.775620025284529e-14,  -1.548186823084214e-15,   1.939641032090055e-17,   7.999061704790872e-01,
  -7.545518442405637e-03,   7.099585824750209e-05,  -6.527340584007530e-07,   5.081513654210344e-09,   3.088786633770114e-12,  -1.877207698847032e-12,   6.778556982572901e-14,
  -1.547851981981614e-15,   1.935724352505685e-17,   7.999066683266861e-01,  -7.545532165766410e-03,   7.099607160134456e-05,  -6.527338247001631e-07,   5.081315765652456e-09,
   3.098772082609804e-12,  -1.877511330562040e-12,   6.779043632837870e-14,  -1.547796395693098e-15,   1.935074937448754e-17,   1.095371453744828e+00,  -1.033031160114666e-02,
   9.709191585321970e-05,  -8.844395283195773e-07,   6.307402622409367e-09,   4.089919016129884e-11,  -4.232977078994175e-12,   1.538431538158982e-13,  -3.920800461184441e-15,
   6.759875155148779e-17,   1.095385281361642e+00,  -1.033068896756780e-02,   9.709724904861234e-05,  -8.843773931384841e-07,   6.298180710092527e-09,   4.136438663750149e-11,
  -4.248643252827711e-12,   1.541844200359884e-13,  -3.922930859100864e-15,   6.741217453013370e-17,   1.095407982173302e+00,  -1.033130845554212e-02,   9.710599860171212e-05,
  -8.842749074269352e-07,   6.283017254751012e-09,   4.212881578452195e-11,  -4.274367693196130e-12,   1.547439619596557e-13,  -3.926383737587991e-15,   6.710442770545206e-17,
   1.095432070223711e+00,  -1.033196575279285e-02,   9.711527473048872e-05,  -8.841655083630014e-07,   6.266894770305890e-09,   4.294093071053969e-11,  -4.301671234313062e-12,
   1.553367224223274e-13,  -3.929986947591677e-15,   6.677591393617221e-17,   1.095451028177694e+00,  -1.033248302930324e-02,   9.712256942183993e-05,  -8.840789370280018e-07,
   6.254182475862610e-09,   4.358079027270018e-11,  -4.323164944681839e-12,   1.558025329818558e-13,  -3.932778796467246e-15,   6.651594564385236e-17,   1.095461969396710e+00,
  -1.033278155170238e-02,   9.712677705562173e-05,  -8.840287850295965e-07,   6.246836414895195e-09,   4.395035447176444e-11,  -4.335571643789260e-12,   1.560710819960782e-13,
  -3.934372415285003e-15,   6.636534133580078e-17,   1.095466077973510e+00,  -1.033289364831901e-02,   9.712835663364961e-05,  -8.840099165330158e-07,   6.244076091273373e-09,
   4.408918405112111e-11,  -4.340230907387975e-12,   1.561718719270870e-13,  -3.934967504296773e-15,   6.630867991837989e-17,   1.095466759031048e+00,  -1.033291222985788e-02,
   9.712861844861115e-05,  -8.840067869142465e-07,   6.243618432913869e-09,   4.411219991807531e-11,  -4.341003269373459e-12,   1.561885765082143e-13,  -3.935065973062906e-15,
   6.629928178033883e-17,   2.188983879872841e-03,  -1.989752131010090e-05,   1.807532470414580e-07,  -1.633407072923924e-09,   1.423243468646414e-11,  -9.910805303586289e-14,
  -2.586721860523530e-16,   3.671564146135117e-17,  -1.081568954905109e-18,   1.932792117651340e-20,   2.189009626818674e-03,  -1.989821914234149e-05,   1.807653958762782e-07,
  -1.633547169994149e-09,   1.423183115167665e-11,  -9.899677191308705e-14,  -2.629951534685720e-16,   3.681331461484851e-17,  -1.082222871392291e-18,   1.927815402820913e-20,
   2.189051895847499e-03,  -1.989936478994619e-05,   1.807853397666031e-07,  -1.633777046906569e-09,   1.423083367489565e-11,  -9.881387584312449e-14,  -2.700938212228440e-16,
   3.697347402184610e-17,  -1.083284822887219e-18,   1.919610808195548e-20,   2.189096748253445e-03,  -1.990058046908554e-05,   1.808065012458692e-07,  -1.634020807526606e-09,
   1.422976619914480e-11,  -9.861952365978376e-14,  -2.776285076655451e-16,   3.714316084239871e-17,  -1.084395916504905e-18,   1.910858238127971e-20,   2.189132048563109e-03,
  -1.990153725728765e-05,   1.808231550559066e-07,  -1.634212534975563e-09,   1.422891951781127e-11,  -9.846636106799459e-14,  -2.835601059203447e-16,   3.727652031042116e-17,
  -1.085258963944238e-18,   1.903936025071533e-20,   2.189152421555337e-03,  -1.990208945543209e-05,   1.808327661402859e-07,  -1.634323139132548e-09,   1.422842824656369e-11,
  -9.837788526295030e-14,  -2.869840481908856e-16,   3.735341034862261e-17,  -1.085752477540976e-18,   1.899927505328118e-20,   2.189160071909734e-03,  -1.990229681453204e-05,
   1.808363751686667e-07,  -1.634364663489164e-09,   1.422824327125673e-11,  -9.834464609820042e-14,  -2.882699044792246e-16,   3.738226925404499e-17,  -1.085936933097810e-18,
   1.898419701797776e-20,   2.189161340070399e-03,  -1.990233118744005e-05,   1.808369734152283e-07,  -1.634371546291646e-09,   1.422821258267546e-11,  -9.833913540700049e-14,
  -2.884830605099851e-16,   3.738705228799685e-17,  -1.085967463674588e-18,   1.898169626524184e-20,   1.977864050442658e-02,  -1.797846904858910e-04,   1.633193117301331e-06,
  -1.475781717462184e-08,   1.285350334477067e-10,  -8.921056855131837e-13,  -2.482298612524343e-15,   3.367053605655730e-16,  -9.906227074064021e-18,   1.773084148792316e-19,
   1.977887314044028e-02,  -1.797909953762229e-04,   1.633302833255056e-06,  -1.475907807720186e-08,   1.285292641699079e-10,  -8.910851612729126e-13,  -2.521895390782238e-15,
   3.376014990677668e-16,  -9.912320780918033e-18,   1.768561465897137e-19,   1.977925506139822e-02,  -1.798013462614601e-04,   1.633482946044865e-06,  -1.476114699728600e-08,
   1.285197318089662e-10,  -8.894078778804598e-13,  -2.586916856079844e-15,   3.390709569192275e-16,  -9.922219003906577e-18,   1.761105112551133e-19,   1.977966032440003e-02,
  -1.798123298770288e-04,   1.633674054580345e-06,  -1.476334084571364e-08,   1.285095341045224e-10,  -8.876255326943695e-13,  -2.655932519310174e-15,   3.406278504032128e-16,
  -9.932578191206251e-18,   1.753150386599696e-19,   1.977997927962430e-02,  -1.798209744211474e-04,   1.633824454325870e-06,  -1.476506637562735e-08,   1.285014482560922e-10,
  -8.862209238498952e-13,  -2.710264631070142e-15,   3.418514526877608e-16,  -9.940626886214974e-18,   1.746858903079542e-19,   1.978016335937557e-02,  -1.798259635092558e-04,
   1.633911251481068e-06,  -1.476606179538701e-08,   1.284967576195167e-10,  -8.854095380101439e-13,  -2.741627294710452e-15,   3.425569419793237e-16,  -9.945230216584533e-18,
   1.743215519788399e-19,   1.978023248399456e-02,  -1.798278369903001e-04,   1.633943844395779e-06,  -1.476643550649854e-08,   1.284949916765810e-10,  -8.851047112366554e-13,
  -2.753405517654104e-15,   3.428217323471455e-16,  -9.946950922795419e-18,   1.741845042096324e-19,   1.978024394243401e-02,  -1.798281475481215e-04,   1.633949247123124e-06,
  -1.476649745030101e-08,   1.284946987055721e-10,  -8.850541742763673e-13,  -2.755357991506405e-15,   3.428656183898925e-16,  -9.947235738169619e-18,   1.741617741804329e-19,
   5.538437815514181e-02,  -5.034348219109148e-04,   4.573232799427644e-06,  -4.131982116808752e-08,   3.595595877455366e-10,  -2.478273842484430e-12,  -7.800263116632099e-15,
   9.719411343751561e-16,  -2.852575393082377e-17,   5.122790191159379e-19,   5.538502957694144e-02,  -5.034524746199858e-04,   4.573539704556712e-06,  -4.132332302369929e-08,
   3.595415821000121e-10,  -2.475327925439446e-12,  -7.914298176782814e-15,   9.745309444945927e-16,  -2.854392837012688e-17,   5.109979772836129e-19,   5.538609902283573e-02,
  -5.034814554744636e-04,   4.574043527467802e-06,  -4.132906883932884e-08,   3.595118467832060e-10,  -2.470486154427276e-12,  -8.101555794961852e-15,   9.787777246328293e-16,
  -2.857346229643322e-17,   5.088858128685106e-19,   5.538723383051373e-02,  -5.035122078623895e-04,   4.574578106790674e-06,  -4.133516144940387e-08,   3.594800558881710e-10,
  -2.465341094875054e-12,  -8.300318907332193e-15,   9.832773277274808e-16,  -2.860438886215089e-17,   5.066322498457420e-19,   5.538812696120178e-02,  -5.035364112110402e-04,
   4.574998812094887e-06,  -4.133995336243233e-08,   3.594548629028792e-10,  -2.461286432282593e-12,  -8.456795600770617e-15,   9.868137756719689e-16,  -2.862843028081227e-17,
   5.048497194216625e-19,   5.538864241684581e-02,  -5.035503798606997e-04,   4.575241604754685e-06,  -4.134271766453522e-08,   3.594402540268017e-10,  -2.458944214580141e-12,
  -8.547120909885889e-15,   9.888528147689949e-16,  -2.864218554742392e-17,   5.038173957037432e-19,   5.538883597792072e-02,  -5.035556253076502e-04,   4.575332774941857e-06,
  -4.134375545968257e-08,   3.594347551088594e-10,  -2.458064274289251e-12,  -8.581042641940803e-15,   9.896181318594097e-16,  -2.864732819026924e-17,   5.034290695712035e-19,
   5.538886806356371e-02,  -5.035564948197896e-04,   4.575347887659383e-06,  -4.134392747706423e-08,   3.594338428912908e-10,  -2.457918389741423e-12,  -8.586665848368625e-15,
   9.897449749913808e-16,  -2.864817946465250e-17,   5.033646631807171e-19,   1.099186879477626e-01,  -9.991415483071964e-04,   9.076102690426211e-06,  -8.198886883646353e-08,
   7.124302463940752e-10,  -4.854980451576171e-12,  -1.821143262292561e-14,   2.022820578373896e-15,  -5.916185117086112e-17,   1.068243780656032e-18,   1.099199807666525e-01,
  -9.991765753775892e-04,   9.076710757182778e-06,  -8.199572598495771e-08,   7.123885610013257e-10,  -4.848849149351983e-12,  -1.844798275995312e-14,   2.028223346820391e-15,
  -5.920164376229994e-17,   1.065657935665600e-18,   1.099221032006617e-01,  -9.992340800879500e-04,   9.077708970583419e-06,  -8.200697676197324e-08,   7.123197622899732e-10,
  -4.838772000058267e-12,  -1.883642913805973e-14,   2.037083147496441e-15,  -5.926634824075857e-17,   1.061393867567064e-18,   1.099243553522308e-01,  -9.992950998907956e-04,
   9.078768115893121e-06,  -8.201890608009585e-08,   7.122462648468957e-10,  -4.828063578835529e-12,  -1.924875070304897e-14,   2.046470834496012e-15,  -5.933415940916309e-17,
   1.056843580943164e-18,   1.099261278689275e-01,  -9.993431248667411e-04,   9.079601642468971e-06,  -8.202828826565738e-08,   7.121880622809788e-10,  -4.819624573982875e-12,
  -1.957335772507234e-14,   2.053849372573417e-15,  -5.938691466729069e-17,   1.053243832417630e-18,   1.099271508476569e-01,  -9.993708418491308e-04,   9.080082676361284e-06,
  -8.203370040121027e-08,   7.121543282359640e-10,  -4.814749684141481e-12,  -1.976073773513577e-14,   2.058103804685511e-15,  -5.941711508600117e-17,   1.051158877309169e-18,
   1.099275349910075e-01,  -9.993812500084173e-04,   9.080263307365065e-06,  -8.203573223784002e-08,   7.121416335073346e-10,  -4.812918250144212e-12,  -1.983110887987095e-14,
   2.059700654256649e-15,  -5.942840919026508e-17,   1.050374544725934e-18,   1.099275986685125e-01,  -9.993829753180694e-04,   9.080293249433530e-06,  -8.203606901882947e-08,
   7.121395277362374e-10,  -4.812614618152958e-12,  -1.984277433030727e-14,   2.059965316285233e-15,  -5.943027889863662e-17,   1.050244455942413e-18,   1.849210539247041e-01,
  -1.680897104896048e-03,   1.526870399709366e-05,  -1.378922149433477e-07,   1.195630780226305e-09,  -8.008595926741813e-12,  -3.750577430764426e-14,   3.640343356846240e-15,
  -1.060184569554280e-16,   1.930003817710534e-18,   1.849232288254339e-01,  -1.680956014037257e-03,   1.526972439467297e-05,  -1.379035184541134e-07,   1.195545680986463e-09,
  -7.997561087675179e-12,  -3.792979024350757e-14,   3.650110660620211e-15,  -1.060953613143533e-16,   1.925558377213250e-18,   1.849267993819560e-01,  -1.681052726395435e-03,
   1.527139948836976e-05,  -1.379220635819991e-07,   1.195405321782983e-09,  -7.979424594473766e-12,  -3.862609621901378e-14,   3.666128552123389e-15,  -1.062205133449221e-16,
   1.918226298007202e-18,   1.849305881610849e-01,  -1.681155350395282e-03,   1.527317681854341e-05,  -1.379417258710584e-07,   1.195255499399364e-09,  -7.960151826763086e-12,
  -3.936522140227205e-14,   3.683101981933483e-15,  -1.063518146343866e-16,   1.910399991815439e-18,   1.849335700534873e-01,  -1.681236119433433e-03,   1.527457553319325e-05,
  -1.379571889460838e-07,   1.195136943566181e-09,  -7.944963404418713e-12,  -3.994712593153670e-14,   3.696443604562051e-15,  -1.064540663359182e-16,   1.904207078257530e-18,
   1.849352910033168e-01,  -1.681282734191550e-03,   1.527538273725140e-05,  -1.379661084765188e-07,   1.195068264150652e-09,  -7.936189595371598e-12,  -4.028303779148275e-14,
   3.704136661555022e-15,  -1.065126433331397e-16,   1.900619579688403e-18,   1.849359372449186e-01,  -1.681300238755038e-03,   1.527568584632815e-05,  -1.379694569956115e-07,
   1.195042425477607e-09,  -7.932893379666846e-12,  -4.040919174065552e-14,   3.707024221087383e-15,  -1.065345574253917e-16,   1.899269897772936e-18,   1.849360443691272e-01,
  -1.681303140400617e-03,   1.527573609078118e-05,  -1.379700120155579e-07,   1.195038139769479e-09,  -7.932346902283829e-12,  -4.043010439069451e-14,   3.707502808896082e-15,
  -1.065381856650731e-16,   1.899046034679171e-18,   2.828393793382490e-01,  -2.570949929793697e-03,   2.335276580696440e-05,  -2.108167954128052e-07,   1.822243794377700e-09,
  -1.189406447326844e-11,  -7.278226056791700e-14,   6.104509529523849e-15,  -1.769817798194189e-16,   3.260885971682580e-18,   2.828427057353845e-01,  -2.571039991344182e-03,
   2.335432078688591e-05,  -2.108335650480441e-07,   1.822080016943706e-09,  -1.187555785878908e-11,  -7.349037457035539e-14,   6.121026814785495e-15,  -1.771237885572636e-16,
   3.253922021371937e-18,   2.828481667145865e-01,  -2.571187847097321e-03,   2.335687343441032e-05,  -2.108610759740655e-07,   1.821810055718454e-09,  -1.184514070153149e-11,
  -7.465325699799777e-14,   6.148116392634545e-15,  -1.773551205229204e-16,   3.242432184565796e-18,   2.828539614530018e-01,  -2.571344740465194e-03,   2.335958184945736e-05,
  -2.108902411542210e-07,   1.821522118735420e-09,  -1.181281745647223e-11,  -7.588770413852997e-14,   6.176824777971031e-15,  -1.775981354006227e-16,   3.230162639376424e-18,
   2.828585220999997e-01,  -2.571468221426033e-03,   2.336171328376204e-05,  -2.109131754358456e-07,   1.821294433739078e-09,  -1.178734395388029e-11,  -7.685960854166781e-14,
   6.199392452267147e-15,  -1.777876166201050e-16,   3.220450052422553e-18,   2.828611542016618e-01,  -2.571539486728956e-03,   2.336294333496747e-05,  -2.109264036896603e-07,
   1.821162600443693e-09,  -1.177262870032209e-11,  -7.742066837615788e-14,   6.212406255898308e-15,  -1.778962587873074e-16,   3.214822137918342e-18,   2.828621425939356e-01,
  -2.571566247941662e-03,   2.336340522362594e-05,  -2.109313695993512e-07,   1.821113014099452e-09,  -1.176710033165788e-11,  -7.763138109375390e-14,   6.217291091244184e-15,
  -1.779369205228737e-16,   3.212704531795030e-18,   2.828623064347317e-01,  -2.571570684015914e-03,   2.336348178787065e-05,  -2.109321926944483e-07,   1.821104790146484e-09,
  -1.176618378592782e-11,  -7.766631127952539e-14,   6.218100718223016e-15,  -1.779436536916677e-16,   3.212353283138447e-18,   4.076020594161688e-01,  -3.705003499787987e-03,
   3.365189188315648e-05,  -3.036168462151554e-07,   2.612257190442995e-09,  -1.638058765419196e-11,  -1.381533054264843e-13,   9.967551276381479e-15,  -2.878751825029694e-16,
   5.400561906349134e-18,   4.076068528094325e-01,  -3.705133201911853e-03,   3.365412058814251e-05,  -3.036399014077593e-07,   2.611948589064581e-09,  -1.635036293881645e-11,
  -1.393057963368054e-13,   9.994941834388124e-15,  -2.881391542642117e-16,   5.390339506131179e-18,   4.076147221694369e-01,  -3.705346135999889e-03,   3.365777917337031e-05,
  -3.036777189685782e-07,   2.611440188950574e-09,  -1.630068519387771e-11,  -1.411985406902655e-13,   1.003986930699096e-14,  -2.885696702765440e-16,   5.373463701720912e-18,
   4.076230724801282e-01,  -3.705572085116114e-03,   3.366166094985499e-05,  -3.037178037928863e-07,   2.610898315968682e-09,  -1.624789314993286e-11,  -1.432078954095009e-13,
   1.008748822865061e-14,  -2.890226224189186e-16,   5.355429370375791e-18,   4.076296444440697e-01,  -3.705749915198496e-03,   3.366471573585738e-05,  -3.037493199408260e-07,
   2.610470105602744e-09,  -1.620628756325693e-11,  -1.447899934579577e-13,   1.012492633691829e-14,  -2.893763014332320e-16,   5.341143778063606e-18,   4.076334373433804e-01,
  -3.705852547197187e-03,   3.366647863527869e-05,  -3.037674961635267e-07,   2.610222273984388e-09,  -1.618225294008106e-11,  -1.457033427608048e-13,   1.014651722608667e-14,
  -2.895792944820782e-16,   5.332862230215644e-18,   4.076348616318758e-01,  -3.705891087058693e-03,   3.366714060690950e-05,  -3.037743191782172e-07,   2.610129077845793e-09,
  -1.617322331164217e-11,  -1.460463691016167e-13,   1.015462190771585e-14,  -2.896553082005532e-16,   5.329745425233140e-18,   4.076350977289824e-01,  -3.705897475620104e-03,
   3.366725033741026e-05,  -3.037754500672174e-07,   2.610113622240220e-09,  -1.617172629000553e-11,  -1.461032335043710e-13,   1.015596522094261e-14,  -2.896678973656598e-16,
   5.329228400887665e-18,   5.659071646603062e-01,  -5.143931556347664e-03,   4.671749738387587e-05,  -4.211234180507148e-07,   3.597048822065842e-09,  -2.108551499047371e-11,
  -2.652537113834367e-13,   1.646455691895382e-14,  -4.750041685919955e-16,   9.167136041073325e-18,   5.659138190729278e-01,  -5.144111447648518e-03,   4.672056535510825e-05,
  -4.211530019027066e-07,   3.596459982884747e-09,  -2.103556775007476e-11,  -2.671571518758798e-13,   1.651114178103535e-14,  -4.755257585794244e-16,   9.153170497105067e-18,
   5.659247436835575e-01,  -5.144406777371067e-03,   4.672560155595668e-05,  -4.212015169011000e-07,   3.595490365624142e-09,  -2.095347089533899e-11,  -2.702834342843923e-13,
   1.658756547881308e-14,  -4.763775957342088e-16,   9.130087232142510e-18,   5.659363359683987e-01,  -5.144720157308614e-03,   4.673094484983866e-05,  -4.212529247665073e-07,
   3.594457526487153e-09,  -2.086622343070534e-11,  -2.736026615930529e-13,   1.666858472499417e-14,  -4.772754230737096e-16,   9.105381375012770e-18,   5.659454594678126e-01,
  -5.144966797848097e-03,   4.673514968418029e-05,  -4.212933320848755e-07,   3.593641779368496e-09,  -2.079746054146370e-11,  -2.762163534857634e-13,   1.673229476996610e-14,
  -4.779776408271508e-16,   9.085783758206931e-18,   5.659507249421203e-01,  -5.145109142484401e-03,   4.673757622932417e-05,  -4.213166315037818e-07,   3.593169834057646e-09,
  -2.075773659568031e-11,  -2.777253426123832e-13,   1.676904194482878e-14,  -4.783811480322263e-16,   9.074411883324667e-18,   5.659527022035929e-01,  -5.145162594983037e-03,
   4.673848739334393e-05,  -4.213253768031587e-07,   3.592992394289536e-09,  -2.074281238794070e-11,  -2.782920917680529e-13,   1.678283686932088e-14,  -4.785323368048779e-16,
   9.070129969734573e-18,   5.659530299642245e-01,  -5.145171455535250e-03,   4.673863843035449e-05,  -4.213268262578171e-07,   3.592962969521755e-09,  -2.074033809280093e-11,
  -2.783860442837964e-13,   1.678512336398810e-14,  -4.785573809779054e-16,   9.069419566114543e-18,   7.707503529351781e-01,  -7.005835354977366e-03,   6.361836493588224e-05,
  -5.725955676030981e-07,   4.828618272263958e-09,  -2.472819813165755e-11,  -5.417767599850097e-13,   2.904994417121788e-14,  -8.440416752646126e-16,   1.711132247065552e-17,
   7.707594145730762e-01,  -7.006079930182790e-03,   6.362248102214617e-05,  -5.726300116320990e-07,   4.827421509613001e-09,  -2.463999037670393e-11,  -5.451647268820507e-13,
   2.913718825855175e-14,  -8.452431382190311e-16,   1.709600669129313e-17,   7.707742911409520e-01,  -7.006481450429943e-03,   6.362923749269315e-05,  -5.726864657733128e-07,
   4.825451589677537e-09,  -2.449499489711760e-11,  -5.507300429306327e-13,   2.928035474074629e-14,  -8.472085175907185e-16,   1.707058550396264e-17,   7.707900769037870e-01,
  -7.006907508654096e-03,   6.363640560742868e-05,  -5.727462437803200e-07,   4.823354227383406e-09,  -2.434088781230589e-11,  -5.566399104426409e-13,   2.943218495466968e-14,
  -8.492843855812403e-16,   1.704323396295804e-17,   7.708025007980525e-01,  -7.007242828991372e-03,   6.364204620952787e-05,  -5.727931993781422e-07,   4.821698431280819e-09,
  -2.421941966713102e-11,  -5.612943558257327e-13,   2.955161741052839e-14,  -8.509111770370348e-16,   1.702143464357885e-17,   7.708096710371046e-01,  -7.007436353030159e-03,
   6.364530121346120e-05,  -5.728202622647432e-07,   4.820740769461386e-09,  -2.414924386274397e-11,  -5.639818666673349e-13,   2.962052053194543e-14,  -8.518472493208190e-16,
   1.700874417642062e-17,   7.708123635646814e-01,  -7.007509024008439e-03,   6.364652344345646e-05,  -5.728304178198806e-07,   4.820380766677736e-09,  -2.412287813508498e-11,
  -5.649913065285289e-13,   2.964638984520793e-14,  -8.521982276850752e-16,   1.700395805222625e-17,   7.708128098913298e-01,  -7.007521070304281e-03,   6.364672604259889e-05,
  -5.728321008882273e-07,   4.820321070421132e-09,  -2.411850689901720e-11,  -5.651586489631842e-13,   2.965067781666538e-14,  -8.522563796078547e-16,   1.700316359011508e-17,
   1.055538927165302e+00,  -9.594281121846964e-03,   8.709671345730782e-05,  -7.812600391745873e-07,   6.394156162150137e-09,  -2.107074164498388e-11,  -1.344924079837162e-12,
   6.310462195780175e-14,  -1.900983966319805e-15,   4.291384257775345e-17,   1.055551332612434e+00,  -9.594614758842938e-03,   8.710215624157005e-05,  -7.812883991832548e-07,
   6.391194134070832e-09,  -2.087863287159738e-11,  -1.352585975092542e-12,   6.332504172264200e-14,  -1.905196305199553e-15,   4.293557101113655e-17,   1.055571698719335e+00,
  -9.595162486352938e-03,   8.711108959600161e-05,  -7.813347576610790e-07,   6.386319617827907e-09,  -2.056277875083384e-11,  -1.365176293194239e-12,   6.368697276716712e-14,
  -1.912101987391702e-15,   4.297069382933422e-17,   1.055593309490788e+00,  -9.595743678937989e-03,   8.712056604793341e-05,  -7.813836767710482e-07,   6.381131239774856e-09,
  -2.022698545224616e-11,  -1.378551992322139e-12,   6.407111219650232e-14,  -1.919416422124668e-15,   4.300721621456896e-17,   1.055610317830214e+00,  -9.596201088758173e-03,
   8.712802223220352e-05,  -7.814219800758547e-07,   6.377036265444376e-09,  -1.996224536512942e-11,  -1.389090598841862e-12,   6.437350536505346e-14,  -1.925163454142338e-15,
   4.303541890184671e-17,   1.055620133895419e+00,  -9.596465072188660e-03,   8.713232460606435e-05,  -7.814440069087564e-07,   6.374668285691116e-09,  -1.980927066434574e-11,
  -1.395177385270464e-12,   6.454805151600590e-14,  -1.928476372821895e-15,   4.305147826695603e-17,   1.055623819967080e+00,  -9.596564201210529e-03,   8.713394005101726e-05,
  -7.814522633100324e-07,   6.373778198974748e-09,  -1.975179160267776e-11,  -1.397463931528973e-12,   6.461360080465111e-14,  -1.929719686043496e-15,   4.305746768142964e-17,
   1.055624430988412e+00,  -9.596580633297429e-03,   8.713420782679411e-05,  -7.814536311408220e-07,   6.373630607572146e-09,  -1.974226175048605e-11,  -1.397843006632260e-12,
   6.462446682539985e-14,  -1.929925744954497e-15,   4.305845834701147e-17,   2.112166973337273e-03,  -1.852617900976273e-05,   1.624529748004882e-07,  -1.421595702769895e-09,
   1.225383188742054e-11,  -9.628901474212697e-14,   3.809793977878831e-16,   1.201056310794227e-17,  -5.059962497751761e-19,   1.218783147199081e-20,   2.112190112638596e-03,
  -1.852678640323457e-05,   1.624634421201810e-07,  -1.421732416701057e-09,   1.225462084586707e-11,  -9.625212100482895e-14,   3.789381123996719e-16,   1.207316500530236e-17,
  -5.072078657930966e-19,   1.219403842264782e-20,   2.112228100625126e-03,  -1.852778358006286e-05,   1.624806263991820e-07,  -1.421956816386622e-09,   1.225591288612064e-11,
  -9.619141863852813e-14,   3.755835379385953e-16,   1.217595801442689e-17,  -5.091942443904064e-19,   1.220407943572177e-20,   2.112268410280851e-03,  -1.852884171902156e-05,
   1.624988608982727e-07,  -1.422194869588467e-09,   1.225727953934044e-11,  -9.612682479151280e-14,   3.720193577852706e-16,   1.228505875259649e-17,  -5.112982853048646e-19,
   1.221453143707475e-20,   2.112300135253214e-03,  -1.852967452140633e-05,   1.625132120153406e-07,  -1.422382180849274e-09,   1.225835198600160e-11,  -9.607585589345504e-14,
   3.692109171228620e-16,   1.237094266277762e-17,  -5.129515178372460e-19,   1.222261060326120e-20,   2.112318444780638e-03,  -1.853015516456682e-05,   1.625214945139378e-07,
  -1.422490266644711e-09,   1.225896966589171e-11,  -9.604638734566074e-14,   3.675887444490160e-16,   1.242051630850596e-17,  -5.139045620930875e-19,   1.222721442855579e-20,
   2.112325320270681e-03,  -1.853033565399408e-05,   1.625246047100809e-07,  -1.422530851061145e-09,   1.225920137446983e-11,  -9.603531151899423e-14,   3.669793443004181e-16,
   1.243913327653900e-17,  -5.142622373823876e-19,   1.222893208736224e-20,   2.112326459985813e-03,  -1.853036557286583e-05,   1.625251202714854e-07,  -1.422537578357383e-09,
   1.225923977101188e-11,  -9.603347500966835e-14,   3.668783138861144e-16,   1.244221938812421e-17,  -5.143215165005553e-19,   1.222921622694490e-20,   1.908455879801984e-02,
  -1.673939227253047e-04,   1.467846764013769e-06,  -1.284459758291348e-08,   1.106993533382229e-10,  -8.688521788631164e-13,   3.389016216845611e-15,   1.105008627613443e-16,
  -4.631882566558077e-18,   1.115787490065534e-19,   1.908476787355516e-02,  -1.673994107246022e-04,   1.467941323617737e-06,  -1.284583114953888e-08,   1.107063652636986e-10,
  -8.685127899326614e-13,   3.370329783012333e-15,   1.110740146058777e-16,  -4.642999339972662e-18,   1.116369041465376e-19,   1.908511111462639e-02,  -1.674084205438759e-04,
   1.468096562772505e-06,  -1.284785589595094e-08,   1.107178475215436e-10,  -8.679543890788615e-13,   3.339621100536131e-15,   1.120151412294460e-16,  -4.661224925803379e-18,
   1.117310176201477e-19,   1.908547533317479e-02,  -1.674179811752407e-04,   1.468261289296063e-06,  -1.285000382814311e-08,   1.107299917084790e-10,  -8.673601984703467e-13,
   3.306993530021404e-15,   1.130140253128401e-16,  -4.680530423673106e-18,   1.118290324204907e-19,   1.908576198467545e-02,  -1.674255058164784e-04,   1.468390934114619e-06,
  -1.285169391380937e-08,   1.107395207168540e-10,  -8.668913477847235e-13,   3.281284151591179e-15,   1.138003499898153e-16,  -4.695699794280960e-18,   1.119048320099175e-19,
   1.908592742070570e-02,  -1.674298485840260e-04,   1.468465756347122e-06,  -1.285266915551662e-08,   1.107450086504892e-10,  -8.666202759672239e-13,   3.266434226458536e-15,
   1.142542318498888e-16,  -4.704444625284459e-18,   1.119480404125920e-19,   1.908598954430669e-02,  -1.674314793647644e-04,   1.468493853155287e-06,  -1.285303534203406e-08,
   1.107470672603826e-10,  -8.665183933862763e-13,   3.260855562895756e-15,   1.144246837560699e-16,  -4.707726558032612e-18,   1.119641640403824e-19,   1.908599984222111e-02,
  -1.674317496915095e-04,   1.468498510620066e-06,  -1.285309604129541e-08,   1.107474083902708e-10,  -8.665015000145236e-13,   3.259930694612020e-15,   1.144529393756044e-16,
  -4.708270488311520e-18,   1.119668314035684e-19,   5.344080335494851e-02,  -4.687383046569042e-04,   4.110265326502841e-06,  -3.596595843967129e-08,   3.098616278528866e-10,
  -2.426136123469882e-12,   9.178204957055682e-15,   3.210105695831758e-16,  -1.332178416578515e-17,   3.210024527968696e-19,   5.344138880816722e-02,  -4.687536714836844e-04,
   4.110530007079033e-06,  -3.596940266329206e-08,   3.098805803320037e-10,  -2.425150435458905e-12,   9.124457530255552e-15,   3.226596930659735e-16,  -1.335391355843238e-17,
   3.211777456086159e-19,   5.344234995164701e-02,  -4.687788996784255e-04,   4.110964534586835e-06,  -3.597505588910881e-08,   3.099116106160509e-10,  -2.423528703969907e-12,
   9.036130292036335e-15,   3.253676159855437e-16,  -1.340659008350650e-17,   3.214616339634094e-19,   5.344336983623253e-02,  -4.688056701856266e-04,   4.111425617467368e-06,
  -3.598105300401377e-08,   3.099444228862082e-10,  -2.421803075521437e-12,   8.942283151058677e-15,   3.282417659793183e-16,  -1.346238978444155e-17,   3.217575787096215e-19,
   5.344417251760087e-02,  -4.688267397599442e-04,   4.111788503398216e-06,  -3.598577175363875e-08,   3.099701642509938e-10,  -2.420441487662476e-12,   8.868334458039619e-15,
   3.305043350947601e-16,  -1.350623603947596e-17,   3.219866598686003e-19,   5.344463577147373e-02,  -4.688388998419227e-04,   4.111997936479628e-06,  -3.598849463041168e-08,
   3.099849871804005e-10,  -2.419654281837504e-12,   8.825620972974898e-15,   3.318103456189365e-16,  -1.353151307706986e-17,   3.221173309341299e-19,   5.344480972994318e-02,
  -4.688434661527460e-04,   4.112076581536737e-06,  -3.598951702093298e-08,   3.099905471140056e-10,  -2.419358412291783e-12,   8.809574786691563e-15,   3.323008102306327e-16,
  -1.354099965061709e-17,   3.221661087115827e-19,   5.344483856615678e-02,  -4.688442230883000e-04,   4.112089618125611e-06,  -3.598968649274399e-08,   3.099914684241933e-10,
  -2.419309353650012e-12,   8.806914540459254e-15,   3.323821141111619e-16,  -1.354257191114608e-17,   3.221741789969829e-19,   1.060613719927698e-01,  -9.302818638313794e-04,
   8.157392655684466e-06,  -7.137468881386878e-08,   6.145842522917032e-10,  -4.793175346442593e-12,   1.721616395252182e-14,   6.743282507509381e-16,  -2.757279005451557e-17,
   6.648124383600168e-19,   1.060625339053538e-01,  -9.303123592917727e-04,   8.157917614862660e-06,  -7.138149232906663e-08,   6.146196785198965e-10,  -4.791105536072311e-12,
   1.710490891609116e-14,   6.777443877119800e-16,  -2.763982569695852e-17,   6.652021554922263e-19,   1.060644414269920e-01,  -9.303624246222059e-04,   8.158779441780962e-06,
  -7.139265924896612e-08,   6.146776640192139e-10,  -4.787700221855183e-12,   1.692207350023033e-14,   6.833539124490909e-16,  -2.774973622627509e-17,   6.658339726916916e-19,
   1.060664655283967e-01,  -9.304155506568117e-04,   8.159693935871355e-06,  -7.140450528599702e-08,   6.147389566632629e-10,  -4.784076881104497e-12,   1.672780990560722e-14,
   6.893079151880103e-16,  -2.786616983912250e-17,   6.664935413406129e-19,   1.060680585600704e-01,  -9.304573631881444e-04,   8.160413668565309e-06,  -7.141382605612391e-08,
   6.147870244184184e-10,  -4.781218022988309e-12,   1.657473457583584e-14,   6.939950830456775e-16,  -2.795766570418806e-17,   6.670047695243139e-19,   1.060689779511389e-01,
  -9.304814948444337e-04,   8.160829048795480e-06,  -7.141920440263633e-08,   6.148146971223635e-10,  -4.779565205515272e-12,   1.648631616289576e-14,   6.967006707653106e-16,
  -2.801041428562370e-17,   6.672966574752539e-19,   1.060693231956607e-01,  -9.304905566776035e-04,   8.160985029791806e-06,  -7.142122386403201e-08,   6.148250756141656e-10,
  -4.778944005189203e-12,   1.645309987844101e-14,   6.977167458149000e-16,  -2.803021139944455e-17,   6.674056682376825e-19,   1.060693804250947e-01,  -9.304920588144042e-04,
   8.161010885958429e-06,  -7.142155861015723e-08,   6.148267953179422e-10,  -4.778841003278252e-12,   1.644759305008679e-14,   6.978851800591734e-16,  -2.803349249990200e-17,
   6.674237068785758e-19,   1.784317278131126e-01,  -1.565053431706969e-03,   1.372341367270574e-05,  -1.200638670777884e-07,   1.032988865527285e-09,  -8.009220582540808e-12,
   2.646136538358995e-14,   1.228050574475519e-15,  -4.925156393086463e-17,   1.189041013583077e-18,   1.784336825300157e-01,  -1.565104729765927e-03,   1.372429598957820e-05,
  -1.200752328869979e-07,   1.033042985605214e-09,  -8.005452901029268e-12,   2.626260667319587e-14,   1.234162367251669e-15,  -4.937277786072385e-17,   1.189808931311034e-18,
   1.784368916050654e-01,  -1.565188947334074e-03,   1.372574448820948e-05,  -1.200938877867515e-07,   1.033131524482177e-09,  -7.999254427430512e-12,   2.593596435106774e-14,
   1.244198601904387e-15,  -4.957153087150933e-17,   1.191055547342807e-18,   1.784402968052734e-01,  -1.565278313442444e-03,   1.372728150153909e-05,  -1.201136767482620e-07,
   1.033225052194748e-09,  -7.992659404826878e-12,   2.558889938446845e-14,   1.254851514661492e-15,  -4.978209691688608e-17,   1.192359194247600e-18,   1.784429768051946e-01,
  -1.565348648484949e-03,   1.372849117112163e-05,  -1.201292469008048e-07,   1.033298355484861e-09,  -7.987456079130608e-12,   2.531541583342577e-14,   1.263238063652830e-15,
  -4.994757644019744e-17,   1.193371319723667e-18,   1.784445235214175e-01,  -1.565389241594353e-03,   1.372918930789852e-05,  -1.201382311894252e-07,   1.033340538508601e-09,
  -7.984447922952120e-12,   2.515744629765447e-14,   1.268079160171760e-15,  -5.004298260695223e-17,   1.193949879508844e-18,   1.784451043355181e-01,  -1.565404484971595e-03,
   1.372945146761778e-05,  -1.201416045857788e-07,   1.033356355634596e-09,  -7.983317344575246e-12,   2.509810131551907e-14,   1.269897238595511e-15,  -5.007879052531681e-17,
   1.194166083388611e-18,   1.784452006141265e-01,  -1.565407011793332e-03,   1.372949492447120e-05,  -1.201421637590287e-07,   1.033358976335063e-09,  -7.983129883017706e-12,
   2.508826267183191e-14,   1.270198621570194e-15,  -5.008472524752474e-17,   1.194201866812364e-18,   2.729138772262367e-01,  -2.393769808438072e-03,   2.098987610384027e-05,
  -1.836109390183774e-07,   1.577864096781027e-09,  -1.212915874575647e-11,   3.489360296108472e-14,   2.088252585347305e-15,  -8.180457950777358e-17,   1.979902886161056e-18,
   2.729168669498948e-01,  -2.393848256772624e-03,   2.099122375153756e-05,  -1.836281454890061e-07,   1.577934652459220e-09,  -1.212275531807583e-11,   3.456339636410085e-14,
   2.098434116243533e-15,  -8.200962448202420e-17,   1.981353418920795e-18,   2.729217752039686e-01,  -2.393977047710561e-03,   2.099343617569502e-05,  -1.836563860418268e-07,
   1.578049969304697e-09,  -1.211222103814947e-11,   3.402072039796572e-14,   2.115153945706907e-15,  -8.234586470716289e-17,   1.983711818466416e-18,   2.729269834295959e-01,
  -2.394113712053142e-03,   2.099578378612328e-05,  -1.836863423960946e-07,   1.578171633421966e-09,  -1.210101342377206e-11,   3.344410016904695e-14,   2.132901995858158e-15,
  -8.270213110563678e-17,   1.986183124607017e-18,   2.729310824671681e-01,  -2.394221272823630e-03,   2.099763140929349e-05,  -1.837099116385265e-07,   1.578266879429776e-09,
  -1.209217129801663e-11,   3.298971892734157e-14,   2.146874849732371e-15,  -8.298214364005576e-17,   1.988105482701945e-18,   2.729334481566769e-01,  -2.394283350337615e-03,
   2.099869772531539e-05,  -1.837235112741002e-07,   1.578321645489446e-09,  -1.208705964462663e-11,   3.272725505480735e-14,   2.154940867185521e-15,  -8.314359517570102e-17,
   1.989205855642188e-18,   2.729343365069641e-01,  -2.394306661456418e-03,   2.099909814070985e-05,  -1.837286175740432e-07,   1.578342172442228e-09,  -1.208513852531679e-11,
   3.262865350955818e-14,   2.157970115464861e-15,  -8.320419358257609e-17,   1.989617343565972e-18,   2.729344837642861e-01,  -2.394310525628867e-03,   2.099916451545766e-05,
  -1.837294639900444e-07,   1.578345573060385e-09,  -1.208481998563201e-11,   3.261230658445285e-14,   2.158472276660496e-15,  -8.321423714424342e-17,   1.989685463181191e-18,
   3.932983701052973e-01,  -3.449677105687220e-03,   3.024809061250071e-05,  -2.645434489117209e-07,   2.269426935084214e-09,  -1.722251751682258e-11,   3.836266671594777e-14,
   3.461807639085914e-15,  -1.319927629956962e-16,   3.209983462926536e-18,   3.933026785284015e-01,  -3.449790131368318e-03,   3.025002877410475e-05,  -2.645678680007075e-07,
   2.269502483043311e-09,  -1.721190794975440e-11,   3.782967948360376e-14,   3.478325902281180e-15,  -1.323329282756103e-16,   3.212748061047532e-18,   3.933097517018447e-01,
  -3.449975688835605e-03,   3.025321062475025e-05,  -2.646079448656168e-07,   2.269625681173019e-09,  -1.719445490117650e-11,   3.695371812954678e-14,   3.505453271472413e-15,
  -1.328908162610436e-16,   3.217250743090071e-18,   3.933172571568997e-01,  -3.450172589868464e-03,   3.025658687468577e-05,  -2.646504545172772e-07,   2.269755280380284e-09,
  -1.717588729964103e-11,   3.602292908352443e-14,   3.534250979481653e-15,  -1.334820303504328e-16,   3.221979647211909e-18,   3.933231641859496e-01,  -3.450327559413343e-03,
   3.025924404469912e-05,  -2.646838989606170e-07,   2.269856461520599e-09,  -1.716123932584249e-11,   3.528943358855754e-14,   3.556924624086830e-15,  -1.339467749679898e-16,
   3.225665946055054e-18,   3.933265733266843e-01,  -3.450416998332794e-03,   3.026077756686687e-05,  -2.647031960380258e-07,   2.269914528583029e-09,  -1.715277159131343e-11,
   3.486573455751406e-14,   3.570013895873735e-15,  -1.342147693730608e-16,   3.227779185767329e-18,   3.933278535078172e-01,  -3.450450584096735e-03,   3.026135342296900e-05,
  -2.647104414568598e-07,   2.269936271595157e-09,  -1.714958920693410e-11,   3.470655872248156e-14,   3.574929776444347e-15,  -1.343153624921964e-16,   3.228570043309812e-18,
   3.933280657169496e-01,  -3.450456151447405e-03,   3.026144887953337e-05,  -2.647116424451704e-07,   2.269939872552579e-09,  -1.714906154052648e-11,   3.468016921822457e-14,
   3.575744692409042e-15,  -1.343320350529837e-16,   3.228700997576487e-18,   5.460482500083210e-01,  -4.789460735803774e-03,   4.199465808184183e-05,  -3.671607177029000e-07,
   3.141341934331164e-09,  -2.335827194785216e-11,   2.732481181967700e-14,   5.802996103706615e-15,  -2.148363658619257e-16,   5.273846281392310e-18,   5.460542315510768e-01,
  -4.789617601680065e-03,   4.199734056481439e-05,  -3.671938077551290e-07,   3.141389933701774e-09,  -2.334049551799864e-11,   2.645677794581910e-14,   5.830163464112006e-15,
  -2.154151396483464e-16,   5.279452540229360e-18,   5.460640514978246e-01,  -4.789875132586423e-03,   4.200174432121140e-05,  -3.672481119672163e-07,   3.141467386798304e-09,
  -2.331125385276843e-11,   2.503009724156934e-14,   5.874783424334774e-15,  -2.163645426520734e-16,   5.288600645118577e-18,   5.460744715957884e-01,  -4.790148406619824e-03,
   4.200641708263091e-05,  -3.673057078060941e-07,   3.141547740271581e-09,  -2.328014627657034e-11,   2.351402029900535e-14,   5.922156183180927e-15,  -2.173709115035401e-16,
   5.298231982908055e-18,   5.460826725395258e-01,  -4.790363484736784e-03,   4.201009459578741e-05,  -3.673510178150243e-07,   3.141609652619591e-09,  -2.325560657524297e-11,
   2.231922553817986e-14,   5.959458638541456e-15,  -2.181621860390766e-16,   5.305757138647518e-18,   5.460874055735079e-01,  -4.790487614538209e-03,   4.201221697059102e-05,
  -3.673771597955310e-07,   3.141644851452204e-09,  -2.324142102825623e-11,   2.162903134440461e-14,   5.980994540553358e-15,  -2.186185469733904e-16,   5.310078074828808e-18,
   5.460891828954328e-01,  -4.790534227271648e-03,   4.201301394531981e-05,  -3.673869749861593e-07,   3.141657968368058e-09,  -2.323608982749009e-11,   2.136973283940838e-14,
   5.989082980433103e-15,  -2.187898583682859e-16,   5.311696471776025e-18,   5.460894775130688e-01,  -4.790541954039442e-03,   4.201314605538795e-05,  -3.673886019215137e-07,
   3.141660137376677e-09,  -2.323520587321165e-11,   2.132674387468148e-14,   5.990423833876706e-15,  -2.188182526907357e-16,   5.311964524822373e-18,   7.437031883797736e-01,
  -6.523100641694844e-03,   5.719279467529346e-05,  -4.997722740777450e-07,   4.256352704315699e-09,  -3.050852828579562e-11,  -2.499339690879625e-14,   1.034332652736166e-14,
  -3.719635345517598e-16,   9.312563063078086e-18,   7.437113346421745e-01,  -6.523314157876307e-03,   5.719642852411546e-05,  -4.998154217811501e-07,   4.256281448017493e-09,
  -3.047684897618348e-11,  -2.649799382798260e-14,   1.039138830210162e-14,  -3.730470794890703e-16,   9.325789110871629e-18,   7.437247084244126e-01,  -6.523664692505546e-03,
   5.720239402555478e-05,  -4.998862228161509e-07,   4.256162135917184e-09,  -3.042473821875821e-11,  -2.897114912095755e-14,   1.047033781100983e-14,  -3.748250683408406e-16,
   9.347415895621422e-18,   7.437388995495025e-01,  -6.524036654859017e-03,   5.720872381558863e-05,  -4.999613034093634e-07,   4.256032362682598e-09,  -3.036930321593153e-11,
  -3.159959155323831e-14,   1.055417484741000e-14,  -3.767105217969268e-16,   9.370246600102900e-18,   7.437500684077013e-01,  -6.524329404228508e-03,   5.721370534371373e-05,
  -5.000203597646707e-07,   4.255927930414719e-09,  -3.032557311039998e-11,  -3.367125370229436e-14,   1.062020232539002e-14,  -3.781935589013904e-16,   9.388129609254638e-18,
   7.437565143217550e-01,  -6.524498360840943e-03,   5.721658026080060e-05,  -5.000544293128585e-07,   4.255866737853247e-09,  -3.030029452280718e-11,  -3.486807835317317e-14,
   1.065832698462591e-14,  -3.790491159283661e-16,   9.398416163959078e-18,   7.437589348544753e-01,  -6.524561806716745e-03,   5.721765981691119e-05,  -5.000672203025013e-07,
   4.255843584964634e-09,  -3.029079439387800e-11,  -3.531772995804583e-14,   1.067264674214582e-14,  -3.793703229664381e-16,   9.402272419318165e-18,   7.437593360938922e-01,
  -6.524572323830912e-03,   5.721783876858569e-05,  -5.000693404620650e-07,   4.255839737835711e-09,  -3.028921920169008e-11,  -3.539227838829106e-14,   1.067502063506588e-14,
  -3.794235642939787e-16,   9.402911308502520e-18,   1.018498376214415e+00,  -8.933309568843761e-03,   7.831722447802296e-05,  -6.835850111427200e-07,   5.762971052655651e-09,
  -3.776723505827866e-11,  -2.319093913096420e-13,   2.223403899180819e-14,  -7.856853253382588e-16,   2.070535518232968e-17,   1.018509531219981e+00,  -8.933601594073973e-03,
   7.832214211788281e-05,  -6.836381796144801e-07,   5.762438076309775e-09,  -3.769907196772582e-11,  -2.350964856203707e-13,   2.234136793886759e-14,  -7.884045930401351e-16,
   2.075216830497987e-17,   1.018527844472833e+00,  -8.934081017035873e-03,   7.833021487879397e-05,  -6.837253934401138e-07,   5.761558162009707e-09,  -3.758693857306980e-11,
  -2.403364539620887e-13,   2.251773828874405e-14,  -7.928696798375441e-16,   2.082890920184875e-17,   1.018547276937100e+00,  -8.934589743974574e-03,   7.833878023722388e-05,
  -6.838178376598491e-07,   5.760617774361947e-09,  -3.746763997829502e-11,  -2.459071183517277e-13,   2.270511509537779e-14,  -7.976087836526962e-16,   2.091018660816629e-17,
   1.018562570886432e+00,  -8.934990130756817e-03,   7.834552088145065e-05,  -6.838905218538830e-07,   5.759872805989128e-09,  -3.737352211667722e-11,  -2.502989747378406e-13,
   2.285275104050342e-14,  -8.013394138491987e-16,   2.097404287462028e-17,   1.018571397523213e+00,  -8.935221208211984e-03,   7.834941090317278e-05,  -6.839324412729283e-07,
   5.759440912965622e-09,  -3.731911291443966e-11,  -2.528366935706780e-13,   2.293802248189504e-14,  -8.034928026167110e-16,   2.101085154864536e-17,   1.018574712050813e+00,
  -8.935307981306118e-03,   7.835087161927844e-05,  -6.839481771256890e-07,   5.759278362702664e-09,  -3.729866433331360e-11,  -2.537902168123964e-13,   2.297005557350477e-14,
  -8.043014908173329e-16,   2.102466523356554e-17,   1.018575261483196e+00,  -8.935322365252445e-03,   7.835111375252252e-05,  -6.839507852885124e-07,   5.759251398138435e-09,
  -3.729527377102425e-11,  -2.539483077788124e-13,   2.297536619295912e-14,  -8.044355461068004e-16,   2.102695460927933e-17,   2.040557980748058e-03,  -1.729160144398801e-05,
   1.465084962306487e-07,  -1.240357723240791e-09,   1.043880630685865e-11,  -8.458457597248249e-14,   5.466152659210611e-16,   1.469692439987330e-18,  -1.909052081762294e-19,
   5.791275552493906e-21,   2.040578847920703e-03,  -1.729213140513808e-05,   1.465174158974567e-07,  -1.240478051724993e-09,   1.043996386457902e-11,  -8.457970323840769e-14,
   5.458383060668384e-16,   1.499722893061767e-18,  -1.916893814185911e-19,   5.804765737042370e-21,   2.040613105681322e-03,  -1.729300145928221e-05,   1.465320596859650e-07,
  -1.240675585199269e-09,   1.044186297555561e-11,  -8.457163875568531e-14,   5.445605407825138e-16,   1.549072451081999e-18,  -1.929769860011981e-19,   5.826879693581093e-21,
   2.040649457063009e-03,  -1.729392470446277e-05,   1.465475988445159e-07,  -1.240885176370138e-09,   1.044387643626007e-11,  -8.456299317918019e-14,   5.432016612033213e-16,
   1.601503639091821e-18,  -1.943435794348494e-19,   5.850300179663141e-21,   2.040678066696490e-03,  -1.729465133982696e-05,   1.465598289438897e-07,  -1.241050120544650e-09,
   1.044545984946102e-11,  -8.455612491545615e-14,   5.421299914124558e-16,   1.642816074047528e-18,  -1.954193424400595e-19,   5.868700159646200e-21,   2.040694578238230e-03,
  -1.729507070995777e-05,   1.465668874538567e-07,  -1.241145310967889e-09,   1.044637319029245e-11,  -8.455213537659593e-14,   5.415106180604036e-16,   1.666677838132548e-18,
  -1.960402841362893e-19,   5.879306257005989e-21,   2.040700778554920e-03,  -1.729522819038166e-05,   1.465695380475370e-07,  -1.241181055523108e-09,   1.044671606847161e-11,
  -8.455063240011415e-14,   5.412778686437681e-16,   1.675641860931094e-18,  -1.962734722780838e-19,   5.883286511065542e-21,   2.040701806349779e-03,  -1.729525429516217e-05,
   1.465699774241751e-07,  -1.241186980673895e-09,   1.044677290066802e-11,  -8.455038300355600e-14,   5.412392782036436e-16,   1.677127970796609e-18,  -1.963121275157873e-19,
   5.883946166267923e-21,   1.843753327455445e-02,  -1.562388668667007e-04,   1.323781847121283e-06,  -1.120721141613585e-08,   9.431378610849491e-11,  -7.638864781295219e-13,
   4.920743684940171e-15,   1.399852478697384e-17,  -1.748549310790542e-18,   5.297131653639017e-20,   1.843772182049815e-02,  -1.562436553112897e-04,   1.323862435379285e-06,
  -1.120829808835752e-08,   9.432420523068052e-11,  -7.638402478328313e-13,   4.913627409011620e-15,   1.427321607606289e-17,  -1.755727024480055e-18,   5.309509364078698e-20,
   1.843803135748727e-02,  -1.562515166535138e-04,   1.323994740454382e-06,  -1.121008198734495e-08,   9.434129884764761e-11,  -7.637637578260537e-13,   4.901924204242445e-15,
   1.472462240508232e-17,  -1.767512826446444e-18,   5.329799989985459e-20,   1.843835981144940e-02,  -1.562598586011538e-04,   1.324135135069288e-06,  -1.121197477466751e-08,
   9.435942144964267e-11,  -7.636817861496459e-13,   4.889478081430494e-15,   1.520421871611271e-17,  -1.780021728110530e-18,   5.351289837800144e-20,   1.843861831462076e-02,
  -1.562664240879063e-04,   1.324245632668542e-06,  -1.121346435919007e-08,   9.437367312459783e-11,  -7.636166872181675e-13,   4.879662556197489e-15,   1.558211145496820e-17,
  -1.789868625711743e-18,   5.368173341950645e-20,   1.843876750513380e-02,  -1.562702132910247e-04,   1.324309405518014e-06,  -1.121432400779854e-08,   9.438189366786989e-11,
  -7.635788819970319e-13,   4.873989661921997e-15,   1.580038013685535e-17,  -1.795552385343849e-18,   5.377905435782549e-20,   1.843882352827457e-02,  -1.562716361994867e-04,
   1.324333353334133e-06,  -1.121464681065643e-08,   9.438497973576789e-11,  -7.635646412594147e-13,   4.871857890756856e-15,   1.588237608580476e-17,  -1.797686866770218e-18,
   5.381557717054787e-20,   1.843883281494474e-02,  -1.562718720682509e-04,   1.324337323052599e-06,  -1.121470031965294e-08,   9.438549125200954e-11,  -7.635622783052756e-13,
   4.871504437772063e-15,   1.589596987532666e-17,  -1.798040696725302e-18,   5.382163017911412e-20,   5.162899520636076e-02,  -4.375018635695692e-04,   3.706864595879786e-06,
  -3.138207292128618e-08,   2.640611942046087e-10,  -2.136825728159537e-12,   1.367279436320431e-14,   4.340089635622390e-17,  -5.034537618864028e-18,   1.521075545851700e-19,
   5.162952317416539e-02,  -4.375152720066939e-04,   3.707090226824624e-06,  -3.138511256803050e-08,   2.640901362871257e-10,  -2.136683401294088e-12,   1.365230521905055e-14,
   4.418973730810909e-17,  -5.055179528645804e-18,   1.524653061010691e-19,   5.163038994202429e-02,  -4.375372850646075e-04,   3.707460654331810e-06,  -3.139010248858744e-08,
   2.641376175606777e-10,  -2.136448038570677e-12,   1.361860948072854e-14,   4.548606585900148e-17,  -5.089073942220517e-18,   1.530517820430072e-19,   5.163130968133169e-02,
  -4.375606438957567e-04,   3.707853730722156e-06,  -3.139539697309164e-08,   2.641879555394836e-10,  -2.136195974738350e-12,   1.358277483145994e-14,   4.686336084536481e-17,
  -5.125048451680806e-18,   1.536729450458890e-19,   5.163203354389396e-02,  -4.375790283420154e-04,   3.708163101402586e-06,  -3.139956360968268e-08,   2.642275403872090e-10,
  -2.135995914011489e-12,   1.355451421552743e-14,   4.794859405318697e-17,  -5.153367673123351e-18,   1.541609800651487e-19,   5.163245130831093e-02,  -4.375896387355890e-04,
   3.708341652282211e-06,  -3.140196819654314e-08,   2.642503729746995e-10,  -2.135879779151840e-12,   1.353818098532066e-14,   4.857542194244717e-17,  -5.169714064410676e-18,
   1.544423035235046e-19,   5.163260818473841e-02,  -4.375936231138446e-04,   3.708408701237710e-06,  -3.140287113133780e-08,   2.642589444548455e-10,  -2.135836041556568e-12,
   1.353204325738163e-14,   4.881090001298306e-17,  -5.175852825512397e-18,   1.545478805821351e-19,   5.163263418934327e-02,  -4.375942835852627e-04,   3.708419815631684e-06,
  -3.140302080509794e-08,   2.642603651745917e-10,  -2.135828784680874e-12,   1.353102560701106e-14,   4.884993904055745e-17,  -5.176870440838139e-18,   1.545653781803818e-19,
   1.024655649533892e-01,  -8.682886550180959e-04,   7.356819488297635e-06,  -6.228091746858435e-08,   5.239503898723014e-10,  -4.233775469901639e-12,   2.679575718178418e-14,
   9.960035054302186e-17,  -1.043590536981050e-17,   3.140557328268535e-19,   1.024666127831523e-01,  -8.683152653897875e-04,   7.357267181191639e-06,  -6.228693968500491e-08,
   5.240070825992093e-10,  -4.233451747669890e-12,   2.675328725505818e-14,   1.012292776590056e-16,  -1.047863138968232e-17,   3.148021990661998e-19,   1.024683330114432e-01,
  -8.683589524805449e-04,   7.358002176380856e-06,  -6.229682578434330e-08,   5.241000868903598e-10,  -4.232916773722570e-12,   2.668344284812409e-14,   1.039061766426072e-16,
  -1.054878970140185e-17,   3.160259711580302e-19,   1.024701583693485e-01,  -8.684053103869759e-04,   7.358782110426059e-06,  -6.230731523093428e-08,   5.241986818338935e-10,
  -4.232344322120886e-12,   2.660916513818680e-14,   1.067503094538493e-16,  -1.062325547553483e-17,   3.173222062490305e-19,   1.024715949810376e-01,  -8.684417961323053e-04,
   7.359395956878884e-06,  -6.231557013947192e-08,   5.242762114745653e-10,  -4.231890319708288e-12,   2.655058697050313e-14,   1.089913592603169e-16,  -1.068187645936650e-17,
   3.183406918975090e-19,   1.024724240959451e-01,  -8.684628535026849e-04,   7.359750233397952e-06,  -6.232033407138223e-08,   5.243209292246981e-10,  -4.231626910241066e-12,
   2.651673176701995e-14,   1.102857952661122e-16,  -1.071571414183468e-17,   3.189278131665305e-19,   1.024727354402795e-01,  -8.684707608932538e-04,   7.359883270347755e-06,
  -6.232212294918773e-08,   5.243377162440757e-10,  -4.231527733446208e-12,   2.650400961525001e-14,   1.107720733253301e-16,  -1.072842172442268e-17,   3.191481567831085e-19,
   1.024727870502410e-01,  -8.684720716637369e-04,   7.359905323263275e-06,  -6.232241947991652e-08,   5.243404986721129e-10,  -4.231511279547427e-12,   2.650190025185947e-14,
   1.108526916580883e-16,  -1.073052825107232e-17,   3.191846752249105e-19,   1.723823448079580e-01,  -1.460760118171772e-03,   1.237666512183737e-05,  -1.047740711154352e-07,
   8.811694888095653e-10,  -7.105062465672673e-12,   4.423182485910374e-14,   2.012523293119447e-16,  -1.867246675389652e-17,   5.590965499911269e-19,   1.723841076124208e-01,
  -1.460804884232643e-03,   1.237741803255855e-05,  -1.047841766288456e-07,   8.812630015883929e-10,  -7.104414609049851e-12,   4.415583725084441e-14,   2.041527864184703e-16,
  -1.874882413335796e-17,   5.604464034828155e-19,   1.723870016188570e-01,  -1.460878378085777e-03,   1.237865411481902e-05,  -1.048007657793460e-07,   8.814163998701407e-10,
  -7.103344758995484e-12,   4.403087118898278e-14,   2.089193329831741e-16,  -1.887421047384425e-17,   5.626595419404698e-19,   1.723900724888616e-01,  -1.460956364983667e-03,
   1.237996577168989e-05,  -1.048183672153623e-07,   8.815790066371663e-10,  -7.102201012798463e-12,   4.389797334481619e-14,   2.139837653406260e-16,  -1.900729999288956e-17,
   5.650039457484488e-19,   1.723924893560854e-01,  -1.461017744151633e-03,   1.238099810902573e-05,  -1.048322189583856e-07,   8.817068625440336e-10,  -7.101294681571727e-12,
   4.379316537750149e-14,   2.179743886143901e-16,  -1.911207435545016e-17,   5.668461639604850e-19,   1.723938842080442e-01,  -1.461053168500097e-03,   1.238159391372113e-05,
  -1.048402127968032e-07,   8.817806039514361e-10,  -7.100769134524207e-12,   4.373259178649617e-14,   2.202794133246847e-16,  -1.917255449802867e-17,   5.679082021109882e-19,
   1.723944079946133e-01,  -1.461066470927757e-03,   1.238181764858537e-05,  -1.048432145108443e-07,   8.818082857437298e-10,  -7.100571316400903e-12,   4.370982938102924e-14,
   2.211453429218293e-16,  -1.919526780177666e-17,   5.683067917146895e-19,   1.723944948200399e-01,  -1.461068676007818e-03,   1.238185473606718e-05,  -1.048437120851784e-07,
   8.818128739305718e-10,  -7.100538500417415e-12,   4.370605532025583e-14,   2.212889026565766e-16,  -1.919903298376176e-17,   5.683728522264069e-19,   2.636612636418941e-01,
  -2.234253006590810e-03,   1.893020511437596e-05,  -1.602449595703556e-07,   1.347111369451061e-09,  -1.082842021512913e-11,   6.577340586818383e-14,   3.828709774048824e-16,
  -3.105980264606314e-17,   9.245652450995145e-19,   2.636639598638125e-01,  -2.234321473097847e-03,   1.893135612363990e-05,  -1.602603588285670e-07,   1.347250264776377e-09,
  -1.082719922872487e-11,   6.564700777060324e-14,   3.876687816219285e-16,  -3.118681802298442e-17,   9.268487610057336e-19,   2.636683862671029e-01,  -2.234433876702614e-03,
   1.893324577692285e-05,  -1.602856379159764e-07,   1.347478087517851e-09,  -1.082518437878543e-11,   6.543913865699466e-14,   3.955535757914868e-16,  -3.139539851262049e-17,
   9.305930618103931e-19,   2.636730831843852e-01,  -2.234553152074447e-03,   1.893525096096934e-05,  -1.603124592263132e-07,   1.347719557800786e-09,  -1.082303231849266e-11,
   6.521807569024533e-14,   4.039313889912940e-16,  -3.161680513154948e-17,   9.345599694094527e-19,   2.636767797997500e-01,  -2.234647027095818e-03,   1.893682913519017e-05,
  -1.603335664630796e-07,   1.347909402438956e-09,  -1.082132838377157e-11,   6.504373749479106e-14,   4.105330456395528e-16,  -3.179111549721209e-17,   9.376775225924881e-19,
   2.636789132355763e-01,  -2.234701206081045e-03,   1.893773996398321e-05,  -1.603457473493853e-07,   1.348018887749547e-09,  -1.082034089764820e-11,   6.494297898956158e-14,
   4.143463048873529e-16,  -3.189173818087056e-17,   9.394749441445740e-19,   2.636797143707923e-01,  -2.234721551183086e-03,   1.893808199559899e-05,  -1.603503212962178e-07,
   1.348059985868678e-09,  -1.081996930925668e-11,   6.490511584940318e-14,   4.157788477702102e-16,  -3.192952765975439e-17,   9.401495567782949e-19,   2.636798471708884e-01,
  -2.234724923693657e-03,   1.893813869256984e-05,  -1.603510794882488e-07,   1.348066797694273e-09,  -1.081990767213612e-11,   6.489883805065677e-14,   4.160163452816607e-16,
  -3.193579205217067e-17,   9.402613656811371e-19,   3.799643633487162e-01,  -3.219798902356607e-03,   2.728030147593284e-05,  -2.309125969006420e-07,   1.939970516170689e-09,
  -1.552302057867415e-11,   9.080296122683847e-14,   7.119072478973333e-16,  -5.014026196282834e-17,   1.483417268838890e-18,   3.799682488692654e-01,  -3.219897562005388e-03,
   2.728195899147797e-05,  -2.309346681828811e-07,   1.940161914963541e-09,  -1.552076980398928e-11,   9.059890188308180e-14,   7.196084309110779e-16,  -5.034591939285345e-17,
   1.487205315335551e-18,   3.799746277509409e-01,  -3.220059534597072e-03,   2.728468018892724e-05,  -2.309708993992425e-07,   1.940475809955130e-09,  -1.551705809229900e-11,
   9.026331242366470e-14,   7.322651471543897e-16,  -5.068366411377394e-17,   1.493417520394919e-18,   3.799813964696554e-01,  -3.220231409292502e-03,   2.728756774923564e-05,
  -2.310093402958397e-07,   1.940808445328467e-09,  -1.551309696491915e-11,   8.990641990594302e-14,   7.457138852710133e-16,  -5.104220593126024e-17,   1.500000297227195e-18,
   3.799867236550166e-01,  -3.220366682283240e-03,   2.728984038977131e-05,  -2.310395911416366e-07,   1.941069918321041e-09,  -1.550996307796280e-11,   8.962495978043350e-14,
   7.563118472732919e-16,  -5.132450148257036e-17,   1.505174538081199e-18,   3.799897981452700e-01,  -3.220444753657900e-03,   2.729115202129480e-05,  -2.310570485551158e-07,
   1.941220693984273e-09,  -1.550814784869191e-11,   8.946228955653947e-14,   7.624336403592091e-16,  -5.148746811113871e-17,   1.508158102870338e-18,   3.799909526596744e-01,
  -3.220474070743189e-03,   2.729164456070929e-05,  -2.310636038092897e-07,   1.941277288006186e-09,  -1.550746496372563e-11,   8.940116102004710e-14,   7.647334740553964e-16,
  -5.154867280756983e-17,   1.509277970279010e-18,   3.799911440376346e-01,  -3.220478930496501e-03,   2.729172620662806e-05,  -2.310646904270925e-07,   1.941286668022680e-09,
  -1.550735169990066e-11,   8.939102575562109e-14,   7.651147592389623e-16,  -5.155881884174593e-17,   1.509463578409518e-18,   5.275355774119718e-01,  -4.470307789072269e-03,
   3.787511898969020e-05,  -3.205576566553552e-07,   2.690539398376084e-09,  -2.137744176351339e-11,   1.175111685320341e-13,   1.335987626739131e-15,  -8.143753295998516e-17,
   2.396878067413816e-18,   5.275409719422925e-01,  -4.470444749544944e-03,   3.787741768768422e-05,  -3.205880427504525e-07,   2.690786290986967e-09,  -2.137324988802932e-11,
   1.171796677687589e-13,   1.348439727559128e-15,  -8.177481964875728e-17,   2.403320054452669e-18,   5.275498281738042e-01,  -4.470669601701454e-03,   3.788119152368793e-05,
  -3.206379220498633e-07,   2.691191089981516e-09,  -2.136634123675040e-11,   1.166344827305218e-13,   1.368905654730854e-15,  -8.232878808076215e-17,   2.413886890628462e-18,
   5.275592256419812e-01,  -4.470908199959307e-03,   3.788519606072624e-05,  -3.206908418554735e-07,   2.691619911996588e-09,  -2.135897388760206e-11,   1.160546766268103e-13,
   1.390653897847280e-15,  -8.291694016589153e-17,   2.425087197897878e-18,   5.275666217320172e-01,  -4.471095987266821e-03,   3.788834780097496e-05,  -3.207324856744405e-07,
   2.691956888979802e-09,  -2.135314912489871e-11,   1.155974082290569e-13,   1.407793260552003e-15,  -8.338007025404293e-17,   2.433893218858947e-18,   5.275708902536843e-01,
  -4.471204366691654e-03,   3.789016679140676e-05,  -3.207565173905791e-07,   2.692151161062156e-09,  -2.134977686244363e-11,   1.153331255981064e-13,   1.417694089543480e-15,
  -8.364745202205769e-17,   2.438971850876725e-18,   5.275724931436855e-01,  -4.471245064942258e-03,   3.789084985164325e-05,  -3.207655412084534e-07,   2.692224073591651e-09,
  -2.134850852523589e-11,   1.152338122314564e-13,   1.421413719303577e-15,  -8.374787545222433e-17,   2.440878265273130e-18,   5.275727588465787e-01,  -4.471251811296709e-03,
   3.789096307924752e-05,  -3.207670370179839e-07,   2.692236157851747e-09,  -2.134829817365008e-11,   1.152173457885427e-13,   1.422030394541141e-15,  -8.376452307003492e-17,
   2.441194245755915e-18,   7.184894613622874e-01,  -6.088435807172934e-03,   5.158411463084212e-05,  -4.365067789787724e-07,   3.657847443727225e-09,  -2.871125818934420e-11,
   1.399382213301477e-13,   2.649838125994381e-15,  -1.397333834221852e-16,   4.108245927798179e-18,   7.184968084448370e-01,  -6.088622305623998e-03,   5.158723951285994e-05,
  -4.365475671459847e-07,   3.658139379035172e-09,  -2.870299712169147e-11,   1.393691018618126e-13,   2.671207832540888e-15,  -1.403273081870426e-16,   4.120281077089580e-18,
   7.185088701919529e-01,  -6.088928485593441e-03,   5.159236969058387e-05,  -4.366145188856094e-07,   3.658617753449621e-09,  -2.868938887274575e-11,   1.384330860681734e-13,
   2.706334159460091e-15,  -1.413029486719840e-16,   4.140029410451373e-18,   7.185216690756321e-01,  -6.089253383300815e-03,   5.159781344750248e-05,  -4.366855480900112e-07,
   3.659124141917170e-09,  -2.867488639589523e-11,   1.374375704099251e-13,   2.743666360727996e-15,  -1.423390146702561e-16,   4.160971161383096e-18,   7.185317421813154e-01,
  -6.089509091880759e-03,   5.160209788767889e-05,  -4.367414399076394e-07,   3.659521799602208e-09,  -2.866342716228826e-11,   1.366524062030035e-13,   2.773090754160553e-15,
  -1.431550075353008e-16,   4.177443113293072e-18,   7.185375556946416e-01,  -6.089656671263442e-03,   5.160457059190570e-05,  -4.367736927386673e-07,   3.659750945429733e-09,
  -2.865679547874937e-11,   1.361985956398467e-13,   2.790089681068195e-15,  -1.436261742736427e-16,   4.186945638245031e-18,   7.185397387507213e-01,  -6.089712089726788e-03,
   5.160549913015669e-05,  -4.367858033483470e-07,   3.659836925730486e-09,  -2.865430174836106e-11,   1.360280572810734e-13,   2.796476260680340e-15,  -1.438031476051645e-16,
   4.190513216940229e-18,   7.185401006247814e-01,  -6.089721276179798e-03,   5.160565304936017e-05,  -4.367878108209877e-07,   3.659851174700694e-09,  -2.865388819390057e-11,
   1.359997813548330e-13,   2.797535102455534e-15,  -1.438324858684895e-16,   4.191104556435929e-18,   9.839683969566172e-01,  -8.338074825670731e-03,   7.064201603895985e-05,
  -5.975543130004111e-07,   4.990249878561735e-09,  -3.811904198651751e-11,   1.303086369186811e-13,   6.242683581379084e-15,  -2.856849915240953e-16,   8.529053934895836e-18,
   9.839784584060278e-01,  -8.338330125810390e-03,   7.064627842459072e-05,  -5.976083950125434e-07,   4.990514151438471e-09,  -3.809967329556181e-11,   1.291430368147114e-13,
   6.287181479166775e-15,  -2.869964599277398e-16,   8.558950170424219e-18,   9.839949763427519e-01,  -8.338749258969921e-03,   7.065327597930219e-05,  -5.976971591707172e-07,
   4.990946185235111e-09,  -3.806777981429790e-11,   1.272257259761164e-13,   6.360342775292149e-15,  -2.891516280533188e-16,   8.608041793454908e-18,   9.840125037471965e-01,
  -8.339194014290001e-03,   7.066070114100649e-05,  -5.977913172711424e-07,   4.991402139371335e-09,  -3.803380689107183e-11,   1.251861571036692e-13,   6.438123169804571e-15,
  -2.914413886452274e-16,   8.660148088792239e-18,   9.840262983388249e-01,  -8.339544055456496e-03,   7.066654493770883e-05,  -5.978654002140556e-07,   4.991759188878958e-09,
  -3.800697472709548e-11,   1.235772714147729e-13,   6.499445809987851e-15,  -2.932455836138983e-16,   8.701167673218072e-18,   9.840342596406619e-01,  -8.339746077628616e-03,
   7.066991756919942e-05,  -5.979081469071078e-07,   4.991964531259699e-09,  -3.799145112757214e-11,   1.226472542515759e-13,   6.534880027971802e-15,  -2.942876774312037e-16,
   8.724845504533522e-18,   9.840372492214171e-01,  -8.339821940204849e-03,   7.067118403758763e-05,  -5.979241971974912e-07,   4.992041503580815e-09,  -3.798561463108824e-11,
   1.222977403582820e-13,   6.548194194051518e-15,  -2.946791560332913e-16,   8.733737634795272e-18,   9.840377447889472e-01,  -8.339834515578244e-03,   7.067139397346908e-05,
  -5.979268576827437e-07,   4.992054255679124e-09,  -3.798464676671356e-11,   1.222397884849240e-13,   6.550401643681926e-15,  -2.947440577597875e-16,   8.735211678385872e-18,
   1.973645288586055e-03,  -1.617635520051137e-05,   1.325728251441766e-07,  -1.086153830893132e-09,   8.878774569475314e-12,  -7.149975085036934e-14,   5.276991887906219e-16,
  -2.103838218534471e-18,  -5.315752006389051e-20,   2.283622253859028e-21,   1.973664169931286e-03,  -1.617681926318293e-05,   1.325804125992612e-07,  -1.086255631584951e-09,
   8.879898381271260e-12,  -7.150584691170850e-14,   5.274795547688795e-16,  -2.091905417846636e-18,  -5.353386982205472e-20,   2.292321816650616e-21,   1.973695167497660e-03,
  -1.617758112861096e-05,   1.325928693278429e-07,  -1.086422760091564e-09,   8.881742957228714e-12,  -7.151582865600446e-14,   5.271179024601480e-16,  -2.072283557117425e-18,
  -5.415233805345079e-20,   2.306606643947033e-21,   1.973728059374857e-03,  -1.617838956945865e-05,   1.326060878215450e-07,  -1.086600104760311e-09,   8.883699727820592e-12,
  -7.152638478286076e-14,   5.267326823837415e-16,  -2.051419427024514e-18,  -5.480943491916661e-20,   2.321768094536055e-21,   1.973753946225144e-03,  -1.617902584760460e-05,
   1.326164915274481e-07,  -1.086739682021456e-09,   8.885239377667264e-12,  -7.153466693974704e-14,   5.264284405219198e-16,  -2.034967515797882e-18,  -5.532719144555279e-20,
   2.333703196822317e-21,   1.973768886341354e-03,  -1.617939306857160e-05,   1.326224959828738e-07,  -1.086820237219560e-09,   8.886127803616978e-12,  -7.153943647463209e-14,
   5.262524267716828e-16,  -2.025460075119338e-18,  -5.562624629896281e-20,   2.340592351491392e-21,   1.973774496561904e-03,  -1.617953096604141e-05,   1.326247507672491e-07,
  -1.086850486956579e-09,   8.886461390645767e-12,  -7.154122554201776e-14,   5.261862505866590e-16,  -2.021887532016275e-18,  -5.573859111184436e-20,   2.343179517858654e-21,
   1.973775426539342e-03,  -1.617955382464458e-05,   1.326251245327587e-07,  -1.086855501307687e-09,   8.886516686111570e-12,  -7.154152200315212e-14,   5.261752766485763e-16,
  -2.021295205003143e-18,  -5.575721633783841e-20,   2.343608389298828e-21,   1.783294130709224e-02,  -1.461620240372889e-04,   1.197866187677012e-06,  -9.813956708222124e-09,
   8.022256844852313e-11,  -6.459211442614812e-13,   4.762189612074140e-15,  -1.876659515592868e-17,  -4.887796097985559e-19,   2.088400343067693e-20,   1.783311191011404e-02,
  -1.461662170808351e-04,   1.197934742688852e-06,  -9.814876358608073e-09,   8.023270977918095e-11,  -6.459754791364839e-13,   4.760170496774120e-15,  -1.865746670013529e-17,
  -4.922206678944044e-19,   2.096361860150805e-20,   1.783339198965413e-02,  -1.461731009245197e-04,   1.198047293090219e-06,  -9.816386168756691e-09,   8.024935526185035e-11,
  -6.460644415175556e-13,   4.756845848688712e-15,  -1.847801964960402e-17,  -4.978754948160740e-19,   2.109434885402861e-20,   1.783368918530229e-02,  -1.461804056008613e-04,
   1.198166726264602e-06,  -9.817988268912290e-09,   8.026701311202414e-11,  -6.461585148763043e-13,   4.753304616830826e-15,  -1.828721143167257e-17,  -5.038835416609118e-19,
   2.123310279427467e-20,   1.783392308679712e-02,  -1.461861546991277e-04,   1.198260726953764e-06,  -9.819249184277255e-09,   8.028090681770152e-11,  -6.462323172546161e-13,
   4.750507850342343e-15,  -1.813675396071585e-17,  -5.086175752013257e-19,   2.134233077510474e-20,   1.783405807871285e-02,  -1.461894727282391e-04,   1.198314979055905e-06,
  -9.819976904851699e-09,   8.028892389601824e-11,  -6.462748162211451e-13,   4.748889851665999e-15,  -1.804980559036708e-17,  -5.113519489591662e-19,   2.140537944270750e-20,
   1.783410877004676e-02,  -1.461907187023495e-04,   1.198335351725861e-06,  -9.820250175253785e-09,   8.029193415195102e-11,  -6.462907572601848e-13,   4.748281533973127e-15,
  -1.801713360602419e-17,  -5.123791623889064e-19,   2.142905692124839e-20,   1.783411717288876e-02,  -1.461909252415105e-04,   1.198338728812105e-06,  -9.820295473950127e-09,
   8.029243313246687e-11,  -6.462933987791641e-13,   4.748180657399478e-15,  -1.801171659596726e-17,  -5.125494603383235e-19,   2.143298191144763e-20,   4.993600981244344e-02,
  -4.092845928754222e-04,   3.354277510175029e-06,  -2.748101409581369e-08,   2.246290499862389e-10,  -1.808032398064807e-12,   1.330100996640736e-14,  -5.113419631790322e-17,
  -1.418188125888316e-18,   5.994389112079446e-20,   4.993648753680143e-02,  -4.092963342206927e-04,   3.354469468794811e-06,  -2.748358830196291e-08,   2.246573725977879e-10,
  -1.808180192089212e-12,   1.329515382873316e-14,  -5.082095240920322e-17,  -1.428061494627623e-18,   6.017276913003980e-20,   4.993727181844473e-02,  -4.093156103343974e-04,
   3.354784617402441e-06,  -2.748781442801790e-08,   2.247038596050586e-10,  -1.808422139289105e-12,   1.328551149943342e-14,  -5.030586365035520e-17,  -1.444286913782964e-18,
   6.054859784945736e-20,   4.993810402879054e-02,  -4.093360648617262e-04,   3.355119038169123e-06,  -2.749229887795303e-08,   2.247531734619917e-10,  -1.808677937951815e-12,
   1.327524143953546e-14,  -4.975816172958034e-17,  -1.461525993893112e-18,   6.094750002477416e-20,   4.993875900218864e-02,  -4.093521634648442e-04,   3.355382246253802e-06,
  -2.749582831070205e-08,   2.247919746928707e-10,  -1.808878581589824e-12,   1.326713073304127e-14,  -4.932628254329994e-17,  -1.475109627023313e-18,   6.126152314941991e-20,
   4.993913700795438e-02,  -4.093614545972273e-04,   3.355534155673786e-06,  -2.749786527421710e-08,   2.248143640145304e-10,  -1.808994107624138e-12,   1.326243860886314e-14,
  -4.907670190692215e-17,  -1.482955570118725e-18,   6.144278577153627e-20,   4.993927895435450e-02,  -4.093649435691258e-04,   3.355591200473269e-06,  -2.749863018538558e-08,
   2.248227707410836e-10,  -1.809037437861048e-12,   1.326067453732016e-14,  -4.898291862661571e-17,  -1.485903039524664e-18,   6.151085802431079e-20,   4.993930248407999e-02,
  -4.093655219192866e-04,   3.355600656533979e-06,  -2.749875698094650e-08,   2.248241642401146e-10,  -1.809044617780082e-12,   1.326038200470555e-14,  -4.896736936763160e-17,
  -1.486391690154020e-18,   6.152214230782001e-20,   9.910557909677337e-02,  -8.122872746049419e-04,   6.657067824697082e-06,  -5.453978698759040e-08,   4.457750238828973e-10,
  -3.586137283804396e-12,   2.628899447181284e-14,  -9.695728119692812e-17,  -2.973157637868640e-18,   1.236699803065207e-19,   9.910652721249474e-02,  -8.123105768804321e-04,
   6.657448764105922e-06,  -5.454489267386206e-08,   4.458309942741884e-10,  -3.586416682584880e-12,   2.627672439580525e-14,  -9.631099417780165e-17,  -2.993518894616076e-18,
   1.241434606094343e-19,   9.910808373717667e-02,  -8.123488329141116e-04,   6.658074172311372e-06,  -5.455327476749749e-08,   4.459228595756304e-10,  -3.586873956637372e-12,
   2.625652223899670e-14,  -9.524825467185150e-17,  -3.026980010742765e-18,   1.249209542977562e-19,   9.910973538356058e-02,  -8.123894276663505e-04,   6.658737825658033e-06,
  -5.456216920096429e-08,   4.460203096787165e-10,  -3.587357249147713e-12,   2.623500616373268e-14,  -9.411822063584644e-17,  -3.062532117484322e-18,   1.257462031447632e-19,
   9.911103527660703e-02,  -8.124213775019118e-04,   6.659260158284670e-06,  -5.456916944445571e-08,   4.460969844987012e-10,  -3.587736217925136e-12,   2.621801491547033e-14,
  -9.322715058895566e-17,  -3.090546006911156e-18,   1.263958702052777e-19,   9.911178548580168e-02,  -8.124398169990048e-04,   6.659561620266846e-06,  -5.457320953293670e-08,
   4.461412274383336e-10,  -3.587954372513568e-12,   2.620818567676519e-14,  -9.271220414260635e-17,  -3.106727065689716e-18,   1.267708819853767e-19,   9.911206719974383e-02,
  -8.124467413311338e-04,   6.659674824810995e-06,  -5.457472664730568e-08,   4.461578396644105e-10,  -3.588036186632775e-12,   2.620449030236564e-14,  -9.251870573005340e-17,
  -3.112805801365427e-18,   1.269117169600268e-19,   9.911211389801668e-02,  -8.124478891445022e-04,   6.659693590220259e-06,  -5.457497813183364e-08,   4.461605933027835e-10,
  -3.588049742948142e-12,   2.620387750913374e-14,  -9.248662369255481e-17,  -3.113813575266281e-18,   1.269350631264761e-19,   1.667296927569857e-01,  -1.366546694157202e-03,
   1.119946880443193e-05,  -9.175358094559160e-08,   7.498595125458462e-10,  -6.027719733437787e-12,   4.395655040175225e-14,  -1.518351102529067e-16,  -5.398307563951819e-18,
   2.198601857368378e-19,   1.667312878122993e-01,  -1.366585896101667e-03,   1.120010959752251e-05,  -9.176216249230862e-08,   7.499530771113730e-10,  -6.028155077249455e-12,
   4.393428806366019e-14,  -1.506860412783141e-16,  -5.434496077884385e-18,   2.207056761235731e-19,   1.667339064198179e-01,  -1.366650255088848e-03,   1.120116162077753e-05,
  -9.177625093061016e-08,   7.501066437436488e-10,  -6.028867267786527e-12,   4.389763624665004e-14,  -1.487965247889945e-16,  -5.493968342287869e-18,   2.220940839095110e-19,
   1.667366850546003e-01,  -1.366718548551543e-03,   1.120227797715885e-05,  -9.179120044986435e-08,   7.502695425000911e-10,  -6.029619559917179e-12,   4.385860359475926e-14,
  -1.467873418460392e-16,  -5.557158506836488e-18,   2.235678287169149e-19,   1.667388719198117e-01,  -1.366772298474442e-03,   1.120315661225207e-05,  -9.180296623147157e-08,
   7.503977103544024e-10,  -6.030209155273648e-12,   4.382778162769043e-14,  -1.452030193937460e-16,  -5.606951340128780e-18,   2.247280585883794e-19,   1.667401340285592e-01,
  -1.366803319651797e-03,   1.120366371249282e-05,  -9.180975666667041e-08,   7.504716647479963e-10,  -6.030548434225511e-12,   4.380995232852122e-14,  -1.442874391339386e-16,
  -5.635712527512313e-18,   2.253978030204312e-19,   1.667406079678720e-01,  -1.366814968610036e-03,   1.120385413797491e-05,  -9.181230657518318e-08,   7.504994327506203e-10,
  -6.030675649977677e-12,   4.380324943277307e-14,  -1.439433958511322e-16,  -5.646517318750651e-18,   2.256493275031149e-19,   1.667406865303569e-01,  -1.366816899602033e-03,
   1.120388570395106e-05,  -9.181272926073526e-08,   7.505040355568924e-10,  -6.030696727948612e-12,   4.380213791942283e-14,  -1.438863534183499e-16,  -5.648308614356679e-18,
   2.256910228015415e-19,   2.550154525867036e-01,  -2.090152600301543e-03,   1.712972521638764e-05,  -1.403359868487421e-07,   1.146729108743560e-09,  -9.207618521660803e-12,
   6.663526102993547e-14,  -2.072491419073738e-16,  -9.139022728358971e-18,   3.627028660507873e-19,   2.550178922430725e-01,  -2.090212559137844e-03,   1.713070514738370e-05,
  -1.403490949112188e-07,   1.146870899944009e-09,  -9.208207502927918e-12,   6.659760435468807e-14,  -2.053532536122929e-16,  -9.198737309970891e-18,   3.641076874430582e-19,
   2.550218974348841e-01,  -2.090310995320395e-03,   1.713231395011820e-05,  -1.403706145109681e-07,   1.147103614392492e-09,  -9.209170291283554e-12,   6.653561223559301e-14,
  -2.022356384093153e-16,  -9.296874962936979e-18,   3.664146943144317e-19,   2.550261473903020e-01,  -2.090415449221461e-03,   1.713402113294761e-05,  -1.403934492742524e-07,
   1.147350462409818e-09,  -9.210186278900077e-12,   6.646959906933870e-14,  -1.989205284167185e-16,  -9.401151227849909e-18,   3.688636392375834e-19,   2.550294922270042e-01,
  -2.090497658975320e-03,   1.713536478079635e-05,  -1.404114209337888e-07,   1.147544675060211e-09,  -9.210981803276030e-12,   6.641747627233055e-14,  -1.963063926132268e-16,
  -9.483321820652855e-18,   3.707917131817519e-19,   2.550314226375400e-01,  -2.090545105429198e-03,   1.713614026070865e-05,  -1.404217929621590e-07,   1.147656735676625e-09,
  -9.211439285608251e-12,   6.638732696358333e-14,  -1.947956682465126e-16,  -9.530785984814946e-18,   3.719047375733963e-19,   2.550321475334278e-01,  -2.090562922346354e-03,
   1.713643146764059e-05,  -1.404256878057718e-07,   1.147698811143591e-09,  -9.211610766430819e-12,   6.637599269823470e-14,  -1.942279876710740e-16,  -9.548617167911686e-18,
   3.723227448629899e-19,   2.550322676956947e-01,  -2.090565875771328e-03,   1.713647973970143e-05,  -1.404263334341605e-07,   1.147705785521804e-09,  -9.211639175560604e-12,
   6.637411320085199e-14,  -1.941338659909855e-16,  -9.551573359335185e-18,   3.723920384799182e-19,   3.675048180426816e-01,  -3.012135426576135e-03,   2.468573772625155e-05,
  -2.022342760617517e-07,   1.652160911767741e-09,  -1.324433596295488e-11,   9.477282374840621e-14,  -2.458005020247620e-16,  -1.504992659151968e-17,   5.794623160540629e-19,
   3.675083338436823e-01,  -3.012221831454258e-03,   2.468714955571679e-05,  -2.022531294723608e-07,   1.652362475997165e-09,  -1.324502198843525e-11,   9.471086964696188e-14,
  -2.427708679426997e-16,  -1.514546597700805e-17,   5.817332595146942e-19,   3.675141057456038e-01,  -3.012363684868886e-03,   2.468946742650503e-05,  -2.022840810834123e-07,
   1.652693279664099e-09,  -1.324614162649452e-11,   9.460888579060191e-14,  -2.377888129438215e-16,  -1.530248596309577e-17,   5.854628623687367e-19,   3.675202303775278e-01,
  -3.012514210220557e-03,   2.469192703537064e-05,  -2.023169240640399e-07,   1.653044156350193e-09,  -1.324732069105140e-11,   9.450029741505942e-14,  -2.324910205738664e-16,
  -1.546933618172179e-17,   5.894222611005576e-19,   3.675250506383231e-01,  -3.012632680194365e-03,   2.469386288267649e-05,  -2.023427723321730e-07,   1.653320202699965e-09,
  -1.324824212737139e-11,   9.441456561259158e-14,  -2.283133398819118e-16,  -1.560082172611616e-17,   5.925397688044383e-19,   3.675278325625248e-01,  -3.012701053830209e-03,
   2.469498014698824e-05,  -2.023576901406836e-07,   1.653479476126070e-09,  -1.324877130070878e-11,   9.436497893734643e-14,  -2.258989947505893e-16,  -1.567677412679508e-17,
   5.943395176579791e-19,   3.675288772135827e-01,  -3.012726729244597e-03,   2.469539970010349e-05,  -2.023632919765703e-07,   1.653539277631196e-09,  -1.324896951776837e-11,
   9.434633800377635e-14,  -2.249917558007779e-16,  -1.570530814365182e-17,   5.950154494128673e-19,   3.675290503800213e-01,  -3.012730985334952e-03,   2.469546924752601e-05,
  -2.023642205637106e-07,   1.653549190204000e-09,  -1.324900234907879e-11,   9.434324691294555e-14,  -2.248413348086105e-16,  -1.571003875818497e-17,   5.951275004735840e-19,
   5.102369774135009e-01,  -4.181993231336897e-03,   3.427313011353062e-05,  -2.807678690335933e-07,   2.292992532352301e-09,  -1.833580241822546e-11,   1.289122318886203e-13,
  -2.279532645787578e-16,  -2.496458138596059e-17,   9.289562599674263e-19,   5.102418586720473e-01,  -4.182113189531788e-03,   3.427508952317799e-05,  -2.807939672502821e-07,
   2.293266485488592e-09,  -1.833640579661901e-11,   1.288095604615893e-13,  -2.230943320113514e-16,  -2.511837650794200e-17,   9.326715045229822e-19,   5.102498722499743e-01,
  -4.182310128383254e-03,   3.427830638000285e-05,  -2.808368122861159e-07,   2.293716063797015e-09,  -1.833738577947368e-11,   1.286405640369766e-13,  -2.151038275629762e-16,
  -2.537115619295265e-17,   9.387737217988904e-19,   5.102583755501382e-01,  -4.182519106681444e-03,   3.428171994305937e-05,  -2.808822749757461e-07,   2.294192883160696e-09,
  -1.833841124809152e-11,   1.284606409608030e-13,  -2.066065500290216e-16,  -2.563978261845773e-17,   9.452527624851283e-19,   5.102650678909063e-01,  -4.182683581632842e-03,
   3.428440660113215e-05,  -2.809180549224580e-07,   2.294567984393114e-09,  -1.833920788089098e-11,   1.283186022830000e-13,  -1.999055786630105e-16,  -2.585148799649497e-17,
   9.503547679470990e-19,   5.102689302513435e-01,  -4.182778506523335e-03,   3.428595719057324e-05,  -2.809387044567286e-07,   2.294784399172016e-09,  -1.833966345360896e-11,
   1.282364531808349e-13,  -1.960328762279002e-16,  -2.597378549043395e-17,   9.533004195007185e-19,   5.102703806211620e-01,  -4.182814152364667e-03,   3.428653946490074e-05,
  -2.809464586049743e-07,   2.294865653063978e-09,  -1.833983373519229e-11,   1.282055721327274e-13,  -1.945776093929748e-16,  -2.601973174595548e-17,   9.544067642674688e-19,
   5.102706210415145e-01,  -4.182820061204802e-03,   3.428663598586834e-05,  -2.809477439682901e-07,   2.294879121425780e-09,  -1.833986192008724e-11,   1.282004514028865e-13,
  -1.943363238189687e-16,  -2.602734917333370e-17,   9.545901685159903e-19,   6.949292381370419e-01,  -5.695762642859692e-03,   4.667887871446118e-05,  -3.823748800065191e-07,
   3.121103429198522e-09,  -2.485332322476892e-11,   1.694137929118080e-13,  -4.527837226376412e-17,  -4.368012313101120e-17,   1.567095657416420e-18,   6.949358862476477e-01,
  -5.695926012075252e-03,   4.668154568588131e-05,  -3.824102480231374e-07,   3.121462921491354e-09,  -2.485332708948604e-11,   1.692342928339193e-13,  -3.707497685414832e-17,
  -4.394231882477054e-17,   1.573609003727506e-18,   6.949468004721242e-01,  -5.696194220004204e-03,   4.668592417240126e-05,  -3.824683102971851e-07,   3.122052806432566e-09,
  -2.485331560039816e-11,   1.689388560579475e-13,  -2.358360281776528e-17,  -4.437331462543376e-17,   1.584308913860729e-18,   6.949583816816166e-01,  -5.696478824190920e-03,
   4.669057038570490e-05,  -3.825299187806804e-07,   3.122678338978840e-09,  -2.485327914334333e-11,   1.686243432577502e-13,  -9.235344646391908e-18,  -4.483139417040278e-17,
   1.595672101631782e-18,   6.949674964249963e-01,  -5.696702819929771e-03,   4.669422719763557e-05,  -3.825784049174236e-07,   3.123170360041774e-09,  -2.485323285939976e-11,
   1.683760724662997e-13,   2.080618436470948e-18,  -4.519245503830508e-17,   1.604622032883124e-18,   6.949727568301299e-01,  -5.696832096559286e-03,   4.669633770252667e-05,
  -3.826063871869807e-07,   3.123454204081285e-09,  -2.485319908881972e-11,   1.682324906476261e-13,   8.620829396600496e-18,  -4.540105067732204e-17,   1.609790029396623e-18,
   6.949747321850740e-01,  -5.696880642033543e-03,   4.669713023458237e-05,  -3.826168948018337e-07,   3.123560769352460e-09,  -2.485318507247964e-11,   1.681785175373125e-13,
   1.107854865048048e-17,  -4.547942205578245e-17,   1.611731194940612e-18,   6.949750596295127e-01,  -5.696888689183732e-03,   4.669726160898418e-05,  -3.826186365890952e-07,
   3.123578432963803e-09,  -2.485318267861380e-11,   1.681695677293667e-13,   1.148604602893714e-17,  -4.549241543016905e-17,   1.612052998931873e-18,   9.517027973217597e-01,
  -7.800320562700047e-03,   6.392594471000800e-05,  -5.235954486733737e-07,   4.268987545755180e-09,  -3.369180963446222e-11,   2.138518074994966e-13,   7.399427570075843e-16,
  -9.000198074209330e-17,   3.123624403818426e-18,   9.517119017886045e-01,  -7.800544266446473e-03,   6.392959231892773e-05,  -5.236433734649764e-07,   4.269439626625508e-09,
  -3.368933573664588e-11,   2.134819736689477e-13,   7.563277297767032e-16,  -9.054094211538409e-17,   3.137844881173492e-18,   9.517268486204601e-01,  -7.800911527145164e-03,
   6.393558073707403e-05,  -5.237220471145172e-07,   4.270181213967840e-09,  -3.368523879143164e-11,   2.128732714543554e-13,   7.832791585711025e-16,  -9.142710833435372e-17,
   3.161214829307162e-18,   9.517427088754429e-01,  -7.801301239239528e-03,   6.394193528890571e-05,  -5.238055223128755e-07,   4.270967310516856e-09,  -3.368084311296163e-11,
   2.122252688292699e-13,   8.119485778512327e-16,  -9.236926679403270e-17,   3.186045734479371e-18,   9.517551913495892e-01,  -7.801607959264593e-03,   6.394693662764900e-05,
  -5.238712150926407e-07,   4.271585403270980e-09,  -3.367734852393431e-11,   2.117137488745534e-13,   8.345636371086146e-16,  -9.311210293783515e-17,   3.205612079050685e-18,
   9.517623953778804e-01,  -7.801784979224674e-03,   6.394982310744168e-05,  -5.239091266169447e-07,   4.271941888113634e-09,  -3.367531761531082e-11,   2.114179234419608e-13,
   8.476361175229131e-16,  -9.354135043751405e-17,   3.216913928502055e-18,   9.517651005901848e-01,  -7.801851453082987e-03,   6.395090702997952e-05,  -5.239233625696751e-07,
   4.272075708473362e-09,  -3.367455231948939e-11,   2.113067213138351e-13,   8.525489134113957e-16,  -9.370263964112635e-17,   3.221159723365368e-18,   9.517655490193256e-01,
  -7.801862472134684e-03,   6.395108670674562e-05,  -5.239257223719581e-07,   4.272097888831172e-09,  -3.367442531988055e-11,   2.112882818093639e-13,   8.533634880421683e-16,
  -9.372938104283381e-17,   3.221863621577423e-18,   1.910981756956205e-03,  -1.516559727604512e-05,   1.203463194872634e-07,  -9.548679317861618e-10,   7.569933527495575e-12,
  -5.967196854313463e-14,   4.546392048212348e-16,  -2.853707247141308e-18,  -2.753024377867078e-21,   7.443266108610298e-22,   1.910998896130745e-03,  -1.516600523048282e-05,
   1.203527885276679e-07,  -9.549529207954939e-10,   7.570903832725993e-12,  -5.968043377518046e-14,   4.546250866930123e-16,  -2.849782680246633e-18,  -2.904360913371780e-21,
   7.484663990718276e-22,   1.911027033526711e-03,  -1.516667497997867e-05,   1.203634091035372e-07,  -9.550924526940900e-10,   7.572496722381058e-12,  -5.969432227422947e-14,
   4.546014713384362e-16,  -2.843324485207792e-18,  -3.153206479863373e-21,   7.552696843497414e-22,   1.911056890385375e-03,  -1.516738567165510e-05,   1.203746791696324e-07,
  -9.552405186221813e-10,   7.574186869226173e-12,  -5.970904740753345e-14,   4.545758174838548e-16,  -2.836450919287038e-18,  -3.417797509005897e-21,   7.624982078568742e-22,
   1.911080388546687e-03,  -1.516794501558706e-05,   1.203835493604203e-07,  -9.553570558251763e-10,   7.575517000076454e-12,  -5.972062772448894e-14,   4.545551956437431e-16,
  -2.831026227363254e-18,  -3.626427900873171e-21,   7.681941181528009e-22,   1.911093950058304e-03,  -1.516826783426952e-05,   1.203886687572955e-07,  -9.554243151456728e-10,
   7.576284635044368e-12,  -5.972730756380671e-14,   4.545431209957922e-16,  -2.827889451170567e-18,  -3.746991283918360e-21,   7.714841525942480e-22,   1.911099042590526e-03,
  -1.516838905785338e-05,   1.203905911863959e-07,  -9.554495723359535e-10,   7.576572887790490e-12,  -5.972981526895394e-14,   4.545385540549951e-16,  -2.826710410810734e-18,
  -3.792294032646855e-21,   7.727201246787687e-22,   1.911099886753260e-03,  -1.516840915250090e-05,   1.203909098588928e-07,  -9.554537591108766e-10,   7.576620669712978e-12,
  -5.973023092315058e-14,   4.545377952888670e-16,  -2.826514907331441e-18,  -3.799805194378194e-21,   7.729250327716511e-22,   1.726674276989489e-02,  -1.370292863632899e-04,
   1.087393333400722e-06,  -8.627735937264146e-09,   6.839785336348940e-11,  -5.391335571711423e-13,   4.106121474717093e-15,  -2.570765661763866e-17,  -2.769985307195536e-20,
   6.813950484080765e-21,   1.726689763149843e-02,  -1.370329724468565e-04,   1.087451784153074e-06,  -8.628503807174202e-09,   6.840661663783809e-11,  -5.392098071551548e-13,
   4.105982329441816e-15,  -2.567173062752047e-17,  -2.908286264408993e-20,   6.851791365291934e-21,   1.726715186791150e-02,  -1.370390239868710e-04,   1.087547745933397e-06,
  -8.629764468130813e-09,   6.842100274132312e-11,  -5.393349055830972e-13,   4.105749895720100e-15,  -2.561261168307900e-17,  -3.135697654745869e-20,   6.913978919257594e-21,
   1.726742164058910e-02,  -1.370454454610637e-04,   1.087649576152862e-06,  -8.631102233117479e-09,   6.843626719358091e-11,  -5.394675381531051e-13,   4.105497817641314e-15,
  -2.554969066897366e-17,  -3.377498927936617e-20,   6.980053822350561e-21,   1.726763395903712e-02,  -1.370504994285319e-04,   1.087729722395115e-06,  -8.632155138106143e-09,
   6.844828016668629e-11,  -5.395718434200094e-13,   4.105295481826172e-15,  -2.550003292878190e-17,  -3.568160035022580e-20,   7.032119563000839e-21,   1.726775649454364e-02,
  -1.370534162656020e-04,   1.087775978493026e-06,  -8.632762820983861e-09,   6.845521299488165e-11,  -5.396320090151401e-13,   4.105177125389246e-15,  -2.547131889510480e-17,
  -3.678339511619617e-20,   7.062193530350773e-21,   1.726780250829438e-02,  -1.370545115846217e-04,   1.087793348521161e-06,  -8.632991017771098e-09,   6.845781632303274e-11,
  -5.396545959272556e-13,   4.105132381706947e-15,  -2.546052598047695e-17,  -3.719740452036612e-20,   7.073491479897167e-21,   1.726781013575592e-02,  -1.370546931503608e-04,
   1.087796227873237e-06,  -8.633028844962145e-09,   6.845824786099694e-11,  -5.396583397215992e-13,   4.105124948988189e-15,  -2.545873634586932e-17,  -3.726604698758566e-20,
   7.075364533903540e-21,   4.835053409693785e-02,  -3.837110006062481e-04,   3.044931107991683e-06,  -2.415944714871738e-08,   1.915252860825104e-10,  -1.509486712360022e-12,
   1.148760447613306e-14,  -7.153748189392025e-17,  -9.404431544233154e-20,   1.959776664135262e-20,   4.835096774214552e-02,  -3.837213224024591e-04,   3.045094779623561e-06,
  -2.416159704869466e-08,   1.915498020901324e-10,  -1.509698841864214e-12,   1.148714727859224e-14,  -7.143416282840605e-17,  -9.800831374581427e-20,   1.970628288841054e-20,
   4.835167965781457e-02,  -3.837382679657702e-04,   3.045363488232457e-06,  -2.416512667505537e-08,   1.915900483361127e-10,  -1.510046861711337e-12,   1.148638523768752e-14,
  -7.126414460199403e-17,  -1.045264345627876e-19,   1.988461949386038e-20,   4.835243507830621e-02,  -3.837562494211434e-04,   3.045648629407086e-06,  -2.416887217705546e-08,
   1.916327516871505e-10,  -1.510415831304980e-12,   1.148556103817790e-14,  -7.108319367301656e-17,  -1.114570409290294e-19,   2.007410588883237e-20,   4.835302961481644e-02,
  -3.837704015748649e-04,   3.045873051905143e-06,  -2.417182012076171e-08,   1.916663586979600e-10,  -1.510705990122365e-12,   1.148490106980478e-14,  -7.094038694472481e-17,
  -1.169218755092988e-19,   2.022341890470111e-20,   4.835337274012226e-02,  -3.837785693216241e-04,   3.046002576487962e-06,  -2.417352152244924e-08,   1.916857536575587e-10,
  -1.510873357260065e-12,   1.148451564758542e-14,  -7.085781099354754e-17,  -1.200799122956746e-19,   2.030966495210358e-20,   4.835350158834543e-02,  -3.837816364412943e-04,
   3.046051215385320e-06,  -2.417416043190133e-08,   1.916930366000830e-10,  -1.510936188411966e-12,   1.148437005878939e-14,  -7.082677276342707e-17,  -1.212665754993006e-19,
   2.034206529059298e-20,   4.835352294684914e-02,  -3.837821448628954e-04,   3.046059278038298e-06,  -2.417426634114274e-08,   1.916942438490034e-10,  -1.510946602684279e-12,
   1.148434588003804e-14,  -7.082162614223687e-17,  -1.214633235354429e-19,   2.034743685359943e-20,   9.595896232494856e-02,  -7.615326243930669e-04,   6.043126089204184e-06,
  -4.794795904405377e-08,   3.801008611793202e-10,  -2.995165005068474e-12,   2.276576692331521e-14,  -1.405439756816253e-16,  -2.392870676993096e-19,   4.055067620050866e-20,
   9.595982295939973e-02,  -7.615531095051124e-04,   6.043450911326271e-06,  -4.795222489794861e-08,   3.801494436297381e-10,  -2.995581586211220e-12,   2.276464369006592e-14,
  -1.403302184855750e-16,  -2.474472595885787e-19,   4.077426992340524e-20,   9.596123586363535e-02,  -7.615867404500500e-04,   6.043984189403622e-06,  -4.795922841477243e-08,
   3.802291977634629e-10,  -2.996265005953374e-12,   2.276277609374820e-14,  -1.399784705168743e-16,  -2.608654046359762e-19,   4.114173069848790e-20,   9.596273510976486e-02,
  -7.616224272736499e-04,   6.044550079426504e-06,  -4.796666026786808e-08,   3.803138205683542e-10,  -2.996989533310545e-12,   2.276076228367429e-14,  -1.396041086154178e-16,
  -2.751328218613275e-19,   4.153217200618072e-20,   9.596391505731851e-02,  -7.616505142887242e-04,   6.044995467364573e-06,  -4.797250959537456e-08,   3.803804173382754e-10,
  -2.997559280475089e-12,   2.275915410268398e-14,  -1.393086649608978e-16,  -2.863828828269580e-19,   4.183983980672832e-20,   9.596459604134218e-02,  -7.616667243744250e-04,
   6.045252521284506e-06,  -4.797588552497510e-08,   3.804188509008292e-10,  -2.997887908189113e-12,   2.275821664046730e-14,  -1.391378301987807e-16,  -2.928841442269993e-19,
   4.201755649062043e-20,   9.596485176011298e-02,  -7.616728115210998e-04,   6.045349049823842e-06,  -4.797715325191553e-08,   3.804332829460867e-10,  -2.998011276257671e-12,
   2.275786284585749e-14,  -1.390736179412701e-16,  -2.953270640988869e-19,   4.208432026382474e-20,   9.596489414929134e-02,  -7.616738205579772e-04,   6.045365050928898e-06,
  -4.797736339747955e-08,   3.804356752567823e-10,  -2.998031724438711e-12,   2.275780410602891e-14,  -1.390629705635178e-16,  -2.957320991118595e-19,   4.209538886502536e-20,
   1.614360005345678e-01,  -1.281159951872593e-03,   1.016661510593397e-05,  -8.066466097274054e-08,   6.394355575971805e-10,  -5.037315730549804e-12,   3.821778375265635e-14,
  -2.328843818416483e-16,  -5.336641613327874e-19,   7.235760965448445e-20,   1.614374484174704e-01,  -1.281194414741452e-03,   1.016716154623575e-05,  -8.067183526187393e-08,
   6.395171083995162e-10,  -5.038005578848628e-12,   3.821535639949376e-14,  -2.325030140059486e-16,  -5.481277048988727e-19,   7.275452228635713e-20,   1.614398254079346e-01,
  -1.281250993335083e-03,   1.016805866677437e-05,  -8.068361372594332e-08,   6.396509833380423e-10,  -5.039137245782006e-12,   3.821132962690265e-14,  -2.318754618489213e-16,
  -5.719109800875972e-19,   7.340683329736389e-20,   1.614423476551322e-01,  -1.281311030609101e-03,   1.016901064943092e-05,  -8.069611254760344e-08,   6.397930296568264e-10,
  -5.040336901124306e-12,   3.820699993014172e-14,  -2.312075742171631e-16,  -5.971999267355123e-19,   7.409995620026570e-20,   1.614443327323975e-01,  -1.281358282441130e-03,
   1.016975991432814e-05,  -8.070594988132405e-08,   6.399048169634334e-10,  -5.041280216116832e-12,   3.820355113242280e-14,  -2.306804893886723e-16,  -6.171408818598733e-19,
   7.464614959216026e-20,   1.614454783815394e-01,  -1.281385553272027e-03,   1.017019234961128e-05,  -8.071162747760601e-08,   6.399693300344070e-10,  -5.041824292467337e-12,
   3.820154419127129e-14,  -2.303757153155436e-16,  -6.286646010705804e-19,   7.496164967180849e-20,   1.614459085883871e-01,  -1.281395793905530e-03,   1.017035473711382e-05,
  -8.071375952411667e-08,   6.399935550362992e-10,  -5.042028536275021e-12,   3.820078743062034e-14,  -2.302611593615109e-16,  -6.329947841052087e-19,   7.508017621187022e-20,
   1.614459799015518e-01,  -1.281397491445837e-03,   1.017038165536476e-05,  -8.071411294412058e-08,   6.399975706613785e-10,  -5.042062389323188e-12,   3.820066182131592e-14,
  -2.302421642546596e-16,  -6.337127275476684e-19,   7.509982648429249e-20,   2.469186748427324e-01,  -1.959552458409555e-03,   1.554997727783367e-05,  -1.233770828461749e-07,
   9.779714555037446e-10,  -7.701181433701939e-12,   5.827440559018728e-14,  -3.483568790882940e-16,  -1.106315816660413e-18,   1.198693424415981e-19,   2.469208893993977e-01,
  -1.959605169556234e-03,   1.555081301739519e-05,  -1.233880508878764e-07,   9.780957896917119e-10,  -7.702212352117465e-12,   5.826950287912928e-14,  -3.477251943741779e-16,
  -1.130082663114673e-18,   1.205231920962806e-19,   2.469245250387570e-01,  -1.959691706823468e-03,   1.555218509589775e-05,  -1.234060577600985e-07,   9.782998965614220e-10,
  -7.703903395662788e-12,   5.826138546418341e-14,  -3.466857514085988e-16,  -1.169164575792102e-18,   1.215977997831906e-19,   2.469283828502652e-01,  -1.959783534159001e-03,
   1.555364108155499e-05,  -1.234251658786740e-07,   9.785164590364250e-10,  -7.705695850736121e-12,   5.825267862266786e-14,  -3.455795166703664e-16,  -1.210721579860177e-18,
   1.227396816481807e-19,   2.469314190530264e-01,  -1.959855806090221e-03,   1.555478702544878e-05,  -1.234402051071005e-07,   9.786868870574064e-10,  -7.707105164046326e-12,
   5.824575841618100e-14,  -3.447065089751555e-16,  -1.243490945676379e-18,   1.236395351281775e-19,   2.469331713390177e-01,  -1.959897516972108e-03,   1.555544840235411e-05,
  -1.234488849560707e-07,   9.787852412652350e-10,  -7.707917961112319e-12,   5.824173739486272e-14,  -3.442017184360732e-16,  -1.262428361356785e-18,   1.241593334280570e-19,
   2.469338293462598e-01,  -1.959913180075767e-03,   1.555569676168114e-05,  -1.234521444043057e-07,   9.788221736538136e-10,  -7.708223071354556e-12,   5.824022231053893e-14,
  -3.440119829060389e-16,  -1.269544383651718e-18,   1.243546126485061e-19,   2.469339384207179e-01,  -1.959915776472729e-03,   1.555573793109643e-05,  -1.234526847086535e-07,
   9.788282956944566e-10,  -7.708273642301296e-12,   5.823997089181890e-14,  -3.439805219407237e-16,  -1.270724221256379e-18,   1.243869877103462e-19,   3.558364872165520e-01,
  -2.823926725570059e-03,   2.240918463596929e-05,  -1.777983190365492e-07,   1.409249778460104e-09,  -1.109102296114592e-11,   8.360295519964542e-14,  -4.855440650268195e-16,
  -2.207149800516696e-18,   1.923072806022000e-19,   3.558396786299652e-01,  -2.824002687397326e-03,   2.241038892595903e-05,  -1.778141144759367e-07,   1.409428123238469e-09,
  -1.109245773795310e-11,   8.359337451999035e-14,  -4.845307881365265e-16,  -2.244929714254040e-18,   1.933509976501417e-19,   3.558449179757785e-01,  -2.824127395911230e-03,
   2.241236607296906e-05,  -1.778400467158118e-07,   1.409720889862846e-09,  -1.109481094933557e-11,   8.357753687576254e-14,  -4.828634502274551e-16,  -2.307056149140838e-18,
   1.950664275083838e-19,   3.558504774954452e-01,  -2.824259727917083e-03,   2.241446412837990e-05,  -1.778675648229783e-07,   1.410031517138415e-09,  -1.109730488443637e-11,
   8.356058305021360e-14,  -4.810889986395598e-16,  -2.373119289879571e-18,   1.968893467521592e-19,   3.558548529888784e-01,  -2.824363878704697e-03,   2.241611541734279e-05,
  -1.778892231624174e-07,   1.410275967347089e-09,  -1.109926544581869e-11,   8.354713239054692e-14,  -4.796886718778430e-16,  -2.425214312222318e-18,   1.983259585218295e-19,
   3.558573782207017e-01,  -2.824423988086456e-03,   2.241706845191616e-05,  -1.779017231923288e-07,   1.410417038269889e-09,  -1.110039604962415e-11,   8.353932645328422e-14,
  -4.788789820056737e-16,  -2.455320659876223e-18,   1.991558423672038e-19,   3.558583264796244e-01,  -2.824446560121001e-03,   2.241742633408259e-05,  -1.779064171872025e-07,
   1.410470010653519e-09,  -1.110082043716247e-11,   8.353638705723036e-14,  -4.785746453559790e-16,  -2.466633698605184e-18,   1.994676207180559e-19,   3.558584836676026e-01,
  -2.824450301778019e-03,   2.241748565860729e-05,  -1.779071952898091e-07,   1.410478791523568e-09,  -1.110089077674071e-11,   8.353589937812999e-14,  -4.785241818955332e-16,
  -2.468509408529180e-18,   1.995193102864357e-19,   4.940368813322774e-01,  -3.920688148619480e-03,   3.111247677312479e-05,  -2.468490705355950e-07,   1.956342205956820e-09,
  -1.538349166760716e-11,   1.152797965569883e-13,  -6.391880434882892e-16,  -4.374679491654244e-18,   3.092414362660142e-19,   4.940413122282647e-01,  -3.920793611329303e-03,
   3.111414857718243e-05,  -2.468709782574839e-07,   1.956588059640052e-09,  -1.538537572352402e-11,   1.152611130826362e-13,  -6.375587306420537e-16,  -4.434854671982865e-18,
   3.109160518474339e-19,   4.940485864335336e-01,  -3.920966752204833e-03,   3.111689326584932e-05,  -2.469069452565925e-07,   1.956991638767368e-09,  -1.538846515756487e-11,
   1.152302668484790e-13,  -6.348777233583833e-16,  -4.533812717910168e-18,   3.136685917238310e-19,   4.940563051618880e-01,  -3.921150477256486e-03,   3.111980579888641e-05,
  -2.469451116410091e-07,   1.957419827196721e-09,  -1.539173845551115e-11,   1.151972994674852e-13,  -6.320244980834467e-16,  -4.639046999636840e-18,   3.165938507194194e-19,
   4.940623800113580e-01,  -3.921295076499812e-03,   3.112209812700279e-05,  -2.469751506804533e-07,   1.957756784506429e-09,  -1.539431105506125e-11,   1.151711820547142e-13,
  -6.297728573440772e-16,  -4.722035079115548e-18,   3.188993746844517e-19,   4.940658859938026e-01,  -3.921378530221356e-03,   3.112342113423315e-05,  -2.469924875563453e-07,
   1.957951237401931e-09,  -1.539579434641737e-11,   1.151560402046731e-13,  -6.284709294651715e-16,  -4.769996545800990e-18,   3.202312717824126e-19,   4.940672025379316e-01,
  -3.921409868428450e-03,   3.112391794791587e-05,  -2.469989978690045e-07,   1.958024254171052e-09,  -1.539635107106554e-11,   1.151503412430455e-13,  -6.279815770484897e-16,
  -4.788019299737194e-18,   3.207316644806867e-19,   4.940674207746441e-01,  -3.921415063211474e-03,   3.112400030249181e-05,  -2.470000770540766e-07,   1.958036357628097e-09,
  -1.539644334210623e-11,   1.151493958701241e-13,  -6.279004353158220e-16,  -4.791007501661365e-18,   3.208146250302545e-19,   6.728651396258186e-01,  -5.339873020689111e-03,
   4.237431173693119e-05,  -3.361955426516712e-07,   2.663963185919846e-09,  -2.091795846358958e-11,   1.552049016152022e-13,  -7.902132332449634e-16,  -9.012251532961897e-18,
   5.212080594905202e-19,   6.728711743796578e-01,  -5.340016655215655e-03,   4.237658822041536e-05,  -3.362253299692326e-07,   2.664294033413772e-09,  -2.092027593319881e-11,
   1.551668972823495e-13,  -7.874666386844301e-16,  -9.112878869346803e-18,   5.240480346864067e-19,   6.728810816395147e-01,  -5.340252463740301e-03,   4.238032564063286e-05,
  -3.362742330385716e-07,   2.664837113381445e-09,  -2.092407445214332e-11,   1.551042154962028e-13,  -7.829470955979377e-16,  -9.278373093202827e-18,   5.287165879886152e-19,
   6.728915943270500e-01,  -5.340502687319775e-03,   4.238429160979528e-05,  -3.363261261881987e-07,   2.665413281765112e-09,  -2.092809683104099e-11,   1.550373085979290e-13,
  -7.781371414243417e-16,  -9.454380683978882e-18,   5.336788092193691e-19,   6.728998680984507e-01,  -5.340699623649616e-03,   4.238741304923893e-05,  -3.363669686936382e-07,
   2.665866670154269e-09,  -2.093125655851461e-11,   1.549843649390999e-13,  -7.743412681415387e-16,  -9.593193277546730e-18,   5.375902743339195e-19,   6.729046431463429e-01,
  -5.340813283087550e-03,   4.238921457349472e-05,  -3.363905406328765e-07,   2.666128305682284e-09,  -2.093307772840767e-11,   1.549536947202132e-13,  -7.721464176625483e-16,
  -9.673422517409409e-18,   5.398501304002836e-19,   6.729064362418172e-01,  -5.340855964023026e-03,   4.238989107898456e-05,  -3.363993923062649e-07,   2.666226547922949e-09,
  -2.093376114735213e-11,   1.549421559220093e-13,  -7.713214394444946e-16,  -9.703571661971337e-18,   5.406991961934858e-19,   6.729067334739818e-01,  -5.340863039035213e-03,
   4.239000322025563e-05,  -3.364008596071019e-07,   2.666242832742881e-09,  -2.093387441015674e-11,   1.549402420492666e-13,  -7.711846458086719e-16,  -9.708570489070886e-18,
   5.408399656562048e-19,   9.214861110063237e-01,  -7.312933806533641e-03,   5.803129650394422e-05,  -4.604011509158161e-07,   3.646841106159516e-09,  -2.855166764135192e-11,
   2.073909397334464e-13,  -8.472429512813125e-16,  -2.149856457018418e-17,   1.022714547492390e-18,   9.214943755530481e-01,  -7.313130505554811e-03,   5.803441283926111e-05,
  -4.604418026035217e-07,   3.647282732537153e-09,  -2.855411306188795e-11,   2.073011592116156e-13,  -8.418481390962084e-16,  -2.169635646620638e-17,   1.028487177200239e-18,
   9.215079434653963e-01,  -7.313453431390748e-03,   5.803952908039532e-05,  -4.605085414091116e-07,   3.648007593010640e-09,  -2.855811586116878e-11,   2.071531966049420e-13,
  -8.329701915869689e-16,  -2.202170814278430e-17,   1.037979052729646e-18,   9.215223405058648e-01,  -7.313796097731253e-03,   5.804495817779960e-05,  -4.605793598056011e-07,
   3.648776534288534e-09,  -2.856234713985525e-11,   2.069954165875460e-13,  -8.235207650944916e-16,  -2.236780768158902e-17,   1.048071288065880e-18,   9.215336713686713e-01,
  -7.314065790301925e-03,   5.804923117394271e-05,  -4.606350966874062e-07,   3.649381555929556e-09,  -2.856566557330799e-11,   2.068706771533688e-13,  -8.160628233263028e-16,
  -2.264082478476650e-17,   1.056028864925939e-18,   9.215402107579619e-01,  -7.314221440112824e-03,   5.805169731097166e-05,  -4.606672645047917e-07,   3.649730669830487e-09,
  -2.856757604760556e-11,   2.067984605486625e-13,  -8.117501959011260e-16,  -2.279864297910333e-17,   1.060627325937172e-18,   9.215426663876342e-01,  -7.314279889101089e-03,
   5.805262339024714e-05,  -4.606793440237938e-07,   3.649861754987493e-09,  -2.856829256839897e-11,   2.067712995513705e-13,  -8.101291532348876e-16,  -2.285795343848462e-17,
   1.062355225680238e-18,   9.215430734446660e-01,  -7.314289577906924e-03,   5.805277690221353e-05,  -4.606813463866580e-07,   3.649883483669850e-09,  -2.856841129546463e-11,
   2.067667949610291e-13,  -8.098603573475744e-16,  -2.286778753712254e-17,   1.062641709512212e-18,   1.852175130960536e-03,  -1.424668834331500e-05,   1.095770807402147e-07,
  -8.427307447864153e-10,   6.479168937317130e-12,  -4.971007087022593e-14,   3.764824804155193e-16,  -2.653791888632301e-18,   1.186938884167647e-20,   1.668032078195547e-22,
   1.852190735718474e-03,  -1.424704837381468e-05,   1.095826174969209e-07,  -8.428015526932054e-10,   6.479973127934145e-12,  -4.971798714458655e-14,   3.765286845998923e-16,
  -2.652892621231689e-18,   1.181701146395942e-20,   1.684646879823677e-22,   1.852216354025136e-03,  -1.424763944403084e-05,   1.095917074758842e-07,  -8.429178034718164e-10,
   6.481293407726986e-12,  -4.973098101886322e-14,   3.766043843138665e-16,  -2.651410142260681e-18,   1.173083631583650e-20,   1.711967366955606e-22,   1.852243537804699e-03,
  -1.424826664495815e-05,   1.096013533213107e-07,  -8.430411655950797e-10,   6.482694422652706e-12,  -4.974476583730705e-14,   3.766845007716969e-16,  -2.649828701091035e-18,
   1.163914048850773e-20,   1.741017145239294e-22,   1.852264932144107e-03,  -1.424876027692195e-05,   1.096089451412415e-07,  -8.431382602430440e-10,   6.483797098184830e-12,
  -4.975561261102278e-14,   3.767474028876988e-16,  -2.648577997722033e-18,   1.156678892567268e-20,   1.763923381118357e-22,   1.852277279461041e-03,  -1.424904517021499e-05,
   1.096133267249575e-07,  -8.431942986730321e-10,   6.484433501591663e-12,  -4.976187171233721e-14,   3.767836447407874e-16,  -2.647853744471758e-18,   1.152495863116805e-20,
   1.777160621415943e-22,   1.852281916043917e-03,  -1.424915215211145e-05,   1.096149720902562e-07,  -8.432153422674278e-10,   6.484672482648847e-12,  -4.976422191872824e-14,
   3.767972425315721e-16,  -2.647581317219426e-18,   1.150923679723990e-20,   1.782134664438977e-22,   1.852282684626142e-03,  -1.424916988597820e-05,   1.096152448350601e-07,
  -8.432188305764173e-10,   6.484712097456639e-12,  -4.976461149124397e-14,   3.767994959591717e-16,  -2.647536134073109e-18,   1.150662993201283e-20,   1.782959358825816e-22,
   1.673539343653728e-02,  -1.287264527147333e-04,   9.900875444586408e-07,  -7.614521406114280e-09,   5.854260747111913e-11,  -4.491472821164397e-13,   3.401199052606813e-15,
  -2.395514783006166e-17,   1.063592136430961e-19,   1.536304693391148e-21,   1.673553443387298e-02,  -1.287297057821223e-04,   9.901375718827939e-07,  -7.615161178873322e-09,
   5.854987260672002e-11,  -4.492187378479644e-13,   3.401612883659810e-15,  -2.394686869621484e-17,   1.058804874072257e-19,   1.551482024828941e-21,   1.673576590897813e-02,
  -1.287350464164434e-04,   9.902197044837568e-07,  -7.616211542872804e-09,   5.856180013612549e-11,  -4.493360258492461e-13,   3.402290865655165e-15,  -2.393322064963718e-17,
   1.050928516510544e-19,   1.576438876698727e-21,   1.673601152896836e-02,  -1.287407135109835e-04,   9.903068596210463e-07,  -7.617326160108883e-09,   5.857445702655851e-11,
  -4.494604527540835e-13,   3.403008366909934e-15,  -2.391866213422155e-17,   1.042547574347557e-19,   1.602975496297343e-21,   1.673620483826973e-02,  -1.287451737387706e-04,
   9.903754555887674e-07,  -7.618203442019554e-09,   5.858441868749786e-11,  -4.495583594243713e-13,   3.403571673567378e-15,  -2.390714877513738e-17,   1.035934687598585e-19,
   1.623900127177072e-21,   1.673631640288337e-02,  -1.287477479014550e-04,   9.904150454335923e-07,  -7.618709767539369e-09,   5.859016800570762e-11,  -4.496148560625578e-13,
   3.403896218739390e-15,  -2.390048182921918e-17,   1.032111425933782e-19,   1.635992246729983e-21,   1.673635829688997e-02,  -1.287487145398857e-04,   9.904299121486525e-07,
  -7.618899903283083e-09,   5.859232697887200e-11,  -4.496360697460666e-13,   3.404017984616575e-15,  -2.389797409565727e-17,   1.030674460667661e-19,   1.640536002410687e-21,
   1.673636524144153e-02,  -1.287488747748197e-04,   9.904323765371271e-07,  -7.618931421293048e-09,   5.859268486205594e-11,  -4.496395861456466e-13,   3.404038163561839e-15,
  -2.389755817975912e-17,   1.030436194908727e-19,   1.641289355575265e-21,   4.686264351342824e-02,  -3.604613108058859e-04,   2.772454571827800e-06,  -2.132226084766609e-08,
   1.639308139532246e-10,  -1.257650437589189e-12,   9.521043300029357e-15,  -6.694396234740209e-17,   2.926601966553976e-19,   4.471973034611790e-21,   4.686303833579381e-02,
  -3.604704200782177e-04,   2.772594658416220e-06,  -2.132405226210956e-08,   1.639511511408758e-10,  -1.257850109375592e-12,   9.522180856716810e-15,  -6.691988214622493e-17,
   2.912877274080395e-19,   4.515437564996305e-21,   4.686368651505277e-02,  -3.604853749766413e-04,   2.772824645785216e-06,  -2.132699336414832e-08,   1.639845396666315e-10,
  -1.258177850159790e-12,   9.524044358967996e-15,  -6.688018876814218e-17,   2.890296402191410e-19,   4.586908866785384e-21,   4.686437430298198e-02,  -3.605012440322470e-04,
   2.773068697233960e-06,  -2.133011437973476e-08,   1.640199698356953e-10,  -1.258525536554165e-12,   9.526016260286823e-15,  -6.683785084500580e-17,   2.866268934956287e-19,
   4.662904818280354e-21,   4.686491560991689e-02,  -3.605137336073048e-04,   2.773260779370049e-06,  -2.133257083739339e-08,   1.640478552729605e-10,  -1.258799115358801e-12,
   9.527564227588185e-15,  -6.680437107182423e-17,   2.847310341226188e-19,   4.722829452407274e-21,   4.686522801443452e-02,  -3.605209418037345e-04,   2.773371638682932e-06,
  -2.133398858810384e-08,   1.640639491878807e-10,  -1.258956982056462e-12,   9.528456012652763e-15,  -6.678498520051925e-17,   2.836349371423045e-19,   4.757459406142437e-21,
   4.686534532651490e-02,  -3.605236485944597e-04,   2.773413268394069e-06,  -2.133452098289520e-08,   1.640699927421090e-10,  -1.259016258599827e-12,   9.528790588474767e-15,
  -6.677769350156801e-17,   2.832229713148533e-19,   4.770472045781924e-21,   4.686536477272824e-02,  -3.605240972859450e-04,   2.773420169163988e-06,  -2.133460923575965e-08,
   1.640709945545386e-10,  -1.259026084325706e-12,   9.528846033461747e-15,  -6.677648415897932e-17,   2.831546625322836e-19,   4.772629538566497e-21,   9.300601799117754e-02,
  -7.153900967135525e-04,   5.502355955444387e-06,  -4.231722432485460e-08,   3.253427634416992e-10,  -2.495816944262211e-12,   1.888631212776120e-14,  -1.324291743342314e-16,
   5.643565028782234e-19,   9.418094752159723e-21,   9.300680157594853e-02,  -7.154081754296592e-04,   5.502633976013470e-06,  -4.232077938949533e-08,   3.253831042844410e-10,
  -2.496211888430460e-12,   1.888850201887009e-14,  -1.323785194329335e-16,   5.615304317117472e-19,   9.507452337772552e-21,   9.300808798583907e-02,  -7.154378556667169e-04,
   5.503090416691180e-06,  -4.232661600952604e-08,   3.254493336558676e-10,  -2.496860142233119e-12,   1.889208888187627e-14,  -1.322950285012397e-16,   5.568807714491297e-19,
   9.654389585467135e-21,   9.300945300513311e-02,  -7.154693501855827e-04,   5.503574769397163e-06,  -4.233280966632414e-08,   3.255196126829399e-10,  -2.497547838411560e-12,
   1.889588366322158e-14,  -1.322059854893480e-16,   5.519332398857872e-19,   9.810630760253299e-21,   9.301052731071277e-02,  -7.154941376187941e-04,   5.503955982045863e-06,
  -4.233768450627872e-08,   3.255749259320182e-10,  -2.498088949127486e-12,   1.889886208498685e-14,  -1.321355800294240e-16,   5.480294469797003e-19,   9.933831941233336e-21,
   9.301114732478369e-02,  -7.155084433646923e-04,   5.504175997150594e-06,  -4.234049803186844e-08,   3.256068496048598e-10,  -2.498401190590782e-12,   1.890057774292254e-14,
  -1.320948159984824e-16,   5.457724567089980e-19,   1.000502939692196e-20,   9.301138014837111e-02,  -7.155138153964685e-04,   5.504258616868392e-06,  -4.234155456896868e-08,
   3.256188375098259e-10,  -2.498518432015299e-12,   1.890122137522543e-14,  -1.320794837985501e-16,   5.449241714343883e-19,   1.003178282981641e-20,   9.301141874232613e-02,
  -7.155147058919520e-04,   5.504272312367244e-06,  -4.234172970671259e-08,   3.256208246897635e-10,  -2.498537866018791e-12,   1.890132803407252e-14,  -1.320769409529412e-16,
   5.447835157493370e-19,   1.003621854813641e-20,   1.564681318973900e-01,  -1.203532352276143e-03,   9.256855706607774e-06,  -7.119205275449802e-08,   5.473316559577230e-10,
  -4.198376858668280e-12,   3.174945618835039e-14,  -2.217236668176692e-16,   9.085614240042941e-19,   1.719524067897040e-20,   1.564694501565412e-01,  -1.203562766861056e-03,
   9.257323426745956e-06,  -7.119803293374405e-08,   5.473994702851752e-10,  -4.199037985318587e-12,   3.175297213205820e-14,  -2.216313187827748e-16,   9.035517918329211e-19,
   1.735333200799895e-20,   1.564716143405231e-01,  -1.203612699172681e-03,   9.258091306937195e-06,  -7.120785104551250e-08,   5.475108038510744e-10,  -4.200123129490913e-12,
   3.175872959102444e-14,  -2.214791258762230e-16,   8.953095666649321e-19,   1.761329660103267e-20,   1.564739107725637e-01,  -1.203665683726645e-03,   9.258906144102964e-06,
  -7.121826974461928e-08,   5.476289446587108e-10,  -4.201274275792842e-12,   3.176481892147300e-14,  -2.213168365157566e-16,   8.865393062028711e-19,   1.788972652958486e-20,
   1.564757181241259e-01,  -1.203707384668060e-03,   9.259547466459027e-06,  -7.122646998426850e-08,   5.477219273632904e-10,  -4.202180033937023e-12,   3.176959691376311e-14,
  -2.211885333524567e-16,   8.796192230481280e-19,   1.810770375248205e-20,   1.564767612010871e-01,  -1.203731451825981e-03,   9.259917602656945e-06,  -7.123120277094252e-08,
   5.477755916088765e-10,  -4.202702684304292e-12,   3.177234862981078e-14,  -2.211142541332680e-16,   8.756183509195414e-19,   1.823367323762950e-20,   1.564771528904559e-01,
  -1.203740489420931e-03,   9.260056595603432e-06,  -7.123298003005649e-08,   5.477957434648838e-10,  -4.202898929502112e-12,   3.177338083758035e-14,  -2.210863174898037e-16,
   8.741146303619860e-19,   1.828100827562242e-20,   1.564772178187651e-01,  -1.203741987538928e-03,   9.260079635838610e-06,  -7.123327463886614e-08,   5.477990839444615e-10,
  -4.202931459149617e-12,   3.177355188332333e-14,  -2.210816842663498e-16,   8.738652957495836e-19,   1.828885643682551e-20,   2.393202486967725e-01,  -1.840819960628853e-03,
   1.415849177402431e-05,  -1.088890846076165e-07,   8.371367126398451e-10,  -6.420504138707405e-12,   4.850914335712876e-14,  -3.367868379549752e-16,   1.299660309427089e-18,
   2.928572732779018e-20,   2.393222649927689e-01,  -1.840866480090235e-03,   1.415920714529973e-05,  -1.088982299307306e-07,   8.372403199848183e-10,  -6.421508087561211e-12,
   4.851415063448618e-14,  -3.366298291870474e-16,   1.291431141118489e-18,   2.954486807868423e-20,   2.393255751427439e-01,  -1.840942852141185e-03,   1.416038160702044e-05,
  -1.089132444907512e-07,   8.374104158486254e-10,  -6.423155888434047e-12,   4.852234701963492e-14,  -3.363711088970364e-16,   1.277891843946359e-18,   2.997100605607987e-20,
   2.393290875679909e-01,  -1.841023892631645e-03,   1.416162788866160e-05,  -1.089291775018841e-07,   8.375909110691378e-10,  -6.424903864321060e-12,   4.853101152771800e-14,
  -3.360952737099826e-16,   1.263485090449051e-18,   3.042414545150194e-20,   2.393318519377358e-01,  -1.841087674705253e-03,   1.416260878184415e-05,  -1.089417178806870e-07,
   8.377329692431795e-10,  -6.426279190640998e-12,   4.853780698024534e-14,  -3.358772381976920e-16,   1.252117542586019e-18,   3.078147401159448e-20,   2.393334473386817e-01,
  -1.841124485702280e-03,   1.416317489972778e-05,  -1.089489555854551e-07,   8.378149567892137e-10,  -6.427072781812131e-12,   4.854171931217497e-14,  -3.357510237450595e-16,
   1.245545332474749e-18,   3.098797817351429e-20,   2.393340464331038e-01,  -1.841138308808487e-03,   1.416338748739459e-05,  -1.089516734924768e-07,   8.378457444936625e-10,
  -6.427370757344987e-12,   4.854318664286285e-14,  -3.357035567358713e-16,   1.243075175476046e-18,   3.106557601245149e-20,   2.393341457418698e-01,  -1.841140600197321e-03,
   1.416342272709504e-05,  -1.089521240285264e-07,   8.378508480261877e-10,  -6.427420149690497e-12,   4.854342977952170e-14,  -3.356956845882618e-16,   1.242665594101630e-18,
   3.107844178610825e-20,   3.448863343855249e-01,  -2.652820425216531e-03,   2.040391302542821e-05,  -1.569205656738854e-07,   1.206373719517815e-09,  -9.250624943722865e-12,
   6.979862869125278e-14,  -4.804564295623628e-16,   1.684184257075769e-18,   4.850083424435699e-20,   3.448892400853706e-01,  -2.652887464617935e-03,   2.040494392512132e-05,
  -1.569337420764147e-07,   1.206522788474406e-09,  -9.252056596037718e-12,   6.980506747820067e-14,  -4.801969031422901e-16,   1.671120875944478e-18,   4.891142011208653e-20,
   3.448940103682469e-01,  -2.652997524717161e-03,   2.040663640588276e-05,  -1.569553747451278e-07,   1.206767519088305e-09,  -9.254406317278009e-12,   6.981559989390835e-14,
  -4.797693194357294e-16,   1.649627758023112e-18,   4.958661803700281e-20,   3.448990721515870e-01,  -2.653114312523854e-03,   2.040843238392589e-05,  -1.569783306782213e-07,
   1.207027210467053e-09,  -9.256898779706013e-12,   6.982672402291149e-14,  -4.793135395582904e-16,   1.626757339408344e-18,   5.030462519238613e-20,   3.449030559063222e-01,
  -2.653206229149297e-03,   2.040984591869764e-05,  -1.569963985657626e-07,   1.207231598538639e-09,  -9.258859799330725e-12,   6.983544136767898e-14,  -4.789533301955378e-16,
   1.608711416078145e-18,   5.087083771823166e-20,   3.449053550510301e-01,  -2.653259277637857e-03,   2.041066173357913e-05,  -1.570068264771466e-07,   1.207349558728014e-09,
  -9.259991316592581e-12,   6.984045730523349e-14,  -4.787448411561405e-16,   1.598277994153744e-18,   5.119806599052558e-20,   3.449062184106597e-01,  -2.653279198176501e-03,
   2.041096808704523e-05,  -1.570107423712153e-07,   1.207393854676268e-09,  -9.260416169896112e-12,   6.984233799980567e-14,  -4.786664369921464e-16,   1.594356591768007e-18,
   5.132102965660272e-20,   3.449063615252945e-01,  -2.653282500306940e-03,   2.041101886987951e-05,  -1.570113914924927e-07,   1.207401197401912e-09,  -9.260486593159496e-12,
   6.984264960197894e-14,  -4.786534343398410e-16,   1.593706375943375e-18,   5.134141719194519e-20,   4.788338894362111e-01,  -3.683127401973041e-03,   2.832841354756409e-05,
  -2.178648886619903e-07,   1.674843800539776e-09,  -1.283921664754361e-11,   9.668114253005838e-14,  -6.567872837561680e-16,   1.938992787854495e-18,   8.076782876290413e-20,
   4.788379236557475e-01,  -3.683220477907594e-03,   2.832984477284874e-05,  -2.178831763174303e-07,   1.675050263117137e-09,  -1.284117249828442e-11,   9.668843691623672e-14,
  -6.563559761659565e-16,   1.918260138659960e-18,   8.141889382357421e-20,   4.788445466276225e-01,  -3.683373282769307e-03,   2.833219448830127e-05,  -2.179132004732856e-07,
   1.675389215885693e-09,  -1.284438240082025e-11,   9.670035168524759e-14,  -6.556454899131522e-16,   1.884148180416796e-18,   8.248960266176257e-20,   4.788515743133024e-01,
  -3.683535428219681e-03,   2.833468789132221e-05,  -2.179450611541910e-07,   1.675748885916117e-09,  -1.284778707101224e-11,   9.671291231123013e-14,  -6.548883094081631e-16,
   1.847849433044941e-18,   8.362826386077748e-20,   4.788571052841465e-01,  -3.683663043103674e-03,   2.833665033809686e-05,  -2.179701376544430e-07,   1.676031958901426e-09,
  -1.285046563207081e-11,   9.672273822265977e-14,  -6.542900122974935e-16,   1.819207250103187e-18,   8.452624791243384e-20,   4.788602973738160e-01,  -3.683736694378503e-03,
   2.833778295481093e-05,  -2.179846105854235e-07,   1.676195330165050e-09,  -1.285201110758555e-11,   9.672838511972825e-14,  -6.539437634809770e-16,   1.802647248686463e-18,
   8.504523459304398e-20,   4.788614960462370e-01,  -3.683764351586059e-03,   2.833820827315820e-05,  -2.179900454646664e-07,   1.676256678511858e-09,  -1.285259137814528e-11,
   9.673050107816274e-14,  -6.538135620665438e-16,   1.796423123363666e-18,   8.524025962939936e-20,   4.788616947439291e-01,  -3.683768936186326e-03,   2.833827877626379e-05,
  -2.179909463815937e-07,   1.676266847921307e-09,  -1.285268756255584e-11,   9.673085159067551e-14,  -6.537919697384556e-16,   1.795391085782920e-18,   8.527259522701787e-20,
   6.521590683206329e-01,  -5.016321834325863e-03,   3.858253386846763e-05,  -2.967245410925724e-07,   2.280952894698091e-09,  -1.747737280741630e-11,   1.311701610302655e-13,
  -8.712604427621992e-16,   1.726020079598307e-18,   1.411753734570350e-19,   6.521645628183921e-01,  -5.016448600522837e-03,   3.858448303344874e-05,  -2.967494345482036e-07,
   2.281232964022686e-09,  -1.747996444707537e-11,   1.311763229135837e-13,  -8.705080681673448e-16,   1.691656793309567e-18,   1.422569798995739e-19,   6.521735831267176e-01,
  -5.016656715444108e-03,   3.858768307618454e-05,  -2.967903038462917e-07,   2.281692752283919e-09,  -1.748421739895606e-11,   1.311863389387731e-13,  -8.692688937263541e-16,
   1.635115629022522e-18,   1.440358790933811e-19,   6.521831546442656e-01,  -5.016877551917182e-03,   3.859107880394359e-05,  -2.968336729472557e-07,   2.282180635501853e-09,
  -1.748872787040511e-11,   1.311968310061603e-13,  -8.679485503800230e-16,   1.574946593740174e-18,   1.459278713496969e-19,   6.521906876767326e-01,  -5.017051358953560e-03,
   3.859375142975266e-05,  -2.968678072757187e-07,   2.282564611023808e-09,  -1.749227601012052e-11,   1.312049899007274e-13,  -8.669054577866481e-16,   1.527466783970840e-18,
   1.474200976987102e-19,   6.521950352163897e-01,  -5.017151669428182e-03,   3.859529392260221e-05,  -2.968875079133834e-07,   2.282786214337800e-09,  -1.749432305830059e-11,
   1.312096590549142e-13,  -8.663018733742330e-16,   1.500014522893035e-18,   1.482825814453020e-19,   6.521966677757545e-01,  -5.017189337582589e-03,   3.859587315690261e-05,
  -2.968949058970153e-07,   2.282869429250746e-09,  -1.749509162174542e-11,   1.312114048958985e-13,  -8.660749196953191e-16,   1.489696331557236e-18,   1.486066967042265e-19,
   6.521969383966282e-01,  -5.017195581648621e-03,   3.859596917395931e-05,  -2.968961322291552e-07,   2.282883223348701e-09,  -1.749521901561852e-11,   1.312116938996520e-13,
  -8.660372829518491e-16,   1.487985437386275e-18,   1.486604363234346e-19,   8.931292313654330e-01,  -6.869832434913791e-03,   5.283858675960331e-05,  -4.063586215668732e-07,
   3.123376764887501e-09,  -2.390964478369735e-11,   1.782218994025057e-13,  -1.127063569624786e-15,  -2.906017088837379e-19,   2.859862046312364e-19,   8.931367560518928e-01,
  -6.870006038678489e-03,   5.284125579163304e-05,  -4.063926749567420e-07,   3.123757167141211e-09,  -2.391298852946261e-11,   1.782193699815573e-13,  -1.125541871109186e-15,
  -3.564466324657702e-19,   2.880865995498870e-19,   8.931491093177757e-01,  -6.870291047877770e-03,   5.284563767455585e-05,  -4.064485825382160e-07,   3.124381654388051e-09,
  -2.391847450556331e-11,   1.782150264092110e-13,  -1.123035926443928e-15,  -4.647999681974041e-19,   2.915417116216334e-19,   8.931622174618037e-01,  -6.870593478969993e-03,
   5.285028751025441e-05,  -4.065079094642182e-07,   3.125044277186694e-09,  -2.392429102365193e-11,   1.782101573861900e-13,  -1.120366269194653e-15,  -5.801225838186497e-19,
   2.952173381075839e-19,   8.931725339109658e-01,  -6.870831504186060e-03,   5.285394718653303e-05,  -4.065546034400525e-07,   3.125565760024018e-09,  -2.392886536925968e-11,
   1.782061367558570e-13,  -1.118257508270576e-15,  -6.711367793585188e-19,   2.981169490868822e-19,   8.931784878441176e-01,  -6.870968877344601e-03,   5.285605934993289e-05,
  -4.065815527982918e-07,   3.125866716005632e-09,  -2.393150399447122e-11,   1.782037406314294e-13,  -1.117037400198212e-15,  -7.237650436738849e-19,   2.997931284869283e-19,
   8.931807236257501e-01,  -6.871020463116436e-03,   5.285685250580579e-05,  -4.065916728057225e-07,   3.125979727593710e-09,  -2.393249457486677e-11,   1.782028265345575e-13,
  -1.116578650941288e-15,  -7.435468075294405e-19,   3.004230718877909e-19,   8.931810942396411e-01,  -6.871029014237906e-03,   5.285698398366867e-05,  -4.065933503552833e-07,
   3.125998460862114e-09,  -2.393265876457122e-11,   1.782026742537247e-13,  -1.116502575732028e-15,  -7.468269379296778e-19,   3.005275215334294e-19,   1.796879955593248e-03,
  -1.340883293104317e-05,   1.000550265819944e-07,  -7.465511592396136e-10,   5.569543145871670e-12,  -4.151950642853803e-14,   3.080470203071071e-16,  -2.224524630395127e-18,
   1.388615299123836e-20,  -1.767573068363483e-23,   1.796894203729369e-03,  -1.340915185913935e-05,   1.000597858330786e-07,  -7.466103006866849e-10,   5.570201359328387e-12,
  -4.152615548203075e-14,   3.081020420082021e-16,  -2.224599431270447e-18,   1.387132743383456e-20,  -1.709097509177706e-23,   1.796917594841589e-03,  -1.340967544950360e-05,
   1.000675993206369e-07,  -7.467073977860786e-10,   5.571282008002180e-12,  -4.153707113102686e-14,   3.081923259069476e-16,  -2.224720048173013e-18,   1.384691347788788e-20,
  -1.612894419106574e-23,   1.796942415286735e-03,  -1.341023104419324e-05,   1.000758905875784e-07,  -7.468104346130801e-10,   5.572428774928805e-12,  -4.154865368174395e-14,
   3.082880653667720e-16,  -2.224845063872496e-18,   1.382090578942480e-20,  -1.510535322606081e-23,   1.796961949590628e-03,  -1.341066831812417e-05,   1.000824162584709e-07,
  -7.468915318710825e-10,   5.573331369879315e-12,  -4.155776935531706e-14,   3.083633702051557e-16,  -2.224941299551022e-18,   1.380036323159317e-20,  -1.429775146160485e-23,
   1.796973223413061e-03,  -1.341092068467229e-05,   1.000861825111937e-07,  -7.469383373837312e-10,   5.573852308477735e-12,  -4.156303024635709e-14,   3.084068129848700e-16,
  -2.224995975192014e-18,   1.378847787908231e-20,  -1.383085428992840e-23,   1.796977456882099e-03,  -1.341101545218379e-05,   1.000875968068692e-07,  -7.469559138293503e-10,
   5.574047932413961e-12,  -4.156500577405751e-14,   3.084231229420232e-16,  -2.225016343032347e-18,   1.378400916732838e-20,  -1.365537576243968e-23,   1.796978158642119e-03,
  -1.341103116132722e-05,   1.000878312482212e-07,  -7.469588274037119e-10,   5.574080360214486e-12,  -4.156533324661897e-14,   3.084258263799365e-16,  -2.225019710669832e-18,
   1.378326811657531e-20,  -1.362627955911153e-23,   1.623577193798553e-02,  -1.211559807885982e-04,   9.040507019822686e-07,  -6.745488735579496e-09,   5.032376230857949e-11,
  -3.751482748905643e-13,   2.783223262309261e-15,  -2.009304417964082e-17,   1.252039454704655e-19,  -1.506655557065752e-22,   1.623590067751911e-02,  -1.211588624743918e-04,
   9.040937043262478e-07,  -6.746023106205677e-09,   5.032970929382717e-11,  -3.752083317777656e-13,   2.783719320242005e-15,  -2.009367217702503e-17,   1.250682054871301e-19,
  -1.453250094110698e-22,   1.623611202873386e-02,  -1.211635933931537e-04,   9.041643033076333e-07,  -6.746900423875628e-09,   5.033947299671161e-11,  -3.753069261431431e-13,
   2.784533284755737e-15,  -2.009468321877956e-17,   1.248446777182935e-19,  -1.365388155041490e-22,   1.623633629473639e-02,  -1.211686134880978e-04,   9.042392192774804e-07,
  -6.747831409731319e-09,   5.034983407832189e-11,  -3.754115440814069e-13,   2.785396426267626e-15,  -2.009572890406529e-17,   1.246065605488628e-19,  -1.271903829932746e-22,
   1.623651279762425e-02,  -1.211725644917523e-04,   9.042981821556031e-07,  -6.748564161313076e-09,   5.035798905545055e-11,  -3.754938801582659e-13,   2.786075332970042e-15,
  -2.009653220661016e-17,   1.244184819052234e-19,  -1.198145655784206e-22,   1.623661466264219e-02,  -1.211748447583840e-04,   9.043322122351781e-07,  -6.748987070959924e-09,
   5.036269575335259e-11,  -3.755413983970245e-13,   2.786466986607652e-15,  -2.009698791865973e-17,   1.243096655245399e-19,  -1.155503954798161e-22,   1.623665291430014e-02,
  -1.211757010334959e-04,   9.043449911424540e-07,  -6.749145882345892e-09,   5.036446322212524e-11,  -3.755592420579559e-13,   2.786614026792216e-15,  -2.009715755067201e-17,
   1.242687523508531e-19,  -1.139477500488977e-22,   1.623665925507741e-02,  -1.211758429740021e-04,   9.043471094437046e-07,  -6.749172207849411e-09,   5.036475620837534e-11,
  -3.755621999048829e-13,   2.786638399242465e-15,  -2.009718559084675e-17,   1.242619676869105e-19,  -1.136820143801697e-22,   4.546359757847933e-02,  -3.392623876185340e-04,
   2.531533275055370e-06,  -1.888879329842566e-08,   1.409169507588718e-10,  -1.050478983617523e-12,   7.792763446480043e-15,  -5.622566433968926e-17,   3.490561238116437e-19,
  -3.692179471009270e-22,   4.546395807641600e-02,  -3.392704569473686e-04,   2.531653690508778e-06,  -1.889028962606943e-08,   1.409336016843640e-10,  -1.050647034254112e-12,
   7.794146155117488e-15,  -5.622714403449657e-17,   3.486656259026096e-19,  -3.539307249732090e-22,   4.546454990454139e-02,  -3.392837045190652e-04,   2.531851382251054e-06,
  -1.889274626300142e-08,   1.409609390031734e-10,  -1.050922919506710e-12,   7.796414959228332e-15,  -5.622951617878995e-17,   3.480225894208260e-19,  -3.287803376236324e-22,
   4.546517789680543e-02,  -3.392977618451358e-04,   2.532061162451842e-06,  -1.889535317970493e-08,   1.409899489050318e-10,  -1.051215659004709e-12,   7.798820788837683e-15,
  -5.623195560984602e-17,   3.473375963166219e-19,  -3.020204689798556e-22,   4.546567214224120e-02,  -3.393088254897997e-04,   2.532226270697120e-06,  -1.889740500703641e-08,
   1.410127819446646e-10,  -1.051446049314668e-12,   7.800713066921325e-15,  -5.623381918567503e-17,   3.467965591759189e-19,  -2.809071493695106e-22,   4.546595738584710e-02,
  -3.393152107179461e-04,   2.532321561952851e-06,  -1.889858922493193e-08,   1.410259601776282e-10,  -1.051579013167188e-12,   7.801804686857021e-15,  -5.623487210771975e-17,
   3.464835360519220e-19,  -2.687009148820979e-22,   4.546606449858377e-02,  -3.393176084690986e-04,   2.532357345534124e-06,  -1.889903392342188e-08,   1.410309088937570e-10,
  -1.051628942621711e-12,   7.802214515705016e-15,  -5.623526321840814e-17,   3.463658452341743e-19,  -2.641133200710679e-22,   4.546608225410192e-02,  -3.393180059324925e-04,
   2.532363277215391e-06,  -1.889910763924214e-08,   1.410317292226567e-10,  -1.051637219154278e-12,   7.802282446200835e-15,  -5.623532782515252e-17,   3.463463285118444e-19,
  -2.633526477961991e-22,   9.022939931467899e-02,  -6.733176223420168e-04,   5.024211355803731e-06,  -3.748766406213603e-08,   2.796703028446892e-10,  -2.084785359501762e-12,
   1.546322105675411e-14,  -1.114641146430636e-16,   6.878518046066629e-19,  -5.649534123556807e-22,   9.023011477745470e-02,  -6.733336371439634e-04,   5.024450337852382e-06,
  -3.749063367756890e-08,   2.797033431271892e-10,  -2.085118495925789e-12,   1.546594502381387e-14,  -1.114661629304823e-16,   6.870436162558716e-19,  -5.335498933899543e-22,
   9.023128935003955e-02,  -6.733599289510215e-04,   5.024842685975360e-06,  -3.749550912472577e-08,   2.797575882935395e-10,  -2.085665397168505e-12,   1.547041450586910e-14,
  -1.114694084036940e-16,   6.857127956971495e-19,  -4.818849279262022e-22,   9.023253569583682e-02,  -6.733878278379151e-04,   5.025259025403940e-06,  -3.750068281691718e-08,
   2.798151523076317e-10,  -2.086245706802211e-12,   1.547515377051724e-14,  -1.114726926958863e-16,   6.842951836865657e-19,  -4.269134195320143e-22,   9.023351660078888e-02,
  -6.734097853118500e-04,   5.025586706812682e-06,  -3.750475487722262e-08,   2.798604596147225e-10,  -2.086702417150163e-12,   1.547888127385217e-14,  -1.114751618587494e-16,
   6.831755224052682e-19,  -3.835411412879382e-22,   9.023408270994296e-02,  -6.734224577615488e-04,   5.025775826215060e-06,  -3.750710507808534e-08,   2.798866090008027e-10,
  -2.086965995036369e-12,   1.548103155613826e-14,  -1.114765404670989e-16,   6.825277417271670e-19,  -3.584662627748609e-22,   9.023429529139787e-02,  -6.734272164608722e-04,
   5.025846843953536e-06,  -3.750798762744019e-08,   2.798964286677140e-10,  -2.087064971416533e-12,   1.548183883201573e-14,  -1.114770493723359e-16,   6.822841906076723e-19,
  -3.490420974824430e-22,   9.023433052991384e-02,  -6.734280052870110e-04,   5.025858616240531e-06,  -3.750813392397682e-08,   2.798980564345406e-10,  -2.087081378182035e-12,
   1.548197264023142e-14,  -1.114771332675244e-16,   6.822438025324809e-19,  -3.474794692875512e-22,   1.517969036717522e-01,  -1.132751973716016e-03,   8.452452480712827e-06,
  -6.306713140413648e-08,   4.704998809959615e-10,  -3.507204995635826e-12,   2.600780814082851e-14,  -1.872142504925614e-16,   1.145072466072611e-18,  -5.342643794197481e-22,
   1.517981073263496e-01,  -1.132778916114809e-03,   8.452854529128833e-06,  -6.307212713837320e-08,   4.705554513268076e-10,  -3.507764493679148e-12,   2.601234073402953e-14,
  -1.872154927753668e-16,   1.143630274679278e-18,  -4.787787552035886e-22,   1.518000833616371e-01,  -1.132823147966829e-03,   8.453514591004030e-06,  -6.308032902038166e-08,
   4.706466859983269e-10,  -3.508683002000421e-12,   2.601977752491218e-14,  -1.872173252407636e-16,   1.141255530037956e-18,  -3.874934055264380e-22,   1.518021801441665e-01,
  -1.132870083479166e-03,   8.454215014334603e-06,  -6.308903263362470e-08,   4.707435025192536e-10,  -3.509657612432151e-12,   2.602766282290248e-14,  -1.872189879731642e-16,
   1.138726008454382e-18,  -2.903650229439683e-22,   1.518038303638494e-01,  -1.132907023493695e-03,   8.454766284966555e-06,  -6.309588298956286e-08,   4.708197044932942e-10,
  -3.510424637300241e-12,   2.603386444934404e-14,  -1.872200923104709e-16,   1.136728205374855e-18,  -2.137305777809189e-22,   1.518047827542585e-01,  -1.132928342907617e-03,
   8.455084447573550e-06,  -6.309983669104458e-08,   4.708636848928460e-10,  -3.510867302822451e-12,   2.603744186496352e-14,  -1.872206476708845e-16,   1.135572402796173e-18,
  -1.694255616801309e-22,   1.518051403894201e-01,  -1.132936348674691e-03,   8.455203923356586e-06,  -6.310132138819350e-08,   4.708802004899313e-10,  -3.511033528209493e-12,
   2.603878490518719e-14,  -1.872208407078665e-16,   1.135137851940626e-18,  -1.527738798764465e-22,   1.518051996727304e-01,  -1.132937675751251e-03,   8.455223728312844e-06,
  -6.310156750026215e-08,   4.708829382139635e-10,  -3.511061082450829e-12,   2.603900751670651e-14,  -1.872208718881764e-16,   1.135065790658295e-18,  -1.500128492114438e-22,
   2.321755382447487e-01,  -1.732560365048955e-03,   1.292814671740586e-05,  -9.646203402398313e-08,   7.196323545919505e-10,  -5.364056130184938e-12,   3.976481856455042e-14,
  -2.856765522880630e-16,   1.724816618566725e-18,   9.806705887156168e-23,   2.321773792516290e-01,  -1.732601573812444e-03,   1.292876165265857e-05,  -9.646967467751346e-08,
   7.197173179554562e-10,  -5.364909809432794e-12,   3.977164148995689e-14,  -2.856736049202851e-16,   1.722428489744951e-18,   1.888211825121943e-22,   2.321804016257945e-01,
  -1.732669227028449e-03,   1.292977122088922e-05,  -9.648221892529048e-08,   7.198568095716790e-10,  -5.366311254155239e-12,   3.978283548145868e-14,  -2.856684278446543e-16,
   1.718496282332128e-18,   3.381320460399922e-22,   2.321836086845889e-01,  -1.732741015529313e-03,   1.293084252215828e-05,  -9.649553053562544e-08,   7.200048352287238e-10,
  -5.367798284154805e-12,   3.979470371448663e-14,  -2.856624738638076e-16,   1.714307976709566e-18,   4.970021421517572e-22,   2.321861327191377e-01,  -1.732797515780979e-03,
   1.293168569354902e-05,  -9.650600770735382e-08,   7.201213425269147e-10,  -5.368968576178205e-12,   3.980403721441347e-14,  -2.856574539684944e-16,   1.711000210376812e-18,
   6.223524032935375e-22,   2.321875894138563e-01,  -1.732830124112771e-03,   1.293217232495633e-05,  -9.651205463454664e-08,   7.201885853054974e-10,  -5.369643971117648e-12,
   3.980942100435345e-14,  -2.856544228015707e-16,   1.709086600109611e-18,   6.948223185342163e-22,   2.321881364219383e-01,  -1.732842369041725e-03,   1.293235506380333e-05,
  -9.651432538133234e-08,   7.202138364195623e-10,  -5.369897587964853e-12,   3.981144214964249e-14,  -2.856532592040120e-16,   1.708367144059741e-18,   7.220596643587960e-22,
   2.321882270966072e-01,  -1.732844398823261e-03,   1.293238535558942e-05,  -9.651470179357017e-08,   7.202180221944098e-10,  -5.369939628551916e-12,   3.981177715588579e-14,
  -2.856530649824873e-16,   1.708247837675456e-18,   7.265759197517209e-22,   3.345900347571304e-01,  -2.496806666335463e-03,   1.863085533321357e-05,  -1.390121170558189e-07,
   1.037059854688397e-09,  -7.729640184568284e-12,   5.727542857498991e-14,  -4.102996134476006e-16,   2.430232749491116e-18,   2.057983595558321e-21,   3.345926878468125e-01,
  -2.496866052572103e-03,   1.863174151404005e-05,  -1.390231272519432e-07,   1.037182229368371e-09,  -7.730866108194419e-12,   5.728503234223304e-14,  -4.102852103224416e-16,
   2.426407190185042e-18,   2.201256301321376e-21,   3.345970434143003e-01,  -2.496963548093549e-03,   1.863319639889111e-05,  -1.390412035321913e-07,   1.037383141991567e-09,
  -7.732878626656394e-12,   5.730078735690219e-14,  -4.102610308533131e-16,   2.420108407677340e-18,   2.436975909747208e-21,   3.346016651322769e-01,  -2.497067003002500e-03,
   1.863474024692733e-05,  -1.390603855770419e-07,   1.037596345892700e-09,  -7.735014018028202e-12,   5.731748949793450e-14,  -4.102346472103335e-16,   2.413399729663803e-18,
   2.687792172326314e-21,   3.346053025385714e-01,  -2.497148425908721e-03,   1.863595533785416e-05,  -1.390754831884365e-07,   1.037764153014330e-09,  -7.736694548266343e-12,
   5.733062318058579e-14,  -4.102133556919704e-16,   2.408101708658213e-18,   2.885692842884850e-21,   3.346074017929337e-01,  -2.497195418002694e-03,   1.863665662041708e-05,
  -1.390841968127698e-07,   1.037861003607951e-09,  -7.737664401337822e-12,   5.733819847266975e-14,  -4.102008562392722e-16,   2.405036791593281e-18,   3.000108555798024e-21,
   3.346081900906380e-01,  -2.497213064255042e-03,   1.863691996463105e-05,  -1.390874689594005e-07,   1.037897373069126e-09,  -7.738028588184046e-12,   5.734104223516557e-14,
  -4.101961225243767e-16,   2.403884499252370e-18,   3.043111250368368e-21,   3.346083207626256e-01,  -2.497215989387341e-03,   1.863696361800140e-05,  -1.390880113695026e-07,
   1.037903401885933e-09,  -7.738088957227672e-12,   5.734151358543159e-14,  -4.101953357299734e-16,   2.403693417189582e-18,   3.050241591730459e-21,   4.645386951184257e-01,
  -3.466520777694411e-03,   2.586673766617190e-05,  -1.930016896694560e-07,   1.439818315207281e-09,  -1.073056974121997e-11,   7.945808461767346e-14,  -5.667552067599720e-16,
   3.257966753732597e-18,   6.901938407482052e-21,   4.645423786194259e-01,  -3.466603228371672e-03,   2.586796800844686e-05,  -1.930169743523378e-07,   1.439988079749951e-09,
  -1.073226278863471e-11,   7.947093856963089e-14,  -5.667137652835155e-16,   3.251837919876206e-18,   7.127693925732885e-21,   4.645484258093497e-01,  -3.466738589226250e-03,
   2.586998791929111e-05,  -1.930420683748893e-07,   1.440266795493662e-09,  -1.073504210656122e-11,   7.949202259345541e-14,  -5.666448902425967e-16,   3.241747192165436e-18,
   7.499129034070062e-21,   4.645548425177231e-01,  -3.466882223975907e-03,   2.587213134336884e-05,  -1.930686974397558e-07,   1.440562561297128e-09,  -1.073799104974558e-11,
   7.951437010883207e-14,  -5.665706622685355e-16,   3.231000342488690e-18,   7.894367051737137e-21,   4.645598926258294e-01,  -3.466995269928158e-03,   2.587381833260422e-05,
  -1.930896563678392e-07,   1.440795349972955e-09,  -1.074031179010597e-11,   7.953194011691942e-14,  -5.665114132405574e-16,   3.222513656104335e-18,   8.206230727452212e-21,
   4.645628071920374e-01,  -3.467060512821598e-03,   2.587479196845901e-05,  -1.931017528621636e-07,   1.440929704656163e-09,  -1.074165109704070e-11,   7.954207304358327e-14,
  -5.664768858386885e-16,   3.217604242941027e-18,   8.386538010648967e-21,   4.645639016500943e-01,  -3.467085012529152e-03,   2.587515758622552e-05,  -1.931062953459345e-07,
   1.440980157646953e-09,  -1.074215401295445e-11,   7.954587672083733e-14,  -5.664638573448203e-16,   3.215758519179943e-18,   8.454306582910882e-21,   4.645640830726823e-01,
  -3.467089073724948e-03,   2.587521819301631e-05,  -1.931070483344905e-07,   1.440988521029952e-09,  -1.074223737808740e-11,   7.954650716419467e-14,  -5.664616943548183e-16,
   3.215452448463440e-18,   8.465543433370829e-21,   6.326893926717405e-01,  -4.721309417048063e-03,   3.522980756367193e-05,  -2.628627625964218e-07,   1.960958019326714e-09,
  -1.461228466934794e-11,   1.080822091315529e-13,  -7.654280455785535e-16,   4.175131624272889e-18,   1.863081633287901e-20,   6.326944095019018e-01,  -4.721421712491413e-03,
   3.523148322444742e-05,  -2.628835762479977e-07,   1.961188927487505e-09,  -1.461457041096459e-11,   1.080986319575226e-13,  -7.653226152608293e-16,   4.164892800262589e-18,
   1.900133255271603e-20,   6.327026456133584e-01,  -4.721606070068402e-03,   3.523423423545145e-05,  -2.629177475769514e-07,   1.961568025839403e-09,  -1.461832259160527e-11,
   1.081255629191474e-13,  -7.651481519210254e-16,   4.148035749042984e-18,   1.961097489773282e-20,   6.327113849990867e-01,  -4.721801696450091e-03,   3.523715346464247e-05,
  -2.629540091937702e-07,   1.961970312764150e-09,  -1.462230362540078e-11,   1.081540982207620e-13,  -7.649611511979344e-16,   4.130083301019481e-18,   2.025972991763550e-20,
   6.327182631116829e-01,  -4.721955661771788e-03,   3.523945105375149e-05,  -2.629825495905114e-07,   1.962286939483380e-09,  -1.462543648703459e-11,   1.081765262477271e-13,
  -7.648126160730368e-16,   4.115906914459682e-18,   2.077166423205979e-20,   6.327222326731493e-01,  -4.722044520707688e-03,   3.524077709363458e-05,  -2.629990217390014e-07,
   1.962469680887251e-09,  -1.462724442896691e-11,   1.081894580936210e-13,  -7.647263458293226e-16,   4.107706296513018e-18,   2.106765744516979e-20,   6.327237232958418e-01,
  -4.722077888601455e-03,   3.524127504543457e-05,  -2.630052073698492e-07,   1.962538303978184e-09,  -1.462792331136463e-11,   1.081943118963218e-13,  -7.646938468834314e-16,
   4.104623261213402e-18,   2.117890907883031e-20,   6.327239703885695e-01,  -4.722083419832776e-03,   3.524135758863418e-05,  -2.630062327359492e-07,   1.962549679336742e-09,
  -1.462803584490043e-11,   1.081951163656830e-13,  -7.646884542498738e-16,   4.104112012859175e-18,   2.119735607721998e-20,   8.664655890577958e-01,  -6.465814281951033e-03,
   4.824707077013385e-05,  -3.599883849557805e-07,   2.685427433099560e-09,  -2.000482268818993e-11,   1.476424858023668e-13,  -1.030289450659795e-15,   4.978131544747589e-18,
   5.208796403602801e-20,   8.664724595850685e-01,  -6.465968069599491e-03,   4.824936549350131e-05,  -3.600168792408491e-07,   2.685742822435580e-09,  -2.000789705748822e-11,
   1.476619129660892e-13,  -1.030003766496693e-15,   4.958523903342158e-18,   5.278681750112399e-20,   8.664837389041832e-01,  -6.466220545719995e-03,   4.825313284811937e-05,
  -3.600636603830556e-07,   2.686260614844075e-09,  -2.001294350299374e-11,   1.476937487954742e-13,  -1.029532161138831e-15,   4.926241760867629e-18,   5.393684878843340e-20,
   8.664957074552291e-01,  -6.466488454367599e-03,   4.825713056735881e-05,  -3.601133030874685e-07,   2.686810073022986e-09,  -2.001829731339858e-11,   1.477274514498271e-13,
  -1.029028200510162e-15,   4.891861309151242e-18,   5.516086291424031e-20,   8.665051270007420e-01,  -6.466699308548661e-03,   4.826027698515561e-05,  -3.601523752675580e-07,
   2.687242528720508e-09,  -2.002251016643909e-11,   1.477539192997320e-13,  -1.028629005480635e-15,   4.864711912267915e-18,   5.612688115183043e-20,   8.665105632980328e-01,
  -6.466821000094264e-03,   4.826209292125794e-05,  -3.601749258336208e-07,   2.687492119061634e-09,  -2.002494123541986e-11,   1.477691718008408e-13,  -1.028397588432585e-15,
   4.849006621293520e-18,   5.668547764711489e-20,   8.665126046993741e-01,  -6.466866697136480e-03,   4.826277483785061e-05,  -3.601833940310847e-07,   2.687585844926872e-09,
  -2.002585407847975e-11,   1.477748949880860e-13,  -1.028310493459192e-15,   4.843102159277629e-18,   5.689544205095215e-20,   8.665129430917977e-01,  -6.466874272109973e-03,
   4.826288787605311e-05,  -3.601847977684584e-07,   2.687601381447171e-09,  -2.002600539277410e-11,   1.477758434624661e-13,  -1.028296045899234e-15,   4.842123042402620e-18,
   5.693025751978088e-20,   1.744790825069362e-03,  -1.264277285968296e-05,   9.160493141331247e-08,  -6.637001831920757e-10,   4.808294287645666e-12,  -3.482467558807119e-14,
   2.517934104400922e-16,  -1.802485431460518e-18,   1.223830197940368e-20,  -6.164785872160711e-23,   1.744803869386374e-03,  -1.264305638317299e-05,   9.160903999575825e-08,
  -6.637497867898626e-10,   4.808832347048202e-12,  -3.483006719378021e-14,   2.518421266610683e-16,  -1.802796450080088e-18,   1.223598597541959e-20,  -6.146958257461138e-23,
   1.744825284167603e-03,  -1.264352184819892e-05,   9.161578523123284e-08,  -6.638312246737727e-10,   4.809715733801061e-12,  -3.483891905606093e-14,   2.519220954013626e-16,
  -1.803306371237630e-18,   1.223215725019500e-20,  -6.117610326612577e-23,   1.744848007481617e-03,  -1.264401576340597e-05,   9.162294289928591e-08,  -6.639176441067954e-10,
   4.810653177573041e-12,  -3.484831247445814e-14,   2.520069391035119e-16,  -1.803846529862415e-18,   1.222805843312482e-20,  -6.086359669885476e-23,   1.744865891266251e-03,
  -1.264440449235911e-05,   9.162857634886372e-08,  -6.639856621171777e-10,   4.811391024705020e-12,  -3.485570580117092e-14,   2.520737047676443e-16,  -1.804270979446992e-18,
   1.222480636071292e-20,  -6.061685327517578e-23,   1.744876212515271e-03,  -1.264462884148838e-05,   9.163182765394287e-08,  -6.640249188307662e-10,   4.811816880357479e-12,
  -3.485997289777227e-14,   2.521122338111493e-16,  -1.804515673377678e-18,   1.222291897776421e-20,  -6.047413217066796e-23,   1.744880088278516e-03,  -1.264471308796070e-05,
   9.163304857612398e-08,  -6.640396605309815e-10,   4.811976798992587e-12,  -3.486157528469767e-14,   2.521267013334096e-16,  -1.804607508389604e-18,   1.222220825136260e-20,
  -6.042047833177916e-23,   1.744880730743418e-03,  -1.264472705307969e-05,   9.163325096275948e-08,  -6.640421042006368e-10,   4.812003308090972e-12,  -3.486184090588911e-14,
   2.521290995050188e-16,  -1.804622728718775e-18,   1.222209033298676e-20,  -6.041158123975612e-23,   1.576511877003011e-02,  -1.142342181315707e-04,   8.276995735256749e-07,
  -5.996886189497815e-09,   4.344550140219334e-11,  -3.146588679741333e-13,   2.275048514175714e-15,  -1.628455073926951e-17,   1.105038713245249e-19,  -5.543508961590640e-22,
   1.576523663241437e-02,  -1.142367799179652e-04,   8.277366967571877e-07,  -5.997334383486095e-09,   4.345036296836431e-11,  -3.147075782018891e-13,   2.275488378094358e-15,
  -1.628734678380219e-17,   1.104823966170283e-19,  -5.527217500504414e-22,   1.576543012642188e-02,  -1.142409856434601e-04,   8.277976435536097e-07,  -5.998070216597396e-09,
   4.345834469468802e-11,  -3.147875499372288e-13,   2.276210422682349e-15,  -1.629193085512404e-17,   1.104468993077693e-19,  -5.500398459238855e-22,   1.576563544372331e-02,
  -1.142454484315594e-04,   8.278623168980502e-07,  -5.998851060555563e-09,   4.346681484554067e-11,  -3.148724142947958e-13,   2.276976481487509e-15,  -1.629678661947475e-17,
   1.104089030535998e-19,  -5.471840735082629e-22,   1.576579703328714e-02,  -1.142489608055884e-04,   8.279132181164141e-07,  -5.999465638204213e-09,   4.347348156653131e-11,
  -3.149392088965866e-13,   2.277579311000099e-15,  -1.630060211774199e-17,   1.103787598769799e-19,  -5.449292693248963e-22,   1.576589029129497e-02,  -1.142509879199793e-04,
   8.279425953900353e-07,  -5.999820342766056e-09,   4.347732932923787e-11,  -3.149777597331352e-13,   2.277927190429415e-15,  -1.630280170186112e-17,   1.103612673649744e-19,
  -5.436250500478871e-22,   1.576592531088981e-02,  -1.142517491319214e-04,   8.279536270724205e-07,  -5.999953541595508e-09,   4.347877425298479e-11,  -3.149922364025290e-13,
   2.278057817826118e-15,  -1.630362721073049e-17,   1.103546805374674e-19,  -5.431347490213609e-22,   1.576593111590398e-02,  -1.142518753142416e-04,   8.279554557434990e-07,
  -5.999975621405337e-09,   4.347901377244692e-11,  -3.149946361412686e-13,   2.278079470933999e-15,  -1.630376402653001e-17,   1.103535877152336e-19,  -5.430534453883474e-22,
   4.414566909909743e-02,  -3.198799873597475e-04,   2.317733974764032e-06,  -1.679254980806927e-08,   1.216565379818431e-10,  -8.811072983843218e-13,   6.370386919361323e-15,
  -4.558932701665736e-17,   3.089939463774922e-19,  -1.536763320981907e-21,   4.414599913871686e-02,  -3.198871609035062e-04,   2.317837927614237e-06,  -1.679380483993369e-08,
   1.216701508824582e-10,  -8.812436635481052e-13,   6.371616810528952e-15,  -4.559707405891585e-17,   3.089306193072179e-19,  -1.532094543836998e-21,   4.414654096288750e-02,
  -3.198989378244608e-04,   2.318008591452725e-06,  -1.679586531823150e-08,   1.216925005594713e-10,  -8.814675456920363e-13,   6.373635689610727e-15,  -4.560977463510848e-17,
   3.088259624261299e-19,  -1.524408827643226e-21,   4.414711589478332e-02,  -3.199114345750775e-04,   2.318189690408396e-06,  -1.679805183575889e-08,   1.217162178729929e-10,
  -8.817051245701660e-13,   6.375777622034782e-15,  -4.562322717224002e-17,   3.087139671412067e-19,  -1.516224893435878e-21,   4.414756837975962e-02,  -3.199212699652702e-04,
   2.318332224516496e-06,  -1.679977277469930e-08,   1.217348853904237e-10,  -8.818921167570913e-13,   6.377463149108557e-15,  -4.563379715579389e-17,   3.086251400981971e-19,
  -1.509763219623267e-21,   4.414782952191795e-02,  -3.199269463143242e-04,   2.318414487056021e-06,  -1.680076601759662e-08,   1.217456595281383e-10,  -8.820000401577965e-13,
   6.378435825299375e-15,  -4.563989038060828e-17,   3.085736008774830e-19,  -1.506025685191124e-21,   4.414792758419480e-02,  -3.199290778687676e-04,   2.318445378084891e-06,
  -1.680113900064955e-08,   1.217497054654329e-10,  -8.820405677059082e-13,   6.378801060776641e-15,  -4.564217713794621e-17,   3.085541952931727e-19,  -1.504620619653399e-21,
   4.414794383946301e-02,  -3.199294312059534e-04,   2.318450498748185e-06,  -1.680120082848162e-08,   1.217503761449139e-10,  -8.820472857924027e-13,   6.378861603039985e-15,
  -4.564255613160995e-17,   3.085509757905797e-19,  -1.504387626330622e-21,   8.761377051883582e-02,  -6.348503120057082e-04,   4.599894301680522e-06,  -3.332735773471199e-08,
   2.414456442629640e-10,  -1.748677905242846e-12,   1.264226838451611e-14,  -9.044448446393538e-17,   6.118474021656233e-19,  -3.000544009626413e-21,   8.761442553247435e-02,
  -6.348645489894097e-04,   4.600100611692266e-06,  -3.332984851615287e-08,   2.414726595002500e-10,  -1.748948435432572e-12,   1.264470350784947e-14,  -9.045959739933451e-17,
   6.117115505488413e-19,  -2.990937330487336e-21,   8.761550086464828e-02,  -6.348879220721257e-04,   4.600439319657926e-06,  -3.333393781548559e-08,   2.415170131413251e-10,
  -1.749392587009948e-12,   1.264870075757515e-14,  -9.048437182876996e-17,   6.114871019219832e-19,  -2.975122970635595e-21,   8.761664190411990e-02,  -6.349127237657832e-04,
   4.600798737676218e-06,  -3.333827725665667e-08,   2.415640808883223e-10,  -1.749863910274419e-12,   1.265294160350142e-14,  -9.051061053339566e-17,   6.112470034691332e-19,
  -2.958283603796348e-21,   8.761753992912429e-02,  -6.349322435867327e-04,   4.601081617973905e-06,  -3.334169269374333e-08,   2.416011271490750e-10,  -1.750234876066340e-12,
   1.265627877517663e-14,  -9.053122507172393e-17,   6.110566371306973e-19,  -2.944988083573131e-21,   8.761805820531059e-02,  -6.349435091608465e-04,   4.601244880311056e-06,
  -3.334366391914414e-08,   2.416225087522472e-10,  -1.750448980457389e-12,   1.265820456274188e-14,  -9.054310788774599e-17,   6.109462080444630e-19,  -2.937297784793721e-21,
   8.761825282475920e-02,  -6.349477395533628e-04,   4.601306188186951e-06,  -3.334440415465128e-08,   2.416305380368971e-10,  -1.750529381199219e-12,   1.265892768491200e-14,
  -9.054756730961412e-17,   6.109046339577479e-19,  -2.934406749168465e-21,   8.761828508580227e-02,  -6.349484408045042e-04,   4.601316350910599e-06,  -3.334452686037774e-08,
   2.416318690205305e-10,  -1.750542708900331e-12,   1.265904755116686e-14,  -9.054830638044784e-17,   6.108977368180121e-19,  -2.933927347025096e-21,   1.473965158252322e-01,
  -1.068036719371766e-03,   7.738605302148730e-06,  -5.606808042338257e-08,   4.061942002610810e-10,  -2.941846015777076e-12,   2.126685187134889e-14,  -1.520739190485905e-16,
   1.025888669059223e-18,  -4.925819100141952e-21,   1.473976177835990e-01,  -1.068060670875750e-03,   7.738952386168655e-06,  -5.607227072715197e-08,   4.062396451869092e-10,
  -2.942300876737963e-12,   2.127093431767012e-14,  -1.520986957029896e-16,   1.025634913548479e-18,  -4.908810438612838e-21,   1.473994268623974e-01,  -1.068099992440999e-03,
   7.739522208838890e-06,  -5.607915025718750e-08,   4.063142566856052e-10,  -2.943047657860772e-12,   2.127763556894494e-14,  -1.521393070317285e-16,   1.025215817772924e-18,
  -4.880811280178403e-21,   1.474013464834840e-01,  -1.068141717421261e-03,   7.740126872899170e-06,  -5.608645060669444e-08,   4.063934338116626e-10,  -2.943840122635124e-12,
   2.128474509789215e-14,  -1.521823122510824e-16,   1.024767701710484e-18,  -4.850997662076037e-21,   1.474028572706018e-01,  -1.068174556474702e-03,   7.740602774328100e-06,
  -5.609219648094608e-08,   4.064557528227373e-10,  -2.944463848854951e-12,   2.129033959536236e-14,  -1.522160948047176e-16,   1.024412549777275e-18,  -4.827458542343944e-21,
   1.474037291895149e-01,  -1.068193509045589e-03,   7.740877437427285e-06,  -5.609551272206563e-08,   4.064917208264767e-10,  -2.944823834389171e-12,   2.129356799191851e-14,
  -1.522355661711032e-16,   1.024206588379756e-18,  -4.813843302106124e-21,   1.474040566064069e-01,  -1.068200626021007e-03,   7.740980578246294e-06,  -5.609675803849968e-08,
   4.065052276389959e-10,  -2.944959016491756e-12,   2.129478023060620e-14,  -1.522428730937853e-16,   1.024129059370008e-18,  -4.808724903051631e-21,   1.474041108805841e-01,
  -1.068201805766648e-03,   7.740997675423851e-06,  -5.609696446936588e-08,   4.065074666112698e-10,  -2.944981425068803e-12,   2.129498117354615e-14,  -1.522440840691045e-16,
   1.024116197881277e-18,  -4.807876152192253e-21,   2.254450820151479e-01,  -1.633577458469030e-03,   1.183630754225796e-05,  -8.575692020172106e-08,   6.212788278696866e-10,
  -4.499526130779761e-12,   3.252405637279674e-14,  -2.324145287946310e-16,   1.561581422161480e-18,  -7.266712904171300e-21,   2.254467674762362e-01,  -1.633614092631997e-03,
   1.183683841131792e-05,  -8.576332922759579e-08,   6.213483278417784e-10,  -4.500221272342687e-12,   3.253026937443857e-14,  -2.324510047827018e-16,   1.561137912384517e-18,
  -7.238829819685775e-21,   2.254495344881416e-01,  -1.633674235520293e-03,   1.183770996173812e-05,  -8.577385139638386e-08,   6.214624328782489e-10,  -4.501362538051736e-12,
   3.254046772156847e-14,  -2.325107818274155e-16,   1.560405716235085e-18,  -7.192929897142605e-21,   2.254524705760582e-01,  -1.633738054465683e-03,   1.183863480246340e-05,
  -8.578501720332218e-08,   6.215835201662548e-10,  -4.502573615514805e-12,   3.255128718199893e-14,  -2.325740680286670e-16,   1.559623215054028e-18,  -7.144056000784229e-21,
   2.254547813465701e-01,  -1.633788282260728e-03,   1.183936269923843e-05,  -8.579380545630561e-08,   6.216788259281891e-10,  -4.503526816738583e-12,   3.255980086460663e-14,
  -2.326237716873408e-16,   1.559003332873685e-18,  -7.105468360361961e-21,   2.254561149590224e-01,  -1.633817270484990e-03,   1.183978279964356e-05,  -8.579887761126277e-08,
   6.217338325267878e-10,  -4.504076958595973e-12,   3.256471375869336e-14,  -2.326524153212125e-16,   1.558643961367772e-18,  -7.083149070621905e-21,   2.254566157478430e-01,
  -1.633828155999184e-03,   1.183994055472558e-05,  -8.580078230924755e-08,   6.217544887659196e-10,  -4.504283548150142e-12,   3.256655850104925e-14,  -2.326631634728449e-16,
   1.558508706332244e-18,  -7.074758572780586e-21,   2.254566987609737e-01,  -1.633829960436769e-03,   1.183996670505744e-05,  -8.580109804301704e-08,   6.217579128709104e-10,
  -4.504317793632558e-12,   3.256686428831314e-14,  -2.326649447202122e-16,   1.558486269648072e-18,  -7.073367232538291e-21,   3.248907201853705e-01,  -2.354161607574873e-03,
   1.705739775063738e-05,  -1.235849630193169e-07,   8.953278291749808e-10,  -6.484160745660539e-12,   4.686265788786242e-14,  -3.345530816075521e-16,   2.234802297181271e-18,
  -9.915651739615994e-21,   3.248931491168618e-01,  -2.354214401350590e-03,   1.705816278842605e-05,  -1.235941989051251e-07,   8.954279682504948e-10,  -6.485161332600382e-12,
   4.687154689885901e-14,  -3.346026907075122e-16,   2.234047297854147e-18,  -9.871540375384301e-21,   3.248971366799094e-01,  -2.354301073732218e-03,   1.705941878364327e-05,
  -1.236093621363992e-07,   8.955923764606675e-10,  -6.486804064425668e-12,   4.688613743795223e-14,  -3.346839672428432e-16,   2.232801388743846e-18,  -9.798926686090132e-21,
   3.249013678997524e-01,  -2.354393043708070e-03,   1.706075157574282e-05,  -1.236254528966724e-07,   8.957668449118972e-10,  -6.488547274310773e-12,   4.690161611237589e-14,
  -3.347699835050048e-16,   2.231470596487008e-18,  -9.721608872798154e-21,   3.249046979696685e-01,  -2.354465427371965e-03,   1.706180055102512e-05,  -1.236381174232330e-07,
   8.959041659896596e-10,  -6.489919294087197e-12,   4.691379571931982e-14,  -3.348375159487304e-16,   2.230416884349441e-18,  -9.660564274701790e-21,   3.249066198492684e-01,
  -2.354507202526112e-03,   1.706240595958435e-05,  -1.236454267755070e-07,   8.959834220758096e-10,  -6.490711155341897e-12,   4.692082392766756e-14,  -3.348764248769304e-16,
   2.229806209094351e-18,  -9.625255965115944e-21,   3.249073415400539e-01,  -2.354522889724790e-03,   1.706263330113270e-05,  -1.236481715867756e-07,   8.960131845461866e-10,
  -6.491008515014215e-12,   4.692346292295797e-14,  -3.348910231991168e-16,   2.229576410698841e-18,  -9.611982538395424e-21,   3.249074611709422e-01,  -2.354525490113745e-03,
   1.706267098649188e-05,  -1.236486265825839e-07,   8.960181181555740e-10,  -6.491057807052695e-12,   4.692390036539249e-14,  -3.348934424272436e-16,   2.229538292795134e-18,
  -9.609781496631536e-21,   4.510723438844076e-01,  -3.268474990107105e-03,   2.368217917327878e-05,  -1.715830571422086e-07,   1.243052559691888e-09,  -9.002198517044965e-12,
   6.504675983909706e-14,  -4.636991114940308e-16,   3.070327330993958e-18,  -1.260322845844954e-20,   4.510757161684739e-01,  -3.268548287998895e-03,   2.368324133393701e-05,
  -1.715958796412576e-07,   1.243191554134728e-09,  -9.003585258644144e-12,   6.505896686608350e-14,  -4.637618023402311e-16,   3.069035056988224e-18,  -1.253364291113871e-20,
   4.510812524280907e-01,  -3.268668622313994e-03,   2.368498512843822e-05,  -1.716169312760841e-07,   1.243419754833948e-09,  -9.005861953664613e-12,   6.507900289712723e-14,
  -4.638644594906929e-16,   3.066903454202562e-18,  -1.241909526578591e-20,   4.510871269763461e-01,  -3.268796311709737e-03,   2.368683554591068e-05,  -1.716392706278501e-07,
   1.243661918997390e-09,  -9.008277885205042e-12,   6.510025752212854e-14,  -4.639730326356469e-16,   3.064627876625526e-18,  -1.229712720033785e-20,   4.510917503845215e-01,
  -3.268896807835848e-03,   2.368829191870953e-05,  -1.716568532199050e-07,   1.243852521988085e-09,  -9.010179367671833e-12,   6.511698128051282e-14,  -4.640582234457808e-16,
   3.062826990372815e-18,  -1.220083017719890e-20,   4.510944186870129e-01,  -3.268954807679040e-03,   2.368913245381382e-05,  -1.716670010407446e-07,   1.243962530124702e-09,
  -9.011276803077290e-12,   6.512663138387834e-14,  -4.641072856147515e-16,   3.061783652046407e-18,  -1.214513187977799e-20,   4.510954206693020e-01,  -3.268976587492462e-03,
   2.368944808950826e-05,  -1.716708117548224e-07,   1.244003840676947e-09,  -9.011688910934529e-12,   6.513025480876580e-14,  -4.641256894378934e-16,   3.061391109257912e-18,
  -1.212419327480474e-20,   4.510955867626396e-01,  -3.268980197823880e-03,   2.368950041098042e-05,  -1.716714434408419e-07,   1.244010688566305e-09,  -9.011757224235343e-12,
   6.513085542826465e-14,  -4.641287391053312e-16,   3.061325999622741e-18,  -1.212072116961475e-20,   6.143485791901461e-01,  -4.451576318619603e-03,   3.225449956748731e-05,
  -2.336914714455612e-07,   1.692995445552003e-09,  -1.226012014831161e-11,   8.855578260587931e-14,  -6.298041617109111e-16,   4.109442920440317e-18,  -1.454845815600891e-20,
   6.143531721515356e-01,  -4.451676148357449e-03,   3.225594619384166e-05,  -2.337089343988186e-07,   1.693184671493804e-09,  -1.226200342493988e-11,   8.857210874198547e-14,
  -6.298756206407366e-16,   4.107127562987714e-18,  -1.443446557528740e-20,   6.143607123901869e-01,  -4.451840040426029e-03,   3.225832118204052e-05,  -2.337376046012587e-07,
   1.693495341674393e-09,  -1.226509528075002e-11,   8.859890397429875e-14,  -6.299925060645129e-16,   4.103310017654277e-18,  -1.424681529036877e-20,   6.143687133689834e-01,
  -4.452013949914251e-03,   3.226084138699435e-05,  -2.337680285366452e-07,   1.693825020954483e-09,  -1.226837618540371e-11,   8.862732656997898e-14,  -6.301159505482529e-16,
   4.099236832573893e-18,  -1.404700570396725e-20,   6.143750103281990e-01,  -4.452150822907663e-03,   3.226282491660582e-05,  -2.337919742413889e-07,   1.694084505043247e-09,
  -1.227095842384922e-11,   8.864968860832472e-14,  -6.302126812559218e-16,   4.096014915624892e-18,  -1.388924833698412e-20,   6.143786444853671e-01,  -4.452229817118188e-03,
   3.226396969645961e-05,  -2.338057945405781e-07,   1.694234268309703e-09,  -1.227244874384281e-11,   8.866259148791936e-14,  -6.302683375098012e-16,   4.094148942131245e-18,
  -1.379800034407308e-20,   6.143800091586490e-01,  -4.452259480632273e-03,   3.226439958139731e-05,  -2.338109843448980e-07,   1.694290507781200e-09,  -1.227300838508686e-11,
   8.866743613826145e-14,  -6.302892050248498e-16,   4.093447012930941e-18,  -1.376369739368677e-20,   6.143802353733662e-01,  -4.452264397805564e-03,   3.226447084143899e-05,
  -2.338118446368752e-07,   1.694299830377548e-09,  -1.227310115422763e-11,   8.866823918151586e-14,  -6.302926624272480e-16,   4.093330592804245e-18,  -1.375800916106376e-20,
   8.413479185774249e-01,  -6.096415925833436e-03,   4.417240565760327e-05,  -3.200392608728380e-07,   2.318526413015186e-09,  -1.678850401667203e-11,   1.211799185785039e-13,
  -8.577876758749413e-16,   5.428797041081951e-18,  -1.259216004445801e-20,   8.413542086192789e-01,  -6.096552642133980e-03,   4.417438678481798e-05,  -3.200631737994563e-07,
   2.318785340538624e-09,  -1.679106840364759e-11,   1.212014508049083e-13,  -8.578464591440312e-16,   5.424036891372579e-18,  -1.237978435302285e-20,   8.413645349452965e-01,
  -6.096777091458490e-03,   4.417763928574592e-05,  -3.201024333778486e-07,   2.319210445154500e-09,  -1.679527838324035e-11,   1.212367855541055e-13,  -8.579421676053871e-16,
   5.416191537335127e-18,  -1.203015759985974e-20,   8.413754922530569e-01,  -6.097015259585335e-03,   4.418109065805915e-05,  -3.201440944120459e-07,   2.319661559093459e-09,
  -1.679974566368270e-11,   1.212742595338612e-13,  -8.580426408534113e-16,   5.407825086077175e-18,  -1.165784596257883e-20,   8.413841159129635e-01,  -6.097202706427095e-03,
   4.418380706365798e-05,  -3.201768844622333e-07,   2.320016620768635e-09,  -1.680326155682981e-11,   1.213037380156736e-13,  -8.581209297066879e-16,   5.401210237775846e-18,
  -1.136386986348548e-20,   8.413890928763492e-01,  -6.097310888580985e-03,   4.418537481756486e-05,  -3.201958092825598e-07,   2.320221546883007e-09,  -1.680529069535886e-11,
   1.213207451047291e-13,  -8.581657969022304e-16,   5.397380473349255e-18,  -1.119382325043524e-20,   8.413909617908302e-01,  -6.097351512606713e-03,   4.418596353667686e-05,
  -3.202029159375744e-07,   2.320298501148354e-09,  -1.680605266606761e-11,   1.213271303910810e-13,  -8.581825854119351e-16,   5.395940049565260e-18,  -1.112989580285223e-20,
   8.413912715909605e-01,  -6.097358246649539e-03,   4.418606112592587e-05,  -3.202040939777481e-07,   2.320311257549722e-09,  -1.680617897409406e-11,   1.213281887885415e-13,
  -8.581853652037206e-16,   5.395701156836065e-18,  -1.111929504751665e-20,   1.695636750502681e-03,  -1.194053404348869e-05,   8.408015972795869e-08,  -5.920274743987089e-10,
   4.168362961424221e-12,  -2.934511788307575e-14,   2.064636453565317e-16,  -1.447443950486621e-18,   9.952536377321805e-21,  -6.197603722183582e-23,   1.695648722889491e-03,
  -1.194078694073730e-05,   8.408372135993696e-08,  -5.920692712259405e-10,   4.168804152229479e-12,  -2.934944855684578e-14,   2.065033266671398e-16,  -1.447760338137302e-18,
   9.953719075916029e-21,  -6.193460962600289e-23,   1.695668377867408e-03,  -1.194120212541875e-05,   8.408956862785637e-08,  -5.921378919409274e-10,   4.169528499597156e-12,
  -2.935655874160403e-14,   2.065684733206235e-16,  -1.448279584134978e-18,   9.955652293027747e-21,  -6.186631508365550e-23,   1.695689233817435e-03,  -1.194164268601487e-05,
   8.409577340158955e-08,  -5.922107098834778e-10,   4.170297171398883e-12,  -2.936410412511043e-14,   2.066376035086127e-16,  -1.448830332304539e-18,   9.957692184847015e-21,
  -6.179346216175492e-23,   1.695705647921284e-03,  -1.194198942223430e-05,   8.410065685943190e-08,  -5.922680223751863e-10,   4.170902180432639e-12,  -2.937004305330054e-14,
   2.066920126163516e-16,  -1.449263620082350e-18,   9.959289320168333e-21,  -6.173584579604973e-23,   1.695715120966533e-03,  -1.194218953558391e-05,   8.410347530600404e-08,
  -5.923011002940155e-10,   4.171251367143343e-12,  -2.937347079410362e-14,   2.067234144903285e-16,  -1.449513617079950e-18,   9.960207737906192e-21,  -6.170248158884342e-23,
   1.695718678216620e-03,  -1.194226468110004e-05,   8.410453368104862e-08,  -5.923135217139709e-10,   4.171382494793357e-12,  -2.937475799573864e-14,   2.067352064542066e-16,
  -1.449607481729936e-18,   9.960551984716018e-21,  -6.168993168318223e-23,   1.695719267883185e-03,  -1.194227713759578e-05,   8.410470912293413e-08,  -5.923155807596677e-10,
   4.171404231319257e-12,  -2.937497137051828e-14,   2.067371611540770e-16,  -1.449623040521112e-18,   9.960609015397737e-21,  -6.168785023185022e-23,   1.532098540320063e-02,
  -1.078891146526613e-04,   7.597092355238965e-07,  -5.349285004187432e-09,   3.766338726371190e-11,  -2.651486599515224e-13,   1.865499089783581e-15,  -1.307792842488420e-17,
   8.990564318867273e-20,  -5.592310234776871e-22,   1.532109358012203e-02,  -1.078913997146179e-04,   7.597414167723109e-07,  -5.349662660613688e-09,   3.766737363543449e-11,
  -2.651877883410243e-13,   1.865857545237356e-15,  -1.308078313531698e-17,   8.991616893498544e-20,  -5.588511364701063e-22,   1.532127117336514e-02,  -1.078951511303638e-04,
   7.597942499629820e-07,  -5.350282685042295e-09,   3.767391846313993e-11,  -2.652520300864085e-13,   1.866446037770451e-15,  -1.308546817834873e-17,   8.993337219732636e-20,
  -5.582248946296042e-22,   1.532145961803391e-02,  -1.078991318310763e-04,   7.598503134097263e-07,  -5.350940633638145e-09,   3.768086378329807e-11,  -2.653202039159016e-13,
   1.867070514339655e-15,  -1.309043742755015e-17,   8.995152209932101e-20,  -5.575568705838606e-22,   1.532160792824558e-02,  -1.079022647783436e-04,   7.598944380612217e-07,
  -5.351458482289286e-09,   3.768633033134673e-11,  -2.653738631386304e-13,   1.867562009915219e-15,  -1.309434684142867e-17,   8.996573066136011e-20,  -5.570285701254616e-22,
   1.532169352227855e-02,  -1.079040729095300e-04,   7.599199042322712e-07,  -5.351757358766315e-09,   3.768948540142642e-11,  -2.654048333543326e-13,   1.867845673309855e-15,
  -1.309660247350852e-17,   8.997390038664456e-20,  -5.567226492980841e-22,   1.532172566393661e-02,  -1.079047518894756e-04,   7.599294672164280e-07,  -5.351869592859734e-09,
   3.769067020287801e-11,  -2.654164634373468e-13,   1.867952193940497e-15,  -1.309744937842970e-17,   8.997696246451101e-20,  -5.566075784687239e-22,   1.532173099188957e-02,
  -1.079048644405796e-04,   7.599310524276253e-07,  -5.351888197425705e-09,   3.769086660285442e-11,  -2.654183913142927e-13,   1.867969851375982e-15,  -1.309758975937535e-17,
   8.997746974505204e-20,  -5.565884935662110e-22,   4.290200167529278e-02,  -3.021123547626844e-04,   2.127346643470005e-06,  -1.497912996286133e-08,   1.054654400892819e-10,
  -7.424713021821236e-13,   5.223731774744016e-15,  -3.661805239862056e-17,   2.516337412061522e-19,  -1.561573557277988e-21,   4.290230459356711e-02,  -3.021187534196945e-04,
   2.127436757762548e-06,  -1.498018747919405e-08,   1.054766026386655e-10,  -7.425808608672228e-13,   5.224735023920340e-15,  -3.662602281928509e-17,   2.516622815496302e-19,
  -1.560477386915470e-21,   4.290280189223340e-02,  -3.021292581776026e-04,   2.127584701855211e-06,  -1.498192367619965e-08,   1.054949293187896e-10,  -7.427607363821759e-13,
   5.226382100800333e-15,  -3.663910344008223e-17,   2.517089164532651e-19,  -1.558670426580983e-21,   4.290332957718811e-02,  -3.021404049819345e-04,   2.127741691347019e-06,
  -1.498376606872705e-08,   1.055143774478766e-10,  -7.429516215810625e-13,   5.228129886401679e-15,  -3.665297738242304e-17,   2.517581019530892e-19,  -1.556743004002746e-21,
   4.290374487716896e-02,  -3.021491778972302e-04,   2.127865249690504e-06,  -1.498521615234320e-08,   1.055296847518497e-10,  -7.431018661563692e-13,   5.229505482031877e-15,
  -3.666389217619255e-17,   2.517965952211490e-19,  -1.555218789623538e-21,   4.290398455857626e-02,  -3.021542410471615e-04,   2.127936560347963e-06,  -1.498605306845705e-08,
   1.055385195072884e-10,  -7.431885820201466e-13,   5.230299396817521e-15,  -3.667018968101836e-17,   2.518187237292216e-19,  -1.554336196637621e-21,   4.290407456202127e-02,
  -3.021561423346847e-04,   2.127963338723323e-06,  -1.498636734719196e-08,   1.055418371612936e-10,  -7.432211459709007e-13,   5.230597525685326e-15,  -3.667255414699576e-17,
   2.518270167989767e-19,  -1.554004218232514e-21,   4.290408948141714e-02,  -3.021564575015923e-04,   2.127967777649474e-06,  -1.498641944383456e-08,   1.055423871160256e-10,
  -7.432265439794584e-13,   5.230646945127259e-15,  -3.667294607472613e-17,   2.518283906281613e-19,  -1.553949158719539e-21,   8.514552404112209e-02,  -5.995877525510684e-04,
   4.222041804552432e-06,  -2.972835291434738e-08,   2.093121004422785e-10,  -1.473543463169502e-12,   1.036709600342386e-14,  -7.266484435039427e-17,   4.990214676124385e-19,
  -3.085241915829296e-21,   8.514612522834342e-02,  -5.996004516553542e-04,   4.222220649978789e-06,  -2.973045171075419e-08,   2.093342537857432e-10,  -1.473760870208814e-12,
   1.036908551216948e-14,  -7.268058867380742e-17,   4.990751418840591e-19,  -3.082963250826378e-21,   8.514711219291009e-02,  -5.996212999389788e-04,   4.222514267379076e-06,
  -2.973389744855782e-08,   2.093706251556057e-10,  -1.474117813027679e-12,   1.037235176486347e-14,  -7.270642697700832e-17,   4.991628081901141e-19,  -3.079207248260934e-21,
   8.514815946367102e-02,  -5.996434224610044e-04,   4.222825836740000e-06,  -2.973755394692201e-08,   2.094092221644878e-10,  -1.474496603117001e-12,   1.037581771743761e-14,
  -7.273383176013337e-17,   4.992552180313552e-19,  -3.075201144143270e-21,   8.514898368941988e-02,  -5.996608336405731e-04,   4.223071056936789e-06,  -2.974043185064648e-08,
   2.094396012358153e-10,  -1.474794746329326e-12,   1.037854558893575e-14,  -7.275539100653323e-17,   4.993275019257385e-19,  -3.072033311793917e-21,   8.514945937349531e-02,
  -5.996708822287174e-04,   4.223212583708265e-06,  -2.974209283347345e-08,   2.094571348035385e-10,  -1.474966824001614e-12,   1.038011995630489e-14,  -7.276782986919754e-17,
   4.993690404674374e-19,  -3.070199070359029e-21,   8.514963799897154e-02,  -5.996746556218666e-04,   4.223265729439123e-06,  -2.974271656573416e-08,   2.094637190615833e-10,
  -1.475031443410062e-12,   1.038071115810989e-14,  -7.277250014222160e-17,   4.993846049436651e-19,  -3.069509155044417e-21,   8.514966760877361e-02,  -5.996752811183448e-04,
   4.223274539158583e-06,  -2.974281995916496e-08,   2.094648105086813e-10,  -1.475042155135494e-12,   1.038080915886185e-14,  -7.277327427284853e-17,   4.993871832019077e-19,
  -3.069394731573894e-21,   1.432440757600907e-01,  -1.008712958349671e-03,   7.102927393299444e-06,  -5.001331977741384e-08,   3.521348726881818e-10,  -2.478999027935244e-12,
   1.744055401054518e-14,  -1.222245966477548e-16,   8.385811485171260e-19,  -5.156072740409688e-21,   1.432450871639042e-01,  -1.008734322613076e-03,   7.103228272752060e-06,
  -5.001685066300605e-08,   3.521721411874298e-10,  -2.479364710682772e-12,   1.744389713175746e-14,  -1.222509010692638e-16,   8.386641119151811e-19,  -5.151983769277562e-21,
   1.432467475779834e-01,  -1.008769396600407e-03,   7.103722238096097e-06,  -5.002264755963378e-08,   3.522333286212836e-10,  -2.479965094859074e-12,   1.744938564083750e-14,
  -1.222940686922628e-16,   8.387995184515697e-19,  -5.145244284150306e-21,   1.432485094478365e-01,  -1.008806614295212e-03,   7.104246404804707e-06,  -5.002879902672256e-08,
   3.522982602320697e-10,  -2.480602226003964e-12,   1.745520969071564e-14,  -1.223398519708687e-16,   8.389421179144632e-19,  -5.138056723963414e-21,   1.432498960792153e-01,
  -1.008835905890743e-03,   7.104658949423514e-06,  -5.003364063418955e-08,   3.523493668298205e-10,  -2.481103707394532e-12,   1.745979347750425e-14,  -1.223758684723644e-16,
   8.390535629396848e-19,  -5.132373647077359e-21,   1.432506963435436e-01,  -1.008852811073899e-03,   7.104897046075788e-06,  -5.003643496907512e-08,   3.523788634826638e-10,
  -2.481393144486617e-12,   1.746243896193462e-14,  -1.223966482008427e-16,   8.391175662912166e-19,  -5.129083224413555e-21,   1.432509968530712e-01,  -1.008859159219666e-03,
   7.104986455453681e-06,  -5.003748429768826e-08,   3.523899401539361e-10,  -2.481501835221462e-12,   1.746343238488927e-14,  -1.224044500410879e-16,   8.391415408257426e-19,
  -5.127845631353334e-21,   1.432510466669489e-01,  -1.008860211519987e-03,   7.105001276428453e-06,  -5.003765824040695e-08,   3.523917762910496e-10,  -2.481519852489602e-12,
   1.746359705987242e-14,  -1.224057432468397e-16,   8.391455118150619e-19,  -5.127640376690389e-21,   2.190938654642132e-01,  -1.542840916778768e-03,   1.086402915365833e-05,
  -7.649608598307404e-08,   5.385950751492843e-10,  -3.791646746871500e-12,   2.667456047419501e-14,  -1.868950504370891e-16,   1.280566863469785e-18,  -7.811337788564321e-21,
   2.190954124208276e-01,  -1.542873593724289e-03,   1.086448935285887e-05,  -7.650148649656590e-08,   5.386520755807243e-10,  -3.792205910369102e-12,   2.667966530294976e-14,
  -1.869348843331627e-16,   1.280677709501324e-18,  -7.804522913576827e-21,   2.190979520479361e-01,  -1.542927239888041e-03,   1.086524487954580e-05,  -7.651035288916752e-08,
   5.387456588940776e-10,  -3.793123953695033e-12,   2.668804601759849e-14,  -1.870002525580748e-16,   1.280858390584857e-18,  -7.793291588391612e-21,   2.191006468531036e-01,
  -1.542984164882931e-03,   1.086604659962713e-05,  -7.651976159947271e-08,   5.388449687329020e-10,  -3.794098185403487e-12,   2.669693902569464e-14,  -1.870695784666810e-16,
   1.281048350048631e-18,  -7.781314934515127e-21,   2.191027677256516e-01,  -1.543028966795954e-03,   1.086667759220864e-05,  -7.652716687051646e-08,   5.389231338529219e-10,
  -3.794864995410763e-12,   2.670393817382279e-14,  -1.871241130329542e-16,   1.281196574519075e-18,  -7.771846205798361e-21,   2.191039917414003e-01,  -1.543054823514632e-03,
   1.086704176426224e-05,  -7.653144082437424e-08,   5.389682475808378e-10,  -3.795307570337889e-12,   2.670797764040972e-14,  -1.871555758377254e-16,   1.281281606030804e-18,
  -7.766364342580757e-21,   2.191044513750255e-01,  -1.543064533094098e-03,   1.086717851711628e-05,  -7.653304577947973e-08,   5.389851888218596e-10,  -3.795473768026205e-12,
   2.670949452315206e-14,  -1.871673885107164e-16,   1.281313439392176e-18,  -7.764302580650610e-21,   2.191045275660647e-01,  -1.543066142602442e-03,   1.086720118599785e-05,
  -7.653331182602635e-08,   5.389879971060500e-10,  -3.795501318009684e-12,   2.670974596938392e-14,  -1.871693465288312e-16,   1.281318711117646e-18,  -7.763960641643671e-21,
   3.157379309550433e-01,  -2.223400448766263e-03,   1.565623970570538e-05,  -1.102391185670641e-07,   7.761731711999112e-10,  -5.464136302502827e-12,   3.843884060401322e-14,
  -2.692348096236293e-16,   1.841198007807207e-18,  -1.110187876033648e-20,   3.157401602866491e-01,  -2.223447539772434e-03,   1.565690290200118e-05,  -1.102469012361302e-07,
   7.762553103238106e-10,  -5.464941801965131e-12,   3.844617963466198e-14,  -2.692913883855295e-16,   1.841324391019964e-18,  -1.109088679679603e-20,   3.157438201636795e-01,
  -2.223524849685814e-03,   1.565799169680615e-05,  -1.102596785762444e-07,   7.763901663178044e-10,  -5.466264281751905e-12,   3.845822819392358e-14,  -2.693842303635942e-16,
   1.841529840993453e-18,  -1.107277327354629e-20,   3.157477036690574e-01,  -2.223606884748808e-03,   1.565914706123168e-05,  -1.102732374488422e-07,   7.765332743477028e-10,
  -5.467667700859823e-12,   3.847101312268090e-14,  -2.694826867217250e-16,   1.841745077516686e-18,  -1.105346027699831e-20,   3.157507600755260e-01,  -2.223671449142064e-03,
   1.566005638905834e-05,  -1.102839091690207e-07,   7.766459122678656e-10,  -5.468772319109758e-12,   3.848107527103275e-14,  -2.695601316243460e-16,   1.841912466384074e-18,
  -1.103819329692377e-20,   3.157525240144555e-01,  -2.223708711465033e-03,   1.566058119995313e-05,  -1.102900683546066e-07,   7.767109222831857e-10,  -5.469409864006351e-12,
   3.848688246995762e-14,  -2.696048102137124e-16,   1.842008265454546e-18,  -1.102935531102304e-20,   3.157531863961656e-01,  -2.223722704017236e-03,   1.566077827544780e-05,
  -1.102923812518854e-07,   7.767353350350960e-10,  -5.469649277545443e-12,   3.848906315657256e-14,  -2.696215843683043e-16,   1.842044086784300e-18,  -1.102603143051494e-20,
   3.157532961956844e-01,  -2.223725023492515e-03,   1.566081094373161e-05,  -1.102927646509784e-07,   7.767393818427260e-10,  -5.469688964246000e-12,   3.848942463794475e-14,
  -2.696243647608853e-16,   1.842050016650951e-18,  -1.102548017906641e-20,   4.383647784385849e-01,  -3.086928586557965e-03,   2.173683724637732e-05,  -1.530539674047217e-07,
   1.077623601025779e-09,  -7.586233161731319e-12,   5.336352696484791e-14,  -3.735930365421771e-16,   2.547544992977214e-18,  -1.509199229638691e-20,   4.383678736018659e-01,
  -3.086993966845602e-03,   2.173775801504781e-05,  -1.530647726096711e-07,   1.077737631964503e-09,  -7.587350854374143e-12,   5.337368006081458e-14,  -3.736698752364623e-16,
   2.547650834127195e-18,  -1.507427056583335e-20,   4.383729549082840e-01,  -3.087101302508676e-03,   2.173926967629716e-05,  -1.530825122530100e-07,   1.077924847877016e-09,
  -7.589185893450654e-12,   5.339034829812556e-14,  -3.737959519625835e-16,   2.547821416009231e-18,  -1.504507049820278e-20,   4.383783466962147e-01,  -3.087215198482597e-03,
   2.174087376148764e-05,  -1.531013369497163e-07,   1.078123519730066e-09,  -7.591133236887261e-12,   5.340803497138032e-14,  -3.739296386159828e-16,   2.547998095907739e-18,
  -1.501394135731937e-20,   4.383825901551276e-01,  -3.087304838499675e-03,   2.174213625430898e-05,  -1.531161532174636e-07,   1.078279890944840e-09,  -7.592665969359355e-12,
   5.342195475112506e-14,  -3.740347850202462e-16,   2.548134009654833e-18,  -1.498933696055080e-20,   4.383850391757174e-01,  -3.087356572824089e-03,   2.174286489140295e-05,
  -1.531247044293016e-07,   1.078370142012812e-09,  -7.593550604540733e-12,   5.342998823711820e-14,  -3.740954406759491e-16,   2.548211189798008e-18,  -1.497509489598070e-20,
   4.383859588143845e-01,  -3.087375999826416e-03,   2.174313850713181e-05,  -1.531279155801927e-07,   1.078404033354790e-09,  -7.593882806188042e-12,   5.343300491142219e-14,
  -3.741182124830277e-16,   2.548239933635414e-18,  -1.496973884095627e-20,   4.383861112580308e-01,  -3.087379220143264e-03,   2.174318386313256e-05,  -1.531284478789437e-07,
   1.078409651391480e-09,  -7.593937874017073e-12,   5.343350496944202e-14,  -3.741219869723391e-16,   2.548244685772707e-18,  -1.496885057501232e-20,   5.970412118079250e-01,
  -4.204314931790991e-03,   2.960499609934629e-05,  -2.084554221095221e-07,   1.467692517164728e-09,  -1.033208899709168e-11,   7.267046348244714e-14,  -5.083698050718548e-16,
   3.450437168265977e-18,  -1.984064500046437e-20,   5.970454273382586e-01,  -4.204403977998411e-03,   2.960625015981884e-05,  -2.084701382732682e-07,   1.467847803589976e-09,
  -1.033360984687785e-11,   7.268421176314504e-14,  -5.084706477443637e-16,   3.450425154230907e-18,  -1.981093148746852e-20,   5.970523479428909e-01,  -4.204550166307738e-03,
   2.960830899899262e-05,  -2.084942988034600e-07,   1.468102752608068e-09,  -1.033610678530942e-11,   7.270678172748320e-14,  -5.086360859794457e-16,   3.450400289567148e-18,
  -1.976197840061973e-20,   5.970596914151118e-01,  -4.204705289585302e-03,   2.961049371690019e-05,  -2.085199371215021e-07,   1.468373302060803e-09,  -1.033875652527422e-11,
   7.273073010970256e-14,  -5.088114770686642e-16,   3.450366905774745e-18,  -1.970979916267535e-20,   5.970654708936534e-01,  -4.204827376896756e-03,   2.961221319580993e-05,
  -2.085401161535192e-07,   1.468586246783036e-09,  -1.034084209825813e-11,   7.274957753764616e-14,  -5.089494006891093e-16,   3.450335554218281e-18,  -1.966856250502183e-20,
   5.970688063947708e-01,  -4.204897837666185e-03,   2.961320557856909e-05,  -2.085517624852285e-07,   1.468709149716516e-09,  -1.034204580883994e-11,   7.276045472479995e-14,
  -5.090289548866181e-16,   3.450315421742180e-18,  -1.964469525430508e-20,   5.970700589182550e-01,  -4.204924296724978e-03,   2.961357823531893e-05,  -2.085561359153595e-07,
   1.468755302572245e-09,  -1.034249783031402e-11,   7.276453921042537e-14,  -5.090588199096960e-16,   3.450307476042661e-18,  -1.963571985497911e-20,   5.970702665424599e-01,
  -4.204928682710597e-03,   2.961364000888684e-05,  -2.085568608801640e-07,   1.468762953152165e-09,  -1.034257276019700e-11,   7.276521627204303e-14,  -5.090637700229739e-16,
   3.450306138569559e-18,  -1.963423136749320e-20,   8.176455482962458e-01,  -5.757792456931497e-03,   4.054392303668706e-05,  -2.854788001513698e-07,   2.009993170099051e-09,
  -1.414933920481397e-11,   9.949757970782537e-14,  -6.950015922045540e-16,   4.673427511935069e-18,  -2.521674025179301e-20,   8.176513214480651e-01,  -5.757914405325732e-03,
   4.054564046217310e-05,  -2.854989532556125e-07,   2.010205779724516e-09,  -1.415141822225463e-11,   9.951619191469163e-14,  -6.951292531801681e-16,   4.672975842765705e-18,
  -2.516020996010734e-20,   8.176607991882445e-01,  -5.758114609580096e-03,   4.054846002542652e-05,  -2.855320399781194e-07,   2.010554841555327e-09,  -1.415483154070675e-11,
   9.954674551044664e-14,  -6.953386175900536e-16,   4.672224933343709e-18,  -2.506708568586666e-20,   8.176708560438833e-01,  -5.758327050234363e-03,   4.055145197852038e-05,
  -2.855671504570594e-07,   2.010925262171777e-09,  -1.415845370870472e-11,   9.957916338186135e-14,  -6.955604809787836e-16,   4.671415332359537e-18,  -2.496783712745149e-20,
   8.176787710164749e-01,  -5.758494248276460e-03,   4.055380679062330e-05,  -2.855947846949534e-07,   2.011216813405817e-09,  -1.416130464404596e-11,   9.960467506210458e-14,
  -6.957348792832819e-16,   4.670768865727459e-18,  -2.488941138767173e-20,   8.176833389718244e-01,  -5.758590743993692e-03,   4.055516585056610e-05,  -2.856107337984371e-07,
   2.011385084652832e-09,  -1.416295008278146e-11,   9.961939780464222e-14,  -6.958354438678782e-16,   4.670392040617686e-18,  -2.484402326504888e-20,   8.176850542976927e-01,
  -5.758626979559599e-03,   4.055567620088598e-05,  -2.856167230050020e-07,   2.011448274320579e-09,  -1.416356798183222e-11,   9.962492623701583e-14,  -6.958731909557803e-16,
   4.670249832062364e-18,  -2.482695552946944e-20,   8.176853386382051e-01,  -5.758632986147823e-03,   4.055576079927339e-05,  -2.856177158101385e-07,   2.011458749025448e-09,
  -1.416367040852265e-11,   9.962584264832459e-14,  -6.958794472358943e-16,   4.670226221644684e-18,  -2.482412503901769e-20,   1.649176446763071e-03,  -1.129521921100207e-05,
   7.735746105541729e-08,  -5.297728152839110e-10,   3.627906543353891e-12,  -2.484234282002190e-14,   1.700711001048322e-16,  -1.162855906196826e-18,   7.895794822421121e-21,
  -5.173737010307904e-23,   1.649187461531583e-03,  -1.129544550769970e-05,   7.736056078114076e-08,  -5.298081971431586e-10,   3.628269953080661e-12,  -2.484582219688265e-14,
   1.701025988857235e-16,  -1.163120932487014e-18,   7.897587250546233e-21,  -5.173642846004636e-23,   1.649205544376454e-03,  -1.129581702128914e-05,   7.736564970713101e-08,
  -5.298662857737067e-10,   3.628866597598244e-12,  -2.485153472972107e-14,   1.701543143833855e-16,  -1.163556011878457e-18,   7.900527589248450e-21,  -5.173479230988573e-23,
   1.649224732107067e-03,  -1.129621124078663e-05,   7.737104975614581e-08,  -5.299279271696012e-10,   3.629499749653233e-12,  -2.485759694682876e-14,   1.702091955207981e-16,
  -1.164017658908046e-18,   7.903644488851654e-21,  -5.173293330329660e-23,   1.649239833266594e-03,  -1.129652150436666e-05,   7.737529984410780e-08,  -5.299764427979364e-10,
   3.629998091516060e-12,  -2.486236850703009e-14,   1.702523923279289e-16,  -1.164380973179501e-18,   7.906095308133171e-21,  -5.173138108776441e-23,   1.649248548567207e-03,
  -1.129670056786068e-05,   7.737775274157604e-08,  -5.300044435291748e-10,   3.630285713539183e-12,  -2.486512249359858e-14,   1.702773240788465e-16,  -1.164590647151771e-18,
   7.907508841370252e-21,  -5.173044947616356e-23,   1.649251821273096e-03,  -1.129676780879887e-05,   7.737867384571318e-08,  -5.300149583493559e-10,   3.630393722096076e-12,
  -2.486615668563241e-14,   1.702866865825976e-16,  -1.164669381467763e-18,   7.908039470142320e-21,  -5.173009287407226e-23,   1.649252363772200e-03,  -1.129677895498987e-05,
   7.737882653279185e-08,  -5.300167013454021e-10,   3.630411626251742e-12,  -2.486632812001740e-14,   1.702882385718286e-16,  -1.164682432789254e-18,   7.908127420640611e-21,
  -5.173003340472301e-23,   1.490119169726311e-02,  -1.020583498239621e-04,   6.989660557911926e-07,  -4.786780868629054e-09,   3.278007631599604e-11,  -2.244638149577824e-13,
   1.536680733433515e-15,  -1.050689454761135e-17,   7.133718191908116e-20,  -4.672688293774870e-22,   1.490129122159079e-02,  -1.020603945357167e-04,   6.989940634712246e-07,
  -4.787100562591889e-09,   3.278335991138242e-11,  -2.244952525809692e-13,   1.536965318721812e-15,  -1.050928810316267e-17,   7.135333238888956e-20,  -4.672587096222279e-22,
   1.490145460977060e-02,  -1.020637513597945e-04,   6.990400446397359e-07,  -4.787625424339567e-09,   3.278875090405025e-11,  -2.245468676988139e-13,   1.537432557941287e-15,
  -1.051321746839541e-17,   7.137982568338807e-20,  -4.672412725060617e-22,   1.490162798118434e-02,  -1.020673133439015e-04,   6.990888369711964e-07,  -4.788182387215775e-09,
   3.279447176120524e-11,  -2.246016423567630e-13,   1.537928397911768e-15,  -1.051738676770303e-17,   7.140790944285770e-20,  -4.672216486924220e-22,   1.490176442824152e-02,
  -1.020701167413695e-04,   6.991272387894000e-07,  -4.788620751783625e-09,   3.279897453832969e-11,  -2.246447553893843e-13,   1.538318672196728e-15,  -1.052066798275459e-17,
   7.142999142300611e-20,  -4.672053909957401e-22,   1.490184317564624e-02,  -1.020717346758549e-04,   6.991494020301338e-07,  -4.788873753318636e-09,   3.280157335242866e-11,
  -2.246696388034740e-13,   1.538543925397693e-15,  -1.052256161748340e-17,   7.144272729766427e-20,  -4.671956817080199e-22,   1.490187274629523e-02,  -1.020723422337122e-04,
   6.991577246987312e-07,  -4.788968760324795e-09,   3.280254926573550e-11,  -2.246789831584674e-13,   1.538628513668584e-15,  -1.052327269257910e-17,   7.144750821837735e-20,
  -4.671919739734104e-22,   1.490187764806493e-02,  -1.020724429455122e-04,   6.991591043081626e-07,  -4.788984509223324e-09,   3.280271103906392e-11,  -2.246805321394007e-13,
   1.538642535567453e-15,  -1.052339056326451e-17,   7.144830064382199e-20,  -4.671913561016166e-22,   4.172649045319079e-02,  -2.857849792208568e-04,   1.957252885624379e-06,
  -1.340399946775515e-08,   9.179114749957747e-11,  -6.285459213285987e-13,   4.303015837114855e-15,  -2.942076966861640e-17,   1.997270041856071e-19,  -1.307255513111561e-21,
   4.172676914237163e-02,  -2.857907048464947e-04,   1.957331313052607e-06,  -1.340489467811237e-08,   9.180034222704490e-11,  -6.286339509570313e-13,   4.303812602372695e-15,
  -2.942746575021379e-17,   1.997719669860109e-19,  -1.307217804606381e-21,   4.172722666385462e-02,  -2.858001046643213e-04,   1.957460070050277e-06,  -1.340636440143051e-08,
   9.181543809052820e-11,  -6.287784803062173e-13,   4.305120750691502e-15,  -2.943845829476687e-17,   1.998457224317379e-19,  -1.307153545854479e-21,   4.172771214050546e-02,
  -2.858100789736477e-04,   1.957596698898786e-06,  -1.340792401465892e-08,   9.183145764062539e-11,  -6.289318567788999e-13,   4.306508972667588e-15,  -2.945012201586443e-17,
   1.999239032886325e-19,  -1.307082157345359e-21,   4.172809422114325e-02,  -2.858179290798440e-04,   1.957704232112383e-06,  -1.340915152767054e-08,   9.184406632156421e-11,
  -6.290525791053120e-13,   4.307601637657229e-15,  -2.945930126385342e-17,   1.999853744248126e-19,  -1.307023649352007e-21,   4.172831473054261e-02,  -2.858224596388084e-04,
   1.957766293874324e-06,  -1.340985998519320e-08,   9.185134352328254e-11,  -6.291222560271914e-13,   4.308232286873134e-15,  -2.946459872125678e-17,   2.000208274802167e-19,
  -1.306988949893082e-21,   4.172839753461811e-02,  -2.858241609293867e-04,   1.957789599106776e-06,  -1.341012602479716e-08,   9.185407627663963e-11,  -6.291484214828317e-13,
   4.308469111539582e-15,  -2.946658795654588e-17,   2.000341360759170e-19,  -1.306975743317319e-21,   4.172841126061069e-02,  -2.858244429437406e-04,   1.957793462304993e-06,
  -1.341017012502613e-08,   9.185452927446480e-11,  -6.291527588385322e-13,   4.308508369125054e-15,  -2.946691770009790e-17,   2.000363419349951e-19,  -1.306973544818596e-21,
   8.281254387443640e-02,  -5.671836014263049e-04,   3.884464968331051e-06,  -2.660226815953162e-08,   1.821734310382158e-10,  -1.247443795376531e-12,   8.539938263785456e-15,
  -5.838757693452437e-17,   3.962865833800417e-19,  -2.590656885956827e-21,   8.281309697535041e-02,  -5.671949647980288e-04,   3.884620619437072e-06,  -2.660404483889337e-08,
   1.821916792591392e-10,  -1.247618496020441e-12,   8.541519141727098e-15,  -5.840084610477130e-17,   3.963749878812095e-19,  -2.590552278859240e-21,   8.281400499606961e-02,
  -5.672136201609280e-04,   3.884876157193990e-06,  -2.660696172547635e-08,   1.822216391080734e-10,  -1.247905324069518e-12,   8.544114662715191e-15,  -5.842262917209448e-17,
   3.965199981444807e-19,  -2.590375727315953e-21,   8.281496849805593e-02,  -5.672334156892649e-04,   3.885147317830678e-06,  -2.661005701207142e-08,   1.822534321411854e-10,
  -1.248209709761582e-12,   8.546869056109784e-15,  -5.844574210525231e-17,   3.966737017371714e-19,  -2.590181827543369e-21,   8.281572679498497e-02,  -5.672489954145940e-04,
   3.885360733774477e-06,  -2.661249319592076e-08,   1.822784558277367e-10,  -1.248449291111417e-12,   8.549037027844684e-15,  -5.846393167392544e-17,   3.967945486001102e-19,
  -2.590024465290023e-21,   8.281616442930563e-02,  -5.672579869954066e-04,   3.885483904737686e-06,  -2.661389923622709e-08,   1.822928984496420e-10,  -1.248587569501447e-12,
   8.550288306753223e-15,  -5.847442905430330e-17,   3.968642440223274e-19,  -2.589931736628787e-21,   8.281632876654221e-02,  -5.672613634643678e-04,   3.885530157500075e-06,
  -2.661442723175803e-08,   1.822983219798217e-10,  -1.248639496549283e-12,   8.550758193326254e-15,  -5.847837089156530e-17,   3.968904063257285e-19,  -2.589896554389110e-21,
   8.281635600785463e-02,  -5.672619231645887e-04,   3.885537824601855e-06,  -2.661451475528257e-08,   1.822992210171837e-10,  -1.248648104313488e-12,   8.550836084748517e-15,
  -5.847902430574173e-17,   3.968947426258385e-19,  -2.589890703339181e-21,   1.393192001838957e-01,  -9.541980237521183e-04,   6.535006980608073e-06,  -4.475417035185819e-08,
   3.064783799973940e-10,  -2.098627738102464e-12,   1.436699588464236e-14,  -9.822211669957288e-17,   6.664401259406183e-19,  -4.349054892919247e-21,   1.393201306899919e-01,
  -9.542171408541100e-04,   6.535268839312014e-06,  -4.475715933493914e-08,   3.065090795180485e-10,  -2.098921626332419e-12,   1.436965442538254e-14,  -9.824439027235478e-17,
   6.665868048117757e-19,  -4.348805399088792e-21,   1.393216582933521e-01,  -9.542485255948269e-04,   6.535698741723367e-06,  -4.476206653699240e-08,   3.065594818545815e-10,
  -2.099404139546387e-12,   1.437401927161659e-14,  -9.828095495998967e-17,   6.668273891126617e-19,  -4.348387330227760e-21,   1.393232792352984e-01,  -9.542818284862012e-04,
   6.536154927192491e-06,  -4.476727386892918e-08,   3.066129682086976e-10,  -2.099916188761006e-12,   1.437865128315130e-14,  -9.831975156115405e-17,   6.670823777805887e-19,
  -4.347932175888827e-21,   1.393245549517136e-01,  -9.543080389460296e-04,   6.536513966224057e-06,  -4.477137236433986e-08,   3.066550662905452e-10,  -2.100319221536230e-12,
   1.438229711469126e-14,  -9.835028369298846e-17,   6.672828448172315e-19,  -4.347565588099667e-21,   1.393252912032601e-01,  -9.543231658794446e-04,   6.536721182154350e-06,
  -4.477373780557121e-08,   3.066793635363568e-10,  -2.100551838612937e-12,   1.438440136127867e-14,  -9.836790397910815e-17,   6.673984537628791e-19,  -4.347350659250607e-21,
   1.393255676750514e-01,  -9.543288462622625e-04,   6.536798995211387e-06,  -4.477462607484146e-08,   3.066884876998970e-10,  -2.100639192225953e-12,   1.438519155814569e-14,
  -9.837452049482699e-17,   6.674418500798815e-19,  -4.347269314907740e-21,   1.393256135043145e-01,  -9.543297878706571e-04,   6.536811893914021e-06,  -4.477477331937799e-08,
   3.066900001767550e-10,  -2.100653672526931e-12,   1.438532254624065e-14,  -9.837561727294305e-17,   6.674490427964664e-19,  -4.347255797329362e-21,   2.130907120573605e-01,
  -1.459459543638854e-03,   9.995386767462112e-06,  -6.845214383073561e-08,   4.687630088898987e-10,  -3.209876752409963e-12,   2.197426804627921e-14,  -1.502194060411270e-16,
   1.018787020944677e-18,  -6.631683851433416e-21,   2.130921352797609e-01,  -1.459488783519827e-03,   9.995787284043310e-06,  -6.845671551652513e-08,   4.688099636689245e-10,
  -3.210326218892568e-12,   2.197833206690097e-14,  -1.502533656729253e-16,   1.019006905411956e-18,  -6.631141598369835e-21,   2.130944717709775e-01,  -1.459536786929720e-03,
   9.996444825844891e-06,  -6.846422114140260e-08,   4.688870538129349e-10,  -3.211064164231760e-12,   2.198500444594422e-14,  -1.503091137941036e-16,   1.019367532033892e-18,
  -6.630237606645113e-21,   2.130969510248984e-01,  -1.459587724178481e-03,   9.997142567953541e-06,  -6.847218581851020e-08,   4.689688609430792e-10,  -3.211847280982462e-12,
   2.199208521349790e-14,  -1.503682639630339e-16,   1.019749708942937e-18,  -6.629259619603954e-21,   2.130989022514253e-01,  -1.459627813451731e-03,   9.997691723215524e-06,
  -6.847845451671468e-08,   4.690332497602807e-10,  -3.212463670173185e-12,   2.199765843533570e-14,  -1.504148133376655e-16,   1.020050138848228e-18,  -6.628476314385573e-21,
   2.131000283587097e-01,  -1.459650950312781e-03,   9.998008662902943e-06,  -6.848207248761552e-08,   4.690704122815330e-10,  -3.212819429366217e-12,   2.200087509924977e-14,
  -1.504416770352491e-16,   1.020223384121732e-18,  -6.628018783900842e-21,   2.131004512262740e-01,  -1.459659638539559e-03,   9.998127679070927e-06,  -6.848343110617768e-08,
   4.690843676457664e-10,  -3.212953025950343e-12,   2.200208303550861e-14,  -1.504517644580140e-16,   1.020288413196344e-18,  -6.627845941813159e-21,   2.131005213227882e-01,
  -1.459661078743068e-03,   9.998147407818490e-06,  -6.848365631847203e-08,   4.690866809718295e-10,  -3.212975171784974e-12,   2.200228327071125e-14,  -1.504534365841163e-16,
   1.020299191310759e-18,  -6.627817236146065e-21,   3.070867383178907e-01,  -2.103238881797421e-03,   1.440443221788482e-05,  -9.864693337324828e-08,   6.755380132715217e-10,
  -4.625770176716433e-12,   3.166676801357089e-14,  -2.164563486626041e-16,   1.467068351759994e-18,  -9.515260643650283e-21,   3.070887893351321e-01,  -2.103281019624309e-03,
   1.440500940543440e-05,  -9.865352165287112e-08,   6.756056790022749e-10,  -4.626417825066499e-12,   3.167262007581849e-14,  -2.165050654702093e-16,   1.467376003295554e-18,
  -9.514145774596742e-21,   3.070921564714058e-01,  -2.103350197723150e-03,   1.440595699402055e-05,  -9.866433804693891e-08,   6.757167722861459e-10,  -4.627481149890444e-12,
   3.168222806625823e-14,  -2.165850377052297e-16,   1.467880509989969e-18,  -9.512293939908205e-21,   3.070957293441600e-01,  -2.103423603800697e-03,   1.440696251557976e-05,
  -9.867581598338890e-08,   6.758346631281458e-10,  -4.628609562742686e-12,   3.169242408614778e-14,  -2.166698885544708e-16,   1.468415077230379e-18,  -9.510299597125088e-21,
   3.070985412723924e-01,  -2.103481376773765e-03,   1.440775390748218e-05,  -9.868484983598360e-08,   6.759274527332619e-10,  -4.629497733143216e-12,   3.170044927513365e-14,
  -2.167366623318097e-16,   1.468835237705295e-18,  -9.508708709947075e-21,   3.071001641146520e-01,  -2.103514719489706e-03,   1.440821065172081e-05,  -9.869006371206043e-08,
   6.759810069937795e-10,  -4.630010355158355e-12,   3.170508111623800e-14,  -2.167751970545970e-16,   1.469077500936637e-18,  -9.507782014880697e-21,   3.071007735124980e-01,
  -2.103527240162966e-03,   1.440838216684236e-05,  -9.869202162410288e-08,   6.760011178249820e-10,  -4.630202857668065e-12,   3.170682048430669e-14,  -2.167896668978684e-16,
   1.469168431632195e-18,  -9.507432411596283e-21,   3.071008745291480e-01,  -2.103529315651789e-03,   1.440841059809328e-05,  -9.869234617867253e-08,   6.760044515186644e-10,
  -4.630234768128372e-12,   3.170710881292501e-14,  -2.167920654641551e-16,   1.469183502502987e-18,  -9.507374374343094e-21,   4.263536205401651e-01,  -2.920098461387969e-03,
   1.999885066407235e-05,  -1.369595982714580e-07,   9.379043859849099e-10,  -6.422316595231351e-12,   4.396449289661342e-14,  -3.004709032265067e-16,   2.034568640076640e-18,
  -1.312494121012021e-20,   4.263564681350506e-01,  -2.920156964776122e-03,   1.999965202049425e-05,  -1.369687452912013e-07,   9.379983294534428e-10,  -6.423215612203920e-12,
   4.397260830058716e-14,  -3.005380820842672e-16,   2.034976676490079e-18,  -1.312269898930029e-20,   4.263611430055678e-01,  -2.920253010383278e-03,   2.000096763480110e-05,
  -1.369837625300899e-07,   9.381525653911556e-10,  -6.424691639174213e-12,   4.398593222016218e-14,  -3.006483584982025e-16,   2.035645662222992e-18,  -1.311898441186691e-20,
   4.263661035168576e-01,  -2.920354926038728e-03,   2.000236368216443e-05,  -1.369996982393487e-07,   9.383162386730111e-10,  -6.426258015085282e-12,   4.400007151815869e-14,
  -3.007653586033736e-16,   2.036354319981718e-18,  -1.311499720005193e-20,   4.263700075466685e-01,  -2.920435136977845e-03,   2.000346243590783e-05,  -1.370122406372894e-07,
   9.384450627380445e-10,  -6.427490903942178e-12,   4.401120036978245e-14,  -3.008574297808872e-16,   2.036911175324436e-18,  -1.311182605006446e-20,   4.263722606712279e-01,
  -2.920481429394801e-03,   2.000409657108150e-05,  -1.370194794656042e-07,   9.385194145686755e-10,  -6.428202485442398e-12,   4.401762350821271e-14,  -3.009105624247552e-16,
   2.037232201215140e-18,  -1.310998259103364e-20,   4.263731067480694e-01,  -2.920498812868546e-03,   2.000433469947404e-05,  -1.370221977866488e-07,   9.385473353548547e-10,
  -6.428469702188878e-12,   4.402003554756859e-14,  -3.009305136098643e-16,   2.037352684111045e-18,  -1.310928783253283e-20,   4.263732469977417e-01,  -2.920501694439265e-03,
   2.000437417289200e-05,  -1.370226483909131e-07,   9.385519636741120e-10,  -6.428513997760139e-12,   4.402043538220604e-14,  -3.009338207699774e-16,   2.037372652417276e-18,
  -1.310917253329609e-20,   5.806823330419839e-01,  -3.977096723149015e-03,   2.723790459530603e-05,  -1.865353373881664e-07,   1.277400371688125e-09,  -8.746985927864214e-12,
   5.987617177655119e-14,  -4.091183299498238e-16,   2.766053611401175e-18,  -1.768728619227159e-20,   5.806862113907502e-01,  -3.977176403210558e-03,   2.723899602101981e-05,
  -1.865477953279868e-07,   1.277528315040607e-09,  -8.748210005062686e-12,   5.988720403588785e-14,  -4.092088180184370e-16,   2.766567040403357e-18,  -1.768268066459841e-20,
   5.806925784404995e-01,  -3.977307214777711e-03,   2.724078785202296e-05,  -1.865682483126964e-07,   1.277738371793582e-09,  -8.750219721324330e-12,   5.990531674612015e-14,
  -4.093573513699260e-16,   2.767408494225448e-18,  -1.767506589003301e-20,   5.806993345254110e-01,  -3.977446021194778e-03,   2.724268923066307e-05,  -1.865899522232908e-07,
   1.277961281395442e-09,  -8.752352451205706e-12,   5.992453772868708e-14,  -4.095149328990408e-16,   2.768299403643418e-18,  -1.766691242821416e-20,   5.807046517105474e-01,
  -3.977555266364397e-03,   2.724418570345394e-05,  -1.866070345553835e-07,   1.278136729187442e-09,  -8.754031113117780e-12,   5.993966618717652e-14,  -4.096389330452583e-16,
   2.768999147501738e-18,  -1.766044222105346e-20,   5.807077204064841e-01,  -3.977618315407303e-03,   2.724504937835602e-05,  -1.866168936005175e-07,   1.278237990259186e-09,
  -8.754999978806157e-12,   5.994839769472472e-14,  -4.097104889729013e-16,   2.769402418475090e-18,  -1.765668670266230e-20,   5.807088727407193e-01,  -3.977641991237038e-03,
   2.724537370276584e-05,  -1.866205958639916e-07,   1.278276016068787e-09,  -8.755363812073572e-12,   5.995167657187430e-14,  -4.097373576122871e-16,   2.769553743836627e-18,
  -1.765527241261007e-20,   5.807090637570559e-01,  -3.977645915859857e-03,   2.724542746449010e-05,  -1.866212095721142e-07,   1.278282319458033e-09,  -8.755424123413939e-12,
   5.995222009845617e-14,  -4.097418114039800e-16,   2.769578822538791e-18,  -1.765503775974266e-20,   7.952421293536088e-01,  -5.446618032606369e-03,   3.730220112303714e-05,
  -2.554593820435672e-07,   1.749393298913319e-09,  -1.197886190706160e-11,   8.199421280728921e-14,  -5.599846712623827e-16,   3.774925906412870e-18,  -2.371708223274032e-20,
   7.952474407366900e-01,  -5.446727154124410e-03,   3.730369582491445e-05,  -2.554764429915299e-07,   1.749568503434378e-09,  -1.198053733215143e-11,   8.200926654706489e-14,
  -5.601058882555206e-16,   3.775513818539648e-18,  -2.370648074975181e-20,   7.952561603857864e-01,  -5.446906300029981e-03,   3.730614972820925e-05,  -2.555044530237431e-07,
   1.749856153252153e-09,  -1.198328807531440e-11,   8.203398137615743e-14,  -5.603048455777681e-16,   3.776476359411596e-18,  -2.368897882571664e-20,   7.952654128169770e-01,
  -5.447096394849709e-03,   3.730875365641509e-05,  -2.555341761774245e-07,   1.750161403530232e-09,  -1.198620718208234e-11,   8.206020799776174e-14,  -5.605159001244999e-16,
   3.777494132045344e-18,  -2.367027466626733e-20,   7.952726946806963e-01,  -5.447246005662070e-03,   3.731080306814794e-05,  -2.555575701533126e-07,   1.750401659976282e-09,
  -1.198850479193053e-11,   8.208085013271180e-14,  -5.606819615093161e-16,   3.778292542622143e-18,  -2.365545771313012e-20,   7.952768972474742e-01,  -5.447332351068081e-03,
   3.731198586644772e-05,  -2.555710719548397e-07,   1.750540325838496e-09,  -1.198983089070220e-11,   8.209276377113364e-14,  -5.607777828351272e-16,   3.778752284069020e-18,
  -2.364686774129142e-20,   7.952784753645875e-01,  -5.447364775019924e-03,   3.731243002704454e-05,  -2.555761421442168e-07,   1.750592397981747e-09,  -1.199032887348198e-11,
   8.209723758520172e-14,  -5.608137616755463e-16,   3.778924725330986e-18,  -2.364363477675812e-20,   7.952787369606945e-01,  -5.447370149774798e-03,   3.731250365344700e-05,
  -2.555769826074662e-07,   1.750601029776270e-09,  -1.199041142228465e-11,   8.209797919047876e-14,  -5.608197255238556e-16,   3.778953299581037e-18,  -2.364309847896008e-20,
   1.605194371644427e-03,  -1.070083819958053e-05,   7.133275967601212e-08,  -4.754898907249612e-10,   3.169379929581294e-12,  -2.112444841397696e-14,   1.407838447626299e-16,
  -9.378403097896838e-19,   6.232269052688105e-21,  -4.088892006603590e-23,   1.605204528265637e-03,  -1.070104130298801e-05,   7.133546753680608e-08,  -4.755199760615586e-10,
   3.169680743645927e-12,  -2.112725445843621e-14,   1.408087113309169e-16,  -9.380500121178917e-19,   6.233880520972277e-21,  -4.089735233270269e-23,   1.605221202282421e-03,
  -1.070137473940119e-05,   7.133991311441920e-08,  -4.755693688997727e-10,   3.170174617015839e-12,  -2.113186148779684e-14,   1.408495384674473e-16,  -9.383943034710366e-19,
   6.236525650390623e-21,  -4.091116996719201e-23,   1.605238895082624e-03,  -1.070172855384682e-05,   7.134463046851293e-08,  -4.756217824456802e-10,   3.170698707025297e-12,
  -2.113675051807798e-14,   1.408928655208875e-16,  -9.387596653461909e-19,   6.239331850340913e-21,  -4.092579709323545e-23,   1.605252819684292e-03,  -1.070200701682767e-05,
   7.134834323391905e-08,  -4.756630350253136e-10,   3.171111206409970e-12,  -2.114059865668041e-14,   1.409269687050393e-16,  -9.390472375319700e-19,   6.241539990264880e-21,
  -4.093728371680389e-23,   1.605260855954415e-03,  -1.070216772692823e-05,   7.135048601677372e-08,  -4.756868438356141e-10,   3.171349283021570e-12,  -2.114281967153755e-14,
   1.409466521493881e-16,  -9.392132132642692e-19,   6.242814208450279e-21,  -4.094390283118658e-23,   1.605263873674590e-03,  -1.070222807586259e-05,   7.135129066690536e-08,
  -4.756957844961008e-10,   3.171438686020376e-12,  -2.114365371850234e-14,   1.409540438243262e-16,  -9.392755411066380e-19,   6.243292663039487e-21,  -4.094638647441426e-23,
   1.605264373906003e-03,  -1.070223807959887e-05,   7.135142404991356e-08,  -4.756972665499181e-10,   3.171453505998201e-12,  -2.114379197550827e-14,   1.409552691184950e-16,
  -9.392858729601883e-19,   6.243371972309580e-21,  -4.094679807353896e-23,   1.450379011305334e-02,  -9.668779932322795e-05,   6.445296549615996e-07,  -4.296305603205962e-09,
   2.863704349190783e-11,  -1.908706841927159e-13,   1.272056709906519e-15,  -8.473855902889829e-18,   5.631045255417077e-20,  -3.693989394329261e-22,   1.450388188356094e-02,
  -9.668963447119766e-05,   6.445541219327495e-07,  -4.296577440304365e-09,   2.863976150646528e-11,  -1.908960382022331e-13,   1.272281386691789e-15,  -8.475750385203904e-18,
   5.632500083442023e-20,  -3.694746817879746e-22,   1.450403254222511e-02,  -9.669264724761656e-05,   6.445942901051478e-07,  -4.297023731000673e-09,   2.864422391419159e-11,
  -1.909376650068744e-13,   1.272650271888410e-15,  -8.478860763341252e-18,   5.634888090120754e-20,  -3.695987941651505e-22,   1.450419240614265e-02,  -9.669584415046319e-05,
   6.446369139234645e-07,  -4.297497315405571e-09,   2.864895934526322e-11,  -1.909818398294305e-13,   1.273041744523331e-15,  -8.482161493413693e-18,   5.637421500670131e-20,
  -3.697301724359093e-22,   1.450431822236999e-02,  -9.669836021250406e-05,   6.446704607454701e-07,  -4.297870054513989e-09,   2.865268649587326e-11,  -1.910166096768581e-13,
   1.273349876760015e-15,  -8.484759458982829e-18,   5.639414981348362e-20,  -3.698333395576459e-22,   1.450439083437089e-02,  -9.669981231426047e-05,   6.446898219350841e-07,
  -4.298085179841933e-09,   2.865483764426193e-11,  -1.910366776512089e-13,   1.273527722419235e-15,  -8.486258905287974e-18,   5.640565326537334e-20,  -3.698927876479404e-22,
   1.450441810108750e-02,  -9.670035759917592e-05,   6.446970923795614e-07,  -4.298165963488607e-09,   2.865564544774739e-11,  -1.910442136804883e-13,   1.273594508355066e-15,
  -8.486821982981895e-18,   5.640997267679472e-20,  -3.699150936493329e-22,   1.450442262094600e-02,  -9.670044798828633e-05,   6.446982975664086e-07,  -4.298179354637069e-09,
   2.865577935410286e-11,  -1.910454629013197e-13,   1.273605579244601e-15,  -8.486915322260882e-18,   5.641068866790589e-20,  -3.699187902726799e-22,   4.061368191099934e-02,
  -2.707463011924917e-04,   1.804819442611159e-06,  -1.203056495256730e-08,   8.018978163181399e-11,  -5.344782465862432e-13,   3.562024165182099e-15,  -2.372839783016286e-17,
   1.576728738851842e-19,  -1.034079992166635e-21,   4.061393888784299e-02,  -2.707514399951945e-04,   1.804887955307760e-06,  -1.203132615387679e-08,   8.019739263920411e-11,
  -5.345492425776465e-13,   3.562653273138837e-15,  -2.373370109652514e-17,   1.577135413349579e-19,  -1.034289486084503e-21,   4.061436076398819e-02,  -2.707598764067863e-04,
   1.805000434690335e-06,  -1.203257586211850e-08,   8.020988831107070e-11,  -5.346658054499398e-13,   3.563686172764649e-15,  -2.374240803754710e-17,   1.577802939284860e-19,
  -1.034632743594684e-21,   4.061480841679100e-02,  -2.707688284113438e-04,   1.805119790401105e-06,  -1.203390199851002e-08,   8.022314850514632e-11,  -5.347895032461332e-13,
   3.564782318236077e-15,  -2.375164782146025e-17,   1.578511104757527e-19,  -1.034996066552826e-21,   4.061516072885539e-02,  -2.707758739175532e-04,   1.805213728601446e-06,
  -1.203494574676442e-08,   8.023358530370638e-11,  -5.348868653428018e-13,   3.565645105691457e-15,  -2.375892033662883e-17,   1.579068339309632e-19,  -1.035281350666462e-21,
   4.061536405782556e-02,  -2.707799401097915e-04,   1.805267944029317e-06,  -1.203554814313324e-08,   8.023960896753855e-11,  -5.349430594349158e-13,   3.566143083381109e-15,
  -2.376311775030659e-17,   1.579389891878198e-19,  -1.035445731475579e-21,   4.061544041040282e-02,  -2.707814670229578e-04,   1.805288302812325e-06,  -1.203577435441143e-08,
   8.024187098565683e-11,  -5.349641617300796e-13,   3.566330087683058e-15,  -2.376469397810305e-17,   1.579510630791797e-19,  -1.035507408480972e-21,   4.061545306696319e-02,
  -2.707817201315968e-04,   1.805291677590523e-06,  -1.203581185245633e-08,   8.024224595136014e-11,  -5.349676597826512e-13,   3.566361086783254e-15,  -2.376495526343977e-17,
   1.579530644610821e-19,  -1.035517629708181e-21,   8.060400667845820e-02,  -5.373370658009256e-04,   3.581937700542176e-06,  -2.387647932552686e-08,   1.591487713782750e-10,
  -1.060752873991791e-12,   7.069364652344519e-15,  -4.709199482699213e-17,   3.128994452626061e-19,  -2.051291189004303e-21,   8.060451668794874e-02,  -5.373472645336503e-04,
   3.582073674368937e-06,  -2.387799004457558e-08,   1.591638765486941e-10,  -1.060893774397407e-12,   7.070613103077925e-15,  -4.710251463115653e-17,   3.129799316838615e-19,
  -2.051698714412958e-21,   8.060535396509334e-02,  -5.373640078709519e-04,   3.582296906745386e-06,  -2.388047027946359e-08,   1.591886760584166e-10,  -1.061125107953780e-12,
   7.072662868755572e-15,  -4.711978609152605e-17,   3.131120428499047e-19,  -2.052366377840825e-21,   8.060624239992137e-02,  -5.373817744806296e-04,   3.582533786236948e-06,
  -2.388310219756365e-08,   1.592149928753558e-10,  -1.061370601640945e-12,   7.074838143504976e-15,  -4.713811448083561e-17,   3.132521952738198e-19,  -2.053072974240784e-21,
   8.060694161660532e-02,  -5.373957573554147e-04,   3.582720220828048e-06,  -2.388517367372378e-08,   1.592357062460177e-10,  -1.061563828840201e-12,   7.076550324168018e-15,
  -4.715254049075524e-17,   3.133624757957967e-19,  -2.053627729642068e-21,   8.060734515376070e-02,  -5.374038273301232e-04,   3.582827819558800e-06,  -2.388636922036147e-08,
   1.592476610979088e-10,  -1.061675353005829e-12,   7.077538548496912e-15,  -4.716086661219428e-17,   3.134261127251630e-19,  -2.053947351817046e-21,   8.060749668702134e-02,
  -5.374068577206982e-04,   3.582868224648223e-06,  -2.388681817083157e-08,   1.592521504074481e-10,  -1.061717233134585e-12,   7.077909653831463e-15,  -4.716399326483475e-17,
   3.134500074872492e-19,  -2.054067271311767e-21,   8.060752180588349e-02,  -5.374073600531496e-04,   3.582874922406867e-06,  -2.388689259136894e-08,   1.592528945823482e-10,
  -1.061724175454840e-12,   7.077971170763748e-15,  -4.716451155813075e-17,   3.134539683048808e-19,  -2.054087144310645e-21,   1.356036805135445e-01,  -9.039858786342838e-04,
   6.026051998248424e-06,  -4.016845565597415e-08,   2.677430002748835e-10,  -1.784550908992551e-12,   1.189307476368843e-14,  -7.922345817206795e-17,   5.263401850953122e-19,
  -3.448530327973512e-21,   1.356045385250362e-01,  -9.040030364127631e-04,   6.026280753016437e-06,  -4.017099720460108e-08,   2.677684123037947e-10,  -1.784787947321051e-12,
   1.189517481949864e-14,  -7.924114301673757e-17,   5.264750395430362e-19,  -3.449195615884100e-21,   1.356059471133569e-01,  -9.040312044685578e-04,   6.026656306692454e-06,
  -4.017516981205722e-08,   2.678101335048374e-10,  -1.785177122322794e-12,   1.189862278926065e-14,  -7.927017799769618e-17,   5.266963876634964e-19,  -3.450285403705821e-21,
   1.356074417665078e-01,  -9.040610940206623e-04,   6.027054819512285e-06,  -4.017959760279799e-08,   2.678544073315669e-10,  -1.785590119031284e-12,   1.190228187932011e-14,
  -7.930098967652455e-17,   5.269312042545737e-19,  -3.451438497839813e-21,   1.356086180896177e-01,  -9.040846180284520e-04,   6.027368466650387e-06,  -4.018308253758712e-08,
   2.678892542575872e-10,  -1.785915187229324e-12,   1.190516198441927e-14,  -7.932524102961303e-17,   5.271159691510287e-19,  -3.452343626928525e-21,   1.356092969779974e-01,
  -9.040981945033059e-04,   6.027549484742370e-06,  -4.018509385789385e-08,   2.679093663795035e-10,  -1.786102805523018e-12,   1.190682430249840e-14,  -7.933923792045400e-17,
   5.272225857031313e-19,  -3.452865046029131e-21,   1.356095519090946e-01,  -9.041032926632042e-04,   6.027617460006971e-06,  -4.018584914687072e-08,   2.679169189231257e-10,
  -1.786173260908349e-12,   1.190744854840422e-14,  -7.934449407359020e-17,   5.272626184593056e-19,  -3.453060664581225e-21,   1.356095941676658e-01,  -9.041041377592721e-04,
   6.027628727941840e-06,  -4.018597434778990e-08,   2.679181708780954e-10,  -1.786184940047324e-12,   1.190755202762495e-14,  -7.934536536577611e-17,   5.272692543127743e-19,
  -3.453093081681435e-21,   2.074077715067175e-01,  -1.382659348551591e-03,   9.216932837066403e-06,  -6.143822806459470e-08,   4.095167385547107e-10,  -2.729495095419106e-12,
   1.819056437806345e-14,  -1.211702106322977e-16,   8.049056959982063e-19,  -5.269274782748831e-21,   2.074090838475825e-01,  -1.382685591619437e-03,   9.217282720746699e-06,
  -6.144211539800016e-08,   4.095556064737618e-10,  -2.729857638909007e-12,   1.819377586404003e-14,  -1.211972315010040e-16,   8.051107603387091e-19,  -5.270248133852579e-21,
   2.074112383035928e-01,  -1.382728675064080e-03,   9.217857135450420e-06,  -6.144849745819526e-08,   4.096194194124262e-10,  -2.730452871122663e-12,   1.819904862840439e-14,
  -1.212415942061781e-16,   8.054473428644431e-19,  -5.271842151797283e-21,   2.074135243969937e-01,  -1.382774391561977e-03,   9.218466666491932e-06,  -6.145526982470161e-08,
   4.096871366129952e-10,  -2.731084537884142e-12,   1.820464424122195e-14,  -1.212886713175436e-16,   8.058043959269326e-19,  -5.273528222747739e-21,   2.074153236000377e-01,
  -1.382810371868702e-03,   9.218946394262800e-06,  -6.146060008012224e-08,   4.097404352865887e-10,  -2.731581720421013e-12,   1.820904859873127e-14,  -1.213257247586735e-16,
   8.060853353024998e-19,  -5.274851319558268e-21,   2.074163619695375e-01,  -1.382831137281376e-03,   9.219223264016076e-06,  -6.146367642203446e-08,   4.097711969499951e-10,
  -2.731868677225725e-12,   1.821159067236988e-14,  -1.213471104278702e-16,   8.062474454651215e-19,  -5.275613358503489e-21,   2.074167518903018e-01,  -1.382838934989935e-03,
   9.219327233152706e-06,  -6.146483164685174e-08,   4.097827486303395e-10,  -2.731976436714417e-12,   1.821254529029702e-14,  -1.213551412243908e-16,   8.063083146235801e-19,
  -5.275899219134567e-21,   2.074168165253917e-01,  -1.382840227576470e-03,   9.219344467619784e-06,  -6.146502314336946e-08,   4.097846635062160e-10,  -2.731994299621864e-12,
   1.821270353420364e-14,  -1.213564724578433e-16,   8.063184043033542e-19,  -5.275946589183160e-21,   2.988970070017236e-01,  -1.992561503263097e-03,   1.328259600950528e-05,
  -8.853912406714872e-08,   5.901578337959899e-10,  -3.933495137935930e-12,   2.621443883969376e-14,  -1.746128357194862e-16,   1.159671674813932e-18,  -7.582727261240741e-21,
   2.988988982266944e-01,  -1.992599322359000e-03,   1.328310022966219e-05,  -8.854472613128459e-08,   5.902138463755472e-10,  -3.934017581828319e-12,   2.621906575336278e-14,
  -1.746517175749824e-16,   1.159964731599082e-18,  -7.584038695126176e-21,   2.989020030305712e-01,  -1.992661410257193e-03,   1.328392802326415e-05,  -8.855392336412283e-08,
   5.903058072347933e-10,  -3.934875342064875e-12,   2.622666242460723e-14,  -1.747155532452742e-16,   1.160445725829052e-18,  -7.586185512869777e-21,   2.989052975381498e-01,
  -1.992727292669581e-03,   1.328480642329979e-05,  -8.856368307016400e-08,   5.904033945254329e-10,  -3.935785606190132e-12,   2.623472422636532e-14,  -1.747832943526386e-16,
   1.160955953419801e-18,  -7.588455126699704e-21,   2.989078903841209e-01,  -1.992779144178656e-03,   1.328549776280871e-05,  -8.857136453953508e-08,   5.904802032680452e-10,
  -3.936502071543753e-12,   2.624106973664034e-14,  -1.748366116763903e-16,   1.161357400210404e-18,  -7.590235283033207e-21,   2.989093867867547e-01,  -1.992809069381681e-03,
   1.328589676201380e-05,  -8.857579787795215e-08,   5.905245339143653e-10,  -3.936915590862816e-12,   2.624473218733690e-14,  -1.748673840338067e-16,   1.161589040777211e-18,
  -7.591260219769871e-21,   2.989099487047028e-01,  -1.992820306722128e-03,   1.328604659276408e-05,  -8.857746268072898e-08,   5.905411810457243e-10,  -3.937070877745658e-12,
   2.624610753685877e-14,  -1.748789397163459e-16,   1.161676016116179e-18,  -7.591644634576555e-21,   2.989100418508505e-01,  -1.992822169478969e-03,   1.328607142949176e-05,
  -8.857773864773523e-08,   5.905439405741409e-10,  -3.937096619099824e-12,   2.624633552404482e-14,  -1.748808552549210e-16,   1.161690433101273e-18,  -7.591708332598980e-21,
   4.149831471132225e-01,  -2.766436009936236e-03,   1.844131377387192e-05,  -1.229261025875364e-07,   8.193642997897553e-10,  -5.461188421124831e-12,   3.639538600174377e-14,
  -2.424160274093850e-16,   1.609487781441010e-18,  -1.050549534237488e-20,   4.149857728554402e-01,  -2.766488517278155e-03,   1.844201382387582e-05,  -1.229338803844713e-07,
   8.194420660438888e-10,  -5.461913731191100e-12,   3.640180751068642e-14,  -2.424698913192625e-16,   1.609889593191767e-18,  -1.050712754811240e-20,   4.149900835084522e-01,
  -2.766574718981861e-03,   1.844316311730678e-05,  -1.229466496436952e-07,   8.195697418517067e-10,  -5.463104561461282e-12,   3.641235061341429e-14,  -2.425583236192145e-16,
   1.610549056067861e-18,  -1.050979754583873e-20,   4.149946575426201e-01,  -2.766666188919758e-03,   1.844438267178014e-05,  -1.229601998297178e-07,   8.197052292297401e-10,
  -5.464368282640804e-12,   3.642353923186374e-14,  -2.426521652249713e-16,   1.611248556949340e-18,  -1.051261763782974e-20,   4.149982574026236e-01,  -2.766738178607792e-03,
   1.844534251485414e-05,  -1.229708646323310e-07,   8.198118682676798e-10,  -5.465362952416730e-12,   3.643234587105155e-14,  -2.427260249117446e-16,   1.611798893272945e-18,
  -1.051482764455866e-20,   4.150003349807176e-01,  -2.766779726213032e-03,   1.844589647802055e-05,  -1.229770197931109e-07,   8.198734156540969e-10,  -5.465937041720824e-12,
   3.643742881070096e-14,  -2.427686531211609e-16,   1.612116432950654e-18,  -1.051609929947644e-20,   4.150011151373367e-01,  -2.766795327931237e-03,   1.844610450028171e-05,
  -1.229793311728838e-07,   8.198965280492272e-10,  -5.466152626643978e-12,   3.643933759125735e-14,  -2.427846608793509e-16,   1.612235658968221e-18,  -1.051657610265045e-20,
   4.150012444597475e-01,  -2.766797914148808e-03,   1.844613898313813e-05,  -1.229797143201039e-07,   8.199003592985589e-10,  -5.466188363388781e-12,   3.643965400350228e-14,
  -2.427873144176874e-16,   1.612255421685544e-18,  -1.051665510181454e-20,   5.651960495463159e-01,  -3.767812536458983e-03,   2.511658066378326e-05,  -1.674220928264700e-07,
   1.115952334063868e-09,  -7.437984544228582e-12,   4.956899129409081e-14,  -3.301357684353063e-16,   2.190828906911611e-18,  -1.425990418369275e-20,   5.651996257376338e-01,
  -3.767884050066603e-03,   2.511753411321987e-05,  -1.674326859657020e-07,   1.116058248383603e-09,  -7.438972308178980e-12,   4.957773200376434e-14,  -3.302088709631027e-16,
   2.191365075053607e-18,  -1.426171098467939e-20,   5.652054967328031e-01,  -3.768001454501668e-03,   2.511909942022305e-05,  -1.674500773351684e-07,   1.116232137377734e-09,
  -7.440594040547487e-12,   4.959208283615995e-14,  -3.303288871715846e-16,   2.192244977129553e-18,  -1.426466180878108e-20,   5.652117264461269e-01,  -3.768126034132025e-03,
   2.512076042089117e-05,  -1.674685323046951e-07,   1.116416665385765e-09,  -7.442315038659188e-12,   4.960731227494238e-14,  -3.304562425539841e-16,   2.193178205829994e-18,
  -1.426777198016292e-20,   5.652166293600548e-01,  -3.768224082178526e-03,   2.512206770155889e-05,  -1.674830574636614e-07,   1.116561903181799e-09,  -7.443669628693950e-12,
   4.961929944082533e-14,  -3.305564783352510e-16,   2.193912359937486e-18,  -1.427020454881699e-20,   5.652194589663626e-01,  -3.768280668915343e-03,   2.512282218461699e-05,
  -1.674914406181972e-07,   1.116645728079211e-09,  -7.444451451416594e-12,   4.962621807683793e-14,  -3.306143289324509e-16,   2.194335933323768e-18,  -1.427160234661691e-20,
   5.652205215190036e-01,  -3.768301918041903e-03,   2.512310550538855e-05,  -1.674945886519331e-07,   1.116677206168313e-09,  -7.444745045403735e-12,   4.962881620839648e-14,
  -3.306360528913293e-16,   2.194494966374402e-18,  -1.427212608209650e-20,   5.652206976527000e-01,  -3.768305440401668e-03,   2.512315247011931e-05,  -1.674951104875864e-07,
   1.116682424165255e-09,  -7.444793713431019e-12,   4.962924689195449e-14,  -3.306396539739943e-16,   2.194521327166273e-18,  -1.427221283796973e-20,   7.740337261334223e-01,
  -5.160004177701957e-03,   3.439705659326893e-05,  -2.292838820152110e-07,   1.528291926431838e-09,  -1.018626632301134e-11,   6.788310474168427e-14,  -4.520462979306454e-16,
   2.997073712166124e-18,  -1.940167373882347e-20,   7.740386237131042e-01,  -5.160102115299524e-03,   3.439836233815742e-05,  -2.292983892412541e-07,   1.528436972452940e-09,
  -1.018761883172533e-11,   6.789506151009677e-14,  -4.521457294414333e-16,   2.997778389752658e-18,  -1.940302165885648e-20,   7.740466640174662e-01,  -5.160262900200409e-03,
   3.440050601934064e-05,  -2.293222065932217e-07,   1.528675107433757e-09,  -1.018983940853475e-11,   6.791469250720262e-14,  -4.523089671461954e-16,   2.998934636580559e-18,
  -1.940520691544869e-20,   7.740551955849038e-01,  -5.160433511502326e-03,   3.440278075258210e-05,  -2.293474805372883e-07,   1.528927812148737e-09,  -1.019219590418837e-11,
   6.793552526592331e-14,  -4.524821814184490e-16,   3.000160692208753e-18,  -1.940748808957425e-20,   7.740619101058842e-01,  -5.160567787907021e-03,   3.440457106780867e-05,
  -2.293673726346660e-07,   1.529126710258717e-09,  -1.019405069009918e-11,   6.795192274943328e-14,  -4.526185065875265e-16,   3.001125014970383e-18,  -1.940925613485540e-20,
   7.740657852403859e-01,  -5.160645283215129e-03,   3.440560432909633e-05,  -2.293788533024764e-07,   1.529241505531803e-09,  -1.019512120807850e-11,   6.796138685643085e-14,
  -4.526971843483215e-16,   3.001681307606293e-18,  -1.941026556446702e-20,   7.740672404019705e-01,  -5.160674383808348e-03,   3.440599233566849e-05,  -2.293831645112551e-07,
   1.529284613675261e-09,  -1.019552321424579e-11,   6.796494087363733e-14,  -4.527267289758938e-16,   3.001890156177048e-18,  -1.941064254437722e-20,   7.740674816163620e-01,
  -5.160679207665855e-03,   3.440605665366428e-05,  -2.293838791612987e-07,   1.529291759539718e-09,  -1.019558985336742e-11,   6.796553001082164e-14,  -4.527316264390212e-16,
   3.001924773449498e-18,  -1.941070492488217e-20,   1.563497381928014e-03,  -1.015216852476511e-05,   6.591777053980717e-08,  -4.279846810129049e-10,   2.778663004546806e-12,
  -1.803950762484854e-14,   1.171083792663017e-16,  -7.601131585864017e-19,   4.929500349236173e-21,  -3.182474803565298e-23,   1.563506767285024e-03,  -1.015235133162499e-05,
   6.592014450254867e-08,  -4.280103717608385e-10,   2.778913218968802e-12,  -1.804178179800573e-14,   1.171280481083139e-16,  -7.602764374208130e-19,   4.930788169943572e-21,
  -3.183363974993077e-23,   1.563522175112374e-03,  -1.015265144661233e-05,   6.592404190120641e-08,  -4.280525496229349e-10,   2.779324016810713e-12,  -1.804551557425211e-14,
   1.171603414063594e-16,  -7.605445189447136e-19,   4.932902461710612e-21,  -3.184823149656527e-23,   1.563538524340926e-03,  -1.015296990260374e-05,   6.592817755256521e-08,
  -4.280973067772218e-10,   2.779759946355671e-12,  -1.804947787917784e-14,   1.171946121349255e-16,  -7.608290188542425e-19,   4.935146058837264e-21,  -3.186370704926574e-23,
   1.563551391510757e-03,  -1.015322053695861e-05,   6.593143248409143e-08,  -4.281325331974491e-10,   2.780103055092703e-12,  -1.805259658136483e-14,   1.172215870301913e-16,
  -7.610529541287010e-19,   4.936911904266529e-21,  -3.187588100148781e-23,   1.563558817502705e-03,  -1.015336518607908e-05,   6.593331102972607e-08,  -4.281528639772573e-10,
   2.780301081838198e-12,  -1.805439658464309e-14,   1.172371562336074e-16,  -7.611822045194278e-19,   4.937931057215143e-21,  -3.188290466120789e-23,   1.563561606054789e-03,
  -1.015341950385444e-05,   6.593401645382246e-08,  -4.281604985618692e-10,   2.780375445115508e-12,  -1.805507253009635e-14,   1.172430029010043e-16,  -7.612307417765639e-19,
   4.938313768527775e-21,  -3.188554170513860e-23,   1.563562068298176e-03,  -1.015342850783444e-05,   6.593413338857202e-08,  -4.281617641127609e-10,   2.780387772012645e-12,
  -1.805518457911926e-14,   1.172439720844103e-16,  -7.612387876509346e-19,   4.938377208893184e-21,  -3.188597881126230e-23,   1.412703549823796e-02,  -9.173027520939303e-05,
   5.956023304797331e-07,  -3.867070614006270e-09,   2.510670711588411e-11,  -1.629966019220754e-13,   1.058136711948679e-15,  -6.868020946038972e-18,   4.454031323944853e-20,
  -2.875397143708705e-22,   1.412712029996080e-02,  -9.173192696719474e-05,   5.956237805034143e-07,  -3.867302743657324e-09,   2.510896793671835e-11,  -1.630171502678226e-13,
   1.058314428959163e-15,  -6.869496183159817e-18,   4.455194619357998e-20,  -2.876199357955916e-22,   1.412725951792588e-02,  -9.173463866670142e-05,   5.956589955857915e-07,
  -3.867683843204727e-09,   2.511267971444750e-11,  -1.630508868919003e-13,   1.058606213712238e-15,  -6.871918320395025e-18,   4.457104468713446e-20,  -2.877515824032819e-22,
   1.412740724195458e-02,  -9.173751608699438e-05,   5.956963634088119e-07,  -3.868088248036847e-09,   2.511661857052239e-11,  -1.630866883920787e-13,   1.058915865444345e-15,
  -6.874488798418443e-18,   4.459131117684261e-20,  -2.878912016772941e-22,   1.412752350371943e-02,  -9.173978070250879e-05,   5.957257734568703e-07,  -3.868406537588182e-09,
   2.511971874106104e-11,  -1.631148674995360e-13,   1.059159595971420e-15,  -6.876512069991538e-18,   4.460726210093338e-20,  -2.880010334161926e-22,   1.412759060153045e-02,
  -9.174108768471622e-05,   5.957427471218918e-07,  -3.868590237059809e-09,   2.512150801838240e-11,  -1.631311314717152e-13,   1.059300270847843e-15,  -6.877679856546740e-18,
   4.461646812665101e-20,  -2.880643996188051e-22,   1.412761579759073e-02,  -9.174157847488280e-05,   5.957491210060760e-07,  -3.868659219615938e-09,   2.512217993027626e-11,
  -1.631372389928279e-13,   1.059353098162188e-15,  -6.878118394115352e-18,   4.461992516299084e-20,  -2.880881905012526e-22,   1.412761997420708e-02,  -9.174165983066027e-05,
   5.957501775741102e-07,  -3.868670654545256e-09,   2.512229131037003e-11,  -1.631382514144210e-13,   1.059361855177555e-15,  -6.878191089160529e-18,   4.462049822057628e-20,
  -2.880921339822128e-22,   3.955868925285083e-02,  -2.568641844595055e-04,   1.667812579106556e-06,  -1.082861614695143e-08,   7.030409331339856e-11,  -4.564249665081588e-13,
   2.963005804714889e-15,  -1.923186476866020e-17,   1.247202161915166e-19,  -8.050913958066893e-22,   3.955892671562229e-02,  -2.568688097309286e-04,   1.667872643712368e-06,
  -1.082926615907902e-08,   7.031042408811946e-11,  -4.564825060764240e-13,   2.963503441252109e-15,  -1.923599531279848e-17,   1.247527723920766e-19,  -8.053153364683989e-22,
   3.955931655538871e-02,  -2.568764030634519e-04,   1.667971253395651e-06,  -1.083033331842928e-08,   7.032081784786860e-11,  -4.565769755188340e-13,   2.964320485970747e-15,
  -1.924277709784046e-17,   1.248062216825620e-19,  -8.056828277917884e-22,   3.955973021393350e-02,  -2.568844604492499e-04,   1.668075891208321e-06,  -1.083146573750652e-08,
   7.033184747481521e-11,  -4.566772270350830e-13,   2.965187561062432e-15,  -1.924997422145436e-17,   1.248629395967280e-19,  -8.060725688419963e-22,   3.956005577148082e-02,
  -2.568908018519739e-04,   1.668158245566979e-06,  -1.083235701558068e-08,   7.034052860553181e-11,  -4.567561342932258e-13,   2.965870046032373e-15,  -1.925563921025272e-17,
   1.249075798386954e-19,  -8.063791549729814e-22,   3.956024365955231e-02,  -2.568944616787646e-04,   1.668205775421202e-06,  -1.083287141296065e-08,   7.034553895902846e-11,
  -4.568016767378470e-13,   2.966263958460543e-15,  -1.925890891255892e-17,   1.249333437716859e-19,  -8.065560346991759e-22,   3.956031421385361e-02,  -2.568958359951020e-04,
   1.668223623645833e-06,  -1.083306457871023e-08,   7.034742045390064e-11,  -4.568187790445809e-13,   2.966411883489113e-15,  -1.926013677999055e-17,   1.249430186065694e-19,
  -8.066224439795271e-22,   3.956032590926333e-02,  -2.568960638084971e-04,   1.668226582259932e-06,  -1.083309659893124e-08,   7.034773234163051e-11,  -4.568216140318510e-13,
   2.966436404548973e-15,  -1.926034031984760e-17,   1.249446223606260e-19,  -8.066334516972850e-22,   7.851021386623927e-02,  -5.097859013371254e-04,   3.310026816993170e-06,
  -2.149102979229780e-08,   1.395291269523535e-10,  -9.058444671989512e-13,   5.880531114693391e-15,  -3.816840057687937e-17,   2.475195808914343e-19,  -1.597571048000546e-21,
   7.851068514709625e-02,  -5.097950808892123e-04,   3.310146024305462e-06,  -2.149231983979914e-08,   1.395416913275944e-10,  -9.059586627231504e-13,   5.881518722338650e-15,
  -3.817659690264130e-17,   2.475841349904488e-19,  -1.598013287674213e-21,   7.851145884319215e-02,  -5.098101510083540e-04,   3.310341730165028e-06,  -2.149443777913380e-08,
   1.395623193080772e-10,  -9.061461508752928e-13,   5.883140226122796e-15,  -3.819005413360477e-17,   2.476901166377815e-19,  -1.598738998333362e-21,   7.851227981126345e-02,
  -5.098261421115456e-04,   3.310549399760846e-06,  -2.149668523627852e-08,   1.395842092626540e-10,  -9.063451143779485e-13,   5.884861019765918e-15,  -3.820433551828323e-17,
   2.478025789973218e-19,  -1.599508628104232e-21,   7.851292592955371e-02,  -5.098387275862741e-04,   3.310712844465390e-06,  -2.149845411258539e-08,   1.396014382729840e-10,
  -9.065017171383208e-13,   5.886215476452633e-15,  -3.821557665179181e-17,   2.478910929708909e-19,  -1.600114036349118e-21,   7.851329882190565e-02,  -5.098459910671773e-04,
   3.310807174663657e-06,  -2.149947501208235e-08,   1.396113820734892e-10,  -9.065921026442713e-13,   5.886997233269156e-15,  -3.822206477445310e-17,   2.479421783140980e-19,
  -1.600463310947102e-21,   7.851343884760895e-02,  -5.098487186062227e-04,   3.310842597170115e-06,  -2.149985837876390e-08,   1.396151161831996e-10,  -9.066260446219130e-13,
   5.887290804596807e-15,  -3.822450125086611e-17,   2.479613617829080e-19,  -1.600594444626822e-21,   7.851346205892194e-02,  -5.098491707364297e-04,   3.310848468988135e-06,
  -2.149992192774139e-08,   1.396157351713338e-10,  -9.066316710602549e-13,   5.887339468978156e-15,  -3.822490513813371e-17,   2.479645417392898e-19,  -1.600616180728369e-21,
   1.320812003879387e-01,  -8.576353377932412e-04,   5.568604309725789e-06,  -3.615530860672680e-08,   2.347360112719159e-10,  -1.523942036218390e-12,   9.893070042571753e-15,
  -6.421202062389652e-17,   4.163970069317271e-19,  -2.687040216458282e-21,   1.320819932445397e-01,  -8.576507809591466e-04,   5.568804857450845e-06,  -3.615747891043623e-08,
   2.347571488591913e-10,  -1.524134151246563e-12,   9.894731471315952e-15,  -6.422580632113283e-17,   4.165054653644291e-19,  -2.687778799800060e-21,   1.320832948676540e-01,
  -8.576761340861747e-04,   5.569134102059754e-06,  -3.616104201302587e-08,   2.347918521952597e-10,  -1.524449568957266e-12,   9.897459287982293e-15,  -6.424844050579930e-17,
   4.166835260870115e-19,  -2.688990772819260e-21,   1.320846760185004e-01,  -8.577030366253464e-04,   5.569483473790403e-06,  -3.616482300912808e-08,   2.348286786043171e-10,
  -1.524784292031658e-12,   9.900354137027646e-15,  -6.427246083652818e-17,   4.168724739764311e-19,  -2.690276045953997e-21,   1.320857630118376e-01,  -8.577242097253396e-04,
   5.569758444033711e-06,  -3.616779886761538e-08,   2.348576637069407e-10,  -1.525047750180040e-12,   9.902632705972196e-15,  -6.429136764939648e-17,   4.170211853836307e-19,
  -2.691287036848028e-21,   1.320863903451109e-01,  -8.577364294000660e-04,   5.569917139891375e-06,  -3.616951637178460e-08,   2.348743925887443e-10,  -1.525199808787037e-12,
   9.903947835945146e-15,  -6.430228021736403e-17,   4.171070130066678e-19,  -2.691870288132939e-21,   1.320866259165362e-01,  -8.577410180594682e-04,   5.569976732738056e-06,
  -3.617016132643074e-08,   2.348806746415547e-10,  -1.525256910528473e-12,   9.904441703629006e-15,  -6.430637819859530e-17,   4.171392427662024e-19,  -2.692089264780504e-21,
   1.320866649659532e-01,  -8.577417786980845e-04,   5.569986611156780e-06,  -3.617026823767331e-08,   2.348817159918223e-10,  -1.525266376076705e-12,   9.904523570495986e-15,
  -6.430705750837385e-17,   4.171445853435567e-19,  -2.692125561181912e-21,   2.020200877044818e-01,  -1.311765532493212e-03,   8.517260046820886e-06,  -5.530006230356632e-08,
   3.590320876643004e-10,  -2.330890913708580e-12,   1.513157689547970e-14,  -9.821241870823309e-17,   6.368504421650209e-19,  -4.108518481560168e-21,   2.020213003900085e-01,
  -1.311789153036628e-03,   8.517566787435448e-06,  -5.530338181378691e-08,   3.590644178721171e-10,  -2.331184753929205e-12,   1.513411792960430e-14,  -9.823349690642592e-17,
   6.370160196485569e-19,  -4.109636405094072e-21,   2.020232912412041e-01,  -1.311827931007504e-03,   8.518070371775011e-06,  -5.530883162959214e-08,   3.591174970645383e-10,
  -2.331667185770273e-12,   1.513828992542262e-14,  -9.826810431402054e-17,   6.372878532771323e-19,  -4.111470777952313e-21,   2.020254037312049e-01,  -1.311869078826443e-03,
   8.518604740835190e-06,  -5.531461471660313e-08,   3.591738235237051e-10,  -2.332179145171784e-12,   1.514271738383353e-14,  -9.830483106496355e-17,   6.375763051545357e-19,
  -4.113415990479160e-21,   2.020270663030822e-01,  -1.311901463386105e-03,   8.519025311756064e-06,  -5.531916633424295e-08,   3.592181566051278e-10,  -2.332582104755931e-12,
   1.514620228634907e-14,  -9.833373927625393e-17,   6.378033293638696e-19,  -4.114946012226229e-21,   2.020280258183087e-01,  -1.311920153553599e-03,   8.519268039340659e-06,
  -5.532179328115704e-08,   3.592437436415504e-10,  -2.332814678589016e-12,   1.514821367993268e-14,  -9.835042439938862e-17,   6.379343538853580e-19,  -4.115828667761418e-21,
   2.020283861281775e-01,  -1.311927171973870e-03,   8.519359187452191e-06,  -5.532277974840846e-08,   3.592533521208066e-10,  -2.332902015774116e-12,   1.514896901379620e-14,
  -9.835669013690584e-17,   6.379835557268240e-19,  -4.116160047443449e-21,   2.020284458548201e-01,  -1.311928335381527e-03,   8.519374296634949e-06,  -5.532294327066578e-08,
   3.592549448792156e-10,  -2.332916493341940e-12,   1.514909422307234e-14,  -9.835772878882559e-17,   6.379917116800646e-19,  -4.116214974871517e-21,   2.911327725593278e-01,
  -1.890395854992712e-03,   1.227429192852253e-05,  -7.969336429992851e-08,   5.174040208707719e-10,  -3.359065115472089e-12,   2.180620586021295e-14,  -1.415331089657138e-16,
   9.176995609381635e-19,  -5.918067460946970e-21,   2.911345201701898e-01,  -1.890429894747693e-03,   1.227473397488175e-05,  -7.969814807201285e-08,   5.174506121229346e-10,
  -3.359488565966155e-12,   2.180986746978210e-14,  -1.415634701786001e-16,   9.179375386634503e-19,  -5.919654373472562e-21,   2.911373892018533e-01,  -1.890485777993224e-03,
   1.227545969431141e-05,  -7.970600184409491e-08,   5.175271048580891e-10,  -3.360183794113482e-12,   2.181587928012507e-14,  -1.416133188902763e-16,   9.183282302349832e-19,
  -5.922258140484488e-21,   2.911404335281769e-01,  -1.890545076445846e-03,   1.227622977784872e-05,  -7.971433589590506e-08,   5.176082772477556e-10,  -3.360921574117229e-12,
   2.182225920742744e-14,  -1.416662201972299e-16,   9.187428011927919e-19,  -5.925019021256935e-21,   2.911428294738757e-01,  -1.890591746095086e-03,   1.227683586597499e-05,
  -7.972089526759158e-08,   5.176721659101767e-10,  -3.361502275451499e-12,   2.182728091847534e-14,  -1.417078595729219e-16,   9.190690829093284e-19,  -5.927190456521469e-21,
   2.911442122389826e-01,  -1.890618680645695e-03,   1.227718566264335e-05,  -7.972468098127945e-08,   5.177090395375425e-10,  -3.361837435441380e-12,   2.183017931659157e-14,
  -1.417318927826845e-16,   9.192573913174172e-19,  -5.928443074723085e-21,   2.911447314844313e-01,  -1.890628794947561e-03,   1.227731701691771e-05,  -7.972610258692943e-08,
   5.177228863729836e-10,  -3.361963296244957e-12,   2.183126774502873e-14,  -1.417409179288037e-16,   9.193281039091001e-19,  -5.928913339385537e-21,   2.911448175569762e-01,
  -1.890630471543687e-03,   1.227733879088212e-05,  -7.972633824012982e-08,   5.177251817064053e-10,  -3.361984159732911e-12,   2.183144817031870e-14,  -1.417424139990016e-16,
   9.193398255813307e-19,  -5.928991286892335e-21,   4.042034257766624e-01,  -2.624591089291937e-03,   1.704140280225632e-05,  -1.106448117575366e-07,   7.183542812624444e-10,
  -4.663663632449655e-12,   3.027527519345640e-14,  -1.964987608377422e-16,   1.273974064956028e-18,  -8.210943079514948e-21,   4.042058521276742e-01,  -2.624638349466168e-03,
   1.704201653133735e-05,  -1.106514534577848e-07,   7.184189675649062e-10,  -4.664251533268821e-12,   3.028035830737018e-14,  -1.965408837975600e-16,   1.274303167370916e-18,
  -8.213096807278787e-21,   4.042098354388513e-01,  -2.624715936743799e-03,   1.704302410692150e-05,  -1.106623574889587e-07,   7.185251684487587e-10,  -4.665216758663307e-12,
   3.028870400964786e-14,  -1.966100434134831e-16,   1.274843451942208e-18,  -8.216630258282492e-21,   4.042140621259339e-01,  -2.624798265632593e-03,   1.704409327682126e-05,
  -1.106739283315654e-07,   7.186378664639848e-10,  -4.666241061170601e-12,   3.029756073343489e-14,  -1.966834379254618e-16,   1.275416748576208e-18,  -8.220376467893856e-21,
   4.042173886131953e-01,  -2.624863060921380e-03,   1.704493475849141e-05,  -1.106830352412687e-07,   7.187265681198805e-10,  -4.667047282243129e-12,   3.030453195463467e-14,
  -1.967412076183708e-16,   1.275867945231036e-18,  -8.223322536059879e-21,   4.042193084190225e-01,  -2.624900456359603e-03,   1.704542040978853e-05,  -1.106882912557680e-07,
   7.187777626770824e-10,  -4.667512604114760e-12,   3.030855555672110e-14,  -1.967745507737957e-16,   1.276128343267592e-18,  -8.225021878159426e-21,   4.042200293299227e-01,
  -2.624914498871620e-03,   1.704560277966077e-05,  -1.106902649866208e-07,   7.187969873277920e-10,  -4.667687343895279e-12,   3.031006653000804e-14,  -1.967870720528141e-16,
   1.276226125997524e-18,  -8.225659829264408e-21,   4.042201488314725e-01,  -2.624916826627066e-03,   1.704563301023476e-05,  -1.106905921631427e-07,   7.188001741197080e-10,
  -4.667716309873329e-12,   3.031031699918748e-14,  -1.967891476652968e-16,   1.276242334920235e-18,  -8.225765569882839e-21,   5.505143547426610e-01,  -3.574623513402630e-03,
   2.320993902635874e-05,  -1.506953012615458e-07,   9.783794650522450e-10,  -6.351784083538200e-12,   4.123398926996936e-14,  -2.676192392371747e-16,   1.734812180934555e-18,
  -1.117104064568222e-20,   5.505176593684417e-01,  -3.574687880507412e-03,   2.321077490907627e-05,  -1.507043470779696e-07,   9.784675657822730e-10,  -6.352584767317584e-12,
   4.124091105529280e-14,  -2.676765449596900e-16,   1.735257587501589e-18,  -1.117386586493479e-20,   5.505230845327086e-01,  -3.574793552323278e-03,   2.321214720027659e-05,
  -1.507191980740165e-07,   9.786122080776806e-10,  -6.353899343195655e-12,   4.125227556923344e-14,  -2.677706320140106e-16,   1.735988790447053e-18,  -1.117850022603008e-20,
   5.505288411685094e-01,  -3.574905682087880e-03,   2.321360338129955e-05,  -1.507349572492005e-07,   9.787656992609313e-10,  -6.355294378172878e-12,   4.126433594076031e-14,
  -2.678704798272813e-16,   1.736764647455492e-18,  -1.118341260817071e-20,   5.505333717560089e-01,  -3.574993931553958e-03,   2.321474945699745e-05,  -1.507473606142812e-07,
   9.788865081489370e-10,  -6.356392399946271e-12,   4.127382877916421e-14,  -2.679490708395904e-16,   1.737375246486450e-18,  -1.118727502409589e-20,   5.505359864806714e-01,
  -3.575044863149737e-03,   2.321541090117260e-05,  -1.507545191640799e-07,   9.789562335378888e-10,  -6.357026138656197e-12,   4.127930778796214e-14,  -2.679944313598002e-16,
   1.737727633222684e-18,  -1.118950263143957e-20,   5.505369683422136e-01,  -3.575063988678941e-03,   2.321565928409760e-05,  -1.507572073321952e-07,   9.789824169119399e-10,
  -6.357264123081592e-12,   4.128136530591202e-14,  -2.680114654628391e-16,   1.737859957574843e-18,  -1.119033884219075e-20,   5.505371311001577e-01,  -3.575067159020166e-03,
   2.321570045733690e-05,  -1.507576529377816e-07,   9.789867572230263e-10,  -6.357303572893911e-12,   4.128170637400974e-14,  -2.680142891502057e-16,   1.737881892210402e-18,
  -1.119047744141853e-20,   7.539272039032033e-01,  -4.895432584509129e-03,   3.178591852978166e-05,  -2.063766107082015e-07,   1.339886684167342e-09,  -8.698737359153729e-12,
   5.646944710510986e-14,  -3.664860170328416e-16,   2.375031226771330e-18,  -1.526747790305925e-20,   7.539317295749732e-01,  -4.895520735000952e-03,   3.178706326774742e-05,
  -2.063889989092665e-07,   1.340007337007604e-09,  -8.699833837511225e-12,   5.647892317156295e-14,  -3.665643293124625e-16,   2.375633807542797e-18,  -1.527106010702643e-20,
   7.539391593157062e-01,  -4.895665452128928e-03,   3.178894261493781e-05,  -2.064093372751930e-07,   1.340205422804519e-09,  -8.701634053463427e-12,   5.649448140388320e-14,
  -3.666929048105259e-16,   2.376622989552859e-18,  -1.527693406721316e-20,   7.539470430053772e-01,  -4.895819013391793e-03,   3.179093684889682e-05,  -2.064309193878963e-07,
   1.340415627034678e-09,  -8.703544451804915e-12,   5.651099224968912e-14,  -3.668293513009110e-16,   2.377672516997717e-18,  -1.528315751743474e-20,   7.539532476268104e-01,
  -4.895939870681611e-03,   3.179250639488019e-05,  -2.064479057351551e-07,   1.340581073270691e-09,  -8.705048111938122e-12,   5.652398807992594e-14,  -3.669367483910318e-16,
   2.378498448603165e-18,  -1.528804867105954e-20,   7.539568284817622e-01,  -4.896009621297740e-03,   3.179341223997403e-05,  -2.064577093337494e-07,   1.340676561302272e-09,
  -8.705915970390035e-12,   5.653148891224443e-14,  -3.669987345533419e-16,   2.378975088865309e-18,  -1.529086874582481e-20,   7.539581731372115e-01,  -4.896035813633268e-03,
   3.179375239937438e-05,  -2.064613907667025e-07,   1.340712419098970e-09,  -8.706241872492372e-12,   5.653430567875486e-14,  -3.670220119563855e-16,   2.379154068030491e-18,
  -1.529192719981504e-20,   7.539583960335638e-01,  -4.896040155402860e-03,   3.179380878595728e-05,  -2.064620010213514e-07,   1.340718363099606e-09,  -8.706295896096697e-12,
   5.653477260494823e-14,  -3.670258705709595e-16,   2.379183736177847e-18,  -1.529210262667952e-20,   1.523911897384728e-03,  -9.644640291376430e-06,   6.103727557826081e-08,
  -3.862666134494187e-10,   2.444342750855892e-12,  -1.546748503429706e-14,   9.787189272765875e-17,  -6.192444885113629e-19,   3.916848263702775e-21,  -2.473577174361871e-23,
   1.523920587636931e-03,  -9.644805274929456e-06,   6.103936385068492e-08,  -3.862886404604696e-10,   2.444551854865074e-12,  -1.546933764675761e-14,   9.788752045609775e-17,
  -6.193714081759438e-19,   3.917842332048430e-21,  -2.474309824870207e-23,   1.523934854307786e-03,  -9.645076128941789e-06,   6.104279221704939e-08,  -3.863248032714952e-10,
   2.444895157070785e-12,  -1.547237928430992e-14,   9.791317876642470e-17,  -6.195797944812616e-19,   3.919474459132905e-21,  -2.475512583474235e-23,   1.523949992641057e-03,
  -9.645363535238137e-06,   6.104643015436824e-08,  -3.863631774017413e-10,   2.445259460047102e-12,  -1.547560706977372e-14,   9.794040811083378e-17,  -6.198009453367707e-19,
   3.921206547882025e-21,  -2.476788794798330e-23,   1.523961906800944e-03,  -9.645589732205418e-06,   6.104929335732946e-08,  -3.863933799213148e-10,   2.445546192156354e-12,
  -1.547814762394223e-14,   9.796184056767087e-17,  -6.199750189243250e-19,   3.922569910375461e-21,  -2.477793173130224e-23,   1.523968782780595e-03,  -9.645720277584926e-06,
   6.105094581872727e-08,  -3.864108111385636e-10,   2.445711680385379e-12,  -1.547961393568918e-14,   9.797421078797593e-17,  -6.200754908991699e-19,   3.923356813478880e-21,
  -2.478372816652947e-23,   1.523971364795396e-03,  -9.645769299180860e-06,   6.105156634405025e-08,  -3.864173568762315e-10,   2.445773824660796e-12,  -1.548016457079383e-14,
   9.797885614237007e-17,  -6.201132211478928e-19,   3.923652318525557e-21,  -2.478590477999918e-23,   1.523971792802155e-03,  -9.645777425238860e-06,   6.105166920551296e-08,
  -3.864184419334490e-10,   2.445784126058916e-12,  -1.548025584752362e-14,   9.797962618762532e-17,  -6.201194755834077e-19,   3.923701303513656e-21,  -2.478626558453704e-23,
   1.376935946256191e-02,  -8.714448603424529e-05,   5.515044468736633e-07,  -3.490125549879710e-09,   2.208594475232569e-11,  -1.397570035504678e-13,   8.843248852243657e-16,
  -5.595203343748652e-18,   3.539073168692971e-20,  -2.234974647747357e-22,   1.376943798364086e-02,  -8.714597674893218e-05,   5.515233155324752e-07,  -3.490324575710608e-09,
   2.208783411885722e-11,  -1.397737428892023e-13,   8.844660897444774e-16,  -5.596350112219871e-18,   3.539971281348570e-20,  -2.235636325268360e-22,   1.376956689064635e-02,
  -8.714842405987185e-05,   5.515542926571390e-07,  -3.490651326057950e-09,   2.209093603784998e-11,  -1.398012257018823e-13,   8.846979257003404e-16,  -5.598232963322997e-18,
   3.541445861561928e-20,  -2.236722568938270e-22,   1.376970367358822e-02,  -8.715102092955500e-05,   5.515871633675195e-07,  -3.490998056857658e-09,   2.209422771003354e-11,
  -1.398303904598728e-13,   8.849439567494503e-16,  -5.600231146934992e-18,   3.543010753631273e-20,  -2.237875147218204e-22,   1.376981132439826e-02,  -8.715306474019596e-05,
   5.516130339384092e-07,  -3.491270952782529e-09,   2.209681848795553e-11,  -1.398533457176462e-13,   8.851376099531199e-16,  -5.601803969090622e-18,   3.544242511722867e-20,
  -2.238782224514266e-22,   1.376987345255386e-02,  -8.715424428755669e-05,   5.516279648113906e-07,  -3.491428453157327e-09,   2.209831376259066e-11,  -1.398665946239299e-13,
   8.852493812162459e-16,  -5.602711772178282e-18,   3.544953455444643e-20,  -2.239305713248558e-22,   1.376989678243926e-02,  -8.715468722390819e-05,   5.516335715897343e-07,
  -3.491487597399598e-09,   2.209887526934730e-11,  -1.398715699048747e-13,   8.852913543673585e-16,  -5.603052679535684e-18,   3.545220435493909e-20,  -2.239502287829320e-22,
   1.376990064970936e-02,  -8.715476064719059e-05,   5.516345009980922e-07,  -3.491497401472141e-09,   2.209896834798742e-11,  -1.398723946386603e-13,   8.852983121197874e-16,
  -5.603109190773716e-18,   3.545264691976566e-20,  -2.239534872845349e-22,   3.855712065409832e-02,  -2.440230042288613e-04,   1.544329172111128e-06,  -9.773090192253450e-09,
   6.184531954456680e-11,  -3.913491845677435e-13,   2.476296615807733e-15,  -1.566774209050310e-17,   9.910102732723993e-20,  -6.258201048693149e-22,   3.855734052973765e-02,
  -2.440271785454805e-04,   1.544382008349135e-06,  -9.773647506696439e-09,   6.185061017022259e-11,  -3.913960582229901e-13,   2.476692016212142e-15,  -1.567095317708750e-17,
   9.912617167089973e-20,  -6.260052079851854e-22,   3.855770149663502e-02,  -2.440340315340621e-04,   1.544468750854144e-06,  -9.774562476813621e-09,   6.185929619907159e-11,
  -3.914730158557463e-13,   2.477341202433293e-15,  -1.567622538095400e-17,   9.916745527424702e-20,  -6.263090816561001e-22,   3.855808451782110e-02,  -2.440413033187782e-04,
   1.544560795799914e-06,  -9.775533396425496e-09,   6.186851357695949e-11,  -3.915546832874002e-13,   2.478030137686017e-15,  -1.568182052847827e-17,   9.921126728729668e-20,
  -6.266315107881774e-22,   3.855838596287253e-02,  -2.440470264211263e-04,   1.544633238873611e-06,  -9.776297562763384e-09,   6.187576830276088e-11,  -3.916189628174846e-13,
   2.478572404672428e-15,  -1.568622461359116e-17,   9.924575257836942e-20,  -6.268852609467314e-22,   3.855855993485705e-02,  -2.440503294033766e-04,   1.544675048477905e-06,
  -9.776738597141887e-09,   6.187995538779822e-11,  -3.916560625301670e-13,   2.478885386145740e-15,  -1.568876656764559e-17,   9.926565672004408e-20,  -6.270317037724531e-22,
   3.855862526347373e-02,  -2.440515697189041e-04,   1.544690748643877e-06,  -9.776904213535909e-09,   6.188152772540331e-11,  -3.916699943589067e-13,   2.479002919205627e-15,
  -1.568972114778142e-17,   9.927313130217298e-20,  -6.270866942486990e-22,   3.855863609264849e-02,  -2.440517753196342e-04,   1.544693351183977e-06,  -9.776931667013697e-09,
   6.188178836526981e-11,  -3.916723037862497e-13,   2.479022402277758e-15,  -1.568987938579893e-17,   9.927437034114158e-20,  -6.270958096933573e-22,   7.652244919620348e-02,
  -4.843006331132848e-04,   3.064955282183206e-06,  -1.939617857800949e-08,   1.227414090191576e-10,  -7.766917534688489e-13,   4.914585212906640e-15,  -3.109497253580334e-17,
   1.966793945396420e-19,  -1.241971423282881e-21,   7.652288557273146e-02,  -4.843089176772245e-04,   3.065060143704618e-06,  -1.939728465296418e-08,   1.227519090659828e-10,
  -7.767847812280679e-13,   4.915369938194538e-15,  -3.110134508346038e-17,   1.967292824193263e-19,  -1.242338217539805e-21,   7.652360196624314e-02,  -4.843225184716208e-04,
   3.065232297351232e-06,  -1.939910054979507e-08,   1.227691478039918e-10,  -7.769375151264228e-13,   4.916658335530369e-15,  -3.111180801022241e-17,   1.968111914660947e-19,
  -1.242940360223114e-21,   7.652436212983306e-02,  -4.843369504304135e-04,   3.065414974495098e-06,  -1.940102748687531e-08,   1.227874410845208e-10,  -7.770995963220371e-13,
   4.918025620106004e-15,  -3.112291183044731e-17,   1.968981169032873e-19,  -1.243579266951248e-21,   7.652496039322101e-02,  -4.843483087943476e-04,   3.065558748753260e-06,
  -1.940254409075665e-08,   1.228018391851265e-10,  -7.772271686335422e-13,   4.919101821758841e-15,  -3.113165193206217e-17,   1.969665375253287e-19,  -1.244082080070527e-21,
   7.652530566698944e-02,  -4.843548640631833e-04,   3.065641726249031e-06,  -1.940341939030472e-08,   1.228101490886615e-10,  -7.773007985446232e-13,   4.919722975504591e-15,
  -3.113669655144409e-17,   1.970060283489619e-19,  -1.244372259320570e-21,   7.652543532152965e-02,  -4.843573256573149e-04,   3.065672885607690e-06,  -1.940374808113224e-08,
   1.228132696304472e-10,  -7.773284483358240e-13,   4.919956235635404e-15,  -3.113859095746274e-17,   1.970208582912715e-19,  -1.244481223741205e-21,   7.652545681366811e-02,
  -4.843577337031221e-04,   3.065678050742922e-06,  -1.940380256671856e-08,   1.228137869096828e-10,  -7.773330317386908e-13,   4.919994902406597e-15,  -3.113890498771927e-17,
   1.970233166057958e-19,  -1.244499286112557e-21,   1.287370960889206e-01,  -8.147603454400345e-04,   5.156309642630507e-06,  -3.263104789857329e-08,   2.064932931929730e-10,
  -1.306662813345171e-12,   8.268022065353084e-15,  -5.231235774659100e-17,   3.308784947521531e-19,  -2.089268362561152e-21,   1.287378302244273e-01,  -8.147742829278570e-04,
   5.156486055799103e-06,  -3.263290869727986e-08,   2.065109578816755e-10,  -1.306819317777139e-12,   8.269342226914455e-15,  -5.232307773301731e-17,   3.309623869080009e-19,
  -2.089884037170561e-21,   1.287390354448733e-01,  -8.147971641449801e-04,   5.156775677481826e-06,  -3.263596366065243e-08,   2.065399593657029e-10,  -1.307076268305017e-12,
   8.271509727546580e-15,  -5.234067860579330e-17,   3.311001260895692e-19,  -2.090894742428922e-21,   1.287403143016551e-01,  -8.148214436666774e-04,   5.157083003308733e-06,
  -3.263920543193620e-08,   2.065707349527672e-10,  -1.307348944173637e-12,   8.273809941865905e-15,  -5.235935759106286e-17,   3.312463005952698e-19,  -2.091967145242862e-21,
   1.287413207865765e-01,  -8.148405523439917e-04,   5.157324881092906e-06,  -3.264175688157161e-08,   2.065949575080158e-10,  -1.307563564323952e-12,   8.275620460580824e-15,
  -5.237406029430941e-17,   3.313613570427913e-19,  -2.092811107091866e-21,   1.287419016558869e-01,  -8.148515805622823e-04,   5.157464477798671e-06,  -3.264322943662709e-08,
   2.066089376226750e-10,  -1.307687434953144e-12,   8.276665441727660e-15,  -5.238254641122637e-17,   3.314277649160274e-19,  -2.093298163875800e-21,   1.287421197794465e-01,
  -8.148557218108118e-04,   5.157516898563868e-06,  -3.264378240771088e-08,   2.066141874467871e-10,  -1.307733951334502e-12,   8.277057860570588e-15,  -5.238573320250305e-17,
   3.314527029698823e-19,  -2.093481056612790e-21,   1.287421559366203e-01,  -8.148564082842956e-04,   5.157525588098983e-06,  -3.264387407121711e-08,   2.066150576882995e-10,
  -1.307741662181717e-12,   8.277122910562041e-15,  -5.238626146773985e-17,   3.314568368745182e-19,  -2.093511373599620e-21,   1.969052322837571e-01,  -1.246187617620356e-03,
   7.886649448723047e-06,  -4.990965510478947e-08,   3.158344485869151e-10,  -1.998559427414461e-12,   1.264605451506684e-14,  -8.001231161791736e-17,   5.060749297449552e-19,
  -3.195231973222317e-21,   1.969063551545290e-01,  -1.246208935207594e-03,   7.886919275190318e-06,  -4.991250122297166e-08,   3.158614669730684e-10,  -1.998798802591664e-12,
   1.264807368570416e-14,  -8.002870619831088e-17,   5.062031653727940e-19,  -3.196170629436327e-21,   1.969081985564628e-01,  -1.246243932356889e-03,   7.887362255700872e-06,
  -4.991717383305501e-08,   3.159058251447129e-10,  -1.999191811126752e-12,   1.265138885065575e-14,  -8.005562403147857e-17,   5.064137098612794e-19,  -3.197711530277421e-21,
   1.969101545862268e-01,  -1.246281068233057e-03,   7.887832314953440e-06,  -4.992213216850412e-08,   3.159528968314586e-10,  -1.999608871730680e-12,   1.265490699921902e-14,
  -8.008419065727749e-17,   5.066371477247274e-19,  -3.199346469078140e-21,   1.969116940193292e-01,  -1.246310295228685e-03,   7.888202270487550e-06,  -4.992603464713832e-08,
   3.159899455652101e-10,  -1.999937135500127e-12,   1.265767616435958e-14,  -8.010667616242104e-17,   5.068130190152325e-19,  -3.200633118628549e-21,   1.969125824672590e-01,
  -1.246327163046507e-03,   7.888415785647768e-06,  -4.992828694111321e-08,   3.160113283441935e-10,  -2.000126596924301e-12,   1.265927444952519e-14,  -8.011965435822311e-17,
   5.069145275978898e-19,  -3.201375646584953e-21,   1.969129160903673e-01,  -1.246333497145444e-03,   7.888495963958699e-06,  -4.992913271827829e-08,   3.160193580228744e-10,
  -2.000197744216288e-12,   1.265987464905966e-14,  -8.012452805894860e-17,   5.069526469357704e-19,  -3.201654468902399e-21,   1.969129713932825e-01,  -1.246334547116469e-03,
   7.888509254727075e-06,  -4.992927291891936e-08,   3.160206890693188e-10,  -2.000209538037767e-12,   1.265997414217765e-14,  -8.012533595827604e-17,   5.069589658595343e-19,
  -3.201700687464185e-21,   2.837617132909422e-01,  -1.795890994649456e-03,   1.136551392621868e-05,  -7.192520520928267e-08,   4.551515614080312e-10,  -2.880139937481847e-12,
   1.822432345694240e-14,  -1.153060034389565e-16,   7.292914745893275e-19,  -4.603995509612872e-21,   2.837633314690392e-01,  -1.795921715595802e-03,   1.136590277530847e-05,
  -7.192930677289432e-08,   4.551904978049358e-10,  -2.880484901773706e-12,   1.822723322819741e-14,  -1.153296261549775e-16,   7.294761156456349e-19,  -4.605342024593384e-21,
   2.837659880103862e-01,  -1.795972150269002e-03,   1.136654115808117e-05,  -7.193604050855072e-08,   4.552544226953537e-10,  -2.881051267554471e-12,   1.823201062074958e-14,
  -1.153684116527345e-16,   7.297792687849269e-19,  -4.607552429878618e-21,   2.837688068606048e-01,  -1.796025667078693e-03,   1.136721856424651e-05,  -7.194318600530875e-08,
   4.553222580523750e-10,  -2.881652294833274e-12,   1.823708052675328e-14,  -1.154095728402414e-16,   7.301009851773547e-19,  -4.609897680187554e-21,   2.837710253500252e-01,
  -1.796067786337054e-03,   1.136775171013894e-05,  -7.194880989838922e-08,   4.553756492573607e-10,  -2.882125356721647e-12,   1.824107109313726e-14,  -1.154419718175048e-16,
   7.303542120176249e-19,  -4.611743287043041e-21,   2.837723056994795e-01,  -1.796092094684922e-03,   1.136805940855171e-05,  -7.195205569719709e-08,   4.554064641386978e-10,
  -2.882398390136896e-12,   1.824337433697801e-14,  -1.154606718675007e-16,   7.305003679379292e-19,  -4.612808375359340e-21,   2.837727864864232e-01,  -1.796101222805822e-03,
   1.136817495415974e-05,  -7.195327455341415e-08,   4.554180357681731e-10,  -2.882500920707911e-12,   1.824423926762751e-14,  -1.154676942939410e-16,   7.305552535388227e-19,
  -4.613208317588861e-21,   2.837728661838988e-01,  -1.796102735927507e-03,   1.136819410759282e-05,  -7.195347659767599e-08,   4.554199539490714e-10,  -2.882517916818580e-12,
   1.824438264435664e-14,  -1.154688583812504e-16,   7.305643517498960e-19,  -4.613274613260831e-21,   3.939695816728600e-01,  -2.493382266712781e-03,   1.577967201775909e-05,
  -9.985964163160201e-08,   6.319241142022332e-10,  -3.998733460458527e-12,   2.530230317206686e-14,  -1.600879824217764e-16,   1.012500360997890e-18,  -6.390730538440784e-21,
   3.939718283217843e-01,  -2.493424919113753e-03,   1.578021188873257e-05,  -9.986533616726757e-08,   6.319781727515255e-10,  -3.999212400170833e-12,   2.530634290066074e-14,
  -1.601207723958873e-16,   1.012756387763654e-18,  -6.392587398015554e-21,   3.939755166152858e-01,  -2.493494941693136e-03,   1.578109820771334e-05,  -9.987468516230420e-08,
   6.320669248473972e-10,  -3.999998728104053e-12,   2.531297550677335e-14,  -1.601746093207172e-16,   1.013176743639592e-18,  -6.395635494248829e-21,   3.939794302554614e-01,
  -2.493569243454546e-03,   1.578203870605964e-05,  -9.988460583889604e-08,   6.321611061600449e-10,  -4.000833179163442e-12,   2.532001421736231e-14,  -1.602317438031577e-16,
   1.013622836859198e-18,  -6.398869432339023e-21,   3.939825103656663e-01,  -2.493627721063798e-03,   1.578277891607809e-05,  -9.989241394885816e-08,   6.322352334879640e-10,
  -4.001489966298470e-12,   2.532555444576403e-14,  -1.602767157062432e-16,   1.013973960241618e-18,  -6.401414319527368e-21,   3.939842879794714e-01,  -2.493661470330131e-03,
   1.578320611893387e-05,  -9.989692035636602e-08,   6.322780162798029e-10,  -4.001869038965298e-12,   2.532875211102047e-14,  -1.603026725826134e-16,   1.014176618705106e-18,
  -6.402882927226360e-21,   3.939849554952856e-01,  -2.493674143646517e-03,   1.578336654034546e-05,  -9.989861259397286e-08,   6.322940821088141e-10,  -4.002011389807688e-12,
   2.532995292114676e-14,  -1.603124201603286e-16,   1.014252722429218e-18,  -6.403434385714335e-21,   3.939850661458056e-01,  -2.493676244437037e-03,   1.578339313262209e-05,
  -9.989889310851867e-08,   6.322967452744798e-10,  -4.002034986776287e-12,   2.533015197551621e-14,  -1.603140359878972e-16,   1.014265337893090e-18,  -6.403525796884592e-21,
   5.365761302644690e-01,  -3.395920574021626e-03,   2.149149513509732e-05,  -1.360061856039325e-07,   8.606638910652456e-10,  -5.446168502184459e-12,   3.446103533745275e-14,
  -2.180339670311038e-16,   1.378925132107880e-18,  -8.701073861944385e-21,   5.365791901407689e-01,  -3.395978665461450e-03,   2.149223042505068e-05,  -1.360139414098425e-07,
   8.607375173068289e-10,  -5.446820800278070e-12,   3.446653703316033e-14,  -2.180786103504847e-16,   1.379273134292325e-18,  -8.703575576479621e-21,   5.365842134987802e-01,
  -3.396074034358955e-03,   2.149343756800525e-05,  -1.360266744920789e-07,   8.608583951940749e-10,  -5.447891749674085e-12,   3.447556995993190e-14,  -2.181519088464183e-16,
   1.379844495101262e-18,  -8.707682051314518e-21,   5.365895437729898e-01,  -3.396175231388980e-03,   2.149471850181925e-05,  -1.360401861893600e-07,   8.609866675229898e-10,
  -5.449028240931902e-12,   3.448515595649324e-14,  -2.182296968029539e-16,   1.380450833040316e-18,  -8.712038662684348e-21,   5.365937388014675e-01,  -3.396254876343110e-03,
   2.149572664824054e-05,  -1.360508206271543e-07,   8.610876268818786e-10,  -5.449922760509697e-12,   3.449270117318091e-14,  -2.182909254463220e-16,   1.380928082005328e-18,
  -8.715466846416917e-21,   5.365961598643644e-01,  -3.396300841949491e-03,   2.149630848720444e-05,  -1.360569582341468e-07,   8.611458958542375e-10,  -5.450439043327958e-12,
   3.449705606094681e-14,  -2.183262653463188e-16,   1.381203534868449e-18,  -8.717445119952951e-21,   5.365970690032144e-01,  -3.396318102670562e-03,   2.149652697691406e-05,
  -1.360592630166923e-07,   8.611677770663979e-10,  -5.450632919857604e-12,   3.449869143939693e-14,  -2.183395365205372e-16,   1.381306974530897e-18,  -8.718187943732574e-21,
   5.365972197062904e-01,  -3.396320963891579e-03,   2.149656319488984e-05,  -1.360596450700318e-07,   8.611714042239432e-10,  -5.450665058047209e-12,   3.449896253072902e-14,
  -2.183417364440430e-16,   1.381324121366199e-18,  -8.718311075419949e-21,   7.348388613056898e-01,  -4.650699624794306e-03,   2.943251650847084e-05,  -1.862599262736945e-07,
   1.178675734866738e-09,  -7.458504696665169e-12,   4.719417239548551e-14,  -2.985925693435514e-16,   1.888246282853834e-18,  -1.190859742867075e-20,   7.348430517940268e-01,
  -4.650779180788395e-03,   2.943352348510164e-05,  -1.862705478169312e-07,   1.178776565535004e-09,  -7.459398003465425e-12,   4.720170616623278e-14,  -2.986536679048858e-16,
   1.888721064692556e-18,  -1.191195235021490e-20,   7.348499312627033e-01,  -4.650909788111419e-03,   2.943517666251776e-05,  -1.862879857189334e-07,   1.178942107029434e-09,
  -7.460864643229080e-12,   4.721407543834263e-14,  -2.987539834989772e-16,   1.889500564876024e-18,  -1.191745886894721e-20,   7.348572310518842e-01,  -4.651048377038577e-03,
   2.943693089621861e-05,  -1.863064899309117e-07,   1.179117775162856e-09,  -7.462421040898193e-12,   4.722720205165632e-14,  -2.988604429719872e-16,   1.890327768368816e-18,
  -1.192330017124359e-20,   7.348629761265821e-01,  -4.651157450484149e-03,   2.943831154868338e-05,  -1.863210537482430e-07,   1.179256038357459e-09,  -7.463646064037743e-12,
   4.723753411182177e-14,  -2.989442393525691e-16,   1.890978849466988e-18,  -1.192789618680889e-20,   7.348662917625224e-01,  -4.651220400197919e-03,   2.943910837480168e-05,
  -1.863294591749110e-07,   1.179335837340980e-09,  -7.464353100958909e-12,   4.724349748555934e-14,  -2.989926047785493e-16,   1.891354628155103e-18,  -1.193054818655773e-20,
   7.348675368245360e-01,  -4.651244038686269e-03,   2.943940759557926e-05,  -1.863326155648018e-07,   1.179365803520451e-09,  -7.464618610203848e-12,   4.724573689372446e-14,
  -2.990107674023012e-16,   1.891495741897645e-18,  -1.193154395343903e-20,   7.348677432117950e-01,  -4.651247957116987e-03,   2.943945719595126e-05,  -1.863331387852248e-07,
   1.179370770889401e-09,  -7.464662622681298e-12,   4.724610811306471e-14,  -2.990137781659787e-16,   1.891519133789709e-18,  -1.193170901154273e-20,   1.486281485006621e-03,
  -9.174240732642685e-06,   5.662692247514529e-08,  -3.495099526192606e-10,   2.157147713851918e-12,  -1.331324441342275e-14,   8.216200454255324e-17,  -5.070336296189135e-19,
   3.128606562170502e-21,  -1.929385326257968e-23,   1.486289547139662e-03,  -9.174390013125877e-06,   5.662876533755663e-08,  -3.495289111522082e-10,   2.157323245999790e-12,
  -1.331476124252932e-14,   8.217448660596085e-17,  -5.071326249062525e-19,   3.129367772356283e-21,  -1.929949978116809e-23,   1.486302782625950e-03,  -9.174635087059370e-06,
   5.663179080292473e-08,  -3.495600362141014e-10,   2.157611429704247e-12,  -1.331725157699930e-14,   8.219498012710923e-17,  -5.072951626133099e-19,   3.130617601005236e-21,
  -1.930877051896468e-23,   1.486316826758301e-03,  -9.174895137410569e-06,   5.663500120295193e-08,  -3.495930644332395e-10,   2.157917241087997e-12,  -1.331989430523470e-14,
   8.221672831910643e-17,  -5.074676561196345e-19,   3.131944008971331e-21,  -1.931860893228057e-23,   1.486327879751408e-03,  -9.175099804171917e-06,   5.663752791140222e-08,
  -3.496190593524105e-10,   2.158157935225455e-12,  -1.332197435687788e-14,   8.223384641990314e-17,  -5.076034300065652e-19,   3.132988075060480e-21,  -1.932635285942668e-23,
   1.486334258724887e-03,  -9.175217923674414e-06,   5.663898616705364e-08,  -3.496340621447833e-10,   2.158296852124057e-12,  -1.332317487979522e-14,   8.224372647628475e-17,
  -5.076817960261948e-19,   3.133590696581230e-21,  -1.933082244932564e-23,   1.486336654107040e-03,  -9.175262279159247e-06,   5.663953376464073e-08,  -3.496396959589789e-10,
   2.158349018238392e-12,  -1.332362570404940e-14,   8.224743669933364e-17,  -5.077112248060876e-19,   3.133817000291540e-21,  -1.933250090375359e-23,   1.486337051176667e-03,
  -9.175269631738811e-06,   5.663962453720573e-08,  -3.496406298504676e-10,   2.158357665594375e-12,  -1.332370043546455e-14,   8.224805173054381e-17,  -5.077161031299042e-19,
   3.133854514074349e-21,  -1.933277913576509e-23,   1.342934855008869e-02,  -8.289417430274281e-05,   5.116545465369473e-07,  -3.158009450273550e-09,   1.949098391700963e-11,
  -1.202922872597897e-13,   7.423776682913647e-16,  -4.581319697946843e-18,   2.826861327776691e-20,  -1.743294443010489e-22,   1.342942139577489e-02,  -8.289552313179083e-05,
   5.116711977849771e-07,  -3.158180750763526e-09,   1.949256994387554e-11,  -1.203059926209772e-13,   7.424904503250093e-16,  -4.582214168803936e-18,   2.827549101768177e-20,
  -1.743804557615826e-22,   1.342954098547602e-02,  -8.289773750592293e-05,   5.116985344835500e-07,  -3.158461982352887e-09,   1.949517383782377e-11,  -1.203284941231081e-13,
   7.426756201089652e-16,  -4.583682776484443e-18,   2.828678355633896e-20,  -1.744642088922874e-22,   1.342966788172706e-02,  -8.290008720000310e-05,   5.117275421657292e-07,
  -3.158760409986342e-09,   1.949793700728504e-11,  -1.203523725842964e-13,   7.428721265057149e-16,  -4.585241339641888e-18,   2.829876800808779e-20,  -1.745530904182033e-22,
   1.342976775143441e-02,  -8.290193647371231e-05,   5.117503723286571e-07,  -3.158995287991043e-09,   1.950011180758820e-11,  -1.203711669619175e-13,   7.430267975834252e-16,
  -4.586468123058608e-18,   2.830820142403086e-20,  -1.746230500327444e-22,   1.342982538887328e-02,  -8.290300374662500e-05,   5.117635484488023e-07,  -3.159130846248189e-09,
   1.950136699608748e-11,  -1.203820143277111e-13,   7.431160691084991e-16,  -4.587176198329577e-18,   2.831364626991790e-20,  -1.746634288529180e-22,   1.342984703243284e-02,
  -8.290340452216581e-05,   5.117684962860295e-07,  -3.159181750774124e-09,   1.950183834483930e-11,  -1.203860877656457e-13,   7.431495929323237e-16,  -4.587442101730406e-18,
   2.831569098410108e-20,  -1.746785922113535e-22,   1.342985062016940e-02,  -8.290347095665665e-05,   5.117693164647280e-07,  -3.159190188983454e-09,   1.950191647832694e-11,
  -1.203867630038977e-13,   7.431551500639721e-16,  -4.587486179768793e-18,   2.831602993109654e-20,  -1.746811057924998e-22,   3.760501813897522e-02,  -2.321212318410903e-04,
   1.432741017305023e-06,  -8.843094824444238e-09,   5.457888004461370e-11,  -3.368438622451311e-13,   2.078814536869362e-15,  -1.282866204466340e-17,   7.915797742064645e-20,
  -4.881544512786461e-22,   3.760522212231369e-02,  -2.321250088478920e-04,   1.432787644323581e-06,  -8.843574502069078e-09,   5.458332125538967e-11,  -3.368822401485674e-13,
   2.079130349920179e-15,  -1.283116672609877e-17,   7.917723538126444e-20,  -4.882972486390136e-22,   3.760555699878694e-02,  -2.321312095641138e-04,   1.432864192865130e-06,
  -8.844362010037285e-09,   5.459061270934270e-11,  -3.369452491027544e-13,   2.079648863659706e-15,  -1.283527909512267e-17,   7.920885495664382e-20,  -4.885317001117991e-22,
   3.760591233514626e-02,  -2.321377892048295e-04,   1.432945420514424e-06,  -8.845197670568197e-09,   5.459835016842861e-11,  -3.370121138327883e-13,   2.080199122258098e-15,
  -1.283964335564309e-17,   7.924241190758466e-20,  -4.887805072108164e-22,   3.760619199146337e-02,  -2.321429675625970e-04,   1.433009349802403e-06,  -8.845855378689368e-09,
   5.460444006939176e-11,  -3.370647420559618e-13,   2.080632233297719e-15,  -1.284307857233774e-17,   7.926882584775535e-20,  -4.889763457110309e-22,   3.760635338849064e-02,
  -2.321459561526311e-04,   1.433046245727406e-06,  -8.846234970498015e-09,   5.460795486274493e-11,  -3.370951169690830e-13,   2.080882212048770e-15,  -1.284506131181583e-17,
   7.928407163015683e-20,  -4.890893783519917e-22,   3.760641399503808e-02,  -2.321470784089658e-04,   1.433060100718803e-06,  -8.846377513943726e-09,   5.460927473897135e-11,
  -3.371065234548304e-13,   2.080976085695277e-15,  -1.284580588966370e-17,   7.928979690966654e-20,  -4.891318251994538e-22,   3.760642404145975e-02,  -2.321472644396004e-04,
   1.433062397392742e-06,  -8.846401142715654e-09,   5.460949352926709e-11,  -3.371084142644170e-13,   2.080991646814266e-15,  -1.284592931618132e-17,   7.929074597445321e-20,
  -4.891388614757192e-22,   7.463285746562040e-02,  -4.606797621188915e-04,   2.843491678009106e-06,  -1.755046183289080e-08,   1.083200587379856e-10,  -6.685176900177389e-13,
   4.125722325924629e-15,  -2.546041547701377e-17,   1.571006164740374e-19,  -9.688010818652476e-22,   7.463326230146888e-02,  -4.606872581612875e-04,   2.843584216393637e-06,
  -1.755141382582752e-08,   1.083288729934606e-10,  -6.685938567564435e-13,   4.126349103170112e-15,  -2.546538631409632e-17,   1.571388331348848e-19,  -9.690843411366525e-22,
   7.463392691457993e-02,  -4.606995644223360e-04,   2.843736138575073e-06,  -1.755297675472916e-08,   1.083433439882314e-10,  -6.687189075307980e-13,   4.127378169604400e-15,
  -2.547354779716809e-17,   1.572015809085571e-19,  -9.695494087663178e-22,   7.463463213343555e-02,  -4.607126227164679e-04,   2.843897347154934e-06,  -1.755463524968847e-08,
   1.083587001477392e-10,  -6.688516106737142e-13,   4.128470238344787e-15,  -2.548220918801834e-17,   1.572681732952787e-19,  -9.700429516316651e-22,   7.463518715377822e-02,
  -4.607228999522277e-04,   2.844024224515245e-06,  -1.755594057112378e-08,   1.083707864786030e-10,  -6.689560593210943e-13,   4.129329810595328e-15,  -2.548902678106937e-17,
   1.573205906490983e-19,  -9.704314231914691e-22,   7.463550747063825e-02,  -4.607288312620652e-04,   2.844097450069894e-06,  -1.755669392859123e-08,   1.083777621183771e-10,
  -6.690163429178941e-13,   4.129825930010842e-15,  -2.549296176141492e-17,   1.573508452543823e-19,  -9.706556380371126e-22,   7.463562775351645e-02,  -4.607310585498372e-04,
   2.844124947400010e-06,  -1.7