//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_12.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot12(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[12] = {5.036188911729393e-02,4.545066815637803e-01,1.269589940103960e+00,2.509848097232131e+00,4.198415644878412e+00,
    6.369975388030638e+00,9.075434230961196e+00,1.239044796380947e+01,1.643219508767532e+01,2.139675593616611e+01,2.766110877984608e+01,3.619136036061554e+01
    };
  constexpr double aw[12] = {4.269311638686991e-01,2.861795353464431e-01,1.277396217845591e-01,3.744547050323081e-02,7.048355810072694e-03,
    8.236924826884174e-04,5.688691636404396e-05,2.158245704902338e-06,4.018971174941392e-08,3.046254269987585e-10,6.584620243078147e-13,1.664368496489123e-16
    };
  constexpr double x[4608] = {  7.887522449637157e-03, -1.571539836577658e-04,  2.339142202190098e-06, -3.079063210893806e-08,  3.774445513368981e-10,
 -4.406083378307222e-12,  4.951308025311900e-14, -5.386621026088275e-16,  5.686664908621152e-18, -5.827680842405324e-20,  5.786336246997091e-22, -5.543825606929964e-24,
  7.029757867252290e-02, -1.358419322164850e-03,  1.898665202054120e-05, -2.238818861471628e-07,  2.291999841217998e-09, -1.993221450023352e-11,  1.323423440341534e-13,
 -3.347816474773429e-16, -8.364710375633505e-18,  1.970025739572160e-19, -2.789045221285068e-21,  3.008470945183432e-23,  1.914664806212864e-01, -3.475837063148429e-03,
  4.242936502306773e-05, -3.812368328807118e-07,  2.061088576338460e-09,  6.262181687309262e-12, -3.298744651294299e-13,  4.658630554848201e-15, -3.606767921016688e-17,
 -5.250904862384913e-21,  5.065180383601532e-21, -8.801125731934164e-23,  3.642349474314633e-01, -6.001082925858448e-03,  5.799257845918238e-05, -2.603285238675213e-07,
 -2.233295555127872e-09,  5.632220786232642e-11, -4.493823171812796e-13, -1.572405491607338e-15,  8.489001468771984e-17, -9.383966137239516e-19,  1.278188052344531e-22,
  1.460106465760989e-22,  5.782297444627502e-01, -8.315967731149296e-03,  5.389860818938499e-05,  1.506158600726937e-07, -6.466667136275261e-09,  3.676432961221982e-11,
  5.343126514855715e-13, -1.010649457670153e-14,  1.219518182719137e-17,  1.491137258093036e-18, -1.625897451319392e-20, -9.528181241776455e-23,  8.203227141476730e-01,
 -9.836702624306595e-03,  2.790879786936229e-05,  5.819434787704647e-07, -4.925390505012254e-09, -5.297600551719047e-11,  8.908991063288164e-13,  4.296197787678536e-15,
 -1.594445935587737e-16, -3.438404015637789e-20,  2.755912652231613e-20, -1.146973242410983e-22,  1.075270685214431e+00, -1.015985797329852e-02, -1.068957816280062e-05,
  6.940360774294208e-07,  1.909376254976486e-09, -8.454482268755103e-11, -3.737087063999451e-13,  1.239321929210788e-14,  7.629679854939803e-17, -1.991324961278489e-18,
 -1.598613884860084e-20,  3.366418067821400e-22,  1.326546907261703e+00, -9.175494575757469e-03, -4.531615467906467e-05,  3.819383075937882e-07,  6.883994224603927e-09,
 -4.508428573000208e-12, -9.859973541421567e-13, -5.857799263583729e-15,  1.175668556573443e-16,  1.786132920926474e-18, -7.837194165406111e-21, -3.730126561082840e-22,
  1.557358201711563e+00, -7.114145957199287e-03, -6.087519116722460e-05, -1.101143711752620e-07,  4.843656936355953e-09,  6.544916165505918e-11,  8.908136173853674e-14,
 -8.419871033048354e-15, -1.130929355983095e-16, -1.342253424370492e-20,  1.855693091585490e-20,  2.311566657664676e-22,  1.751811835853525e+00, -4.505266573059890e-03,
 -5.244874638247836e-05, -3.999885306274292e-07, -7.739187589684368e-10,  3.270951376943238e-11,  5.916972279686018e-13,  4.859575446161091e-15, -6.283243677447460e-18,
 -8.213378020452109e-19, -1.256596862517351e-20, -8.001919238176826e-23,  1.896154760080191e+00, -2.046613678350778e-03, -2.855750916692554e-05, -3.245978443176906e-07,
 -3.001089094486569e-09, -1.990811528145388e-11, -2.653427158924511e-14,  1.868285324207997e-15,  3.829756826680555e-17,  4.850646905289752e-19,  4.184128571028724e-21,
  1.421877047621856e-23,  1.979982291328720e+00, -4.126896780186773e-04, -6.316199352791858e-06, -8.473697781325213e-08, -1.046597006775260e-09, -1.212456306558833e-11,
 -1.325302150735627e-13, -1.363954726014563e-15, -1.307596314937102e-17, -1.138309415297373e-19, -8.441876812994450e-22, -4.229218421789964e-24,  7.294129310171290e-03,
 -1.398224332739216e-04,  2.003177249747330e-06, -2.539670902952885e-08,  3.000829294235971e-10, -3.379986817394436e-12,  3.669205531904242e-14, -3.862264972720517e-16,
  3.952509831247697e-18, -3.936660153867282e-20,  3.811439803931342e-22, -3.578604535775291e-24,  6.515151436737660e-02, -1.216678206103916e-03,  1.650749527452107e-05,
 -1.902301230379509e-07,  1.924227309721045e-09, -1.689288791763274e-11,  1.201477639056549e-13, -5.081173075836305e-16, -2.991333310202312e-18,  1.087007185983307e-19,
 -1.700608900483923e-21,  1.985668434206779e-23,  1.782138289539319e-01, -3.154133960343692e-03,  3.805524273396694e-05, -3.476456090616027e-07,  2.117057862574125e-09,
 -2.188779402795911e-13, -2.153812901204755e-13,  3.533646237979276e-15, -3.344060632829824e-17,  1.310519196799700e-19,  2.011487226809846e-21, -5.220699709542463e-23,
  3.411379624384245e-01, -5.550163774402903e-03,  5.468948579136073e-05, -2.876455378872972e-07, -1.216814368052742e-09,  4.528476585167229e-11, -4.603862304611962e-13,
  6.153906529117836e-16,  5.248831639033030e-17, -8.329605827355184e-19,  4.495178636350042e-21,  5.721989152200549e-23,  5.458372936761040e-01, -7.879248301716029e-03,
  5.511146017410478e-05,  5.363339180020123e-08, -5.625645484835139e-09,  4.628111536043355e-11,  2.639367084870294e-13, -8.988082354415279e-15,  5.360880919088180e-17,
  8.053433165435672e-19, -1.695831964451690e-20,  5.144413379733893e-23,  7.814646843122030e-01, -9.586911475321040e-03,  3.438816801700460e-05,  4.958533868766664e-07,
 -5.764308882814742e-09, -3.072130276247603e-11,  9.410179227227774e-13, -6.263903110079995e-16, -1.425691923648186e-16,  9.124907629756260e-19,  1.866827845396875e-20,
 -2.672831544004239e-22,  1.034513527331560e+00, -1.021167258788579e-02, -2.234890848043819e-06,  7.106936711113349e-07,  1.580286577579484e-10, -8.914370908189627e-11,
 -3.994691556036536e-15,  1.359565769189367e-14, -2.982690462220427e-18, -2.298706333587312e-18,  1.185306852586873e-21,  4.138822076741905e-22,  1.289151521393891e+00,
 -9.517833777414750e-03, -4.007930431360088e-05,  4.900277415157065e-07,  6.546339536430388e-09, -2.965902005675497e-11, -1.088299523481849e-12, -1.159998408197384e-15,
  1.722010465590802e-16,  1.139385895336151e-18, -2.429932335092415e-20, -3.446022741093538e-22,  1.527921237686334e+00, -7.605015691937347e-03, -6.168823646174204e-05,
 -2.211529837672284e-08,  6.152828262750075e-09,  6.435425049667787e-11, -1.962798267967765e-13, -1.188410704602844e-14, -9.787923111949460e-17,  9.176881653634963e-19,
  2.738647107870265e-20,  1.462568785104616e-22,  1.732920965447021e+00, -4.944211541473744e-03, -5.729869275414025e-05, -4.063206661917828e-07,  3.305386851019993e-11,
  4.848939819599248e-11,  7.197775694274718e-13,  4.082309608737231e-15, -4.562184411962813e-17, -1.379517437887264e-18, -1.483209499716176e-20, -9.167324672467514e-24,
  1.887485523307284e+00, -2.291501130405379e-03, -3.275398421888168e-05, -3.758146732246599e-07, -3.400593893086129e-09, -1.976139555557634e-11,  4.579595623484181e-14,
  3.406389807914925e-15,  5.886928827909770e-17,  6.586283891739903e-19,  4.286037603729459e-21, -1.469752100986060e-23,  1.978223605728531e+00, -4.675909423904255e-04,
 -7.442116056021311e-06, -1.036091657807073e-07, -1.324250277380679e-09, -1.581488791117667e-11, -1.772435280444152e-13, -1.854816861924054e-15, -1.782382865678961e-17,
 -1.509847683625694e-19, -1.000076028929548e-21, -2.336719934943952e-24,  6.765069092034755e-03, -1.249392787429643e-04,  1.725139436407440e-06, -2.109176914576713e-08,
  2.404819922785808e-10, -2.616068759054074e-12,  2.745470598901760e-14, -2.797615147505644e-16,  2.775599343005796e-18, -2.685997052106302e-20,  2.532836390752875e-22,
 -2.325649872245369e-24,  6.053517028010931e-02, -1.093250583941459e-03,  1.439880422467473e-05, -1.619936653307324e-07,  1.614010465283699e-09, -1.418769963050112e-11,
  1.050842254953039e-13, -5.527938070878278e-16, -1.139107573197603e-19,  5.578244797004118e-20, -9.988486405594159e-22,  1.249699453659654e-23,  1.661805663364181e-01,
 -2.865805166986122e-03,  3.408576556145008e-05, -3.140570356715921e-07,  2.068398356155936e-09, -4.316832142513032e-12, -1.306241010547777e-13,  2.550581937210436e-15,
 -2.775084433261060e-17,  1.738954899037341e-19,  3.170865776082758e-22, -2.660178171044150e-23,  3.197900966838772e-01, -5.126720873185879e-03,  5.114889191077743e-05,
 -3.004604175284973e-07, -4.193478698305878e-10,  3.460569812133211e-11, -4.238784495932909e-13,  1.853675948441394e-15,  2.616797969572055e-17, -6.217532207344434e-19,
  5.658137409683072e-21,  1.261743320984453e-24,  5.152040947861447e-01, -7.437240219315184e-03,  5.524643456954043e-05, -2.870956479773702e-08, -4.655964418872186e-09,
  4.981169950058088e-11,  3.974618164042820e-14, -6.933564074277314e-15,  7.118082753841386e-17,  1.979526094729674e-19, -1.291923185811288e-20,  1.192691086811641e-22,
  7.437026688598591e-01, -9.289611850489907e-03,  3.976869612715012e-05,  3.999213201173256e-07, -6.156829949903336e-09, -8.827954263557237e-12,  8.654354154609764e-13,
 -4.542909170976651e-15, -9.925539861880268e-17,  1.410287518738406e-18,  6.125753006030048e-21, -2.811212930718209e-22,  9.936849742204463e-01, -1.019553032852012e-02,
  6.250103300457387e-06,  6.990821945904199e-07, -1.595345520936479e-09, -8.475749516235939e-11,  3.631744518058435e-13,  1.222004891168046e-14, -8.064285419224286e-17,
 -1.905993119158371e-18,  1.766495578780037e-20,  3.071794627573229e-22,  1.250478602255948e+00, -9.813220585617876e-03, -3.359469704020246e-05,  5.886051618712723e-07,
  5.692688648338186e-09, -5.551478020034400e-11, -1.038962827684994e-12,  4.792279108516303e-15,  1.925121267732699e-16, -8.453293209438249e-20, -3.529604858180606e-20,
 -1.260681388800896e-22,  1.496514971216020e+00, -8.097813979047968e-03, -6.132162726084067e-05,  8.625164790734881e-08,  7.364181689556197e-09,  5.533487994216084e-11,
 -5.663541179100203e-13, -1.426699806364119e-14, -4.409742194967134e-17,  2.081973471768628e-18,  2.905535505714557e-20, -9.645861061032131e-23,  1.712196577591723e+00,
 -5.422015504264709e-03, -6.213622655295492e-05, -3.970596427627127e-07,  1.183784970320440e-09,  6.692078847033609e-11,  8.053683020953905e-13,  1.714903596830261e-15,
 -1.056880380817498e-16, -1.938304098406910e-18, -1.184510071271974e-20,  1.643686029916852e-22,  1.877765548397826e+00, -2.572526541783910e-03, -3.760296792875220e-05,
 -4.332897304149513e-07, -3.775907806126860e-09, -1.728183118941529e-11,  1.713367470711750e-13,  5.700437216229137e-15,  8.535916004445653e-17,  7.998136190076490e-19,
  2.244903602389604e-21, -8.774924857758771e-23,  1.976225751596026e+00, -5.324869397158110e-04, -8.823791759450039e-06, -1.275775623081371e-07, -1.687648628193944e-09,
 -2.076170391045242e-11, -2.380364146001057e-13, -2.519984644056789e-15, -2.399083870207724e-17, -1.914891368375956e-19, -9.735723302934339e-22,  4.855386644586590e-24,
  6.291398613776548e-03, -1.120889134240812e-04,  1.493506975081390e-06, -1.762932088761609e-08,  1.941635658979393e-10, -2.041947330650040e-12,  2.073234781340279e-14,
 -2.046422640804641e-16,  1.968778493807607e-18, -1.851315097036350e-20,  1.698762804170735e-22, -1.524147104054787e-24,  5.638082973089588e-02, -9.854175363457646e-04,
  1.260089088904939e-05, -1.383077487493605e-07,  1.354227772036409e-09, -1.185022420330252e-11,  8.980762414923447e-14, -5.310427090213561e-16,  1.292750995244571e-18,
  2.522606858108973e-20, -5.646348351293952e-22,  7.589049055424645e-24,  1.552396339413257e-01, -2.607638730608890e-03,  3.051230867252661e-05, -2.818011382318208e-07,
  1.956002741626760e-09, -6.689340645364814e-12, -7.069324435607439e-14,  1.763204538805630e-15, -2.149536513216036e-17,  1.684236465054556e-19, -4.768384531341382e-22,
 -1.092541782810414e-23,  3.000786643806095e-01, -4.732016797346012e-03,  4.752421057185454e-05, -3.021667094560794e-07,  1.756463272228083e-10,  2.513094475680419e-11,
 -3.633081653062316e-13,  2.376106524399276e-15,  7.782465919653891e-18, -4.037789498959430e-19,  5.053798474685876e-21, -2.456397729003048e-23,  4.863352069145868e-01,
 -6.997837482387120e-03,  5.448782172620274e-05, -9.524461996600707e-08, -3.664570645414106e-09,  4.869660033776372e-11, -1.220830940877536e-13, -4.630882155245432e-15,
  7.031794440449805e-17, -2.093814658356023e-19, -7.432777897074254e-21,  1.218215476615212e-22,  7.072085416477484e-01, -8.953947041190617e-03,  4.397439306429150e-05,
  3.010790031272201e-07, -6.137639383194642e-09,  1.010519408025526e-11,  7.016024523825474e-13, -6.882527768593678e-15, -4.687637897672056e-17,  1.428729113616006e-18,
 -4.554853020654284e-21, -1.932503048153399e-22,  9.530552068908148e-01, -1.011253269173772e-02,  1.443183413986451e-05,  6.605793757533708e-07, -3.177374903614462e-09,
 -7.228491218345800e-11,  6.600005483823197e-13,  8.700853233688880e-15, -1.338348140082675e-16, -9.908832139796754e-19,  2.643052255378995e-20,  8.140827133715635e-23,
  1.210735002742346e+00, -1.005226961047058e-02, -2.602581079015816e-05,  6.695090213408938e-07,  4.347460540495459e-09, -7.815627884808601e-11, -8.209693091355299e-13,
  1.062622598162536e-14,  1.635749277345632e-16, -1.512349921328945e-18, -3.364442797028746e-20,  2.073524859315789e-22,  1.463152056249460e+00, -8.582165232399264e-03,
 -5.954589323180479e-05,  2.120558826499883e-07,  8.302094769367466e-09,  3.686617416406646e-11, -9.727958233183122e-13, -1.426880193867794e-14,  4.984492959992503e-17,
  3.058784999458427e-18,  1.718493255142837e-20, -4.504873438373111e-22,  1.689484756756695e+00, -5.937733597181740e-03, -6.673970311698740e-05, -3.663529610814309e-07,
  2.717119288795909e-09,  8.637635353647153e-11,  7.949989356629268e-13, -2.856419975893188e-15, -1.815660508550013e-16, -2.190632737851445e-18,  1.304244284290371e-21,
  4.479654725321762e-22,  1.866839382328175e+00, -2.895199762838050e-03, -4.317545172496935e-05, -4.961857588226905e-07, -4.065785383497971e-09, -1.091874375722130e-11,
  3.735881475546598e-13,  8.900303839281992e-15,  1.145120966177434e-16,  7.753482594646812e-19, -4.542851070744317e-21, -2.357405601793425e-22,  1.973944234917320e+00,
 -6.096937373783450e-04, -1.053151445599311e-05, -1.582378475729871e-07, -2.166203074216393e-09, -2.741466719073615e-11, -3.204301820921811e-13, -3.404836920895775e-15,
 -3.149453479865120e-17, -2.216022654751625e-19, -3.884217430406954e-22,  2.482406988670494e-23,  5.865669920091884e-03, -1.009371898296827e-04,  1.299329683797986e-06,
 -1.482420798880912e-08,  1.578705942619756e-10, -1.606583667921112e-12,  1.579282586179919e-14, -1.511142492804623e-16,  1.410016522067215e-18, -1.289116703049438e-20,
  1.149603939755833e-22, -1.009407168546693e-24,  5.263075965471684e-02, -8.908981074345798e-04,  1.106374837916802e-05, -1.184239932163830e-07,  1.137599913676778e-09,
 -9.867898733143548e-12,  7.562649357719637e-14, -4.789140193724939e-16,  1.865264284623158e-18,  8.290702828462532e-21, -3.048733482410590e-22,  4.457125477890863e-24,
  1.452765961114593e-01, -2.376545371927570e-03,  2.731380035564929e-05, -2.516521152599544e-07,  1.808870022380329e-09, -7.865818025218699e-12, -3.007271365377162e-14,
  1.167926059258561e-15, -1.586403534043515e-17,  1.426405301884513e-19, -7.513730425476546e-22, -2.514556310466875e-24,  2.818881339625606e-01, -4.366244104131222e-03,
  4.393018659313644e-05, -2.957862028324539e-07,  5.965536154171367e-10,  1.722596943132115e-11, -2.952109592660701e-13,  2.429275552774539e-15, -3.403547907464381e-18,
 -2.261210317159036e-19,  3.784987081839958e-21, -3.078308340365426e-23,  4.592071123863393e-01, -6.567430629667453e-03,  5.302460190422466e-05, -1.462851093183869e-07,
 -2.729163533108562e-09,  4.445613482271398e-11, -2.217290054091104e-13, -2.548645588505517e-15,  5.865184018201626e-17, -4.073477709473065e-19, -2.698420652979475e-21,
  9.027988746984355e-23,  6.721168962520928e-01, -8.589348574179976e-03,  4.700757564601315e-05,  2.053405156797954e-07, -5.783440631587109e-09,  2.450751329757288e-11,
  4.952865552352496e-13, -7.609330173333702e-15, -4.522433000889491e-19,  1.111563212059588e-18, -1.042973280410851e-20, -7.421417450019971e-23,  9.128848320331402e-01,
 -9.966338361468366e-03,  2.200904305040892e-05,  5.991102077842152e-07, -4.447553556558798e-09, -5.403092965943386e-11,  8.397782737019402e-13,  4.054218450416920e-15,
 -1.502519565051447e-16,  6.854054888187918e-20,  2.492319727714251e-20, -1.390277176307817e-22,  1.170161898712592e+00, -1.022728236434542e-02, -1.762909679617963e-05,
  7.256039133709862e-07,  2.614213933208832e-09, -9.375668904164828e-11, -4.600587590437633e-13,  1.475325914037066e-14,  8.795282948186386e-17, -2.584372607080453e-18,
 -1.794964078593989e-20,  4.801189599200650e-22,  1.427890027976575e+00, -9.046048387632386e-03, -5.618435938874061e-05,  3.493882060389763e-07,  8.774962731984820e-09,
  9.010414072102715e-12, -1.332746156328979e-12, -1.082403200712842e-14,  1.666525080295160e-16,  3.252524875924643e-18, -9.600019659304192e-21, -7.348287075579749e-22,
  1.664639369023865e+00, -6.488359266704466e-03, -7.081483347922710e-05, -3.080620837796348e-07,  4.625270106542865e-09,  1.037685776705097e-10,  6.221446920905601e-13,
 -9.874082888603308e-15, -2.538851949826972e-16, -1.651001291154177e-18,  2.788301092408507e-20,  7.466627596845280e-22,  1.854528487325924e+00, -3.265539166118491e-03,
 -4.952537442633085e-05, -5.624056708652437e-07, -4.172070149382786e-09,  1.475916434116899e-12,  6.779084391285639e-13,  1.295217644124880e-14,  1.360742810186856e-16,
  3.211025128102738e-19, -1.995674201226521e-20, -4.806576075797418e-22,  1.971324039272990e+00, -7.021750315024238e-04, -1.265786500556465e-05, -1.977358423861708e-07,
 -2.799741869508832e-09, -3.637031533750466e-11, -4.310804179096958e-13, -4.540530496523255e-15, -3.938887237741562e-17, -2.038209963017100e-19,  1.630330922513311e-21,
  7.377599098237335e-23,  5.481641358875955e-03, -9.121348853935647e-05,  1.135597407306068e-06, -1.253609009650381e-08,  1.292111117112406e-10, -1.273630722719820e-12,
  1.212940470535169e-14, -1.126117254799541e-16,  1.019006079448063e-18, -9.073010523835457e-21,  7.834446715672223e-23, -6.793146438803820e-25,  4.923560481874364e-02,
 -8.077774255301316e-04,  9.745664526207267e-06, -1.017070765861251e-07,  9.573418707635965e-10, -8.206832819736118e-12,  6.308265189375285e-14, -4.164601201474893e-16,
  1.985486251346111e-18, -6.267503134891374e-22, -1.552375044898650e-22,  2.495042552037425e-24,  1.361889884532902e-01, -2.169634417574139e-03,  2.446233605174068e-05,
 -2.239977953015425e-07,  1.646707966730392e-09, -8.247970630094400e-12, -3.748071593808787e-15,  7.365086377330832e-16, -1.128360105861719e-17,  1.117497653064215e-19,
 -7.657086531669502e-22,  1.285969682726201e-24,  2.651038213656184e-01, -4.028814290479181e-03,  4.044820594174687e-05, -2.838473262742365e-07,  8.756400412810059e-10,
  1.093829354021826e-11, -2.297467092061858e-13,  2.216712187442791e-15, -9.140736432834276e-18, -1.012326151971397e-19,  2.484973049242766e-21, -2.738196836511743e-23,
  4.337737044256740e-01, -6.150932242908661e-03,  5.103552785813381e-05, -1.831485057540629e-07, -1.897999670026343e-09,  3.847626361952935e-11, -2.691265509748994e-13,
 -9.201751450690719e-16,  4.289609248057577e-17, -4.474521127449363e-19,  4.067559900456324e-22,  5.117389921538226e-23,  6.385250621656186e-01, -8.204963630833817e-03,
  4.893452155243690e-05,  1.173004953720728e-07, -5.191541991023390e-09,  3.386999393714303e-11,  2.874368064390427e-13, -7.068554057976293e-15,  3.155237044769983e-17,
  6.597860471877764e-19, -1.147127193630075e-20,  1.989337710091200e-23,  8.734153486621803e-01, -9.762793321850653e-03,  2.873936933484760e-05,  5.204283884007949e-07,
 -5.320204687957669e-09, -3.304853523631247e-11,  8.876429393249654e-13, -5.367230060481928e-16, -1.317297167826346e-16,  8.992339473221097e-19,  1.575192827138605e-20,
 -2.567560164516135e-22,  1.129026661537125e+00, -1.033292077588348e-02, -8.734312950125729e-06,  7.519753811714780e-07,  6.633906992113093e-10, -9.961281682878589e-11,
 -2.228754055694188e-14,  1.598431519845288e-14, -1.257142288882924e-17, -2.845574071505055e-18,  5.264461959615262e-21,  5.311515646297361e-22,  1.390836811033089e+00,
 -9.476363897038055e-03, -5.114923964868859e-05,  4.894005188623760e-07,  8.614321738241945e-09, -2.590581431345040e-11, -1.544460297561282e-12, -3.756853076291894e-15,
  2.687974174943113e-16,  2.200870725880669e-18, -4.277914330465774e-20, -7.047615650715872e-22,  1.637531471947109e+00, -7.068244377990574e-03, -7.399673531679545e-05,
 -2.167546457160922e-07,  6.822617654737062e-09,  1.144187418030766e-10,  2.249181022413724e-13, -1.866660383726399e-14, -2.848593535216225e-16,  1.678368062736273e-19,
  6.352999942589464e-20,  8.053441680249211e-22,  1.840629590746603e+00, -3.689863801766933e-03, -5.667056522575133e-05, -6.279064228986202e-07, -3.947913618642790e-09,
  2.259374697586128e-11,  1.101904702916099e-12,  1.729082372072019e-14,  1.273669448027493e-16, -9.884448890943085e-19, -4.772180770337152e-20, -7.796018907648840e-22,
  1.968296632521014e+00, -8.137499620580445e-04, -1.532542008027907e-05, -2.489589609406582e-07, -3.641668047649202e-09, -4.839043994586539e-11, -5.768309011854741e-13,
 -5.897956375770518e-15, -4.453839840327305e-17, -4.712898073199015e-20,  7.006648531082688e-21,  1.849105904260647e-22,  5.134051408359816e-03, -8.269713440758373e-05,
  9.967764535015985e-07, -1.065768591593217e-08,  1.064119877902602e-10, -1.016959372251674e-12,  9.387682561100047e-15, -8.467897236638698e-17,  7.422213178767590e-19,
 -6.468284681011395e-21,  5.341576082532231e-23, -4.692491935402635e-25,  4.615304783384732e-02, -7.344456111184872e-04,  8.611923854852472e-06, -8.762427630822536e-08,
  8.074373952737901e-10, -6.825659105783028e-12,  5.230044919524685e-14, -3.542943949518081e-16,  1.873839102410572e-18, -5.046069252379450e-21, -7.468619464748774e-23,
  1.262260800058155e-24,  1.278854401333875e-01, -1.984252255448650e-03,  2.192700447117334e-05, -1.989687075674143e-07,  1.482323565685896e-09, -8.127749695216538e-12,
  1.238256246923572e-14,  4.340322727906663e-16, -7.793654383416738e-18,  8.273219270282740e-20, -6.768553762772975e-22,  2.452120052709449e-24,  2.496145189409505e-01,
 -3.718600358498067e-03,  3.713240444228231e-05, -2.683660767566844e-07,  1.044111409006681e-09,  6.133396979399516e-12, -1.721980441949594e-13,  1.882832633249224e-15,
 -1.126994333582221e-17, -2.411510091602886e-20,  1.417963328124395e-21, -2.096309227545655e-23,  4.099719699754630e-01, -5.751899233163374e-03,  4.867977773419972e-05,
 -2.077173974631488e-07, -1.194412519391229e-09,  3.184848540862024e-11, -2.780508172217257e-13,  2.016850735730164e-16,  2.752879610336178e-17, -3.963909088545458e-19,
  1.911233424135516e-21,  1.897291874463987e-23,  6.064951518192440e-01, -7.809215541371075e-03,  4.986712942051812e-05,  3.996485063918455e-08, -4.460517308458022e-09,
  3.852638088711773e-11,  1.066075897754197e-13, -5.764579681144327e-15,  4.742076154070314e-17,  2.358157685682571e-19, -9.383797203168408e-21,  6.719331270223437e-23,
  8.348614580560634e-01, -9.509387672589988e-03,  3.445567403877026e-05,  4.311615760774885e-07, -5.771679171680950e-09, -1.236807726816335e-11,  8.192025004060726e-13,
 -4.135159984815626e-15, -9.081266895695457e-17,  1.296875395176446e-18,  4.174018937055622e-21, -2.514920859039194e-22,  1.087612435347801e+00, -1.036667087120384e-02,
  2.876497444070682e-07,  7.467726823238056e-07, -1.298589995371660e-09, -9.491455466572979e-11,  4.047850688330126e-13,  1.402710957246163e-14, -1.059471105344184e-16,
 -2.210090147247826e-18,  2.506436928775307e-20,  3.349449127439871e-22,  1.352153401423167e+00, -9.859776058984433e-03, -4.447313400982597e-05,  6.210532921949500e-07,
  7.722300837624427e-09, -6.320319181075750e-11, -1.519998435445168e-12,  5.727165662920942e-15,  3.106586637334161e-16, -2.523872551322933e-20, -6.518666311811981e-20,
 -2.493729082785615e-22,  1.608060923733336e+00, -7.668591866235408e-03, -7.586688298559121e-05, -8.918845252460008e-08,  9.117406360190196e-09,  1.125394928708712e-10,
 -4.205813517221800e-13, -2.713080784932845e-14, -2.253747304737141e-16,  3.315827949702038e-18,  9.008467849717969e-20,  2.831872144334446e-22,  1.824914227680618e+00,
 -4.174397137555662e-03, -6.456440717971180e-05, -6.858488270265781e-07, -3.190178813335691e-09,  5.526194223695875e-11,  1.634722308212563e-12,  2.035750134074447e-14,
  4.853771991435038e-17, -3.647232760941480e-18, -8.622174460790684e-20, -9.089146382719843e-22,  1.964776003185662e+00, -9.493726174455210e-04, -1.869706235985127e-05,
 -3.157793512130285e-07, -4.762123334257099e-09, -6.437632763651851e-11, -7.616885300200787e-13, -7.277098886285634e-15, -3.872630642080086e-17,  4.532531990185716e-19,
  1.971514727352822e-20,  4.202748975032557e-22,  4.818440229600732e-03, -7.520701770396403e-05,  8.784661415562736e-07, -9.106326548976053e-09,  8.814680046909855e-11,
 -8.176246190865890e-13,  7.316899986623977e-15, -6.427885521325540e-17,  5.432660644113461e-19, -4.699103085979802e-21,  3.610352813202942e-23, -3.223300723579575e-25,
  4.334669364170334e-02, -6.695465107416781e-04,  7.633653583677154e-06, -7.573243696579603e-08,  6.827070200530137e-10, -5.682901501837456e-12,  4.318881989361406e-14,
 -2.977211311570745e-16,  1.649541399750957e-18, -7.161474553272594e-21, -3.589142259556647e-23,  6.078893020883314e-25,  1.202846946404411e-01, -1.817995756335288e-03,
  1.967638117460814e-05, -1.765321651911627e-07,  1.323590139025745e-09, -7.710344706155093e-12,  2.145564664531358e-14,  2.272792456987995e-16, -5.275990248648405e-18,
  5.788071997938642e-20, -5.645365553923982e-22,  2.649985583305030e-24,  2.353142516535441e-01, -3.434130746451746e-03,  3.401561408990417e-05, -2.508863123264274e-07,
  1.129509353477686e-09,  2.592070282130775e-12, -1.245899999839887e-13,  1.517564904684717e-15, -1.132144408299638e-17,  1.613613199079663e-20,  6.441832058736041e-22,
 -1.412431796042710e-23,  3.877270651865595e-01, -5.372710256286027e-03,  4.609236007639700e-05, -2.220912708354244e-07, -6.232570525508885e-10,  2.532995046371914e-11,
 -2.621034740668471e-13,  8.702458658768778e-16,  1.477214372350944e-17, -3.100664284689611e-19,  2.260992215713572e-21, -7.417478075714694e-25,  5.760575662421015e-01,
 -7.409514250258722e-03,  4.994423333679141e-05, -2.515190664339861e-08, -3.676567402457399e-09,  3.932494140329942e-11, -3.276126418271092e-14, -4.177626543534793e-15,
  4.991200491733742e-17, -7.584983042065800e-20, -6.142442582988317e-21,  7.545464810715593e-23,  7.974057337976246e-01, -9.214628498052300e-03,  3.907070856655259e-05,
  3.378593420687205e-07, -5.833322174242548e-09,  5.618767242680419e-12,  6.698628146528004e-13, -6.282380047138264e-15, -4.359779466247888e-17,  1.264150197904994e-18,
 -5.169360925066339e-21, -1.643521769766580e-22,  1.046206425206777e+00, -1.032901800982603e-02,  9.063669871701623e-06,  7.114625304015837e-07, -3.070183883859332e-09,
 -8.093569120702646e-11,  7.396392613666335e-13,  9.580783574026399e-15, -1.647283983818993e-16, -1.003165129414249e-18,  3.297115734383538e-20,  2.099149304270506e-23,
  1.312052750003211e+00, -1.018375870130345e-02, -3.632709096178034e-05,  7.325900595887266e-07,  6.112162001502248e-09, -9.665463302915360e-11, -1.224254084645214e-12,
  1.514073993628687e-14,  2.619686100917806e-16, -2.653047169619294e-18, -6.110796679799504e-20,  4.433421443528015e-22,  1.576169628315231e+00, -8.277161880640789e-03,
 -7.599011131704009e-05,  7.387664207393169e-08,  1.120207183469089e-08,  9.265007769695907e-11, -1.258253638664541e-12, -3.173090035585697e-14, -4.090982713491280e-17,
  6.855427143622015e-18,  7.807782685417300e-20, -9.182134158710395e-22,  1.807130388447936e+00, -4.724602050965154e-03, -7.305693907116102e-05, -7.257229405995372e-07,
 -1.646136275811167e-09,  1.013639229654665e-10,  2.201559153838770e-12,  1.907033527821622e-14, -1.537519206601801e-16, -7.802536469918808e-18, -1.174340341155642e-19,
 -3.313233263557004e-22,  1.960653394262627e+00, -1.115506481093266e-03, -2.298947897581544e-05, -4.033383218115221e-07, -6.249596290909392e-09, -8.522046074057702e-11,
 -9.790175896669701e-13, -8.060398165803929e-15, -2.748095432146965e-18,  1.726248284619760e-18,  4.724800225749096e-20,  8.769573407606041e-22,  4.531007820628385e-03,
 -6.859360001798488e-05,  7.771419990277102e-07, -7.817834944042846e-09,  7.341410310533161e-11, -6.617992505165372e-13,  5.736882768387619e-15, -4.934746094078440e-17,
  3.970727781551432e-19, -3.494062474926743e-21,  2.537362471469156e-23, -1.521272186329869e-25,  4.078514160608704e-02, -6.119350284982829e-04,  6.786828435770439e-06,
 -6.566480079487184e-08,  5.787688589430339e-10, -4.740686264931619e-12,  3.555117998698528e-14, -2.492876986842517e-16,  1.372103974759746e-18, -8.070858868446944e-21,
 -7.604651644714679e-24,  8.928244591289328e-25,  1.133146103169302e-01, -1.668709762872285e-03,  1.768006678334275e-05, -1.565585563195261e-07,  1.174957093205928e-09,
 -7.136345969635971e-12,  2.573937604522315e-14,  8.766861792602806e-17, -3.568659161502530e-18,  3.788206811876902e-20, -4.247366911099492e-22,  4.164612744466935e-24,
  2.221033488138434e-01, -3.173738196996267e-03,  3.111463345811923e-05, -2.325481776981190e-07,  1.154682256669526e-09,  7.156068879533539e-14, -8.705377946915199e-14,
  1.168467381804826e-15, -1.040541093795037e-17,  3.184305086538384e-20,  2.070689467442285e-22, -4.983894436174916e-24,  3.669566316736785e-01, -5.014764957015093e-03,
  4.338306746586214e-05, -2.283432547712359e-07, -1.773546073203318e-10,  1.937559094415512e-11, -2.326735148077435e-13,  1.181582770838089e-15,  5.206288169818764e-18,
 -2.226024158695887e-19,  2.088462698290653e-21, -3.892767307574294e-24,  5.472153718599788e-01, -7.012108389482510e-03,  4.931517511066305e-05, -7.776428676901057e-08,
 -2.906489746879701e-09,  3.731141110844324e-11, -1.280856317161315e-13, -2.665148091935389e-15,  4.354488616196898e-17, -2.567284442237832e-19, -2.941059744260773e-21,
  7.055448573878471e-23,  7.611958064919288e-01, -8.887418335756347e-03,  4.257139052671870e-05,  2.462365685820978e-07, -5.575070722560537e-09,  1.946725597497066e-11,
  4.809093279388501e-13, -7.001402463973447e-15, -3.245809010960334e-18,  9.467748630319491e-19, -9.824251791025896e-21, -4.447224989035107e-23,  1.005088110284341e+00,
 -1.022330988734715e-02,  1.725641192846564e-05,  6.504345214665586e-07, -4.492842107167911e-09, -6.058518303730815e-11,  9.304737540324771e-13,  3.982918493307573e-15,
 -1.776416437172878e-16,  2.525707622746411e-19,  2.807018801729089e-20, -2.162494694269198e-22,  1.270794299845965e+00, -1.043770510457744e-02, -2.701777391831616e-05,
  8.134833785928622e-07,  3.924050973151369e-09, -1.201061242977819e-10, -7.003959776671053e-13,  2.157330216695931e-14,  1.288609772725066e-16, -4.524849282229914e-18,
 -2.853557562755180e-20,  9.805655433620677e-22,  1.541855225645738e+00, -8.878361060415178e-03, -7.397318355348226e-05,  2.659914149274696e-07,  1.268140082982931e-08,
  5.188964875808671e-11, -2.124227865303176e-12, -2.859245743333897e-14,  2.485925901965239e-16,  8.759817486931116e-18,  7.590417910244623e-21, -2.207640710532725e-21,
  1.787007509823496e+00, -5.344166440799901e-03, -8.184697978854879e-05, -7.328041578143334e-07,  9.486742089723209e-10,  1.597608043648532e-10,  2.617915822800201e-12,
  8.746810779374934e-15, -5.186262085004914e-16, -1.231859727675630e-17, -9.350632595540724e-20,  1.715530261140775e-21,  1.955790301425445e+00, -1.320620650574585e-03,
 -2.849008915950834e-05, -5.183198092774590e-07, -8.207004269515116e-09, -1.113625708005199e-10, -1.193503034855993e-12, -6.702121626012930e-15,  1.045176096743933e-16,
  4.590641974495278e-18,  1.015871153296728e-19,  1.647012470817771e-21,  4.268500460354278e-03, -6.273271103143295e-05,  6.899619541297935e-07, -6.742061656937702e-09,
  6.145000189488793e-11, -5.393684644602204e-13,  4.515474489355644e-15, -3.846655413456274e-17,  2.886203944105150e-19, -2.536156008487825e-21,  2.472801382175122e-23,
  1.510770262534279e-25,  3.844121333456600e-02, -5.606418024059220e-04,  6.051427674838965e-06, -5.711893751182801e-08,  4.919465346316882e-10, -3.966525338910457e-12,
  2.914228573840980e-14, -2.099876087382471e-16,  1.089270754141854e-18, -7.153088866381194e-21,  6.775024167920646e-23,  2.850323172508748e-24,  1.069111910446633e-01,
 -1.534475076907992e-03,  1.590956047783985e-05, -1.388668765292677e-07,  1.038544717881026e-09, -6.500895566079408e-12,  2.677939100231940e-14, -7.558582398108845e-18,
 -2.455435509275902e-18,  2.584938801168866e-20, -1.358269954008607e-22,  9.809936113086414e-24,  2.098889991761616e-01, -2.935669944508592e-03,  2.843461313250255e-05,
 -2.141648690646231e-07,  1.137680872118665e-09, -1.661640940528466e-12, -5.881592853718527e-14,  8.552408797566229e-16, -9.126279952380232e-18,  3.987814402520355e-20,
  3.131765075869518e-22,  1.129952434649882e-23,  3.475743151484967e-01, -4.678681597372582e-03,  4.063775879846015e-05, -2.283727420459027e-07,  1.570633533727668e-10,
  1.420043120508248e-11, -1.983475658259096e-13,  1.235951106850302e-15, -1.312837358738253e-18, -1.386199659053779e-19,  2.249451853106391e-21,  1.513573877315612e-23,
  5.199490281907341e-01, -6.622054726231071e-03,  4.812700239250148e-05, -1.184879760994698e-07, -2.196271574037220e-09,  3.349012406829042e-11, -1.847175466478118e-13,
 -1.436160982751208e-15,  3.294444316516961e-17, -3.106717760637838e-19,  3.341997984931330e-22,  8.315829478592858e-23,  7.263438922910745e-01, -8.536510941447466e-03,
  4.500572050704797e-05,  1.607108154607374e-07, -5.086123618746719e-09,  2.867360079715893e-11,  2.879881417477428e-13, -6.637322812177015e-15,  2.363988942977782e-17,
  5.529180933464488e-19, -8.902728916012318e-21,  8.805059444153237e-23,  9.645185697897549e-01, -1.005534385253864e-02,  2.459433360864843e-05,  5.700952967330853e-07,
 -5.475456297295042e-09, -3.754225171002828e-11,  9.652069916072633e-13, -1.359806778487793e-15, -1.508793490339345e-16,  1.161398890522133e-18,  1.723451426443131e-20,
 -2.349681901237631e-22,  1.228674279725707e+00, -1.061392020015108e-02, -1.696091598135727e-05,  8.563496712090967e-07,  1.404509464881868e-09, -1.293572466754890e-10,
 -6.416038720824023e-14,  2.295928783515989e-14, -4.351204706654959e-17, -4.736333031484823e-18,  1.880738870684877e-20,  1.098134372598812e-21,  1.505183375235285e+00,
 -9.453869996877629e-03, -6.953929436852143e-05,  4.741738644142814e-07,  1.315040537445776e-08, -7.511440433502357e-12, -2.766784337472326e-12, -1.573539254661699e-14,
  5.442856810426103e-16,  6.955613813442993e-18, -9.879229850084456e-20, -2.326996623955119e-21,  1.764266311976580e+00, -6.033593566436182e-03, -9.043292234673682e-05,
 -6.886058149149151e-07,  4.780517739741337e-09,  2.232234857071735e-10,  2.559802354433774e-12, -1.546137732469734e-14, -1.002338422920738e-15, -1.355170254020468e-17,
  5.901682091811740e-20,  5.414383813182004e-21,  1.950009197349420e+00, -1.575832683751536e-03, -3.557649302173223e-05, -6.690609608140785e-07, -1.073318127916563e-08,
 -1.416960588655559e-10, -1.302998883837052e-12,  2.295412122779706e-16,  3.629666708195659e-16,  1.038777647604692e-17,  1.953588813342305e-19,  2.606869209817397e-21,
  4.028119172774010e-03, -5.752070328774121e-05,  6.146185469981676e-07, -5.839620837277425e-09,  5.166416635958233e-11, -4.429552712961303e-13,  3.555458802742237e-15,
 -3.048042339757837e-17,  2.178269448730294e-19, -1.292186387833100e-21,  4.055470694864705e-23,  5.678658930683764e-25,  3.629130918627756e-02, -5.148440724223487e-04,
  5.410727184527100e-06, -4.984636649862998e-08,  4.191533617182676e-10, -3.333939673943585e-12,  2.371733291323525e-14, -1.784275173897594e-16,  9.192520229564247e-19,
 -9.910865695132590e-22,  2.647631215249075e-22,  6.139798897020825e-24,  1.010176758800636e-01, -1.413591374450059e-03,  1.433868021996098e-05, -1.232556048782764e-07,
  9.148944181858056e-10, -5.868762618619821e-12,  2.560578450082107e-14, -7.129227341711771e-17, -1.494785492292722e-18,  3.169882431751674e-20,  4.966921707981226e-22,
  1.902540264288276e-23,  1.985854296365306e-01, -2.718166489876215e-03,  2.597252780245716e-05, -1.962969673839306e-07,  1.092107406768603e-09, -2.817418838781859e-12,
 -3.871718257689786e-14,  5.899451352135361e-16, -7.286414636571344e-18,  6.886969247330945e-20,  1.301474223358750e-21,  3.361228726866022e-23,  3.294925232952085e-01,
 -4.364478735232670e-03,  3.792093026830717e-05, -2.238346764085818e-07,  3.962299936387682e-10,  9.846674784881707e-12, -1.649450643596753e-13,  1.133354446179413e-15,
 -4.432107201398367e-18, -2.517570781912831e-20,  3.689689912491813e-21,  5.112643429904187e-23,  4.942210579395892e-01, -6.243274235377584e-03,  4.651559536088797e-05,
 -1.485224321014168e-07, -1.573485767693685e-09,  2.868342556734838e-11, -2.117896701230821e-13, -5.505740616844613e-16,  2.297191385310303e-17, -2.140523137286841e-19,
  4.774695654083984e-21,  1.203716574506033e-22,  6.929282611650203e-01, -8.170088766875224e-03,  4.646595498447510e-05,  8.423471402950931e-08, -4.458076281934257e-09,
  3.345682470389874e-11,  1.152918735160891e-13, -5.621114601390842e-15,  3.843310979464387e-17,  3.141104531815357e-19, -2.087917059681842e-21,  2.170517748391532e-22,
  9.247318633270546e-01, -9.832762922811329e-03,  3.088907467989985e-05,  4.777176424261578e-07, -6.000375553267279e-09, -1.533682587681027e-11,  8.666673551756249e-13,
 -5.403648051957482e-15, -9.875517946918986e-17,  1.690089339733263e-18,  1.063742523332766e-20, -4.125917961370290e-23,  1.186012587560876e+00, -1.070831681694592e-02,
 -6.634947677769442e-06,  8.582547912705324e-07, -1.147417699022924e-09, -1.234901794173029e-10,  5.351430391988825e-13,  1.907576355624141e-14, -1.892728144575892e-16,
 -3.070131475230633e-18,  6.268292829710086e-20,  8.509397991915761e-22,  1.466296308202455e+00, -9.983882544188515e-03, -6.260373174055545e-05,  6.796588998076935e-07,
  1.231149969906750e-08, -7.703369275202198e-11, -2.932384691877531e-12,  4.747273935040515e-15,  7.024118300471383e-16,  1.373472114365606e-18, -1.663248600208936e-19,
 -4.229795588069881e-22,  1.738634986059586e+00, -6.788449752063646e-03, -9.807969356006094e-05, -5.732817044968441e-07,  9.803729317908645e-09,  2.754176115331855e-10,
  1.610787216509804e-12, -5.435058159240215e-14, -1.379801260243768e-15, -5.299183665795932e-18,  3.776636518085622e-19,  8.623646556587616e-21,  1.943081374834224e+00,
 -1.895705272483803e-03, -4.473455959395671e-05, -8.651315426314296e-07, -1.387083719540408e-08, -1.711731661823559e-10, -1.065630213822318e-12,  1.957248204308553e-14,
  9.069645111135653e-16,  2.066687328330745e-17,  3.199392347764930e-19,  2.740147661230053e-21,  3.807445432802896e-03, -5.287064861347993e-05,  5.492247649968469e-07,
 -5.079507133602571e-09,  4.359317477202332e-11, -3.671084944079702e-13,  2.795142740651762e-15, -2.388690950826027e-17,  2.073061781711238e-19,  9.069935727027037e-22,
  7.018016824645317e-23,  6.582351836949930e-25,  3.431487072448159e-02, -4.738417456680119e-04,  4.850704794536734e-06, -4.364405407929209e-08,  3.577794043898986e-10,
 -2.821297282426781e-12,  1.914567458261819e-14, -1.469672310603908e-16,  1.145417926092958e-18,  1.560228988919973e-20,  5.696761987238305e-22,  6.646300041797180e-24,
  9.558370166701548e-02, -1.304558057742276e-03,  1.294367554534670e-05, -1.095236670236720e-07,  8.034800399368918e-10, -5.282348746364685e-12,  2.314891702127719e-14,
 -9.527670842633714e-17,  2.226323688961508e-19,  6.996191621849916e-20,  1.428670615534688e-21,  2.027853529292568e-23,  1.881138188941311e-01, -2.519516053092564e-03,
  2.371979774391914e-05, -1.793193473717273e-07,  1.027680010386258e-09, -3.572029925416237e-12, -2.500044283607158e-14,  4.096800474273204e-16, -3.471667355126730e-18,
  1.546887536850098e-19,  3.032785799225504e-21,  3.869649645556378e-23,  3.126245019918381e-01, -4.071733961072697e-03,  3.527878309343960e-05, -2.161241155059126e-07,
  5.560648297534393e-10,  6.253073549747286e-12, -1.351018467756654e-13,  1.010415559777941e-15, -2.066681976048202e-18,  1.747173866711447e-19,  6.385418325033581e-21,
  6.062575832716530e-23,  4.699803737970195e-01, -5.878664753059395e-03,  4.460029711041219e-05, -1.693888531749170e-07, -1.051490739441282e-09,  2.349301107015624e-11,
 -2.177474190860767e-13,  1.089497961118800e-16,  2.005007798707835e-17,  8.947866800201734e-20,  1.041419297245439e-20,  1.195729818964148e-22,  6.609961192808002e-01,
 -7.795478881411407e-03,  4.707122481735697e-05,  1.835804538888156e-08, -3.773256370219059e-09,  3.448447388067436e-11, -2.318030675729488e-14, -4.206239168143437e-15,
  5.075977099595781e-17,  4.436512095016492e-19,  8.811908409571832e-21,  2.472883607605431e-22,  8.859290174019496e-01, -9.564368229156961e-03,  3.603903443724592e-05,
  3.803307569419469e-07, -6.112963714216828e-09,  3.349610745376637e-12,  6.808550371786697e-13, -7.507627280876731e-15, -3.007293480607451e-17,  2.145140243243083e-18,
  1.344259359751849e-20,  1.335294059993481e-22,  1.143137707157848e+00, -1.072069458974237e-02,  3.475178715437815e-06,  8.210036693285248e-07, -3.449425153282753e-09,
 -1.050048422693904e-10,  9.716936126227652e-13,  1.180051678225567e-14, -2.467688852264059e-16,  5.866878324610442e-20,  9.011813420703786e-20,  3.471506144745290e-22,
  1.425415314835363e+00, -1.044888156676460e-02, -5.332891574760956e-05,  8.605846981047495e-07,  1.009097350654522e-08, -1.432761060927557e-10, -2.486463083262801e-12,
  2.674607165385870e-14,  6.353903597736673e-16, -4.795880273828070e-18, -1.210573207778450e-19,  2.418485453119150e-21,  1.709872672733135e+00, -7.597508864327500e-03,
 -1.038309688492846e-04, -3.708630201937795e-07,  1.554930891186251e-08,  2.907718211591325e-10, -5.327493000166388e-13, -9.789673014183580e-14, -1.207564521476660e-15,
  1.723910546020681e-17,  7.296209699315562e-19,  5.828820993614077e-21,  1.934711371440588e+00, -2.299148944135561e-03, -5.656454178577734e-05, -1.115587178901338e-06,
 -1.748545597605235e-08, -1.861113189755189e-10,  1.938422524071090e-14,  6.317065379158559e-14,  1.904641970899542e-15,  3.515834307822360e-17,  3.749690349721482e-19,
 -1.463439773102280e-21,  3.604380424661111e-03, -4.870934488910341e-05,  4.922245516139237e-07, -4.437322160565875e-09,  3.687174034721919e-11, -3.072506893885629e-13,
  2.228231585420213e-15, -1.614307449329286e-17,  2.956858080964430e-19,  4.074393830554089e-21,  7.968482804357664e-23, -5.247829689546621e-25,  3.249393000006966e-02,
 -4.370378386947343e-04,  4.359538157813681e-06, -3.834734153474628e-08,  3.056393202561261e-10, -2.406351588280353e-12,  1.566236804677600e-14, -9.645981353802179e-17,
  2.170895969184676e-18,  4.217598729186369e-20,  6.800265894225199e-22, -4.338121130994930e-24,  9.056454263834676e-02, -1.206055080206241e-03,  1.170313468572678e-05,
 -9.748383456097885e-08,  7.031883147933518e-10, -4.755222915397643e-12,  2.104690349684209e-14, -3.537610366010357e-17,  3.936406963854800e-18,  1.390202252348206e-19,
  1.797684577590871e-21, -1.122889197774453e-23,  1.784020304020505e-01, -2.338091093439732e-03,  2.166416998927113e-05, -1.634768435609131e-07,  9.511287039060033e-10,
 -4.040886053473213e-12, -1.406396835364556e-14,  4.138604389628967e-16,  4.597158825190448e-18,  2.984946222121631e-19,  3.707183049327645e-21, -2.395178933805735e-23,
  2.968858259204554e-01, -3.799717996622232e-03,  3.274225844775141e-05, -2.063931819090998e-07,  6.509863095138687e-10,  3.350343005480548e-12, -1.064133254137031e-13,
  1.098464721015352e-15,  9.303928366055162e-18,  4.637862883279867e-19,  7.293670076134038e-21, -4.715631108250734e-23,  4.471660869822987e-01, -5.530245171317605e-03,
  4.248127950116529e-05, -1.827353561227974e-07, -6.332442702681372e-10,  1.838225677110397e-11, -2.046056332008398e-13,  8.910045235436540e-16,  3.174765074854268e-17,
  5.760030210413753e-19,  1.258447583418724e-20, -6.510805475907019e-23,  6.305673582671645e-01, -7.419002187060525e-03,  4.695184959440210e-05, -3.656329222331383e-08,
 -3.097648259736502e-09,  3.271607133464531e-11, -1.152172215696488e-13, -2.239639977920575e-15,  7.527492926926022e-17,  9.615955010605725e-19,  1.504654482566694e-20,
 -3.620084028187140e-23,  8.482747403362233e-01, -9.259452303336335e-03,  4.002104775269005e-05,  2.838746336034853e-07, -5.899838399719577e-09,  1.713416144194327e-11,
  4.695801340343663e-13, -7.120250740370887e-15,  5.801977116001792e-17,  2.766555200128438e-18,  1.561453710910092e-20, -1.496126947820886e-22,  1.100371403901587e+00,
 -1.065457410931890e-02,  1.293114803526292e-05,  7.503757411614427e-07, -5.294063032212099e-09, -7.858421842808289e-11,  1.196940312579229e-12,  4.649639625663260e-15,
 -1.782207551602309e-16,  3.725630833848286e-18,  8.596711393112313e-20, -6.583306413164496e-22,  1.382835493358139e+00, -1.083169750341034e-02, -4.213744077318203e-05,
  9.961673821365590e-07,  6.700454391403954e-09, -1.918541048113759e-10, -1.484161053175738e-12,  4.362313430341901e-14,  4.060424773960173e-16, -7.027303747851193e-18,
  1.515745833092445e-20,  3.153119489021144e-21,  1.677799698156362e+00, -8.441296082595865e-03, -1.066016478036911e-04, -7.724642839101428e-08,  2.099548659241166e-08,
  2.415100967840280e-10, -3.679333814112316e-12, -1.206520151120958e-13, -2.778441147801406e-17,  4.831490831972416e-17,  7.231881811189668e-19, -7.961473633993651e-21,
  1.924517875497932e+00, -2.810248688016576e-03, -7.175096716956680e-05, -1.424365768832046e-06, -2.101884528696652e-08, -1.562671124302447e-10,  2.850697172008727e-12,
  1.469440936914678e-13,  3.393809314459552e-15,  4.523551757684015e-17,  8.307096057955178e-21, -1.821928159181477e-20,  3.417094967414338e-03, -4.497495964819617e-05,
  4.423226299463952e-07, -3.893761319740457e-09,  3.123106472995303e-11, -2.579724009515926e-13,  1.934651131818117e-15, -3.809153781783019e-18,  4.871620458267338e-19,
  5.999282092662340e-21, -7.101735341638999e-24, -3.761641435899228e-24,  3.081272956338099e-02, -4.039226008113123e-04,  3.927187273507941e-06, -3.382246231612691e-08,
  2.610996415927512e-10, -2.053441267564097e-12,  1.419559051350714e-14,  1.766885052126035e-18,  4.068540046667655e-18,  5.821666876241100e-20, -9.468705447758085e-23,
 -3.398276368710645e-23,  8.592042441998080e-02, -1.116925009599207e-03,  1.059778503895430e-05, -8.696622895549583e-08,  6.131497365900408e-10, -4.242674007716099e-12,
  2.265992443941702e-14,  1.823984334459883e-16,  9.932461755485766e-18,  1.800461596848352e-19, -3.659145117411965e-22, -9.598322041761559e-23,  1.693842255192496e-01,
 -2.172372155059428e-03,  1.979104161292787e-05, -1.489192899361566e-07,  8.680057509196174e-10, -4.211882209625386e-12,  1.379701981499785e-15,  7.570751561351156e-16,
  1.738550983278057e-17,  3.831354192537241e-19, -7.338708030665966e-22, -1.961454453028788e-22,  2.821953998115873e-01, -3.547505487387926e-03,  3.032982718608414e-05,
 -1.955688303346204e-07,  6.951914217080210e-10,  1.216416272330042e-12, -6.862019558955371e-14,  1.711434734192228e-15,  3.010385444547659e-17,  6.400043250174755e-19,
 -6.757413331209330e-22, -3.471543509625320e-22,  4.257107104331104e-01, -5.199312215778972e-03,  4.023896056258809e-05, -1.901820837911858e-07, -3.119972321804890e-10,
  1.390827111258515e-11, -1.616900309992784e-13,  2.323417723933698e-15,  5.978640061877520e-17,  9.001868309559800e-19,  2.937052496927435e-23, -5.569938172004570e-22,
  6.016386750350993e-01, -7.045936320771455e-03,  4.623677628833789e-05, -8.105731196808921e-08, -2.474501677162056e-09,  2.950640253548569e-11, -1.382417498909089e-13,
  8.252915036427637e-16,  1.186568335621571e-16,  1.339148864927918e-18, -1.852268572304756e-21, -8.136153965526408e-22,  8.118966157821799e-01, -8.927232989724752e-03,
  4.287427744670992e-05,  1.927682239602897e-07, -5.459115943207716e-09,  2.631724255317822e-11,  3.118944039962197e-13, -3.576783797469375e-15,  1.650131847545340e-16,
  2.999215065413296e-18, -1.195053142869801e-20, -1.239397943797857e-21,  1.058014856979111e+00, -1.051665600327723e-02,  2.138071411232449e-05,  6.546925437408671e-07,
 -6.570660605958835e-09, -4.879406989978353e-11,  1.271717980888784e-12,  1.671515259859873e-15,  6.470224979012256e-18,  6.093604806933892e-18,  1.852625858433349e-20,
 -2.562164698797671e-21,  1.338912388302779e+00, -1.111946050476200e-02, -2.967188941395038e-05,  1.071181453865509e-06,  2.612742103440937e-09, -2.115718586539070e-10,
 -1.166134856234622e-13,  5.291840886428296e-14,  1.911128607316799e-16, -4.405235878988983e-18,  8.872867405597123e-20, -5.578346630659985e-22,  1.642331516848001e+00,
 -9.291776029972226e-03, -1.053722772818059e-04,  2.913970718748436e-07,  2.467596415451314e-08,  1.143499699531447e-10, -6.774417810043354e-12, -8.915999864794665e-14,
  2.095010826229366e-15,  6.442057846693309e-17, -6.142151622099522e-20, -2.732610829641721e-20,  1.912012269111585e+00, -3.458548575179333e-03, -9.094786528215976e-05,
 -1.780314106345709e-06, -2.305708750628584e-08, -2.474685461506675e-11,  8.719083313814022e-12,  2.795458673217842e-13,  4.748975171190559e-15,  1.971714598791071e-17,
 -1.572736852857295e-18, -5.772059435759684e-20,  3.243987861382866e-03, -4.161516007274330e-05,  3.984335691168018e-07, -3.432819189869746e-09,  2.653720767950844e-11,
 -2.108708967570938e-13,  2.076069582883518e-15,  1.478033092890786e-17,  6.464255016318293e-19,  1.115139584776993e-21, -2.690169775521412e-22, -8.068244918755127e-24,
  2.925739994951576e-02, -3.740605614354766e-04,  3.545088717737963e-06, -2.995460221517731e-08,  2.235256498240707e-10, -1.695616496438380e-12,  1.635724939657231e-14,
  1.611359305453789e-16,  5.628773589994029e-18,  1.273373990069545e-20, -2.471131485662499e-21, -7.334756473004156e-23,  8.161590671174905e-02, -1.036156576935000e-03,
  9.610354678809683e-06, -7.780265602701430e-08,  5.343582165539141e-10, -3.595987463837022e-12,  3.311342468536198e-14,  5.908538356965591e-16,  1.482695392765530e-17,
  4.724750288799703e-20, -7.107704782065844e-21, -2.085063193937580e-22,  1.610004006368417e-01, -2.020962199954020e-03,  1.808458743215959e-05, -1.356948041384395e-07,
  7.861929614302305e-10, -3.849477072306707e-12,  3.228185474510164e-14,  1.507465105508245e-15,  2.794645314853776e-17,  1.124691950715756e-19, -1.450032971790876e-20,
 -4.257158457636391e-22,  2.684760606339658e-01, -3.314063724319243e-03,  2.805030239259216e-05, -1.843221063432373e-07,  7.075819117068271e-10,  2.736609005657755e-13,
 -3.995013543081611e-15,  3.001168054613814e-15,  4.788664830310942e-17,  1.874240680415014e-19, -2.492725297522579e-20, -7.485579282053464e-22,  4.055427375945212e-01,
 -4.886594236898836e-03,  3.793539091953761e-05, -1.931331787891721e-07, -6.612796675129449e-11,  1.105311762230377e-11, -6.531126392235045e-14,  4.695745489377738e-15,
  8.453222889137998e-17,  2.155878987569924e-19, -3.910235608124744e-20, -1.210798166456136e-21,  5.741876653508968e-01, -6.680562175065524e-03,  4.504546793117941e-05,
 -1.160924560433884e-07, -1.913281827775953e-09,  2.693692405342151e-11, -5.532553445597947e-14,  5.290938927263248e-15,  1.540968660830329e-16,  2.397029986935535e-19,
 -6.078289806607571e-20, -1.848370001080244e-21,  7.768862822659641e-01, -8.576428251537246e-03,  4.468204330629746e-05,  1.100177431524308e-07, -4.862543427061379e-09,
  3.329092456028333e-11,  3.004935083985470e-13,  3.205088504830455e-15,  2.470855725217767e-16,  9.722123869137156e-19, -1.008489266119479e-19, -2.784445178622563e-21,
  1.016337473788827e+00, -1.031603557120007e-02,  2.857945903778473e-05,  5.434321745187818e-07, -7.236558857193370e-09, -1.748623920591646e-11,  1.353932949424854e-12,
  5.268766632762336e-15,  2.055779397080450e-16,  3.873525881878367e-18, -1.467530465057422e-19, -4.887272438941631e-21,  1.294041787004894e+00, -1.130502827582246e-02,
 -1.670561593607645e-05,  1.079496323614501e-06, -1.523634113331115e-09, -1.960241692942364e-10,  1.430949578850243e-12,  5.702398236655160e-14,  7.368934519854413e-17,
 -3.210944243512696e-18, -7.672887096057243e-20, -7.000386741481671e-21,  1.603510230529754e+00, -1.011394247443449e-02, -9.946169652953814e-05,  6.949889266947819e-07,
  2.518287045019635e-08, -6.855513187076164e-11, -8.001883575890120e-12,  1.192536648080563e-14,  4.046077060178010e-15,  3.447491401466993e-17, -1.480548331138498e-18,
 -3.318208721165048e-20,  1.896578812248277e+00, -4.277807369112573e-03, -1.144965955171949e-04, -2.138844041817656e-06, -2.073592897152061e-08,  2.956927182701406e-10,
  1.866077908928819e-11,  4.248452810507953e-13,  3.575400234223274e-15, -1.091307873583347e-16, -5.218149976441694e-18, -1.037962410886624e-19,  3.083651054851501e-03,
 -3.858555078733791e-05,  3.596573902983988e-07, -3.039073650070333e-09,  2.286347731052229e-11, -1.537968966874516e-13,  2.766468983683896e-15,  3.328733273930941e-17,
  4.002656481299058e-19, -1.742749603807844e-20, -6.618756783867868e-22, -8.398139805287914e-24,  2.781568519493770e-02, -3.470793032837110e-04,  3.206047008519138e-06,
 -2.662626297677013e-08,  1.940084897007545e-10, -1.228970990712870e-12,  2.328475339479842e-14,  3.227463386060511e-16,  3.465579972598209e-18, -1.569054814623244e-19,
 -6.045999342119671e-21, -7.647848862390349e-23,  7.761933145630766e-02, -9.628680750785464e-04,  8.725805404032933e-06, -6.977851597078516e-08,  4.720008482888707e-10,
 -2.549984415638137e-12,  5.605367905219720e-14,  1.018409855931253e-15,  9.014042047911593e-18, -4.384801645458430e-19, -1.728262271154428e-20, -2.179472104477183e-22,
  1.531958870547725e-01, -1.882590505665129e-03,  1.652936361030031e-05, -1.236733673284511e-07,  7.208904797564372e-10, -2.468370984243989e-12,  8.659557841758548e-14,
  2.315281987803000e-15,  1.666140517544423e-17, -8.789354330135976e-19, -3.528861415697663e-20, -4.459154620963238e-22,  2.556548745001733e-01, -3.098315767350651e-03,
  2.590661429991546e-05, -1.729305340565060e-07,  7.197938664130204e-10,  1.356997685478335e-12,  1.007361140987776e-13,  4.379950168491082e-15,  2.808268075949147e-17,
 -1.532984057449776e-18, -6.148804940412932e-20, -7.856506295331411e-22,  3.865886451374693e-01, -4.592382997299790e-03,  3.561859900226964e-05, -1.924577261022955e-07,
  1.514717355937878e-10,  1.136273346130163e-11,  1.024118283044305e-13,  7.111216104464350e-15,  5.020983120796473e-17, -2.520039418698655e-18, -9.836863435195951e-20,
 -1.278034195658085e-21,  5.481766401548936e-01, -6.326250516211033e-03,  4.348638966707066e-05, -1.424069027356977e-07, -1.372982533603651e-09,  2.793109710184323e-11,
  1.588238155486695e-13,  9.719511690024612e-15,  9.761123349764697e-17, -3.989299815043003e-18, -1.519191152395133e-19, -1.978096017214247e-21,  7.433020462693386e-01,
 -8.214960300006168e-03,  4.555881567503575e-05,  3.798211797484546e-08, -4.112704162999287e-09,  4.247134335979137e-11,  4.991578706285803e-13,  1.063496247818187e-14,
  1.772820883872291e-16, -5.773040115922972e-18, -2.383955545455471e-19, -2.992535479036918e-21,  9.755691046353202e-01, -1.006329829947514e-02,  3.440028545900542e-05,
  4.266796622590333e-07, -7.245184139899503e-09,  1.759924739503944e-11,  1.603875889432516e-12,  1.249928681344384e-14,  1.839243469743646e-16, -6.643909331196306e-18,
 -3.806392658054564e-19, -5.000472475412887e-21,  1.248635466433036e+00, -1.138755493308678e-02, -4.019769349804115e-06,  1.026166225553213e-06, -4.970565608405837e-09,
 -1.423994870489399e-10,  3.035092949545110e-12,  5.624833030220904e-14, -1.844363799517182e-16, -1.377565968007242e-17, -4.707910242220728e-19, -9.471383945163624e-21,
  1.561525342090564e+00, -1.086959716323541e-02, -8.878235340192837e-05,  1.076898465960171e-06,  2.199713673335767e-08, -2.412915397834479e-10, -5.765719849292106e-12,
  1.471994886860847e-13,  3.906507174960329e-15, -4.943359696285144e-17, -2.549348483013401e-18, -1.056929726006411e-20,  1.877465939578597e+00, -5.301456458175447e-03,
 -1.418679152115769e-04, -2.394759685991383e-06, -9.334490258111799e-09,  8.939348221375720e-10,  3.122841743955338e-11,  4.271923541962011e-13, -5.195134460358280e-15,
 -4.048627100330412e-16, -9.100004121341961e-18, -3.488569570220035e-20,  2.934840903246843e-03, -3.584815702069438e-05,  3.252944884235083e-07, -2.693924450410454e-09,
  2.053129150957200e-11, -7.554765510483952e-14,  3.743555222498206e-15,  3.036576809141731e-17, -7.696773004479798e-19, -4.847006374780837e-20, -7.816074232960711e-22,
  6.759514184131703e-24,  2.647671344220603e-02, -3.226578724125823e-04,  2.904452658626006e-06, -2.368518556005836e-08,  1.757854745171558e-10, -5.561920884980269e-13,
  3.266012237794561e-14,  2.912888066956457e-16, -7.137501300019258e-18, -4.403728217293076e-19, -7.138638613163588e-21,  6.147065020616582e-23,  7.390234567219515e-02,
 -8.962859677580201e-04,  7.932356468940516e-06, -6.255136114648796e-08,  4.368516611097329e-10, -8.496747112566698e-13,  8.519142344476093e-14,  9.057444060858104e-16,
 -2.093078310881602e-17, -1.248672874391053e-18, -2.041653456236043e-20,  1.742120713550464e-22,  1.459208686102215e-01, -1.756098742272066e-03,  1.511328715471447e-05,
 -1.123984897637478e-07,  6.977061773961039e-10,  4.083021792872323e-13,  1.520007324435284e-13,  2.038739787978845e-15, -4.390861820868390e-17, -2.534842120948974e-18,
 -4.179335986601148e-20,  3.514069178551251e-22,  2.436632549922658e-01, -2.899164606961927e-03,  2.390198577528256e-05, -1.610226601748327e-07,  7.812860420661064e-10,
  5.278451451427919e-12,  2.239429346928613e-13,  3.866092299960182e-15, -7.760741711124179e-17, -4.426436511348388e-18, -7.323621014395561e-20,  6.029434363573136e-22,
  3.687744663943579e-01, -4.316612492067086e-03,  3.333176948966902e-05, -1.880129902327705e-07,  4.199094023007928e-10,  1.627818752374231e-11,  3.044252320568330e-13,
  6.417411049281704e-15, -1.215372187039099e-16, -7.168171171057487e-18, -1.181059119270976e-19,  9.463366678355031e-22,  5.235561284260671e-01, -5.985524102712111e-03,
  4.166506942045267e-05, -1.596018027614137e-07, -7.531027952147285e-10,  3.518326090711413e-11,  4.439063803219600e-13,  9.233164600360738e-15, -1.712687569577959e-16,
 -1.118102556772955e-17, -1.833073068960574e-19,  1.424233953008115e-21,  7.111725445784685e-01, -7.849715964332945e-03,  4.565021866310819e-05, -2.026520464958179e-08,
 -3.117119135634275e-09,  5.840210160884075e-11,  8.307188033657039e-13,  1.093127349554030e-14, -2.262756985144908e-16, -1.700143980556595e-17, -2.862816536051952e-19,
  2.141820320124913e-21,  9.358960146566052e-01, -9.769545117061051e-03,  3.884363953514920e-05,  3.157910702263706e-07, -6.477834583093167e-09,  6.062165527882727e-11,
  1.977206463736500e-12,  1.126460177001882e-14, -3.699743487199744e-16, -2.475705276994009e-17, -4.669170415056549e-19,  3.116843690130014e-21,  1.203096760503695e+00,
 -1.137199725175767e-02,  7.737306210544316e-06,  9.283272107668132e-07, -6.968486676265614e-09, -5.193142917770075e-11,  4.422699248953201e-12,  3.806410876650885e-14,
 -1.102638844071675e-15, -3.878387595413989e-17, -6.893072847013639e-19,  3.155606495238829e-21,  1.516716191487868e+00, -1.152258935845465e-02, -7.392707284357424e-05,
  1.384354929091018e-06,  1.618481084978214e-08, -3.184414466933822e-10, -3.036658265021041e-13,  2.238583064212183e-13,  2.899084848277583e-16, -1.482466293409789e-16,
 -2.043333148969113e-18,  3.720961784884799e-20,  1.853806787835218e+00, -6.552245735284377e-03, -1.707693644585676e-04, -2.356828371606181e-06,  1.684452230349502e-08,
  1.752200428447991e-09,  3.817644598209453e-11, -4.057709119426880e-14, -2.590583507999253e-14, -7.070129769903970e-16, -2.927952053467608e-18,  3.872044513135911e-19,
  2.796456022707536e-03, -3.336960693860843e-05,  2.949049706651465e-07, -2.372413389477735e-09,  1.996572628556673e-11,  1.991414460032753e-14,  3.949806467903780e-15,
 -2.705567384140606e-17, -2.915279034678325e-18, -6.348305623311883e-20,  3.307412071587970e-22,  4.743586744364954e-23,  2.523081987027151e-02, -3.005118839421802e-04,
  2.636882720864921e-06, -2.091691645862491e-08,  1.729586768224623e-10,  2.833211868514170e-13,  3.489850438063666e-14, -2.353093711759875e-16, -2.665538943225438e-17,
 -5.779594204334194e-19,  2.991579032393967e-21,  4.322192398092766e-22,  7.043953260194886e-02, -8.357112921808275e-04,  7.223495976369538e-06, -5.557991445456928e-08,
  4.417723733173703e-10,  1.377032872523653e-12,  9.345307193143168e-14, -6.108738621015664e-16, -7.639037434332492e-17, -1.644677003695866e-18,  8.404762730346187e-21,
  1.231152741532424e-21,  1.391300144088815e-01, -1.640395807411131e-03,  1.383244018879311e-05, -1.009562849219667e-07,  7.457598674368459e-10,  4.488004827095137e-12,
  1.737183908755924e-13, -1.088191872924396e-15, -1.567484633947920e-16, -3.352353814327631e-18,  1.681351348072337e-20,  2.508914189930830e-21,  2.324371037865225e-01,
 -2.715455223051476e-03,  2.204923095164848e-05, -1.473558210041828e-07,  9.472278072656848e-10,  1.150624658310421e-11,  2.699970953003442e-13, -1.626995069789186e-15,
 -2.749463842532107e-16, -5.872909005262001e-18,  2.873827446400996e-20,  4.380577199391388e-21,  3.520272331843671e-01, -4.058841162714173e-03,  3.112809503948684e-05,
 -1.782431199250531e-07,  8.296989905124912e-10,  2.503367864903080e-11,  3.852560294250398e-13, -2.344949480651603e-15, -4.411550377629003e-16, -9.526049545604939e-18,
  4.512443596321404e-20,  7.045636629729265e-21,  5.002683298993769e-01, -5.660011665340314e-03,  3.970284795842795e-05, -1.653717344863411e-07,  7.309417845146552e-11,
  4.790293266789805e-11,  5.564547428560153e-13, -3.847703742422555e-15, -6.699493409052598e-16, -1.489418857591321e-17,  6.716629785309100e-20,  1.086898481454116e-20,
  6.805014735205613e-01, -7.486238562737414e-03,  4.515007875983649e-05, -5.963013084868647e-08, -1.731803653345987e-09,  8.055765691543730e-11,  9.296929155838308e-13,
 -7.926667369424237e-15, -9.902368228974783e-16, -2.296695547812826e-17,  9.426776150770458e-20,  1.658725323074033e-20,  8.974609881261921e-01, -9.445290710252239e-03,
  4.205983193941164e-05,  2.244949064788127e-07, -4.776164240304682e-09,  1.095815598419460e-10,  1.970253590756005e-12, -1.785612261492259e-14, -1.515113032972049e-15,
 -3.505907308334235e-17,  1.184685516309941e-19,  2.579135693522025e-20,  1.157800390267274e+00, -1.126747454613293e-02,  1.819344258132319e-05,  8.145619565092103e-07,
 -6.886063044796592e-09,  6.155145544570389e-11,  4.750771268452736e-12, -2.408540406103747e-14, -2.879569860874798e-15, -5.416487658419892e-17,  2.016731377592840e-19,
  4.147356901507274e-20,  1.469553798151405e+00, -1.204363081707722e-02, -5.596680505737074e-05,  1.594047354799310e-06,  1.023356520801836e-08, -2.548603240539474e-10,
  5.203472266658265e-12,  1.362928183221675e-13, -5.951100720179286e-15, -1.779266755848026e-16,  1.081851477462145e-18,  1.086071856422200e-19,  1.824696751524080e+00,
 -8.023969739467861e-03, -1.961222921673056e-04, -1.759554666222744e-06,  6.037525193338868e-08,  2.537835982667937e-09,  2.169626748238854e-11, -1.254632266076833e-12,
 -4.762328933586957e-14, -2.943862140147532e-16,  2.781495849258183e-17,  9.422863771149920e-19,  2.667523517385938e-03, -3.111875074398369e-05,  2.683813311906625e-07,
 -2.045097430517942e-09,  2.118786073695062e-11,  9.317278763991464e-14,  1.588426982030436e-15, -1.494850022678271e-16, -4.342531510259037e-18,  3.710826411488360e-21,
  3.234770638209629e-21,  7.326110660698259e-23,  2.406944010584549e-02, -2.803730820697747e-04,  2.402807358789034e-06, -1.806294271593266e-08,  1.858937167379927e-10,
  9.280936130452774e-13,  1.365642861633176e-14, -1.353681261700474e-15, -3.965657792304503e-17,  3.365983486909077e-20,  2.947289119018660e-20,  6.686243064539199e-22,
  6.720821263093804e-02, -7.804681647111551e-04,  6.600221445819724e-06, -4.818080803175483e-08,  4.887146129113653e-10,  3.089050868006649e-12,  3.440398576020028e-14,
 -3.811232861751167e-15, -1.134365104813331e-16,  9.435144470763860e-20,  8.396047279605910e-20,  1.911067273854662e-21,  1.327823746468057e-01, -1.534371144925062e-03,
  1.269619779771652e-05, -8.810140930165659e-08,  8.713783120161600e-10,  7.624086691823571e-12,  5.726996172141173e-14, -7.647064947604184e-15, -2.324520441589228e-16,
  1.840818462495199e-19,  1.712011006190111e-19,  3.915923941907877e-21,  2.219172610327417e-01, -2.545857189745652e-03,  2.038053903358339e-05, -1.300428168695510e-07,
  1.232557920469240e-09,  1.626862204990960e-11,  7.361853657043850e-14, -1.313461865223190e-14, -4.081649390990359e-16,  2.902181509197158e-19,  2.993694108782733e-19,
  6.891836707594715e-21,  3.362767441709511e-01, -3.818105319703939e-03,  2.908683981101227e-05, -1.605149987622516e-07,  1.408027163380516e-09,  3.160959582986985e-11,
  7.700685299275464e-14, -2.087261602841316e-14, -6.588449583386608e-16,  3.720243356473029e-19,  4.827725671521668e-19,  1.120542941007571e-20,  4.782510901008575e-01,
 -5.350229696367454e-03,  3.775915249130820e-05, -1.558983110348727e-07,  1.141505637670352e-09,  5.709234005348983e-11,  7.803898333313426e-14, -3.222054452367499e-14,
 -1.014192706120159e-15,  3.348940561709680e-19,  7.469984028107666e-19,  1.752823809834921e-20,  6.512738941805487e-01, -7.128241574175636e-03,  4.432497760866295e-05,
 -7.338653830676182e-08,  6.297562580818712e-11,  9.592920993762396e-11,  1.547551285271381e-13, -5.039151872088591e-14, -1.529171012730927e-15,  4.803860830259211e-20,
  1.140338022194832e-18,  2.720636611227308e-20,  8.603682492267963e-01, -9.099153453784915e-03,  4.437517246368816e-05,  1.678958624045497e-07, -2.185110884325900e-09,
  1.443197008914201e-10,  6.235025777289935e-13, -8.292605784188963e-14, -2.347862138594996e-15, -1.642499141514492e-19,  1.764042561641093e-18,  4.328953578697230e-20,
  1.113081021291455e+00, -1.108456920951006e-02,  2.736669000998341e-05,  7.199898360425926e-07, -4.630400944598691e-09,  1.554225159504517e-10,  2.529058404723068e-12,
 -1.414799256382795e-13, -4.121295759237467e-15,  3.474500989815056e-18,  2.929304880458140e-18,  7.321959117363518e-20,  1.420608433774081e+00, -1.241240613825680e-02,
 -3.599958535757721e-05,  1.724631562603499e-06,  6.559880563887895e-09, -1.110654333277787e-10,  5.510878083022256e-12, -1.376150192445879e-13, -1.023101769416286e-14,
 -1.870142754390115e-17,  7.222072388910598e-18,  1.508695344631017e-19,  1.789357603733427e+00, -9.657015353492594e-03, -2.097144924230654e-04, -3.742814235858374e-07,
  1.125964125567107e-07,  2.464653262449862e-09, -3.437028071217067e-11, -2.654967522381863e-12, -2.879211899176677e-14,  1.549846720775400e-15,  5.761365613767605e-17,
 -1.174793293136465e-20,  2.547195518174124e-03, -2.906395477027065e-05,  2.459378550548502e-07, -1.690806815947208e-09,  2.301659106939252e-11,  6.652313005870861e-14,
 -4.312125303584602e-15, -2.559480207544530e-16, -1.258372225810063e-18,  1.777850655282499e-19,  4.627252515270001e-21, -4.258042392049655e-23,  2.298509321038534e-02,
 -2.619656290937167e-04,  2.204526859454960e-06, -1.493770255849200e-08,  2.039604755682745e-10,  6.681582293950759e-13, -3.991296913194949e-14, -2.326565193058150e-15,
 -1.154687438005709e-17,  1.620928877968135e-18,  4.222158377199882e-20, -3.869640442899592e-22,  6.418847574361110e-02, -7.298413639126222e-04,  6.071036149321162e-06,
 -3.986562829932943e-08,  5.480985891099553e-10,  2.253991565028036e-12, -1.171528346670441e-13, -6.597844065967351e-15, -3.333196439776759e-17,  4.623105612748793e-18,
  1.206314314674377e-19, -1.096508879962708e-21,  1.268416835122781e-01, -1.436781762468291e-03,  1.172767291462979e-05, -7.295214110066077e-08,  1.016140058455702e-09,
  5.649560711781721e-12, -2.488318848394974e-13, -1.336864028362253e-14, -6.915786895700214e-17,  9.440289703649802e-18,  2.470760985470506e-19, -2.217127801077099e-21,
  2.120505434529031e-01, -2.388695050350137e-03,  1.894899558031275e-05, -1.077734640378449e-07,  1.538567244615623e-09,  1.225195902976079e-11, -4.558993620045172e-13,
 -2.320716206324122e-14, -1.231587155571533e-16,  1.652787942032409e-17,  4.346931942933018e-19, -3.830590239996403e-21,  3.214581166349353e-01, -3.592684794327381e-03,
  2.731637524677698e-05, -1.330685378463244e-07,  1.999658064939565e-09,  2.422959311601139e-11, -7.690105465403791e-13, -3.718124045623231e-14, -2.014205847725801e-16,
  2.666696417608385e-17,  7.066231330869291e-19, -6.077285582996448e-21,  4.574430209006201e-01, -5.055243447694389e-03,  3.603497585302802e-05, -1.287679587999516e-07,
  2.210962137086181e-09,  4.472337567261146e-11, -1.227724842895273e-12, -5.740527241617907e-14, -3.124625758525940e-16,  4.124674496150232e-17,  1.104860763022651e-18,
 -9.206203827582592e-21,  6.234647648526657e-01, -6.777002829279730e-03,  4.351280861006069e-05, -5.740412125797565e-08,  1.877162920673272e-09,  7.755196975334409e-11,
 -1.866016197761415e-12, -8.844823426635858e-14, -4.687823950336144e-16,  6.299609766997132e-17,  1.710985938719483e-18, -1.369974641807530e-20,  8.246938495465505e-01,
 -8.736467298008541e-03,  4.627552288403113e-05,  1.559014886415250e-07,  6.209987505872797e-10,  1.234974885108127e-10, -2.634471438157837e-12, -1.412534340979198e-13,
 -7.017345906560696e-16,  9.839472730663911e-17,  2.701522502304477e-18, -2.069272820788629e-20,  1.069233881692900e+00, -1.083208572102727e-02,  3.567100702931544e-05,
  6.724645012892162e-07, -1.308963944815649e-09,  1.547493158607603e-10, -3.065323882036445e-12, -2.431537481187996e-13, -1.234875632632170e-15,  1.686116352395438e-16,
  4.549453761133335e-18, -3.465837152218452e-20,  1.370516231982634e+00, -1.261596751843942e-02, -1.472943860402217e-05,  1.817043648552232e-06,  5.163445801150465e-09,
 -6.037588695324261e-11, -2.562917125792155e-12, -4.089354128023211e-13, -4.426871729967369e-15,  3.616046380124633e-16,  9.990887018829691e-18, -9.885564010907825e-20,
  1.747393315601488e+00, -1.131874582187183e-02, -2.019869473100254e-04,  1.750449029286749e-06,  1.473552142374214e-07,  7.101633676312928e-10, -1.102844604774576e-10,
 -2.287057435963888e-12,  6.106195412485757e-14,  3.027222204051143e-15, -5.116440063067894e-18, -2.826279153378602e-18,  2.434755114322714e-03, -2.717129769253211e-05,
  2.278767904223946e-07, -1.319952089542688e-09,  2.273737752570208e-11, -1.204900726549308e-13, -1.086646212616883e-14, -1.657717828709570e-16,  7.408893854685304e-18,
  2.581010402442227e-19, -2.205891026149215e-21, -2.516846661107765e-22,  2.197144695769438e-02, -2.449903795257484e-04,  2.045066417057971e-06, -1.164158228656994e-08,
  2.025187256898121e-10, -1.049157176645131e-12, -9.950590618798972e-14, -1.506437154519879e-15,  6.750605557003424e-17,  2.354809486220122e-18, -2.009304874577983e-20,
 -2.297181812061746e-21,  6.136343043355103e-02, -6.830354213948030e-04,  5.646086911972406e-06, -3.095089432054619e-08,  5.502356510589939e-10, -2.712260477290154e-12,
 -2.862253187561386e-13, -4.269511061032479e-15,  1.923226658689961e-16,  6.725910935280111e-18, -5.720460691960075e-20, -6.567139622247945e-21,  1.212770529566201e-01,
 -1.346179846865993e-03,  1.095212574580771e-05, -5.624158818770014e-08,  1.039353376037975e-09, -4.690789412436553e-12, -5.916042213998260e-13, -8.642476750380301e-15,
  3.922530061292005e-16,  1.376638831102168e-17, -1.165178585508721e-19, -1.346272462729692e-20,  2.027913655511975e-01, -2.241844062706769e-03,  1.780897162769841e-05,
 -8.201140353909700e-08,  1.621978664225939e-09, -6.277912569300389e-12, -1.051263993178811e-12, -1.498086483101435e-14,  6.863492594544070e-16,  2.418576477682647e-17,
 -2.034145796098788e-19, -2.371487302009458e-20,  3.075151323169262e-01, -3.379968626920389e-03,  2.592329282398448e-05, -9.855403495515322e-08,  2.215996178719170e-09,
 -6.390056112447728e-12, -1.723155977861188e-12, -2.395154406642320e-14,  1.108629728764658e-15,  3.921389430909875e-17, -3.273889073831017e-19, -3.861642304337186e-20,
  4.377897425660953e-01, -4.772488269177227e-03,  3.472484595635301e-05, -8.838431070943841e-08,  2.681559463981489e-09, -3.520398810625794e-12, -2.700339636723616e-12,
 -3.687674461145275e-14,  1.722317796862682e-15,  6.105026950162492e-17, -5.061312415733365e-19, -6.053978233411884e-20,  5.970494469701975e-01, -6.431047297682807e-03,
  4.304516207319465e-05, -1.823594918322003e-08,  2.781435356811369e-09,  3.864850698924500e-12, -4.131673787702622e-12, -5.664179071462088e-14,  2.655018434653800e-15,
  9.395841962394351e-17, -7.769581284954829e-19, -9.421589509534936e-20,  7.905006869044033e-01, -8.358452230053996e-03,  4.827265785089387e-05,  1.808199280758807e-07,
  2.141533253035024e-09,  1.420203153791915e-11, -6.244845379853097e-12, -9.037216468258313e-14,  4.196646134401879e-15,  1.474820313223397e-16, -1.237359156753227e-18,
 -1.504633692108901e-19,  1.026527142916652e+00, -1.051459769150817e-02,  4.369776844839870e-05,  6.699716946343566e-07,  5.037087824934647e-10,  1.730720836654155e-12,
 -9.301644966026701e-12, -1.575974621111082e-13,  7.101793008172281e-15,  2.492658961944928e-16, -2.242548183443417e-18, -2.605211310046438e-19,  1.319956596381237e+00,
 -1.264531384582173e-02,  7.509157301897298e-06,  1.882653880355959e-06,  2.390554769007542e-09, -2.608875781063270e-10, -1.358340556530888e-11, -2.828253143290679e-13,
  1.334007394255441e-14,  5.207804744599553e-16, -5.675072255046839e-18, -5.733585796829704e-19,  1.699076298318236e+00, -1.281048177255897e-02, -1.668798298360721e-04,
  4.061372257417496e-06,  1.314457550171681e-07, -2.391476022517452e-09, -1.323776117487016e-10,  1.109194689665623e-12,  1.341249963271454e-13,  1.879217820685063e-16,
 -1.271981517581243e-16, -1.460557662099367e-18,  2.329624002751838e-03, -2.540573723402901e-05,  2.140917980995971e-07, -9.905988581940587e-10,  1.751455951128072e-11,
 -4.027654149540871e-13, -1.104132964537934e-14,  1.810082734961728e-16,  1.244834714205638e-17, -4.287942566461135e-20, -1.157096453028235e-20, -7.681868850697763e-23,
  2.102339628292471e-02, -2.291360469327568e-04,  1.923669861342170e-06, -8.707944142370027e-09,  1.557951782708923e-10, -3.631579187356583e-12, -1.009725051891363e-13,
  1.654695060878319e-15,  1.134905046666964e-16, -3.914061425866353e-19, -1.056130569026674e-19, -7.018955721675256e-22,  5.871947649625521e-02, -6.392093942761504e-04,
  5.324424480942645e-06, -2.297986073298993e-08,  4.220529885347697e-10, -1.012715381929958e-11, -2.896977511742757e-13,  4.744374824342313e-15,  3.236957008682909e-16,
 -1.119596208890726e-18, -3.019321502443668e-19, -2.010654004985882e-21,  1.160636762653496e-01, -1.260992161152525e-03,  1.037125809667459e-05, -4.118535452883850e-08,
  7.930132814169257e-10, -1.997836526611706e-11, -5.966228138301554e-13,  9.764088049750797e-15,  6.611952499416869e-16, -2.299747887260561e-18, -6.189571375965744e-19,
 -4.133049034119105e-21,  1.941032984105379e-01, -2.102886601319802e-03,  1.697169917685917e-05, -5.852368452728342e-08,  1.226009562136503e-09, -3.336335981291013e-11,
 -1.055622244501642e-12,  1.727020706986843e-14,  1.158804380729123e-15, -4.071749359105488e-18, -1.090171991371436e-18, -7.300692852827043e-21,  2.944033591658872e-01,
 -3.176735224144698e-03,  2.494146798238968e-05, -6.650824736892131e-08,  1.645967779024752e-09, -5.065502068474222e-11, -1.722613516678741e-12,  2.820479412384095e-14,
  1.874008865882173e-15, -6.705407162929542e-18, -1.774568315240164e-18, -1.190678446968772e-20,  4.192496621766830e-01, -4.498231997142830e-03,  3.390729673182550e-05,
 -4.977929977215560e-08,  1.919302146350302e-09, -7.273256304473436e-11, -2.689647802531716e-12,  4.418885324239405e-14,  2.910897780646136e-15, -1.075582920755819e-17,
 -2.779869382688685e-18, -1.862014295784939e-20,  5.720136238839267e-01, -6.086835752686490e-03,  4.307746952631763e-05,  2.116746974683105e-08,  1.800100718842124e-09,
 -1.020217497407483e-10, -4.110617340275475e-12,  6.817055694005822e-14,  4.472971746634327e-15, -1.749859995697461e-17, -4.319764248344703e-18, -2.859047044602476e-20,
  7.578537633351463e-01, -7.963043394565822e-03,  5.062951115872574e-05,  2.086830401590319e-07,  8.187849647512152e-10, -1.466296670406756e-10, -6.242073737260050e-12,
  1.061005253700558e-13,  7.009011936477187e-15, -3.036736869706978e-17, -6.880483017972418e-18, -4.368514471244433e-20,  9.852189254656575e-01, -1.013280130096867e-02,
  5.174486064599261e-05,  6.652358811213549e-07, -1.887690771931579e-09, -2.416786470085277e-10, -9.440126698150231e-12,  1.731132054678864e-13,  1.169281508495529e-14,
 -6.095810838438098e-17, -1.184831141153050e-17, -6.508113165807974e-20,  1.269638808111867e+00, -1.249474374399425e-02,  3.009610189244071e-05,  1.859820012689397e-06,
 -6.415533589344522e-09, -6.191550390238557e-10, -1.330641256614356e-11,  3.513073812132159e-13,  2.211263808512916e-14, -1.686311080873165e-16, -2.504088843540923e-17,
 -6.157813386166332e-20,  1.645517333312369e+00, -1.391949079637311e-02, -1.076127952376684e-04,  5.628256173629352e-06,  5.676194748827126e-08, -4.740916707118798e-09,
 -4.743311741810203e-11,  4.506677535595385e-12,  4.993852045818540e-14, -4.399289288449533e-15, -5.805664514017293e-17,  4.302366307186432e-18,  2.231357051846703e-03,
 -2.373648169610575e-05,  2.035800999607289e-07, -7.867230869582517e-10,  7.434748383653299e-12, -5.665485249794832e-13, -1.260561246537157e-15,  4.674833343267177e-16,
  3.097180685476405e-18, -4.263960192005483e-19, -4.129260975846377e-21,  3.790092496916394e-22,  2.013702060864426e-02, -2.141285617834591e-04,  1.831367387512358e-06,
 -6.905261272112825e-09,  6.464197938563257e-11, -5.130759141541983e-12, -1.168648487100058e-14,  4.265284436082672e-15,  2.814138246091710e-17, -3.891270178377241e-18,
 -3.762581520774749e-20,  3.462465711352693e-21,  5.624622229362610e-02, -5.976197753500716e-04,  5.081447031552760e-06, -1.816019994549781e-08,  1.663287704436834e-10,
 -1.443596829198564e-11, -3.439680335547129e-14,  1.218318881269695e-14,  7.969962680988047e-17, -1.112101487671673e-17, -1.071760521265394e-19,  9.917044488256580e-21,
  1.111827765372341e-01, -1.179818087895203e-03,  9.937809240442748e-06, -3.233837749444624e-08,  2.838077726701351e-10, -2.887320260871058e-11, -7.327810881069735e-14,
  2.493538140611900e-14,  1.609510949522605e-16, -2.278712979863023e-17, -2.183574795373728e-19,  2.039017708485624e-20,  1.859592453959416e-01, -1.969647218437212e-03,
  1.636125402526695e-05, -4.538711206456639e-08,  3.645412493853480e-10, -4.914187988506499e-11, -1.345056828976874e-13,  4.379693097635854e-14,  2.773267405368215e-16,
 -4.010994597802089e-17, -3.808328910249825e-19,  3.606937417119681e-20,  2.820909414712600e-01, -2.980037959130373e-03,  2.426168441226009e-05, -5.014113006247151e-08,
  3.156907240957194e-10, -7.645769205088117e-11, -2.265271017869483e-13,  7.095414357644396e-14,  4.374876509510339e-16, -6.523923095323403e-17, -6.103311007579815e-19,
  5.907461542636779e-20,  4.017960336772842e-01, -4.228971501265446e-03,  3.343641355786143e-05, -3.361709491077312e-08, -3.057086087862998e-11, -1.130359776836680e-10,
 -3.581903863862096e-13,  1.102417862369571e-13,  6.548835019843952e-16, -1.020958149247451e-16, -9.320380214157519e-19,  9.334308875807014e-20,  5.483575772946913e-01,
 -5.740895886987824e-03,  4.342202491696296e-05,  2.920610252191952e-08, -9.955081714262220e-10, -1.633699064283008e-10, -5.279949271270198e-13,  1.688230042047485e-13,
  9.493907834842914e-16, -1.584220768856069e-16, -1.385443491332897e-18,  1.468434253783124e-19,  7.268274839977348e-01, -7.548036805642182e-03,  5.309296039450080e-05,
  1.916175946421298e-07, -3.251493966251083e-09, -2.383459867875671e-10, -6.689609076605793e-13,  2.615518210850827e-13,  1.342195365748512e-15, -2.515910393472944e-16,
 -2.023970570545212e-18,  2.381006854242661e-19,  9.455648994501195e-01, -9.687860790955970e-03,  5.935330269846582e-05,  5.864050632276413e-07, -8.396195742244748e-09,
 -3.730508508624916e-10, -3.209539324223260e-13,  4.249107369428282e-13,  1.770321318632730e-15, -4.291287916004079e-16, -2.832719379745600e-18,  4.208282193537514e-19,
  1.220278897399712e+00, -1.216748044806370e-02,  5.134551255604106e-05,  1.645400062739178e-06, -2.083038758760643e-08, -7.527583887307671e-10,  4.222548777526543e-12,
  7.849746401438788e-13,  6.543988913311018e-16, -8.688535646033181e-16, -2.393513639846211e-18,  9.217025162970349e-19,  1.588557369950038e+00, -1.450218624394952e-02,
 -3.783315022854841e-05,  5.760245801225683e-06, -3.893393438640013e-08, -4.337102658297689e-09,  7.640601762897707e-11,  3.516789489426028e-12, -1.019358154144392e-13,
 -2.803923913463735e-15,  1.210039964282227e-16,  2.112743862794151e-18,  2.139610348992854e-03, -2.214443091993609e-05,  1.944861509931610e-07, -7.555928634733107e-10,
 -3.142241888908112e-12, -4.430059561381245e-13,  1.087941484811697e-14,  3.232025214633195e-16, -1.105833798160886e-17, -2.542912604157445e-19,  1.127138249801575e-20,
  1.869515970615681e-22,  1.930929810336810e-02, -1.997991872430243e-04,  1.751385865347697e-06, -6.666412515865543e-09, -3.114062475707627e-11, -4.008440375414385e-12,
  9.902539917301287e-14,  2.945350213530769e-15, -1.009693539910320e-16, -2.316256287499627e-18,  1.029723246923599e-19,  1.703050091706942e-21,  5.393570145047203e-02,
 -5.578163013390884e-04,  4.870137959292817e-06, -1.773723212434612e-08, -1.031312716294170e-10, -1.125714121039402e-11,  2.815259784387346e-13,  8.391957303988058e-15,
 -2.888575300794425e-16, -6.593386586273591e-18,  2.949379772762509e-19,  4.848505738941281e-21,  1.066201032023069e-01, -1.101833981943677e-03,  9.558280542398029e-06,
 -3.227480402397107e-08, -2.549714525506199e-10, -2.244439949981932e-11,  5.723082906080972e-13,  1.710637749341420e-14, -5.927675317080837e-16, -1.342217474372632e-17,
  6.064339310396634e-19,  9.870290388884366e-21,  1.783390297742951e-01, -1.840910365083839e-03,  1.581974735457487e-05, -4.717504293081201e-08, -5.518495313863041e-10,
 -3.801042790985487e-11,  9.968050303735357e-13,  2.986454652399482e-14, -1.045453483333166e-15, -2.339386108889758e-17,  1.072763837369294e-18,  1.719612966423217e-20,
  2.705551355571345e-01, -2.788380154646383e-03,  2.364073038382292e-05, -5.694316175067340e-08, -1.108129147531372e-09, -5.867895747311085e-11,  1.600246357984149e-12,
  4.795562523259613e-14, -1.704492453430705e-15, -3.749648949325006e-17,  1.756837360848279e-18,  2.752206696373787e-20,  3.854123396827003e-01, -3.963271748775711e-03,
  3.295683013246833e-05, -5.161133746172636e-08, -2.129670237616460e-09, -8.566939320249471e-11,  2.466567698559051e-12,  7.353260353891898e-14, -2.674528063581094e-15,
 -5.739318789086561e-17,  2.775081803465111e-18,  4.196251917113457e-20,  5.260902602544476e-01, -5.392633377236789e-03,  4.357126508812389e-05, -1.194942885148257e-08,
 -4.011700588341946e-09, -1.212115515476066e-10,  3.766641220563165e-12,  1.103086692301984e-13, -4.161148582139717e-15, -8.597922757161198e-17,  4.361567718254043e-18,
  6.226454905465192e-20,  6.974976687740146e-01, -7.115335498852030e-03,  5.492687063470472e-05,  1.030547871219682e-07, -7.596542860558313e-09, -1.700705123149425e-10,
  5.904930378872308e-12,  1.649340332361989e-13, -6.623141447619243e-15, -1.284692888804132e-16,  7.053246230866003e-18,  9.078414809546378e-20,  9.078037250533656e-01,
 -9.187720536065758e-03,  6.534748869912678e-05,  3.959363563356654e-07, -1.499793757905038e-08, -2.457266338996408e-10,  1.010373542836140e-11,  2.488802345809411e-13,
 -1.131945793554609e-14, -1.934341490269257e-16,  1.236288310662308e-17,  1.267522756163223e-19,  1.172546135845800e+00, -1.168447541897687e-02,  6.863134115754015e-05,
  1.204333007685407e-06, -3.319841525952400e-08, -4.129403921828990e-10,  2.210606448935391e-11,  3.625242025149864e-13, -2.333148160579992e-14, -2.662958471314250e-16,
  2.625872977368218e-17,  1.080526705256008e-19,  1.530358413473945e+00, -1.454475856114618e-02,  2.508600430074782e-05,  4.569002854377427e-06, -1.015334145582881e-07,
 -1.747853103424753e-09,  1.211720102404005e-10, -3.606709940189518e-13, -1.108826969178394e-13,  2.010886384332386e-15,  8.003838017966121e-17, -3.123020641267223e-18,
  2.054085015195591e-03, -2.062623398096789e-05,  1.848774565128453e-07, -8.602812717646755e-10, -8.888740007660344e-12, -1.184195566552629e-13,  1.426461636956636e-14,
 -8.370520481362558e-17, -1.157714889511961e-17,  2.029139882560869e-19,  8.120528153156238e-21, -2.716543147837954e-22,  1.853759808180872e-02, -1.861217022477479e-04,
  1.666231374278480e-06, -7.656102597974030e-09, -8.296672632471046e-11, -1.053934730898427e-12,  1.298061037483684e-13, -7.667321961769301e-16, -1.055177667136777e-16,
  1.856056130056491e-18,  7.397700121436998e-20, -2.484000460100762e-21,  5.178095164994569e-02, -5.197490491267558e-04,  4.641318660509469e-06, -2.076222457245085e-08,
 -2.476877019721528e-10, -2.857613037573367e-12,  3.688100463327625e-13, -2.208537374488056e-15, -3.007495601505008e-16,  5.329646713645636e-18,  2.106348930933121e-19,
 -7.127905755227919e-21,  1.023631108805643e-01, -1.027014909963190e-03,  9.134452938163674e-06, -3.907884370432025e-08, -5.400313018900525e-10, -5.372444017978592e-12,
  7.488116242792899e-13, -4.584045382516273e-15, -6.134950866829037e-16,  1.100181920827996e-17,  4.289469835694441e-19, -1.469798485989675e-20,  1.712246428859446e-01,
 -1.716815112215918e-03,  1.518039047912924e-05, -6.057705513841769e-08, -1.026785320125817e-09, -8.295574666075788e-12,  1.301097960416365e-12, -8.227821953582296e-15,
 -1.072512456164128e-15,  1.957073405487644e-17,  7.479525244116017e-19, -2.610474718680842e-20,  2.597750150886686e-01, -2.602362853085625e-03,  2.282001914871456e-05,
 -8.164042539553839e-08, -1.824159454343336e-09, -1.105531205862462e-11,  2.079388197015471e-12, -1.377218953160765e-14, -1.726573961698636e-15,  3.229324409618289e-17,
  1.199378165765519e-18, -4.297978429246636e-20,  3.700816796819130e-01, -3.702780334855859e-03,  3.208837922606025e-05, -9.566724172460200e-08, -3.139445542485103e-09,
 -1.253433357530898e-11,  3.178475562021244e-12, -2.247827123884702e-14, -2.659817544579489e-15,  5.152514082435394e-17,  1.836358199821355e-18, -6.836002868771467e-20,
  5.052142205707383e-01, -5.045876317408132e-03,  4.298082209939271e-05, -8.986358145266446e-08, -5.367051591608243e-09, -1.038913158892711e-11,  4.778166483720230e-12,
 -3.712594811394897e-14, -4.025328097388783e-15,  8.207560390319374e-17,  2.750554696022431e-18, -1.083776306889965e-19,  6.699198012669861e-01, -6.673242728061021e-03,
  5.535012954796077e-05, -3.689669884008501e-08, -9.341227593633676e-09,  8.688544373690939e-13,  7.263800062263456e-12, -6.486151548758181e-14, -6.125977700159025e-15,
  1.351878437352645e-16,  4.104258161609512e-18, -1.770998462862359e-19,  8.721223606449985e-01, -8.650294434896453e-03,  6.854401214252144e-05,  1.314132057582431e-07,
 -1.714924395634080e-08,  3.650340996999564e-11,  1.164509677085349e-11, -1.290684099232701e-13, -9.630258808701002e-15,  2.434317027517195e-16,  6.154655025153981e-18,
 -3.137081345069998e-19,  1.126984538474309e+00, -1.108707626948861e-02,  7.972279529234521e-05,  6.378043406385053e-07, -3.577724823167337e-08,  1.532528681601201e-10,
  2.175341695404655e-11, -3.471781797959185e-13, -1.607432231553043e-14,  5.445729790001745e-16,  8.481629015044296e-18, -6.653777935174371e-19,  1.472886749560901e+00,
 -1.415404849818603e-02,  6.950053577771226e-05,  2.813192056689271e-06, -1.099571476562219e-07,  7.202722604370174e-10,  7.508823545580065e-11, -2.407056586876875e-12,
 -1.421717139240532e-14,  2.534663388027395e-15, -4.093835521820409e-17, -1.511512863799415e-18,  1.974469230792169e-03, -1.919099137572665e-05,  1.736790925265228e-07,
 -1.004293616786862e-09, -8.204988442303620e-12,  1.623206325611288e-13,  8.135606868954861e-15, -2.994513084557690e-16, -1.476128196606388e-18,  2.786544002875412e-19,
 -3.553105924113311e-21, -1.752785107140768e-22,  1.781915645141071e-02, -1.731824742696200e-04,  1.566211618682399e-06, -8.996149611613510e-09, -7.628449976478028e-11,
  1.498786940083791e-12,  7.386808110535544e-14, -2.730122020543963e-15, -1.330446495318200e-17,  2.540399963704183e-18, -3.257050440978587e-20, -1.595707141969197e-21,
  4.977454150915272e-02, -4.836838512481258e-04,  4.367967093895297e-06, -2.473939415577156e-08, -2.260425701301639e-10,  4.383597657597302e-12,  2.089067624442005e-13,
 -7.786879434356582e-15, -3.703245049490075e-17,  7.244619150295780e-18, -9.393948389056117e-20, -4.537115244181430e-21,  9.839802191378254e-02, -9.559641412794398e-04,
  8.613077737659275e-06, -4.768044902351724e-08, -4.877492414435308e-10,  9.291677757753902e-12,  4.210162029402324e-13, -1.590480339551721e-14, -7.262125307339631e-17,
  1.479103330323693e-17, -1.952532354849743e-19, -9.218423949264855e-21,  1.645952670321833e-01, -1.598561197355778e-03,  1.435455460896937e-05, -7.677448165947449e-08,
 -9.158111850012583e-10,  1.708689372257992e-11,  7.236039010391424e-13, -2.786734930300759e-14, -1.193914487461977e-16,  2.589083214746925e-17, -3.507011936356043e-19,
 -1.601809362037776e-20,  2.497237775979795e-01, -2.424217850629137e-03,  2.166610807445451e-05, -1.101114919769523e-07, -1.604259106958772e-09,  2.928847751972636e-11,
  1.138577003105779e-12, -4.503617789012120e-14, -1.746083277800913e-16,  4.175659068698325e-17, -5.862299602210692e-19, -2.555178459285801e-20,  3.557755029258240e-01,
 -3.451513058947518e-03,  3.064319319275399e-05, -1.441204374597368e-07, -2.719355259259816e-09,  4.864747816781544e-11,  1.701921859840918e-12, -6.984899790105322e-14,
 -2.295293465593746e-16,  6.449552468061208e-17, -9.513601275219820e-19, -3.881066595607371e-20,  4.857095448047397e-01, -4.707781020559755e-03,  4.139903996906346e-05,
 -1.717427221469134e-07, -4.573919454227452e-09,  8.050783475148307e-11,  2.475182100896690e-12, -1.070015383359506e-13, -2.572142092814431e-16,  9.798048749931292e-17,
 -1.549123632558778e-18, -5.738863359917718e-20,  6.441061151070813e-01, -6.234695145971195e-03,  5.403936284314075e-05, -1.776956816550692e-07, -7.820158258255736e-09,
  1.365005568932706e-10,  3.571205312243628e-12, -1.666982929850607e-13, -1.686682803569748e-16,  1.499875718709494e-16, -2.624602109933062e-18, -8.370234983413669e-20,
  8.386214766204164e-01, -8.100153203726066e-03,  6.854330876694455e-05, -1.236890983108459e-07, -1.405864917342343e-08,  2.469278758860304e-10,  5.218686105431638e-12,
 -2.758519115742434e-13,  3.883452585740490e-16,  2.381252000369759e-16, -4.894481541244654e-18, -1.195767898729685e-19,  1.083947047986616e+00, -1.042801328038138e-02,
  8.412384896593905e-05,  1.141486412266129e-07, -2.849811700740316e-08,  5.196768639984608e-10,  7.936537101074771e-12, -5.345723662877901e-13,  3.442568842544116e-15,
  4.060406563317047e-16, -1.132471514593378e-17, -1.394828052988059e-19,  1.417556248705306e+00, -1.349130254009134e-02,  9.343276470950893e-05,  1.244146554638677e-06,
 -8.294609661406420e-08,  1.733050366654047e-09,  1.230897911427018e-11, -1.792566628275052e-12,  3.981771134588966e-14,  4.463862721769653e-16, -4.608042365324823e-17,
  8.330145576020743e-19,  1.900405048572286e-03, -1.785169500061617e-05,  1.609736013177911e-07, -1.101833357162424e-09, -3.677936298032190e-12,  2.596316053486604e-13,
  3.399655620035038e-16, -2.236038738774475e-16,  4.906402343055117e-18,  6.511044503249400e-20, -5.317963407180125e-21,  6.645439979363828e-23,  1.715077657399887e-02,
 -1.611025710402954e-04,  1.452164773029879e-06, -9.906455246260045e-09, -3.470354764527340e-11,  2.379170669164863e-12,  2.854689473939073e-15, -2.034832372900315e-15,
  4.479290304489850e-17,  5.898242675043456e-19, -4.848203052342402e-20,  6.096531986103567e-22,  4.790773714858731e-02, -4.499810241179576e-04,  4.052967628242617e-06,
 -2.745605395053957e-08, -1.056814129804382e-10,  6.854929238604193e-12,  6.718070614641147e-15, -5.781394851773853e-15,  1.281140233286482e-16,  1.659746579486351e-18,
 -1.382576820692288e-19,  1.761129204406130e-21,  9.470818578015229e-02, -8.894639095072724e-04,  8.001586662944780e-06, -5.359925126938084e-08, -2.364578497967996e-10,
  1.421303319326675e-11,  9.209369252872832e-15, -1.173564679398232e-14,  2.628076746472960e-16,  3.315871868698902e-18, -2.822634205502871e-19,  3.669131455182989e-21,
  1.584245489460814e-01, -1.487628247642371e-03,  1.335895497376246e-05, -8.801317354031106e-08, -4.626241779958941e-10,  2.539757736277311e-11,  5.061781007453765e-15,
 -2.037596464320509e-14,  4.632796716602978e-16,  5.617788312770604e-18, -4.940320618162669e-19,  6.610677797012318e-21,  2.403646476760217e-01, -2.256558650335374e-03,
  2.021373719032283e-05, -1.300330136628617e-07, -8.454634946879211e-10,  4.203832297818377e-11, -1.575297794794515e-14, -3.250360137189347e-14,  7.548289222782440e-16,
  8.633055297146062e-18, -7.965721146017505e-19,  1.109171837703356e-20,  3.424478560512494e-01, -3.213939872013768e-03,  2.869018703156267e-05, -1.782827161846293e-07,
 -1.492702030265458e-09,  6.701780099955491e-11, -7.315256367637947e-14, -4.948023558976133e-14,  1.183312862456725e-15,  1.239450410183451e-17, -1.229678817186789e-18,
  1.807446898743133e-20,  4.675261781879315e-01, -4.385938111068555e-03,  3.895987899474104e-05, -2.298151135073137e-07, -2.605219194100566e-09,  1.057754901674927e-10,
 -2.100245456507391e-13, -7.374454033801079e-14,  1.838277167249909e-15,  1.673796396312113e-17, -1.865900991077141e-18,  2.954513133936016e-20,  6.200157587464200e-01,
 -5.812806708962556e-03,  5.125721515498500e-05, -2.778634539723839e-07, -4.596152153335151e-09,  1.697336938246986e-10, -5.309436395304940e-13, -1.100670238034674e-13,
  2.916907407146785e-15,  2.063884185255728e-17, -2.848778973102251e-18,  5.015321729868134e-20,  8.073032929759104e-01, -7.561160847093951e-03,  6.588750274154360e-05,
 -3.048278823165815e-07, -8.457820324611061e-09,  2.873083334910854e-10, -1.345434639279483e-12, -1.691255506377541e-13,  4.943935281801451e-15,  1.892647624505571e-17,
 -4.493623392656215e-18,  9.305656571369369e-20,  1.043579805465120e+00, -9.756461547231393e-03,  8.312127130571355e-05, -2.530476669269171e-07, -1.730236356222895e-08,
  5.532557647660629e-10, -3.935702346459763e-12, -2.802415738824208e-13,  9.855559337667352e-15, -2.152745531519329e-17, -7.513589828245699e-18,  2.086045853399320e-19,
  1.365152180605784e+00, -1.270401809113827e-02,  1.015553037622689e-04,  1.959536479471108e-07, -4.862945866434994e-08,  1.574210942418241e-09, -1.970978645220311e-11,
 -5.380459949415244e-13,  3.247112756422386e-14, -5.904925467284551e-16, -7.248552862317884e-18,  6.759037656606613e-19,  1.831489207180487e-03, -1.661740628584700e-05,
  1.475662979795998e-07, -1.120490823286306e-09,  1.185237359226702e-12,  2.112715181845617e-13, -3.622288774689698e-15, -6.293794221037297e-17,  4.333563252571307e-18,
 -6.955141890068297e-20, -1.313165204514268e-21,  8.405755398625785e-23,  1.652883940518049e-02, -1.499666453837960e-04,  1.331492471428917e-06, -1.009364763580208e-08,
  9.826617340140697e-12,  1.933764513926039e-12, -3.315522901837912e-14, -5.699978765264872e-16,  3.946400214679098e-17, -6.357472064512481e-19, -1.189789131630192e-20,
  7.660498426437209e-22,  4.617054681013898e-02, -4.188936806148610e-04,  3.717772726805918e-06, -2.808774423366786e-08,  2.242123422359718e-11,  5.558456677990138e-12,
 -9.531602019499444e-14, -1.603355006501200e-15,  1.122871793223227e-16, -1.822875346083020e-18, -3.349385805851905e-20,  2.182930427120346e-21,  9.127421917659621e-02,
 -8.280670974387719e-04,  7.344852762848841e-06, -5.519038811465327e-08,  2.852217374318107e-11,  1.148296952956359e-11, -1.970126866479085e-13, -3.202701914196576e-15,
  2.284404639177284e-16, -3.753862964166738e-18, -6.696371586839537e-20,  4.451178556012130e-21,  1.526809625137895e-01, -1.385069262830316e-03,  1.227471405233154e-05,
 -9.150760276184215e-08,  9.337065705547611e-12,  2.041522702316327e-11, -3.507277447298082e-13, -5.430092051377993e-15,  3.978671301234668e-16, -6.653150181199845e-18,
 -1.135952232713608e-19,  7.776400205836431e-21,  2.316517081515448e-01, -2.101257868801177e-03,  1.859913208939422e-05, -1.371134324364285e-07, -6.758316449425682e-11,
  3.356359720225144e-11, -5.782271631591674e-13, -8.370346481987659e-15,  6.373184753733922e-16, -1.091795367107809e-17, -1.749599273944928e-19,  1.250476834253568e-20,
  3.300371479259784e-01, -2.993282730673482e-03,  2.645032148465588e-05, -1.919302660972473e-07, -2.593542585308601e-10,  5.303309455368501e-11, -9.185332042658722e-13,
 -1.212162589294343e-14,  9.754731072152641e-16, -1.727459578159478e-17, -2.522599910964469e-19,  1.922629928225809e-20,  4.505875235284559e-01, -4.085842813704863e-03,
  3.601929732534988e-05, -2.554282390363519e-07, -6.722989845915641e-10,  8.271704335058085e-11, -1.446596896298069e-12, -1.674326511342625e-14,  1.464153627514111e-15,
 -2.715370213971727e-17, -3.437290904235883e-19,  2.899272411640959e-20,  5.975620938735818e-01, -5.417087511912491e-03,  4.758900373336160e-05, -3.257929270732787e-07,
 -1.523598740559475e-09,  1.305739722946467e-10, -2.323450524974945e-12, -2.201568940496480e-14,  2.205800486276524e-15, -4.372687116960691e-17, -4.338797847963792e-19,
  4.380934295195220e-20,  7.780869881195559e-01, -7.050574472508837e-03,  6.159792890326621e-05, -3.972290227433385e-07, -3.326913963037292e-09,  2.156678465733599e-10,
 -3.961860603439882e-12, -2.622461137840653e-14,  3.432395469408180e-15, -7.543980940419956e-17, -4.408186014121213e-19,  6.777478410255495e-20,  1.005859077460064e+00,
 -9.107547028075438e-03,  7.876639615744579e-05, -4.485494782712075e-07, -7.642392841541228e-09,  3.979255678127727e-10, -7.794889691948531e-12, -1.777173647130259e-14,
  5.787797385730305e-15, -1.529016755570110e-16,  1.502909435546462e-19,  1.082024460464681e-19,  1.315960134385519e+00, -1.189318903673764e-02,  1.001845644283839e-04,
 -3.592165581640525e-07, -2.257572105841908e-08,  1.017377114666856e-09, -2.354648499305220e-11,  1.508295666880793e-13,  1.130829587151252e-14, -4.858904126632830e-16,
  8.036842717334494e-18,  7.681990688460591e-20,  1.767296322971063e-03, -1.549004857227335e-05,  1.343573016647903e-07, -1.072796199013106e-09,  4.468939070592271e-12,
  1.163416100054299e-13, -3.855558673174121e-15,  3.161201546954900e-17,  1.597782300866096e-18, -6.779262210906808e-20,  9.090241159148383e-22,  1.838177783160577e-23,
  1.594951685920335e-02, -1.397938869486550e-04,  1.212439011640221e-06, -9.673404270179967e-09,  3.989240040629674e-11,  1.066229350621857e-12, -3.520071282873473e-14,
  2.901328828355280e-16,  1.450760273965233e-17, -6.175289501317116e-19,  8.316324387563531e-21,  1.663851394887414e-22,  4.455234045397151e-02, -3.904860196076989e-04,
  3.386112264964315e-06, -2.697273659561922e-08,  1.088989348752389e-10,  3.072391050690482e-12, -1.006747619204446e-13,  8.386983995781057e-16,  4.102717301539501e-17,
 -1.758033944195420e-18,  2.388733367580748e-20,  4.674370681329233e-22,  8.807530570375237e-02, -7.719339678507895e-04,  6.692001551953335e-06, -5.317100405646774e-08,
  2.073339242464465e-10,  6.369584445597316e-12, -2.064369801318993e-13,  1.748403088083711e-15,  8.265530669039155e-17, -3.579639228313340e-18,  4.932376553142768e-20,
  9.314485308127886e-22,  1.473301668640190e-01, -1.291233477870160e-03,  1.118942623275354e-05, -8.857795742764077e-08,  3.275809767184289e-10,  1.137380112647396e-11,
 -3.634554403682976e-13,  3.149890733204085e-15,  1.419111770722869e-16, -6.241820474717289e-18,  8.774059136414329e-20,  1.572254834944458e-21,  2.235338770056237e-01,
 -1.959018765849173e-03,  1.696686379129464e-05, -1.336217563267794e-07,  4.561995643132493e-10,  1.879005845382029e-11, -5.904649535957550e-13,  5.276224129103574e-15,
  2.227300244145376e-16, -1.001353161018603e-17,  1.446665329461767e-19,  2.403941471369583e-21,  3.184726319072809e-01, -2.790890869475120e-03,  2.415320281109334e-05,
 -1.888520973811261e-07,  5.690218237388361e-10,  2.983408114996057e-11, -9.201547957754002e-13,  8.557272000677462e-15,  3.311121552586306e-16, -1.535565715491319e-17,
  2.302352171030693e-19,  3.428028269873243e-21,  4.348009400953037e-01, -3.810018827900954e-03,  3.293786805095255e-05, -2.549128679970377e-07,  6.202427842886163e-10,
  4.672249034700230e-11, -1.413166773125380e-12,  1.384703692292315e-14,  4.760556849276343e-16, -2.310126174191035e-17,  3.644214805497049e-19,  4.588799767023918e-21,
  5.766300587827249e-01, -5.052249697496090e-03,  4.360931867948328e-05, -3.323936953923014e-07,  5.151948789489046e-10,  7.389525294884491e-11, -2.194077405298554e-12,
  2.305382507200282e-14,  6.701206424293840e-16, -3.489483824465336e-17,  5.913771996676742e-19,  5.603673780540131e-21,  7.508391795049800e-01, -6.577469149886414e-03,
  5.663718748694874e-05, -4.211777650849691e-07,  2.956675818125926e-11,  1.216725234245326e-10, -3.563581043839770e-12,  4.129649532186371e-14,  9.231678744814138e-16,
 -5.443975785521135e-17,  1.027382486289497e-18,  5.190753329045749e-21,  9.706528420402166e-01, -8.500485687644936e-03,  7.288014365728569e-05, -5.171800858169797e-07,
 -1.507627469555161e-09,  2.209439182679002e-10, -6.477430921903377e-12,  8.731217397922799e-14,  1.161685960755340e-15, -9.182824670659197e-17,  2.080640051154824e-18,
 -3.860231747425316e-21,  1.269956160755855e+00, -1.111373911889791e-02,  9.428399280382360e-05, -5.863654206473746e-07, -7.386209979837724e-09,  5.299470101023882e-10,
 -1.643305001931039e-11,  2.961671192947521e-13, -3.547781364802162e-16, -1.757491071469696e-16,  6.224576607605545e-18, -9.960144050928666e-20,  1.707406223288384e-03,
 -1.446532282606010e-05,  1.219742798752089e-07, -9.873274812191100e-10,  5.963418745666464e-12,  3.822734178166570e-14, -2.566267997873435e-15,  5.150596779049256e-17,
 -1.088915526111603e-19, -2.726960322804719e-20,  9.039103261695274e-22, -1.122560382735269e-23,  1.540902225691270e-02, -1.305465083730773e-04,  1.100752148345588e-06,
 -8.906963677505316e-09,  5.361988500930897e-11,  3.533274504727117e-13, -2.341497288207134e-14,  4.700459538769383e-16, -1.022914845663049e-18, -2.477650512777443e-19,
  8.234209493612367e-21, -1.027233515644175e-22,  4.304257120209779e-02, -3.646583271250837e-04,  3.074522999234530e-06, -2.486007642936236e-08,  1.486316099287189e-10,
  1.035073136043248e-12, -6.688003270576056e-14,  1.343247474385840e-15, -3.093926421089688e-18, -7.016192091129657e-19,  2.344408669819748e-20, -2.951942199763064e-22,
  8.509069115971088e-02, -7.208857363522221e-04,  6.077240881715310e-06, -4.908308046819401e-08,  2.902391291220273e-10,  2.197174437975597e-12, -1.368537241744100e-13,
  2.751170443374561e-15, -6.883580139173694e-18, -1.416547305037006e-18,  4.774216662241569e-20, -6.099397317464967e-22,  1.423376767691359e-01, -1.205866321045379e-03,
  1.016400885997644e-05, -8.195398441608790e-08,  4.768375433048534e-10,  4.040947035077978e-12, -2.402106357009077e-13,  4.836798800708645e-15, -1.346415664816871e-17,
 -2.439661487331630e-18,  8.326018811389318e-20, -1.085895485498086e-21,  2.159593234021137e-01, -1.829549760393908e-03,  1.541726884617256e-05, -1.240252487009496e-07,
  7.051599785578756e-10,  6.906868449530955e-12, -3.885548162077430e-13,  7.845399941367166e-15, -2.484313174369946e-17, -3.845935430076882e-18,  1.335874864394054e-19,
 -1.791989968289843e-21,  3.076814359599522e-01, -2.606537350252691e-03,  2.195766899558616e-05, -1.760770533592549e-07,  9.685395997845136e-10,  1.137963676097045e-11,
 -6.018092793330937e-13,  1.220735166339921e-14, -4.493243710592663e-17, -5.753251575859006e-18,  2.048583666219157e-19, -2.854014845928779e-21,  4.200688149296702e-01,
 -3.558523200076463e-03,  2.996373991456306e-05, -2.392021700685333e-07,  1.252956534756869e-09,  1.851749077842564e-11, -9.161468646072645e-13,  1.872686896112320e-14,
 -8.197622439638759e-17, -8.348507389361411e-18,  3.081116042413744e-19, -4.518144075390081e-21,  5.570938711611993e-01, -4.719094959805501e-03,  3.971023163190059e-05,
 -3.149385634087204e-07,  1.527016524141510e-09,  3.041380354446666e-11, -1.403758873425007e-12,  2.907119005617228e-14, -1.555587990931164e-16, -1.192774246070538e-17,
  4.649720563912486e-19, -7.321981496386782e-21,  7.254037081357620e-01, -6.144423265223575e-03,  5.165231783396761e-05, -4.054511951385666e-07,  1.712022653822278e-09,
  5.183343704389195e-11, -2.231975510572677e-12,  4.731003737645578e-14, -3.215809873578029e-16, -1.690469624942398e-17,  7.234496345940380e-19, -1.265148260251039e-20,
  9.377774758746518e-01, -7.942393984657618e-03,  6.665009149522431e-05, -5.135245320880160e-07,  1.565458741860823e-09,  9.651938040208197e-11, -3.900576390650684e-12,
  8.655213418647983e-14, -7.977058470320347e-16, -2.308223697731417e-17,  1.210270562141187e-18, -2.516677662873348e-20,  1.226963251435239e+00, -1.038894177596235e-02,
  8.682639919989582e-05, -6.384452200171675e-07, -8.536357284515589e-11,  2.294418899689886e-10, -8.957577514627246e-12,  2.230967602775038e-13, -3.241804126915993e-15,
 -1.135522827235399e-17,  2.235236316830600e-18, -6.961237262533806e-20,  1.651423825641583e-03, -1.353525951993333e-05,  1.107145303574389e-07, -8.886689374702439e-10,
  6.223818500101948e-12, -7.134212279374261e-15, -1.276773416784580e-15,  3.824049493350258e-17, -5.701178155383001e-19, -1.955820065292304e-21,  3.698595497936531e-22,
 -1.054539616510247e-23,  1.490379240318483e-02, -1.221530805055479e-04,  9.991622622700341e-07, -8.018723047201933e-09,  5.608633633627656e-11, -6.059975941558705e-14,
 -1.165499982037375e-14,  3.485575444821061e-16, -5.204392000646520e-18, -1.740148318271118e-20,  3.361031602923683e-21, -9.605377179546866e-23,  4.163129940628853e-02,
 -3.412139304871678e-04,  2.790905285542205e-06, -2.239122476884648e-08,  1.561928923793509e-10, -1.474470936694102e-13, -3.332061759551054e-14,  9.935655265990841e-16,
 -1.488139353289833e-17, -4.710949299678715e-20,  9.521114846984745e-21, -2.734201193257580e-22,  8.230076830310842e-02, -6.745425453555062e-04,  5.517048346362378e-06,
 -4.424090544457179e-08,  3.072923137458480e-10, -2.231449450339753e-13, -6.826979867882741e-14,  2.026921500850418e-15, -3.050881521059494e-17, -8.810705198412386e-20,
  1.923362017172073e-20, -5.565981905400350e-22,  1.376707960350660e-01, -1.128354012355249e-03,  9.228111683205388e-06, -7.394692953412548e-08,  5.104555912283363e-10,
 -2.082628809569111e-13, -1.200105935415168e-13,  3.543365392289377e-15, -5.371484658887286e-17, -1.340410670166229e-19,  3.315219701972607e-20, -9.701437607745504e-22,
  2.088786556581499e-01, -1.711965451874860e-03,  1.399977577612917e-05, -1.120725017298804e-07,  7.669517429969544e-10,  3.268408789081663e-14, -1.944203371902128e-13,
  5.702771757621843e-15, -8.730928819423128e-17, -1.714880270069124e-19,  5.232161598807631e-20, -1.555259432763175e-21,  2.975936163895227e-01, -2.439051497416045e-03,
  1.994299885212819e-05, -1.594330922973020e-07,  1.077918055863005e-09,  7.342176267474446e-13, -3.014840848520674e-13,  8.779607572143787e-15, -1.362604308200456e-16,
 -1.710824786391770e-19,  7.839653038210850e-20, -2.382001869895643e-21,  4.062964721120047e-01, -3.329932942325703e-03,  2.722241750043771e-05, -2.172165759225593e-07,
  1.443470953056244e-09,  2.323168214950180e-12, -4.590686975242097e-13,  1.327232739018596e-14, -2.099382488677646e-16, -6.414295815853066e-20,  1.140346356243172e-19,
 -3.575486228242392e-21,  5.388295536498088e-01, -4.416079154186324e-03,  3.609242914413789e-05, -2.872079011071022e-07,  1.860149534085451e-09,  5.644753908156879e-12,
 -7.021134609435955e-13,  2.017638460075530e-14, -3.279781632825231e-16,  3.280352698574759e-19,  1.635648153459133e-19, -5.377966154006950e-21,  7.016223779429632e-01,
 -5.750138700739356e-03,  4.697720797500869e-05, -3.722519614678019e-07,  2.312561519138923e-09,  1.261002690243735e-11, -1.109249910254063e-12,  3.180153455771797e-14,
 -5.388951293011939e-16,  1.556937408766220e-18,  2.336147434294479e-19, -8.316826953612241e-21,  9.070360311769872e-01, -7.433299106905961e-03,  6.068741875520335e-05,
 -4.773553249131729e-07,  2.738893342652091e-09,  2.861763948594930e-11, -1.904661258739216e-12,  5.505193247408489e-14, -1.000946316785530e-15,  5.913372888079039e-18,
  3.265107761282436e-19, -1.372949451704528e-20,  1.186748528144404e+00, -9.724716622051141e-03,  7.927575164186938e-05, -6.128678762587977e-07,  2.799271846395279e-09,
  7.780601572177364e-11, -4.131825803119392e-12,  1.249932480516218e-13, -2.642242510654204e-15,  3.161925556459354e-17,  2.463798127675857e-19, -2.431878146192670e-20,
  1.598989045256070e-03, -1.269052651178541e-05,  1.006387933319200e-07, -7.915672630190741e-10,  5.850813189407979e-12, -2.697284009559929e-14, -4.563712093571912e-16,
  2.093322867986541e-17, -4.684802002039266e-19,  5.487883775111519e-21,  4.909247288471535e-23, -4.234721487976224e-24,  1.443057856418435e-02, -1.145296013858482e-04,
  9.082408984226378e-07, -7.143255855284547e-09,  5.277072910489504e-11, -2.418599879093594e-13, -4.178854518506071e-15,  1.907276957544854e-16, -4.268949453421131e-18,
  5.013106723772864e-20,  4.422029969830501e-22, -3.848139893468270e-23,  4.030945581539026e-02, -3.199194459114381e-04,  2.536990558884388e-06, -1.995068800914824e-08,
  1.472235105796257e-10, -6.665813040520924e-13, -1.202004989490242e-14,  5.432147758306920e-16, -1.216192255888172e-17,  1.435453443442121e-19,  1.229654091615022e-21,
 -1.090048126072703e-22,  7.968762551812575e-02, -6.324469683540347e-04,  5.015269849044962e-06, -3.943163797923133e-08,  2.904749800989104e-10, -1.289588441135435e-12,
 -2.484917034928152e-14,  1.106672701667949e-15, -2.479052818173316e-17,  2.949332400243180e-19,  2.409731273850620e-21, -2.201841803010618e-22,  1.332996043101153e-01,
 -1.057940907559658e-03,  8.389191673221229e-06, -6.593919989360494e-08,  4.845286520366403e-10, -2.089353094106131e-12, -4.419111294734899e-14,  1.930683887114874e-15,
 -4.329103727524636e-17,  5.208873024463138e-19,  3.966164308880989e-21, -3.794805116972726e-22,  2.022465655543710e-01, -1.605139465743472e-03,  1.272786821077087e-05,
 -1.000009134585542e-07,  7.322654656139307e-10, -3.027230136948090e-12, -7.259286348273897e-14,  3.098073616400524e-15, -6.958270841228393e-17,  8.502415063110754e-19,
  5.839208028999809e-21, -5.988138479601700e-22,  2.881447941043978e-01, -2.286868160228437e-03,  1.813270022818077e-05, -1.423872437398282e-07,  1.037651758849194e-09,
 -4.032778922343557e-12, -1.143596944470429e-13,  4.749075213106531e-15, -1.069645761643634e-16,  1.334417232405933e-18,  7.851211685977876e-21, -8.970562823489085e-22,
  3.933963453118972e-01, -3.122187159349317e-03,  2.475429880682413e-05, -1.942350378381456e-07,  1.406019528668139e-09, -4.971584089812215e-12, -1.771335500124226e-13,
  7.133688767194301e-15, -1.614373576336211e-16,  2.071355237844196e-18,  9.498670956353695e-21, -1.304530939307962e-21,  5.217216072769267e-01, -4.140616239319518e-03,
  3.282574300342757e-05, -2.572866609667963e-07,  1.844345703813744e-09, -5.566794395784957e-12, -2.756713217247240e-13,  1.073889251952280e-14, -2.450068074451842e-16,
  3.268546231900208e-18,  9.292343179365870e-21, -1.870782728553048e-21,  6.793460704425073e-01, -5.391548980107084e-03,  4.273657280043108e-05, -3.344109723605425e-07,
  2.361000837934356e-09, -5.174614744361438e-12, -4.425264416059561e-13,  1.665601613168790e-14, -3.855803997111969e-16,  5.444518188176305e-18,  2.211734060059356e-21,
 -2.672983767730902e-21,  8.782386460735575e-01, -6.969938122552055e-03,  5.523421311732063e-05, -4.309757117058084e-07,  2.961359914311907e-09, -1.954632636528884e-12,
 -7.674417776893685e-13,  2.797998818414601e-14, -6.666452789346288e-16,  1.030830654338118e-17, -3.388059567055476e-20, -3.754140585340873e-21,  1.149072688901044e+00,
 -9.119078347289882e-03,  7.222683397300517e-05, -5.599866317043049e-07,  3.602432522982944e-09,  1.216311592916257e-11, -1.640661623719154e-12,  5.896584621434040e-14,
 -1.510024683630778e-15,  2.790568921957669e-17, -2.800570017412337e-19, -3.244705144606503e-21  };
  constexpr double w[4608] = {  2.499094135756334e-01, -2.944297664936297e-03,  3.865186983078175e-05, -5.315407877929951e-07,  7.380177041335190e-09,
 -1.017981418940126e-10,  1.386548301793393e-12, -1.862493368396003e-14,  2.467846770671005e-16, -3.228614149487320e-18,  4.174239487224210e-20, -5.337602257999374e-22,
  2.389650306104160e-01, -6.185879342045644e-03,  1.649983091123670e-04, -3.973229922995252e-06,  8.827884658214563e-08, -1.844319904526888e-09,  3.666092072091243e-11,
 -6.988175751706649e-13,  1.284560258635129e-14, -2.286694949852879e-16,  3.955035964569597e-18, -6.661968107556212e-20,  2.189614244630325e-01, -1.167774399025376e-02,
  4.940407750223390e-04, -1.741745126662680e-05,  5.426676888433571e-07, -1.539666037853627e-08,  4.051454620461383e-10, -1.001010796052869e-11,  2.342801672041552e-13,
 -5.228256273930231e-15,  1.118166016095268e-16, -2.300189250585015e-18,  1.930003240948698e-01, -1.785152882656721e-02,  1.098415682948180e-03, -5.327899489207440e-05,
  2.199358139710062e-06, -8.039381517163143e-08,  2.666020630476881e-09, -8.151880615062450e-11,  2.324948138215831e-12, -6.238167562130209e-14,  1.585112541988626e-15,
 -3.832412028005369e-17,  1.644212604756669e-01, -2.314745731381265e-02,  1.954998364349283e-03, -1.243541358927940e-04,  6.521920525901833e-06, -2.957532909913631e-07,
  1.193774207155290e-08, -4.373022431909566e-10,  1.474039809982802e-11, -4.619297470224215e-13,  1.356532252422454e-14, -3.754226030228359e-16,  1.359713898585386e-01,
 -2.647062125133851e-02,  2.913329251225141e-03, -2.331513520185294e-04,  1.499690831609560e-05, -8.176375659000184e-07,  3.903860747092053e-08, -1.668527535621480e-09,
  6.484718221422399e-11, -2.318786915725722e-12,  7.698079385761364e-14, -2.388018583728640e-15,  1.093990073558836e-01, -2.735611162142063e-02,  3.742058146817501e-03,
 -3.628909803625903e-04,  2.772793064063805e-05, -1.766944290589578e-06,  9.727573571867165e-08, -4.738368522757017e-09,  2.077533236584453e-10, -8.305379372206156e-12,
  3.057812247153919e-13, -1.044130917698586e-14,  8.546751808620986e-02, -2.587430627281010e-02,  4.214726886496314e-03, -4.783016073253978e-04,  4.213154400831920e-05,
 -3.055862133637136e-06,  1.893882336446953e-07, -1.028564775413990e-08,  4.985439424587434e-10, -2.186549536420405e-11,  8.771495355074945e-13, -3.242738251529682e-14,
  6.421164512024316e-02, -2.241493342467090e-02,  4.182649065429898e-03, -5.375550355639413e-04,  5.304678072642469e-05, -4.268828971415395e-06,  2.910159197261693e-07,
 -1.725269142817501e-08,  9.065842344047417e-10, -4.284055653280408e-11,  1.841294301729585e-12, -7.255000106219031e-14,  4.524211169716554e-02, -1.748073018404498e-02,
  3.606845889188702e-03, -5.089380459774469e-04,  5.472985867542484e-05, -4.766153412362468e-06,  3.493896716650815e-07, -2.214537792951939e-08,  1.237654832514793e-09,
 -6.190852735581765e-11,  2.804423669564824e-12, -1.159889825026150e-13,  2.798344185802181e-02, -1.155603769349171e-02,  2.551731925103032e-03, -3.837621364087690e-04,
  4.377809112141676e-05, -4.025699427466252e-06,  3.102898180405050e-07, -2.059768594176797e-08,  1.201298219665545e-09, -6.250124620669020e-11,  2.936027073023061e-12,
 -1.255669931527298e-13,  1.182942402476036e-02, -5.062297748351216e-03,  1.160037672265391e-03, -1.806954605548382e-04,  2.129695777823578e-05, -2.018400636483132e-06,
  1.599658661802981e-07, -1.089515635038688e-08,  6.506633102483062e-10, -3.460108964232691e-11,  1.658542404102855e-12, -7.226294250955585e-14,  2.387128995141155e-01,
 -2.658733061826259e-03,  3.292009876703330e-05, -4.281001240340330e-07,  5.638939198665944e-09, -7.398350306641641e-11,  9.601933882966288e-13, -1.230606599930567e-14,
  1.557144378459146e-16, -1.946956397389432e-18,  2.407102487854249e-20, -2.945177225579090e-22,  2.165900784253750e-01, -5.035118777445284e-03,  1.247155650731351e-04,
 -2.813958499243118e-06,  5.881749498887496e-08, -1.159452296388137e-09,  2.179980893054253e-11, -3.938652458036183e-13,  6.874652098085588e-15, -1.163863410926136e-16,
  1.917151325411184e-18, -3.079576181718535e-20,  1.790127165142511e-01, -8.434238494172549e-03,  3.284489886293002e-04, -1.075193797342362e-05,  3.130051431334912e-07,
 -8.336734507011390e-09,  2.066968609839112e-10, -4.826533044647229e-12,  1.070367102550381e-13, -2.268515051328157e-15,  4.616998067557988e-17, -9.055208981398639e-19,
  1.358274908557978e-01, -1.112630114155074e-02,  6.266007097249888e-04, -2.812343719706142e-05,  1.082450556142420e-06, -3.709993967038569e-08,  1.158725614928013e-09,
 -3.349169454096448e-11,  9.057698935936188e-13, -2.310887933000935e-14,  5.597065225350628e-16, -1.292788103357731e-17,  9.567836518319134e-02, -1.206827530757176e-02,
  9.346486337910273e-04, -5.512676428358501e-05,  2.701817974864609e-06, -1.151711135235874e-07,  4.390569666783617e-09, -1.525024284274931e-10,  4.890674927168159e-12,
 -1.462465238143936e-13,  4.108974922721686e-15, -1.090609247751208e-16,  6.344040852506533e-02, -1.125278317678645e-02,  1.145428350144409e-03, -8.559553958767807e-05,
  5.177417323694787e-06, -2.669163571026223e-07,  1.210548934407718e-08, -4.933551822789561e-10,  1.834397484747964e-11, -6.293647321376104e-13,  2.009963207666154e-14,
 -6.012329254237849e-16,  4.019281906745238e-02, -9.337280553310626e-03,  1.196908031909971e-03, -1.095580369379332e-04,  7.947044956582939e-06, -4.830359882766384e-07,
  2.546533786865419e-08, -1.191890425207943e-09,  5.036197955444128e-11, -1.945342149806025e-12,  6.936517431473592e-14, -2.298863378680876e-15,  2.466385300314764e-02,
 -7.076365546002568e-03,  1.096973944673017e-03, -1.190480376881316e-04,  1.007072969446225e-05, -7.040345934243860e-07,  4.218669714561088e-08, -2.221248697119238e-09,
  1.046287793491062e-10, -4.469018854935797e-12,  1.749274219668234e-13, -6.321080813717174e-15,  1.477219007113154e-02, -4.977613149908709e-03,  8.978347260062673e-04,
 -1.118612178974934e-04,  1.073065701043779e-05, -8.415072284625810e-07,  5.602656645293039e-08, -3.250122038095786e-09,  1.674021369591617e-10, -7.765748694949372e-12,
  3.281138594864433e-13, -1.272525152476351e-14,  8.570636946754570e-03, -3.245456420384415e-03,  6.563476152228650e-04, -9.090550713151136e-05,  9.610230517320006e-06,
 -8.239118706762598e-07,  5.953685028116812e-08, -3.724128177642882e-09,  2.056165414454352e-10, -1.017025492070323e-11,  4.559465382834861e-13, -1.867742681738491e-14,
  4.581006569066121e-03, -1.874457178675265e-03,  4.100191131443737e-04, -6.111882990549019e-05,  6.915081729374507e-06, -6.310792065172141e-07,  4.830206272121870e-08,
 -3.185687786138445e-09,  1.846850329981584e-10, -9.555544326991413e-12,  4.465651595963799e-13, -1.900728041138340e-14,  1.777894606120442e-03, -7.585660738964312e-04,
  1.732765874743953e-04, -2.690827849914026e-05,  3.162261670236247e-06, -2.988834930454256e-07,  2.362685005242415e-08, -1.605317549706534e-09,  9.565176329541277e-11,
 -5.075643755303832e-12,  2.427972733466016e-13, -1.055840189558533e-14,  2.285741799111806e-01, -2.414492149533682e-03,  2.827916478004085e-05, -3.485701575626602e-07,
  4.364462884185369e-09, -5.456933261715471e-11,  6.760382714527549e-13, -8.281450450878786e-15,  1.002384086934606e-16, -1.199882228084615e-18,  1.420831811292813e-20,
 -1.666215979889360e-22,  1.982516658132340e-01, -4.158060542598669e-03,  9.591211925915245e-05, -2.033311215574997e-06,  4.008089733819303e-08, -7.471380197817572e-10,
  1.331350136554335e-11, -2.284065217681924e-13,  3.791836052375654e-15, -6.114631128301868e-17,  9.606382817830987e-19, -1.473513298340234e-20,  1.498192440802415e-01,
 -6.248725762282710e-03,  2.247344018669337e-04, -6.848040682938750e-06,  1.866520993035228e-07, -4.675089802589835e-09,  1.093811813418292e-10, -2.417100114699558e-12,
  5.085068723081035e-14, -1.024548699565753e-15,  1.986096784610417e-17, -3.716614053393443e-19,  9.956251455854538e-02, -7.216942806711263e-03,  3.726950889071692e-04,
 -1.549767544518350e-05,  5.567370725367584e-07, -1.790635998401214e-08,  5.270548448575087e-10, -1.440721618414170e-11,  3.695990492807197e-13, -8.968082355066825e-15,
  2.070624188683215e-16, -4.568981759308373e-18,  5.901608986505352e-02, -6.646242092852666e-03,  4.717173110755574e-04, -2.578616791228889e-05,  1.180499612722390e-06,
 -4.728006743557017e-08,  1.701401896972199e-09, -5.600146099605124e-11,  1.707536584353914e-12, -4.868850069458134e-14,  1.307781442214110e-15, -3.326302841731236e-17,
  3.180969858077341e-02, -5.112099906642665e-03,  4.798306844697407e-04, -3.340356851755011e-05,  1.896182234218664e-06, -9.226724081627793e-08,  3.968046442317513e-09,
 -1.539469138972213e-10,  5.467400609189016e-12, -1.796990110789376e-13,  5.512208717698323e-15, -1.587526339132179e-16,  1.596758464643280e-02, -3.423099840772595e-03,
  4.092819260213378e-04, -3.522804700925175e-05,  2.418022994388895e-06, -1.397792143465807e-07,  7.037996249298310e-09, -3.157403092448144e-10,  1.282751683194201e-11,
 -4.777191156018378e-13,  1.646326432458068e-14, -5.285207093651867e-16,  7.667366093117468e-03, -2.071118544520553e-03,  3.039608556222234e-04, -3.140813982285435e-05,
  2.541948298944934e-06, -1.707031354145246e-07,  9.859668648378340e-09, -5.019020350612525e-10,  2.291622284068161e-11, -9.509970513930412e-13,  3.624079079736197e-14,
 -1.277414215718175e-15,  3.612228129211993e-03, -1.168615377588891e-03,  2.028174522441002e-04, -2.439872764654064e-05,  2.267263407120135e-06, -1.727271354970551e-07,
  1.119973353271396e-08, -6.341279712696566e-10,  3.194070569170523e-11, -1.451521549450624e-12,  6.017187878728414e-14, -2.292903153754874e-15,  1.692128982940091e-03,
 -6.257817058953182e-04,  1.236440573902143e-04, -1.676130035877853e-05,  1.737535423761810e-06, -1.463189363538465e-07,  1.040127171673048e-08, -6.409078649850364e-10,
  3.490004504880383e-11, -1.704387680832487e-12,  7.551670317057348e-14, -3.060074901957318e-15,  7.660414977006092e-04, -3.100635398047076e-04,  6.707794151624056e-05,
 -9.895966928967928e-06,  1.109014388245699e-06, -1.003260316587972e-07,  7.617118588516709e-09, -4.986547095007581e-10,  2.871107231700551e-11, -1.476111056700534e-12,
  6.858000010512846e-14, -2.903163487914192e-15,  2.691675467996058e-04, -1.144507886449699e-04,  2.604893243088351e-05, -4.031100885503237e-06,  4.721824488197112e-07,
 -4.449139405462986e-08,  3.506914624251966e-09, -2.376308572569539e-10,  1.412304845740237e-11, -7.476277619954301e-13,  3.568262236578891e-14, -1.548414633927668e-15,
  2.193437599813593e-01, -2.203880649536005e-03,  2.448195039053141e-05, -2.866610843015350e-07,  3.418260192210124e-09, -4.080083780995304e-11,  4.832770377022834e-13,
 -5.668124518987873e-15,  6.572720265526547e-17, -7.544973235153089e-19,  8.568806105992628e-21, -9.648202738799855e-23,  1.830135097124781e-01, -3.478493257296190e-03,
  7.491787644738609e-05, -1.496149556976753e-06,  2.787845557427009e-08, -4.924444053315952e-10,  8.332288096540060e-12, -1.359752670435014e-13,  2.150510952170217e-15,
 -3.308158701412424e-17,  4.963884762635567e-19, -7.280229089693138e-21,  1.279629883056107e-01, -4.735068761670121e-03,  1.577972174056146e-04, -4.487079338500384e-06,
  1.147431670021954e-07, -2.707508514980350e-09,  5.987104083416438e-11, -1.253774427147104e-12,  2.505287775122878e-14, -4.803862024645179e-16,  8.878175278850781e-18,
 -1.586511987125621e-19,  7.566284103410140e-02, -4.851185524649884e-03,  2.302536109910124e-04, -8.884059992994586e-06,  2.982492828744713e-07, -9.010981650035433e-09,
  2.501625593466446e-10, -6.471475103324721e-12,  1.575615894796381e-13, -3.637452962034387e-15,  8.008290624107503e-17, -1.688429502020689e-18,  3.839280600672155e-02,
 -3.848853458577667e-03,  2.503647943746485e-04, -1.268409150985041e-05,  5.423791178151104e-07, -2.040719293954052e-08,  6.930553768510285e-10, -2.161042900066247e-11,
  6.262443368514959e-13, -1.701917830882620e-14,  4.367948503676977e-16, -1.063987446305081e-17,  1.707807804217837e-02, -2.473751261321742e-03,  2.135964768286794e-04,
 -1.382687649499492e-05,  7.354446310292097e-07, -3.372778113780594e-08,  1.373505805708876e-09, -5.065793191112599e-11,  1.716119089860456e-12, -5.396184415277605e-14,
  1.587753207028503e-15, -4.396861593734462e-17,  6.855022100799798e-03, -1.347052290329421e-03,  1.495771700285019e-04, -1.206456833313880e-05,  7.812750550276289e-07,
 -4.283894245231683e-08,  2.055038628800507e-09, -8.816659480109789e-11,  3.436589990407992e-12, -1.231419305723244e-13,  4.093533282373403e-15, -1.270588934218961e-16,
  2.575414473856343e-03, -6.503740916223728e-04,  8.988657284365023e-05, -8.804577115973655e-06,  6.791529122704247e-07, -4.366338712753639e-08,  2.423548034390837e-09,
 -1.189405024861584e-10,  5.250534312789648e-12, -2.111900075835468e-13,  7.817933407868050e-15, -2.682349895884846e-16,  9.440125793862303e-04, -2.914502215914562e-04,
  4.842386143875032e-05, -5.600427960925141e-06,  5.022305888708992e-07, -3.704531345921743e-08,  2.332304881725688e-09, -1.285393102212865e-10,  6.315861472939454e-12,
 -2.805313112008347e-13,  1.138602918571433e-14, -4.254785478994743e-16,  3.501201552596214e-04, -1.259313605059583e-04,  2.421884386105479e-05, -3.202869958331579e-06,
  3.246297836694832e-07, -2.678280281169422e-08,  1.868622979640048e-09, -1.131880950573652e-10,  6.067561582807951e-12, -2.920697400549693e-13,  1.276971129722706e-14,
 -5.111433799831071e-16,  1.313062202067492e-04, -5.246661131372073e-05,  1.120378992601861e-05, -1.633010426953114e-06,  1.809859413021907e-07, -1.620706893968669e-08,
  1.219084336081216e-09, -7.912740162140466e-11,  4.520203122025284e-12, -2.307152581040186e-13,  1.064740729168401e-14, -4.479508825340494e-16,  4.109416300526622e-05,
 -1.740392285427422e-05,  3.944608451513962e-06, -6.080020068084710e-07,  7.095213024404145e-08, -6.662121665078423e-09,  5.234111086706369e-10, -3.535852404325075e-11,
  2.095452302766733e-12, -1.106292370078073e-13,  5.266800367608938e-15, -2.280079998087005e-16,  2.108993980444172e-01, -2.020913186217992e-03,  2.134514536327660e-05,
 -2.379168463362526e-07,  2.706504423320682e-09, -3.089193177196253e-11,  3.503596376342026e-13, -3.940771007132577e-15,  4.383530853825569e-17, -4.834227432414138e-19,
  5.270083194035852e-21, -5.711834150677431e-23,  1.701943155179339e-01, -2.944066312573639e-03,  5.934736731865723e-05, -1.119187510485278e-06,  1.975689712571312e-08,
 -3.313583839413289e-10,  5.333454730416510e-12, -8.293002477752443e-14,  1.251444222690483e-15, -1.839139204300194e-17,  2.639305522742339e-19, -3.705960439012959e-21,
  1.112456600507567e-01, -3.660522157753268e-03,  1.134044566635646e-04, -3.016807291845442e-06,  7.252681246396066e-08, -1.615109468723265e-09,  3.380883378852791e-11,
 -6.718855350852818e-13,  1.276784564000684e-14, -2.332589378705253e-16,  4.114118325505319e-18, -7.026847920532455e-20,  5.936577859667860e-02, -3.366314053180425e-03,
  1.472396083256885e-04, -5.280332567179457e-06,  1.658927060301049e-07, -4.713775730428650e-09,  1.235520025475706e-10, -3.027218582716522e-12,  6.999716124083854e-14,
 -1.538306924940455e-15,  3.230823752748632e-17, -6.510607428378834e-19,  2.621293754776749e-02, -2.333269677237496e-03,  1.392050209653956e-04, -6.538646342417782e-06,
  2.612328002646369e-07, -9.235385273244798e-09,  2.960217471721030e-10, -8.743860948996633e-12,  2.407864235468841e-13, -6.235411982630176e-15,  1.528619275412264e-16,
 -3.564699887620253e-18,  9.776792388171272e-03, -1.270267806574697e-03,  1.007263359168998e-04, -6.055099894990818e-06,  3.014310906738251e-07, -1.301443272480999e-08,
  5.013238917903937e-10, -1.755877318333649e-11,  5.667814810435667e-13, -1.703157983400813e-14,  4.801604436924330e-16, -1.277093815837301e-17,  3.175052213106203e-03,
 -5.681447643933044e-04,  5.836077570448335e-05, -4.397586929417420e-06,  2.679692549385483e-07, -1.390417626351837e-08,  6.340905373078991e-10, -2.596236718364310e-11,
  9.690096943700663e-13, -3.334562579741809e-14,  1.067319672832792e-15, -3.197439408404273e-17,  9.366067597465199e-04, -2.195002568979582e-04,  2.841714334081279e-05,
 -2.627263114378803e-06,  1.924331802565192e-07, -1.180508005734268e-08,  6.277919522544305e-10, -2.962244619943512e-11,  1.261063455887286e-12, -4.904636100323972e-14,
  1.759768439139986e-15, -5.864828077958613e-17,  2.650521698291027e-04, -7.756653382693485e-05,  1.227031400176144e-05, -1.358039501924000e-06,  1.170579523586286e-07,
 -8.330339171101649e-09,  5.076202625474906e-10, -2.715318325477795e-11,  1.298092960289649e-12, -5.621829815231954e-14,  2.229075580949184e-15, -8.151772897408603e-17,
  7.638458850423602e-05, -2.659050246685497e-05,  4.956125629783764e-06, -6.370168724980704e-07,  6.292088014124518e-08, -5.071064537213715e-09,  3.463513802151056e-10,
 -2.057564366716299e-11,  1.083517580682986e-12, -5.131089017178825e-14,  2.209884683435425e-15, -8.724013651925616e-17,  2.316587153570870e-05, -9.115052288416764e-06,
  1.916763404590894e-06, -2.754380361915161e-07,  3.013330007062404e-08, -2.666675805367974e-09,  1.984314916340214e-10, -1.275305099550058e-11,  7.219574134787255e-13,
 -3.654386770556468e-14,  1.673599660664856e-15, -6.991511994160643e-17,  6.334972980522345e-06, -2.670480076315004e-06,  6.023371389348012e-07, -9.241467326195687e-08,
  1.073827735461101e-08, -1.004259099196228e-09,  7.860711831118781e-11, -5.291880782218191e-12,  3.126020486592545e-13, -1.645409042006551e-14,  7.811314828318623e-16,
 -3.372714740641718e-17,  2.031401668602351e-01, -1.860880025570934e-03,  1.873096281130831e-05, -1.991334726317813e-07,  2.164570319755940e-09, -2.366362991262938e-11,
  2.573039137155863e-13, -2.780253251009803e-15,  2.969124042547779e-17, -3.153454048586788e-19,  3.296923506004604e-21, -3.460755727454174e-23,  1.592895250037418e-01,
 -2.518096592364233e-03,  4.761563434186004e-05, -8.498549300565470e-07,  1.424270620899723e-08, -2.272408324357528e-10,  3.485397550797811e-12, -5.172026542856940e-14,
  7.458103710606656e-16, -1.048584492558532e-17,  1.441091715812213e-19, -1.939714967009702e-21,  9.821370472382128e-02, -2.880563196001838e-03,  8.322650547244768e-05,
 -2.076364110220197e-06,  4.702428736303623e-08, -9.900395070839484e-10,  1.964933918245599e-11, -3.710996388815199e-13,  6.715119381673193e-15, -1.170210858037914e-16,
  1.971806531086648e-18, -3.221969711991649e-20,  4.791047095290535e-02, -2.402975160251676e-03,  9.714305490309961e-05, -3.243984553706969e-06,  9.552342331236548e-08,
 -2.556029957532032e-09,  6.332264261324571e-11, -1.470872600116961e-12,  3.232572287436873e-14, -6.767336232576774e-16,  1.356619501444666e-17, -2.614129600634724e-19,
  1.869472920014306e-02, -1.474316859140926e-03,  8.077985707686158e-05, -3.520442771987230e-06,  1.314912343216892e-07, -4.369862802460006e-09,  1.322382088445309e-10,
 -3.700867140080311e-12,  9.685349571305209e-14, -2.389892443451310e-15,  5.595777562466041e-17, -1.249007014326711e-18,  5.941314549698051e-03, -6.893492670888324e-04,
  5.014904785316543e-05, -2.797213257277720e-06,  1.302323824239334e-07, -5.289866490713044e-09,  1.926051073895887e-10, -6.401284665524179e-12,  1.967246366609243e-13,
 -5.644566399590345e-15,  1.523403183269955e-16, -3.888040387624981e-18,  1.582591770446732e-03, -2.562302631912101e-04,  2.426680264954046e-05, -1.703787695710692e-06,
  9.747489472741563e-08, -4.776380157499080e-09,  2.066845555936946e-10, -8.061730248124872e-12,  2.876206716112716e-13, -9.489306908130006e-15,  2.919738924299921e-16,
 -8.428691407054203e-18,  3.691635446359625e-04, -7.968217235110249e-05,  9.613404812157693e-06, -8.354257447367591e-07,  5.789728795577679e-08, -3.378430768513744e-09,
  1.716438078784611e-10, -7.766237758745027e-12,  3.180515779857436e-13, -1.193332946742464e-14,  4.140868800262041e-16, -1.337731564980824e-17,  8.033743894188974e-05,
 -2.211999155324170e-05,  3.312301514194166e-06, -3.491251259311688e-07,  2.880471988611361e-08, -1.970411230236524e-09,  1.158303949051899e-10, -5.995627064434895e-12,
  2.781114832924552e-13, -1.171440432195088e-14,  4.527021945633802e-16, -1.616683776770354e-17,  1.768626149298568e-05, -5.924729617939819e-06,  1.064971478606040e-06,
 -1.324731597663201e-07,  1.270464104334252e-08, -9.969866679205762e-10,  6.646620423545591e-11, -3.862482812568350e-12,  1.993427528558930e-13, -9.267288941417302e-15,
  3.924087137472958e-16, -1.525123042735312e-17,  4.227229222512889e-06, -1.632825766720910e-06,  3.371585348029675e-07, -4.764575563930626e-08,  5.133915488434808e-09,
 -4.481090001937436e-10,  3.292901320668699e-11, -2.092272541088593e-12,  1.172137471069694e-13, -5.876566253750663e-15,  2.667725706401513e-16, -1.105483694917449e-17,
  9.876662058512033e-07, -4.140631625376390e-07,  9.286462427604976e-08, -1.417179992799758e-08,  1.638548600761097e-09, -1.525361642027372e-10,  1.188885901572667e-11,
 -7.972135660464471e-13,  4.692072560511565e-14, -2.461302998702763e-15,  1.164750898643966e-16, -5.014176337233558e-18,  1.959819943866464e-01, -1.720035879480299e-03,
  1.653456080015963e-05, -1.679756663691841e-07,  1.747258494846725e-09, -1.832478586800296e-11,  1.912174087858017e-13, -1.989027424926789e-15,  2.038622977454754e-17,
 -2.095705969187831e-19,  2.086232084678646e-21, -2.157990023585791e-23,  1.499194480508716e-01, -2.174408677817598e-03,  3.864818078124130e-05, -6.542331697459448e-07,
  1.042967358879931e-08, -1.585852437776820e-10,  2.321665083855416e-12, -3.292923290170366e-14,  4.543991658499190e-16, -6.120396385289940e-18,  8.065416146654569e-20,
 -1.041948606641097e-21,  8.788153588023898e-02, -2.302980337805655e-03,  6.224534011430441e-05, -1.459900108490204e-06,  3.120844053433383e-08, -6.222727991139906e-10,
  1.172796497208127e-11, -2.107914312068993e-13,  3.636781777167736e-15, -6.052313478994054e-17,  9.753324535980921e-19, -1.526155491263798e-20,  3.963847520026496e-02,
 -1.758970182896150e-03,  6.593222358607357e-05, -2.054157061352095e-06,  5.678493683333832e-08, -1.432866329084988e-09,  3.359167455243308e-11, -7.404884302851516e-13,
  1.548164347387913e-14, -3.089778601203320e-16,  5.915956216502400e-18, -1.090675276633395e-19,  1.386534602051895e-02, -9.669679612808645e-04,  4.874911675866473e-05,
 -1.973138900693067e-06,  6.895897385809436e-08, -2.155766279176649e-09,  6.162272530997484e-11, -1.634650106847673e-12,  4.066666157549382e-14, -9.563212920112690e-16,
  2.138773297828563e-17, -4.569217406891760e-19,  3.814862333207160e-03, -3.936665807091793e-04,  2.626682447705401e-05, -1.358907719988641e-06,  5.915194563451029e-08,
 -2.259557299312202e-09,  7.773046117420492e-11, -2.450202766888697e-12,  7.165153257107352e-14, -1.961855639042603e-15,  5.065459326370197e-17, -1.239673668005380e-18,
  8.461277661503850e-04, -1.231905433694641e-04,  1.072744888688185e-05, -7.003028675399827e-07,  3.754769593094822e-08, -1.734663224378521e-09,  7.111243106380764e-11,
 -2.638362694606141e-12,  8.984449226979621e-14, -2.837774769006341e-15,  8.381440881960599e-17, -2.328239129538078e-18,  1.576861006941774e-04, -3.110614185448356e-05,
  3.480295501593366e-06, -2.831897516065845e-07,  1.850851443843561e-08, -1.024289215652605e-09,  4.958370362132855e-11, -2.145948979792227e-12,  8.434597280538462e-14,
 -3.046249173839334e-15,  1.020156814916804e-16, -3.188270247004575e-18,  2.639450880742599e-05, -6.782521709334349e-06,  9.555977521595942e-07, -9.544813031590810e-08,
  7.505787724300379e-09, -4.916905779074936e-10,  2.778976310906313e-11, -1.387709652613006e-12,  6.228222543198640e-14, -2.544899696571296e-15,  9.562374023333276e-17,
 -3.327312532735938e-18,  4.376015071065293e-06, -1.401261190012019e-06,  2.415564611612864e-07, -2.894233534917578e-08,  2.683981567508153e-09, -2.043461519830218e-10,
  1.325512460326810e-11, -7.513378502296304e-13,  3.790522360739944e-14, -1.725889862764720e-15,  7.169663684700608e-17, -2.738037796339134e-18,  8.024017689743366e-07,
 -3.031059638397033e-07,  6.124473013161403e-08, -8.485532762621729e-09,  8.981671740800716e-10, -7.714275080644726e-11,  5.586681564391951e-12, -3.502983927329936e-13,
  1.938898110744864e-14, -9.614113930047843e-16,  4.320538597804208e-17, -1.773894906847011e-18,  1.560390324136372e-07, -6.498907508156187e-08,  1.447801691502863e-08,
 -2.195604335680910e-09,  2.523892366592576e-10, -2.337052864020266e-11,  1.812608101096103e-12, -1.209962028860988e-13,  7.091583979369071e-15, -3.705594532133342e-16,
  1.747267713501890e-17, -7.496711038260782e-19,  1.893542738473888e-01, -1.595373293351539e-03,  1.467525423287935e-05, -1.427198419521736e-07,  1.422497194791361e-09,
 -1.433660300066889e-11,  1.436283354878144e-13, -1.442973003895252e-15,  1.413882776137421e-17, -1.425445881316364e-19,  1.321834453895068e-21, -1.373165792888721e-23,
  1.417941727131839e-01, -1.894012377664065e-03,  3.170298118849936e-05, -5.099909100218517e-07,  7.748187189284220e-09, -1.124697553773994e-10,  1.574063566703941e-12,
 -2.137079931562152e-14,  2.825851124249330e-16, -3.651268441540422e-18,  4.619178558868595e-20, -5.733888849632052e-22,  7.956543862969212e-02, -1.867459705687917e-03,
  4.735642304010288e-05, -1.046628956991050e-06,  2.115992740393468e-08, -4.002502435624119e-10,  7.174470205106058e-12, -1.228865807189133e-13,  2.024110828818902e-15,
 -3.220503612211270e-17,  4.969056142277738e-19, -7.452835802060039e-21,  3.352064826271252e-02, -1.316591119227126e-03,  4.591279714328494e-05, -1.337212670652723e-06,
  3.476116843823082e-08, -8.283390697277673e-10,  1.839992552337956e-11, -3.853444177851117e-13,  7.671773754147996e-15, -1.460868858674408e-16,  2.673565690827975e-18,
 -4.718880029929198e-20,  1.065023632769960e-02, -6.557513228106068e-04,  3.049206311761031e-05, -1.147634436830069e-06,  3.756944238368035e-08, -1.105766299231550e-09,
  2.987858268829542e-11, -7.516669757713217e-13,  1.778411329218620e-14, -3.986958364748416e-16,  8.518853357268730e-18, -1.742166264452899e-19,  2.576082309035240e-03,
 -2.355456299636850e-04,  1.442144899022961e-05, -6.920265967418341e-07,  2.816469790906521e-08, -1.011733782217672e-09,  3.287901066877433e-11, -9.827504447252943e-13,
  2.733798380423849e-14, -7.140259057767215e-16,  1.762953576096425e-17, -4.135066488325150e-19,  4.833547084805886e-04, -6.291130022315906e-05,  5.027091292107612e-06,
 -3.046431330011517e-07,  1.528670383150595e-08, -6.649921548965595e-10,  2.579475155201375e-11, -9.092002592448676e-13,  2.951577957039553e-14, -8.914255784486439e-16,
  2.524225633724055e-17, -6.739051862299301e-19,  7.290600528790851e-05, -1.304234627317018e-05,  1.347274183462597e-06, -1.022917037569955e-07,  6.286316265635945e-09,
 -3.290753512351530e-10,  1.514122872169082e-11, -6.253935668707617e-13,  2.354092339439040e-14, -8.167182229355877e-16,  2.634471367839468e-17, -7.950114397010956e-19,
  9.429349852325804e-06, -2.241847079946739e-06,  2.953683413483628e-07, -2.781912868829597e-08,  2.076253373021528e-09, -1.297651623745233e-10,  7.027827973531788e-12,
 -3.375264994033813e-13,  1.461609663652320e-14, -5.778422861944607e-16,  2.105961963442855e-17, -7.123711520447510e-19,  1.165053398591186e-06, -3.538689740510561e-07,
  5.813935357955652e-08, -6.674971416588925e-09,  5.958870932510081e-10, -4.384398272820029e-11,  2.757555449639026e-12, -1.519881428602652e-13,  7.474521071753499e-15,
 -3.324693453486986e-16,  1.351845420904294e-17, -5.061962090838898e-19,  1.594982745872149e-07, -5.864482662379176e-08,  1.154687337280568e-08, -1.562877925314507e-09,
  1.619928443344564e-10, -1.365363184048687e-11,  9.721317130018268e-13, -6.002447631509357e-14,  3.276256666356716e-15, -1.604001364842653e-16,  7.124971420880169e-18,
 -2.894392047325610e-19,  2.504274205528530e-08, -1.034787973204997e-08,  2.286868362517942e-09, -3.442347016687454e-10,  3.930173958449629e-11, -3.616629647179937e-12,
  2.789092161239227e-13, -1.852072969500644e-14,  1.080285097435688e-15, -5.619831678364339e-17,  2.638999422032887e-18, -1.127972058715332e-19,  1.831972569959470e-01,
 -1.484455532148055e-03,  1.309028494219209e-05, -1.220793266140043e-07,  1.167208618275430e-09, -1.132763987271378e-11,  1.088542839613054e-13, -1.063503773221188e-15,
  9.829970870077732e-18, -9.993290413467218e-20,  8.536483385691140e-22, -7.502940424112969e-24,  1.346893771566612e-01, -1.662919143934033e-03,  2.625882024313483e-05,
 -4.021490023930779e-07,  5.832906707138037e-09, -8.096081842512413e-11,  1.084801757914565e-12, -1.411862186001929e-14,  1.791140141957962e-16, -2.223064791165669e-18,
  2.703359521564633e-20, -3.225858540691760e-22,  7.278115215476412e-02, -1.533643926473121e-03,  3.659146141145484e-05, -7.638053363611722e-07,  1.463182211422958e-08,
 -2.629821230976906e-10,  4.490194928158175e-12, -7.338895652136615e-14,  1.155608657123951e-15, -1.759696964907105e-17,  2.602595125430938e-19, -3.745869929011267e-21,
  2.889912501423764e-02, -1.005139485604254e-03,  3.272539007904667e-05, -8.927998172141133e-07,  2.186155360712348e-08, -4.926862774975393e-10,  1.038320129917950e-11,
 -2.068234337859637e-13,  3.925065422519273e-15, -7.137537344779228e-17,  1.249579087518235e-18, -2.113037633408150e-20,  8.440375061311813e-03, -4.581413705392482e-04,
  1.970642141601262e-05, -6.906325857795227e-07,  2.120377208871653e-08, -5.881682516275621e-10,  1.503583259004571e-11, -3.589865976338978e-13,  8.082224487027358e-15,
 -1.728161947712001e-16,  3.529075823913966e-18, -6.910658122412178e-20,  1.821138441176317e-03, -1.470299543573970e-04,  8.270216404563855e-06, -3.682344291171598e-07,
  1.401746067713041e-08, -4.736290649146129e-10,  1.454212261398702e-11, -4.121656016311690e-13,  1.090586427570624e-14, -2.716695954357243e-16,  6.412647230617735e-18,
 -1.441102786207975e-19,  2.937583744566878e-04, -3.398802296467168e-05,  2.489222276381616e-06, -1.398748582841103e-07,  6.562710813440240e-09, -2.685750703023691e-10,
  9.848574868910906e-12, -3.294891489148470e-13,  1.018740416810696e-14, -2.939121989666849e-16,  7.971339522511523e-18, -2.043249383723711e-19,  3.640506748610716e-05,
 -5.860555346107139e-06,  5.568088500878954e-07, -3.932876083689667e-08,  2.266853962177978e-09, -1.119892299993090e-10,  4.887291587326182e-12, -1.922646002820865e-13,
  6.917664213656221e-15, -2.301184613709933e-16,  7.136971478431049e-18, -2.076011650732943e-19,  3.670148448666901e-06, -7.999805311499234e-07,  9.796764899753739e-08,
 -8.658756233459535e-09,  6.108312082384361e-10, -3.629205016844670e-11,  1.877274653574501e-12, -8.645488161093267e-14,  3.602214527760783e-15, -1.374354234860161e-16,
  4.846589819977861e-18, -1.590131542440794e-19,  3.360183644210328e-07, -9.596057695736290e-08,  1.492418534068881e-08, -1.632660818024660e-09,  1.396360281472800e-10,
 -9.887457930292487e-12,  6.007357944572856e-13, -3.208907390019533e-14,  1.533676005871269e-15, -6.646102373509731e-17,  2.638428131812281e-18, -9.664787898711657e-20,
  3.345723263230329e-08, -1.190428707581225e-08,  2.272525658139000e-09, -2.991954276832706e-10,  3.025626368588549e-11, -2.494534989525754e-12,  1.741263487269865e-13,
 -1.056111653204506e-14,  5.671993533112677e-16, -2.736412371602733e-17,  1.199346399358583e-18, -4.813002419699628e-20,  4.095426746247218e-09, -1.675988123838068e-09,
  3.668302811567801e-10, -5.472891010533490e-11,  6.198180959636410e-12, -5.662004234127721e-13,  4.337408090911995e-14, -2.862731072743501e-15,  1.660503098965210e-16,
 -8.594117294308336e-18,  4.016699523057216e-19, -1.709390758528516e-20,  1.774600280084570e-01, -1.385291923152235e-03,  1.173034239549800e-05, -1.050839905420019e-07,
  9.645392320392320e-10, -9.040031389098447e-12,  8.298303081945927e-14, -8.004347366399272e-16,  6.787032149615765e-18, -7.019039234325756e-20,  6.943870871497089e-22,
  8.960667935885153e-25,  1.284293667874131e-01, -1.470679676540149e-03,  2.194379818926920e-05, -3.204852802236982e-07,  4.445080329778973e-09, -5.908887614462343e-11,
  7.590337727643075e-13, -9.483617523901172e-15,  1.155614969475357e-16, -1.379148064254285e-18,  1.615855320364597e-20, -1.849938154966368e-22,  6.717912625468726e-02,
 -1.273959914975874e-03,  2.867410761692567e-05, -5.665484409283241e-07,  1.030273046456390e-08, -1.762182010263382e-10,  2.870436269595334e-12, -4.481903376705768e-14,
  6.756679682556186e-16, -9.856664770699430e-18,  1.398251518273942e-19, -1.936691473447888e-21,  2.534182803244010e-02, -7.809141646764327e-04,  2.382436178265696e-05,
 -6.100460234270313e-07,  1.409512262575152e-08, -3.008586011562571e-10,  6.023810671581505e-12, -1.142499089960558e-13,  2.069146752790733e-15, -3.596443260704510e-17,
  6.027702887241477e-19, -9.775845217832605e-21,  6.877729851854224e-03, -3.286546305627786e-04,  1.312149724136125e-05, -4.288292845090852e-07,  1.236459766236092e-08,
 -3.236062400304221e-10,  7.834278843468353e-12, -1.776569373954289e-13,  3.808794492258584e-15, -7.772012418129306e-17,  1.517566535918310e-18, -2.846693472864502e-20,
  1.341924276511451e-03, -9.534439565782043e-05,  4.936675321065088e-06, -2.040876088807284e-07,  7.271238668734280e-09, -2.312020579503289e-10,  6.709193658006274e-12,
 -1.803557099887907e-13,  4.539796526245405e-15, -1.078601239915940e-16,  2.433878573700804e-18, -5.239780278856448e-20,  1.890740837683206e-04, -1.934123609488965e-05,
  1.297874429862419e-06, -6.758154583401659e-08,  2.963286658661256e-09, -1.140254420674728e-10,  3.950491714192840e-12, -1.253674588392639e-13,  3.689268243657205e-15,
 -1.016019677312167e-16,  2.637254182265797e-18, -6.484989487530031e-20,  1.957176038100586e-05, -2.813648439870812e-06,  2.451142723846564e-07, -1.606635811531848e-08,
  8.667274980304287e-10, -4.033323795545712e-11,  1.666496406209434e-12, -6.233452749034118e-14,  2.140206482976686e-15, -6.815297468381647e-17,  2.029068479469899e-18,
 -5.680266200561416e-20,  1.557459219125641e-06, -3.082771305332305e-07,  3.488891857295170e-08, -2.880594359551864e-09,  1.913410893294624e-10, -1.077047302205229e-11,
  5.304748599792760e-13, -2.335963266167450e-14,  9.340086846778241e-16, -3.430439483963740e-17,  1.167785280133054e-18, -3.707953243771252e-20,  1.056365777406097e-07,
 -2.808499335710514e-08,  4.104649202312079e-09, -4.253419212318998e-10,  3.467738373935306e-11, -2.352736249931062e-12,  1.375526188699121e-13, -7.096004858153460e-15,
  3.285623602743029e-16, -1.383124218559571e-17,  5.346763398752845e-19, -1.911324592396550e-20,  7.471024568963890e-09, -2.553949289111874e-09,  4.698652588040318e-10,
 -5.987013251743444e-11,  5.881512155404814e-12, -4.725725385706592e-13,  3.223513546917660e-14, -1.915021487309473e-15,  1.009424160201787e-16, -4.788020129370756e-18,
  2.066444957422252e-19, -8.177166926800072e-21,  6.851551736317053e-10, -2.770562514718080e-10,  5.993030686198017e-11, -8.845805475999346e-12,  9.921681757069573e-13,
 -8.984772729331159e-14,  6.828851741346232e-15, -4.475039055231716e-16,  2.578892053965175e-17, -1.326832299725933e-18,  6.167658729050118e-20, -2.611704600802793e-21,
  1.720989125192235e-01, -1.296243934815125e-03,  1.055629455548279e-05, -9.099676456163557e-08,  8.019567884876271e-10, -7.294980474914280e-12,  6.327120303815909e-14,
 -6.180451050174607e-16,  4.799809797092236e-18, -3.826871316105452e-20,  9.896363190195733e-22,  1.285077738908275e-23,  1.228749880556997e-01, -1.309387326799964e-03,
  1.848868024926787e-05, -2.579117478108389e-07,  3.425942067919692e-09, -4.368247052379120e-11,  5.386052895143643e-13, -6.469596119972304e-15,  7.582700968216892e-17,
 -8.696604807316996e-19,  9.874715170887957e-21, -1.078518207841001e-22,  6.250264598944633e-02, -1.069204523162600e-03,  2.275934068631296e-05, -4.265431879659390e-07,
  7.376985478834958e-09, -1.202367462336815e-10,  1.871686600910483e-12, -2.794271424934967e-14,  4.038904733181734e-16, -5.656349213891232e-18,  7.672826517621438e-20,
 -1.032129326597293e-21,  2.255786556664306e-02, -6.161787793815417e-04,  1.768114092336850e-05, -4.257732752139146e-07,  9.298683121176424e-09, -1.882417031927490e-10,
  3.586023733120235e-12, -6.482673161470382e-14,  1.121707777417353e-15, -1.865828449861210e-17,  2.993702707026158e-19, -4.667277853779713e-21,  5.744638204023169e-03,
 -2.413362912631563e-04,  8.977969573151791e-06, -2.740297589006201e-07,  7.431332930396286e-09, -1.837236270595466e-10,  4.216816051024012e-12, -9.090158527830723e-14,
  1.857279870814409e-15, -3.619337165400397e-17,  6.760251531087237e-19, -1.215601951991790e-20,  1.026414135966631e-03, -6.397147470124522e-05,  3.057340295583653e-06,
 -1.174531145314743e-07,  3.920102071114255e-09, -1.173780155860381e-10,  3.221039438358869e-12, -8.215674588158706e-14,  1.967873443601286e-15, -4.460185156436850e-17,
  9.622029379952868e-19, -1.984520262845308e-20,  1.282842692003161e-04, -1.154107274743217e-05,  7.100363339527548e-07, -3.425217108850297e-08,  1.403431575174624e-09,
 -5.076629556070604e-11,  1.661299533207618e-12, -4.999108687869528e-14,  1.399574550651592e-15, -3.677499907805556e-17,  9.130569888806918e-19, -2.152580242477825e-20,
  1.128471174144854e-05, -1.437824566869067e-06,  1.146030481515757e-07, -6.957475701897241e-09,  3.507313452157203e-10, -1.535093181391132e-11,  5.996582784833396e-13,
 -2.129669154895777e-14,  6.967929669615469e-16, -2.121151984809069e-17,  6.053928181656377e-19, -1.628813792845214e-20,  7.200980417378148e-07, -1.281663181244394e-07,
  1.333487097750749e-08, -1.024272215002944e-09,  6.384003040703122e-11, -3.394010143514780e-12,  1.587191080286741e-13, -6.665422478701502e-15,  2.551191213442148e-16,
 -8.998986634182680e-18,  2.950620047914211e-19, -9.047599524831243e-21,  3.638891105565155e-08, -8.908133266245096e-09,  1.214219321267823e-09, -1.184628280777943e-10,
  9.159536215950997e-12, -5.927905130575868e-13,  3.321760291484063e-14, -1.649029482194883e-15,  7.372972629345152e-17, -3.006052843473033e-18,  1.128445411667167e-19,
 -3.926575885430854e-21,  1.793134270995015e-09, -5.837642858728479e-10,  1.027704583977490e-10, -1.259930446485363e-11,  1.196433007189316e-12, -9.328660069424179e-14,
  6.195149913233998e-15, -3.593147247185059e-16,  1.853495085146877e-17, -8.621627862125475e-19,  3.655595896599631e-20, -1.423455375149968e-21,  1.178501567761456e-10,
 -4.694571780828853e-11,  1.000841708801806e-11, -1.458057223002633e-12,  1.616409222980124e-13, -1.448574533809380e-14,  1.090725614664258e-15, -7.087636203842514e-17,
  4.053435028556645e-18, -2.071070462142088e-19,  9.566501040068451e-21, -4.027632795537292e-22,  1.670762157120765e-01, -1.215953871151267e-03,  9.536758448275048e-06,
 -7.925573208478996e-08,  6.699259323231880e-10, -5.967747364436829e-12,  4.797099964075791e-14, -4.775517935080909e-16,  4.300035275514780e-18,  1.567813213455583e-20,
  1.762464463615209e-21,  1.997541031273922e-23,  1.179148897593270e-01, -1.172987913703385e-03,  1.569591718247691e-05, -2.094405316860114e-07,  2.668188416439293e-09,
 -3.268195287410990e-11,  3.872147933531201e-13, -4.476189491342308e-15,  5.062240945139500e-17, -5.549157028358747e-19,  6.178054816606328e-21, -6.432285509159713e-23,
  5.856017035570934e-02, -9.057654553183263e-04,  1.827689432515805e-05, -3.255505773660701e-07,  5.364901333772599e-09, -8.341353806212216e-11,  1.243379706705563e-12,
 -1.776278130066479e-14,  2.460515570949935e-16, -3.336538706773655e-18,  4.262630185472490e-20, -5.667427511402964e-22,  2.034691825014550e-02, -4.928960669175784e-04,
  1.335391658944817e-05, -3.029882288347054e-07,  6.266068270545980e-09, -1.204497936992812e-10,  2.186834056365439e-12, -3.771737386921982e-14,  6.238683405711805e-16,
 -9.961721112790088e-18,  1.525654353943952e-19, -2.296169507259263e-21,  4.904640030735971e-03, -1.808920297148316e-04,  6.297470692745683e-06, -1.797838120795348e-07,
  4.592936093152399e-09, -1.073873660620540e-10,  2.339675952518898e-12, -4.798874950797298e-14,  9.350938146921873e-16, -1.742349542069275e-17,  3.112866097615272e-19,
 -5.371605335945998e-21,  8.118195290429915e-04, -4.423878197701373e-05,  1.958503250681184e-06, -6.998253045567791e-08,  2.190586339336248e-09, -6.181686513099517e-11,
  1.605355748727875e-12, -3.887255067402115e-14,  8.863867272158080e-16, -1.917321082421094e-17,  3.954952015809339e-19, -7.816346282487588e-21,  9.132980925799942e-05,
 -7.188283867094765e-06,  4.061402978863148e-07, -1.815191423632968e-08,  6.951912793030504e-10, -2.364185515212860e-11,  7.307715625549326e-13, -2.084930162890971e-14,
  5.552095061648527e-16, -1.391540437987271e-17,  3.303543385182298e-19, -7.463959486363149e-21,  6.947571347331107e-06, -7.786626961112282e-07,  5.672318139494558e-08,
 -3.185016112163974e-09,  1.498703049106077e-10, -6.162900584483512e-12,  2.273625436527759e-13, -7.658465893801539e-15,  2.385176047954200e-16, -6.933338904675212e-18,
  1.894816106276728e-19, -4.893974603469399e-21,  3.620357824740715e-07, -5.736101570868420e-08,  5.462202615734759e-09, -3.889251163268835e-10,  2.267716228378020e-11,
 -1.135604425957213e-12,  5.029717065103451e-14, -2.009635245832648e-15,  7.346667328021063e-17, -2.483481687946702e-18,  7.826912108849923e-20, -2.313098977984397e-21,
  1.378837509110933e-08, -3.070948800404168e-09,  3.874193037480025e-10, -3.537318080751502e-11,  2.580781186808878e-12, -1.586205741552922e-13,  8.485587467022329e-15,
 -4.039249380541023e-16,  1.738198110510429e-17, -6.843029943367258e-19,  2.487521911437564e-20, -8.403425079471679e-22,  4.673725861962056e-10, -1.433608875652463e-10,
  2.395255458752771e-11, -2.806492151761564e-12,  2.561708419390230e-13, -1.928954139938522e-14,  1.241961595473244e-15, -7.006679150343865e-17,  3.525563221072144e-18,
 -1.603534977540586e-19,  6.662170936545803e-21, -2.546773304402901e-22,  2.097625760337985e-11, -8.197929277263702e-12,  1.716335444256942e-12, -2.460454391598005e-13,
  2.689136386839696e-14, -2.379734657182805e-15,  1.771865264414152e-16, -1.139874850397526e-17,  6.460400845886283e-19, -3.274093094633147e-20,  1.501199220709322e-21,
 -6.277956925090529e-23,  1.623592107050207e-01, -1.143290544813290e-03,  8.646254745176527e-06, -6.943345733278618e-08,  5.610854126203749e-10, -4.960303405729798e-12,
  3.671717376389891e-14, -3.157314570616117e-16,  6.321296482225248e-18,  1.005726081450360e-19,  2.329537031307741e-21, -1.507735855264933e-24,  1.134591182781566e-01,
 -1.056794569559912e-03,  1.341873340578705e-05, -1.715132420995531e-07,  2.098202410143959e-09, -2.472662789155595e-11,  2.818676261074222e-13, -3.133237595697101e-15,
  3.448735862559431e-17, -3.563088078684426e-19,  3.923364953432690e-21, -4.072373808036950e-23,  5.520670227881886e-02, -7.738345090706149e-04,  1.483509062797388e-05,
 -2.515913642777208e-07,  3.958922205396679e-09, -5.875132557776224e-11,  8.402858362644412e-13, -1.152532418216723e-14,  1.514189415183674e-16, -2.044312279922115e-18,
  2.385483786718391e-20, -3.081238645540958e-22,  1.856815567591357e-02, -3.990699868577441e-04,  1.024844882430148e-05, -2.194738207832142e-07,  4.306761240198235e-09,
 -7.867658465463121e-11,  1.363704762738798e-12, -2.248640052214652e-14,  3.544630322056655e-16, -5.484096131578968e-18,  7.956670489260579e-20, -1.153332151350737e-21,
  4.269738826512226e-03, -1.380380601016248e-04,  4.518877449370346e-06, -1.208305563150567e-07,  2.913167821906635e-09, -6.448191660571979e-11,  1.335402010004032e-12,
 -2.609491490381363e-14,  4.848098136828466e-16, -8.661546186177422e-18,  1.478592744254986e-19, -2.449023542604804e-21,  6.616142261170799e-04, -3.141606750729510e-05,
  1.294102840507370e-06, -4.305007971489157e-08,  1.265579761899912e-09, -3.368755672294759e-11,  8.286699993180443e-13, -1.906393887504500e-14,  4.139462920909201e-16,
 -8.552851158283444e-18,  1.686989285049136e-19, -3.195559594145998e-21,  6.792169883237188e-05, -4.651962751652616e-06,  2.420721203053124e-07, -1.002613413450876e-08,
  3.591519185287714e-10, -1.148648396478781e-11,  3.354511569996297e-13, -9.075436397569130e-15,  2.298679145454229e-16, -5.495395011092848e-18,  1.247197167763624e-19,
 -2.699908289199206e-21,  4.545679638181216e-06, -4.447425274772456e-07,  2.961599751019437e-08, -1.536578097647206e-09,  6.745022870813640e-11, -2.604122767620785e-12,
  9.066752221432259e-14, -2.894407542065627e-15,  8.573709028504002e-17, -2.377806317777548e-18,  6.216816888540931e-20, -1.539983273795462e-21,  1.973013371431317e-07,
 -2.754230476370720e-08,  2.392351512945030e-09, -1.574311936481008e-10,  8.566217046349335e-12, -4.031464320823432e-13,  1.687559524878250e-14, -6.402177100631514e-16,
  2.231040624865172e-17, -7.213927831715780e-19,  2.181248439253848e-20, -6.201621852092587e-22,  5.759833686011354e-09, -1.152085997301802e-09,  1.335420999947571e-10,
 -1.134530778355191e-11,  7.772926612397726e-13, -4.517873815829339e-14,  2.298567340151583e-15, -1.045495805403936e-16,  4.316270882478794e-18, -1.635890878867243e-19,
  5.742404881045088e-21, -1.878461156131376e-22,  1.336898613794194e-10, -3.814385056734208e-11,  5.992164166595231e-12, -6.660277223180968e-13,  5.807456115087676e-14,
 -4.200816684041652e-15,  2.610164263503445e-16, -1.426549017696313e-17,  6.976445904358333e-19, -3.092671987891002e-20,  1.255392167161366e-21, -4.699021726593561e-23,
  3.895914118165742e-12, -1.485503164249720e-12,  3.039763031741528e-13, -4.271259663364898e-14,  4.587324795335062e-15, -3.997715429897037e-16,  2.936509267560054e-17,
 -1.866521697561601e-18,  1.046571252515872e-19, -5.253044374622676e-21,  2.387700875431700e-22, -9.907075194240031e-24,  1.579193175511170e-01, -1.077307939249474e-03,
  7.863791633035018e-06, -6.120440559115790e-08,  4.701099961332362e-10, -4.158351805706754e-12,  3.137557403556891e-14, -3.867156356053659e-17,  1.144485125128276e-17,
  1.741259847802830e-19,  7.789111789836220e-22, -7.966851600821191e-23,  1.094343637233636e-01, -9.571419628444056e-04,  1.154679655458245e-05, -1.415584352391696e-07,
  1.664809782619593e-09, -1.890071776667955e-11,  2.078558723609641e-13, -2.207839556549933e-15,  2.409079484311388e-17, -2.312366363754165e-19,  2.409926264750343e-21,
 -2.970930784402773e-23,  5.233101558499934e-02, -6.662360333717618e-04,  1.216054641829754e-05, -1.966537697485528e-07,  2.961988056288841e-09, -4.197145532569683e-11,
  5.755246181920731e-13, -7.696442888041155e-15,  9.223789608664941e-17, -1.306464794275548e-18,  1.430153140259089e-20, -1.337572662682354e-22,  1.712068038800107e-02,
 -3.265547123531462e-04,  7.981511695057362e-06, -1.615687725650993e-07,  3.015442380927102e-09, -5.238404599549342e-11,  8.670718324332769e-13, -1.377490719849283e-14,
  2.039633932864416e-16, -3.116768371067074e-18,  4.304166841268870e-20, -5.664339024464238e-22,  3.781707824044053e-03, -1.069823415011458e-04,  3.311047386173382e-06,
 -8.301582418747015e-08,  1.892813639940128e-09, -3.969906067011378e-11,  7.821258965670317e-13, -1.461018331369723e-14,  2.578212095111628e-16, -4.442169050900334e-18,
  7.253236085730118e-20, -1.141845702150149e-21,  5.538101300004276e-04, -2.283039856787686e-05,  8.798258704807052e-07, -2.726802082085371e-08,  7.541509671826478e-10,
 -1.895207219949621e-11,  4.419442494476721e-13, -9.674315241703737e-15,  1.999158161633648e-16, -3.952311562517603e-18,  7.457642865052652e-20, -1.352281537460930e-21,
  5.254303174396824e-05, -3.113943836538361e-06,  1.498683860296295e-07, -5.753599937016306e-09,  1.929765706797166e-10, -5.807165187398611e-12,  1.602979559243937e-13,
 -4.114534141241277e-15,  9.911599371510358e-17, -2.260936873359326e-18,  4.905441113579298e-20, -1.017177287711256e-21,  3.145291949161177e-06, -2.665311799277650e-07,
  1.625276472465101e-08, -7.786478683888676e-10,  3.188343017284922e-11, -1.155328543210276e-12,  3.794747488641789e-14, -1.147611149730208e-15,  3.231317945412128e-17,
 -8.545268571845352e-19,  2.135969157647393e-20, -5.070782842112347e-22,  1.160756421379627e-07, -1.412526766210808e-08,  1.117012012059465e-09, -6.777000933881202e-11,
  3.434841450758474e-12, -1.516488119475616e-13,  5.989252757384350e-15, -2.153843130331063e-16,  7.143040940392944e-18, -2.205643676721855e-19,  6.388095588986833e-21,
 -1.744504338706434e-22,  2.653487969209015e-09, -4.701015043075864e-10,  4.974032551246590e-11, -3.911198896277922e-12,  2.505287337492501e-13, -1.371677898325785e-14,
  6.613566935117706e-16, -2.865001910753012e-17,  1.131283909812825e-18, -4.115920397966109e-20,  1.391397104781408e-21, -4.396083503868111e-23,  4.239242805436351e-11,
 -1.108059479455826e-11,  1.620031455439951e-12, -1.694472929582839e-13,  1.402046117259638e-14, -9.687029856568448e-16,  5.779818530764638e-17, -3.046777254491356e-18,
  1.442509591021564e-19, -6.210707717274441e-21,  2.455370711555594e-22, -8.973302332708157e-24,  7.632471438149694e-13, -2.817561663779448e-13,  5.599876948980955e-14,
 -7.673478749218003e-15,  8.064794469345421e-16, -6.897281255718712e-17,  4.983656092709812e-18, -3.122105350844753e-19,  1.728194433079479e-20, -8.575253836776489e-22,
  3.857828076275105e-23, -1.585943668575470e-24,  1.537314274508372e-01, -1.017213601159349e-03,  7.171858293380463e-06, -5.430661709890061e-08,  3.946239763674960e-10,
 -3.371147891527086e-12,  3.635538139809852e-14,  4.249231918196980e-16,  1.710752790244231e-17,  9.930509014191029e-20, -5.463116800844064e-21, -2.075600028125330e-22,
  1.057803896838989e-01, -8.711366334840601e-04,  9.996266720081941e-06, -1.176940933502763e-07,  1.332093248586520e-09, -1.457398684413776e-11,  1.556958838703045e-13,
 -1.553986944779504e-15,  1.719982377114635e-17, -1.595926206725061e-19,  1.196565092266450e-21, -2.628222110831302e-23,  4.984675352565866e-02, -5.776446442035955e-04,
  1.005959499541534e-05, -1.552946988363707e-07,  2.244782253306808e-09, -3.045108381124291e-11,  3.950097518517582e-13, -5.395809881828009e-15,  5.448445526003555e-17,
 -8.085131663084653e-19,  1.162244199304778e-20,  6.740961379734382e-24,  1.593094796992754e-02, -2.697105989118103e-04,  6.300928884496655e-06, -1.206915680427980e-07,
  2.148028683524951e-09, -3.555803348804271e-11,  5.580028464016017e-13, -8.752941945403105e-15,  1.177706474850014e-16, -1.783490035787817e-18,  2.600740574440140e-20,
 -2.374474741667279e-22,  3.401100876003107e-03, -8.401822150045270e-05,  2.473326495238508e-06, -5.818679300031947e-08,  1.257663687632204e-09, -2.503470263108419e-11,
  4.679937406596535e-13, -8.443464252673746e-15,  1.400211861408181e-16, -2.332860647556929e-18,  3.733584237031677e-20, -5.318134613123656e-22,  4.747492096744239e-04,
 -1.692100025192248e-05,  6.141428726286064e-07, -1.773823755915896e-08,  4.624795823423140e-10, -1.098652151176576e-11,  2.427533975069231e-13, -5.076790976395727e-15,
  9.957089166690173e-17, -1.886132517212629e-18,  3.422344564883877e-20, -5.891095383435938e-22,  4.211184368224243e-05, -2.146320027795355e-06,  9.610193934458784e-08,
 -3.419660510274871e-09,  1.075492907638484e-10, -3.047652560566963e-12,  7.952462972059525e-14, -1.939403560965046e-15,  4.440994663499982e-17, -9.670643121802739e-19,
  2.007710901714644e-20, -3.982760271883074e-22,  2.290309888384715e-06, -1.666932865944004e-07,  9.342089775188558e-09, -4.130187998069493e-10,  1.578316414403180e-11,
 -5.367971599039555e-13,  1.662947946542579e-14, -4.764465140239381e-16,  1.274606799849147e-17, -3.213089275896049e-19,  7.675740892149040e-21, -1.745197319558284e-22,
  7.336474032409052e-08, -7.696193514482580e-09,  5.540681788970417e-10, -3.093132182571591e-11,  1.458549415159482e-12, -6.033226565662727e-14,  2.245176412189160e-15,
 -7.643973828785612e-17,  2.409323801042447e-18, -7.095105923192164e-20,  1.965685632456449e-21, -5.148924641897369e-23,  1.346093411040772e-09, -2.081254552246560e-10,
  1.999726360964412e-11, -1.448556709884923e-12,  8.641891448490956e-14, -4.441729884517483e-15,  2.023100888779279e-16, -8.322288776403264e-18,  3.134217597452654e-19,
 -1.091727238850253e-20,  3.545154567124995e-22, -1.079186470378169e-23,  1.503293759945612e-11, -3.536404231153370e-12,  4.760913502990045e-13, -4.647005553333388e-14,
  3.623609476734742e-15, -2.377283006821390e-16,  1.355006596324882e-17, -6.857612885263103e-19,  3.130285291505558e-20, -1.304082168133069e-21,  5.004225652988759e-23,
 -1.780071997457800e-24,  1.599286612491354e-13, -5.654766312894876e-14,  1.082548643709792e-14, -1.437168837143850e-15,  1.470287559462074e-16, -1.228632503458098e-17,
  8.700774005020950e-19, -5.355695894466972e-20,  2.918957603643048e-21, -1.428604407777022e-22,  6.348696342163841e-24, -2.581485604201594e-25,  1.497733406737787e-01,
 -9.623429061584801e-04,  6.556005185066950e-06, -4.847942777194203e-08,  3.372167286704510e-10, -2.292669310069367e-12,  5.604051804447663e-14,  9.674953549087506e-16,
  1.424886333800464e-17, -3.329422760131087e-19, -1.665637894068101e-20, -2.722121811701879e-22,  1.024473225611018e-01, -7.964743893756764e-04,  8.702819508496222e-06,
 -9.852315202434292e-08,  1.074756007898607e-09, -1.130226468285399e-11,  1.190789297323995e-13, -1.088518248932439e-15,  1.204112207977040e-17, -1.344106800320753e-19,
  7.906072700596001e-23, -2.376949313918220e-23,  4.768613096451001e-02, -5.040546298672441e-04,  8.392996001011881e-06, -1.237833996187479e-07,  1.719241136132838e-09,
 -2.261046167802979e-11,  2.646131232370740e-13, -4.025777769160656e-15,  3.410367805667089e-17, -3.075705406692231e-19,  1.398824642675827e-20,  8.174300576305581e-23,
  1.494450694674656e-02, -2.245618051261965e-04,  5.037518763237330e-06, -9.136111788147309e-08,  1.552910899806168e-09, -2.473367538998266e-11,  3.573619010073637e-13,
 -5.827350328632929e-15,  7.035017161971294e-17, -8.908368504499474e-19,  1.986556996940584e-20, -6.802050071843206e-23,  3.100616339135648e-03, -6.671694422584941e-05,
  1.881074911909833e-06, -4.153163593142841e-08,  8.524600103236124e-10, -1.620184717563248e-11,  2.835027038406543e-13, -5.057627279760783e-15,  7.823696372269650e-17,
 -1.205864561959039e-18,  2.110118132758362e-20, -2.433417147343792e-22,  4.157012901844604e-04, -1.274835730684887e-05,  4.393383005811549e-07, -1.182243037608539e-08,
  2.911211166632417e-10, -6.560602794246656e-12,  1.366301940536769e-13, -2.756038928775738e-15,  5.116202099847433e-17, -9.193802378166834e-19,  1.646488297910749e-20,
 -2.627745799700045e-22,  3.484024121912652e-05, -1.516434721174603e-06,  6.367091293020256e-08, -2.098733720627693e-09,  6.199476549721864e-11, -1.657485371874526e-12,
  4.081734068166182e-14, -9.490840923391673e-16,  2.064428587353000e-17, -4.283928728952250e-19,  8.555125459978983e-21, -1.616636157283231e-22,  1.746759273043042e-06,
 -1.081830669965005e-07,  5.606345844963340e-09, -2.285161174524472e-10,  8.157228203960324e-12, -2.605757709449341e-13,  7.609277157473054e-15, -2.067172190170493e-16,
  5.252381182180521e-18, -1.261525399075400e-19,  2.881723649090589e-21, -6.268956728461055e-23,  4.955366041818728e-08, -4.427377062764555e-09,  2.909097089209434e-10,
 -1.491660136825738e-11,  6.540641148314223e-13, -2.532989253919763e-14,  8.872492609367689e-16, -2.857665067845932e-17,  8.551461657845040e-19, -2.399125360223149e-20,
  6.351755385100859e-22, -1.593974236835127e-23,  7.495031473727124e-10, -9.953376376195238e-11,  8.657913461365200e-12, -5.754016300399112e-13,  3.187416338805229e-14,
 -1.533505697692818e-15,  6.580305760238645e-17, -2.563864439504121e-18,  9.186261484453809e-20, -3.056118364187267e-21,  9.510854525167449e-23, -2.783207030097466e-24,
  6.001189262985612e-12, -1.244890840845510e-12,  1.527298653052586e-13, -1.379642642953328e-14,  1.006966583676080e-15, -6.235959882084555e-17,  3.377798717018259e-18,
 -1.633565908728362e-19,  7.158755610292751e-21, -2.874598364709283e-22,  1.066907598313199e-23, -3.681982806610280e-25,  3.647737763010715e-14, -1.216871525222303e-14,
  2.219600431726525e-15, -2.830972819025597e-16,  2.800387183243374e-17, -2.274056865222062e-18,  1.571210270811416e-19, -9.466633320322610e-21,  5.063702818559037e-22,
 -2.437686686896344e-23,  1.067550119251372e-24, -4.284634247182330e-26,  1.460253062498598e-01, -9.121331154939724e-04,  6.005375400187030e-06, -4.336776418544816e-08,
  3.072081191729141e-10, -5.873113721637641e-13,  8.666962001024830e-14,  1.081904268130820e-15, -1.223411594153240e-17, -1.189325210878351e-18, -2.393380221111578e-20,
  4.190873375735486e-23,  9.939357362438361e-02, -7.313048300419454e-04,  7.616735201612453e-06, -8.298977609775029e-08,  8.750268737933583e-10, -8.771068887670961e-12,
  9.326068194421028e-14, -7.818939142678363e-16,  7.034078525225509e-18, -1.488770875360091e-19, -6.743605328936870e-22, -5.653901800095968e-24,  4.579541032219846e-02,
 -4.424169391498985e-04,  7.058737591233966e-06, -9.958435834306535e-08,  1.322017099890902e-09, -1.749529445161562e-11,  1.663130536434826e-13, -2.997272722654712e-15,
  3.384346870710534e-17,  3.059744497636773e-19,  1.569806186005001e-20, -5.834074923773448e-23,  1.412046683170517e-02, -1.882594225227407e-04,  4.075308780800625e-06,
 -7.005715799073597e-08,  1.131996329862844e-09, -1.788487048607806e-11,  2.219555941550981e-13, -3.940966043774081e-15,  5.196205401510519e-17, -1.486612914227884e-19,
  1.695251184850495e-20, -1.105887166730013e-22,  2.860986989415078e-03, -5.345243929730216e-05,  1.454915418703617e-06, -3.015840289201044e-08,  5.863045878383232e-10,
 -1.084899456119093e-11,  1.714668789531317e-13, -3.103960378171975e-15,  4.783517353841940e-17, -5.348158610337884e-19,  1.315936247124198e-20, -1.460743706741005e-22,
  3.709387260503550e-04, -9.730875180528607e-06,  3.215994412871094e-07, -8.059283348189310e-09,  1.872908745006261e-10, -4.049042843301235e-12,  7.819710242487847e-14,
 -1.540752405260873e-15,  2.760299380251971e-17, -4.423492270093932e-19,  8.373711971709978e-21, -1.259445287718665e-22,  2.965460430016127e-05, -1.093157606150077e-06,
  4.349426719783333e-08, -1.326643331136765e-09,  3.682163791611308e-11, -9.343038642447682e-13,  2.157426375269728e-14, -4.809284369185909e-16,  9.987789019070419e-18,
 -1.946615878006873e-19,  3.801651547544310e-21, -6.841474429492495e-23,  1.389042246658988e-06, -7.242246509913849e-08,  3.502750046300736e-09, -1.314432113424815e-10,
  4.385972774721858e-12, -1.319342042386810e-13,  3.623567895331418e-15, -9.351923725229160e-17,  2.259023992152578e-18, -5.154461319891072e-20,  1.129374007565947e-21,
 -2.348707947648672e-23,  3.557349992190738e-08, -2.670331072259619e-09,  1.611019679559668e-10, -7.572536319188063e-12,  3.087327882616793e-13, -1.119705117554364e-14,
  3.687197513186287e-16, -1.123310657860700e-17,  3.189552892478718e-19, -8.515043746482150e-21,  2.153558064694007e-22, -5.172189499104425e-24,  4.559095949472578e-10,
 -5.109415984822691e-11,  4.024149371332809e-12, -2.444848433366298e-13,  1.254675218122506e-14, -5.638448766267075e-16,  2.274100311926616e-17, -8.375055877924274e-19,
  2.848877296596302e-20, -9.033088046369627e-22,  2.688693088951307e-23, -7.548239669983670e-25,  2.706954918438571e-12, -4.837361869359070e-13,  5.360510854743506e-14,
 -4.446011534199040e-15,  3.018058249060459e-16, -1.754408469283827e-17,  8.985479708585681e-19, -4.133617920608416e-20,  1.731795994542737e-21, -6.676856229307756e-23,
  2.388262003530257e-24, -7.969783219208891e-26,  9.253636903956945e-15, -2.851472587397600e-15,  4.887120023014718e-16, -5.925845943347949e-17,  5.621182298984948e-18,
 -4.406148205717597e-19,  2.953778488044048e-20, -1.733884349611783e-21,  9.066492996990086e-23, -4.278672140215013e-24,  1.841176898742107e-25, -7.275627210893529e-27,
  1.424696816163173e-01, -8.660883168644878e-04,  5.514457670584987e-06, -3.842445223846582e-08,  3.182968072601546e-10,  1.766216100144739e-12,  1.038176645439007e-13,
 -1.615017074427439e-16, -6.958998834628696e-17, -1.850782865050467e-18, -1.225099693456053e-21,  1.120574948859663e-21,  9.658423422972219e-02, -6.741290276152142e-04,
  6.699446116827362e-06, -7.027815648549921e-08,  7.203244853873957e-10, -6.775230226814946e-12,  7.367701657602699e-14, -6.474651744381690e-16,  1.252781366112849e-18,
 -1.664657700804272e-19,  2.483592388678836e-22,  5.654916127875960e-23,  4.413158816329966e-02, -3.903928149547657e-04,  5.979722246791689e-06, -8.104062087279388e-08,
  1.005919202034621e-09, -1.437422670527517e-11,  1.000079484229154e-13, -1.629006409686716e-15,  5.441931619486881e-17,  7.528519755366772e-19,  2.651434394003601e-21,
 -6.024395658552486e-22,  1.342771074124305e-02, -1.587372700753226e-04,  3.332333633791217e-06, -5.455152322769984e-08,  8.195962852882202e-10, -1.369478809422368e-11,
  1.349390578832176e-13, -2.247042358562936e-15,  5.691473309119596e-17,  3.469721494900669e-19,  5.086324411694497e-21, -4.841099001836995e-22,  2.668368905132986e-03,
 -4.311641699861659e-05,  1.142790085314145e-06, -2.231640820445180e-08,  4.042676310130171e-10, -7.618221710786800e-12,  1.037418497457608e-13, -1.792608704039001e-15,
  3.644200935936023e-17, -1.465408347435009e-19,  5.726379039436988e-21, -2.172508036753397e-22,  3.366128699840994e-04, -7.499540311920097e-06,  2.404897769275670e-07,
 -5.621547139626426e-09,  1.220439176101483e-10, -2.602842305177969e-12,  4.543202606858232e-14, -8.573074505207029e-16,  1.653824589905230e-17, -2.010680580189975e-19,
  3.980938195213405e-21, -8.530580058572204e-23,  2.588952978360788e-05, -8.001245787717408e-07,  3.057280568495460e-08, -8.628552457535563e-10,  2.238521188474166e-11,
 -5.475531246315670e-13,  1.170869705517092e-14, -2.491309997051964e-16,  5.117918753133394e-18, -8.950520299254479e-20,  1.716654639526816e-21, -3.216960017647160e-23,
  1.146860432485812e-06, -4.969048652008206e-08,  2.272593013965392e-09, -7.841457805915173e-11,  2.440777050086301e-12, -6.966890122429549e-14,  1.790251612906320e-15,
 -4.388630562120868e-17,  1.017279926326540e-18, -2.180300150604290e-20,  4.596641853505279e-22, -9.263932832234864e-24,  2.699378386376281e-08, -1.675375154355580e-09,
  9.378816907996313e-11, -4.032838929411481e-12,  1.527521778216594e-13, -5.201987351675972e-15,  1.606951398899243e-16, -4.630391578314936e-18,  1.249209314804117e-19,
 -3.165041953990378e-21,  7.649889427640843e-23, -1.759520937038361e-24,  3.012285502184073e-10, -2.792110420964618e-11,  2.000702559527750e-12, -1.107403089725937e-13,
  5.255749508717695e-15, -2.204174894090625e-16,  8.338025388205460e-18, -2.898031214409687e-19,  9.344992469058950e-21, -2.818475785118728e-22,  8.011126420004915e-24,
 -2.153952135554864e-25,  1.380185558538686e-12, -2.068454950798630e-13,  2.058750913097578e-14, -1.556421306643091e-15,  9.771252211638006e-17, -5.305280576187931e-18,
  2.557221169455375e-19, -1.114282286684611e-20,  4.445245076022979e-22, -1.639370129454075e-23,  5.631533518014144e-25, -1.811201004233984e-26,  2.676891267302207e-15,
 -7.397918314314482e-16,  1.171403626708949e-16, -1.333286598257222e-17,  1.200865323530717e-18, -9.013367538193853e-20,  5.823783927338813e-21, -3.312113169576366e-22,
  1.685055250213149e-23, -7.763971771082137e-25,  3.271377868411137e-26, -1.268948916101196e-27,  1.390907662523057e-01, -8.237269169947539e-04,  5.085508180262086e-06,
 -3.292056503538148e-08,  3.766171330921818e-10,  3.892880718999062e-12,  5.871524348337347e-14, -3.342954915407064e-15, -1.215390021976000e-16, -5.199758776781443e-19,
  7.576406709081943e-20,  2.154687209575741e-21,  9.398983189335976e-02, -6.237205866021708e-04,  5.921082152454135e-06, -5.974707818327240e-08,  6.010345523837698e-10,
 -5.225318655414490e-12,  5.525809120564887e-14, -6.948663770327367e-16, -3.716924918211888e-18, -8.008136592244987e-20,  4.684519509931992e-21,  1.371066757587370e-22,
  4.265989183107239e-02, -3.461924398265102e-04,  5.094705324836835e-06, -6.712703120522401e-08,  7.398630993202753e-10, -1.230034265510858e-11,  8.263428225134767e-14,
  5.022724797712748e-16,  7.518122603541700e-17,  1.297675060913035e-19, -3.781278894950642e-20, -1.119475959204659e-21,  1.284222169302390e-02, -1.344939074400049e-04,
  2.747878817017288e-06, -4.347072513321684e-08,  5.741035007792636e-10, -1.099370839537684e-11,  9.939127021947824e-14, -2.373843071286500e-16,  6.656998522312889e-17,
 -2.192305959290084e-20, -2.653743875425981e-20, -8.720114463300260e-22,  2.512632818407817e-03, -3.494609918764745e-05,  9.091720240263792e-07, -1.694650796325843e-08,
  2.734000750575164e-10, -5.602763520374005e-12,  6.927612471174547e-14, -6.879008951999074e-16,  3.260206224876415e-17, -1.500835858869315e-19, -6.778113514955877e-21,
 -3.287601449241444e-22,  3.100773966838493e-04, -5.815868252328242e-06,  1.832015781712853e-07, -4.033217816056989e-09,  7.923049005503135e-11, -1.746496460368026e-12,
  2.792534522554964e-14, -4.204375301652499e-16,  1.127055996248580e-17, -1.161126279934415e-19,  2.717172512069443e-22, -8.287536286470186e-23,  2.312023005303481e-05,
 -5.916140344232545e-07,  2.204984188135068e-08, -5.791049709143266e-10,  1.376373925077747e-11, -3.343121202604198e-13,  6.621462810884714e-15, -1.261175692183175e-16,
  2.836600054468120e-18, -4.430727985171476e-20,  6.385335533875513e-22, -1.875726681557526e-23,  9.793149711572166e-07, -3.470231482011838e-08,  1.526512941824245e-09,
 -4.853448177824874e-11,  1.393863981207028e-12, -3.838593834590618e-14,  9.204815821959371e-16, -2.101661131287352e-17,  4.834373037506917e-19, -9.637749067782417e-21,
  1.864245939014446e-22, -3.984556211758859e-24,  2.153611279398211e-08, -1.083833056541081e-09,  5.720031942098801e-11, -2.248697263750144e-12,  7.873164784272047e-14,
 -2.536796554394746e-15,  7.334990857121232e-17, -1.989558315351226e-18,  5.142792369117473e-20, -1.231234750472012e-21,  2.825442223140348e-23, -6.311855349095512e-25,
  2.147904018672657e-10, -1.607743710893507e-11,  1.059816007439672e-12, -5.329480883445800e-14,  2.332896371672946e-15, -9.143746003905686e-17,  3.237414283549607e-18,
 -1.060009508846798e-19,  3.240812125330193e-21, -9.276235876618532e-23,  2.513538202340590e-24, -6.472249537778882e-26,  7.930084309413228e-13, -9.660290098381054e-14,
  8.636656170021100e-15, -5.912802399679671e-16,  3.416417003900832e-17, -1.725931990872280e-18,  7.796541850746768e-20, -3.205657987945385e-21,  1.213459383611210e-22,
 -4.265477646432776e-24,  1.402588416532364e-25, -4.334061481596560e-27,  9.064527736325298e-16, -2.158040888293740e-16,  3.098752769233077e-17, -3.262715898734996e-18,
  2.758893068460329e-19, -1.964667073811194e-20,  1.214129089619899e-21, -6.646641454094703e-23,  3.271846955126786e-24, -1.464844700366953e-25,  6.018779282354501e-27,
 -2.283531836729409e-28,  1.358748775702708e-01, -7.845143743564084e-04,  4.729327966074034e-06, -2.623497800302420e-08,  4.587303009970350e-10,  3.747341982066208e-12,
 -8.696465099990860e-14, -6.774932384986906e-15, -6.533779361236058e-17,  4.062182331041739e-18,  1.353102432450016e-19, -3.535960621194149e-22,  9.158536695759377e-02,
 -5.790638159723038e-04,  5.258582529765977e-06, -5.090139580581151e-08,  5.081390530465596e-10, -4.147118062928144e-12,  3.402922378654157e-14, -8.121204489168914e-16,
 -1.820827643672578e-18,  2.182946396430262e-19,  9.399697178653140e-21,  1.829601073566957e-23,  4.135179609439311e-02, -3.084736049750224e-04,  4.352463347179211e-06,
 -5.713991418684992e-08,  5.162055238971294e-10, -9.884899739672253e-12,  1.284738251537885e-13,  2.601941035846807e-15,  4.209377131239661e-17, -2.183796873203614e-18,
 -6.842330237224421e-20,  1.925847778196397e-22,  1.234510784119299e-02, -1.144571778753082e-04,  2.274512090547848e-06, -3.591248093230533e-08,  3.787533471810964e-10,
 -8.457201149522688e-12,  1.205757093542726e-13,  1.605446451638811e-15,  3.836840151473163e-17, -1.719435140224861e-18, -5.140372448180914e-20,  9.403484919399300e-23,
  2.386201706707392e-03, -2.841974404280637e-05,  7.286421593051289e-07, -1.338272842434115e-08,  1.769899953545150e-10, -4.060920421397775e-12,  6.327901403224536e-14,
  1.900730764093076e-16,  1.915634223371507e-17, -6.656123148622005e-19, -1.664766568023804e-20, -3.070626190645537e-25,  2.894658260316002e-04, -4.524734546949093e-06,
  1.413650800318619e-07, -3.011874183387612e-09,  5.024305246956640e-11, -1.180756693600298e-12,  2.054983972146558e-14, -1.311910391636313e-16,  6.492811490391320e-18,
 -1.672330665534863e-19, -2.348173732414410e-21, -1.567455657683776e-23,  2.106723893871103e-05, -4.397259307308907e-07,  1.622634965835207e-08, -4.047742370589855e-10,
  8.427891438623135e-12, -2.088498570256161e-13,  4.147796576887940e-15, -5.738285799148649e-17,  1.528517087209930e-18, -3.232771838876153e-20,  4.454033484479437e-23,
 -6.982690746003869e-24,  8.617083658221686e-07, -2.449216219756004e-08,  1.055984466830271e-09, -3.134638940367714e-11,  8.072319419851214e-13, -2.188454727664254e-14,
  5.049570102064411e-16, -9.952428785768817e-18,  2.357984347411411e-19, -4.903601732134954e-21,  6.701391695397693e-23, -1.648461132028985e-24,  1.797091631434809e-08,
 -7.160695324126428e-10,  3.636502820216392e-11, -1.315282362632213e-12,  4.189925814263994e-14, -1.293251025122275e-15,  3.530585268421688e-17, -8.799141230445886e-19,
  2.213451056014926e-20, -5.112948908641537e-22,  1.057000532691498e-23, -2.358739125452084e-25,  1.641292161689486e-10, -9.638342458151067e-12,  5.952384017746486e-13,
 -2.720882245230666e-14,  1.090331315287783e-15, -4.014574041124968e-17,  1.330859529008730e-18, -4.079098122622038e-20,  1.186818123247749e-21, -3.226114620996267e-23,
  8.263576660128619e-25, -2.048259913354298e-26,  5.101855305241600e-13, -4.868611543115834e-14,  3.943565648585820e-15, -2.432583519130343e-16,  1.286850087020660e-17,
 -6.038420576522525e-19,  2.547417481283884e-20, -9.845939249868309e-22,  3.527901036219901e-23, -1.178232077853016e-24,  3.695858652656991e-26, -1.094703970399428e-27,
  3.675896827256661e-16, -7.150188547212076e-17,  9.156140890467218e-18, -8.778942773338604e-19,  6.885050517441001e-20, -4.605951461167991e-21,  2.699313185682583e-22,
 -1.412121719140316e-23,  6.683874518985609e-25, -2.891906590165322e-26,  1.153207055593064e-27, -4.261794635116132e-29,  1.328106777932899e-01, -7.478096261177884e-04,
  4.460470266701393e-06, -1.847578978092390e-08,  4.969204751870193e-10, -6.826498203927991e-13, -2.771930859692650e-13, -5.617509758722053e-15,  1.582968664933499e-16,
  7.351856121698630e-18, -1.702652704225793e-20, -6.449090278825956e-21,  8.934956763892384e-02, -5.393062626992011e-04,  4.693932614220753e-06, -4.339806758761961e-08,
  4.315278320792163e-10, -3.600097938632286e-12,  1.214980626686004e-14, -6.771771318632982e-16,  1.196134977175923e-17,  4.927942203295807e-19,  1.058549552815889e-21,
 -4.152756465565310e-22,  4.018337839800242e-02, -2.762700124699548e-04,  3.710430634080704e-06, -5.026827691971570e-08,  3.556562488984332e-10, -5.865192714224577e-12,
  2.049625828136300e-13,  2.233864587047269e-15, -7.537056922122799e-17, -3.820131903951834e-18,  1.023087311711905e-20,  3.308479350519437e-21,  1.192107185556422e-02,
 -9.789360969232482e-05,  1.874896101537237e-06, -3.103143415531930e-08,  2.426141099851569e-10, -4.955647727842809e-12,  1.708302784189785e-13,  1.495416900624223e-15,
 -5.317804065019016e-17, -2.983141069484706e-18,  6.468475072774010e-21,  2.503765874917553e-21,  2.283224434783078e-03, -2.319046002773021e-05,  5.826347782203447e-07,
 -1.111539117484114e-08,  1.116376849829556e-10, -2.435568579954773e-12,  7.273368247085477e-14,  3.054033339788436e-16, -1.459319894506503e-17, -1.085642043546695e-18,
  2.068939219127173e-21,  8.490802665123574e-22,  2.734169672594607e-04, -3.526343161267224e-06,  1.093508620145588e-07, -2.371013513539229e-09,  3.135774440806074e-11,
 -7.143580425379984e-13,  1.875632477649559e-14, -3.651010149216628e-17, -9.650027967830627e-19, -2.279573442302352e-19,  5.549283270516329e-22,  1.492097236613498e-22,
  1.954005312673899e-05, -3.273365780175042e-07,  1.205653254827413e-08, -2.983958002881171e-10,  5.140236647913903e-12, -1.241283350011986e-13,  3.051437353477748e-15,
 -2.702526350494824e-17,  3.724866970112471e-19, -3.113938717870176e-20,  1.601312655448204e-22,  1.243452888519874e-23,  7.785241449193878e-07, -1.735874744003047e-08,
  7.447850051179344e-10, -2.135508011789173e-11,  4.719308116762406e-13, -1.240447162997819e-14,  3.084162530894825e-16, -4.823176992759513e-18,  9.499450962059810e-20,
 -3.132929625109686e-21,  3.436675890994089e-23,  9.947439115988183e-26,  1.560234705738227e-08, -4.785893111284137e-10,  2.387970874415402e-11, -8.129050512260247e-13,
  2.286268296454932e-14, -6.760471548746994e-16,  1.829978233783726e-17, -4.011699909608679e-19,  9.379367988950040e-21, -2.385080765797673e-22,  4.253485776012200e-24,
 -7.159188007769101e-26,  1.333822019287765e-10, -5.937291186839272e-12,  3.516284609857355e-13, -1.477432562086316e-14,  5.326433504365502e-16, -1.850157476721496e-17,
  5.827791605853209e-19, -1.644057237989776e-20,  4.530335403278711e-22, -1.201319612487997e-23,  2.849829784659508e-25, -6.613769756521895e-27,  3.640063667942510e-13,
 -2.605447728115822e-14,  1.947899026425922e-15, -1.082545021307367e-16,  5.196202586253821e-18, -2.266395752858615e-19,  8.927448207429169e-21, -3.224004958069879e-22,
  1.091688467365225e-23, -3.464642669549065e-25,  1.030732691573226e-26, -2.917753872246421e-28,  1.808048924117909e-16, -2.690425206201796e-17,  3.046960618019776e-18,
 -2.619870523679458e-19,  1.881832384040565e-20, -1.171365022317441e-21,  6.452947062584488e-23, -3.200651362743709e-24,  1.447002366107594e-25, -6.014424860341951e-27,
  2.315160131897408e-28, -8.295528594621813e-30,  1.298895888825098e-01, -7.128811387870157e-04,  4.284728934509842e-06, -1.103595592490243e-08,  4.079325746423070e-10,
 -8.425126034422247e-12, -3.281437042499740e-13,  2.957948755053626e-15,  3.377006396895655e-16,  6.979195661870731e-19, -2.955011580533293e-19, -3.596348704574806e-21,
  8.726430584414552e-02, -5.037259308034391e-04,  4.212242439112713e-06, -3.705925806926122e-08,  3.611969999781571e-10, -3.477081343615405e-12,  1.040531165274108e-15,
 -4.294618282676004e-17,  2.540391793874174e-17,  1.111116571707798e-19, -1.975854275162129e-20, -3.492574528705896e-22,  3.913397195345573e-02, -2.489098045809416e-04,
  3.138391965226454e-06, -4.523411414492290e-08,  2.906963764069138e-10, -5.848224308475835e-13,  2.153873788402602e-13, -1.996038712542876e-15, -1.682285772875844e-16,
 -3.635313053156113e-19,  1.518399440470742e-19,  1.791839475781131e-21,  1.155722248573203e-02, -8.432399160244016e-05,  1.523288623342035e-06, -2.771018089831909e-08,
  1.865019614295830e-10, -6.372962566358130e-13,  1.744282337721288e-13, -1.642735855423003e-15, -1.273337031822167e-16, -3.798922299066685e-19,  1.164065009044245e-19,
  1.465905417734092e-21,  2.198978756803629e-03, -1.903563196158609e-05,  4.586717434482773e-07, -9.622517913301741e-09,  8.065743621734924e-11, -6.737019093620125e-13,
  6.944485970547375e-14, -6.912307671151466e-16, -4.233386635625101e-17, -1.905021794253569e-19,  4.057920989781465e-20,  5.437005325507176e-22,  2.608918185599746e-04,
 -2.757744833884998e-06,  8.351548917647855e-08, -1.959631860095059e-09,  2.144076326673852e-11, -2.870428984146335e-13,  1.618098352048946e-14, -1.800572467122042e-16,
 -6.988999731829270e-18, -5.756662678898898e-20,  7.693955169027863e-21,  1.083821393783127e-22,  1.840268942539443e-05, -2.439732179857327e-07,  8.899537963246844e-09,
 -2.322791131047903e-10,  3.331546225584962e-12, -5.958827125001411e-14,  2.309183443758069e-15, -3.052568301551192e-17, -4.723714389039491e-19, -1.112647168734815e-20,
  8.362463019730563e-22,  1.138249788745417e-23,  7.195421302812101e-07, -1.231359516239028e-08,  5.268319003427698e-10, -1.542770160184475e-11,  2.882917393567907e-13,
 -6.373689643704992e-15,  2.010133629322608e-16, -3.293866159300603e-18,  1.090788488740024e-20, -1.382529299863620e-21,  5.619346285412397e-23,  4.877421729920037e-25,
  1.401588359112706e-08, -3.212417930027135e-10,  1.594160611686628e-11, -5.347067817950178e-13,  1.296932531090458e-14, -3.446106326631152e-16,  1.018482291101363e-17,
 -2.100986288352178e-19,  3.337233256896112e-21, -1.063290027471303e-22,  2.793555363729681e-24, -1.179854824594934e-26,  1.143090977545784e-10, -3.712410259989591e-12,
  2.153544361890611e-13, -8.583824145218825e-15,  2.722095922813370e-16, -8.733626933520299e-18,  2.733404269104512e-19, -7.119667694305845e-21,  1.722205889265850e-22,
 -4.694877053231314e-24,  1.137451858432952e-25, -2.039168604751445e-27,  2.843482686422066e-13, -1.453578542429632e-14,  1.028857464648289e-15, -5.221913014977951e-17,
  2.238567521593311e-18, -9.042977446636089e-20,  3.364961667713955e-21, -1.127715708210208e-22,  3.562794423705008e-24, -1.086449516602174e-25,  3.076831608756123e-27,
 -8.115817236556543e-29,  1.074482069186935e-16, -1.133949102843296e-17,  1.144005324961575e-18, -8.727322565398688e-20,  5.660419140261419e-21, -3.251492845959626e-22,
  1.671514355762434e-23, -7.793200831091087e-25,  3.341449727440658e-26, -1.326969261025804e-27,  4.901776011740886e-29, -1.693242517486517e-30,  1.271059177927578e-01,
 -6.790374342529013e-04,  4.184641121988807e-06, -6.235363070213692e-09,  1.734835046982043e-10, -1.414758692245138e-11, -1.072369184230607e-13,  1.179655990456165e-14,
  1.459872368423742e-16, -1.049290457378716e-17, -1.673698105551964e-19,  9.107709386343011e-21,  8.531411324452651e-02, -4.717138617714649e-04,  3.799918624257859e-06,
 -3.183384880418930e-08,  2.922766258182197e-10, -3.376917960051601e-12,  1.062946785992055e-14,  6.660678911343348e-16,  1.376596409395054e-17, -7.265097236874647e-19,
 -1.490570795305609e-20,  6.001763781706667e-22,  3.818522180090584e-02, -2.258940391085234e-04,  2.623935519775201e-06, -4.042535176925869e-08,  3.231297012531714e-10,
  3.337072699737455e-12,  9.086374281004114e-14, -6.375647428229405e-15, -7.044278218397755e-17,  5.344827335514783e-18,  8.435812833184054e-20, -4.675919135709023e-21,
  1.124226523046491e-02, -7.341664453824380e-05,  1.208924449830378e-06, -2.462441705106193e-08,  2.095824098993309e-10,  2.557637692580680e-12,  7.604817697757917e-14,
 -4.997824757292099e-15, -5.498851905660252e-17,  4.077885091412147e-18,  6.820032913355794e-20, -3.565454320854849e-21,  2.129473975898433e-03, -1.580667952521283e-05,
  3.507687799956398e-07, -8.358535250580756e-09,  8.150740195859430e-11,  6.131280427920333e-13,  3.245416622438515e-14, -1.825312857500542e-15, -1.880971213346519e-17,
  1.395769249140299e-18,  2.524592474769733e-20, -1.229388223300603e-21,  2.510559731370309e-04, -2.178160956735535e-06,  6.193133299182599e-08, -1.643577811573045e-09,
  1.904443185402764e-11,  1.587137586226612e-14,  8.147968806064155e-15, -3.735750988140092e-16, -3.216680453060470e-18,  2.504811061406148e-19,  5.157361915919179e-21,
 -2.270099005077484e-22,  1.755271857229222e-05, -1.830927186243416e-07,  6.401569248044902e-09, -1.858209995309450e-10,  2.615246017744717e-12, -1.625703691604641e-14,
  1.231784296433933e-15, -4.514299461912587e-17, -2.326279327051617e-19,  2.296484806692033e-20,  6.068705892645463e-22, -2.298131501385435e-23,  6.776444428601200e-07,
 -8.769193669289272e-09,  3.659329943368598e-10, -1.160378183208850e-11,  2.016579883115784e-13, -2.646525648031297e-15,  1.094106977360309e-16, -3.289495934297994e-18,
  2.940468098802158e-21,  8.504710423472378e-22,  4.203879156133224e-23, -1.270777903683426e-24,  1.294973149905293e-08, -2.162939185513256e-10,  1.058073122009184e-11,
 -3.708752370142528e-13,  8.095045443365537e-15, -1.614937554527341e-16,  5.368882285504894e-18, -1.441723442348734e-19,  1.363014742844659e-21, -9.606485952707776e-24,
  1.809633808872211e-24, -4.140919890037929e-26,  1.023423371677772e-10, -2.338813782735920e-12,  1.337090371563242e-13, -5.327712501704768e-15,  1.496491859869183e-16,
 -4.071445708708457e-18,  1.311335026998579e-19, -3.580056136818607e-21,  6.784306897732059e-23, -1.496960128855110e-24,  5.276230694268908e-26, -1.083698269332060e-27,
  2.394069511272651e-13, -8.316026134846276e-15,  5.691984469708967e-16, -2.736383393556528e-17,  1.035660618416658e-18, -3.758861235644002e-20,  1.351706122827863e-21,
 -4.312265758455985e-23,  1.219123588634595e-24, -3.488141989378106e-26,  1.009345503789066e-27, -2.501181905943689e-29,  7.542564153287376e-17, -5.219174369142761e-18,
  4.800832949709802e-19, -3.263544158525659e-20,  1.878435074678023e-21, -9.852732511271234e-23,  4.719425992346502e-24, -2.054855473812756e-25,  8.264824780833082e-27,
 -3.119590083519857e-28,  1.104007002260977e-29, -3.649225603556248e-31,  1.244562862540685e-01, -6.458342483747151e-04,  4.117000165497807e-06, -5.746033555730465e-09,
 -1.073034184166049e-10, -1.260367964518206e-11,  2.274801850100100e-13,  1.000302176191017e-14, -2.444017193607684e-16, -8.265958770358363e-18,  2.592617940333228e-19,
  6.555567953203837e-21,  8.348574274458763e-02, -4.427680471898373e-04,  3.443805874077975e-06, -2.767697067709638e-08,  2.289444216960853e-10, -2.875036861791993e-12,
  3.104424968581373e-14,  6.344034620859671e-16, -1.542127526723709e-17, -6.726050582318024e-19,  1.744083706973386e-20,  5.775077046379958e-22,  3.732068764526548e-02,
 -2.067495499808494e-04,  2.172266419813709e-06, -3.466571760994600e-08,  3.967063655138346e-10,  3.311041504952951e-12, -8.820692431412785e-14, -5.345237346254015e-15,
  1.276033219538264e-16,  4.167172174359784e-18, -1.327450505688001e-19, -3.299799263568180e-21,  1.096615610674351e-02, -6.486592697606787e-05,  9.354260499627929e-07,
 -2.081201002280467e-08,  2.672413644403989e-10,  2.650778921488880e-12, -6.467553262232479e-14, -4.225313294714531e-15,  9.835209859982654e-17,  3.277138350342275e-18,
 -1.012874199381234e-19, -2.652652518769912e-21,  2.071257074980115e-03, -1.337845108568301e-05,  2.587837852695061e-07, -6.931956614476488e-09,  9.728069663944705e-11,
  7.611866098094086e-13, -1.882575826507590e-14, -1.548224783191196e-15,  3.471144002468179e-17,  1.164996626131088e-18, -3.482937289945771e-20, -9.718193251809558e-22,
  2.432167284767313e-04, -1.756346892793403e-06,  4.407158867227717e-08, -1.329351818194125e-09,  2.044878606684603e-11,  8.347954905824656e-14, -2.242638493742646e-15,
 -3.149293439337292e-16,  6.705229432274367e-18,  2.216771745382972e-19, -6.351063607359303e-21, -1.942625412368165e-22,  1.690963260026263e-05, -1.401046579817056e-07,
  4.416067436379897e-09, -1.454058482381390e-10,  2.482674175434973e-12, -1.828200670115246e-15,  7.960974118992634e-18, -3.700223977698435e-17,  7.393426559605441e-19,
  2.264775643454066e-20, -6.140114238816732e-22, -2.175700369715909e-23,  6.476138224869387e-07, -6.347109217542887e-09,  2.446780917063771e-10, -8.688699536748502e-12,
  1.677326989038281e-13, -1.078557367887951e-15,  2.479342466106518e-17, -2.511892929250531e-18,  4.735202293144231e-20,  1.133010679695293e-21, -2.850663507055254e-23,
 -1.339384947036623e-24,  1.222849528543087e-08, -1.474546684748609e-10,  6.819907769647296e-12, -2.614763010332482e-13,  5.852336936828339e-15, -7.607324095121971e-17,
  1.966798600640918e-18, -9.623628623400100e-20,  1.803326492569941e-21,  1.897265300287388e-23, -4.059945969842489e-25, -4.402061851384329e-26,  9.477203892474929e-11,
 -1.489397851130961e-12,  8.192592572364443e-14, -3.443940059624821e-15,  9.267500172108427e-17, -1.919322117746159e-18,  5.555853174196471e-20, -1.955044180263136e-21,
  4.080869036474773e-23, -2.959815317497011e-25,  9.189257736262436e-27, -7.980296922104800e-28,  2.135050082230213e-13, -4.841646261267583e-15,  3.201985785473346e-16,
 -1.538853162881112e-17,  5.292189858318068e-19, -1.615634720036299e-20,  5.466290547921775e-22, -1.818890937024602e-23,  4.799064194115799e-25, -1.077289313345342e-26,
  3.043867028013950e-28, -9.658600254018678e-30,  6.031452558814147e-17, -2.551766325929143e-18,  2.194043101981375e-19, -1.371741265531062e-20,  6.939518594795339e-22,
 -3.237996003328889e-23,  1.444032928161798e-24, -5.933162206259027e-26,  2.215534095218888e-27, -7.775651259008807e-29,  2.637322350814537e-30, -8.469060073196238e-32,
  1.219383210181280e-01, -6.132200752168143e-04,  4.030604895398316e-06, -9.106251435592508e-09, -2.875364472201940e-10, -4.860797051365814e-12,  3.696809697709806e-13,
 -2.571443734230610e-16, -3.229777861997080e-16,  3.795984112919381e-18,  2.477209864898119e-19, -6.124666713185751e-21,  8.176775051517077e-02, -4.164879038755248e-04,
  3.131908068769269e-06, -2.442857948012473e-08,  1.799705618636231e-10, -1.989229324375738e-12,  3.942017783054197e-14, -7.988923085050990e-17, -2.368284987222423e-17,
  2.301375632221354e-19,  2.009891014324301e-20, -4.214287278300336e-22,  3.652596888062775e-02, -1.909233974137617e-04,  1.796058334107364e-06, -2.794488139042322e-08,
  4.324579464338613e-10, -4.328261521210449e-14, -1.664963101179013e-13, -4.604124475192851e-17,  1.660132967802587e-16, -1.969280871448888e-18, -1.253190524923276e-19,
  3.134387020854642e-21,  1.072018453751471e-02, -5.830549395647957e-05,  7.127213480845692e-07, -1.622909860420403e-08,  2.973374923588996e-10,  1.116681114391411e-13,
 -1.276123133771614e-13, -1.043025893906420e-16,  1.299819555759664e-16, -1.493591917544350e-18, -9.890855343822159e-20,  2.403591806212486e-21,  2.021395586127494e-03,
 -1.161351946331329e-05,  1.853281484476676e-07, -5.290315741758329e-09,  1.052481165558634e-10, -5.763243275826923e-14, -4.255653134606122e-14, -8.512751756284320e-17,
  4.644047351685423e-17, -5.140104693372151e-19, -3.542786084107672e-20,  8.327142450921208e-22,  2.368034355529818e-04, -1.461925956488670e-06,  3.012109858355094e-08,
 -9.942261170462401e-10,  2.101510145927594e-11, -4.659077075128688e-14, -7.272272063158569e-15, -3.204547289212782e-17,  9.030981311192678e-18, -9.524228330944147e-20,
 -6.850241555052520e-21,  1.539483015168568e-22,  1.640976810338019e-05, -1.110845491651772e-07,  2.907531420391194e-09, -1.062616598767920e-10,  2.380381444730018e-12,
 -1.084695390509101e-14, -6.157392695819088e-16, -6.251727604522554e-18,  9.832577805389868e-19, -9.799756606322076e-21, -7.263177484769662e-22,  1.533776715858003e-23,
  6.255422781992776e-07, -4.762652946873629e-09,  1.558518545239284e-10, -6.165660539569159e-12,  1.474238749179414e-13, -1.128669770997339e-15, -2.025573497401321e-17,
 -6.432947723949530e-19,  5.898628950865968e-20, -5.628999514690719e-22, -4.019481072625952e-23,  7.749768581164346e-25,  1.173003382115196e-08, -1.039574508122439e-10,
  4.199909256406413e-12, -1.782384209280056e-13,  4.620359360304145e-15, -5.424166829522832e-17,  1.432449122822001e-19, -3.353537009711885e-20,  1.880845596941440e-21,
 -1.870947368124127e-23, -1.016062163142419e-24,  1.669153182003795e-26,  8.989575638930864e-11, -9.766206610378433e-13,  4.841866069076690e-14, -2.211853428101028e-15,
  6.391390681147770e-17, -1.104005681781205e-18,  1.767353504748457e-20, -8.034049196452363e-22,  3.047182169926386e-23, -3.879185730072974e-25, -7.360230600574072e-27,
  5.315420957851960e-29,  1.982678349376231e-13, -2.895432892574205e-15,  1.775803962209300e-16, -8.939084790548597e-18,  3.037265793743192e-19, -7.705389643773885e-21,
  2.067434841290176e-22, -7.363298048910773e-24,  2.321059502920693e-25, -4.594451673796050e-27,  5.941371411905541e-29, -2.148907986772779e-30,  5.278956897622508e-17,
 -1.305511880375244e-18,  1.048870195385027e-19, -6.359847285146427e-21,  2.909503327190428e-22, -1.165368865095456e-23,  4.659426716083491e-25, -1.846401332269194e-26,
  6.641578112049841e-28, -2.119114597457870e-29,  6.457659429880503e-31, -2.023991993002338e-32,  1.195491220028976e-01, -5.814948926385310e-04,  3.892027183236782e-06,
 -1.402378417714518e-08, -3.019100196462082e-10,  2.937249854297827e-12,  2.485096586464427e-13, -7.096012254216819e-15, -8.293733031814877e-17,  7.450820910079863e-18,
 -5.763643381687936e-20, -5.342316918460264e-21,  8.015011838821606e-02, -3.925589583566090e-04,  2.854890429800118e-06, -2.181808025333054e-08,  1.490723618976253e-10,
 -1.143479437220433e-12,  2.867451271350747e-14, -5.940094800294003e-16, -6.454968296790410e-18,  5.660823121140489e-19, -3.348938918003980e-21, -4.425707174229759e-22,
  3.578905265871487e-02, -1.777800949403377e-04,  1.501526269059599e-06, -2.124034873356624e-08,  3.942511985090378e-10, -3.546979232541034e-12, -1.092040674624842e-13,
  3.471804759337646e-15,  4.309325071608967e-17, -3.798344935097408e-18,  2.985841301641860e-20,  2.700161091404555e-21,  1.049724576273148e-02, -5.330272899758711e-05,
  5.460670295579009e-07, -1.161363419685462e-08,  2.708446803219565e-10, -2.587261202263690e-12, -8.446415655094800e-14,  2.669217720230453e-15,  3.464629595524289e-17,
 -2.972707443677943e-18,  2.240221175281744e-20,  2.141558270418521e-21,  1.977544548787091e-03, -1.035664284878319e-05,  1.317347993346484e-07, -3.669149129931358e-09,
  9.445500694243482e-11, -9.645175513890073e-13, -2.838882068741633e-14,  9.148673496783817e-16,  1.284861503392218e-17, -1.057697989010525e-18,  7.580509203657160e-21,
  7.719161933762055e-22,  2.313700077123113e-04, -1.263095660740185e-06,  2.014682725632099e-08, -6.746957906904321e-10,  1.841491349629581e-11, -2.039162286591892e-13,
 -4.926441289498353e-15,  1.649100794863197e-16,  2.636659904504609e-18, -2.036989091868455e-19,  1.363562167497885e-21,  1.506961377562757e-22,  1.600476020719096e-05,
 -9.229915304162866e-08,  1.851127097203825e-09, -7.071538547193063e-11,  2.017870849928447e-12, -2.465765313095952e-14, -4.341451938235003e-16,  1.556863027128310e-17,
  3.096934936119375e-19, -2.172387412954407e-20,  1.327506046046431e-22,  1.624089351354496e-23,  6.085708187910019e-07, -3.773593650986981e-09,  9.517792847976652e-11,
 -4.016498956723638e-12,  1.195190294387746e-13, -1.645451652475335e-15, -1.661849387675864e-17,  6.948735853876896e-19,  2.056175204292641e-20, -1.248061663928328e-21,
  6.857125590454119e-24,  9.284450310363806e-25,  1.136952211020054e-08, -7.773924018742481e-11,  2.468808238282141e-12, -1.130118006360580e-13,  3.525484442813332e-15,
 -5.612556756287158e-17, -9.884770381263742e-20,  1.007513199087031e-20,  7.382884927146151e-22, -3.642477241988340e-23,  1.900383435908799e-25,  2.551770796867762e-26,
  8.661835312699887e-11, -6.796146663345935e-13,  2.734164097496688e-14, -1.348674584530393e-15,  4.476154655197526e-17, -8.542318419442840e-19,  6.400491553013916e-21,
 -9.442168624732567e-23,  1.314117707560785e-23, -4.996477034784349e-25,  3.306384593841068e-27,  2.694206419904392e-28,  1.889510562112949e-13, -1.831505899202983e-15,
  9.509767584403464e-17, -5.099549700536148e-18,  1.862755942736868e-19, -4.517873360701534e-21,  8.226848046464417e-23, -2.233414984757875e-24,  9.765088221979515e-26,
 -2.986588862172948e-27,  3.869844008229003e-29,  3.224199505552123e-31,  4.885482222740628e-17, -7.070400523038727e-19,  5.038380001074462e-20, -3.101777355243136e-21,
  1.377809339307717e-22, -4.835105806660427e-24,  1.593684867802984e-25, -5.755972312141938e-27,  2.127414871257505e-28, -6.844853119709093e-30,  1.823968291944988e-31,
 -4.561688729459066e-33,  1.172842412416582e-01, -5.511077133035717e-04,  3.697555599281532e-06, -1.813033457214860e-08, -2.002025566742875e-10,  6.440182735287834e-12,
  4.777002643622816e-14, -6.237591144721269e-15,  1.062158445910739e-16,  2.526493396186588e-18, -1.401980037879577e-19,  1.102729457723055e-21,  7.862395785050105e-02,
 -3.707280792345095e-04,  2.606734871837595e-06, -1.958433675317282e-08,  1.316908224411323e-10, -6.610814050372695e-13,  1.185599948688542e-14, -5.288669233004794e-16,
  8.283269879241074e-18,  2.035882248593282e-19, -1.090952911132764e-20,  7.063947688878238e-23,  3.510048575910511e-02, -1.666863315776733e-04,  1.281781676701670e-06,
 -1.560789265654603e-08,  3.052909901582801e-10, -4.959053771330128e-12, -1.056837311522165e-14,  3.062036162377239e-15, -5.321047659018626e-17, -1.285789644759971e-18,
  7.124711143055635e-20, -5.673107882492707e-22,  1.029198736098571e-02, -4.942249448489729e-05,  4.307124134609234e-07, -7.777733037220253e-09,  2.051442532395366e-10,
 -3.681317308991293e-12, -8.236880064069309e-15,  2.373040415150654e-15, -4.111149295969263e-17, -1.020240546532166e-18,  5.590295172183157e-20, -4.307576288725610e-22,
  1.937980968751959e-03, -9.454853264334652e-06,  9.604108314945245e-08, -2.340084581622692e-09,  7.052904878979539e-11, -1.323763778786479e-12, -2.025195136170109e-15,
  8.240889016817395e-16, -1.427308953036005e-17, -3.693584892784475e-19,  1.992497053701054e-20, -1.476685927098811e-22,  2.265953175291846e-04, -1.129641066913500e-06,
  1.366744019137738e-08, -4.174473208850158e-10,  1.355100525552890e-11, -2.633470622447714e-13, -9.649802304763707e-17,  1.520783576119687e-16, -2.630614028191149e-18,
 -7.289469958848948e-20,  3.839846111707812e-21, -2.698229799308565e-23,  1.566052903356808e-05, -8.037598435058954e-08,  1.178584636654286e-09, -4.278110391845631e-11,
  1.458779891639231e-12, -2.938405615855077e-14,  3.662586635578425e-17,  1.503566066002694e-17, -2.584621138497399e-19, -8.048774242633118e-21,  4.085372904586954e-22,
 -2.667661941538816e-24,  5.947365020510116e-07, -3.175058353363388e-09,  5.731777108575404e-11, -2.381684151581752e-12,  8.441785764597191e-14, -1.774465329536883e-15,
  6.040493071521800e-18,  7.473786809975578e-19, -1.256294437489384e-20, -4.854454345964110e-22,  2.322466798674357e-23, -1.376205901882240e-25,  1.109071819265257e-08,
 -6.253993728873426e-11,  1.413998308493375e-12, -6.558372418401072e-14,  2.411095059775856e-15, -5.355706777128747e-17,  3.375755348954390e-19,  1.587264086177771e-20,
 -2.441350471590269e-22, -1.509716814924825e-23,  6.564313713911532e-25, -3.510174491812104e-27,  8.425040417867350e-11, -5.146886770819720e-13,  1.491706011157364e-14,
 -7.610646145823035e-16,  2.917884187787095e-17, -7.000526959107939e-19,  7.231301555475711e-21,  8.186938291613395e-23, -4.083490428485157e-25, -2.204198565358465e-25,
  8.252764682552645e-27, -4.525796113906366e-29,  1.828222808449493e-13, -1.271089950169628e-15,  4.910588380297727e-17, -2.750793699742968e-18,  1.120413561957284e-19,
 -3.028825371861903e-21,  4.957965295975697e-23, -5.087516866059686e-25,  2.030599419914412e-26, -1.296935766714340e-27,  4.025632084689550e-29, -3.657762515508132e-31,
  4.664171172531482e-17, -4.216023825452709e-19,  2.374954563841783e-20, -1.506526696101142e-21,  6.943927412625728e-23, -2.360366013353598e-24,  6.467148264305170e-26,
 -1.788396575449038e-27,  6.192284452532409e-29, -2.268000229921153e-30,  6.780903165263119e-32, -1.481206574511744e-33,  1.151375295877878e-01, -5.224420499825200e-04,
  3.465080452615918e-06, -2.029260385052219e-08, -7.186962048988760e-11,  5.923645109368410e-12, -7.252270917168542e-14, -2.318601370090118e-15,  1.153458469438891e-16,
 -1.381591500646242e-18, -4.758205273770072e-20,  2.227239157571801e-21,  7.718131422529466e-02, -3.507793555120801e-04,  2.383966589100625e-06, -1.757203335529197e-08,
  1.202884855746375e-10, -5.202828651131728e-13,  1.318468032318910e-15, -2.201377886813383e-16,  9.154768162885824e-18, -1.064755641141356e-19, -3.861582292617489e-21,
  1.769821891879310e-22,  3.445317007894012e-02, -1.571057158417928e-04,  1.120547769631661e-06, -1.150514552526974e-08,  2.094084711329821e-10, -4.401098576575044e-12,
  4.787501144787542e-14,  1.093574226548906e-15, -5.795536928136308e-17,  6.978252816036731e-19,  2.412565697127842e-20, -1.129705798170579e-21,  1.010066910664933e-02,
 -4.629989228784443e-05,  3.546636306552720e-07, -5.075553150192042e-09,  1.340627949095730e-10, -3.250165033544682e-12,  3.702264312201681e-14,  8.432360524818187e-16,
 -4.515492165410244e-17,  5.421068247110804e-19,  1.909847298890725e-20, -8.893807283710752e-22,  1.901544817860859e-03, -8.781659248543077e-06,  7.386757820317478e-08,
 -1.419252982478789e-09,  4.513644783576373e-11, -1.154340357960879e-12,  1.363960105316404e-14,  2.880301781783268e-16, -1.588330224626464e-17,  1.899953085227204e-19,
  6.880877230207018e-21, -3.180651479168523e-22,  2.222683889625621e-04, -1.037047833456757e-06,  9.788248053663110e-09, -2.416372627368603e-10,  8.549952515962152e-12,
 -2.255296291172185e-13,  2.778764703429920e-15,  5.171149889908464e-17, -2.993075007175775e-18,  3.555369738543825e-20,  1.346038850391577e-21, -6.152599216709026e-23,
  1.535513353816535e-05, -7.264773193566950e-08,  7.863607449250939e-10, -2.397037906718696e-11,  9.084060826219724e-13, -2.455162471781197e-14,  3.185728042698331e-16,
  4.885957372397945e-18, -3.062170065107783e-19,  3.584283812743548e-21,  1.462680137697284e-22, -6.569252291728061e-24,  5.828013083647662e-07, -2.810489909742268e-09,
  3.571318576011384e-11, -1.300885851783916e-12,  5.179184807994804e-14, -1.434027007059373e-15,  1.987108676735317e-17,  2.233801967636528e-19, -1.618045596108895e-20,
  1.831018767554483e-22,  8.567521188158408e-24, -3.739572934681247e-25,  1.085902100598682e-08, -5.379802998713676e-11,  8.249010166876682e-13, -3.500466053025447e-14,
  1.450896751370780e-15, -4.133889803653945e-17,  6.238695616492886e-19,  3.847948478607327e-21, -3.926139499645164e-22,  4.050896988999397e-24,  2.523719295534568e-25,
 -1.049564725947595e-26,  8.238236474739525e-11, -4.249459686234596e-13,  8.155867385468923e-15, -3.961018731775188e-16,  1.706802726569994e-17, -5.056856194269643e-19,
  8.562613409532088e-21, -1.640558788531827e-24, -3.354085140368036e-24,  2.276310097738676e-26,  3.332771635904701e-27, -1.273624911064793e-28,  1.783520132782002e-13,
 -9.840097903596616e-16,  2.505167615402833e-17, -1.382065328428746e-18,  6.244393378811503e-20, -1.969420862299092e-21,  3.939867821073680e-23, -3.359189081016690e-25,
 -2.588640533507084e-27, -1.370452757229232e-28,  1.648038628413313e-29, -5.475465505185290e-31,  4.524333663956965e-17, -2.881426986116250e-19,  1.101412330689447e-20,
 -7.026274605516117e-22,  3.459309894899467e-23, -1.244779342350306e-24,  3.314729654726869e-26, -6.992345549435491e-28,  1.605935295918501e-29, -5.766075708569509e-31,
  2.256162372242603e-32, -6.666459950702877e-34,  1.131016438362073e-01, -4.957066918085322e-04,  3.218229266715887e-06, -2.060455607340568e-08,  2.586599951862391e-11,
  3.766356315999207e-12, -9.487331620901372e-14,  3.764046574257247e-16,  5.113723812601094e-17, -1.757390344572674e-18,  1.702538821649583e-20,  6.678648826072259e-22,
  7.581504994631895e-02, -3.325191497598523e-04,  2.184307658619913e-06, -1.573049675171692e-08,  1.098532803295412e-10, -5.337660812496519e-13, -1.453636831313768e-15,
 -4.969154591719859e-18,  4.125026108894417e-18, -1.384892238183364e-19,  1.332727855612079e-21,  5.431054402517026e-23,  3.384187373898261e-02, -1.486428680804067e-04,
  9.999068525202386e-07, -8.789371229674067e-09,  1.343893019437951e-10, -3.066536004864008e-12,  5.713292668738851e-14, -2.575057675317946e-16, -2.549507743092386e-17,
  8.885368390890548e-19, -8.619436373012503e-21, -3.382973434101225e-22,  9.920803810911399e-03, -4.367434246220444e-05,  3.046537405618558e-07, -3.396938491427215e-09,
  7.910364977275397e-11, -2.219991011921908e-12,  4.399276652420661e-14, -2.087926846467725e-16, -1.979695472651187e-17,  6.954070414283500e-19, -6.740351958023883e-21,
 -2.676226214774380e-22,  1.867507375534770e-03, -8.248194953542528e-06,  6.047060005159489e-08, -8.621748761571095e-10,  2.571130030447184e-11, -7.800425901743879e-13,
  1.585386456451386e-14, -8.158718423455417e-17, -6.922154106307101e-18,  2.464175812403681e-19, -2.384660378299334e-21, -9.626905581066212e-23,  2.182613081513580e-04,
 -9.683323994977737e-07,  7.573199254586092e-09, -1.369838468895382e-10,  4.773593758129644e-12, -1.508523140594721e-13,  3.124811300858368e-15, -1.782981480608770e-17,
 -1.293145519970486e-18,  4.695748345415052e-20, -4.527217519260692e-22, -1.877323496448853e-23,  1.507560585239086e-05, -6.729480098175859e-08,  5.711478332631127e-10,
 -1.292030934876416e-11,  4.998012543630040e-13, -1.622464108622474e-14,  3.427029442284461e-16, -2.215119415613044e-18, -1.306675316876284e-19,  4.888039385078976e-21,
 -4.672054569243671e-23, -2.027511026200677e-24,  5.720491268830820e-07, -2.575144326529370e-09,  2.421553309857205e-11, -6.745794150609486e-13,  2.811670250579484e-14,
 -9.328465813680623e-16,  2.017157922988518e-17, -1.510994335866984e-19, -6.779323328883879e-21,  2.657874988358309e-22, -2.489447131801697e-24, -1.173261579147196e-25,
  1.065484801445635e-08, -4.854186557767541e-11,  5.195261694413852e-13, -1.757767528100092e-14,  7.759962679511418e-16, -2.630889999089356e-17,  5.868107966214813e-19,
 -5.231523408152565e-21, -1.597555769344989e-22,  6.807882610674920e-24, -6.049791126689476e-26, -3.371747904028207e-27,  8.078860203328835e-11, -3.747664236660289e-13,
  4.743059118278443e-15, -1.929745880542779e-16,  8.948692932275878e-18, -3.114345740319226e-19,  7.263234401278744e-21, -7.983120902196030e-23, -1.287574811873405e-24,
  6.662954743744984e-26, -4.939373180673731e-28, -4.225979589176056e-29,  1.747321959055107e-13, -8.356271516531904e-16,  1.331891519118325e-17, -6.500825012124824e-19,
  3.169471783713804e-20, -1.147155674593566e-21,  2.875346095094066e-23, -4.118432772541971e-25, -5.698951156787269e-28,  1.409548368968444e-28,  1.395031679405948e-31,
 -1.866827778170830e-31,  4.422469903150636e-17, -2.259872475522334e-19,  5.205885856157545e-21, -3.108849696619816e-22,  1.630436827118911e-23, -6.403052862279555e-25,
  1.860103928953842e-26, -3.908304135693388e-28,  5.947961909235565e-30, -1.033396430367447e-31,  4.466060444836333e-33, -2.055630273812143e-34,  1.111687592937331e-01,
 -4.709378908538956e-04,  2.975559055145617e-06, -1.970558176936511e-08,  8.000527403644312e-11,  1.748028096726830e-12, -6.977513142120378e-14,  1.167578308565097e-15,
  3.979006759921939e-18, -8.275005928092429e-19,  2.312227786524573e-20, -2.076581956371858e-22,  7.451876785132958e-02, -3.157706952193187e-04,  2.005729583350296e-06,
 -1.405997602625794e-08,  9.887696893064659e-11, -5.595638131868657e-13, -4.027129747775198e-16,  6.045355983298728e-17,  4.131038796131393e-19, -6.483804098386816e-20,
  1.834753776134137e-21, -1.669591594714922e-23,  3.326267883254923e-02, -1.410331439691619e-04,  9.055432661875954e-07, -7.059046012219169e-09,  8.582506627815017e-11,
 -1.847390156757009e-12,  4.272220847738127e-14, -6.461283094698909e-16, -1.663867300852447e-18,  4.176718600445835e-19, -1.170968917183343e-20,  1.051008295513765e-22,
  9.750749112887173e-03, -4.138166520745602e-05,  2.701971320774818e-07, -2.432113120720310e-09,  4.450862532509280e-11, -1.285036440031405e-12,  3.258054414168704e-14,
 -5.080565269937842e-16, -1.159890856006674e-18,  3.258657991523834e-19, -9.196519406656281e-21,  8.275994066186093e-23,  1.835425072678570e-03, -7.799877767888169e-06,
  5.214193237516088e-08, -5.560571933829187e-10,  1.363287658864663e-11, -4.446002153736140e-13,  1.163841180944491e-14, -1.847129956441059e-16, -3.246750910145569e-19,
  1.149847855105180e-19, -3.274719339253825e-21,  2.954632548150990e-23,  2.145003017110655e-04, -9.132275540307760e-07,  6.300669184206337e-09, -8.090329115918120e-11,
  2.447976464565464e-12, -8.511499959126938e-14,  2.269163457014235e-15, -3.666332881960283e-17, -3.750491593862758e-20,  2.178592311879344e-20, -6.284832751357942e-22,
  5.685069147411570e-24,  1.481474597629955e-05, -6.323173774379126e-08,  4.547505116245212e-10, -7.100205967540996e-12,  2.507240989863016e-13, -9.069915358824273e-15,
  2.453405797032482e-16, -4.050653749645035e-18, -1.562825960562181e-22,  2.250141987639506e-21, -6.612193932590338e-23,  5.990971084887803e-25,  5.620938623232564e-07,
 -2.407407728022646e-09,  1.828454807665869e-11, -3.494384107698611e-13,  1.386598401705356e-14, -5.160366605660012e-16,  1.416536357766848e-17, -2.405140642467874e-19,
  3.062751768933238e-22,  1.210451046450627e-22, -3.656483454654426e-24,  3.307160808116407e-26,  1.046790824885471e-08, -4.505361173807732e-11,  3.680493362659564e-13,
 -8.663462051652920e-15,  3.766851665291117e-16, -1.435632696604453e-17,  4.011188243313919e-19, -7.074289551258888e-21,  2.158401629728081e-23,  3.054043418398569e-24,
 -9.647317530259511e-26,  8.616154190721215e-28,  7.935364401563133e-11, -3.440665532679310e-13,  3.109351637937077e-15, -9.097103866247583e-17,  4.266747530758078e-18,
 -1.665820831033888e-19,  4.769791364575682e-21, -8.884403104666186e-23,  4.938088724228985e-25,  2.924918446543310e-26, -1.006606419192123e-27,  8.521027410451554e-30,
  1.715635387245100e-13, -7.531783173920265e-16,  7.914274854923228e-18, -2.929173128732380e-19,  1.472676208023542e-20, -5.930871529810485e-22,  1.766925751902317e-23,
 -3.588395440103073e-25,  3.370277693414026e-27,  6.038347922871985e-29, -2.698201705464577e-30,  1.621189940946588e-32,  4.338557237516375e-17, -1.956605516937069e-19,
  2.687142935276116e-21, -1.315767242993208e-22,  7.176012130052728e-24, -3.062471227049669e-25,  9.929426932206063e-27, -2.386774377411272e-28,  3.934568288227144e-30,
 -3.551516387621632e-32,  2.176085605453627e-34, -2.545103835336094e-35,  1.093311525987330e-01, -4.480554038436744e-04,  2.747661892249462e-06, -1.822571939191536e-08,
  1.008469967855611e-10,  4.584509483781334e-13, -3.863057214617132e-14,  9.748774443332747e-16, -1.192567786364107e-17, -1.387426915760675e-19,  1.095172152090993e-20,
 -2.686877148206740e-22,  7.328674503221849e-02, -3.003736939302218e-04,  1.846132633226008e-06, -1.256742045562911e-08,  8.772642788633642e-11, -5.491153040302874e-13,
  1.215124694965271e-15,  4.872884208082449e-17, -8.223273172140211e-19, -1.044180076267079e-20,  8.566056264838933e-22, -2.151025621895913e-23,  3.271252813487984e-02,
 -1.341067641722518e-04,  8.280183620009493e-07, -5.931828742244542e-09,  5.768211187541499e-11, -1.034245910431687e-12,  2.556413873500842e-14, -5.381090436632482e-16,
  6.339973380848441e-18,  6.883556144630063e-20, -5.547120310768859e-21,  1.361014237482465e-22,  9.589375600209503e-03, -3.932642437634968e-05,  2.445609573376121e-07,
 -1.887892548636541e-09,  2.549069873249633e-11, -6.694941387357249e-13,  1.914237158088795e-14, -4.197395401012448e-16,  5.051772056108538e-18,  5.220185763724487e-20,
 -4.341197281567490e-21,  1.071681816550703e-22,  1.805022029851755e-03, -7.406310774891557e-06,  4.652896120134242e-08, -3.956296126883774e-10,  7.122271630219336e-12,
 -2.255201959481947e-13,  6.780786719432012e-15, -1.510315848672381e-16,  1.850841851216586e-18,  1.766597773881763e-20, -1.539165483978133e-21,  3.828905486033320e-23,
  2.109428451281454e-04, -8.661515748089192e-07,  5.517301945561587e-09, -5.273886365705352e-11,  1.208911723051708e-12, -4.254395088992946e-14,  1.312520498485577e-15,
 -2.956507285112754e-17,  3.702264221626242e-19,  3.140402315346716e-21, -2.936869885269997e-22,  7.383535362945981e-24,  1.456863590788855e-05, -5.987824300547101e-08,
  3.885640905238355e-10, -4.257663904043370e-12,  1.192737323153588e-13, -4.485205183538295e-15,  1.407521934773646e-16, -3.206396404474579e-18,  4.127779037985221e-20,
  2.927969639472209e-22, -3.065524979788990e-23,  7.822475708407178e-25,  5.527346548465578e-07, -2.274808342353135e-09,  1.513555740125030e-11, -1.939043532880286e-13,
  6.418855918235976e-15, -2.526713504923650e-16,  8.042121395608467e-18, -1.856792290529260e-19,  2.478696535425062e-21,  1.310892447931628e-23, -1.676745648370323e-24,
  4.372318701115348e-26,  1.029304392944962e-08, -4.244135308852606e-11,  2.922904259218343e-13, -4.475338886388718e-15,  1.705272541138952e-16, -6.951189945277452e-18,
  2.244589004721661e-19, -5.275396443819105e-21,  7.395542842047343e-23,  2.158767210308514e-25, -4.355050265948531e-26,  1.174502718362155e-27,  7.802156421041299e-11,
 -3.226146230113223e-13,  2.335298706515318e-15, -4.394016314941080e-17,  1.890775820105048e-18, -7.945491074317009e-20,  2.611778284901313e-21, -6.299096607412498e-23,
  9.461744544038749e-25, -2.722303276770825e-28, -4.437245692588809e-28,  1.269939953725397e-29,  1.686598276932857e-13, -7.006862703996390e-16,  5.487469519440635e-18,
 -1.323204206312932e-19,  6.360760175063095e-21, -2.760892390173983e-22,  9.323267581683151e-24, -2.346253949518833e-25,  3.917215849061237e-27, -1.925390439082976e-29,
 -1.144563718363984e-30,  3.778554989288780e-32,  4.263815988272429e-17, -1.789188820505016e-19,  1.631313523165498e-21, -5.484316983190777e-23,  2.961431850248834e-24,
 -1.350643956314404e-25,  4.821479518029375e-27, -1.327088286263308e-28,  2.691142747556665e-30, -3.424748916228626e-32,  6.104613346264557e-35,  5.941722602847595e-36,
  1.075815477029601e-01, -4.269211004867739e-04,  2.538797387007540e-06, -1.658071824019584e-08,  1.027225390623338e-10, -1.863686259951491e-13, -1.694704756761910e-14,
  5.771663318861338e-16, -1.151381298737929e-17,  1.042383398706436e-19,  2.276565362348657e-21, -1.240669861297404e-22,  7.211386585670233e-02, -2.861848297420671e-04,
  1.703389174504338e-06, -1.124966360100193e-08,  7.713015089125778e-11, -5.067061294774726e-13,  2.192002090448724e-15,  2.135859130573455e-17, -7.792275953081567e-19,
  8.276654331144797e-21,  1.671713066703009e-22, -9.736487289886114e-24,  3.218891887417678e-02, -1.277530346920626e-04,  7.617863138062472e-07, -5.145752559653224e-09,
  4.203564833046836e-11, -5.775591661665495e-13,  1.346655020051393e-14, -3.279066537605680e-16,  6.079913503531216e-18, -5.420273609362448e-20, -1.151005172264667e-21,
  6.290871130363220e-23,  9.435848026690712e-03, -3.745449600470201e-05,  2.239822459737799e-07, -1.565853881358678e-09,  1.584111353783773e-11, -3.320933091708337e-13,
  9.745178872934584e-15, -2.532671103091539e-16,  4.793516341850950e-18, -4.368622701282400e-20, -8.848375229507358e-22,  4.932908119044424e-23,  1.776113529551168e-03,
 -7.051424026954563e-06,  4.234131301967136e-08, -3.102278040403199e-10,  3.932496663855523e-12, -1.065971298486790e-13,  3.409377970878335e-15, -9.056159982158698e-17,
  1.731379238200285e-18, -1.614886320305692e-20, -3.064376144670588e-22,  1.753764063156542e-23,  2.075628988932445e-04, -8.242706448511289e-07,  4.977246655120575e-09,
 -3.874849686490267e-11,  6.130980753893604e-13, -1.960066379037566e-14,  6.547454014718920e-16, -1.760785811607700e-17,  3.397808305753641e-19, -3.263163575400872e-21,
 -5.652165129464926e-23,  3.359590253343594e-24,  1.433505452217810e-05, -5.694742118027988e-08,  3.464798915177867e-10, -2.911161664114092e-12,  5.686495689493338e-14,
 -2.032425780332087e-15,  6.971793443526703e-17, -1.893364808507555e-18,  3.693625344579959e-20, -3.683276827931632e-22, -5.606803686598388e-24,  3.527152263889810e-25,
  5.438648880652338e-07, -2.161609404514039e-09,  1.328768478401771e-11, -1.227478297473829e-13,  2.921183261892613e-15, -1.130266111464897e-16,  3.952037737446111e-18,
 -1.083974171049359e-19,  2.144486457455915e-21, -2.245602228906405e-23, -2.825870100593394e-25,  1.946507715211615e-26,  1.012766870511532e-08, -4.028035651393090e-11,
  2.511916608365578e-13, -2.611816868132568e-15,  7.478524961932715e-17, -3.071823729912466e-18,  1.091827775321442e-19, -3.030670580410833e-21,  6.111992287874759e-23,
 -6.827482880441493e-25, -6.319663671659713e-27,  5.131915646383695e-28,  7.676572241176904e-11, -3.056284453843531e-13,  1.946630495712236e-15, -2.353401492408667e-17,
  8.029193396387343e-19, -3.462249906982549e-20,  1.251759713495543e-21, -3.532460228118430e-23,  7.327680957838974e-25, -8.943453358879373e-27, -4.451830521707716e-29,
  5.386744257363143e-30,  1.659368021871370e-13, -6.617585272649615e-16,  4.361907396362782e-18, -6.455449904583564e-20,  2.614006290490378e-21, -1.178827122187730e-22,
  4.358537092788980e-24, -1.263140257476921e-25,  2.744057177633063e-27, -3.814621740193403e-29,  3.003115600067231e-32,  1.516800304784057e-32,  4.194532840557138e-17,
 -1.678653980675763e-19,  1.185654487342566e-21, -2.388599126376620e-23,  1.161875142912580e-24, -5.531772178372815e-26,  2.132180010575235e-27, -6.535368814510164e-29,
  1.561385788983837e-30, -2.716641615183736e-32,  2.603875693528699e-34,  1.927139436830545e-36  };
  int offset = -12;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 12;
    if (std::isnan(t)) {
      fill_n(rr+offset, 12, 0.5);
      fill_n(ww+offset, 12, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 12; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=12; ++j) {
        const int boxof = it*144+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
