//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_13.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot13(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[13] = {4.656008324502489e-02,4.200274064012138e-01,1.172310773277779e+00,2.314540864349432e+00,3.864585038228160e+00,
    5.848734811306344e+00,8.304553489985892e+00,1.128575099351763e+01,1.487096037752541e+01,1.918091948561044e+01,2.441669233305652e+01,3.096393827474679e+01,
    3.981042606874936e+01};
  constexpr double aw[13] = {4.120436505903693e-01,2.846322411767841e-01,1.351133279117879e-01,4.359822721725099e-02,9.397901291159515e-03,
    1.319064722323857e-03,1.162297016031097e-04,6.103291717396045e-06,1.770106337397341e-07,2.524494034490568e-09,1.460999933981603e-11,2.383148659372179e-14,
    4.396916094753844e-18};
  constexpr double x[4992] = {  6.763244749183432e-03, -1.248379441866770e-04,  1.722376060891350e-06, -2.103080710074614e-08,  2.393736891651011e-10,
 -2.597641617293236e-12,  2.717721174595044e-14, -2.757850315267350e-16,  2.722223940890498e-18, -2.616501228371319e-20,  2.446949527404646e-22, -2.221336165099678e-24,
  6.035894227004335e-02, -1.085223746022034e-03,  1.418812106328045e-05, -1.577783318447202e-07,  1.544309788392325e-09, -1.318913660284050e-11,  9.257775810694212e-14,
 -4.157494074616188e-16, -1.374093119053075e-18,  6.445602831734677e-20, -1.015354857869172e-21,  1.173682528336322e-23,  1.648483930799589e-01, -2.809579390326239e-03,
  3.275698003166618e-05, -2.915878898516580e-07,  1.783375222147245e-09, -1.759342809144769e-12, -1.399162427818710e-13,  2.360290269424670e-15, -2.269140912646955e-17,
  1.048032723800916e-19,  8.951318095168396e-22, -2.734986842030029e-23,  3.149218944331616e-01, -4.941999597289777e-03,  4.751424937256206e-05, -2.569171798045360e-07,
 -6.404294753238845e-10,  3.153406081800194e-11, -3.357968095636091e-13,  8.782526802700451e-16,  2.797726640250433e-17, -4.905921429044925e-19,  3.208698377753995e-21,
  1.967152109442320e-23,  5.028540649082733e-01, -7.035448603703002e-03,  4.947883398000996e-05, -4.652390946489470e-09, -4.016062609679646e-09,  3.699553966775220e-11,
  9.642722334373255e-14, -5.392010589045711e-15,  4.142028729583426e-17,  2.983399070864281e-19, -8.788957363844184e-21,  4.921405333548476e-23,  7.188003981383192e-01,
 -8.640801094034275e-03,  3.488149101559694e-05,  3.385630944926345e-07, -4.694997491735063e-09, -1.025135533183442e-11,  6.044095914344061e-13, -2.148537528824649e-15,
 -6.841747870782609e-17,  7.067913014210714e-19,  5.659393042875727e-21, -1.400010788952524e-22,  9.512058670546042e-01, -9.401246037987365e-03,  7.299951507450342e-06,
  5.492965549314315e-07, -1.221533005282128e-09, -5.713159941508341e-11,  2.136036202053382e-13,  7.140498430734310e-15, -3.832928117992591e-17, -9.764193303687160e-19,
  6.973276716935657e-21,  1.402357196917817e-22,  1.187330932671005e+00, -9.133667282571102e-03, -2.352100231196473e-05,  4.746437146887753e-07,  3.515249037343967e-09,
 -3.944507005354769e-11, -5.521233828364545e-13,  3.244881044268252e-15,  8.723772633695714e-17, -1.593633806464431e-19, -1.357726978331282e-20, -2.472636495831337e-23,
  1.413893331733568e+00, -7.878253694778849e-03, -4.592339534984975e-05,  1.590422125851597e-07,  5.074739204811965e-09,  2.077729089956689e-11, -4.364194374383986e-13,
 -6.073607291658997e-15,  9.887031764692477e-18,  9.353545290295953e-19,  6.319066661818492e-21, -8.724362425679614e-23,  1.617811047294962e+00, -5.901277797942339e-03,
 -5.187453522022230e-05, -1.806583071120655e-07,  2.363058508212019e-09,  4.421621764136446e-11,  2.459699604617542e-13, -2.428523338592953e-15, -6.098141973823202e-17,
 -4.277130028264685e-19,  3.099406299138949e-21,  1.002782189304745e-22,  1.787012991120084e+00, -3.644557261513661e-03, -4.107931006385962e-05, -3.252966980329220e-07,
 -1.236569975141941e-09,  1.243638609254115e-11,  3.096411640746478e-13,  3.278060033988569e-15,  1.390196155088812e-17, -1.868621559688506e-19, -4.749141641924888e-21,
 -5.186084956809254e-23,  1.911262462999532e+00, -1.627958318229192e-03, -2.133820650419421e-05, -2.313358760558414e-07, -2.102846704763819e-09, -1.498063127240874e-11,
 -5.780992863780387e-14,  4.878862067743886e-16,  1.458677366998058e-17,  2.066723076288428e-19,  2.086840323289257e-21,  1.414178134516716e-23,  1.982935241268074e+00,
 -3.252619492408063e-04, -4.609570374377074e-06, -5.738594704167560e-08, -6.596202601699849e-10, -7.139302971296582e-12, -7.330603556838300e-14, -7.144032836033004e-16,
 -6.569868122184637e-18, -5.619182874925913e-20, -4.327183964150917e-22, -2.755090130645695e-24,  6.289939636849217e-03, -1.120070353190806e-04,  1.491379832464063e-06,
 -1.758347054406808e-08,  1.933653183152934e-10, -2.029016006317508e-12,  2.054561873377367e-14, -2.020317449678203e-16,  1.935206327969745e-18, -1.808464747987209e-20,
  1.648278270726517e-22, -1.463236405370018e-24,  5.623363361737784e-02, -9.788913682763000e-04,  1.243471006418228e-05, -1.350629381233198e-07,  1.301785273193425e-09,
 -1.111004369948366e-11,  8.061955870084843e-14, -4.295076999859391e-16,  3.268521744343810e-19,  3.278042016474603e-20, -5.998050001096408e-22,  7.422575738020158e-24,
  1.541127064457817e-01, -2.561038444574274e-03,  2.942743514604216e-05, -2.634967915315861e-07,  1.719553069801120e-09, -4.402647088004620e-12, -8.338966146094125e-14,
  1.699365838942000e-15, -1.852233884324523e-17,  1.210293492446832e-19,  1.611645478939302e-23, -1.361216521779078e-23,  2.958944120726049e-01, -4.574346688652259e-03,
  4.438918284821419e-05, -2.625464996980807e-07, -8.789069675166102e-11,  2.385579428995055e-11, -3.011433054120224e-13,  1.516862798054098e-15,  1.275331630665674e-17,
 -3.536324970939129e-19,  3.455457996295794e-21, -5.631301674804078e-24,  4.755021109582451e-01, -6.640876809039095e-03,  4.906215410366357e-05, -6.291289838124090e-08,
 -3.264430654688034e-09,  3.765546644601733e-11, -3.483471669870966e-14, -3.957804144589445e-15,  4.643180096960907e-17, -1.898059904628266e-21, -6.086232042604921e-21,
  6.818346468090071e-23,  6.848192112970634e-01, -8.346785756732644e-03,  3.848924960301540e-05,  2.625664769122770e-07, -4.761013263694095e-09,  3.309945353154650e-12,
  5.176670474607843e-13, -3.898987653570120e-15, -4.035510000827126e-17,  8.136669064057110e-19, -1.433634199954776e-22, -1.167819391385273e-22,  9.137588477819566e-01,
 -9.316897152670235e-03,  1.373761727475352e-05,  5.209545992211567e-07, -2.297551691018743e-09, -4.977478194706464e-11,  3.915294461333197e-13,  5.416221689559075e-15,
 -6.716231929322714e-17, -5.954700579301846e-19,  1.147994609908885e-20,  5.931852480806390e-23,  1.150457265555510e+00, -9.298160713052492e-03, -1.751608189835843e-05,
  5.238929809114791e-07,  2.602791496246639e-09, -5.129936784800285e-11, -4.237975144213317e-13,  5.839545445493394e-15,  7.173716955511870e-17, -6.938936993736364e-19,
 -1.238065713680902e-20,  8.001237017024656e-23,  1.381659615171860e+00, -8.236598901190832e-03, -4.351599979611074e-05,  2.429365518631851e-07,  5.372091891627291e-09,
  8.330889080447255e-12, -5.966916734763386e-13, -5.178619575791981e-15,  4.696670816730371e-17,  1.087597528745165e-18,  7.311255006249535e-22, -1.636869814188634e-22,
  1.593363211997262e+00, -6.324233765520019e-03, -5.378543270628978e-05, -1.354812901099689e-07,  3.299711605691202e-09,  4.906985808967422e-11,  1.485606892985825e-13,
 -4.593076362512245e-15, -7.298573485607632e-17, -2.049665699079015e-19,  8.258639506499662e-21,  1.300804462969733e-22,  1.771752324141002e+00, -3.989120645687732e-03,
 -4.509197797410322e-05, -3.426562056115023e-07, -9.058654484448863e-10,  2.101183191051984e-11,  4.063556837021806e-13,  3.574026393981559e-15,  3.185893362787931e-18,
 -4.244278156568972e-19, -7.150054126633870e-21, -5.446354748019078e-23,  1.904390798797780e+00, -1.810363299704723e-03, -2.432622652699008e-05, -2.674480209123600e-07,
 -2.414923221644088e-09, -1.614391314113967e-11, -3.637382400665689e-14,  1.091031195864541e-15,  2.367865290540469e-17,  3.024265028979886e-19,  2.686578234429932e-21,
  1.208542457574766e-23,  1.981555810586144e+00, -3.650839627822410e-04, -5.366566535158722e-06, -6.918500443656885e-08, -8.217511985908607e-10, -9.164438583837269e-12,
 -9.658196632477591e-14, -9.605907736562271e-16, -8.934660677590773e-18, -7.604219150880340e-20, -5.619663342622707e-22, -3.042985498820645e-24,  5.864507623463897e-03,
 -1.008703269837206e-04,  1.297683922485485e-06, -1.478928125151132e-08,  1.572915072493080e-10, -1.597365123310756e-12,  1.566622006177403e-14, -1.493654517390984e-16,
  1.388807102283185e-18, -1.261893127902654e-20,  1.120288090842523e-22, -9.714757859333011e-25,  5.250723717879383e-02, -8.855588476259883e-04,  1.093192300735669e-05,
 -1.159109080320035e-07,  1.097969150058824e-09, -9.317367389972825e-12,  6.888758038221308e-14, -4.042164501809271e-16,  1.145103933177007e-18,  1.438375988741670e-20,
 -3.409125113268494e-22,  4.548494683035020e-24,  1.443200165615213e-01, -2.337806413861722e-03,  2.642733417272704e-05, -2.367820816996805e-07,  1.615011641878994e-09,
 -5.895984190336754e-12, -4.345545013035803e-14,  1.175490516865330e-15, -1.427201337792898e-17,  1.124818447198947e-19, -3.832230613379198e-22, -5.310630131893116e-24,
  2.782873096436175e-01, -4.231825580032801e-03,  4.124470128364986e-05, -2.605133858286153e-07,  3.205828774620801e-10,  1.717331042186112e-11, -2.546854347346815e-13,
  1.747209420776345e-15,  2.412499281538524e-18, -2.243912383313550e-19,  2.929379066849900e-21, -1.632781911446862e-23,  4.497176381423562e-01, -6.252230554124371e-03,
  4.801842373457344e-05, -1.091990124719940e-07, -2.527796157364551e-09,  3.565591081951988e-11, -1.251630695609485e-13, -2.514208273533876e-15,  4.270094475775552e-17,
 -1.860207620123472e-19, -3.172372762109667e-21,  6.122002868053182e-23,  6.520660350086281e-01, -8.027554341578523e-03,  4.118725425391378e-05,  1.875554944344140e-07,
 -4.580057374464181e-09,  1.430476274506888e-11,  3.947577266515761e-13, -4.732023647358114e-15, -1.227947544671295e-17,  7.191639089004768e-19, -4.206891663574846e-21,
 -6.576282952979480e-23,  8.767496760571979e-01, -9.182687430938164e-03,  1.973743984667213e-05,  4.767873328065165e-07, -3.188123597865762e-09, -3.881762702703540e-11,
  5.105255365390096e-13,  3.016111641149408e-15, -7.995625577436920e-17, -1.116345875873946e-19,  1.204321668720484e-20, -3.183648435937393e-23,  1.113025073762470e+00,
 -9.412515817491390e-03, -1.101498342426402e-05,  5.568370458626050e-07,  1.489567700826060e-09, -5.927531525798395e-11, -2.325403084299217e-13,  7.648493093504028e-15,
  3.895215705679103e-17, -1.090594231939631e-18, -6.830810521007637e-21,  1.649063949847262e-22,  1.348037499677003e+00, -8.571597359040358e-03, -4.008218873220241e-05,
  3.293990958565741e-07,  5.384789353999397e-09, -7.523883282895932e-12, -7.148120567760701e-13, -3.058637572433127e-15,  8.476864077865787e-17,  9.579889219313109e-19,
 -7.469650678686125e-21, -1.984556160120936e-22,  1.567196780156622e+00, -6.760047199348810e-03, -5.506155329322238e-05, -7.468954095298466e-08,  4.304962548887510e-09,
  5.082386584088002e-11, -1.333230315220230e-14, -6.971618443789759e-15, -7.302654295662173e-17,  2.404470416970082e-19,  1.392576651424035e-20,  1.176914946171160e-22,
  1.755048026837206e+00, -4.366514813047822e-03, -4.927513823790482e-05, -3.532242409544903e-07, -3.800054775307607e-10,  3.196055737724459e-11,  5.051390379883679e-13,
  3.371839621074324e-15, -1.778274768004711e-17, -7.538891616504386e-19, -9.148942232491578e-21, -3.018896560452958e-23,  1.896738839924706e+00, -2.018492264654124e-03,
 -2.777821164853425e-05, -3.087051866695438e-07, -2.743568770674918e-09, -1.655385158086394e-11,  6.573073294257897e-15,  2.044591824555596e-15,  3.660701510866680e-17,
  4.179841872905849e-19,  3.004189602019840e-21, -4.987916346380239e-26,  1.980004016603095e+00, -4.115756876710670e-04, -6.282157655146484e-06, -8.393503671690988e-08,
 -1.030576552477007e-09, -1.184016302519323e-11, -1.279252110189205e-13, -1.294897472273828e-15, -1.210850804048995e-17, -1.011205836096151e-19, -6.876895866846300e-22,
 -2.434663154902257e-24,  5.480722630730822e-03, -9.115825979515652e-05,  1.134320766350850e-06, -1.250910350084277e-08,  1.287896158381676e-10, -1.266931491706049e-12,
  1.204359314207392e-14, -1.114044216840198e-16,  1.005854275334429e-18, -8.888253154917809e-21,  7.683561086528596e-23, -6.505513233950014e-25,  4.913150698780240e-02,
 -8.033821371103665e-04,  9.640528344539759e-06, -9.974811937757057e-08,  9.272611751879477e-10, -7.795348133967246e-12,  5.814368924089487e-14, -3.615658562015590e-16,
  1.460082411150247e-18,  4.146350235828491e-21, -1.843110683574633e-22,  2.709678710756034e-24,  1.353742407632355e-01, -2.137323275334930e-03,  2.373694384864298e-05,
 -2.119316098160612e-07,  1.489077408300392e-09, -6.591931451986608e-12, -1.635008526703712e-14,  7.802565744124005e-16, -1.054050504577116e-17,  9.401403565967591e-20,
 -5.079499926664055e-22, -8.636762458589603e-25,  2.620002784289238e-01, -3.914261385094984e-03,  3.815962083663806e-05, -2.529517374849385e-07,  6.069034916837974e-10,
  1.164995420002208e-11, -2.057444289161761e-13,  1.716301990166295e-15, -3.739244300421587e-18, -1.225454659406493e-19,  2.151441578793840e-21, -1.797855802494332e-23,
  4.254678108938309e-01, -5.873959248646275e-03,  4.648831246546386e-05, -1.441232620538581e-07, -1.849650348631746e-09,  3.195469155601073e-11, -1.775831333427598e-13,
 -1.274439815314670e-15,  3.432423223379826e-17, -2.640863911337968e-19, -8.669628245266739e-22,  4.271166002514516e-23,  6.206273417901631e-01, -7.690274557665242e-03,
  4.300921891047472e-05,  1.170325488111818e-07, -4.210085087578647e-09,  2.216722448677830e-11,  2.603923878002489e-13, -4.747902901756202e-15,  1.002999686413258e-17,
  5.089340706136384e-19, -5.926057287915877e-21, -1.405807584800107e-23,  8.403696647752245e-01, -9.002823846069345e-03,  2.512943069504366e-05,  4.202557563363244e-07,
 -3.836607635463139e-09, -2.584120493677744e-11,  5.591924096217426e-13,  4.820997170480925e-16, -7.584288023710773e-17,  3.205150398813753e-19,  9.102194416569825e-21,
 -9.499563409536892e-23,  1.075241541548868e+00, -9.473594042703232e-03, -4.229840325955447e-06,  5.709577135896674e-07,  2.661668115480579e-10, -6.218333330090333e-11,
 -7.123790886007549e-15,  8.229067639759565e-15, -3.358607200907939e-18, -1.206540645425140e-18,  1.202509369452005e-21,  1.879269834734664e-22,  1.313136874457147e+00,
 -8.874996662601393e-03, -3.562051037537906e-05,  4.133965702866783e-07,  5.057530327001848e-09, -2.537116541996379e-11, -7.578017717996429e-13,  1.312933047595823e-16,
  1.118234221706084e-16,  4.912897759974255e-19, -1.553726554038771e-20, -1.533322638312113e-22,  1.539271684491624e+00, -7.202876982847137e-03, -5.551125642318359e-05,
  2.233314454831014e-09,  5.301112457030951e-09,  4.790943731887147e-11, -2.391320005499718e-13, -9.053367827218525e-15, -5.325989472536571e-17,  8.818752430019456e-19,
  1.752258493055996e-20,  3.200931659031937e-23,  1.736766644035924e+00, -4.777721030947054e-03, -5.352699780835630e-05, -3.535013414178963e-07,  3.876382766434186e-10,
  4.512488011381350e-11,  5.869898219819249e-13,  2.296280311622733e-15, -5.167988457984595e-17, -1.129106497571313e-18, -9.078906250148063e-21,  4.328769803941253e-23,
  1.888195871381432e+00, -2.256307056723720e-03, -3.175689494612264e-05, -3.552202997941471e-07, -3.067685020095590e-09, -1.556201873669009e-11,  8.264697938432674e-14,
  3.479534060887217e-15,  5.374954665539543e-17,  5.303412923079844e-19,  2.373094190095007e-21, -3.335191816431630e-23,  1.978250399354227e+00, -4.661612928840462e-04,
 -7.396703985481148e-06, -1.024986622489556e-07, -1.301259954959392e-09, -1.539279608684906e-11, -1.701931197502849e-13, -1.746099871693396e-15, -1.626440517268637e-17,
 -1.301330278329371e-19, -7.411011560903491e-22,  6.147251758826617e-25,  5.133335070638278e-03, -8.265092857162637e-05,  9.957872766240605e-07, -1.063647256252886e-08,
  1.061063989049349e-10, -1.011955731588223e-12,  9.330714547859764e-15, -8.379530510582516e-17,  7.349361546156028e-19, -6.318811160996801e-21,  5.316775351362321e-23,
 -4.397099210882877e-25,  4.606498708235217e-02, -7.308049780788832e-04,  8.527659480539659e-06, -8.608672271534479e-08,  7.845163699132550e-10, -6.516013674427986e-12,
  4.868749220231980e-14, -3.136680226547942e-16,  1.501867287848122e-18, -1.219017358602625e-21, -9.225920429366251e-23,  1.565889202262313e-24,  1.271891904239427e-01,
 -1.957205536787688e-03,  2.133231495444533e-05, -1.891756198423389e-07,  1.354900156480871e-09, -6.757295623632353e-12,  1.255602085787979e-15,  4.931635665166303e-16,
 -7.523934393533999e-18,  7.367126572494325e-20, -4.944014723547585e-22,  1.183174471040073e-24,  2.469348167891650e-01, -3.620944979220920e-03,  3.518932658344320e-05,
 -2.416295304211422e-07,  7.943313493855327e-10,  7.271723963011878e-12, -1.599167677417614e-13,  1.541153435928346e-15, -6.787415518527756e-18, -5.170965900769743e-20,
  1.410185337285210e-21, -1.530267310113505e-23,  4.027041853439624e-01, -5.509426755311285e-03,  4.460157884836630e-05, -1.688464992311619e-07, -1.255463322525100e-09,
  2.737966159270200e-11, -1.993476016987336e-13, -3.315501192098802e-16,  2.459195924624475e-17, -2.670680071493523e-19,  5.761162490947201e-22,  2.332870112572676e-23,
  5.905617157954945e-01, -7.341692708007687e-03,  4.402505010220202e-05,  5.351314808066270e-08, -3.714761401501988e-09,  2.687289240062839e-11,  1.343694012179082e-13,
 -4.180013895243440e-15,  2.404707857770890e-17,  2.714668852161855e-19, -5.687254211057662e-21,  2.159173601205694e-23,  8.047908606487196e-01, -8.782694219343046e-03,
  2.978949327891667e-05,  3.554644433599167e-07, -4.219495798722227e-09, -1.251988923491269e-11,  5.408989221146630e-13, -1.698740556242030e-15, -5.884207125353785e-17,
  5.924504153515547e-19,  4.366828789630403e-21, -1.126604919621678e-22,  1.037322858706809e+00, -9.480048590421720e-03,  2.606345579453062e-06,  5.653353744435451e-07,
 -9.607766391699714e-10, -5.964089247351390e-11,  2.154132347005295e-13,  7.451591613479621e-15, -4.401598548364152e-17, -1.002892511790382e-18,  8.614369962905338e-21,
  1.382047424181689e-22,  1.277100260984059e+00, -9.138787009906323e-03, -3.019415324949624e-05,  4.892781850522132e-07,  4.370674896246989e-09, -4.309817962625620e-11,
 -7.022924751997538e-13,  3.861329170196785e-15,  1.169846215012345e-16, -2.324835087389469e-19, -1.971278902251564e-20, -2.526836252734231e-23,  1.509574294738264e+00,
 -7.645347576650786e-03, -5.494518263972131e-05,  9.431556607734484e-08,  6.180523348770379e-09,  3.896994404581086e-11, -5.107457497861383e-13, -1.011419056174611e-14,
 -8.942513690809371e-18,  1.567550285591275e-18,  1.556247158289959e-20, -1.317650291202463e-22,  1.716772707507016e+00, -5.222725984263465e-03, -5.769948822513011e-05,
 -3.392957195697780e-07,  1.435087504738123e-09,  5.975737652287199e-11,  6.215542133632243e-13, -7.214899606173147e-17, -9.808715054553454e-17, -1.418263545928054e-18,
 -4.372134296390260e-21,  1.812720964419101e-22,  1.878634328015643e+00, -2.528269975629831e-03, -3.632385870509583e-05, -4.066485578811454e-07, -3.350117098977868e-09,
 -1.219680198920796e-11,  2.071331453697314e-13,  5.519457020154919e-15,  7.404272105329224e-17,  5.783669959576277e-19, -4.879270841954785e-22, -1.045224146022863e-22,
  1.976259084567336e+00, -5.306337292136453e-04, -8.762535120980805e-06, -1.260213391200066e-07, -1.654245433281235e-09, -2.012746262484987e-11, -2.271146008200389e-13,
 -2.347074844550657e-15, -2.145877608413530e-17, -1.572083966757831e-19, -5.481747574414740e-22,  9.582373522159881e-24,  4.817894392729934e-03, -7.516778299927824e-05,
  8.777052721401307e-07, -9.089268319447002e-09,  8.792950113981207e-11, -8.137126747625624e-13,  7.282221001783019e-15, -6.354157971177006e-17,  5.414965611787325e-19,
 -4.533838736718156e-21,  3.709226672071429e-23, -3.004707078843403e-25,  4.327195582897963e-02, -6.665119827635168e-04,  7.565829540889906e-06, -7.451642365357548e-08,
  6.651975075240213e-10, -5.447538511557297e-12,  4.056665810791157e-14, -2.669022588813788e-16,  1.406007859033828e-18, -3.762557034956365e-21, -3.998616484012370e-23,
  8.672708607888185e-25,  1.196878147485719e-01, -1.795269153087975e-03,  1.918783513560386e-05, -1.685725118266782e-07,  1.221043387501834e-09, -6.586347752825538e-12,
  1.206563667823257e-14,  2.911353635078109e-16, -5.212544704826174e-18,  5.521201877809010e-20, -4.235794947873166e-22,  1.877279027957327e-24,  2.329960202290488e-01,
 -3.350802756698841e-03,  3.237019086200179e-05, -2.279510727006171e-07,  9.047483140989437e-10,  3.925643581201691e-12, -1.200147662951524e-13,  1.303808690963653e-15,
 -7.785551146931419e-18, -7.624611196129228e-21,  8.231433818165547e-22, -1.133470738152810e-23,  3.813668418820073e-01, -5.161020323860671e-03,  4.247211989356460e-05,
 -1.848147841646535e-07, -7.560428713045289e-10,  2.256416229938567e-11, -1.990173019039229e-13,  3.077215437239922e-16,  1.559522463749661e-17, -2.283013356683244e-19,
  1.253106185758926e-21,  8.362605928641936e-24,  5.619020413503315e-01, -6.987892296863975e-03,  4.432878972746430e-05, -1.486282537896549e-09, -3.154053004737682e-09,
  2.878774129503275e-11,  2.927094616211994e-14, -3.295805074532422e-15,  3.001089419911773e-17,  6.894588645797896e-20, -4.325840458823557e-21,  3.718007841664445e-23,
  7.701620912424006e-01, -8.528478225352144e-03,  3.364396380104695e-05,  2.866349227915509e-07, -4.344942973452777e-09, -3.011892217875303e-13,  4.703643617882607e-13,
 -3.216225292430732e-15, -3.553198268882366e-17,  6.720146991475288e-19, -2.311713897816835e-22, -9.138959059237519e-23,  9.994868456171018e-01, -9.432411549079594e-03,
  9.259868488243387e-06,  5.407689781890671e-07, -2.085949710166725e-09, -5.215711772985476e-11,  3.994465625993553e-13,  5.542282667981779e-15, -7.268761111194024e-17,
 -5.629924707198219e-19,  1.267894780571757e-20,  4.265127890742558e-23,  1.240100776368755e+00, -9.355737305599333e-03, -2.393452308330634e-05,  5.514417031345851e-07,
  3.351052160168519e-09, -5.824595166512290e-11, -5.441079530090085e-13,  7.319420488047501e-15,  9.458896986974148e-17, -9.953258821163449e-19, -1.723572996848410e-20,
  1.372437875907129e-22,  1.478123394875680e+00, -8.078646358925837e-03, -5.319676578558720e-05,  1.986769566924617e-07,  6.814472971892261e-09,  2.333743630327608e-11,
 -7.886916968868605e-13, -9.392065673247846e-15,  5.677564089665906e-17,  2.016856439639189e-18,  5.502209439525826e-21, -3.222453664961347e-22,  1.694933502706808e+00,
 -5.700121675236798e-03, -6.159122171998394e-05, -3.059703131636527e-07,  2.777208177906171e-09,  7.424781160124054e-11,  5.677802207919203e-13, -4.042914575399838e-15,
 -1.498969050831033e-16, -1.381232774473379e-18,  7.561184982732099e-21,  3.634693661994435e-22,  1.867907852748952e+00, -2.839307710924532e-03, -4.153227190098205e-05,
 -4.618742129337523e-07, -3.530359011479445e-09, -5.084483065089042e-12,  3.978911192686288e-13,  8.207321661645856e-15,  9.311335813054253e-17,  4.340671645871203e-19,
 -7.647840166441569e-21, -2.309967290122231e-22,  1.973986093335045e+00, -6.072656239140506e-04, -1.044790677093693e-05, -1.560296259473034e-07, -2.117049038583970e-09,
 -2.644978022120619e-11, -3.033210395127237e-13, -3.127425048255285e-15, -2.736589841237667e-17, -1.654723333218913e-19,  2.963224367373757e-22,  3.196946998094926e-23,
  4.530607969159844e-03, -6.855968689204062e-05,  7.765674220900284e-07, -7.803665836969967e-09,  7.326838321472982e-11, -6.584724715492888e-13,  5.723011014924418e-15,
 -4.856284441990835e-17,  4.020756205155601e-19, -3.284720737031322e-21,  2.602987034732360e-23, -2.087659197309567e-25,  4.072154285933934e-02, -6.093891498767656e-04,
  6.732060669755071e-06, -6.469442191078232e-08,  5.654031105625708e-10, -4.558668261723426e-12,  3.370111150354699e-14, -2.243200351267399e-16,  1.249651300832602e-18,
 -4.739649450745908e-21, -1.196866178690665e-23,  4.397572926967253e-25,  1.128013878131056e-01, -1.649535725336678e-03,  1.727789594037814e-05, -1.500714447709088e-07,
  1.092782449004641e-09, -6.216075832734591e-12,  1.815865081542696e-14,  1.530303425158654e-16, -3.509609673235496e-18,  3.995421758657506e-20, -3.394070938797006e-22,
  1.869528255256359e-24,  2.200937620567475e-01, -3.102531779976746e-03,  2.972375050259661e-05, -2.129915913958085e-07,  9.572688606146506e-10,  1.455167048965577e-12,
 -8.699731935783702e-14,  1.055727225274091e-15, -7.577153245482636e-18,  1.646124558631819e-20,  4.080037864952656e-22, -7.657018438550097e-24,  3.613880213777250e-01,
 -4.830287488223431e-03,  4.019582430759173e-05, -1.935568723714778e-07, -3.515653416256180e-10,  1.794029960779952e-11, -1.845778402034806e-13,  6.854645908822425e-16,
  8.337892752576237e-18, -1.739691158511857e-19,  1.395245228291017e-21, -1.028346935449140e-24,  5.346584665072851e-01, -6.634147365448602e-03,  4.402720780939997e-05,
 -4.733632808126425e-08, -2.578181550586257e-09,  2.849255304675110e-11, -4.941276686091988e-14, -2.325868364869353e-15,  2.978223440467541e-17, -7.050108747886214e-20,
 -2.648331125273005e-21,  3.704762852318637e-23,  7.366066017786242e-01, -8.246746496430382e-03,  3.666816777895361e-05,  2.176483542222370e-07, -4.245943698049004e-09,
  9.800527366662749e-12,  3.679735782862209e-13, -3.975164714281051e-15, -1.237456788260917e-17,  5.935305444982581e-19, -3.398835554568501e-21, -5.133041082739407e-23,
  9.619455547899686e-01, -9.333018721231471e-03,  1.551624094820078e-05,  4.996173510945174e-07, -3.022079907820095e-09, -4.098620192396216e-11,  5.197297812984769e-13,
  2.991753743669914e-15, -8.364591289614843e-17, -4.790833979342188e-20,  1.237669411491641e-20, -5.264117686484453e-23,  1.202337949068548e+00, -9.519925576528889e-03,
 -1.703605808690774e-05,  5.951050350435553e-07,  2.073758601683869e-09, -6.854070945533027e-11, -3.030427523548787e-13,  9.654232336734667e-15,  4.818040193352051e-17,
 -1.523559972460073e-18, -8.316559462882329e-21,  2.541734572882610e-22,  1.444975415225164e+00, -8.492802089422956e-03, -5.014661514639660e-05,  3.103292095143048e-07,
  7.071983368662736e-09,  1.526271733500492e-12, -1.015190082866279e-12, -6.401490298639668e-15,  1.295265186005626e-16,  1.911153706736853e-18, -1.159361230542360e-20,
 -4.310345805970727e-22,  1.671125523732043e+00, -6.206665189151352e-03, -6.494498150339197e-05, -2.489637486945818e-07,  4.386276350370682e-09,  8.593106277822580e-11,
  3.805617776593488e-13, -9.542558156907520e-15, -1.898748354605159e-16, -7.110433585273088e-19,  2.694413891040672e-20,  4.973457452113248e-22,  1.855849642016692e+00,
 -3.194700050404023e-03, -4.741512356316764e-05, -5.185702731693932e-07, -3.516148653954812e-09,  7.571043921734984e-12,  6.712096772834592e-13,  1.135511714516201e-14,
  1.003335998210727e-16, -1.252337103013065e-19, -2.163515389378664e-20, -4.109933050934539e-22,  1.971377136701137e+00, -6.989570661534762e-04, -1.254232286037903e-05,
 -1.945615285065715e-07, -2.726468911283942e-09, -3.488459723615589e-11, -4.040088643645291e-13, -4.092724792418704e-15, -3.266390233794054e-17, -1.132675270335334e-19,
  2.683792435743167e-21,  8.321113994588934e-23,  4.268228095620189e-03, -6.270274906176053e-05,  6.895455758360008e-07, -6.729701987596130e-09,  6.136939102516183e-11,
 -5.360859183408613e-13,  4.526938914261610e-15, -3.740423967206889e-17,  3.005336880216396e-19, -2.407840945298630e-21,  1.824487665358266e-23, -1.494341554783943e-25,
  3.838699078082210e-02, -5.584908610634833e-04,  6.007134294115498e-06, -5.633546908846022e-08,  4.818319293904784e-10, -3.820854507093538e-12,  2.795387659482739e-14,
 -1.871212638765222e-16,  1.074246409513057e-18, -4.920062527090756e-21,  9.716515717071073e-25,  1.675918958254617e-25,  1.064686931900174e-01, -1.518228038569780e-03,
  1.557792327666350e-05, -1.335565741799274e-07,  9.731058049722309e-10, -5.740301509838175e-12,  2.106965542177215e-14,  6.127235512737617e-17, -2.296555453679089e-18,
  2.793739659673688e-20, -2.639682278584371e-22,  1.525379428911262e-24,  2.081433972213872e-01, -2.874703472477009e-03,  2.726036844227776e-05, -1.975463418230890e-07,
  9.677483165892302e-10, -3.047983745493732e-13, -6.072352420261274e-14,  8.252852625384216e-16, -6.763778866119503e-18,  2.692970048110275e-20,  1.355392797337668e-22,
 -4.893752487216680e-24,  3.426951933147427e-01, -4.518081509542699e-03,  3.785047148920148e-05, -1.965451617120320e-07, -3.537074618735145e-11,  1.376549133416680e-11,
 -1.625152298419821e-13,  8.626464525772461e-16,  3.052699604973542e-18, -1.207615843907156e-19,  1.230239585450578e-21, -5.843156092981633e-24,  5.088217812347169e-01,
 -6.284860324232764e-03,  4.323020689383140e-05, -8.411310000345910e-08, -2.024920418452837e-09,  2.662984808559406e-11, -1.017040795483285e-13, -1.430824891943376e-15,
  2.571102932096455e-17, -1.460319792719823e-19, -1.193161009875935e-21,  2.823224208365807e-23,  7.042212406451976e-01, -7.944091105911698e-03,  3.888025529486222e-05,
  1.517227712274281e-07, -3.970786370428724e-09,  1.727020071882480e-11,  2.541282867644805e-13, -4.059204101984792e-15,  6.111556695306387e-18,  4.244414832912349e-19,
 -4.771905478305019e-21, -1.255812461631699e-23,  9.248984737565654e-01, -9.185786943074370e-03,  2.119673867855730e-05,  4.454070598001734e-07, -3.711841430544321e-09,
 -2.780823567152850e-11,  5.664147729438492e-13,  3.772140685944214e-16, -7.721046516307375e-17,  3.803085902137449e-19,  8.610934996637284e-21, -1.105697407556860e-22,
  1.164031554118156e+00, -9.627191219743666e-03, -9.741976543713969e-06,  6.170178669637649e-07,  6.527887234971447e-10, -7.244810929804254e-11, -1.971152617840018e-14,
  1.027696676685888e-14, -9.839500939491280e-18, -1.620975269698639e-18,  3.514721164852642e-21,  2.636180789343777e-22,  1.410228153586190e+00, -8.877162175441482e-03,
 -4.574717958347331e-05,  4.223495987628943e-07,  6.847020352008878e-09, -2.446136844681309e-11, -1.126913325251611e-12, -1.282251130419551e-15,  1.854531998628724e-16,
  1.075940867289519e-18, -2.957637693498653e-20, -3.495924590270068e-22,  1.645242682013253e+00, -6.736848896607936e-03, -6.745342041833894e-05, -1.646415235682081e-07,
  6.170971685490534e-09,  9.115651067231604e-11,  2.619067347710442e-14, -1.577705797375862e-14, -1.907848126307657e-16,  8.018799848997260e-19,  4.810545848129954e-20,
  4.125529165856523e-22,  1.842271461317211e+00, -3.599851047167057e-03, -5.396737419959178e-05, -5.726275184972170e-07, -3.176051440280103e-09,  2.784712690862220e-11,
  1.032012562446397e-12,  1.428793878968230e-14,  7.538806264631050e-17, -1.406614218943918e-18, -4.365475595966789e-20, -5.753553097991630e-22,  1.968364723163924e+00,
 -8.094328515097685e-04, -1.516364424859914e-05, -2.443345213255130e-07, -3.531028348166364e-09, -4.607690101002117e-11, -5.336551664537344e-13, -5.173834915541712e-15,
 -3.369339150869879e-17,  9.395905982034851e-20,  8.471071757816643e-21,  1.929682240983703e-22,  4.027960909011882e-03, -5.749349586637355e-05,  6.143449905706342e-07,
 -5.827999865352545e-09,  5.165459903089348e-11, -4.389958417063597e-13,  3.602161619138473e-15, -2.904531096813613e-17,  2.255201602059388e-19, -1.796893694413991e-21,
  1.259265556193362e-23, -1.092486667492861e-25,  3.624503764396132e-02, -5.130124103831471e-04,  5.374956139748474e-06, -4.920275668345215e-08,  4.117187615591542e-10,
 -3.209112840188348e-12,  2.316923578789857e-14, -1.555609197102769e-16,  8.990763078322867e-19, -4.789700500225976e-21,  4.377359381102016e-24,  8.601955469092453e-27,
  1.006352399053023e-01, -1.399759227565921e-03,  1.406496420174416e-05, -1.188774095923117e-07,  8.634562280026159e-10, -5.221487050832837e-12,  2.189381580744585e-14,
  1.960349603173720e-18, -1.465847755381277e-18,  1.859461197501054e-20, -2.061668245821505e-22,  1.121663518729325e-24,  1.970661061065541e-01, -2.665840462287497e-03,
  2.498227894938792e-05, -1.821828915204734e-07,  9.488279547476413e-10, -1.508401460714184e-12, -4.049476024556691e-14,  6.250184597083934e-16, -5.742982417232266e-18,
  2.865346866985124e-20, -3.544421225180728e-23, -2.969402696376775e-24,  3.252135497078996e-01, -4.224701938106566e-03,  3.549695552846819e-05, -1.951121721217890e-07,
  2.029331041317622e-10,  1.016232282865627e-11, -1.375825041771518e-13,  8.997245634513810e-16, -4.773829812392745e-19, -7.736455119018587e-20,  9.281709363091190e-22,
 -7.415944312751530e-24,  4.843669052892406e-01, -5.943567321561884e-03,  4.204357010182720e-05, -1.123956869110567e-07, -1.519518688325573e-09,  2.379603371145281e-11,
 -1.310915227734479e-13, -6.991641634312964e-16,  1.986426277090905e-17, -1.722029387552978e-19, -1.965769406159014e-22,  1.717505695835422e-23,  6.730770035451399e-01,
 -7.626818210397770e-03,  4.033210056571815e-05,  9.124672640964648e-08, -3.573428569822892e-09,  2.204027144198035e-11,  1.452394321832084e-13, -3.656529604770130e-15,
  1.790442838931927e-17,  2.313085807276726e-19, -4.692771264114980e-21,  1.381585117517006e-23,  8.885268497078337e-01, -8.995880587439716e-03,  2.616932383662428e-05,
  3.823056355616822e-07, -4.132592431920668e-09, -1.435194707539736e-11,  5.448613439477406e-13, -1.817930491606642e-15, -5.855291104073049e-17,  6.214458694984385e-19,
  3.384710808517810e-21, -1.191341788194022e-22,  1.125413916833262e+00, -9.675442423296590e-03, -2.322729132417798e-06,  6.159416051296790e-07, -7.780034774099121e-10,
 -6.955611434605951e-11,  2.551817664642933e-13,  9.077020442163649e-15, -6.306283282485980e-17, -1.271102843380349e-18,  1.325056953231938e-20,  1.646980805261027e-22,
  1.374022216775375e+00, -9.221051180593852e-03, -4.004257851182568e-05,  5.265188410537630e-07,  6.088011342814548e-09, -5.124057170363956e-11, -1.075692956471772e-12,
  5.017622267793503e-15,  1.998166151697652e-16, -3.427268200300916e-19, -3.925041676550060e-20, -6.243262604239320e-23,  1.617206070587307e+00, -7.282562563495677e-03,
 -6.877687074355908e-05, -5.144891327779156e-08,  7.961203992936710e-09,  8.583484628354325e-11, -4.938729708288780e-13, -2.101917296257799e-14, -1.238175608930211e-16,
  2.983281663811086e-18,  5.760968759594771e-20, -4.740248116673066e-23,  1.826963907509676e+00, -4.059888284048637e-03, -6.112068513591270e-05, -6.175028586170638e-07,
 -2.337858440039172e-09,  5.762869253405263e-11,  1.455541129956252e-12,  1.550262612469670e-14, -1.290679612986201e-17, -3.668081830671642e-18, -6.899982834021654e-20,
 -5.112850875053427e-22,  1.964864349769628e+00, -9.435053134682149e-04, -1.846744185796992e-05, -3.089505456582400e-07, -4.592984265495797e-09, -6.073893883848719e-11,
 -6.925313719768592e-13, -6.112826825574888e-15, -2.168755030636867e-17,  6.569412234730812e-19,  2.126435830610745e-20,  4.119118461610852e-22,  3.807392509860464e-03,
 -5.284506795634557e-05,  5.490925901551019e-07, -5.067330969817842e-09,  4.367729904219665e-11, -3.615442231876358e-13,  2.880843072952442e-15, -2.277519273778659e-17,
  1.688433785595432e-19, -1.377787847578583e-21,  8.679664597645532e-24, -6.502141318015345e-26,  3.427539979867090e-02, -4.722671947665014e-04,  4.822024002957072e-06,
 -4.309992634764512e-08,  3.527604394282426e-10, -2.702226705619148e-12,  1.919063534974196e-14, -1.295155723669516e-16,  7.297973822305950e-19, -4.613101152666920e-21,
  4.861114382502589e-24,  7.002958861331616e-26,  9.525252907580220e-02, -1.292718520963082e-03,  1.271797322017306e-05, -1.058690676551980e-07,  7.642604800687129e-10,
 -4.700113356528091e-12,  2.138183242557372e-14, -3.573500635221744e-17, -9.334876198219549e-19,  1.129014184949639e-20, -1.587741046626516e-22,  1.177314480196987e-24,
  1.867889757500389e-01, -2.474471536058075e-03,  2.288602052490704e-05, -1.672902050213180e-07,  9.102553903536597e-10, -2.290098534096586e-12, -2.541530393847245e-14,
  4.572497678762091e-16, -4.763617900211841e-18,  2.516471041236646e-20, -1.240881803865505e-22, -8.865197069448690e-25,  3.088679615937480e-01, -3.950022156913347e-03,
  3.318124028735995e-05, -1.904101746341640e-07,  3.751813755519831e-10,  7.158590990627889e-12, -1.129753597068532e-13,  8.464212485852223e-16, -2.671396691848546e-18,
 -4.655110445444052e-20,  6.246055158071026e-22, -5.712588628566032e-24,  4.612562538111382e-01, -5.612992031490891e-03,  4.056408448005599e-05, -1.330770012516365e-07,
 -1.076298856903857e-09,  2.048099822419307e-11, -1.427039796191155e-13, -1.629028631499018e-16,  1.368062825746364e-17, -1.676068847408265e-19,  3.718566022936671e-22,
  9.801523229441986e-24,  6.432206523812016e-01, -7.300718971681530e-03,  4.109908009066864e-05,  3.775414566479520e-08, -3.105696043105811e-09,  2.436860055124216e-11,
  5.187976278378259e-14, -2.985084334051871e-15,  2.304544622773669e-17,  6.070106579666522e-20, -3.730209815919622e-21,  2.876132930942143e-23,  8.529894817836573e-01,
 -8.769316690726451e-03,  3.035303593381807e-05,  3.145775003322917e-07, -4.293991630401424e-09, -2.076468226260112e-12,  4.712195295862474e-13, -3.317419623876114e-15,
 -3.494705701732748e-17,  6.591253937558083e-19, -1.258626616262852e-21, -8.607051645613746e-23,  1.086721360116662e+00, -9.664773829060735e-03,  4.949277778373757e-06,
  5.927791357326843e-07, -2.088639083088327e-09, -6.064822785473760e-11,  4.750061558517719e-13,  6.440825743976392e-15, -9.791724468861664e-17, -6.382632746748352e-19,
  1.733372757719160e-20,  2.104835912962846e-23,  1.336539570210188e+00, -9.514549675057864e-03, -3.317810455722930e-05,  6.143863418620467e-07,  4.820059826958354e-09,
 -7.467099177398677e-11, -8.496960269580901e-13,  1.091247532442012e-14,  1.595504647799121e-16, -1.858140237432708e-18, -3.378929519149713e-20,  3.093826707659638e-22,
  1.586974702884254e+00, -7.832956366196481e-03, -6.857598029758664e-05,  8.881318274887971e-08,  9.509864051597075e-09,  6.658653694894103e-11, -1.118648186072112e-12,
 -2.283477204438324e-14,  2.263883913955763e-17,  5.032118062360166e-18,  3.918824709486121e-20, -8.145665454896097e-22,  1.809698727360150e+00, -4.579029149608996e-03,
 -6.871057327620520e-05, -6.436449892766401e-07, -8.016262406457962e-10,  9.758186952874058e-11,  1.859963076286470e-12,  1.240750159657224e-14, -1.988710532863040e-16,
 -6.736340947993307e-18, -7.943341898016236e-20,  1.799656696608680e-22,  1.960769476029347e+00, -1.107422250033085e-03, -2.265894950935239e-05, -3.931188449238305e-07,
 -5.988122522905624e-09, -7.946331974642955e-11, -8.684473630907517e-13, -6.223027976526115e-15,  2.253798437385106e-17,  1.971387685875275e-18,  4.733279685134707e-20,
  8.073884785927552e-22,  3.604428679354712e-03, -4.868420507083797e-05,  4.922506214977957e-07, -4.422791041420522e-09,  3.708913198132660e-11, -2.994894686709281e-13,
  2.311774040358476e-15, -1.810319678434513e-17,  1.249909147908790e-19, -1.066278496287181e-21,  7.547507049890970e-24,  2.517332254111984e-26,  3.246033805155644e-02,
 -4.356677991049159e-04,  4.336984221662789e-06, -3.786427846185535e-08,  3.030409094543989e-10, -2.282681589774735e-12,  1.586651546725535e-14, -1.087691889028267e-16,
  5.690055683811485e-19, -4.233587082424190e-21,  1.842434295176481e-23,  6.676397102834047e-25,  9.027738079718022e-02, -1.195855536544160e-03,  1.151790059038029e-05,
 -9.436543272697397e-08,  6.752928036133331e-10, -4.201997326992518e-12,  2.001607241060014e-14, -6.021248905667642e-17, -6.263784102724171e-19,  6.276137400127784e-21,
 -8.095882265969241e-23,  2.700739646114693e-24,  1.772448965809990e-01, -2.299169388112899e-03,  2.096431493350984e-05, -1.531216226059050e-07,  8.593051910156170e-10,
 -2.762853176369672e-12, -1.461721293712141e-14,  3.183324421538237e-16, -3.947374649074854e-18,  2.046157909139272e-20, -7.921548593512947e-23,  3.525698341347682e-24,
  2.935844588950747e-01, -3.693599910496263e-03,  3.093660462465753e-05, -1.834013520205319e-07,  4.931028915240504e-10,  4.720533438146274e-12, -9.069232930223854e-14,
  7.385423893603061e-16, -3.944001865973989e-18, -2.494852013294125e-20,  5.090307636155907e-22,  1.688105032475937e-24,  4.394428234016103e-01, -5.295129887199724e-03,
  3.887674820357325e-05, -1.472076402955247e-07, -7.010648670380228e-10,  1.704538418825115e-11, -1.420182074136872e-13,  1.820275378192141e-16,  8.016108482836895e-18,
 -1.441791927613546e-19,  8.220952632864171e-22,  1.300230267143123e-23,  6.146770877273438e-01, -6.970921536427403e-03,  4.127021143308017e-05, -7.997266220650179e-09,
 -2.612207358741817e-09,  2.469511389495556e-11, -2.123958673474680e-14, -2.238760303333429e-15,  2.288498915407895e-17, -5.926599701561008e-20, -2.158890022071068e-21,
  4.401174257823492e-23,  8.184201232595046e-01, -8.512559978089944e-03,  3.371627154120378e-05,  2.461222902847144e-07, -4.230514071744039e-09,  8.013190872913335e-12,
  3.661352303749058e-13, -4.072221130769888e-15, -1.288709578813169e-17,  5.499627565368283e-19, -3.728762498152891e-21, -2.149569468418760e-23,  1.048185586291450e+00,
 -9.597382201456849e-03,  1.182424835652039e-05,  5.503313236806898e-07, -3.174896894393102e-09, -4.745447467238126e-11,  6.089817459564615e-13,  3.073279042799837e-15,
 -1.085170093324808e-16,  3.895592696972244e-20,  1.582156401877282e-20, -7.466914397863534e-23,  1.297998908068878e+00, -9.749293054457160e-03, -2.539530774099580e-05,
  6.785653260938643e-07,  3.150150308213305e-09, -9.089053729884937e-11, -4.844010915625163e-13,  1.471938473139685e-14,  7.248149046904111e-17, -2.843862445893262e-18,
 -1.346552332197514e-20,  5.866508564964951e-22,  1.554556183525816e+00, -8.374623823981305e-03, -6.655863878023348e-05,  2.499524564660540e-07,  1.052249642181127e-08,
  3.232457868008275e-11, -1.718960836498473e-12, -1.899269130457961e-14,  2.213810480939578e-16,  5.669623883355139e-18, -1.179359029170020e-20, -1.417383664570111e-21,
  1.790234232789342e+00, -5.159662132329821e-03, -7.643872383599908e-05, -6.383304155851033e-07,  1.619797748397916e-09,  1.454255955535885e-10,  2.077654847424939e-12,
  1.589650199863585e-15, -4.929343004604227e-16, -9.329832508577198e-18, -3.769089257222449e-20,  1.900988323750609e-21,  1.955944898505609e+00, -1.309320746539492e-03,
 -2.800750574759325e-05, -5.028321859556258e-07, -7.799177024630273e-09, -1.022349621614558e-10, -1.018871906246654e-12, -3.921875653711068e-15,  1.376145032348879e-16,
  4.738944018168978e-18,  9.543705679630605e-20,  1.407761004426172e-21,  3.417245402611489e-03, -4.494884228770551e-05,  4.425493352807035e-07, -3.874433335438521e-09,
  3.161530353822850e-11, -2.496708846632916e-13,  1.855550052031275e-15, -1.465468955895135e-17,  9.269979081712512e-20, -6.977817517850922e-22,  1.212464035664424e-23,
  1.955774413340961e-25,  3.078429287396669e-02, -4.027103238219083e-04,  3.910262513737293e-06, -3.336116323416643e-08,  2.609586129811062e-10, -1.936508097502217e-12,
  1.305442498383141e-14, -9.277967780171601e-17,  4.400831138750169e-19, -2.552221692187327e-21,  7.593382759760525e-23,  2.072313606361775e-24,  8.567132438915127e-02,
 -1.108064413411826e-03,  1.044765307760428e-05, -8.420757794941034e-08,  5.959092726487777e-10, -3.743914818623191e-12,  1.808062382541571e-14, -7.697989467779507e-17,
 -4.216383735912762e-19,  6.376494768346581e-21,  1.139674017818661e-22,  6.521303463258993e-24,  1.683723351217449e-01, -2.138575284859290e-03,  1.920747121537526e-05,
 -1.398310746025219e-07,  8.011910453180600e-10, -3.020311713966377e-12, -7.363575692606170e-15,  2.036215178374962e-16, -3.210661151251905e-18,  2.262742255250890e-20,
  2.505402233015016e-22,  1.213734543811598e-23,  2.792913043092042e-01, -3.454769773712273e-03,  2.878587731866123e-05, -1.748679180542123e-07,  5.673457233687760e-10,
  2.777124571178687e-12, -7.188511595884901e-14,  6.022664691266894e-16, -4.422428960581027e-18,  8.954134501216027e-22,  8.966678389865440e-22,  1.719142892635635e-23,
  4.188729074905981e-01, -4.991347841628005e-03,  3.705361022265189e-05, -1.558804129878067e-07, -3.936983334538909e-10,  1.372255760350548e-11, -1.340576335869337e-13,
  3.632024889777579e-16,  3.593480414515226e-18, -9.544799702727012e-20,  1.751694959407223e-21,  3.171621787377444e-23,  5.874521632251026e-01, -6.641816977381114e-03,
  4.093962667507670e-05, -4.588891665632744e-08, -2.128062627634242e-09,  2.351342637815349e-11, -7.408803976584528e-14, -1.553044682538517e-15,  1.972775943050929e-17,
 -9.962545023687188e-20,  3.497724071051686e-22,  7.259023326005167e-23,  7.849264441964808e-01, -8.232151548798191e-03,  3.627033748062105e-05,  1.801542340820219e-07,
 -3.991780618262498e-09,  1.540281603634935e-11,  2.491072073983582e-13, -4.197005031829865e-15,  4.223036418118299e-18,  4.068241849697360e-19, -2.773803842342040e-21,
  6.797280414379255e-23,  1.010025763023013e+00, -9.477302737763184e-03,  1.809474959217971e-05,  4.927566256977411e-07, -3.972867674606131e-09, -3.219319370685048e-11,
  6.474601953493569e-13, -2.615045331780634e-16, -9.656419640353212e-17,  6.024884745585918e-19,  1.249262794688490e-20, -5.607924300322633e-23,  1.258648005101553e+00,
 -9.919169086757447e-03, -1.701175172948602e-05,  7.139371922133999e-07,  1.250410614045769e-09, -9.740537060693303e-11, -5.561293637459616e-14,  1.534990689602845e-14,
 -3.298675077520012e-17, -2.826807061708451e-18,  1.493116886622672e-20,  6.712208182187369e-22,  1.520015832453124e+00, -8.892199357909943e-03, -6.253543052205335e-05,
  4.210787576289586e-07,  1.071827770724530e-08, -1.432924026989306e-11, -2.122260356196919e-12, -8.857716608391507e-15,  4.017674760792860e-16,  3.944087320180889e-18,
 -7.265300603200239e-20, -1.161062875946111e-21,  1.768324987095300e+00, -5.801132618318439e-03, -8.383847598969077e-05, -5.864572687250849e-07,  5.020000629184806e-09,
  1.937250534727249e-10,  1.849916071982914e-12, -1.964355025944501e-14, -8.293453924017971e-16, -8.450350671823648e-18,  9.999193518925006e-20,  4.386861268653244e-21,
  1.950218069371547e+00, -1.559802283744788e-03, -3.486206725235895e-05, -6.453313022468641e-07, -1.009395343851567e-08, -1.273208297044569e-10, -1.035373780171608e-12,
  4.081028050243832e-15,  3.936239900495157e-16,  9.986668127565632e-18,  1.712794265397961e-19,  1.987291279319796e-21,  3.244248024813743e-03, -4.158618549159095e-05,
  3.989338921990218e-07, -3.406249925727903e-09,  2.703562862298909e-11, -2.097458380398897e-13,  1.483754328940242e-15, -1.197620322057771e-17,  7.892541853433697e-20,
  1.824091734083217e-23,  2.502509705804016e-23,  3.759792371820471e-25,  2.923357679194312e-02, -3.729614159716377e-04,  3.533755281971319e-06, -2.947949922708548e-08,
  2.251590449415719e-10, -1.652843483556076e-12,  1.064530211563580e-14, -7.937185423910602e-17,  4.294979571605956e-19,  2.814290902200827e-21,  2.039840867296916e-22,
  3.620351319235737e-24,  8.140005092357704e-02, -1.028368606520947e-03,  9.491972759506089e-06, -7.524923595749962e-08,  5.251889199898449e-10, -3.337110709521471e-12,
  1.578074227687012e-14, -8.527381314183218e-17, -2.806379938909602e-20,  1.806776374966031e-20,  5.025650247561747e-22,  1.078698915529212e-23,  1.601150278969238e-01,
 -1.991414127199056e-03,  1.760439296764367e-05, -1.275031297045908e-07,  7.394229046908852e-10, -3.139379365714774e-12, -2.957348178535114e-15,  1.170755728021709e-16,
 -2.059259290599022e-18,  4.634431472388219e-20,  1.004400495842820e-21,  2.137531569672595e-23,  2.659197319819673e-01, -3.232718457667481e-03,  2.674347173086819e-05,
 -1.654343357264003e-07,  6.069202446638517e-10,  1.238571886835166e-12, -5.693849634514189e-14,  4.699991424426498e-16, -3.511861868225837e-18,  5.738135485701915e-20,
  2.054455723456174e-21,  3.416912050658715e-23,  3.994884018873577e-01, -4.702488565074859e-03,  3.515375078770771e-05, -1.601551321180879e-07, -1.505415851831122e-10,
  1.063758898376078e-11, -1.226801788386941e-13,  4.399258195145734e-16,  1.824364266985922e-18,  1.011963843795556e-20,  3.704639294487412e-21,  5.544570784654283e-23,
  5.615356708554416e-01, -6.317046420612055e-03,  4.019983417995567e-05, -7.628592304708269e-08, -1.678742041243614e-09,  2.128177498782761e-11, -1.092158765928709e-13,
 -9.695602401740315e-16,  1.725870641301736e-17, -1.132359728260194e-20,  4.304201794768854e-21,  1.043810671587414e-22,  7.525903555648696e-01, -7.934401883997246e-03,
  3.806008729214640e-05,  1.190355169454282e-07, -3.633323260306169e-09,  1.999940875593256e-11,  1.355741850455295e-13, -3.841427833183781e-15,  1.784526516363330e-17,
  3.831384219909896e-19,  2.216838214855257e-21,  1.525427177274639e-22,  9.724419343380672e-01, -9.310016528251934e-03,  2.360789986983155e-05,  4.248756381601109e-07,
 -4.463641483481595e-09, -1.706779152405455e-11,  6.008055413500714e-13, -2.911270153582503e-15, -6.621991692109352e-17,  1.081628621721759e-18,  1.226124092789471e-20,
  5.049218627117071e-23,  1.218753685186778e+00, -1.002080181824406e-02, -8.388596866927590e-06,  7.184292161014937e-07, -6.772262077545867e-10, -9.379028403653330e-11,
  3.452606385389462e-13,  1.283835271311057e-14, -1.170164229892496e-16, -1.656006924752013e-18,  4.285829282238990e-20,  5.675425793734752e-22,  1.483482534194707e+00,
 -9.369395717726816e-03, -5.647211674769971e-05,  5.874543727389464e-07,  9.910246012869021e-09, -6.667789566109443e-11, -2.173428684030088e-12,  5.628150572226250e-15,
  4.820056915196886e-16,  3.458799399491509e-19, -9.740920782192896e-20,  1.755502356439380e-22,  1.743736804495181e+00, -6.498315959421488e-03, -9.025901858386927e-05,
 -4.729731700216719e-07,  9.277371093191429e-09,  2.282804640697035e-10,  8.904951838450548e-13, -4.986293383085457e-14, -1.009498594611145e-15, -1.231717729841959e-20,
  3.317893014281177e-19,  5.679922993445877e-21,  1.943367880080916e+00, -1.872622265759092e-03, -4.366328948988732e-05, -8.284868060014925e-07, -1.287065225625158e-08,
 -1.489914694552760e-10, -6.802829162354894e-13,  2.392468398797666e-14,  8.977205814214138e-16,  1.858285574697477e-17,  2.550937561582518e-19,  1.468399853260185e-21,
  3.084037326648505e-03, -3.855116744769156e-05,  3.605218495647410e-07, -3.005413183000458e-09,  2.317115620528801e-11, -1.778660085090769e-13,  1.185447698656651e-15,
 -9.213672158760143e-18,  1.016831570279634e-19,  1.354471712023252e-21,  4.104647376359534e-23,  2.657048159559168e-25,  2.779611402857642e-02, -3.460475721855503e-04,
  3.200568655109819e-06, -2.612825385605915e-08,  1.944856865375559e-10, -1.422314316169153e-12,  8.643607355446262e-15, -6.211392125572173e-17,  7.167676930466932e-19,
  1.418016379626816e-20,  3.571566479294118e-22,  2.559085607519674e-24,  7.743292426821370e-02, -9.559068791048030e-04,  8.637262026481694e-06, -6.736037725154173e-08,
  4.620432894509867e-10, -2.986363235926906e-12,  1.351142654201530e-14, -7.093957081152268e-17,  1.100324121393815e-18,  4.769327487207049e-20,  9.577736233369058e-22,
  7.687152058620812e-24,  1.524216290594610e-01, -1.856502802497595e-03,  1.614325829996879e-05, -1.161775168847936e-07,  6.761602991376551e-10, -3.176599206625671e-12,
 -2.847785515310372e-16,  8.751011510139299e-17,  5.636938513680087e-19,  1.055268555286176e-19,  1.915341208042648e-21,  1.551105093444187e-23,  2.534044156474022e-01,
 -3.026545027992721e-03,  2.481711273621173e-05, -1.555954115807788e-07,  6.190371776888367e-10,  1.981952994950360e-14, -4.491065195038337e-14,  4.095656926551454e-16,
  4.064855386812416e-19,  1.702861193009789e-19,  3.530354894817226e-21,  2.507576979405385e-23,  3.812286980761189e-01, -4.428971801314118e-03,  3.322395157830636e-05,
 -1.610174361103695e-07,  3.380433877050592e-11,  7.849156762039992e-12, -1.092579534019230e-13,  5.376233144546913e-16,  5.456977260209128e-18,  2.076616376721823e-19,
  6.067325143586492e-21,  3.972437071734463e-23,  5.369042815854814e-01, -5.999534707533973e-03,  3.913680601009807e-05, -9.989122802006810e-08, -1.281191330474187e-09,
  1.839826559694456e-11, -1.284034136244569e-13, -3.815019894834438e-16,  2.106334798339084e-17,  2.520909215057817e-19,  8.670948489181233e-21,  7.558912769824596e-23,
  7.214694022393017e-01, -7.625164373340695e-03,  3.915338998250181e-05,  6.424380135995618e-08, -3.209118749255285e-09,  2.204069271011445e-11,  3.828380342478897e-14,
 -3.018826009546418e-15,  3.493464249152083e-17,  6.129721244650249e-19,  9.151249381903034e-21,  1.326978271855535e-22,  9.356101431544915e-01, -9.101994415552523e-03,
  2.826908598163131e-05,  3.514784499634104e-07, -4.668478825894494e-09, -3.826596172820680e-12,  4.961848547371578e-13, -4.306798263203208e-15, -1.770482812223448e-17,
  1.637407691519046e-18,  1.569234075781707e-20,  6.802029731964259e-23,  1.178590417359022e+00, -1.005374925871554e-02,  1.074111413892646e-07,  6.931513994648435e-07,
 -2.443425752896278e-09, -8.165559713868615e-11,  6.459698695510162e-13,  8.515339611615351e-15, -1.404405611076968e-16,  4.783899271165627e-19,  6.132792014511570e-20,
  2.152146110346900e-22,  1.445149693180853e+00, -9.790398625504824e-03, -4.852424694514613e-05,  7.326005219504007e-07,  8.076791278013164e-09, -1.152206566480535e-10,
 -1.803159770632457e-12,  2.054389945773720e-14,  4.306040235892340e-16, -2.916402034418970e-18, -5.480180013595677e-20,  1.640515727790635e-21,  1.716267476699737e+00,
 -7.240215465189995e-03, -9.489109559099494e-05, -2.873885342763446e-07,  1.392511425297327e-08,  2.293509310631240e-10, -9.370088972452075e-13, -7.914892929951282e-14,
 -7.151602281462250e-16,  1.769392750443149e-17,  5.281236448347020e-19,  2.149267274468578e-21,  1.935110566915000e+00, -2.265427598503719e-03, -5.494114003499889e-05,
 -1.058848173869079e-06, -1.593982448453980e-08, -1.533425407995119e-10,  5.069074254465897e-13,  6.540392647575671e-14,  1.758296170250845e-15,  2.915746423240999e-17,
  2.397497129855290e-19, -3.287517351461072e-21,  2.935381148484211e-03, -3.580521064894132e-05,  3.265687158784769e-07, -2.661667828746052e-09,  1.987958090380350e-11,
 -1.520865960680504e-13,  9.826931037941753e-16, -4.849983341301504e-18,  1.811998652822272e-19,  3.038963789415136e-21,  3.664737653714371e-23, -6.370573685082430e-25,
  2.646121901212709e-02, -3.216463704344494e-04,  2.904796529637651e-06, -2.323331955111196e-08,  1.679887601578824e-10, -1.232572073456931e-12,  7.322766838076225e-15,
 -2.812466506848665e-17,  1.496735928258941e-18,  2.896701508075728e-20,  3.225005851236518e-22, -5.691289717952616e-24,  7.374254513604196e-02, -8.899208330128958e-04,
  7.871378104591415e-06, -6.042846458691840e-08,  4.054261736054140e-10, -2.680083309114296e-12,  1.233147441819200e-14, -4.663359964671920e-19,  3.546169875033837e-18,
  8.777625850511537e-20,  8.764329056120911e-22, -1.580424264819473e-23,  1.452453337730194e-01, -1.732754167692618e-03,  1.481194420125306e-05, -1.058666592075630e-07,
  6.127858766313275e-10, -3.147929428979353e-12,  3.099790158662342e-15,  1.819233361646426e-16,  5.821408279713531e-18,  1.857564678429625e-19,  1.753463248021768e-21,
 -3.185976344337855e-23,  2.416837213826980e-01, -2.835308658356407e-03,  2.300922964012285e-05, -1.457422011619765e-07,  6.096192163205102e-10, -9.122755795997631e-13,
 -3.213657855745994e-14,  5.491693978614873e-16,  9.200200661723147e-18,  3.164567224184568e-19,  3.190596283886674e-21, -5.615959818236307e-23,  3.640321843486625e-01,
 -4.170888798544452e-03,  3.129972156586327e-05, -1.593575953813094e-07,  1.659224876141087e-10,  5.435981661854581e-12, -9.028899838334377e-14,  8.806764347507793e-16,
  1.749165594269559e-17,  4.579651517338387e-19,  5.510739271553577e-21, -8.984911303189756e-23,  5.135242834256680e-01, -5.691556656927665e-03,  3.782671104421788e-05,
 -1.176161345560319e-07, -9.444697463868822e-10,  1.527546443853550e-11, -1.277806284322198e-13,  5.089033402484530e-16,  3.682026777245094e-17,  6.225606815970250e-19,
  8.396524969910651e-21, -1.257059602126122e-22,  6.915988936292420e-01, -7.309692737584106e-03,  3.963087633575946e-05,  1.644815558654338e-08, -2.765214141392892e-09,
  2.209464634341733e-11, -2.672022929284743e-14, -1.468921131187220e-15,  6.449235110350146e-17,  1.035617155277736e-18,  9.881132010570915e-21, -1.576219123290838e-22,
  8.996793879103262e-01, -8.860242406767412e-03,  3.203811055373066e-05,  2.767761467195319e-07, -4.635777867441590e-09,  6.629619161746385e-12,  3.774056432743854e-13,
 -3.806711841822100e-15,  5.268863257758190e-17,  2.255117732197889e-18,  1.255880047311353e-20, -2.972385390597679e-22,  1.138428723837259e+00, -1.002040159147953e-02,
  8.139695236865802e-06,  6.419063384069702e-07, -3.904686623688570e-09, -6.376590354124281e-11,  8.274989978729698e-13,  4.777391223063877e-15, -7.856107442339867e-17,
  2.916635465383902e-18,  5.439377879867609e-20, -6.389730989504195e-22,  1.405270241023512e+00, -1.014142022048272e-02, -3.904073203125041e-05,  8.412647866115775e-07,
  5.393805645462708e-09, -1.501451038280312e-10, -1.052947970998033e-12,  3.237167944377808e-14,  3.049120922425715e-16, -3.548408378717371e-18,  2.174025564253909e-20,
  1.419947966531864e-21,  1.685772307893973e+00, -8.009014472620932e-03, -9.685768479045895e-05, -2.990345221000672e-08,  1.809741173311167e-08,  1.784189587253897e-10,
 -3.348377532877771e-12, -8.772645564449288e-14,  3.020512712753849e-16,  3.811084193636616e-17,  4.169314296253327e-19, -8.174810862009720e-21,  1.925082907412171e+00,
 -2.760342248740528e-03, -6.927460124682991e-05, -1.337009138297478e-06, -1.869949782889247e-08, -1.118173324660464e-10,  3.294383711524330e-12,  1.398426580495143e-13,
  2.915848984065853e-15,  3.238773554419151e-17, -1.884810505137422e-19, -1.853974810071277e-20,  2.797190457835374e-03, -3.331523675452402e-05,  2.964408206613756e-07,
 -2.366679961834016e-09,  1.706654174798471e-11, -1.293670149574392e-13,  9.460767612826426e-16,  2.897891320039066e-18,  3.057215003805232e-19,  3.433438987619574e-21,
 -3.144379501425501e-23, -2.620182404627119e-24,  2.521940665723816e-02, -2.994793169526950e-04,  2.641340581076572e-06, -2.073331932105878e-08,  1.450633271745356e-10,
 -1.059827685761228e-12,  7.376213923404002e-15,  3.819092696142577e-17,  2.670272628350985e-18,  3.220297188136005e-20, -2.930023763174254e-22, -2.376064748550986e-23,
  7.030436173596735e-02, -8.297440667602665e-04,  7.183441304340949e-06, -5.435411322411030e-08,  3.548623978760875e-10, -2.368347212373204e-12,  1.441885858981666e-14,
  1.682229382903263e-16,  7.052608131853687e-18,  9.568667001124920e-20, -8.570716480611222e-22, -6.718029587365205e-23,  1.385434913904257e-01, -1.619178284133175e-03,
  1.359831301982491e-05, -9.655951797025036e-08,  5.511203154153372e-10, -2.984790386800691e-12,  1.188019245381593e-14,  4.844741892606882e-16,  1.319652056215895e-17,
  2.010512054536737e-19, -1.750841893028362e-21, -1.359492382607248e-22,  2.306997899739566e-01, -2.658066260505812e-03,  2.131812485928239e-05, -1.361701950736427e-07,
  5.851257298353816e-10, -1.454524436274595e-12, -1.079061319761855e-14,  1.043020902137231e-15,  2.188554465341207e-17,  3.483633490302868e-19, -2.912873896860294e-21,
 -2.361157112115900e-22,  3.478373872237562e-01, -3.928087514951043e-03,  2.940659144690468e-05, -1.559410853764910e-07,  2.553663683702718e-10,  3.644690633671383e-12,
 -5.507706851955614e-14,  1.734815415357164e-15,  3.634226370877839e-17,  5.255904744273941e-19, -4.228137820434836e-21, -3.764858432769397e-22,  4.913540119624615e-01,
 -5.394823267889776e-03,  3.633421001832340e-05, -1.304426769081004e-07, -6.676903985802793e-10,  1.253550543294502e-11, -9.329828126536993e-14,  2.093306816111118e-15,
  6.294459085716772e-17,  7.345535133558895e-19, -6.014821511482244e-21, -5.652326371228369e-22,  6.629944488478811e-01, -6.992575046969055e-03,  3.957723614579899e-05,
 -2.430429479514876e-08, -2.331705812981535e-09,  2.122967577435298e-11, -3.293369540014972e-14,  1.244505613620127e-15,  1.057321512902267e-16,  1.123864764849888e-18,
 -1.026673560353767e-20, -8.128781977166195e-22,  8.647703000151835e-01, -8.591900087046507e-03,  3.492027073344353e-05,  2.041247528258158e-07, -4.419928882922756e-09,
  1.467643226326461e-11,  3.071062945152310e-13, -7.635328104762642e-16,  1.377107751782485e-16,  2.262500648753898e-18, -1.894841092308777e-20, -1.220104249249248e-21,
  1.098524519377518e+00, -9.925624303929931e-03,  1.542924619115601e-05,  5.703496127533277e-07, -4.971577199163042e-09, -4.247455482276326e-11,  9.444168675888439e-13,
  4.284908276529427e-15,  5.520147581218339e-17,  4.122326867266022e-18, -5.390613942856573e-21, -2.180327747411572e-21,  1.364145605601891e+00, -1.041213378740970e-02,
 -2.853040600898974e-05,  9.024959980256489e-07,  2.216842097594319e-09, -1.635460606930431e-10, -2.741510142629827e-14,  4.033831788114395e-14,  2.020620808611269e-16,
 -2.107051048904876e-18,  2.875729295528567e-20, -1.518032670882775e-21,  1.652191520717081e+00, -8.780149998349541e-03, -9.537775896101545e-05,  2.830375781431630e-07,
  2.067459177662810e-08,  7.103521188727352e-11, -5.445384983094960e-12, -5.382027733452737e-14,  1.853198375615395e-15,  4.384746918807860e-17, -2.180554214288995e-19,
 -2.003634564535644e-20,  1.912824171599849e+00, -3.383936387747493e-03, -8.716962403742215e-05, -1.648262085513667e-06, -1.976930669799765e-08,  2.575629749830447e-11,
  8.669730823887175e-12,  2.482976993527141e-13,  3.678660501605911e-15,  5.287437343145122e-19, -1.629688263828949e-18, -4.922777445417728e-20,  2.668499000936412e-03,
 -3.105285712831510e-05,  2.695977893108051e-07, -2.113031527296395e-09,  1.471897835584092e-11, -1.044828382286371e-13,  1.179514739531890e-15,  1.414744052863211e-17,
  3.723802583058039e-19, -8.424263810981582e-22, -1.991649961115051e-22, -4.880326778986611e-24,  2.406222876868988e-02, -2.793058802986849e-04,  2.405799938587028e-06,
 -1.857171016289441e-08,  1.257776508180723e-10, -8.593782270721241e-13,  9.786229777839359e-15,  1.374904604181016e-16,  3.307265911099969e-18, -6.914677314061423e-21,
 -1.816053955507466e-21, -4.434942168819513e-23,  6.709632130412643e-02, -7.747924789738548e-04,  6.563762094136218e-06, -4.903435075449381e-08,  3.114814326070648e-10,
 -1.937486814597922e-12,  2.272039514799037e-14,  4.355113232937677e-16,  8.998987566609844e-18, -1.616284326803386e-20, -5.171050722889845e-21, -1.257415446725195e-22,
  1.322772185467016e-01, -1.514881141682678e-03,  1.249060141606197e-05, -8.819811857647973e-08,  4.956467228216862e-10, -2.483290683089519e-12,  3.227037338986760e-14,
  9.950956972291579e-16,  1.738962561030771e-17, -2.604019184101434e-20, -1.048792246882328e-20, -2.548137628050577e-22,  2.203984877206598e-01, -2.493900523532472e-03,
  1.973927988083042e-05, -1.270434888776843e-07,  5.562644767228112e-10, -1.273697358688556e-12,  2.980680284688102e-14,  1.897299882816877e-15,  2.923224899191979e-17,
 -4.076586223350049e-20, -1.807650652622746e-20, -4.422037015832114e-22,  3.325837959937215e-01, -3.700245330184564e-03,  2.756203771365054e-05, -1.513248084305395e-07,
  3.197224306381305e-10,  3.052551536666837e-12,  1.217259214857259e-14,  3.129238608138298e-15,  4.728147069992663e-17, -7.816954342466640e-20, -2.840456775531620e-20,
 -7.052001405997112e-22,  4.703459204817106e-01, -5.110574067900317e-03,  3.471274389738425e-05, -1.392173942631279e-07, -4.333547015499088e-10,  1.124869898308189e-11,
 -3.170763335659982e-15,  4.426029338675172e-15,  7.761735163052795e-17, -1.615553936137309e-19, -4.253375567173238e-20, -1.068682428511153e-21,  6.356546842364560e-01,
 -6.677725909547651e-03,  3.907566321445464e-05, -5.823862354475594e-08, -1.910075951490015e-09,  2.127230311576124e-11,  5.432236199909490e-14,  5.111787396292448e-15,
  1.280112304866649e-16, -2.391765587090041e-19, -6.350845699981925e-20, -1.569409363750826e-21,  8.309752729192129e-01, -8.303917240290271e-03,  3.695644191875356e-05,
  1.361571659007715e-07, -4.051562045519639e-09,  2.235544805488937e-11,  3.579140712270267e-13,  4.674515513547661e-15,  1.894477173860357e-16,  8.813796921819263e-20,
 -9.793585937029624e-20, -2.318346093128621e-21,  1.059110252816821e+00, -9.776222159156188e-03,  2.177224997407523e-05,  4.852860526715561e-07, -5.583098684427088e-09,
 -1.803881085198356e-11,  1.109894249116307e-12,  8.164697832315160e-15,  1.717738509994843e-16,  1.461433836235583e-18, -1.399663935687316e-19, -3.837154847586430e-21,
  1.322109699265110e+00, -1.059670111183353e-02, -1.759461433428693e-05,  9.121586643764689e-07, -9.656782040759659e-10, -1.499864424587990e-10,  1.181640513644055e-12,
  4.560779387320891e-14,  1.194993843327505e-16, -3.537515952903773e-18, -1.308166850821444e-19, -5.634483936184837e-21,  1.615574408274521e+00, -9.523902929076206e-03,
 -8.997373612300360e-05,  6.177218251455552e-07,  2.070679758733516e-08, -6.968310272547163e-11, -5.907397543819745e-12,  2.721548833151313e-14,  3.045958001394278e-15,
  1.591461870606555e-17, -1.189922185588621e-18, -2.145580087660857e-20,  1.897761012318828e+00, -4.165661919777854e-03, -1.087859777116347e-04, -1.946546641486120e-06,
 -1.654349421362729e-08,  3.300113692325016e-10,  1.715571204178034e-11,  3.488930116837740e-13,  1.911252837656922e-15, -1.176714957049667e-16, -4.470704716331266e-18,
 -7.380739581077387e-20,  2.548446002876638e-03, -2.899364482217384e-05,  2.455908807901570e-07, -1.892549114916407e-09,  1.295109681745578e-11, -7.016818510886755e-14,
  1.724421070614122e-15,  2.360314544183001e-17,  1.445799754797607e-19, -1.329326857739411e-20, -4.189453583093759e-22, -4.157585305030046e-24,  2.298213328633400e-02,
 -2.609179273580228e-04,  2.194492295039739e-06, -1.668249159561648e-08,  1.113092996443710e-10, -5.671820231583319e-13,  1.495727098479379e-14,  2.213420372110341e-16,
  1.259257836518888e-18, -1.203208526154506e-19, -3.814310678998016e-21, -3.782633282524069e-23,  6.409856096754084e-02, -7.245540377113261e-04,  6.004082022646740e-06,
 -4.432630991187015e-08,  2.793321317990825e-10, -1.215567787368740e-12,  3.850902932293879e-14,  6.629657797158652e-16,  3.299798807925087e-18, -3.386463187022105e-19,
 -1.084160899146162e-20, -1.074852971848548e-22,  1.264110263044854e-01, -1.419058473855589e-03,  1.147833193455743e-05, -8.061245629959589e-08,  4.562916255325588e-10,
 -1.315892540573185e-12,  6.707337514775124e-14,  1.432725501182090e-15,  6.074371256303830e-18, -6.800480096586544e-19, -2.199132433442863e-20, -2.184907602126996e-22,
  2.107292702888960e-01, -2.341934654345220e-03,  1.826749844697122e-05, -1.182882907902031e-07,  5.427664652014322e-10,  1.775401295171294e-13,  9.458248743861626e-14,
  2.629995950655819e-15,  9.842529708851649e-18, -1.171010513387701e-18, -3.806283091052212e-20, -3.807047994305597e-22,  3.182124358063437e-01, -3.486920751767114e-03,
  2.577898801800610e-05, -1.456722245114589e-07,  3.916309966524876e-10,  4.555088972954863e-12,  1.186212783229738e-13,  4.314590341255603e-15,  1.618582214339422e-17,
 -1.864302366121513e-18, -6.033226570192318e-20, -6.106426078555615e-22,  4.504483039695717e-01, -4.839655123909260e-03,  3.300807073019479e-05, -1.443084297879337e-07,
 -1.977261148266350e-10,  1.292093317457196e-11,  1.517605592881407e-13,  6.392256297434566e-15,  2.929299148804626e-17, -2.849893765965534e-18, -9.108018628645045e-20,
 -9.338149382722633e-22,  6.095638751482837e-01, -6.368402529832189e-03,  3.820785401213594e-05, -8.526874321415895e-08, -1.457715489252928e-09,  2.472752665607628e-11,
  2.491954039264219e-13,  8.438638545469244e-15,  5.617505914870398e-17, -4.234137585122110e-18, -1.351850429213277e-19, -1.388367338671501e-21,  7.983597481215399e-01,
 -8.002794903127438e-03,  3.821779511021404e-05,  7.543232255139561e-08, -3.504514014836910e-09,  3.317183082704313e-11,  5.675544090409162e-13,  9.822627804920458e-15,
  9.626035532722309e-17, -5.978056577710133e-18, -2.038743438142653e-19, -2.059223423410841e-21,  1.020388434230398e+00, -9.580286615547677e-03,  2.705272745893222e-05,
  3.946066455041796e-07, -5.655734206087415e-09,  1.196465582292918e-11,  1.413684448163328e-12,  1.307955534138742e-14,  8.121126135489370e-17, -7.655584058403506e-18,
 -3.130002552416701e-19, -3.362820786644266e-21,  1.279510048922297e+00, -1.069415286304748e-02, -6.834214403068566e-06,  8.746908390191384e-07, -3.576813881780831e-09,
 -1.060374407516007e-10,  2.482803977351517e-12,  4.585314229129859e-14, -1.683581249295233e-16, -1.436782559564771e-17, -4.151162543637059e-19, -6.106143019161333e-21,
  1.576093914901522e+00, -1.020856378345412e-02, -8.064297275782610e-05,  9.306385066659345e-07,  1.801492001017555e-08, -1.911435739120268e-10, -3.769943590421334e-12,
  1.230084150857002e-13,  2.564849988942402e-15, -4.697455455022294e-17, -1.831784983324934e-18, -4.639798869404246e-21,  1.879204363635251e+00, -5.133220069908247e-03,
 -1.334332010448864e-04, -2.132687333734445e-06, -5.020482693699356e-09,  8.605884947905852e-10,  2.686313511494771e-11,  3.018441617509471e-13, -6.247578869977795e-15,
 -3.505279590094257e-16, -6.593163703401630e-18,  8.733708300811974e-21,  2.436261896333495e-03, -2.711632835093059e-05,  2.240851915038680e-07, -1.694082579102665e-09,
  1.201550724290243e-11, -2.089343400701937e-14,  2.353519008670665e-15,  1.708950556994391e-17, -6.621238062164339e-19, -3.159905562706425e-20, -4.203914894938885e-22,
  6.383381933466921e-24,  2.197234736292881e-02, -2.441331972805982e-04,  2.004682749055705e-06, -1.497066066824959e-08,  1.040599114205789e-10, -1.344019055756999e-13,
  2.084367798634498e-14,  1.606197534812837e-16, -6.060001424524225e-18, -2.870056458115888e-19, -3.829692983581459e-21,  5.797068571332835e-23,  6.129314660656267e-02,
 -6.785745558701389e-04,  5.498359960576446e-06, -3.999491991913889e-08,  2.657689149402645e-10, -7.110067736414225e-14,  5.608049936069583e-14,  4.833486584153751e-16,
 -1.738506261132460e-17, -8.126025368790470e-19, -1.090044232994378e-20,  1.639725861873101e-22,  1.209124925511591e-01, -1.330978468747507e-03,  1.055423874483175e-05,
 -7.342118705837572e-08,  4.493150013669342e-10,  7.681695064006373e-13,  1.049378634629438e-13,  1.052467945412660e-15, -3.564505510215573e-17, -1.642315524326359e-18,
 -2.216842928967983e-20,  3.303325652725217e-22,  2.016450316763146e-01, -2.201323676245750e-03,  1.690072987681055e-05, -1.094272148411594e-07,  5.749601384524984e-10,
  3.316686493272353e-12,  1.640553851305547e-13,  1.953577149454872e-15, -6.218245775547647e-17, -2.839465952032293e-18, -3.853464103127157e-20,  5.669052578947269e-22,
  3.046663065490308e-01, -3.287566457158743e-03,  2.407213800078164e-05, -1.384814706076460e-07,  5.209626087315317e-10,  8.830525677939153e-12,  2.330386988488376e-13,
  3.255745607777816e-15, -9.835816597138071e-17, -4.516194742732546e-18, -6.145979547495072e-20,  8.894891449227573e-22,  4.316067971230075e-01, -4.582549913817773e-03,
  3.126672440808005e-05, -1.451455166943038e-07,  1.116610272912556e-10,  1.869537525854952e-11,  3.230732762536665e-13,  4.927634579293087e-15, -1.450534674502993e-16,
 -6.866213099615862e-18, -9.347273665759840e-20,  1.325267898502221e-21,  5.846946032145816e-01, -6.067188992760984e-03,  3.706228476526641e-05, -1.042290354448360e-07,
 -8.839108829501260e-10,  3.356618825432106e-11,  4.797540411750939e-13,  6.667887734290771e-15, -2.028638805043618e-16, -1.020757096487957e-17, -1.396282314016583e-19,
  1.927104710638011e-21,  7.669645134711597e-01, -7.694329310010104e-03,  3.881110424584638e-05,  2.550432740071824e-08, -2.681848227570365e-09,  5.018294336530022e-11,
  8.413424298920575e-13,  7.757549638197922e-15, -2.796229891141844e-16, -1.498692462879341e-17, -2.116141334776615e-19,  2.800737031895917e-21,  9.825279895375837e-01,
 -9.346431248009117e-03,  3.125926881891637e-05,  3.079983303382125e-07, -5.047389376403528e-09,  5.023455484689561e-11,  1.756314161526681e-12,  8.638433280822824e-15,
 -4.431917054281868e-16, -2.166524621395191e-17, -3.341623581886284e-19,  4.052739753694823e-21,  1.236689009604752e+00, -1.070795235623295e-02,  3.260354748835002e-06,
  8.041516349693618e-07, -5.003323172161058e-09, -3.225594955620332e-11,  3.588126141476963e-12,  2.856867319246262e-14, -1.031390640837195e-15, -3.416785109995723e-17,
 -4.920570186035343e-19,  5.422940672851247e-21,  1.534046602971075e+00, -1.080445292943182e-02, -6.788440971626150e-05,  1.184691154862010e-06,  1.360569987093440e-08,
 -2.330857019685701e-10,  4.684643664720998e-13,  1.639969271461149e-13, -4.150243995470605e-16, -1.153622176122208e-16, -1.332331138343488e-18,  3.050158175438773e-20,
  1.856374566102553e+00, -6.302872519157091e-03, -1.588194447334578e-04, -2.037990806108839e-06,  1.915043917548166e-08,  1.570747007965631e-09,  3.028087989848983e-11,
 -1.458245003979977e-13, -2.284152990122745e-14, -5.278205877760017e-16,  1.882189697852624e-19,  3.438575298567474e-19,  2.331257793637430e-03, -2.540170580083822e-05,
  2.049061502902449e-07, -1.502003256595036e-09,  1.218404812011213e-11,  3.779186165558168e-14,  2.346184130178305e-15, -2.463198884698160e-17, -1.978244264571758e-18,
 -3.641817409846153e-20,  3.579533878254160e-22,  3.051308453305383e-23,  2.102679164651149e-02, -2.287860448703347e-04,  1.835026854745467e-06, -1.329902264687839e-08,
  1.065816001495373e-10,  3.874807083079264e-13,  2.090700033296048e-14, -2.198851951335066e-16, -1.802157351379090e-17, -3.311581904693422e-19,  3.246322529473370e-21,
  2.775251856385490e-22,  5.866388506069850e-02, -6.364347591876998e-04,  5.044133737321036e-06, -3.567776577195541e-08,  2.784535168639201e-10,  1.344851337207622e-12,
  5.695516149310131e-14, -6.016897192902695e-16, -5.129170290858737e-17, -9.396493163859780e-19,  9.161343831983042e-21,  7.876059074006055e-22,  1.157520417285586e-01,
 -1.249944467705333e-03,  9.717289150640840e-06, -6.596545225053078e-08,  4.913334911684688e-10,  3.451712262676282e-12,  1.085863207056325e-13, -1.157851740353830e-15,
 -1.042755736502382e-16, -1.904632908841398e-18,  1.841192837678145e-20,  1.595726384895593e-21,  1.931020614509625e-01, -2.071207451729757e-03,  1.564571970769017e-05,
 -9.947000243404869e-08,  6.835018681866298e-10,  7.582278144917330e-12,  1.738515862954604e-13, -1.887584560520661e-15, -1.810260352737489e-16, -3.303881316392811e-18,
  3.155143023794802e-20,  2.762637619717506e-21,  2.918908907180197e-01, -3.101479244458815e-03,  2.246725005575516e-05, -1.284067756486553e-07,  7.583578804100213e-10,
  1.499736769098268e-11,  2.530072347781523e-13, -2.838673601515970e-15, -2.876373207187240e-16, -5.272640026426115e-18,  4.950961668230714e-20,  4.388921527433236e-21,
  4.137659180159075e-01, -4.339321393792612e-03,  2.954949990098902e-05, -1.399120647809893e-07,  5.705212788771689e-10,  2.733035606288261e-11,  3.548021107193708e-13,
 -4.197413282309254e-15, -4.331834385514572e-16, -8.046081360892745e-18,  7.379097353937830e-20,  6.644252280996859e-21,  5.610106556595336e-01, -5.775878801617975e-03,
  3.575099256812221e-05, -1.123298198831807e-07, -8.767640850359798e-11,  4.621526593964831e-11,  5.141701522930916e-13, -6.498373600851577e-15, -6.322393949122704e-16,
 -1.203516135916833e-17,  1.066559326183939e-19,  9.833133280652483e-21,  7.368091922750701e-01, -7.383262056116374e-03,  3.889651635127312e-05, -8.230092310167892e-09,
 -1.466198667346255e-09,  7.142272084577371e-11,  8.427581107655520e-13, -1.104266193896016e-14, -9.149302924628415e-16, -1.793743919193516e-17,  1.508805088811839e-19,
  1.455567319678446e-20,  9.456640022538229e-01, -9.082854574898628e-03,  3.451140639087382e-05,  2.376112328435387e-07, -3.613225877387402e-09,  9.288648931124933e-11,
  1.667290251622396e-12, -1.999025347647402e-14, -1.379735566228138e-15, -2.680779294170920e-17,  2.102060968908222e-19,  2.210382189804945e-20,  1.193968535014315e+00,
 -1.064464875065363e-02,  1.242427007292098e-05,  7.238055574437043e-07, -4.747030918151953e-09,  5.847553129502030e-11,  3.718766572452677e-12, -2.701848780419118e-14,
 -2.491176515035606e-15, -4.145028536508434e-17,  3.483584682512783e-19,  3.532476908067056e-20,  1.489837448820256e+00, -1.128730514150433e-02, -5.250973892581672e-05,
  1.367181633052363e-06,  9.403238051755418e-09, -1.723647157798435e-10,  4.196200232616446e-12,  7.747390937349658e-14, -5.070247830683271e-15, -1.268459314998220e-16,
  1.162429790939642e-18,  8.548570841276465e-20,  1.828477885838524e+00, -7.663412330087274e-03, -1.802801400882127e-04, -1.443869784459104e-06,  5.700366712729502e-08,
  2.149268647911189e-09,  1.332847752447736e-11, -1.141959576106094e-12, -3.689543516130687e-14, -9.321108689227190e-17,  2.402331922623991e-17,  6.627774157482993e-19,
  2.232820093939931e-03, -2.383116310952943e-05,  1.880856513748507e-07, -1.298329534219771e-09,  1.340558630905841e-11,  7.763078195558210e-14,  6.100876975871056e-16,
 -1.031191742854804e-16, -2.649039892150670e-18,  1.075461788508711e-20,  2.079494705290741e-21,  3.996474327372667e-23,  2.014003907908810e-02, -2.147144424328815e-04,
  1.686005642669999e-06, -1.150785023233807e-08,  1.184720397025735e-10,  7.407438783763119e-13,  5.219891348214977e-15, -9.346943589950478e-16, -2.412555809952370e-17,
  9.764664245015342e-20,  1.891465466621197e-20,  3.640169636810262e-22,  5.619625083031494e-02, -5.977159992568963e-04,  4.643835786466795e-06, -3.094248947788411e-08,
  3.165791837391790e-10,  2.297288904471457e-12,  1.299347764792217e-14, -2.635261691116504e-15, -6.863920224696748e-17,  2.759797601725023e-19,  5.368863082655255e-20,
  1.036143135498494e-21,  1.109029237553732e-01, -1.175232771814571e-03,  8.975560475051423e-06, -5.742878412341805e-08,  5.816155664702867e-10,  5.237223026726357e-12,
  2.105968690402780e-14, -5.290875290768226e-15, -1.395397008501003e-16,  5.547608651916764e-19,  1.088224329814228e-19,  2.109093024891199e-21,  1.850602827831943e-01,
 -1.950617485277329e-03,  1.452335425852593e-05, -8.712512266014906e-08,  8.687941870283925e-10,  1.037131064351536e-11,  2.532075261738845e-14, -9.064747187480680e-15,
 -2.424906419157036e-16,  9.471049237125637e-19,  1.885633104380035e-19,  3.675644996111592e-21,  2.798350145279767e-01, -2.927673773761567e-03,  2.101001470698501e-05,
 -1.135913160847284e-07,  1.106552519133512e-09,  1.892443221991279e-11,  2.134244143224761e-14, -1.426007510270237e-14, -3.864714733579680e-16,  1.469376584112535e-18,
  3.000031200848933e-19,  5.891628970044075e-21,  3.968710683680018e-01, -4.109441767683392e-03,  2.794467801947977e-05, -1.260194494687046e-07,  1.183655088355556e-09,
  3.263753669608274e-11,  7.501075275160786e-15, -2.145990667995831e-14, -5.857158857088420e-16,  2.140359148369373e-18,  4.551050587468118e-19,  9.023309388827187e-21,
  5.384706831102661e-01, -5.495212427774637e-03,  3.442701341612012e-05, -1.057753713818008e-07,  9.319598766144664e-10,  5.373844221901624e-11, -4.689274903963389e-15,
 -3.185312943107576e-14, -8.639735225709330e-16,  2.987669533339894e-18,  6.749470569899791e-19,  1.355222619964908e-20,  7.078974509772701e-01, -7.072768861611588e-03,
  3.870725311346491e-05, -1.933428640428344e-08,  1.201062056409920e-10,  8.411022265200015e-11,  4.321835378107276e-14, -4.802342257445217e-14, -1.266609973598829e-15,
  4.111688996051658e-18,  9.994729113463180e-19,  2.043326958461976e-20,  9.099016397405197e-01, -8.796186815465559e-03,  3.708346016340488e-05,  1.965451016470193e-07,
 -1.429871272954219e-09,  1.204153214788125e-10,  3.686097874910285e-13, -7.572578980579289e-14, -1.910137464630643e-15,  6.117887828509034e-18,  1.514664776868185e-18,
  3.180395577879576e-20,  1.151642069160612e+00, -1.051168471939012e-02,  2.070739540071740e-05,  6.616230927698278e-07, -2.798075886825037e-09,  1.284430632759952e-10,
  1.661502859105707e-12, -1.243124706993006e-13, -3.273827968474534e-15,  1.232477158414436e-17,  2.482301580954141e-18,  5.294815295420622e-20,  1.443955291109424e+00,
 -1.163942494972245e-02, -3.529577185215868e-05,  1.495885310611279e-06,  7.027892158114227e-09, -6.765739959924158e-11,  3.518739665621626e-12, -1.405840244314896e-13,
 -7.758359859882531e-15,  8.652633632906191e-18,  5.795658165368715e-18,  1.069036248471774e-19,  1.794856281652227e+00, -9.156138026273972e-03, -1.906948262840103e-04,
 -1.837833740295359e-07,  9.992374555147870e-08,  1.956906706692419e-09, -3.404955235639978e-11, -2.138917975216595e-12, -1.684165645411297e-14,  1.326572620135039e-15,
  4.077247247148018e-17, -1.953613815018540e-19,  2.140411441972362e-03, -2.238503376810109e-05,  1.738433719011479e-07, -1.071766884827384e-09,  1.482509392563928e-11,
  4.905132939508683e-14, -3.274623894594628e-15, -1.628886948976414e-16, -4.544699063293840e-19,  1.150997145066311e-19,  2.597136393643141e-21, -3.401388560655189e-23,
  1.930732977536054e-02, -2.017454297889131e-04,  1.559767808655683e-06, -9.497341294303045e-09,  1.320039482973276e-10,  4.738663895925021e-13, -3.003775717540904e-14,
 -1.479369258659829e-15, -4.164082380436252e-18,  1.047289658649240e-18,  2.364959712810819e-20, -3.089885275385491e-22,  5.387746271310775e-02, -5.619609827523603e-04,
  4.304409891675667e-06, -2.552198719880142e-08,  3.584831015631877e-10,  1.501397522299753e-12, -8.666099536002616e-14, -4.186800188416477e-15, -1.198501422428478e-17,
  2.974626146125029e-18,  6.728183360897366e-20, -8.747620183288349e-22,  1.063414707619753e-01, -1.106018816343148e-03,  8.345637375725035e-06, -4.731640146401770e-08,
  6.770074320448003e-10,  3.512736242709862e-12, -1.797205731373433e-13, -8.450706802138242e-15, -2.475820493329367e-17,  6.034390739362790e-18,  1.368529870099230e-19,
 -1.765844547732955e-21,  1.774839190771992e-01, -1.838360855549810e-03,  1.356793729820767e-05, -7.163308946413312e-08,  1.057552460382836e-09,  7.146768632343066e-12,
 -3.200759629709237e-13, -1.456841448388538e-14, -4.383757973020074e-17,  1.046520283214952e-17,  2.382820359304669e-19, -3.042269845958826e-21,  2.684523088591345e-01,
 -2.764716882224392e-03,  1.976529995124665e-05, -9.299010596580785e-08,  1.451144013513424e-09,  1.339041156519282e-11, -5.241261211877914e-13, -2.305485784890944e-14,
 -7.119136351895571e-17,  1.666121303406201e-17,  3.815155157865695e-19, -4.803419389838639e-21,  3.808713572643150e-01, -3.891562812015555e-03,  2.656700277086338e-05,
 -1.020893010838515e-07,  1.779403920472076e-09,  2.370271425147855e-11, -8.153188251365816e-13, -3.482577153703815e-14, -1.095022764779538e-16,  2.528187718194723e-17,
  5.834845181443794e-19, -7.216227722146344e-21,  5.170330901050250e-01, -5.224540125653196e-03,  3.328166766663458e-05, -8.262811724189545e-08,  1.918397808380538e-09,
  4.011015774382834e-11, -1.224545306644962e-12, -5.161578151991148e-14, -1.622383519287780e-16,  3.749347568811871e-17,  8.744087938645187e-19, -1.057739877760353e-20,
  6.802244341657514e-01, -6.763880589049394e-03,  3.854102951286653e-05, -4.433405111260312e-09,  1.681806549979405e-09,  6.488260414993501e-11, -1.782858698312843e-12,
 -7.702324821241149e-14, -2.342106432723522e-16,  5.558312110304771e-17,  1.312541979686532e-18, -1.547119173813471e-20,  8.753248565067380e-01, -8.490291800895750e-03,
  3.938351084389727e-05,  1.925763051047269e-07,  8.620419891809295e-10,  9.759279106362351e-11, -2.477250979663065e-12, -1.193606892303494e-13, -3.399616042930493e-16,
  8.490598602903655e-17,  2.023897481494794e-18, -2.328201495179628e-20,  1.109976124489404e+00, -1.031482611400734e-02,  2.846632810968516e-05,  6.381877277254345e-07,
 -1.690113178083681e-10,  1.159078083025237e-10, -3.059610455198949e-12, -1.990038139921607e-13, -6.074900203036080e-16,  1.422532351611088e-16,  3.346650831255205e-18,
 -3.889383215155477e-20,  1.396949136456619e+00, -1.184815870040960e-02, -1.670509027243890e-05,  1.600272758255235e-06,  6.063105409350228e-09, -5.641289599810181e-11,
 -3.482641128794868e-12, -3.317457182978478e-13, -2.442996067797903e-15,  2.969114061205750e-16,  7.117099271784729e-18, -9.937930947835731e-20,  1.755208447877027e+00,
 -1.066075620947790e-02, -1.822166464691357e-04,  1.662911058349316e-06,  1.259492724978530e-07,  4.144820847598267e-10, -9.232521418322880e-11, -1.650027516768080e-12,
  5.294973899226021e-14,  2.204811211221259e-15, -1.118674070784537e-17, -2.077328959782914e-18,  2.053577093446606e-03, -2.104165999154545e-05,  1.624197315571253e-07,
 -8.325123274024840e-10,  1.466078818298879e-11, -8.148252776453229e-14, -7.301374610002843e-15, -9.628612707896952e-17,  4.853104589092552e-18,  1.514518924319782e-19,
 -1.632172892694990e-21, -1.457031258901026e-22,  1.852463377723677e-02, -1.896868581255875e-04,  1.458619919589577e-06, -7.362480746968258e-09,  1.310075574329400e-10,
 -7.188411336015241e-13, -6.661181691003139e-14, -8.741157286242056e-16,  4.414433668204503e-17,  1.378809725434100e-18, -1.484523749224973e-20, -1.327008341411228e-21,
  5.169668917147605e-02, -5.286518998157380e-04,  4.033077597933060e-06, -1.969825040970611e-08,  3.584711230580361e-10, -1.914002248098991e-12, -1.901846235948797e-13,
 -2.471781246516682e-15,  1.253137954812348e-16,  3.920649098973369e-18, -4.213359066145863e-20, -3.776608691128283e-21,  1.020475942573236e-01, -1.041337337822934e-03,
  7.844175116565512e-06, -3.623576476952792e-08,  6.854711272116284e-10, -3.496996638968660e-12, -3.887116384363978e-13, -4.982706435683732e-15,  2.540537184120743e-16,
  7.967583089078960e-18, -8.538804783666781e-20, -7.685962445791527e-21,  1.703425347101910e-01, -1.732960622659885e-03,  1.281285519785657e-05, -5.412266243743103e-08,
  1.091493838484961e-09, -5.185017400955267e-12, -6.804228959665675e-13, -8.574912743239237e-15,  4.404100249654110e-16,  1.385261252199428e-17, -1.479303972224449e-19,
 -1.339297001863710e-20,  2.577031960427003e-01, -2.610648464462881e-03,  1.879475876504612e-05, -6.852890061884897e-08,  1.542227490796056e-09, -6.549378401636718e-12,
 -1.094430375032061e-12, -1.354007386407541e-14,  7.013342617216974e-16,  2.212898775751291e-17, -2.353451282686015e-19, -2.146735723839592e-20,  3.657231393713127e-01,
 -3.683415590840690e-03,  2.552405713420277e-05, -7.121607839689458e-08,  1.980828545571259e-09, -6.985194800785713e-12, -1.676682446260450e-12, -2.039907798320287e-14,
  1.065937911792019e-15,  3.372643173119793e-17, -3.572365829849854e-19, -3.288550303415955e-20,  4.966619575721454e-01, -4.961682957037775e-03,  3.249426776872049e-05,
 -4.759680230020277e-08,  2.312670885297986e-09, -5.756761081107528e-12, -2.500503897081781e-12, -3.014612615848407e-14,  1.587052910232497e-15,  5.028645248252047e-17,
 -5.313059091843129e-19, -4.941388024592359e-20,  6.537859837498154e-01, -6.455227798016224e-03,  3.868259169928184e-05,  2.981020176380073e-08,  2.381503289502431e-09,
 -2.476050118682332e-12, -3.684838602720311e-12, -4.487276310136855e-14,  2.369391677041644e-15,  7.497156210171892e-17, -7.943553503522504e-19, -7.455052736740473e-20,
  8.420089546175265e-01, -8.165623812708757e-03,  4.182806068056396e-05,  2.176360961883665e-07,  1.956055968240223e-09,  1.038895292122202e-13, -5.421344676563950e-12,
 -6.954700310894165e-14,  3.647652956219362e-15,  1.148092247236567e-16, -1.239300857558820e-18, -1.162588723566794e-19,  1.069220906892707e+00, -1.005636752099101e-02,
  3.616680812082225e-05,  6.481736590069722e-07,  9.751550340988786e-10, -2.106948235880597e-11, -7.984509971151063e-12, -1.171432237469624e-13,  6.034487258946563e-15,
  1.897538537449199e-16, -2.184723210426800e-18, -1.973702544443148e-19,  1.349412999642274e+00, -1.190346825111543e-02,  3.019596117341932e-06,  1.680541143390906e-06,
  3.348984252743825e-09, -2.487907559726102e-10, -1.194972878084779e-11, -1.991920924746149e-13,  1.130127439247451e-14,  3.835878858751720e-16, -5.275375418231311e-18,
 -4.231992520554904e-19,  1.709824472931006e+00, -1.200462454061554e-02, -1.503197156634609e-04,  3.612633374884453e-06,  1.096132638990870e-07, -2.098621520099287e-09,
 -1.045655791071168e-10,  1.042376350516711e-12,  1.016097503267649e-13, -6.965936952204049e-17, -9.338791037459035e-17, -8.110024820994884e-19,  1.971951282995069e-03,
 -1.977846377189307e-05,  1.537507824317824e-07, -6.210412221959208e-10,  1.116985479668003e-11, -2.672436626670846e-13, -7.166063540114033e-15,  1.212137443190679e-16,
  7.627307578001925e-18, -3.292830737542414e-20, -6.786321270461535e-21, -3.630196312594778e-23,  1.778871283604800e-02, -1.783373485579245e-04,  1.382076406358671e-06,
 -5.473161427917939e-09,  9.965689226719681e-11, -2.412678506584603e-12, -6.532750769217939e-14,  1.104814415067907e-15,  6.940206078570108e-17, -2.999516430062628e-19,
 -6.180440037884951e-20, -3.308891731439850e-22,  4.964524543747045e-02, -4.972398898735673e-04,  3.829003861238155e-06, -1.453084088091379e-08,  2.717675528307948e-10,
 -6.745126388176529e-12, -1.862394613747967e-13,  3.148778603913877e-15,  1.971401667378289e-16, -8.541086599768533e-19, -1.758745260966116e-19, -9.431122358084485e-22,
  9.800524965963923e-02, -9.801455717053287e-04,  7.471118100529167e-06, -2.636250214939966e-08,  5.166729774055473e-10, -1.335662631425266e-11, -3.798288322539544e-13,
  6.420429447347830e-15,  4.000226013313706e-16, -1.740518334998004e-18, -3.578640095706942e-19, -1.923158072035788e-21,  1.636119857278604e-01, -1.632772698591312e-03,
  1.226172799703967e-05, -3.842334539049438e-08,  8.149883299447536e-10, -2.241259453113899e-11, -6.630812627317935e-13,  1.121007844742904e-14,  6.941409013115352e-16,
 -3.041509884020405e-18, -6.233889620106779e-19, -3.357757633404645e-21,  2.475566770143135e-01, -2.463179947623071e-03,  1.811129655480218e-05, -4.640315150727570e-08,
  1.133712458533757e-09, -3.420411230186342e-11, -1.063282684425842e-12,  1.799466930198999e-14,  1.106358903634778e-15, -4.902934281011813e-18, -9.986974525079409e-19,
 -5.387818737184083e-21,  3.513931774590568e-01, -3.482128179606219e-03,  2.484759584899149e-05, -4.293886306523307e-08,  1.416549321497962e-09, -4.927264915623338e-11,
 -1.623914927488212e-12,  2.756169139141164e-14,  1.682103214856406e-15, -7.592372315355021e-18, -1.528586603112659e-18, -8.239752252881970e-21,  4.773323653558371e-01,
 -4.703415287262161e-03,  3.213026758359488e-05, -1.494041395459429e-08,  1.564923006413942e-09, -6.873941352246424e-11, -2.415453419999134e-12,  4.126379982863888e-14,
  2.502092962713901e-15, -1.163937123798274e-17, -2.293686035177533e-18, -1.227842783168095e-20,  6.285871280878254e-01, -6.143724781351714e-03,  3.925100625897282e-05,
  6.246852006192321e-08,  1.399394588132894e-09, -9.530765788297149e-11, -3.555161663520926e-12,  6.159712384582517e-14,  3.722096558143672e-15, -1.821883625347551e-17,
 -3.452699778826225e-18, -1.807845733373367e-20,  8.100329394771413e-01, -7.820068688259418e-03,  4.460350239847211e-05,  2.414989539976825e-07,  5.815974224972815e-10,
 -1.369597388296929e-10, -5.239702488842117e-12,  9.375794245070100e-14,  5.681510622016819e-15, -3.039836856054554e-17, -5.364349965163147e-18, -2.636210349975815e-20,
  1.029623609405118e+00, -9.735758837383108e-03,  4.398893047916227e-05,  6.493421396294691e-07, -1.492205816773025e-09, -2.249520752648111e-10, -7.753037199071662e-12,
  1.515224926023815e-13,  9.256581689861992e-15, -5.835600910383362e-17, -9.040408414506720e-18, -3.608542844411889e-20,  1.301975813872137e+00, -1.179821990788177e-02,
  2.328981753400067e-05,  1.677716827810228e-06, -4.689377276750416e-09, -5.512349865566376e-10, -1.088529551910257e-11,  3.074882967016341e-13,  1.710096109823756e-14,
 -1.545743401790685e-16, -1.862797141398261e-17, -1.587686758819145e-20,  1.659712280368197e+00, -1.300796162113865e-02, -9.822957542579341e-05,  4.910558791077290e-06,
  4.670270168524910e-08, -3.919016791839862e-09, -3.542057374986425e-11,  3.536395372893786e-12,  3.448696254726029e-14, -3.283270407701106e-15, -3.771381443567517e-17,
  3.061191891688110e-18,  1.895253927746292e-03, -1.857568857287688e-05,  1.471682232406467e-07, -4.928093588242437e-10,  4.511119785359789e-12, -3.738771420543854e-13,
 -9.009324213431568e-16,  2.956905614592731e-16,  1.915130904139524e-18, -2.547995660956585e-19, -2.398829681062386e-21,  2.145585907780649e-22,  1.709709352448786e-02,
 -1.675204935110896e-04,  1.324136209266845e-06, -4.335129372664915e-09,  3.942306153093506e-11, -3.385287344801220e-12, -8.272422211302195e-15,  2.691818169147073e-15,
  1.738005995247613e-17, -2.320236899128011e-18, -2.181597790063827e-20,  1.955432824589157e-21,  4.771653469007719e-02, -4.672430508036104e-04,  3.675596018148417e-06,
 -1.146267596008666e-08,  1.026960790741119e-10, -9.520659819584916e-12, -2.390577938723881e-14,  7.653263541836355e-15,  4.909858016653690e-17, -6.601047648595710e-18,
 -6.189635564319438e-20,  5.572763300607414e-21,  9.420236978378282e-02, -9.215246083488631e-04,  7.194174984717782e-06, -2.064265743612655e-08,  1.798138764813081e-10,
 -1.902478995544795e-11, -4.965348426676936e-14,  1.554922874046508e-14,  9.875518107389363e-17, -1.342679785879440e-17, -1.253249967024816e-19,  1.136594289044086e-20,
  1.572744242244662e-01, -1.536340499599516e-03,  1.186168762313447e-05, -2.968531397397886e-08,  2.449386179641649e-10, -3.232202817751793e-11, -8.845216040555867e-14,
  2.702167654524340e-14,  1.691681741168060e-16, -2.337780258962385e-17, -2.166624494927455e-19,  1.986626723259825e-20,  2.379905681491190e-01, -2.320268427815578e-03,
  1.763686042080250e-05, -3.488444373623578e-08,  2.542358057268166e-10, -5.011294227216793e-11, -1.444012286633135e-13,  4.312910459833341e-14,  2.647087082912371e-16,
 -3.742914403173886e-17, -3.431420033711113e-19,  3.197642155394076e-20,  3.378593928920935e-01, -3.285110105925060e-03,  2.442990379012115e-05, -2.991084406577319e-08,
  1.326968843507840e-10, -7.357479602565072e-11, -2.224326400513004e-13,  6.562904028491430e-14,  3.919699664512590e-16, -5.724359101105227e-17, -5.160346204872278e-19,
  4.925872835870638e-20,  4.590320935380172e-01, -4.446786999988531e-03,  3.204708615096210e-05, -3.505270460466105e-09, -2.531708183282781e-10, -1.048132738694229e-10,
 -3.261485472273066e-13,  9.756396936428096e-14,  5.606734242531576e-16, -8.580779066019511e-17, -7.528411540389018e-19,  7.457435779156447e-20,  6.046453057556472e-01,
 -5.826508754898770e-03,  4.005919966429214e-05,  6.578511920414443e-08, -1.156764526340065e-09, -1.480256673057615e-10, -4.478671260673287e-13,  1.445954097572610e-13,
  7.839886289141741e-16, -1.289703034423318e-16, -1.079994669971744e-18,  1.136718599664623e-19,  7.794845747163448e-01, -7.451737251359196e-03,  4.744806832512582e-05,
  2.232931431573969e-07, -3.105951343572190e-09, -2.131379555634667e-10, -5.219035317229533e-13,  2.184881443998844e-13,  1.071251199129978e-15, -1.997766505516976e-16,
 -1.529812505447485e-18,  1.798428179032823e-19,  9.914326518496558e-01, -9.353483015404713e-03,  5.146185496934292e-05,  5.813601482901516e-07, -7.352526265353337e-09,
 -3.310233894704282e-10, -1.597962128790093e-13,  3.483605620627923e-13,  1.348007598038106e-15, -3.337130004360553e-16, -2.068316403241790e-18,  3.113606862297612e-19,
  1.255280078891727e+00, -1.153355789594065e-02,  4.257287854487905e-05,  1.504219892642958e-06, -1.734939689213639e-08, -6.573586432944727e-10,  3.592195281390362e-12,
  6.359766008043761e-13,  2.870333424900358e-16, -6.628943869766690e-16, -1.535519585673444e-18,  6.675367533765347e-19,  1.606491874036660e+00, -1.355147402471239e-02,
 -3.746134468958362e-05,  5.019034303668002e-06, -3.199283683409111e-08, -3.568945873929188e-09,  6.080790664820895e-11,  2.734113309971736e-12, -7.706967820970500e-14,
 -2.058774486224730e-15,  8.669834981663279e-17,  1.463580108929525e-18,  1.823269402111515e-03, -1.742133244274200e-05,  1.414447625598300e-07, -4.787982977458094e-10,
 -2.513068751529104e-12, -2.978817053123619e-13,  6.837336090363523e-15,  2.109937021800070e-16, -6.622689032844495e-18, -1.591583484802778e-19,  6.411894285818275e-21,
  1.133660587874652e-22,  1.644787668249349e-02, -1.571298543978618e-04,  1.273700568556276e-06, -4.231049877543949e-09, -2.417363801433744e-11, -2.695370261984586e-12,
  6.214713810709119e-14,  1.918995276444457e-15, -6.033252269574326e-17, -1.447247454159017e-18,  5.844021541773165e-20,  1.031019173443828e-21,  4.590552140533544e-02,
 -4.383748670231907e-04,  3.541718592976351e-06, -1.130084571398163e-08, -7.613336435849498e-11, -7.569600598663686e-12,  1.761569760159558e-13,  5.445481965553914e-15,
 -1.717912635731822e-16, -4.105153799139977e-18,  1.665699695463887e-19,  2.925374012546604e-21,  9.062984060446745e-02, -8.649417443540494e-04,  6.951366272943374e-06,
 -2.072575579987569e-08, -1.774273071028635e-10, -1.509072771091532e-11,  3.563296197282950e-13,  1.102953469542247e-14, -3.498801784171184e-16, -8.310045550897057e-18,
  3.397955852527733e-19,  5.923945620371483e-21,  1.513166230523105e-01, -1.442853862826261e-03,  1.150797892591847e-05, -3.079510657385270e-08, -3.616591897198826e-10,
 -2.554708327486387e-11,  6.158474349220646e-13,  1.908075940474717e-14, -6.102454020595011e-16, -1.436636990939094e-17,  5.940770991080856e-19,  1.024421060019149e-20,
  2.289890311484885e-01, -2.180854188965690e-03,  1.721009696070533e-05, -3.861154267042599e-08, -6.853148929699672e-10, -3.939861189981403e-11,  9.769939376517948e-13,
  3.025935580626278e-14, -9.791882373745295e-16, -2.276695890439459e-17,  9.565210172230759e-19,  1.623350234370372e-20,  3.251074626469456e-01, -3.091181101895912e-03,
  2.403592776666510e-05, -3.922434303233687e-08, -1.244257678325395e-09, -5.738158811609203e-11,  1.478176935919222e-12,  4.562529560780564e-14, -1.501568200314387e-15,
 -3.430759159090416e-17,  1.473994813685069e-18,  2.443940385099865e-20,  4.417571274191613e-01, -4.190804875809406e-03,  3.191270831837008e-05, -2.382342624982233e-08,
 -2.208295581719775e-09, -8.072870874438368e-11,  2.189653697127606e-12,  6.692347430754592e-14, -2.257944682355522e-15, -5.030734173591880e-17,  2.232134350538336e-18,
  3.573018301907897e-20,  5.819844803313232e-01, -5.503414058278614e-03,  4.064174491782328e-05,  2.438043385422706e-08, -3.900653995601763e-09, -1.116925657991966e-10,
  3.253277941414592e-12,  9.715166590374912e-14, -3.406001428794427e-15, -7.304814844381690e-17,  3.402169161488354e-18,  5.147630181222821e-20,  7.504521522772063e-01,
 -7.062597534077700e-03,  4.969220204836825e-05,  1.408788641287251e-07, -7.006881897926440e-09, -1.550509634222014e-10,  5.002414201088630e-12,  1.417087046351169e-13,
 -5.297830972430361e-15, -1.066404135126140e-16,  5.376007205960787e-18,  7.360907451189855e-20,  9.548828243119434e-01, -8.916370960376639e-03,  5.752214505326914e-05,
  4.138092881768569e-07, -1.324308181348695e-08, -2.239328346130823e-10,  8.435238135004826e-12,  2.101802034178051e-13, -8.902898008256670e-15, -1.579512176423535e-16,
  9.256985626339061e-18,  1.022136164051895e-19,  1.209933428512357e+00, -1.112643092944722e-02,  5.855527625926387e-05,  1.131934114393554e-06, -2.827729625086357e-08,
 -3.775048235099292e-10,  1.817791921256658e-11,  3.061401340316273e-13, -1.815427345211701e-14, -2.176580464316755e-16,  1.940517618960671e-17,  9.532144908024863e-20,
  1.552049385208651e+00, -1.362375624259148e-02,  1.765474228558075e-05,  4.035798829027178e-06, -8.421486491906329e-08, -1.512482930030361e-09,  9.680482138594030e-11,
 -2.017488533760553e-13, -8.515420300897926e-14,  1.415003686832663e-15,  5.970999187854958e-17, -2.140907553922414e-18,  1.755809320733166e-03, -1.631382702567791e-05,
  1.352945481257610e-07, -5.562239316350303e-10, -6.490501004137728e-12, -9.022025493334573e-14,  9.300178274903297e-15, -3.865065803994024e-17, -7.336823255886673e-18,
  1.098284904187634e-19,  5.074631963824419e-21, -1.464805901766976e-22,  1.583940098296004e-02, -1.471534127908399e-04,  1.219130330691059e-06, -4.954150295682370e-09,
 -6.008200785255964e-11, -8.079260634714512e-13,  8.451028881683041e-14, -3.536880243457210e-16, -6.674566591338087e-17,  1.002279323419204e-18,  4.615419910105442e-20,
 -1.336242548410349e-21,  4.420778830012299e-02, -4.106140731548370e-04,  3.394659693674078e-06, -1.346100692931667e-08, -1.765071477834717e-10, -2.220241065173106e-12,
  2.393989845174743e-13, -1.016541264657976e-15, -1.895076871314976e-16,  2.864145026013015e-18,  1.309745488919570e-19, -3.815449396428522e-21,  8.727962627354428e-02,
 -8.103934101934849e-04,  6.677395803979195e-06, -2.543476974564341e-08, -3.760522597493653e-10, -4.273278637683068e-12,  4.837064893635247e-13, -2.101616593849991e-15,
 -3.842061907769539e-16,  5.866284267285292e-18,  2.653082412918353e-19, -7.804975493354593e-21,  1.457268122235266e-01, -1.352399457354525e-03,  1.108984950028193e-05,
 -3.972857090648349e-08, -6.943135182092607e-10, -6.863454030663665e-12,  8.343467298420784e-13, -3.746995246954642e-15, -6.656932479912507e-16,  1.031452005937774e-17,
  4.590848261386558e-19, -1.369888923761312e-20,  2.205377111838368e-01, -2.045263635566349e-03,  1.665971012347605e-05, -5.438892202263642e-08, -1.190663028248176e-09,
 -9.797787889320485e-12,  1.319189615708153e-12, -6.201893464468273e-15, -1.058277306175683e-15,  1.673448282425350e-17,  7.283988755213835e-19, -2.217128821501566e-20,
  3.131237571339257e-01, -2.901187861310332e-03,  2.341508720757512e-05, -6.605966953553002e-08, -1.964969620621989e-09, -1.270994159954007e-11,  1.984573609398704e-12,
 -9.931087587453599e-15, -1.601886802890709e-15,  2.604871873178640e-17,  1.099277358348891e-18, -3.439752570923116e-20,  4.255017173532472e-01, -3.937349035378482e-03,
  3.137215234479254e-05, -6.874223038726162e-08, -3.192479724191338e-09, -1.487120665824832e-11,  2.911169979975872e-12, -1.586403310015314e-14, -2.364546970083024e-15,
  3.997365076427583e-17,  1.614932928921131e-18, -5.254442545996240e-20,  5.606212624017369e-01, -5.178309413446543e-03,  4.050181750259747e-05, -5.097664472864770e-08,
 -5.203722034963793e-09, -1.472105290578279e-11,  4.251169958037207e-12, -2.606719562616427e-14, -3.469700792275000e-15,  6.201607237822056e-17,  2.350271280619173e-18,
 -8.098033147066585e-20,  7.230046025586508e-01, -6.660391714355760e-03,  5.063167236898876e-05,  1.145798284387808e-08, -8.694320477851239e-09, -8.526273056252722e-12,
  6.330039636151932e-12, -4.590806247908588e-14, -5.162689956452416e-15,  1.004181793385469e-16,  3.440830822024396e-18, -1.297548553777188e-19,  9.201637093448951e-01,
 -8.440194559898162e-03,  6.110833368901159e-05,  1.784705652558485e-07, -1.539968036766941e-08,  1.431508587218695e-11,  9.999233407016596e-12, -9.312995745173805e-14,
 -7.993353251188879e-15,  1.792693848976750e-16,  5.119668804795520e-18, -2.270494910563264e-19,  1.166439206944570e+00, -1.061175759933912e-02,  6.925651900374717e-05,
  6.444935124602845e-07, -3.112105995113737e-08,  9.400716215431801e-11,  1.847686104726087e-11, -2.576594131573881e-13, -1.330332179159107e-14,  4.018892297781425e-16,
  7.251581588995266e-18, -4.803785456642026e-19,  1.498109184905093e+00, -1.331321479506374e-02,  5.739335328385728e-05,  2.565863788275764e-06, -9.303582046417757e-08,
  4.939322495982157e-10,  6.284233048978374e-11, -1.841500469032233e-12, -1.451202255211978e-14,  1.921279884588723e-15, -2.660406211301249e-17, -1.171861334842568e-18,
  1.692673874175551e-03, -1.525999671722819e-05,  1.279744818797084e-07, -6.631671384215304e-10, -6.268115209233991e-12,  9.818310051201011e-14,  5.725253060466189e-15,
 -1.847843148863923e-16, -1.433547275970140e-18,  1.721598123021947e-19, -1.666965231290895e-21, -1.115803042042464e-22,  1.526989307371657e-02, -1.376550562938437e-04,
  1.153717879984769e-06, -5.941710723700691e-09, -5.782959402322030e-11,  9.031234032956231e-13,  5.194473564141925e-14, -1.681663237358367e-15, -1.296708954649182e-17,
  1.566682770093252e-18, -1.525310586239803e-20, -1.014511176160229e-21,  4.261855374066267e-02, -3.841523734401524e-04,  3.215675914111113e-06, -1.634868387677267e-08,
 -1.687955382112835e-10,  2.621141235977092e-12,  1.466786145020334e-13, -4.778445338694999e-15, -3.637949781762812e-17,  4.451044975050386e-18, -4.382512303372354e-20,
 -2.877028203974806e-21,  8.414280988786833e-02, -7.582999866922993e-04,  6.335192162971526e-06, -3.154650300452500e-08, -3.563377114637787e-10,  5.490639238793179e-12,
  2.948666920407188e-13, -9.700865375613019e-15, -7.234455870101165e-17,  9.033126385268713e-18, -9.051903760282501e-20, -5.821542740060851e-21,  1.404913607443536e-01,
 -1.265780184482432e-03,  1.054525686481629e-05, -5.092134017008009e-08, -6.504616171614461e-10,  9.933083109904576e-12,  5.049021741666853e-13, -1.684424791783507e-14,
 -1.217952685716001e-16,  1.567398490638651e-17, -1.610310665343465e-19, -1.005713545528818e-20,  2.126186150190355e-01, -1.914924742661284e-03,  1.589153685308682e-05,
 -7.340613969251629e-08, -1.100924861403231e-09,  1.665915060369620e-11,  7.901742701897690e-13, -2.686754765812147e-14, -1.856894167409836e-16,  2.496776661863543e-17,
 -2.653430712322217e-19, -1.591893632364849e-20,  3.018878666871331e-01, -2.717575851965920e-03,  2.243324823286386e-05, -9.713018865326409e-08, -1.790800368247862e-09,
  2.688209285410467e-11,  1.171954326295339e-12, -4.088214283088784e-14, -2.642733405633294e-16,  3.789752020799149e-17, -4.213838065030262e-19, -2.393967452309780e-20,
  4.102478250176632e-01, -3.690539043513515e-03,  3.024251057113906e-05, -1.186895204455658e-07, -2.864507727406089e-09,  4.277286678043307e-11,  1.685009687749738e-12,
 -6.085510994284403e-14, -3.547697498743481e-16,  5.615415606736661e-17, -6.633785739854525e-19, -3.498025249594345e-20,  5.405501947734087e-01, -4.858145566276053e-03,
  3.939762785113023e-05, -1.314905715718847e-07, -4.591291992250807e-09,  6.853210174069158e-11,  2.389355819266564e-12, -9.056473183850513e-14, -4.436412339062840e-16,
  8.284560798945467e-17, -1.063158131316337e-18, -5.046569973581274e-20,  6.971707210450309e-01, -6.257115902134830e-03,  4.995372934589112e-05, -1.214840532258878e-07,
 -7.529526064007563e-09,  1.133047285043552e-10,  3.397605226767946e-12, -1.382344706988478e-13, -4.770601588471586e-16,  1.242620021523378e-16, -1.793955644743644e-18,
 -7.274308266162231e-20,  8.873884425960546e-01, -7.946849760391578e-03,  6.181980885569388e-05, -5.391516526140459e-08, -1.304528874229687e-08,  2.009883449733815e-10,
  4.948645911504688e-12, -2.256482500549945e-13, -2.191306249802888e-16,  1.949303844188314e-16, -3.371855365212967e-18, -1.047424362280442e-19,  1.125137679155101e+00,
 -1.003495031979884e-02,  7.413452309644132e-05,  1.825561331146605e-07, -2.557862088315740e-08,  4.171615080914437e-10,  7.649447806658654e-12, -4.344383731186910e-13,
  1.782674589414631e-15,  3.331950588100676e-16, -7.991796763080535e-18, -1.338099834691220e-19,  1.445935452097445e+00, -1.275501736312422e-02,  7.979515937387285e-05,
  1.220522441195667e-06, -7.228422070029942e-08,  1.385718164900988e-09,  1.331903622050330e-11, -1.467065319832894e-12,  2.882195987299294e-14,  4.395944112022045e-16,
 -3.486344059200338e-17,  5.242511517526861e-19,  1.633628918394025e-03, -1.426954894525750e-05,  1.194988383430999e-07, -7.420670843015205e-10, -3.354264381885749e-12,
  1.733980801691362e-13,  7.070785583239863e-16, -1.511893804385844e-16,  2.801804827104909e-18,  5.311038166128816e-20, -3.236769878444500e-21,  2.845968624777536e-23,
  1.473726082378486e-02, -1.287245129500513e-04,  1.077636758371150e-06, -6.670989524371058e-09, -3.115651958226213e-11,  1.584079188743328e-12,  6.307082789547344e-15,
 -1.373952953098624e-15,  2.553160570082510e-17,  4.814387928555963e-19, -2.945877772550650e-20,  2.608287895647150e-22,  4.113209428252510e-02, -3.592526178909677e-04,
  3.005510687737801e-06, -1.848488082305102e-08, -9.211884751228360e-11,  4.535489184191613e-12,  1.718218064032300e-14, -3.892518872428059e-15,  7.274135657053152e-17,
  1.356811343419400e-18, -8.371505160163248e-20,  7.518207740370245e-22,  8.120845223056010e-02, -7.092192267295887e-04,  5.927039126194518e-06, -3.607843401869524e-08,
 -1.979583950703147e-10,  9.312166038505646e-12,  3.256099637024745e-14, -7.865186948606675e-15,  1.482856342241815e-16,  2.718299721938201e-18, -1.699585275164786e-19,
  1.560405150947129e-21,  1.355928686274787e-01, -1.184020710464360e-03,  9.880001209306949e-06, -5.924321843302554e-08, -3.691068223410908e-10,  1.641093469401248e-11,
  5.092106767644569e-14, -1.356405942855098e-14,  2.589720519667544e-16,  4.628571188766555e-18, -2.950555406911290e-19,  2.794089781006112e-21,  2.052072192671715e-01,
 -1.791584662624166e-03,  1.491860051088518e-05, -8.758324577359850e-08, -6.393349897035988e-10,  2.665546050049174e-11,  6.933015938892598e-14, -2.143046814496410e-14,
  4.162788720909725e-16,  7.178211279380863e-18, -4.703036712711614e-19,  4.642042679720452e-21,  2.913684896895155e-01, -2.543210373673322e-03,  2.111738914198450e-05,
 -1.203453444604405e-07, -1.064752674634306e-09,  4.142219416719060e-11,  8.200019730017345e-14, -3.218126313768118e-14,  6.398417096945887e-16,  1.048839650718222e-17,
 -7.143826810283048e-19,  7.445232296710381e-21,  3.959595288081820e-01, -3.454998805568417e-03,  2.857700031016263e-05, -1.560614997909884e-07, -1.742225194226217e-09,
  6.311127198177700e-11,  7.688561092497429e-14, -4.702234078749212e-14,  9.649930458577182e-16,  1.470008274964447e-17, -1.059364991336953e-18,  1.185560491859223e-20,
  5.217363758242253e-01, -4.550404796653736e-03,  3.743194546296219e-05, -1.917296824780926e-07, -2.850536786270855e-09,  9.622501114971045e-11,  2.678590167085230e-14,
 -6.811478704006611e-14,  1.460846035614864e-15,  1.989882899497682e-17, -1.563964075874541e-18,  1.923837831980648e-20,  6.729296483803150e-01, -5.865170818482231e-03,
  4.785865225256267e-05, -2.206971296790434e-07, -4.755073330466204e-09,  1.502019578524330e-10, -1.377201032835413e-13, -9.972224051041279e-14,  2.280669111225881e-15,
  2.573229628852287e-17, -2.345996103358538e-18,  3.285471214586315e-20,  8.565814963732832e-01, -7.458090574827390e-03,  6.006829097513059e-05, -2.261184215188090e-07,
 -8.330092265771920e-09,  2.485486508397938e-10, -6.313032023479803e-13, -1.515619251699570e-13,  3.837055678030681e-15,  2.927689172938377e-17, -3.672326026378787e-18,
  6.218269059230994e-20,  1.086188975967356e+00, -9.439389573172358e-03,  7.416652899462788e-05, -1.538819993483628e-07, -1.631302682433428e-08,  4.699542577210307e-10,
 -2.383055197045396e-12, -2.514075084503362e-13,  7.679984041018325e-15,  8.273325140985913e-18, -6.207690126489342e-18,  1.449702258716852e-19,  1.396259951853935e+00,
 -1.207557452402392e-02,  8.843956635570749e-05,  2.910691839955542e-07, -4.413088438116460e-08,  1.322936634600763e-09, -1.408513472032013e-11, -5.080810000054988e-13,
  2.611428355151889e-14, -4.039245243082835e-16, -7.568807323656772e-18,  5.192529524668123e-19,  1.578405366157106e-03, -1.334982661508819e-05,  1.103859922905059e-07,
 -7.683121537176314e-10, -2.637234233896844e-15,  1.506555734946458e-13, -2.141878955553376e-15, -5.237687252487833e-17,  2.841412331822837e-18, -3.600507469623332e-20,
 -1.065186154676688e-21,  5.123905279314324e-23,  1.423908917203157e-02, -1.204296974284508e-04,  9.956345480922095e-07, -6.919104734444728e-09, -5.594959826391567e-13,
  1.374762244293827e-12, -1.955985512049054e-14, -4.746124235737540e-16,  2.583662135171250e-17, -3.285938473901556e-19, -9.657171255895324e-21,  4.662703043090956e-22,
  3.974174083001899e-02, -3.361139868821393e-04,  2.777825683257709e-06, -1.924265533710800e-08, -4.639971838857083e-12,  3.927200267574191e-12, -5.596483802926078e-14,
 -1.336637737632852e-15,  7.328334641651017e-17, -9.390669039216030e-19, -2.722465823120561e-20,  1.324607033415497e-21,  7.846360857826359e-02, -6.635744227422261e-04,
  5.481197774543777e-06, -3.777786033825374e-08, -1.874056862616100e-11,  8.035097190057663e-12, -1.148056824651040e-13, -2.675436911809429e-15,  1.483450675716903e-16,
 -1.923421423752019e-18, -5.457144970105381e-20,  2.687806330797518e-21,  1.310102543194014e-01, -1.107899964406624e-03,  9.144385172618226e-06, -6.256782633462668e-08,
 -5.420897043511071e-11,  1.409237825922019e-11, -2.021512688376997e-13, -4.551456773343337e-15,  2.564799816166959e-16, -3.381370140901351e-18, -9.299691714731751e-20,
  4.662440024102455e-21,  1.982727294550558e-01, -1.676573545696678e-03,  1.382362288832022e-05, -9.363237922893138e-08, -1.298300324174284e-10,  2.274589752493974e-11,
 -3.281745050349475e-13, -7.055313567954350e-15,  4.065873051008313e-16, -5.482876694946337e-18, -1.444071427658865e-19,  7.422961229563861e-21,  2.815240535534583e-01,
 -2.380275135295103e-03,  1.959798301233149e-05, -1.309089591798825e-07, -2.768316513558607e-10,  3.506300019970715e-11, -5.101245025094083e-13, -1.031757731818046e-14,
  6.132187803624441e-16, -8.522494270925854e-18, -2.114289508240344e-19,  1.125564243333648e-20,  3.825843608075209e-01, -3.234253013687064e-03,  2.657792321090637e-05,
 -1.741202789322813e-07, -5.490496319089637e-10,  5.287462287764838e-11, -7.786392263021265e-13, -1.452005454379593e-14,  9.010534625628307e-16, -1.303792635145368e-17,
 -2.973573256336419e-19,  1.664654365744211e-20,  5.041181913783690e-01, -4.260783930639825e-03,  3.491962704359946e-05, -2.224561318986341e-07, -1.045397020226195e-09,
  7.954369928292043e-11, -1.192534553957974e-12, -1.989558359378105e-14,  1.314745179392337e-15, -2.009667254399419e-17, -4.051597326319951e-19,  2.447044900092698e-20,
  6.502163991415933e-01, -5.493965392745711e-03,  4.485012670745255e-05, -2.737213202435172e-07, -1.966101330886575e-09,  1.219269771106528e-10, -1.878732427335672e-12,
 -2.664056960212309e-14,  1.943367003192999e-15, -3.209852575321179e-17, -5.317420482051734e-19,  3.643445467937793e-20,  8.276903268194663e-01, -6.990297404407604e-03,
  5.671322433483709e-05, -3.216449086366012e-07, -3.781756995756893e-09,  1.964541344281330e-10, -3.165212735527930e-12, -3.425946215994712e-14,  2.992357252359996e-15,
 -5.556063266904595e-17, -6.349629552920467e-19,  5.620614260388617e-20,  1.049601027149761e+00, -8.857196564972190e-03,  7.104863983231600e-05, -3.447098141385528e-07,
 -7.916597675928286e-09,  3.549364353544593e-10, -6.205002463714032e-12, -3.613149059424284e-14,  5.054568149613699e-15, -1.147883345174693e-16, -3.787278119973990e-19,
  9.164697077006675e-20,  1.349380340850430e+00, -1.136421649164990e-02,  8.849994560718223e-05, -2.250449817488142e-07, -2.177839014403557e-08,  8.940367347620321e-10,
 -1.899648988787276e-11,  7.293507223767396e-14,  1.037886744183808e-14, -3.861868064040112e-16,  5.275568714537855e-18,  9.224194377307024e-20,  1.526714119697659e-03,
 -1.250340931170342e-05,  1.012554234354515e-07, -7.473736698453303e-10,  2.424902512561331e-12,  9.053383363192732e-14, -2.566144577864137e-15,  1.343287230446359e-17,
  1.234067532716224e-18, -4.340544880221036e-20,  4.264863783395558e-22,  1.558470609327561e-23,  1.377277699469581e-02, -1.127949824783017e-04,  9.133676580480471e-07,
 -6.736597122228904e-09,  2.159464262464412e-11,  8.265868655477115e-13, -2.337650695618125e-14,  1.233206299385614e-16,  1.119865401977060e-17, -3.947935134452484e-19,
  3.898069735359588e-21,  1.412331202936640e-22,  3.844027308691277e-02, -3.148108411050679e-04,  2.548799664089186e-06, -1.876993143256584e-08,  5.865890863231534e-11,
  2.363733839022149e-12, -6.655135098649172e-14,  3.566211098563302e-16,  3.163233630706968e-17, -1.120448813049491e-18,  1.117374898020907e-20,  3.977986293468885e-22,
  7.589414650379356e-02, -6.215321250031144e-04,  5.030834212350398e-06, -3.695854533101042e-08,  1.108029216200994e-10,  4.843371579447461e-12, -1.354790842728267e-13,
  7.434764880663646e-16,  6.361297143770914e-17, -2.270118001518045e-18,  2.299231216742287e-20,  7.962569799710304e-22,  1.267202145490931e-01, -1.037743328669654e-03,
  8.396732538062546e-06, -6.147225891000698e-08,  1.730511407667508e-10,  8.509719505743155e-12, -2.360421384559971e-13,  1.338123066673923e-15,  1.089472247658613e-16,
 -3.929763347109426e-18,  4.067683569526402e-20,  1.354150716113961e-21,  1.917804891141719e-01, -1.570482672121701e-03,  1.270107122153090e-05, -9.254158327471765e-08,
  2.370502201935729e-10,  1.376135311718160e-11, -3.779158050669035e-13,  2.234234720444731e-15,  1.704552944533421e-16, -6.239820754877411e-18,  6.649890919141744e-20,
  2.096719796903091e-21,  2.723065297604238e-01, -2.229801564974288e-03,  1.802130538339779e-05, -1.304557472698705e-07,  2.887126666256303e-10,  2.125038051150887e-11,
 -5.771067097257312e-13,  3.596573878092019e-15,  2.524698124993206e-16, -9.430462609408248e-18,  1.044271067807263e-19,  3.057565338393989e-21,  3.700592486209341e-01,
 -3.030063439350166e-03,  2.446712953447823e-05, -1.755461947647984e-07,  3.034407865364336e-10,  3.208264881271135e-11, -8.611816717666019e-13,  5.730557540813970e-15,
  3.617096554913465e-16, -1.389299832948009e-17,  1.617642062300451e-19,  4.275783003561564e-21,  4.876166074982255e-01, -3.992278978377710e-03,  3.219692511068637e-05,
 -2.281237163398989e-07,  2.356221540118710e-10,  4.825794038178231e-11, -1.281065906559378e-12,  9.251567359318334e-15,  5.088062869894568e-16, -2.033694557813132e-17,
  2.531066057879768e-19,  5.776886085493082e-21,  6.289368051033947e-01, -5.148669165695200e-03,  4.144884084876314e-05, -2.882622462244947e-07, -7.404055643154934e-12,
  7.376687499062740e-11, -1.941443725413734e-12,  1.556159444095432e-14,  7.107293861076047e-16, -3.017889865846455e-17,  4.113846283250641e-19,  7.479637161569562e-21,
  8.006110103653532e-01, -6.552788322429713e-03,  5.260625056782917e-05, -3.550038284180594e-07, -6.422490701600183e-10,  1.178776252793039e-10, -3.096037335846036e-12,
  2.851114962781951e-14,  9.918028513681048e-16, -4.667804610157545e-17,  7.256983683602591e-19,  8.706006911213993e-21,  1.015280425589645e+00, -8.307020438945954e-03,
  6.635992226065122e-05, -4.227406219821779e-07, -2.310611754910394e-09,  2.083913483319663e-10, -5.557799562287050e-12,  6.261033944175930e-14,  1.343536581466426e-15,
 -7.911565483487799e-17,  1.520934773851275e-18,  4.709027840230558e-21,  1.305315603464317e+00, -1.067173914598401e-02,  8.422169777332971e-05, -4.540044543561938e-07,
 -8.146261109083331e-09,  4.888793825526044e-10, -1.408030542451484e-11,  2.269145835983404e-13,  6.138920496830369e-16, -1.599298711055883e-16,  4.920305444258938e-18,
 -6.425210333626164e-20,  1.478264855125138e-03, -1.172846351503439e-05,  9.256914801384115e-08, -6.972450413703798e-10,  3.667612848995595e-12,  3.661961915146218e-14,
 -1.843369132550981e-15,  3.204816375226962e-17,  6.879953877753746e-20, -2.050553403626640e-20,  5.695933322091296e-22, -4.933699275025476e-24,  1.333570867526682e-02,
 -1.058044575261672e-04,  8.350530025795793e-07, -6.287565181400949e-09,  3.295389210890916e-11,  3.356373529143320e-13, -1.678129126411409e-14,  2.919145690126479e-16,
  6.085208418304751e-19, -1.861560643975917e-19,  5.181353953466969e-21, -4.513325375185279e-23,  3.722041058271877e-02, -2.953023925639264e-04,  2.330483952973526e-06,
 -1.753496353127322e-08,  9.121629526849755e-11,  9.671206006362598e-13, -4.771071499783745e-14,  8.309036028965666e-16,  1.626703569682563e-18, -5.262722866631702e-19,
  1.470858859340103e-20, -1.296004395454501e-22,  7.348575336951114e-02, -5.830230601331664e-04,  4.600620446591494e-06, -3.457710227745944e-08,  1.777370321586215e-10,
  2.003731612642686e-12, -9.691906044851426e-14,  1.691091594843316e-15,  2.977871302231244e-18, -1.059746704337407e-18,  2.981172562194739e-20, -2.673830457521188e-22,
  1.226989981544355e-01, -9.734620452582179e-04,  7.680346184448921e-06, -5.763140474715511e-08,  2.911592003010279e-10,  3.570792680541454e-12, -1.683491708384559e-13,
  2.945795542292335e-15,  4.374783587163678e-18, -1.818422688697000e-18,  5.163206583929449e-20, -4.747073801156956e-22,  1.856948571490957e-01, -1.473233763106895e-03,
  1.162089464440089e-05, -8.700985827640921e-08,  4.290265969944322e-10,  5.872324611928322e-12, -2.684200918771110e-13,  4.716240220443840e-15,  5.264038753499847e-18,
 -2.852434631283169e-18,  8.203400452104835e-20, -7.794712758046023e-22,  2.636658973138658e-01, -2.091786832890554e-03,  1.649526535349200e-05, -1.231418635952003e-07,
  5.868785414341565e-10,  9.240767114416876e-12, -4.076068206169919e-13,  7.204365350485763e-15,  4.553477022942396e-18, -4.239789315767724e-18,  1.240719468828285e-19,
 -1.230453553034423e-21,  3.583172994712963e-01, -2.842628267489903e-03,  2.240743620756038e-05, -1.666082413612193e-07,  7.563886401877544e-10,  1.423628477398566e-11,
 -6.036307991392524e-13,  1.076099090441264e-14, -2.619139705174058e-20, -6.103816754610373e-18,  1.829327138032495e-19, -1.917368154913695e-21,  4.721454791609226e-01,
 -3.745526383878718e-03,  2.950880220257122e-05, -2.181897353681373e-07,  9.212267343663093e-10,  2.186201657505566e-11, -8.884816392954500e-13,  1.604118677608106e-14,
 -1.357667757750403e-17, -8.645941304548881e-18,  2.679978567306448e-19, -3.018995270672710e-21,  6.089835273023153e-01, -4.830820480616171e-03,  3.802995903158207e-05,
 -2.789269285153370e-07,  1.046748885395204e-09,  3.409014799003223e-11, -1.325941310445979e-12,  2.440928708077756e-14, -4.898997830234325e-17, -1.220785215642446e-17,
  3.979042080778050e-19, -4.935694787884595e-21,  7.752145352373409e-01, -6.148998702261047e-03,  4.835012797807729e-05, -3.501385127231353e-07,  1.049625075068405e-09,
  5.539554748064517e-11, -2.064203992267720e-12,  3.922502397510072e-14, -1.453058763206610e-16, -1.736984481045112e-17,  6.150816302697536e-19, -8.733603090488909e-21,
  9.830814492395242e-01, -7.796788218248918e-03,  6.118105198305013e-05, -4.329613074077470e-07,  6.808036005492556e-10,  9.868356182239105e-11, -3.548568809474665e-12,
  7.146108831122723e-14, -4.638051180505161e-16, -2.473369047610522e-17,  1.037355735108023e-18, -1.816296571800232e-20,  1.263939404027908e+00, -1.002133906423633e-02,
  7.826066315283095e-05, -5.223404180658210e-07, -1.239923883761344e-09,  2.253094127962032e-10, -8.080142380080356e-12,  1.865864144558251e-13, -2.320569197559113e-15,
 -2.250802768454128e-17,  2.034685773279837e-18, -5.505106225484532e-20  };
  constexpr double w[4992] = {  2.315806620512299e-01, -2.500733233052667e-03,  2.996954589428386e-05, -3.766231163718286e-07,  4.790158315795040e-09,
 -6.065645599434770e-11,  7.597102703756305e-13, -9.395457855878426e-15,  1.147285944387986e-16, -1.384339364035127e-18,  1.651882957066130e-20, -1.950766001950411e-22,
  2.228182459016555e-01, -5.125275484411538e-03,  1.232923661569682e-04, -2.696995857703739e-06,  5.462568649356539e-08, -1.043028259267972e-09,  1.898998053297344e-11,
 -3.321794380983343e-13,  5.612958900184470e-15, -9.199201966542450e-17,  1.466978618579625e-18, -2.281459852101302e-20,  2.066100213216586e-01, -9.677376430544372e-03,
  3.673859030744497e-04, -1.170369879182242e-05,  3.310810841623814e-07, -8.561257670185419e-09,  2.059699340139995e-10, -4.665522500734713e-12,  1.003514428839056e-13,
 -2.062694214039625e-15,  4.071604783596388e-17, -7.745738510230381e-19,  1.851792261331782e-01, -1.501870354208671e-02,  8.260203174174093e-04, -3.610610490846786e-05,
  1.351114593830386e-06, -4.497988049867840e-08,  1.363813251405982e-09, -3.825780097156097e-11,  1.004069002751088e-12, -2.485964688535798e-14,  5.843784701635464e-16,
 -1.310293767375331e-17,  1.610301247099435e-01, -1.994835282475119e-02,  1.505187416749346e-03, -8.627808383425977e-05,  4.104224117041099e-06, -1.696986338026568e-07,
  6.273312381438541e-09, -2.112885502351684e-10,  6.571147159911542e-12, -1.906030303124179e-13,  5.196182196109805e-15, -1.338763852560174e-16,  1.363709130440188e-01,
 -2.352956962118093e-02,  2.320637487610258e-03, -1.678074111053193e-04,  9.817430135082520e-06, -4.895268204174413e-07,  2.147834801737597e-08, -8.471585667210824e-10,
  3.050003184789661e-11, -1.013814840023981e-12,  3.138806349016637e-14, -9.108476664619240e-16,  1.127702892360886e-01, -2.525090308972100e-02,  3.115061564861228e-03,
 -2.744321058606005e-04,  1.917016844388728e-05, -1.122968898698917e-06,  5.710742142404614e-08, -2.580762090173258e-09,  1.053929453435262e-10, -3.938567649032057e-12,
  1.360057550259309e-13, -4.369838568251831e-15,  9.108464842387991e-02, -2.501336976396867e-02,  3.709383315209710e-03, -3.855578506077782e-04,  3.128575157934834e-05,
 -2.101275476450229e-06,  1.211574851554231e-07, -6.147897001742685e-09,  2.795031343036855e-10, -1.153948503785937e-11,  4.372042541469084e-13, -1.531407356192099e-14,
  7.157683982439784e-02, -2.301044248474283e-02,  3.957458847111772e-03, -4.709953018044951e-04,  4.325466412788116e-05, -3.254531617497742e-06,  2.083381594060544e-07,
 -1.164382650732197e-08,  5.789106179407366e-10, -2.597044935754701e-11,  1.062962638983441e-12, -4.000368219889976e-14,  5.411098991126381e-02, -1.958324203764820e-02,
  3.780881721523566e-03, -5.009277333074804e-04,  5.078328215019737e-05, -4.185517697256212e-06,  2.914535662740956e-07, -1.760755150969630e-08,  9.408924475463813e-10,
 -4.513169938829889e-11,  1.965799906015266e-12, -7.837981248348011e-14,  3.833463990002915e-02, -1.510638846994756e-02,  3.177728204020065e-03, -4.563395372806211e-04,
  4.985457458348097e-05, -4.403438225730000e-06,  3.269167224598615e-07, -2.095770882947666e-08,  1.183279793733234e-09, -5.973304768771073e-11,  2.728235117680568e-12,
 -1.136741424043359e-13,  2.380765089529189e-02, -9.923701440192032e-03,  2.212194909404526e-03, -3.356543264937137e-04,  3.860174302096186e-05, -3.576047436780172e-06,
  2.774971433734024e-07, -1.853457140990555e-08,  1.087069866976255e-09, -5.684996731477557e-11,  2.683178341307023e-12, -1.152496392032343e-13,  1.008773986780571e-02,
 -4.333886911495893e-03,  9.972822387553470e-04, -1.559741980051624e-04,  1.845422696395092e-05, -1.755366692924434e-06,  1.395991167115191e-07, -9.538974698537689e-09,
  5.714276309725538e-10, -3.047620294378313e-11,  1.464868414086146e-12, -6.399193057605630e-14,  2.220303439617482e-01, -2.277838029643778e-03,  2.587287182160814e-05,
 -3.087774831005152e-07,  3.740014764339001e-09, -4.520729691322094e-11,  5.413644501211179e-13, -6.409041169109132e-15,  7.497819812642247e-17, -8.673612685723561e-19,
  9.927821269573977e-21, -1.125199389038343e-22,  2.041039213090051e-01, -4.254973031477036e-03,  9.555645700476851e-05, -1.967939218029242e-06,  3.766257574781703e-08,
 -6.812834113216010e-10,  1.177635880798184e-11, -1.959324987647401e-13,  3.153955764288705e-15, -4.931102097862254e-17,  7.510772090581255e-19, -1.116957642816648e-20,
  1.730011448971041e-01, -7.221477571728702e-03,  2.538375274716196e-04, -7.546285315855436e-06,  2.003277052613623e-07, -4.881553039617584e-09,  1.110361581470190e-10,
 -2.384369098336073e-12,  4.873127432004964e-14, -9.536786843141527e-16,  1.795530924351518e-17, -3.263359525259893e-19,  1.360179889357762e-01, -9.834521473550595e-03,
  4.976698804203799e-04, -2.021473544928019e-05,  7.078271374047917e-07, -2.216200728637637e-08,  6.345131828951892e-10, -1.686304513112481e-11,  4.204683104202899e-13,
 -9.914855667359634e-15,  2.224625851358004e-16, -4.770620901715873e-18,  1.000550761172463e-01, -1.114514156475679e-02,  7.737338236221516e-04, -4.123493514010793e-05,
  1.836973853106162e-06, -7.151838300578495e-08,  2.500289251498699e-09, -7.992689849325122e-11,  2.366604390507651e-12, -6.553254599768688e-14,  1.709619384622776e-15,
 -4.224418938320145e-17,  6.960684357430413e-02, -1.094425887904514e-02,  9.990029527500205e-04, -6.748578242921614e-05,  3.713484368931963e-06, -1.750772946051613e-07,
  7.294374522316504e-09, -2.741924915032190e-10,  9.437315454153983e-12, -3.007133952371085e-13,  8.946709012675581e-15, -2.500481653680212e-16,  4.634988978546695e-02,
 -9.610969484240931e-03,  1.108612643569728e-03, -9.200026777887031e-05,  6.088774874442566e-06, -3.395092073670443e-07,  1.649872156665668e-08, -7.148701357625937e-10,
  2.807190570401038e-11, -1.011328194391096e-12,  3.374412522426025e-14, -1.049809981592195e-15,  2.989179490901775e-02, -7.733625513274920e-03,  1.086153648992565e-03,
 -1.074914079282105e-04,  8.342297302870898e-06, -5.379370037156813e-07,  2.987610434546310e-08, -1.464384121653670e-09,  6.446899007107278e-11, -2.583135078825702e-12,
  9.517066383214998e-14, -3.247625199034505e-15,  1.884434305809348e-02, -5.803672002784711e-03,  9.583819109415624e-04, -1.098988481693457e-04,  9.755734767070525e-06,
 -7.115339876308546e-07,  4.426244545451234e-08, -2.409207645886031e-09,  1.168822307066709e-10, -5.125455745441549e-12,  2.053852801780579e-13, -7.578523619684240e-15,
  1.164345598459269e-02, -4.097565155419511e-03,  7.696767311275378e-04, -9.941248805417573e-05,  9.845267421182012e-06, -7.941708509604307e-07,  5.421591467256446e-08,
 -3.215936559582240e-09,  1.689627025363031e-10, -7.978251082856122e-12,  3.424699044798480e-13, -1.347085453903482e-14,  6.961564558249587e-03, -2.700020163234553e-03,
  5.588991979825573e-04, -7.905870792817873e-05,  8.517234453340465e-06, -7.426463752407596e-07,  5.448171222126945e-08, -3.454370298118882e-09,  1.930526735632461e-10,
 -9.653514657346165e-12,  4.370438333670658e-13, -1.806134289130870e-14,  3.812369425518792e-03, -1.577565550294218e-03,  3.490185979643399e-04, -5.257674198970950e-05,
  6.006076462834330e-06, -5.529348363446333e-07,  4.265868597116520e-08, -2.833911402335285e-09,  1.653779276138059e-10, -8.608240085450139e-12,  4.045132586937153e-13,
 -1.730413852302937e-14,  1.501622765345382e-03, -6.435604620801782e-04,  1.477061208919438e-04, -2.304272884064536e-05,  2.719752073479361e-06, -2.581119711009873e-07,
  2.048249094135125e-08, -1.396727374410126e-09,  8.350794178827433e-11, -4.445570188041015e-12,  2.133072786476091e-13, -9.302767836539706e-15,  2.133108417041118e-01,
 -2.084723503208021e-03,  2.249887762399042e-05, -2.555209557956608e-07,  2.952548608508029e-09, -3.412320004275242e-11,  3.913025321205122e-13, -4.441410089340950e-15,
  4.985316578931549e-17, -5.537354055772546e-19,  6.088135741636970e-21, -6.631904295151388e-23,  1.884765815507472e-01, -3.575682513224532e-03,  7.515224522068557e-05,
 -1.460666218008251e-06,  2.647152435722645e-08, -4.545338954976910e-10,  7.472727534140303e-12, -1.184504732551208e-13,  1.819200310798166e-15, -2.717187858345504e-17,
  3.958293809994016e-19, -5.635944971764600e-21,  1.476713219708953e-01, -5.505090269024874e-03,  1.797055667060716e-04, -4.997190884478672e-06,  1.247296886974952e-07,
 -2.869003924958354e-09,  6.179070881270252e-11, -1.259559074452055e-12,  2.448924551985468e-14, -4.567824974752325e-16,  8.210462368624459e-18, -1.426841094663945e-19,
  1.033396108787989e-01, -6.659950352975720e-03,  3.107167888401690e-04, -1.174489183400080e-05,  3.852777514759078e-07, -1.135649231092204e-08,  3.072768211168120e-10,
 -7.741956294124344e-12,  1.835020612742668e-13, -4.122921990447323e-15,  8.832657531912968e-17, -1.811986817501310e-18,  6.530519323023140e-02, -6.525653373473809e-03,
  4.168619878789769e-04, -2.065676705666772e-05,  8.618459849876923e-07, -3.159392336761730e-08,  1.044449161258537e-09, -3.168376706441905e-11,  8.929519127918187e-13,
 -2.359737186933489e-14,  5.888817109881653e-16, -1.394927835569994e-17,  3.782462435855122e-02, -5.396651501655198e-03,  4.550365790058035e-04, -2.867438486053392e-05,
  1.482170657690410e-06, -6.599483164850063e-08,  2.608051254919748e-09, -9.332778377481055e-11,  3.067530725674464e-12, -9.359833686529593e-14,  2.673081089301879e-15,
 -7.187517632325990e-17,  2.045173639629031e-02, -3.905840532456988e-03,  4.197630635680191e-04, -3.272073239762239e-05,  2.046700711564925e-06, -1.083937679662244e-07,
  5.023422330628415e-09, -2.082933878282133e-10,  7.850937986535583e-12, -2.722012513154897e-13,  8.761279477733070e-15, -2.635082027751901e-16,  1.054283485449651e-02,
 -2.554773271371729e-03,  3.383117471837354e-04, -3.176131348832669e-05,  2.350058495295772e-06, -1.450758955513571e-07,  7.740810715569411e-09, -3.656235999417754e-10,
  1.555251849778627e-11, -6.035176983897635e-13,  2.158012176449211e-14, -7.160946987598248e-16,  5.294783595128073e-03, -1.553905328588041e-03,  2.452910750596974e-04,
 -2.699853690921189e-05,  2.308908807483954e-06, -1.627517797261082e-07,  9.811864131154228e-09, -5.188368289299977e-10,  2.450632605459890e-11, -1.048255530883830e-12,
  4.104460866421147e-14, -1.482234739222060e-15,  2.637009719212085e-03, -8.987018372624372e-04,  1.636363185684338e-04, -2.053801286265827e-05,  1.981240616303753e-06,
 -1.560134157741062e-07,  1.041731832099265e-08, -6.054361386972767e-10,  3.121434457786642e-11, -1.448357478401279e-12,  6.116997124660676e-14, -2.370090707670017e-15,
  1.307517250958901e-03, -4.978221324044670e-04,  1.011551314133165e-04, -1.406339870839567e-05,  1.491110865494327e-06, -1.281192583520818e-07,  9.272686375383195e-09,
 -5.806297241965846e-10,  3.207676745342810e-11, -1.586916471934688e-12,  7.113478732396210e-14, -2.912788120240994e-15,  6.209911533833607e-04, -2.547928648119948e-04,
  5.587780457672092e-05, -8.348004351925940e-06,  9.462998919270899e-07, -8.649799014446279e-08,  6.629212015783723e-09, -4.376956128063383e-10,  2.539718267598124e-11,
 -1.314976262389447e-12,  6.148792493381441e-14, -2.618241999192109e-15,  2.248630424258023e-04, -9.610557739087781e-05,  2.199274993797385e-05, -3.421196055369466e-06,
  4.027157963978367e-07, -3.812129685440355e-08,  3.017831399330128e-09, -2.053218759914682e-10,  1.224946994712259e-11, -6.507788728445771e-13,  3.116555277762993e-14,
 -1.356719014157035e-15,  2.053135794711970e-01, -1.916243144540353e-03,  1.969509416466398e-05, -2.132688909849966e-07,  2.354783285051267e-09, -2.606085404277435e-11,
  2.865852254948546e-13, -3.123216087001012e-15,  3.368146310389320e-17, -3.597260570611262e-19,  3.803899026064949e-21, -3.988343779915228e-23,  1.752746044195661e-01,
 -3.038009012822271e-03,  5.989426987691575e-05, -1.101122703747775e-06,  1.893617959467947e-08, -3.092150520007599e-10,  4.843333271574453e-12, -7.325724602710661e-14,
  1.075051426041929e-15, -1.536101205341697e-17,  2.142991816643951e-19, -2.924939979499955e-21,  1.281892039967834e-01, -4.277275492875991e-03,  1.300514752084223e-04,
 -3.390553763054136e-06,  7.972324994830261e-08, -1.733884396635517e-09,  3.541174260805983e-11, -6.861372134539497e-13,  1.270615830882570e-14, -2.261311057573732e-16,
  3.884291866174452e-18, -6.460090366919263e-20,  8.090673897892774e-02, -4.648156797363529e-03,  2.003913554639069e-04, -7.060107424628136e-06,  2.172606852300609e-07,
 -6.035739316409496e-09,  1.544848169126804e-10, -3.693035714001319e-12,  8.326483657734100e-14, -1.783535445639089e-15,  3.649922461872200e-17, -7.165571947874105e-19,
  4.457965727505429e-02, -3.988326554034555e-03,  2.345743348028659e-04, -1.081249842598666e-05,  4.226418107611328e-07, -1.459185347064688e-08,  4.562114205457539e-10,
 -1.313354462940254e-11,  3.523006158494662e-13, -8.883830241966539e-15,  2.120324600949498e-16, -4.813577062530926e-18,  2.179952986521031e-02, -2.811515481036924e-03,
  2.186705205625694e-04, -1.284052620753868e-05,  6.229181319220660e-07, -2.617207154005919e-08,  9.802336624580001e-10, -3.336466132552487e-11,  1.046354268884024e-12,
 -3.054601109732655e-14,  8.366540075162756e-16, -2.162343445233728e-17,  9.670195323798743e-03, -1.691939847866402e-03,  1.688756029816257e-04, -1.233418817183500e-05,
  7.276181335834487e-07, -3.652962404913889e-08,  1.611614779280729e-09, -6.384147921406831e-11,  2.305948858633024e-12, -7.682306703073318e-14,  2.381698683502726e-15,
 -6.914996300603759e-17,  4.000120084820519e-03, -9.024557509531146e-04,  1.121912914192058e-04, -9.956223034558578e-06,  7.001773831453509e-07, -4.126709853223676e-08,
  2.110124486138455e-09, -9.582291221412262e-11,  3.929798371791779e-12, -1.473915210052712e-13,  5.105197660353754e-15, -1.644348867374470e-16,  1.593428185664247e-03,
 -4.430560545690022e-04,  6.654522084771285e-05, -7.002710122920088e-06,  5.749566982357963e-07, -3.904831656780234e-08,  2.275132898296671e-09, -1.165798138777480e-10,
  5.348452935731912e-12, -2.226799984151437e-13,  8.502500537126701e-15, -2.999411014105664e-16,  6.317130843678824e-04, -2.075190276864446e-04,  3.647834930748684e-05,
 -4.433186094744725e-06,  4.152618695588730e-07, -3.183209842940446e-08,  2.073674967753514e-09, -1.178111439078240e-10,  5.947892515486159e-12, -2.706780799850523e-13,
  1.122776561914779e-14, -4.278225919935600e-16,  2.551192657769874e-04, -9.506288599199648e-05,  1.890767394148172e-05, -2.577050863700185e-06,  2.683041640006859e-07,
 -2.267088861882016e-08,  1.615791308931358e-09, -9.975468355354202e-11,  5.439434693943608e-12, -2.658726682645593e-13,  1.178538690305467e-14, -4.776091864851878e-16,
  1.031620237840674e-04, -4.190791099884409e-05,  9.097394353165543e-06, -1.346142895902395e-06,  1.512426193495473e-07, -1.371146670840721e-08,  1.042906298551702e-09,
 -6.837694275542841e-11,  3.941872707202980e-12, -2.028704905810602e-13,  9.433223342645918e-15, -3.995982544499172e-16,  3.390080001213167e-05, -1.444345052938570e-05,
  3.294190057339545e-06, -5.107951801480014e-07,  5.994361725714004e-08, -5.658028405429330e-09,  4.467040172098952e-10, -3.031494719715604e-11,  1.804262220536443e-12,
 -9.563912832332001e-14,  4.570368095665913e-15, -1.985605225284996e-16,  1.979483748632392e-01, -1.768316120703879e-03,  1.734586075938588e-05, -1.794160733415070e-07,
  1.895845433420417e-09, -2.012141205576474e-11,  2.124687098865164e-13, -2.226357615800059e-15,  2.309517732842210e-17, -2.375243500437601e-19,  2.418106042533570e-21,
 -2.444451788324680e-23,  1.640038909665246e-01, -2.606990276361547e-03,  4.831329657668514e-05, -8.419360111309522e-07,  1.376625033728836e-08, -2.141595975315984e-10,
  3.201103807786630e-12, -4.627134149836764e-14,  6.497416847517780e-16, -8.893287445359919e-18,  1.189656599051501e-19, -1.558377525245478e-21,  1.129307245772466e-01,
 -3.380290421446856e-03,  9.600742875107602e-05, -2.352018568047651e-06,  5.219725790039113e-08, -1.075172173984260e-09,  2.085387824282695e-11, -3.845935771068524e-13,
  6.791736512272552e-15, -1.154568304883744e-16,  1.897153132478779e-18, -3.022353118454456e-20,  6.505659704168354e-02, -3.332836646609340e-03,  1.331115455802915e-04,
 -4.378619093639156e-06,  1.265830653772251e-07, -3.318471637946347e-09,  8.043080235177926e-11, -1.825963008486838e-12,  3.919200135476318e-14, -8.008728162360667e-16,
  1.566487183688929e-17, -2.944435376410599e-19,  3.169505194178756e-02, -2.534627070145542e-03,  1.374006882559298e-04, -5.895420047092188e-06,  2.160226497806042e-07,
 -7.027561082101063e-09,  2.078661439416819e-10, -5.680289594185449e-12,  1.450455801332729e-13, -3.490332822747333e-15,  7.967025715705718e-17, -1.733247723825573e-18,
  1.327188946018726e-02, -1.541879485175380e-03,  1.105228444765959e-04, -6.043765441158707e-06,  2.750176567111751e-07, -1.089753206683929e-08,  3.865998752610414e-10,
 -1.250905471082308e-11,  3.740752754833566e-13, -1.044106105975587e-14,  2.740831127505236e-16, -6.803892233781186e-18,  4.887379097714397e-03, -7.794402102064406e-04,
  7.205477669672942e-05, -4.920518999666502e-06,  2.732629479365958e-07, -1.298386580645250e-08,  5.444731390543352e-10, -2.057549404294277e-11,  7.111897823685559e-13,
 -2.273552902757363e-14,  6.780087130362126e-16, -1.897783820357685e-17,  1.632872805618815e-03, -3.408978674113111e-04,  3.961983747322677e-05, -3.312390704691365e-06,
  2.207661707523555e-07, -1.239044616124892e-08,  6.057316428565301e-10, -2.638792594829718e-11,  1.041237796427647e-12, -3.767242867992181e-14,  1.261654494677701e-15,
 -3.937533077015312e-17,  5.151783831021417e-04, -1.348823366724616e-04,  1.918338150890952e-05, -1.922282182132607e-06,  1.509974561107816e-07, -9.849936592303903e-09,
  5.530880819376198e-10, -2.739239927921083e-11,  1.217757192517380e-12, -4.924021116230742e-14,  1.829649832440851e-15, -6.292874117393054e-17,  1.608688672353254e-04,
 -5.067128460683299e-05,  8.560677898937479e-06, -1.003487567154530e-06,  9.096408654852336e-08, -6.767331703423731e-09,  4.289350247699906e-10, -2.376278659046795e-11,
  1.172155364304864e-12, -5.220888927582018e-14,  2.122921421840041e-15, -7.941142709326904e-17,  5.196820879111919e-05, -1.888363318117231e-05,  3.664366936901873e-06,
 -4.882039272372329e-07,  4.978136204801877e-08, -4.127059791007435e-09,  2.890554980441044e-10, -1.756180944959306e-11,  9.435833977632170e-13, -4.549715553254995e-14,
  1.991509414438570e-15, -7.977220092526573e-17,  1.753202441033853e-05, -7.039019720013282e-06,  1.509929604112601e-06, -2.209461904204320e-07,  2.456974158427950e-08,
 -2.206475440914008e-09,  1.663707173155384e-10, -1.082067097987189e-11,  6.191951011509656e-13, -3.164940513776874e-14,  1.462334274941460e-15, -6.158201546836464e-17,
  5.150483886559676e-06, -2.186411246525810e-06,  4.967592550674603e-07, -7.674477521396629e-08,  8.975165581078722e-09, -8.444149808517953e-10,  6.646465564365973e-11,
 -4.497696248557435e-12,  2.669752794921176e-13, -1.411609258766654e-14,  6.729785175584934e-16, -2.917259456877624e-17,  1.911396983583739e-01, -1.637674420159629e-03,
  1.536243187330432e-05, -1.520447006043756e-07,  1.539760651580944e-09, -1.569398913858283e-11,  1.593137032207006e-13, -1.607372422833192e-15,  1.605453082286366e-17,
 -1.592636825388240e-19,  1.561512634365841e-21, -1.526245402286413e-23,  1.542898442193582e-01, -2.257452842564892e-03,  3.940269108436946e-05, -6.521690261093385e-07,
  1.015737665536308e-08, -1.507968361097396e-10,  2.154306700419354e-12, -2.980266329500611e-14,  4.009801634585414e-16, -5.264216633788339e-18,  6.760483472925326e-20,
 -8.509147887919924e-22,  1.007850197837516e-01, -2.712404355565098e-03,  7.216357758051032e-05, -1.664960529634921e-06,  3.493883238267060e-08, -6.827183607079521e-10,
  1.259419293109319e-11, -2.213684924430889e-13,  3.732493511125243e-15, -6.067559586129113e-17,  9.547114013354810e-19, -1.458266125338380e-20,  5.356498201639818e-02,
 -2.448127086671133e-03,  9.082761257400060e-05, -2.794500433121715e-06,  7.600905544099124e-08, -1.882807767146331e-09,  4.326240012871732e-11, -9.336418502360125e-13,
  1.909357126325408e-14, -3.724989771462643e-16,  6.968392086281218e-18, -1.254752799463454e-19,  2.337770346309598e-02, -1.668799143040297e-03,  8.350575927612138e-05,
 -3.338347178434667e-06,  1.147639699775170e-07, -3.520180114197110e-09,  9.855907854293957e-11, -2.557599169360005e-12,  6.218734199323801e-14, -1.428341475371648e-15,
  3.118488779727632e-17, -6.501721702309754e-19,  8.500685758436948e-03, -8.867874916428933e-04,  5.856477923334497e-05, -2.981517678460679e-06,  1.272324948702018e-07,
 -4.753527493887709e-09,  1.596838013022290e-10, -4.909933447234218e-12,  1.399510103585605e-13, -3.733130849754120e-15,  9.387252065111208e-17, -2.237029109269384e-18,
  2.632263322545604e-03, -3.807954499726708e-04,  3.253050813067928e-05, -2.073472541225750e-06,  1.082462060487861e-07, -4.861169051440436e-09,  1.935188864713297e-10,
 -6.967883443702613e-12,  2.302009544687450e-13, -7.053323838549515e-15,  2.020940665305401e-16, -5.447145223308572e-18,  7.166169686305399e-04, -1.376061887754138e-04,
  1.489308166469988e-05, -1.169396277715645e-06,  7.366813463105138e-08, -3.927940370158573e-09,  1.831913159890479e-10, -7.640372620213169e-12,  2.895167772963898e-13,
 -1.008626744054306e-14,  3.260395612816008e-16, -9.843121790610426e-18,  1.793698109501985e-04, -4.393275893671980e-05,  5.887749950583776e-06, -5.595441699136715e-07,
  4.190432767051115e-08, -2.617438459217339e-09,  1.412467824124716e-10, -6.744032151860167e-12,  2.898314677018921e-13, -1.135666786240436e-14,  4.098101272487369e-16,
 -1.371547744431749e-17,  4.376120776653465e-05, -1.313960502935212e-05,  2.123174693456482e-06, -2.390620378797619e-07,  2.089520410274355e-08, -1.503837257696988e-09,
  9.247350790402422e-11, -4.982460911923706e-12,  2.395531592161623e-13, -1.042015950112189e-14,  4.145060884725145e-16, -1.519297930044951e-17,  1.111174059518504e-05,
 -3.920820467882210e-06,  7.394931960777943e-07, -9.598695428814199e-08,  9.557978241541536e-09, -7.754263878521415e-10,  5.324642138562083e-11, -3.176905776783703e-12,
  1.678719162957136e-13, -7.971005363103909e-15,  3.439948718280921e-16, -1.359983135824236e-17,  3.059095444130696e-06, -1.211264314402983e-06,  2.562190449089560e-07,
 -3.700771314200382e-08,  4.066488844894168e-09, -3.612150575966610e-10,  2.696409173840742e-11, -1.737640031121892e-12,  9.859342873638155e-14, -5.000190540904854e-15,
  2.293640510697505e-16, -9.594656720711059e-18,  7.894561435235856e-07, -3.337189208076821e-07,  7.548777026281547e-08, -1.161313706201919e-08,  1.352782133769389e-09,
 -1.268060635542542e-10,  9.946735120028927e-12, -6.709406236943205e-13,  3.970627916320923e-14, -2.093528708732598e-15,  9.954439814909277e-17, -4.304405684404193e-18,
  1.848238056201504e-01, -1.521676873015129e-03,  1.367598796016102e-05, -1.297261449725072e-07,  1.260749654089584e-09, -1.235738135339676e-11,  1.207166734261418e-13,
 -1.174508071978416e-15,  1.130055852839016e-17, -1.084013203162323e-19,  1.021740503605126e-21, -9.729677844163996e-24,  1.458445306870948e-01, -1.970984890511209e-03,
  3.246062782966080e-05, -5.112289853697383e-07,  7.597694099410878e-09, -1.078153376742464e-10,  1.474317939960158e-12, -1.954680732543974e-14,  2.523162945072840e-16,
 -3.181149057989271e-18,  3.926582493156998e-20, -4.754160819667210e-22,  9.097565367169348e-02, -2.206451070914306e-03,  5.513555756954545e-05, -1.200639414969067e-06,
  2.386706439816461e-08, -4.431236635839582e-10,  7.785741400845757e-12, -1.306006625903426e-13,  2.105028836411805e-15, -3.275896224630259e-17,  4.940947933268706e-19,
 -7.242771625992385e-21,  4.503916108008636e-02, -1.837502674133452e-03,  6.350895641868293e-05, -1.830978453915479e-06,  4.692884903959811e-08, -1.099875956981857e-09,
  2.398736763044680e-11, -4.926115028502417e-13,  9.607555577645682e-15, -1.790918216024933e-16,  3.206561265651153e-18, -5.534626068240576e-20,  1.782282135863963e-02,
 -1.134399948625971e-03,  5.249796368816250e-05, -1.957667868232481e-06,  6.320185711464035e-08, -1.829358532441219e-09,  4.851516049460833e-11, -1.196197578241163e-12,
  2.770774822131538e-14, -6.076451225392751e-16,  1.269281635205087e-17, -2.536526164050441e-19,  5.704767656947234e-03, -5.328473125069782e-04,  3.242924260831222e-05,
 -1.537141476785246e-06,  6.151979870512974e-08, -2.167142369327746e-09,  6.893128273058275e-11, -2.013838387269503e-12,  5.470198209511770e-14, -1.394108354382537e-15,
  3.356982289121296e-17, -7.676721162713356e-19,  1.505536044602764e-03, -1.966620746639447e-04,  1.549872450045250e-05, -9.208665275984555e-07,  4.514176033443518e-08,
 -1.914123419832943e-09,  7.226646592677675e-11, -2.476837871686710e-12,  7.813667901964120e-14, -2.292382692462532e-15,  6.304517706849830e-17, -1.634717598008945e-18,
  3.376153409204947e-04, -5.927053342607843e-05,  5.952561921878005e-06, -4.377513313798888e-07,  2.600456129442392e-08, -1.314466761281386e-09,  5.837027491742393e-11,
 -2.326445328108982e-12,  8.451087770192790e-14, -2.830283797962961e-15,  8.816512694668274e-17, -2.570779868702934e-18,  6.735685687663440e-05, -1.532888776280727e-05,
  1.926428752678826e-06, -1.729487087325416e-07,  1.230670592298623e-08, -7.338489345990252e-10,  3.795471728422218e-11, -1.742703306130848e-12,  7.223267774459984e-14,
 -2.736778910474115e-15,  9.571189795466616e-17, -3.111014773235925e-18,  1.277526788431219e-05, -3.632859403981970e-06,  5.585317739501362e-07, -6.014358597949424e-08,
  5.049522439977660e-09, -3.503865080681872e-10,  2.083970414834292e-11, -1.089044785874457e-12,  5.090762215649738e-14, -2.157568515539047e-15,  8.378384217278097e-17,
 -3.003137640211992e-18,  2.508503775692330e-06, -8.552890442884607e-07,  1.561120619126685e-07, -1.966798942859105e-08,  1.906216001234778e-09, -1.508968477888345e-10,
  1.013228271452732e-11, -5.922821303632170e-13,  3.071451389022759e-14, -1.433416428973480e-15,  6.088186278491410e-17, -2.371830276143256e-18,  5.503638633230063e-07,
 -2.143458190436439e-07,  4.460030399594374e-08, -6.344682783263347e-09,  6.875429725103783e-10, -6.030287176236833e-11,  4.449649624912313e-12, -2.837217219920524e-13,
  1.594235790691342e-14, -8.013121794961821e-16,  3.645480624283835e-17, -1.513401303534496e-18,  1.222507373202846e-07, -5.142332477154772e-08,  1.157247694738237e-08,
 -1.771678402335981e-09,  2.054430392531106e-10, -1.917660100663735e-11,  1.498339078215442e-12, -1.007001779102130e-13,  5.939223991289465e-15, -3.121559052889325e-16,
  1.479858977226789e-17, -6.381333654860908e-19,  1.789465153360877e-01, -1.418170713573115e-03,  1.223263134578425e-05, -1.113844066950695e-07,  1.040107091720346e-09,
 -9.817296377033508e-12,  9.235815816415957e-14, -8.682100414008666e-16,  8.040910364951005e-18, -7.498621040646192e-20,  6.732483700457834e-22, -6.388981589041512e-24,
  1.384438239016855e-01, -1.733924536864939e-03,  2.698985634108542e-05, -4.051647503792537e-07,  5.755194185826055e-09, -7.818297040791683e-11,  1.024774353844226e-12,
 -1.303849169551004e-14,  1.616707558255773e-16, -1.959853854095135e-18,  2.327592838434765e-20, -2.714041866229595e-22,  8.294912281919936e-02, -1.817118709146217e-03,
  4.275645263808129e-05, -8.806326664003277e-07,  1.661213265983992e-08, -2.935031950964293e-10,  4.918655655308637e-12, -7.884024994466829e-14,  1.216212617592143e-15,
 -1.813889414932453e-17,  2.625205159770197e-19, -3.696474200111531e-21,  3.858218619408812e-02, -1.406042917218888e-03,  4.540632922007053e-05, -1.228950579001208e-06,
  2.972820255271708e-08, -6.601329779412963e-10,  1.368148474443908e-11, -2.676549215460568e-13,  4.983154296637290e-15, -8.883103596538699e-17,  1.523421604931750e-18,
 -2.522245334408746e-20,  1.399746629252172e-02, -7.936130170625697e-04,  3.404359991555190e-05, -1.185685288795802e-06,  3.598859307167381e-08, -9.839087143436797e-10,
  2.473591572581429e-11, -5.798757495379433e-13,  1.280283476371341e-14, -2.682096862846288e-16,  5.362174078309661e-18, -1.027414421496860e-19,  3.995338838671688e-03,
 -3.332553932831830e-04,  1.870534585215518e-05, -8.258084838320285e-07,  3.100770028384284e-08, -1.030155727301504e-09,  3.102999520362049e-11, -8.614126880708356e-13,
  2.229773584236960e-14, -5.428898476599290e-16,  1.251652486330156e-17, -2.746052196463759e-19,  9.110296351012506e-04, -1.069918959688133e-04,  7.769844425707611e-06,
 -4.299485622274809e-07,  1.977614080581499e-08, -7.912035658077570e-10,  2.830949503377662e-11, -9.229172685126156e-13,  2.778106783269376e-14, -7.798198240728633e-16,
  2.056940648766994e-17, -5.126671295813040e-19,  1.703679165069638e-04, -2.718352660975329e-05,  2.525491409387418e-06, -1.735319242659227e-07,  9.701251760976269e-09,
 -4.640377304371643e-10,  1.958682256618063e-11, -7.448368601975733e-13,  2.589846588697343e-14, -8.325423060490706e-16,  2.495584410337528e-17, -7.018312519981921e-19,
  2.729858148533033e-05, -5.732131661063521e-06,  6.723440716761611e-07, -5.680638605797071e-08,  3.828443145804070e-09, -2.173162393934835e-10,  1.074433461460714e-11,
 -4.732732484386449e-13,  1.887706502529875e-14, -6.901240317979906e-16,  2.334445892079578e-17, -7.355427636160350e-19,  4.018851355128707e-06, -1.074698340012366e-06,
  1.563509984866553e-07, -1.602807760514809e-08,  1.287543484104789e-09, -8.584102913640057e-11,  4.922814880275670e-12, -2.488088742925007e-13,  1.127860720073891e-14,
 -4.646304450783933e-16,  1.757436302664995e-17, -6.147555984610251e-19,  6.016182301672524e-07, -1.970741119991853e-07,  3.464116682582330e-08, -4.218291009393086e-09,
  3.964759185575848e-10, -3.052494739557338e-11,  1.998518672269450e-12, -1.141597030087280e-13,  5.796325596980543e-15, -2.653087409894495e-16,  1.106881071675891e-17,
 -4.241702469229413e-19,  1.026046187448008e-07, -3.917834568574814e-08,  7.995059871493593e-09, -1.117225259299917e-09,  1.191203580885715e-10, -1.029498460229012e-11,
  7.495325839384255e-13, -4.721110352994452e-14,  2.623271029055829e-15, -1.305069225465730e-16,  5.881480993716745e-18, -2.420563594673102e-19,  1.915819656671467e-08,
 -8.011775381573313e-09,  1.792180156173120e-09, -2.728211508122544e-10,  3.147034735368683e-11, -2.923287599043252e-12,  2.273834215094237e-13, -1.521849689311169e-14,
  8.941162981887471e-16, -4.682478880797703e-17,  2.212434257110084e-18, -9.510569703052913e-20,  1.734614700336976e-01, -1.325387384047624e-03,  1.098975806066343e-05,
 -9.620079808217293e-08,  8.640983407161298e-10, -7.865664576697745e-12,  7.127885671821130e-14, -6.494037609783384e-16,  5.764635243100732e-18, -5.300796246201970e-20,
  4.405053859010861e-22, -4.338252115102626e-24,  1.319112344832045e-01, -1.535998913816730e-03,  2.263279032354321e-05, -3.243689978087665e-07,  4.410675646623907e-09,
 -5.744401936158376e-11,  7.226760315095024e-13, -8.835186758449946e-15,  1.053533535254028e-16, -1.229494239815710e-18,  1.406270637060723e-20, -1.580960586542845e-22,
  7.630366232251926e-02, -1.513226839738180e-03,  3.360881380789835e-05, -6.560636386921947e-07,  1.176414522360539e-08, -1.980860273903066e-10,  3.170621275577782e-12,
 -4.862268487575248e-14,  7.187319161603881e-16, -1.028365961374567e-17,  1.429677080874548e-19, -1.935395842925650e-21,  3.360134028276129e-02, -1.094594786454708e-03,
  3.312867571278022e-05, -8.433379508629880e-07,  1.928401897264497e-08, -4.062727831598838e-10,  8.011617226710728e-12, -1.494712842776040e-13,  2.659142747918323e-15,
 -4.537147953434129e-17,  7.459083821181580e-19, -1.185444740501442e-20,  1.128968177982936e-02, -5.696985741609038e-04,  2.271208444368312e-05, -7.398263609630696e-07,
  2.113804203936744e-08, -5.464244016266296e-10,  1.303432154457958e-11, -2.907434798204130e-13,  6.122662144119792e-15, -1.225941806090831e-16,  2.346927355651438e-18,
 -4.313158444672554e-20,  2.908971567869225e-03, -2.161558232225214e-04,  1.120419203284975e-05, -4.609985899577539e-07,  1.624909583459736e-08, -5.093526089125649e-10,
  1.453433335091414e-11, -3.834865502274025e-13,  9.460981910292767e-15, -2.200770353465188e-16,  4.858080786998460e-18, -1.022483467442008e-19,  5.809684287909190e-04,
 -6.109163768240360e-05,  4.086073053698749e-06, -2.104701649119554e-07,  9.079904709235531e-09, -3.426117884207183e-10,  1.161261075530585e-11, -3.599319459923695e-13,
  1.033255735663452e-14, -2.773457639393725e-16,  7.012142268698977e-18, -1.678843322172619e-19,  9.182161142485599e-05, -1.323919968137691e-05,  1.134922571573412e-06,
 -7.271993416905533e-08,  3.819509301122006e-09, -1.726256652665130e-10,  6.916252800289536e-12, -2.505964114324228e-13,  8.329290698419419e-15, -2.566812403219809e-16,
  7.394472410207363e-18, -2.003156809537413e-19,  1.193721606198257e-05, -2.296281942372397e-06,  2.502648542906700e-07, -1.983001414780005e-08,  1.261983590083689e-09,
 -6.801084425011154e-11,  3.206593780474069e-12, -1.352000447919703e-13,  5.178417298784950e-15, -1.823102563894503e-16,  5.953535558211773e-18, -1.815100466628026e-19,
  1.367012274641135e-06, -3.411442254831021e-07,  4.669907529831397e-08, -4.536463771936040e-09,  3.472908196434776e-10, -2.216875971669471e-11,  1.221989843719322e-12,
 -5.956262302641189e-14,  2.611395059953799e-15, -1.043127281770369e-16,  3.834437142459197e-18, -1.306214567524222e-19,  1.542651571321618e-07, -4.822917791360703e-08,
  8.119519471462055e-09, -9.512128166595794e-10,  8.635358194870661e-11, -6.443374089121641e-12,  4.100404525038964e-13, -2.282380378150284e-14,  1.131732648436339e-15,
 -5.068790629519862e-17,  2.072844633394205e-18, -7.798422847668022e-20,  1.993721380773122e-08, -7.434173935049684e-09,  1.482519545828839e-09, -2.028638827298311e-10,
  2.122342372980503e-11, -1.803062210383814e-12,  1.292490167277473e-13, -8.026841492416054e-15,  4.402983133270478e-16, -2.164801821499183e-17,  9.651087993765986e-19,
 -3.932779808742092e-20,  3.044708789288769e-09, -1.264426041818323e-09,  2.808378554277567e-10, -4.246792224796617e-11,  4.868785944502066e-12, -4.497202673890794e-13,
  3.479987212088222e-14, -2.318007280793704e-15,  1.355873232298682e-16, -7.071708924217805e-18,  3.328659455841314e-19, -1.425851146168307e-20,  1.683287621417832e-01,
 -1.241863304302547e-03,  9.913395631148793e-06, -8.354661209096747e-08,  7.225197887322183e-10, -6.353977147423053e-12,  5.541345248690005e-14, -4.924121219269037e-16,
  4.131844625709077e-18, -3.873028005233871e-20,  2.851590742931212e-22, -2.699899493950254e-24,  1.261062972452801e-01, -1.369388183205214e-03,  1.912871235008863e-05,
 -2.621246062832363e-07,  3.417007720941481e-09, -4.272478770181868e-11,  5.165369698015219e-13, -6.075765713131964e-15,  6.974149639719151e-17, -7.845594963514331e-19,
  8.649939411918663e-21, -9.379087406098957e-23,  7.074278685960557e-02, -1.272923888007381e-03,  2.674690296082349e-05, -4.958167431441446e-07,  8.465209089719371e-09,
 -1.360357786552417e-10,  2.082523384170232e-12, -3.059016120586565e-14,  4.338209611262761e-16, -5.960303306500692e-18,  7.968793792185260e-20, -1.038117068036551e-21,
  2.969559480704226e-02, -8.653564329288648e-04,  2.462207710362061e-05, -5.906176070334443e-07,  1.278631613156756e-08, -2.559269089526233e-10,  4.807990321334866e-12,
 -8.563866565519010e-14,  1.457333427167094e-15, -2.382112090227699e-17,  3.757394022241966e-19, -5.736436503168693e-21,  9.325200085049147e-03, -4.184964425990090e-04,
  1.555113066454538e-05, -4.744649215698512e-07,  1.277759457117238e-08, -3.126624497872545e-10,  7.083442922097105e-12, -1.504681259377163e-13,  3.024515311486937e-15,
 -5.791884534899712e-17,  1.062315755703115e-18, -1.873459056441753e-20,  2.193934011114479e-03, -1.448974613386229e-04,  6.948667905892141e-06, -2.666741261582559e-07,
  8.830542182141668e-09, -2.613386200636488e-10,  7.068004604487088e-12, -1.773158118464792e-13,  4.170610042560942e-15, -9.270783122439239e-17,  1.959665819395768e-18,
 -3.956997666400874e-20,  3.888894194080406e-04, -3.647291597065544e-05,  2.247061187598824e-06, -1.077227224094652e-07,  4.358363615455231e-09, -1.550801272485368e-10,
  4.978295932411550e-12, -1.466622257215535e-13,  4.013926058987250e-15, -1.029888538072008e-16,  2.494814582985113e-18, -5.735083563417262e-20,  5.267921368807574e-05,
 -6.825236068260658e-06,  5.388197183094097e-07, -3.214513541754743e-08,  1.584228149228456e-09, -6.757335461744433e-11,  2.566884073712285e-12, -8.851940267268245e-14,
  2.809431815935827e-15, -8.290621027391360e-17,  2.292854404349055e-18, -5.976680924179469e-20,  5.625343759369261e-06, -9.842040351972589e-07,  9.926485626102006e-08,
 -7.352966428387614e-09,  4.406941996773723e-10, -2.249474596099975e-11,  1.009195756349456e-12, -4.064628598077190e-14,  1.492103147878291e-15, -5.049325246888596e-17,
  1.589045966693098e-18, -4.679770557594433e-20,  5.040628334581109e-07, -1.164355123123839e-07,  1.491182422053978e-08, -1.366376610830522e-09,  9.929757674866958e-11,
 -6.047845242580439e-12,  3.194353566955604e-13, -1.497299932542582e-14,  6.332543500359755e-16, -2.446794734845091e-17,  8.720993893727024e-19, -2.886971807448937e-20,
  4.256102585180230e-08, -1.260370055200603e-08,  2.019980615727447e-09, -2.265181042434921e-10,  1.977612945215803e-11, -1.424673428680631e-12,  8.782511848477666e-14,
 -4.749159582276314e-15,  2.293474821715501e-16, -1.002602605718690e-17,  4.009679533311172e-19, -1.477878047147683e-20,  4.064910739548150e-09, -1.472956283579587e-09,
  2.858101221379940e-10, -3.815517602325266e-11,  3.904185030379541e-12, -3.251305605694311e-13,  2.289012721750260e-14, -1.398536064215486e-15,  7.558351850310767e-17,
 -3.666194473225471e-18,  1.614328398381864e-19, -6.504143629249395e-21,  4.919887693023668e-10, -2.026045804197829e-10,  4.461911746877332e-11, -6.694252584186064e-12,
  7.619534534852127e-13, -6.991789102387936e-14,  5.377813448373512e-15, -3.562398229043764e-16,  2.073191991718899e-17, -1.076240889157448e-18,  5.043970493779564e-20,
 -2.151974527074700e-21,  1.635138389906114e-01, -1.166379062070406e-03,  8.976226431210430e-06, -7.293510740267838e-08,  6.076947025474879e-10, -5.175778741624827e-12,
  4.328189258259234e-14, -3.804971745520574e-16,  2.919751412977916e-18, -2.907441830684406e-20,  2.158432393872316e-22, -1.742294511706168e-25,  1.209161141334683e-01,
 -1.228071874813547e-03,  1.628508550251311e-05, -2.136685010274706e-07,  2.673901680549666e-09, -3.214106787165778e-11,  3.738468779645362e-13, -4.236462911734549e-15,
  4.684691417647654e-17, -5.086444595144882e-19,  5.416694420072902e-21, -5.641678229512404e-23,  6.604435829568862e-02, -1.080635801759741e-03,  2.152804217273004e-05,
 -3.796888468898682e-07,  6.182260086696427e-09, -9.494310703784579e-11,  1.392011961590256e-12, -1.960515250675598e-14,  2.671141374640627e-16, -3.526585725102960e-18,
  4.538203612437590e-20, -5.703279524649791e-22,  2.658767923468650e-02, -6.936035538136011e-04,  1.861152969567247e-05, -4.214449252003975e-07,  8.651681127180058e-09,
 -1.647397159985278e-10,  2.952211109559433e-12, -5.025444806654985e-14,  8.189329476967515e-16, -1.283455522584994e-17,  1.943939747920274e-19, -2.854074581360085e-21,
  7.868320875294810e-03, -3.138078340867443e-04,  1.090427503446838e-05, -3.120703656867214e-07,  7.932409003236459e-09, -1.839493421999359e-10,  3.962162982130454e-12,
 -8.022196741065726e-14,  1.540424287785699e-15, -2.823158052982273e-17,  4.964054735614548e-19, -8.405703109320521e-21,  1.708189203375978e-03, -1.000513245571438e-04,
  4.449646405449045e-06, -1.594344560633015e-07,  4.964521918388812e-09, -1.388204244047587e-10,  3.560766194554901e-12, -8.497960994963647e-14,  1.906419901632883e-15,
 -4.050949809275303e-17,  8.201753018359481e-19, -1.589138484196960e-20,  2.721724201908638e-04, -2.268119330803559e-05,  1.288196768074350e-06, -5.748308753013238e-08,
  2.181561131095313e-09, -7.320758312571180e-11,  2.225813372020000e-12, -6.232317359306049e-14,  1.625961496858309e-15, -3.987080671341835e-17,  9.251510206651169e-19,
 -2.041373291874331e-20,  3.205233285181569e-05, -3.711247223011590e-06,  2.694793039471028e-07, -1.495191999721512e-08,  6.908036757115273e-10, -2.778436483909440e-11,
  9.998424276201046e-13, -3.278874757613581e-14,  9.928396361164672e-16, -2.803176775963723e-17,  7.435827707103931e-19, -1.863348270398527e-20,  2.850909585671856e-06,
 -4.503911549590470e-07,  4.188905598322682e-08, -2.892788583242699e-09,  1.629037217100162e-10, -7.859480040690413e-12,  3.348758894374891e-13, -1.286044378601067e-14,
  4.516903968480934e-16, -1.466806376819388e-17,  4.441354109647099e-19, -1.261496379817941e-20,  2.017857039879768e-07, -4.277501101579572e-08,  5.096524429652332e-09,
 -4.385421949057465e-10,  3.013930697429224e-11, -1.745677590271493e-12,  8.808406877580496e-14, -3.959547772862311e-15,  1.611296752511750e-16, -6.007758579565602e-18,
  2.071623848897069e-19, -6.650171020864104e-21,  1.271105681663017e-08, -3.535021245817661e-09,  5.358212098898875e-10, -5.720584867055720e-11,  4.780943585507972e-12,
 -3.311914332635426e-13,  1.970687982430462e-14, -1.031941562173230e-15,  4.839348383498488e-17, -2.059398169194126e-18,  8.034889722164064e-20, -2.894833461186500e-21,
  8.762703392234722e-10, -3.067252360983390e-10,  5.761344960840851e-11, -7.470875332072748e-12,  7.448701638719570e-13, -6.060647054607646e-14,  4.178649203481075e-15,
 -2.505337693394058e-16,  1.331034122219116e-17, -6.356482450699657e-19,  2.759451448468082e-20, -1.097453146739667e-21,  8.109632607302681e-11, -3.305464060086220e-11,
  7.205308841143789e-12, -1.070879655013248e-12,  1.208510326186715e-13, -1.100369401412448e-14,  8.404088651359059e-16, -5.531364477585704e-17,  3.200165461241297e-18,
 -1.652326745681501e-19,  7.705468573765509e-21, -3.272462437794461e-22,  1.589866227204185e-01, -1.097912360570041e-03,  8.156101176490576e-06, -6.398712135396374e-08,
  5.137544940102790e-10, -4.255209228423687e-12,  3.379079859784152e-14, -3.020913693303243e-16,  2.037392252840250e-18, -1.937551536648538e-20,  3.039033008534221e-22,
  4.597186330962121e-24,  1.162491153231736e-01, -1.107365853342720e-03,  1.395802076869821e-05, -1.755786350225797e-07,  2.112004035684442e-09, -2.443833198228889e-11,
  2.737328454254328e-13, -2.992919681355310e-15,  3.190639839542950e-17, -3.342266382480962e-19,  3.466216191200470e-21, -3.407513194317746e-23,  6.203960493696507e-02,
 -9.250883355914209e-04,  1.750801920173153e-05, -2.943190510149240e-07,  4.577552356571756e-09, -6.726216444259395e-11,  9.458888475990514e-13, -1.278224995761680e-14,
  1.675758506920382e-16, -2.128678235000889e-18,  2.631012529644683e-20, -3.220488787260594e-22,  2.408204063432558e-02, -5.628149849815375e-04,  1.428730398794897e-05,
 -3.059568293507957e-07,  5.965110433509677e-09, -1.081896615809292e-10,  1.851936780302695e-12, -3.015569586261891e-14,  4.711348864226032e-16, -7.086631012688540e-18,
  1.030770085026745e-19, -1.459160901337309e-21,  6.766556103258401e-03, -2.396448542963957e-04,  7.814402252548734e-06, -2.100913656157323e-07,  5.047647180354594e-09,
 -1.110599069271726e-10,  2.276907828646135e-12, -4.397943060348770e-14,  8.074545758555915e-16, -1.417342124081774e-17,  2.390388835131675e-19, -3.889889359760930e-21,
  1.368723048932822e-03, -7.094106406223418e-05,  2.934500669489080e-06, -9.827039130792604e-08,  2.880599935782810e-09, -7.617247917202295e-11,  1.854471458438990e-12,
 -4.212879986086954e-14,  9.019224276364146e-16, -1.832822052706875e-17,  3.555472444367667e-19, -6.612454828977180e-21,  1.984017045095634e-04, -1.463640939041414e-05,
  7.675153156617214e-07, -3.189118327199085e-08,  1.135820745376605e-09, -3.595772550359829e-11,  1.035697330419479e-12, -2.756591298163385e-14,  6.855903379058798e-16,
 -1.606653148402500e-17,  3.570642703967302e-19, -7.561319539625550e-21,  2.060130632049289e-05, -2.120291405513881e-06,  1.415391384706470e-07, -7.298524723621988e-09,
  3.159480549168512e-10, -1.197603387446781e-11,  4.080381681766599e-13, -1.271734959475883e-14,  3.671570393800051e-16, -9.911457902529492e-18,  2.520011955397737e-19,
 -6.066405855627737e-21,  1.549475543462909e-06, -2.194391134383743e-07,  1.876626493290910e-08, -1.205441808872752e-09,  6.366053649042118e-11, -2.898014350936930e-12,
  1.170801018166915e-13, -4.280646018951015e-15,  1.436317309322029e-16, -4.469360025745785e-18,  1.300188134568079e-19, -3.556713858408195e-21,  8.772980120552372e-08,
 -1.691413922319660e-08,  1.864916612759189e-09, -1.500651454599075e-10,  9.719069632110629e-12, -5.336682827334306e-13,  2.565241652263055e-14, -1.102976015406217e-15,
  4.308233535403437e-17, -1.546533051427916e-18,  5.148100704343844e-20, -1.599269027128945e-21,  4.131777247759658e-09, -1.068851746436895e-09,  1.521604958273341e-10,
 -1.537946379697787e-11,  1.224542599292929e-12, -8.123047542944610e-14,  4.648167138594376e-15, -2.349127598415018e-16,  1.066530475320114e-17, -4.405927324796880e-19,
  1.672724124063246e-20, -5.877021208781081e-22,  2.014308397829726e-10, -6.761377845131291e-11,  1.221952886355242e-11, -1.531296742582601e-12,  1.481192644888152e-13,
 -1.173076446542757e-14,  7.894770193229795e-16, -4.631402016672064e-17,  2.412588010644802e-18, -1.131742672201654e-19,  4.833738648109149e-21, -1.894094735206554e-22,
  1.369233580511065e-11, -5.510469440394322e-12,  1.186265998791338e-12, -1.743136019713305e-13,  1.947126643716427e-14, -1.756620717859168e-15,  1.330496558079832e-16,
 -8.691157297851632e-18,  4.993853614420051e-19, -2.562339808193390e-20,  1.188079811233991e-21, -5.019200746442850e-23,  1.547207969738424e-01, -1.035601387168748e-03,
  7.434902890801113e-06, -5.640657042975795e-08,  4.361106405741584e-10, -3.538914376722587e-12,  2.615968519388766e-14, -2.452041810134493e-16,  1.624082962054951e-18,
 -1.341106861557847e-21,  6.429614888033123e-22,  1.068483349000985e-23,  1.120304010592576e-01, -1.003589957270917e-03,  1.203878333645361e-05, -1.453663063591271e-07,
  1.682697691454383e-09, -1.876921954294936e-11,  2.025915092040662e-13, -2.140323324164892e-15,  2.205049891610974e-17, -2.210636511958840e-19,  2.290530199642944e-21,
 -2.049507962499617e-23,  5.859864404782456e-02, -7.980011899147282e-04,  1.437492992877968e-05, -2.307183463692598e-07,  3.433187822900864e-09, -4.831389310095898e-11,
  6.528411292130857e-13, -8.467704066811075e-15,  1.068961013522265e-16, -1.314329944550269e-18,  1.537544748793242e-20, -1.882615841380609e-22,  2.203821679233282e-02,
 -4.617300400184668e-04,  1.112417334725929e-05, -2.256696770975352e-07,  4.185287588044480e-09, -7.238197381245445e-11,  1.185313799881939e-12, -1.847607013751496e-14,
  2.770006443945111e-16, -4.008842033898429e-18,  5.581452219171556e-20, -7.669347716408201e-22,  5.918777906941535e-03, -1.859924673474875e-04,  5.713168591762895e-06,
 -1.445011124721592e-07,  3.286466722035586e-09, -6.868436889929657e-11,  1.341961112702720e-12, -2.474878407058823e-14,  4.348222742584074e-16, -7.318704705909843e-18,
  1.183741233389620e-19, -1.854333088056707e-21,  1.125413372442882e-03, -5.150036272003287e-05,  1.988383125960947e-06, -6.229949388358108e-08,  1.721260197675842e-09,
 -4.308307411443360e-11,  9.964390477845165e-13, -2.156224042544243e-14,  4.407936620426137e-16, -8.571612488799675e-18,  1.593644280474288e-19, -2.846404052450093e-21,
  1.500863331601745e-04, -9.765144596756722e-06,  4.738797185033115e-07, -1.834455413005619e-08,  6.135717076268521e-10, -1.833394203413024e-11,  5.004785598509343e-13,
 -1.266565957532413e-14,  3.003580000526145e-16, -6.727731281418135e-18,  1.432086547903444e-19, -2.910457219965331e-21,  1.393112523993923e-05, -1.267633177529042e-06,
  7.782591432955593e-08, -3.728252075090716e-09,  1.511931361690048e-10, -5.399702537364512e-12,  1.741351107181917e-13, -5.156195341604759e-15,  1.418753758288827e-16,
 -3.660222321950287e-18,  8.915305139405648e-20, -2.060578870371582e-21,  9.000450769054274e-07, -1.134376649359369e-07,  8.901834414856754e-09, -5.308941318929002e-10,
  2.625415285731298e-11, -1.126159318715392e-12,  4.308326328384483e-14, -1.497741923601927e-15,  4.795022704120651e-17, -1.427940816507338e-18,  3.986152866659274e-20,
 -1.048903580279515e-21,  4.139110079699936e-08, -7.190868491361116e-09,  7.301567668760663e-10, -5.473597500566495e-11,  3.330115765080150e-12, -1.728602141608613e-13,
  7.895048504794654e-15, -3.239212176382417e-16,  1.211697550484981e-17, -4.178747405092619e-19,  1.340094565049352e-20, -4.020803233271827e-22,  1.468330001379193e-09,
 -3.496188361558195e-10,  4.641057818683041e-11, -4.415592716359211e-12,  3.333374263791996e-13, -2.108522680876184e-14,  1.155934678332517e-15, -5.619150264077844e-17,
  2.462211492528431e-18, -9.846040233364776e-20,  3.627866187936389e-21, -1.239972791873606e-22,  4.983598430724646e-11, -1.589990839044754e-11,  2.745196746764272e-12,
 -3.305142798727529e-13,  3.086255487324975e-14, -2.369013893071290e-15,  1.550448973356668e-16, -8.870444486662210e-18,  4.517473741128252e-19, -2.076173816278020e-20,
  8.703842486709465e-22, -3.353271773953680e-23,  2.380505354707437e-12, -9.428885762946685e-13,  1.998784952912982e-13, -2.896666710151822e-14,  3.195911422718953e-15,
 -2.851573344741171e-16,  2.138560490020459e-17, -1.384567212392528e-18,  7.891706278175246e-20, -4.019687770482282e-21,  1.851411724226570e-22, -7.774049577333151e-24,
  1.506932236121296e-01, -9.787162260100539e-04,  6.797659360881680e-06, -4.996314157818425e-08,  3.710854396055709e-10, -2.987440891874323e-12,  2.005535977439936e-14,
 -1.880556347536607e-16,  2.161491061276513e-18,  3.468038063047649e-20,  1.161124137043671e-21,  1.084756650982598e-23,  1.081982245119563e-01, -9.138264880140262e-04,
  1.044434228574042e-05, -1.212010687469497e-07,  1.351464055632193e-09, -1.455319917110091e-11,  1.514613598637575e-13, -1.545955773658764e-15,  1.554874242250795e-17,
 -1.448439828168749e-19,  1.575960992273161e-21, -1.286550038631000e-23,  5.562033160639868e-02, -6.932106840693518e-04,  1.190656157018636e-05, -1.827404387980386e-07,
  2.606213477170527e-09, -3.514416607198052e-11,  4.572819290139556e-13, -5.700018459960380e-15,  6.888910598360649e-17, -8.397948685075629e-19,  8.901188495182118e-21,
 -1.122173430189846e-22,  2.035360627289117e-02, -3.825311837063605e-04,  8.774718829731998e-06, -1.688999824443598e-07,  2.984881673372786e-09, -4.926020337302805e-11,
  7.731118999508715e-13, -1.154864986088658e-14,  1.658720191728822e-16, -2.330019948362886e-18,  3.068728047781867e-20, -4.126843212985884e-22,  5.256374030490091e-03,
 -1.464233489775792e-04,  4.254410927631822e-06, -1.013673729278897e-07,  2.185920069357669e-09, -4.343490913043928e-11,  8.098819711979726e-13, -1.427488275641978e-14,
  2.400268658231547e-16, -3.884992390662333e-18,  6.013377889678945e-20, -9.087983914996919e-22,  9.470754320297648e-04, -3.817344922284976e-05,  1.381305282563180e-06,
 -4.053312544657054e-08,  1.057011199726827e-09, -2.506606317367374e-11,  5.513144420507486e-13, -1.137283999195184e-14,  2.221094104859813e-16, -4.137470117677053e-18,
  7.372137039014113e-20, -1.265455212375284e-21,  1.174172097068067e-04, -6.711909640905191e-06,  3.023735967426565e-07, -1.091177231446200e-08,  3.430717006067862e-10,
 -9.681710704304941e-12,  2.506262289754223e-13, -6.033387828787446e-15,  1.364633961135473e-16, -2.922591775752584e-18,  5.959067006565452e-20, -1.162442754980059e-21,
  9.871297420414878e-06, -7.898006839221217e-07,  4.465829567388560e-08, -1.987247559550492e-09,  7.550924612895067e-11, -2.540842870576986e-12,  7.755385381173785e-14,
 -2.181400788372859e-15,  5.719282115274471e-17, -1.409762588269128e-18,  3.288434799309432e-20, -7.294586949439900e-22,  5.565869961849534e-07, -6.197148456352729e-08,
  4.457633351118571e-09, -2.464872932055599e-10,  1.140249701695570e-11, -4.603979587355751e-13,  1.666254696680237e-14, -5.502288195767039e-16,  1.679096952699547e-17,
 -4.780594437008826e-19,  1.279272467866558e-20, -3.234687957426553e-22,  2.115133925272870e-08, -3.279642053078070e-09,  3.054226555371576e-10, -2.125954421577856e-11,
  1.211674719522655e-12, -5.931135289914856e-14,  2.568096628285109e-15, -1.003257394304848e-16,  3.586768905859956e-18, -1.186037601281377e-19,  3.657392959593449e-21,
 -1.057941626289871e-22,  5.723165344299705e-10, -1.239971338747816e-10,  1.523918683278609e-11, -1.357114782937652e-12,  9.667579561724654e-14, -5.807151851674357e-15,
  3.038795425003664e-16, -1.416083748751852e-17,  5.970197705247902e-19, -2.304383742400113e-20,  8.218486148537465e-22, -2.725856867815238e-23,  1.340055261650993e-11,
 -4.020462975713031e-12,  6.577716026282658e-13, -7.558445231819373e-14,  6.775684874655618e-15, -5.016957660041082e-16,  3.179821044797393e-17, -1.767725307606396e-18,
  8.772643745399067e-20, -3.938555130703283e-21,  1.616435577490900e-22, -6.108431330534342e-24,  4.290446101286653e-13, -1.665317668947998e-13,  3.463143180037042e-14,
 -4.934053803754156e-15,  5.362509593282642e-16, -4.721429329190569e-17,  3.499152793821381e-18, -2.241563535015177e-19,  1.265520834333198e-20, -6.390778506827358e-22,
  2.920626593581277e-23, -1.217708637665316e-24,  1.468834607730254e-01, -9.266366259360142e-04,  6.231834352700901e-06, -4.447924448799235e-08,  3.157699191640446e-10,
 -2.559989209410672e-12,  1.601421411632901e-14, -8.921572911553141e-17,  4.328244208303420e-18,  8.669177080737819e-20,  1.290802347867201e-21, -9.821534283736749e-24,
  1.047013080847909e-01, -8.357427096485556e-04,  9.110666766667592e-06, -1.017224137117541e-07,  1.093516200112559e-09, -1.138575256123791e-11,  1.144372299535578e-13,
 -1.120695089538899e-15,  1.134312488249118e-17, -9.204843936664891e-20,  1.081037255448886e-21, -1.050356402913481e-23,  5.302504051087872e-02, -6.060706399221383e-04,
  9.942470991941897e-06, -1.461179120279032e-07,  2.001327266016178e-09, -2.586120155106013e-11,  3.244377018606240e-13, -3.919226654765185e-15,  4.402680842182891e-17,
 -5.660513801788662e-19,  5.172499092690448e-21, -5.879381181025997e-23,  1.895209575130610e-02, -3.196975753364617e-04,  7.004945134216715e-06, -1.281154383591823e-07,
  2.161831280875610e-09, -3.405590998860842e-11,  5.129537330307342e-13, -7.377401999749568e-15,  1.003153260232241e-16, -1.400894812354890e-18,  1.716907726142022e-20,
 -2.190967643513434e-22,  4.731807528528139e-03, -1.167189014985884e-04,  3.222267642657161e-06, -7.240793902342414e-08,  1.483210116832903e-09, -2.804054683341277e-11,
  4.995980248776146e-13, -8.435818640066795e-15,  1.353079833585533e-16, -2.121778970314795e-18,  3.130956483555841e-20, -4.541388397738696e-22,  8.137629535857839e-04,
 -2.881500402386712e-05,  9.819014763449526e-07, -2.700800440057505e-08,  6.658448311634354e-10, -1.497232774626373e-11,  3.134919458591918e-13, -6.172852656461768e-15,
  1.151168008569428e-16, -2.059003202391094e-18,  3.514334050819426e-20, -5.794799921258924e-22,  9.469295673338476e-05, -4.736216316350291e-06,  1.988979343773385e-07,
 -6.694543451330976e-09,  1.980945484140290e-10, -5.283393891728105e-12,  1.297893666537892e-13, -2.974181715929295e-15,  6.416946760545694e-17, -1.314984261091037e-18,
  2.568474670541420e-20, -4.809483396200406e-22,  7.300218070169245e-06, -5.106785656995687e-07,  2.666190645205956e-08, -1.102072800264369e-09,  3.925638611342485e-11,
 -1.244853870775908e-12,  3.596893558485647e-14, -9.611551306856242e-16,  2.400991132540028e-17, -5.654407089611361e-19,  1.262873916661544e-20, -2.687964692981644e-22,
  3.648967521848065e-07, -3.562115264233410e-08,  2.348878978399739e-09, -1.203026238665070e-10,  5.202883797378578e-12, -1.976141333149208e-13,  6.761361300180674e-15,
 -2.119365361774236e-16,  6.160115387565965e-18, -1.675509331202304e-19,  4.294479548109104e-21, -1.042556762163716e-22,  1.167280913574737e-08, -1.599483314969972e-09,
  1.361899072100354e-10, -8.777670765719641e-12,  4.676020351635915e-13, -2.153998557658429e-14,  8.824576817379831e-16, -3.276506337486378e-17,  1.117544254046955e-18,
 -3.537140749536401e-20,  1.047072525332501e-21, -2.915165233811865e-23,  2.450816600122886e-10, -4.772165605766650e-11,  5.393032310203425e-12, -4.471346872741513e-13,
  2.992257709345417e-14, -1.700143885475852e-15,  8.461891652488630e-17, -3.767864874333841e-18,  1.523826089405367e-19, -5.661284698829232e-21,  1.949214709488596e-22,
 -6.258209707993786e-24,  3.954618153324654e-12, -1.101636752788266e-12,  1.692372740623509e-13, -1.842610807867146e-14,  1.576154887278072e-15, -1.119902131498723e-16,
  6.842983465623440e-18, -3.681652148009594e-19,  1.774084719689215e-20, -7.755845257928570e-22,  3.107215959945944e-23, -1.148743968605874e-24,  8.086042242392318e-14,
 -3.057639175590122e-14,  6.206819010513164e-15, -8.658117452923786e-16,  9.237934239325792e-17, -8.002950411507476e-18,  5.847001852198397e-19, -3.698360701994906e-20,
  2.064451191848654e-21, -1.031977043437487e-22,  4.673122164587626e-24, -1.932296650363546e-25,  1.432733594890585e-01, -8.788348238776540e-04,  5.726773826588644e-06,
 -3.981616910142074e-08,  2.683055191963243e-10, -2.186768180427314e-12,  1.598688011235341e-14,  1.075808103618280e-16,  8.155405279181672e-18,  1.160842165019520e-19,
 -2.244899844796241e-22, -6.507751603736841e-23,  1.014967752643013e-01, -7.674590018978304e-04,  7.987916688404932e-06, -8.590861631342406e-08,  8.909243483764166e-10,
 -8.977582091682739e-12,  8.769549083553769e-14, -8.033146119731317e-16,  8.692689211584261e-18, -5.852360703849005e-20,  5.745265540110662e-22, -1.331865879972312e-23,
  5.074945245902028e-02, -5.330369055406805e-04,  8.365389945346726e-06, -1.178460760909365e-07,  1.553827192711049e-09, -1.924986616211698e-11,  2.316196882064388e-13,
 -2.800644979680796e-15,  2.688659510432157e-17, -3.957981630250737e-19,  3.721636920064716e-21, -6.355158184337116e-24,  1.777641477232611e-02, -2.692672805554158e-04,
  5.654608087070496e-06, -9.837045220214727e-08,  1.588782864001333e-09, -2.390336943550538e-11,  3.445938511579432e-13, -4.858121110133820e-15,  6.028478187600934e-17,
 -8.677721725254896e-19,  1.036815491734227e-20, -9.754812528144997e-23,  4.311503445596729e-03, -9.405166317511424e-05,  2.479164029754325e-06, -5.258392129781845e-08,
  1.025428031357774e-09, -1.845816725837021e-11,  3.140515206251302e-13, -5.120541836560964e-15,  7.738853277959659e-17, -1.190401151112048e-18,  1.692036768686313e-20,
 -2.243093204256982e-22,  7.123894554428268e-04, -2.209543278295296e-05,  7.130247019545868e-07, -1.839333337568474e-08,  4.295287056536689e-10, -9.166232642923721e-12,
  1.827608008031372e-13, -3.446796115765382e-15,  6.117295585968260e-17, -1.054803890508712e-18,  1.728761760295196e-20, -2.714138556038928e-22,  7.848838533940231e-05,
 -3.419545763452741e-06,  1.345732689708446e-07, -4.225765860410546e-09,  1.178671252385603e-10, -2.973294468687928e-12,  6.934906462881704e-14, -1.514974806897292e-15,
  3.116062753558782e-17, -6.117837114987170e-19,  1.145481279073769e-20, -2.056285749497253e-22,  5.613251692533260e-06, -3.412323480339462e-07,  1.651426941415182e-08,
 -6.340426476021193e-10,  2.119190460866467e-11, -6.335487958151505e-13,  1.733362946201866e-14, -4.402473765680737e-16,  1.047680722951096e-17, -2.357875850175977e-19,
  5.042371608572805e-21, -1.029481521070776e-22,  2.525147213946060e-07, -2.144115959628640e-08,  1.298175605145817e-09, -6.153609333939452e-11,  2.487821746461497e-12,
 -8.885500677111932e-14,  2.872983881239357e-15, -8.544896726770523e-17,  2.364289178771100e-18, -6.140186100323276e-20,  1.506489089342936e-21, -3.508983492053574e-23,
  6.931032714412476e-09, -8.306672744132742e-10,  6.455352932806662e-11, -3.843585881721651e-12,  1.910550758532807e-13, -8.268595193087521e-15,  3.200193473536122e-16,
 -1.127595577361105e-17,  3.663681160462494e-19, -1.108300088850427e-20,  3.144829360592068e-22, -8.414882039040751e-24,  1.153101150673419e-10, -1.991308148349745e-11,
  2.056806017350109e-12, -1.579826823601811e-13,  9.891499329762593e-15, -5.296904193997463e-16,  2.499325628799430e-17, -1.060166858115135e-18,  4.101314979887806e-20,
 -1.462706314697502e-21,  4.849680433212276e-23, -1.503636713063114e-24,  1.292592683879131e-12, -3.293773291732349e-13,  4.704600911751599e-14, -4.815791595524024e-15,
  3.905549620927157e-16, -2.648263656223642e-17,  1.552510144779537e-18, -8.049325446945368e-20,  3.751845098753744e-21, -1.591660777080654e-22,  6.205224675775722e-24,
 -2.237991871004459e-25,  1.611350900337055e-14, -5.888411848370740e-15,  1.159177983055599e-15, -1.574823428979821e-16,  1.642437446179509e-17, -1.394977393409332e-18,
  1.001666611089354e-19, -6.239680635049283e-21,  3.436123716254957e-22, -1.696990428293479e-23,  7.601576398328450e-25, -3.112675463285700e-26,  1.398467213725275e-01,
 -8.348620113212763e-04,  5.273365568714038e-06, -3.585071450232248e-08,  2.288190503149969e-10, -1.733809796458936e-12,  2.322964050603542e-14,  4.267404495214939e-16,
  1.127712838405732e-17,  2.710314786445048e-20, -4.798643735776506e-21, -1.426813813998131e-22,  9.854854188498903e-02, -7.074498892730287e-04,  7.036967665471338e-06,
 -7.298299060847448e-08,  7.307523756937779e-10, -7.113189589968832e-12,  6.880477834972009e-14, -5.556678979871760e-16,  6.843047651025358e-18, -4.896176518870565e-20,
 -1.411304633317722e-22, -1.933281931774087e-23,  4.874275518536396e-02, -4.713751799690885e-04,  7.088608905320765e-06, -9.578785903907204e-08,  1.218517068929263e-09,
 -1.454692263168761e-11,  1.633112180456984e-13, -2.139096647479810e-15,  1.539791761682949e-17, -2.363271065817505e-19,  4.643953170001333e-21,  4.692907662949059e-23,
  1.678290883048580e-02, -2.283536772361659e-04,  4.612247475015766e-06, -7.636778554369443e-08,  1.183413736353401e-09, -1.707363608610951e-11,  2.314080694402473e-13,
 -3.355505975280324e-15,  3.573052726105474e-17, -5.113309814263504e-19,  8.079764287131982e-21, -1.179740287869823e-23,  3.971326892443713e-03, -7.648908170543607e-05,
  1.935620131794591e-06, -3.876503406174688e-08,  7.213174796989777e-10, -1.239695195343880e-11,  1.997364525571007e-13, -3.215844810277339e-15,  4.472899653778132e-17,
 -6.692071609365160e-19,  1.003193684004492e-20, -1.011011629553310e-22,  6.341665654496091e-04, -1.716981586118849e-05,  5.281807533220717e-07, -1.277839173531374e-08,
  2.832593099404163e-10, -5.747729365380644e-12,  1.087794184486498e-13, -1.983558488992918e-15,  3.324075888803548e-17, -5.520258058207193e-19,  8.886565051408268e-21,
 -1.279668217713591e-22,  6.668218050406946e-05, -2.517732586939143e-06,  9.347483914637022e-08, -2.737815882387239e-09,  7.211527025844498e-11, -1.722848795851467e-12,
  3.811982333259092e-14, -7.968684671831240e-16,  1.559230946393501e-17, -2.934026599911096e-19,  5.293083104585757e-21, -9.046155617901570e-23,  4.471393972643420e-06,
 -2.346225365562249e-07,  1.058524997789452e-08, -3.773348373919869e-10,  1.184946975133418e-11, -3.342238478231263e-13,  8.657724196880800e-15, -2.092826762894647e-16,
  4.742478141734744e-18, -1.020219658716265e-19,  2.091028938670430e-21, -4.090389998988202e-23,  1.836477938256145e-07, -1.344701321264912e-08,  7.501622804371194e-10,
 -3.288363461599311e-11,  1.243260549355649e-12, -4.175587386695679e-14,  1.275499675510522e-15, -3.599783695329301e-17,  9.477476665957302e-19, -2.349392867634686e-20,
  5.516101679311504e-22, -1.231983920302796e-23,  4.408766513604653e-09, -4.570715246023323e-10,  3.242152258266133e-11, -1.779879379779282e-12,  8.246290960411479e-14,
 -3.349026087685020e-15,  1.223013120895261e-16, -4.084824903579758e-18,  1.262751361472014e-19, -3.646578614380466e-21,  9.906324223957767e-23, -2.544393951713328e-24,
  5.951323060316817e-11, -8.985794722522278e-12,  8.442838001203889e-13, -5.981580303465295e-14,  3.491708101184440e-15, -1.756685013578982e-16,  7.835089535360202e-18,
 -3.157424027324426e-19,  1.165372437463317e-20, -3.979984466899488e-22,  1.267719294495719e-23, -3.787114157826239e-25,  4.716046651647086e-13, -1.080430096112302e-13,
  1.420280738817851e-14, -1.355994911899644e-15,  1.035766524689263e-16, -6.664671489168426e-18,  3.729898450489453e-19, -1.855328280434951e-20,  8.331483382642280e-22,
 -3.417456434874718e-23,  1.292226481309220e-24, -4.532908376348511e-26,  3.443468843393638e-15, -1.202589895831932e-15,  2.276201969055792e-16, -2.991427676944661e-17,
  3.032926588755564e-18, -2.514093014212699e-19,  1.767536792241273e-20, -1.080888422751630e-21,  5.856129481360008e-23, -2.850647709762725e-24,  1.260573286261608e-25,
 -5.102579724611589e-27,  1.365890071900372e-01, -7.943360977330183e-04,  4.864090291664896e-06, -3.243193560021208e-08,  2.008945269529660e-10, -9.928821357241724e-13,
  4.003685599775746e-14,  7.528894578778151e-16,  7.140166879991799e-18, -3.047648114538949e-19, -1.193309404642783e-20, -1.582572246426615e-22,  9.582605416166531e-02,
 -6.544688205159601e-04,  6.226906503204259e-06, -6.234420785519690e-08,  6.038621683054984e-10, -5.625545242489045e-12,  5.602897109361007e-14, -3.677250231812036e-16,
  4.762517330767999e-18, -7.271539019817981e-20, -1.052871992399312e-21, -1.983613967190367e-23,  4.696383271327206e-02, -4.189535144100364e-04,  6.047167669717134e-06,
 -7.842558541163052e-08,  9.621812637783736e-10, -1.129697727179786e-11,  1.093182066708230e-13, -1.741918124425518e-15,  1.083023488240265e-17,  7.521668799577775e-22,
  7.341500666596463e-21,  6.332898218029342e-23,  1.593790863138974e-02, -1.948236038874021e-04,  3.799068515982547e-06, -5.989300734203425e-08,  8.904723178442705e-10,
 -1.253287487032668e-11,  1.511379204400925e-13, -2.444251712295618e-15,  2.316868632799267e-17, -1.825309630681234e-19,  8.633943146001902e-21,  2.453190393445612e-23,
  3.693648446823018e-03, -6.268593621820867e-05,  1.532270683741636e-06, -2.897497474609237e-08,  5.147725532794741e-10, -8.541741657892965e-12,  1.266183262878825e-13,
 -2.099847253847972e-15,  2.699474405067445e-17, -3.350599853116364e-19,  7.111366118872060e-21, -4.138525886621220e-23,  5.730653455714132e-04, -1.348858679183967e-05,
  3.986520702140453e-07, -9.040965130991611e-09,  1.904644916295773e-10, -3.699454479323163e-12,  6.557689426777153e-14, -1.178729040176474e-15,  1.863259474860899e-17,
 -2.854583080931886e-19,  4.928273298372926e-21, -6.069861072596375e-23,  5.792337858404972e-05, -1.884063399230919e-06,  6.654951970555805e-08, -1.816602961007419e-09,
  4.525448989777746e-11, -1.027809336810661e-12,  2.145680890139859e-14, -4.327154396204963e-16,  8.048250095921764e-18, -1.436367048230473e-19,  2.552686786763062e-21,
 -4.084429070097464e-23,  3.677552457490133e-06, -1.652729990205609e-07,  7.005977769074021e-09, -2.316517231396228e-10,  6.844272275374099e-12, -1.825016876341333e-13,
  4.467793946279948e-15, -1.031068147101426e-16,  2.224285220445088e-18, -4.564256014670363e-20,  9.008654502740116e-22, -1.682705199422556e-23,  1.397687141857165e-07,
 -8.740107153091797e-09,  4.519333848599145e-10, -1.829889433482293e-11,  6.474955247222282e-13, -2.046402880310134e-14,  5.901602460824126e-16, -1.581710711311175e-17,
  3.961355066448630e-19, -9.368033367658724e-21,  2.105939258027193e-22, -4.506023482785149e-24,  2.990012274542220e-09, -2.649224059398973e-10,  1.719625442907498e-11,
 -8.688310168360965e-13,  3.749996768975652e-14, -1.428234941246831e-15,  4.916361719501928e-17, -1.555440683635098e-18,  4.570528448724103e-20, -1.258737088134438e-21,
  3.270853800291442e-23, -8.055321535680633e-25,  3.358986769999674e-11, -4.365918707816644e-12,  3.721532373483006e-13, -2.422684227204678e-14,  1.314815668140584e-15,
 -6.198342586018209e-17,  2.606656098976801e-18, -9.956140735741893e-20,  3.497937026980527e-21, -1.141436559939297e-22,  3.485386947370833e-24, -1.001118469959811e-25,
  1.931638935357866e-13, -3.900419457166199e-14,  4.673001534840511e-15, -4.128562565239401e-16,  2.951161669715044e-17, -1.791924548756862e-18,  9.526400672635076e-20,
 -4.525982618886457e-21,  1.950148386304176e-22, -7.705669278271642e-24,  2.816386005615722e-25, -9.578605490270145e-27,  8.031730577884417e-16, -2.639372348906092e-16,
  4.750087947299526e-17, -5.987289980922192e-18,  5.860941408718409e-19, -4.715159823241402e-20,  3.230661264376371e-21, -1.931842789357447e-22,  1.026296957354493e-23,
 -4.910003282737543e-25,  2.138105771387306e-26, -8.537038150895388e-28,  1.334870990426857e-01, -7.569265980719020e-04,  4.493727101648903e-06, -2.931680883310630e-08,
  1.924307239404583e-10,  2.330612776750435e-13,  6.194196942756970e-14,  7.023493578051053e-16, -1.372760879949229e-17, -8.751164931074310e-19, -1.474728360591990e-20,
  9.846860106309305e-23,  9.330329241144610e-02, -6.074899323479881e-04,  5.533261690248977e-06, -5.351266367321807e-08,  5.040417711182182e-10, -4.389931794384190e-12,
  4.740605940361519e-14, -2.667952197183807e-16,  1.217319363431095e-18, -1.272320161576069e-19, -1.473285132520301e-21,  8.140626550467280e-24,  4.537916090205883e-02,
 -3.740952125134537e-04,  5.191392229221860e-06, -6.471150792256154e-08,  7.587376866951639e-10, -9.217293103077284e-12,  6.583148790916988e-14, -1.333806106528384e-15,
  1.664543264790745e-17,  3.289445193394712e-19,  8.196736019575037e-21, -5.845807029378904e-23,  1.521516574816495e-02, -1.670815907716733e-04,  3.158144406288215e-06,
 -4.747544240289584e-08,  6.709603922913242e-10, -9.646700709392094e-12,  9.257545377846251e-14, -1.739807556682004e-15,  2.297256994509622e-17,  1.709549281907051e-19,
  8.401040214083254e-21, -6.505991871110234e-23,  3.465400728053422e-03, -5.169055469175106e-05,  1.228835770728871e-06, -2.195854075684083e-08,  3.700277300712886e-10,
 -6.120102101242967e-12,  7.847524677179265e-14, -1.377382853101777e-15,  1.965140915787995e-17, -8.403266343921561e-20,  5.366821918845984e-21, -5.200191091277810e-23,
  5.248686801526144e-04, -1.068664899061983e-05,  3.062524533664878e-07, -6.510052243062433e-09,  1.298529840403702e-10, -2.462538919986312e-12,  3.961917146136252e-14,
 -7.134524793424581e-16,  1.135424575470272e-17, -1.320165801888457e-19,  2.917033529961938e-21, -3.682122670536158e-23,  5.132937982640556e-05, -1.427953969085153e-06,
  4.849687845565310e-08, -1.232651701366836e-09,  2.899898181561323e-11, -6.332870323886292e-13,  1.229159443015884e-14, -2.412298591124913e-16,  4.354085804015760e-18,
 -6.987080801524597e-20,  1.287284350132868e-21, -1.981428009020201e-23,  3.113255408544231e-06, -1.187267152672642e-07,  4.779256410155194e-09, -1.463717654651215e-10,
  4.068589976605956e-12, -1.031767491732271e-13,  2.372571733766929e-15, -5.249131575811187e-17,  1.084257482946568e-18, -2.094090394436275e-20,  4.033462860730534e-22,
 -7.212073374464326e-24,  1.108616289513867e-07, -5.853628925071924e-09,  2.831357180436286e-10, -1.057193713159799e-11,  3.502453045784643e-13, -1.044413665836397e-14,
  2.837267420363303e-16, -7.232608950198474e-18,  1.725163568339466e-19, -3.880816832567962e-21,  8.375440913947147e-23, -1.716167417154499e-24,  2.151416873985145e-09,
 -1.606737359483747e-10,  9.600994847862394e-12, -4.455336335555128e-13,  1.791135549078015e-14, -6.399714822854626e-16,  2.074021924542677e-17, -6.214809319351059e-19,
  1.735014334303493e-20, -4.551839794714515e-22,  1.131042813362480e-23, -2.668387554875801e-25,  2.064309086145471e-11, -2.270008104104560e-12,  1.756230811819615e-13,
 -1.046895138685890e-14,  5.271184307479665e-16, -2.324022646345688e-17,  9.195529741078203e-19, -3.322659245901845e-20,  1.109073933734171e-21, -3.451294459950244e-23,
  1.008418549389887e-24, -2.779778203629270e-26,  8.908559175217415e-14, -1.549860675455177e-14,  1.678495774493274e-15, -1.362090918440516e-16,  9.057192389302078e-18,
 -5.162335756545735e-19,  2.594684219330916e-20, -1.172344663691857e-21,  4.827645985580637e-23, -1.830798002259769e-24,  6.445886474186505e-26, -2.118754878713377e-27,
  2.088618719952260e-16, -6.320392883763502e-17,  1.066485931317921e-17, -1.275662382565273e-18,  1.195614141109461e-19, -9.271956506352304e-21,  6.156301033251158e-22,
 -3.582640416445141e-23,  1.858746550227107e-24, -8.709624379377722e-26,  3.723660775235411e-27, -1.462776458823568e-28,  1.305291392625653e-01, -7.223307397423479e-04,
  4.160829439147943e-06, -2.611447172996789e-08,  2.131572560450686e-10,  1.873229830638798e-12,  7.000798717606829e-14, -3.362271002866219e-16, -5.322026763911797e-17,
 -1.197394146998754e-18,  3.933681576800624e-21,  8.179868179476472e-22,  9.095798315196786e-02, -5.656616308808438e-04,  4.936793749322580e-06, -4.609108554219864e-08,
  4.270189204742237e-10, -3.342029179926139e-12,  3.972096951520669e-14, -3.106723078579707e-16, -4.160916150806454e-18, -1.587698075546917e-19,  4.997451498263500e-22,
  9.025837989763139e-23,  4.396119776845075e-02, -3.354773610622078e-04,  4.481855870423614e-06, -5.397208174106748e-08,  5.875313957376753e-10, -8.012314677040042e-12,
  3.812054260833232e-14, -5.583652748951483e-16,  3.299845802261442e-17,  5.173802829355582e-19, -1.353205298851198e-21, -4.082948967079596e-22,  1.459400077405511e-02,
 -1.439267100574426e-04,  2.646834055141009e-06, -3.817780428695766e-08,  4.967598374555729e-10, -7.918601357841778e-12,  5.548832911599441e-14, -8.509876266058260e-16,
  3.385479576061479e-17,  3.774612662910199e-19, -2.240205225063885e-22, -3.566465712805949e-22,  3.276761622676980e-03, -4.282192864341446e-05,  9.971153541742367e-07,
 -1.692683821307902e-08,  2.636961992194290e-10, -4.629884866675824e-12,  4.852085774025010e-14, -7.612788153906846e-16,  1.973400897875251e-17,  6.105671179875965e-20,
  1.138208978340918e-21, -1.535950249066637e-22,  4.865726731595514e-04, -8.517230158706177e-06,  2.391229004976398e-07, -4.780849684282355e-09,  8.868893063656736e-11,
 -1.714006242529491e-12,  2.415698963898625e-14, -4.068073947422851e-16,  8.308874369706146e-18, -4.845669819925491e-20,  1.190130603930799e-21, -4.618928488145087e-23,
  4.630981751150710e-05, -1.092127306599769e-06,  3.611725905083400e-08, -8.560055148501717e-10,  1.880878921637114e-11, -4.056052395025476e-13,  7.171537193294067e-15,
 -1.337305448922155e-16,  2.582150227347341e-18, -3.304223449611596e-20,  6.037752838496540e-22, -1.287927871571117e-23,  2.705070571493483e-06, -8.655080290772027e-08,
  3.354091877239635e-09, -9.512589024536159e-11,  2.473089481609972e-12, -6.055036188832999e-14,  1.294280147373398e-15, -2.727500405439440e-17,  5.574876742907835e-19,
 -9.765116508246859e-21,  1.828244583974591e-22, -3.403072130224502e-24,  9.129004104082459e-08, -4.014502175803891e-09,  1.840370368883200e-10, -6.328177794316185e-12,
  1.958033854312757e-13, -5.550201585258893e-15,  1.413738752530952e-16, -3.424305010732386e-18,  7.849980987160636e-20, -1.663210070556055e-21,  3.450971948428651e-23,
 -6.866177779362286e-25,  1.634263037352428e-09, -1.012019287203564e-10,  5.625489218437088e-12, -2.392571211326579e-13,  8.949823462255143e-15, -3.007926495204265e-16,
  9.158954269064690e-18, -2.598723084692306e-19,  6.902730844098530e-21, -1.720809968940762e-22,  4.089675807200635e-24, -9.251236657127375e-26,  1.374142354987005e-11,
 -1.253012824937436e-12,  8.842673300126422e-14, -4.810935054810831e-15,  2.243545257756928e-16, -9.244012451026492e-18,  3.434511874764978e-19, -1.172355490232487e-20,
  3.712857912187230e-22, -1.099802920095921e-23,  3.070517070518241e-25, -8.110525405010177e-27,  4.626051340251640e-14, -6.754886997658948e-15,  6.580209329790739e-16,
 -4.871204789147677e-17,  2.997385082015298e-18, -1.596303642292955e-19,  7.552389786236735e-21, -3.232309162938043e-22,  1.267342563923037e-23, -4.596481806823097e-25,
  1.553786950499233e-26, -4.920588275407456e-28,  6.203249261132233e-17, -1.677973804459339e-17,  2.610451104003385e-18, -2.925841084231184e-19,  2.599724062425978e-20,
 -1.927804401459496e-21,  1.232138299122789e-22, -6.939004432456708e-24,  3.498996232238620e-25, -1.599195354717221e-26,  6.688779795089293e-28, -2.577157698669904e-29,
  1.277044911901449e-01, -6.902362113322845e-04,  3.869432777449048e-06, -2.232009542674356e-08,  2.655079698813528e-10,  3.211274203884953e-12,  3.096634715377788e-14,
 -2.613872633440334e-15, -8.269030247868873e-17, -9.636968317651072e-20,  5.509609014648627e-20,  1.323575447228133e-21,  8.877098008819793e-02, -5.282682632233819e-04,
  4.422647706863607e-06, -3.974500416943613e-08,  3.689078126007246e-10, -2.513075772849813e-12,  2.838000985735111e-14, -5.218898014676612e-16, -8.296873254087120e-18,
 -3.141275558799997e-20,  6.409593456125959e-21,  1.598840205327291e-22,  4.268710608116937e-02, -3.020652381819876e-04,  3.885457899606077e-06, -4.580680049552032e-08,
  4.358528195754302e-10, -7.149874287410667e-12,  3.975715696079729e-14,  7.430871493309034e-16,  4.529264595264026e-17, -3.853434156276832e-21, -2.659646726138780e-20,
 -6.476060729315790e-22,  1.405791720688495e-02, -1.244610504606793e-04,  2.231380956885373e-06, -3.143001185207464e-08,  3.504579261157523e-10, -6.738772625834990e-12,
  4.865069149923583e-14,  4.114079543355261e-16,  4.261509621393492e-17, -3.850078384266796e-20, -2.224577087919681e-20, -5.690494904489909e-22,  3.120233775371934e-03,
 -3.559242570927941e-05,  8.164407045230080e-07, -1.339114674612263e-08,  1.813943011878696e-10, -3.647840159341373e-12,  3.635125578903108e-14, -1.012965906016075e-16,
  2.078860983808391e-17, -6.386448062484647e-20, -8.030379499143070e-21, -2.355286561542350e-22,  4.559972329345238e-04, -6.812022077977359e-06,  1.892283158933308e-07,
 -3.607917585920980e-09,  5.943313961202470e-11, -1.242269548294695e-12,  1.626717473817420e-14, -1.639884092191705e-16,  6.876690882028080e-18, -4.731228805329515e-20,
 -1.239741501263819e-21, -5.932857727775575e-23,  4.246060734071261e-05, -8.397229538070515e-07,  2.741032771792175e-08, -6.117278244519607e-10,  1.215866405749791e-11,
 -2.700440042707902e-13,  4.432045889039210e-15, -6.654709871609376e-17,  1.695794189206023e-18, -1.969855509110559e-20,  7.486332047618712e-23, -1.108059011274253e-23,
  2.406143986388132e-06, -6.369365660144917e-08,  2.414871234908471e-09, -6.378388288227685e-11,  1.520052005357288e-12, -3.691713622754379e-14,  7.360217107197868e-16,
 -1.390767731943308e-17,  3.065156287057409e-19, -4.916310136858247e-21,  7.026885177920410e-23, -1.908316928263104e-24,  7.776108281774441e-08, -2.800081790457525e-09,
  1.237519018353744e-10, -3.927122285613954e-12,  1.122254775235376e-13, -3.071029595456551e-15,  7.326266211427883e-17, -1.653900795874031e-18,  3.753736261863085e-20,
 -7.451092875895029e-22,  1.419132269180237e-23, -2.966266212717183e-25,  1.304198228238369e-09, -6.563829834528361e-11,  3.447932069752274e-12, -1.343320173470726e-13,
  4.650992483628473e-15, -1.480999845244050e-16,  4.229726825968264e-18, -1.130789115579782e-19,  2.880217883674015e-21, -6.799383031290232e-23,  1.534953179024158e-24,
 -3.373637992631296e-26,  9.849286026967296e-12, -7.271106552774722e-13,  4.732765779879681e-14, -2.343869879729798e-15,  1.009606408591966e-16, -3.893393424112806e-18,
  1.355728266355664e-19, -4.363872862166548e-21,  1.311654433579812e-22, -3.690690536891216e-24,  9.829032853378757e-26, -2.488142285137349e-27,  2.696356912071079e-14,
 -3.204763011661650e-15,  2.809917001355469e-16, -1.885982673652574e-17,  1.069024603494449e-18, -5.301104623189341e-20,  2.351594819398334e-21, -9.499747596638866e-23,
  3.534918752892445e-24, -1.222055883653875e-25,  3.954044154138387e-27, -1.202898146272786e-28,  2.156665551317172e-17, -5.009943606861500e-18,  7.056899848107877e-19,
 -7.305868959970701e-20,  6.086038310955426e-21, -4.276311295015784e-22,  2.610912626883024e-23, -1.413735626141245e-24,  6.890144885495638e-26, -3.056878088650190e-27,
  1.245623680762178e-28, -4.690178481398586e-30,  1.250038694867288e-01, -6.602748970582793e-04,  3.629249949972261e-06, -1.754791820470019e-08,  3.297420659682627e-10,
  2.791803136302675e-12, -7.615811060350194e-14, -4.789892010322201e-15, -3.479866384250367e-17,  2.969411572980031e-18,  8.481718895576302e-20, -5.205190495622825e-22,
  8.672578567289646e-02, -4.946981051281285e-04,  3.979569190007423e-06, -3.421306533360817e-08,  3.241218574396519e-10, -2.036265678664556e-12,  1.030716346107423e-14,
 -7.434780509896449e-16, -3.336487664431318e-18,  3.362294753963058e-19,  1.053955432284762e-20, -3.895769445464782e-23,  4.153768465818816e-02, -2.730722335951647e-04,
  3.373093435352134e-06, -3.991535516548287e-08,  3.048973821105217e-10, -5.790986288222750e-12,  7.907834832142382e-14,  1.936087605184108e-15,  2.031784445165504e-17,
 -1.485772337299899e-18, -4.087611486924248e-20,  2.648277794755031e-22,  1.359350804679257e-02, -1.080331191469336e-04,  1.883639886862177e-06, -2.683084493486561e-08,
  2.290566462342282e-10, -5.287371447209868e-12,  7.757052772470023e-14,  1.537836569665303e-15,  2.014563674133219e-17, -1.303684285803043e-18, -3.542899498556852e-20,
  2.015532712481866e-22,  2.989972130233699e-03, -2.965957208289478e-05,  6.709072799500406e-07, -1.102475497728657e-08,  1.173019443410934e-10, -2.739083464450148e-12,
  4.193275043655289e-14,  4.470200168372604e-16,  1.057790565835513e-17, -5.444074711846632e-19, -1.382878846109812e-20,  6.423134806803742e-23,  4.315230949759442e-04,
 -5.456966231974303e-06,  1.508844596066720e-07, -2.835676353193529e-09,  3.824014584235002e-11, -8.841260707275262e-13,  1.440457794269559e-14,  1.462259040952900e-17,
  3.734932519083597e-18, -1.383446381123418e-19, -2.832232717081725e-21,  7.173987557355035e-24,  3.949796117615632e-05, -6.468717558578176e-07,  2.107583380339547e-08,
 -4.551484253316096e-10,  7.699460103881923e-12, -1.805594130945549e-13,  3.220853093960559e-15, -2.391337065481936e-17,  9.378466709430133e-19, -2.464489212388879e-20,
 -2.527650065177418e-22, -1.423841261839316e-24,  2.185676584461776e-06, -4.707332054810583e-08,  1.773815271647246e-09, -4.452441454262808e-11,  9.319046223691354e-13,
 -2.296509381977928e-14,  4.603280628035314e-16, -6.533707289749585e-18,  1.628058341071648e-19, -3.459075837651931e-21,  1.145931125514312e-23, -6.725055284241742e-25,
  6.827996221380694e-08, -1.972159648882746e-09,  8.564489583094502e-11, -2.540931473754672e-12,  6.524563300246954e-14, -1.754131823221685e-15,  4.038931186500076e-17,
 -7.941608818006431e-19,  1.833742884606687e-20, -3.796577404068227e-22,  5.334010827283139e-24, -1.219785361757002e-25,  1.088131327532729e-09, -4.343165925749676e-11,
  2.200017389475652e-12, -7.901101918691696e-14,  2.493231064796851e-15, -7.606674714763527e-17,  2.056012607361165e-18, -5.063645882168860e-20,  1.252875075148470e-21,
 -2.860157794599733e-23,  5.848321091875142e-25, -1.275530466731145e-26,  7.552149376103116e-12, -4.384795844608022e-13,  2.680052575325766e-14, -1.209009060808287e-15,
  4.774732237403321e-17, -1.731752318033909e-18,  5.655189396037783e-20, -1.706018652760076e-21,  4.883093468204787e-23, -1.306543475587876e-24,  3.292343501652964e-26,
 -8.023040740716457e-28,  1.753186281268363e-14, -1.635689330815959e-15,  1.302332259199020e-16, -7.888199281350411e-18,  4.098244491848998e-19, -1.889463126978342e-20,
  7.833762748266970e-22, -2.976383809805090e-23,  1.048775798760280e-24, -3.445859326133945e-26,  1.063702721048382e-27, -3.101968635885383e-29,  8.960051929943117e-18,
 -1.696927918439887e-18,  2.130250333945617e-19, -2.006283934103445e-20,  1.548523712490799e-21, -1.021075980971309e-22,  5.905817247251806e-24, -3.052689234050430e-25,
  1.429109965405615e-26, -6.121327596522107e-28,  2.418532138710837e-29, -8.862461337421166e-31,  1.224196353777999e-01, -6.319901398881647e-04,  3.451724217068651e-06,
 -1.197105249994172e-08,  3.562836793677628e-10, -6.513734382034909e-13, -2.057123521572512e-13, -3.649950879184070e-15,  1.174131077098250e-16,  4.774639714833035e-18,
 -2.213219149172922e-20, -4.154394106314264e-21,  8.480818661535662e-02, -4.644186608405027e-04,  3.598808211831608e-06, -2.934660237154747e-08,  2.841790693102440e-10,
 -2.036902130845273e-12, -9.663583823159342e-15, -5.865664381988284e-16,  1.471222322500240e-17,  5.866355837580583e-19, -1.503214051168662e-21, -4.993399031575430e-22,
  4.049643808618971e-02, -2.479285290614307e-04,  2.919943252142564e-06, -3.584141863734562e-08,  2.125799411930388e-10, -3.228655332902044e-12,  1.323918435665929e-13,
  1.470297815249340e-15, -5.480382984763652e-17, -2.337935786735051e-18,  1.161301113162598e-20,  2.022674418268624e-21,  1.318955294625618e-02, -9.419688102775730e-05,
  1.580538942362355e-06, -2.389545982668822e-08,  1.455736844374472e-10, -2.888317695131029e-12,  1.208882648471505e-13,  1.203693932759770e-15, -4.582611273679249e-17,
 -2.064881008589857e-18,  9.129054464382045e-21,  1.751988842561704e-21,  2.881270507353121e-03, -2.479338109767196e-05,  5.482532429157412e-07, -9.526820081098386e-09,
  7.370594619567642e-11, -1.565832675925212e-12,  5.556778565571121e-14,  3.819815423543971e-16, -1.656626506749529e-17, -8.494447518803234e-19,  3.347265384676830e-21,
  6.938403389174744e-22,  4.119069379038059e-04, -4.376822085751148e-06,  1.200055410464578e-07, -2.346194620242975e-09,  2.409549301317107e-11, -5.253198186250365e-13,
  1.559855720196886e-14,  3.573622952096836e-17, -2.819811801682238e-18, -2.021399333021194e-19,  7.348650947239726e-22,  1.516055098548889e-22,  3.721572420959355e-05,
 -4.982660409339993e-07,  1.624713711234113e-08, -3.568243872080102e-10,  4.820842774812346e-12, -1.087889981472257e-13,  2.825087295646032e-15, -9.832108651312751e-18,
 -9.421361731934139e-20, -3.019266485533833e-20,  1.246280218067620e-22,  1.837891896164258e-23,  2.022696901820868e-06, -3.479777009937521e-08,  1.315624978375251e-09,
 -3.274114743706163e-11,  5.708257786035397e-13, -1.363662243238894e-14,  3.320435450914866e-16, -3.255596443537679e-18,  4.402463157325859e-20, -3.079573595959558e-21,
  2.053512678645941e-23,  1.069720268371068e-24,  6.159046062518530e-08, -1.393575695683442e-09,  6.041206326597890e-11, -1.731511275139331e-12,  3.834902534716245e-14,
 -9.966911726771602e-16,  2.455765155841832e-17, -3.930148371176776e-19,  7.571994120562933e-21, -2.350479234933380e-22,  2.792796176392784e-24,  1.297505086360545e-28,
  9.444244673491117e-10, -2.904619338940509e-11,  1.448571184702232e-12, -4.902030334347890e-14,  1.370383246098899e-15, -4.001937300603236e-17,  1.071490794657499e-18,
 -2.340718498015615e-20,  5.379860285973165e-22, -1.336238774876308e-23,  2.400691982010041e-25, -4.023612478321210e-27,  6.150537878997799e-12, -2.713431224002770e-13,
  1.593429176063362e-14, -6.619323840184647e-16,  2.357192952012763e-17, -8.069897080695739e-19,  2.506640061053764e-20, -6.978100873263610e-22,  1.892035821861026e-23,
 -4.936591815089053e-25,  1.156410297150221e-26, -2.639409378450985e-28,  1.259976555542704e-14, -8.842409905358250e-16,  6.511946316797741e-17, -3.559993515614623e-18,
  1.680626538473035e-19, -7.209383790581541e-21,  2.793720203720794e-22, -9.926182407931939e-24,  3.306866318927817e-25, -1.032974144800876e-26,  3.025826281715485e-28,
 -8.433144389706867e-30,  4.495035734382838e-18, -6.511070850727044e-19,  7.232139857663653e-20, -6.106510889508170e-21,  4.314450036012603e-22, -2.645339873926208e-23,
  1.437165962144358e-24, -7.037325488180786e-26,  3.144022309200030e-27, -1.292565636155090e-28,  4.925393593442219e-30, -1.748411161333939e-31,  1.199461257523311e-01,
 -6.048569151982356e-04,  3.340903609972807e-06, -6.668190392207327e-09,  2.884233755811308e-10, -6.246807692009556e-12, -2.328491684112801e-13,  2.313877357437893e-15,
  2.277399544177050e-16,  1.888268277692012e-19, -1.916089547901163e-19, -1.990664729955512e-21,  8.300596747307856e-02, -4.369627363187033e-04,  3.272532566233708e-06,
 -2.514263300323218e-08,  2.401440344327208e-10, -2.394748660167318e-12, -1.667005108466480e-14,  1.644926222423823e-16,  2.907734943260755e-17,  6.119642123459590e-20,
 -2.337122921232987e-20, -3.001211464961480e-22,  3.954879575120333e-02, -2.262352835824005e-04,  2.508709833179509e-06, -3.277458257097685e-08,  1.817874320670203e-10,
  1.745184306495035e-13,  1.380433778513772e-13, -1.359633381573328e-15, -1.084984327152164e-16, -8.315268934204584e-20,  9.328629742478731e-20,  9.344256437732817e-22,
  1.283628944407762e-02, -8.266327970875720e-05,  1.306395162859858e-06, -2.186311952794544e-08,  1.184243706616373e-10,  1.894755799120547e-13,  1.243038846523319e-13,
 -1.223754573151338e-15, -9.424231599989180e-17, -1.276971300426793e-19,  8.141978975495247e-20,  8.713405034277479e-22,  2.790170770104451e-03, -2.084649131531538e-05,
  4.402150350709022e-07, -8.523379537999531e-09,  5.617077632143189e-11, -1.895370774865843e-13,  5.479393861781232e-14, -5.484489092213052e-16, -3.698300299545609e-17,
 -8.307600320049545e-20,  3.268810376576147e-20,  3.729382479074829e-22,  3.961497946617373e-04, -3.523506801903207e-06,  9.388385934062424e-08, -2.024302028315586e-09,
  1.733441469171911e-11, -1.553203717116634e-13,  1.436317535300894e-14, -1.512627779757868e-16, -7.843480598258837e-18, -3.131357780030019e-20,  7.373583625937771e-21,
  8.999546435023379e-23,  3.545715827986762e-05, -3.842472028655328e-07,  1.236788053820836e-08, -2.935251491846342e-10,  3.295023852391165e-12, -4.555849893475924e-14,
  2.361061393666026e-15, -2.753375135509142e-17, -8.756339304881294e-19, -7.353658938226945e-21,  9.773534886314862e-22,  1.252192747378230e-23,  1.902262727912894e-06,
 -2.570714190328709e-08,  9.698523629481078e-10, -2.538617471662353e-11,  3.708171691843587e-13, -6.696401015257434e-15,  2.456975096450022e-16, -3.352682804996552e-18,
 -3.832542337299768e-20, -1.100035928593845e-21,  7.774379062076084e-23,  9.388330680797099e-25,  5.686412608640596e-08, -9.842846130967033e-10,  4.275210955485193e-11,
 -1.248715557893791e-12,  2.352889372551095e-14, -5.190014061637328e-16,  1.583402707733979e-17, -2.631851704086343e-19,  1.315303805088664e-21, -1.040392857361687e-22,
  3.964979732804059e-24,  2.697890911705641e-26,  8.481475522209177e-10, -1.949058812248948e-11,  9.694616936472430e-13, -3.229298294261399e-14,  7.824523160914905e-16,
 -2.060820649559773e-17,  5.964288736733862e-19, -1.229552513411163e-20,  1.997501094997874e-22, -5.986240007378572e-24,  1.519605861195934e-25, -8.440098263803717e-28,
  5.277474098109966e-12, -1.702728674504199e-13,  9.811684175873329e-15, -3.868083970475626e-16,  1.215939942923570e-17, -3.851516568811468e-19,  1.185940427940343e-20,
 -3.057375812575419e-22,  7.326668062573266e-24, -1.951845572766825e-25,  4.650462459525479e-27, -8.396857346454004e-29,  9.886739989990055e-15, -4.974382525434496e-16,
  3.474083603717396e-17, -1.736878305684371e-18,  7.338844258209559e-20, -2.918991956616437e-21,  1.069073952008485e-22, -3.530094852198928e-24,  1.098513685248675e-25,
 -3.295846721872942e-27,  9.196352034889378e-29, -2.393185150143312e-30,  2.708403420362377e-18, -2.789815750535414e-19,  2.763725087487765e-20, -2.071451444191082e-21,
  1.321697108194439e-22, -7.476846242959699e-24,  3.789115366394465e-25, -1.743231951211842e-26,  7.381479835944661e-28, -2.897277452058906e-29,  1.058706002670935e-30,
 -3.620420790924778e-32,  1.175797417212086e-01, -5.783826079732952e-04,  3.283562469017330e-06, -3.320153082000366e-09,  1.169348534152590e-10, -1.028258770685229e-11,
 -7.588569353530827e-14,  8.196075260035947e-15,  9.642183265772282e-17, -6.902000430142432e-18, -1.046310768016710e-19,  5.686736555074433e-21,  8.130865346557770e-02,
 -4.119277688975838e-04,  2.992232604609892e-06, -2.170180872756463e-08,  1.891486658009590e-10, -2.639171970716950e-12, -6.189475372490706e-17,  9.405467036172283e-16,
  1.383438015462439e-17, -8.508359882522546e-19, -1.474043426113319e-20,  6.866405108109740e-22,  3.868157462355077e-02, -2.076879961806365e-04,  2.133512803225881e-06,
 -2.967782911526675e-08,  2.133819005619662e-10,  2.662159878648909e-12,  5.619348197866056e-14, -4.145183407741421e-15, -4.459962309779175e-17,  3.341837328643302e-18,
  4.983001786175489e-20, -2.770007360596040e-21,  1.252492413243778e-02, -7.322807783824404e-05,  1.056010332285120e-06, -1.979352834552062e-08,  1.475769070249045e-10,
  2.439841605672177e-12,  5.176191072446506e-14, -3.667207914809998e-15, -3.985417908332438e-17,  2.909407683071712e-18,  4.554363453819191e-20, -2.406727608400682e-21,
  2.713202200014824e-03, -1.771847421784413e-05,  3.434132807371595e-07, -7.591092203578538e-09,  6.361804530349466e-11,  8.141447463927201e-13,  2.429251748222961e-14,
 -1.518327305320802e-15, -1.603180997782801e-17,  1.157221836333432e-18,  1.921216672036264e-20, -9.592680283329658e-22,  3.834105495231728e-04, -2.865011069965044e-06,
  7.120934742780682e-08, -1.755015802709099e-09,  1.718886938288015e-11,  1.113025936715649e-13,  6.870367494638621e-15, -3.607326354156239e-16, -3.497363672797725e-18,
  2.544604677351900e-19,  4.613004872929932e-21, -2.132644063581197e-22,  3.409694496795059e-05, -2.985479003243427e-07,  9.140950985080194e-09, -2.453347388240776e-10,
  2.871694966206450e-12, -1.270481692746600e-15,  1.214930563392036e-15, -5.181552894279786e-17, -4.045115179480095e-19,  3.143971757739206e-20,  6.596777268913230e-22,
 -2.734797831074560e-23,  1.813153838737993e-06, -1.907426363550561e-08,  6.973411272582187e-10, -2.023879279756598e-11,  2.874634366189808e-13, -2.078686160445867e-15,
  1.332282835590077e-16, -4.576975526937739e-18, -1.905938538299133e-20,  2.033829920692513e-21,  5.662022763032027e-23, -2.001544772978866e-24,  5.352426810731827e-08,
 -6.964731724776865e-10,  2.974392419759827e-11, -9.370991546440606e-13,  1.636611915593141e-14, -2.249937648749065e-16,  8.715618766981853e-18, -2.495824494616986e-19,
  4.739944314045606e-22,  5.081113381165218e-23,  2.942527419041416e-24, -8.258876159403360e-26,  7.835071933486662e-10, -1.309893824899460e-11,  6.456859098363884e-13,
 -2.239952680465242e-14,  4.885796971952639e-16, -9.861931758580615e-18,  3.171729193433306e-19, -8.255674218695769e-21,  8.368595870690020e-23, -8.141450714803795e-25,
  9.679101718821467e-26, -2.087263860197784e-27,  4.727980453329157e-12, -1.075365664282717e-13,  6.126215936505660e-15, -2.409233871573822e-16,  6.722748989398471e-18,
 -1.821245411684894e-19,  5.745111660306955e-21, -1.538050078941559e-22,  2.936489808815447e-24, -6.485419011341070e-26,  2.150636217533029e-27, -4.313893839552448e-29,
  8.344136196165212e-15, -2.865932488207730e-16,  1.939138000435419e-17, -9.179444337129853e-19,  3.432620630970799e-20, -1.230641049006611e-21,  4.352244662123657e-23,
 -1.367040374593242e-24,  3.823634191576396e-26, -1.078726687776904e-27,  3.056761758165117e-29, -7.476633217237907e-31,  1.916242015470330e-18, -1.301821549895346e-19,
  1.177395977113496e-20, -7.868489794319476e-22,  4.459959086544977e-23, -2.304871546154543e-24,  1.088078273886015e-25, -4.673994034885297e-27,  1.856538407698071e-28,
 -6.922411282904643e-30,  2.421242754888475e-31, -7.919950999314864e-33,  1.153185199340434e-01, -5.522575396718811e-04,  3.248060832979467e-06, -3.112184756011393e-09,
 -8.757584166648357e-11, -9.246534696785565e-12,  1.568028063559083e-13,  7.039357188774886e-15, -1.603728140215456e-16, -5.541385964924171e-18,  1.614114524494492e-19,
  4.207263273166443e-21,  7.970723617470388e-02, -3.889841117459479e-04,  2.748252841461896e-06, -1.908831387447141e-08,  1.386123865607701e-10, -2.305342881904372e-12,
  2.744133288278539e-14,  8.467449755936330e-16, -1.901346977782478e-17, -7.387584870890101e-19,  1.957581370703020e-20,  5.847500728023515e-22,  3.788279095517665e-02,
 -1.919820696005353e-04,  1.799746377966075e-06, -2.580535229047197e-08,  2.703779868885356e-10,  2.575241677549399e-12, -6.053457704302840e-14, -3.525176804499298e-15,
  7.911712551043876e-17,  2.652028128670949e-18, -7.850404036986098e-20, -2.005582209917540e-21,  1.224746557108785e-02, -6.568597582840492e-05,  8.343855507029586e-07,
 -1.701061153330288e-08,  2.001730207181140e-10,  2.409560928795121e-12, -5.184529717988354e-14, -3.145185471333387e-15,  6.915706382723490e-17,  2.367317012814652e-18,
 -6.819940811950535e-20, -1.821230681418660e-21,  2.647272222343193e-03, -1.531686715707035e-05,  2.590265958429159e-07, -6.426232989424692e-09,  8.216340486434186e-11,
  8.705748631387785e-13, -1.861457243328910e-14, -1.309092967548175e-15,  2.795549174721134e-17,  9.689037466642795e-19, -2.712793677225949e-20, -7.614043189939737e-22,
  3.729633490816559e-04, -2.374691860489446e-06,  5.189209261405925e-08, -1.456771288869128e-09,  2.021924180522943e-11,  1.515692272659670e-13, -3.285571628626477e-15,
 -3.113355045642368e-16,  6.385423483191811e-18,  2.218929650598752e-19, -5.990694046508025e-21, -1.800363683330220e-22,  3.303147323866755e-05, -2.364094023908970e-07,
  6.475530875098040e-09, -1.985115610344304e-10,  3.017681847215792e-12,  1.017708672137858e-14, -2.262426202794388e-16, -4.428141056746320e-17,  8.618846393059790e-19,
  2.923259231275419e-20, -7.526914606390367e-22, -2.500687224527989e-23,  1.746583470247774e-06, -1.439105549502843e-08,  4.811430143369310e-10, -1.584206903288413e-11,
  2.674560939997871e-13, -4.096112856250830e-16,  9.497023393225270e-18, -3.781818727175884e-18,  6.937474613005436e-20,  2.137032686682187e-21, -5.165967397153423e-23,
 -2.019714363055468e-24,  5.114897126121395e-08, -4.993306814011175e-10,  1.995184310058263e-11, -7.021922422662756e-13,  1.341027654158995e-14, -9.566647641384793e-17,
  2.328187997464161e-18, -1.909407338952455e-19,  3.349582126801166e-21,  7.719701176477742e-23, -1.697650089366132e-24, -9.170554594625753e-26,  7.399108369820499e-10,
 -8.888406218255437e-12,  4.184241611520844e-13, -1.581984030653568e-14,  3.502691332034376e-16, -4.726407824651531e-18,  1.232535480149567e-19, -5.504828953690292e-21,
  9.830295471387119e-23,  8.735493558519312e-25, -1.400592152603205e-26, -2.260560441562597e-27,  4.379813300931003e-12, -6.849730417556105e-14,  3.780993567145303e-15,
 -1.563034036823686e-16,  4.157850682755244e-18, -8.695515773351309e-20,  2.500656087425511e-21, -8.416820106023124e-23,  1.713601944870230e-24, -1.439951608314129e-26,
  4.520013317953097e-28, -3.123712075070885e-29,  7.449372666938276e-15, -1.677445487648675e-16,  1.101254999871414e-17, -5.197890223447171e-19,  1.764684552096433e-20,
 -5.359890105830009e-22,  1.790326956708531e-23, -5.819792786466908e-25,  1.513193075233834e-26, -3.417003248004914e-28,  9.527609050479576e-30, -2.885254628651522e-31,
  1.537543709432398e-18, -6.439013286168978e-20,  5.453890585673962e-21, -3.349732593466789e-22,  1.670608911372374e-23, -7.697899167744297e-25,  3.384488819422501e-26,
 -1.370267666976406e-27,  5.054046104683161e-29, -1.754993156126045e-30,  5.879728965585616e-32, -1.863098505712984e-33,  1.131611720842503e-01, -5.264587011807284e-04,
  3.197020783299017e-06, -5.733661201345263e-09, -2.225044374187146e-10, -3.831425631281115e-12,  2.623373086723972e-13,  1.782287312475917e-16, -2.212779081323716e-16,
  2.169861058730483e-18,  1.653228449962475e-19, -3.565905477428287e-21,  7.819387000318641e-02, -3.678798630617554e-04,  2.531112732835660e-06, -1.719701696411522e-08,
  1.005749886024245e-10, -1.449255603196006e-12,  3.991357037049490e-14, -4.090738553855002e-18, -2.812753169680236e-17,  2.472343973066391e-19,  2.199866009187257e-20,
 -4.343967254563608e-22,  3.714180557742784e-02, -1.787459536637274e-04,  1.517405079551027e-06, -2.117372388184050e-08,  3.011233738117585e-10,  2.876050285140851e-13,
 -1.144181571376395e-13, -1.740647684957959e-16,  1.075610393750681e-16, -1.070174566800764e-18, -7.931027753539774e-20,  1.734168537307795e-21,  1.199686001586994e-02,
 -5.976985792497123e-05,  6.507769390324948e-07, -1.351456242100196e-08,  2.303368837106784e-10,  4.157376856815591e-13, -1.004748281777211e-13, -1.898559780676952e-16,
  9.544245417583475e-17, -9.194522669456421e-19, -7.092450725809878e-20,  1.509618802660027e-21,  2.589693816997191e-03, -1.352965286206704e-05,  1.902664976958479e-07,
 -5.006914437023833e-09,  9.276640810361126e-11,  1.086329861666301e-13, -3.925186856996665e-14, -1.063585634405718e-16,  3.906340629878001e-17, -3.631170043051480e-19,
 -2.914410105731346e-20,  6.023344213266390e-22,  3.641921577578486e-04, -2.023790713582308e-06,  3.643111233395254e-08, -1.115769303198737e-09,  2.189967289377731e-11,
 -3.356701606996263e-15, -8.333303978848073e-15, -3.527817864950148e-17,  9.019250464493415e-18, -8.007089608759891e-20, -6.729137131970430e-21,  1.337677098865319e-22,
  3.217553177606484e-05, -1.933011775240288e-07,  4.387856377677161e-09, -1.492507470436632e-10,  3.085838884781191e-12, -6.289955183603131e-15, -9.720870387316989e-16,
 -7.086856991415685e-18,  1.220908514909447e-18, -1.023856537057340e-20, -9.021642989801403e-22,  1.700747473698484e-23,  1.695615329863071e-06, -1.123028254374780e-08,
  3.163978862320486e-10, -1.164667211485152e-11,  2.545011880797884e-13, -1.148000353691683e-15, -5.733216614874137e-17, -8.486539128930712e-19,  9.617244887017719e-20,
 -7.596717550410883e-22, -6.871231706175021e-23,  1.202037479395406e-24,  4.942248425431999e-08, -3.699073006834107e-10,  1.275523496981469e-11, -5.014713465765080e-13,
  1.169393046679831e-14, -8.989049214203778e-17, -1.228232150511614e-18, -5.808109343801064e-20,  4.276296409867513e-21, -3.289159409249826e-23, -2.780207605129150e-24,
  4.337118189855989e-26,  7.099757527535474e-10, -6.211465117218695e-12,  2.594859841692152e-13, -1.085674630647844e-14,  2.747699983729543e-16, -3.241298531741811e-18,
  1.620643890826203e-20, -2.113333362162028e-21,  1.027613330752583e-22, -8.756021079977067e-25, -5.144487315938060e-26,  6.370472954540849e-28,  4.155885632349310e-12,
 -4.473551413637011e-14,  2.255745927456984e-15, -1.011249416486793e-16,  2.858268592196952e-18, -4.943534842177798e-20,  8.454365236536677e-22, -3.632668707368552e-23,
  1.266787163293266e-24, -1.511104610798871e-26, -2.541299190219783e-28, -2.136153712024216e-31,  6.920955342066767e-15, -1.004810538629570e-16,  6.178007119806680e-18,
 -3.045319451854874e-19,  1.014631697394111e-20, -2.564055611985901e-22,  6.940561940323428e-24, -2.413615857503281e-25,  7.304583655242493e-27, -1.422200616447715e-28,
  2.022305768300160e-30, -7.224695493431026e-32,  1.346955497951818e-18, -3.323060978350856e-20,  2.643806216214081e-21, -1.570804077734336e-22,  7.070478536678785e-24,
 -2.805776256323906e-25,  1.111461403767248e-26, -4.334881553459141e-28,  1.532723659122946e-29, -4.840769632393544e-31,  1.468782098375518e-32, -4.549427462578873e-34,
  1.111059634794178e-01, -5.012219187474953e-04,  3.105408569884701e-06, -9.576067001628425e-09, -2.394584448208863e-10,  1.833485889057525e-12,  1.869711522044926e-13,
 -4.738371986068109e-15, -6.944530085959506e-17,  4.963238709330413e-18, -2.508267652080353e-20, -3.598926876807385e-21,  7.676157751535348e-02, -3.484309334368576e-04,
  2.333611637152583e-06, -1.576936311807419e-08,  8.068773846522019e-11, -5.812100394611798e-13,  2.948763813196478e-14, -6.374676675872920e-16, -9.120646643164776e-18,
  6.401075406225803e-19, -2.619911192243601e-21, -4.836470478310114e-22,  3.644960604897435e-02, -1.675416603668185e-04,  1.291945704655640e-06, -1.645423173574822e-08,
  2.808131764518630e-10, -2.181231494265339e-12, -8.026072022494511e-14,  2.214338025962400e-15,  3.384835259322543e-17, -2.397434668847054e-18,  1.247878479117857e-20,
  1.724460434017676e-21,  1.176725413557120e-02, -5.514989470463277e-05,  5.105733324377766e-07, -9.889826661436976e-09,  2.157014910772735e-10, -1.760776543005792e-12,
 -7.103343472176003e-14,  1.941130317305858e-15,  3.057511982904938e-17, -2.127695008331608e-18,  1.044927586786730e-20,  1.547793622210083e-21,  2.538274370401316e-03,
 -1.222278318357183e-05,  1.389978735209492e-07, -3.555148305117353e-09,  8.593163308463261e-11, -7.465227904133722e-13, -2.794464311494236e-14,  7.716418873969611e-16,
  1.280769846494701e-17, -8.687530545376970e-19,  3.993925488215930e-21,  6.387813750522406e-22,  3.566034086561466e-04, -1.780017183988507e-06,  2.510722250635649e-08,
 -7.765770595979513e-10,  1.990409152031601e-11, -1.867805129623573e-13, -6.004462712498277e-15,  1.692763644485995e-16,  3.055072705255867e-18, -1.994526034243634e-19,
  8.376787811730053e-22,  1.484133386724497e-22,  3.146235164432946e-05, -1.645408445319514e-07,  2.884823523620038e-09, -1.021458273116650e-10,  2.731268644194646e-12,
 -2.813249607890066e-14, -7.182803429074631e-16,  2.094114705810401e-17,  4.327958742561680e-19, -2.668390839634613e-20,  9.878848750868573e-23,  2.009211314814526e-23,
  1.654966214235206e-06, -9.191162399753948e-09,  2.000620337377814e-10, -7.835402254442516e-12,  2.174877297203979e-13, -2.502432856348868e-15, -4.514895734131378e-17,
  1.394069497459931e-18,  3.626948316873096e-20, -2.052563097644897e-21,  6.406775390113585e-24,  1.556366308546638e-24,  4.811312212649170e-08, -2.889040201456621e-10,
  7.794795203864940e-12, -3.306479083297787e-13,  9.542475053434374e-15, -1.251616044973402e-16, -1.241005195258639e-18,  4.346733348685543e-20,  1.745728672534779e-21,
 -8.701307447800783e-23,  2.247796088701502e-25,  6.518926103816712e-26,  6.885556529439169e-10, -4.586827515154175e-12,  1.534722016972174e-13, -6.971831720731354e-15,
  2.107919608541721e-16, -3.232146955776917e-18, -4.011777222181567e-21,  3.616952426135086e-22,  4.571240938486148e-23, -1.903639884874865e-24,  4.914617022133414e-27,
  1.322743824567429e-27,  4.006355820672483e-12, -3.083548064357810e-14,  1.286822313300741e-15, -6.247034676713576e-17,  2.011383567093547e-18, -3.733564508998260e-20,
  3.018977344783077e-22, -6.087535232398242e-24,  5.933565649929609e-25, -1.983827556983998e-26,  9.300410205706151e-29,  1.020896554392717e-29,  6.598179389033563e-15,
 -6.325534211912790e-17,  3.352502186272805e-18, -1.760438583570298e-19,  6.254629760346792e-21, -1.487995303084106e-22,  2.771804711672958e-24, -7.789505588183416e-26,
  3.203191725628504e-27, -9.098396654175858e-29,  1.107464839681013e-30,  6.507976800310303e-33,  1.246646369089682e-18, -1.804621577581924e-20,  1.290116550064088e-21,
 -7.765428262216956e-23,  3.373553473560444e-24, -1.168954832832101e-25,  3.851882000362606e-27, -1.383868201321058e-28,  5.002392429113539e-30, -1.569350040115166e-31,
  4.144005605653992e-33, -1.053209437600591e-34,  1.091499479913507e-01, -4.768992984928654e-04,  2.969377869709204e-06, -1.291786668844969e-08, -1.693055113185858e-10,
  4.629432038956216e-12,  4.723035515531723e-14, -4.531822552145607e-15,  6.422656701454198e-17,  2.029005401870055e-18, -9.154310221680510e-20,  4.018460978544051e-22,
  7.540402319169778e-02, -3.304976879574124e-04,  2.151848816950544e-06, -1.453930452521167e-08,  7.460924589233172e-11, -1.009657635277053e-13,  1.067743132437441e-14,
 -6.130550734713887e-16,  8.353445645840392e-18,  2.696108543679821e-19, -1.193806731261261e-20,  4.291076434915233e-23,  3.579896275600309e-02, -1.579234018835738e-04,
  1.119735141808491e-06, -1.239255803778471e-08,  2.232647417145594e-10, -3.314352221494842e-12, -1.469679015665757e-14,  2.125914389623128e-15, -3.059970413001997e-17,
 -9.766700018852710e-19,  4.409843253753766e-20, -1.990827844221974e-22,  1.155415076392239e-02, -5.148453027115291e-05,  4.111940006396250e-07, -6.793341712749325e-09,
  1.681309400438524e-10, -2.767964990170733e-12, -1.330562338051187e-14,  1.876538198413351e-15, -2.687803009138948e-17, -8.761101244089600e-19,  3.922849332376153e-20,
 -1.673165801067939e-22,  2.491368262923194e-03, -1.125940674357454e-05,  1.039960970018701e-07, -2.328296397961987e-09,  6.616899388983835e-11, -1.138276780100110e-12,
 -4.826435880635380e-15,  7.541660143216714e-16, -1.076784729285374e-17, -3.621626472308867e-19,  1.604480197229957e-20, -6.413223952530436e-23,  3.498332507928027e-04,
 -1.611347440470264e-06,  1.755515752600297e-08, -4.940965732758440e-10,  1.514197612564327e-11, -2.691035521882769e-13, -8.695504570965565e-16,  1.684941431546214e-16,
 -2.393045250725954e-18, -8.454293506843058e-20,  3.688297834024015e-21, -1.347334075430302e-23,  3.084356842247138e-05, -1.456701313925906e-07,  1.900262715324684e-09,
 -6.366665632202298e-11,  2.048264563150462e-12, -3.759449218863187e-14, -6.886024493309718e-17,  2.152996230884932e-17, -3.024214538872540e-19, -1.157101291835898e-20,
  4.933934808533092e-22, -1.583441179537371e-24,  1.620885173513999e-06, -7.911722424453126e-09,  1.251138269176546e-10, -4.800065142124031e-12,  1.601687684386710e-13,
 -3.050160558248878e-15,  1.433775574216815e-20,  1.527169968157061e-18, -2.091999585315000e-20, -9.179883525556587e-22,  3.780944535722633e-23, -1.003191508353704e-25,
  4.706049667927663e-08, -2.400195728855620e-10,  4.656575486604509e-12, -1.991205489659211e-13,  6.860941075929845e-15, -1.367422982524130e-16,  3.265483573895760e-19,
  5.540816720015821e-20, -7.112446168677825e-22, -4.052836954647942e-23,  1.581888439494404e-24, -3.186674027919293e-27,  6.722084950107261e-10, -3.641282810712552e-12,
  8.791094867502445e-14, -4.115895871308055e-15,  1.466049711790450e-16, -3.101144808335446e-18,  1.711596588775218e-20,  8.577646740335531e-22, -8.678975935779099e-24,
 -9.296139280915231e-25,  3.335608243340032e-26, -5.014167147852765e-29,  3.899555884081793e-12, -2.304673406255542e-14,  7.068216002023109e-16, -3.589563452481594e-17,
  1.331763678711774e-18, -3.060515178518382e-20,  2.993660365278185e-22,  2.912857359979470e-24,  2.961439193283914e-26, -9.989408725273158e-27,  3.161980400842286e-28,
 -6.496674573845789e-31,  6.387548258315175e-15, -4.338982354970165e-17,  1.752317879049331e-18, -9.673209293592064e-20,  3.815383393816990e-21, -9.957309907471052e-23,
  1.597501189595525e-24, -1.872622629213163e-26,  7.839101004064216e-28, -4.280002971770326e-29,  1.180157677752439e-30, -8.205126528305146e-33,  1.190297299784949e-18,
 -1.068555148281297e-20,  6.183031992177854e-22, -3.840699135474346e-23,  1.721125859571869e-24, -5.712109940291168e-26,  1.554661718318825e-27, -4.374762802757095e-29,
  1.515037139600029e-30, -5.353039928616683e-32,  1.531925895436066e-33, -3.271846729803644e-35,  1.072888236152330e-01, -4.538031423097550e-04,  2.801258651187839e-06,
 -1.486279368570988e-08, -7.426008383320776e-11,  4.516357235961276e-12, -4.454632043323702e-14, -1.941139490966320e-15,  8.121247879378974e-17, -7.180898432758623e-19,
 -3.845288404041242e-20,  1.448508506962128e-21,  7.411538556301311e-02, -3.139605797973894e-04,  1.984503663784577e-06, -1.335299664040027e-08,  7.394487629950346e-11,
 -1.461838294298531e-14, -1.895116915012784e-15, -2.735767923730205e-16,  1.068911469486393e-17, -9.265450377972515e-20, -5.129682923114514e-21,  1.909842080712745e-22,
  3.518432212279010e-02, -1.495047065528037e-04,  9.902581382537175e-07, -9.351837549834339e-09,  1.576042114301735e-10, -3.084521690067652e-12,  2.806774646707634e-14,
  8.889172646619825e-16, -3.878887803064180e-17,  3.444433137296182e-19,  1.846337522675596e-20, -6.963884949096817e-22,  1.135433442469633e-02, -4.847956647829092e-05,
  3.439754042662992e-07, -4.547627537829362e-09,  1.132456215613983e-10, -2.572975615375722e-12,  2.444479566920407e-14,  7.834692955014485e-16, -3.436279954879316e-17,
  3.033611229903660e-19,  1.654999356881096e-20, -6.214290398693683e-22,  2.447840738851295e-03, -1.052293690702235e-05,  8.165479243289035e-08, -1.451644128371305e-09,
  4.371849322244547e-11, -1.047540109546447e-12,  1.032176612066165e-14,  3.123558277584674e-16, -1.393893494276156e-17,  1.221605626324799e-19,  6.826752666493565e-21,
 -2.549541517223355e-22,  3.436364670127158e-04, -1.490913366796142e-06,  1.290229587172619e-08, -2.945935029882836e-10,  9.880222507450117e-12, -2.438670535882756e-13,
  2.506598560795146e-15,  6.889557435744405e-17, -3.160097006934369e-18,  2.736570418960157e-20,  1.587042964482172e-21, -5.881739137070131e-23,  3.028716502402352e-05,
 -1.330237037199109e-07,  1.308297518416809e-09, -3.681769398843875e-11,  1.321865290039798e-12, -3.336312179489670e-14,  3.610943599031237e-16,  8.635451136657417e-18,
 -4.129713755050067e-19,  3.501428140101969e-21,  2.155472985726948e-22, -7.899106632639474e-24,  1.590930772728285e-06, -7.102219556451238e-09,  8.091199591012647e-11,
 -2.712486822925447e-12,  1.021483774782529e-13, -2.632994991676180e-15,  3.037560693524498e-17,  5.944852543164323e-19, -3.037140866524205e-20,  2.473261368834390e-22,
  1.685902797958284e-23, -6.074645483573935e-25,  4.616215740261361e-08, -2.106612775247148e-10,  2.838209242497359e-12, -1.103303593308462e-13,  4.312644021197695e-15,
 -1.137930645808155e-16,  1.421602226470621e-18,  2.047892059186150e-20, -1.175488315028026e-21,  8.771309165401676e-24,  7.247921426547165e-25, -2.543731094619459e-26,
  6.587874405429918e-10, -3.100213263313094e-12,  5.064008335728343e-14, -2.236787608786861e-15,  9.037415487215837e-17, -2.455674672378676e-18,  3.394281815758889e-20,
  2.815713304850395e-22, -2.100792105452960e-23,  1.223921773714387e-25,  1.580669408615264e-26, -5.316863375728420e-28,  3.816403447415503e-12, -1.879676234019864e-14,
  3.850612157807050e-16, -1.906763787873897e-17,  7.975635249395724e-19, -2.258369194684506e-20,  3.564986471464617e-22,  3.514430689208606e-25, -1.295781396112441e-25,
  2.060346904533652e-29,  1.542791896853900e-28, -4.840240109434264e-30,  6.235956126428712e-15, -3.311518576280836e-17,  8.984411603305132e-19, -4.967700034876927e-20,
  2.174572146419824e-21, -6.581154578828665e-23,  1.252126373323418e-24, -1.017718769423737e-26, -3.573505912370147e-29, -6.992694560657606e-30,  5.557932241512380e-31,
 -1.575317495378941e-32,  1.155089922430348e-18, -7.189903508264424e-21,  2.905713155096706e-22, -1.831814164558578e-23,  8.746984454499175e-25, -3.044969092069489e-26,
  7.888348579932109e-28, -1.667715947217466e-29,  4.048685441083570e-31, -1.464180618515174e-32,  5.392349199866778e-34, -1.481889873311389e-35,  1.055172815837334e-01,
 -4.321202700796837e-04,  2.618530182653002e-06, -1.540000955046849e-08,  2.360468555100196e-12,  3.057064151626568e-12, -6.785306796165255e-14,  5.978051869053012e-17,
  4.111733887661714e-17, -1.204350271164730e-18,  7.371748320924062e-21,  5.576540122929259e-22,  7.289030880740714e-02, -2.987054298722115e-04,  1.831343208450763e-06,
 -1.217664816865092e-08,  7.275996723420221e-11, -1.174885386898315e-13, -5.462383583412348e-15, -9.591362164445731e-18,  5.440664602076835e-18, -1.583727764764548e-19,
  9.578121940867447e-22,  7.457596082456674e-23,  3.460149136508105e-02, -1.419930795892803e-04,  8.912663137610903e-07, -7.280968596363644e-09,  1.040039031675228e-10,
 -2.237309038018213e-12,  3.814096433048241e-14, -6.548955134563945e-17, -1.955317396233127e-17,  5.777269585156281e-19, -3.541933133221399e-21, -2.675316602641440e-22,
  1.116561277150726e-02, -4.591892187398480e-05,  2.986958962005520e-07, -3.110110398566854e-09,  6.884304257561019e-11, -1.833886684793682e-12,  3.325476939403694e-14,
 -6.197513669561442e-17, -1.729708307878720e-17,  5.136739130388072e-19, -3.134667972773412e-21, -2.398634985641249e-22,  2.406959955615262e-03, -9.928979564055086e-06,
  6.779034612707369e-08, -9.041617898096414e-10,  2.571530570955283e-11, -7.398287519663048e-13,  1.374276036456905e-14, -3.048109922479008e-17, -6.997450503951902e-18,
  2.095527961228295e-19, -1.270660656764365e-21, -9.892035837687030e-23,  3.378601962559087e-04, -1.399495037061851e-06,  1.016664036214040e-08, -1.717947469773659e-10,
  5.706741970770431e-12, -1.707555240372837e-13,  3.228325365291222e-15, -8.802080804974820e-18, -1.580493902562679e-18,  4.790363317636332e-20, -2.874013035532050e-22,
 -2.297634262956470e-23,  2.977364979039998e-05, -1.240123726257746e-07,  9.730540049468082e-10, -2.047778943320794e-11,  7.537928235972760e-13, -2.312844922988894e-14,
  4.450452850929749e-16, -1.516494590525279e-18, -2.055486750550060e-19,  6.337040710920320e-21, -3.731479293087573e-23, -3.113811220694738e-24,  1.563644635330918e-06,
 -6.561062856124755e-09,  5.656993909954800e-11, -1.455957240453113e-12,  5.760724861181738e-14, -1.802391119165648e-15,  3.540031191208364e-17, -1.524289968325802e-19,
 -1.502570551749674e-20,  4.748204544120510e-22, -2.699749817553074e-24, -2.423828964664783e-25,  4.535798254984353e-08, -1.922386681055506e-10,  1.859520129474904e-12,
 -5.755739801393970e-14,  2.404247012934980e-15, -7.660346169451974e-17,  1.543955404621246e-18, -8.491044730658466e-21, -5.774143637050427e-22,  1.895210209605745e-23,
 -1.002277246888193e-25, -1.031447178234700e-26,  6.470569876640477e-10, -2.781313647334041e-12,  3.100139826629544e-14, -1.138047381648243e-15,  4.968264019370460e-17,
 -1.615039197347307e-18,  3.370019031833614e-20, -2.401600890962697e-22, -1.025054604430154e-23,  3.592071907546224e-25, -1.581703066006594e-27, -2.200571427443875e-28,
  3.746193029037940e-12, -1.644590543974124e-14,  2.194058364793956e-16, -9.459873353381751e-18,  4.299512484810755e-19, -1.434467141591400e-20,  3.146358969366500e-22,
 -2.975047470444631e-24, -6.362542546833919e-26,  2.581839203092414e-27, -4.836378529520344e-30, -2.045384333404902e-30,  6.114810896681519e-15, -2.781059129758746e-17,
  4.726551785921662e-19, -2.388185666925144e-20,  1.134571709284603e-21, -3.941981556434237e-23,  9.366552728987761e-25, -1.228649253444357e-26, -3.423629191503135e-29,
  3.701255507571566e-30,  4.835872435604211e-32, -6.588896828053156e-33,  1.129869697490895e-18, -5.546985402969531e-21,  1.375784172940246e-22, -8.303704573496869e-24,
  4.231521372736415e-25, -1.602312780256085e-26,  4.473212984842818e-28, -9.063158468751676e-30,  1.394988413994592e-31, -2.828672252220843e-33,  1.225498368981553e-34,
 -5.065508115986623e-36,  1.038295329086440e-01, -4.119065031540967e-04,  2.435694653354944e-06, -1.495883371353730e-08,  4.796140495405138e-11,  1.560235506013354e-12,
 -5.366743091653339e-14,  7.717956575879973e-16,  6.761857976314440e-18, -6.534958227998589e-19,  1.552924112420282e-20, -7.870608664807169e-23,  7.172389080097484e-02,
 -2.846195967049586e-04,  1.692108234224882e-06, -1.103821103488680e-08,  6.915815510892870e-11, -2.370175672468791e-13, -4.070686941009608e-15,  8.510766074945714e-17,
  9.235546901240384e-19, -8.575746865173750e-20,  2.052585747740312e-21, -1.043698643063929e-23,  3.404726180613476e-02, -1.351872315356126e-04,  8.125592939141821e-07,
 -5.926802376629159e-09,  6.797416503770826e-11, -1.396829016817305e-12,  3.038156645709728e-14, -4.016208918366194e-16, -3.076896966554341e-18,  3.132604018361824e-19,
 -7.454731267150076e-21,  3.775428590469252e-23,  1.098650295731284e-02, -4.366242724343611e-05,  2.669097397045133e-07, -2.260187551819772e-09,  3.975071341841022e-11,
 -1.103309968325709e-12,  2.629031706500923e-14, -3.580296220750066e-16, -2.651297927955919e-18,  2.780970167738043e-19, -6.648708780589887e-21,  3.368653873025434e-23,
  2.368268501713755e-03, -9.424073102456592e-06,  5.897713302610811e-08, -5.938298529065172e-10,  1.404486387509764e-11, -4.390877962589499e-13,  1.078247747385877e-14,
 -1.493767718804852e-16, -1.024509044527258e-18,  1.132286524139069e-19, -2.723230560569339e-21,  1.379093284081181e-23,  3.324137086751646e-04, -1.325088792193003e-06,
  8.553454320594559e-09, -1.037653212628805e-10,  3.023279488064412e-12, -1.004714964867779e-13,  2.508845567924122e-15, -3.536901028059076e-17, -2.154815923765141e-19,
  2.581993402824270e-20, -6.260387905527789e-22,  3.163485440294873e-24,  2.929186056698428e-05, -1.170373446830860e-07,  7.862337068814052e-10, -1.156256986954756e-11,
  3.915942261348228e-13, -1.350474115805570e-14,  3.416004844776392e-16, -4.917258619528769e-18, -2.500418301437338e-20,  3.405265511392054e-21, -8.348564941558509e-23,
  4.194424969943710e-25,  1.538213724442033e-06, -6.165170345551657e-09,  4.358280312550335e-11, -7.786987918680996e-13,  2.949199330151221e-14, -1.043678748547543e-15,
  2.673303300497457e-17, -3.950566492960410e-19, -1.494511678451317e-21,  2.542459235077125e-22, -6.330326050652961e-24,  3.137741919643443e-26,  4.461519139235635e-08,
 -1.795751909138395e-10,  1.355307956380571e-12, -2.944341870938795e-14,  1.215197287105811e-15, -4.390356853851557e-17,  1.140780575140220e-18, -1.744368701810170e-20,
 -3.657431334436139e-23,  1.011118671811097e-23, -2.574610205337755e-25,  1.236612958647137e-27,  6.363574486233591e-10, -2.576597958094708e-12,  2.118325408092729e-14,
 -5.603938066750248e-16,  2.478157392990842e-17, -9.128442744683994e-19,  2.415892668955269e-20, -3.867737156672449e-22,  4.901403157653393e-26,  1.912704742832573e-25,
 -5.044322739685561e-27,  2.235837316108460e-29,  3.683340475517942e-12, -1.504707795529141e-14,  1.389391839109618e-16, -4.496918594829405e-18,  2.109823494137745e-19,
 -7.941946903146881e-21,  2.157704364494152e-22, -3.686588377233630e-24,  1.169128857077016e-26,  1.387029290353261e-27, -3.900312570386147e-29,  1.316174903834997e-31,
  6.009681955208742e-15, -2.491964239169318e-17,  2.726097080558156e-19, -1.093206015790051e-20,  5.430013647108135e-22, -2.106684610768877e-23,  5.974620593669926e-25,
 -1.129200540952884e-26,  8.652814890172974e-29,  2.224481243514419e-30, -7.491688140686269e-32, -1.030183839337417e-34,  1.109386600507817e-18, -4.750798825273097e-21,
  6.965478654711203e-23, -3.591815072058894e-24,  1.917933168559231e-25, -7.897305387942315e-27,  2.454763104527654e-28, -5.615299367380067e-30,  8.742373201218913e-32,
 -7.851103281599205e-34,  1.009209287855130e-35, -8.383324560134541e-37  };
  int offset = -13;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 13;
    if (std::isnan(t)) {
      fill_n(rr+offset, 13, 0.5);
      fill_n(ww+offset, 13, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 13; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=13; ++j) {
        const int boxof = it*156+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
