//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: zsuperci.h
// Copyright (C) 2014 Toru Shiozaki
//
// Author: Jefferson Bates <jefferson.bates@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#ifndef __SRC_ZCASSCF_ZSUPERCI_H
#define __SRC_ZCASSCF_ZSUPERCI_H

#include <src/multi/zcasscf/zcasscf.h>

namespace bagel {

class ZSuperCI : public ZCASSCF {
  protected:
    int diis_start_;

    void common_init() {
      std::cout << "   * Using the Super CI algorithm as noted in Roos (1980) IJQC *    " << std::endl;
      diis_start_ = idata_->get<int>("diis_start", 5);
      std::cout << "   * DIIS will be used after " << diis_start_ << " macro iterations *    " << std::endl << std::endl;
    }

  public:
    ZSuperCI(const std::shared_ptr<const PTree> idat, const std::shared_ptr<const Geometry> geom, const std::shared_ptr<const Reference> ref = nullptr)
       : ZCASSCF(idat, geom, ref) { common_init(); }

    void compute() override;
    // compute effective fock matrices used to build gradients
    void one_body_operators(std::shared_ptr<ZMatrix>& f, std::shared_ptr<ZMatrix>& fact, std::shared_ptr<ZMatrix>& factp, std::shared_ptr<ZMatrix>& gaa,
                            std::shared_ptr<ZRotFile>& denom);
    // gradient functions for virtual-closed, virtual-active, and closed-active contributions
    void grad_vc(const std::shared_ptr<ZMatrix> f, std::shared_ptr<ZRotFile> sigma);
    void grad_va(const std::shared_ptr<ZMatrix> fact, std::shared_ptr<ZRotFile> sigma);
    void grad_ca(const std::shared_ptr<ZMatrix> f, std::shared_ptr<ZMatrix> fact, std::shared_ptr<ZRotFile> sigma);

};

}

#endif
