/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lbking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef _BAB_H_
#define _BAB_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
//#include <dcopclient.h>
#include "bab_iface.h"
#include <qwidget.h>
#include <qpixmap.h>
#include <qsettings.h>
#include <kmainwindow.h>
#include <ksystemtray.h>

class bab;

class BabSwitcher : public KSystemTray , public babInterface{
   Q_OBJECT
public: 
   
   enum State {Aqua = 0, Brushed};
//   enum DecoState {Jaguar = 0, Panther, Brushed}

   BabSwitcher(bab *parent=0, const char *name=0);
   ~BabSwitcher();

   void toggleState();
   void setState(int);
   int state();
   void setDecoState(int);
   int decoState();
   void start(QString name, int state, int decoState);
   void start(QString name, int decoState);
   void readState();
   void saveDecoState();
   static QPoint *globalPos;
   
protected:
   void mousePressEvent(QMouseEvent *e);
   void paintEvent(QPaintEvent *ev);

private:

   State state_;
   bool forceRects;
   int decoState_;
   int oldState;
   int oldDecoState;
//   DecoState decoState_;
//   TabState aquaTab_;
//   TabState brushedTab_;
   QPixmap aquaIcon;
   QPixmap brushedIcon;


public slots:
      void saveState();
      
private slots:
    void resetAfterStart();
    void resetAfterStart2();
   
};


class QComboBox;
class QCheckBox;
/**
 * @short Application Main Window
 * @author Thomas Lübking <thomas@home>
 * @version 0.1
 */
class bab : public KMainWindow
{
    Q_OBJECT
public:
    
    enum TabState {Tab = 0, Clever, Chooser};
    bab();
    void showEvent(QShowEvent *e);

    QComboBox *AquaTab;
    QComboBox *BrushedTab;
    QComboBox *ShowTools;
    QCheckBox *iTunesCheck;
    QCheckBox *iTunesCheck2;
    virtual ~bab();
private:
    BabSwitcher* bSwitcher;
    QComboBox *DefStyle;
 //   BabSwitcher::State defState;

private slots:
   void saveSettings(); 

};

class Corner : public QWidget
{
    Q_OBJECT
public:
    enum Side {left = 0, right};
    Corner(Side side);
};
   
#endif // _BAB_H_
