/***************************************************************************
 *   Copyright (C) 2004 by Thomas Lbking                                  *
 *   thomas@home                                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "bab.h"
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlayout.h>
#include <qsettings.h>
#include <qtooltip.h>
#include <qtimer.h>
#include <qvbox.h> 
#include <qpainter.h>
#include <dcopclient.h>
#include <kapplication.h>
// #include <kconfig.h>
#include <kiconloader.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <klocale.h>
#include <kprocess.h>
#include <X11/extensions/shape.h>

static const char description[] =
    I18N_NOOP("Baghira Aqua/Brushed");

static const char version[] = "0.6";

static KCmdLineOptions options[] =
{
//    { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
    KCmdLineLastOption
};

int main(int argc, char **argv)
{
    KAboutData about("bab", I18N_NOOP("BAB - Baghira Aqua/Brushed Switcher"), version, description,
                     KAboutData::License_GPL, "(C) 2004 Thomas Lübking", 0, 0, "thomas@home");
    about.addAuthor( "Thomas Lübking", 0, "thomas@home" );
    KCmdLineArgs::init(argc, argv, &about);
    KCmdLineArgs::addCmdLineOptions( options );
    KApplication app;
    DCOPClient* client = app.dcopClient();
    client->registerAs( "bab", false);
    client->setDefaultObject( "babInterface" );
//    BabSwitcher* switcher = 0;
    bab* mainBAB = 0;

//      if (app.isRestored())
//      {
//          RESTORE(bab);
// 	 mainBAB = new bab;
//          app.setMainWidget(mainBAB);
//           mainBAB->hide();
// //        switcher->setObjId("bab");
// //        switcher->show();
//      }
//      else
//      {   
        // no session.. just start up normally
//        KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

//        switcher = new BabSwitcher;
        
        mainBAB = new bab;
        app.setMainWidget(mainBAB);
        Corner leftCorner(Corner::left);
        Corner rightCorner(Corner::right);
//	QWidget test(0, "test", Qt::WType_TopLevel | Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | Qt::WX11BypassWM);
//	test.resize(100,100);
//	test.move(500,400);
//	test.show();
//          mainBAB->show();
//        switcher->setObjId("bab");
//        switcher->show();
        
//        args->clear();
//     }

    int ret = app.exec();
//    if (switcher) delete switcher;
    if (mainBAB) delete mainBAB;
    return ret;
}


bab::bab() : KMainWindow(0,"bab",Qt::WStyle_StaysOnTop | Qt::WX11BypassWM ){
   bSwitcher = new BabSwitcher(this,"switcher");
   QToolTip::add(bSwitcher, i18n("leftclick toggles state<br>rightclick toggles setupmenu"));
   bSwitcher->show();
    
   QSettings config;
   config.beginGroup("/baghira/BAB");
//     KConfig config("baghirarc");
//     config.setGroup("BAB");
   QVBox *vb = new QVBox(this);
//    QVBoxLayout *vbl = new QVBoxLayout(vb);
   vb->setLineWidth(2);
   vb->setMargin(2);
   vb->setFrameStyle(QFrame::Panel | QFrame::Plain );   
   QLabel *DefStyleLabel = new QLabel("Default Style is", vb);
   DefStyle = new QComboBox(vb);
   DefStyle->insertItem ( "Aqua" );
   DefStyle->insertItem ( "Brushed Metal" );
   DefStyle->setCurrentItem(config.readNumEntry("defaultState", BabSwitcher::Aqua ));
   QLabel *AquaTabLabel = new QLabel("Aqua Tabs are", vb);
   AquaTab = new QComboBox(vb);
   AquaTab->insertItem ( "Tab" );
   AquaTab->insertItem ( "Clever" );
   AquaTab->insertItem ( "Chooser" );
   AquaTab->setCurrentItem(config.readNumEntry("aquaTab", Clever ));
   QLabel *BrushedTabLabel = new QLabel("Brushed Tabs are", vb);
   BrushedTab = new QComboBox(vb);
   BrushedTab->insertItem ( "Tab" );
   BrushedTab->insertItem ( "Clever" );
   BrushedTab->insertItem ( "Chooser" );
   BrushedTab->setCurrentItem(config.readNumEntry("brushedTab", Clever ));
   iTunesCheck = new QCheckBox("Toolbuttons follow Design", vb);
   iTunesCheck->setChecked(config.readBoolEntry("brushediTunes", true ));
   iTunesCheck2 = new QCheckBox("Pushbuttons follow Design", vb);
   iTunesCheck2->setChecked(config.readBoolEntry("brushediTunes2", false ));
   QLabel *ShowToolsLabel = new QLabel("Show unhovered Toolbuttons for", vb);
   ShowTools = new QComboBox(vb);
   ShowTools->insertItem ( "Aqua" );
   ShowTools->insertItem ( "Brushed Metal" );
   ShowTools->insertItem ( "Both" );
   ShowTools->insertItem ( "None" );
   ShowTools->setCurrentItem(config.readNumEntry("unhoveredTools", BabSwitcher::Brushed ));
   QPushButton *Quit = new QPushButton("Quit BAB", vb);
//   Quit->setPixmap(BarIcon("fileclose"));
   QPushButton *Close = new QPushButton("Close Menu", vb);
   vb->adjustSize();
   config.endGroup();
   bSwitcher->setState(DefStyle->currentItem());
   
   connect(DefStyle, SIGNAL(activated(int)), this, SLOT(saveSettings()));
   connect(AquaTab, SIGNAL(activated(int)), this, SLOT(saveSettings()));
   connect(BrushedTab, SIGNAL(activated(int)), this, SLOT(saveSettings()));
   connect(ShowTools, SIGNAL(activated(int)), this, SLOT(saveSettings()));
   connect(iTunesCheck, SIGNAL(clicked ()),  this, SLOT(saveSettings()));
   connect(iTunesCheck2, SIGNAL(clicked ()),  this, SLOT(saveSettings()));
   connect(AquaTab, SIGNAL(activated(int)), bSwitcher, SLOT(saveState()));
   connect(BrushedTab, SIGNAL(activated(int)), bSwitcher, SLOT(saveState()));
   connect(ShowTools, SIGNAL(activated(int)), bSwitcher, SLOT(saveState()));
   connect(iTunesCheck, SIGNAL(clicked ()),  bSwitcher, SLOT(saveState()));
   connect(iTunesCheck2, SIGNAL(clicked ()),  bSwitcher, SLOT(saveState()));
   connect(Close, SIGNAL(clicked()), this, SLOT(hide()));
   connect(Quit, SIGNAL(clicked()), this, SLOT(close()));
   
   resize(vb->width(),vb->height());
   
//   show();
}

bab::~ bab(){
   bSwitcher->setState(DefStyle->currentItem());
   if (bSwitcher) delete bSwitcher;
}

/** overwrite the show event for repositioning the window on top
 of the icon, adapted from kkeyled */
void bab::showEvent(QShowEvent *e){
    if ( bSwitcher->globalPos->x() > 0) {
       QWidget *desktop = QApplication::desktop();
       int w = desktop->width();
       QPoint nPos;   
       if(bSwitcher->globalPos->y() - height() > 0 ) { // it's not on top
          nPos.setY(bSwitcher->globalPos->y() -height());
          nPos.setX(bSwitcher->globalPos->x() - (width() / 2));
       } else { 
          if( bSwitcher->globalPos->y() > 0 ) { 
               nPos.setY(bSwitcher->globalPos->y() + bSwitcher->height() );
               nPos.setX(bSwitcher->globalPos->x() - (width() / 2));
          }
       }
       if ( nPos.x() < 0 ) {
          nPos.setX(bSwitcher->globalPos->x() + bSwitcher->width());
       } else {
          if ( bSwitcher->globalPos->x() + (width() / 2)  > w ) {
               nPos.setX(bSwitcher->globalPos->x() - width());
          }
       }
       move(nPos);
    }
    
   // If it was set by the normal sessionmanagement it needs
   // to set the Flags again
   setWFlags(Qt::WStyle_StaysOnTop | Qt::WX11BypassWM); 
   QWidget::showEvent(e); // execute the normal showevent
   raise();
}

void bab::saveSettings(){
   QSettings *config = new QSettings();
//    KConfig *config = new KConfig("baghirarc");
   config->beginGroup("/baghira/BAB");
//    config->setGroup("BAB");
   config->writeEntry("defaultState", DefStyle->currentItem());
   config->writeEntry("aquaTab", AquaTab->currentItem());
   config->writeEntry("brushedTab", BrushedTab->currentItem() );
   config->writeEntry("unhoveredTools", ShowTools->currentItem() );
   config->writeEntry("brushediTunes", iTunesCheck->isChecked() );
   config->writeEntry("brushediTunes2", iTunesCheck2->isChecked() );
   config->endGroup();
   delete config;
}

QPoint *BabSwitcher::globalPos = new QPoint::QPoint(0,0);

BabSwitcher::BabSwitcher(bab *parent, const char *name) 
                                          : KSystemTray(parent,name), DCOPObject("babInterface") {
   KIconLoader* iLoader = KGlobal::iconLoader();
   aquaIcon = iLoader->loadIcon("bab_aqua", KIcon::Small, 22);
   brushedIcon = iLoader->loadIcon("bab_brushed", KIcon::Small, 22);
   readState();
   installEventFilter(this);                                          
}

BabSwitcher::~BabSwitcher(){
}

void BabSwitcher::toggleState(){
   if ( state_ == Aqua ) {
      // lade brushed icon...
      state_ = Brushed;
   }
   else {
      // lade aqua icon
      state_ = Aqua;
   }
   saveState();
   repaint();
}

void BabSwitcher::setState(int state){
   state_ = state < 0 ? (State)0 : state > 1 ? (State)1 : (State)state;
   saveState();
   repaint();
}

void BabSwitcher::setDecoState(int state){
   decoState_ = state < 0 ? 0 : state > 2 ? 2 : state;
   saveDecoState();
}

int BabSwitcher::state(){
   return (int)state_;
}

int BabSwitcher::decoState(){
   return decoState_;
}

void BabSwitcher::start(QString name, int state, int decoState){
    oldState = (int)state_;
    oldDecoState = decoState_;
    QSettings *config = new QSettings();
    config->beginGroup("/baghira/BAB");
//     KConfig *config = new KConfig("baghirarc");
//     config->setGroup("BAB");
    config->writeEntry("styleQueried", false);
    config->writeEntry("decoQueried", false);
    config->endGroup();
    delete config;
    setState(state);
    setDecoState(decoState);
    KProcess proc;// = new KProcess;
    QString section; int i = 0; bool done = false;
    if (name.contains(' ')){
        while (!done){
            section = name.section(' ',i,i);
            if (!section.isEmpty())
                proc << section;
            else
                done = true;
            i++;
        }
    }
    else {
        proc << name;
    }
    proc.start(KProcess::DontCare);
    proc.detach();
//     delete proc;
    QTimer::singleShot( 500, this, SLOT(resetAfterStart()) );
}

void BabSwitcher::start(QString name, int decoState){
    oldDecoState = decoState_;
//     KConfig *config = new KConfig("baghirarc");
//     config->setGroup("BAB");
    QSettings *config = new QSettings();
    config->beginGroup("/baghira/BAB");
    config->writeEntry("decoQueried", false);
    config->endGroup();
    delete config;
    setDecoState(decoState);
    KProcess proc;// = new KProcess;
    QString section; int i = 0; bool done = false;
    if (name.contains(' ')){
        while (!done){
            section = name.section(' ',i,i);
            if (!section.isEmpty())
                proc << section;
            else
                done = true;
            i++;
        }
    }
    else {
        proc << name;
    }
    proc.start(KProcess::DontCare);
    proc.detach();
//     delete proc;
    QTimer::singleShot( 500, this, SLOT(resetAfterStart2()) );
}

void BabSwitcher::resetAfterStart(){
    bool styleQueried; bool decoQueried;
//     KConfig config("baghirarc");
//     config.setGroup("BAB");
    QSettings config;
    config.beginGroup("/baghira/BAB");
    styleQueried = config.readBoolEntry("styleQueried", false );
    decoQueried = config.readBoolEntry("decoQueried", false );
    config.endGroup();
    if (styleQueried && decoQueried){
        setState(oldState);
        setDecoState(oldDecoState);
    }
    else
        QTimer::singleShot( 500, this, SLOT(resetAfterStart()) );
}

void BabSwitcher::resetAfterStart2(){
    bool decoQueried;
//     KConfig config("baghirarc");
//     config.setGroup("BAB");
    QSettings config;
    config.beginGroup("/baghira/BAB");
    decoQueried = config.readBoolEntry("decoQueried", false );
    config.endGroup();
    if (decoQueried){
        setDecoState(oldDecoState);
    }
    else
        QTimer::singleShot( 500, this, SLOT(resetAfterStart2()) );
}

void BabSwitcher::saveState(){
//    KConfig *config = new KConfig("baghirarc");
   QSettings *config = new QSettings;
   config->beginGroup("/baghira/Style");
//    config->setGroup("Style");
   config->writeEntry("Design_Default", state_ );
   config->writeEntry("Design_TabStyle", 
                        (state_ == Aqua) ?
                        ((bab*)parent())->AquaTab->currentItem() :
                        ((bab*)parent())->BrushedTab->currentItem() );
   if (((bab*)parent())->iTunesCheck->isChecked()) config->writeEntry("Special_RoundToolButtons", state_ == Aqua);
   (((bab*)parent())->iTunesCheck2->isChecked()) ?
		config->writeEntry("Design_RectangularButtons", state_ == Brushed):
		config->writeEntry("Design_RectangularButtons", forceRects);
   config->writeEntry("Special_UnhoveredToolButtons", 
                        (((bab*)parent())->ShowTools->currentItem() ==  Aqua && state_ == Aqua) ||
			(((bab*)parent())->ShowTools->currentItem() ==  Brushed && state_ == Brushed) ||
			(((bab*)parent())->ShowTools->currentItem() ==  2));
   config->endGroup();
   delete config;
}

void BabSwitcher::saveDecoState(){
   QSettings *config = new QSettings;
   config->beginGroup("/baghira/Deco");
//    KConfig *config = new KConfig("baghirarc");
//    config->setGroup("Deco");
   config->writeEntry("defaultMode", decoState_);
   config->endGroup();
   delete config;
}

void BabSwitcher::readState(){
//    KConfig config("baghirarc");
//    config.setGroup("Style");
   QSettings config;
   config.beginGroup("/baghira/Style");
   state_ = (State)config.readNumEntry("Design_Default", 0 );
   forceRects = config.readBoolEntry("Design_RectangularButtons", false );
   config.endGroup();
   config.beginGroup("/baghira/Deco");
//    config.setGroup("Deco");
   decoState_ = config.readNumEntry("defaultMode",1);
   config.endGroup();
}

void BabSwitcher::mousePressEvent(QMouseEvent *e){

  QWidget *daddy = parentWidget();

  globalPos->setX(e->globalX() - e->x());
  globalPos->setY(e->globalY() - e->y());

   switch ( e->button() ) {
   case LeftButton:{
      if ( state_ == Aqua ) {
      // lade brushed icon...
      state_ = Brushed;
      }
      else {
      // lade aqua icon
      state_ = Aqua;
      }
      saveState();
      repaint();
      break;
   }
   case RightButton:
   default:{
   // toggleMinimizeRestore();
      if ( daddy->isVisible() ) {
         daddy->hide();
      }
      else {
         daddy->show();
      }
   }
   }
}

void BabSwitcher::paintEvent(QPaintEvent *ev){
   KSystemTray::paintEvent(ev);
   QPainter *icyApainter = new QPainter(this);
   if(state_ == Aqua) {
      aquaIcon.isNull() ? icyApainter->fillRect(this->rect(), Qt::white) : icyApainter->drawPixmap(0, 0, aquaIcon);
   }
   else {
      brushedIcon.isNull() ? icyApainter->fillRect(this->rect(), Qt::black) : icyApainter->drawPixmap(0, 0, brushedIcon);
   }
   
   icyApainter->flush();
   icyApainter->end();
   delete icyApainter;
}

Corner::Corner(Side side) : QWidget(0, (side == left)?"left_corner":"right_corner", Qt::WType_TopLevel | Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | Qt::WX11BypassWM )
{
    
    if (side == left) {
        setFixedSize(5,4);
        move(0,0);
        show();
        setPaletteBackgroundColor(Qt::black);
        XRectangle* xrects = new XRectangle[4];
        xrects[ 0 ].x = 0;
        xrects[ 0 ].y = 0;
        xrects[ 0 ].width = 5;
        xrects[ 0 ].height = 1;
        xrects[ 1 ].x = 0;
        xrects[ 1 ].y = 1;
        xrects[ 1 ].width = 3;
        xrects[ 1 ].height = 1;
        xrects[ 2 ].x = 0;
        xrects[ 2 ].y = 2;
        xrects[ 2 ].width = 2;
        xrects[ 2 ].height = 1;
        xrects[ 3 ].x = 0;
        xrects[ 3 ].y = 3;
        xrects[ 3 ].width = 1;
        xrects[ 3 ].height = 2;                
        XShapeCombineRectangles( qt_xdisplay(), winId(), ShapeBounding, 0, 0,
            xrects, 4, ShapeSet, 0 );
        delete[] xrects;
    }
    else {
        setFixedSize(5,4);
        move(QApplication::desktop()->width()-5,0);
        show();
        setPaletteBackgroundColor(Qt::black);
        XRectangle* xrects = new XRectangle[4];
        xrects[ 0 ].x = 0;
        xrects[ 0 ].y = 0;
        xrects[ 0 ].width = 5;
        xrects[ 0 ].height = 1;
        xrects[ 1 ].x = 2;
        xrects[ 1 ].y = 1;
        xrects[ 1 ].width = 3;
        xrects[ 1 ].height = 1;
        xrects[ 2 ].x = 3;
        xrects[ 2 ].y = 2;
        xrects[ 2 ].width = 2;
        xrects[ 2 ].height = 1;
        xrects[ 3 ].x = 4;
        xrects[ 3 ].y = 3;
        xrects[ 3 ].width = 1;
        xrects[ 3 ].height = 2;          
        XShapeCombineRectangles( qt_xdisplay(), winId(), ShapeBounding, 0, 0,
            xrects, 4, ShapeSet, 0 );
        delete[] xrects;
    }
}

#include "bab.moc"
