# Balazar
# Copyright (C) 2005 Jean-Baptiste LAMY
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

import os, os.path, gettext

import soya, tofu
APPDIR = os.path.dirname(__file__)

soya.path.insert(0, APPDIR)
tofu.path.insert(0, APPDIR)

soya.AUTO_EXPORTERS_ENABLED = os.path.exists(os.path.join(APPDIR, "CVS"))

translator = None
LOCALEDIR = os.path.join(APPDIR, "locale")
try: translator = gettext.translation("balazar", LOCALEDIR)
except IOError:
  
  LOCALEDIR = os.path.join(APPDIR, "..", "locale")
  try: translator = gettext.translation("balazar", LOCALEDIR)
  except IOError:
    
    LOCALEDIR = os.path.join("/", "usr", "share", "locale")
    try: translator = gettext.translation("balazar", LOCALEDIR)
    except IOError:
      
      # Non-supported language, defaults to english
      LOCALEDIR = os.path.join(APPDIR, "locale")
      try: translator = gettext.translation("balazar", LOCALEDIR, ("en",))
      except IOError:
        
        LOCALEDIR = os.path.join(APPDIR, "..", "locale")
        try: translator = gettext.translation("balazar", LOCALEDIR, ("en",))
        except IOError:
          
          LOCALEDIR = os.path.join("/", "usr", "share", "locale")
          translator = gettext.translation("balazar", LOCALEDIR, ("en",))
      
translator.install(1)
#open(os.path.join(LOCALEDIR, "fr", "LC_MESSAGES", "balazar.po")).read()


VERIFICATION_SERVER = ""

DIFFICULTY = 0

FULLSCREEN    = 0
SCREEN_WIDTH  = 800
SCREEN_HEIGHT = 600
MIN_FRAME_DURATION = 0.025

QUALITY    = 1

SERVER_HOST = "localhost" #"balazar.nekeme.net"
SERVER_PORT = 6900

MUSIC = 1
SOUND = 1
ASYNC_LOAD_MUSIC = 0
SOUND_SYSTEM = "OpenAL"
#SOUND_SYSTEM = "SDL_mixer"
WAIT_FOR_SOUND = 1

# Check for "dot balazar" config file
CONFIG_FILE = os.path.expanduser(os.path.join("~", ".balazar"))
if CONFIG_FILE[0] == "~": # Fucking winedaube OS !!!
  CONFIG_FILE = "C:\\.balazar" # Random name...
  
SAVED_GAME_DIR = os.path.expanduser(os.path.join("~", ".balazar_saved_games"))
if SAVED_GAME_DIR[0] == "~": # Fucking winedaube OS !!!
  SAVED_GAME_DIR = "C:\\.balazar_saved_games" # Random name...
  
try:
  import getpass
  NAME = getpass.getuser()
except:
  NAME = "jiba"

PASSWORD = "test"

if os.path.exists(CONFIG_FILE):
  try:
    execfile(CONFIG_FILE)
  except:
    import sys
    sys.excepthook(*sys.exc_info())
    print """* Balazar * Error in config file ~/.balazar !
Please reconfigure Balazar !
Config file ignored.
"""

    
def generate_dot_balazar():
  open(CONFIG_FILE, "w").write("""
FULLSCREEN        = %(FULLSCREEN)s
SCREEN_WIDTH      = %(SCREEN_WIDTH)s
SCREEN_HEIGHT     = %(SCREEN_HEIGHT)s
QUALITY           = %(QUALITY)s

DIFFICULTY        = %(DIFFICULTY)s

NAME              = '%(NAME)s'
PASSWORD          = '%(PASSWORD)s'

SERVER_HOST      = '%(SERVER_HOST)s'
SERVER_PORT      = %(SERVER_PORT)s

MUSIC            = %(MUSIC)s
SOUND            = %(SOUND)s
ASYNC_LOAD_MUSIC = %(ASYNC_LOAD_MUSIC)s
SOUND_SYSTEM     = '%(SOUND_SYSTEM)s'
WAIT_FOR_SOUND   = %(WAIT_FOR_SOUND)s

SAVED_GAME_DIR   = '%(SAVED_GAME_DIR)s'
""" % globals())

VERSION = "0.3.3"

GUI = 0

DIFFICULTY_NEWBIE = 0
DIFFICULTY_HACKER = 1
DIFFICULTY_GURU   = 2
DIFFICULTIES = {
  _("Newbie") : 0,
  _("Hacker") : 1,
  _("Guru"  ) : 2,
  }

SERVER_VIEW = 0


MODE = ""


