//
// C++ Implementation: numberfield
//
// Description: 
//
//
// Author: Bjorn Hansen <Holomorph@users.sourceforge.net>, (C) 2005
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include <sstream>
#include "../../include/menu/numberfield.h"

using namespace Balder;
using namespace gcn;

NumberField::NumberField(int n,int maxDigits)
{
  	std::stringstream ss;
  	ss << n;
	setText(ss.str());
	setWidth(getFont()->getWidth("0")*maxDigits + 4);
	digits = maxDigits;
}

int NumberField::getValue()
{
	if (mText.size() < 1) return 0;
	std::istringstream ss(mText);
	int value;
	ss >> value;
	return value;
}

void NumberField::setValue(int n)
{
	std::stringstream ss;
  	ss << n;
	setText(ss.str());
}

void NumberField::mousePress(int x, int y, int button)
{
	if (hasMouse() && button == MouseInput::LEFT)
	{
		mCaretPosition = getFont()->getStringIndexAt(mText, x + mXScroll);
		fixScroll();
	}
}

void NumberField::keyPress(const Key& key)
{
	if (key.getValue() == Key::LEFT && mCaretPosition > 0)
    {
    	--mCaretPosition;
	}

	else if (key.getValue() == Key::RIGHT && mCaretPosition < mText.size())
	{
		++mCaretPosition;
	}

	else if (key.getValue() == Key::DELETE && mCaretPosition < mText.size())
	{
		mText.erase(mCaretPosition, 1);
	}

	else if (key.getValue() == Key::BACKSPACE && mCaretPosition > 0)
	{
		mText.erase(mCaretPosition - 1, 1);
		--mCaretPosition;
	}
	
	else if (key.getValue() == Key::ENTER)
	{
		generateAction();
	}

	else if (key.getValue() == Key::HOME)
	{
		mCaretPosition = 0;
	}    

	else if (key.getValue() == Key::END)
	{
		mCaretPosition = mText.size();
	}    

	else if (key.isNumber())
	{
		if (mText.size() < digits){
			mText.insert(mCaretPosition, std::string(1,(char)key.getValue()));
			++mCaretPosition;
		}
	}
}

void NumberField::draw(Graphics* graphics)
    {
        Color faceColor = getBackgroundColor();
        graphics->setColor(faceColor);
        graphics->fillRectangle(Rectangle(0, 0, getWidth(), getHeight()));
    
        if (hasFocus())
        {      
            drawCaret(graphics, getWidth()-getFont()->getWidth(mText.substr(mCaretPosition,mText.size())) - 4);
        }
    
        graphics->setColor(getForegroundColor());
        graphics->setFont(getFont());
        //graphics->drawText(mText, 1 - mXScroll, 1);
        graphics->drawText(mText,getWidth()-1, 0, gcn::Graphics::RIGHT);
    }
