/***************************************************************************
 *   Copyright (C) 2006 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/options.h"
#include "../../include/menu/gamesetup.h"
#include "../../include/menu/playersetup.h"
#include "../../include/menu/soundvideo.h"
#include "../../include/configmanager.h"
#include <sstream>

using namespace Balder;

OptionsMenu::OptionsMenu(gcn::Container* top, SubMenu* parent):SubMenu(top,parent)
{
    page->setDimension(gcn::Rectangle(0, 0, 500, 400));
    page->setPosition(150,200);

    backButton = new gcn::Button("Back");
    backButton->setEventId("back");
    backButton->addActionListener(this);

    std::stringstream ss;
    numPlayers = ConfigManager::GetNumPlayers();
    ss << "Number of Players: " << numPlayers;
    numPlayersLabel = new gcn::Label(ss.str());

    morePlayersButton = new gcn::Button("+");
    morePlayersButton->setEventId("morePlayers");
    morePlayersButton->addActionListener(this);
    morePlayersButton->setHeight(numPlayersLabel->getHeight()/2);

    lessPlayersButton = new gcn::Button("-");
    lessPlayersButton->setEventId("lessPlayers");
    lessPlayersButton->addActionListener(this);
    lessPlayersButton->setHeight(numPlayersLabel->getHeight()/2);
    lessPlayersButton->setWidth(morePlayersButton->getWidth());

    soundVideoButton = new gcn::Button("Sound and Video");
    soundVideoButton->setEventId("soundVideoMenu");
    soundVideoButton->addActionListener(this);
    soundVideoButton->setAlignment(0); //alignment is justified left.

    gameSetupButton = new gcn::Button("Game Setup");
    gameSetupButton->setEventId("gameSetupMenu");
    gameSetupButton->addActionListener(this);
    gameSetupButton->setWidth(soundVideoButton->getWidth());
    gameSetupButton->setAlignment(0); //alignment is justified left.

    playersButton = new gcn::Button("Player Setup");
    playersButton->setEventId("playerSetupMenu");
    playersButton->addActionListener(this);
    playersButton->setWidth(soundVideoButton->getWidth());
    playersButton->setAlignment(0); //alignment is justified left.

    // add these things to the page container
    page->add(backButton, 0, 300);
    page->add(numPlayersLabel, 0, 0);
    page->add(morePlayersButton, numPlayersLabel->getWidth(), 0);
    page->add(lessPlayersButton, numPlayersLabel->getWidth(), morePlayersButton->getHeight());
    page->add(gameSetupButton, 0, 60);
    page->add(playersButton, 0, 120);
    page->add(soundVideoButton, 0, 180);
    // create the submenus
    gameSetupMenu = new GameSetupMenu(top, this);
    playerSetupMenu = new PlayerSetupMenu(top, this);
    soundVideoMenu = new SoundVideoMenu(top, this);
}

OptionsMenu::~OptionsMenu()
{
}

void OptionsMenu::action(const std::string& action)
{
    if (action == "morePlayers")
    {
        if (numPlayers < 8)
        {
            ++numPlayers;
            std::stringstream ss;
            ss << "Number of Players: " << numPlayers;
            numPlayersLabel->setCaption(ss.str());
            ConfigManager::SetNumPlayers(numPlayers);
        }
    }
    else if (action == "lessPlayers")
    {
        if (numPlayers > 1)
        {
            --numPlayers;
            std::stringstream ss;
            ss << "Number of Players: " << numPlayers;
            numPlayersLabel->setCaption(ss.str());
            ConfigManager::SetNumPlayers(numPlayers);
        }
    }
    else if (action == "gameSetupMenu")
    {
        hide();
        gameSetupMenu->show();
    }
    else if (action == "playerSetupMenu")
    {
        hide();
        playerSetupMenu->show();
    }
    else if (action == "soundVideoMenu")
    {
        hide();
        soundVideoMenu->show();
    }
    else if (action == "back")
    {
        hide();
        ConfigManager::SaveConfigFile();
        parent->show();
    }
}
