/***************************************************************************
 *   Copyright (C) 2006 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/soundvideo.h"
#include "../../include/configmanager.h"
#include "../../include/soundmanager.h"

using namespace Balder;

SoundVideoMenu::SoundVideoMenu(gcn::Container* top, SubMenu* parent):SubMenu(top,parent)
{
    page->setDimension(gcn::Rectangle(0, 0, 500, 400));
    page->setPosition(150,200);

    backButton = new gcn::Button("Back");
    backButton->setEventId("back");
    backButton->addActionListener(this);

    fullScreenCheckbox = new gcn::CheckBox("fullscreen",
                                           ConfigManager::GetIntValue("Video", "fullscreen"));
    fullScreenCheckbox->setEventId("toggleFullscreen");
    fullScreenCheckbox->addActionListener(this);

    soundCheckbox = new gcn::CheckBox("sound", ConfigManager::GetIntValue("Sound", "sound"));
    soundCheckbox->setEventId("toggleSound");
    soundCheckbox->addActionListener(this);

    musicCheckbox = new gcn::CheckBox("music", ConfigManager::GetIntValue("Sound", "music"));
    musicCheckbox->setEventId("toggleMusic");
    musicCheckbox->addActionListener(this);

    fxVolumeLabel = new gcn::Label("    volume");
    fxVolumeSlider = new gcn::Slider();
    fxVolumeSlider->setSize(200, fxVolumeLabel->getHeight()/2);
    fxVolumeSlider->setValue(ConfigManager::GetDoubleValue("Sound", "fxvolume"));
    fxVolumeSlider->setEventId("fxVolumeChange");
    fxVolumeSlider->addActionListener(this);

    musicVolumeLabel = new gcn::Label("    volume");
    musicVolumeSlider = new gcn::Slider();
    musicVolumeSlider->setSize(200, musicVolumeLabel->getHeight()/2);
    musicVolumeSlider->setValue(ConfigManager::GetDoubleValue("Sound", "musicvolume"));
    musicVolumeSlider->setEventId("musicVolumeChange");
    musicVolumeSlider->addActionListener(this);

    page->add(backButton, 0, 300);
    page->add(fullScreenCheckbox, 0, 60);
    page->add(soundCheckbox, 0, 120);
    page->add(musicCheckbox, 0, 180);
    page->add(fxVolumeLabel, soundCheckbox->getWidth(), soundCheckbox->getY());
    page->add(fxVolumeSlider, soundCheckbox->getWidth()+fxVolumeLabel->getWidth()+10, soundCheckbox->getY());
    page->add(musicVolumeLabel, soundCheckbox->getWidth(), musicCheckbox->getY());
    page->add(musicVolumeSlider, soundCheckbox->getWidth()+fxVolumeLabel->getWidth()+10, musicCheckbox->getY());
}

SoundVideoMenu::~SoundVideoMenu()
{
}

void SoundVideoMenu::action(const std::string& action)
{
    if (action == "toggleSound")
    {
        ConfigManager::SetIntValue("Sound", "sound", soundCheckbox->isMarked());
    }
    else if (action == "toggleMusic")
    {
        ConfigManager::SetIntValue("Sound", "music", musicCheckbox->isMarked());
//        sound->PlayMusic("menu");
    }
    else if (action == "fxVolumeChange")
    {
        Mix_Volume(-1, (int)(MIX_MAX_VOLUME * fxVolumeSlider->getValue()));
        ConfigManager::SetDoubleValue("Sound", "fxvolume", fxVolumeSlider->getValue());
    }
    else if (action == "musicVolumeChange")
    {
        Mix_VolumeMusic(int(MIX_MAX_VOLUME * musicVolumeSlider->getValue()));
        ConfigManager::SetDoubleValue("Sound", "musicvolume", musicVolumeSlider->getValue());
    }
    else if (action == "toggleFullscreen")
    {
        ConfigManager::SetIntValue("Video", "fullscreen", fullScreenCheckbox->isMarked());
    }
    else if (action == "back")
    {
        hide();
        parent->show();
    }
}
