<?php

/****
 *
 * Renderer Class
 * Controls rendering of a page, static or dynamic.
 * 
 ****/	

require_once('Properties.php');
require_once('Page.php');

class Renderer {

var $prop; # the default decorator for the site.

# predefined types and filters: the order matters.
var $filters = array(
	'txt' => array('text2html','symbols'),
	'raw' => array('pre'),
	'html' => array('symbols'),
	'mod' => '',
);

function Renderer(&$prop) {
	$this->prop = &$prop;
}

function displayError($title, $contents) {
	$content = "<font color=red>Error:</font><br>$contents";
	$this->display($title, $content);
}

function display($title, &$content) {
	require_once(dirname(__FILE__) . '/decorators/common.php');

	$title = $this->prop->getGlobal('title-prefix') . $title;
	
	$decor = $this->getDecorator();
	if (is_file($decor->template)) {
		$GLOBALS['root'] = $this->prop->getGlobal('siteroot');
		$GLOBALS['decoratorurl'] = $decor->url;
		$GLOBALS['decoratorname'] = $decor->name;
		$GLOBALS['nav_hide'] = true;
		extract($GLOBALS);
		include($decor->template);
	}
	else {
		echo $content;
	}
}

function renderPage(&$page,$printable=false,$content='',$skipfilters=false) {
	require_once(dirname(__FILE__) . '/decorators/common.php');
	
	$decor = $this->getDecorator($page->get('decorator'));
	if ($content == '')
		$content = &$page->get('content');
	$title   = $page->get('title');
	$title   = $this->prop->getGlobal('title-prefix') . $title;

	if ($page->fnf) {
		$this->displayError("File not found", "That file does not exist.");
		return;	
	}

	$GLOBALS['root'] = $page->prop->getGlobal('siteroot');
	$GLOBALS['decoratorurl'] = $decor->url;
	$GLOBALS['decoratorname'] = $decor->name;
	extract($GLOBALS); // this is excessive..
		
	if (isset($this->filters[$page->type]) && !$skipfilters) {
		foreach($this->filters[$page->type] as $filter) {
			$this->applyFilter($filter, $content, $page);
		}	
	}
	
	// it is a hack to check if content is <p></p>\n
	// not sure why empty files are often that.
	if ($page->get('dir') && ($content == "<p></p>\n" || $content == '')) {
		# if index empty, return default index.
		if ($decor->index)
			include($decor->index);
		else {
			$content = $this->indexinfo($page);
			include($decor->template);
		}
	}
	elseif (!$printable && is_file($decor->template)) {
		# standard template
		include($decor->template);
	}
	else {
		# page without any template
		echo "<html>\n<head>\n<title>$title</title>\n</head>\n<body>\n";
		echo $content;
		echo "\n</body>\n</html>";
	}
}

function &getRenderedContent(&$page, $filter=true) {
	ob_start();
	$decor = $this->getDecorator($page->get('decorator'));
	$content = &$page->get('content');
	$title   = $page->get('title');
	$title   = $this->prop->getGlobal('title-prefix') . $title;

	$GLOBALS['root'] = $page->prop->getGlobal('siteroot');
	$GLOBALS['decoratorurl'] = $decor->url;
	$GLOBALS['decoratorname'] = $decor->name;
	extract($GLOBALS); // this is excessive..
		
	if (isset($this->filters[$page->type]) && $filter) {
		foreach($this->filters[$page->type] as $f) {
			$this->applyFilter($f, $content, $page);
		}	
	}
	
	// it is a hack to check if content is <p></p>\n
	// not sure why empty files are often that.
	if ($page->get('dir') && ($content == "<p></p>\n" || $content == '')) {
		# if index empty, return default index.
		if ($decor->index)
			include($decor->index);
		else {
			$content = $this->indexinfo($page);
		}
	}
	echo $content;
	$data = &ob_get_contents();
	ob_end_clean();
	return $data;
}

function style(&$page) {
	
	// send cache headers. we want the style page cached.
	$offset = 60*60*3; // 3 hours
	$expires = "Expires: " . gmdate("D, d M Y H:i:s", time() + $offset) . " GMT";
	header("Cache-Control: must-revalidate");
	header($expires);

	require_once(dirname(__FILE__) . '/decorators/common.php');
	$decor = $this->getDecorator($page->get('decorator'));
	$GLOBALS['root'] = $page->prop->getGlobal('siteroot');
	$GLOBALS['decoratorurl'] = $decor->url;
	$GLOBALS['decoratorname'] = $decor->name;
	extract($GLOBALS); // this is excessive..
	include($decor->style);
}


function applyFilter($filter, &$content,&$page) {
	include("filters/$filter.php");
	$filter_object = new $filter();
	$filter_object->apply($content,$page);
}

function getDecorator($name = '') {
	$d = new Decorator();
	if ($name == '')
		$d->name = $this->prop->getGlobal('decorator');
	else
		$d->name = $name;
		
	// try possible dirs, until we find a decorator
	// this is kinda silly, we should just decide
	// where it must go.
	
	// map url => directory
	$docroot = $this->prop->getGlobal('sitedocroot');
	$urlroot = $this->prop->getGlobal('siteroot');
	$libfile = dirname(__FILE__);
	$liburl  = $this->prop->getGlobal('liburl');
	$candidates = array(
		"$urlroot/.decorators/$d->name"  => "$docroot/.decorators/$d->name",
		"$urlroot/$d->name"  => "$docroot/$d->name",
		"$liburl/decorators/$d->name"  => "$libfile/decorators/$d->name",
	);
	foreach($candidates as $url => $dir) {
		if (is_dir($dir)) break;
	}
		 
	$d->url = $url;
	$d->template = "$dir/template.php";
	$d->style = "$dir/style.php";
	if (file_exists("$dir/index.php"))
		$d->index = "$dir/index.php";
	$d->error = "$dir/error.php";
	
	return $d;
}

function displayFnf() {
	$d = $this->getDecorator();
	if (is_file($d->error)) {
		ob_start();
		include($d->error);
		$content = &ob_get_contents();
		ob_end_clean();
	}
	else {
		$content = "<p>404 File not found</p><p>The web page you seek<br />Cannot be located, but<br />Countless more exist.</p>";
	}
	$this->display("File not found", $content);
}

function indexinfo(&$page) {
	$children = $page->children();
	foreach($children as $child) {
		$ret .= "<dl class=index>\n";
		$ret .= "<dt>" . alink($child->path .'/',$child->get('title')) . "</dt>\n";
		$ret .= "<dd>" . $child->get('description') . "</dd>\n";
		$ret .= "</dl>\n";
	}
	return $ret;
}


} // end class

class Decorator {
	var $index;
	var $style;
	var $template;
	var $name;
	var $url;	
}


?>