<?php

class d {

function log($str) {
	static $count = 0;
	error_log($count++ . " " . $str);
}

function logv($var, $label) {
	d::log(d::str($var, $label));
}

// returns a debug string. 

function str($var, $string = '') {
    $out = "";
    // TRUE, FALSE, NULL and empty arrays: return this value
    if($var === true) {
        $out .= htmlentities($string . ' = TRUE;') . "\n";
    } else if($var === false) {
        $out .= htmlentities($string . ' = FALSE;') . "\n";
    } else if($var === null) {
        $out .= htmlentities($string . ' = NULL;') . "\n";
    } else if($var === array()) {
        $out .= htmlentities($string . ' = array();') . "\n";
    // array or object - foreach element of $var
    } else if ( is_array( $var ) || is_object($var) ) {
        foreach($var as $k=>$v) {
            // Format the string which stands next to the ' = '.
            // [] for arrays and -> for objects
            if(is_array($var)) {
                if(is_string($k)) {
                    $k = "'" . str_replace('\"', '"',
                           addslashes($k)) . "'";
                }
                $new_string = $string . '[' . $k . ']';
            } else if(is_object($var)) {
                $new_string = $string . '->' . $k;
            }
            // dive
            $out .= d::str($v, $new_string);
        }
    // not object, not array
    } else {
        // Format as a string if it is one
        if(is_string($var)) {
            $var = "'" . str_replace('\"', '"',
                     addslashes($var)) . "'";
        }
        if ($string) $string .= ' = ';
        $out .= htmlentities($string . $var) . ";\n";
    }
    return $out;
}

function stack() {
	if (PHPVERSION() < 4.3) return;
	$s = '';

	$MAXSTRLEN = 64;
	$s = '<pre align=left>';
	$traceArr = debug_backtrace();
	array_shift($traceArr);
	$tabs = sizeof($traceArr)-1;
	foreach ($traceArr as $arr) {
		for ($i=0; $i < $tabs; $i++) $s .= ' &nbsp; ';
		$tabs -= 1;
		$s .= '<font face="Courier New,Courier">';
		if (isset($arr['class'])) $s .= $arr['class'].'.';
		foreach($arr['args'] as $v) {
			if (is_null($v)) $args[] = 'null';
			else if (is_array($v)) $args[] = 'Array['.sizeof($v).']';
			else if (is_object($v)) $args[] = 'Object:'.get_class($v);
			else if (is_bool($v)) $args[] = $v ? 'true' : 'false';
			else {
				$v = (string) @$v;
				$str = htmlspecialchars(substr($v,0,$MAXSTRLEN));
				if (strlen($v) > $MAXSTRLEN) $str .= '...';
				$args[] = $str;
			}
		}
		$s .= $arr['function'].'('.implode(', ',$args).')';
		$s .= sprintf("</font><font color=#808080 size=-1> # line %4d,".  " file: <a href=\"file:/%s\">%s</a></font>",  $arr['line'],$arr['file'],$arr['file']);
		$s .= "\n";
	}
	$s .= '</pre>';
	print $s;
	die();
}

function stackstr() {
	if (PHPVERSION() < 4.3) return;
	$s = '';
	$traceArr = debug_backtrace();
	array_shift($traceArr);
	for($i=count($traceArr)-1; $i>=0; $i--) {
		if (isset($traceArr[$i]['class']))
			$s .= $traceArr[$i]['class'] . "::";
		$s .= $traceArr[$i]['function'] . '() > ';
	}
	return $s;
}

// a delayed debug which can be used to overlay at the end
// a floating debug layer. 
function overlay($var = ' not set ') {
	static $html;

	if ($var == ' not set ') {
		return $html;
	}
	else {
		ob_start();
			echo "<div class=subdebug><pre>";
			if (isset($var))
				print_r($var);
			else
				echo "Error: variable not set";
			echo "</pre></div>";
			$contents = &ob_get_contents();
			$html .= $contents;
		ob_end_clean();
	}
}

function printr($var) {
	echo "<div class=debug><pre>";
	print_r($var);
	echo "</pre></div>";
}

function printvar($var,$label) {
	echo "<br>";
	echo d::str($var, $label);
}

}
?>