<?php

// 
// This file is the front door entry point to all pages.
//

require_once('debug.php');
require_once('Page.php');
require_once('FSPageStore.php');
require_once('Properties.php');
require_once('Auth.php');
require_once('Renderer.php');
require_once('PageNav.php');
require_once('Search.php');
require_once('HttpUtil.php');

$prop     = new Properties(get_site_config());
$ps       = new FSPageStore($prop);
$page     = $ps->getPage($_SERVER['REQUEST_URI']);
$renderer = new Renderer($prop);
$nav      = new PageNav($prop);
$auth     = new Auth($prop->getGlobal('authbackend'));
$search   = new Search($prop->getGlobal('sitedocroot') . '/.search');

$action     = isset($_REQUEST['action']) ? $_REQUEST['action'] : 'view';
$authaction = isset($_REQUEST['auth'])   ? $_REQUEST['auth']   : '';
$query      = preg_replace("'.*\?(.*)$'",'$1',$_SERVER['REQUEST_URI']);
$root 		= $prop->getGlobal('siteroot');

if ($page->fnf) {
	$path = $search->findClosestPage(basename($page->path),$page->path);
	if ($path)
		http::redirect("$root$path");
	else
		$renderer->displayFnf();
	return;
}

if ($action == 'style') {
	$renderer->style($page); // style does not require auth
	return;
}

$auth->init();
if ($authaction == 'logout') {
	startsession();
	$auth->logout();
}
elseif ($authaction == 'login') {
	startsession();
	$ok = $auth->login($error);
	if (!$ok) {
		$renderer->display('login', $auth->getLoginForm($prop->getGlobal('sitename'), $error));
		return;
	}
}

if (!$page->may('anonymous',$action)) {
	startsession();
	$username = $auth->username();
	if ($username == '') {
		$renderer->display('login', $auth->getLoginForm($prop->getGlobal('sitename')));
		return;
	}
	elseif (!$page->may($username,$action)) {
		$renderer->displayError('Permission Denied', 'You do not have permission to do that');
		return;
	}
}

## LANGUAGE ##

if (isset($_REQUEST['lang'])) {
	startsession();
	set_lang($_REQUEST['lang']);
}
else {
	startsession();
}

## EDITOR ##

if ($action == 'edit' || $query == 'edit') {
	startsession();
	require_once("Editor.php");
	$editor = new Editor($prop);
	$action = $editor->handleRequest($page);
	if ($action == '')
		return; // $editor handled the request and finished
}

## SEARCH ##

$s = get('s');
if ($s) {
	$result = $search->findByContent($s,$ps);
	if ($result == '')
		$result = _("no search results found.");
	$renderer->renderPage($page,false,$result,true);
	return;
}

## ACTIONS ##

if ($action == 'source') {
	echo "<pre>";
	echo htmlspecialchars($page->get('content'));
	echo "</pre>";
}
elseif($action == 'print') {
	$renderer->renderPage($page,true);
}
elseif ($action == 'view') {
	if ($page->static) {
		require_once('Cache.php');
		$cache = new Cache($prop->getGlobal('cachedir'), $prop->getGlobal('siteroot'));
		if ($cache->time($page->path) < $page->mtime) {
			$cache->begin($page->path);
				$renderer->renderPage($page);
			$cache->end();
		}
		$cache->echofile($page->path);
	}
	else {
		# dynamic module code here...
	}
}
elseif ($action == 'reindex') {
	$search->clear();
	$search->indexTree($page);
	$renderer->display( _("index"), _("index created") );
}
elseif ($action == 'indexdebug') {
	$search->dump();
}
elseif ($action == 'deindex') {
	$search->clear();
}
elseif ( $action == 'changes' ) {
	require_once 'Changes.php';
	$changes = new Changes($page);
	if ( get('mode') == 'rss' ) {
		$page->set('decorator', 'rss');
		# set globals for decorator/rss
		$changes->resultsRss();
	}
	else {
		$results = $changes->results();
	}
	$renderer->renderPage($page,false,$results,true);	
}
else {
	die("an error occurred: unknown action $action");
}

return;

/// functions ///

// so we only call session_start() once
function startsession() {
	static $ses_set = false;
	if (!$ses_set) {
		session_start();
		$ses_set = true;
	}
}

?>