/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ADDITEMDIALOG_H
#define ADDITEMDIALOG_H

#include <qwidget.h>
#include <qdialog.h>
#include <kdialogbase.h>
#include <qptrlist.h>

#include "variouswidgets.h"

class QRadioButton;
class KIntNumInput;
class QPushButton;
class QCheckBox;
class QSize;

class Basket;
class Item;

/**A widget that the user resize to graphically choose a new image size
  *@author Sbastien Laot
  */
class ViewSizeDialog : public QDialog
{
  Q_OBJECT
  public:
	ViewSizeDialog(QWidget *parent, int w, int h);
	~ViewSizeDialog();
  private:
	virtual void resizeEvent(QResizeEvent *);
};

/**Widget to select a type of new item
  *@author Sbastien Laot
  */
class AddItemWidget : public QWidget
{
  Q_OBJECT
  public:
	AddItemWidget(QWidget *parent = 0, const char *name = 0, WFlags f = 0);
	~AddItemWidget();
	int selected();
	QSize imageSize();
	int iconSize();

  private slots:
	void toggled(bool on);
	void visualize();
	void activateImageOption(int i = 0);
	void activateLauncherOption(bool);
	void activateImportOption(int);

  private:
	QPtrList<QRadioButton>   m_options;
	KIntNumInput            *m_imgSizeX;
	KIntNumInput            *m_imgSizeY;
	QPushButton             *m_pushVisualize;
	IconSizeCombo           *m_iconSize;
  public:
	QCheckBox               *m_nameInAnnots;
};

/**Dialog to create a new item :
  *First ask type and create it
  *@author Sbastien Laot
  */
class AddItemDialog : public KDialogBase
{
  Q_OBJECT
  public:
	AddItemDialog(Basket *parent, const QString &caption);
	~AddItemDialog();
  protected slots:
	virtual void slotOk();
	Item* appLauncher(bool nameInAnnots);
	Item* importIcon();
  private:
	Basket        *m_basket;
	AddItemWidget *m_widget;
};

#endif // ADDITEMDIALOG_H
