/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastient.laout@tuxfamily.org                                        *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ITEMDRAG_H
#define ITEMDRAG_H

#include <qdragobject.h>
#include <qstring.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <kurl.h>

#include "item.h"

class Basket;

/**QDragObject to drag and drop Items
  *@author Sbastien Laot
  */
class ItemDrag : public QDragObject
{
  Q_OBJECT
  public:
	ItemDrag(/*const */Item &item, QWidget *parent = 0, const char *name = 0);
	~ItemDrag();
	void         setItem(/*const */Item &item);
	const char*  format(int i) const;
	QByteArray   encodedData(const char *mimeType) const;
	static bool  canDecode(QMimeSource *source);
	static Item* decode(QMimeSource *source, Basket *parent);
  private:
	QByteArray   encodedItem() const;
	QDragObject* contentDrag() const;

	/* Variables to handle item type and global properties */
	Item::ContentType m_type;
	bool              m_isChecked;
	QString           m_annotations;
	QString           m_runCommand;

	/* Special variables to handle contents by type */
	QString m_text;
	int     m_textFontType;
	bool    m_showSource;
	QPixmap m_pixmap;
	QColor  m_color;
	KURL    m_url;
	QString m_title;
	QString m_icon;
	bool    m_autoTitle;
	bool    m_autoIcon;

	/* Have a QDragObject of the content too */
	QDragObject *m_object;

  public:
	static const char * const item_mime_string;
	static const char * const text_mime_string;
	static const char * const color_mime_string;
};

#endif // ITEMDRAG_H
