// -*- Mode: C++; c-basic-offset: 4; indent-tabs-mode: nil; tab-width: 8; -*-
/* This file is part of the KDE project
   Copyright (C) 2003 by Lubos Lunak <l.lunak@kde.org>

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

/** This class was took from Klipper (version in KDE 3.4)
  * because it's exactly what's needed for clipboard manager baskets.
  *
  * A singleton model has however been added!
  */

#ifndef _CLIPBOARDPOLL_H_
#define _CLIPBOARDPOLL_H_

#include <qwidget.h>
#include <qtimer.h>
#include <X11/Xlib.h>
#include <fixx11h.h>

class ClipboardPoll
    : public QWidget
    {
    Q_OBJECT
    public:
        ClipboardPoll( QWidget* parent );
/** Added: */
        static ClipboardPoll* instance();
        void updateTimestamp(); // Should be private
/** ****** */
    signals:
        void clipboardChanged( bool selectionMode );
    protected:
        virtual bool x11Event( XEvent* );
    private slots:
        void timeout();
    private:
        struct SelectionData
        {
            Atom atom;
            Atom sentinel_atom;
            Atom timestamp_atom;
            Window last_owner;
            bool owner_is_qt;
            Time last_change;
            bool waiting_for_timestamp;
            Time waiting_x_time;
        };
        void updateQtOwnership( SelectionData& data );
        bool checkTimestamp( SelectionData& data );
        bool changedTimestamp( SelectionData& data, const XEvent& e );
        QTimer timer;
        SelectionData selection;
        SelectionData clipboard;
        Atom xa_clipboard;
        Atom xa_timestamp;
    };

#endif
