/***************************************************************************
 *   Copyright (C) 2003 by Sbastien Laot                                 *
 *   sebastien.laout@tuxfamily.org                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef ONCLICKACTION_H
#define ONCLICKACTION_H

#include <qcombobox.h>
#include <kdialogbase.h>
#include <qnamespace.h>

class QWidget;

class Basket;
class Item;

/**Some OnClickAction related functions
  *@author Sbastien Laot
  */

namespace OnClickAction
{
	enum Action { NoAction, Copy, CopyToSel, Edit, EditAnnot, Open, OpenWith };

	void    startHoverFeedback(Item *item);
	void    stopHoverFeedback();
	void    feedbackShiftCursor(bool shiftPressed);

/*	int     whichCopy(bool shiftPressed);
	QString whichCopyName(bool shiftPressed);*/
	Action  whichCopyAction(bool shiftPressed);
	Action  actionForButton(Qt::ButtonState state, int policy);
}

/**The widget that allow to edit items on clic policy.
  *@author Sbastien Laot
  */

/*class OnClickActionCombo : public QComboBox
{
  Q_OBJECT
  public:
	OnClickActionCombo(int action, QWidget *parent = 0, const char *name = 0);
	~OnClickActionCombo();
};*/

#endif // ONCLICKACTION_H
