/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* $Id: PDFRendererMaker.java 542237 2007-05-28 14:31:24Z jeremias $ */

package org.apache.fop.render.pdf;

import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.MimeConstants;
import org.apache.fop.render.AbstractRendererMaker;
import org.apache.fop.render.Renderer;
import org.apache.fop.render.RendererConfigurator;

/**
 * RendererMaker for the PDF Renderer.
 */
public class PDFRendererMaker extends AbstractRendererMaker {

    private static final String[] MIMES = new String[] {MimeConstants.MIME_PDF};
    
    /** @see org.apache.fop.render.AbstractRendererMaker#makeRenderer(FOUserAgent) */
    public Renderer makeRenderer(FOUserAgent userAgent) {
        return new PDFRenderer();
    }

    /** @see org.apache.fop.render.AbstractRendererMaker#getConfigurator(FOUserAgent) */
    public RendererConfigurator getConfigurator(FOUserAgent userAgent) {
        return new PDFRendererConfigurator(userAgent);
    }
    
    /** @see org.apache.fop.render.AbstractRendererMaker#needsOutputStream() */
    public boolean needsOutputStream() {
        return true;
    }

    /** @see org.apache.fop.render.AbstractRendererMaker#getSupportedMimeTypes() */
    public String[] getSupportedMimeTypes() {
        return MIMES;
    }

}
