/* unit-cmd-diff.c
 *
 ****************************************************************
 * Copyright (C) 2004, Canonical Limited
 *               Author: Robert Collins
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "hackerlab/vu/reserv.h"
#include "hackerlab/cmd/main.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/bugs/exception.h"
#include "hackerlab/char/str.h"
#include "commands/diff.h"



/* typedefs */



/* local methods */



int
main (int argc, char * argv[])
{
  t_uchar * result = arch_diff_default_output_dir (NULL, "/a/tree/root", ",,what-changed.cat--branch-0.1.2--example@example.com");
  safe_printfmt(1, "We got: %s\n", result);
  invariant(!str_cmp(result, "/a/tree/root/,,what-changed.cat--branch-0.1.2--example@example.com"));
  talloc_free (result);
  return 0;
}

