/* file-offset-mapper.h:
 *
 * vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
 ****************************************************************
 * Copyright (C) 2005 Canonical Limited
 * 	Authors: Robert Collins <robert.collins@canonical.com>
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__FILE_OFFSET_MAPPER_H
#define INCLUDE__LIBARCH__FILE_OFFSET_MAPPER_H

#include "hackerlab/arrays/ar.h"

typedef struct file_offset_map_entry_
{
    int from;
    int to;
    int length;
} file_offset_map_entry_t;

extern void file_offset_map_entry_init (file_offset_map_entry_t * entry, int from, int to, int length);

AR_TYPEDEF(file_offset_map_entry_t, file_offset_map_entry);

/**
 * \brief this struct allows one to process patch unks in reverse time sequence.
 * given a patch you should all subtract for each subtraction you see in a hunk, and
 * add for each addtion. When you see a subtraction or no-op line you should increment
 * the line number you are calling with. The following table shows the line index you 
 * should you for a hypothetical patch hunk:
 * ==
 * -0,6 +0,7
 * 0 -
 * 1 -
 * 2 -
 * 3 +
 * 3 +
 * 3 -
 * 4 +
 * 4 
 * 5 -
 * 6 +
 * 6
 * 7 +
 *===
 */
typedef struct file_offset_mapper_
{
    ar_file_offset_map_entry map;
} file_offset_mapper_t;

extern void file_offset_mapper_init (file_offset_mapper_t *mapper, int lines);
extern void file_offset_mapper_finalise (file_offset_mapper_t *mapper);
extern void file_offset_mapper_subtract (file_offset_mapper_t *mapper, int line);
extern void file_offset_mapper_add (file_offset_mapper_t *mapper, int line);
extern int file_offset_mapper_map (file_offset_mapper_t *mapper, int line);
extern void file_offset_mapper_print(int fd, file_offset_mapper_t *mapper);

#endif /* INCLUDE__LIBARCH__FILE_OFFSET_MAPPER_H */
