#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# vim:smartindent ts=8:sts=2:sta:et:ai:shiftwidth=2
# branch listing
# Copyright © 2004 Canonical Ltd.
#       Authors: Robert Collins <robert.collins@canonical.com>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_archives

test_class "revisions"

begin_test "branches in a tree, no arguments"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
#we want to see two branches
tla branch hello-world--other--1.0
test "$(tla branches)" = "hello-world--mainline
hello-world--other" || test_fail "incorrect branch listing: '$(tla branches)'"
end_test 

clean_workdir
