#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Simple branching tests
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_with_trivial_tla_archives

test_class "commit"

begin_test "commit with no log, no EDITOR set leaves no log"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
touch new-file
tla add new-file
[ -n "$EDITOR" ] && unset EDITOR
tla commit && test_fail "unexpected commit success"
test -f ++log.hello-world--mainline--1.0--jane@example.com--2003 && test_fail "log file created"
cd ..
end_test 

begin_test "commit --just-commit doesn't do other operations"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
tla commit --just-commit -s 'succeed' || test_fail "failed to commit"
test -f ${ARCHIVEDIR}/jane-archive/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-1/hello-world--mainline--1.0--patch-1.tar.gz && test_fail "cached revision created with --just-commit"
test -f ${ARCHIVEDIR}/jane-archive/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-1/ancestry.gz && test_fail "ancestry file created with --just-commit"
cd ..
end_test 

begin_test "commit to a signed archive with bad rule/failed password doesn't lock the revision"
tla change-archive --add-signatures jane@example.com--2003 || test_fail "failed to add signatures"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo || test_fail "failed to checkout tree"
touch $(tla whereis-archive jane@example.com--2003|sed s/cached://)/\=meta-info/signed-archive || test_fail "failed to touch signed flag"
mkdir -p $HOME/.arch-params/signing
echo "true" > $HOME/.arch-params/signing/\=default.check
cd foo
touch new-file
tla add new-file
echo "gpg_command=false" >> $HOME/.arch-params/archives/jane@example.com--2003
tla commit -s 'fail' && test_fail "unexpected success"
echo "gpg_command=" >> $HOME/.arch-params/archives/jane@example.com--2003
tla commit -s 'succeed' || test_fail "failed to commit with trivial signing rule"
cd ..
tla change-archive --remove-signatures jane@example.com--2003
end_test 


begin_test "commit uploads an ancestry.gz file"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
touch new-forancestry
tla add new-forancestry
[ -n "$EDITOR" ] && unset EDITOR
tla commit -s 'do it man' || test_fail "unexpected commit failure"
test -f ${ARCHIVEDIR}/jane-archive/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-3/ancestry.gz || test_fail "no ancestry file created"
test -f ${ARCHIVEDIR}/jane-archive/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-3/ancestry.gz.checksum || test_fail "no ancestry checksum created"
test "$(gunzip -c $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-3/ancestry.gz)" = "$(echo -e 'arch ancestry version 1\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--patch-3\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--patch-2\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--patch-1\narch:patch:jane@example.com--2003/hello-world--mainline--1.0--base-0')" 
cd ..
tla get jane@example.com--2003/hello-world--mainline--1.0 bar
end_test 

begin_test "commit -b VERSION works"
tla branch jane@example.com--2003/hello-world--mainline--1.0 jane@example.com--2003/hello-world--devo--1.0
tla get jane@example.com--2003/hello-world--devo--1.0 foo
cd foo
tla commit -s 'VERSION' -b jane@example.com--2003/hello-world--mainline--1.0  || test_fail "failed to commit new from jane@example.com--2003/hello-world--devo--1.0 to jane@example.com--2003/hello-world--mainline--1.0"
test -f $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-4/log || test_fail "jane@example.com--2003/hello-world--mainline--1.0--patch-4 was not created"
cd ..
end_test 

begin_test "commit -b VERSION works with a non-setup tree-version"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
tla tree-version jane@example.com--2003-missing/hello-world--foobar--1.0
tla commit -s 'VERSION' -b jane@example.com--2003/hello-world--mainline--1.0  || test_fail "failed to commit new from jane@example.com--2003-missing/hello-world--foobar--1.0 to jane@example.com--2003/hello-world--mainline--1.0"
test -f $(tla whereis-archive jane@example.com--2003|sed s/cached://)/hello-world/hello-world--mainline/hello-world--mainline--1.0/patch-5/log || test_fail "jane@example.com--2003/hello-world--mainline--1.0--patch-5 was not created"
cd ..
end_test 

begin_test "commit works with an inaccessible archive in the ancestry"
tla get jane@example.com--2003/hello-world--mainline--1.0 foo
cd foo
tla branch foo@example.org--2003/hello-world--1.0
#make jane@example.com--2003 unreachable
LOC=$(tla whereis-archive jane@example.com--2003)
echo url=sftp://fake@fake.t/foo/bar > $HOME/.arch-params/archives/jane@example.com--2003
tla commit -s 'blah' || test_fail "commit failed"
test -z "$(tla missing)" || test_fail "commit did not update the working tree"
echo url=${LOC} > $HOME/.arch-params/archives/jane@example.com--2003
cd ..
end_test 

clean_workdir
