# install-locale.mk: install locale
#
################################################################
# Copyright (C) 2004 Tez Kamihira
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
#
# This file is derived from Tom Lord's "install-programs.mk".
# 



ifndef install-locale-mk
install-locale-mk	:= 1

machine_objs_bases		:=	$(basename $(machine_objs))

# Already set upon entry (see also "locale.mk"):
#
#	$(machine_objs)	the file-names (no directories) of the *.mo files.
#
# After installation, the build directory will contain "Installed-locales"
# which is a list of the locales that were installed.
#

include $(makefiles)/rules.mk

install:	install-locales Installed-locales

install-locales Installed-locales: $(machine_objs)
ifdef machine_objs
	$(foreach v,$(machine_objs_bases),test ! -e $(locale-install-dir)/$(v)/LC_MESSAGES/$(package_name).mo || rm -f $(locale-install-dir)/$(v)/LC_MESSAGES/$(package_name).mo;)
	$(foreach v,$(machine_objs_bases),mkdir -p $(locale-install-dir)/$(v)/LC_MESSAGES;)
	$(foreach v,$(machine_objs_bases),cp $(v).mo $(locale-install-dir)/$(v)/LC_MESSAGES/$(package_name).mo;)
endif
	echo $(machine_objs) | sed -f $(makefiles)/column.sed > Installed-locales

clean: clean-install-locales

clean-install-locales:
	test ! -e Installed-locales || rm Installed-locales

endif

# arch-tag: Tez Kamihira Mon Jun 14 13:15:53 JST 2004 (install-locale.mk)
#
