/***************************************************************************
                         -- color.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include <qhgroupbox.h>
#include <qlabel.h>
#include <qcolordialog.h>
#include <qpalette.h>
#include <qlayout.h>

#include "color.h"

// ColorButton class implementation
ColorButton::ColorButton( QWidget *parent, const char *name )
		: QPushButton( parent, name )
{
	setFixedSize( 80, 30 );
	setBackgroundMode( QWidget::PaletteButton );

	connect( this, SIGNAL(clicked()), this, SLOT(doColorSelect()));
}

void ColorButton::setColor( QColor c )
{
	if ( c.isValid() )
	{
		color = c;
		setPalette( QPalette( c ) );	
		changed();
	}
}

QString ColorButton::getColorString() const
{
	QString s;
	s.sprintf( "%02x%02x%02x", color.red(), color.green(), color.blue() );
	return s;
}

void ColorButton::doColorSelect()
{
	QColor c = getColor();
	
	c = QColorDialog::getColor( c ); 
	
	if ( c.isValid() )
	{
		setColor( c );
	}
}


// ColorSelector class implementation.
ColorSelector::ColorSelector( QWidget *parent, const char *name )
		: QHGroupBox( parent, name)
{
	button = new ColorButton( this );

	(void) new QLabel( "  #", this);
	lineedit = new QLineEdit( this );
	lineedit->setMaxLength( 6 );	// ie. #[a0a0a0]
	connect( lineedit, SIGNAL(textChanged( const QString & )),
			   	this, SLOT(colorTextChanged( const QString & )) );
	
	setMinimumSize(minimumSizeHint());
	/*
	setMinimumWidth( button->width() + lineedit->width() );
	setMinimumHeight( button->height() );
	*/

}

ColorSelector::~ColorSelector()
{
	delete button;
	delete lineedit;
}

QString ColorSelector::getColorString() const
{
	return button->getColorString();
}


void ColorSelector::colorTextChanged( const QString &string )
{
	QColor c;
	QString newString = string;
	newString.prepend( '#' );
	c.setNamedColor( newString );

	if ( button->getColor() == c || string.length() != 6 )
		return;
	
	button->setColor( c );
}

void ColorSelector::setColor( QColor c )
{
	button->setColor( c );
	lineedit->setText( button->getColorString() );
}

void ColorSelector::disable( bool on )
{
	button->setEnabled( on );
	lineedit->setEnabled( on );
}
