#!/bin/sh

usage() 
{
echo "
	This file is meant to be run from a ui directory directly underneath the
	directory that will hold the resultant base and implementation class
	files....  We only keep one of these buggers around to eliminate
	maintaining duplicate code.  So... since there aren't any *.ui
	files in this directory, I'm exitting out.  Try running me from a
	directory with some designer files and it'll work much better.  =:)
"
}

test=`ls *.ui >/dev/null 2>&1`
if [ "$?" -ne "0" ] ; then
	usage
	exit
fi

HEADER_EXT="h"
SOURCE_EXT="cc"

cd ..

for i in ui/*.ui; do
	UI=`echo $i | sed -e "s/^ui\///"`
	IMP=`echo $UI|sed -e "s/_base.ui$//"`
	C=`echo $UI|sed -e "s/.ui$/.$SOURCE_EXT/"`
	H=`echo $UI|sed -e "s/.ui$/.$HEADER_EXT/"`
	if [ ui/$UI -nt $H ]
	then
		echo "creating files from ui->ui/$UI<-"
		uic -o $H ui/$UI
		uic -i $H -o $C ui/$UI

		if [ ! -s $IMP.$HEADER_EXT ]; then
			impl_class="`cat $H | grep class | grep public | cut -f2 -d\ | sed 's/Base//'`"
			H_IMPL="$IMP.$HEADER_EXT"
			C_IMPL="$IMP.$SOURCE_EXT"
			uic -o $H_IMPL -subdecl $impl_class $H ui/$UI
			uic -o $C_IMPL -subimpl $impl_class $H_IMPL ui/$UI
		else
			echo "implementation files for $UI already exist"
		fi
	else
		echo "skipping ui/$UI"
	fi
done
