
/**
 ** Generated data (by mkcproc.pl)
 **/
#line 1 "bsedatapocket.proc"

#include        <bse/bseplugin.h>
#include        <bse/bseprocedure.h>
#include        <bse/bsedatapocket.h>


#line 25 "bsedatapocket.proc"


/* --- create-entry --- */
static void
create_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 27 "bsedatapocket.proc"
 {
#line 30 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 34 "bsedatapocket.proc"
}  }
static BseErrorType
#line 34 "bsedatapocket.proc"
create_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 37 "bsedatapocket.proc"
{
#line 38 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id;
  
#line 42 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 46 "bsedatapocket.proc"
  
  id = _bse_data_pocket_create_entry (pocket);
  
#line 49 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, id);
  
  return BSE_ERROR_NONE;
}

/* --- delete-entry --- */
static void
delete_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 55 "bsedatapocket.proc"
 {
#line 57 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 64 "bsedatapocket.proc"
}  }
static BseErrorType
#line 64 "bsedatapocket.proc"
delete_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 67 "bsedatapocket.proc"
{
#line 68 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gboolean fail = TRUE;
  
#line 73 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 77 "bsedatapocket.proc"
  
  if (id)
    fail = _bse_data_pocket_delete_entry (pocket, id);
  
#line 81 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, fail ? BSE_ERROR_NO_ENTRY : BSE_ERROR_NONE);
  
  return BSE_ERROR_NONE;
}

/* --- get-n-entries --- */
static void
get_n_entries_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 87 "bsedatapocket.proc"
 {
#line 89 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("n_entries", "N Entries", "The number of entries in use",
			 1, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 93 "bsedatapocket.proc"
}  }
static BseErrorType
#line 93 "bsedatapocket.proc"
get_n_entries_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 96 "bsedatapocket.proc"
{
#line 97 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  
#line 100 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 104 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, pocket->n_entries);
  
  return BSE_ERROR_NONE;
}

/* --- get-nth-entry-id --- */
static void
get_nth_entry_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 110 "bsedatapocket.proc"
 {
#line 112 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_index", "Entry Index", "index into number of entries present",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID (or 0 if there's no such entry)",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 118 "bsedatapocket.proc"
}  }
static BseErrorType
#line 118 "bsedatapocket.proc"
get_nth_entry_id_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 121 "bsedatapocket.proc"
{
#line 122 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint index           = sfi_value_get_int (in_values++);
  
#line 126 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 130 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, index < pocket->n_entries ? pocket->entries[index].id : 0);
  
  return BSE_ERROR_NONE;
}

/* --- set-float --- */
static void
set_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 136 "bsedatapocket.proc"
 {
#line 140 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("number", "Number", "The value to store in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 151 "bsedatapocket.proc"
}  }
static BseErrorType
#line 151 "bsedatapocket.proc"
set_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 154 "bsedatapocket.proc"
{
#line 155 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gfloat v_float        = sfi_value_get_real (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 163 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 167 "bsedatapocket.proc"
  
  value.v_float = v_float;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_FLOAT, value);
  
#line 172 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-int --- */
static void
set_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 178 "bsedatapocket.proc"
 {
#line 182 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("number", "Number", "The value to store in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 193 "bsedatapocket.proc"
}  }
static BseErrorType
#line 193 "bsedatapocket.proc"
set_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 196 "bsedatapocket.proc"
{
#line 197 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  guint v_uint          = sfi_value_get_int (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 205 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 209 "bsedatapocket.proc"
  
  value.v_int = v_uint;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_INT, value);
  
#line 214 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-object --- */
static void
set_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 220 "bsedatapocket.proc"
 {
#line 224 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "The value to store in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 235 "bsedatapocket.proc"
}  }
static BseErrorType
#line 235 "bsedatapocket.proc"
set_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 238 "bsedatapocket.proc"
{
#line 239 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseItem *v_object     = bse_value_get_object (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 247 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket) ||
      (v_object && !bse_item_common_ancestor ((BseItem*) pocket, v_object)))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 252 "bsedatapocket.proc"
  
  value.v_object = v_object;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_OBJECT, value);
  
#line 257 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- set-string --- */
static void
set_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 263 "bsedatapocket.proc"
 {
#line 265 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("string", "String", "The value to store in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 276 "bsedatapocket.proc"
}  }
static BseErrorType
#line 276 "bsedatapocket.proc"
set_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 279 "bsedatapocket.proc"
{
#line 280 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  gchar *v_string       = sfi_value_get_string (in_values++);
  BseDataPocketValue value;
  gboolean success = FALSE;
  
#line 288 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 292 "bsedatapocket.proc"
  
  value.v_string = v_string;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_STRING, value);
  
#line 297 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  
  return BSE_ERROR_NONE;
}

/* --- get-float --- */
static void
get_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 303 "bsedatapocket.proc"
 {
#line 305 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_real ("number", "Number", "The value stored in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
#line 313 "bsedatapocket.proc"
}  }
static BseErrorType
#line 313 "bsedatapocket.proc"
get_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 316 "bsedatapocket.proc"
{
#line 317 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 324 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 328 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 331 "bsedatapocket.proc"
  
  sfi_value_set_real (out_values++, type == BSE_DATA_POCKET_FLOAT ? value.v_float : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-int --- */
static void
get_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 337 "bsedatapocket.proc"
 {
#line 339 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("number", "Number", "The value stored in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 347 "bsedatapocket.proc"
}  }
static BseErrorType
#line 347 "bsedatapocket.proc"
get_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 350 "bsedatapocket.proc"
{
#line 351 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 358 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 362 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 365 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, type == BSE_DATA_POCKET_INT ? value.v_int : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-object --- */
static void
get_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 371 "bsedatapocket.proc"
 {
#line 373 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The value stored in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 381 "bsedatapocket.proc"
}  }
static BseErrorType
#line 381 "bsedatapocket.proc"
get_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 384 "bsedatapocket.proc"
{
#line 385 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 392 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 396 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 399 "bsedatapocket.proc"
  
  bse_value_set_object (out_values++, type == BSE_DATA_POCKET_OBJECT ? value.v_object : 0);
  
  return BSE_ERROR_NONE;
}

/* --- get-string --- */
static void
get_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 405 "bsedatapocket.proc"
 {
#line 407 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", "String", "The value stored in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
#line 415 "bsedatapocket.proc"
}  }
static BseErrorType
#line 415 "bsedatapocket.proc"
get_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 418 "bsedatapocket.proc"
{
#line 419 "bsedatapocket.proc"
  
  BseDataPocket *pocket = bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  gchar *name           = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
  
#line 426 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 430 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
  
#line 433 "bsedatapocket.proc"
  
  sfi_value_set_string (out_values++, type == BSE_DATA_POCKET_STRING ? value.v_string : 0);
  
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Create a new entry in a data pocket. "
	   "Entries have a unique ID which is required to set values in a data pocket.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_entry = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+create-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Create Entry",
    NULL,
    __enode_create_entry__fill_strings,
  },
  0, create_entry_setup, create_entry_exec, 
};
static void
__enode_delete_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete an existing entry from a data pocket";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_delete_entry = {
  { (BseExportNode*) &__enode_create_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+delete-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Delete Entry",
    NULL,
    __enode_delete_entry__fill_strings,
  },
  0, delete_entry_setup, delete_entry_exec, 
};
static void
__enode_get_n_entries__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of entries created in a data pocket.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_n_entries = {
  { (BseExportNode*) &__enode_delete_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-n-entries", 
    NULL,
    "/Methods/BseDataPocket/General/Get N Entries",
    NULL,
    __enode_get_n_entries__fill_strings,
  },
  0, get_n_entries_setup, get_n_entries_exec, 
};
static void
__enode_get_nth_entry_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the ID of an entry in the data pocket by sequential index.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_nth_entry_id = {
  { (BseExportNode*) &__enode_get_n_entries, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-nth-entry-id", 
    NULL,
    "/Methods/BseDataPocket/General/Get Nth Entry Id",
    NULL,
    __enode_get_nth_entry_id__fill_strings,
  },
  0, get_nth_entry_id_setup, get_nth_entry_id_exec, 
};
static void
__enode_set_float__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named floating point value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_set_float = {
  { (BseExportNode*) &__enode_get_nth_entry_id, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-float", 
    NULL,
    "/Methods/BseDataPocket/General/Set Float",
    NULL,
    __enode_set_float__fill_strings,
  },
  0, set_float_setup, set_float_exec, 
};
static void
__enode_set_int__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named integer value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_set_int = {
  { (BseExportNode*) &__enode_set_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-int", 
    NULL,
    "/Methods/BseDataPocket/General/Set Int",
    NULL,
    __enode_set_int__fill_strings,
  },
  0, set_int_setup, set_int_exec, 
};
static void
__enode_set_object__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named object reference in a data pocket entry. "
	   "Object references stored in a data pocket must exist within the "
	   "same project that the data pocket belongs to");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_set_object = {
  { (BseExportNode*) &__enode_set_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-object", 
    NULL,
    "/Methods/BseDataPocket/General/Set Object",
    NULL,
    __enode_set_object__fill_strings,
  },
  0, set_object_setup, set_object_exec, 
};
static void
__enode_set_string__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named string in a data pocket entry.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_set_string = {
  { (BseExportNode*) &__enode_set_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-string", 
    NULL,
    "/Methods/BseDataPocket/General/Set String",
    NULL,
    __enode_set_string__fill_strings,
  },
  0, set_string_setup, set_string_exec, 
};
static void
__enode_get_float__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set floating point value from a data pocket entry.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_float = {
  { (BseExportNode*) &__enode_set_string, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-float", 
    NULL,
    "/Methods/BseDataPocket/General/Get Float",
    NULL,
    __enode_get_float__fill_strings,
  },
  0, get_float_setup, get_float_exec, 
};
static void
__enode_get_int__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set integer value from a data pocket entry.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_int = {
  { (BseExportNode*) &__enode_get_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-int", 
    NULL,
    "/Methods/BseDataPocket/General/Get Int",
    NULL,
    __enode_get_int__fill_strings,
  },
  0, get_int_setup, get_int_exec, 
};
static void
__enode_get_object__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set object reference from a data pocket entry.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_object = {
  { (BseExportNode*) &__enode_get_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-object", 
    NULL,
    "/Methods/BseDataPocket/General/Get Object",
    NULL,
    __enode_get_object__fill_strings,
  },
  0, get_object_setup, get_object_exec, 
};
static void
__enode_get_string__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set string from a data pocket entry.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_string = {
  { (BseExportNode*) &__enode_get_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-string", 
    NULL,
    "/Methods/BseDataPocket/General/Get String",
    NULL,
    __enode_get_string__fill_strings,
  },
  0, get_string_setup, get_string_exec, 
};
BseExportNode* bse__builtin_init_bsedatapocket_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsedatapocket_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_get_string;
}

/**
 ** Generated data ends here
 **/
