
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsesource.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bsesource.h>
#include <bse/bseundostack.h>
#include <bse/bseieee754.h>
#include <bse/bsemidievent.h>


#line 29 "bsesource.proc"

/* --- set-input-by-id --- */
static void
set_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsesource.proc"
 {
#line 32 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 44 "bsesource.proc"
 }
static BseErrorType
#line 44 "bsesource.proc"
set_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 47 "bsesource.proc"
{
#line 48 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error;
  
#line 55 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 60 "bsesource.proc"
  
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);

#line 65 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- set-input --- */
static void
set_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 71 "bsesource.proc"
 {
#line 73 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("imodule", "Input Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 85 "bsesource.proc"
 }
static BseErrorType
#line 85 "bsesource.proc"
set_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 88 "bsesource.proc"
{
#line 89 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error;
  
#line 97 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      BSE_ITEM (isource)->parent != BSE_ITEM (osource)->parent ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 103 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_set_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    bse_item_push_undo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
  
#line 110 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input-by-id --- */
static void
unset_input_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 116 "bsesource.proc"
 {
#line 118 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 130 "bsesource.proc"
 }
static BseErrorType
#line 130 "bsesource.proc"
unset_input_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 133 "bsesource.proc"
{
#line 134 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  guint ichannel     = sfi_value_get_int (in_values++);
  BseSource *osource = bse_value_get_object (in_values++);
  guint ochannel     = sfi_value_get_int (in_values++);
  BseErrorType error = BSE_ERROR_NONE;
  
#line 141 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 145 "bsesource.proc"
  
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }

#line 156 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- unset-input --- */
static void
unset_input_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 162 "bsesource.proc"
 {
#line 164 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("omodule", "Output Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("output-channel", "Output Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
}
#line 176 "bsesource.proc"
 }
static BseErrorType
#line 176 "bsesource.proc"
unset_input_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 179 "bsesource.proc"
{
#line 180 "bsesource.proc"
  
  BseSource *isource   = bse_value_get_object (in_values++);
  gchar *ichannel_ident = sfi_value_get_string (in_values++);
  BseSource *osource   = bse_value_get_object (in_values++);
  gchar *ochannel_ident = sfi_value_get_string (in_values++);
  guint ichannel, ochannel;
  BseErrorType error = BSE_ERROR_NONE;
  
#line 188 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource) || !BSE_IS_SOURCE (osource) ||
      !ichannel_ident || !ochannel_ident)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 193 "bsesource.proc"
  
  ichannel = bse_source_find_ichannel (isource, ichannel_ident);
  ochannel = bse_source_find_ochannel (osource, ochannel_ident);
  error = bse_source_check_input (isource, ichannel, osource, ochannel);
  if (error == BSE_ERROR_NONE)
    {
      BseUndoStack *ustack = bse_item_undo_open (isource, "unset-input-by-id");
      bse_source_input_backup_to_undo (isource, ichannel, osource, ochannel);
      bse_item_push_redo_proc (isource, "unset-input-by-id", ichannel, osource, ochannel);
      bse_item_undo_close (ustack);
      error = bse_source_unset_input (isource, ichannel, osource, ochannel);
    }
  
#line 206 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- clear-inputs --- */
static void
clear_inputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 212 "bsesource.proc"
 {
#line 214 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 217 "bsesource.proc"
 }
static BseErrorType
#line 217 "bsesource.proc"
clear_inputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 220 "bsesource.proc"
{
#line 221 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 225 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 229 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-inputs %s", bse_object_debug_name (isource));
  bse_source_backup_ichannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-inputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ichannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- clear-outputs --- */
static void
clear_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 239 "bsesource.proc"
 {
#line 241 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 244 "bsesource.proc"
 }
static BseErrorType
#line 244 "bsesource.proc"
clear_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 247 "bsesource.proc"
{
#line 248 "bsesource.proc"
  
  BseSource *isource = bse_value_get_object (in_values++);
  BseUndoStack *ustack;

#line 252 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (isource))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 256 "bsesource.proc"
  
  ustack = bse_item_undo_open (isource, "clear-outputs %s", bse_object_debug_name (isource));
  bse_source_backup_ochannels_to_undo (isource);
  bse_item_push_redo_proc (isource, "clear-outputs");
  bse_item_undo_close (ustack);
  bse_source_clear_ochannels (isource);
  
  return BSE_ERROR_NONE;
}

/* --- has-output --- */
static void
has_output_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 266 "bsesource.proc"
 {
#line 268 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", NULL, NULL, BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("ochannel", NULL, NULL, 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
}
#line 272 "bsesource.proc"
 }
static BseErrorType
#line 272 "bsesource.proc"
has_output_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 275 "bsesource.proc"
{
#line 276 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 280 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 284 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, bse_source_has_output (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- has-outputs --- */
static void
has_outputs_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 290 "bsesource.proc"
 {
#line 292 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("has_outputs", "Has Outputs", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 297 "bsesource.proc"
 }
static BseErrorType
#line 297 "bsesource.proc"
has_outputs_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 300 "bsesource.proc"
{
#line 301 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 304 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 308 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, source->outputs != NULL);
  
  return BSE_ERROR_NONE;
}

/* --- n-ichannels --- */
static void
n_ichannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 314 "bsesource.proc"
 {
#line 316 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 321 "bsesource.proc"
 }
static BseErrorType
#line 321 "bsesource.proc"
n_ichannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 324 "bsesource.proc"
{
#line 325 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 328 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 332 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_ICHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-label --- */
static void
ichannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 338 "bsesource.proc"
 {
#line 340 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 347 "bsesource.proc"
 }
static BseErrorType
#line 347 "bsesource.proc"
ichannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 350 "bsesource.proc"
{
#line 351 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 355 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 359 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_LABEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-ident --- */
static void
ichannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 365 "bsesource.proc"
 {
#line 367 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 374 "bsesource.proc"
 }
static BseErrorType
#line 374 "bsesource.proc"
ichannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 377 "bsesource.proc"
{
#line 378 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 382 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 386 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_IDENT (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-blurb --- */
static void
ichannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 392 "bsesource.proc"
 {
#line 394 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 401 "bsesource.proc"
 }
static BseErrorType
#line 401 "bsesource.proc"
ichannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 404 "bsesource.proc"
{
#line 405 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 409 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 413 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_ICHANNEL_BLURB (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel-by-id --- */
static void
is_joint_ichannel_by_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 419 "bsesource.proc"
 {
#line 421 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 428 "bsesource.proc"
 }
static BseErrorType
#line 428 "bsesource.proc"
is_joint_ichannel_by_id_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 431 "bsesource.proc"
{
#line 432 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  
#line 436 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 440 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel));
  
  return BSE_ERROR_NONE;
}

/* --- is-joint-ichannel --- */
static void
is_joint_ichannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 446 "bsesource.proc"
 {
#line 448 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("input-channel", "Input Channel", NULL,
			    NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_jchannel", "Is Joint Channel", NULL,
			  FALSE, SFI_PARAM_STANDARD);
}
#line 455 "bsesource.proc"
 }
static BseErrorType
#line 455 "bsesource.proc"
is_joint_ichannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 458 "bsesource.proc"
{
#line 459 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  gchar *ichannel   = sfi_value_get_string (in_values++);
  guint id;
  
#line 464 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !ichannel)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 468 "bsesource.proc"
  
  id = bse_source_find_ichannel (source, ichannel);
  sfi_value_set_bool (out_values++,
		      id < BSE_SOURCE_N_ICHANNELS (source) ? BSE_SOURCE_IS_JOINT_ICHANNEL (source, id) : FALSE);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-n-joints --- */
static void
ichannel_get_n_joints_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 476 "bsesource.proc"
 {
#line 478 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_joints", "Number of Connections", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 485 "bsesource.proc"
 }
static BseErrorType
#line 485 "bsesource.proc"
ichannel_get_n_joints_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 488 "bsesource.proc"
{
#line 489 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 494 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 498 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel))
    sfi_value_set_int (out_values++, input->jdata.n_joints);
  else
    sfi_value_set_int (out_values++, input->idata.osource ? 1 : 0);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-osource --- */
static void
ichannel_get_osource_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 508 "bsesource.proc"
 {
#line 510 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("osource", "Output Source", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
}
#line 519 "bsesource.proc"
 }
static BseErrorType
#line 519 "bsesource.proc"
ichannel_get_osource_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 522 "bsesource.proc"
{
#line 523 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 529 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 533 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    bse_value_set_object (out_values++, input->jdata.joints[joint].osource);
  else if (joint < 1)
    bse_value_set_object (out_values++, input->idata.osource);
  else
    bse_value_set_object (out_values++, NULL);
  
  return BSE_ERROR_NONE;
}

/* --- ichannel-get-ochannel --- */
static void
ichannel_get_ochannel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 545 "bsesource.proc"
 {
#line 547 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("input-joint", "Input Joint", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("ochannel", "Output Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 556 "bsesource.proc"
 }
static BseErrorType
#line 556 "bsesource.proc"
ichannel_get_ochannel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 559 "bsesource.proc"
{
#line 560 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ichannel    = sfi_value_get_int (in_values++);
  guint joint       = sfi_value_get_int (in_values++);
  BseSourceInput *input;
  
#line 566 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ichannel >= BSE_SOURCE_N_ICHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 570 "bsesource.proc"
  
  input = BSE_SOURCE_INPUT (source, ichannel);
  if (BSE_SOURCE_IS_JOINT_ICHANNEL (source, ichannel) && joint < input->jdata.n_joints)
    sfi_value_set_int (out_values++, input->jdata.joints[joint].ochannel);
  else if (joint < 1)
    sfi_value_set_int (out_values++, input->idata.ochannel);
  else
    sfi_value_set_int (out_values++, G_MAXINT);
  
  return BSE_ERROR_NONE;
}

/* --- n-ochannels --- */
static void
n_ochannels_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 582 "bsesource.proc"
 {
#line 584 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("n_channels", "Number of Channels", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
}
#line 589 "bsesource.proc"
 }
static BseErrorType
#line 589 "bsesource.proc"
n_ochannels_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 592 "bsesource.proc"
{
#line 593 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  
#line 596 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 600 "bsesource.proc"
  
  sfi_value_set_int (out_values++, BSE_SOURCE_N_OCHANNELS (source));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-label --- */
static void
ochannel_label_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 606 "bsesource.proc"
 {
#line 608 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_label", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 615 "bsesource.proc"
 }
static BseErrorType
#line 615 "bsesource.proc"
ochannel_label_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 618 "bsesource.proc"
{
#line 619 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 623 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 627 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_LABEL (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-ident --- */
static void
ochannel_ident_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 633 "bsesource.proc"
 {
#line 635 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_ident", "Channel Name", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 642 "bsesource.proc"
 }
static BseErrorType
#line 642 "bsesource.proc"
ochannel_ident_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 645 "bsesource.proc"
{
#line 646 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 650 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 654 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_IDENT (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- ochannel-blurb --- */
static void
ochannel_blurb_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 660 "bsesource.proc"
 {
#line 662 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("output-channel", "Input Channel", NULL,
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("channel_blurb", "Channel Blurb", NULL,
			    NULL, SFI_PARAM_STANDARD);
}
#line 669 "bsesource.proc"
 }
static BseErrorType
#line 669 "bsesource.proc"
ochannel_blurb_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 672 "bsesource.proc"
{
#line 673 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  guint ochannel    = sfi_value_get_int (in_values++);
  
#line 677 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || ochannel >= BSE_SOURCE_N_OCHANNELS (source))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 681 "bsesource.proc"
  
  sfi_value_set_string (out_values++, BSE_SOURCE_OCHANNEL_BLURB (source, ochannel));
  
  return BSE_ERROR_NONE;
}

/* --- set-pos --- */
static void
set_pos_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 687 "bsesource.proc"
 {
#line 694 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("module", "Module", NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("x-pos", "X Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("y-pos", "Y Position", NULL,
                          0, -SFI_MAXREAL, SFI_MAXREAL, 1, SFI_PARAM_STANDARD);
}
#line 701 "bsesource.proc"
 }
static BseErrorType
#line 701 "bsesource.proc"
set_pos_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 704 "bsesource.proc"
{
#line 705 "bsesource.proc"
  
  BseSource *source = bse_value_get_object (in_values++);
  SfiReal xpos      = sfi_value_get_real (in_values++);
  SfiReal ypos      = sfi_value_get_real (in_values++);
  SfiReal epsilon = 1e-5;

#line 711 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || BSE_DOUBLE_IS_NANINF (xpos) || BSE_DOUBLE_IS_NANINF (ypos))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 715 "bsesource.proc"
  
  if (fabs (xpos - source->pos_x) > epsilon ||
      fabs (ypos - source->pos_y) > epsilon)
    {
      BseUndoStack *ustack = bse_item_undo_open (source, "set-xy-pos");
      bse_item_set (source,
                    "pos_x", xpos,
                    "pos_y", ypos,
                    NULL);
      bse_item_undo_close (ustack);
    }

  return BSE_ERROR_NONE;
}

/* --- set-automation --- */
static void
set_automation_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 730 "bsesource.proc"
 {
#line 732 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("midi_channel", _("MIDI Channel"), _("The MIDI Channel from which automation events should be received, 0 designates the default MIDI channel"),
                         0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
  *(in_pspecs++)    = bse_param_spec_genum ("control_type", _("Control Type"), _("The type of control events used for automation"),
                                BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL, BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE, SFI_PARAM_STANDARD);
}
#line 742 "bsesource.proc"
 }
static BseErrorType
#line 742 "bsesource.proc"
set_automation_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 745 "bsesource.proc"
{
#line 746 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);
  guint      midi_channel = sfi_value_get_int (in_values++);
  guint      control_type = g_value_get_enum (in_values++);
  BseErrorType error = BSE_ERROR_NONE;

#line 753 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 757 "bsesource.proc"
  
  guint old_midi_channel = 0;
  guint old_control_type = 0;
  bse_source_get_automation_property (source, property, &old_midi_channel, &old_control_type);
  if (old_midi_channel != midi_channel || old_control_type != control_type)
    {
      error = bse_source_set_automation_property (source, property, midi_channel, control_type);
      if (error == BSE_ERROR_NONE)
        bse_item_push_undo_proc (source, "set-automation", property, old_midi_channel, old_control_type);
    }

#line 768 "bsesource.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- get-automation-channel --- */
static void
get_automation_channel_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 774 "bsesource.proc"
 {
#line 776 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("midi_channel", NULL, NULL, 0, 0, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD ":scale:unprepared");
}
#line 782 "bsesource.proc"
 }
static BseErrorType
#line 782 "bsesource.proc"
get_automation_channel_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 785 "bsesource.proc"
{
#line 786 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);

#line 790 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 794 "bsesource.proc"
  
  guint midi_channel = 0;
  bse_source_get_automation_property (source, property, &midi_channel, NULL);
#line 797 "bsesource.proc"
  
  g_value_set_int (out_values++, midi_channel);
  
  return BSE_ERROR_NONE;
}

/* --- get-automation-control --- */
static void
get_automation_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 803 "bsesource.proc"
 {
#line 805 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("property_name", NULL, "Item property name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("control_type", NULL, NULL, BSE_TYPE_MIDI_CONTROL_TYPE, BSE_MIDI_CONTROL_CONTINUOUS_16, SFI_PARAM_STANDARD);
}
#line 811 "bsesource.proc"
 }
static BseErrorType
#line 811 "bsesource.proc"
get_automation_control_exec (BseProcedureClass *proc,
      const GValue      *in_values,
      GValue            *out_values)
#line 814 "bsesource.proc"
{
#line 815 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);
  gchar     *property     = sfi_value_get_string (in_values++);

#line 819 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source) || !property)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 823 "bsesource.proc"
  
  guint control_type = 0;
  bse_source_get_automation_property (source, property, NULL, &control_type);
#line 826 "bsesource.proc"
  
  g_value_set_enum (out_values++, control_type);
  
  return BSE_ERROR_NONE;
}

/* --- is-prepared --- */
static void
is_prepared_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 832 "bsesource.proc"
 {
#line 834 "bsesource.proc"
  *(in_pspecs++) = bse_param_spec_object ("source", NULL, NULL,
				 BSE_TYPE_SOURCE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_prepared", NULL, NULL, FALSE, SFI_PARAM_STANDARD);
#line 837 "bsesource.proc"
}  }
static BseErrorType
#line 837 "bsesource.proc"
is_prepared_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 840 "bsesource.proc"
{
#line 841 "bsesource.proc"
  
  BseSource *source       = bse_value_get_object (in_values++);

#line 844 "bsesource.proc"
  
  if (!BSE_IS_SOURCE (source))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 848 "bsesource.proc"
  
  sfi_value_set_bool (out_values++, BSE_SOURCE_PREPARED (source));

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_set_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input_by_id = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Set Input By Id",
    NULL,
    __enode_set_input_by_id__fill_strings,
  },
  0, set_input_by_id_setup, set_input_by_id_exec, 
};
static void
__enode_set_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Connect a module input to another module's output.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_input = {
  { (BseExportNode*) &__enode_set_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+set-input", 
    NULL,
    "/Methods/BseSource/General/Set Input",
    NULL,
    __enode_set_input__fill_strings,
  },
  0, set_input_setup, set_input_exec, 
};
static void
__enode_unset_input_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input_by_id = {
  { (BseExportNode*) &__enode_set_input, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input-by-id", 
    NULL,
    "/Methods/BseSource/General/Unset Input By Id",
    NULL,
    __enode_unset_input_by_id__fill_strings,
  },
  0, unset_input_by_id_setup, unset_input_by_id_exec, 
};
static void
__enode_unset_input__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect a module input.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_unset_input = {
  { (BseExportNode*) &__enode_unset_input_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+unset-input", 
    NULL,
    "/Methods/BseSource/General/Unset Input",
    NULL,
    __enode_unset_input__fill_strings,
  },
  0, unset_input_setup, unset_input_exec, 
};
static void
__enode_clear_inputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module inputs.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_inputs = {
  { (BseExportNode*) &__enode_unset_input, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-inputs", 
    NULL,
    "/Methods/BseSource/General/Clear Inputs",
    NULL,
    __enode_clear_inputs__fill_strings,
  },
  0, clear_inputs_setup, clear_inputs_exec, 
};
static void
__enode_clear_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Disconnect all module outputs.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_clear_outputs = {
  { (BseExportNode*) &__enode_clear_inputs, BSE_EXPORT_NODE_PROC,
    "BseSource+clear-outputs", 
    NULL,
    "/Methods/BseSource/General/Clear Outputs",
    NULL,
    __enode_clear_outputs__fill_strings,
  },
  0, clear_outputs_setup, clear_outputs_exec, 
};
static void
__enode_has_output__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module's output channel is connected.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_output = {
  { (BseExportNode*) &__enode_clear_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+has-output", 
    NULL,
    "/Methods/BseSource/General/Has Output",
    NULL,
    __enode_has_output__fill_strings,
  },
  0, has_output_setup, has_output_exec, 
};
static void
__enode_has_outputs__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a module has output channel connections.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_has_outputs = {
  { (BseExportNode*) &__enode_has_output, BSE_EXPORT_NODE_PROC,
    "BseSource+has-outputs", 
    NULL,
    "/Methods/BseSource/General/Has Outputs",
    NULL,
    __enode_has_outputs__fill_strings,
  },
  0, has_outputs_setup, has_outputs_exec, 
};
static void
__enode_n_ichannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of input channels of a module.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ichannels = {
  { (BseExportNode*) &__enode_has_outputs, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ichannels", 
    NULL,
    "/Methods/BseSource/General/N Ichannels",
    NULL,
    __enode_n_ichannels__fill_strings,
  },
  0, n_ichannels_setup, n_ichannels_exec, 
};
static void
__enode_ichannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel name.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_label = {
  { (BseExportNode*) &__enode_n_ichannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-label", 
    NULL,
    "/Methods/BseSource/General/Ichannel Label",
    NULL,
    __enode_ichannel_label__fill_strings,
  },
  0, ichannel_label_setup, ichannel_label_exec, 
};
static void
__enode_ichannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical input channel name.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_ident = {
  { (BseExportNode*) &__enode_ichannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ichannel Ident",
    NULL,
    __enode_ichannel_ident__fill_strings,
  },
  0, ichannel_ident_setup, ichannel_ident_exec, 
};
static void
__enode_ichannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get input channel description.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_blurb = {
  { (BseExportNode*) &__enode_ichannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ichannel Blurb",
    NULL,
    __enode_ichannel_blurb__fill_strings,
  },
  0, ichannel_blurb_setup, ichannel_blurb_exec, 
};
static void
__enode_is_joint_ichannel_by_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel_by_id = {
  { (BseExportNode*) &__enode_ichannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel-by-id", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel By Id",
    NULL,
    __enode_is_joint_ichannel_by_id__fill_strings,
  },
  0, is_joint_ichannel_by_id_setup, is_joint_ichannel_by_id_exec, 
};
static void
__enode_is_joint_ichannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check if an input channel is a joint (multi-connect) channel.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_joint_ichannel = {
  { (BseExportNode*) &__enode_is_joint_ichannel_by_id, BSE_EXPORT_NODE_PROC,
    "BseSource+is-joint-ichannel", 
    NULL,
    "/Methods/BseSource/General/Is Joint Ichannel",
    NULL,
    __enode_is_joint_ichannel__fill_strings,
  },
  0, is_joint_ichannel_setup, is_joint_ichannel_exec, 
};
static void
__enode_ichannel_get_n_joints__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of inputs connected to an input channel.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_n_joints = {
  { (BseExportNode*) &__enode_is_joint_ichannel, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-n-joints", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get N Joints",
    NULL,
    __enode_ichannel_get_n_joints__fill_strings,
  },
  0, ichannel_get_n_joints_setup, ichannel_get_n_joints_exec, 
};
static void
__enode_ichannel_get_osource__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output module connected to a specific joint of an input channel";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_osource = {
  { (BseExportNode*) &__enode_ichannel_get_n_joints, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-osource", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Osource",
    NULL,
    __enode_ichannel_get_osource__fill_strings,
  },
  0, ichannel_get_osource_setup, ichannel_get_osource_exec, 
};
static void
__enode_ichannel_get_ochannel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve output channel of the module connected to a specific joint of an input channel.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ichannel_get_ochannel = {
  { (BseExportNode*) &__enode_ichannel_get_osource, BSE_EXPORT_NODE_PROC,
    "BseSource+ichannel-get-ochannel", 
    NULL,
    "/Methods/BseSource/General/Ichannel Get Ochannel",
    NULL,
    __enode_ichannel_get_ochannel__fill_strings,
  },
  0, ichannel_get_ochannel_setup, ichannel_get_ochannel_exec, 
};
static void
__enode_n_ochannels__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get the number of output channels of a module.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_n_ochannels = {
  { (BseExportNode*) &__enode_ichannel_get_ochannel, BSE_EXPORT_NODE_PROC,
    "BseSource+n-ochannels", 
    NULL,
    "/Methods/BseSource/General/N Ochannels",
    NULL,
    __enode_n_ochannels__fill_strings,
  },
  0, n_ochannels_setup, n_ochannels_exec, 
};
static void
__enode_ochannel_label__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel name.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_label = {
  { (BseExportNode*) &__enode_n_ochannels, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-label", 
    NULL,
    "/Methods/BseSource/General/Ochannel Label",
    NULL,
    __enode_ochannel_label__fill_strings,
  },
  0, ochannel_label_setup, ochannel_label_exec, 
};
static void
__enode_ochannel_ident__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get canonical output channel name.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_ident = {
  { (BseExportNode*) &__enode_ochannel_label, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-ident", 
    NULL,
    "/Methods/BseSource/General/Ochannel Ident",
    NULL,
    __enode_ochannel_ident__fill_strings,
  },
  0, ochannel_ident_setup, ochannel_ident_exec, 
};
static void
__enode_ochannel_blurb__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get output channel description.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_ochannel_blurb = {
  { (BseExportNode*) &__enode_ochannel_ident, BSE_EXPORT_NODE_PROC,
    "BseSource+ochannel-blurb", 
    NULL,
    "/Methods/BseSource/General/Ochannel Blurb",
    NULL,
    __enode_ochannel_blurb__fill_strings,
  },
  0, ochannel_blurb_setup, ochannel_blurb_exec, 
};
static void
__enode_set_pos__fill_strings (BseExportStrings *es)
{
  es->blurb = "Set the x and y position of a module. In contrast to setting the position "
          "through ordinary object property setters, this function will not update "
          "the module position if the passed in arguments are sufficiently equal to "
          "the values already set on the object. As such, it does not record an extra "
          "undo step for setting properties to values they already have and if necessary "
          "turns setting of x and y positions into an atomic undo operation.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_pos = {
  { (BseExportNode*) &__enode_ochannel_blurb, BSE_EXPORT_NODE_PROC,
    "BseSource+set-pos", 
    NULL,
    "/Methods/BseSource/General/Set Pos",
    NULL,
    __enode_set_pos__fill_strings,
  },
  0, set_pos_setup, set_pos_exec, 
};
static void
__enode_set_automation__fill_strings (BseExportStrings *es)
{
  es->blurb = "Setup automation parameters for a property.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_automation = {
  { (BseExportNode*) &__enode_set_pos, BSE_EXPORT_NODE_PROC,
    "BseSource+set-automation", 
    NULL,
    "/Methods/BseSource/General/Set Automation",
    NULL,
    __enode_set_automation__fill_strings,
  },
  0, set_automation_setup, set_automation_exec, 
};
static void
__enode_get_automation_channel__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get MIDI channel from an automation property.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_channel = {
  { (BseExportNode*) &__enode_set_automation, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-channel", 
    NULL,
    "/Methods/BseSource/General/Get Automation Channel",
    NULL,
    __enode_get_automation_channel__fill_strings,
  },
  0, get_automation_channel_setup, get_automation_channel_exec, 
};
static void
__enode_get_automation_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Get control type from an automation property.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_automation_control = {
  { (BseExportNode*) &__enode_get_automation_channel, BSE_EXPORT_NODE_PROC,
    "BseSource+get-automation-control", 
    NULL,
    "/Methods/BseSource/General/Get Automation Control",
    NULL,
    __enode_get_automation_control__fill_strings,
  },
  0, get_automation_control_setup, get_automation_control_exec, 
};
static void
__enode_is_prepared__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a source is prepared for synthesis processing.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_is_prepared = {
  { (BseExportNode*) &__enode_get_automation_control, BSE_EXPORT_NODE_PROC,
    "BseSource+is-prepared", 
    NULL,
    "/Methods/BseSource/General/Is Prepared",
    NULL,
    __enode_is_prepared__fill_strings,
  },
  0, is_prepared_setup, is_prepared_exec, 
};
BseExportNode* bse__builtin_init_bsesource_gen_proc_c (void);
BseExportNode* bse__builtin_init_bsesource_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_is_prepared;
}

/*
 * Generated data ends here
 */
