/*  XMMS - Cross-platform multimedia player
 *  Copyright (C) 1998-2001  Peter Alm, Mikael Alm, Olle Hallnas,
 *                           Thomas Nilsson and 4Front Technologies
 *  Copyright (C) 1999-2001  Haavard Kvaalen
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef SKIN_H
#define SKIN_H

#include <gdk/gdk.h>

typedef enum {
    SKIN_MAIN = 0, SKIN_CBUTTONS, SKIN_TITLEBAR, SKIN_SHUFREP, SKIN_TEXT,
    SKIN_VOLUME,
    SKIN_BALANCE, SKIN_MONOSTEREO, SKIN_PLAYPAUSE, SKIN_NUMBERS,
    SKIN_POSBAR,
    SKIN_PLEDIT, SKIN_EQMAIN, SKIN_EQ_EX, SKIN_PMID_LAST
} SkinIndex;

typedef enum {
    SKIN_MASK_MAIN = 0,
    SKIN_MASK_EQ,
    SKIN_MASK_SHADE,
    SKIN_MASK_EQ_SHADE,
    SKIN_MID_LAST
} MaskIndex;

typedef enum {
    SKIN_PLEDIT_NORMAL, SKIN_PLEDIT_CURRENT, SKIN_PLEDIT_NORMALBG,
    SKIN_PLEDIT_SELECTEDBG, SKIN_TEXTBG, SKIN_TEXTFG, SKIN_COLORID_LAST
} SkinColorIndex;

typedef struct {
    GdkPixmap *pixmap;		/*, *def_pixmap; */
    /* The real size of the pixmap */
    gint width, height;
    /* The size of the pixmap from the current skin,
       which might be smaller */
    gint current_width, current_height;
} SkinPixmap;


typedef struct {
    GMutex *lock;
    gchar *path;
    gchar *def_path;
    SkinPixmap pixmaps[SKIN_PMID_LAST];
    GdkColor textbg[6], def_textbg[6];
    GdkColor textfg[6], def_textfg[6];
    GdkColor *colors[SKIN_COLORID_LAST];
    guchar vis_color[24][3];
    GdkBitmap *masks[SKIN_MID_LAST];
    GdkBitmap *ds_masks[SKIN_MID_LAST];
} Skin;

extern Skin *skin;

void init_skins(const gchar *);
void load_skin(const gchar * path);
void reload_skin(void);
void cleanup_skins(void);
GdkBitmap *skin_get_mask(MaskIndex mi, gboolean doublesize,
			 gboolean shaded);
GdkColor *get_skin_color(SkinColorIndex si);
void get_skin_viscolor(guchar vis_color[24][3]);
int skin_get_id(void);
void skin_draw_pixmap(GdkDrawable * drawable, GdkGC * gc, SkinIndex si,
		      gint xsrc, gint ysrc, gint xdest, gint ydest,
		      gint width, gint height);
void skin_get_eq_spline_colors(guint32(*colors)[19]);
void skin_install_skin(const gchar * path);
#endif
