
dnl BEEP_FUNC_POSIX(FUNCTION... [, ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]])
dnl Test for functions in posix libraries, and define POSIX_LIBS

AC_DEFUN(BEEP_FUNC_POSIX,
[   beep_posix4=no
    beep_rt=no

    for beep_func in $1 ; do
	beep_have_func=no
        AC_CHECK_FUNC($beep_func,beep_have_func=yes,[
            dnl try in libposix4 if not found in current LIBS
            AC_CHECK_LIB(posix4,$beep_func,[beep_have_func=yes beep_posix4=yes],[
                dnl try in librt, if not found so far
                AC_CHECK_LIB(rt,$beep_func,[beep_have_func=yes beep_rt=yes])
            ])
        ])
        if test $beep_have_func = yes; then
            changequote(, )
            beep_tr_func=HAVE_`echo $beep_func | tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`
            changequote([, ])
            AC_DEFINE_UNQUOTED($beep_tr_func)
            ifelse([$2], , :, [$2])
        else
            ifelse([$3], , :, [$3])
        fi
    done

    POSIX_LIBS=
    if test $beep_posix4 = yes; then
        POSIX_LIBS=-lposix4
    fi
    if test $beep_rt = yes; then
        POSIX_LIBS="$POSIX_LIBS -lrt"
    fi
    AC_SUBST(POSIX_LIBS)
])
