/*
 * pkcs11 low level testing
 *
 * Copyright (C) 2002  Zetes
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include "pkcs11-lowlevel.h"

int c_FindObjectsFinal()
{
	int errors = 0;
	CK_SESSION_HANDLE session;
	CK_OBJECT_CLASS cls = CKO_PUBLIC_KEY;
	CK_ATTRIBUTE attrib = {CKA_CLASS, &cls, sizeof(CK_OBJECT_CLASS)};
	CK_OBJECT_HANDLE objects[3];
	CK_ULONG count, total;
	CK_RV rv;

	printf("C_FindObjectsFinal\n");

	if (p11->C_Initialize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Initialize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}

	if (p11->C_FindObjectsFinal(12345) != CKR_SESSION_HANDLE_INVALID) {
		printf("    ERR: C_FindObjectsFinal(1) didn't return CKR_SESSION_HANDLE_INVALID\n");
		errors++;
	}

	session = getSessionInFirstSlot();

	if (rv = (p11->C_FindObjectsInit(session, NULL_PTR, 0) != CKR_OK)) {
		printf("    ERR: C_FindObjectsInit(2) didn't return CKR_OK but %s\n", CKR2Str(rv));
		errors++;
	}
	if (p11->C_FindObjects(session, objects, 1, &count) != CKR_OK) {
		printf("    ERR: C_FindObjects(2) didn't return CKR_OK\n");
		errors++;
	}
	if (p11->C_FindObjectsFinal(session) != CKR_OK) {
		printf("    ERR: C_FindObjectsFinal(2) didn't return CKR_OK\n");
		errors++;
	}

	if (p11->C_Finalize(NULL_PTR) != CKR_OK) {
		printf("    ERR: C_Finalize(NULL_PTR) didn't return CKR_OK\n");
		return ++errors;
	}
	if (p11->C_FindObjectsFinal(session) != CKR_CRYPTOKI_NOT_INITIALIZED) {
		printf("    ERR: C_FindObjectsFinal(3) didn't return CKR_CRYPTOKI_NOT_INITIALIZED\n");
		errors++;
	}

	return errors;
}
