/*
 * scgui.h: GUI Support for Belgium EID card
 *
 * Copyright (C) 2003, Zetes Belgium
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef SCGUI_H
#define SCGUI_H

/* if SCGUI_DLL not defined then used directly by opensc.dll */
#ifdef SCGUI_DLL

#ifdef SCGUI_EXPORTS
#define SCGUI_API __declspec(dllexport)
#else
#define SCGUI_API __declspec(dllimport)
#endif

#else
#define SCGUI_API
#endif

typedef enum {
	SCGUI_OK,
	SCGUI_CANCEL,
	SCGUI_ERROR,
	SCGUI_NOT_INITED,
	SCGUI_BUFFER_TOO_SMALL,
	SCGUI_BAD_PARAM
} scgui_ret_t;

typedef enum {
	SCGUI_NO_ICON,
	SCGUI_SIGN_ICON
} scgui_param_t;

SCGUI_API scgui_ret_t scgui_init(void);

/* pin : memory allocated should be 13 bytes !! (12 + '\0') */
/* len : without '\0' */
SCGUI_API scgui_ret_t scgui_enterpin(const char *title, const char *msg, char *pin, int *len, const char *btn_ok, const char *btn_cancel, const char *pinTooShort, scgui_param_t signIcon);

/* <old|new>pin : memory allocated should be 13 bytes !! (12 + '\0') */
/* <old|new>pinlen : without '\0' */
SCGUI_API scgui_ret_t scgui_changepin(const char *title, const char *msg, char *oldpin, int *oldpinlen, char *newpin, int *newpinlen, const char *btn_ok, const char *btn_cancel, const char *pinTooShort, const char *confirmPinError);

/* if btn_cancel == NULL : only btn_ok shown */
SCGUI_API scgui_ret_t scgui_ask_message(const char *title, const char *short_msg, const char *long_msg, const char *btn_ok, const char *btn_cancel, const char *pinpad_reader);

/* modeless */
SCGUI_API scgui_ret_t scgui_display_message(const char *title, const char *short_msg, const char *long_msg, const char *btn_close, void **handle, scgui_param_t signIcon, const char *pinpad_reader);
SCGUI_API scgui_ret_t scgui_remove_message(void *handle);

#endif
