#ifndef __MASTERMANAGER__ 
#define __MASTERMANAGER__ 
 
#include "../../Include/Base/platform.h" 
 
#include "../../Include/Base/Object.h" 
 
class CManager; 
class CStringToObjectCollection; 
 
class CMasterManager : public CObject 
{ 
	public: 
 
		static CMasterManager* Instance(); 
 
		virtual ~CMasterManager(); 
 
		// Register managers 
		void RegisterManager (CManager* aManager); 
 
		// Get a manager 
		CManager* GetManager (char *managerName); 
 
		// Dump object description 
		void CreateDescription(void); 
 
        void RemoveAll();

	protected: 
 
		CMasterManager(); 
 
	private: 
 
		CStringToObjectCollection *managerCollection; 
 
		static CMasterManager* m_instance; 
}; 
 
#endif //__MASTERMANAGER__

